// content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-params-data.h"
namespace auction_worklet {
namespace mojom {

NOINLINE static const char* BaseValueToStringHelper(BaseValue value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BaseValue::kWinningBid:
      return "kWinningBid";
    case BaseValue::kHighestScoringOtherBid:
      return "kHighestScoringOtherBid";
    case BaseValue::kScriptRunTime:
      return "kScriptRunTime";
    case BaseValue::kSignalsFetchTime:
      return "kSignalsFetchTime";
    case BaseValue::kBidRejectReason:
      return "kBidRejectReason";
    case BaseValue::kParticipatingInterestGroupCount:
      return "kParticipatingInterestGroupCount";
    case BaseValue::kAverageCodeFetchTime:
      return "kAverageCodeFetchTime";
    case BaseValue::kPercentScriptsTimeout:
      return "kPercentScriptsTimeout";
    case BaseValue::kPercentInterestGroupsCumulativeTimeout:
      return "kPercentInterestGroupsCumulativeTimeout";
    case BaseValue::kCumulativeBuyerTime:
      return "kCumulativeBuyerTime";
    case BaseValue::kRegularInterestGroupsUsed:
      return "kRegularInterestGroupsUsed";
    case BaseValue::kPercentRegularInterestGroupQuotaUsed:
      return "kPercentRegularInterestGroupQuotaUsed";
    case BaseValue::kNegativeInterestGroupsUsed:
      return "kNegativeInterestGroupsUsed";
    case BaseValue::kPercentNegativeInterestGroupQuotaUsed:
      return "kPercentNegativeInterestGroupQuotaUsed";
    case BaseValue::kInterestGroupStorageUsed:
      return "kInterestGroupStorageUsed";
    case BaseValue::kPercentInterestGroupStorageQuotaUsed:
      return "kPercentInterestGroupStorageQuotaUsed";
    default:
      return nullptr;
  }
}

std::string BaseValueToString(BaseValue value) {
  const char *str = BaseValueToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BaseValue value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BaseValue value) {
  return os << BaseValueToString(value);
}

NOINLINE static const char* ReservedEventTypeToStringHelper(ReservedEventType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ReservedEventType::kReservedAlways:
      return "kReservedAlways";
    case ReservedEventType::kReservedWin:
      return "kReservedWin";
    case ReservedEventType::kReservedLoss:
      return "kReservedLoss";
    case ReservedEventType::kReservedOnce:
      return "kReservedOnce";
    default:
      return nullptr;
  }
}

std::string ReservedEventTypeToString(ReservedEventType value) {
  const char *str = ReservedEventTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ReservedEventType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ReservedEventType value) {
  return os << ReservedEventTypeToString(value);
}

namespace internal {
// static
bool ForEventSignalBucket_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ForEventSignalBucket_Data* object = static_cast<const ForEventSignalBucket_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ForEventSignalBucket_Tag::kIdBucket: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_id_bucket, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_id_bucket, validation_context))
        return false;
      return true;
    }
    case ForEventSignalBucket_Tag::kSignalBucket: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_signal_bucket, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_signal_bucket, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ForEventSignalBucket");
      return false;
    }
  }
}
// static
bool ForEventSignalValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ForEventSignalValue_Data* object = static_cast<const ForEventSignalValue_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ForEventSignalValue_Tag::kIntValue: {

      return true;
    }
    case ForEventSignalValue_Tag::kSignalValue: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_signal_value, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_signal_value, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ForEventSignalValue");
      return false;
    }
  }
}
// static
bool EventType_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const EventType_Data* object = static_cast<const EventType_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case EventType_Tag::kReserved: {


      if (!::auction_worklet::mojom::internal::ReservedEventType_Data
            ::Validate(object->data.f_reserved, validation_context))
        return false;
      return true;
    }
    case EventType_Tag::kNonReserved: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_non_reserved, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& non_reserved_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_non_reserved, validation_context,
                                             &non_reserved_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in EventType");
      return false;
    }
  }
}
// static
bool AggregatableReportContribution_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const AggregatableReportContribution_Data* object = static_cast<const AggregatableReportContribution_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case AggregatableReportContribution_Tag::kHistogramContribution: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_histogram_contribution, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_histogram_contribution, validation_context))
        return false;
      return true;
    }
    case AggregatableReportContribution_Tag::kForEventContribution: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_for_event_contribution, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_for_event_contribution, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in AggregatableReportContribution");
      return false;
    }
  }
}


// static
bool BucketOffset_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BucketOffset_Data* object =
      static_cast<const BucketOffset_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

BucketOffset_Data::BucketOffset_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SignalBucket_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SignalBucket_Data* object =
      static_cast<const SignalBucket_Data*>(data);


  if (!::auction_worklet::mojom::internal::BaseValue_Data
        ::Validate(object->base_value, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->offset, validation_context))
    return false;

  return true;
}

SignalBucket_Data::SignalBucket_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SignalValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SignalValue_Data* object =
      static_cast<const SignalValue_Data*>(data);


  if (!::auction_worklet::mojom::internal::BaseValue_Data
        ::Validate(object->base_value, validation_context))
    return false;

  return true;
}

SignalValue_Data::SignalValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AggregatableReportForEventContribution_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AggregatableReportForEventContribution_Data* object =
      static_cast<const AggregatableReportForEventContribution_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->bucket, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->bucket, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->value, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->event_type, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->event_type, validation_context))
    return false;

  return true;
}

AggregatableReportForEventContribution_Data::AggregatableReportForEventContribution_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrivateAggregationRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrivateAggregationRequest_Data* object =
      static_cast<const PrivateAggregationRequest_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->contribution, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->contribution, validation_context))
    return false;


  if (!::blink::mojom::internal::AggregationServiceMode_Data
        ::Validate(object->aggregation_mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->debug_mode_details, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->debug_mode_details, validation_context))
    return false;

  return true;
}

PrivateAggregationRequest_Data::PrivateAggregationRequest_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace auction_worklet

namespace perfetto {

// static
void TraceFormatTraits<::auction_worklet::mojom::BaseValue>::WriteIntoTrace(
   perfetto::TracedValue context, ::auction_worklet::mojom::BaseValue value) {
  return std::move(context).WriteString(::auction_worklet::mojom::BaseValueToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::auction_worklet::mojom::ReservedEventType>::WriteIntoTrace(
   perfetto::TracedValue context, ::auction_worklet::mojom::ReservedEventType value) {
  return std::move(context).WriteString(::auction_worklet::mojom::ReservedEventTypeToString(value));
}

} // namespace perfetto