// third_party/blink/public/mojom/widget/visual_properties.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom-forward.h"
#include "cc/mojom/browser_controls_params.mojom.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom.h"
#include "third_party/blink/public/mojom/manifest/display_mode.mojom-forward.h"
#include "third_party/blink/public/mojom/widget/screen_info.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>




#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/public/common/widget/visual_properties_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {








class BLINK_COMMON_EXPORT VisualProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VisualProperties, T>::value>;
  using DataView = VisualPropertiesDataView;
  using Data_ = internal::VisualProperties_Data;

  template <typename... Args>
  static VisualPropertiesPtr New(Args&&... args) {
    return VisualPropertiesPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VisualPropertiesPtr From(const U& u) {
    return mojo::TypeConverter<VisualPropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VisualProperties>::Convert(*this);
  }


  VisualProperties();

  VisualProperties(
      const ::blink::ScreenInfo& screen_info,
      bool auto_resize_enabled,
      const ::gfx::Size& min_size_for_auto_resize,
      const ::gfx::Size& max_size_for_auto_resize,
      const ::gfx::Size& new_size,
      const ::gfx::Size& visible_viewport_size,
      const ::gfx::Rect& compositor_viewport_pixel_rect,
      const base::Optional<::cc::BrowserControlsParams>& browser_controls_params,
      bool scroll_focused_node_into_view,
      const base::Optional<::viz::LocalSurfaceId>& local_surface_id,
      bool is_fullscreen_granted,
      ::blink::mojom::DisplayMode display_mode,
      uint32_t capture_sequence_number,
      double zoom_level,
      float page_scale_factor,
      std::vector<::gfx::Rect> root_widget_window_segments,
      bool is_pinch_gesture_active);

  ~VisualProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VisualPropertiesPtr>
  VisualPropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VisualProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VisualProperties::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VisualProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VisualProperties_UnserializedMessageContext<
            UserType, VisualProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VisualProperties::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VisualProperties::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VisualProperties_UnserializedMessageContext<
            UserType, VisualProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VisualProperties::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::ScreenInfo screen_info;
  
  bool auto_resize_enabled;
  
  ::gfx::Size min_size_for_auto_resize;
  
  ::gfx::Size max_size_for_auto_resize;
  
  ::gfx::Size new_size;
  
  ::gfx::Size visible_viewport_size;
  
  ::gfx::Rect compositor_viewport_pixel_rect;
  
  base::Optional<::cc::BrowserControlsParams> browser_controls_params;
  
  bool scroll_focused_node_into_view;
  
  base::Optional<::viz::LocalSurfaceId> local_surface_id;
  
  bool is_fullscreen_granted;
  
  ::blink::mojom::DisplayMode display_mode;
  
  uint32_t capture_sequence_number;
  
  double zoom_level;
  
  float page_scale_factor;
  
  std::vector<::gfx::Rect> root_widget_window_segments;
  
  bool is_pinch_gesture_active;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VisualProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VisualProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VisualProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VisualProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
VisualPropertiesPtr VisualProperties::Clone() const {
  return New(
      mojo::Clone(screen_info),
      mojo::Clone(auto_resize_enabled),
      mojo::Clone(min_size_for_auto_resize),
      mojo::Clone(max_size_for_auto_resize),
      mojo::Clone(new_size),
      mojo::Clone(visible_viewport_size),
      mojo::Clone(compositor_viewport_pixel_rect),
      mojo::Clone(browser_controls_params),
      mojo::Clone(scroll_focused_node_into_view),
      mojo::Clone(local_surface_id),
      mojo::Clone(is_fullscreen_granted),
      mojo::Clone(display_mode),
      mojo::Clone(capture_sequence_number),
      mojo::Clone(zoom_level),
      mojo::Clone(page_scale_factor),
      mojo::Clone(root_widget_window_segments),
      mojo::Clone(is_pinch_gesture_active)
  );
}

template <typename T, VisualProperties::EnableIfSame<T>*>
bool VisualProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->screen_info, other_struct.screen_info))
    return false;
  if (!mojo::Equals(this->auto_resize_enabled, other_struct.auto_resize_enabled))
    return false;
  if (!mojo::Equals(this->min_size_for_auto_resize, other_struct.min_size_for_auto_resize))
    return false;
  if (!mojo::Equals(this->max_size_for_auto_resize, other_struct.max_size_for_auto_resize))
    return false;
  if (!mojo::Equals(this->new_size, other_struct.new_size))
    return false;
  if (!mojo::Equals(this->visible_viewport_size, other_struct.visible_viewport_size))
    return false;
  if (!mojo::Equals(this->compositor_viewport_pixel_rect, other_struct.compositor_viewport_pixel_rect))
    return false;
  if (!mojo::Equals(this->browser_controls_params, other_struct.browser_controls_params))
    return false;
  if (!mojo::Equals(this->scroll_focused_node_into_view, other_struct.scroll_focused_node_into_view))
    return false;
  if (!mojo::Equals(this->local_surface_id, other_struct.local_surface_id))
    return false;
  if (!mojo::Equals(this->is_fullscreen_granted, other_struct.is_fullscreen_granted))
    return false;
  if (!mojo::Equals(this->display_mode, other_struct.display_mode))
    return false;
  if (!mojo::Equals(this->capture_sequence_number, other_struct.capture_sequence_number))
    return false;
  if (!mojo::Equals(this->zoom_level, other_struct.zoom_level))
    return false;
  if (!mojo::Equals(this->page_scale_factor, other_struct.page_scale_factor))
    return false;
  if (!mojo::Equals(this->root_widget_window_segments, other_struct.root_widget_window_segments))
    return false;
  if (!mojo::Equals(this->is_pinch_gesture_active, other_struct.is_pinch_gesture_active))
    return false;
  return true;
}

template <typename T, VisualProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.screen_info, rhs.screen_info))
    return true;
  if (std::less<>{}(rhs.screen_info, lhs.screen_info))
    return false;
  if (std::less<>{}(lhs.auto_resize_enabled, rhs.auto_resize_enabled))
    return true;
  if (std::less<>{}(rhs.auto_resize_enabled, lhs.auto_resize_enabled))
    return false;
  if (std::less<>{}(lhs.min_size_for_auto_resize, rhs.min_size_for_auto_resize))
    return true;
  if (std::less<>{}(rhs.min_size_for_auto_resize, lhs.min_size_for_auto_resize))
    return false;
  if (std::less<>{}(lhs.max_size_for_auto_resize, rhs.max_size_for_auto_resize))
    return true;
  if (std::less<>{}(rhs.max_size_for_auto_resize, lhs.max_size_for_auto_resize))
    return false;
  if (std::less<>{}(lhs.new_size, rhs.new_size))
    return true;
  if (std::less<>{}(rhs.new_size, lhs.new_size))
    return false;
  if (std::less<>{}(lhs.visible_viewport_size, rhs.visible_viewport_size))
    return true;
  if (std::less<>{}(rhs.visible_viewport_size, lhs.visible_viewport_size))
    return false;
  if (std::less<>{}(lhs.compositor_viewport_pixel_rect, rhs.compositor_viewport_pixel_rect))
    return true;
  if (std::less<>{}(rhs.compositor_viewport_pixel_rect, lhs.compositor_viewport_pixel_rect))
    return false;
  if (std::less<>{}(lhs.browser_controls_params, rhs.browser_controls_params))
    return true;
  if (std::less<>{}(rhs.browser_controls_params, lhs.browser_controls_params))
    return false;
  if (std::less<>{}(lhs.scroll_focused_node_into_view, rhs.scroll_focused_node_into_view))
    return true;
  if (std::less<>{}(rhs.scroll_focused_node_into_view, lhs.scroll_focused_node_into_view))
    return false;
  if (std::less<>{}(lhs.local_surface_id, rhs.local_surface_id))
    return true;
  if (std::less<>{}(rhs.local_surface_id, lhs.local_surface_id))
    return false;
  if (std::less<>{}(lhs.is_fullscreen_granted, rhs.is_fullscreen_granted))
    return true;
  if (std::less<>{}(rhs.is_fullscreen_granted, lhs.is_fullscreen_granted))
    return false;
  if (std::less<>{}(lhs.display_mode, rhs.display_mode))
    return true;
  if (std::less<>{}(rhs.display_mode, lhs.display_mode))
    return false;
  if (std::less<>{}(lhs.capture_sequence_number, rhs.capture_sequence_number))
    return true;
  if (std::less<>{}(rhs.capture_sequence_number, lhs.capture_sequence_number))
    return false;
  if (std::less<>{}(lhs.zoom_level, rhs.zoom_level))
    return true;
  if (std::less<>{}(rhs.zoom_level, lhs.zoom_level))
    return false;
  if (std::less<>{}(lhs.page_scale_factor, rhs.page_scale_factor))
    return true;
  if (std::less<>{}(rhs.page_scale_factor, lhs.page_scale_factor))
    return false;
  if (std::less<>{}(lhs.root_widget_window_segments, rhs.root_widget_window_segments))
    return true;
  if (std::less<>{}(rhs.root_widget_window_segments, lhs.root_widget_window_segments))
    return false;
  if (std::less<>{}(lhs.is_pinch_gesture_active, rhs.is_pinch_gesture_active))
    return true;
  if (std::less<>{}(rhs.is_pinch_gesture_active, lhs.is_pinch_gesture_active))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::VisualProperties::DataView,
                                         ::blink::mojom::VisualPropertiesPtr> {
  static bool IsNull(const ::blink::mojom::VisualPropertiesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::VisualPropertiesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::VisualProperties::screen_info)& screen_info(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->screen_info;
  }

  static decltype(::blink::mojom::VisualProperties::auto_resize_enabled) auto_resize_enabled(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->auto_resize_enabled;
  }

  static const decltype(::blink::mojom::VisualProperties::min_size_for_auto_resize)& min_size_for_auto_resize(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->min_size_for_auto_resize;
  }

  static const decltype(::blink::mojom::VisualProperties::max_size_for_auto_resize)& max_size_for_auto_resize(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->max_size_for_auto_resize;
  }

  static const decltype(::blink::mojom::VisualProperties::new_size)& new_size(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->new_size;
  }

  static const decltype(::blink::mojom::VisualProperties::visible_viewport_size)& visible_viewport_size(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->visible_viewport_size;
  }

  static const decltype(::blink::mojom::VisualProperties::compositor_viewport_pixel_rect)& compositor_viewport_pixel_rect(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->compositor_viewport_pixel_rect;
  }

  static const decltype(::blink::mojom::VisualProperties::browser_controls_params)& browser_controls_params(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->browser_controls_params;
  }

  static decltype(::blink::mojom::VisualProperties::scroll_focused_node_into_view) scroll_focused_node_into_view(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->scroll_focused_node_into_view;
  }

  static const decltype(::blink::mojom::VisualProperties::local_surface_id)& local_surface_id(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->local_surface_id;
  }

  static decltype(::blink::mojom::VisualProperties::is_fullscreen_granted) is_fullscreen_granted(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->is_fullscreen_granted;
  }

  static decltype(::blink::mojom::VisualProperties::display_mode) display_mode(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->display_mode;
  }

  static decltype(::blink::mojom::VisualProperties::capture_sequence_number) capture_sequence_number(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->capture_sequence_number;
  }

  static decltype(::blink::mojom::VisualProperties::zoom_level) zoom_level(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->zoom_level;
  }

  static decltype(::blink::mojom::VisualProperties::page_scale_factor) page_scale_factor(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->page_scale_factor;
  }

  static const decltype(::blink::mojom::VisualProperties::root_widget_window_segments)& root_widget_window_segments(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->root_widget_window_segments;
  }

  static decltype(::blink::mojom::VisualProperties::is_pinch_gesture_active) is_pinch_gesture_active(
      const ::blink::mojom::VisualPropertiesPtr& input) {
    return input->is_pinch_gesture_active;
  }

  static bool Read(::blink::mojom::VisualProperties::DataView input, ::blink::mojom::VisualPropertiesPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_VISUAL_PROPERTIES_MOJOM_H_