// services/network/public/mojom/cert_verifier_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/cert_verifier_service.mojom-shared.h"
#include "services/network/public/mojom/cert_verifier_service.mojom-forward.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "services/network/public/cpp/cert_verifier/cert_verifier_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace cert_verifier {
namespace mojom {

class URLLoaderFactoryConnectorProxy;

template <typename ImplRefTraits>
class URLLoaderFactoryConnectorStub;

class URLLoaderFactoryConnectorRequestValidator;


class  URLLoaderFactoryConnector
    : public URLLoaderFactoryConnectorInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = URLLoaderFactoryConnectorInterfaceBase;
  using Proxy_ = URLLoaderFactoryConnectorProxy;

  template <typename ImplRefTraits>
  using Stub_ = URLLoaderFactoryConnectorStub<ImplRefTraits>;

  using RequestValidator_ = URLLoaderFactoryConnectorRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateURLLoaderFactoryMinVersion = 0,
  };
  virtual ~URLLoaderFactoryConnector() {}

  
  virtual void CreateURLLoaderFactory(::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> url_loader_factory) = 0;
};

class CertVerifierServiceProxy;

template <typename ImplRefTraits>
class CertVerifierServiceStub;

class CertVerifierServiceRequestValidator;


class  CertVerifierService
    : public CertVerifierServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = CertVerifierServiceInterfaceBase;
  using Proxy_ = CertVerifierServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = CertVerifierServiceStub<ImplRefTraits>;

  using RequestValidator_ = CertVerifierServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kEnableNetworkAccessMinVersion = 0,
    kVerifyMinVersion = 0,
    kSetConfigMinVersion = 0,
  };
  virtual ~CertVerifierService() {}

  
  virtual void EnableNetworkAccess(::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory, ::mojo::PendingRemote<URLLoaderFactoryConnector> reconnector) = 0;

  
  virtual void Verify(const ::net::CertVerifier::RequestParams& params, ::mojo::PendingRemote<CertVerifierRequest> cert_verifier_request) = 0;

  
  virtual void SetConfig(const ::net::CertVerifier::Config& config) = 0;
};

class CertVerifierRequestProxy;

template <typename ImplRefTraits>
class CertVerifierRequestStub;

class CertVerifierRequestRequestValidator;


class  CertVerifierRequest
    : public CertVerifierRequestInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = CertVerifierRequestInterfaceBase;
  using Proxy_ = CertVerifierRequestProxy;

  template <typename ImplRefTraits>
  using Stub_ = CertVerifierRequestStub<ImplRefTraits>;

  using RequestValidator_ = CertVerifierRequestRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCompleteMinVersion = 0,
  };
  virtual ~CertVerifierRequest() {}

  
  virtual void Complete(const ::net::CertVerifyResult& result, int32_t net_error) = 0;
};



class  URLLoaderFactoryConnectorProxy
    : public URLLoaderFactoryConnector {
 public:
  using InterfaceType = URLLoaderFactoryConnector;

  explicit URLLoaderFactoryConnectorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateURLLoaderFactory(::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> url_loader_factory) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CertVerifierServiceProxy
    : public CertVerifierService {
 public:
  using InterfaceType = CertVerifierService;

  explicit CertVerifierServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EnableNetworkAccess(::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory, ::mojo::PendingRemote<URLLoaderFactoryConnector> reconnector) final;
  
  void Verify(const ::net::CertVerifier::RequestParams& params, ::mojo::PendingRemote<CertVerifierRequest> cert_verifier_request) final;
  
  void SetConfig(const ::net::CertVerifier::Config& config) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CertVerifierRequestProxy
    : public CertVerifierRequest {
 public:
  using InterfaceType = CertVerifierRequest;

  explicit CertVerifierRequestProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Complete(const ::net::CertVerifyResult& result, int32_t net_error) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  URLLoaderFactoryConnectorStubDispatch {
 public:
  static bool Accept(URLLoaderFactoryConnector* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      URLLoaderFactoryConnector* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<URLLoaderFactoryConnector>>
class URLLoaderFactoryConnectorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  URLLoaderFactoryConnectorStub() {}
  ~URLLoaderFactoryConnectorStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderFactoryConnectorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderFactoryConnectorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CertVerifierServiceStubDispatch {
 public:
  static bool Accept(CertVerifierService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CertVerifierService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CertVerifierService>>
class CertVerifierServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CertVerifierServiceStub() {}
  ~CertVerifierServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertVerifierServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertVerifierServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CertVerifierRequestStubDispatch {
 public:
  static bool Accept(CertVerifierRequest* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CertVerifierRequest* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CertVerifierRequest>>
class CertVerifierRequestStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CertVerifierRequestStub() {}
  ~CertVerifierRequestStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertVerifierRequestStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertVerifierRequestStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  URLLoaderFactoryConnectorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CertVerifierServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CertVerifierRequestRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  RequestParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RequestParams, T>::value>;
  using DataView = RequestParamsDataView;
  using Data_ = internal::RequestParams_Data;

  template <typename... Args>
  static RequestParamsPtr New(Args&&... args) {
    return RequestParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RequestParamsPtr From(const U& u) {
    return mojo::TypeConverter<RequestParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequestParams>::Convert(*this);
  }


  RequestParams();

  RequestParams(
      const ::scoped_refptr<::net::X509Certificate>& certificate,
      const std::string& hostname,
      int32_t flags,
      const std::string& ocsp_response,
      const std::string& sct_list);

  ~RequestParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RequestParamsPtr>
  RequestParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequestParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RequestParams_UnserializedMessageContext<
            UserType, RequestParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RequestParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return RequestParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RequestParams_UnserializedMessageContext<
            UserType, RequestParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RequestParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::scoped_refptr<::net::X509Certificate> certificate;
  
  std::string hostname;
  
  int32_t flags;
  
  std::string ocsp_response;
  
  std::string sct_list;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CertVerifierConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CertVerifierConfig, T>::value>;
  using DataView = CertVerifierConfigDataView;
  using Data_ = internal::CertVerifierConfig_Data;

  template <typename... Args>
  static CertVerifierConfigPtr New(Args&&... args) {
    return CertVerifierConfigPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CertVerifierConfigPtr From(const U& u) {
    return mojo::TypeConverter<CertVerifierConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CertVerifierConfig>::Convert(*this);
  }


  CertVerifierConfig();

  CertVerifierConfig(
      bool enable_rev_checking,
      bool require_rev_checking_local_anchors,
      bool enable_sha1_local_anchors,
      bool disable_symantec_enforcement,
      ::mojo_base::BigBuffer crl_set,
      std::vector<::scoped_refptr<::net::X509Certificate>> additional_trust_anchors,
      std::vector<::scoped_refptr<::net::X509Certificate>> additional_untrusted_authorities);

  ~CertVerifierConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CertVerifierConfigPtr>
  CertVerifierConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CertVerifierConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CertVerifierConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CertVerifierConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CertVerifierConfig_UnserializedMessageContext<
            UserType, CertVerifierConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CertVerifierConfig::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CertVerifierConfig::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CertVerifierConfig_UnserializedMessageContext<
            UserType, CertVerifierConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CertVerifierConfig::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool enable_rev_checking;
  
  bool require_rev_checking_local_anchors;
  
  bool enable_sha1_local_anchors;
  
  bool disable_symantec_enforcement;
  
  ::mojo_base::BigBuffer crl_set;
  
  std::vector<::scoped_refptr<::net::X509Certificate>> additional_trust_anchors;
  
  std::vector<::scoped_refptr<::net::X509Certificate>> additional_untrusted_authorities;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CertVerifierConfig);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CertVerifierConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CertVerifierConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CertVerifierConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CertVerifierConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RequestParamsPtr RequestParams::Clone() const {
  return New(
      mojo::Clone(certificate),
      mojo::Clone(hostname),
      mojo::Clone(flags),
      mojo::Clone(ocsp_response),
      mojo::Clone(sct_list)
  );
}

template <typename T, RequestParams::EnableIfSame<T>*>
bool RequestParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->certificate, other_struct.certificate))
    return false;
  if (!mojo::Equals(this->hostname, other_struct.hostname))
    return false;
  if (!mojo::Equals(this->flags, other_struct.flags))
    return false;
  if (!mojo::Equals(this->ocsp_response, other_struct.ocsp_response))
    return false;
  if (!mojo::Equals(this->sct_list, other_struct.sct_list))
    return false;
  return true;
}

template <typename T, RequestParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.certificate, rhs.certificate))
    return true;
  if (std::less<>{}(rhs.certificate, lhs.certificate))
    return false;
  if (std::less<>{}(lhs.hostname, rhs.hostname))
    return true;
  if (std::less<>{}(rhs.hostname, lhs.hostname))
    return false;
  if (std::less<>{}(lhs.flags, rhs.flags))
    return true;
  if (std::less<>{}(rhs.flags, lhs.flags))
    return false;
  if (std::less<>{}(lhs.ocsp_response, rhs.ocsp_response))
    return true;
  if (std::less<>{}(rhs.ocsp_response, lhs.ocsp_response))
    return false;
  if (std::less<>{}(lhs.sct_list, rhs.sct_list))
    return true;
  if (std::less<>{}(rhs.sct_list, lhs.sct_list))
    return false;
  return false;
}
template <typename StructPtrType>
CertVerifierConfigPtr CertVerifierConfig::Clone() const {
  return New(
      mojo::Clone(enable_rev_checking),
      mojo::Clone(require_rev_checking_local_anchors),
      mojo::Clone(enable_sha1_local_anchors),
      mojo::Clone(disable_symantec_enforcement),
      mojo::Clone(crl_set),
      mojo::Clone(additional_trust_anchors),
      mojo::Clone(additional_untrusted_authorities)
  );
}

template <typename T, CertVerifierConfig::EnableIfSame<T>*>
bool CertVerifierConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->enable_rev_checking, other_struct.enable_rev_checking))
    return false;
  if (!mojo::Equals(this->require_rev_checking_local_anchors, other_struct.require_rev_checking_local_anchors))
    return false;
  if (!mojo::Equals(this->enable_sha1_local_anchors, other_struct.enable_sha1_local_anchors))
    return false;
  if (!mojo::Equals(this->disable_symantec_enforcement, other_struct.disable_symantec_enforcement))
    return false;
  if (!mojo::Equals(this->crl_set, other_struct.crl_set))
    return false;
  if (!mojo::Equals(this->additional_trust_anchors, other_struct.additional_trust_anchors))
    return false;
  if (!mojo::Equals(this->additional_untrusted_authorities, other_struct.additional_untrusted_authorities))
    return false;
  return true;
}

template <typename T, CertVerifierConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.enable_rev_checking, rhs.enable_rev_checking))
    return true;
  if (std::less<>{}(rhs.enable_rev_checking, lhs.enable_rev_checking))
    return false;
  if (std::less<>{}(lhs.require_rev_checking_local_anchors, rhs.require_rev_checking_local_anchors))
    return true;
  if (std::less<>{}(rhs.require_rev_checking_local_anchors, lhs.require_rev_checking_local_anchors))
    return false;
  if (std::less<>{}(lhs.enable_sha1_local_anchors, rhs.enable_sha1_local_anchors))
    return true;
  if (std::less<>{}(rhs.enable_sha1_local_anchors, lhs.enable_sha1_local_anchors))
    return false;
  if (std::less<>{}(lhs.disable_symantec_enforcement, rhs.disable_symantec_enforcement))
    return true;
  if (std::less<>{}(rhs.disable_symantec_enforcement, lhs.disable_symantec_enforcement))
    return false;
  if (std::less<>{}(lhs.crl_set, rhs.crl_set))
    return true;
  if (std::less<>{}(rhs.crl_set, lhs.crl_set))
    return false;
  if (std::less<>{}(lhs.additional_trust_anchors, rhs.additional_trust_anchors))
    return true;
  if (std::less<>{}(rhs.additional_trust_anchors, lhs.additional_trust_anchors))
    return false;
  if (std::less<>{}(lhs.additional_untrusted_authorities, rhs.additional_untrusted_authorities))
    return true;
  if (std::less<>{}(rhs.additional_untrusted_authorities, lhs.additional_untrusted_authorities))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace cert_verifier

namespace mojo {


template <>
struct  StructTraits<::cert_verifier::mojom::RequestParams::DataView,
                                         ::cert_verifier::mojom::RequestParamsPtr> {
  static bool IsNull(const ::cert_verifier::mojom::RequestParamsPtr& input) { return !input; }
  static void SetToNull(::cert_verifier::mojom::RequestParamsPtr* output) { output->reset(); }

  static const decltype(::cert_verifier::mojom::RequestParams::certificate)& certificate(
      const ::cert_verifier::mojom::RequestParamsPtr& input) {
    return input->certificate;
  }

  static const decltype(::cert_verifier::mojom::RequestParams::hostname)& hostname(
      const ::cert_verifier::mojom::RequestParamsPtr& input) {
    return input->hostname;
  }

  static decltype(::cert_verifier::mojom::RequestParams::flags) flags(
      const ::cert_verifier::mojom::RequestParamsPtr& input) {
    return input->flags;
  }

  static const decltype(::cert_verifier::mojom::RequestParams::ocsp_response)& ocsp_response(
      const ::cert_verifier::mojom::RequestParamsPtr& input) {
    return input->ocsp_response;
  }

  static const decltype(::cert_verifier::mojom::RequestParams::sct_list)& sct_list(
      const ::cert_verifier::mojom::RequestParamsPtr& input) {
    return input->sct_list;
  }

  static bool Read(::cert_verifier::mojom::RequestParams::DataView input, ::cert_verifier::mojom::RequestParamsPtr* output);
};


template <>
struct  StructTraits<::cert_verifier::mojom::CertVerifierConfig::DataView,
                                         ::cert_verifier::mojom::CertVerifierConfigPtr> {
  static bool IsNull(const ::cert_verifier::mojom::CertVerifierConfigPtr& input) { return !input; }
  static void SetToNull(::cert_verifier::mojom::CertVerifierConfigPtr* output) { output->reset(); }

  static decltype(::cert_verifier::mojom::CertVerifierConfig::enable_rev_checking) enable_rev_checking(
      const ::cert_verifier::mojom::CertVerifierConfigPtr& input) {
    return input->enable_rev_checking;
  }

  static decltype(::cert_verifier::mojom::CertVerifierConfig::require_rev_checking_local_anchors) require_rev_checking_local_anchors(
      const ::cert_verifier::mojom::CertVerifierConfigPtr& input) {
    return input->require_rev_checking_local_anchors;
  }

  static decltype(::cert_verifier::mojom::CertVerifierConfig::enable_sha1_local_anchors) enable_sha1_local_anchors(
      const ::cert_verifier::mojom::CertVerifierConfigPtr& input) {
    return input->enable_sha1_local_anchors;
  }

  static decltype(::cert_verifier::mojom::CertVerifierConfig::disable_symantec_enforcement) disable_symantec_enforcement(
      const ::cert_verifier::mojom::CertVerifierConfigPtr& input) {
    return input->disable_symantec_enforcement;
  }

  static  decltype(::cert_verifier::mojom::CertVerifierConfig::crl_set)& crl_set(
       ::cert_verifier::mojom::CertVerifierConfigPtr& input) {
    return input->crl_set;
  }

  static const decltype(::cert_verifier::mojom::CertVerifierConfig::additional_trust_anchors)& additional_trust_anchors(
      const ::cert_verifier::mojom::CertVerifierConfigPtr& input) {
    return input->additional_trust_anchors;
  }

  static const decltype(::cert_verifier::mojom::CertVerifierConfig::additional_untrusted_authorities)& additional_untrusted_authorities(
      const ::cert_verifier::mojom::CertVerifierConfigPtr& input) {
    return input->additional_untrusted_authorities;
  }

  static bool Read(::cert_verifier::mojom::CertVerifierConfig::DataView input, ::cert_verifier::mojom::CertVerifierConfigPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_H_