// media/mojo/mojom/display_media_information.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_H_
#define MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "media/mojo/mojom/display_media_information.mojom-shared.h"
#include "media/mojo/mojom/display_media_information.mojom-forward.h"
#include <string>
#include <vector>







// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media {
namespace mojom {





class  DisplayMediaInformation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DisplayMediaInformation, T>::value>;
  using DataView = DisplayMediaInformationDataView;
  using Data_ = internal::DisplayMediaInformation_Data;

  template <typename... Args>
  static DisplayMediaInformationPtr New(Args&&... args) {
    return DisplayMediaInformationPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DisplayMediaInformationPtr From(const U& u) {
    return mojo::TypeConverter<DisplayMediaInformationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DisplayMediaInformation>::Convert(*this);
  }


  DisplayMediaInformation();

  DisplayMediaInformation(
      DisplayCaptureSurfaceType display_surface,
      bool logical_surface,
      CursorCaptureType cursor);

  ~DisplayMediaInformation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DisplayMediaInformationPtr>
  DisplayMediaInformationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DisplayMediaInformation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DisplayMediaInformation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DisplayMediaInformation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DisplayMediaInformation_UnserializedMessageContext<
            UserType, DisplayMediaInformation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DisplayMediaInformation::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DisplayMediaInformation::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DisplayMediaInformation_UnserializedMessageContext<
            UserType, DisplayMediaInformation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DisplayMediaInformation::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  DisplayCaptureSurfaceType display_surface;
  
  bool logical_surface;
  
  CursorCaptureType cursor;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DisplayMediaInformation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DisplayMediaInformation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DisplayMediaInformation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DisplayMediaInformation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
DisplayMediaInformationPtr DisplayMediaInformation::Clone() const {
  return New(
      mojo::Clone(display_surface),
      mojo::Clone(logical_surface),
      mojo::Clone(cursor)
  );
}

template <typename T, DisplayMediaInformation::EnableIfSame<T>*>
bool DisplayMediaInformation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->display_surface, other_struct.display_surface))
    return false;
  if (!mojo::Equals(this->logical_surface, other_struct.logical_surface))
    return false;
  if (!mojo::Equals(this->cursor, other_struct.cursor))
    return false;
  return true;
}

template <typename T, DisplayMediaInformation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.display_surface, rhs.display_surface))
    return true;
  if (std::less<>{}(rhs.display_surface, lhs.display_surface))
    return false;
  if (std::less<>{}(lhs.logical_surface, rhs.logical_surface))
    return true;
  if (std::less<>{}(rhs.logical_surface, lhs.logical_surface))
    return false;
  if (std::less<>{}(lhs.cursor, rhs.cursor))
    return true;
  if (std::less<>{}(rhs.cursor, lhs.cursor))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace media

namespace mojo {


template <>
struct  StructTraits<::media::mojom::DisplayMediaInformation::DataView,
                                         ::media::mojom::DisplayMediaInformationPtr> {
  static bool IsNull(const ::media::mojom::DisplayMediaInformationPtr& input) { return !input; }
  static void SetToNull(::media::mojom::DisplayMediaInformationPtr* output) { output->reset(); }

  static decltype(::media::mojom::DisplayMediaInformation::display_surface) display_surface(
      const ::media::mojom::DisplayMediaInformationPtr& input) {
    return input->display_surface;
  }

  static decltype(::media::mojom::DisplayMediaInformation::logical_surface) logical_surface(
      const ::media::mojom::DisplayMediaInformationPtr& input) {
    return input->logical_surface;
  }

  static decltype(::media::mojom::DisplayMediaInformation::cursor) cursor(
      const ::media::mojom::DisplayMediaInformationPtr& input) {
    return input->cursor;
  }

  static bool Read(::media::mojom::DisplayMediaInformation::DataView input, ::media::mojom::DisplayMediaInformationPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_DISPLAY_MEDIA_INFORMATION_MOJOM_H_