// ui/accessibility/mojom/ax_event.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_EVENT_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_MOJOM_AX_EVENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/accessibility/mojom/ax_event.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_event_intent.mojom-shared.h"







namespace ax {
namespace mojom {
class AXEventDataView;



}  // namespace mojom
}  // namespace ax

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::AXEventDataView> {
  using Data = ::ax::mojom::internal::AXEvent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax {
namespace mojom {


class AXEventDataView {
 public:
  AXEventDataView() {}

  AXEventDataView(
      internal::AXEvent_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEventType(UserType* output) const {
    auto data_value = data_->event_type;
    return mojo::internal::Deserialize<::ax::mojom::Event>(
        data_value, output);
  }

  ::ax::mojom::Event event_type() const {
    return static_cast<::ax::mojom::Event>(data_->event_type);
  }
  int32_t id() const {
    return data_->id;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEventFrom(UserType* output) const {
    auto data_value = data_->event_from;
    return mojo::internal::Deserialize<::ax::mojom::EventFrom>(
        data_value, output);
  }

  ::ax::mojom::EventFrom event_from() const {
    return static_cast<::ax::mojom::EventFrom>(data_->event_from);
  }
  inline void GetEventIntentsDataView(
      mojo::ArrayDataView<::ax::mojom::EventIntentDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEventIntents(UserType* output) {
    
    auto* pointer = data_->event_intents.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::EventIntentDataView>>(
        pointer, output, context_);
  }
  int32_t action_request_id() const {
    return data_->action_request_id;
  }
 private:
  internal::AXEvent_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace ax

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXEventDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXEventDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::ax::mojom::internal::AXEvent_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::ax::mojom::Event>(
        Traits::event_type(input), &(*output)->event_type);
    (*output)->id = Traits::id(input);
    mojo::internal::Serialize<::ax::mojom::EventFrom>(
        Traits::event_from(input), &(*output)->event_from);
    decltype(Traits::event_intents(input)) in_event_intents = Traits::event_intents(input);
    typename decltype((*output)->event_intents)::BaseType::BufferWriter
        event_intents_writer;
    const mojo::internal::ContainerValidateParams event_intents_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::EventIntentDataView>>(
        in_event_intents, buffer, &event_intents_writer, &event_intents_validate_params,
        context);
    (*output)->event_intents.Set(
        event_intents_writer.is_null() ? nullptr : event_intents_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->event_intents.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_intents in AXEvent struct");
    (*output)->action_request_id = Traits::action_request_id(input);
  }

  static bool Deserialize(::ax::mojom::internal::AXEvent_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::AXEventDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax {
namespace mojom {

inline void AXEventDataView::GetEventIntentsDataView(
    mojo::ArrayDataView<::ax::mojom::EventIntentDataView>* output) {
  auto pointer = data_->event_intents.Get();
  *output = mojo::ArrayDataView<::ax::mojom::EventIntentDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace ax

#endif  // UI_ACCESSIBILITY_MOJOM_AX_EVENT_MOJOM_SHARED_H_