#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

#include <git2.h>
#include <git2/sys/repository.h>


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // char const *()(git_refspec const *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 912), // git_refspec const *
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // char const *()(git_remote const *)
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 913), // git_remote const *
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION, 10), // char const *()(git_submodule *)
/*  7 */ _CFFI_OP(_CFFI_OP_POINTER, 934), // git_submodule *
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 849), // git_attr_value_t()(char const *)
/* 10 */ _CFFI_OP(_CFFI_OP_POINTER, 845), // char const *
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION, 851), // git_blame_hunk const *()(git_blame *, size_t)
/* 13 */ _CFFI_OP(_CFFI_OP_POINTER, 850), // git_blame *
/* 14 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 15 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 16 */ _CFFI_OP(_CFFI_OP_FUNCTION, 851), // git_blame_hunk const *()(git_blame *, uint32_t)
/* 17 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 18 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION, 883), // git_direction()(git_refspec const *)
/* 21 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 22 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 23 */ _CFFI_OP(_CFFI_OP_FUNCTION, 884), // git_error const *()(void)
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION, 337), // git_index_entry const *()(git_index *, char const *, int)
/* 26 */ _CFFI_OP(_CFFI_OP_POINTER, 890), // git_index *
/* 27 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 28 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 29 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 30 */ _CFFI_OP(_CFFI_OP_FUNCTION, 337), // git_index_entry const *()(git_index *, size_t)
/* 31 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 32 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 33 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION, 387), // git_indexer_progress const *()(git_remote *)
/* 35 */ _CFFI_OP(_CFFI_OP_POINTER, 913), // git_remote *
/* 36 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 37 */ _CFFI_OP(_CFFI_OP_FUNCTION, 71), // git_oid const *()(git_submodule *)
/* 38 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // git_refspec const *()(git_remote const *, size_t)
/* 41 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 42 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION, 925), // git_repository_state_t()(git_repository *)
/* 45 */ _CFFI_OP(_CFFI_OP_POINTER, 920), // git_repository *
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(char const * *, char const * *, git_repository const *)
/* 48 */ _CFFI_OP(_CFFI_OP_POINTER, 10), // char const * *
/* 49 */ _CFFI_OP(_CFFI_OP_NOOP, 48),
/* 50 */ _CFFI_OP(_CFFI_OP_POINTER, 920), // git_repository const *
/* 51 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 52 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(char const * *, git_config const *, char const *)
/* 53 */ _CFFI_OP(_CFFI_OP_NOOP, 48),
/* 54 */ _CFFI_OP(_CFFI_OP_POINTER, 865), // git_config const *
/* 55 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(char const * *, git_repository *, git_attr_options *, char const *, char const *)
/* 58 */ _CFFI_OP(_CFFI_OP_NOOP, 48),
/* 59 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 60 */ _CFFI_OP(_CFFI_OP_POINTER, 848), // git_attr_options *
/* 61 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 62 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 64 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(char const *, char const *, void *)
/* 65 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 66 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 67 */ _CFFI_OP(_CFFI_OP_POINTER, 974), // void *
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(char const *, git_oid const *, git_oid const *, git_refspec *, void *)
/* 70 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 71 */ _CFFI_OP(_CFFI_OP_POINTER, 903), // git_oid const *
/* 72 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 73 */ _CFFI_OP(_CFFI_OP_POINTER, 912), // git_refspec *
/* 74 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 76 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(char const *, git_oid const *, git_oid const *, void *)
/* 77 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 78 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 79 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 80 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 81 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 82 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(char const *, int, void *)
/* 83 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 84 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 85 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 86 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 87 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_annotated_commit * *, git_repository *, git_oid const *)
/* 88 */ _CFFI_OP(_CFFI_OP_POINTER, 791), // git_annotated_commit * *
/* 89 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 90 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 92 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_annotated_commit * *, git_repository *, struct git_reference const *)
/* 93 */ _CFFI_OP(_CFFI_OP_NOOP, 88),
/* 94 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 95 */ _CFFI_OP(_CFFI_OP_POINTER, 963), // struct git_reference const *
/* 96 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_blame * *, git_repository *, char const *, git_blame_options *)
/* 98 */ _CFFI_OP(_CFFI_OP_POINTER, 13), // git_blame * *
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 100 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 101 */ _CFFI_OP(_CFFI_OP_POINTER, 853), // git_blame_options *
/* 102 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_blame_options *, unsigned int)
/* 104 */ _CFFI_OP(_CFFI_OP_NOOP, 101),
/* 105 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 106 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 107 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_buf *)
/* 108 */ _CFFI_OP(_CFFI_OP_POINTER, 854), // git_buf *
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 110 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_buf *, char const *, int, void *)
/* 111 */ _CFFI_OP(_CFFI_OP_NOOP, 108),
/* 112 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 113 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 114 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 115 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 116 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_buf *, git_describe_result const *, git_describe_format_options const *)
/* 117 */ _CFFI_OP(_CFFI_OP_NOOP, 108),
/* 118 */ _CFFI_OP(_CFFI_OP_POINTER, 874), // git_describe_result const *
/* 119 */ _CFFI_OP(_CFFI_OP_POINTER, 872), // git_describe_format_options const *
/* 120 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 121 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_buf *, git_refspec const *, char const *)
/* 122 */ _CFFI_OP(_CFFI_OP_NOOP, 108),
/* 123 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 125 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_buf *, git_repository *)
/* 127 */ _CFFI_OP(_CFFI_OP_NOOP, 108),
/* 128 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 129 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_cert *, int, char const *, void *)
/* 131 */ _CFFI_OP(_CFFI_OP_POINTER, 855), // git_cert *
/* 132 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 133 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 134 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 135 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_checkout_notify_t, char const *, git_diff_file const *, git_diff_file const *, git_diff_file const *, void *)
/* 137 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // git_checkout_notify_t
/* 138 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 139 */ _CFFI_OP(_CFFI_OP_POINTER, 879), // git_diff_file const *
/* 140 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 141 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 142 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 143 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_checkout_options *, unsigned int)
/* 145 */ _CFFI_OP(_CFFI_OP_POINTER, 860), // git_checkout_options *
/* 146 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 147 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_clone_options *, unsigned int)
/* 149 */ _CFFI_OP(_CFFI_OP_POINTER, 863), // git_clone_options *
/* 150 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_config * *)
/* 153 */ _CFFI_OP(_CFFI_OP_POINTER, 161), // git_config * *
/* 154 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_config * *, char const *)
/* 156 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 157 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 158 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 159 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_config * *, git_config *)
/* 160 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 161 */ _CFFI_OP(_CFFI_OP_POINTER, 865), // git_config *
/* 162 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_config * *, git_repository *)
/* 164 */ _CFFI_OP(_CFFI_OP_NOOP, 153),
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 166 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 167 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_config *, char const *)
/* 168 */ _CFFI_OP(_CFFI_OP_NOOP, 161),
/* 169 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 170 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 171 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_config *, char const *, char const *)
/* 172 */ _CFFI_OP(_CFFI_OP_NOOP, 161),
/* 173 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 174 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 176 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_config *, char const *, char const *, char const *)
/* 177 */ _CFFI_OP(_CFFI_OP_NOOP, 161),
/* 178 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 179 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 180 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 181 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 182 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_config *, char const *, git_config_level_t, git_repository const *, int)
/* 183 */ _CFFI_OP(_CFFI_OP_NOOP, 161),
/* 184 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 185 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // git_config_level_t
/* 186 */ _CFFI_OP(_CFFI_OP_NOOP, 50),
/* 187 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 188 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 189 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_config *, char const *, int)
/* 190 */ _CFFI_OP(_CFFI_OP_NOOP, 161),
/* 191 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 192 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 193 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 194 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_config *, char const *, int64_t)
/* 195 */ _CFFI_OP(_CFFI_OP_NOOP, 161),
/* 196 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 197 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 23), // int64_t
/* 198 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 199 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_config_entry * *, git_config const *, char const *)
/* 200 */ _CFFI_OP(_CFFI_OP_POINTER, 807), // git_config_entry * *
/* 201 */ _CFFI_OP(_CFFI_OP_NOOP, 54),
/* 202 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 203 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 204 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_config_entry * *, git_config_iterator *)
/* 205 */ _CFFI_OP(_CFFI_OP_NOOP, 200),
/* 206 */ _CFFI_OP(_CFFI_OP_POINTER, 867), // git_config_iterator *
/* 207 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 208 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_config_iterator * *, git_config const *)
/* 209 */ _CFFI_OP(_CFFI_OP_POINTER, 206), // git_config_iterator * *
/* 210 */ _CFFI_OP(_CFFI_OP_NOOP, 54),
/* 211 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 212 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_config_iterator * *, git_config const *, char const *, char const *)
/* 213 */ _CFFI_OP(_CFFI_OP_NOOP, 209),
/* 214 */ _CFFI_OP(_CFFI_OP_NOOP, 54),
/* 215 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 216 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 217 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 218 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_credential * *, char const *)
/* 219 */ _CFFI_OP(_CFFI_OP_POINTER, 868), // git_credential * *
/* 220 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 221 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 222 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_credential * *, char const *, char const *)
/* 223 */ _CFFI_OP(_CFFI_OP_NOOP, 219),
/* 224 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 225 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 226 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 227 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_credential * *, char const *, char const *, char const *, char const *)
/* 228 */ _CFFI_OP(_CFFI_OP_NOOP, 219),
/* 229 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 230 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 231 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 232 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 233 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 234 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_credential * *, char const *, char const *, unsigned int, void *)
/* 235 */ _CFFI_OP(_CFFI_OP_NOOP, 219),
/* 236 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 237 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 238 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 239 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 240 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 241 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_describe_format_options *, unsigned int)
/* 242 */ _CFFI_OP(_CFFI_OP_POINTER, 872), // git_describe_format_options *
/* 243 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 244 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 245 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_describe_options *, unsigned int)
/* 246 */ _CFFI_OP(_CFFI_OP_POINTER, 873), // git_describe_options *
/* 247 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 249 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_describe_result * *, git_object *, git_describe_options *)
/* 250 */ _CFFI_OP(_CFFI_OP_POINTER, 813), // git_describe_result * *
/* 251 */ _CFFI_OP(_CFFI_OP_POINTER, 902), // git_object *
/* 252 */ _CFFI_OP(_CFFI_OP_NOOP, 246),
/* 253 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 254 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_describe_result * *, git_repository *, git_describe_options *)
/* 255 */ _CFFI_OP(_CFFI_OP_NOOP, 250),
/* 256 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 257 */ _CFFI_OP(_CFFI_OP_NOOP, 246),
/* 258 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 259 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_diff * *, git_repository *, git_index *, git_diff_options const *)
/* 260 */ _CFFI_OP(_CFFI_OP_POINTER, 876), // git_diff * *
/* 261 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 262 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 263 */ _CFFI_OP(_CFFI_OP_POINTER, 880), // git_diff_options const *
/* 264 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 265 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_diff * *, git_repository *, git_tree *, git_index *, git_diff_options const *)
/* 266 */ _CFFI_OP(_CFFI_OP_NOOP, 260),
/* 267 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 268 */ _CFFI_OP(_CFFI_OP_POINTER, 939), // git_tree *
/* 269 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 270 */ _CFFI_OP(_CFFI_OP_NOOP, 263),
/* 271 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 272 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_diff const *, char const *, char const *, void *)
/* 273 */ _CFFI_OP(_CFFI_OP_POINTER, 877), // git_diff const *
/* 274 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 275 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 276 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 277 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 278 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_diff const *, git_diff_delta const *, char const *, void *)
/* 279 */ _CFFI_OP(_CFFI_OP_NOOP, 273),
/* 280 */ _CFFI_OP(_CFFI_OP_POINTER, 878), // git_diff_delta const *
/* 281 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 282 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 283 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 284 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_diff_options *, unsigned int)
/* 285 */ _CFFI_OP(_CFFI_OP_POINTER, 880), // git_diff_options *
/* 286 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 287 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 288 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_fetch_options *, unsigned int)
/* 289 */ _CFFI_OP(_CFFI_OP_POINTER, 888), // git_fetch_options *
/* 290 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 291 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 292 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index * *, char const *)
/* 293 */ _CFFI_OP(_CFFI_OP_POINTER, 26), // git_index * *
/* 294 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 295 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 296 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index * *, git_repository *)
/* 297 */ _CFFI_OP(_CFFI_OP_NOOP, 293),
/* 298 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 299 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 300 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index * *, git_repository *, git_commit *, git_commit *, unsigned int, git_merge_options const *)
/* 301 */ _CFFI_OP(_CFFI_OP_NOOP, 293),
/* 302 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 303 */ _CFFI_OP(_CFFI_OP_POINTER, 864), // git_commit *
/* 304 */ _CFFI_OP(_CFFI_OP_NOOP, 303),
/* 305 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 306 */ _CFFI_OP(_CFFI_OP_POINTER, 901), // git_merge_options const *
/* 307 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 308 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index * *, git_repository *, git_commit const *, git_commit const *, git_merge_options const *)
/* 309 */ _CFFI_OP(_CFFI_OP_NOOP, 293),
/* 310 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 311 */ _CFFI_OP(_CFFI_OP_POINTER, 864), // git_commit const *
/* 312 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 313 */ _CFFI_OP(_CFFI_OP_NOOP, 306),
/* 314 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 315 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index * *, git_repository *, git_tree const *, git_tree const *, git_tree const *, git_merge_options const *)
/* 316 */ _CFFI_OP(_CFFI_OP_NOOP, 293),
/* 317 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 318 */ _CFFI_OP(_CFFI_OP_POINTER, 939), // git_tree const *
/* 319 */ _CFFI_OP(_CFFI_OP_NOOP, 318),
/* 320 */ _CFFI_OP(_CFFI_OP_NOOP, 318),
/* 321 */ _CFFI_OP(_CFFI_OP_NOOP, 306),
/* 322 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 323 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index *)
/* 324 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 325 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 326 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index *, char const *)
/* 327 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 328 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 329 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 330 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index *, char const *, int)
/* 331 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 332 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 333 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 334 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 335 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index *, git_index_entry const *)
/* 336 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 337 */ _CFFI_OP(_CFFI_OP_POINTER, 892), // git_index_entry const *
/* 338 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 339 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index *, git_index_entry const *, git_index_entry const *, git_index_entry const *)
/* 340 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 341 */ _CFFI_OP(_CFFI_OP_NOOP, 337),
/* 342 */ _CFFI_OP(_CFFI_OP_NOOP, 337),
/* 343 */ _CFFI_OP(_CFFI_OP_NOOP, 337),
/* 344 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 345 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index *, git_strarray const *, int(*)(char const *, char const *, void *), void *)
/* 346 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 347 */ _CFFI_OP(_CFFI_OP_POINTER, 933), // git_strarray const *
/* 348 */ _CFFI_OP(_CFFI_OP_POINTER, 64), // int(*)(char const *, char const *, void *)
/* 349 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 350 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 351 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index *, git_strarray const *, unsigned int, int(*)(char const *, char const *, void *), void *)
/* 352 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 353 */ _CFFI_OP(_CFFI_OP_NOOP, 347),
/* 354 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 355 */ _CFFI_OP(_CFFI_OP_NOOP, 348),
/* 356 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 357 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 358 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index *, git_tree const *)
/* 359 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 360 */ _CFFI_OP(_CFFI_OP_NOOP, 318),
/* 361 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 362 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index *, int)
/* 363 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 364 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 365 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 366 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index const *)
/* 367 */ _CFFI_OP(_CFFI_OP_POINTER, 890), // git_index const *
/* 368 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 369 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index_conflict_iterator * *, git_index *)
/* 370 */ _CFFI_OP(_CFFI_OP_POINTER, 384), // git_index_conflict_iterator * *
/* 371 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 372 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 373 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index_entry const * *, git_index_entry const * *, git_index_entry const * *, git_index *, char const *)
/* 374 */ _CFFI_OP(_CFFI_OP_POINTER, 337), // git_index_entry const * *
/* 375 */ _CFFI_OP(_CFFI_OP_NOOP, 374),
/* 376 */ _CFFI_OP(_CFFI_OP_NOOP, 374),
/* 377 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 378 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 379 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 380 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_index_entry const * *, git_index_entry const * *, git_index_entry const * *, git_index_conflict_iterator *)
/* 381 */ _CFFI_OP(_CFFI_OP_NOOP, 374),
/* 382 */ _CFFI_OP(_CFFI_OP_NOOP, 374),
/* 383 */ _CFFI_OP(_CFFI_OP_NOOP, 374),
/* 384 */ _CFFI_OP(_CFFI_OP_POINTER, 891), // git_index_conflict_iterator *
/* 385 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 386 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_indexer_progress const *, void *)
/* 387 */ _CFFI_OP(_CFFI_OP_POINTER, 894), // git_indexer_progress const *
/* 388 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 389 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 390 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_merge_file_result *, git_repository *, git_index_entry const *, git_index_entry const *, git_index_entry const *, git_merge_file_options const *)
/* 391 */ _CFFI_OP(_CFFI_OP_POINTER, 899), // git_merge_file_result *
/* 392 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 393 */ _CFFI_OP(_CFFI_OP_NOOP, 337),
/* 394 */ _CFFI_OP(_CFFI_OP_NOOP, 337),
/* 395 */ _CFFI_OP(_CFFI_OP_NOOP, 337),
/* 396 */ _CFFI_OP(_CFFI_OP_POINTER, 898), // git_merge_file_options const *
/* 397 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 398 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_merge_options *, unsigned int)
/* 399 */ _CFFI_OP(_CFFI_OP_POINTER, 901), // git_merge_options *
/* 400 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 401 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 402 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_oid *, git_commit const *, char const *, git_signature const *, git_signature const *, char const *, char const *, git_tree const *)
/* 403 */ _CFFI_OP(_CFFI_OP_POINTER, 903), // git_oid *
/* 404 */ _CFFI_OP(_CFFI_OP_NOOP, 311),
/* 405 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 406 */ _CFFI_OP(_CFFI_OP_POINTER, 928), // git_signature const *
/* 407 */ _CFFI_OP(_CFFI_OP_NOOP, 406),
/* 408 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 409 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 410 */ _CFFI_OP(_CFFI_OP_NOOP, 318),
/* 411 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 412 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_oid *, git_index *)
/* 413 */ _CFFI_OP(_CFFI_OP_NOOP, 403),
/* 414 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 415 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 416 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_oid *, git_index *, git_repository *)
/* 417 */ _CFFI_OP(_CFFI_OP_NOOP, 403),
/* 418 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 419 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 420 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 421 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_oid *, git_repository *, char const *, git_object_t, char const *)
/* 422 */ _CFFI_OP(_CFFI_OP_NOOP, 403),
/* 423 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 424 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 425 */ _CFFI_OP(_CFFI_OP_ENUM, 16), // git_object_t
/* 426 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 427 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 428 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_oid *, git_repository *, git_signature const *, char const *, uint32_t)
/* 429 */ _CFFI_OP(_CFFI_OP_NOOP, 403),
/* 430 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 431 */ _CFFI_OP(_CFFI_OP_NOOP, 406),
/* 432 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 433 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 434 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 435 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_oid *, git_repository *, git_stash_save_options const *)
/* 436 */ _CFFI_OP(_CFFI_OP_NOOP, 403),
/* 437 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 438 */ _CFFI_OP(_CFFI_OP_POINTER, 932), // git_stash_save_options const *
/* 439 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 440 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_packbuilder * *, git_repository *)
/* 441 */ _CFFI_OP(_CFFI_OP_POINTER, 445), // git_packbuilder * *
/* 442 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 443 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 444 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_packbuilder *, char const *, unsigned int, int(*)(git_indexer_progress const *, void *), void *)
/* 445 */ _CFFI_OP(_CFFI_OP_POINTER, 905), // git_packbuilder *
/* 446 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 447 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 448 */ _CFFI_OP(_CFFI_OP_POINTER, 386), // int(*)(git_indexer_progress const *, void *)
/* 449 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 450 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 451 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_packbuilder *, git_oid const *, char const *)
/* 452 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 453 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 454 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 455 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 456 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_proxy_options *, unsigned int)
/* 457 */ _CFFI_OP(_CFFI_OP_POINTER, 906), // git_proxy_options *
/* 458 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 459 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 460 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_push_options *, unsigned int)
/* 461 */ _CFFI_OP(_CFFI_OP_POINTER, 908), // git_push_options *
/* 462 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 463 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 464 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_push_update const * *, size_t, void *)
/* 465 */ _CFFI_OP(_CFFI_OP_POINTER, 909), // git_push_update const * *
/* 466 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 467 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 468 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 469 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_refspec const *)
/* 470 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 471 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 472 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_refspec const *, char const *)
/* 473 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 474 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 475 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 476 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_remote * *, git_repository *, char const *)
/* 477 */ _CFFI_OP(_CFFI_OP_POINTER, 35), // git_remote * *
/* 478 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 479 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 480 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 481 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_remote * *, git_repository *, char const *, char const *)
/* 482 */ _CFFI_OP(_CFFI_OP_NOOP, 477),
/* 483 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 484 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 485 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 486 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 487 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_remote * *, git_repository *, char const *, char const *, char const *)
/* 488 */ _CFFI_OP(_CFFI_OP_NOOP, 477),
/* 489 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 490 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 491 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 492 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 493 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 494 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_remote * *, git_repository *, char const *, char const *, void *)
/* 495 */ _CFFI_OP(_CFFI_OP_NOOP, 477),
/* 496 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 497 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 498 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 499 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 500 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 501 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_remote *, git_remote_callbacks const *)
/* 502 */ _CFFI_OP(_CFFI_OP_NOOP, 35),
/* 503 */ _CFFI_OP(_CFFI_OP_POINTER, 915), // git_remote_callbacks const *
/* 504 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 505 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_remote *, git_strarray const *, git_fetch_options const *, char const *)
/* 506 */ _CFFI_OP(_CFFI_OP_NOOP, 35),
/* 507 */ _CFFI_OP(_CFFI_OP_NOOP, 347),
/* 508 */ _CFFI_OP(_CFFI_OP_POINTER, 888), // git_fetch_options const *
/* 509 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 510 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 511 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_remote *, git_strarray const *, git_push_options const *)
/* 512 */ _CFFI_OP(_CFFI_OP_NOOP, 35),
/* 513 */ _CFFI_OP(_CFFI_OP_NOOP, 347),
/* 514 */ _CFFI_OP(_CFFI_OP_POINTER, 908), // git_push_options const *
/* 515 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 516 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_remote *, int, git_remote_callbacks const *, git_proxy_options const *, git_strarray const *)
/* 517 */ _CFFI_OP(_CFFI_OP_NOOP, 35),
/* 518 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 519 */ _CFFI_OP(_CFFI_OP_NOOP, 503),
/* 520 */ _CFFI_OP(_CFFI_OP_POINTER, 906), // git_proxy_options const *
/* 521 */ _CFFI_OP(_CFFI_OP_NOOP, 347),
/* 522 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 523 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_remote *, int, void *)
/* 524 */ _CFFI_OP(_CFFI_OP_NOOP, 35),
/* 525 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 526 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 527 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 528 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_remote_callbacks *, unsigned int)
/* 529 */ _CFFI_OP(_CFFI_OP_POINTER, 915), // git_remote_callbacks *
/* 530 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 531 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 532 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_remote_completion_t, void *)
/* 533 */ _CFFI_OP(_CFFI_OP_ENUM, 31), // git_remote_completion_t
/* 534 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 535 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 536 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_remote_head const * * *, size_t *, git_remote *)
/* 537 */ _CFFI_OP(_CFFI_OP_POINTER, 916), // git_remote_head const * * *
/* 538 */ _CFFI_OP(_CFFI_OP_POINTER, 14), // size_t *
/* 539 */ _CFFI_OP(_CFFI_OP_NOOP, 35),
/* 540 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 541 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository * *, char const *, char const *, git_clone_options const *)
/* 542 */ _CFFI_OP(_CFFI_OP_POINTER, 45), // git_repository * *
/* 543 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 544 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 545 */ _CFFI_OP(_CFFI_OP_POINTER, 863), // git_clone_options const *
/* 546 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 547 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository * *, char const *, git_repository_init_options *)
/* 548 */ _CFFI_OP(_CFFI_OP_NOOP, 542),
/* 549 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 550 */ _CFFI_OP(_CFFI_OP_POINTER, 923), // git_repository_init_options *
/* 551 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 552 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository * *, char const *, int, void *)
/* 553 */ _CFFI_OP(_CFFI_OP_NOOP, 542),
/* 554 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 555 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 556 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 557 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 558 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository * *, char const *, unsigned int)
/* 559 */ _CFFI_OP(_CFFI_OP_NOOP, 542),
/* 560 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 561 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 562 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 563 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository * *, char const *, unsigned int, char const *)
/* 564 */ _CFFI_OP(_CFFI_OP_NOOP, 542),
/* 565 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 566 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 567 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 568 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 569 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository * *, git_submodule *)
/* 570 */ _CFFI_OP(_CFFI_OP_NOOP, 542),
/* 571 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 572 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 573 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository * *, git_submodule *, git_submodule_update_options const *)
/* 574 */ _CFFI_OP(_CFFI_OP_NOOP, 542),
/* 575 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 576 */ _CFFI_OP(_CFFI_OP_POINTER, 935), // git_submodule_update_options const *
/* 577 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 578 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository *)
/* 579 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 580 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 581 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository *, char const *)
/* 582 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 583 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 584 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 585 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository *, char const *, char const *)
/* 586 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 587 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 588 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 589 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 590 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository *, git_annotated_commit const * *, size_t, git_merge_options const *, git_checkout_options const *)
/* 591 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 592 */ _CFFI_OP(_CFFI_OP_POINTER, 846), // git_annotated_commit const * *
/* 593 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 594 */ _CFFI_OP(_CFFI_OP_NOOP, 306),
/* 595 */ _CFFI_OP(_CFFI_OP_POINTER, 860), // git_checkout_options const *
/* 596 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 597 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository *, git_checkout_options const *)
/* 598 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 599 */ _CFFI_OP(_CFFI_OP_NOOP, 595),
/* 600 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 601 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository *, git_commit *, git_revert_options const *)
/* 602 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 603 */ _CFFI_OP(_CFFI_OP_NOOP, 303),
/* 604 */ _CFFI_OP(_CFFI_OP_POINTER, 926), // git_revert_options const *
/* 605 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 606 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository *, git_index *, git_checkout_options const *)
/* 607 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 608 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 609 */ _CFFI_OP(_CFFI_OP_NOOP, 595),
/* 610 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 611 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository *, git_object const *, git_checkout_options const *)
/* 612 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 613 */ _CFFI_OP(_CFFI_OP_POINTER, 902), // git_object const *
/* 614 */ _CFFI_OP(_CFFI_OP_NOOP, 595),
/* 615 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 616 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository *, git_oid const *)
/* 617 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 618 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 619 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 620 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository *, int(*)(size_t, char const *, git_oid const *, void *), void *)
/* 621 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 622 */ _CFFI_OP(_CFFI_OP_POINTER, 732), // int(*)(size_t, char const *, git_oid const *, void *)
/* 623 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 624 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 625 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository *, size_t)
/* 626 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 627 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 628 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 629 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository *, size_t, git_stash_apply_options const *)
/* 630 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 631 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 632 */ _CFFI_OP(_CFFI_OP_POINTER, 930), // git_stash_apply_options const *
/* 633 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 634 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_repository_init_options *, unsigned int)
/* 635 */ _CFFI_OP(_CFFI_OP_NOOP, 550),
/* 636 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 637 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 638 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_stash_apply_options *, unsigned int)
/* 639 */ _CFFI_OP(_CFFI_OP_POINTER, 930), // git_stash_apply_options *
/* 640 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 641 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 642 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_stash_apply_progress_t, void *)
/* 643 */ _CFFI_OP(_CFFI_OP_ENUM, 27), // git_stash_apply_progress_t
/* 644 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 645 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 646 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_stash_save_options *, unsigned int)
/* 647 */ _CFFI_OP(_CFFI_OP_POINTER, 932), // git_stash_save_options *
/* 648 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 649 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 650 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_strarray *, git_remote const *)
/* 651 */ _CFFI_OP(_CFFI_OP_POINTER, 933), // git_strarray *
/* 652 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 653 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 654 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_strarray *, git_repository *)
/* 655 */ _CFFI_OP(_CFFI_OP_NOOP, 651),
/* 656 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 657 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 658 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_strarray *, git_repository *, char const *, char const *)
/* 659 */ _CFFI_OP(_CFFI_OP_NOOP, 651),
/* 660 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 661 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 662 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 663 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 664 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_submodule * *, git_repository *, char const *)
/* 665 */ _CFFI_OP(_CFFI_OP_POINTER, 7), // git_submodule * *
/* 666 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 667 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 668 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 669 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_submodule * *, git_repository *, char const *, char const *, int)
/* 670 */ _CFFI_OP(_CFFI_OP_NOOP, 665),
/* 671 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 672 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 673 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 674 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 675 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 676 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_submodule *)
/* 677 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 678 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 679 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_submodule *, int)
/* 680 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 681 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 682 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 683 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_submodule *, int, git_submodule_update_options *)
/* 684 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 685 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 686 */ _CFFI_OP(_CFFI_OP_POINTER, 935), // git_submodule_update_options *
/* 687 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 688 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_submodule_update_options *, unsigned int)
/* 689 */ _CFFI_OP(_CFFI_OP_NOOP, 686),
/* 690 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 691 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 692 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(git_transport * *, git_remote *, void *)
/* 693 */ _CFFI_OP(_CFFI_OP_POINTER, 937), // git_transport * *
/* 694 */ _CFFI_OP(_CFFI_OP_NOOP, 35),
/* 695 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 696 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 697 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(int *, char const *)
/* 698 */ _CFFI_OP(_CFFI_OP_POINTER, 28), // int *
/* 699 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 700 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 701 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(int *, void *, void *, void *)
/* 702 */ _CFFI_OP(_CFFI_OP_NOOP, 698),
/* 703 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 704 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 705 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 706 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 707 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(int, ...)
/* 708 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 709 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 1),
/* 710 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(int, uint32_t, uint32_t, void *)
/* 711 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 712 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 713 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 714 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 715 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 716 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(int64_t *, char const *)
/* 717 */ _CFFI_OP(_CFFI_OP_POINTER, 197), // int64_t *
/* 718 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 719 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 720 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(size_t *, git_index *, char const *)
/* 721 */ _CFFI_OP(_CFFI_OP_NOOP, 538),
/* 722 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 723 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 724 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 725 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(size_t *, size_t *, git_repository *, git_oid const *, git_oid const *)
/* 726 */ _CFFI_OP(_CFFI_OP_NOOP, 538),
/* 727 */ _CFFI_OP(_CFFI_OP_NOOP, 538),
/* 728 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 729 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 730 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 731 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 732 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(size_t, char const *, git_oid const *, void *)
/* 733 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 734 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 735 */ _CFFI_OP(_CFFI_OP_NOOP, 71),
/* 736 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 737 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 738 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(unsigned int *, git_repository *, char const *, git_submodule_ignore_t)
/* 739 */ _CFFI_OP(_CFFI_OP_POINTER, 105), // unsigned int *
/* 740 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 741 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 742 */ _CFFI_OP(_CFFI_OP_ENUM, 29), // git_submodule_ignore_t
/* 743 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 744 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(unsigned int, unsigned int, size_t, void *)
/* 745 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 746 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 747 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 748 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 749 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 750 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(void * *, git_diff_file const *, char const *, size_t, void *)
/* 751 */ _CFFI_OP(_CFFI_OP_POINTER, 67), // void * *
/* 752 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 753 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 754 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 755 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 756 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 757 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(void * *, git_diff_file const *, char const *, void *)
/* 758 */ _CFFI_OP(_CFFI_OP_NOOP, 751),
/* 759 */ _CFFI_OP(_CFFI_OP_NOOP, 139),
/* 760 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 761 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 762 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 763 */ _CFFI_OP(_CFFI_OP_FUNCTION, 28), // int()(void)
/* 764 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 765 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // size_t()(git_index const *)
/* 766 */ _CFFI_OP(_CFFI_OP_NOOP, 367),
/* 767 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 768 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // size_t()(git_packbuilder *)
/* 769 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 770 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 771 */ _CFFI_OP(_CFFI_OP_FUNCTION, 14), // size_t()(git_remote const *)
/* 772 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 773 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 774 */ _CFFI_OP(_CFFI_OP_FUNCTION, 18), // uint32_t()(git_blame *)
/* 775 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 776 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 777 */ _CFFI_OP(_CFFI_OP_FUNCTION, 18), // uint32_t()(git_packbuilder *)
/* 778 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 779 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 780 */ _CFFI_OP(_CFFI_OP_FUNCTION, 105), // unsigned int()(git_packbuilder *, unsigned int)
/* 781 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 782 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 783 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 784 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(char const *, size_t, size_t, void *)
/* 785 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 786 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 787 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 788 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 789 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 790 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_annotated_commit *)
/* 791 */ _CFFI_OP(_CFFI_OP_POINTER, 847), // git_annotated_commit *
/* 792 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 793 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_blame *)
/* 794 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 795 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 796 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_buf *)
/* 797 */ _CFFI_OP(_CFFI_OP_NOOP, 108),
/* 798 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 799 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_checkout_perfdata const *, void *)
/* 800 */ _CFFI_OP(_CFFI_OP_POINTER, 861), // git_checkout_perfdata const *
/* 801 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 802 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 803 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_config *)
/* 804 */ _CFFI_OP(_CFFI_OP_NOOP, 161),
/* 805 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 806 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_config_entry *)
/* 807 */ _CFFI_OP(_CFFI_OP_POINTER, 866), // git_config_entry *
/* 808 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 809 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_config_iterator *)
/* 810 */ _CFFI_OP(_CFFI_OP_NOOP, 206),
/* 811 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 812 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_describe_result *)
/* 813 */ _CFFI_OP(_CFFI_OP_POINTER, 874), // git_describe_result *
/* 814 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 815 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_index *)
/* 816 */ _CFFI_OP(_CFFI_OP_NOOP, 26),
/* 817 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 818 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_index_conflict_iterator *)
/* 819 */ _CFFI_OP(_CFFI_OP_NOOP, 384),
/* 820 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 821 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_merge_file_result *)
/* 822 */ _CFFI_OP(_CFFI_OP_NOOP, 391),
/* 823 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 824 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_packbuilder *)
/* 825 */ _CFFI_OP(_CFFI_OP_NOOP, 445),
/* 826 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 827 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_remote *)
/* 828 */ _CFFI_OP(_CFFI_OP_NOOP, 35),
/* 829 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 830 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_repository *)
/* 831 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 832 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 833 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_strarray *)
/* 834 */ _CFFI_OP(_CFFI_OP_NOOP, 651),
/* 835 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 836 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(git_submodule *)
/* 837 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 838 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 839 */ _CFFI_OP(_CFFI_OP_FUNCTION, 974), // void()(void *, void *)
/* 840 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 841 */ _CFFI_OP(_CFFI_OP_NOOP, 67),
/* 842 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 843 */ _CFFI_OP(_CFFI_OP_POINTER, 844), // char * *
/* 844 */ _CFFI_OP(_CFFI_OP_POINTER, 845), // char *
/* 845 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 846 */ _CFFI_OP(_CFFI_OP_POINTER, 847), // git_annotated_commit const *
/* 847 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 22), // git_annotated_commit
/* 848 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // git_attr_options
/* 849 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // git_attr_value_t
/* 850 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 23), // git_blame
/* 851 */ _CFFI_OP(_CFFI_OP_POINTER, 852), // git_blame_hunk const *
/* 852 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 24), // git_blame_hunk
/* 853 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 25), // git_blame_options
/* 854 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // git_buf
/* 855 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // git_cert
/* 856 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // git_cert_hostkey
/* 857 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // git_cert_ssh_t
/* 858 */ _CFFI_OP(_CFFI_OP_ENUM, 30), // git_cert_t
/* 859 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // git_cert_x509
/* 860 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 26), // git_checkout_options
/* 861 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // git_checkout_perfdata
/* 862 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // git_clone_local_t
/* 863 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 27), // git_clone_options
/* 864 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 28), // git_commit
/* 865 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 29), // git_config
/* 866 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 30), // git_config_entry
/* 867 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 31), // git_config_iterator
/* 868 */ _CFFI_OP(_CFFI_OP_POINTER, 869), // git_credential *
/* 869 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 32), // git_credential
/* 870 */ _CFFI_OP(_CFFI_OP_ENUM, 5), // git_credential_t
/* 871 */ _CFFI_OP(_CFFI_OP_ENUM, 6), // git_delta_t
/* 872 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // git_describe_format_options
/* 873 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 33), // git_describe_options
/* 874 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 34), // git_describe_result
/* 875 */ _CFFI_OP(_CFFI_OP_ENUM, 7), // git_describe_strategy_t
/* 876 */ _CFFI_OP(_CFFI_OP_POINTER, 877), // git_diff *
/* 877 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 35), // git_diff
/* 878 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // git_diff_delta
/* 879 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // git_diff_file
/* 880 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // git_diff_options
/* 881 */ _CFFI_OP(_CFFI_OP_POINTER, 882), // git_diff_similarity_metric *
/* 882 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // git_diff_similarity_metric
/* 883 */ _CFFI_OP(_CFFI_OP_ENUM, 8), // git_direction
/* 884 */ _CFFI_OP(_CFFI_OP_POINTER, 885), // git_error const *
/* 885 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // git_error
/* 886 */ _CFFI_OP(_CFFI_OP_ENUM, 9), // git_error_code
/* 887 */ _CFFI_OP(_CFFI_OP_ENUM, 10), // git_feature_t
/* 888 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // git_fetch_options
/* 889 */ _CFFI_OP(_CFFI_OP_ENUM, 11), // git_fetch_prune_t
/* 890 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 36), // git_index
/* 891 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 37), // git_index_conflict_iterator
/* 892 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 38), // git_index_entry
/* 893 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // git_index_time
/* 894 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 39), // git_indexer_progress
/* 895 */ _CFFI_OP(_CFFI_OP_ENUM, 12), // git_libgit2_opt_t
/* 896 */ _CFFI_OP(_CFFI_OP_ENUM, 13), // git_merge_file_favor_t
/* 897 */ _CFFI_OP(_CFFI_OP_ENUM, 14), // git_merge_file_flag_t
/* 898 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // git_merge_file_options
/* 899 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // git_merge_file_result
/* 900 */ _CFFI_OP(_CFFI_OP_ENUM, 15), // git_merge_flag_t
/* 901 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // git_merge_options
/* 902 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 40), // git_object
/* 903 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 41), // git_oid
/* 904 */ _CFFI_OP(_CFFI_OP_ENUM, 17), // git_oid_t
/* 905 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 42), // git_packbuilder
/* 906 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 17), // git_proxy_options
/* 907 */ _CFFI_OP(_CFFI_OP_ENUM, 18), // git_proxy_t
/* 908 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 18), // git_push_options
/* 909 */ _CFFI_OP(_CFFI_OP_POINTER, 910), // git_push_update const *
/* 910 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 19), // git_push_update
/* 911 */ _CFFI_OP(_CFFI_OP_ENUM, 19), // git_reference_t
/* 912 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 44), // git_refspec
/* 913 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 45), // git_remote
/* 914 */ _CFFI_OP(_CFFI_OP_ENUM, 20), // git_remote_autotag_option_t
/* 915 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 46), // git_remote_callbacks
/* 916 */ _CFFI_OP(_CFFI_OP_POINTER, 917), // git_remote_head const * *
/* 917 */ _CFFI_OP(_CFFI_OP_POINTER, 918), // git_remote_head const *
/* 918 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 47), // git_remote_head
/* 919 */ _CFFI_OP(_CFFI_OP_ENUM, 21), // git_remote_redirect_t
/* 920 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 48), // git_repository
/* 921 */ _CFFI_OP(_CFFI_OP_ENUM, 22), // git_repository_init_flag_t
/* 922 */ _CFFI_OP(_CFFI_OP_ENUM, 23), // git_repository_init_mode_t
/* 923 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 20), // git_repository_init_options
/* 924 */ _CFFI_OP(_CFFI_OP_ENUM, 24), // git_repository_open_flag_t
/* 925 */ _CFFI_OP(_CFFI_OP_ENUM, 25), // git_repository_state_t
/* 926 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 21), // git_revert_options
/* 927 */ _CFFI_OP(_CFFI_OP_POINTER, 928), // git_signature *
/* 928 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 49), // git_signature
/* 929 */ _CFFI_OP(_CFFI_OP_ENUM, 26), // git_stash_apply_flags
/* 930 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 50), // git_stash_apply_options
/* 931 */ _CFFI_OP(_CFFI_OP_ENUM, 28), // git_stash_flags
/* 932 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 51), // git_stash_save_options
/* 933 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 52), // git_strarray
/* 934 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 53), // git_submodule
/* 935 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 54), // git_submodule_update_options
/* 936 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 55), // git_time
/* 937 */ _CFFI_OP(_CFFI_OP_POINTER, 938), // git_transport *
/* 938 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 56), // git_transport
/* 939 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 57), // git_tree
/* 940 */ _CFFI_OP(_CFFI_OP_POINTER, 69), // int(*)(char const *, git_oid const *, git_oid const *, git_refspec *, void *)
/* 941 */ _CFFI_OP(_CFFI_OP_POINTER, 76), // int(*)(char const *, git_oid const *, git_oid const *, void *)
/* 942 */ _CFFI_OP(_CFFI_OP_POINTER, 82), // int(*)(char const *, int, void *)
/* 943 */ _CFFI_OP(_CFFI_OP_POINTER, 110), // int(*)(git_buf *, char const *, int, void *)
/* 944 */ _CFFI_OP(_CFFI_OP_POINTER, 130), // int(*)(git_cert *, int, char const *, void *)
/* 945 */ _CFFI_OP(_CFFI_OP_POINTER, 136), // int(*)(git_checkout_notify_t, char const *, git_diff_file const *, git_diff_file const *, git_diff_file const *, void *)
/* 946 */ _CFFI_OP(_CFFI_OP_POINTER, 234), // int(*)(git_credential * *, char const *, char const *, unsigned int, void *)
/* 947 */ _CFFI_OP(_CFFI_OP_POINTER, 272), // int(*)(git_diff const *, char const *, char const *, void *)
/* 948 */ _CFFI_OP(_CFFI_OP_POINTER, 278), // int(*)(git_diff const *, git_diff_delta const *, char const *, void *)
/* 949 */ _CFFI_OP(_CFFI_OP_POINTER, 464), // int(*)(git_push_update const * *, size_t, void *)
/* 950 */ _CFFI_OP(_CFFI_OP_POINTER, 494), // int(*)(git_remote * *, git_repository *, char const *, char const *, void *)
/* 951 */ _CFFI_OP(_CFFI_OP_POINTER, 523), // int(*)(git_remote *, int, void *)
/* 952 */ _CFFI_OP(_CFFI_OP_POINTER, 532), // int(*)(git_remote_completion_t, void *)
/* 953 */ _CFFI_OP(_CFFI_OP_POINTER, 552), // int(*)(git_repository * *, char const *, int, void *)
/* 954 */ _CFFI_OP(_CFFI_OP_POINTER, 642), // int(*)(git_stash_apply_progress_t, void *)
/* 955 */ _CFFI_OP(_CFFI_OP_POINTER, 692), // int(*)(git_transport * *, git_remote *, void *)
/* 956 */ _CFFI_OP(_CFFI_OP_POINTER, 701), // int(*)(int *, void *, void *, void *)
/* 957 */ _CFFI_OP(_CFFI_OP_POINTER, 707), // int(*)(int, ...)
/* 958 */ _CFFI_OP(_CFFI_OP_POINTER, 710), // int(*)(int, uint32_t, uint32_t, void *)
/* 959 */ _CFFI_OP(_CFFI_OP_POINTER, 744), // int(*)(unsigned int, unsigned int, size_t, void *)
/* 960 */ _CFFI_OP(_CFFI_OP_POINTER, 750), // int(*)(void * *, git_diff_file const *, char const *, size_t, void *)
/* 961 */ _CFFI_OP(_CFFI_OP_POINTER, 757), // int(*)(void * *, git_diff_file const *, char const *, void *)
/* 962 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 21), // int32_t
/* 963 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 43), // struct git_reference
/* 964 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20), // uint16_t
/* 965 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4), // unsigned char
/* 966 */ _CFFI_OP(_CFFI_OP_ARRAY, 965), // unsigned char[16]
/* 967 */ (_cffi_opcode_t)(16),
/* 968 */ _CFFI_OP(_CFFI_OP_ARRAY, 965), // unsigned char[20]
/* 969 */ (_cffi_opcode_t)(20),
/* 970 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 6), // unsigned short
/* 971 */ _CFFI_OP(_CFFI_OP_POINTER, 784), // void(*)(char const *, size_t, size_t, void *)
/* 972 */ _CFFI_OP(_CFFI_OP_POINTER, 799), // void(*)(git_checkout_perfdata const *, void *)
/* 973 */ _CFFI_OP(_CFFI_OP_POINTER, 839), // void(*)(void *, void *)
/* 974 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_attr_options(git_attr_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_attr_options.version' is an integer */
  (void)((p->flags) | 0);  /* check that 'git_attr_options.flags' is an integer */
  { git_oid * *tmp = &p->commit_id; (void)tmp; }
  { git_oid *tmp = &p->attr_commit_id; (void)tmp; }
}
struct _cffi_align_typedef_git_attr_options { char x; git_attr_options y; };

static int _cffi_const_GIT_ATTR_VALUE_UNSPECIFIED(unsigned long long *o)
{
  int n = (GIT_ATTR_VALUE_UNSPECIFIED) <= 0;
  *o = (unsigned long long)((GIT_ATTR_VALUE_UNSPECIFIED) | 0);  /* check that GIT_ATTR_VALUE_UNSPECIFIED is an integer */
  return n;
}

static int _cffi_const_GIT_ATTR_VALUE_TRUE(unsigned long long *o)
{
  int n = (GIT_ATTR_VALUE_TRUE) <= 0;
  *o = (unsigned long long)((GIT_ATTR_VALUE_TRUE) | 0);  /* check that GIT_ATTR_VALUE_TRUE is an integer */
  return n;
}

static int _cffi_const_GIT_ATTR_VALUE_FALSE(unsigned long long *o)
{
  int n = (GIT_ATTR_VALUE_FALSE) <= 0;
  *o = (unsigned long long)((GIT_ATTR_VALUE_FALSE) | 0);  /* check that GIT_ATTR_VALUE_FALSE is an integer */
  return n;
}

static int _cffi_const_GIT_ATTR_VALUE_STRING(unsigned long long *o)
{
  int n = (GIT_ATTR_VALUE_STRING) <= 0;
  *o = (unsigned long long)((GIT_ATTR_VALUE_STRING) | 0);  /* check that GIT_ATTR_VALUE_STRING is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_buf(git_buf *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char * *tmp = &p->ptr; (void)tmp; }
  (void)((p->reserved) | 0);  /* check that 'git_buf.reserved' is an integer */
  (void)((p->size) | 0);  /* check that 'git_buf.size' is an integer */
}
struct _cffi_align_typedef_git_buf { char x; git_buf y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_cert(git_cert *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { git_cert_t *tmp = &p->cert_type; (void)tmp; }
}
struct _cffi_align_typedef_git_cert { char x; git_cert y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_cert_hostkey(git_cert_hostkey *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { git_cert *tmp = &p->parent; (void)tmp; }
  { git_cert_ssh_t *tmp = &p->type; (void)tmp; }
  { unsigned char(*tmp)[16] = &p->hash_md5; (void)tmp; }
  { unsigned char(*tmp)[20] = &p->hash_sha1; (void)tmp; }
}
struct _cffi_align_typedef_git_cert_hostkey { char x; git_cert_hostkey y; };

static int _cffi_const_GIT_CERT_SSH_MD5(unsigned long long *o)
{
  int n = (GIT_CERT_SSH_MD5) <= 0;
  *o = (unsigned long long)((GIT_CERT_SSH_MD5) | 0);  /* check that GIT_CERT_SSH_MD5 is an integer */
  return n;
}

static int _cffi_const_GIT_CERT_SSH_SHA1(unsigned long long *o)
{
  int n = (GIT_CERT_SSH_SHA1) <= 0;
  *o = (unsigned long long)((GIT_CERT_SSH_SHA1) | 0);  /* check that GIT_CERT_SSH_SHA1 is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_cert_x509(git_cert_x509 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { git_cert *tmp = &p->parent; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
  (void)((p->len) | 0);  /* check that 'git_cert_x509.len' is an integer */
}
struct _cffi_align_typedef_git_cert_x509 { char x; git_cert_x509 y; };

static int _cffi_const_GIT_CHECKOUT_NOTIFY_NONE(unsigned long long *o)
{
  int n = (GIT_CHECKOUT_NOTIFY_NONE) <= 0;
  *o = (unsigned long long)((GIT_CHECKOUT_NOTIFY_NONE) | 0);  /* check that GIT_CHECKOUT_NOTIFY_NONE is an integer */
  return n;
}

static int _cffi_const_GIT_CHECKOUT_NOTIFY_CONFLICT(unsigned long long *o)
{
  int n = (GIT_CHECKOUT_NOTIFY_CONFLICT) <= 0;
  *o = (unsigned long long)((GIT_CHECKOUT_NOTIFY_CONFLICT) | 0);  /* check that GIT_CHECKOUT_NOTIFY_CONFLICT is an integer */
  return n;
}

static int _cffi_const_GIT_CHECKOUT_NOTIFY_DIRTY(unsigned long long *o)
{
  int n = (GIT_CHECKOUT_NOTIFY_DIRTY) <= 0;
  *o = (unsigned long long)((GIT_CHECKOUT_NOTIFY_DIRTY) | 0);  /* check that GIT_CHECKOUT_NOTIFY_DIRTY is an integer */
  return n;
}

static int _cffi_const_GIT_CHECKOUT_NOTIFY_UPDATED(unsigned long long *o)
{
  int n = (GIT_CHECKOUT_NOTIFY_UPDATED) <= 0;
  *o = (unsigned long long)((GIT_CHECKOUT_NOTIFY_UPDATED) | 0);  /* check that GIT_CHECKOUT_NOTIFY_UPDATED is an integer */
  return n;
}

static int _cffi_const_GIT_CHECKOUT_NOTIFY_UNTRACKED(unsigned long long *o)
{
  int n = (GIT_CHECKOUT_NOTIFY_UNTRACKED) <= 0;
  *o = (unsigned long long)((GIT_CHECKOUT_NOTIFY_UNTRACKED) | 0);  /* check that GIT_CHECKOUT_NOTIFY_UNTRACKED is an integer */
  return n;
}

static int _cffi_const_GIT_CHECKOUT_NOTIFY_IGNORED(unsigned long long *o)
{
  int n = (GIT_CHECKOUT_NOTIFY_IGNORED) <= 0;
  *o = (unsigned long long)((GIT_CHECKOUT_NOTIFY_IGNORED) | 0);  /* check that GIT_CHECKOUT_NOTIFY_IGNORED is an integer */
  return n;
}

static int _cffi_const_GIT_CHECKOUT_NOTIFY_ALL(unsigned long long *o)
{
  int n = (GIT_CHECKOUT_NOTIFY_ALL) <= 0;
  *o = (unsigned long long)((GIT_CHECKOUT_NOTIFY_ALL) | 0);  /* check that GIT_CHECKOUT_NOTIFY_ALL is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_checkout_perfdata(git_checkout_perfdata *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->mkdir_calls) | 0);  /* check that 'git_checkout_perfdata.mkdir_calls' is an integer */
  (void)((p->stat_calls) | 0);  /* check that 'git_checkout_perfdata.stat_calls' is an integer */
  (void)((p->chmod_calls) | 0);  /* check that 'git_checkout_perfdata.chmod_calls' is an integer */
}
struct _cffi_align_typedef_git_checkout_perfdata { char x; git_checkout_perfdata y; };

static int _cffi_const_GIT_CLONE_LOCAL_AUTO(unsigned long long *o)
{
  int n = (GIT_CLONE_LOCAL_AUTO) <= 0;
  *o = (unsigned long long)((GIT_CLONE_LOCAL_AUTO) | 0);  /* check that GIT_CLONE_LOCAL_AUTO is an integer */
  return n;
}

static int _cffi_const_GIT_CLONE_LOCAL(unsigned long long *o)
{
  int n = (GIT_CLONE_LOCAL) <= 0;
  *o = (unsigned long long)((GIT_CLONE_LOCAL) | 0);  /* check that GIT_CLONE_LOCAL is an integer */
  return n;
}

static int _cffi_const_GIT_CLONE_NO_LOCAL(unsigned long long *o)
{
  int n = (GIT_CLONE_NO_LOCAL) <= 0;
  *o = (unsigned long long)((GIT_CLONE_NO_LOCAL) | 0);  /* check that GIT_CLONE_NO_LOCAL is an integer */
  return n;
}

static int _cffi_const_GIT_CLONE_LOCAL_NO_LINKS(unsigned long long *o)
{
  int n = (GIT_CLONE_LOCAL_NO_LINKS) <= 0;
  *o = (unsigned long long)((GIT_CLONE_LOCAL_NO_LINKS) | 0);  /* check that GIT_CLONE_LOCAL_NO_LINKS is an integer */
  return n;
}

static int _cffi_const_GIT_CONFIG_LEVEL_PROGRAMDATA(unsigned long long *o)
{
  int n = (GIT_CONFIG_LEVEL_PROGRAMDATA) <= 0;
  *o = (unsigned long long)((GIT_CONFIG_LEVEL_PROGRAMDATA) | 0);  /* check that GIT_CONFIG_LEVEL_PROGRAMDATA is an integer */
  return n;
}

static int _cffi_const_GIT_CONFIG_LEVEL_SYSTEM(unsigned long long *o)
{
  int n = (GIT_CONFIG_LEVEL_SYSTEM) <= 0;
  *o = (unsigned long long)((GIT_CONFIG_LEVEL_SYSTEM) | 0);  /* check that GIT_CONFIG_LEVEL_SYSTEM is an integer */
  return n;
}

static int _cffi_const_GIT_CONFIG_LEVEL_XDG(unsigned long long *o)
{
  int n = (GIT_CONFIG_LEVEL_XDG) <= 0;
  *o = (unsigned long long)((GIT_CONFIG_LEVEL_XDG) | 0);  /* check that GIT_CONFIG_LEVEL_XDG is an integer */
  return n;
}

static int _cffi_const_GIT_CONFIG_LEVEL_GLOBAL(unsigned long long *o)
{
  int n = (GIT_CONFIG_LEVEL_GLOBAL) <= 0;
  *o = (unsigned long long)((GIT_CONFIG_LEVEL_GLOBAL) | 0);  /* check that GIT_CONFIG_LEVEL_GLOBAL is an integer */
  return n;
}

static int _cffi_const_GIT_CONFIG_LEVEL_LOCAL(unsigned long long *o)
{
  int n = (GIT_CONFIG_LEVEL_LOCAL) <= 0;
  *o = (unsigned long long)((GIT_CONFIG_LEVEL_LOCAL) | 0);  /* check that GIT_CONFIG_LEVEL_LOCAL is an integer */
  return n;
}

static int _cffi_const_GIT_CONFIG_LEVEL_WORKTREE(unsigned long long *o)
{
  int n = (GIT_CONFIG_LEVEL_WORKTREE) <= 0;
  *o = (unsigned long long)((GIT_CONFIG_LEVEL_WORKTREE) | 0);  /* check that GIT_CONFIG_LEVEL_WORKTREE is an integer */
  return n;
}

static int _cffi_const_GIT_CONFIG_LEVEL_APP(unsigned long long *o)
{
  int n = (GIT_CONFIG_LEVEL_APP) <= 0;
  *o = (unsigned long long)((GIT_CONFIG_LEVEL_APP) | 0);  /* check that GIT_CONFIG_LEVEL_APP is an integer */
  return n;
}

static int _cffi_const_GIT_CONFIG_HIGHEST_LEVEL(unsigned long long *o)
{
  int n = (GIT_CONFIG_HIGHEST_LEVEL) <= 0;
  *o = (unsigned long long)((GIT_CONFIG_HIGHEST_LEVEL) | 0);  /* check that GIT_CONFIG_HIGHEST_LEVEL is an integer */
  return n;
}

static int _cffi_const_GIT_CREDENTIAL_USERPASS_PLAINTEXT(unsigned long long *o)
{
  int n = (GIT_CREDENTIAL_USERPASS_PLAINTEXT) <= 0;
  *o = (unsigned long long)((GIT_CREDENTIAL_USERPASS_PLAINTEXT) | 0);  /* check that GIT_CREDENTIAL_USERPASS_PLAINTEXT is an integer */
  return n;
}

static int _cffi_const_GIT_CREDENTIAL_SSH_KEY(unsigned long long *o)
{
  int n = (GIT_CREDENTIAL_SSH_KEY) <= 0;
  *o = (unsigned long long)((GIT_CREDENTIAL_SSH_KEY) | 0);  /* check that GIT_CREDENTIAL_SSH_KEY is an integer */
  return n;
}

static int _cffi_const_GIT_CREDENTIAL_SSH_CUSTOM(unsigned long long *o)
{
  int n = (GIT_CREDENTIAL_SSH_CUSTOM) <= 0;
  *o = (unsigned long long)((GIT_CREDENTIAL_SSH_CUSTOM) | 0);  /* check that GIT_CREDENTIAL_SSH_CUSTOM is an integer */
  return n;
}

static int _cffi_const_GIT_CREDENTIAL_DEFAULT(unsigned long long *o)
{
  int n = (GIT_CREDENTIAL_DEFAULT) <= 0;
  *o = (unsigned long long)((GIT_CREDENTIAL_DEFAULT) | 0);  /* check that GIT_CREDENTIAL_DEFAULT is an integer */
  return n;
}

static int _cffi_const_GIT_CREDENTIAL_SSH_INTERACTIVE(unsigned long long *o)
{
  int n = (GIT_CREDENTIAL_SSH_INTERACTIVE) <= 0;
  *o = (unsigned long long)((GIT_CREDENTIAL_SSH_INTERACTIVE) | 0);  /* check that GIT_CREDENTIAL_SSH_INTERACTIVE is an integer */
  return n;
}

static int _cffi_const_GIT_CREDENTIAL_USERNAME(unsigned long long *o)
{
  int n = (GIT_CREDENTIAL_USERNAME) <= 0;
  *o = (unsigned long long)((GIT_CREDENTIAL_USERNAME) | 0);  /* check that GIT_CREDENTIAL_USERNAME is an integer */
  return n;
}

static int _cffi_const_GIT_CREDENTIAL_SSH_MEMORY(unsigned long long *o)
{
  int n = (GIT_CREDENTIAL_SSH_MEMORY) <= 0;
  *o = (unsigned long long)((GIT_CREDENTIAL_SSH_MEMORY) | 0);  /* check that GIT_CREDENTIAL_SSH_MEMORY is an integer */
  return n;
}

static int _cffi_const_GIT_DELTA_UNMODIFIED(unsigned long long *o)
{
  int n = (GIT_DELTA_UNMODIFIED) <= 0;
  *o = (unsigned long long)((GIT_DELTA_UNMODIFIED) | 0);  /* check that GIT_DELTA_UNMODIFIED is an integer */
  return n;
}

static int _cffi_const_GIT_DELTA_ADDED(unsigned long long *o)
{
  int n = (GIT_DELTA_ADDED) <= 0;
  *o = (unsigned long long)((GIT_DELTA_ADDED) | 0);  /* check that GIT_DELTA_ADDED is an integer */
  return n;
}

static int _cffi_const_GIT_DELTA_DELETED(unsigned long long *o)
{
  int n = (GIT_DELTA_DELETED) <= 0;
  *o = (unsigned long long)((GIT_DELTA_DELETED) | 0);  /* check that GIT_DELTA_DELETED is an integer */
  return n;
}

static int _cffi_const_GIT_DELTA_MODIFIED(unsigned long long *o)
{
  int n = (GIT_DELTA_MODIFIED) <= 0;
  *o = (unsigned long long)((GIT_DELTA_MODIFIED) | 0);  /* check that GIT_DELTA_MODIFIED is an integer */
  return n;
}

static int _cffi_const_GIT_DELTA_RENAMED(unsigned long long *o)
{
  int n = (GIT_DELTA_RENAMED) <= 0;
  *o = (unsigned long long)((GIT_DELTA_RENAMED) | 0);  /* check that GIT_DELTA_RENAMED is an integer */
  return n;
}

static int _cffi_const_GIT_DELTA_COPIED(unsigned long long *o)
{
  int n = (GIT_DELTA_COPIED) <= 0;
  *o = (unsigned long long)((GIT_DELTA_COPIED) | 0);  /* check that GIT_DELTA_COPIED is an integer */
  return n;
}

static int _cffi_const_GIT_DELTA_IGNORED(unsigned long long *o)
{
  int n = (GIT_DELTA_IGNORED) <= 0;
  *o = (unsigned long long)((GIT_DELTA_IGNORED) | 0);  /* check that GIT_DELTA_IGNORED is an integer */
  return n;
}

static int _cffi_const_GIT_DELTA_UNTRACKED(unsigned long long *o)
{
  int n = (GIT_DELTA_UNTRACKED) <= 0;
  *o = (unsigned long long)((GIT_DELTA_UNTRACKED) | 0);  /* check that GIT_DELTA_UNTRACKED is an integer */
  return n;
}

static int _cffi_const_GIT_DELTA_TYPECHANGE(unsigned long long *o)
{
  int n = (GIT_DELTA_TYPECHANGE) <= 0;
  *o = (unsigned long long)((GIT_DELTA_TYPECHANGE) | 0);  /* check that GIT_DELTA_TYPECHANGE is an integer */
  return n;
}

static int _cffi_const_GIT_DELTA_UNREADABLE(unsigned long long *o)
{
  int n = (GIT_DELTA_UNREADABLE) <= 0;
  *o = (unsigned long long)((GIT_DELTA_UNREADABLE) | 0);  /* check that GIT_DELTA_UNREADABLE is an integer */
  return n;
}

static int _cffi_const_GIT_DELTA_CONFLICTED(unsigned long long *o)
{
  int n = (GIT_DELTA_CONFLICTED) <= 0;
  *o = (unsigned long long)((GIT_DELTA_CONFLICTED) | 0);  /* check that GIT_DELTA_CONFLICTED is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_describe_format_options(git_describe_format_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_describe_format_options.version' is an integer */
  (void)((p->abbreviated_size) | 0);  /* check that 'git_describe_format_options.abbreviated_size' is an integer */
  (void)((p->always_use_long_format) | 0);  /* check that 'git_describe_format_options.always_use_long_format' is an integer */
  { char const * *tmp = &p->dirty_suffix; (void)tmp; }
}
struct _cffi_align_typedef_git_describe_format_options { char x; git_describe_format_options y; };

static int _cffi_const_GIT_DESCRIBE_DEFAULT(unsigned long long *o)
{
  int n = (GIT_DESCRIBE_DEFAULT) <= 0;
  *o = (unsigned long long)((GIT_DESCRIBE_DEFAULT) | 0);  /* check that GIT_DESCRIBE_DEFAULT is an integer */
  return n;
}

static int _cffi_const_GIT_DESCRIBE_TAGS(unsigned long long *o)
{
  int n = (GIT_DESCRIBE_TAGS) <= 0;
  *o = (unsigned long long)((GIT_DESCRIBE_TAGS) | 0);  /* check that GIT_DESCRIBE_TAGS is an integer */
  return n;
}

static int _cffi_const_GIT_DESCRIBE_ALL(unsigned long long *o)
{
  int n = (GIT_DESCRIBE_ALL) <= 0;
  *o = (unsigned long long)((GIT_DESCRIBE_ALL) | 0);  /* check that GIT_DESCRIBE_ALL is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_diff_delta(git_diff_delta *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { git_delta_t *tmp = &p->status; (void)tmp; }
  (void)((p->flags) | 0);  /* check that 'git_diff_delta.flags' is an integer */
  (void)((p->similarity) | 0);  /* check that 'git_diff_delta.similarity' is an integer */
  (void)((p->nfiles) | 0);  /* check that 'git_diff_delta.nfiles' is an integer */
  { git_diff_file *tmp = &p->old_file; (void)tmp; }
  { git_diff_file *tmp = &p->new_file; (void)tmp; }
}
struct _cffi_align_typedef_git_diff_delta { char x; git_diff_delta y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_diff_file(git_diff_file *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { git_oid *tmp = &p->id; (void)tmp; }
  { char const * *tmp = &p->path; (void)tmp; }
  (void)((p->size) | 0);  /* check that 'git_diff_file.size' is an integer */
  (void)((p->flags) | 0);  /* check that 'git_diff_file.flags' is an integer */
  (void)((p->mode) | 0);  /* check that 'git_diff_file.mode' is an integer */
  (void)((p->id_abbrev) | 0);  /* check that 'git_diff_file.id_abbrev' is an integer */
}
struct _cffi_align_typedef_git_diff_file { char x; git_diff_file y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_diff_options(git_diff_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_diff_options.version' is an integer */
  (void)((p->flags) | 0);  /* check that 'git_diff_options.flags' is an integer */
  { git_submodule_ignore_t *tmp = &p->ignore_submodules; (void)tmp; }
  { git_strarray *tmp = &p->pathspec; (void)tmp; }
  { int(* *tmp)(git_diff const *, git_diff_delta const *, char const *, void *) = &p->notify_cb; (void)tmp; }
  { int(* *tmp)(git_diff const *, char const *, char const *, void *) = &p->progress_cb; (void)tmp; }
  { void * *tmp = &p->payload; (void)tmp; }
  (void)((p->context_lines) | 0);  /* check that 'git_diff_options.context_lines' is an integer */
  (void)((p->interhunk_lines) | 0);  /* check that 'git_diff_options.interhunk_lines' is an integer */
  { git_oid_t *tmp = &p->oid_type; (void)tmp; }
  (void)((p->id_abbrev) | 0);  /* check that 'git_diff_options.id_abbrev' is an integer */
  (void)((p->max_size) | 0);  /* check that 'git_diff_options.max_size' is an integer */
  { char const * *tmp = &p->old_prefix; (void)tmp; }
  { char const * *tmp = &p->new_prefix; (void)tmp; }
}
struct _cffi_align_typedef_git_diff_options { char x; git_diff_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_diff_similarity_metric(git_diff_similarity_metric *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { int(* *tmp)(void * *, git_diff_file const *, char const *, void *) = &p->file_signature; (void)tmp; }
  { int(* *tmp)(void * *, git_diff_file const *, char const *, size_t, void *) = &p->buffer_signature; (void)tmp; }
  { void(* *tmp)(void *, void *) = &p->free_signature; (void)tmp; }
  { int(* *tmp)(int *, void *, void *, void *) = &p->similarity; (void)tmp; }
  { void * *tmp = &p->payload; (void)tmp; }
}
struct _cffi_align_typedef_git_diff_similarity_metric { char x; git_diff_similarity_metric y; };

static int _cffi_const_GIT_DIRECTION_FETCH(unsigned long long *o)
{
  int n = (GIT_DIRECTION_FETCH) <= 0;
  *o = (unsigned long long)((GIT_DIRECTION_FETCH) | 0);  /* check that GIT_DIRECTION_FETCH is an integer */
  return n;
}

static int _cffi_const_GIT_DIRECTION_PUSH(unsigned long long *o)
{
  int n = (GIT_DIRECTION_PUSH) <= 0;
  *o = (unsigned long long)((GIT_DIRECTION_PUSH) | 0);  /* check that GIT_DIRECTION_PUSH is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_error(git_error *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char * *tmp = &p->message; (void)tmp; }
  (void)((p->klass) | 0);  /* check that 'git_error.klass' is an integer */
}
struct _cffi_align_typedef_git_error { char x; git_error y; };

static int _cffi_const_GIT_OK(unsigned long long *o)
{
  int n = (GIT_OK) <= 0;
  *o = (unsigned long long)((GIT_OK) | 0);  /* check that GIT_OK is an integer */
  return n;
}

static int _cffi_const_GIT_ERROR(unsigned long long *o)
{
  int n = (GIT_ERROR) <= 0;
  *o = (unsigned long long)((GIT_ERROR) | 0);  /* check that GIT_ERROR is an integer */
  return n;
}

static int _cffi_const_GIT_ENOTFOUND(unsigned long long *o)
{
  int n = (GIT_ENOTFOUND) <= 0;
  *o = (unsigned long long)((GIT_ENOTFOUND) | 0);  /* check that GIT_ENOTFOUND is an integer */
  return n;
}

static int _cffi_const_GIT_EEXISTS(unsigned long long *o)
{
  int n = (GIT_EEXISTS) <= 0;
  *o = (unsigned long long)((GIT_EEXISTS) | 0);  /* check that GIT_EEXISTS is an integer */
  return n;
}

static int _cffi_const_GIT_EAMBIGUOUS(unsigned long long *o)
{
  int n = (GIT_EAMBIGUOUS) <= 0;
  *o = (unsigned long long)((GIT_EAMBIGUOUS) | 0);  /* check that GIT_EAMBIGUOUS is an integer */
  return n;
}

static int _cffi_const_GIT_EBUFS(unsigned long long *o)
{
  int n = (GIT_EBUFS) <= 0;
  *o = (unsigned long long)((GIT_EBUFS) | 0);  /* check that GIT_EBUFS is an integer */
  return n;
}

static int _cffi_const_GIT_EUSER(unsigned long long *o)
{
  int n = (GIT_EUSER) <= 0;
  *o = (unsigned long long)((GIT_EUSER) | 0);  /* check that GIT_EUSER is an integer */
  return n;
}

static int _cffi_const_GIT_EBAREREPO(unsigned long long *o)
{
  int n = (GIT_EBAREREPO) <= 0;
  *o = (unsigned long long)((GIT_EBAREREPO) | 0);  /* check that GIT_EBAREREPO is an integer */
  return n;
}

static int _cffi_const_GIT_EUNBORNBRANCH(unsigned long long *o)
{
  int n = (GIT_EUNBORNBRANCH) <= 0;
  *o = (unsigned long long)((GIT_EUNBORNBRANCH) | 0);  /* check that GIT_EUNBORNBRANCH is an integer */
  return n;
}

static int _cffi_const_GIT_EUNMERGED(unsigned long long *o)
{
  int n = (GIT_EUNMERGED) <= 0;
  *o = (unsigned long long)((GIT_EUNMERGED) | 0);  /* check that GIT_EUNMERGED is an integer */
  return n;
}

static int _cffi_const_GIT_ENONFASTFORWARD(unsigned long long *o)
{
  int n = (GIT_ENONFASTFORWARD) <= 0;
  *o = (unsigned long long)((GIT_ENONFASTFORWARD) | 0);  /* check that GIT_ENONFASTFORWARD is an integer */
  return n;
}

static int _cffi_const_GIT_EINVALIDSPEC(unsigned long long *o)
{
  int n = (GIT_EINVALIDSPEC) <= 0;
  *o = (unsigned long long)((GIT_EINVALIDSPEC) | 0);  /* check that GIT_EINVALIDSPEC is an integer */
  return n;
}

static int _cffi_const_GIT_ECONFLICT(unsigned long long *o)
{
  int n = (GIT_ECONFLICT) <= 0;
  *o = (unsigned long long)((GIT_ECONFLICT) | 0);  /* check that GIT_ECONFLICT is an integer */
  return n;
}

static int _cffi_const_GIT_ELOCKED(unsigned long long *o)
{
  int n = (GIT_ELOCKED) <= 0;
  *o = (unsigned long long)((GIT_ELOCKED) | 0);  /* check that GIT_ELOCKED is an integer */
  return n;
}

static int _cffi_const_GIT_EMODIFIED(unsigned long long *o)
{
  int n = (GIT_EMODIFIED) <= 0;
  *o = (unsigned long long)((GIT_EMODIFIED) | 0);  /* check that GIT_EMODIFIED is an integer */
  return n;
}

static int _cffi_const_GIT_EAUTH(unsigned long long *o)
{
  int n = (GIT_EAUTH) <= 0;
  *o = (unsigned long long)((GIT_EAUTH) | 0);  /* check that GIT_EAUTH is an integer */
  return n;
}

static int _cffi_const_GIT_ECERTIFICATE(unsigned long long *o)
{
  int n = (GIT_ECERTIFICATE) <= 0;
  *o = (unsigned long long)((GIT_ECERTIFICATE) | 0);  /* check that GIT_ECERTIFICATE is an integer */
  return n;
}

static int _cffi_const_GIT_EAPPLIED(unsigned long long *o)
{
  int n = (GIT_EAPPLIED) <= 0;
  *o = (unsigned long long)((GIT_EAPPLIED) | 0);  /* check that GIT_EAPPLIED is an integer */
  return n;
}

static int _cffi_const_GIT_EPEEL(unsigned long long *o)
{
  int n = (GIT_EPEEL) <= 0;
  *o = (unsigned long long)((GIT_EPEEL) | 0);  /* check that GIT_EPEEL is an integer */
  return n;
}

static int _cffi_const_GIT_EEOF(unsigned long long *o)
{
  int n = (GIT_EEOF) <= 0;
  *o = (unsigned long long)((GIT_EEOF) | 0);  /* check that GIT_EEOF is an integer */
  return n;
}

static int _cffi_const_GIT_EINVALID(unsigned long long *o)
{
  int n = (GIT_EINVALID) <= 0;
  *o = (unsigned long long)((GIT_EINVALID) | 0);  /* check that GIT_EINVALID is an integer */
  return n;
}

static int _cffi_const_GIT_EUNCOMMITTED(unsigned long long *o)
{
  int n = (GIT_EUNCOMMITTED) <= 0;
  *o = (unsigned long long)((GIT_EUNCOMMITTED) | 0);  /* check that GIT_EUNCOMMITTED is an integer */
  return n;
}

static int _cffi_const_GIT_EDIRECTORY(unsigned long long *o)
{
  int n = (GIT_EDIRECTORY) <= 0;
  *o = (unsigned long long)((GIT_EDIRECTORY) | 0);  /* check that GIT_EDIRECTORY is an integer */
  return n;
}

static int _cffi_const_GIT_EMERGECONFLICT(unsigned long long *o)
{
  int n = (GIT_EMERGECONFLICT) <= 0;
  *o = (unsigned long long)((GIT_EMERGECONFLICT) | 0);  /* check that GIT_EMERGECONFLICT is an integer */
  return n;
}

static int _cffi_const_GIT_PASSTHROUGH(unsigned long long *o)
{
  int n = (GIT_PASSTHROUGH) <= 0;
  *o = (unsigned long long)((GIT_PASSTHROUGH) | 0);  /* check that GIT_PASSTHROUGH is an integer */
  return n;
}

static int _cffi_const_GIT_ITEROVER(unsigned long long *o)
{
  int n = (GIT_ITEROVER) <= 0;
  *o = (unsigned long long)((GIT_ITEROVER) | 0);  /* check that GIT_ITEROVER is an integer */
  return n;
}

static int _cffi_const_GIT_RETRY(unsigned long long *o)
{
  int n = (GIT_RETRY) <= 0;
  *o = (unsigned long long)((GIT_RETRY) | 0);  /* check that GIT_RETRY is an integer */
  return n;
}

static int _cffi_const_GIT_EMISMATCH(unsigned long long *o)
{
  int n = (GIT_EMISMATCH) <= 0;
  *o = (unsigned long long)((GIT_EMISMATCH) | 0);  /* check that GIT_EMISMATCH is an integer */
  return n;
}

static int _cffi_const_GIT_EINDEXDIRTY(unsigned long long *o)
{
  int n = (GIT_EINDEXDIRTY) <= 0;
  *o = (unsigned long long)((GIT_EINDEXDIRTY) | 0);  /* check that GIT_EINDEXDIRTY is an integer */
  return n;
}

static int _cffi_const_GIT_EAPPLYFAIL(unsigned long long *o)
{
  int n = (GIT_EAPPLYFAIL) <= 0;
  *o = (unsigned long long)((GIT_EAPPLYFAIL) | 0);  /* check that GIT_EAPPLYFAIL is an integer */
  return n;
}

static int _cffi_const_GIT_EOWNER(unsigned long long *o)
{
  int n = (GIT_EOWNER) <= 0;
  *o = (unsigned long long)((GIT_EOWNER) | 0);  /* check that GIT_EOWNER is an integer */
  return n;
}

static int _cffi_const_GIT_TIMEOUT(unsigned long long *o)
{
  int n = (GIT_TIMEOUT) <= 0;
  *o = (unsigned long long)((GIT_TIMEOUT) | 0);  /* check that GIT_TIMEOUT is an integer */
  return n;
}

static int _cffi_const_GIT_FEATURE_THREADS(unsigned long long *o)
{
  int n = (GIT_FEATURE_THREADS) <= 0;
  *o = (unsigned long long)((GIT_FEATURE_THREADS) | 0);  /* check that GIT_FEATURE_THREADS is an integer */
  return n;
}

static int _cffi_const_GIT_FEATURE_HTTPS(unsigned long long *o)
{
  int n = (GIT_FEATURE_HTTPS) <= 0;
  *o = (unsigned long long)((GIT_FEATURE_HTTPS) | 0);  /* check that GIT_FEATURE_HTTPS is an integer */
  return n;
}

static int _cffi_const_GIT_FEATURE_SSH(unsigned long long *o)
{
  int n = (GIT_FEATURE_SSH) <= 0;
  *o = (unsigned long long)((GIT_FEATURE_SSH) | 0);  /* check that GIT_FEATURE_SSH is an integer */
  return n;
}

static int _cffi_const_GIT_FEATURE_NSEC(unsigned long long *o)
{
  int n = (GIT_FEATURE_NSEC) <= 0;
  *o = (unsigned long long)((GIT_FEATURE_NSEC) | 0);  /* check that GIT_FEATURE_NSEC is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_fetch_options(git_fetch_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_fetch_options.version' is an integer */
  { git_remote_callbacks *tmp = &p->callbacks; (void)tmp; }
  { git_fetch_prune_t *tmp = &p->prune; (void)tmp; }
  (void)((p->update_fetchhead) | 0);  /* check that 'git_fetch_options.update_fetchhead' is an integer */
  { git_remote_autotag_option_t *tmp = &p->download_tags; (void)tmp; }
  { git_proxy_options *tmp = &p->proxy_opts; (void)tmp; }
  (void)((p->depth) | 0);  /* check that 'git_fetch_options.depth' is an integer */
  { git_remote_redirect_t *tmp = &p->follow_redirects; (void)tmp; }
  { git_strarray *tmp = &p->custom_headers; (void)tmp; }
}
struct _cffi_align_typedef_git_fetch_options { char x; git_fetch_options y; };

static int _cffi_const_GIT_FETCH_PRUNE_UNSPECIFIED(unsigned long long *o)
{
  int n = (GIT_FETCH_PRUNE_UNSPECIFIED) <= 0;
  *o = (unsigned long long)((GIT_FETCH_PRUNE_UNSPECIFIED) | 0);  /* check that GIT_FETCH_PRUNE_UNSPECIFIED is an integer */
  return n;
}

static int _cffi_const_GIT_FETCH_PRUNE(unsigned long long *o)
{
  int n = (GIT_FETCH_PRUNE) <= 0;
  *o = (unsigned long long)((GIT_FETCH_PRUNE) | 0);  /* check that GIT_FETCH_PRUNE is an integer */
  return n;
}

static int _cffi_const_GIT_FETCH_NO_PRUNE(unsigned long long *o)
{
  int n = (GIT_FETCH_NO_PRUNE) <= 0;
  *o = (unsigned long long)((GIT_FETCH_NO_PRUNE) | 0);  /* check that GIT_FETCH_NO_PRUNE is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_index_time(git_index_time *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->seconds) | 0);  /* check that 'git_index_time.seconds' is an integer */
  (void)((p->nanoseconds) | 0);  /* check that 'git_index_time.nanoseconds' is an integer */
}
struct _cffi_align_typedef_git_index_time { char x; git_index_time y; };

static int _cffi_const_GIT_OPT_GET_MWINDOW_SIZE(unsigned long long *o)
{
  int n = (GIT_OPT_GET_MWINDOW_SIZE) <= 0;
  *o = (unsigned long long)((GIT_OPT_GET_MWINDOW_SIZE) | 0);  /* check that GIT_OPT_GET_MWINDOW_SIZE is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_MWINDOW_SIZE(unsigned long long *o)
{
  int n = (GIT_OPT_SET_MWINDOW_SIZE) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_MWINDOW_SIZE) | 0);  /* check that GIT_OPT_SET_MWINDOW_SIZE is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_GET_MWINDOW_MAPPED_LIMIT(unsigned long long *o)
{
  int n = (GIT_OPT_GET_MWINDOW_MAPPED_LIMIT) <= 0;
  *o = (unsigned long long)((GIT_OPT_GET_MWINDOW_MAPPED_LIMIT) | 0);  /* check that GIT_OPT_GET_MWINDOW_MAPPED_LIMIT is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_MWINDOW_MAPPED_LIMIT(unsigned long long *o)
{
  int n = (GIT_OPT_SET_MWINDOW_MAPPED_LIMIT) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_MWINDOW_MAPPED_LIMIT) | 0);  /* check that GIT_OPT_SET_MWINDOW_MAPPED_LIMIT is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_GET_SEARCH_PATH(unsigned long long *o)
{
  int n = (GIT_OPT_GET_SEARCH_PATH) <= 0;
  *o = (unsigned long long)((GIT_OPT_GET_SEARCH_PATH) | 0);  /* check that GIT_OPT_GET_SEARCH_PATH is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_SEARCH_PATH(unsigned long long *o)
{
  int n = (GIT_OPT_SET_SEARCH_PATH) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_SEARCH_PATH) | 0);  /* check that GIT_OPT_SET_SEARCH_PATH is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_CACHE_OBJECT_LIMIT(unsigned long long *o)
{
  int n = (GIT_OPT_SET_CACHE_OBJECT_LIMIT) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_CACHE_OBJECT_LIMIT) | 0);  /* check that GIT_OPT_SET_CACHE_OBJECT_LIMIT is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_CACHE_MAX_SIZE(unsigned long long *o)
{
  int n = (GIT_OPT_SET_CACHE_MAX_SIZE) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_CACHE_MAX_SIZE) | 0);  /* check that GIT_OPT_SET_CACHE_MAX_SIZE is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_ENABLE_CACHING(unsigned long long *o)
{
  int n = (GIT_OPT_ENABLE_CACHING) <= 0;
  *o = (unsigned long long)((GIT_OPT_ENABLE_CACHING) | 0);  /* check that GIT_OPT_ENABLE_CACHING is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_GET_CACHED_MEMORY(unsigned long long *o)
{
  int n = (GIT_OPT_GET_CACHED_MEMORY) <= 0;
  *o = (unsigned long long)((GIT_OPT_GET_CACHED_MEMORY) | 0);  /* check that GIT_OPT_GET_CACHED_MEMORY is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_GET_TEMPLATE_PATH(unsigned long long *o)
{
  int n = (GIT_OPT_GET_TEMPLATE_PATH) <= 0;
  *o = (unsigned long long)((GIT_OPT_GET_TEMPLATE_PATH) | 0);  /* check that GIT_OPT_GET_TEMPLATE_PATH is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_TEMPLATE_PATH(unsigned long long *o)
{
  int n = (GIT_OPT_SET_TEMPLATE_PATH) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_TEMPLATE_PATH) | 0);  /* check that GIT_OPT_SET_TEMPLATE_PATH is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_SSL_CERT_LOCATIONS(unsigned long long *o)
{
  int n = (GIT_OPT_SET_SSL_CERT_LOCATIONS) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_SSL_CERT_LOCATIONS) | 0);  /* check that GIT_OPT_SET_SSL_CERT_LOCATIONS is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_USER_AGENT(unsigned long long *o)
{
  int n = (GIT_OPT_SET_USER_AGENT) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_USER_AGENT) | 0);  /* check that GIT_OPT_SET_USER_AGENT is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_ENABLE_STRICT_OBJECT_CREATION(unsigned long long *o)
{
  int n = (GIT_OPT_ENABLE_STRICT_OBJECT_CREATION) <= 0;
  *o = (unsigned long long)((GIT_OPT_ENABLE_STRICT_OBJECT_CREATION) | 0);  /* check that GIT_OPT_ENABLE_STRICT_OBJECT_CREATION is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_ENABLE_STRICT_SYMBOLIC_REF_CREATION(unsigned long long *o)
{
  int n = (GIT_OPT_ENABLE_STRICT_SYMBOLIC_REF_CREATION) <= 0;
  *o = (unsigned long long)((GIT_OPT_ENABLE_STRICT_SYMBOLIC_REF_CREATION) | 0);  /* check that GIT_OPT_ENABLE_STRICT_SYMBOLIC_REF_CREATION is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_SSL_CIPHERS(unsigned long long *o)
{
  int n = (GIT_OPT_SET_SSL_CIPHERS) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_SSL_CIPHERS) | 0);  /* check that GIT_OPT_SET_SSL_CIPHERS is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_GET_USER_AGENT(unsigned long long *o)
{
  int n = (GIT_OPT_GET_USER_AGENT) <= 0;
  *o = (unsigned long long)((GIT_OPT_GET_USER_AGENT) | 0);  /* check that GIT_OPT_GET_USER_AGENT is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_ENABLE_OFS_DELTA(unsigned long long *o)
{
  int n = (GIT_OPT_ENABLE_OFS_DELTA) <= 0;
  *o = (unsigned long long)((GIT_OPT_ENABLE_OFS_DELTA) | 0);  /* check that GIT_OPT_ENABLE_OFS_DELTA is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_ENABLE_FSYNC_GITDIR(unsigned long long *o)
{
  int n = (GIT_OPT_ENABLE_FSYNC_GITDIR) <= 0;
  *o = (unsigned long long)((GIT_OPT_ENABLE_FSYNC_GITDIR) | 0);  /* check that GIT_OPT_ENABLE_FSYNC_GITDIR is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_GET_WINDOWS_SHAREMODE(unsigned long long *o)
{
  int n = (GIT_OPT_GET_WINDOWS_SHAREMODE) <= 0;
  *o = (unsigned long long)((GIT_OPT_GET_WINDOWS_SHAREMODE) | 0);  /* check that GIT_OPT_GET_WINDOWS_SHAREMODE is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_WINDOWS_SHAREMODE(unsigned long long *o)
{
  int n = (GIT_OPT_SET_WINDOWS_SHAREMODE) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_WINDOWS_SHAREMODE) | 0);  /* check that GIT_OPT_SET_WINDOWS_SHAREMODE is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_ENABLE_STRICT_HASH_VERIFICATION(unsigned long long *o)
{
  int n = (GIT_OPT_ENABLE_STRICT_HASH_VERIFICATION) <= 0;
  *o = (unsigned long long)((GIT_OPT_ENABLE_STRICT_HASH_VERIFICATION) | 0);  /* check that GIT_OPT_ENABLE_STRICT_HASH_VERIFICATION is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_ALLOCATOR(unsigned long long *o)
{
  int n = (GIT_OPT_SET_ALLOCATOR) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_ALLOCATOR) | 0);  /* check that GIT_OPT_SET_ALLOCATOR is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_ENABLE_UNSAVED_INDEX_SAFETY(unsigned long long *o)
{
  int n = (GIT_OPT_ENABLE_UNSAVED_INDEX_SAFETY) <= 0;
  *o = (unsigned long long)((GIT_OPT_ENABLE_UNSAVED_INDEX_SAFETY) | 0);  /* check that GIT_OPT_ENABLE_UNSAVED_INDEX_SAFETY is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_GET_PACK_MAX_OBJECTS(unsigned long long *o)
{
  int n = (GIT_OPT_GET_PACK_MAX_OBJECTS) <= 0;
  *o = (unsigned long long)((GIT_OPT_GET_PACK_MAX_OBJECTS) | 0);  /* check that GIT_OPT_GET_PACK_MAX_OBJECTS is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_PACK_MAX_OBJECTS(unsigned long long *o)
{
  int n = (GIT_OPT_SET_PACK_MAX_OBJECTS) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_PACK_MAX_OBJECTS) | 0);  /* check that GIT_OPT_SET_PACK_MAX_OBJECTS is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_DISABLE_PACK_KEEP_FILE_CHECKS(unsigned long long *o)
{
  int n = (GIT_OPT_DISABLE_PACK_KEEP_FILE_CHECKS) <= 0;
  *o = (unsigned long long)((GIT_OPT_DISABLE_PACK_KEEP_FILE_CHECKS) | 0);  /* check that GIT_OPT_DISABLE_PACK_KEEP_FILE_CHECKS is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_ENABLE_HTTP_EXPECT_CONTINUE(unsigned long long *o)
{
  int n = (GIT_OPT_ENABLE_HTTP_EXPECT_CONTINUE) <= 0;
  *o = (unsigned long long)((GIT_OPT_ENABLE_HTTP_EXPECT_CONTINUE) | 0);  /* check that GIT_OPT_ENABLE_HTTP_EXPECT_CONTINUE is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_GET_MWINDOW_FILE_LIMIT(unsigned long long *o)
{
  int n = (GIT_OPT_GET_MWINDOW_FILE_LIMIT) <= 0;
  *o = (unsigned long long)((GIT_OPT_GET_MWINDOW_FILE_LIMIT) | 0);  /* check that GIT_OPT_GET_MWINDOW_FILE_LIMIT is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_MWINDOW_FILE_LIMIT(unsigned long long *o)
{
  int n = (GIT_OPT_SET_MWINDOW_FILE_LIMIT) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_MWINDOW_FILE_LIMIT) | 0);  /* check that GIT_OPT_SET_MWINDOW_FILE_LIMIT is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_ODB_PACKED_PRIORITY(unsigned long long *o)
{
  int n = (GIT_OPT_SET_ODB_PACKED_PRIORITY) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_ODB_PACKED_PRIORITY) | 0);  /* check that GIT_OPT_SET_ODB_PACKED_PRIORITY is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_ODB_LOOSE_PRIORITY(unsigned long long *o)
{
  int n = (GIT_OPT_SET_ODB_LOOSE_PRIORITY) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_ODB_LOOSE_PRIORITY) | 0);  /* check that GIT_OPT_SET_ODB_LOOSE_PRIORITY is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_GET_EXTENSIONS(unsigned long long *o)
{
  int n = (GIT_OPT_GET_EXTENSIONS) <= 0;
  *o = (unsigned long long)((GIT_OPT_GET_EXTENSIONS) | 0);  /* check that GIT_OPT_GET_EXTENSIONS is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_EXTENSIONS(unsigned long long *o)
{
  int n = (GIT_OPT_SET_EXTENSIONS) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_EXTENSIONS) | 0);  /* check that GIT_OPT_SET_EXTENSIONS is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_GET_OWNER_VALIDATION(unsigned long long *o)
{
  int n = (GIT_OPT_GET_OWNER_VALIDATION) <= 0;
  *o = (unsigned long long)((GIT_OPT_GET_OWNER_VALIDATION) | 0);  /* check that GIT_OPT_GET_OWNER_VALIDATION is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_OWNER_VALIDATION(unsigned long long *o)
{
  int n = (GIT_OPT_SET_OWNER_VALIDATION) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_OWNER_VALIDATION) | 0);  /* check that GIT_OPT_SET_OWNER_VALIDATION is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_GET_HOMEDIR(unsigned long long *o)
{
  int n = (GIT_OPT_GET_HOMEDIR) <= 0;
  *o = (unsigned long long)((GIT_OPT_GET_HOMEDIR) | 0);  /* check that GIT_OPT_GET_HOMEDIR is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_HOMEDIR(unsigned long long *o)
{
  int n = (GIT_OPT_SET_HOMEDIR) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_HOMEDIR) | 0);  /* check that GIT_OPT_SET_HOMEDIR is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_SERVER_CONNECT_TIMEOUT(unsigned long long *o)
{
  int n = (GIT_OPT_SET_SERVER_CONNECT_TIMEOUT) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_SERVER_CONNECT_TIMEOUT) | 0);  /* check that GIT_OPT_SET_SERVER_CONNECT_TIMEOUT is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_GET_SERVER_CONNECT_TIMEOUT(unsigned long long *o)
{
  int n = (GIT_OPT_GET_SERVER_CONNECT_TIMEOUT) <= 0;
  *o = (unsigned long long)((GIT_OPT_GET_SERVER_CONNECT_TIMEOUT) | 0);  /* check that GIT_OPT_GET_SERVER_CONNECT_TIMEOUT is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_SERVER_TIMEOUT(unsigned long long *o)
{
  int n = (GIT_OPT_SET_SERVER_TIMEOUT) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_SERVER_TIMEOUT) | 0);  /* check that GIT_OPT_SET_SERVER_TIMEOUT is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_GET_SERVER_TIMEOUT(unsigned long long *o)
{
  int n = (GIT_OPT_GET_SERVER_TIMEOUT) <= 0;
  *o = (unsigned long long)((GIT_OPT_GET_SERVER_TIMEOUT) | 0);  /* check that GIT_OPT_GET_SERVER_TIMEOUT is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_SET_USER_AGENT_PRODUCT(unsigned long long *o)
{
  int n = (GIT_OPT_SET_USER_AGENT_PRODUCT) <= 0;
  *o = (unsigned long long)((GIT_OPT_SET_USER_AGENT_PRODUCT) | 0);  /* check that GIT_OPT_SET_USER_AGENT_PRODUCT is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_GET_USER_AGENT_PRODUCT(unsigned long long *o)
{
  int n = (GIT_OPT_GET_USER_AGENT_PRODUCT) <= 0;
  *o = (unsigned long long)((GIT_OPT_GET_USER_AGENT_PRODUCT) | 0);  /* check that GIT_OPT_GET_USER_AGENT_PRODUCT is an integer */
  return n;
}

static int _cffi_const_GIT_OPT_ADD_SSL_X509_CERT(unsigned long long *o)
{
  int n = (GIT_OPT_ADD_SSL_X509_CERT) <= 0;
  *o = (unsigned long long)((GIT_OPT_ADD_SSL_X509_CERT) | 0);  /* check that GIT_OPT_ADD_SSL_X509_CERT is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FILE_FAVOR_NORMAL(unsigned long long *o)
{
  int n = (GIT_MERGE_FILE_FAVOR_NORMAL) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FILE_FAVOR_NORMAL) | 0);  /* check that GIT_MERGE_FILE_FAVOR_NORMAL is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FILE_FAVOR_OURS(unsigned long long *o)
{
  int n = (GIT_MERGE_FILE_FAVOR_OURS) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FILE_FAVOR_OURS) | 0);  /* check that GIT_MERGE_FILE_FAVOR_OURS is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FILE_FAVOR_THEIRS(unsigned long long *o)
{
  int n = (GIT_MERGE_FILE_FAVOR_THEIRS) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FILE_FAVOR_THEIRS) | 0);  /* check that GIT_MERGE_FILE_FAVOR_THEIRS is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FILE_FAVOR_UNION(unsigned long long *o)
{
  int n = (GIT_MERGE_FILE_FAVOR_UNION) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FILE_FAVOR_UNION) | 0);  /* check that GIT_MERGE_FILE_FAVOR_UNION is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FILE_DEFAULT(unsigned long long *o)
{
  int n = (GIT_MERGE_FILE_DEFAULT) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FILE_DEFAULT) | 0);  /* check that GIT_MERGE_FILE_DEFAULT is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FILE_STYLE_MERGE(unsigned long long *o)
{
  int n = (GIT_MERGE_FILE_STYLE_MERGE) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FILE_STYLE_MERGE) | 0);  /* check that GIT_MERGE_FILE_STYLE_MERGE is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FILE_STYLE_DIFF3(unsigned long long *o)
{
  int n = (GIT_MERGE_FILE_STYLE_DIFF3) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FILE_STYLE_DIFF3) | 0);  /* check that GIT_MERGE_FILE_STYLE_DIFF3 is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FILE_SIMPLIFY_ALNUM(unsigned long long *o)
{
  int n = (GIT_MERGE_FILE_SIMPLIFY_ALNUM) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FILE_SIMPLIFY_ALNUM) | 0);  /* check that GIT_MERGE_FILE_SIMPLIFY_ALNUM is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FILE_IGNORE_WHITESPACE(unsigned long long *o)
{
  int n = (GIT_MERGE_FILE_IGNORE_WHITESPACE) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FILE_IGNORE_WHITESPACE) | 0);  /* check that GIT_MERGE_FILE_IGNORE_WHITESPACE is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FILE_IGNORE_WHITESPACE_CHANGE(unsigned long long *o)
{
  int n = (GIT_MERGE_FILE_IGNORE_WHITESPACE_CHANGE) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FILE_IGNORE_WHITESPACE_CHANGE) | 0);  /* check that GIT_MERGE_FILE_IGNORE_WHITESPACE_CHANGE is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FILE_IGNORE_WHITESPACE_EOL(unsigned long long *o)
{
  int n = (GIT_MERGE_FILE_IGNORE_WHITESPACE_EOL) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FILE_IGNORE_WHITESPACE_EOL) | 0);  /* check that GIT_MERGE_FILE_IGNORE_WHITESPACE_EOL is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FILE_DIFF_PATIENCE(unsigned long long *o)
{
  int n = (GIT_MERGE_FILE_DIFF_PATIENCE) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FILE_DIFF_PATIENCE) | 0);  /* check that GIT_MERGE_FILE_DIFF_PATIENCE is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FILE_DIFF_MINIMAL(unsigned long long *o)
{
  int n = (GIT_MERGE_FILE_DIFF_MINIMAL) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FILE_DIFF_MINIMAL) | 0);  /* check that GIT_MERGE_FILE_DIFF_MINIMAL is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FILE_STYLE_ZDIFF3(unsigned long long *o)
{
  int n = (GIT_MERGE_FILE_STYLE_ZDIFF3) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FILE_STYLE_ZDIFF3) | 0);  /* check that GIT_MERGE_FILE_STYLE_ZDIFF3 is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FILE_ACCEPT_CONFLICTS(unsigned long long *o)
{
  int n = (GIT_MERGE_FILE_ACCEPT_CONFLICTS) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FILE_ACCEPT_CONFLICTS) | 0);  /* check that GIT_MERGE_FILE_ACCEPT_CONFLICTS is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_merge_file_options(git_merge_file_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_merge_file_options.version' is an integer */
  { char const * *tmp = &p->ancestor_label; (void)tmp; }
  { char const * *tmp = &p->our_label; (void)tmp; }
  { char const * *tmp = &p->their_label; (void)tmp; }
  { git_merge_file_favor_t *tmp = &p->favor; (void)tmp; }
  { git_merge_file_flag_t *tmp = &p->flags; (void)tmp; }
  (void)((p->marker_size) | 0);  /* check that 'git_merge_file_options.marker_size' is an integer */
}
struct _cffi_align_typedef_git_merge_file_options { char x; git_merge_file_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_merge_file_result(git_merge_file_result *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->automergeable) | 0);  /* check that 'git_merge_file_result.automergeable' is an integer */
  { char const * *tmp = &p->path; (void)tmp; }
  (void)((p->mode) | 0);  /* check that 'git_merge_file_result.mode' is an integer */
  { char const * *tmp = &p->ptr; (void)tmp; }
  (void)((p->len) | 0);  /* check that 'git_merge_file_result.len' is an integer */
}
struct _cffi_align_typedef_git_merge_file_result { char x; git_merge_file_result y; };

static int _cffi_const_GIT_MERGE_FIND_RENAMES(unsigned long long *o)
{
  int n = (GIT_MERGE_FIND_RENAMES) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FIND_RENAMES) | 0);  /* check that GIT_MERGE_FIND_RENAMES is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_FAIL_ON_CONFLICT(unsigned long long *o)
{
  int n = (GIT_MERGE_FAIL_ON_CONFLICT) <= 0;
  *o = (unsigned long long)((GIT_MERGE_FAIL_ON_CONFLICT) | 0);  /* check that GIT_MERGE_FAIL_ON_CONFLICT is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_SKIP_REUC(unsigned long long *o)
{
  int n = (GIT_MERGE_SKIP_REUC) <= 0;
  *o = (unsigned long long)((GIT_MERGE_SKIP_REUC) | 0);  /* check that GIT_MERGE_SKIP_REUC is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_NO_RECURSIVE(unsigned long long *o)
{
  int n = (GIT_MERGE_NO_RECURSIVE) <= 0;
  *o = (unsigned long long)((GIT_MERGE_NO_RECURSIVE) | 0);  /* check that GIT_MERGE_NO_RECURSIVE is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_VIRTUAL_BASE(unsigned long long *o)
{
  int n = (GIT_MERGE_VIRTUAL_BASE) <= 0;
  *o = (unsigned long long)((GIT_MERGE_VIRTUAL_BASE) | 0);  /* check that GIT_MERGE_VIRTUAL_BASE is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_merge_options(git_merge_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_merge_options.version' is an integer */
  { git_merge_flag_t *tmp = &p->flags; (void)tmp; }
  (void)((p->rename_threshold) | 0);  /* check that 'git_merge_options.rename_threshold' is an integer */
  (void)((p->target_limit) | 0);  /* check that 'git_merge_options.target_limit' is an integer */
  { git_diff_similarity_metric * *tmp = &p->metric; (void)tmp; }
  (void)((p->recursion_limit) | 0);  /* check that 'git_merge_options.recursion_limit' is an integer */
  { char const * *tmp = &p->default_driver; (void)tmp; }
  { git_merge_file_favor_t *tmp = &p->file_favor; (void)tmp; }
  { git_merge_file_flag_t *tmp = &p->file_flags; (void)tmp; }
}
struct _cffi_align_typedef_git_merge_options { char x; git_merge_options y; };

static int _cffi_const_GIT_OBJECT_ANY(unsigned long long *o)
{
  int n = (GIT_OBJECT_ANY) <= 0;
  *o = (unsigned long long)((GIT_OBJECT_ANY) | 0);  /* check that GIT_OBJECT_ANY is an integer */
  return n;
}

static int _cffi_const_GIT_OBJECT_INVALID(unsigned long long *o)
{
  int n = (GIT_OBJECT_INVALID) <= 0;
  *o = (unsigned long long)((GIT_OBJECT_INVALID) | 0);  /* check that GIT_OBJECT_INVALID is an integer */
  return n;
}

static int _cffi_const_GIT_OBJECT_COMMIT(unsigned long long *o)
{
  int n = (GIT_OBJECT_COMMIT) <= 0;
  *o = (unsigned long long)((GIT_OBJECT_COMMIT) | 0);  /* check that GIT_OBJECT_COMMIT is an integer */
  return n;
}

static int _cffi_const_GIT_OBJECT_TREE(unsigned long long *o)
{
  int n = (GIT_OBJECT_TREE) <= 0;
  *o = (unsigned long long)((GIT_OBJECT_TREE) | 0);  /* check that GIT_OBJECT_TREE is an integer */
  return n;
}

static int _cffi_const_GIT_OBJECT_BLOB(unsigned long long *o)
{
  int n = (GIT_OBJECT_BLOB) <= 0;
  *o = (unsigned long long)((GIT_OBJECT_BLOB) | 0);  /* check that GIT_OBJECT_BLOB is an integer */
  return n;
}

static int _cffi_const_GIT_OBJECT_TAG(unsigned long long *o)
{
  int n = (GIT_OBJECT_TAG) <= 0;
  *o = (unsigned long long)((GIT_OBJECT_TAG) | 0);  /* check that GIT_OBJECT_TAG is an integer */
  return n;
}

static int _cffi_const_GIT_OBJECT_OFS_DELTA(unsigned long long *o)
{
  int n = (GIT_OBJECT_OFS_DELTA) <= 0;
  *o = (unsigned long long)((GIT_OBJECT_OFS_DELTA) | 0);  /* check that GIT_OBJECT_OFS_DELTA is an integer */
  return n;
}

static int _cffi_const_GIT_OBJECT_REF_DELTA(unsigned long long *o)
{
  int n = (GIT_OBJECT_REF_DELTA) <= 0;
  *o = (unsigned long long)((GIT_OBJECT_REF_DELTA) | 0);  /* check that GIT_OBJECT_REF_DELTA is an integer */
  return n;
}

static int _cffi_const_GIT_OID_SHA1(unsigned long long *o)
{
  int n = (GIT_OID_SHA1) <= 0;
  *o = (unsigned long long)((GIT_OID_SHA1) | 0);  /* check that GIT_OID_SHA1 is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_proxy_options(git_proxy_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_proxy_options.version' is an integer */
  { git_proxy_t *tmp = &p->type; (void)tmp; }
  { char const * *tmp = &p->url; (void)tmp; }
  { int(* *tmp)(git_credential * *, char const *, char const *, unsigned int, void *) = &p->credentials; (void)tmp; }
  { int(* *tmp)(git_cert *, int, char const *, void *) = &p->certificate_check; (void)tmp; }
  { void * *tmp = &p->payload; (void)tmp; }
}
struct _cffi_align_typedef_git_proxy_options { char x; git_proxy_options y; };

static int _cffi_const_GIT_PROXY_NONE(unsigned long long *o)
{
  int n = (GIT_PROXY_NONE) <= 0;
  *o = (unsigned long long)((GIT_PROXY_NONE) | 0);  /* check that GIT_PROXY_NONE is an integer */
  return n;
}

static int _cffi_const_GIT_PROXY_AUTO(unsigned long long *o)
{
  int n = (GIT_PROXY_AUTO) <= 0;
  *o = (unsigned long long)((GIT_PROXY_AUTO) | 0);  /* check that GIT_PROXY_AUTO is an integer */
  return n;
}

static int _cffi_const_GIT_PROXY_SPECIFIED(unsigned long long *o)
{
  int n = (GIT_PROXY_SPECIFIED) <= 0;
  *o = (unsigned long long)((GIT_PROXY_SPECIFIED) | 0);  /* check that GIT_PROXY_SPECIFIED is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_push_options(git_push_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_push_options.version' is an integer */
  (void)((p->pb_parallelism) | 0);  /* check that 'git_push_options.pb_parallelism' is an integer */
  { git_remote_callbacks *tmp = &p->callbacks; (void)tmp; }
  { git_proxy_options *tmp = &p->proxy_opts; (void)tmp; }
  { git_remote_redirect_t *tmp = &p->follow_redirects; (void)tmp; }
  { git_strarray *tmp = &p->custom_headers; (void)tmp; }
  { git_strarray *tmp = &p->remote_push_options; (void)tmp; }
}
struct _cffi_align_typedef_git_push_options { char x; git_push_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_push_update(git_push_update *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char * *tmp = &p->src_refname; (void)tmp; }
  { char * *tmp = &p->dst_refname; (void)tmp; }
  { git_oid *tmp = &p->src; (void)tmp; }
  { git_oid *tmp = &p->dst; (void)tmp; }
}
struct _cffi_align_typedef_git_push_update { char x; git_push_update y; };

static int _cffi_const_GIT_REFERENCE_INVALID(unsigned long long *o)
{
  int n = (GIT_REFERENCE_INVALID) <= 0;
  *o = (unsigned long long)((GIT_REFERENCE_INVALID) | 0);  /* check that GIT_REFERENCE_INVALID is an integer */
  return n;
}

static int _cffi_const_GIT_REFERENCE_DIRECT(unsigned long long *o)
{
  int n = (GIT_REFERENCE_DIRECT) <= 0;
  *o = (unsigned long long)((GIT_REFERENCE_DIRECT) | 0);  /* check that GIT_REFERENCE_DIRECT is an integer */
  return n;
}

static int _cffi_const_GIT_REFERENCE_SYMBOLIC(unsigned long long *o)
{
  int n = (GIT_REFERENCE_SYMBOLIC) <= 0;
  *o = (unsigned long long)((GIT_REFERENCE_SYMBOLIC) | 0);  /* check that GIT_REFERENCE_SYMBOLIC is an integer */
  return n;
}

static int _cffi_const_GIT_REFERENCE_ALL(unsigned long long *o)
{
  int n = (GIT_REFERENCE_ALL) <= 0;
  *o = (unsigned long long)((GIT_REFERENCE_ALL) | 0);  /* check that GIT_REFERENCE_ALL is an integer */
  return n;
}

static int _cffi_const_GIT_REMOTE_DOWNLOAD_TAGS_UNSPECIFIED(unsigned long long *o)
{
  int n = (GIT_REMOTE_DOWNLOAD_TAGS_UNSPECIFIED) <= 0;
  *o = (unsigned long long)((GIT_REMOTE_DOWNLOAD_TAGS_UNSPECIFIED) | 0);  /* check that GIT_REMOTE_DOWNLOAD_TAGS_UNSPECIFIED is an integer */
  return n;
}

static int _cffi_const_GIT_REMOTE_DOWNLOAD_TAGS_AUTO(unsigned long long *o)
{
  int n = (GIT_REMOTE_DOWNLOAD_TAGS_AUTO) <= 0;
  *o = (unsigned long long)((GIT_REMOTE_DOWNLOAD_TAGS_AUTO) | 0);  /* check that GIT_REMOTE_DOWNLOAD_TAGS_AUTO is an integer */
  return n;
}

static int _cffi_const_GIT_REMOTE_DOWNLOAD_TAGS_NONE(unsigned long long *o)
{
  int n = (GIT_REMOTE_DOWNLOAD_TAGS_NONE) <= 0;
  *o = (unsigned long long)((GIT_REMOTE_DOWNLOAD_TAGS_NONE) | 0);  /* check that GIT_REMOTE_DOWNLOAD_TAGS_NONE is an integer */
  return n;
}

static int _cffi_const_GIT_REMOTE_DOWNLOAD_TAGS_ALL(unsigned long long *o)
{
  int n = (GIT_REMOTE_DOWNLOAD_TAGS_ALL) <= 0;
  *o = (unsigned long long)((GIT_REMOTE_DOWNLOAD_TAGS_ALL) | 0);  /* check that GIT_REMOTE_DOWNLOAD_TAGS_ALL is an integer */
  return n;
}

static int _cffi_const_GIT_REMOTE_REDIRECT_NONE(unsigned long long *o)
{
  int n = (GIT_REMOTE_REDIRECT_NONE) <= 0;
  *o = (unsigned long long)((GIT_REMOTE_REDIRECT_NONE) | 0);  /* check that GIT_REMOTE_REDIRECT_NONE is an integer */
  return n;
}

static int _cffi_const_GIT_REMOTE_REDIRECT_INITIAL(unsigned long long *o)
{
  int n = (GIT_REMOTE_REDIRECT_INITIAL) <= 0;
  *o = (unsigned long long)((GIT_REMOTE_REDIRECT_INITIAL) | 0);  /* check that GIT_REMOTE_REDIRECT_INITIAL is an integer */
  return n;
}

static int _cffi_const_GIT_REMOTE_REDIRECT_ALL(unsigned long long *o)
{
  int n = (GIT_REMOTE_REDIRECT_ALL) <= 0;
  *o = (unsigned long long)((GIT_REMOTE_REDIRECT_ALL) | 0);  /* check that GIT_REMOTE_REDIRECT_ALL is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_INIT_BARE(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_INIT_BARE) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_INIT_BARE) | 0);  /* check that GIT_REPOSITORY_INIT_BARE is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_INIT_NO_REINIT(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_INIT_NO_REINIT) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_INIT_NO_REINIT) | 0);  /* check that GIT_REPOSITORY_INIT_NO_REINIT is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_INIT_NO_DOTGIT_DIR(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_INIT_NO_DOTGIT_DIR) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_INIT_NO_DOTGIT_DIR) | 0);  /* check that GIT_REPOSITORY_INIT_NO_DOTGIT_DIR is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_INIT_MKDIR(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_INIT_MKDIR) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_INIT_MKDIR) | 0);  /* check that GIT_REPOSITORY_INIT_MKDIR is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_INIT_MKPATH(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_INIT_MKPATH) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_INIT_MKPATH) | 0);  /* check that GIT_REPOSITORY_INIT_MKPATH is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_INIT_EXTERNAL_TEMPLATE(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_INIT_EXTERNAL_TEMPLATE) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_INIT_EXTERNAL_TEMPLATE) | 0);  /* check that GIT_REPOSITORY_INIT_EXTERNAL_TEMPLATE is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_INIT_RELATIVE_GITLINK(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_INIT_RELATIVE_GITLINK) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_INIT_RELATIVE_GITLINK) | 0);  /* check that GIT_REPOSITORY_INIT_RELATIVE_GITLINK is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_INIT_SHARED_UMASK(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_INIT_SHARED_UMASK) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_INIT_SHARED_UMASK) | 0);  /* check that GIT_REPOSITORY_INIT_SHARED_UMASK is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_INIT_SHARED_GROUP(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_INIT_SHARED_GROUP) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_INIT_SHARED_GROUP) | 0);  /* check that GIT_REPOSITORY_INIT_SHARED_GROUP is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_INIT_SHARED_ALL(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_INIT_SHARED_ALL) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_INIT_SHARED_ALL) | 0);  /* check that GIT_REPOSITORY_INIT_SHARED_ALL is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_repository_init_options(git_repository_init_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_repository_init_options.version' is an integer */
  (void)((p->flags) | 0);  /* check that 'git_repository_init_options.flags' is an integer */
  (void)((p->mode) | 0);  /* check that 'git_repository_init_options.mode' is an integer */
  { char const * *tmp = &p->workdir_path; (void)tmp; }
  { char const * *tmp = &p->description; (void)tmp; }
  { char const * *tmp = &p->template_path; (void)tmp; }
  { char const * *tmp = &p->initial_head; (void)tmp; }
  { char const * *tmp = &p->origin_url; (void)tmp; }
}
struct _cffi_align_typedef_git_repository_init_options { char x; git_repository_init_options y; };

static int _cffi_const_GIT_REPOSITORY_OPEN_NO_SEARCH(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_OPEN_NO_SEARCH) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_OPEN_NO_SEARCH) | 0);  /* check that GIT_REPOSITORY_OPEN_NO_SEARCH is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_OPEN_CROSS_FS(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_OPEN_CROSS_FS) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_OPEN_CROSS_FS) | 0);  /* check that GIT_REPOSITORY_OPEN_CROSS_FS is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_OPEN_BARE(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_OPEN_BARE) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_OPEN_BARE) | 0);  /* check that GIT_REPOSITORY_OPEN_BARE is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_OPEN_NO_DOTGIT(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_OPEN_NO_DOTGIT) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_OPEN_NO_DOTGIT) | 0);  /* check that GIT_REPOSITORY_OPEN_NO_DOTGIT is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_OPEN_FROM_ENV(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_OPEN_FROM_ENV) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_OPEN_FROM_ENV) | 0);  /* check that GIT_REPOSITORY_OPEN_FROM_ENV is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_STATE_NONE(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_STATE_NONE) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_STATE_NONE) | 0);  /* check that GIT_REPOSITORY_STATE_NONE is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_STATE_MERGE(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_STATE_MERGE) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_STATE_MERGE) | 0);  /* check that GIT_REPOSITORY_STATE_MERGE is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_STATE_REVERT(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_STATE_REVERT) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_STATE_REVERT) | 0);  /* check that GIT_REPOSITORY_STATE_REVERT is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_STATE_REVERT_SEQUENCE(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_STATE_REVERT_SEQUENCE) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_STATE_REVERT_SEQUENCE) | 0);  /* check that GIT_REPOSITORY_STATE_REVERT_SEQUENCE is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_STATE_CHERRYPICK(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_STATE_CHERRYPICK) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_STATE_CHERRYPICK) | 0);  /* check that GIT_REPOSITORY_STATE_CHERRYPICK is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_STATE_CHERRYPICK_SEQUENCE(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_STATE_CHERRYPICK_SEQUENCE) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_STATE_CHERRYPICK_SEQUENCE) | 0);  /* check that GIT_REPOSITORY_STATE_CHERRYPICK_SEQUENCE is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_STATE_BISECT(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_STATE_BISECT) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_STATE_BISECT) | 0);  /* check that GIT_REPOSITORY_STATE_BISECT is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_STATE_REBASE(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_STATE_REBASE) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_STATE_REBASE) | 0);  /* check that GIT_REPOSITORY_STATE_REBASE is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_STATE_REBASE_INTERACTIVE(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_STATE_REBASE_INTERACTIVE) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_STATE_REBASE_INTERACTIVE) | 0);  /* check that GIT_REPOSITORY_STATE_REBASE_INTERACTIVE is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_STATE_REBASE_MERGE(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_STATE_REBASE_MERGE) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_STATE_REBASE_MERGE) | 0);  /* check that GIT_REPOSITORY_STATE_REBASE_MERGE is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_STATE_APPLY_MAILBOX(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_STATE_APPLY_MAILBOX) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_STATE_APPLY_MAILBOX) | 0);  /* check that GIT_REPOSITORY_STATE_APPLY_MAILBOX is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_STATE_APPLY_MAILBOX_OR_REBASE(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_STATE_APPLY_MAILBOX_OR_REBASE) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_STATE_APPLY_MAILBOX_OR_REBASE) | 0);  /* check that GIT_REPOSITORY_STATE_APPLY_MAILBOX_OR_REBASE is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_git_revert_options(git_revert_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_revert_options.version' is an integer */
  (void)((p->mainline) | 0);  /* check that 'git_revert_options.mainline' is an integer */
  { git_merge_options *tmp = &p->merge_opts; (void)tmp; }
  { git_checkout_options *tmp = &p->checkout_opts; (void)tmp; }
}
struct _cffi_align_typedef_git_revert_options { char x; git_revert_options y; };

static int _cffi_const_GIT_STASH_APPLY_DEFAULT(unsigned long long *o)
{
  int n = (GIT_STASH_APPLY_DEFAULT) <= 0;
  *o = (unsigned long long)((GIT_STASH_APPLY_DEFAULT) | 0);  /* check that GIT_STASH_APPLY_DEFAULT is an integer */
  return n;
}

static int _cffi_const_GIT_STASH_APPLY_REINSTATE_INDEX(unsigned long long *o)
{
  int n = (GIT_STASH_APPLY_REINSTATE_INDEX) <= 0;
  *o = (unsigned long long)((GIT_STASH_APPLY_REINSTATE_INDEX) | 0);  /* check that GIT_STASH_APPLY_REINSTATE_INDEX is an integer */
  return n;
}

static int _cffi_const_GIT_STASH_APPLY_PROGRESS_NONE(unsigned long long *o)
{
  int n = (GIT_STASH_APPLY_PROGRESS_NONE) <= 0;
  *o = (unsigned long long)((GIT_STASH_APPLY_PROGRESS_NONE) | 0);  /* check that GIT_STASH_APPLY_PROGRESS_NONE is an integer */
  return n;
}

static int _cffi_const_GIT_STASH_APPLY_PROGRESS_LOADING_STASH(unsigned long long *o)
{
  int n = (GIT_STASH_APPLY_PROGRESS_LOADING_STASH) <= 0;
  *o = (unsigned long long)((GIT_STASH_APPLY_PROGRESS_LOADING_STASH) | 0);  /* check that GIT_STASH_APPLY_PROGRESS_LOADING_STASH is an integer */
  return n;
}

static int _cffi_const_GIT_STASH_APPLY_PROGRESS_ANALYZE_INDEX(unsigned long long *o)
{
  int n = (GIT_STASH_APPLY_PROGRESS_ANALYZE_INDEX) <= 0;
  *o = (unsigned long long)((GIT_STASH_APPLY_PROGRESS_ANALYZE_INDEX) | 0);  /* check that GIT_STASH_APPLY_PROGRESS_ANALYZE_INDEX is an integer */
  return n;
}

static int _cffi_const_GIT_STASH_APPLY_PROGRESS_ANALYZE_MODIFIED(unsigned long long *o)
{
  int n = (GIT_STASH_APPLY_PROGRESS_ANALYZE_MODIFIED) <= 0;
  *o = (unsigned long long)((GIT_STASH_APPLY_PROGRESS_ANALYZE_MODIFIED) | 0);  /* check that GIT_STASH_APPLY_PROGRESS_ANALYZE_MODIFIED is an integer */
  return n;
}

static int _cffi_const_GIT_STASH_APPLY_PROGRESS_ANALYZE_UNTRACKED(unsigned long long *o)
{
  int n = (GIT_STASH_APPLY_PROGRESS_ANALYZE_UNTRACKED) <= 0;
  *o = (unsigned long long)((GIT_STASH_APPLY_PROGRESS_ANALYZE_UNTRACKED) | 0);  /* check that GIT_STASH_APPLY_PROGRESS_ANALYZE_UNTRACKED is an integer */
  return n;
}

static int _cffi_const_GIT_STASH_APPLY_PROGRESS_CHECKOUT_UNTRACKED(unsigned long long *o)
{
  int n = (GIT_STASH_APPLY_PROGRESS_CHECKOUT_UNTRACKED) <= 0;
  *o = (unsigned long long)((GIT_STASH_APPLY_PROGRESS_CHECKOUT_UNTRACKED) | 0);  /* check that GIT_STASH_APPLY_PROGRESS_CHECKOUT_UNTRACKED is an integer */
  return n;
}

static int _cffi_const_GIT_STASH_APPLY_PROGRESS_CHECKOUT_MODIFIED(unsigned long long *o)
{
  int n = (GIT_STASH_APPLY_PROGRESS_CHECKOUT_MODIFIED) <= 0;
  *o = (unsigned long long)((GIT_STASH_APPLY_PROGRESS_CHECKOUT_MODIFIED) | 0);  /* check that GIT_STASH_APPLY_PROGRESS_CHECKOUT_MODIFIED is an integer */
  return n;
}

static int _cffi_const_GIT_STASH_APPLY_PROGRESS_DONE(unsigned long long *o)
{
  int n = (GIT_STASH_APPLY_PROGRESS_DONE) <= 0;
  *o = (unsigned long long)((GIT_STASH_APPLY_PROGRESS_DONE) | 0);  /* check that GIT_STASH_APPLY_PROGRESS_DONE is an integer */
  return n;
}

static int _cffi_const_GIT_STASH_DEFAULT(unsigned long long *o)
{
  int n = (GIT_STASH_DEFAULT) <= 0;
  *o = (unsigned long long)((GIT_STASH_DEFAULT) | 0);  /* check that GIT_STASH_DEFAULT is an integer */
  return n;
}

static int _cffi_const_GIT_STASH_KEEP_INDEX(unsigned long long *o)
{
  int n = (GIT_STASH_KEEP_INDEX) <= 0;
  *o = (unsigned long long)((GIT_STASH_KEEP_INDEX) | 0);  /* check that GIT_STASH_KEEP_INDEX is an integer */
  return n;
}

static int _cffi_const_GIT_STASH_INCLUDE_UNTRACKED(unsigned long long *o)
{
  int n = (GIT_STASH_INCLUDE_UNTRACKED) <= 0;
  *o = (unsigned long long)((GIT_STASH_INCLUDE_UNTRACKED) | 0);  /* check that GIT_STASH_INCLUDE_UNTRACKED is an integer */
  return n;
}

static int _cffi_const_GIT_STASH_INCLUDE_IGNORED(unsigned long long *o)
{
  int n = (GIT_STASH_INCLUDE_IGNORED) <= 0;
  *o = (unsigned long long)((GIT_STASH_INCLUDE_IGNORED) | 0);  /* check that GIT_STASH_INCLUDE_IGNORED is an integer */
  return n;
}

static int _cffi_const_GIT_STASH_KEEP_ALL(unsigned long long *o)
{
  int n = (GIT_STASH_KEEP_ALL) <= 0;
  *o = (unsigned long long)((GIT_STASH_KEEP_ALL) | 0);  /* check that GIT_STASH_KEEP_ALL is an integer */
  return n;
}

static int _cffi_const_GIT_SUBMODULE_IGNORE_UNSPECIFIED(unsigned long long *o)
{
  int n = (GIT_SUBMODULE_IGNORE_UNSPECIFIED) <= 0;
  *o = (unsigned long long)((GIT_SUBMODULE_IGNORE_UNSPECIFIED) | 0);  /* check that GIT_SUBMODULE_IGNORE_UNSPECIFIED is an integer */
  return n;
}

static int _cffi_const_GIT_SUBMODULE_IGNORE_NONE(unsigned long long *o)
{
  int n = (GIT_SUBMODULE_IGNORE_NONE) <= 0;
  *o = (unsigned long long)((GIT_SUBMODULE_IGNORE_NONE) | 0);  /* check that GIT_SUBMODULE_IGNORE_NONE is an integer */
  return n;
}

static int _cffi_const_GIT_SUBMODULE_IGNORE_UNTRACKED(unsigned long long *o)
{
  int n = (GIT_SUBMODULE_IGNORE_UNTRACKED) <= 0;
  *o = (unsigned long long)((GIT_SUBMODULE_IGNORE_UNTRACKED) | 0);  /* check that GIT_SUBMODULE_IGNORE_UNTRACKED is an integer */
  return n;
}

static int _cffi_const_GIT_SUBMODULE_IGNORE_DIRTY(unsigned long long *o)
{
  int n = (GIT_SUBMODULE_IGNORE_DIRTY) <= 0;
  *o = (unsigned long long)((GIT_SUBMODULE_IGNORE_DIRTY) | 0);  /* check that GIT_SUBMODULE_IGNORE_DIRTY is an integer */
  return n;
}

static int _cffi_const_GIT_SUBMODULE_IGNORE_ALL(unsigned long long *o)
{
  int n = (GIT_SUBMODULE_IGNORE_ALL) <= 0;
  *o = (unsigned long long)((GIT_SUBMODULE_IGNORE_ALL) | 0);  /* check that GIT_SUBMODULE_IGNORE_ALL is an integer */
  return n;
}

static int _cffi_const_GIT_CERT_NONE(unsigned long long *o)
{
  int n = (GIT_CERT_NONE) <= 0;
  *o = (unsigned long long)((GIT_CERT_NONE) | 0);  /* check that GIT_CERT_NONE is an integer */
  return n;
}

static int _cffi_const_GIT_CERT_X509(unsigned long long *o)
{
  int n = (GIT_CERT_X509) <= 0;
  *o = (unsigned long long)((GIT_CERT_X509) | 0);  /* check that GIT_CERT_X509 is an integer */
  return n;
}

static int _cffi_const_GIT_CERT_HOSTKEY_LIBSSH2(unsigned long long *o)
{
  int n = (GIT_CERT_HOSTKEY_LIBSSH2) <= 0;
  *o = (unsigned long long)((GIT_CERT_HOSTKEY_LIBSSH2) | 0);  /* check that GIT_CERT_HOSTKEY_LIBSSH2 is an integer */
  return n;
}

static int _cffi_const_GIT_CERT_STRARRAY(unsigned long long *o)
{
  int n = (GIT_CERT_STRARRAY) <= 0;
  *o = (unsigned long long)((GIT_CERT_STRARRAY) | 0);  /* check that GIT_CERT_STRARRAY is an integer */
  return n;
}

static int _cffi_const_GIT_REMOTE_COMPLETION_DOWNLOAD(unsigned long long *o)
{
  int n = (GIT_REMOTE_COMPLETION_DOWNLOAD) <= 0;
  *o = (unsigned long long)((GIT_REMOTE_COMPLETION_DOWNLOAD) | 0);  /* check that GIT_REMOTE_COMPLETION_DOWNLOAD is an integer */
  return n;
}

static int _cffi_const_GIT_REMOTE_COMPLETION_INDEXING(unsigned long long *o)
{
  int n = (GIT_REMOTE_COMPLETION_INDEXING) <= 0;
  *o = (unsigned long long)((GIT_REMOTE_COMPLETION_INDEXING) | 0);  /* check that GIT_REMOTE_COMPLETION_INDEXING is an integer */
  return n;
}

static int _cffi_const_GIT_REMOTE_COMPLETION_ERROR(unsigned long long *o)
{
  int n = (GIT_REMOTE_COMPLETION_ERROR) <= 0;
  *o = (unsigned long long)((GIT_REMOTE_COMPLETION_ERROR) | 0);  /* check that GIT_REMOTE_COMPLETION_ERROR is an integer */
  return n;
}

static struct _cffi_externpy_s _cffi_externpy___certificate_check_cb =
  { "pygit2._libgit2._certificate_check_cb", (int)sizeof(int), 0, 0 };

static int _certificate_check_cb(git_cert * a0, int a1, char const * a2, void * a3)
{
  char a[32];
  char *p = a;
  *(git_cert * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(char const * *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___certificate_check_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___checkout_notify_cb =
  { "pygit2._libgit2._checkout_notify_cb", (int)sizeof(int), 0, 0 };

static int _checkout_notify_cb(git_checkout_notify_t a0, char const * a1, git_diff_file const * a2, git_diff_file const * a3, git_diff_file const * a4, void * a5)
{
  char a[48];
  char *p = a;
  *(git_checkout_notify_t *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(git_diff_file const * *)(p + 16) = a2;
  *(git_diff_file const * *)(p + 24) = a3;
  *(git_diff_file const * *)(p + 32) = a4;
  *(void * *)(p + 40) = a5;
  _cffi_call_python(&_cffi_externpy___checkout_notify_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___checkout_progress_cb =
  { "pygit2._libgit2._checkout_progress_cb", 0, 0, 0 };

static void _checkout_progress_cb(char const * a0, size_t a1, size_t a2, void * a3)
{
  char a[32];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(size_t *)(p + 8) = a1;
  *(size_t *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___checkout_progress_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy___credentials_cb =
  { "pygit2._libgit2._credentials_cb", (int)sizeof(int), 0, 0 };

static int _credentials_cb(git_credential * * a0, char const * a1, char const * a2, unsigned int a3, void * a4)
{
  char a[40];
  char *p = a;
  *(git_credential * * *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(char const * *)(p + 16) = a2;
  *(unsigned int *)(p + 24) = a3;
  *(void * *)(p + 32) = a4;
  _cffi_call_python(&_cffi_externpy___credentials_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___push_negotiation_cb =
  { "pygit2._libgit2._push_negotiation_cb", (int)sizeof(int), 0, 0 };

static int _push_negotiation_cb(git_push_update const * * a0, size_t a1, void * a2)
{
  char a[24];
  char *p = a;
  *(git_push_update const * * *)(p + 0) = a0;
  *(size_t *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___push_negotiation_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___push_transfer_progress_cb =
  { "pygit2._libgit2._push_transfer_progress_cb", (int)sizeof(int), 0, 0 };

static int _push_transfer_progress_cb(unsigned int a0, unsigned int a1, size_t a2, void * a3)
{
  char a[32];
  char *p = a;
  *(unsigned int *)(p + 0) = a0;
  *(unsigned int *)(p + 8) = a1;
  *(size_t *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___push_transfer_progress_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___push_update_reference_cb =
  { "pygit2._libgit2._push_update_reference_cb", (int)sizeof(int), 0, 0 };

static int _push_update_reference_cb(char const * a0, char const * a1, void * a2)
{
  char a[24];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___push_update_reference_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___remote_create_cb =
  { "pygit2._libgit2._remote_create_cb", (int)sizeof(int), 0, 0 };

static int _remote_create_cb(git_remote * * a0, git_repository * a1, char const * a2, char const * a3, void * a4)
{
  char a[40];
  char *p = a;
  *(git_remote * * *)(p + 0) = a0;
  *(git_repository * *)(p + 8) = a1;
  *(char const * *)(p + 16) = a2;
  *(char const * *)(p + 24) = a3;
  *(void * *)(p + 32) = a4;
  _cffi_call_python(&_cffi_externpy___remote_create_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___repository_create_cb =
  { "pygit2._libgit2._repository_create_cb", (int)sizeof(int), 0, 0 };

static int _repository_create_cb(git_repository * * a0, char const * a1, int a2, void * a3)
{
  char a[32];
  char *p = a;
  *(git_repository * * *)(p + 0) = a0;
  *(char const * *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___repository_create_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___sideband_progress_cb =
  { "pygit2._libgit2._sideband_progress_cb", (int)sizeof(int), 0, 0 };

static int _sideband_progress_cb(char const * a0, int a1, void * a2)
{
  char a[24];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(void * *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___sideband_progress_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___stash_apply_progress_cb =
  { "pygit2._libgit2._stash_apply_progress_cb", (int)sizeof(int), 0, 0 };

static int _stash_apply_progress_cb(git_stash_apply_progress_t a0, void * a1)
{
  char a[16];
  char *p = a;
  *(git_stash_apply_progress_t *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy___stash_apply_progress_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___transfer_progress_cb =
  { "pygit2._libgit2._transfer_progress_cb", (int)sizeof(int), 0, 0 };

static int _transfer_progress_cb(git_indexer_progress const * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(git_indexer_progress const * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy___transfer_progress_cb, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___update_tips_cb =
  { "pygit2._libgit2._update_tips_cb", (int)sizeof(int), 0, 0 };

static int _update_tips_cb(char const * a0, git_oid const * a1, git_oid const * a2, void * a3)
{
  char a[32];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(git_oid const * *)(p + 8) = a1;
  *(git_oid const * *)(p + 16) = a2;
  *(void * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___update_tips_cb, p);
  return *(int *)p;
}

static void _cffi_d_git_annotated_commit_free(git_annotated_commit * x0)
{
  git_annotated_commit_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_annotated_commit_free(PyObject *self, PyObject *arg0)
{
  git_annotated_commit * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(791), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_annotated_commit *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(791), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { git_annotated_commit_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_git_annotated_commit_free _cffi_d_git_annotated_commit_free
#endif

static int _cffi_d_git_annotated_commit_from_ref(git_annotated_commit * * x0, git_repository * x1, struct git_reference const * x2)
{
  return git_annotated_commit_from_ref(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_annotated_commit_from_ref(PyObject *self, PyObject *args)
{
  git_annotated_commit * * x0;
  git_repository * x1;
  struct git_reference const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_annotated_commit_from_ref", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(88), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_annotated_commit * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(88), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(95), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct git_reference const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(95), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_annotated_commit_from_ref(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_annotated_commit_from_ref _cffi_d_git_annotated_commit_from_ref
#endif

static int _cffi_d_git_annotated_commit_lookup(git_annotated_commit * * x0, git_repository * x1, git_oid const * x2)
{
  return git_annotated_commit_lookup(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_annotated_commit_lookup(PyObject *self, PyObject *args)
{
  git_annotated_commit * * x0;
  git_repository * x1;
  git_oid const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_annotated_commit_lookup", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(88), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_annotated_commit * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(88), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_oid const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_annotated_commit_lookup(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_annotated_commit_lookup _cffi_d_git_annotated_commit_lookup
#endif

static int _cffi_d_git_attr_get_ext(char const * * x0, git_repository * x1, git_attr_options * x2, char const * x3, char const * x4)
{
  return git_attr_get_ext(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_attr_get_ext(PyObject *self, PyObject *args)
{
  char const * * x0;
  git_repository * x1;
  git_attr_options * x2;
  char const * x3;
  char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_attr_get_ext", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(60), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_attr_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(60), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_attr_get_ext(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_attr_get_ext _cffi_d_git_attr_get_ext
#endif

static git_attr_value_t _cffi_d_git_attr_value(char const * x0)
{
  return git_attr_value(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_attr_value(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  git_attr_value_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_attr_value(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(849));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_attr_value _cffi_d_git_attr_value
#endif

static int _cffi_d_git_blame_file(git_blame * * x0, git_repository * x1, char const * x2, git_blame_options * x3)
{
  return git_blame_file(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_blame_file(PyObject *self, PyObject *args)
{
  git_blame * * x0;
  git_repository * x1;
  char const * x2;
  git_blame_options * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "git_blame_file", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_blame * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(101), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_blame_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(101), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_blame_file(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_blame_file _cffi_d_git_blame_file
#endif

static void _cffi_d_git_blame_free(git_blame * x0)
{
  git_blame_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_blame_free(PyObject *self, PyObject *arg0)
{
  git_blame * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_blame *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { git_blame_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_git_blame_free _cffi_d_git_blame_free
#endif

static git_blame_hunk const * _cffi_d_git_blame_get_hunk_byindex(git_blame * x0, uint32_t x1)
{
  return git_blame_get_hunk_byindex(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_blame_get_hunk_byindex(PyObject *self, PyObject *args)
{
  git_blame * x0;
  uint32_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  git_blame_hunk const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_blame_get_hunk_byindex", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_blame *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, uint32_t);
  if (x1 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_blame_get_hunk_byindex(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(851));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_blame_get_hunk_byindex _cffi_d_git_blame_get_hunk_byindex
#endif

static git_blame_hunk const * _cffi_d_git_blame_get_hunk_byline(git_blame * x0, size_t x1)
{
  return git_blame_get_hunk_byline(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_blame_get_hunk_byline(PyObject *self, PyObject *args)
{
  git_blame * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  git_blame_hunk const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_blame_get_hunk_byline", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_blame *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_blame_get_hunk_byline(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(851));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_blame_get_hunk_byline _cffi_d_git_blame_get_hunk_byline
#endif

static uint32_t _cffi_d_git_blame_get_hunk_count(git_blame * x0)
{
  return git_blame_get_hunk_count(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_blame_get_hunk_count(PyObject *self, PyObject *arg0)
{
  git_blame * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_blame *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_blame_get_hunk_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_blame_get_hunk_count _cffi_d_git_blame_get_hunk_count
#endif

static int _cffi_d_git_blame_options_init(git_blame_options * x0, unsigned int x1)
{
  return git_blame_options_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_blame_options_init(PyObject *self, PyObject *args)
{
  git_blame_options * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_blame_options_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(101), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_blame_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(101), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_blame_options_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_blame_options_init _cffi_d_git_blame_options_init
#endif

static void _cffi_d_git_buf_dispose(git_buf * x0)
{
  git_buf_dispose(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_buf_dispose(PyObject *self, PyObject *arg0)
{
  git_buf * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(108), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_buf *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(108), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { git_buf_dispose(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_git_buf_dispose _cffi_d_git_buf_dispose
#endif

static int _cffi_d_git_checkout_head(git_repository * x0, git_checkout_options const * x1)
{
  return git_checkout_head(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_checkout_head(PyObject *self, PyObject *args)
{
  git_repository * x0;
  git_checkout_options const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_checkout_head", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(595), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_checkout_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(595), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_checkout_head(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_checkout_head _cffi_d_git_checkout_head
#endif

static int _cffi_d_git_checkout_index(git_repository * x0, git_index * x1, git_checkout_options const * x2)
{
  return git_checkout_index(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_checkout_index(PyObject *self, PyObject *args)
{
  git_repository * x0;
  git_index * x1;
  git_checkout_options const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_checkout_index", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(595), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_checkout_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(595), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_checkout_index(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_checkout_index _cffi_d_git_checkout_index
#endif

static int _cffi_d_git_checkout_options_init(git_checkout_options * x0, unsigned int x1)
{
  return git_checkout_options_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_checkout_options_init(PyObject *self, PyObject *args)
{
  git_checkout_options * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_checkout_options_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(145), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_checkout_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(145), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_checkout_options_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_checkout_options_init _cffi_d_git_checkout_options_init
#endif

static int _cffi_d_git_checkout_tree(git_repository * x0, git_object const * x1, git_checkout_options const * x2)
{
  return git_checkout_tree(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_checkout_tree(PyObject *self, PyObject *args)
{
  git_repository * x0;
  git_object const * x1;
  git_checkout_options const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_checkout_tree", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(613), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_object const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(613), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(595), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_checkout_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(595), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_checkout_tree(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_checkout_tree _cffi_d_git_checkout_tree
#endif

static int _cffi_d_git_clone(git_repository * * x0, char const * x1, char const * x2, git_clone_options const * x3)
{
  return git_clone(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_clone(PyObject *self, PyObject *args)
{
  git_repository * * x0;
  char const * x1;
  char const * x2;
  git_clone_options const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "git_clone", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(542), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(542), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(545), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_clone_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(545), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_clone(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_clone _cffi_d_git_clone
#endif

static int _cffi_d_git_clone_options_init(git_clone_options * x0, unsigned int x1)
{
  return git_clone_options_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_clone_options_init(PyObject *self, PyObject *args)
{
  git_clone_options * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_clone_options_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(149), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_clone_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(149), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_clone_options_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_clone_options_init _cffi_d_git_clone_options_init
#endif

static int _cffi_d_git_commit_amend(git_oid * x0, git_commit const * x1, char const * x2, git_signature const * x3, git_signature const * x4, char const * x5, char const * x6, git_tree const * x7)
{
  return git_commit_amend(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_commit_amend(PyObject *self, PyObject *args)
{
  git_oid * x0;
  git_commit const * x1;
  char const * x2;
  git_signature const * x3;
  git_signature const * x4;
  char const * x5;
  char const * x6;
  git_tree const * x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "git_commit_amend", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(403), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_oid *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(403), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_commit const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(406), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_signature const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(406), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(406), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (git_signature const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(406), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(318), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (git_tree const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(318), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_commit_amend(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_commit_amend _cffi_d_git_commit_amend
#endif

static int _cffi_d_git_config_add_file_ondisk(git_config * x0, char const * x1, git_config_level_t x2, git_repository const * x3, int x4)
{
  return git_config_add_file_ondisk(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_add_file_ondisk(PyObject *self, PyObject *args)
{
  git_config * x0;
  char const * x1;
  git_config_level_t x2;
  git_repository const * x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_config_add_file_ondisk", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(185), arg2) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_repository const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_add_file_ondisk(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_add_file_ondisk _cffi_d_git_config_add_file_ondisk
#endif

static int _cffi_d_git_config_delete_entry(git_config * x0, char const * x1)
{
  return git_config_delete_entry(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_delete_entry(PyObject *self, PyObject *args)
{
  git_config * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_config_delete_entry", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_delete_entry(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_delete_entry _cffi_d_git_config_delete_entry
#endif

static int _cffi_d_git_config_delete_multivar(git_config * x0, char const * x1, char const * x2)
{
  return git_config_delete_multivar(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_delete_multivar(PyObject *self, PyObject *args)
{
  git_config * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_config_delete_multivar", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_delete_multivar(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_delete_multivar _cffi_d_git_config_delete_multivar
#endif

static void _cffi_d_git_config_entry_free(git_config_entry * x0)
{
  git_config_entry_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_entry_free(PyObject *self, PyObject *arg0)
{
  git_config_entry * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(807), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config_entry *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(807), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { git_config_entry_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_git_config_entry_free _cffi_d_git_config_entry_free
#endif

static int _cffi_d_git_config_find_global(git_buf * x0)
{
  return git_config_find_global(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_find_global(PyObject *self, PyObject *arg0)
{
  git_buf * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(108), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_buf *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(108), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_find_global(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_find_global _cffi_d_git_config_find_global
#endif

static int _cffi_d_git_config_find_system(git_buf * x0)
{
  return git_config_find_system(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_find_system(PyObject *self, PyObject *arg0)
{
  git_buf * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(108), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_buf *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(108), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_find_system(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_find_system _cffi_d_git_config_find_system
#endif

static int _cffi_d_git_config_find_xdg(git_buf * x0)
{
  return git_config_find_xdg(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_find_xdg(PyObject *self, PyObject *arg0)
{
  git_buf * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(108), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_buf *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(108), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_find_xdg(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_find_xdg _cffi_d_git_config_find_xdg
#endif

static void _cffi_d_git_config_free(git_config * x0)
{
  git_config_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_free(PyObject *self, PyObject *arg0)
{
  git_config * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { git_config_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_git_config_free _cffi_d_git_config_free
#endif

static int _cffi_d_git_config_get_entry(git_config_entry * * x0, git_config const * x1, char const * x2)
{
  return git_config_get_entry(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_get_entry(PyObject *self, PyObject *args)
{
  git_config_entry * * x0;
  git_config const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_config_get_entry", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(200), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config_entry * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(200), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(54), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_config const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(54), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_get_entry(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_get_entry _cffi_d_git_config_get_entry
#endif

static int _cffi_d_git_config_get_string(char const * * x0, git_config const * x1, char const * x2)
{
  return git_config_get_string(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_get_string(PyObject *self, PyObject *args)
{
  char const * * x0;
  git_config const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_config_get_string", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(54), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_config const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(54), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_get_string(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_get_string _cffi_d_git_config_get_string
#endif

static void _cffi_d_git_config_iterator_free(git_config_iterator * x0)
{
  git_config_iterator_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_iterator_free(PyObject *self, PyObject *arg0)
{
  git_config_iterator * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(206), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config_iterator *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(206), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { git_config_iterator_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_git_config_iterator_free _cffi_d_git_config_iterator_free
#endif

static int _cffi_d_git_config_iterator_new(git_config_iterator * * x0, git_config const * x1)
{
  return git_config_iterator_new(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_iterator_new(PyObject *self, PyObject *args)
{
  git_config_iterator * * x0;
  git_config const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_config_iterator_new", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(209), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config_iterator * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(209), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(54), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_config const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(54), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_iterator_new(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_iterator_new _cffi_d_git_config_iterator_new
#endif

static int _cffi_d_git_config_multivar_iterator_new(git_config_iterator * * x0, git_config const * x1, char const * x2, char const * x3)
{
  return git_config_multivar_iterator_new(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_multivar_iterator_new(PyObject *self, PyObject *args)
{
  git_config_iterator * * x0;
  git_config const * x1;
  char const * x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "git_config_multivar_iterator_new", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(209), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config_iterator * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(209), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(54), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_config const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(54), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_multivar_iterator_new(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_multivar_iterator_new _cffi_d_git_config_multivar_iterator_new
#endif

static int _cffi_d_git_config_new(git_config * * x0)
{
  return git_config_new(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_new(PyObject *self, PyObject *arg0)
{
  git_config * * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_new _cffi_d_git_config_new
#endif

static int _cffi_d_git_config_next(git_config_entry * * x0, git_config_iterator * x1)
{
  return git_config_next(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_next(PyObject *self, PyObject *args)
{
  git_config_entry * * x0;
  git_config_iterator * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_config_next", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(200), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config_entry * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(200), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(206), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_config_iterator *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(206), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_next(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_next _cffi_d_git_config_next
#endif

static int _cffi_d_git_config_open_ondisk(git_config * * x0, char const * x1)
{
  return git_config_open_ondisk(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_open_ondisk(PyObject *self, PyObject *args)
{
  git_config * * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_config_open_ondisk", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_open_ondisk(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_open_ondisk _cffi_d_git_config_open_ondisk
#endif

static int _cffi_d_git_config_parse_bool(int * x0, char const * x1)
{
  return git_config_parse_bool(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_parse_bool(PyObject *self, PyObject *args)
{
  int * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_config_parse_bool", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(698), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(698), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_parse_bool(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_parse_bool _cffi_d_git_config_parse_bool
#endif

static int _cffi_d_git_config_parse_int64(int64_t * x0, char const * x1)
{
  return git_config_parse_int64(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_parse_int64(PyObject *self, PyObject *args)
{
  int64_t * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_config_parse_int64", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(717), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (int64_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(717), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_parse_int64(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_parse_int64 _cffi_d_git_config_parse_int64
#endif

static int _cffi_d_git_config_set_bool(git_config * x0, char const * x1, int x2)
{
  return git_config_set_bool(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_set_bool(PyObject *self, PyObject *args)
{
  git_config * x0;
  char const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_config_set_bool", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_set_bool(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_set_bool _cffi_d_git_config_set_bool
#endif

static int _cffi_d_git_config_set_int64(git_config * x0, char const * x1, int64_t x2)
{
  return git_config_set_int64(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_set_int64(PyObject *self, PyObject *args)
{
  git_config * x0;
  char const * x1;
  int64_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_config_set_int64", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int64_t);
  if (x2 == (int64_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_set_int64(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_set_int64 _cffi_d_git_config_set_int64
#endif

static int _cffi_d_git_config_set_multivar(git_config * x0, char const * x1, char const * x2, char const * x3)
{
  return git_config_set_multivar(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_set_multivar(PyObject *self, PyObject *args)
{
  git_config * x0;
  char const * x1;
  char const * x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "git_config_set_multivar", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_set_multivar(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_set_multivar _cffi_d_git_config_set_multivar
#endif

static int _cffi_d_git_config_set_string(git_config * x0, char const * x1, char const * x2)
{
  return git_config_set_string(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_set_string(PyObject *self, PyObject *args)
{
  git_config * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_config_set_string", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_set_string(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_set_string _cffi_d_git_config_set_string
#endif

static int _cffi_d_git_config_snapshot(git_config * * x0, git_config * x1)
{
  return git_config_snapshot(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_config_snapshot(PyObject *self, PyObject *args)
{
  git_config * * x0;
  git_config * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_config_snapshot", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_config *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_config_snapshot(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_config_snapshot _cffi_d_git_config_snapshot
#endif

static int _cffi_d_git_credential_ssh_key_from_agent(git_credential * * x0, char const * x1)
{
  return git_credential_ssh_key_from_agent(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_credential_ssh_key_from_agent(PyObject *self, PyObject *args)
{
  git_credential * * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_credential_ssh_key_from_agent", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(219), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_credential * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(219), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_credential_ssh_key_from_agent(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_credential_ssh_key_from_agent _cffi_d_git_credential_ssh_key_from_agent
#endif

static int _cffi_d_git_credential_ssh_key_memory_new(git_credential * * x0, char const * x1, char const * x2, char const * x3, char const * x4)
{
  return git_credential_ssh_key_memory_new(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_credential_ssh_key_memory_new(PyObject *self, PyObject *args)
{
  git_credential * * x0;
  char const * x1;
  char const * x2;
  char const * x3;
  char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_credential_ssh_key_memory_new", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(219), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_credential * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(219), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_credential_ssh_key_memory_new(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_credential_ssh_key_memory_new _cffi_d_git_credential_ssh_key_memory_new
#endif

static int _cffi_d_git_credential_ssh_key_new(git_credential * * x0, char const * x1, char const * x2, char const * x3, char const * x4)
{
  return git_credential_ssh_key_new(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_credential_ssh_key_new(PyObject *self, PyObject *args)
{
  git_credential * * x0;
  char const * x1;
  char const * x2;
  char const * x3;
  char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_credential_ssh_key_new", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(219), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_credential * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(219), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_credential_ssh_key_new(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_credential_ssh_key_new _cffi_d_git_credential_ssh_key_new
#endif

static int _cffi_d_git_credential_username_new(git_credential * * x0, char const * x1)
{
  return git_credential_username_new(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_credential_username_new(PyObject *self, PyObject *args)
{
  git_credential * * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_credential_username_new", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(219), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_credential * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(219), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_credential_username_new(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_credential_username_new _cffi_d_git_credential_username_new
#endif

static int _cffi_d_git_credential_userpass_plaintext_new(git_credential * * x0, char const * x1, char const * x2)
{
  return git_credential_userpass_plaintext_new(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_credential_userpass_plaintext_new(PyObject *self, PyObject *args)
{
  git_credential * * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_credential_userpass_plaintext_new", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(219), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_credential * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(219), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_credential_userpass_plaintext_new(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_credential_userpass_plaintext_new _cffi_d_git_credential_userpass_plaintext_new
#endif

static int _cffi_d_git_describe_commit(git_describe_result * * x0, git_object * x1, git_describe_options * x2)
{
  return git_describe_commit(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_describe_commit(PyObject *self, PyObject *args)
{
  git_describe_result * * x0;
  git_object * x1;
  git_describe_options * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_describe_commit", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(250), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_describe_result * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(250), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(251), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_object *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(251), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(246), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_describe_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(246), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_describe_commit(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_describe_commit _cffi_d_git_describe_commit
#endif

static int _cffi_d_git_describe_format(git_buf * x0, git_describe_result const * x1, git_describe_format_options const * x2)
{
  return git_describe_format(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_describe_format(PyObject *self, PyObject *args)
{
  git_buf * x0;
  git_describe_result const * x1;
  git_describe_format_options const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_describe_format", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(108), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_buf *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(108), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(118), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_describe_result const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(118), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(119), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_describe_format_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(119), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_describe_format(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_describe_format _cffi_d_git_describe_format
#endif

static int _cffi_d_git_describe_init_format_options(git_describe_format_options * x0, unsigned int x1)
{
  return git_describe_init_format_options(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_describe_init_format_options(PyObject *self, PyObject *args)
{
  git_describe_format_options * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_describe_init_format_options", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(242), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_describe_format_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(242), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_describe_init_format_options(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_describe_init_format_options _cffi_d_git_describe_init_format_options
#endif

static int _cffi_d_git_describe_options_init(git_describe_options * x0, unsigned int x1)
{
  return git_describe_options_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_describe_options_init(PyObject *self, PyObject *args)
{
  git_describe_options * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_describe_options_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(246), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_describe_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(246), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_describe_options_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_describe_options_init _cffi_d_git_describe_options_init
#endif

static void _cffi_d_git_describe_result_free(git_describe_result * x0)
{
  git_describe_result_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_describe_result_free(PyObject *self, PyObject *arg0)
{
  git_describe_result * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(813), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_describe_result *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(813), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { git_describe_result_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_git_describe_result_free _cffi_d_git_describe_result_free
#endif

static int _cffi_d_git_describe_workdir(git_describe_result * * x0, git_repository * x1, git_describe_options * x2)
{
  return git_describe_workdir(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_describe_workdir(PyObject *self, PyObject *args)
{
  git_describe_result * * x0;
  git_repository * x1;
  git_describe_options * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_describe_workdir", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(250), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_describe_result * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(250), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(246), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_describe_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(246), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_describe_workdir(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_describe_workdir _cffi_d_git_describe_workdir
#endif

static int _cffi_d_git_diff_index_to_workdir(git_diff * * x0, git_repository * x1, git_index * x2, git_diff_options const * x3)
{
  return git_diff_index_to_workdir(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_diff_index_to_workdir(PyObject *self, PyObject *args)
{
  git_diff * * x0;
  git_repository * x1;
  git_index * x2;
  git_diff_options const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "git_diff_index_to_workdir", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(260), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_diff * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(260), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(263), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_diff_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(263), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_diff_index_to_workdir(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_diff_index_to_workdir _cffi_d_git_diff_index_to_workdir
#endif

static int _cffi_d_git_diff_options_init(git_diff_options * x0, unsigned int x1)
{
  return git_diff_options_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_diff_options_init(PyObject *self, PyObject *args)
{
  git_diff_options * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_diff_options_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(285), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_diff_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(285), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_diff_options_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_diff_options_init _cffi_d_git_diff_options_init
#endif

static int _cffi_d_git_diff_tree_to_index(git_diff * * x0, git_repository * x1, git_tree * x2, git_index * x3, git_diff_options const * x4)
{
  return git_diff_tree_to_index(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_diff_tree_to_index(PyObject *self, PyObject *args)
{
  git_diff * * x0;
  git_repository * x1;
  git_tree * x2;
  git_index * x3;
  git_diff_options const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_diff_tree_to_index", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(260), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_diff * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(260), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(268), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_tree *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(268), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(263), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (git_diff_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(263), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_diff_tree_to_index(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_diff_tree_to_index _cffi_d_git_diff_tree_to_index
#endif

static git_error const * _cffi_d_git_error_last(void)
{
  return git_error_last();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_error_last(PyObject *self, PyObject *noarg)
{
  git_error const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_error_last(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(884));
  return pyresult;
}
#else
#  define _cffi_f_git_error_last _cffi_d_git_error_last
#endif

static int _cffi_d_git_fetch_options_init(git_fetch_options * x0, unsigned int x1)
{
  return git_fetch_options_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_fetch_options_init(PyObject *self, PyObject *args)
{
  git_fetch_options * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_fetch_options_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(289), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_fetch_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(289), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_fetch_options_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_fetch_options_init _cffi_d_git_fetch_options_init
#endif

static int _cffi_d_git_graph_ahead_behind(size_t * x0, size_t * x1, git_repository * x2, git_oid const * x3, git_oid const * x4)
{
  return git_graph_ahead_behind(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_graph_ahead_behind(PyObject *self, PyObject *args)
{
  size_t * x0;
  size_t * x1;
  git_repository * x2;
  git_oid const * x3;
  git_oid const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_graph_ahead_behind", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(538), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(538), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(538), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(538), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_oid const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (git_oid const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_graph_ahead_behind(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_graph_ahead_behind _cffi_d_git_graph_ahead_behind
#endif

static int _cffi_d_git_index_add(git_index * x0, git_index_entry const * x1)
{
  return git_index_add(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_add(PyObject *self, PyObject *args)
{
  git_index * x0;
  git_index_entry const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_index_add", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(337), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_index_entry const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(337), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_add(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_add _cffi_d_git_index_add
#endif

static int _cffi_d_git_index_add_all(git_index * x0, git_strarray const * x1, unsigned int x2, int(* x3)(char const *, char const *, void *), void * x4)
{
  return git_index_add_all(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_add_all(PyObject *self, PyObject *args)
{
  git_index * x0;
  git_strarray const * x1;
  unsigned int x2;
  int(* x3)(char const *, char const *, void *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_index_add_all", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(347), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_strarray const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(347), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (int(*)(char const *, char const *, void *))_cffi_to_c_pointer(arg3, _cffi_type(348));
  if (x3 == (int(*)(char const *, char const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(67), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_add_all(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_add_all _cffi_d_git_index_add_all
#endif

static int _cffi_d_git_index_add_bypath(git_index * x0, char const * x1)
{
  return git_index_add_bypath(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_add_bypath(PyObject *self, PyObject *args)
{
  git_index * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_index_add_bypath", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_add_bypath(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_add_bypath _cffi_d_git_index_add_bypath
#endif

static int _cffi_d_git_index_clear(git_index * x0)
{
  return git_index_clear(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_clear(PyObject *self, PyObject *arg0)
{
  git_index * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_clear(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_clear _cffi_d_git_index_clear
#endif

static int _cffi_d_git_index_conflict_add(git_index * x0, git_index_entry const * x1, git_index_entry const * x2, git_index_entry const * x3)
{
  return git_index_conflict_add(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_conflict_add(PyObject *self, PyObject *args)
{
  git_index * x0;
  git_index_entry const * x1;
  git_index_entry const * x2;
  git_index_entry const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "git_index_conflict_add", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(337), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_index_entry const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(337), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(337), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_index_entry const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(337), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(337), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_index_entry const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(337), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_conflict_add(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_conflict_add _cffi_d_git_index_conflict_add
#endif

static int _cffi_d_git_index_conflict_get(git_index_entry const * * x0, git_index_entry const * * x1, git_index_entry const * * x2, git_index * x3, char const * x4)
{
  return git_index_conflict_get(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_conflict_get(PyObject *self, PyObject *args)
{
  git_index_entry const * * x0;
  git_index_entry const * * x1;
  git_index_entry const * * x2;
  git_index * x3;
  char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_index_conflict_get", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(374), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index_entry const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(374), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(374), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_index_entry const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(374), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(374), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_index_entry const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(374), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_conflict_get(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_conflict_get _cffi_d_git_index_conflict_get
#endif

static void _cffi_d_git_index_conflict_iterator_free(git_index_conflict_iterator * x0)
{
  git_index_conflict_iterator_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_conflict_iterator_free(PyObject *self, PyObject *arg0)
{
  git_index_conflict_iterator * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(384), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index_conflict_iterator *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(384), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { git_index_conflict_iterator_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_git_index_conflict_iterator_free _cffi_d_git_index_conflict_iterator_free
#endif

static int _cffi_d_git_index_conflict_iterator_new(git_index_conflict_iterator * * x0, git_index * x1)
{
  return git_index_conflict_iterator_new(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_conflict_iterator_new(PyObject *self, PyObject *args)
{
  git_index_conflict_iterator * * x0;
  git_index * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_index_conflict_iterator_new", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(370), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index_conflict_iterator * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(370), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_conflict_iterator_new(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_conflict_iterator_new _cffi_d_git_index_conflict_iterator_new
#endif

static int _cffi_d_git_index_conflict_next(git_index_entry const * * x0, git_index_entry const * * x1, git_index_entry const * * x2, git_index_conflict_iterator * x3)
{
  return git_index_conflict_next(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_conflict_next(PyObject *self, PyObject *args)
{
  git_index_entry const * * x0;
  git_index_entry const * * x1;
  git_index_entry const * * x2;
  git_index_conflict_iterator * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "git_index_conflict_next", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(374), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index_entry const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(374), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(374), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_index_entry const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(374), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(374), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_index_entry const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(374), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(384), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_index_conflict_iterator *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(384), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_conflict_next(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_conflict_next _cffi_d_git_index_conflict_next
#endif

static int _cffi_d_git_index_conflict_remove(git_index * x0, char const * x1)
{
  return git_index_conflict_remove(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_conflict_remove(PyObject *self, PyObject *args)
{
  git_index * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_index_conflict_remove", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_conflict_remove(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_conflict_remove _cffi_d_git_index_conflict_remove
#endif

static size_t _cffi_d_git_index_entrycount(git_index const * x0)
{
  return git_index_entrycount(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_entrycount(PyObject *self, PyObject *arg0)
{
  git_index const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(367), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(367), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_entrycount(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_entrycount _cffi_d_git_index_entrycount
#endif

static int _cffi_d_git_index_find(size_t * x0, git_index * x1, char const * x2)
{
  return git_index_find(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_find(PyObject *self, PyObject *args)
{
  size_t * x0;
  git_index * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_index_find", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(538), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(538), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_find(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_find _cffi_d_git_index_find
#endif

static void _cffi_d_git_index_free(git_index * x0)
{
  git_index_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_free(PyObject *self, PyObject *arg0)
{
  git_index * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { git_index_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_git_index_free _cffi_d_git_index_free
#endif

static git_index_entry const * _cffi_d_git_index_get_byindex(git_index * x0, size_t x1)
{
  return git_index_get_byindex(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_get_byindex(PyObject *self, PyObject *args)
{
  git_index * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  git_index_entry const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_index_get_byindex", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_get_byindex(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(337));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_get_byindex _cffi_d_git_index_get_byindex
#endif

static git_index_entry const * _cffi_d_git_index_get_bypath(git_index * x0, char const * x1, int x2)
{
  return git_index_get_bypath(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_get_bypath(PyObject *self, PyObject *args)
{
  git_index * x0;
  char const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  git_index_entry const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_index_get_bypath", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_get_bypath(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(337));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_get_bypath _cffi_d_git_index_get_bypath
#endif

static int _cffi_d_git_index_has_conflicts(git_index const * x0)
{
  return git_index_has_conflicts(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_has_conflicts(PyObject *self, PyObject *arg0)
{
  git_index const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(367), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(367), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_has_conflicts(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_has_conflicts _cffi_d_git_index_has_conflicts
#endif

static int _cffi_d_git_index_open(git_index * * x0, char const * x1)
{
  return git_index_open(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_open(PyObject *self, PyObject *args)
{
  git_index * * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_index_open", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(293), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(293), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_open(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_open _cffi_d_git_index_open
#endif

static int _cffi_d_git_index_read(git_index * x0, int x1)
{
  return git_index_read(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_read(PyObject *self, PyObject *args)
{
  git_index * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_index_read", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_read(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_read _cffi_d_git_index_read
#endif

static int _cffi_d_git_index_read_tree(git_index * x0, git_tree const * x1)
{
  return git_index_read_tree(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_read_tree(PyObject *self, PyObject *args)
{
  git_index * x0;
  git_tree const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_index_read_tree", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(318), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_tree const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(318), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_read_tree(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_read_tree _cffi_d_git_index_read_tree
#endif

static int _cffi_d_git_index_remove(git_index * x0, char const * x1, int x2)
{
  return git_index_remove(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_remove(PyObject *self, PyObject *args)
{
  git_index * x0;
  char const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_index_remove", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_remove(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_remove _cffi_d_git_index_remove
#endif

static int _cffi_d_git_index_remove_all(git_index * x0, git_strarray const * x1, int(* x2)(char const *, char const *, void *), void * x3)
{
  return git_index_remove_all(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_remove_all(PyObject *self, PyObject *args)
{
  git_index * x0;
  git_strarray const * x1;
  int(* x2)(char const *, char const *, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "git_index_remove_all", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(347), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_strarray const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(347), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (int(*)(char const *, char const *, void *))_cffi_to_c_pointer(arg2, _cffi_type(348));
  if (x2 == (int(*)(char const *, char const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(67), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_remove_all(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_remove_all _cffi_d_git_index_remove_all
#endif

static int _cffi_d_git_index_remove_directory(git_index * x0, char const * x1, int x2)
{
  return git_index_remove_directory(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_remove_directory(PyObject *self, PyObject *args)
{
  git_index * x0;
  char const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_index_remove_directory", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_remove_directory(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_remove_directory _cffi_d_git_index_remove_directory
#endif

static int _cffi_d_git_index_write(git_index * x0)
{
  return git_index_write(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_write(PyObject *self, PyObject *arg0)
{
  git_index * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_write(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_write _cffi_d_git_index_write
#endif

static int _cffi_d_git_index_write_tree(git_oid * x0, git_index * x1)
{
  return git_index_write_tree(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_write_tree(PyObject *self, PyObject *args)
{
  git_oid * x0;
  git_index * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_index_write_tree", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(403), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_oid *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(403), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_write_tree(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_write_tree _cffi_d_git_index_write_tree
#endif

static int _cffi_d_git_index_write_tree_to(git_oid * x0, git_index * x1, git_repository * x2)
{
  return git_index_write_tree_to(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_index_write_tree_to(PyObject *self, PyObject *args)
{
  git_oid * x0;
  git_index * x1;
  git_repository * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_index_write_tree_to", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(403), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_oid *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(403), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(26), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_index *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(26), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_index_write_tree_to(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_index_write_tree_to _cffi_d_git_index_write_tree_to
#endif

static int _cffi_d_git_libgit2_features(void)
{
  return git_libgit2_features();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_libgit2_features(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_libgit2_features(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_git_libgit2_features _cffi_d_git_libgit2_features
#endif

static void _cffi_const_git_libgit2_opts(char *o)
{
  *(int(* *)(int, ...))o = git_libgit2_opts;
}

static int _cffi_d_git_merge(git_repository * x0, git_annotated_commit const * * x1, size_t x2, git_merge_options const * x3, git_checkout_options const * x4)
{
  return git_merge(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_merge(PyObject *self, PyObject *args)
{
  git_repository * x0;
  git_annotated_commit const * * x1;
  size_t x2;
  git_merge_options const * x3;
  git_checkout_options const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_merge", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(592), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_annotated_commit const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(592), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(306), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_merge_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(306), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(595), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (git_checkout_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(595), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_merge(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_merge _cffi_d_git_merge
#endif

static int _cffi_d_git_merge_commits(git_index * * x0, git_repository * x1, git_commit const * x2, git_commit const * x3, git_merge_options const * x4)
{
  return git_merge_commits(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_merge_commits(PyObject *self, PyObject *args)
{
  git_index * * x0;
  git_repository * x1;
  git_commit const * x2;
  git_commit const * x3;
  git_merge_options const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_merge_commits", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(293), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(293), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_commit const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_commit const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(306), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (git_merge_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(306), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_merge_commits(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_merge_commits _cffi_d_git_merge_commits
#endif

static int _cffi_d_git_merge_file_from_index(git_merge_file_result * x0, git_repository * x1, git_index_entry const * x2, git_index_entry const * x3, git_index_entry const * x4, git_merge_file_options const * x5)
{
  return git_merge_file_from_index(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_merge_file_from_index(PyObject *self, PyObject *args)
{
  git_merge_file_result * x0;
  git_repository * x1;
  git_index_entry const * x2;
  git_index_entry const * x3;
  git_index_entry const * x4;
  git_merge_file_options const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "git_merge_file_from_index", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(391), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_merge_file_result *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(391), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(337), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_index_entry const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(337), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(337), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_index_entry const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(337), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(337), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (git_index_entry const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(337), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(396), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (git_merge_file_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(396), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_merge_file_from_index(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_merge_file_from_index _cffi_d_git_merge_file_from_index
#endif

static void _cffi_d_git_merge_file_result_free(git_merge_file_result * x0)
{
  git_merge_file_result_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_merge_file_result_free(PyObject *self, PyObject *arg0)
{
  git_merge_file_result * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(391), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_merge_file_result *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(391), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { git_merge_file_result_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_git_merge_file_result_free _cffi_d_git_merge_file_result_free
#endif

static int _cffi_d_git_merge_options_init(git_merge_options * x0, unsigned int x1)
{
  return git_merge_options_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_merge_options_init(PyObject *self, PyObject *args)
{
  git_merge_options * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_merge_options_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(399), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_merge_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(399), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_merge_options_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_merge_options_init _cffi_d_git_merge_options_init
#endif

static int _cffi_d_git_merge_trees(git_index * * x0, git_repository * x1, git_tree const * x2, git_tree const * x3, git_tree const * x4, git_merge_options const * x5)
{
  return git_merge_trees(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_merge_trees(PyObject *self, PyObject *args)
{
  git_index * * x0;
  git_repository * x1;
  git_tree const * x2;
  git_tree const * x3;
  git_tree const * x4;
  git_merge_options const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "git_merge_trees", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(293), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(293), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(318), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_tree const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(318), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(318), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_tree const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(318), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(318), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (git_tree const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(318), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(306), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (git_merge_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(306), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_merge_trees(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_merge_trees _cffi_d_git_merge_trees
#endif

static void _cffi_d_git_packbuilder_free(git_packbuilder * x0)
{
  git_packbuilder_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_packbuilder_free(PyObject *self, PyObject *arg0)
{
  git_packbuilder * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_packbuilder *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { git_packbuilder_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_git_packbuilder_free _cffi_d_git_packbuilder_free
#endif

static int _cffi_d_git_packbuilder_insert(git_packbuilder * x0, git_oid const * x1, char const * x2)
{
  return git_packbuilder_insert(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_packbuilder_insert(PyObject *self, PyObject *args)
{
  git_packbuilder * x0;
  git_oid const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_packbuilder_insert", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_packbuilder *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_oid const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_packbuilder_insert(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_packbuilder_insert _cffi_d_git_packbuilder_insert
#endif

static int _cffi_d_git_packbuilder_insert_recur(git_packbuilder * x0, git_oid const * x1, char const * x2)
{
  return git_packbuilder_insert_recur(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_packbuilder_insert_recur(PyObject *self, PyObject *args)
{
  git_packbuilder * x0;
  git_oid const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_packbuilder_insert_recur", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_packbuilder *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_oid const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_packbuilder_insert_recur(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_packbuilder_insert_recur _cffi_d_git_packbuilder_insert_recur
#endif

static int _cffi_d_git_packbuilder_new(git_packbuilder * * x0, git_repository * x1)
{
  return git_packbuilder_new(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_packbuilder_new(PyObject *self, PyObject *args)
{
  git_packbuilder * * x0;
  git_repository * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_packbuilder_new", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(441), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_packbuilder * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(441), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_packbuilder_new(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_packbuilder_new _cffi_d_git_packbuilder_new
#endif

static size_t _cffi_d_git_packbuilder_object_count(git_packbuilder * x0)
{
  return git_packbuilder_object_count(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_packbuilder_object_count(PyObject *self, PyObject *arg0)
{
  git_packbuilder * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_packbuilder *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_packbuilder_object_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_packbuilder_object_count _cffi_d_git_packbuilder_object_count
#endif

static unsigned int _cffi_d_git_packbuilder_set_threads(git_packbuilder * x0, unsigned int x1)
{
  return git_packbuilder_set_threads(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_packbuilder_set_threads(PyObject *self, PyObject *args)
{
  git_packbuilder * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_packbuilder_set_threads", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_packbuilder *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_packbuilder_set_threads(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_packbuilder_set_threads _cffi_d_git_packbuilder_set_threads
#endif

static int _cffi_d_git_packbuilder_write(git_packbuilder * x0, char const * x1, unsigned int x2, int(* x3)(git_indexer_progress const *, void *), void * x4)
{
  return git_packbuilder_write(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_packbuilder_write(PyObject *self, PyObject *args)
{
  git_packbuilder * x0;
  char const * x1;
  unsigned int x2;
  int(* x3)(git_indexer_progress const *, void *);
  void * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_packbuilder_write", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_packbuilder *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x3 = (int(*)(git_indexer_progress const *, void *))_cffi_to_c_pointer(arg3, _cffi_type(448));
  if (x3 == (int(*)(git_indexer_progress const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(67), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_packbuilder_write(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_packbuilder_write _cffi_d_git_packbuilder_write
#endif

static uint32_t _cffi_d_git_packbuilder_written(git_packbuilder * x0)
{
  return git_packbuilder_written(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_packbuilder_written(PyObject *self, PyObject *arg0)
{
  git_packbuilder * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(445), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_packbuilder *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(445), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_packbuilder_written(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_packbuilder_written _cffi_d_git_packbuilder_written
#endif

static int _cffi_d_git_proxy_options_init(git_proxy_options * x0, unsigned int x1)
{
  return git_proxy_options_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_proxy_options_init(PyObject *self, PyObject *args)
{
  git_proxy_options * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_proxy_options_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(457), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_proxy_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(457), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_proxy_options_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_proxy_options_init _cffi_d_git_proxy_options_init
#endif

static int _cffi_d_git_push_options_init(git_push_options * x0, unsigned int x1)
{
  return git_push_options_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_push_options_init(PyObject *self, PyObject *args)
{
  git_push_options * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_push_options_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(461), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_push_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(461), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_push_options_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_push_options_init _cffi_d_git_push_options_init
#endif

static git_direction _cffi_d_git_refspec_direction(git_refspec const * x0)
{
  return git_refspec_direction(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_refspec_direction(PyObject *self, PyObject *arg0)
{
  git_refspec const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  git_direction result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_refspec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_refspec_direction(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(883));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_refspec_direction _cffi_d_git_refspec_direction
#endif

static char const * _cffi_d_git_refspec_dst(git_refspec const * x0)
{
  return git_refspec_dst(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_refspec_dst(PyObject *self, PyObject *arg0)
{
  git_refspec const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_refspec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_refspec_dst(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(10));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_refspec_dst _cffi_d_git_refspec_dst
#endif

static int _cffi_d_git_refspec_dst_matches(git_refspec const * x0, char const * x1)
{
  return git_refspec_dst_matches(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_refspec_dst_matches(PyObject *self, PyObject *args)
{
  git_refspec const * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_refspec_dst_matches", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_refspec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_refspec_dst_matches(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_refspec_dst_matches _cffi_d_git_refspec_dst_matches
#endif

static int _cffi_d_git_refspec_force(git_refspec const * x0)
{
  return git_refspec_force(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_refspec_force(PyObject *self, PyObject *arg0)
{
  git_refspec const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_refspec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_refspec_force(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_refspec_force _cffi_d_git_refspec_force
#endif

static int _cffi_d_git_refspec_rtransform(git_buf * x0, git_refspec const * x1, char const * x2)
{
  return git_refspec_rtransform(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_refspec_rtransform(PyObject *self, PyObject *args)
{
  git_buf * x0;
  git_refspec const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_refspec_rtransform", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(108), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_buf *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(108), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_refspec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_refspec_rtransform(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_refspec_rtransform _cffi_d_git_refspec_rtransform
#endif

static char const * _cffi_d_git_refspec_src(git_refspec const * x0)
{
  return git_refspec_src(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_refspec_src(PyObject *self, PyObject *arg0)
{
  git_refspec const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_refspec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_refspec_src(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(10));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_refspec_src _cffi_d_git_refspec_src
#endif

static int _cffi_d_git_refspec_src_matches(git_refspec const * x0, char const * x1)
{
  return git_refspec_src_matches(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_refspec_src_matches(PyObject *self, PyObject *args)
{
  git_refspec const * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_refspec_src_matches", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_refspec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_refspec_src_matches(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_refspec_src_matches _cffi_d_git_refspec_src_matches
#endif

static char const * _cffi_d_git_refspec_string(git_refspec const * x0)
{
  return git_refspec_string(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_refspec_string(PyObject *self, PyObject *arg0)
{
  git_refspec const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_refspec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_refspec_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(10));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_refspec_string _cffi_d_git_refspec_string
#endif

static int _cffi_d_git_refspec_transform(git_buf * x0, git_refspec const * x1, char const * x2)
{
  return git_refspec_transform(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_refspec_transform(PyObject *self, PyObject *args)
{
  git_buf * x0;
  git_refspec const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_refspec_transform", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(108), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_buf *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(108), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_refspec const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_refspec_transform(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_refspec_transform _cffi_d_git_refspec_transform
#endif

static int _cffi_d_git_remote_add_fetch(git_repository * x0, char const * x1, char const * x2)
{
  return git_remote_add_fetch(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_add_fetch(PyObject *self, PyObject *args)
{
  git_repository * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_remote_add_fetch", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_add_fetch(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_add_fetch _cffi_d_git_remote_add_fetch
#endif

static int _cffi_d_git_remote_add_push(git_repository * x0, char const * x1, char const * x2)
{
  return git_remote_add_push(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_add_push(PyObject *self, PyObject *args)
{
  git_repository * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_remote_add_push", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_add_push(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_add_push _cffi_d_git_remote_add_push
#endif

static int _cffi_d_git_remote_connect(git_remote * x0, int x1, git_remote_callbacks const * x2, git_proxy_options const * x3, git_strarray const * x4)
{
  return git_remote_connect(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_connect(PyObject *self, PyObject *args)
{
  git_remote * x0;
  int x1;
  git_remote_callbacks const * x2;
  git_proxy_options const * x3;
  git_strarray const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_remote_connect", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(503), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_remote_callbacks const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(503), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(520), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_proxy_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(520), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(347), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (git_strarray const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(347), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_connect(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_connect _cffi_d_git_remote_connect
#endif

static int _cffi_d_git_remote_create(git_remote * * x0, git_repository * x1, char const * x2, char const * x3)
{
  return git_remote_create(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_create(PyObject *self, PyObject *args)
{
  git_remote * * x0;
  git_repository * x1;
  char const * x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "git_remote_create", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(477), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(477), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_create(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_create _cffi_d_git_remote_create
#endif

static int _cffi_d_git_remote_create_anonymous(git_remote * * x0, git_repository * x1, char const * x2)
{
  return git_remote_create_anonymous(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_create_anonymous(PyObject *self, PyObject *args)
{
  git_remote * * x0;
  git_repository * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_remote_create_anonymous", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(477), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(477), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_create_anonymous(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_create_anonymous _cffi_d_git_remote_create_anonymous
#endif

static int _cffi_d_git_remote_create_with_fetchspec(git_remote * * x0, git_repository * x1, char const * x2, char const * x3, char const * x4)
{
  return git_remote_create_with_fetchspec(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_create_with_fetchspec(PyObject *self, PyObject *args)
{
  git_remote * * x0;
  git_repository * x1;
  char const * x2;
  char const * x3;
  char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_remote_create_with_fetchspec", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(477), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(477), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_create_with_fetchspec(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_create_with_fetchspec _cffi_d_git_remote_create_with_fetchspec
#endif

static int _cffi_d_git_remote_delete(git_repository * x0, char const * x1)
{
  return git_remote_delete(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_delete(PyObject *self, PyObject *args)
{
  git_repository * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_remote_delete", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_delete(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_delete _cffi_d_git_remote_delete
#endif

static int _cffi_d_git_remote_fetch(git_remote * x0, git_strarray const * x1, git_fetch_options const * x2, char const * x3)
{
  return git_remote_fetch(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_fetch(PyObject *self, PyObject *args)
{
  git_remote * x0;
  git_strarray const * x1;
  git_fetch_options const * x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "git_remote_fetch", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(347), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_strarray const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(347), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(508), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_fetch_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(508), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_fetch(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_fetch _cffi_d_git_remote_fetch
#endif

static void _cffi_d_git_remote_free(git_remote * x0)
{
  git_remote_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_free(PyObject *self, PyObject *arg0)
{
  git_remote * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { git_remote_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_git_remote_free _cffi_d_git_remote_free
#endif

static int _cffi_d_git_remote_get_fetch_refspecs(git_strarray * x0, git_remote const * x1)
{
  return git_remote_get_fetch_refspecs(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_get_fetch_refspecs(PyObject *self, PyObject *args)
{
  git_strarray * x0;
  git_remote const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_remote_get_fetch_refspecs", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(651), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_strarray *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(651), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_remote const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_get_fetch_refspecs(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_get_fetch_refspecs _cffi_d_git_remote_get_fetch_refspecs
#endif

static int _cffi_d_git_remote_get_push_refspecs(git_strarray * x0, git_remote const * x1)
{
  return git_remote_get_push_refspecs(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_get_push_refspecs(PyObject *self, PyObject *args)
{
  git_strarray * x0;
  git_remote const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_remote_get_push_refspecs", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(651), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_strarray *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(651), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_remote const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_get_push_refspecs(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_get_push_refspecs _cffi_d_git_remote_get_push_refspecs
#endif

static git_refspec const * _cffi_d_git_remote_get_refspec(git_remote const * x0, size_t x1)
{
  return git_remote_get_refspec(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_get_refspec(PyObject *self, PyObject *args)
{
  git_remote const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  git_refspec const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_remote_get_refspec", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_get_refspec(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_get_refspec _cffi_d_git_remote_get_refspec
#endif

static int _cffi_d_git_remote_init_callbacks(git_remote_callbacks * x0, unsigned int x1)
{
  return git_remote_init_callbacks(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_init_callbacks(PyObject *self, PyObject *args)
{
  git_remote_callbacks * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_remote_init_callbacks", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(529), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote_callbacks *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(529), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_init_callbacks(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_init_callbacks _cffi_d_git_remote_init_callbacks
#endif

static int _cffi_d_git_remote_list(git_strarray * x0, git_repository * x1)
{
  return git_remote_list(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_list(PyObject *self, PyObject *args)
{
  git_strarray * x0;
  git_repository * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_remote_list", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(651), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_strarray *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(651), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_list(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_list _cffi_d_git_remote_list
#endif

static int _cffi_d_git_remote_lookup(git_remote * * x0, git_repository * x1, char const * x2)
{
  return git_remote_lookup(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_lookup(PyObject *self, PyObject *args)
{
  git_remote * * x0;
  git_repository * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_remote_lookup", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(477), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(477), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_lookup(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_lookup _cffi_d_git_remote_lookup
#endif

static int _cffi_d_git_remote_ls(git_remote_head const * * * x0, size_t * x1, git_remote * x2)
{
  return git_remote_ls(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_ls(PyObject *self, PyObject *args)
{
  git_remote_head const * * * x0;
  size_t * x1;
  git_remote * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_remote_ls", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(537), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote_head const * * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(537), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(538), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(538), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_remote *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_ls(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_ls _cffi_d_git_remote_ls
#endif

static char const * _cffi_d_git_remote_name(git_remote const * x0)
{
  return git_remote_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_name(PyObject *self, PyObject *arg0)
{
  git_remote const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(10));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_name _cffi_d_git_remote_name
#endif

static int _cffi_d_git_remote_prune(git_remote * x0, git_remote_callbacks const * x1)
{
  return git_remote_prune(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_prune(PyObject *self, PyObject *args)
{
  git_remote * x0;
  git_remote_callbacks const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_remote_prune", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(503), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_remote_callbacks const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(503), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_prune(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_prune _cffi_d_git_remote_prune
#endif

static int _cffi_d_git_remote_push(git_remote * x0, git_strarray const * x1, git_push_options const * x2)
{
  return git_remote_push(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_push(PyObject *self, PyObject *args)
{
  git_remote * x0;
  git_strarray const * x1;
  git_push_options const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_remote_push", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(347), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_strarray const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(347), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(514), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_push_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(514), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_push(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_push _cffi_d_git_remote_push
#endif

static char const * _cffi_d_git_remote_pushurl(git_remote const * x0)
{
  return git_remote_pushurl(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_pushurl(PyObject *self, PyObject *arg0)
{
  git_remote const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_pushurl(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(10));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_pushurl _cffi_d_git_remote_pushurl
#endif

static size_t _cffi_d_git_remote_refspec_count(git_remote const * x0)
{
  return git_remote_refspec_count(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_refspec_count(PyObject *self, PyObject *arg0)
{
  git_remote const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_refspec_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_refspec_count _cffi_d_git_remote_refspec_count
#endif

static int _cffi_d_git_remote_rename(git_strarray * x0, git_repository * x1, char const * x2, char const * x3)
{
  return git_remote_rename(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_rename(PyObject *self, PyObject *args)
{
  git_strarray * x0;
  git_repository * x1;
  char const * x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "git_remote_rename", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(651), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_strarray *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(651), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_rename(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_rename _cffi_d_git_remote_rename
#endif

static int _cffi_d_git_remote_set_pushurl(git_repository * x0, char const * x1, char const * x2)
{
  return git_remote_set_pushurl(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_set_pushurl(PyObject *self, PyObject *args)
{
  git_repository * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_remote_set_pushurl", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_set_pushurl(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_set_pushurl _cffi_d_git_remote_set_pushurl
#endif

static int _cffi_d_git_remote_set_url(git_repository * x0, char const * x1, char const * x2)
{
  return git_remote_set_url(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_set_url(PyObject *self, PyObject *args)
{
  git_repository * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_remote_set_url", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_set_url(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_set_url _cffi_d_git_remote_set_url
#endif

static git_indexer_progress const * _cffi_d_git_remote_stats(git_remote * x0)
{
  return git_remote_stats(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_stats(PyObject *self, PyObject *arg0)
{
  git_remote * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  git_indexer_progress const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_stats(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(387));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_stats _cffi_d_git_remote_stats
#endif

static char const * _cffi_d_git_remote_url(git_remote const * x0)
{
  return git_remote_url(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_remote_url(PyObject *self, PyObject *arg0)
{
  git_remote const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_remote const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_remote_url(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(10));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_remote_url _cffi_d_git_remote_url
#endif

static int _cffi_d_git_repository_config(git_config * * x0, git_repository * x1)
{
  return git_repository_config(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_config(PyObject *self, PyObject *args)
{
  git_config * * x0;
  git_repository * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_repository_config", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_config(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_config _cffi_d_git_repository_config
#endif

static int _cffi_d_git_repository_config_snapshot(git_config * * x0, git_repository * x1)
{
  return git_repository_config_snapshot(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_config_snapshot(PyObject *self, PyObject *args)
{
  git_config * * x0;
  git_repository * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_repository_config_snapshot", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(153), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_config * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(153), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_config_snapshot(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_config_snapshot _cffi_d_git_repository_config_snapshot
#endif

static void _cffi_d_git_repository_free(git_repository * x0)
{
  git_repository_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_free(PyObject *self, PyObject *arg0)
{
  git_repository * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { git_repository_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_git_repository_free _cffi_d_git_repository_free
#endif

static int _cffi_d_git_repository_hashfile(git_oid * x0, git_repository * x1, char const * x2, git_object_t x3, char const * x4)
{
  return git_repository_hashfile(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_hashfile(PyObject *self, PyObject *args)
{
  git_oid * x0;
  git_repository * x1;
  char const * x2;
  git_object_t x3;
  char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_repository_hashfile", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(403), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_oid *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(403), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x3, _cffi_type(425), arg3) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_hashfile(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_hashfile _cffi_d_git_repository_hashfile
#endif

static int _cffi_d_git_repository_ident(char const * * x0, char const * * x1, git_repository const * x2)
{
  return git_repository_ident(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_ident(PyObject *self, PyObject *args)
{
  char const * * x0;
  char const * * x1;
  git_repository const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_repository_ident", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(48), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(48), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_repository const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_ident(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_ident _cffi_d_git_repository_ident
#endif

static int _cffi_d_git_repository_index(git_index * * x0, git_repository * x1)
{
  return git_repository_index(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_index(PyObject *self, PyObject *args)
{
  git_index * * x0;
  git_repository * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_repository_index", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(293), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(293), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_index(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_index _cffi_d_git_repository_index
#endif

static int _cffi_d_git_repository_init(git_repository * * x0, char const * x1, unsigned int x2)
{
  return git_repository_init(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_init(PyObject *self, PyObject *args)
{
  git_repository * * x0;
  char const * x1;
  unsigned int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_repository_init", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(542), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(542), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_init(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_init _cffi_d_git_repository_init
#endif

static int _cffi_d_git_repository_init_ext(git_repository * * x0, char const * x1, git_repository_init_options * x2)
{
  return git_repository_init_ext(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_init_ext(PyObject *self, PyObject *args)
{
  git_repository * * x0;
  char const * x1;
  git_repository_init_options * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_repository_init_ext", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(542), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(542), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(550), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_repository_init_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(550), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_init_ext(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_init_ext _cffi_d_git_repository_init_ext
#endif

static int _cffi_d_git_repository_init_options_init(git_repository_init_options * x0, unsigned int x1)
{
  return git_repository_init_options_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_init_options_init(PyObject *self, PyObject *args)
{
  git_repository_init_options * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_repository_init_options_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(550), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository_init_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(550), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_init_options_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_init_options_init _cffi_d_git_repository_init_options_init
#endif

static int _cffi_d_git_repository_message(git_buf * x0, git_repository * x1)
{
  return git_repository_message(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_message(PyObject *self, PyObject *args)
{
  git_buf * x0;
  git_repository * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_repository_message", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(108), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_buf *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(108), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_message(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_message _cffi_d_git_repository_message
#endif

static int _cffi_d_git_repository_message_remove(git_repository * x0)
{
  return git_repository_message_remove(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_message_remove(PyObject *self, PyObject *arg0)
{
  git_repository * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_message_remove(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_message_remove _cffi_d_git_repository_message_remove
#endif

static int _cffi_d_git_repository_open_ext(git_repository * * x0, char const * x1, unsigned int x2, char const * x3)
{
  return git_repository_open_ext(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_open_ext(PyObject *self, PyObject *args)
{
  git_repository * * x0;
  char const * x1;
  unsigned int x2;
  char const * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "git_repository_open_ext", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(542), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(542), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned int);
  if (x2 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_open_ext(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_open_ext _cffi_d_git_repository_open_ext
#endif

static int _cffi_d_git_repository_set_head(git_repository * x0, char const * x1)
{
  return git_repository_set_head(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_set_head(PyObject *self, PyObject *args)
{
  git_repository * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_repository_set_head", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_set_head(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_set_head _cffi_d_git_repository_set_head
#endif

static int _cffi_d_git_repository_set_head_detached(git_repository * x0, git_oid const * x1)
{
  return git_repository_set_head_detached(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_set_head_detached(PyObject *self, PyObject *args)
{
  git_repository * x0;
  git_oid const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_repository_set_head_detached", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(71), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_oid const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(71), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_set_head_detached(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_set_head_detached _cffi_d_git_repository_set_head_detached
#endif

static int _cffi_d_git_repository_set_ident(git_repository * x0, char const * x1, char const * x2)
{
  return git_repository_set_ident(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_set_ident(PyObject *self, PyObject *args)
{
  git_repository * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_repository_set_ident", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_set_ident(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_set_ident _cffi_d_git_repository_set_ident
#endif

static git_repository_state_t _cffi_d_git_repository_state(git_repository * x0)
{
  return git_repository_state(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_state(PyObject *self, PyObject *arg0)
{
  git_repository * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  git_repository_state_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_state(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(925));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_state _cffi_d_git_repository_state
#endif

static int _cffi_d_git_repository_state_cleanup(git_repository * x0)
{
  return git_repository_state_cleanup(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_state_cleanup(PyObject *self, PyObject *arg0)
{
  git_repository * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_state_cleanup(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_state_cleanup _cffi_d_git_repository_state_cleanup
#endif

static int _cffi_d_git_repository_submodule_cache_all(git_repository * x0)
{
  return git_repository_submodule_cache_all(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_submodule_cache_all(PyObject *self, PyObject *arg0)
{
  git_repository * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_submodule_cache_all(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_submodule_cache_all _cffi_d_git_repository_submodule_cache_all
#endif

static int _cffi_d_git_repository_submodule_cache_clear(git_repository * x0)
{
  return git_repository_submodule_cache_clear(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_repository_submodule_cache_clear(PyObject *self, PyObject *arg0)
{
  git_repository * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_repository_submodule_cache_clear(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_repository_submodule_cache_clear _cffi_d_git_repository_submodule_cache_clear
#endif

static int _cffi_d_git_revert(git_repository * x0, git_commit * x1, git_revert_options const * x2)
{
  return git_revert(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_revert(PyObject *self, PyObject *args)
{
  git_repository * x0;
  git_commit * x1;
  git_revert_options const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_revert", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(303), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_commit *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(303), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(604), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_revert_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(604), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_revert(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_revert _cffi_d_git_revert
#endif

static int _cffi_d_git_revert_commit(git_index * * x0, git_repository * x1, git_commit * x2, git_commit * x3, unsigned int x4, git_merge_options const * x5)
{
  return git_revert_commit(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_revert_commit(PyObject *self, PyObject *args)
{
  git_index * * x0;
  git_repository * x1;
  git_commit * x2;
  git_commit * x3;
  unsigned int x4;
  git_merge_options const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "git_revert_commit", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(293), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_index * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(293), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(303), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_commit *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(303), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(303), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (git_commit *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(303), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(306), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (git_merge_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(306), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_revert_commit(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_revert_commit _cffi_d_git_revert_commit
#endif

static int _cffi_d_git_stash_apply(git_repository * x0, size_t x1, git_stash_apply_options const * x2)
{
  return git_stash_apply(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_stash_apply(PyObject *self, PyObject *args)
{
  git_repository * x0;
  size_t x1;
  git_stash_apply_options const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_stash_apply", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(632), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_stash_apply_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(632), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_stash_apply(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_stash_apply _cffi_d_git_stash_apply
#endif

static int _cffi_d_git_stash_apply_options_init(git_stash_apply_options * x0, unsigned int x1)
{
  return git_stash_apply_options_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_stash_apply_options_init(PyObject *self, PyObject *args)
{
  git_stash_apply_options * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_stash_apply_options_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(639), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_stash_apply_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(639), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_stash_apply_options_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_stash_apply_options_init _cffi_d_git_stash_apply_options_init
#endif

static int _cffi_d_git_stash_drop(git_repository * x0, size_t x1)
{
  return git_stash_drop(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_stash_drop(PyObject *self, PyObject *args)
{
  git_repository * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_stash_drop", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_stash_drop(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_stash_drop _cffi_d_git_stash_drop
#endif

static int _cffi_d_git_stash_foreach(git_repository * x0, int(* x1)(size_t, char const *, git_oid const *, void *), void * x2)
{
  return git_stash_foreach(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_stash_foreach(PyObject *self, PyObject *args)
{
  git_repository * x0;
  int(* x1)(size_t, char const *, git_oid const *, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_stash_foreach", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(size_t, char const *, git_oid const *, void *))_cffi_to_c_pointer(arg1, _cffi_type(622));
  if (x1 == (int(*)(size_t, char const *, git_oid const *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(67), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(67), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_stash_foreach(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_stash_foreach _cffi_d_git_stash_foreach
#endif

static int _cffi_d_git_stash_pop(git_repository * x0, size_t x1, git_stash_apply_options const * x2)
{
  return git_stash_pop(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_stash_pop(PyObject *self, PyObject *args)
{
  git_repository * x0;
  size_t x1;
  git_stash_apply_options const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_stash_pop", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(632), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_stash_apply_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(632), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_stash_pop(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_stash_pop _cffi_d_git_stash_pop
#endif

static int _cffi_d_git_stash_save(git_oid * x0, git_repository * x1, git_signature const * x2, char const * x3, uint32_t x4)
{
  return git_stash_save(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_stash_save(PyObject *self, PyObject *args)
{
  git_oid * x0;
  git_repository * x1;
  git_signature const * x2;
  char const * x3;
  uint32_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_stash_save", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(403), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_oid *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(403), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(406), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_signature const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(406), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, uint32_t);
  if (x4 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_stash_save(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_stash_save _cffi_d_git_stash_save
#endif

static int _cffi_d_git_stash_save_options_init(git_stash_save_options * x0, unsigned int x1)
{
  return git_stash_save_options_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_stash_save_options_init(PyObject *self, PyObject *args)
{
  git_stash_save_options * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_stash_save_options_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(647), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_stash_save_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(647), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_stash_save_options_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_stash_save_options_init _cffi_d_git_stash_save_options_init
#endif

static int _cffi_d_git_stash_save_with_opts(git_oid * x0, git_repository * x1, git_stash_save_options const * x2)
{
  return git_stash_save_with_opts(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_stash_save_with_opts(PyObject *self, PyObject *args)
{
  git_oid * x0;
  git_repository * x1;
  git_stash_save_options const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_stash_save_with_opts", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(403), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_oid *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(403), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(438), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_stash_save_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(438), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_stash_save_with_opts(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_stash_save_with_opts _cffi_d_git_stash_save_with_opts
#endif

static void _cffi_d_git_strarray_dispose(git_strarray * x0)
{
  git_strarray_dispose(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_strarray_dispose(PyObject *self, PyObject *arg0)
{
  git_strarray * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(651), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_strarray *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(651), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { git_strarray_dispose(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_git_strarray_dispose _cffi_d_git_strarray_dispose
#endif

static int _cffi_d_git_submodule_add_finalize(git_submodule * x0)
{
  return git_submodule_add_finalize(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_add_finalize(PyObject *self, PyObject *arg0)
{
  git_submodule * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_submodule *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_add_finalize(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_add_finalize _cffi_d_git_submodule_add_finalize
#endif

static int _cffi_d_git_submodule_add_setup(git_submodule * * x0, git_repository * x1, char const * x2, char const * x3, int x4)
{
  return git_submodule_add_setup(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_add_setup(PyObject *self, PyObject *args)
{
  git_submodule * * x0;
  git_repository * x1;
  char const * x2;
  char const * x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "git_submodule_add_setup", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(665), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_submodule * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(665), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_add_setup(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_add_setup _cffi_d_git_submodule_add_setup
#endif

static char const * _cffi_d_git_submodule_branch(git_submodule * x0)
{
  return git_submodule_branch(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_branch(PyObject *self, PyObject *arg0)
{
  git_submodule * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_submodule *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_branch(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(10));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_branch _cffi_d_git_submodule_branch
#endif

static int _cffi_d_git_submodule_clone(git_repository * * x0, git_submodule * x1, git_submodule_update_options const * x2)
{
  return git_submodule_clone(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_clone(PyObject *self, PyObject *args)
{
  git_repository * * x0;
  git_submodule * x1;
  git_submodule_update_options const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_submodule_clone", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(542), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(542), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_submodule *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(576), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_submodule_update_options const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(576), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_clone(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_clone _cffi_d_git_submodule_clone
#endif

static void _cffi_d_git_submodule_free(git_submodule * x0)
{
  git_submodule_free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_free(PyObject *self, PyObject *arg0)
{
  git_submodule * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_submodule *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { git_submodule_free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_git_submodule_free _cffi_d_git_submodule_free
#endif

static git_oid const * _cffi_d_git_submodule_head_id(git_submodule * x0)
{
  return git_submodule_head_id(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_head_id(PyObject *self, PyObject *arg0)
{
  git_submodule * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  git_oid const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_submodule *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_head_id(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(71));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_head_id _cffi_d_git_submodule_head_id
#endif

static int _cffi_d_git_submodule_init(git_submodule * x0, int x1)
{
  return git_submodule_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_init(PyObject *self, PyObject *args)
{
  git_submodule * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_submodule_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_submodule *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_init _cffi_d_git_submodule_init
#endif

static int _cffi_d_git_submodule_lookup(git_submodule * * x0, git_repository * x1, char const * x2)
{
  return git_submodule_lookup(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_lookup(PyObject *self, PyObject *args)
{
  git_submodule * * x0;
  git_repository * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_submodule_lookup", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(665), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_submodule * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(665), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_lookup(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_lookup _cffi_d_git_submodule_lookup
#endif

static char const * _cffi_d_git_submodule_name(git_submodule * x0)
{
  return git_submodule_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_name(PyObject *self, PyObject *arg0)
{
  git_submodule * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_submodule *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(10));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_name _cffi_d_git_submodule_name
#endif

static int _cffi_d_git_submodule_open(git_repository * * x0, git_submodule * x1)
{
  return git_submodule_open(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_open(PyObject *self, PyObject *args)
{
  git_repository * * x0;
  git_submodule * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_submodule_open", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(542), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(542), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_submodule *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_open(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_open _cffi_d_git_submodule_open
#endif

static char const * _cffi_d_git_submodule_path(git_submodule * x0)
{
  return git_submodule_path(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_path(PyObject *self, PyObject *arg0)
{
  git_submodule * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_submodule *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_path(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(10));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_path _cffi_d_git_submodule_path
#endif

static int _cffi_d_git_submodule_reload(git_submodule * x0, int x1)
{
  return git_submodule_reload(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_reload(PyObject *self, PyObject *args)
{
  git_submodule * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_submodule_reload", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_submodule *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_reload(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_reload _cffi_d_git_submodule_reload
#endif

static int _cffi_d_git_submodule_set_url(git_repository * x0, char const * x1, char const * x2)
{
  return git_submodule_set_url(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_set_url(PyObject *self, PyObject *args)
{
  git_repository * x0;
  char const * x1;
  char const * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_submodule_set_url", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_set_url(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_set_url _cffi_d_git_submodule_set_url
#endif

static int _cffi_d_git_submodule_status(unsigned int * x0, git_repository * x1, char const * x2, git_submodule_ignore_t x3)
{
  return git_submodule_status(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_status(PyObject *self, PyObject *args)
{
  unsigned int * x0;
  git_repository * x1;
  char const * x2;
  git_submodule_ignore_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "git_submodule_status", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(739), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(739), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (git_repository *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(10), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(10), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x3, _cffi_type(742), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_status(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_status _cffi_d_git_submodule_status
#endif

static int _cffi_d_git_submodule_update(git_submodule * x0, int x1, git_submodule_update_options * x2)
{
  return git_submodule_update(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_update(PyObject *self, PyObject *args)
{
  git_submodule * x0;
  int x1;
  git_submodule_update_options * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "git_submodule_update", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_submodule *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(686), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (git_submodule_update_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(686), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_update(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_update _cffi_d_git_submodule_update
#endif

static int _cffi_d_git_submodule_update_options_init(git_submodule_update_options * x0, unsigned int x1)
{
  return git_submodule_update_options_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_update_options_init(PyObject *self, PyObject *args)
{
  git_submodule_update_options * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "git_submodule_update_options_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(686), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_submodule_update_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(686), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_update_options_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_update_options_init _cffi_d_git_submodule_update_options_init
#endif

static char const * _cffi_d_git_submodule_url(git_submodule * x0)
{
  return git_submodule_url(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_git_submodule_url(PyObject *self, PyObject *arg0)
{
  git_submodule * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(7), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (git_submodule *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(7), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = git_submodule_url(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(10));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_git_submodule_url _cffi_d_git_submodule_url
#endif

static int _cffi_const_GIT_ATTR_CHECK_FILE_THEN_INDEX(unsigned long long *o)
{
  int n = (GIT_ATTR_CHECK_FILE_THEN_INDEX) <= 0;
  *o = (unsigned long long)((GIT_ATTR_CHECK_FILE_THEN_INDEX) | 0);  /* check that GIT_ATTR_CHECK_FILE_THEN_INDEX is an integer */
  if (!_cffi_check_int(*o, n, 0))
    n |= 2;
  return n;
}

static int _cffi_const_GIT_ATTR_CHECK_INCLUDE_COMMIT(unsigned long long *o)
{
  int n = (GIT_ATTR_CHECK_INCLUDE_COMMIT) <= 0;
  *o = (unsigned long long)((GIT_ATTR_CHECK_INCLUDE_COMMIT) | 0);  /* check that GIT_ATTR_CHECK_INCLUDE_COMMIT is an integer */
  if (!_cffi_check_int(*o, n, 16U))
    n |= 2;
  return n;
}

static int _cffi_const_GIT_ATTR_CHECK_INCLUDE_HEAD(unsigned long long *o)
{
  int n = (GIT_ATTR_CHECK_INCLUDE_HEAD) <= 0;
  *o = (unsigned long long)((GIT_ATTR_CHECK_INCLUDE_HEAD) | 0);  /* check that GIT_ATTR_CHECK_INCLUDE_HEAD is an integer */
  if (!_cffi_check_int(*o, n, 8U))
    n |= 2;
  return n;
}

static int _cffi_const_GIT_ATTR_CHECK_INDEX_ONLY(unsigned long long *o)
{
  int n = (GIT_ATTR_CHECK_INDEX_ONLY) <= 0;
  *o = (unsigned long long)((GIT_ATTR_CHECK_INDEX_ONLY) | 0);  /* check that GIT_ATTR_CHECK_INDEX_ONLY is an integer */
  if (!_cffi_check_int(*o, n, 2U))
    n |= 2;
  return n;
}

static int _cffi_const_GIT_ATTR_CHECK_INDEX_THEN_FILE(unsigned long long *o)
{
  int n = (GIT_ATTR_CHECK_INDEX_THEN_FILE) <= 0;
  *o = (unsigned long long)((GIT_ATTR_CHECK_INDEX_THEN_FILE) | 0);  /* check that GIT_ATTR_CHECK_INDEX_THEN_FILE is an integer */
  if (!_cffi_check_int(*o, n, 1U))
    n |= 2;
  return n;
}

static int _cffi_const_GIT_ATTR_CHECK_NO_SYSTEM(unsigned long long *o)
{
  int n = (GIT_ATTR_CHECK_NO_SYSTEM) <= 0;
  *o = (unsigned long long)((GIT_ATTR_CHECK_NO_SYSTEM) | 0);  /* check that GIT_ATTR_CHECK_NO_SYSTEM is an integer */
  if (!_cffi_check_int(*o, n, 4U))
    n |= 2;
  return n;
}

static int _cffi_const_GIT_ATTR_OPTIONS_VERSION(unsigned long long *o)
{
  int n = (GIT_ATTR_OPTIONS_VERSION) <= 0;
  *o = (unsigned long long)((GIT_ATTR_OPTIONS_VERSION) | 0);  /* check that GIT_ATTR_OPTIONS_VERSION is an integer */
  return n;
}

static int _cffi_const_GIT_BLAME_OPTIONS_VERSION(unsigned long long *o)
{
  int n = (GIT_BLAME_OPTIONS_VERSION) <= 0;
  *o = (unsigned long long)((GIT_BLAME_OPTIONS_VERSION) | 0);  /* check that GIT_BLAME_OPTIONS_VERSION is an integer */
  return n;
}

static int _cffi_const_GIT_CLONE_OPTIONS_VERSION(unsigned long long *o)
{
  int n = (GIT_CLONE_OPTIONS_VERSION) <= 0;
  *o = (unsigned long long)((GIT_CLONE_OPTIONS_VERSION) | 0);  /* check that GIT_CLONE_OPTIONS_VERSION is an integer */
  return n;
}

static int _cffi_const_GIT_DESCRIBE_FORMAT_OPTIONS_VERSION(unsigned long long *o)
{
  int n = (GIT_DESCRIBE_FORMAT_OPTIONS_VERSION) <= 0;
  *o = (unsigned long long)((GIT_DESCRIBE_FORMAT_OPTIONS_VERSION) | 0);  /* check that GIT_DESCRIBE_FORMAT_OPTIONS_VERSION is an integer */
  if (!_cffi_check_int(*o, n, 1U))
    n |= 2;
  return n;
}

static int _cffi_const_GIT_DESCRIBE_OPTIONS_VERSION(unsigned long long *o)
{
  int n = (GIT_DESCRIBE_OPTIONS_VERSION) <= 0;
  *o = (unsigned long long)((GIT_DESCRIBE_OPTIONS_VERSION) | 0);  /* check that GIT_DESCRIBE_OPTIONS_VERSION is an integer */
  if (!_cffi_check_int(*o, n, 1U))
    n |= 2;
  return n;
}

static int _cffi_const_GIT_FETCH_OPTIONS_VERSION(unsigned long long *o)
{
  int n = (GIT_FETCH_OPTIONS_VERSION) <= 0;
  *o = (unsigned long long)((GIT_FETCH_OPTIONS_VERSION) | 0);  /* check that GIT_FETCH_OPTIONS_VERSION is an integer */
  return n;
}

static int _cffi_const_GIT_MERGE_OPTIONS_VERSION(unsigned long long *o)
{
  int n = (GIT_MERGE_OPTIONS_VERSION) <= 0;
  *o = (unsigned long long)((GIT_MERGE_OPTIONS_VERSION) | 0);  /* check that GIT_MERGE_OPTIONS_VERSION is an integer */
  if (!_cffi_check_int(*o, n, 1U))
    n |= 2;
  return n;
}

static int _cffi_const_GIT_PATH_MAX(unsigned long long *o)
{
  int n = (GIT_PATH_MAX) <= 0;
  *o = (unsigned long long)((GIT_PATH_MAX) | 0);  /* check that GIT_PATH_MAX is an integer */
  return n;
}

static int _cffi_const_GIT_PROXY_OPTIONS_VERSION(unsigned long long *o)
{
  int n = (GIT_PROXY_OPTIONS_VERSION) <= 0;
  *o = (unsigned long long)((GIT_PROXY_OPTIONS_VERSION) | 0);  /* check that GIT_PROXY_OPTIONS_VERSION is an integer */
  return n;
}

static int _cffi_const_GIT_PUSH_OPTIONS_VERSION(unsigned long long *o)
{
  int n = (GIT_PUSH_OPTIONS_VERSION) <= 0;
  *o = (unsigned long long)((GIT_PUSH_OPTIONS_VERSION) | 0);  /* check that GIT_PUSH_OPTIONS_VERSION is an integer */
  return n;
}

static int _cffi_const_GIT_REMOTE_CALLBACKS_VERSION(unsigned long long *o)
{
  int n = (GIT_REMOTE_CALLBACKS_VERSION) <= 0;
  *o = (unsigned long long)((GIT_REMOTE_CALLBACKS_VERSION) | 0);  /* check that GIT_REMOTE_CALLBACKS_VERSION is an integer */
  return n;
}

static int _cffi_const_GIT_REPOSITORY_INIT_OPTIONS_VERSION(unsigned long long *o)
{
  int n = (GIT_REPOSITORY_INIT_OPTIONS_VERSION) <= 0;
  *o = (unsigned long long)((GIT_REPOSITORY_INIT_OPTIONS_VERSION) | 0);  /* check that GIT_REPOSITORY_INIT_OPTIONS_VERSION is an integer */
  return n;
}

static int _cffi_const_GIT_REVERT_OPTIONS_VERSION(unsigned long long *o)
{
  int n = (GIT_REVERT_OPTIONS_VERSION) <= 0;
  *o = (unsigned long long)((GIT_REVERT_OPTIONS_VERSION) | 0);  /* check that GIT_REVERT_OPTIONS_VERSION is an integer */
  return n;
}

static int _cffi_const_GIT_STASH_APPLY_OPTIONS_VERSION(unsigned long long *o)
{
  int n = (GIT_STASH_APPLY_OPTIONS_VERSION) <= 0;
  *o = (unsigned long long)((GIT_STASH_APPLY_OPTIONS_VERSION) | 0);  /* check that GIT_STASH_APPLY_OPTIONS_VERSION is an integer */
  if (!_cffi_check_int(*o, n, 1U))
    n |= 2;
  return n;
}

static int _cffi_const_GIT_STASH_SAVE_OPTIONS_VERSION(unsigned long long *o)
{
  int n = (GIT_STASH_SAVE_OPTIONS_VERSION) <= 0;
  *o = (unsigned long long)((GIT_STASH_SAVE_OPTIONS_VERSION) | 0);  /* check that GIT_STASH_SAVE_OPTIONS_VERSION is an integer */
  return n;
}

static int _cffi_const_GIT_SUBMODULE_UPDATE_OPTIONS_VERSION(unsigned long long *o)
{
  int n = (GIT_SUBMODULE_UPDATE_OPTIONS_VERSION) <= 0;
  *o = (unsigned long long)((GIT_SUBMODULE_UPDATE_OPTIONS_VERSION) | 0);  /* check that GIT_SUBMODULE_UPDATE_OPTIONS_VERSION is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_blame_hunk(git_blame_hunk *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->lines_in_hunk) | 0);  /* check that 'git_blame_hunk.lines_in_hunk' is an integer */
  { git_oid *tmp = &p->final_commit_id; (void)tmp; }
  (void)((p->final_start_line_number) | 0);  /* check that 'git_blame_hunk.final_start_line_number' is an integer */
  { git_signature * *tmp = &p->final_signature; (void)tmp; }
  { git_signature * *tmp = &p->final_committer; (void)tmp; }
  { git_oid *tmp = &p->orig_commit_id; (void)tmp; }
  { char const * *tmp = &p->orig_path; (void)tmp; }
  (void)((p->orig_start_line_number) | 0);  /* check that 'git_blame_hunk.orig_start_line_number' is an integer */
  { git_signature * *tmp = &p->orig_signature; (void)tmp; }
  { git_signature * *tmp = &p->orig_committer; (void)tmp; }
  { char const * *tmp = &p->summary; (void)tmp; }
  { char *tmp = &p->boundary; (void)tmp; }
}
struct _cffi_align__git_blame_hunk { char x; git_blame_hunk y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_blame_options(git_blame_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_blame_options.version' is an integer */
  (void)((p->flags) | 0);  /* check that 'git_blame_options.flags' is an integer */
  (void)((p->min_match_characters) | 0);  /* check that 'git_blame_options.min_match_characters' is an integer */
  { git_oid *tmp = &p->newest_commit; (void)tmp; }
  { git_oid *tmp = &p->oldest_commit; (void)tmp; }
  (void)((p->min_line) | 0);  /* check that 'git_blame_options.min_line' is an integer */
  (void)((p->max_line) | 0);  /* check that 'git_blame_options.max_line' is an integer */
}
struct _cffi_align__git_blame_options { char x; git_blame_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_checkout_options(git_checkout_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_checkout_options.version' is an integer */
  (void)((p->checkout_strategy) | 0);  /* check that 'git_checkout_options.checkout_strategy' is an integer */
  (void)((p->disable_filters) | 0);  /* check that 'git_checkout_options.disable_filters' is an integer */
  (void)((p->dir_mode) | 0);  /* check that 'git_checkout_options.dir_mode' is an integer */
  (void)((p->file_mode) | 0);  /* check that 'git_checkout_options.file_mode' is an integer */
  (void)((p->file_open_flags) | 0);  /* check that 'git_checkout_options.file_open_flags' is an integer */
  (void)((p->notify_flags) | 0);  /* check that 'git_checkout_options.notify_flags' is an integer */
  { int(* *tmp)(git_checkout_notify_t, char const *, git_diff_file const *, git_diff_file const *, git_diff_file const *, void *) = &p->notify_cb; (void)tmp; }
  { void * *tmp = &p->notify_payload; (void)tmp; }
  { void(* *tmp)(char const *, size_t, size_t, void *) = &p->progress_cb; (void)tmp; }
  { void * *tmp = &p->progress_payload; (void)tmp; }
  { git_strarray *tmp = &p->paths; (void)tmp; }
  { git_tree * *tmp = &p->baseline; (void)tmp; }
  { git_index * *tmp = &p->baseline_index; (void)tmp; }
  { char const * *tmp = &p->target_directory; (void)tmp; }
  { char const * *tmp = &p->ancestor_label; (void)tmp; }
  { char const * *tmp = &p->our_label; (void)tmp; }
  { char const * *tmp = &p->their_label; (void)tmp; }
  { void(* *tmp)(git_checkout_perfdata const *, void *) = &p->perfdata_cb; (void)tmp; }
  { void * *tmp = &p->perfdata_payload; (void)tmp; }
}
struct _cffi_align__git_checkout_options { char x; git_checkout_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_clone_options(git_clone_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_clone_options.version' is an integer */
  { git_checkout_options *tmp = &p->checkout_opts; (void)tmp; }
  { git_fetch_options *tmp = &p->fetch_opts; (void)tmp; }
  (void)((p->bare) | 0);  /* check that 'git_clone_options.bare' is an integer */
  { git_clone_local_t *tmp = &p->local; (void)tmp; }
  { char const * *tmp = &p->checkout_branch; (void)tmp; }
  { int(* *tmp)(git_repository * *, char const *, int, void *) = &p->repository_cb; (void)tmp; }
  { void * *tmp = &p->repository_cb_payload; (void)tmp; }
  { int(* *tmp)(git_remote * *, git_repository *, char const *, char const *, void *) = &p->remote_cb; (void)tmp; }
  { void * *tmp = &p->remote_cb_payload; (void)tmp; }
}
struct _cffi_align__git_clone_options { char x; git_clone_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_config_entry(git_config_entry *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  { char const * *tmp = &p->value; (void)tmp; }
  { char const * *tmp = &p->backend_type; (void)tmp; }
  { char const * *tmp = &p->origin_path; (void)tmp; }
  (void)((p->include_depth) | 0);  /* check that 'git_config_entry.include_depth' is an integer */
  { git_config_level_t *tmp = &p->level; (void)tmp; }
}
struct _cffi_align__git_config_entry { char x; git_config_entry y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_describe_options(git_describe_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_describe_options.version' is an integer */
  (void)((p->max_candidates_tags) | 0);  /* check that 'git_describe_options.max_candidates_tags' is an integer */
  (void)((p->describe_strategy) | 0);  /* check that 'git_describe_options.describe_strategy' is an integer */
  { char const * *tmp = &p->pattern; (void)tmp; }
  (void)((p->only_follow_first_parent) | 0);  /* check that 'git_describe_options.only_follow_first_parent' is an integer */
  (void)((p->show_commit_oid_as_fallback) | 0);  /* check that 'git_describe_options.show_commit_oid_as_fallback' is an integer */
}
struct _cffi_align__git_describe_options { char x; git_describe_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_index_entry(git_index_entry *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { git_index_time *tmp = &p->ctime; (void)tmp; }
  { git_index_time *tmp = &p->mtime; (void)tmp; }
  (void)((p->dev) | 0);  /* check that 'git_index_entry.dev' is an integer */
  (void)((p->ino) | 0);  /* check that 'git_index_entry.ino' is an integer */
  (void)((p->mode) | 0);  /* check that 'git_index_entry.mode' is an integer */
  (void)((p->uid) | 0);  /* check that 'git_index_entry.uid' is an integer */
  (void)((p->gid) | 0);  /* check that 'git_index_entry.gid' is an integer */
  (void)((p->file_size) | 0);  /* check that 'git_index_entry.file_size' is an integer */
  { git_oid *tmp = &p->id; (void)tmp; }
  (void)((p->flags) | 0);  /* check that 'git_index_entry.flags' is an integer */
  (void)((p->flags_extended) | 0);  /* check that 'git_index_entry.flags_extended' is an integer */
  { char const * *tmp = &p->path; (void)tmp; }
}
struct _cffi_align__git_index_entry { char x; git_index_entry y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_indexer_progress(git_indexer_progress *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->total_objects) | 0);  /* check that 'git_indexer_progress.total_objects' is an integer */
  (void)((p->indexed_objects) | 0);  /* check that 'git_indexer_progress.indexed_objects' is an integer */
  (void)((p->received_objects) | 0);  /* check that 'git_indexer_progress.received_objects' is an integer */
  (void)((p->local_objects) | 0);  /* check that 'git_indexer_progress.local_objects' is an integer */
  (void)((p->total_deltas) | 0);  /* check that 'git_indexer_progress.total_deltas' is an integer */
  (void)((p->indexed_deltas) | 0);  /* check that 'git_indexer_progress.indexed_deltas' is an integer */
  (void)((p->received_bytes) | 0);  /* check that 'git_indexer_progress.received_bytes' is an integer */
}
struct _cffi_align__git_indexer_progress { char x; git_indexer_progress y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_oid(git_oid *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { unsigned char(*tmp)[20] = &p->id; (void)tmp; }
}
struct _cffi_align__git_oid { char x; git_oid y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_remote_callbacks(git_remote_callbacks *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_remote_callbacks.version' is an integer */
  { int(* *tmp)(char const *, int, void *) = &p->sideband_progress; (void)tmp; }
  { int(* *tmp)(git_remote_completion_t, void *) = &p->completion; (void)tmp; }
  { int(* *tmp)(git_credential * *, char const *, char const *, unsigned int, void *) = &p->credentials; (void)tmp; }
  { int(* *tmp)(git_cert *, int, char const *, void *) = &p->certificate_check; (void)tmp; }
  { int(* *tmp)(git_indexer_progress const *, void *) = &p->transfer_progress; (void)tmp; }
  { int(* *tmp)(char const *, git_oid const *, git_oid const *, void *) = &p->update_tips; (void)tmp; }
  { int(* *tmp)(int, uint32_t, uint32_t, void *) = &p->pack_progress; (void)tmp; }
  { int(* *tmp)(unsigned int, unsigned int, size_t, void *) = &p->push_transfer_progress; (void)tmp; }
  { int(* *tmp)(char const *, char const *, void *) = &p->push_update_reference; (void)tmp; }
  { int(* *tmp)(git_push_update const * *, size_t, void *) = &p->push_negotiation; (void)tmp; }
  { int(* *tmp)(git_transport * *, git_remote *, void *) = &p->transport; (void)tmp; }
  { int(* *tmp)(git_remote *, int, void *) = &p->remote_ready; (void)tmp; }
  { void * *tmp = &p->payload; (void)tmp; }
  { int(* *tmp)(git_buf *, char const *, int, void *) = &p->resolve_url; (void)tmp; }
  { int(* *tmp)(char const *, git_oid const *, git_oid const *, git_refspec *, void *) = &p->update_refs; (void)tmp; }
}
struct _cffi_align__git_remote_callbacks { char x; git_remote_callbacks y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_remote_head(git_remote_head *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->local) | 0);  /* check that 'git_remote_head.local' is an integer */
  { git_oid *tmp = &p->oid; (void)tmp; }
  { git_oid *tmp = &p->loid; (void)tmp; }
  { char * *tmp = &p->name; (void)tmp; }
  { char * *tmp = &p->symref_target; (void)tmp; }
}
struct _cffi_align__git_remote_head { char x; git_remote_head y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_signature(git_signature *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char * *tmp = &p->name; (void)tmp; }
  { char * *tmp = &p->email; (void)tmp; }
  { git_time *tmp = &p->when; (void)tmp; }
}
struct _cffi_align__git_signature { char x; git_signature y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_stash_apply_options(git_stash_apply_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_stash_apply_options.version' is an integer */
  { git_stash_apply_flags *tmp = &p->flags; (void)tmp; }
  { git_checkout_options *tmp = &p->checkout_options; (void)tmp; }
  { int(* *tmp)(git_stash_apply_progress_t, void *) = &p->progress_cb; (void)tmp; }
  { void * *tmp = &p->progress_payload; (void)tmp; }
}
struct _cffi_align__git_stash_apply_options { char x; git_stash_apply_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_stash_save_options(git_stash_save_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_stash_save_options.version' is an integer */
  (void)((p->flags) | 0);  /* check that 'git_stash_save_options.flags' is an integer */
  { git_signature const * *tmp = &p->stasher; (void)tmp; }
  { char const * *tmp = &p->message; (void)tmp; }
  { git_strarray *tmp = &p->paths; (void)tmp; }
}
struct _cffi_align__git_stash_save_options { char x; git_stash_save_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_strarray(git_strarray *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char * * *tmp = &p->strings; (void)tmp; }
  (void)((p->count) | 0);  /* check that 'git_strarray.count' is an integer */
}
struct _cffi_align__git_strarray { char x; git_strarray y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_submodule_update_options(git_submodule_update_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->version) | 0);  /* check that 'git_submodule_update_options.version' is an integer */
  { git_checkout_options *tmp = &p->checkout_opts; (void)tmp; }
  { git_fetch_options *tmp = &p->fetch_opts; (void)tmp; }
  (void)((p->allow_fetch) | 0);  /* check that 'git_submodule_update_options.allow_fetch' is an integer */
}
struct _cffi_align__git_submodule_update_options { char x; git_submodule_update_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__git_time(git_time *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->time) | 0);  /* check that 'git_time.time' is an integer */
  (void)((p->offset) | 0);  /* check that 'git_time.offset' is an integer */
  { char *tmp = &p->sign; (void)tmp; }
}
struct _cffi_align__git_time { char x; git_time y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "GIT_ATTR_CHECK_FILE_THEN_INDEX", (void *)_cffi_const_GIT_ATTR_CHECK_FILE_THEN_INDEX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_ATTR_CHECK_INCLUDE_COMMIT", (void *)_cffi_const_GIT_ATTR_CHECK_INCLUDE_COMMIT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_ATTR_CHECK_INCLUDE_HEAD", (void *)_cffi_const_GIT_ATTR_CHECK_INCLUDE_HEAD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_ATTR_CHECK_INDEX_ONLY", (void *)_cffi_const_GIT_ATTR_CHECK_INDEX_ONLY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_ATTR_CHECK_INDEX_THEN_FILE", (void *)_cffi_const_GIT_ATTR_CHECK_INDEX_THEN_FILE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_ATTR_CHECK_NO_SYSTEM", (void *)_cffi_const_GIT_ATTR_CHECK_NO_SYSTEM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_ATTR_OPTIONS_VERSION", (void *)_cffi_const_GIT_ATTR_OPTIONS_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_ATTR_VALUE_FALSE", (void *)_cffi_const_GIT_ATTR_VALUE_FALSE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_ATTR_VALUE_STRING", (void *)_cffi_const_GIT_ATTR_VALUE_STRING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_ATTR_VALUE_TRUE", (void *)_cffi_const_GIT_ATTR_VALUE_TRUE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_ATTR_VALUE_UNSPECIFIED", (void *)_cffi_const_GIT_ATTR_VALUE_UNSPECIFIED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_BLAME_OPTIONS_VERSION", (void *)_cffi_const_GIT_BLAME_OPTIONS_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_CERT_HOSTKEY_LIBSSH2", (void *)_cffi_const_GIT_CERT_HOSTKEY_LIBSSH2, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CERT_NONE", (void *)_cffi_const_GIT_CERT_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CERT_SSH_MD5", (void *)_cffi_const_GIT_CERT_SSH_MD5, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CERT_SSH_SHA1", (void *)_cffi_const_GIT_CERT_SSH_SHA1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CERT_STRARRAY", (void *)_cffi_const_GIT_CERT_STRARRAY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CERT_X509", (void *)_cffi_const_GIT_CERT_X509, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CHECKOUT_NOTIFY_ALL", (void *)_cffi_const_GIT_CHECKOUT_NOTIFY_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CHECKOUT_NOTIFY_CONFLICT", (void *)_cffi_const_GIT_CHECKOUT_NOTIFY_CONFLICT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CHECKOUT_NOTIFY_DIRTY", (void *)_cffi_const_GIT_CHECKOUT_NOTIFY_DIRTY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CHECKOUT_NOTIFY_IGNORED", (void *)_cffi_const_GIT_CHECKOUT_NOTIFY_IGNORED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CHECKOUT_NOTIFY_NONE", (void *)_cffi_const_GIT_CHECKOUT_NOTIFY_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CHECKOUT_NOTIFY_UNTRACKED", (void *)_cffi_const_GIT_CHECKOUT_NOTIFY_UNTRACKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CHECKOUT_NOTIFY_UPDATED", (void *)_cffi_const_GIT_CHECKOUT_NOTIFY_UPDATED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CLONE_LOCAL", (void *)_cffi_const_GIT_CLONE_LOCAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CLONE_LOCAL_AUTO", (void *)_cffi_const_GIT_CLONE_LOCAL_AUTO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CLONE_LOCAL_NO_LINKS", (void *)_cffi_const_GIT_CLONE_LOCAL_NO_LINKS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CLONE_NO_LOCAL", (void *)_cffi_const_GIT_CLONE_NO_LOCAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CLONE_OPTIONS_VERSION", (void *)_cffi_const_GIT_CLONE_OPTIONS_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_CONFIG_HIGHEST_LEVEL", (void *)_cffi_const_GIT_CONFIG_HIGHEST_LEVEL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CONFIG_LEVEL_APP", (void *)_cffi_const_GIT_CONFIG_LEVEL_APP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CONFIG_LEVEL_GLOBAL", (void *)_cffi_const_GIT_CONFIG_LEVEL_GLOBAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CONFIG_LEVEL_LOCAL", (void *)_cffi_const_GIT_CONFIG_LEVEL_LOCAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CONFIG_LEVEL_PROGRAMDATA", (void *)_cffi_const_GIT_CONFIG_LEVEL_PROGRAMDATA, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CONFIG_LEVEL_SYSTEM", (void *)_cffi_const_GIT_CONFIG_LEVEL_SYSTEM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CONFIG_LEVEL_WORKTREE", (void *)_cffi_const_GIT_CONFIG_LEVEL_WORKTREE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CONFIG_LEVEL_XDG", (void *)_cffi_const_GIT_CONFIG_LEVEL_XDG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CREDENTIAL_DEFAULT", (void *)_cffi_const_GIT_CREDENTIAL_DEFAULT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CREDENTIAL_SSH_CUSTOM", (void *)_cffi_const_GIT_CREDENTIAL_SSH_CUSTOM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CREDENTIAL_SSH_INTERACTIVE", (void *)_cffi_const_GIT_CREDENTIAL_SSH_INTERACTIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CREDENTIAL_SSH_KEY", (void *)_cffi_const_GIT_CREDENTIAL_SSH_KEY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CREDENTIAL_SSH_MEMORY", (void *)_cffi_const_GIT_CREDENTIAL_SSH_MEMORY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CREDENTIAL_USERNAME", (void *)_cffi_const_GIT_CREDENTIAL_USERNAME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_CREDENTIAL_USERPASS_PLAINTEXT", (void *)_cffi_const_GIT_CREDENTIAL_USERPASS_PLAINTEXT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DELTA_ADDED", (void *)_cffi_const_GIT_DELTA_ADDED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DELTA_CONFLICTED", (void *)_cffi_const_GIT_DELTA_CONFLICTED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DELTA_COPIED", (void *)_cffi_const_GIT_DELTA_COPIED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DELTA_DELETED", (void *)_cffi_const_GIT_DELTA_DELETED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DELTA_IGNORED", (void *)_cffi_const_GIT_DELTA_IGNORED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DELTA_MODIFIED", (void *)_cffi_const_GIT_DELTA_MODIFIED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DELTA_RENAMED", (void *)_cffi_const_GIT_DELTA_RENAMED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DELTA_TYPECHANGE", (void *)_cffi_const_GIT_DELTA_TYPECHANGE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DELTA_UNMODIFIED", (void *)_cffi_const_GIT_DELTA_UNMODIFIED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DELTA_UNREADABLE", (void *)_cffi_const_GIT_DELTA_UNREADABLE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DELTA_UNTRACKED", (void *)_cffi_const_GIT_DELTA_UNTRACKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DESCRIBE_ALL", (void *)_cffi_const_GIT_DESCRIBE_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DESCRIBE_DEFAULT", (void *)_cffi_const_GIT_DESCRIBE_DEFAULT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DESCRIBE_FORMAT_OPTIONS_VERSION", (void *)_cffi_const_GIT_DESCRIBE_FORMAT_OPTIONS_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_DESCRIBE_OPTIONS_VERSION", (void *)_cffi_const_GIT_DESCRIBE_OPTIONS_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_DESCRIBE_TAGS", (void *)_cffi_const_GIT_DESCRIBE_TAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DIRECTION_FETCH", (void *)_cffi_const_GIT_DIRECTION_FETCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_DIRECTION_PUSH", (void *)_cffi_const_GIT_DIRECTION_PUSH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EAMBIGUOUS", (void *)_cffi_const_GIT_EAMBIGUOUS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EAPPLIED", (void *)_cffi_const_GIT_EAPPLIED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EAPPLYFAIL", (void *)_cffi_const_GIT_EAPPLYFAIL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EAUTH", (void *)_cffi_const_GIT_EAUTH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EBAREREPO", (void *)_cffi_const_GIT_EBAREREPO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EBUFS", (void *)_cffi_const_GIT_EBUFS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_ECERTIFICATE", (void *)_cffi_const_GIT_ECERTIFICATE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_ECONFLICT", (void *)_cffi_const_GIT_ECONFLICT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EDIRECTORY", (void *)_cffi_const_GIT_EDIRECTORY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EEOF", (void *)_cffi_const_GIT_EEOF, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EEXISTS", (void *)_cffi_const_GIT_EEXISTS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EINDEXDIRTY", (void *)_cffi_const_GIT_EINDEXDIRTY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EINVALID", (void *)_cffi_const_GIT_EINVALID, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EINVALIDSPEC", (void *)_cffi_const_GIT_EINVALIDSPEC, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_ELOCKED", (void *)_cffi_const_GIT_ELOCKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EMERGECONFLICT", (void *)_cffi_const_GIT_EMERGECONFLICT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EMISMATCH", (void *)_cffi_const_GIT_EMISMATCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EMODIFIED", (void *)_cffi_const_GIT_EMODIFIED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_ENONFASTFORWARD", (void *)_cffi_const_GIT_ENONFASTFORWARD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_ENOTFOUND", (void *)_cffi_const_GIT_ENOTFOUND, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EOWNER", (void *)_cffi_const_GIT_EOWNER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EPEEL", (void *)_cffi_const_GIT_EPEEL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_ERROR", (void *)_cffi_const_GIT_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EUNBORNBRANCH", (void *)_cffi_const_GIT_EUNBORNBRANCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EUNCOMMITTED", (void *)_cffi_const_GIT_EUNCOMMITTED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EUNMERGED", (void *)_cffi_const_GIT_EUNMERGED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_EUSER", (void *)_cffi_const_GIT_EUSER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_FEATURE_HTTPS", (void *)_cffi_const_GIT_FEATURE_HTTPS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_FEATURE_NSEC", (void *)_cffi_const_GIT_FEATURE_NSEC, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_FEATURE_SSH", (void *)_cffi_const_GIT_FEATURE_SSH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_FEATURE_THREADS", (void *)_cffi_const_GIT_FEATURE_THREADS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_FETCH_NO_PRUNE", (void *)_cffi_const_GIT_FETCH_NO_PRUNE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_FETCH_OPTIONS_VERSION", (void *)_cffi_const_GIT_FETCH_OPTIONS_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_FETCH_PRUNE", (void *)_cffi_const_GIT_FETCH_PRUNE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_FETCH_PRUNE_UNSPECIFIED", (void *)_cffi_const_GIT_FETCH_PRUNE_UNSPECIFIED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_ITEROVER", (void *)_cffi_const_GIT_ITEROVER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FAIL_ON_CONFLICT", (void *)_cffi_const_GIT_MERGE_FAIL_ON_CONFLICT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FILE_ACCEPT_CONFLICTS", (void *)_cffi_const_GIT_MERGE_FILE_ACCEPT_CONFLICTS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FILE_DEFAULT", (void *)_cffi_const_GIT_MERGE_FILE_DEFAULT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FILE_DIFF_MINIMAL", (void *)_cffi_const_GIT_MERGE_FILE_DIFF_MINIMAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FILE_DIFF_PATIENCE", (void *)_cffi_const_GIT_MERGE_FILE_DIFF_PATIENCE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FILE_FAVOR_NORMAL", (void *)_cffi_const_GIT_MERGE_FILE_FAVOR_NORMAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FILE_FAVOR_OURS", (void *)_cffi_const_GIT_MERGE_FILE_FAVOR_OURS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FILE_FAVOR_THEIRS", (void *)_cffi_const_GIT_MERGE_FILE_FAVOR_THEIRS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FILE_FAVOR_UNION", (void *)_cffi_const_GIT_MERGE_FILE_FAVOR_UNION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FILE_IGNORE_WHITESPACE", (void *)_cffi_const_GIT_MERGE_FILE_IGNORE_WHITESPACE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FILE_IGNORE_WHITESPACE_CHANGE", (void *)_cffi_const_GIT_MERGE_FILE_IGNORE_WHITESPACE_CHANGE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FILE_IGNORE_WHITESPACE_EOL", (void *)_cffi_const_GIT_MERGE_FILE_IGNORE_WHITESPACE_EOL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FILE_SIMPLIFY_ALNUM", (void *)_cffi_const_GIT_MERGE_FILE_SIMPLIFY_ALNUM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FILE_STYLE_DIFF3", (void *)_cffi_const_GIT_MERGE_FILE_STYLE_DIFF3, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FILE_STYLE_MERGE", (void *)_cffi_const_GIT_MERGE_FILE_STYLE_MERGE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FILE_STYLE_ZDIFF3", (void *)_cffi_const_GIT_MERGE_FILE_STYLE_ZDIFF3, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_FIND_RENAMES", (void *)_cffi_const_GIT_MERGE_FIND_RENAMES, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_NO_RECURSIVE", (void *)_cffi_const_GIT_MERGE_NO_RECURSIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_OPTIONS_VERSION", (void *)_cffi_const_GIT_MERGE_OPTIONS_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_MERGE_SKIP_REUC", (void *)_cffi_const_GIT_MERGE_SKIP_REUC, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_MERGE_VIRTUAL_BASE", (void *)_cffi_const_GIT_MERGE_VIRTUAL_BASE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OBJECT_ANY", (void *)_cffi_const_GIT_OBJECT_ANY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OBJECT_BLOB", (void *)_cffi_const_GIT_OBJECT_BLOB, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OBJECT_COMMIT", (void *)_cffi_const_GIT_OBJECT_COMMIT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OBJECT_INVALID", (void *)_cffi_const_GIT_OBJECT_INVALID, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OBJECT_OFS_DELTA", (void *)_cffi_const_GIT_OBJECT_OFS_DELTA, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OBJECT_REF_DELTA", (void *)_cffi_const_GIT_OBJECT_REF_DELTA, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OBJECT_TAG", (void *)_cffi_const_GIT_OBJECT_TAG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OBJECT_TREE", (void *)_cffi_const_GIT_OBJECT_TREE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OID_SHA1", (void *)_cffi_const_GIT_OID_SHA1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OK", (void *)_cffi_const_GIT_OK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_ADD_SSL_X509_CERT", (void *)_cffi_const_GIT_OPT_ADD_SSL_X509_CERT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_DISABLE_PACK_KEEP_FILE_CHECKS", (void *)_cffi_const_GIT_OPT_DISABLE_PACK_KEEP_FILE_CHECKS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_ENABLE_CACHING", (void *)_cffi_const_GIT_OPT_ENABLE_CACHING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_ENABLE_FSYNC_GITDIR", (void *)_cffi_const_GIT_OPT_ENABLE_FSYNC_GITDIR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_ENABLE_HTTP_EXPECT_CONTINUE", (void *)_cffi_const_GIT_OPT_ENABLE_HTTP_EXPECT_CONTINUE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_ENABLE_OFS_DELTA", (void *)_cffi_const_GIT_OPT_ENABLE_OFS_DELTA, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_ENABLE_STRICT_HASH_VERIFICATION", (void *)_cffi_const_GIT_OPT_ENABLE_STRICT_HASH_VERIFICATION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_ENABLE_STRICT_OBJECT_CREATION", (void *)_cffi_const_GIT_OPT_ENABLE_STRICT_OBJECT_CREATION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_ENABLE_STRICT_SYMBOLIC_REF_CREATION", (void *)_cffi_const_GIT_OPT_ENABLE_STRICT_SYMBOLIC_REF_CREATION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_ENABLE_UNSAVED_INDEX_SAFETY", (void *)_cffi_const_GIT_OPT_ENABLE_UNSAVED_INDEX_SAFETY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_GET_CACHED_MEMORY", (void *)_cffi_const_GIT_OPT_GET_CACHED_MEMORY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_GET_EXTENSIONS", (void *)_cffi_const_GIT_OPT_GET_EXTENSIONS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_GET_HOMEDIR", (void *)_cffi_const_GIT_OPT_GET_HOMEDIR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_GET_MWINDOW_FILE_LIMIT", (void *)_cffi_const_GIT_OPT_GET_MWINDOW_FILE_LIMIT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_GET_MWINDOW_MAPPED_LIMIT", (void *)_cffi_const_GIT_OPT_GET_MWINDOW_MAPPED_LIMIT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_GET_MWINDOW_SIZE", (void *)_cffi_const_GIT_OPT_GET_MWINDOW_SIZE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_GET_OWNER_VALIDATION", (void *)_cffi_const_GIT_OPT_GET_OWNER_VALIDATION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_GET_PACK_MAX_OBJECTS", (void *)_cffi_const_GIT_OPT_GET_PACK_MAX_OBJECTS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_GET_SEARCH_PATH", (void *)_cffi_const_GIT_OPT_GET_SEARCH_PATH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_GET_SERVER_CONNECT_TIMEOUT", (void *)_cffi_const_GIT_OPT_GET_SERVER_CONNECT_TIMEOUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_GET_SERVER_TIMEOUT", (void *)_cffi_const_GIT_OPT_GET_SERVER_TIMEOUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_GET_TEMPLATE_PATH", (void *)_cffi_const_GIT_OPT_GET_TEMPLATE_PATH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_GET_USER_AGENT", (void *)_cffi_const_GIT_OPT_GET_USER_AGENT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_GET_USER_AGENT_PRODUCT", (void *)_cffi_const_GIT_OPT_GET_USER_AGENT_PRODUCT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_GET_WINDOWS_SHAREMODE", (void *)_cffi_const_GIT_OPT_GET_WINDOWS_SHAREMODE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_ALLOCATOR", (void *)_cffi_const_GIT_OPT_SET_ALLOCATOR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_CACHE_MAX_SIZE", (void *)_cffi_const_GIT_OPT_SET_CACHE_MAX_SIZE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_CACHE_OBJECT_LIMIT", (void *)_cffi_const_GIT_OPT_SET_CACHE_OBJECT_LIMIT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_EXTENSIONS", (void *)_cffi_const_GIT_OPT_SET_EXTENSIONS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_HOMEDIR", (void *)_cffi_const_GIT_OPT_SET_HOMEDIR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_MWINDOW_FILE_LIMIT", (void *)_cffi_const_GIT_OPT_SET_MWINDOW_FILE_LIMIT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_MWINDOW_MAPPED_LIMIT", (void *)_cffi_const_GIT_OPT_SET_MWINDOW_MAPPED_LIMIT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_MWINDOW_SIZE", (void *)_cffi_const_GIT_OPT_SET_MWINDOW_SIZE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_ODB_LOOSE_PRIORITY", (void *)_cffi_const_GIT_OPT_SET_ODB_LOOSE_PRIORITY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_ODB_PACKED_PRIORITY", (void *)_cffi_const_GIT_OPT_SET_ODB_PACKED_PRIORITY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_OWNER_VALIDATION", (void *)_cffi_const_GIT_OPT_SET_OWNER_VALIDATION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_PACK_MAX_OBJECTS", (void *)_cffi_const_GIT_OPT_SET_PACK_MAX_OBJECTS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_SEARCH_PATH", (void *)_cffi_const_GIT_OPT_SET_SEARCH_PATH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_SERVER_CONNECT_TIMEOUT", (void *)_cffi_const_GIT_OPT_SET_SERVER_CONNECT_TIMEOUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_SERVER_TIMEOUT", (void *)_cffi_const_GIT_OPT_SET_SERVER_TIMEOUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_SSL_CERT_LOCATIONS", (void *)_cffi_const_GIT_OPT_SET_SSL_CERT_LOCATIONS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_SSL_CIPHERS", (void *)_cffi_const_GIT_OPT_SET_SSL_CIPHERS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_TEMPLATE_PATH", (void *)_cffi_const_GIT_OPT_SET_TEMPLATE_PATH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_USER_AGENT", (void *)_cffi_const_GIT_OPT_SET_USER_AGENT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_USER_AGENT_PRODUCT", (void *)_cffi_const_GIT_OPT_SET_USER_AGENT_PRODUCT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_OPT_SET_WINDOWS_SHAREMODE", (void *)_cffi_const_GIT_OPT_SET_WINDOWS_SHAREMODE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_PASSTHROUGH", (void *)_cffi_const_GIT_PASSTHROUGH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_PATH_MAX", (void *)_cffi_const_GIT_PATH_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_PROXY_AUTO", (void *)_cffi_const_GIT_PROXY_AUTO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_PROXY_NONE", (void *)_cffi_const_GIT_PROXY_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_PROXY_OPTIONS_VERSION", (void *)_cffi_const_GIT_PROXY_OPTIONS_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_PROXY_SPECIFIED", (void *)_cffi_const_GIT_PROXY_SPECIFIED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_PUSH_OPTIONS_VERSION", (void *)_cffi_const_GIT_PUSH_OPTIONS_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_REFERENCE_ALL", (void *)_cffi_const_GIT_REFERENCE_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REFERENCE_DIRECT", (void *)_cffi_const_GIT_REFERENCE_DIRECT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REFERENCE_INVALID", (void *)_cffi_const_GIT_REFERENCE_INVALID, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REFERENCE_SYMBOLIC", (void *)_cffi_const_GIT_REFERENCE_SYMBOLIC, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REMOTE_CALLBACKS_VERSION", (void *)_cffi_const_GIT_REMOTE_CALLBACKS_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_REMOTE_COMPLETION_DOWNLOAD", (void *)_cffi_const_GIT_REMOTE_COMPLETION_DOWNLOAD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REMOTE_COMPLETION_ERROR", (void *)_cffi_const_GIT_REMOTE_COMPLETION_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REMOTE_COMPLETION_INDEXING", (void *)_cffi_const_GIT_REMOTE_COMPLETION_INDEXING, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REMOTE_DOWNLOAD_TAGS_ALL", (void *)_cffi_const_GIT_REMOTE_DOWNLOAD_TAGS_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REMOTE_DOWNLOAD_TAGS_AUTO", (void *)_cffi_const_GIT_REMOTE_DOWNLOAD_TAGS_AUTO, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REMOTE_DOWNLOAD_TAGS_NONE", (void *)_cffi_const_GIT_REMOTE_DOWNLOAD_TAGS_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REMOTE_DOWNLOAD_TAGS_UNSPECIFIED", (void *)_cffi_const_GIT_REMOTE_DOWNLOAD_TAGS_UNSPECIFIED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REMOTE_REDIRECT_ALL", (void *)_cffi_const_GIT_REMOTE_REDIRECT_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REMOTE_REDIRECT_INITIAL", (void *)_cffi_const_GIT_REMOTE_REDIRECT_INITIAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REMOTE_REDIRECT_NONE", (void *)_cffi_const_GIT_REMOTE_REDIRECT_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_INIT_BARE", (void *)_cffi_const_GIT_REPOSITORY_INIT_BARE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_INIT_EXTERNAL_TEMPLATE", (void *)_cffi_const_GIT_REPOSITORY_INIT_EXTERNAL_TEMPLATE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_INIT_MKDIR", (void *)_cffi_const_GIT_REPOSITORY_INIT_MKDIR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_INIT_MKPATH", (void *)_cffi_const_GIT_REPOSITORY_INIT_MKPATH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_INIT_NO_DOTGIT_DIR", (void *)_cffi_const_GIT_REPOSITORY_INIT_NO_DOTGIT_DIR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_INIT_NO_REINIT", (void *)_cffi_const_GIT_REPOSITORY_INIT_NO_REINIT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_INIT_OPTIONS_VERSION", (void *)_cffi_const_GIT_REPOSITORY_INIT_OPTIONS_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_REPOSITORY_INIT_RELATIVE_GITLINK", (void *)_cffi_const_GIT_REPOSITORY_INIT_RELATIVE_GITLINK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_INIT_SHARED_ALL", (void *)_cffi_const_GIT_REPOSITORY_INIT_SHARED_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_INIT_SHARED_GROUP", (void *)_cffi_const_GIT_REPOSITORY_INIT_SHARED_GROUP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_INIT_SHARED_UMASK", (void *)_cffi_const_GIT_REPOSITORY_INIT_SHARED_UMASK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_OPEN_BARE", (void *)_cffi_const_GIT_REPOSITORY_OPEN_BARE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_OPEN_CROSS_FS", (void *)_cffi_const_GIT_REPOSITORY_OPEN_CROSS_FS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_OPEN_FROM_ENV", (void *)_cffi_const_GIT_REPOSITORY_OPEN_FROM_ENV, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_OPEN_NO_DOTGIT", (void *)_cffi_const_GIT_REPOSITORY_OPEN_NO_DOTGIT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_OPEN_NO_SEARCH", (void *)_cffi_const_GIT_REPOSITORY_OPEN_NO_SEARCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_STATE_APPLY_MAILBOX", (void *)_cffi_const_GIT_REPOSITORY_STATE_APPLY_MAILBOX, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_STATE_APPLY_MAILBOX_OR_REBASE", (void *)_cffi_const_GIT_REPOSITORY_STATE_APPLY_MAILBOX_OR_REBASE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_STATE_BISECT", (void *)_cffi_const_GIT_REPOSITORY_STATE_BISECT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_STATE_CHERRYPICK", (void *)_cffi_const_GIT_REPOSITORY_STATE_CHERRYPICK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_STATE_CHERRYPICK_SEQUENCE", (void *)_cffi_const_GIT_REPOSITORY_STATE_CHERRYPICK_SEQUENCE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_STATE_MERGE", (void *)_cffi_const_GIT_REPOSITORY_STATE_MERGE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_STATE_NONE", (void *)_cffi_const_GIT_REPOSITORY_STATE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_STATE_REBASE", (void *)_cffi_const_GIT_REPOSITORY_STATE_REBASE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_STATE_REBASE_INTERACTIVE", (void *)_cffi_const_GIT_REPOSITORY_STATE_REBASE_INTERACTIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_STATE_REBASE_MERGE", (void *)_cffi_const_GIT_REPOSITORY_STATE_REBASE_MERGE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_STATE_REVERT", (void *)_cffi_const_GIT_REPOSITORY_STATE_REVERT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REPOSITORY_STATE_REVERT_SEQUENCE", (void *)_cffi_const_GIT_REPOSITORY_STATE_REVERT_SEQUENCE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_RETRY", (void *)_cffi_const_GIT_RETRY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_REVERT_OPTIONS_VERSION", (void *)_cffi_const_GIT_REVERT_OPTIONS_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_STASH_APPLY_DEFAULT", (void *)_cffi_const_GIT_STASH_APPLY_DEFAULT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_STASH_APPLY_OPTIONS_VERSION", (void *)_cffi_const_GIT_STASH_APPLY_OPTIONS_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_STASH_APPLY_PROGRESS_ANALYZE_INDEX", (void *)_cffi_const_GIT_STASH_APPLY_PROGRESS_ANALYZE_INDEX, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_STASH_APPLY_PROGRESS_ANALYZE_MODIFIED", (void *)_cffi_const_GIT_STASH_APPLY_PROGRESS_ANALYZE_MODIFIED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_STASH_APPLY_PROGRESS_ANALYZE_UNTRACKED", (void *)_cffi_const_GIT_STASH_APPLY_PROGRESS_ANALYZE_UNTRACKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_STASH_APPLY_PROGRESS_CHECKOUT_MODIFIED", (void *)_cffi_const_GIT_STASH_APPLY_PROGRESS_CHECKOUT_MODIFIED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_STASH_APPLY_PROGRESS_CHECKOUT_UNTRACKED", (void *)_cffi_const_GIT_STASH_APPLY_PROGRESS_CHECKOUT_UNTRACKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_STASH_APPLY_PROGRESS_DONE", (void *)_cffi_const_GIT_STASH_APPLY_PROGRESS_DONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_STASH_APPLY_PROGRESS_LOADING_STASH", (void *)_cffi_const_GIT_STASH_APPLY_PROGRESS_LOADING_STASH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_STASH_APPLY_PROGRESS_NONE", (void *)_cffi_const_GIT_STASH_APPLY_PROGRESS_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_STASH_APPLY_REINSTATE_INDEX", (void *)_cffi_const_GIT_STASH_APPLY_REINSTATE_INDEX, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_STASH_DEFAULT", (void *)_cffi_const_GIT_STASH_DEFAULT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_STASH_INCLUDE_IGNORED", (void *)_cffi_const_GIT_STASH_INCLUDE_IGNORED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_STASH_INCLUDE_UNTRACKED", (void *)_cffi_const_GIT_STASH_INCLUDE_UNTRACKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_STASH_KEEP_ALL", (void *)_cffi_const_GIT_STASH_KEEP_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_STASH_KEEP_INDEX", (void *)_cffi_const_GIT_STASH_KEEP_INDEX, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_STASH_SAVE_OPTIONS_VERSION", (void *)_cffi_const_GIT_STASH_SAVE_OPTIONS_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_SUBMODULE_IGNORE_ALL", (void *)_cffi_const_GIT_SUBMODULE_IGNORE_ALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_SUBMODULE_IGNORE_DIRTY", (void *)_cffi_const_GIT_SUBMODULE_IGNORE_DIRTY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_SUBMODULE_IGNORE_NONE", (void *)_cffi_const_GIT_SUBMODULE_IGNORE_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_SUBMODULE_IGNORE_UNSPECIFIED", (void *)_cffi_const_GIT_SUBMODULE_IGNORE_UNSPECIFIED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_SUBMODULE_IGNORE_UNTRACKED", (void *)_cffi_const_GIT_SUBMODULE_IGNORE_UNTRACKED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "GIT_SUBMODULE_UPDATE_OPTIONS_VERSION", (void *)_cffi_const_GIT_SUBMODULE_UPDATE_OPTIONS_VERSION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "GIT_TIMEOUT", (void *)_cffi_const_GIT_TIMEOUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "_certificate_check_cb", (void *)&_cffi_externpy___certificate_check_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 944), (void *)_certificate_check_cb },
  { "_checkout_notify_cb", (void *)&_cffi_externpy___checkout_notify_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 945), (void *)_checkout_notify_cb },
  { "_checkout_progress_cb", (void *)&_cffi_externpy___checkout_progress_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 971), (void *)_checkout_progress_cb },
  { "_credentials_cb", (void *)&_cffi_externpy___credentials_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 946), (void *)_credentials_cb },
  { "_push_negotiation_cb", (void *)&_cffi_externpy___push_negotiation_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 949), (void *)_push_negotiation_cb },
  { "_push_transfer_progress_cb", (void *)&_cffi_externpy___push_transfer_progress_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 959), (void *)_push_transfer_progress_cb },
  { "_push_update_reference_cb", (void *)&_cffi_externpy___push_update_reference_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 348), (void *)_push_update_reference_cb },
  { "_remote_create_cb", (void *)&_cffi_externpy___remote_create_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 950), (void *)_remote_create_cb },
  { "_repository_create_cb", (void *)&_cffi_externpy___repository_create_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 953), (void *)_repository_create_cb },
  { "_sideband_progress_cb", (void *)&_cffi_externpy___sideband_progress_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 942), (void *)_sideband_progress_cb },
  { "_stash_apply_progress_cb", (void *)&_cffi_externpy___stash_apply_progress_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 954), (void *)_stash_apply_progress_cb },
  { "_transfer_progress_cb", (void *)&_cffi_externpy___transfer_progress_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 448), (void *)_transfer_progress_cb },
  { "_update_tips_cb", (void *)&_cffi_externpy___update_tips_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 941), (void *)_update_tips_cb },
  { "git_annotated_commit_free", (void *)_cffi_f_git_annotated_commit_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 790), (void *)_cffi_d_git_annotated_commit_free },
  { "git_annotated_commit_from_ref", (void *)_cffi_f_git_annotated_commit_from_ref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 92), (void *)_cffi_d_git_annotated_commit_from_ref },
  { "git_annotated_commit_lookup", (void *)_cffi_f_git_annotated_commit_lookup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 87), (void *)_cffi_d_git_annotated_commit_lookup },
  { "git_attr_get_ext", (void *)_cffi_f_git_attr_get_ext, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 57), (void *)_cffi_d_git_attr_get_ext },
  { "git_attr_value", (void *)_cffi_f_git_attr_value, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 9), (void *)_cffi_d_git_attr_value },
  { "git_blame_file", (void *)_cffi_f_git_blame_file, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 97), (void *)_cffi_d_git_blame_file },
  { "git_blame_free", (void *)_cffi_f_git_blame_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 793), (void *)_cffi_d_git_blame_free },
  { "git_blame_get_hunk_byindex", (void *)_cffi_f_git_blame_get_hunk_byindex, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 16), (void *)_cffi_d_git_blame_get_hunk_byindex },
  { "git_blame_get_hunk_byline", (void *)_cffi_f_git_blame_get_hunk_byline, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 12), (void *)_cffi_d_git_blame_get_hunk_byline },
  { "git_blame_get_hunk_count", (void *)_cffi_f_git_blame_get_hunk_count, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 774), (void *)_cffi_d_git_blame_get_hunk_count },
  { "git_blame_options_init", (void *)_cffi_f_git_blame_options_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 103), (void *)_cffi_d_git_blame_options_init },
  { "git_buf_dispose", (void *)_cffi_f_git_buf_dispose, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 796), (void *)_cffi_d_git_buf_dispose },
  { "git_checkout_head", (void *)_cffi_f_git_checkout_head, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 597), (void *)_cffi_d_git_checkout_head },
  { "git_checkout_index", (void *)_cffi_f_git_checkout_index, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 606), (void *)_cffi_d_git_checkout_index },
  { "git_checkout_options_init", (void *)_cffi_f_git_checkout_options_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 144), (void *)_cffi_d_git_checkout_options_init },
  { "git_checkout_tree", (void *)_cffi_f_git_checkout_tree, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 611), (void *)_cffi_d_git_checkout_tree },
  { "git_clone", (void *)_cffi_f_git_clone, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 541), (void *)_cffi_d_git_clone },
  { "git_clone_options_init", (void *)_cffi_f_git_clone_options_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_git_clone_options_init },
  { "git_commit_amend", (void *)_cffi_f_git_commit_amend, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 402), (void *)_cffi_d_git_commit_amend },
  { "git_config_add_file_ondisk", (void *)_cffi_f_git_config_add_file_ondisk, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 182), (void *)_cffi_d_git_config_add_file_ondisk },
  { "git_config_delete_entry", (void *)_cffi_f_git_config_delete_entry, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 167), (void *)_cffi_d_git_config_delete_entry },
  { "git_config_delete_multivar", (void *)_cffi_f_git_config_delete_multivar, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 171), (void *)_cffi_d_git_config_delete_multivar },
  { "git_config_entry_free", (void *)_cffi_f_git_config_entry_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 806), (void *)_cffi_d_git_config_entry_free },
  { "git_config_find_global", (void *)_cffi_f_git_config_find_global, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 107), (void *)_cffi_d_git_config_find_global },
  { "git_config_find_system", (void *)_cffi_f_git_config_find_system, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 107), (void *)_cffi_d_git_config_find_system },
  { "git_config_find_xdg", (void *)_cffi_f_git_config_find_xdg, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 107), (void *)_cffi_d_git_config_find_xdg },
  { "git_config_free", (void *)_cffi_f_git_config_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 803), (void *)_cffi_d_git_config_free },
  { "git_config_get_entry", (void *)_cffi_f_git_config_get_entry, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 199), (void *)_cffi_d_git_config_get_entry },
  { "git_config_get_string", (void *)_cffi_f_git_config_get_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 52), (void *)_cffi_d_git_config_get_string },
  { "git_config_iterator_free", (void *)_cffi_f_git_config_iterator_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 809), (void *)_cffi_d_git_config_iterator_free },
  { "git_config_iterator_new", (void *)_cffi_f_git_config_iterator_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 208), (void *)_cffi_d_git_config_iterator_new },
  { "git_config_multivar_iterator_new", (void *)_cffi_f_git_config_multivar_iterator_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 212), (void *)_cffi_d_git_config_multivar_iterator_new },
  { "git_config_new", (void *)_cffi_f_git_config_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 152), (void *)_cffi_d_git_config_new },
  { "git_config_next", (void *)_cffi_f_git_config_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 204), (void *)_cffi_d_git_config_next },
  { "git_config_open_ondisk", (void *)_cffi_f_git_config_open_ondisk, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 155), (void *)_cffi_d_git_config_open_ondisk },
  { "git_config_parse_bool", (void *)_cffi_f_git_config_parse_bool, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 697), (void *)_cffi_d_git_config_parse_bool },
  { "git_config_parse_int64", (void *)_cffi_f_git_config_parse_int64, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 716), (void *)_cffi_d_git_config_parse_int64 },
  { "git_config_set_bool", (void *)_cffi_f_git_config_set_bool, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 189), (void *)_cffi_d_git_config_set_bool },
  { "git_config_set_int64", (void *)_cffi_f_git_config_set_int64, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 194), (void *)_cffi_d_git_config_set_int64 },
  { "git_config_set_multivar", (void *)_cffi_f_git_config_set_multivar, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 176), (void *)_cffi_d_git_config_set_multivar },
  { "git_config_set_string", (void *)_cffi_f_git_config_set_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 171), (void *)_cffi_d_git_config_set_string },
  { "git_config_snapshot", (void *)_cffi_f_git_config_snapshot, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 159), (void *)_cffi_d_git_config_snapshot },
  { "git_credential_ssh_key_from_agent", (void *)_cffi_f_git_credential_ssh_key_from_agent, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 218), (void *)_cffi_d_git_credential_ssh_key_from_agent },
  { "git_credential_ssh_key_memory_new", (void *)_cffi_f_git_credential_ssh_key_memory_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 227), (void *)_cffi_d_git_credential_ssh_key_memory_new },
  { "git_credential_ssh_key_new", (void *)_cffi_f_git_credential_ssh_key_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 227), (void *)_cffi_d_git_credential_ssh_key_new },
  { "git_credential_username_new", (void *)_cffi_f_git_credential_username_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 218), (void *)_cffi_d_git_credential_username_new },
  { "git_credential_userpass_plaintext_new", (void *)_cffi_f_git_credential_userpass_plaintext_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 222), (void *)_cffi_d_git_credential_userpass_plaintext_new },
  { "git_describe_commit", (void *)_cffi_f_git_describe_commit, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 249), (void *)_cffi_d_git_describe_commit },
  { "git_describe_format", (void *)_cffi_f_git_describe_format, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 116), (void *)_cffi_d_git_describe_format },
  { "git_describe_init_format_options", (void *)_cffi_f_git_describe_init_format_options, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 241), (void *)_cffi_d_git_describe_init_format_options },
  { "git_describe_options_init", (void *)_cffi_f_git_describe_options_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 245), (void *)_cffi_d_git_describe_options_init },
  { "git_describe_result_free", (void *)_cffi_f_git_describe_result_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 812), (void *)_cffi_d_git_describe_result_free },
  { "git_describe_workdir", (void *)_cffi_f_git_describe_workdir, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 254), (void *)_cffi_d_git_describe_workdir },
  { "git_diff_index_to_workdir", (void *)_cffi_f_git_diff_index_to_workdir, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 259), (void *)_cffi_d_git_diff_index_to_workdir },
  { "git_diff_options_init", (void *)_cffi_f_git_diff_options_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 284), (void *)_cffi_d_git_diff_options_init },
  { "git_diff_tree_to_index", (void *)_cffi_f_git_diff_tree_to_index, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 265), (void *)_cffi_d_git_diff_tree_to_index },
  { "git_error_last", (void *)_cffi_f_git_error_last, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 23), (void *)_cffi_d_git_error_last },
  { "git_fetch_options_init", (void *)_cffi_f_git_fetch_options_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 288), (void *)_cffi_d_git_fetch_options_init },
  { "git_graph_ahead_behind", (void *)_cffi_f_git_graph_ahead_behind, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 725), (void *)_cffi_d_git_graph_ahead_behind },
  { "git_index_add", (void *)_cffi_f_git_index_add, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 335), (void *)_cffi_d_git_index_add },
  { "git_index_add_all", (void *)_cffi_f_git_index_add_all, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 351), (void *)_cffi_d_git_index_add_all },
  { "git_index_add_bypath", (void *)_cffi_f_git_index_add_bypath, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 326), (void *)_cffi_d_git_index_add_bypath },
  { "git_index_clear", (void *)_cffi_f_git_index_clear, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 323), (void *)_cffi_d_git_index_clear },
  { "git_index_conflict_add", (void *)_cffi_f_git_index_conflict_add, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 339), (void *)_cffi_d_git_index_conflict_add },
  { "git_index_conflict_get", (void *)_cffi_f_git_index_conflict_get, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 373), (void *)_cffi_d_git_index_conflict_get },
  { "git_index_conflict_iterator_free", (void *)_cffi_f_git_index_conflict_iterator_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 818), (void *)_cffi_d_git_index_conflict_iterator_free },
  { "git_index_conflict_iterator_new", (void *)_cffi_f_git_index_conflict_iterator_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 369), (void *)_cffi_d_git_index_conflict_iterator_new },
  { "git_index_conflict_next", (void *)_cffi_f_git_index_conflict_next, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 380), (void *)_cffi_d_git_index_conflict_next },
  { "git_index_conflict_remove", (void *)_cffi_f_git_index_conflict_remove, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 326), (void *)_cffi_d_git_index_conflict_remove },
  { "git_index_entrycount", (void *)_cffi_f_git_index_entrycount, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 765), (void *)_cffi_d_git_index_entrycount },
  { "git_index_find", (void *)_cffi_f_git_index_find, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 720), (void *)_cffi_d_git_index_find },
  { "git_index_free", (void *)_cffi_f_git_index_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 815), (void *)_cffi_d_git_index_free },
  { "git_index_get_byindex", (void *)_cffi_f_git_index_get_byindex, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 30), (void *)_cffi_d_git_index_get_byindex },
  { "git_index_get_bypath", (void *)_cffi_f_git_index_get_bypath, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 25), (void *)_cffi_d_git_index_get_bypath },
  { "git_index_has_conflicts", (void *)_cffi_f_git_index_has_conflicts, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 366), (void *)_cffi_d_git_index_has_conflicts },
  { "git_index_open", (void *)_cffi_f_git_index_open, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 292), (void *)_cffi_d_git_index_open },
  { "git_index_read", (void *)_cffi_f_git_index_read, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 362), (void *)_cffi_d_git_index_read },
  { "git_index_read_tree", (void *)_cffi_f_git_index_read_tree, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 358), (void *)_cffi_d_git_index_read_tree },
  { "git_index_remove", (void *)_cffi_f_git_index_remove, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 330), (void *)_cffi_d_git_index_remove },
  { "git_index_remove_all", (void *)_cffi_f_git_index_remove_all, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 345), (void *)_cffi_d_git_index_remove_all },
  { "git_index_remove_directory", (void *)_cffi_f_git_index_remove_directory, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 330), (void *)_cffi_d_git_index_remove_directory },
  { "git_index_write", (void *)_cffi_f_git_index_write, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 323), (void *)_cffi_d_git_index_write },
  { "git_index_write_tree", (void *)_cffi_f_git_index_write_tree, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 412), (void *)_cffi_d_git_index_write_tree },
  { "git_index_write_tree_to", (void *)_cffi_f_git_index_write_tree_to, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 416), (void *)_cffi_d_git_index_write_tree_to },
  { "git_libgit2_features", (void *)_cffi_f_git_libgit2_features, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 763), (void *)_cffi_d_git_libgit2_features },
  { "git_libgit2_opts", (void *)_cffi_const_git_libgit2_opts, _CFFI_OP(_CFFI_OP_CONSTANT, 957), (void *)0 },
  { "git_merge", (void *)_cffi_f_git_merge, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 590), (void *)_cffi_d_git_merge },
  { "git_merge_commits", (void *)_cffi_f_git_merge_commits, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 308), (void *)_cffi_d_git_merge_commits },
  { "git_merge_file_from_index", (void *)_cffi_f_git_merge_file_from_index, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 390), (void *)_cffi_d_git_merge_file_from_index },
  { "git_merge_file_result_free", (void *)_cffi_f_git_merge_file_result_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 821), (void *)_cffi_d_git_merge_file_result_free },
  { "git_merge_options_init", (void *)_cffi_f_git_merge_options_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 398), (void *)_cffi_d_git_merge_options_init },
  { "git_merge_trees", (void *)_cffi_f_git_merge_trees, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 315), (void *)_cffi_d_git_merge_trees },
  { "git_packbuilder_free", (void *)_cffi_f_git_packbuilder_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 824), (void *)_cffi_d_git_packbuilder_free },
  { "git_packbuilder_insert", (void *)_cffi_f_git_packbuilder_insert, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 451), (void *)_cffi_d_git_packbuilder_insert },
  { "git_packbuilder_insert_recur", (void *)_cffi_f_git_packbuilder_insert_recur, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 451), (void *)_cffi_d_git_packbuilder_insert_recur },
  { "git_packbuilder_new", (void *)_cffi_f_git_packbuilder_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 440), (void *)_cffi_d_git_packbuilder_new },
  { "git_packbuilder_object_count", (void *)_cffi_f_git_packbuilder_object_count, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 768), (void *)_cffi_d_git_packbuilder_object_count },
  { "git_packbuilder_set_threads", (void *)_cffi_f_git_packbuilder_set_threads, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 780), (void *)_cffi_d_git_packbuilder_set_threads },
  { "git_packbuilder_write", (void *)_cffi_f_git_packbuilder_write, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 444), (void *)_cffi_d_git_packbuilder_write },
  { "git_packbuilder_written", (void *)_cffi_f_git_packbuilder_written, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 777), (void *)_cffi_d_git_packbuilder_written },
  { "git_proxy_options_init", (void *)_cffi_f_git_proxy_options_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 456), (void *)_cffi_d_git_proxy_options_init },
  { "git_push_options_init", (void *)_cffi_f_git_push_options_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 460), (void *)_cffi_d_git_push_options_init },
  { "git_refspec_direction", (void *)_cffi_f_git_refspec_direction, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 20), (void *)_cffi_d_git_refspec_direction },
  { "git_refspec_dst", (void *)_cffi_f_git_refspec_dst, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_git_refspec_dst },
  { "git_refspec_dst_matches", (void *)_cffi_f_git_refspec_dst_matches, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 472), (void *)_cffi_d_git_refspec_dst_matches },
  { "git_refspec_force", (void *)_cffi_f_git_refspec_force, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 469), (void *)_cffi_d_git_refspec_force },
  { "git_refspec_rtransform", (void *)_cffi_f_git_refspec_rtransform, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 121), (void *)_cffi_d_git_refspec_rtransform },
  { "git_refspec_src", (void *)_cffi_f_git_refspec_src, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_git_refspec_src },
  { "git_refspec_src_matches", (void *)_cffi_f_git_refspec_src_matches, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 472), (void *)_cffi_d_git_refspec_src_matches },
  { "git_refspec_string", (void *)_cffi_f_git_refspec_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_git_refspec_string },
  { "git_refspec_transform", (void *)_cffi_f_git_refspec_transform, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 121), (void *)_cffi_d_git_refspec_transform },
  { "git_remote_add_fetch", (void *)_cffi_f_git_remote_add_fetch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 585), (void *)_cffi_d_git_remote_add_fetch },
  { "git_remote_add_push", (void *)_cffi_f_git_remote_add_push, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 585), (void *)_cffi_d_git_remote_add_push },
  { "git_remote_connect", (void *)_cffi_f_git_remote_connect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 516), (void *)_cffi_d_git_remote_connect },
  { "git_remote_create", (void *)_cffi_f_git_remote_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 481), (void *)_cffi_d_git_remote_create },
  { "git_remote_create_anonymous", (void *)_cffi_f_git_remote_create_anonymous, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 476), (void *)_cffi_d_git_remote_create_anonymous },
  { "git_remote_create_with_fetchspec", (void *)_cffi_f_git_remote_create_with_fetchspec, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 487), (void *)_cffi_d_git_remote_create_with_fetchspec },
  { "git_remote_delete", (void *)_cffi_f_git_remote_delete, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 581), (void *)_cffi_d_git_remote_delete },
  { "git_remote_fetch", (void *)_cffi_f_git_remote_fetch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 505), (void *)_cffi_d_git_remote_fetch },
  { "git_remote_free", (void *)_cffi_f_git_remote_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 827), (void *)_cffi_d_git_remote_free },
  { "git_remote_get_fetch_refspecs", (void *)_cffi_f_git_remote_get_fetch_refspecs, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 650), (void *)_cffi_d_git_remote_get_fetch_refspecs },
  { "git_remote_get_push_refspecs", (void *)_cffi_f_git_remote_get_push_refspecs, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 650), (void *)_cffi_d_git_remote_get_push_refspecs },
  { "git_remote_get_refspec", (void *)_cffi_f_git_remote_get_refspec, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 40), (void *)_cffi_d_git_remote_get_refspec },
  { "git_remote_init_callbacks", (void *)_cffi_f_git_remote_init_callbacks, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 528), (void *)_cffi_d_git_remote_init_callbacks },
  { "git_remote_list", (void *)_cffi_f_git_remote_list, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 654), (void *)_cffi_d_git_remote_list },
  { "git_remote_lookup", (void *)_cffi_f_git_remote_lookup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 476), (void *)_cffi_d_git_remote_lookup },
  { "git_remote_ls", (void *)_cffi_f_git_remote_ls, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 536), (void *)_cffi_d_git_remote_ls },
  { "git_remote_name", (void *)_cffi_f_git_remote_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 3), (void *)_cffi_d_git_remote_name },
  { "git_remote_prune", (void *)_cffi_f_git_remote_prune, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 501), (void *)_cffi_d_git_remote_prune },
  { "git_remote_push", (void *)_cffi_f_git_remote_push, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 511), (void *)_cffi_d_git_remote_push },
  { "git_remote_pushurl", (void *)_cffi_f_git_remote_pushurl, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 3), (void *)_cffi_d_git_remote_pushurl },
  { "git_remote_refspec_count", (void *)_cffi_f_git_remote_refspec_count, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 771), (void *)_cffi_d_git_remote_refspec_count },
  { "git_remote_rename", (void *)_cffi_f_git_remote_rename, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 658), (void *)_cffi_d_git_remote_rename },
  { "git_remote_set_pushurl", (void *)_cffi_f_git_remote_set_pushurl, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 585), (void *)_cffi_d_git_remote_set_pushurl },
  { "git_remote_set_url", (void *)_cffi_f_git_remote_set_url, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 585), (void *)_cffi_d_git_remote_set_url },
  { "git_remote_stats", (void *)_cffi_f_git_remote_stats, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 34), (void *)_cffi_d_git_remote_stats },
  { "git_remote_url", (void *)_cffi_f_git_remote_url, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 3), (void *)_cffi_d_git_remote_url },
  { "git_repository_config", (void *)_cffi_f_git_repository_config, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 163), (void *)_cffi_d_git_repository_config },
  { "git_repository_config_snapshot", (void *)_cffi_f_git_repository_config_snapshot, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 163), (void *)_cffi_d_git_repository_config_snapshot },
  { "git_repository_free", (void *)_cffi_f_git_repository_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 830), (void *)_cffi_d_git_repository_free },
  { "git_repository_hashfile", (void *)_cffi_f_git_repository_hashfile, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 421), (void *)_cffi_d_git_repository_hashfile },
  { "git_repository_ident", (void *)_cffi_f_git_repository_ident, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 47), (void *)_cffi_d_git_repository_ident },
  { "git_repository_index", (void *)_cffi_f_git_repository_index, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 296), (void *)_cffi_d_git_repository_index },
  { "git_repository_init", (void *)_cffi_f_git_repository_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 558), (void *)_cffi_d_git_repository_init },
  { "git_repository_init_ext", (void *)_cffi_f_git_repository_init_ext, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 547), (void *)_cffi_d_git_repository_init_ext },
  { "git_repository_init_options_init", (void *)_cffi_f_git_repository_init_options_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 634), (void *)_cffi_d_git_repository_init_options_init },
  { "git_repository_message", (void *)_cffi_f_git_repository_message, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 126), (void *)_cffi_d_git_repository_message },
  { "git_repository_message_remove", (void *)_cffi_f_git_repository_message_remove, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 578), (void *)_cffi_d_git_repository_message_remove },
  { "git_repository_open_ext", (void *)_cffi_f_git_repository_open_ext, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 563), (void *)_cffi_d_git_repository_open_ext },
  { "git_repository_set_head", (void *)_cffi_f_git_repository_set_head, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 581), (void *)_cffi_d_git_repository_set_head },
  { "git_repository_set_head_detached", (void *)_cffi_f_git_repository_set_head_detached, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 616), (void *)_cffi_d_git_repository_set_head_detached },
  { "git_repository_set_ident", (void *)_cffi_f_git_repository_set_ident, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 585), (void *)_cffi_d_git_repository_set_ident },
  { "git_repository_state", (void *)_cffi_f_git_repository_state, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 44), (void *)_cffi_d_git_repository_state },
  { "git_repository_state_cleanup", (void *)_cffi_f_git_repository_state_cleanup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 578), (void *)_cffi_d_git_repository_state_cleanup },
  { "git_repository_submodule_cache_all", (void *)_cffi_f_git_repository_submodule_cache_all, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 578), (void *)_cffi_d_git_repository_submodule_cache_all },
  { "git_repository_submodule_cache_clear", (void *)_cffi_f_git_repository_submodule_cache_clear, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 578), (void *)_cffi_d_git_repository_submodule_cache_clear },
  { "git_revert", (void *)_cffi_f_git_revert, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 601), (void *)_cffi_d_git_revert },
  { "git_revert_commit", (void *)_cffi_f_git_revert_commit, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 300), (void *)_cffi_d_git_revert_commit },
  { "git_stash_apply", (void *)_cffi_f_git_stash_apply, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 629), (void *)_cffi_d_git_stash_apply },
  { "git_stash_apply_options_init", (void *)_cffi_f_git_stash_apply_options_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 638), (void *)_cffi_d_git_stash_apply_options_init },
  { "git_stash_drop", (void *)_cffi_f_git_stash_drop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 625), (void *)_cffi_d_git_stash_drop },
  { "git_stash_foreach", (void *)_cffi_f_git_stash_foreach, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 620), (void *)_cffi_d_git_stash_foreach },
  { "git_stash_pop", (void *)_cffi_f_git_stash_pop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 629), (void *)_cffi_d_git_stash_pop },
  { "git_stash_save", (void *)_cffi_f_git_stash_save, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 428), (void *)_cffi_d_git_stash_save },
  { "git_stash_save_options_init", (void *)_cffi_f_git_stash_save_options_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 646), (void *)_cffi_d_git_stash_save_options_init },
  { "git_stash_save_with_opts", (void *)_cffi_f_git_stash_save_with_opts, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 435), (void *)_cffi_d_git_stash_save_with_opts },
  { "git_strarray_dispose", (void *)_cffi_f_git_strarray_dispose, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 833), (void *)_cffi_d_git_strarray_dispose },
  { "git_submodule_add_finalize", (void *)_cffi_f_git_submodule_add_finalize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 676), (void *)_cffi_d_git_submodule_add_finalize },
  { "git_submodule_add_setup", (void *)_cffi_f_git_submodule_add_setup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 669), (void *)_cffi_d_git_submodule_add_setup },
  { "git_submodule_branch", (void *)_cffi_f_git_submodule_branch, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 6), (void *)_cffi_d_git_submodule_branch },
  { "git_submodule_clone", (void *)_cffi_f_git_submodule_clone, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 573), (void *)_cffi_d_git_submodule_clone },
  { "git_submodule_free", (void *)_cffi_f_git_submodule_free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 836), (void *)_cffi_d_git_submodule_free },
  { "git_submodule_head_id", (void *)_cffi_f_git_submodule_head_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 37), (void *)_cffi_d_git_submodule_head_id },
  { "git_submodule_init", (void *)_cffi_f_git_submodule_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 679), (void *)_cffi_d_git_submodule_init },
  { "git_submodule_lookup", (void *)_cffi_f_git_submodule_lookup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 664), (void *)_cffi_d_git_submodule_lookup },
  { "git_submodule_name", (void *)_cffi_f_git_submodule_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 6), (void *)_cffi_d_git_submodule_name },
  { "git_submodule_open", (void *)_cffi_f_git_submodule_open, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 569), (void *)_cffi_d_git_submodule_open },
  { "git_submodule_path", (void *)_cffi_f_git_submodule_path, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 6), (void *)_cffi_d_git_submodule_path },
  { "git_submodule_reload", (void *)_cffi_f_git_submodule_reload, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 679), (void *)_cffi_d_git_submodule_reload },
  { "git_submodule_set_url", (void *)_cffi_f_git_submodule_set_url, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 585), (void *)_cffi_d_git_submodule_set_url },
  { "git_submodule_status", (void *)_cffi_f_git_submodule_status, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 738), (void *)_cffi_d_git_submodule_status },
  { "git_submodule_update", (void *)_cffi_f_git_submodule_update, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 683), (void *)_cffi_d_git_submodule_update },
  { "git_submodule_update_options_init", (void *)_cffi_f_git_submodule_update_options_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 688), (void *)_cffi_d_git_submodule_update_options_init },
  { "git_submodule_url", (void *)_cffi_f_git_submodule_url, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 6), (void *)_cffi_d_git_submodule_url },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "version", offsetof(git_attr_options, version),
               sizeof(((git_attr_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "flags", offsetof(git_attr_options, flags),
             sizeof(((git_attr_options *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "commit_id", offsetof(git_attr_options, commit_id),
                 sizeof(((git_attr_options *)0)->commit_id),
                 _CFFI_OP(_CFFI_OP_NOOP, 403) },
  { "attr_commit_id", offsetof(git_attr_options, attr_commit_id),
                      sizeof(((git_attr_options *)0)->attr_commit_id),
                      _CFFI_OP(_CFFI_OP_NOOP, 903) },
  { "ptr", offsetof(git_buf, ptr),
           sizeof(((git_buf *)0)->ptr),
           _CFFI_OP(_CFFI_OP_NOOP, 844) },
  { "reserved", offsetof(git_buf, reserved),
                sizeof(((git_buf *)0)->reserved),
                _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "size", offsetof(git_buf, size),
            sizeof(((git_buf *)0)->size),
            _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "cert_type", offsetof(git_cert, cert_type),
                 sizeof(((git_cert *)0)->cert_type),
                 _CFFI_OP(_CFFI_OP_NOOP, 858) },
  { "parent", offsetof(git_cert_hostkey, parent),
              sizeof(((git_cert_hostkey *)0)->parent),
              _CFFI_OP(_CFFI_OP_NOOP, 855) },
  { "type", offsetof(git_cert_hostkey, type),
            sizeof(((git_cert_hostkey *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 857) },
  { "hash_md5", offsetof(git_cert_hostkey, hash_md5),
                sizeof(((git_cert_hostkey *)0)->hash_md5),
                _CFFI_OP(_CFFI_OP_NOOP, 966) },
  { "hash_sha1", offsetof(git_cert_hostkey, hash_sha1),
                 sizeof(((git_cert_hostkey *)0)->hash_sha1),
                 _CFFI_OP(_CFFI_OP_NOOP, 968) },
  { "parent", offsetof(git_cert_x509, parent),
              sizeof(((git_cert_x509 *)0)->parent),
              _CFFI_OP(_CFFI_OP_NOOP, 855) },
  { "data", offsetof(git_cert_x509, data),
            sizeof(((git_cert_x509 *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 67) },
  { "len", offsetof(git_cert_x509, len),
           sizeof(((git_cert_x509 *)0)->len),
           _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "mkdir_calls", offsetof(git_checkout_perfdata, mkdir_calls),
                   sizeof(((git_checkout_perfdata *)0)->mkdir_calls),
                   _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "stat_calls", offsetof(git_checkout_perfdata, stat_calls),
                  sizeof(((git_checkout_perfdata *)0)->stat_calls),
                  _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "chmod_calls", offsetof(git_checkout_perfdata, chmod_calls),
                   sizeof(((git_checkout_perfdata *)0)->chmod_calls),
                   _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "version", offsetof(git_describe_format_options, version),
               sizeof(((git_describe_format_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "abbreviated_size", offsetof(git_describe_format_options, abbreviated_size),
                        sizeof(((git_describe_format_options *)0)->abbreviated_size),
                        _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "always_use_long_format", offsetof(git_describe_format_options, always_use_long_format),
                              sizeof(((git_describe_format_options *)0)->always_use_long_format),
                              _CFFI_OP(_CFFI_OP_NOOP, 28) },
  { "dirty_suffix", offsetof(git_describe_format_options, dirty_suffix),
                    sizeof(((git_describe_format_options *)0)->dirty_suffix),
                    _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "status", offsetof(git_diff_delta, status),
              sizeof(((git_diff_delta *)0)->status),
              _CFFI_OP(_CFFI_OP_NOOP, 871) },
  { "flags", offsetof(git_diff_delta, flags),
             sizeof(((git_diff_delta *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "similarity", offsetof(git_diff_delta, similarity),
                  sizeof(((git_diff_delta *)0)->similarity),
                  _CFFI_OP(_CFFI_OP_NOOP, 964) },
  { "nfiles", offsetof(git_diff_delta, nfiles),
              sizeof(((git_diff_delta *)0)->nfiles),
              _CFFI_OP(_CFFI_OP_NOOP, 964) },
  { "old_file", offsetof(git_diff_delta, old_file),
                sizeof(((git_diff_delta *)0)->old_file),
                _CFFI_OP(_CFFI_OP_NOOP, 879) },
  { "new_file", offsetof(git_diff_delta, new_file),
                sizeof(((git_diff_delta *)0)->new_file),
                _CFFI_OP(_CFFI_OP_NOOP, 879) },
  { "id", offsetof(git_diff_file, id),
          sizeof(((git_diff_file *)0)->id),
          _CFFI_OP(_CFFI_OP_NOOP, 903) },
  { "path", offsetof(git_diff_file, path),
            sizeof(((git_diff_file *)0)->path),
            _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "size", offsetof(git_diff_file, size),
            sizeof(((git_diff_file *)0)->size),
            _CFFI_OP(_CFFI_OP_NOOP, 197) },
  { "flags", offsetof(git_diff_file, flags),
             sizeof(((git_diff_file *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "mode", offsetof(git_diff_file, mode),
            sizeof(((git_diff_file *)0)->mode),
            _CFFI_OP(_CFFI_OP_NOOP, 964) },
  { "id_abbrev", offsetof(git_diff_file, id_abbrev),
                 sizeof(((git_diff_file *)0)->id_abbrev),
                 _CFFI_OP(_CFFI_OP_NOOP, 964) },
  { "version", offsetof(git_diff_options, version),
               sizeof(((git_diff_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "flags", offsetof(git_diff_options, flags),
             sizeof(((git_diff_options *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "ignore_submodules", offsetof(git_diff_options, ignore_submodules),
                         sizeof(((git_diff_options *)0)->ignore_submodules),
                         _CFFI_OP(_CFFI_OP_NOOP, 742) },
  { "pathspec", offsetof(git_diff_options, pathspec),
                sizeof(((git_diff_options *)0)->pathspec),
                _CFFI_OP(_CFFI_OP_NOOP, 933) },
  { "notify_cb", offsetof(git_diff_options, notify_cb),
                 sizeof(((git_diff_options *)0)->notify_cb),
                 _CFFI_OP(_CFFI_OP_NOOP, 948) },
  { "progress_cb", offsetof(git_diff_options, progress_cb),
                   sizeof(((git_diff_options *)0)->progress_cb),
                   _CFFI_OP(_CFFI_OP_NOOP, 947) },
  { "payload", offsetof(git_diff_options, payload),
               sizeof(((git_diff_options *)0)->payload),
               _CFFI_OP(_CFFI_OP_NOOP, 67) },
  { "context_lines", offsetof(git_diff_options, context_lines),
                     sizeof(((git_diff_options *)0)->context_lines),
                     _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "interhunk_lines", offsetof(git_diff_options, interhunk_lines),
                       sizeof(((git_diff_options *)0)->interhunk_lines),
                       _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "oid_type", offsetof(git_diff_options, oid_type),
                sizeof(((git_diff_options *)0)->oid_type),
                _CFFI_OP(_CFFI_OP_NOOP, 904) },
  { "id_abbrev", offsetof(git_diff_options, id_abbrev),
                 sizeof(((git_diff_options *)0)->id_abbrev),
                 _CFFI_OP(_CFFI_OP_NOOP, 964) },
  { "max_size", offsetof(git_diff_options, max_size),
                sizeof(((git_diff_options *)0)->max_size),
                _CFFI_OP(_CFFI_OP_NOOP, 197) },
  { "old_prefix", offsetof(git_diff_options, old_prefix),
                  sizeof(((git_diff_options *)0)->old_prefix),
                  _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "new_prefix", offsetof(git_diff_options, new_prefix),
                  sizeof(((git_diff_options *)0)->new_prefix),
                  _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "file_signature", offsetof(git_diff_similarity_metric, file_signature),
                      sizeof(((git_diff_similarity_metric *)0)->file_signature),
                      _CFFI_OP(_CFFI_OP_NOOP, 961) },
  { "buffer_signature", offsetof(git_diff_similarity_metric, buffer_signature),
                        sizeof(((git_diff_similarity_metric *)0)->buffer_signature),
                        _CFFI_OP(_CFFI_OP_NOOP, 960) },
  { "free_signature", offsetof(git_diff_similarity_metric, free_signature),
                      sizeof(((git_diff_similarity_metric *)0)->free_signature),
                      _CFFI_OP(_CFFI_OP_NOOP, 973) },
  { "similarity", offsetof(git_diff_similarity_metric, similarity),
                  sizeof(((git_diff_similarity_metric *)0)->similarity),
                  _CFFI_OP(_CFFI_OP_NOOP, 956) },
  { "payload", offsetof(git_diff_similarity_metric, payload),
               sizeof(((git_diff_similarity_metric *)0)->payload),
               _CFFI_OP(_CFFI_OP_NOOP, 67) },
  { "message", offsetof(git_error, message),
               sizeof(((git_error *)0)->message),
               _CFFI_OP(_CFFI_OP_NOOP, 844) },
  { "klass", offsetof(git_error, klass),
             sizeof(((git_error *)0)->klass),
             _CFFI_OP(_CFFI_OP_NOOP, 28) },
  { "version", offsetof(git_fetch_options, version),
               sizeof(((git_fetch_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 28) },
  { "callbacks", offsetof(git_fetch_options, callbacks),
                 sizeof(((git_fetch_options *)0)->callbacks),
                 _CFFI_OP(_CFFI_OP_NOOP, 915) },
  { "prune", offsetof(git_fetch_options, prune),
             sizeof(((git_fetch_options *)0)->prune),
             _CFFI_OP(_CFFI_OP_NOOP, 889) },
  { "update_fetchhead", offsetof(git_fetch_options, update_fetchhead),
                        sizeof(((git_fetch_options *)0)->update_fetchhead),
                        _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "download_tags", offsetof(git_fetch_options, download_tags),
                     sizeof(((git_fetch_options *)0)->download_tags),
                     _CFFI_OP(_CFFI_OP_NOOP, 914) },
  { "proxy_opts", offsetof(git_fetch_options, proxy_opts),
                  sizeof(((git_fetch_options *)0)->proxy_opts),
                  _CFFI_OP(_CFFI_OP_NOOP, 906) },
  { "depth", offsetof(git_fetch_options, depth),
             sizeof(((git_fetch_options *)0)->depth),
             _CFFI_OP(_CFFI_OP_NOOP, 28) },
  { "follow_redirects", offsetof(git_fetch_options, follow_redirects),
                        sizeof(((git_fetch_options *)0)->follow_redirects),
                        _CFFI_OP(_CFFI_OP_NOOP, 919) },
  { "custom_headers", offsetof(git_fetch_options, custom_headers),
                      sizeof(((git_fetch_options *)0)->custom_headers),
                      _CFFI_OP(_CFFI_OP_NOOP, 933) },
  { "seconds", offsetof(git_index_time, seconds),
               sizeof(((git_index_time *)0)->seconds),
               _CFFI_OP(_CFFI_OP_NOOP, 962) },
  { "nanoseconds", offsetof(git_index_time, nanoseconds),
                   sizeof(((git_index_time *)0)->nanoseconds),
                   _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "version", offsetof(git_merge_file_options, version),
               sizeof(((git_merge_file_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "ancestor_label", offsetof(git_merge_file_options, ancestor_label),
                      sizeof(((git_merge_file_options *)0)->ancestor_label),
                      _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "our_label", offsetof(git_merge_file_options, our_label),
                 sizeof(((git_merge_file_options *)0)->our_label),
                 _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "their_label", offsetof(git_merge_file_options, their_label),
                   sizeof(((git_merge_file_options *)0)->their_label),
                   _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "favor", offsetof(git_merge_file_options, favor),
             sizeof(((git_merge_file_options *)0)->favor),
             _CFFI_OP(_CFFI_OP_NOOP, 896) },
  { "flags", offsetof(git_merge_file_options, flags),
             sizeof(((git_merge_file_options *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 897) },
  { "marker_size", offsetof(git_merge_file_options, marker_size),
                   sizeof(((git_merge_file_options *)0)->marker_size),
                   _CFFI_OP(_CFFI_OP_NOOP, 970) },
  { "automergeable", offsetof(git_merge_file_result, automergeable),
                     sizeof(((git_merge_file_result *)0)->automergeable),
                     _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "path", offsetof(git_merge_file_result, path),
            sizeof(((git_merge_file_result *)0)->path),
            _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "mode", offsetof(git_merge_file_result, mode),
            sizeof(((git_merge_file_result *)0)->mode),
            _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "ptr", offsetof(git_merge_file_result, ptr),
           sizeof(((git_merge_file_result *)0)->ptr),
           _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "len", offsetof(git_merge_file_result, len),
           sizeof(((git_merge_file_result *)0)->len),
           _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "version", offsetof(git_merge_options, version),
               sizeof(((git_merge_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "flags", offsetof(git_merge_options, flags),
             sizeof(((git_merge_options *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 900) },
  { "rename_threshold", offsetof(git_merge_options, rename_threshold),
                        sizeof(((git_merge_options *)0)->rename_threshold),
                        _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "target_limit", offsetof(git_merge_options, target_limit),
                    sizeof(((git_merge_options *)0)->target_limit),
                    _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "metric", offsetof(git_merge_options, metric),
              sizeof(((git_merge_options *)0)->metric),
              _CFFI_OP(_CFFI_OP_NOOP, 881) },
  { "recursion_limit", offsetof(git_merge_options, recursion_limit),
                       sizeof(((git_merge_options *)0)->recursion_limit),
                       _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "default_driver", offsetof(git_merge_options, default_driver),
                      sizeof(((git_merge_options *)0)->default_driver),
                      _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "file_favor", offsetof(git_merge_options, file_favor),
                  sizeof(((git_merge_options *)0)->file_favor),
                  _CFFI_OP(_CFFI_OP_NOOP, 896) },
  { "file_flags", offsetof(git_merge_options, file_flags),
                  sizeof(((git_merge_options *)0)->file_flags),
                  _CFFI_OP(_CFFI_OP_NOOP, 897) },
  { "version", offsetof(git_proxy_options, version),
               sizeof(((git_proxy_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "type", offsetof(git_proxy_options, type),
            sizeof(((git_proxy_options *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 907) },
  { "url", offsetof(git_proxy_options, url),
           sizeof(((git_proxy_options *)0)->url),
           _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "credentials", offsetof(git_proxy_options, credentials),
                   sizeof(((git_proxy_options *)0)->credentials),
                   _CFFI_OP(_CFFI_OP_NOOP, 946) },
  { "certificate_check", offsetof(git_proxy_options, certificate_check),
                         sizeof(((git_proxy_options *)0)->certificate_check),
                         _CFFI_OP(_CFFI_OP_NOOP, 944) },
  { "payload", offsetof(git_proxy_options, payload),
               sizeof(((git_proxy_options *)0)->payload),
               _CFFI_OP(_CFFI_OP_NOOP, 67) },
  { "version", offsetof(git_push_options, version),
               sizeof(((git_push_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "pb_parallelism", offsetof(git_push_options, pb_parallelism),
                      sizeof(((git_push_options *)0)->pb_parallelism),
                      _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "callbacks", offsetof(git_push_options, callbacks),
                 sizeof(((git_push_options *)0)->callbacks),
                 _CFFI_OP(_CFFI_OP_NOOP, 915) },
  { "proxy_opts", offsetof(git_push_options, proxy_opts),
                  sizeof(((git_push_options *)0)->proxy_opts),
                  _CFFI_OP(_CFFI_OP_NOOP, 906) },
  { "follow_redirects", offsetof(git_push_options, follow_redirects),
                        sizeof(((git_push_options *)0)->follow_redirects),
                        _CFFI_OP(_CFFI_OP_NOOP, 919) },
  { "custom_headers", offsetof(git_push_options, custom_headers),
                      sizeof(((git_push_options *)0)->custom_headers),
                      _CFFI_OP(_CFFI_OP_NOOP, 933) },
  { "remote_push_options", offsetof(git_push_options, remote_push_options),
                           sizeof(((git_push_options *)0)->remote_push_options),
                           _CFFI_OP(_CFFI_OP_NOOP, 933) },
  { "src_refname", offsetof(git_push_update, src_refname),
                   sizeof(((git_push_update *)0)->src_refname),
                   _CFFI_OP(_CFFI_OP_NOOP, 844) },
  { "dst_refname", offsetof(git_push_update, dst_refname),
                   sizeof(((git_push_update *)0)->dst_refname),
                   _CFFI_OP(_CFFI_OP_NOOP, 844) },
  { "src", offsetof(git_push_update, src),
           sizeof(((git_push_update *)0)->src),
           _CFFI_OP(_CFFI_OP_NOOP, 903) },
  { "dst", offsetof(git_push_update, dst),
           sizeof(((git_push_update *)0)->dst),
           _CFFI_OP(_CFFI_OP_NOOP, 903) },
  { "version", offsetof(git_repository_init_options, version),
               sizeof(((git_repository_init_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "flags", offsetof(git_repository_init_options, flags),
             sizeof(((git_repository_init_options *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "mode", offsetof(git_repository_init_options, mode),
            sizeof(((git_repository_init_options *)0)->mode),
            _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "workdir_path", offsetof(git_repository_init_options, workdir_path),
                    sizeof(((git_repository_init_options *)0)->workdir_path),
                    _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "description", offsetof(git_repository_init_options, description),
                   sizeof(((git_repository_init_options *)0)->description),
                   _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "template_path", offsetof(git_repository_init_options, template_path),
                     sizeof(((git_repository_init_options *)0)->template_path),
                     _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "initial_head", offsetof(git_repository_init_options, initial_head),
                    sizeof(((git_repository_init_options *)0)->initial_head),
                    _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "origin_url", offsetof(git_repository_init_options, origin_url),
                  sizeof(((git_repository_init_options *)0)->origin_url),
                  _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "version", offsetof(git_revert_options, version),
               sizeof(((git_revert_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "mainline", offsetof(git_revert_options, mainline),
                sizeof(((git_revert_options *)0)->mainline),
                _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "merge_opts", offsetof(git_revert_options, merge_opts),
                  sizeof(((git_revert_options *)0)->merge_opts),
                  _CFFI_OP(_CFFI_OP_NOOP, 901) },
  { "checkout_opts", offsetof(git_revert_options, checkout_opts),
                     sizeof(((git_revert_options *)0)->checkout_opts),
                     _CFFI_OP(_CFFI_OP_NOOP, 860) },
  { "lines_in_hunk", offsetof(git_blame_hunk, lines_in_hunk),
                     sizeof(((git_blame_hunk *)0)->lines_in_hunk),
                     _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "final_commit_id", offsetof(git_blame_hunk, final_commit_id),
                       sizeof(((git_blame_hunk *)0)->final_commit_id),
                       _CFFI_OP(_CFFI_OP_NOOP, 903) },
  { "final_start_line_number", offsetof(git_blame_hunk, final_start_line_number),
                               sizeof(((git_blame_hunk *)0)->final_start_line_number),
                               _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "final_signature", offsetof(git_blame_hunk, final_signature),
                       sizeof(((git_blame_hunk *)0)->final_signature),
                       _CFFI_OP(_CFFI_OP_NOOP, 927) },
  { "final_committer", offsetof(git_blame_hunk, final_committer),
                       sizeof(((git_blame_hunk *)0)->final_committer),
                       _CFFI_OP(_CFFI_OP_NOOP, 927) },
  { "orig_commit_id", offsetof(git_blame_hunk, orig_commit_id),
                      sizeof(((git_blame_hunk *)0)->orig_commit_id),
                      _CFFI_OP(_CFFI_OP_NOOP, 903) },
  { "orig_path", offsetof(git_blame_hunk, orig_path),
                 sizeof(((git_blame_hunk *)0)->orig_path),
                 _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "orig_start_line_number", offsetof(git_blame_hunk, orig_start_line_number),
                              sizeof(((git_blame_hunk *)0)->orig_start_line_number),
                              _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "orig_signature", offsetof(git_blame_hunk, orig_signature),
                      sizeof(((git_blame_hunk *)0)->orig_signature),
                      _CFFI_OP(_CFFI_OP_NOOP, 927) },
  { "orig_committer", offsetof(git_blame_hunk, orig_committer),
                      sizeof(((git_blame_hunk *)0)->orig_committer),
                      _CFFI_OP(_CFFI_OP_NOOP, 927) },
  { "summary", offsetof(git_blame_hunk, summary),
               sizeof(((git_blame_hunk *)0)->summary),
               _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "boundary", offsetof(git_blame_hunk, boundary),
                sizeof(((git_blame_hunk *)0)->boundary),
                _CFFI_OP(_CFFI_OP_NOOP, 845) },
  { "version", offsetof(git_blame_options, version),
               sizeof(((git_blame_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "flags", offsetof(git_blame_options, flags),
             sizeof(((git_blame_options *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "min_match_characters", offsetof(git_blame_options, min_match_characters),
                            sizeof(((git_blame_options *)0)->min_match_characters),
                            _CFFI_OP(_CFFI_OP_NOOP, 964) },
  { "newest_commit", offsetof(git_blame_options, newest_commit),
                     sizeof(((git_blame_options *)0)->newest_commit),
                     _CFFI_OP(_CFFI_OP_NOOP, 903) },
  { "oldest_commit", offsetof(git_blame_options, oldest_commit),
                     sizeof(((git_blame_options *)0)->oldest_commit),
                     _CFFI_OP(_CFFI_OP_NOOP, 903) },
  { "min_line", offsetof(git_blame_options, min_line),
                sizeof(((git_blame_options *)0)->min_line),
                _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "max_line", offsetof(git_blame_options, max_line),
                sizeof(((git_blame_options *)0)->max_line),
                _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "version", offsetof(git_checkout_options, version),
               sizeof(((git_checkout_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "checkout_strategy", offsetof(git_checkout_options, checkout_strategy),
                         sizeof(((git_checkout_options *)0)->checkout_strategy),
                         _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "disable_filters", offsetof(git_checkout_options, disable_filters),
                       sizeof(((git_checkout_options *)0)->disable_filters),
                       _CFFI_OP(_CFFI_OP_NOOP, 28) },
  { "dir_mode", offsetof(git_checkout_options, dir_mode),
                sizeof(((git_checkout_options *)0)->dir_mode),
                _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "file_mode", offsetof(git_checkout_options, file_mode),
                 sizeof(((git_checkout_options *)0)->file_mode),
                 _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "file_open_flags", offsetof(git_checkout_options, file_open_flags),
                       sizeof(((git_checkout_options *)0)->file_open_flags),
                       _CFFI_OP(_CFFI_OP_NOOP, 28) },
  { "notify_flags", offsetof(git_checkout_options, notify_flags),
                    sizeof(((git_checkout_options *)0)->notify_flags),
                    _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "notify_cb", offsetof(git_checkout_options, notify_cb),
                 sizeof(((git_checkout_options *)0)->notify_cb),
                 _CFFI_OP(_CFFI_OP_NOOP, 945) },
  { "notify_payload", offsetof(git_checkout_options, notify_payload),
                      sizeof(((git_checkout_options *)0)->notify_payload),
                      _CFFI_OP(_CFFI_OP_NOOP, 67) },
  { "progress_cb", offsetof(git_checkout_options, progress_cb),
                   sizeof(((git_checkout_options *)0)->progress_cb),
                   _CFFI_OP(_CFFI_OP_NOOP, 971) },
  { "progress_payload", offsetof(git_checkout_options, progress_payload),
                        sizeof(((git_checkout_options *)0)->progress_payload),
                        _CFFI_OP(_CFFI_OP_NOOP, 67) },
  { "paths", offsetof(git_checkout_options, paths),
             sizeof(((git_checkout_options *)0)->paths),
             _CFFI_OP(_CFFI_OP_NOOP, 933) },
  { "baseline", offsetof(git_checkout_options, baseline),
                sizeof(((git_checkout_options *)0)->baseline),
                _CFFI_OP(_CFFI_OP_NOOP, 268) },
  { "baseline_index", offsetof(git_checkout_options, baseline_index),
                      sizeof(((git_checkout_options *)0)->baseline_index),
                      _CFFI_OP(_CFFI_OP_NOOP, 26) },
  { "target_directory", offsetof(git_checkout_options, target_directory),
                        sizeof(((git_checkout_options *)0)->target_directory),
                        _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "ancestor_label", offsetof(git_checkout_options, ancestor_label),
                      sizeof(((git_checkout_options *)0)->ancestor_label),
                      _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "our_label", offsetof(git_checkout_options, our_label),
                 sizeof(((git_checkout_options *)0)->our_label),
                 _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "their_label", offsetof(git_checkout_options, their_label),
                   sizeof(((git_checkout_options *)0)->their_label),
                   _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "perfdata_cb", offsetof(git_checkout_options, perfdata_cb),
                   sizeof(((git_checkout_options *)0)->perfdata_cb),
                   _CFFI_OP(_CFFI_OP_NOOP, 972) },
  { "perfdata_payload", offsetof(git_checkout_options, perfdata_payload),
                        sizeof(((git_checkout_options *)0)->perfdata_payload),
                        _CFFI_OP(_CFFI_OP_NOOP, 67) },
  { "version", offsetof(git_clone_options, version),
               sizeof(((git_clone_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "checkout_opts", offsetof(git_clone_options, checkout_opts),
                     sizeof(((git_clone_options *)0)->checkout_opts),
                     _CFFI_OP(_CFFI_OP_NOOP, 860) },
  { "fetch_opts", offsetof(git_clone_options, fetch_opts),
                  sizeof(((git_clone_options *)0)->fetch_opts),
                  _CFFI_OP(_CFFI_OP_NOOP, 888) },
  { "bare", offsetof(git_clone_options, bare),
            sizeof(((git_clone_options *)0)->bare),
            _CFFI_OP(_CFFI_OP_NOOP, 28) },
  { "local", offsetof(git_clone_options, local),
             sizeof(((git_clone_options *)0)->local),
             _CFFI_OP(_CFFI_OP_NOOP, 862) },
  { "checkout_branch", offsetof(git_clone_options, checkout_branch),
                       sizeof(((git_clone_options *)0)->checkout_branch),
                       _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "repository_cb", offsetof(git_clone_options, repository_cb),
                     sizeof(((git_clone_options *)0)->repository_cb),
                     _CFFI_OP(_CFFI_OP_NOOP, 953) },
  { "repository_cb_payload", offsetof(git_clone_options, repository_cb_payload),
                             sizeof(((git_clone_options *)0)->repository_cb_payload),
                             _CFFI_OP(_CFFI_OP_NOOP, 67) },
  { "remote_cb", offsetof(git_clone_options, remote_cb),
                 sizeof(((git_clone_options *)0)->remote_cb),
                 _CFFI_OP(_CFFI_OP_NOOP, 950) },
  { "remote_cb_payload", offsetof(git_clone_options, remote_cb_payload),
                         sizeof(((git_clone_options *)0)->remote_cb_payload),
                         _CFFI_OP(_CFFI_OP_NOOP, 67) },
  { "name", offsetof(git_config_entry, name),
            sizeof(((git_config_entry *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "value", offsetof(git_config_entry, value),
             sizeof(((git_config_entry *)0)->value),
             _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "backend_type", offsetof(git_config_entry, backend_type),
                    sizeof(((git_config_entry *)0)->backend_type),
                    _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "origin_path", offsetof(git_config_entry, origin_path),
                   sizeof(((git_config_entry *)0)->origin_path),
                   _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "include_depth", offsetof(git_config_entry, include_depth),
                     sizeof(((git_config_entry *)0)->include_depth),
                     _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "level", offsetof(git_config_entry, level),
             sizeof(((git_config_entry *)0)->level),
             _CFFI_OP(_CFFI_OP_NOOP, 185) },
  { "version", offsetof(git_describe_options, version),
               sizeof(((git_describe_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "max_candidates_tags", offsetof(git_describe_options, max_candidates_tags),
                           sizeof(((git_describe_options *)0)->max_candidates_tags),
                           _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "describe_strategy", offsetof(git_describe_options, describe_strategy),
                         sizeof(((git_describe_options *)0)->describe_strategy),
                         _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "pattern", offsetof(git_describe_options, pattern),
               sizeof(((git_describe_options *)0)->pattern),
               _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "only_follow_first_parent", offsetof(git_describe_options, only_follow_first_parent),
                                sizeof(((git_describe_options *)0)->only_follow_first_parent),
                                _CFFI_OP(_CFFI_OP_NOOP, 28) },
  { "show_commit_oid_as_fallback", offsetof(git_describe_options, show_commit_oid_as_fallback),
                                   sizeof(((git_describe_options *)0)->show_commit_oid_as_fallback),
                                   _CFFI_OP(_CFFI_OP_NOOP, 28) },
  { "ctime", offsetof(git_index_entry, ctime),
             sizeof(((git_index_entry *)0)->ctime),
             _CFFI_OP(_CFFI_OP_NOOP, 893) },
  { "mtime", offsetof(git_index_entry, mtime),
             sizeof(((git_index_entry *)0)->mtime),
             _CFFI_OP(_CFFI_OP_NOOP, 893) },
  { "dev", offsetof(git_index_entry, dev),
           sizeof(((git_index_entry *)0)->dev),
           _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "ino", offsetof(git_index_entry, ino),
           sizeof(((git_index_entry *)0)->ino),
           _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "mode", offsetof(git_index_entry, mode),
            sizeof(((git_index_entry *)0)->mode),
            _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "uid", offsetof(git_index_entry, uid),
           sizeof(((git_index_entry *)0)->uid),
           _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "gid", offsetof(git_index_entry, gid),
           sizeof(((git_index_entry *)0)->gid),
           _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "file_size", offsetof(git_index_entry, file_size),
                 sizeof(((git_index_entry *)0)->file_size),
                 _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "id", offsetof(git_index_entry, id),
          sizeof(((git_index_entry *)0)->id),
          _CFFI_OP(_CFFI_OP_NOOP, 903) },
  { "flags", offsetof(git_index_entry, flags),
             sizeof(((git_index_entry *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 964) },
  { "flags_extended", offsetof(git_index_entry, flags_extended),
                      sizeof(((git_index_entry *)0)->flags_extended),
                      _CFFI_OP(_CFFI_OP_NOOP, 964) },
  { "path", offsetof(git_index_entry, path),
            sizeof(((git_index_entry *)0)->path),
            _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "total_objects", offsetof(git_indexer_progress, total_objects),
                     sizeof(((git_indexer_progress *)0)->total_objects),
                     _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "indexed_objects", offsetof(git_indexer_progress, indexed_objects),
                       sizeof(((git_indexer_progress *)0)->indexed_objects),
                       _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "received_objects", offsetof(git_indexer_progress, received_objects),
                        sizeof(((git_indexer_progress *)0)->received_objects),
                        _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "local_objects", offsetof(git_indexer_progress, local_objects),
                     sizeof(((git_indexer_progress *)0)->local_objects),
                     _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "total_deltas", offsetof(git_indexer_progress, total_deltas),
                    sizeof(((git_indexer_progress *)0)->total_deltas),
                    _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "indexed_deltas", offsetof(git_indexer_progress, indexed_deltas),
                      sizeof(((git_indexer_progress *)0)->indexed_deltas),
                      _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "received_bytes", offsetof(git_indexer_progress, received_bytes),
                      sizeof(((git_indexer_progress *)0)->received_bytes),
                      _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "id", offsetof(git_oid, id),
          sizeof(((git_oid *)0)->id),
          _CFFI_OP(_CFFI_OP_NOOP, 968) },
  { "version", offsetof(git_remote_callbacks, version),
               sizeof(((git_remote_callbacks *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "sideband_progress", offsetof(git_remote_callbacks, sideband_progress),
                         sizeof(((git_remote_callbacks *)0)->sideband_progress),
                         _CFFI_OP(_CFFI_OP_NOOP, 942) },
  { "completion", offsetof(git_remote_callbacks, completion),
                  sizeof(((git_remote_callbacks *)0)->completion),
                  _CFFI_OP(_CFFI_OP_NOOP, 952) },
  { "credentials", offsetof(git_remote_callbacks, credentials),
                   sizeof(((git_remote_callbacks *)0)->credentials),
                   _CFFI_OP(_CFFI_OP_NOOP, 946) },
  { "certificate_check", offsetof(git_remote_callbacks, certificate_check),
                         sizeof(((git_remote_callbacks *)0)->certificate_check),
                         _CFFI_OP(_CFFI_OP_NOOP, 944) },
  { "transfer_progress", offsetof(git_remote_callbacks, transfer_progress),
                         sizeof(((git_remote_callbacks *)0)->transfer_progress),
                         _CFFI_OP(_CFFI_OP_NOOP, 448) },
  { "update_tips", offsetof(git_remote_callbacks, update_tips),
                   sizeof(((git_remote_callbacks *)0)->update_tips),
                   _CFFI_OP(_CFFI_OP_NOOP, 941) },
  { "pack_progress", offsetof(git_remote_callbacks, pack_progress),
                     sizeof(((git_remote_callbacks *)0)->pack_progress),
                     _CFFI_OP(_CFFI_OP_NOOP, 958) },
  { "push_transfer_progress", offsetof(git_remote_callbacks, push_transfer_progress),
                              sizeof(((git_remote_callbacks *)0)->push_transfer_progress),
                              _CFFI_OP(_CFFI_OP_NOOP, 959) },
  { "push_update_reference", offsetof(git_remote_callbacks, push_update_reference),
                             sizeof(((git_remote_callbacks *)0)->push_update_reference),
                             _CFFI_OP(_CFFI_OP_NOOP, 348) },
  { "push_negotiation", offsetof(git_remote_callbacks, push_negotiation),
                        sizeof(((git_remote_callbacks *)0)->push_negotiation),
                        _CFFI_OP(_CFFI_OP_NOOP, 949) },
  { "transport", offsetof(git_remote_callbacks, transport),
                 sizeof(((git_remote_callbacks *)0)->transport),
                 _CFFI_OP(_CFFI_OP_NOOP, 955) },
  { "remote_ready", offsetof(git_remote_callbacks, remote_ready),
                    sizeof(((git_remote_callbacks *)0)->remote_ready),
                    _CFFI_OP(_CFFI_OP_NOOP, 951) },
  { "payload", offsetof(git_remote_callbacks, payload),
               sizeof(((git_remote_callbacks *)0)->payload),
               _CFFI_OP(_CFFI_OP_NOOP, 67) },
  { "resolve_url", offsetof(git_remote_callbacks, resolve_url),
                   sizeof(((git_remote_callbacks *)0)->resolve_url),
                   _CFFI_OP(_CFFI_OP_NOOP, 943) },
  { "update_refs", offsetof(git_remote_callbacks, update_refs),
                   sizeof(((git_remote_callbacks *)0)->update_refs),
                   _CFFI_OP(_CFFI_OP_NOOP, 940) },
  { "local", offsetof(git_remote_head, local),
             sizeof(((git_remote_head *)0)->local),
             _CFFI_OP(_CFFI_OP_NOOP, 28) },
  { "oid", offsetof(git_remote_head, oid),
           sizeof(((git_remote_head *)0)->oid),
           _CFFI_OP(_CFFI_OP_NOOP, 903) },
  { "loid", offsetof(git_remote_head, loid),
            sizeof(((git_remote_head *)0)->loid),
            _CFFI_OP(_CFFI_OP_NOOP, 903) },
  { "name", offsetof(git_remote_head, name),
            sizeof(((git_remote_head *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 844) },
  { "symref_target", offsetof(git_remote_head, symref_target),
                     sizeof(((git_remote_head *)0)->symref_target),
                     _CFFI_OP(_CFFI_OP_NOOP, 844) },
  { "name", offsetof(git_signature, name),
            sizeof(((git_signature *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 844) },
  { "email", offsetof(git_signature, email),
             sizeof(((git_signature *)0)->email),
             _CFFI_OP(_CFFI_OP_NOOP, 844) },
  { "when", offsetof(git_signature, when),
            sizeof(((git_signature *)0)->when),
            _CFFI_OP(_CFFI_OP_NOOP, 936) },
  { "version", offsetof(git_stash_apply_options, version),
               sizeof(((git_stash_apply_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "flags", offsetof(git_stash_apply_options, flags),
             sizeof(((git_stash_apply_options *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 929) },
  { "checkout_options", offsetof(git_stash_apply_options, checkout_options),
                        sizeof(((git_stash_apply_options *)0)->checkout_options),
                        _CFFI_OP(_CFFI_OP_NOOP, 860) },
  { "progress_cb", offsetof(git_stash_apply_options, progress_cb),
                   sizeof(((git_stash_apply_options *)0)->progress_cb),
                   _CFFI_OP(_CFFI_OP_NOOP, 954) },
  { "progress_payload", offsetof(git_stash_apply_options, progress_payload),
                        sizeof(((git_stash_apply_options *)0)->progress_payload),
                        _CFFI_OP(_CFFI_OP_NOOP, 67) },
  { "version", offsetof(git_stash_save_options, version),
               sizeof(((git_stash_save_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "flags", offsetof(git_stash_save_options, flags),
             sizeof(((git_stash_save_options *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 18) },
  { "stasher", offsetof(git_stash_save_options, stasher),
               sizeof(((git_stash_save_options *)0)->stasher),
               _CFFI_OP(_CFFI_OP_NOOP, 406) },
  { "message", offsetof(git_stash_save_options, message),
               sizeof(((git_stash_save_options *)0)->message),
               _CFFI_OP(_CFFI_OP_NOOP, 10) },
  { "paths", offsetof(git_stash_save_options, paths),
             sizeof(((git_stash_save_options *)0)->paths),
             _CFFI_OP(_CFFI_OP_NOOP, 933) },
  { "strings", offsetof(git_strarray, strings),
               sizeof(((git_strarray *)0)->strings),
               _CFFI_OP(_CFFI_OP_NOOP, 843) },
  { "count", offsetof(git_strarray, count),
             sizeof(((git_strarray *)0)->count),
             _CFFI_OP(_CFFI_OP_NOOP, 14) },
  { "version", offsetof(git_submodule_update_options, version),
               sizeof(((git_submodule_update_options *)0)->version),
               _CFFI_OP(_CFFI_OP_NOOP, 105) },
  { "checkout_opts", offsetof(git_submodule_update_options, checkout_opts),
                     sizeof(((git_submodule_update_options *)0)->checkout_opts),
                     _CFFI_OP(_CFFI_OP_NOOP, 860) },
  { "fetch_opts", offsetof(git_submodule_update_options, fetch_opts),
                  sizeof(((git_submodule_update_options *)0)->fetch_opts),
                  _CFFI_OP(_CFFI_OP_NOOP, 888) },
  { "allow_fetch", offsetof(git_submodule_update_options, allow_fetch),
                   sizeof(((git_submodule_update_options *)0)->allow_fetch),
                   _CFFI_OP(_CFFI_OP_NOOP, 28) },
  { "time", offsetof(git_time, time),
            sizeof(((git_time *)0)->time),
            _CFFI_OP(_CFFI_OP_NOOP, 197) },
  { "offset", offsetof(git_time, offset),
              sizeof(((git_time *)0)->offset),
              _CFFI_OP(_CFFI_OP_NOOP, 28) },
  { "sign", offsetof(git_time, sign),
            sizeof(((git_time *)0)->sign),
            _CFFI_OP(_CFFI_OP_NOOP, 845) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$git_attr_options", 848, _CFFI_F_CHECK_FIELDS,
    sizeof(git_attr_options), offsetof(struct _cffi_align_typedef_git_attr_options, y), 0, 4 },
  { "$git_buf", 854, _CFFI_F_CHECK_FIELDS,
    sizeof(git_buf), offsetof(struct _cffi_align_typedef_git_buf, y), 4, 3 },
  { "$git_cert", 855, _CFFI_F_CHECK_FIELDS,
    sizeof(git_cert), offsetof(struct _cffi_align_typedef_git_cert, y), 7, 1 },
  { "$git_cert_hostkey", 856, _CFFI_F_CHECK_FIELDS,
    sizeof(git_cert_hostkey), offsetof(struct _cffi_align_typedef_git_cert_hostkey, y), 8, 4 },
  { "$git_cert_x509", 859, _CFFI_F_CHECK_FIELDS,
    sizeof(git_cert_x509), offsetof(struct _cffi_align_typedef_git_cert_x509, y), 12, 3 },
  { "$git_checkout_perfdata", 861, _CFFI_F_CHECK_FIELDS,
    sizeof(git_checkout_perfdata), offsetof(struct _cffi_align_typedef_git_checkout_perfdata, y), 15, 3 },
  { "$git_describe_format_options", 872, _CFFI_F_CHECK_FIELDS,
    sizeof(git_describe_format_options), offsetof(struct _cffi_align_typedef_git_describe_format_options, y), 18, 4 },
  { "$git_diff_delta", 878, _CFFI_F_CHECK_FIELDS,
    sizeof(git_diff_delta), offsetof(struct _cffi_align_typedef_git_diff_delta, y), 22, 6 },
  { "$git_diff_file", 879, _CFFI_F_CHECK_FIELDS,
    sizeof(git_diff_file), offsetof(struct _cffi_align_typedef_git_diff_file, y), 28, 6 },
  { "$git_diff_options", 880, _CFFI_F_CHECK_FIELDS,
    sizeof(git_diff_options), offsetof(struct _cffi_align_typedef_git_diff_options, y), 34, 14 },
  { "$git_diff_similarity_metric", 882, _CFFI_F_CHECK_FIELDS,
    sizeof(git_diff_similarity_metric), offsetof(struct _cffi_align_typedef_git_diff_similarity_metric, y), 48, 5 },
  { "$git_error", 885, _CFFI_F_CHECK_FIELDS,
    sizeof(git_error), offsetof(struct _cffi_align_typedef_git_error, y), 53, 2 },
  { "$git_fetch_options", 888, _CFFI_F_CHECK_FIELDS,
    sizeof(git_fetch_options), offsetof(struct _cffi_align_typedef_git_fetch_options, y), 55, 9 },
  { "$git_index_time", 893, _CFFI_F_CHECK_FIELDS,
    sizeof(git_index_time), offsetof(struct _cffi_align_typedef_git_index_time, y), 64, 2 },
  { "$git_merge_file_options", 898, _CFFI_F_CHECK_FIELDS,
    sizeof(git_merge_file_options), offsetof(struct _cffi_align_typedef_git_merge_file_options, y), 66, 7 },
  { "$git_merge_file_result", 899, _CFFI_F_CHECK_FIELDS,
    sizeof(git_merge_file_result), offsetof(struct _cffi_align_typedef_git_merge_file_result, y), 73, 5 },
  { "$git_merge_options", 901, _CFFI_F_CHECK_FIELDS,
    sizeof(git_merge_options), offsetof(struct _cffi_align_typedef_git_merge_options, y), 78, 9 },
  { "$git_proxy_options", 906, _CFFI_F_CHECK_FIELDS,
    sizeof(git_proxy_options), offsetof(struct _cffi_align_typedef_git_proxy_options, y), 87, 6 },
  { "$git_push_options", 908, _CFFI_F_CHECK_FIELDS,
    sizeof(git_push_options), offsetof(struct _cffi_align_typedef_git_push_options, y), 93, 7 },
  { "$git_push_update", 910, _CFFI_F_CHECK_FIELDS,
    sizeof(git_push_update), offsetof(struct _cffi_align_typedef_git_push_update, y), 100, 4 },
  { "$git_repository_init_options", 923, _CFFI_F_CHECK_FIELDS,
    sizeof(git_repository_init_options), offsetof(struct _cffi_align_typedef_git_repository_init_options, y), 104, 8 },
  { "$git_revert_options", 926, _CFFI_F_CHECK_FIELDS,
    sizeof(git_revert_options), offsetof(struct _cffi_align_typedef_git_revert_options, y), 112, 4 },
  { "git_annotated_commit", 847, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_blame", 850, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_blame_hunk", 852, _CFFI_F_CHECK_FIELDS,
    sizeof(git_blame_hunk), offsetof(struct _cffi_align__git_blame_hunk, y), 116, 12 },
  { "git_blame_options", 853, _CFFI_F_CHECK_FIELDS,
    sizeof(git_blame_options), offsetof(struct _cffi_align__git_blame_options, y), 128, 7 },
  { "git_checkout_options", 860, _CFFI_F_CHECK_FIELDS,
    sizeof(git_checkout_options), offsetof(struct _cffi_align__git_checkout_options, y), 135, 20 },
  { "git_clone_options", 863, _CFFI_F_CHECK_FIELDS,
    sizeof(git_clone_options), offsetof(struct _cffi_align__git_clone_options, y), 155, 10 },
  { "git_commit", 864, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_config", 865, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_config_entry", 866, _CFFI_F_CHECK_FIELDS,
    sizeof(git_config_entry), offsetof(struct _cffi_align__git_config_entry, y), 165, 6 },
  { "git_config_iterator", 867, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_credential", 869, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_describe_options", 873, _CFFI_F_CHECK_FIELDS,
    sizeof(git_describe_options), offsetof(struct _cffi_align__git_describe_options, y), 171, 6 },
  { "git_describe_result", 874, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_diff", 877, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_index", 890, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_index_conflict_iterator", 891, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_index_entry", 892, _CFFI_F_CHECK_FIELDS,
    sizeof(git_index_entry), offsetof(struct _cffi_align__git_index_entry, y), 177, 12 },
  { "git_indexer_progress", 894, _CFFI_F_CHECK_FIELDS,
    sizeof(git_indexer_progress), offsetof(struct _cffi_align__git_indexer_progress, y), 189, 7 },
  { "git_object", 902, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_oid", 903, _CFFI_F_CHECK_FIELDS,
    sizeof(git_oid), offsetof(struct _cffi_align__git_oid, y), 196, 1 },
  { "git_packbuilder", 905, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_reference", 963, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_refspec", 912, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_remote", 913, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_remote_callbacks", 915, _CFFI_F_CHECK_FIELDS,
    sizeof(git_remote_callbacks), offsetof(struct _cffi_align__git_remote_callbacks, y), 197, 16 },
  { "git_remote_head", 918, _CFFI_F_CHECK_FIELDS,
    sizeof(git_remote_head), offsetof(struct _cffi_align__git_remote_head, y), 213, 5 },
  { "git_repository", 920, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_signature", 928, _CFFI_F_CHECK_FIELDS,
    sizeof(git_signature), offsetof(struct _cffi_align__git_signature, y), 218, 3 },
  { "git_stash_apply_options", 930, _CFFI_F_CHECK_FIELDS,
    sizeof(git_stash_apply_options), offsetof(struct _cffi_align__git_stash_apply_options, y), 221, 5 },
  { "git_stash_save_options", 932, _CFFI_F_CHECK_FIELDS,
    sizeof(git_stash_save_options), offsetof(struct _cffi_align__git_stash_save_options, y), 226, 5 },
  { "git_strarray", 933, _CFFI_F_CHECK_FIELDS,
    sizeof(git_strarray), offsetof(struct _cffi_align__git_strarray, y), 231, 2 },
  { "git_submodule", 934, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_submodule_update_options", 935, _CFFI_F_CHECK_FIELDS,
    sizeof(git_submodule_update_options), offsetof(struct _cffi_align__git_submodule_update_options, y), 233, 4 },
  { "git_time", 936, _CFFI_F_CHECK_FIELDS,
    sizeof(git_time), offsetof(struct _cffi_align__git_time, y), 237, 3 },
  { "git_transport", 938, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "git_tree", 939, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$git_attr_value_t", 849, _cffi_prim_int(sizeof(git_attr_value_t), ((git_attr_value_t)-1) <= 0),
    "GIT_ATTR_VALUE_UNSPECIFIED,GIT_ATTR_VALUE_TRUE,GIT_ATTR_VALUE_FALSE,GIT_ATTR_VALUE_STRING" },
  { "$git_cert_ssh_t", 857, _cffi_prim_int(sizeof(git_cert_ssh_t), ((git_cert_ssh_t)-1) <= 0),
    "GIT_CERT_SSH_MD5,GIT_CERT_SSH_SHA1" },
  { "$git_checkout_notify_t", 137, _cffi_prim_int(sizeof(git_checkout_notify_t), ((git_checkout_notify_t)-1) <= 0),
    "GIT_CHECKOUT_NOTIFY_NONE,GIT_CHECKOUT_NOTIFY_CONFLICT,GIT_CHECKOUT_NOTIFY_DIRTY,GIT_CHECKOUT_NOTIFY_UPDATED,GIT_CHECKOUT_NOTIFY_UNTRACKED,GIT_CHECKOUT_NOTIFY_IGNORED,GIT_CHECKOUT_NOTIFY_ALL" },
  { "$git_clone_local_t", 862, _cffi_prim_int(sizeof(git_clone_local_t), ((git_clone_local_t)-1) <= 0),
    "GIT_CLONE_LOCAL_AUTO,GIT_CLONE_LOCAL,GIT_CLONE_NO_LOCAL,GIT_CLONE_LOCAL_NO_LINKS" },
  { "$git_config_level_t", 185, _cffi_prim_int(sizeof(git_config_level_t), ((git_config_level_t)-1) <= 0),
    "GIT_CONFIG_LEVEL_PROGRAMDATA,GIT_CONFIG_LEVEL_SYSTEM,GIT_CONFIG_LEVEL_XDG,GIT_CONFIG_LEVEL_GLOBAL,GIT_CONFIG_LEVEL_LOCAL,GIT_CONFIG_LEVEL_WORKTREE,GIT_CONFIG_LEVEL_APP,GIT_CONFIG_HIGHEST_LEVEL" },
  { "$git_credential_t", 870, _cffi_prim_int(sizeof(git_credential_t), ((git_credential_t)-1) <= 0),
    "GIT_CREDENTIAL_USERPASS_PLAINTEXT,GIT_CREDENTIAL_SSH_KEY,GIT_CREDENTIAL_SSH_CUSTOM,GIT_CREDENTIAL_DEFAULT,GIT_CREDENTIAL_SSH_INTERACTIVE,GIT_CREDENTIAL_USERNAME,GIT_CREDENTIAL_SSH_MEMORY" },
  { "$git_delta_t", 871, _cffi_prim_int(sizeof(git_delta_t), ((git_delta_t)-1) <= 0),
    "GIT_DELTA_UNMODIFIED,GIT_DELTA_ADDED,GIT_DELTA_DELETED,GIT_DELTA_MODIFIED,GIT_DELTA_RENAMED,GIT_DELTA_COPIED,GIT_DELTA_IGNORED,GIT_DELTA_UNTRACKED,GIT_DELTA_TYPECHANGE,GIT_DELTA_UNREADABLE,GIT_DELTA_CONFLICTED" },
  { "$git_describe_strategy_t", 875, _cffi_prim_int(sizeof(git_describe_strategy_t), ((git_describe_strategy_t)-1) <= 0),
    "GIT_DESCRIBE_DEFAULT,GIT_DESCRIBE_TAGS,GIT_DESCRIBE_ALL" },
  { "$git_direction", 883, _cffi_prim_int(sizeof(git_direction), ((git_direction)-1) <= 0),
    "GIT_DIRECTION_FETCH,GIT_DIRECTION_PUSH" },
  { "$git_error_code", 886, _cffi_prim_int(sizeof(git_error_code), ((git_error_code)-1) <= 0),
    "GIT_OK,GIT_ERROR,GIT_ENOTFOUND,GIT_EEXISTS,GIT_EAMBIGUOUS,GIT_EBUFS,GIT_EUSER,GIT_EBAREREPO,GIT_EUNBORNBRANCH,GIT_EUNMERGED,GIT_ENONFASTFORWARD,GIT_EINVALIDSPEC,GIT_ECONFLICT,GIT_ELOCKED,GIT_EMODIFIED,GIT_EAUTH,GIT_ECERTIFICATE,GIT_EAPPLIED,GIT_EPEEL,GIT_EEOF,GIT_EINVALID,GIT_EUNCOMMITTED,GIT_EDIRECTORY,GIT_EMERGECONFLICT,GIT_PASSTHROUGH,GIT_ITEROVER,GIT_RETRY,GIT_EMISMATCH,GIT_EINDEXDIRTY,GIT_EAPPLYFAIL,GIT_EOWNER,GIT_TIMEOUT" },
  { "$git_feature_t", 887, _cffi_prim_int(sizeof(git_feature_t), ((git_feature_t)-1) <= 0),
    "GIT_FEATURE_THREADS,GIT_FEATURE_HTTPS,GIT_FEATURE_SSH,GIT_FEATURE_NSEC" },
  { "$git_fetch_prune_t", 889, _cffi_prim_int(sizeof(git_fetch_prune_t), ((git_fetch_prune_t)-1) <= 0),
    "GIT_FETCH_PRUNE_UNSPECIFIED,GIT_FETCH_PRUNE,GIT_FETCH_NO_PRUNE" },
  { "$git_libgit2_opt_t", 895, _cffi_prim_int(sizeof(git_libgit2_opt_t), ((git_libgit2_opt_t)-1) <= 0),
    "GIT_OPT_GET_MWINDOW_SIZE,GIT_OPT_SET_MWINDOW_SIZE,GIT_OPT_GET_MWINDOW_MAPPED_LIMIT,GIT_OPT_SET_MWINDOW_MAPPED_LIMIT,GIT_OPT_GET_SEARCH_PATH,GIT_OPT_SET_SEARCH_PATH,GIT_OPT_SET_CACHE_OBJECT_LIMIT,GIT_OPT_SET_CACHE_MAX_SIZE,GIT_OPT_ENABLE_CACHING,GIT_OPT_GET_CACHED_MEMORY,GIT_OPT_GET_TEMPLATE_PATH,GIT_OPT_SET_TEMPLATE_PATH,GIT_OPT_SET_SSL_CERT_LOCATIONS,GIT_OPT_SET_USER_AGENT,GIT_OPT_ENABLE_STRICT_OBJECT_CREATION,GIT_OPT_ENABLE_STRICT_SYMBOLIC_REF_CREATION,GIT_OPT_SET_SSL_CIPHERS,GIT_OPT_GET_USER_AGENT,GIT_OPT_ENABLE_OFS_DELTA,GIT_OPT_ENABLE_FSYNC_GITDIR,GIT_OPT_GET_WINDOWS_SHAREMODE,GIT_OPT_SET_WINDOWS_SHAREMODE,GIT_OPT_ENABLE_STRICT_HASH_VERIFICATION,GIT_OPT_SET_ALLOCATOR,GIT_OPT_ENABLE_UNSAVED_INDEX_SAFETY,GIT_OPT_GET_PACK_MAX_OBJECTS,GIT_OPT_SET_PACK_MAX_OBJECTS,GIT_OPT_DISABLE_PACK_KEEP_FILE_CHECKS,GIT_OPT_ENABLE_HTTP_EXPECT_CONTINUE,GIT_OPT_GET_MWINDOW_FILE_LIMIT,GIT_OPT_SET_MWINDOW_FILE_LIMIT,GIT_OPT_SET_ODB_PACKED_PRIORITY,GIT_OPT_SET_ODB_LOOSE_PRIORITY,GIT_OPT_GET_EXTENSIONS,GIT_OPT_SET_EXTENSIONS,GIT_OPT_GET_OWNER_VALIDATION,GIT_OPT_SET_OWNER_VALIDATION,GIT_OPT_GET_HOMEDIR,GIT_OPT_SET_HOMEDIR,GIT_OPT_SET_SERVER_CONNECT_TIMEOUT,GIT_OPT_GET_SERVER_CONNECT_TIMEOUT,GIT_OPT_SET_SERVER_TIMEOUT,GIT_OPT_GET_SERVER_TIMEOUT,GIT_OPT_SET_USER_AGENT_PRODUCT,GIT_OPT_GET_USER_AGENT_PRODUCT,GIT_OPT_ADD_SSL_X509_CERT" },
  { "$git_merge_file_favor_t", 896, _cffi_prim_int(sizeof(git_merge_file_favor_t), ((git_merge_file_favor_t)-1) <= 0),
    "GIT_MERGE_FILE_FAVOR_NORMAL,GIT_MERGE_FILE_FAVOR_OURS,GIT_MERGE_FILE_FAVOR_THEIRS,GIT_MERGE_FILE_FAVOR_UNION" },
  { "$git_merge_file_flag_t", 897, _cffi_prim_int(sizeof(git_merge_file_flag_t), ((git_merge_file_flag_t)-1) <= 0),
    "GIT_MERGE_FILE_DEFAULT,GIT_MERGE_FILE_STYLE_MERGE,GIT_MERGE_FILE_STYLE_DIFF3,GIT_MERGE_FILE_SIMPLIFY_ALNUM,GIT_MERGE_FILE_IGNORE_WHITESPACE,GIT_MERGE_FILE_IGNORE_WHITESPACE_CHANGE,GIT_MERGE_FILE_IGNORE_WHITESPACE_EOL,GIT_MERGE_FILE_DIFF_PATIENCE,GIT_MERGE_FILE_DIFF_MINIMAL,GIT_MERGE_FILE_STYLE_ZDIFF3,GIT_MERGE_FILE_ACCEPT_CONFLICTS" },
  { "$git_merge_flag_t", 900, _cffi_prim_int(sizeof(git_merge_flag_t), ((git_merge_flag_t)-1) <= 0),
    "GIT_MERGE_FIND_RENAMES,GIT_MERGE_FAIL_ON_CONFLICT,GIT_MERGE_SKIP_REUC,GIT_MERGE_NO_RECURSIVE,GIT_MERGE_VIRTUAL_BASE" },
  { "$git_object_t", 425, _cffi_prim_int(sizeof(git_object_t), ((git_object_t)-1) <= 0),
    "GIT_OBJECT_ANY,GIT_OBJECT_INVALID,GIT_OBJECT_COMMIT,GIT_OBJECT_TREE,GIT_OBJECT_BLOB,GIT_OBJECT_TAG,GIT_OBJECT_OFS_DELTA,GIT_OBJECT_REF_DELTA" },
  { "$git_oid_t", 904, _cffi_prim_int(sizeof(git_oid_t), ((git_oid_t)-1) <= 0),
    "GIT_OID_SHA1" },
  { "$git_proxy_t", 907, _cffi_prim_int(sizeof(git_proxy_t), ((git_proxy_t)-1) <= 0),
    "GIT_PROXY_NONE,GIT_PROXY_AUTO,GIT_PROXY_SPECIFIED" },
  { "$git_reference_t", 911, _cffi_prim_int(sizeof(git_reference_t), ((git_reference_t)-1) <= 0),
    "GIT_REFERENCE_INVALID,GIT_REFERENCE_DIRECT,GIT_REFERENCE_SYMBOLIC,GIT_REFERENCE_ALL" },
  { "$git_remote_autotag_option_t", 914, _cffi_prim_int(sizeof(git_remote_autotag_option_t), ((git_remote_autotag_option_t)-1) <= 0),
    "GIT_REMOTE_DOWNLOAD_TAGS_UNSPECIFIED,GIT_REMOTE_DOWNLOAD_TAGS_AUTO,GIT_REMOTE_DOWNLOAD_TAGS_NONE,GIT_REMOTE_DOWNLOAD_TAGS_ALL" },
  { "$git_remote_redirect_t", 919, _cffi_prim_int(sizeof(git_remote_redirect_t), ((git_remote_redirect_t)-1) <= 0),
    "GIT_REMOTE_REDIRECT_NONE,GIT_REMOTE_REDIRECT_INITIAL,GIT_REMOTE_REDIRECT_ALL" },
  { "$git_repository_init_flag_t", 921, _cffi_prim_int(sizeof(git_repository_init_flag_t), ((git_repository_init_flag_t)-1) <= 0),
    "GIT_REPOSITORY_INIT_BARE,GIT_REPOSITORY_INIT_NO_REINIT,GIT_REPOSITORY_INIT_NO_DOTGIT_DIR,GIT_REPOSITORY_INIT_MKDIR,GIT_REPOSITORY_INIT_MKPATH,GIT_REPOSITORY_INIT_EXTERNAL_TEMPLATE,GIT_REPOSITORY_INIT_RELATIVE_GITLINK" },
  { "$git_repository_init_mode_t", 922, _cffi_prim_int(sizeof(git_repository_init_mode_t), ((git_repository_init_mode_t)-1) <= 0),
    "GIT_REPOSITORY_INIT_SHARED_UMASK,GIT_REPOSITORY_INIT_SHARED_GROUP,GIT_REPOSITORY_INIT_SHARED_ALL" },
  { "$git_repository_open_flag_t", 924, _cffi_prim_int(sizeof(git_repository_open_flag_t), ((git_repository_open_flag_t)-1) <= 0),
    "GIT_REPOSITORY_OPEN_NO_SEARCH,GIT_REPOSITORY_OPEN_CROSS_FS,GIT_REPOSITORY_OPEN_BARE,GIT_REPOSITORY_OPEN_NO_DOTGIT,GIT_REPOSITORY_OPEN_FROM_ENV" },
  { "$git_repository_state_t", 925, _cffi_prim_int(sizeof(git_repository_state_t), ((git_repository_state_t)-1) <= 0),
    "GIT_REPOSITORY_STATE_NONE,GIT_REPOSITORY_STATE_MERGE,GIT_REPOSITORY_STATE_REVERT,GIT_REPOSITORY_STATE_REVERT_SEQUENCE,GIT_REPOSITORY_STATE_CHERRYPICK,GIT_REPOSITORY_STATE_CHERRYPICK_SEQUENCE,GIT_REPOSITORY_STATE_BISECT,GIT_REPOSITORY_STATE_REBASE,GIT_REPOSITORY_STATE_REBASE_INTERACTIVE,GIT_REPOSITORY_STATE_REBASE_MERGE,GIT_REPOSITORY_STATE_APPLY_MAILBOX,GIT_REPOSITORY_STATE_APPLY_MAILBOX_OR_REBASE" },
  { "$git_stash_apply_flags", 929, _cffi_prim_int(sizeof(git_stash_apply_flags), ((git_stash_apply_flags)-1) <= 0),
    "GIT_STASH_APPLY_DEFAULT,GIT_STASH_APPLY_REINSTATE_INDEX" },
  { "$git_stash_apply_progress_t", 643, _cffi_prim_int(sizeof(git_stash_apply_progress_t), ((git_stash_apply_progress_t)-1) <= 0),
    "GIT_STASH_APPLY_PROGRESS_NONE,GIT_STASH_APPLY_PROGRESS_LOADING_STASH,GIT_STASH_APPLY_PROGRESS_ANALYZE_INDEX,GIT_STASH_APPLY_PROGRESS_ANALYZE_MODIFIED,GIT_STASH_APPLY_PROGRESS_ANALYZE_UNTRACKED,GIT_STASH_APPLY_PROGRESS_CHECKOUT_UNTRACKED,GIT_STASH_APPLY_PROGRESS_CHECKOUT_MODIFIED,GIT_STASH_APPLY_PROGRESS_DONE" },
  { "$git_stash_flags", 931, _cffi_prim_int(sizeof(git_stash_flags), ((git_stash_flags)-1) <= 0),
    "GIT_STASH_DEFAULT,GIT_STASH_KEEP_INDEX,GIT_STASH_INCLUDE_UNTRACKED,GIT_STASH_INCLUDE_IGNORED,GIT_STASH_KEEP_ALL" },
  { "$git_submodule_ignore_t", 742, _cffi_prim_int(sizeof(git_submodule_ignore_t), ((git_submodule_ignore_t)-1) <= 0),
    "GIT_SUBMODULE_IGNORE_UNSPECIFIED,GIT_SUBMODULE_IGNORE_NONE,GIT_SUBMODULE_IGNORE_UNTRACKED,GIT_SUBMODULE_IGNORE_DIRTY,GIT_SUBMODULE_IGNORE_ALL" },
  { "git_cert_t", 858, _cffi_prim_int(sizeof(git_cert_t), ((git_cert_t)-1) <= 0),
    "GIT_CERT_NONE,GIT_CERT_X509,GIT_CERT_HOSTKEY_LIBSSH2,GIT_CERT_STRARRAY" },
  { "git_remote_completion_t", 533, _cffi_prim_int(sizeof(git_remote_completion_t), ((git_remote_completion_t)-1) <= 0),
    "GIT_REMOTE_COMPLETION_DOWNLOAD,GIT_REMOTE_COMPLETION_INDEXING,GIT_REMOTE_COMPLETION_ERROR" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "git_annotated_commit", 847 },
  { "git_attr_options", 848 },
  { "git_attr_value_t", 849 },
  { "git_blame", 850 },
  { "git_blame_hunk", 852 },
  { "git_blame_options", 853 },
  { "git_buf", 854 },
  { "git_cert", 855 },
  { "git_cert_hostkey", 856 },
  { "git_cert_ssh_t", 857 },
  { "git_cert_t", 858 },
  { "git_cert_x509", 859 },
  { "git_checkout_notify_cb", 945 },
  { "git_checkout_notify_t", 137 },
  { "git_checkout_options", 860 },
  { "git_checkout_perfdata", 861 },
  { "git_checkout_perfdata_cb", 972 },
  { "git_checkout_progress_cb", 971 },
  { "git_clone_local_t", 862 },
  { "git_clone_options", 863 },
  { "git_commit", 864 },
  { "git_config", 865 },
  { "git_config_entry", 866 },
  { "git_config_iterator", 867 },
  { "git_config_level_t", 185 },
  { "git_credential", 869 },
  { "git_credential_acquire_cb", 946 },
  { "git_credential_t", 870 },
  { "git_delta_t", 871 },
  { "git_describe_format_options", 872 },
  { "git_describe_options", 873 },
  { "git_describe_result", 874 },
  { "git_describe_strategy_t", 875 },
  { "git_diff", 877 },
  { "git_diff_delta", 878 },
  { "git_diff_file", 879 },
  { "git_diff_notify_cb", 948 },
  { "git_diff_options", 880 },
  { "git_diff_progress_cb", 947 },
  { "git_diff_similarity_metric", 882 },
  { "git_direction", 883 },
  { "git_error", 885 },
  { "git_error_code", 886 },
  { "git_feature_t", 887 },
  { "git_fetch_options", 888 },
  { "git_fetch_prune_t", 889 },
  { "git_index", 890 },
  { "git_index_conflict_iterator", 891 },
  { "git_index_entry", 892 },
  { "git_index_matched_path_cb", 348 },
  { "git_index_time", 893 },
  { "git_indexer_progress", 894 },
  { "git_indexer_progress_cb", 448 },
  { "git_libgit2_opt_t", 895 },
  { "git_merge_file_favor_t", 896 },
  { "git_merge_file_flag_t", 897 },
  { "git_merge_file_options", 898 },
  { "git_merge_file_result", 899 },
  { "git_merge_flag_t", 900 },
  { "git_merge_options", 901 },
  { "git_object", 902 },
  { "git_object_t", 425 },
  { "git_off_t", 197 },
  { "git_oid", 903 },
  { "git_oid_t", 904 },
  { "git_packbuilder", 905 },
  { "git_packbuilder_progress", 958 },
  { "git_proxy_options", 906 },
  { "git_proxy_t", 907 },
  { "git_push_negotiation", 949 },
  { "git_push_options", 908 },
  { "git_push_transfer_progress_cb", 959 },
  { "git_push_update", 910 },
  { "git_push_update_reference_cb", 348 },
  { "git_reference_t", 911 },
  { "git_refspec", 912 },
  { "git_remote", 913 },
  { "git_remote_autotag_option_t", 914 },
  { "git_remote_callbacks", 915 },
  { "git_remote_completion_t", 533 },
  { "git_remote_create_cb", 950 },
  { "git_remote_head", 918 },
  { "git_remote_ready_cb", 951 },
  { "git_remote_redirect_t", 919 },
  { "git_repository", 920 },
  { "git_repository_create_cb", 953 },
  { "git_repository_init_flag_t", 921 },
  { "git_repository_init_mode_t", 922 },
  { "git_repository_init_options", 923 },
  { "git_repository_open_flag_t", 924 },
  { "git_repository_state_t", 925 },
  { "git_revert_options", 926 },
  { "git_signature", 928 },
  { "git_stash_apply_flags", 929 },
  { "git_stash_apply_options", 930 },
  { "git_stash_apply_progress_cb", 954 },
  { "git_stash_apply_progress_t", 643 },
  { "git_stash_cb", 622 },
  { "git_stash_flags", 931 },
  { "git_stash_save_options", 932 },
  { "git_strarray", 933 },
  { "git_submodule", 934 },
  { "git_submodule_ignore_t", 742 },
  { "git_submodule_update_options", 935 },
  { "git_time", 936 },
  { "git_time_t", 197 },
  { "git_transport", 938 },
  { "git_transport_cb", 955 },
  { "git_transport_certificate_check_cb", 944 },
  { "git_transport_message_cb", 942 },
  { "git_tree", 939 },
  { "git_url_resolve_cb", 943 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  449,  /* num_globals */
  58,  /* num_struct_unions */
  32,  /* num_enums */
  112,  /* num_typenames */
  NULL,  /* no includes */
  975,  /* num_types */
  1,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__libgit2(const void *p[])
{
    if (((intptr_t)p[0]) >= 0x0A03) {
        _cffi_call_python_org = (void(*)(struct _cffi_externpy_s *, char *))p[1];
    }
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__libgit2(void) { return NULL; }
#  else
     init_libgit2(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__libgit2(void)
{
  return _cffi_init("pygit2._libgit2", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_libgit2(void)
{
  _cffi_init("pygit2._libgit2", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
