/* presentation.c generated by valac 0.56.17, the Vala compiler
 * generated from presentation.vala, do not modify */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PDFPC_WINDOW_TYPE_FULLSCREEN (pdfpc_window_fullscreen_get_type ())
#define PDFPC_WINDOW_FULLSCREEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_WINDOW_TYPE_FULLSCREEN, pdfpcWindowFullscreen))
#define PDFPC_WINDOW_FULLSCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_WINDOW_TYPE_FULLSCREEN, pdfpcWindowFullscreenClass))
#define PDFPC_WINDOW_IS_FULLSCREEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_WINDOW_TYPE_FULLSCREEN))
#define PDFPC_WINDOW_IS_FULLSCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_WINDOW_TYPE_FULLSCREEN))
#define PDFPC_WINDOW_FULLSCREEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_WINDOW_TYPE_FULLSCREEN, pdfpcWindowFullscreenClass))

typedef struct _pdfpcWindowFullscreen pdfpcWindowFullscreen;
typedef struct _pdfpcWindowFullscreenClass pdfpcWindowFullscreenClass;
typedef struct _pdfpcWindowFullscreenPrivate pdfpcWindowFullscreenPrivate;

#define PDFPC_TYPE_CONTROLLABLE (pdfpc_controllable_get_type ())
#define PDFPC_CONTROLLABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_TYPE_CONTROLLABLE, pdfpcControllable))
#define PDFPC_IS_CONTROLLABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_TYPE_CONTROLLABLE))
#define PDFPC_CONTROLLABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PDFPC_TYPE_CONTROLLABLE, pdfpcControllableIface))

typedef struct _pdfpcControllable pdfpcControllable;
typedef struct _pdfpcControllableIface pdfpcControllableIface;

#define PDFPC_TYPE_PRESENTATION_CONTROLLER (pdfpc_presentation_controller_get_type ())
#define PDFPC_PRESENTATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_TYPE_PRESENTATION_CONTROLLER, pdfpcPresentationController))
#define PDFPC_PRESENTATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_TYPE_PRESENTATION_CONTROLLER, pdfpcPresentationControllerClass))
#define PDFPC_IS_PRESENTATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_TYPE_PRESENTATION_CONTROLLER))
#define PDFPC_IS_PRESENTATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_TYPE_PRESENTATION_CONTROLLER))
#define PDFPC_PRESENTATION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_TYPE_PRESENTATION_CONTROLLER, pdfpcPresentationControllerClass))

typedef struct _pdfpcPresentationController pdfpcPresentationController;
typedef struct _pdfpcPresentationControllerClass pdfpcPresentationControllerClass;

#define PDFPC_VIEW_TYPE_PDF (pdfpc_view_pdf_get_type ())
#define PDFPC_VIEW_PDF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_VIEW_TYPE_PDF, pdfpcViewPdf))
#define PDFPC_VIEW_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_VIEW_TYPE_PDF, pdfpcViewPdfClass))
#define PDFPC_VIEW_IS_PDF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_VIEW_TYPE_PDF))
#define PDFPC_VIEW_IS_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_VIEW_TYPE_PDF))
#define PDFPC_VIEW_PDF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_VIEW_TYPE_PDF, pdfpcViewPdfClass))

typedef struct _pdfpcViewPdf pdfpcViewPdf;
typedef struct _pdfpcViewPdfClass pdfpcViewPdfClass;

#define PDFPC_WINDOW_TYPE_CONTROLLABLE_WINDOW (pdfpc_window_controllable_window_get_type ())
#define PDFPC_WINDOW_CONTROLLABLE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_WINDOW_TYPE_CONTROLLABLE_WINDOW, pdfpcWindowControllableWindow))
#define PDFPC_WINDOW_CONTROLLABLE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_WINDOW_TYPE_CONTROLLABLE_WINDOW, pdfpcWindowControllableWindowClass))
#define PDFPC_WINDOW_IS_CONTROLLABLE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_WINDOW_TYPE_CONTROLLABLE_WINDOW))
#define PDFPC_WINDOW_IS_CONTROLLABLE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_WINDOW_TYPE_CONTROLLABLE_WINDOW))
#define PDFPC_WINDOW_CONTROLLABLE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_WINDOW_TYPE_CONTROLLABLE_WINDOW, pdfpcWindowControllableWindowClass))

typedef struct _pdfpcWindowControllableWindow pdfpcWindowControllableWindow;
typedef struct _pdfpcWindowControllableWindowClass pdfpcWindowControllableWindowClass;
typedef struct _pdfpcWindowControllableWindowPrivate pdfpcWindowControllableWindowPrivate;

#define PDFPC_WINDOW_TYPE_PRESENTATION (pdfpc_window_presentation_get_type ())
#define PDFPC_WINDOW_PRESENTATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_WINDOW_TYPE_PRESENTATION, pdfpcWindowPresentation))
#define PDFPC_WINDOW_PRESENTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_WINDOW_TYPE_PRESENTATION, pdfpcWindowPresentationClass))
#define PDFPC_WINDOW_IS_PRESENTATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_WINDOW_TYPE_PRESENTATION))
#define PDFPC_WINDOW_IS_PRESENTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_WINDOW_TYPE_PRESENTATION))
#define PDFPC_WINDOW_PRESENTATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_WINDOW_TYPE_PRESENTATION, pdfpcWindowPresentationClass))

typedef struct _pdfpcWindowPresentation pdfpcWindowPresentation;
typedef struct _pdfpcWindowPresentationClass pdfpcWindowPresentationClass;
typedef struct _pdfpcWindowPresentationPrivate pdfpcWindowPresentationPrivate;
enum  {
	PDFPC_WINDOW_PRESENTATION_0_PROPERTY,
	PDFPC_WINDOW_PRESENTATION_NUM_PROPERTIES
};
static GParamSpec* pdfpc_window_presentation_properties[PDFPC_WINDOW_PRESENTATION_NUM_PROPERTIES];

#define PDFPC_METADATA_TYPE_PDF (pdfpc_metadata_pdf_get_type ())
#define PDFPC_METADATA_PDF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdf))
#define PDFPC_METADATA_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdfClass))
#define PDFPC_METADATA_IS_PDF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_METADATA_TYPE_PDF))
#define PDFPC_METADATA_IS_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_METADATA_TYPE_PDF))
#define PDFPC_METADATA_PDF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdfClass))

typedef struct _pdfpcMetadataPdf pdfpcMetadataPdf;
typedef struct _pdfpcMetadataPdfClass pdfpcMetadataPdfClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _pdfpcViewPdfPrivate pdfpcViewPdfPrivate;

#define PDFPC_RENDERER_TYPE_PDF (pdfpc_renderer_pdf_get_type ())
#define PDFPC_RENDERER_PDF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_TYPE_PDF, pdfpcRendererPdf))
#define PDFPC_RENDERER_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_RENDERER_TYPE_PDF, pdfpcRendererPdfClass))
#define PDFPC_RENDERER_IS_PDF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_TYPE_PDF))
#define PDFPC_RENDERER_IS_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_RENDERER_TYPE_PDF))
#define PDFPC_RENDERER_PDF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_RENDERER_TYPE_PDF, pdfpcRendererPdfClass))

typedef struct _pdfpcRendererPdf pdfpcRendererPdf;
typedef struct _pdfpcRendererPdfClass pdfpcRendererPdfClass;

#define PDFPC_VIEW_BEHAVIOUR_TYPE_BASE (pdfpc_view_behaviour_base_get_type ())
#define PDFPC_VIEW_BEHAVIOUR_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_VIEW_BEHAVIOUR_TYPE_BASE, pdfpcViewBehaviourBase))
#define PDFPC_VIEW_BEHAVIOUR_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_VIEW_BEHAVIOUR_TYPE_BASE, pdfpcViewBehaviourBaseClass))
#define PDFPC_VIEW_BEHAVIOUR_IS_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_VIEW_BEHAVIOUR_TYPE_BASE))
#define PDFPC_VIEW_BEHAVIOUR_IS_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_VIEW_BEHAVIOUR_TYPE_BASE))
#define PDFPC_VIEW_BEHAVIOUR_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_VIEW_BEHAVIOUR_TYPE_BASE, pdfpcViewBehaviourBaseClass))

typedef struct _pdfpcViewBehaviourBase pdfpcViewBehaviourBase;
typedef struct _pdfpcViewBehaviourBaseClass pdfpcViewBehaviourBaseClass;

#define PDFPC_PRESENTATION_CONTROLLER_TYPE_SCALED_RECTANGLE (pdfpc_presentation_controller_scaled_rectangle_get_type ())
typedef struct _pdfpcPresentationControllerScaledRectangle pdfpcPresentationControllerScaledRectangle;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _pdfpcWindowFullscreen {
	GtkWindow parent_instance;
	pdfpcWindowFullscreenPrivate * priv;
	gboolean windowed;
	GdkScreen* screen_to_use;
	gint monitor_num_to_use;
};

struct _pdfpcWindowFullscreenClass {
	GtkWindowClass parent_class;
	void (*resize_gui) (pdfpcWindowFullscreen* self);
};

struct _pdfpcControllableIface {
	GTypeInterface parent_iface;
	pdfpcPresentationController* (*get_controller) (pdfpcControllable* self);
	void (*set_controller) (pdfpcControllable* self, pdfpcPresentationController* value);
	pdfpcViewPdf* (*get_main_view) (pdfpcControllable* self);
	void (*set_main_view) (pdfpcControllable* self, pdfpcViewPdf* value);
};

struct _pdfpcWindowControllableWindow {
	pdfpcWindowFullscreen parent_instance;
	pdfpcWindowControllableWindowPrivate * priv;
	GtkOverlay* overlay_layout;
	guint hide_cursor_timeout;
	gboolean cursor_blanked;
	guint accepted_key_mods;
	guint last_key_ev_time;
};

struct _pdfpcWindowControllableWindowClass {
	pdfpcWindowFullscreenClass parent_class;
};

struct _pdfpcWindowPresentation {
	pdfpcWindowControllableWindow parent_instance;
	pdfpcWindowPresentationPrivate * priv;
};

struct _pdfpcWindowPresentationClass {
	pdfpcWindowControllableWindowClass parent_class;
};

struct _pdfpcPresentationControllerScaledRectangle {
	gdouble x;
	gdouble y;
	gdouble width;
	gdouble height;
};

struct _pdfpcViewPdf {
	GtkDrawingArea parent_instance;
	pdfpcViewPdfPrivate * priv;
	gboolean entering_slide_queued;
	pdfpcRendererPdf* renderer;
	gint current_slide_number;
	cairo_surface_t* current_slide;
	cairo_surface_t* buffer;
	gboolean disabled;
	gboolean user_slides;
	GList* behaviours;
	gint gdk_scale;
	gboolean notes_area;
	guint prerender_tid;
	guint transition_tid;
	gboolean transitions_enabled;
	pdfpcPresentationControllerScaledRectangle* zoom_area;
};

struct _pdfpcViewPdfClass {
	GtkDrawingAreaClass parent_class;
	gboolean (*prerender) (pdfpcViewPdf* self);
};

static gpointer pdfpc_window_presentation_parent_class = NULL;
VALA_EXTERN gboolean pdfpc_options_single_screen;
VALA_EXTERN gboolean pdfpc_options_presentation_interactive;

VALA_EXTERN GType pdfpc_window_fullscreen_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcWindowFullscreen, g_object_unref)
VALA_EXTERN GType pdfpc_presentation_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcPresentationController, g_object_unref)
VALA_EXTERN GType pdfpc_view_pdf_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcViewPdf, g_object_unref)
VALA_EXTERN GType pdfpc_controllable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcControllable, g_object_unref)
VALA_EXTERN GType pdfpc_window_controllable_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcWindowControllableWindow, g_object_unref)
VALA_EXTERN GType pdfpc_window_presentation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcWindowPresentation, g_object_unref)
VALA_EXTERN pdfpcWindowPresentation* pdfpc_window_presentation_new (pdfpcPresentationController* controller,
                                                        gint screen_num,
                                                        gboolean windowed,
                                                        gint width,
                                                        gint height);
VALA_EXTERN pdfpcWindowPresentation* pdfpc_window_presentation_construct (GType object_type,
                                                              pdfpcPresentationController* controller,
                                                              gint screen_num,
                                                              gboolean windowed,
                                                              gint width,
                                                              gint height);
VALA_EXTERN pdfpcWindowControllableWindow* pdfpc_window_controllable_window_new (pdfpcPresentationController* controller,
                                                                     gboolean interactive,
                                                                     gint monitor_num,
                                                                     gboolean windowed,
                                                                     gint width,
                                                                     gint height);
VALA_EXTERN pdfpcWindowControllableWindow* pdfpc_window_controllable_window_construct (GType object_type,
                                                                           pdfpcPresentationController* controller,
                                                                           gboolean interactive,
                                                                           gint monitor_num,
                                                                           gboolean windowed,
                                                                           gint width,
                                                                           gint height);
VALA_EXTERN GType pdfpc_metadata_pdf_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcMetadataPdf, g_object_unref)
VALA_EXTERN pdfpcMetadataPdf* pdfpc_presentation_controller_get_metadata (pdfpcPresentationController* self);
VALA_EXTERN gchar* pdfpc_metadata_pdf_get_title (pdfpcMetadataPdf* self);
VALA_EXTERN pdfpcPresentationController* pdfpc_controllable_get_controller (pdfpcControllable* self);
VALA_EXTERN void pdfpc_window_presentation_update (pdfpcWindowPresentation* self);
static void _pdfpc_window_presentation_update_pdfpc_presentation_controller_update_request (pdfpcPresentationController* _sender,
                                                                                     gpointer self);
VALA_EXTERN pdfpcViewPdf* pdfpc_controllable_get_main_view (pdfpcControllable* self);
VALA_EXTERN GType pdfpc_renderer_pdf_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcRendererPdf, g_object_unref)
VALA_EXTERN GType pdfpc_view_behaviour_base_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcViewBehaviourBase, g_object_unref)
VALA_EXTERN GType pdfpc_presentation_controller_scaled_rectangle_get_type (void) G_GNUC_CONST ;
VALA_EXTERN pdfpcPresentationControllerScaledRectangle* pdfpc_presentation_controller_scaled_rectangle_dup (const pdfpcPresentationControllerScaledRectangle* self);
VALA_EXTERN void pdfpc_presentation_controller_scaled_rectangle_free (pdfpcPresentationControllerScaledRectangle* self);
static void pdfpc_window_presentation_on_entering_slide (pdfpcWindowPresentation* self,
                                                  gint slide_number);
static void _pdfpc_window_presentation_on_entering_slide_pdfpc_view_pdf_entering_slide (pdfpcViewPdf* _sender,
                                                                                 gint slide_number,
                                                                                 gpointer self);
VALA_EXTERN pdfpcMetadataPdf* pdfpc_window_controllable_window_get_metadata (pdfpcWindowControllableWindow* self);
VALA_EXTERN gdouble pdfpc_metadata_pdf_get_page_width (pdfpcMetadataPdf* self);
VALA_EXTERN gdouble pdfpc_metadata_pdf_get_page_height (pdfpcMetadataPdf* self);
VALA_EXTERN void pdfpc_window_controllable_window_add_top_container (pdfpcWindowControllableWindow* self,
                                                         GtkWidget* top);
VALA_EXTERN gboolean pdfpc_presentation_controller_get_hidden (pdfpcPresentationController* self);
VALA_EXTERN gboolean pdfpc_presentation_controller_get_frozen (pdfpcPresentationController* self);
VALA_EXTERN gboolean pdfpc_presentation_controller_get_faded_to_black (pdfpcPresentationController* self);
VALA_EXTERN void pdfpc_view_pdf_display (pdfpcViewPdf* self,
                             gint slide_number,
                             gboolean force,
                             pdfpcPresentationControllerScaledRectangle* rect);
VALA_EXTERN gint pdfpc_presentation_controller_get_current_slide_number (pdfpcPresentationController* self);
VALA_EXTERN void pdfpc_presentation_controller_start_autoadvance_timer (pdfpcPresentationController* self,
                                                            gint slide_number);
static GType pdfpc_window_presentation_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
         * Base constructor instantiating a new presentation window
         */
static void
_pdfpc_window_presentation_update_pdfpc_presentation_controller_update_request (pdfpcPresentationController* _sender,
                                                                                gpointer self)
{
	pdfpc_window_presentation_update ((pdfpcWindowPresentation*) self);
}

static void
_pdfpc_window_presentation_on_entering_slide_pdfpc_view_pdf_entering_slide (pdfpcViewPdf* _sender,
                                                                            gint slide_number,
                                                                            gpointer self)
{
	pdfpc_window_presentation_on_entering_slide ((pdfpcWindowPresentation*) self, slide_number);
}

pdfpcWindowPresentation*
pdfpc_window_presentation_construct (GType object_type,
                                     pdfpcPresentationController* controller,
                                     gint screen_num,
                                     gboolean windowed,
                                     gint width,
                                     gint height)
{
	pdfpcWindowPresentation * self = NULL;
	gboolean interactive = FALSE;
	gboolean _tmp0_ = FALSE;
	pdfpcMetadataPdf* _tmp1_;
	pdfpcMetadataPdf* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	pdfpcPresentationController* _tmp7_;
	pdfpcPresentationController* _tmp8_;
	pdfpcViewPdf* _tmp9_;
	pdfpcViewPdf* _tmp10_;
	pdfpcViewPdf* _tmp11_;
	pdfpcViewPdf* _tmp12_;
	gdouble ratio = 0.0;
	pdfpcMetadataPdf* _tmp13_;
	pdfpcMetadataPdf* _tmp14_;
	pdfpcMetadataPdf* _tmp15_;
	pdfpcMetadataPdf* _tmp16_;
	GtkAspectFrame* frame = NULL;
	GtkAspectFrame* _tmp17_;
	GtkOverlay* _tmp18_;
	g_return_val_if_fail (controller != NULL, NULL);
	interactive = FALSE;
	if (pdfpc_options_single_screen) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = pdfpc_options_presentation_interactive;
	}
	if (_tmp0_) {
		interactive = TRUE;
	}
	self = (pdfpcWindowPresentation*) pdfpc_window_controllable_window_construct (object_type, controller, interactive, screen_num, windowed, width, height);
	_tmp1_ = pdfpc_presentation_controller_get_metadata (controller);
	_tmp2_ = _tmp1_;
	_tmp3_ = pdfpc_metadata_pdf_get_title (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("pdfpc - presentation (%s)", _tmp4_);
	_tmp6_ = _tmp5_;
	gtk_window_set_title ((GtkWindow*) self, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = pdfpc_controllable_get_controller ((pdfpcControllable*) self);
	_tmp8_ = _tmp7_;
	g_signal_connect_object (_tmp8_, "update-request", (GCallback) _pdfpc_window_presentation_update_pdfpc_presentation_controller_update_request, self, 0);
	_tmp9_ = pdfpc_controllable_get_main_view ((pdfpcControllable*) self);
	_tmp10_ = _tmp9_;
	_tmp10_->transitions_enabled = TRUE;
	_tmp11_ = pdfpc_controllable_get_main_view ((pdfpcControllable*) self);
	_tmp12_ = _tmp11_;
	g_signal_connect_object (_tmp12_, "entering-slide", (GCallback) _pdfpc_window_presentation_on_entering_slide_pdfpc_view_pdf_entering_slide, self, 0);
	_tmp13_ = pdfpc_window_controllable_window_get_metadata ((pdfpcWindowControllableWindow*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = pdfpc_window_controllable_window_get_metadata ((pdfpcWindowControllableWindow*) self);
	_tmp16_ = _tmp15_;
	ratio = pdfpc_metadata_pdf_get_page_width (_tmp14_) / pdfpc_metadata_pdf_get_page_height (_tmp16_);
	_tmp17_ = (GtkAspectFrame*) gtk_aspect_frame_new (NULL, 0.5f, 0.5f, (gfloat) ratio, FALSE);
	g_object_ref_sink (_tmp17_);
	frame = _tmp17_;
	_tmp18_ = ((pdfpcWindowControllableWindow*) self)->overlay_layout;
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) _tmp18_);
	pdfpc_window_controllable_window_add_top_container ((pdfpcWindowControllableWindow*) self, (GtkWidget*) frame);
	_g_object_unref0 (frame);
	return self;
}

pdfpcWindowPresentation*
pdfpc_window_presentation_new (pdfpcPresentationController* controller,
                               gint screen_num,
                               gboolean windowed,
                               gint width,
                               gint height)
{
	return pdfpc_window_presentation_construct (PDFPC_WINDOW_TYPE_PRESENTATION, controller, screen_num, windowed, width, height);
}

/**
         * Update the display
         */
void
pdfpc_window_presentation_update (pdfpcWindowPresentation* self)
{
	pdfpcPresentationController* _tmp0_;
	pdfpcPresentationController* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	pdfpcPresentationController* _tmp4_;
	pdfpcPresentationController* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean old_disabled = FALSE;
	pdfpcViewPdf* _tmp8_;
	pdfpcViewPdf* _tmp9_;
	pdfpcPresentationController* _tmp10_;
	pdfpcPresentationController* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean force = FALSE;
	pdfpcViewPdf* _tmp18_;
	pdfpcViewPdf* _tmp19_;
	pdfpcViewPdf* _tmp20_;
	pdfpcViewPdf* _tmp21_;
	pdfpcPresentationController* _tmp22_;
	pdfpcPresentationController* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pdfpc_controllable_get_controller ((pdfpcControllable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = pdfpc_presentation_controller_get_hidden (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_visible ((GtkWidget*) self, !_tmp3_);
	_tmp4_ = pdfpc_controllable_get_controller ((pdfpcControllable*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = pdfpc_presentation_controller_get_frozen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		return;
	}
	_tmp8_ = pdfpc_controllable_get_main_view ((pdfpcControllable*) self);
	_tmp9_ = _tmp8_;
	old_disabled = _tmp9_->disabled;
	_tmp10_ = pdfpc_controllable_get_controller ((pdfpcControllable*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = pdfpc_presentation_controller_get_faded_to_black (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		pdfpcViewPdf* _tmp14_;
		pdfpcViewPdf* _tmp15_;
		_tmp14_ = pdfpc_controllable_get_main_view ((pdfpcControllable*) self);
		_tmp15_ = _tmp14_;
		_tmp15_->disabled = TRUE;
	} else {
		pdfpcViewPdf* _tmp16_;
		pdfpcViewPdf* _tmp17_;
		_tmp16_ = pdfpc_controllable_get_main_view ((pdfpcControllable*) self);
		_tmp17_ = _tmp16_;
		_tmp17_->disabled = FALSE;
	}
	_tmp18_ = pdfpc_controllable_get_main_view ((pdfpcControllable*) self);
	_tmp19_ = _tmp18_;
	force = old_disabled != _tmp19_->disabled;
	_tmp20_ = pdfpc_controllable_get_main_view ((pdfpcControllable*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = pdfpc_controllable_get_controller ((pdfpcControllable*) self);
	_tmp23_ = _tmp22_;
	_tmp24_ = pdfpc_presentation_controller_get_current_slide_number (_tmp23_);
	_tmp25_ = _tmp24_;
	pdfpc_view_pdf_display (_tmp21_, _tmp25_, force, NULL);
}

static void
pdfpc_window_presentation_on_entering_slide (pdfpcWindowPresentation* self,
                                             gint slide_number)
{
	pdfpcPresentationController* _tmp0_;
	pdfpcPresentationController* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pdfpc_controllable_get_controller ((pdfpcControllable*) self);
	_tmp1_ = _tmp0_;
	pdfpc_presentation_controller_start_autoadvance_timer (_tmp1_, slide_number);
}

static void
pdfpc_window_presentation_class_init (pdfpcWindowPresentationClass * klass,
                                      gpointer klass_data)
{
	pdfpc_window_presentation_parent_class = g_type_class_peek_parent (klass);
}

static void
pdfpc_window_presentation_instance_init (pdfpcWindowPresentation * self,
                                         gpointer klass)
{
}

/**
     * Window showing the currently active slide to be presented on a beamer
     */
static GType
pdfpc_window_presentation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (pdfpcWindowPresentationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdfpc_window_presentation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (pdfpcWindowPresentation), 0, (GInstanceInitFunc) pdfpc_window_presentation_instance_init, NULL };
	GType pdfpc_window_presentation_type_id;
	pdfpc_window_presentation_type_id = g_type_register_static (PDFPC_WINDOW_TYPE_CONTROLLABLE_WINDOW, "pdfpcWindowPresentation", &g_define_type_info, 0);
	return pdfpc_window_presentation_type_id;
}

GType
pdfpc_window_presentation_get_type (void)
{
	static volatile gsize pdfpc_window_presentation_type_id__once = 0;
	if (g_once_init_enter (&pdfpc_window_presentation_type_id__once)) {
		GType pdfpc_window_presentation_type_id;
		pdfpc_window_presentation_type_id = pdfpc_window_presentation_get_type_once ();
		g_once_init_leave (&pdfpc_window_presentation_type_id__once, pdfpc_window_presentation_type_id);
	}
	return pdfpc_window_presentation_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

