// python wrapper for vtkSMWriterFactory
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMWriterFactory.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMWriterFactory(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMWriterFactory_ClassNew(); }

#ifndef DECLARED_PyvtkSMObject_ClassNew
extern "C" { PyObject *PyvtkSMObject_ClassNew(); }
#define DECLARED_PyvtkSMObject_ClassNew
#endif

static PyObject *
PyvtkSMWriterFactory_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMWriterFactory::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMWriterFactory_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMWriterFactory::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMWriterFactory_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMWriterFactory *tempr = vtkSMWriterFactory::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMWriterFactory_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMWriterFactory *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMWriterFactory::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMWriterFactory_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMWriterFactory::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMWriterFactory_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMWriterFactory::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMWriterFactory_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkSMWriterFactory::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMWriterFactory_RegisterPrototype(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RegisterPrototype");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->RegisterPrototype(temp0, temp1);
    }
    else
    {
      op->vtkSMWriterFactory::RegisterPrototype(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMWriterFactory_CanWrite(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CanWrite");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  unsigned int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->CanWrite(temp0, temp1) :
      op->vtkSMWriterFactory::CanWrite(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMWriterFactory_CreateWriter_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CreateWriter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  const char *temp0 = nullptr;
  vtkSMSourceProxy *temp1 = nullptr;
  unsigned int temp2;
  bool temp3 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMSourceProxy") &&
      ap.GetValue(temp2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->CreateWriter(temp0, temp1, temp2, temp3) :
      op->vtkSMWriterFactory::CreateWriter(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMWriterFactory_CreateWriter_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CreateWriter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  const char *temp0 = nullptr;
  vtkSMSourceProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMSourceProxy"))
  {
    vtkSMProxy *tempr = (ap.IsBound() ?
      op->CreateWriter(temp0, temp1) :
      op->vtkSMWriterFactory::CreateWriter(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMWriterFactory_CreateWriter(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
    case 4:
      return PyvtkSMWriterFactory_CreateWriter_s1(self, args);
    case 2:
      return PyvtkSMWriterFactory_CreateWriter_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "CreateWriter");
  return nullptr;
}


static PyObject *
PyvtkSMWriterFactory_GetSupportedFileTypes_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSupportedFileTypes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  unsigned int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetValue(temp1))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetSupportedFileTypes(temp0, temp1) :
      op->vtkSMWriterFactory::GetSupportedFileTypes(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMWriterFactory_GetSupportedFileTypes_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSupportedFileTypes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy"))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetSupportedFileTypes(temp0) :
      op->vtkSMWriterFactory::GetSupportedFileTypes(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMWriterFactory_GetSupportedFileTypes(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMWriterFactory_GetSupportedFileTypes_s1(self, args);
    case 1:
      return PyvtkSMWriterFactory_GetSupportedFileTypes_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetSupportedFileTypes");
  return nullptr;
}


static PyObject *
PyvtkSMWriterFactory_GetSupportedWriterProxies(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSupportedWriterProxies");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  unsigned int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetValue(temp1))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetSupportedWriterProxies(temp0, temp1) :
      op->vtkSMWriterFactory::GetSupportedWriterProxies(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMWriterFactory_GetNumberOfRegisteredPrototypes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfRegisteredPrototypes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfRegisteredPrototypes() :
      op->vtkSMWriterFactory::GetNumberOfRegisteredPrototypes());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMWriterFactory_UpdateAvailableWriters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateAvailableWriters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UpdateAvailableWriters();
    }
    else
    {
      op->vtkSMWriterFactory::UpdateAvailableWriters();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMWriterFactory_AddGroup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddGroup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AddGroup(temp0);
    }
    else
    {
      op->vtkSMWriterFactory::AddGroup(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMWriterFactory_RemoveGroup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveGroup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->RemoveGroup(temp0);
    }
    else
    {
      op->vtkSMWriterFactory::RemoveGroup(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMWriterFactory_GetGroups(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGroups");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMWriterFactory *op = static_cast<vtkSMWriterFactory *>(vp);

  vtkStringList *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkStringList"))
  {
    if (ap.IsBound())
    {
      op->GetGroups(temp0);
    }
    else
    {
      op->vtkSMWriterFactory::GetGroups(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMWriterFactory_AddWriterToWhitelist(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "AddWriterToWhitelist");

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkSMWriterFactory::AddWriterToWhitelist(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMWriterFactory_Methods[] = {
  {"IsTypeOf", PyvtkSMWriterFactory_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMWriterFactory_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMWriterFactory_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMWriterFactory\nC++: static vtkSMWriterFactory *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMWriterFactory_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMWriterFactory\nC++: vtkSMWriterFactory *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMWriterFactory_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMWriterFactory_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Initialize", PyvtkSMWriterFactory_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize()\n\nCleanup all registered prototypes.\n"},
  {"RegisterPrototype", PyvtkSMWriterFactory_RegisterPrototype, METH_VARARGS,
   "RegisterPrototype(self, xmlgroup:str, xmlname:str) -> None\nC++: void RegisterPrototype(const char *xmlgroup,\n    const char *xmlname)\n\nRegister a prototype.\n"},
  {"CanWrite", PyvtkSMWriterFactory_CanWrite, METH_VARARGS,
   "CanWrite(self, __a:vtkSMSourceProxy, outputport:int) -> bool\nC++: bool CanWrite(vtkSMSourceProxy *, unsigned int outputport)\n\nReturns true if the data from the output port can be written at\nall.\n"},
  {"CreateWriter", PyvtkSMWriterFactory_CreateWriter, METH_VARARGS,
   "CreateWriter(self, filename:str, __b:vtkSMSourceProxy,\n    outputport:int, proxyname:bool=False) -> vtkSMProxy\nC++: vtkSMProxy *CreateWriter(const char *filename,\n    vtkSMSourceProxy *, unsigned int outputport,\n    bool proxyname=false)\nCreateWriter(self, filename:str, pxy:vtkSMSourceProxy)\n    -> vtkSMProxy\nC++: vtkSMProxy *CreateWriter(const char *filename,\n    vtkSMSourceProxy *pxy)\n\nCreate a new writer proxy to write the data from the specified\noutput port to the file specified, if possible. As internally\nUpdatePipeline() will be called on the source proxy, in order to\nprevent a double pipeline execution when you want to write a\ngiven timestep, you should call updatePipeline( time ) before the\nCreateWriter call. The proxybyname flag tells the factory to use\nthe proxy name rather than a filename.extension to lookup the\nright proxy.\n"},
  {"GetSupportedFileTypes", PyvtkSMWriterFactory_GetSupportedFileTypes, METH_VARARGS,
   "GetSupportedFileTypes(self, source:vtkSMSourceProxy,\n    outputport:int) -> str\nC++: const char *GetSupportedFileTypes(vtkSMSourceProxy *source,\n    unsigned int outputport)\nGetSupportedFileTypes(self, source:vtkSMSourceProxy) -> str\nC++: const char *GetSupportedFileTypes(vtkSMSourceProxy *source)\n\nReturns a formatted string with all supported file types. An\nexample returned string would look like:\n \"PVD Files (*.pvd);;VTK Files (*.vtk)\"\n \n"},
  {"GetSupportedWriterProxies", PyvtkSMWriterFactory_GetSupportedWriterProxies, METH_VARARGS,
   "GetSupportedWriterProxies(self, source:vtkSMSourceProxy,\n    outputport:int) -> str\nC++: const char *GetSupportedWriterProxies(\n    vtkSMSourceProxy *source, unsigned int outputport)\n\nA variation on GetSupportedFileTypes that obtains a list of\nprototype proxy names.\n"},
  {"GetNumberOfRegisteredPrototypes", PyvtkSMWriterFactory_GetNumberOfRegisteredPrototypes, METH_VARARGS,
   "GetNumberOfRegisteredPrototypes(self) -> int\nC++: unsigned int GetNumberOfRegisteredPrototypes()\n\n"},
  {"UpdateAvailableWriters", PyvtkSMWriterFactory_UpdateAvailableWriters, METH_VARARGS,
   "UpdateAvailableWriters(self) -> None\nC++: void UpdateAvailableWriters()\n\nEvery time a new proxy definition is added we check to see if it\nis a writer and then we add it to the list of available writers.\n"},
  {"AddGroup", PyvtkSMWriterFactory_AddGroup, METH_VARARGS,
   "AddGroup(self, groupName:str) -> None\nC++: void AddGroup(const char *groupName)\n\nAdd/remove a group name to look for writers in. By default\n\"writers\" is included.\n"},
  {"RemoveGroup", PyvtkSMWriterFactory_RemoveGroup, METH_VARARGS,
   "RemoveGroup(self, groupName:str) -> None\nC++: void RemoveGroup(const char *groupName)\n\n"},
  {"GetGroups", PyvtkSMWriterFactory_GetGroups, METH_VARARGS,
   "GetGroups(self, groups:vtkStringList) -> None\nC++: void GetGroups(vtkStringList *groups)\n\n"},
  {"AddWriterToWhitelist", PyvtkSMWriterFactory_AddWriterToWhitelist, METH_VARARGS,
   "AddWriterToWhitelist(writerxmlgroup:str, writerxmlname:str)\n    -> None\nC++: static void AddWriterToWhitelist(const char *writerxmlgroup,\n    const char *writerxmlname)\n\nThis function is for ParaView based applications that only wish\nto expose a subset of the writers.  If this function is never\ncalled, the reader factory will expose all the writers as it has\nin the past.  However, if any writers are specified by passing\ntheir group name and reader name to this function, then only\nthose writers will be available in any reader factories created\nby the application.  This is intended to be called at the\nbeginning of the application's execution before any sessions are\ncreated.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMWriterFactory_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("number_of_registered_prototypes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMWriterFactory_GetNumberOfRegisteredPrototypes(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfRegisteredPrototypes\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMWriterFactory_Doc =
  "vtkSMWriterFactory - is a factory or creating a writer based on the\ndata type information from the output port.\n\n"
  "Superclass: vtkSMObject\n\n"
  "vtkSMWriterFactory is a factory for creating a writer to write the\n"
  "data provided at an output port. This is done whenever a new proxy\n"
  "definition is added in the writers group.\n\n"
  "Alternatively, one can register prototypes using RegisterPrototype\n"
  "API. The proxy definitions for the writer proxies must provide hints\n"
  "that indicate the file extension and description for the writer.\n\n"
  "Once the factory has been configured, the API to create writers, get\n"
  "available writers etc. can be used.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMWriterFactory_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMWriterFactory", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMWriterFactory_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMWriterFactory_StaticNew()
{
  return vtkSMWriterFactory::New();
}

PyObject *PyvtkSMWriterFactory_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMWriterFactory_Type, PyvtkSMWriterFactory_Methods,
    "vtkSMWriterFactory",
 &PyvtkSMWriterFactory_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMObject_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMWriterFactory_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMWriterFactory(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMWriterFactory_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMWriterFactory", o) != 0)
  {
    Py_DECREF(o);
  }

}

