// python wrapper for vtkSMRangedTransferFunctionDomain
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMRangedTransferFunctionDomain.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMRangedTransferFunctionDomain(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMRangedTransferFunctionDomain_ClassNew(); }


static PyObject *
PyvtkSMRangedTransferFunctionDomain_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMRangedTransferFunctionDomain::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRangedTransferFunctionDomain_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRangedTransferFunctionDomain *op = static_cast<vtkSMRangedTransferFunctionDomain *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMRangedTransferFunctionDomain::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRangedTransferFunctionDomain_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMRangedTransferFunctionDomain *tempr = vtkSMRangedTransferFunctionDomain::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRangedTransferFunctionDomain_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRangedTransferFunctionDomain *op = static_cast<vtkSMRangedTransferFunctionDomain *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMRangedTransferFunctionDomain *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMRangedTransferFunctionDomain::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRangedTransferFunctionDomain_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMRangedTransferFunctionDomain::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRangedTransferFunctionDomain_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRangedTransferFunctionDomain *op = static_cast<vtkSMRangedTransferFunctionDomain *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMRangedTransferFunctionDomain::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRangedTransferFunctionDomain_GetRangeMinimum_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRangeMinimum");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRangedTransferFunctionDomain *op = static_cast<vtkSMRangedTransferFunctionDomain *>(vp);

  unsigned int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    double tempr = (ap.IsBound() ?
      op->GetRangeMinimum(temp0, temp1) :
      op->vtkSMRangedTransferFunctionDomain::GetRangeMinimum(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(1, temp1);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMRangedTransferFunctionDomain_GetRangeMinimum_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRangeMinimum");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRangedTransferFunctionDomain *op = static_cast<vtkSMRangedTransferFunctionDomain *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    double tempr = (ap.IsBound() ?
      op->GetRangeMinimum(temp0) :
      op->vtkSMRangedTransferFunctionDomain::GetRangeMinimum(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMRangedTransferFunctionDomain_GetRangeMinimum(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMRangedTransferFunctionDomain_GetRangeMinimum_s1(self, args);
    case 1:
      return PyvtkSMRangedTransferFunctionDomain_GetRangeMinimum_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetRangeMinimum");
  return nullptr;
}


static PyObject *
PyvtkSMRangedTransferFunctionDomain_GetRangeMaximum_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRangeMaximum");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRangedTransferFunctionDomain *op = static_cast<vtkSMRangedTransferFunctionDomain *>(vp);

  unsigned int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    double tempr = (ap.IsBound() ?
      op->GetRangeMaximum(temp0, temp1) :
      op->vtkSMRangedTransferFunctionDomain::GetRangeMaximum(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(1, temp1);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMRangedTransferFunctionDomain_GetRangeMaximum_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRangeMaximum");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRangedTransferFunctionDomain *op = static_cast<vtkSMRangedTransferFunctionDomain *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    double tempr = (ap.IsBound() ?
      op->GetRangeMaximum(temp0) :
      op->vtkSMRangedTransferFunctionDomain::GetRangeMaximum(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMRangedTransferFunctionDomain_GetRangeMaximum(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMRangedTransferFunctionDomain_GetRangeMaximum_s1(self, args);
    case 1:
      return PyvtkSMRangedTransferFunctionDomain_GetRangeMaximum_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetRangeMaximum");
  return nullptr;
}


static PyObject *
PyvtkSMRangedTransferFunctionDomain_GetRangeMinimumExists(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRangeMinimumExists");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRangedTransferFunctionDomain *op = static_cast<vtkSMRangedTransferFunctionDomain *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRangeMinimumExists(temp0) :
      op->vtkSMRangedTransferFunctionDomain::GetRangeMinimumExists(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRangedTransferFunctionDomain_GetRangeMaximumExists(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRangeMaximumExists");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRangedTransferFunctionDomain *op = static_cast<vtkSMRangedTransferFunctionDomain *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRangeMaximumExists(temp0) :
      op->vtkSMRangedTransferFunctionDomain::GetRangeMaximumExists(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRangedTransferFunctionDomain_SetDefaultValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDefaultValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRangedTransferFunctionDomain *op = static_cast<vtkSMRangedTransferFunctionDomain *>(vp);

  vtkSMProperty *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProperty") &&
      ap.GetValue(temp1))
  {
    int tempr = (ap.IsBound() ?
      op->SetDefaultValues(temp0, temp1) :
      op->vtkSMRangedTransferFunctionDomain::SetDefaultValues(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMRangedTransferFunctionDomain_Methods[] = {
  {"IsTypeOf", PyvtkSMRangedTransferFunctionDomain_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMRangedTransferFunctionDomain_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMRangedTransferFunctionDomain_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMRangedTransferFunctionDomain\nC++: static vtkSMRangedTransferFunctionDomain *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMRangedTransferFunctionDomain_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMRangedTransferFunctionDomain\nC++: vtkSMRangedTransferFunctionDomain *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMRangedTransferFunctionDomain_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMRangedTransferFunctionDomain_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetRangeMinimum", PyvtkSMRangedTransferFunctionDomain_GetRangeMinimum, METH_VARARGS,
   "GetRangeMinimum(self, idx:int, exists:int) -> float\nC++: double GetRangeMinimum(unsigned int idx, int &exists)\nGetRangeMinimum(self, idx:int) -> float\nC++: double GetRangeMinimum(unsigned int idx)\n\nReturn a range min. value if it exists. If the min. exists exists\nis set to 1. Otherwise, it is set to 0. An unspecified min. is\nequivalent to -inf\n"},
  {"GetRangeMaximum", PyvtkSMRangedTransferFunctionDomain_GetRangeMaximum, METH_VARARGS,
   "GetRangeMaximum(self, idx:int, exists:int) -> float\nC++: double GetRangeMaximum(unsigned int idx, int &exists)\nGetRangeMaximum(self, idx:int) -> float\nC++: double GetRangeMaximum(unsigned int idx)\n\nReturn a range max. value if it exists. If the max. exists exists\nis set to 1. Otherwise, it is set to 0. An unspecified max. is\nequivalent to +inf\n"},
  {"GetRangeMinimumExists", PyvtkSMRangedTransferFunctionDomain_GetRangeMinimumExists, METH_VARARGS,
   "GetRangeMinimumExists(self, idx:int) -> bool\nC++: bool GetRangeMinimumExists(unsigned int idx)\n\nReturns if range minimum/maximum bound is set for the domain.\n"},
  {"GetRangeMaximumExists", PyvtkSMRangedTransferFunctionDomain_GetRangeMaximumExists, METH_VARARGS,
   "GetRangeMaximumExists(self, idx:int) -> bool\nC++: bool GetRangeMaximumExists(unsigned int idx)\n\n"},
  {"SetDefaultValues", PyvtkSMRangedTransferFunctionDomain_SetDefaultValues, METH_VARARGS,
   "SetDefaultValues(self, prop:vtkSMProperty,\n    use_unchecked_values:bool) -> int\nC++: int SetDefaultValues(vtkSMProperty *prop,\n    bool use_unchecked_values) override;\n\nIf prop is a vtkSMProxyProperty containing a\nvtkSMTransferFunctionProxy this set its range based on this\ndomain min and max values.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMRangedTransferFunctionDomain_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMRangedTransferFunctionDomain_Doc =
  "vtkSMRangedTransferFunctionDomain - represents a ranged\nvtkSMTransferFunctionProxy\n\n"
  "Superclass: vtkSMProxyListDomain\n\n"
  "This domain represent a single vtkSMTransferFunctionProxy with a\n"
  "range defined by a vtkSMArrayRangeDomain used internally.\n\n"
  "Example usage :{xml}\n"
  "      <RangedTransferFunctionDomain name=\"domain\">\n"
  "        \n"
  "          <Property function=\"Input\" name=\"Input\" />\n"
  "          <Property function=\"ArraySelection\" name=\"OpacityArray\" />\n"
  "          <Property function=\"ComponentSelection\"\n"
  "name=\"OpacityArrayComponent\" />\n"
  "        \n"
  "      \n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMRangedTransferFunctionDomain_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMRangedTransferFunctionDomain", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMRangedTransferFunctionDomain_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMRangedTransferFunctionDomain_StaticNew()
{
  return vtkSMRangedTransferFunctionDomain::New();
}

PyObject *PyvtkSMRangedTransferFunctionDomain_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMRangedTransferFunctionDomain_Type, PyvtkSMRangedTransferFunctionDomain_Methods,
    "vtkSMRangedTransferFunctionDomain",
 &PyvtkSMRangedTransferFunctionDomain_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSMProxyListDomain");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMRangedTransferFunctionDomain_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMRangedTransferFunctionDomain(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMRangedTransferFunctionDomain_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMRangedTransferFunctionDomain", o) != 0)
  {
    Py_DECREF(o);
  }

}

