// python wrapper for vtkMaterialInterfaceIdListItem
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkMaterialInterfaceIdListItem.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkMaterialInterfaceIdListItem(PyObject *dict); }

static PyObject *
PyvtkMaterialInterfaceIdListItem_Clear(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Clear");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceIdListItem *op = static_cast<vtkMaterialInterfaceIdListItem *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    op->Clear();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceIdListItem_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceIdListItem *op = static_cast<vtkMaterialInterfaceIdListItem *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    op->Initialize(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceIdListItem_GetLocalId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLocalId");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceIdListItem *op = static_cast<vtkMaterialInterfaceIdListItem *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = op->GetLocalId();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceIdListItem_GetGlobalId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGlobalId");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfaceIdListItem *op = static_cast<vtkMaterialInterfaceIdListItem *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = op->GetGlobalId();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkMaterialInterfaceIdListItem_Methods[] = {
  {"Clear", PyvtkMaterialInterfaceIdListItem_Clear, METH_VARARGS,
   "Clear(self) -> None\nC++: void Clear()\n\n"},
  {"Initialize", PyvtkMaterialInterfaceIdListItem_Initialize, METH_VARARGS,
   "Initialize(self, localId:int, globalId:int) -> None\nC++: void Initialize(int localId, int globalId)\n\n"},
  {"GetLocalId", PyvtkMaterialInterfaceIdListItem_GetLocalId, METH_VARARGS,
   "GetLocalId(self) -> int\nC++: int GetLocalId()\n\n"},
  {"GetGlobalId", PyvtkMaterialInterfaceIdListItem_GetGlobalId, METH_VARARGS,
   "GetGlobalId(self) -> int\nC++: int GetGlobalId()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkMaterialInterfaceIdListItem_GetSets[] = {
  {
    /*name=*/pystr("local_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceIdListItem_GetLocalId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLocalId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("global_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceIdListItem_GetGlobalId(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetGlobalId\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkMaterialInterfaceIdListItem_vtkMaterialInterfaceIdListItem_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkMaterialInterfaceIdListItem");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkMaterialInterfaceIdListItem *op = new vtkMaterialInterfaceIdListItem();

    result = PyVTKSpecialObject_New("vtkMaterialInterfaceIdListItem", op);
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceIdListItem_vtkMaterialInterfaceIdListItem_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkMaterialInterfaceIdListItem");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkMaterialInterfaceIdListItem *op = new vtkMaterialInterfaceIdListItem(temp0);

    result = PyVTKSpecialObject_New("vtkMaterialInterfaceIdListItem", op);
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceIdListItem_vtkMaterialInterfaceIdListItem_s3(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkMaterialInterfaceIdListItem");

  vtkMaterialInterfaceIdListItem *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkMaterialInterfaceIdListItem"))
  {
    vtkMaterialInterfaceIdListItem *op = new vtkMaterialInterfaceIdListItem(*temp0);

    result = PyVTKSpecialObject_New("vtkMaterialInterfaceIdListItem", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkMaterialInterfaceIdListItem_vtkMaterialInterfaceIdListItem_Methods[] = {
  {"vtkMaterialInterfaceIdListItem", PyvtkMaterialInterfaceIdListItem_vtkMaterialInterfaceIdListItem_s2, METH_VARARGS,
   "@i"},
  {"vtkMaterialInterfaceIdListItem", PyvtkMaterialInterfaceIdListItem_vtkMaterialInterfaceIdListItem_s3, METH_VARARGS,
   "@W vtkMaterialInterfaceIdListItem"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkMaterialInterfaceIdListItem_vtkMaterialInterfaceIdListItem(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkMaterialInterfaceIdListItem_vtkMaterialInterfaceIdListItem_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkMaterialInterfaceIdListItem_vtkMaterialInterfaceIdListItem_s1(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkMaterialInterfaceIdListItem");
  return nullptr;
}


static const char *PyvtkMaterialInterfaceIdListItem_Doc =

  "vtkMaterialInterfaceIdListItem() -> vtkMaterialInterfaceIdListItem\nC++: vtkMaterialInterfaceIdListItem()\nvtkMaterialInterfaceIdListItem(globalId:int)\n    -> vtkMaterialInterfaceIdListItem\nC++: vtkMaterialInterfaceIdListItem(int globalId)\nvtkMaterialInterfaceIdListItem(other:vtkMaterialInterfaceIdListItem)\n    -> vtkMaterialInterfaceIdListItem\nC++: vtkMaterialInterfaceIdListItem(\n    const vtkMaterialInterfaceIdListItem &other)\n""\n"
  "vtkMaterialInterfaceIdListItem - Elemental data type for fragment id\nlist containers.\n\n"
;

static PyObject *
PyvtkMaterialInterfaceIdListItem_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkMaterialInterfaceIdListItem_vtkMaterialInterfaceIdListItem(nullptr, args);
}

static void PyvtkMaterialInterfaceIdListItem_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkMaterialInterfaceIdListItem *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static int PyvtkMaterialInterfaceIdListItem_CheckExact(PyObject *ob);

static PyObject *PyvtkMaterialInterfaceIdListItem_RichCompare(
  PyObject *o1, PyObject *o2, int opid)
{
  PyObject *n1 = nullptr;
  PyObject *n2 = nullptr;
  const vtkMaterialInterfaceIdListItem *so1 = nullptr;
  const vtkMaterialInterfaceIdListItem *so2 = nullptr;
  int result = -1;

  if (PyvtkMaterialInterfaceIdListItem_CheckExact(o1))
  {
    PyVTKSpecialObject *s1 = (PyVTKSpecialObject *)o1;
    so1 = static_cast<const vtkMaterialInterfaceIdListItem *>(s1->vtk_ptr);
  }
  else
  {
    so1 = static_cast<const vtkMaterialInterfaceIdListItem *>(
      vtkPythonUtil::GetPointerFromSpecialObject(
        o1, "vtkMaterialInterfaceIdListItem", &n1));
    if (so1 == nullptr)
    {
      PyErr_Clear();
      Py_INCREF(Py_NotImplemented);
      return Py_NotImplemented;
    }
  }

  if (PyvtkMaterialInterfaceIdListItem_CheckExact(o2))
  {
    PyVTKSpecialObject *s2 = (PyVTKSpecialObject *)o2;
    so2 = static_cast<const vtkMaterialInterfaceIdListItem *>(s2->vtk_ptr);
  }
  else
  {
    so2 = static_cast<const vtkMaterialInterfaceIdListItem *>(
      vtkPythonUtil::GetPointerFromSpecialObject(
        o2, "vtkMaterialInterfaceIdListItem", &n2));
    if (so2 == nullptr)
    {
      PyErr_Clear();
      Py_INCREF(Py_NotImplemented);
      return Py_NotImplemented;
    }
  }

  switch (opid)
  {
    case Py_LT:
      result = ((*so1) < (*so2));
      break;
    case Py_LE:
      result = ((*so1) <= (*so2));
      break;
    case Py_EQ:
      result = ((*so1) == (*so2));
      break;
    case Py_NE:
      break;
    case Py_GT:
      result = ((*so1) > (*so2));
      break;
    case Py_GE:
      result = ((*so1) >= (*so2));
      break;
  }

  if (n1)
  {
    Py_DECREF(n1);
  }
  else if (n2)
  {
    Py_DECREF(n2);
  }

  if (result == -1)
  {
    PyErr_SetString(PyExc_TypeError, "operation not available");
    return nullptr;
  }

  // avoids aliasing issues with Py_INCREF(Py_False)
  return PyBool_FromLong((long)result);
}

static Py_hash_t PyvtkMaterialInterfaceIdListItem_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkMaterialInterfaceIdListItem_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersMaterialInterface.vtkMaterialInterfaceIdListItem", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkMaterialInterfaceIdListItem_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkMaterialInterfaceIdListItem_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkMaterialInterfaceIdListItem_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  PyvtkMaterialInterfaceIdListItem_RichCompare, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkMaterialInterfaceIdListItem_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static int PyvtkMaterialInterfaceIdListItem_CheckExact(PyObject *ob)
{
  return (Py_TYPE(ob) == &PyvtkMaterialInterfaceIdListItem_Type);
}

static void *PyvtkMaterialInterfaceIdListItem_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkMaterialInterfaceIdListItem(*static_cast<const vtkMaterialInterfaceIdListItem*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkMaterialInterfaceIdListItem_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkMaterialInterfaceIdListItem_TypeNew(); }
#define DECLARED_PyvtkMaterialInterfaceIdListItem_TypeNew
#endif

PyObject *PyvtkMaterialInterfaceIdListItem_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkMaterialInterfaceIdListItem_Type,
    PyvtkMaterialInterfaceIdListItem_Methods,
    PyvtkMaterialInterfaceIdListItem_GetSets,
    PyvtkMaterialInterfaceIdListItem_vtkMaterialInterfaceIdListItem_Methods,
    &PyvtkMaterialInterfaceIdListItem_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 3; c++)
  {
    static const struct { const char *name; int value; }
      constants[3] = {
        { "LOCAL_ID", vtkMaterialInterfaceIdListItem::LOCAL_ID },
        { "GLOBAL_ID", vtkMaterialInterfaceIdListItem::GLOBAL_ID },
        { "SIZE", vtkMaterialInterfaceIdListItem::SIZE },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkMaterialInterfaceIdListItem(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkMaterialInterfaceIdListItem_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkMaterialInterfaceIdListItem", o) != 0)
  {
    Py_DECREF(o);
  }

}

