// python wrapper for vtkCPInputDataDescription
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkCPInputDataDescription.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkCPInputDataDescription(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkCPInputDataDescription_ClassNew(); }


static PyObject *
PyvtkCPInputDataDescription_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkCPInputDataDescription::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkCPInputDataDescription::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkCPInputDataDescription *tempr = vtkCPInputDataDescription::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCPInputDataDescription *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkCPInputDataDescription::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkCPInputDataDescription::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkCPInputDataDescription::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_Reset(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Reset");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Reset();
    }
    else
    {
      op->vtkCPInputDataDescription::Reset();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_AddField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->AddField(temp0, temp1);
    }
    else
    {
      op->vtkCPInputDataDescription::AddField(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_GetNumberOfFields(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfFields");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfFields() :
      op->vtkCPInputDataDescription::GetNumberOfFields());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_GetFieldName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetFieldName(temp0) :
      op->vtkCPInputDataDescription::GetFieldName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_GetFieldType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFieldType(temp0) :
      op->vtkCPInputDataDescription::GetFieldType(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_IsFieldNeeded(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsFieldNeeded");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->IsFieldNeeded(temp0, temp1) :
      op->vtkCPInputDataDescription::IsFieldNeeded(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_SetAllFields(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAllFields");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAllFields(temp0);
    }
    else
    {
      op->vtkCPInputDataDescription::SetAllFields(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_GetAllFields(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAllFields");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAllFields() :
      op->vtkCPInputDataDescription::GetAllFields());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_AllFieldsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AllFieldsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AllFieldsOn();
    }
    else
    {
      op->vtkCPInputDataDescription::AllFieldsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_AllFieldsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AllFieldsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AllFieldsOff();
    }
    else
    {
      op->vtkCPInputDataDescription::AllFieldsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_SetGenerateMesh(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateMesh");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateMesh(temp0);
    }
    else
    {
      op->vtkCPInputDataDescription::SetGenerateMesh(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_GetGenerateMesh(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateMesh");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGenerateMesh() :
      op->vtkCPInputDataDescription::GetGenerateMesh());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_GenerateMeshOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateMeshOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateMeshOn();
    }
    else
    {
      op->vtkCPInputDataDescription::GenerateMeshOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_GenerateMeshOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateMeshOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateMeshOff();
    }
    else
    {
      op->vtkCPInputDataDescription::GenerateMeshOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_SetGrid(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGrid");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  vtkDataObject *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkDataObject"))
  {
    if (ap.IsBound())
    {
      op->SetGrid(temp0);
    }
    else
    {
      op->vtkCPInputDataDescription::SetGrid(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_GetGrid(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGrid");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataObject *tempr = (ap.IsBound() ?
      op->GetGrid() :
      op->vtkCPInputDataDescription::GetGrid());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_GetIfGridIsNecessary(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIfGridIsNecessary");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIfGridIsNecessary() :
      op->vtkCPInputDataDescription::GetIfGridIsNecessary());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_SetWholeExtent_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWholeExtent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  int temp4;
  int temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->SetWholeExtent(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkCPInputDataDescription::SetWholeExtent(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkCPInputDataDescription_SetWholeExtent_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWholeExtent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  const size_t size0 = 6;
  int temp0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetWholeExtent(temp0);
    }
    else
    {
      op->vtkCPInputDataDescription::SetWholeExtent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkCPInputDataDescription_SetWholeExtent(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 6:
      return PyvtkCPInputDataDescription_SetWholeExtent_s1(self, args);
    case 1:
      return PyvtkCPInputDataDescription_SetWholeExtent_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetWholeExtent");
  return nullptr;
}


static PyObject *
PyvtkCPInputDataDescription_GetWholeExtent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWholeExtent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetWholeExtent() :
      op->vtkCPInputDataDescription::GetWholeExtent());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_ShallowCopy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShallowCopy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  vtkCPInputDataDescription *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCPInputDataDescription"))
  {
    if (ap.IsBound())
    {
      op->ShallowCopy(temp0);
    }
    else
    {
      op->vtkCPInputDataDescription::ShallowCopy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_SetTemporalCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTemporalCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy"))
  {
    if (ap.IsBound())
    {
      op->SetTemporalCache(temp0);
    }
    else
    {
      op->vtkCPInputDataDescription::SetTemporalCache(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPInputDataDescription_GetTemporalCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTemporalCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPInputDataDescription *op = static_cast<vtkCPInputDataDescription *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMSourceProxy *tempr = (ap.IsBound() ?
      op->GetTemporalCache() :
      op->vtkCPInputDataDescription::GetTemporalCache());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkCPInputDataDescription_Methods[] = {
  {"IsTypeOf", PyvtkCPInputDataDescription_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkCPInputDataDescription_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkCPInputDataDescription_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkCPInputDataDescription\nC++: static vtkCPInputDataDescription *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkCPInputDataDescription_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkCPInputDataDescription\nC++: vtkCPInputDataDescription *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkCPInputDataDescription_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkCPInputDataDescription_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Reset", PyvtkCPInputDataDescription_Reset, METH_VARARGS,
   "Reset(self) -> None\nC++: void Reset()\n\nReset the names of the fields that are needed.\n"},
  {"AddField", PyvtkCPInputDataDescription_AddField, METH_VARARGS,
   "AddField(self, fieldName:str, type:int) -> None\nC++: void AddField(const char *fieldName, int type)\n\nAdd in a name of an array with name *fieldName* of type *type*\nwhere the values comes from vtkDataObject::AttributeTypes.\n"},
  {"GetNumberOfFields", PyvtkCPInputDataDescription_GetNumberOfFields, METH_VARARGS,
   "GetNumberOfFields(self) -> int\nC++: unsigned int GetNumberOfFields()\n\nGet the number of fields currently specified in this object.\n"},
  {"GetFieldName", PyvtkCPInputDataDescription_GetFieldName, METH_VARARGS,
   "GetFieldName(self, fieldIndex:int) -> str\nC++: const char *GetFieldName(unsigned int fieldIndex)\n\nGet the name of the field given its current index.\n"},
  {"GetFieldType", PyvtkCPInputDataDescription_GetFieldType, METH_VARARGS,
   "GetFieldType(self, fieldIndex:int) -> int\nC++: int GetFieldType(unsigned int fieldIndex)\n\nGet the type of field given its current index. The types are\ndefined in vtkDataObject::AttributeTypes. A return value of -1\nindicates an invalid fieldIndex.\n"},
  {"IsFieldNeeded", PyvtkCPInputDataDescription_IsFieldNeeded, METH_VARARGS,
   "IsFieldNeeded(self, fieldName:str, type:int) -> bool\nC++: bool IsFieldNeeded(const char *fieldName, int type)\n\nReturn true if a field with fieldName is needed.\n"},
  {"SetAllFields", PyvtkCPInputDataDescription_SetAllFields, METH_VARARGS,
   "SetAllFields(self, _arg:bool) -> None\nC++: virtual void SetAllFields(bool _arg)\n\nWhen set to true, all fields are requested. Off by default. Note\nthat calling Reset() resets this flag to Off as well.\n"},
  {"GetAllFields", PyvtkCPInputDataDescription_GetAllFields, METH_VARARGS,
   "GetAllFields(self) -> bool\nC++: virtual bool GetAllFields()\n\nWhen set to true, all fields are requested. Off by default. Note\nthat calling Reset() resets this flag to Off as well.\n"},
  {"AllFieldsOn", PyvtkCPInputDataDescription_AllFieldsOn, METH_VARARGS,
   "AllFieldsOn(self) -> None\nC++: virtual void AllFieldsOn()\n\nWhen set to true, all fields are requested. Off by default. Note\nthat calling Reset() resets this flag to Off as well.\n"},
  {"AllFieldsOff", PyvtkCPInputDataDescription_AllFieldsOff, METH_VARARGS,
   "AllFieldsOff(self) -> None\nC++: virtual void AllFieldsOff()\n\nWhen set to true, all fields are requested. Off by default. Note\nthat calling Reset() resets this flag to Off as well.\n"},
  {"SetGenerateMesh", PyvtkCPInputDataDescription_SetGenerateMesh, METH_VARARGS,
   "SetGenerateMesh(self, _arg:bool) -> None\nC++: virtual void SetGenerateMesh(bool _arg)\n\nUse this to enable the mesh. Off by default. Note that calling\nReset() resets this flag to Off as well.\n"},
  {"GetGenerateMesh", PyvtkCPInputDataDescription_GetGenerateMesh, METH_VARARGS,
   "GetGenerateMesh(self) -> bool\nC++: virtual bool GetGenerateMesh()\n\nUse this to enable the mesh. Off by default. Note that calling\nReset() resets this flag to Off as well.\n"},
  {"GenerateMeshOn", PyvtkCPInputDataDescription_GenerateMeshOn, METH_VARARGS,
   "GenerateMeshOn(self) -> None\nC++: virtual void GenerateMeshOn()\n\nUse this to enable the mesh. Off by default. Note that calling\nReset() resets this flag to Off as well.\n"},
  {"GenerateMeshOff", PyvtkCPInputDataDescription_GenerateMeshOff, METH_VARARGS,
   "GenerateMeshOff(self) -> None\nC++: virtual void GenerateMeshOff()\n\nUse this to enable the mesh. Off by default. Note that calling\nReset() resets this flag to Off as well.\n"},
  {"SetGrid", PyvtkCPInputDataDescription_SetGrid, METH_VARARGS,
   "SetGrid(self, grid:vtkDataObject) -> None\nC++: void SetGrid(vtkDataObject *grid)\n\nSet the grid input for coprocessing.  The grid should have all of\nthe point data and cell data properly set.\n"},
  {"GetGrid", PyvtkCPInputDataDescription_GetGrid, METH_VARARGS,
   "GetGrid(self) -> vtkDataObject\nC++: virtual vtkDataObject *GetGrid()\n\nGet the grid for coprocessing.\n"},
  {"GetIfGridIsNecessary", PyvtkCPInputDataDescription_GetIfGridIsNecessary, METH_VARARGS,
   "GetIfGridIsNecessary(self) -> bool\nC++: bool GetIfGridIsNecessary()\n\nReturns true if the grid is necessary..\n"},
  {"SetWholeExtent", PyvtkCPInputDataDescription_SetWholeExtent, METH_VARARGS,
   "SetWholeExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int,\n    _arg5:int, _arg6:int) -> None\nC++: virtual void SetWholeExtent(int _arg1, int _arg2, int _arg3,\n    int _arg4, int _arg5, int _arg6)\nSetWholeExtent(self, _arg:(int, int, int, int, int, int)) -> None\nC++: virtual void SetWholeExtent(const int _arg[6])\n\nSet/get the extents for a partitioned topologically regular grid\n(i.e. vtkUniformGrid, vtkImageData, vtkRectilinearGrid, and\nvtkStructuredGrid).\n"},
  {"GetWholeExtent", PyvtkCPInputDataDescription_GetWholeExtent, METH_VARARGS,
   "GetWholeExtent(self) -> (int, int, int, int, int, int)\nC++: virtual int *GetWholeExtent()\n\nSet/get the extents for a partitioned topologically regular grid\n(i.e. vtkUniformGrid, vtkImageData, vtkRectilinearGrid, and\nvtkStructuredGrid).\n"},
  {"ShallowCopy", PyvtkCPInputDataDescription_ShallowCopy, METH_VARARGS,
   "ShallowCopy(self, __a:vtkCPInputDataDescription) -> None\nC++: void ShallowCopy(vtkCPInputDataDescription *)\n\nShallow copy.\n"},
  {"SetTemporalCache", PyvtkCPInputDataDescription_SetTemporalCache, METH_VARARGS,
   "SetTemporalCache(self, cache:vtkSMSourceProxy) -> None\nC++: void SetTemporalCache(vtkSMSourceProxy *cache)\n\nSet the temporal cache. Adaptors can get a cache from the\ncoprocessor object and apply them to the InputDataDescription\nwhen they want to use temporal filters in their pipelines.\n"},
  {"GetTemporalCache", PyvtkCPInputDataDescription_GetTemporalCache, METH_VARARGS,
   "GetTemporalCache(self) -> vtkSMSourceProxy\nC++: virtual vtkSMSourceProxy *GetTemporalCache()\n\nGet the temporal cache.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkCPInputDataDescription_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("all_fields"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPInputDataDescription_GetAllFields(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCPInputDataDescription_SetAllFields(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCPInputDataDescription_SetAllFields(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAllFields/SetAllFields\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_mesh"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPInputDataDescription_GetGenerateMesh(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCPInputDataDescription_SetGenerateMesh(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCPInputDataDescription_SetGenerateMesh(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateMesh/SetGenerateMesh\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("grid"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPInputDataDescription_GetGrid(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCPInputDataDescription_SetGrid(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCPInputDataDescription_SetGrid(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGrid/SetGrid\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("whole_extent"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPInputDataDescription_GetWholeExtent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCPInputDataDescription_SetWholeExtent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCPInputDataDescription_SetWholeExtent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWholeExtent/SetWholeExtent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("temporal_cache"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPInputDataDescription_GetTemporalCache(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCPInputDataDescription_SetTemporalCache(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCPInputDataDescription_SetTemporalCache(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTemporalCache/SetTemporalCache\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("if_grid_is_necessary"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPInputDataDescription_GetIfGridIsNecessary(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIfGridIsNecessary\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_fields"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPInputDataDescription_GetNumberOfFields(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfFields\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkCPInputDataDescription_Doc =
  "vtkCPInputDataDescription - @ingroup CoProcessing\n\n"
  "Superclass: vtkObject\n\n"
  "This class provides the data description for each input for the\n"
  "coprocessor pipelines.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkCPInputDataDescription_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVCatalyst.vtkCPInputDataDescription", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkCPInputDataDescription_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkCPInputDataDescription_StaticNew()
{
  return vtkCPInputDataDescription::New();
}

PyObject *PyvtkCPInputDataDescription_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkCPInputDataDescription_Type, PyvtkCPInputDataDescription_Methods,
    "vtkCPInputDataDescription",
 &PyvtkCPInputDataDescription_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkCPInputDataDescription_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkCPInputDataDescription(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkCPInputDataDescription_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkCPInputDataDescription", o) != 0)
  {
    Py_DECREF(o);
  }

}

