#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkImageButterworthHighPass_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageButterworthLowPass_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageFFT_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageFourierCenter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageFourierFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageIdealHighPass_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageIdealLowPass_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageRFFT_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkImagingFourierCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkImageButterworthHighPass_Init(csi);
  vtkImageButterworthLowPass_Init(csi);
  vtkImageFFT_Init(csi);
  vtkImageFourierCenter_Init(csi);
  vtkImageFourierFilter_Init(csi);
  vtkImageIdealHighPass_Init(csi);
  vtkImageIdealLowPass_Init(csi);
  vtkImageRFFT_Init(csi);
}
