// Copyright (c) Lawrence Livermore National Security, LLC and other Conduit
// Project developers. See top-level LICENSE AND COPYRIGHT files for dates and
// other details. No copyright assignment is required to contribute to Conduit.

//-----------------------------------------------------------------------------
///
/// file: conduit_log.hpp
///
//-----------------------------------------------------------------------------

#ifndef CONDUIT_LOG_HPP
#define CONDUIT_LOG_HPP

//-----------------------------------------------------------------------------
// conduit lib includes
//-----------------------------------------------------------------------------
#include "conduit.hpp"

//-----------------------------------------------------------------------------
// -- begin conduit:: --
//-----------------------------------------------------------------------------
namespace conduit
{

//-----------------------------------------------------------------------------
// -- begin conduit::utils --
//-----------------------------------------------------------------------------
namespace utils
{

//-----------------------------------------------------------------------------
// -- begin conduit::utils::log --
//-----------------------------------------------------------------------------
namespace log
{

//-----------------------------------------------------------------------------
void CONDUIT_API info(conduit::Node &info,
                      const std::string &proto_name,
                      const std::string &msg);

//-----------------------------------------------------------------------------
void CONDUIT_API optional(conduit::Node &info,
                          const std::string &proto_name,
                          const std::string &msg);

//-----------------------------------------------------------------------------
void CONDUIT_API error(conduit::Node &info,
                       const std::string &proto_name,
                       const std::string &msg);

//-----------------------------------------------------------------------------
void CONDUIT_API validation(conduit::Node &info,
                            bool res);


//-----------------------------------------------------------------------------
void CONDUIT_API remove_valid(conduit::Node &info);
//-----------------------------------------------------------------------------
void CONDUIT_API remove_invalid(conduit::Node &info);

//-----------------------------------------------------------------------------
void CONDUIT_API remove_optional(conduit::Node &info);

//-----------------------------------------------------------------------------
std::string CONDUIT_API quote(const std::string &str,
                              bool pad_before = false);

}
//-----------------------------------------------------------------------------
// -- end conduit::utils::log --
//-----------------------------------------------------------------------------

}
//-----------------------------------------------------------------------------
// -- end conduit::utils --
//-----------------------------------------------------------------------------

}
//-----------------------------------------------------------------------------
// -- end conduit:: --
//-----------------------------------------------------------------------------

#endif 
