/* SourceRow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SourceRow.vala, do not modify */

/*
 * Copyright 2019-2023 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <libedataserver/libedataserver.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <granite-7.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TASKS_WIDGETS_TYPE_SOURCE_ROW (tasks_widgets_source_row_get_type ())
#define TASKS_WIDGETS_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow))
#define TASKS_WIDGETS_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRowClass))
#define TASKS_WIDGETS_IS_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_WIDGETS_TYPE_SOURCE_ROW))
#define TASKS_WIDGETS_IS_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_WIDGETS_TYPE_SOURCE_ROW))
#define TASKS_WIDGETS_SOURCE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRowClass))

typedef struct _TasksWidgetsSourceRow TasksWidgetsSourceRow;
typedef struct _TasksWidgetsSourceRowClass TasksWidgetsSourceRowClass;
typedef struct _TasksWidgetsSourceRowPrivate TasksWidgetsSourceRowPrivate;
enum  {
	TASKS_WIDGETS_SOURCE_ROW_0_PROPERTY,
	TASKS_WIDGETS_SOURCE_ROW_SOURCE_PROPERTY,
	TASKS_WIDGETS_SOURCE_ROW_NUM_PROPERTIES
};
static GParamSpec* tasks_widgets_source_row_properties[TASKS_WIDGETS_SOURCE_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TASKS_TYPE_TASK_MODEL (tasks_task_model_get_type ())
#define TASKS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModel))
#define TASKS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))
#define TASKS_IS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_TASK_MODEL))
#define TASKS_IS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_TASK_MODEL))
#define TASKS_TASK_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))

typedef struct _TasksTaskModel TasksTaskModel;
typedef struct _TasksTaskModelClass TasksTaskModelClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TasksWidgetsSourceRowOnDragDropMoveTasksData TasksWidgetsSourceRowOnDragDropMoveTasksData;
typedef struct _Block36Data Block36Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _TasksWidgetsSourceRow {
	GtkListBoxRow parent_instance;
	TasksWidgetsSourceRowPrivate * priv;
};

struct _TasksWidgetsSourceRowClass {
	GtkListBoxRowClass parent_class;
};

struct _TasksWidgetsSourceRowPrivate {
	ESource* _source;
	GtkGrid* source_color;
	GtkImage* status_image;
	GtkLabel* display_name_label;
	GtkStack* status_stack;
	GtkRevealer* revealer;
	GeeHashMultiMap* received_drag_data;
};

struct _TasksWidgetsSourceRowOnDragDropMoveTasksData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TasksWidgetsSourceRow* self;
	ESourceRegistry* registry;
	TasksTaskModel* _tmp0_;
	ESourceRegistry* _tmp1_;
	GeeSet* source_uids;
	GeeHashMultiMap* _tmp2_;
	GeeSet* _tmp3_;
	GeeIterator* _source_uid_it;
	GeeSet* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	gchar* source_uid;
	GeeIterator* _tmp7_;
	gpointer _tmp8_;
	ESource* src_source;
	ESourceRegistry* _tmp9_;
	const gchar* _tmp10_;
	ESource* _tmp11_;
	GeeCollection* component_uids;
	GeeHashMultiMap* _tmp12_;
	const gchar* _tmp13_;
	GeeCollection* _tmp14_;
	GeeIterator* _component_uid_it;
	GeeCollection* _tmp15_;
	GeeIterator* _tmp16_;
	GeeIterator* _tmp17_;
	gchar* component_uid;
	GeeIterator* _tmp18_;
	gpointer _tmp19_;
	gboolean _tmp20_;
	TasksTaskModel* _tmp21_;
	ESource* _tmp22_;
	ESource* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	ESource* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GError* _inner_error0_;
};

struct _Block36Data {
	int _ref_count_;
	TasksWidgetsSourceRow* self;
	GraniteMessageDialog* error_dialog;
};

static gint TasksWidgetsSourceRow_private_offset;
static gpointer tasks_widgets_source_row_parent_class = NULL;
VALA_EXTERN TasksTaskModel* tasks_application_model;

VALA_EXTERN GType tasks_widgets_source_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksWidgetsSourceRow, g_object_unref)
VALA_EXTERN TasksWidgetsSourceRow* tasks_widgets_source_row_new (ESource* source);
VALA_EXTERN TasksWidgetsSourceRow* tasks_widgets_source_row_construct (GType object_type,
                                                           ESource* source);
static void tasks_widgets_source_row_build_drag_and_drop (TasksWidgetsSourceRow* self);
static gboolean tasks_widgets_source_row_on_drop_accept (TasksWidgetsSourceRow* self,
                                                  GdkDrop* drop);
static gboolean _tasks_widgets_source_row_on_drop_accept_gtk_drop_target_accept (GtkDropTarget* _sender,
                                                                          GdkDrop* drop,
                                                                          gpointer self);
static gboolean tasks_widgets_source_row_on_drag_drop (TasksWidgetsSourceRow* self,
                                                GValue* value,
                                                gdouble x,
                                                gdouble y);
static gboolean _tasks_widgets_source_row_on_drag_drop_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                                      GValue* value,
                                                                      gdouble x,
                                                                      gdouble y,
                                                                      gpointer self);
static GdkDragAction tasks_widgets_source_row_on_drag_enter (TasksWidgetsSourceRow* self,
                                                      gdouble x,
                                                      gdouble y);
static GdkDragAction _tasks_widgets_source_row_on_drag_enter_gtk_drop_target_enter (GtkDropTarget* _sender,
                                                                             gdouble x,
                                                                             gdouble y,
                                                                             gpointer self);
static void tasks_widgets_source_row_on_drag_leave (TasksWidgetsSourceRow* self);
static void _tasks_widgets_source_row_on_drag_leave_gtk_drop_target_leave (GtkDropTarget* _sender,
                                                                    gpointer self);
static void tasks_widgets_source_row_on_drag_drop_move_tasks_data_free (gpointer _data);
static void tasks_widgets_source_row_on_drag_drop_move_tasks (TasksWidgetsSourceRow* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void tasks_widgets_source_row_on_drag_drop_move_tasks_finish (TasksWidgetsSourceRow* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
static gboolean tasks_widgets_source_row_on_drag_drop_move_tasks_co (TasksWidgetsSourceRowOnDragDropMoveTasksData* _data_);
VALA_EXTERN GType tasks_task_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksTaskModel, g_object_unref)
VALA_EXTERN void tasks_task_model_get_registry (TasksTaskModel* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN ESourceRegistry* tasks_task_model_get_registry_finish (TasksTaskModel* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void tasks_widgets_source_row_on_drag_drop_move_tasks_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
VALA_EXTERN void tasks_task_model_move_task (TasksTaskModel* self,
                                 ESource* source_list,
                                 ESource* destination_list,
                                 const gchar* task_uid,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN gboolean tasks_task_model_move_task_finish (TasksTaskModel* self,
                                            GAsyncResult* _res_,
                                            GError** error);
VALA_EXTERN ESource* tasks_widgets_source_row_get_source (TasksWidgetsSourceRow* self);
static void tasks_widgets_source_row_parse_data (TasksWidgetsSourceRow* self,
                                          const gchar* uri);
static void ___lambda26_ (TasksWidgetsSourceRow* self,
                   GObject* obj,
                   GAsyncResult* res);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
static void ___lambda27_ (Block36Data* _data36_);
static void ____lambda27__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void ____lambda26__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
VALA_EXTERN void tasks_widgets_source_row_update_request (TasksWidgetsSourceRow* self);
VALA_EXTERN void tasks_application_set_task_color (ESource* source,
                                       GtkWidget* widget);
VALA_EXTERN void tasks_widgets_source_row_remove_request (TasksWidgetsSourceRow* self);
static gboolean __lambda28_ (TasksWidgetsSourceRow* self);
static gboolean ___lambda28__gsource_func (gpointer self);
static void tasks_widgets_source_row_set_source (TasksWidgetsSourceRow* self,
                                          ESource* value);
static GObject * tasks_widgets_source_row_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void tasks_widgets_source_row_finalize (GObject * obj);
static GType tasks_widgets_source_row_get_type_once (void);
static void _vala_tasks_widgets_source_row_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_tasks_widgets_source_row_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
tasks_widgets_source_row_get_instance_private (TasksWidgetsSourceRow* self)
{
	return G_STRUCT_MEMBER_P (self, TasksWidgetsSourceRow_private_offset);
}

TasksWidgetsSourceRow*
tasks_widgets_source_row_construct (GType object_type,
                                    ESource* source)
{
	TasksWidgetsSourceRow * self = NULL;
	g_return_val_if_fail (source != NULL, NULL);
	self = (TasksWidgetsSourceRow*) g_object_new (object_type, "source", source, NULL);
	return self;
}

TasksWidgetsSourceRow*
tasks_widgets_source_row_new (ESource* source)
{
	return tasks_widgets_source_row_construct (TASKS_WIDGETS_TYPE_SOURCE_ROW, source);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_tasks_widgets_source_row_on_drop_accept_gtk_drop_target_accept (GtkDropTarget* _sender,
                                                                 GdkDrop* drop,
                                                                 gpointer self)
{
	gboolean result;
	result = tasks_widgets_source_row_on_drop_accept ((TasksWidgetsSourceRow*) self, drop);
	return result;
}

static gboolean
_tasks_widgets_source_row_on_drag_drop_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                             GValue* value,
                                                             gdouble x,
                                                             gdouble y,
                                                             gpointer self)
{
	gboolean result;
	result = tasks_widgets_source_row_on_drag_drop ((TasksWidgetsSourceRow*) self, value, x, y);
	return result;
}

static GdkDragAction
_tasks_widgets_source_row_on_drag_enter_gtk_drop_target_enter (GtkDropTarget* _sender,
                                                               gdouble x,
                                                               gdouble y,
                                                               gpointer self)
{
	GdkDragAction result;
	result = tasks_widgets_source_row_on_drag_enter ((TasksWidgetsSourceRow*) self, x, y);
	return result;
}

static void
_tasks_widgets_source_row_on_drag_leave_gtk_drop_target_leave (GtkDropTarget* _sender,
                                                               gpointer self)
{
	tasks_widgets_source_row_on_drag_leave ((TasksWidgetsSourceRow*) self);
}

static void
tasks_widgets_source_row_build_drag_and_drop (TasksWidgetsSourceRow* self)
{
	GtkDropTarget* drop_target = NULL;
	GtkDropTarget* _tmp0_;
	GtkEventController* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_drop_target_new (G_TYPE_STRING, GDK_ACTION_COPY);
	drop_target = _tmp0_;
	_tmp1_ = _g_object_ref0 ((GtkEventController*) drop_target);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp1_);
	g_signal_connect_object (drop_target, "accept", (GCallback) _tasks_widgets_source_row_on_drop_accept_gtk_drop_target_accept, self, 0);
	g_signal_connect_object (drop_target, "drop", (GCallback) _tasks_widgets_source_row_on_drag_drop_gtk_drop_target_drop, self, 0);
	g_signal_connect_object (drop_target, "enter", (GCallback) _tasks_widgets_source_row_on_drag_enter_gtk_drop_target_enter, self, 0);
	g_signal_connect_object (drop_target, "leave", (GCallback) _tasks_widgets_source_row_on_drag_leave_gtk_drop_target_leave, self, 0);
	_g_object_unref0 (drop_target);
}

static gboolean
tasks_widgets_source_row_on_drop_accept (TasksWidgetsSourceRow* self,
                                         GdkDrop* drop)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (drop != NULL, FALSE);
	result = TRUE;
	return result;
}

static GdkDragAction
tasks_widgets_source_row_on_drag_enter (TasksWidgetsSourceRow* self,
                                        gdouble x,
                                        gdouble y)
{
	GdkDragAction result;
	g_return_val_if_fail (self != NULL, 0U);
	if (!gtk_widget_has_css_class ((GtkWidget*) self, "drop-hover")) {
		gtk_widget_add_css_class ((GtkWidget*) self, "drop-hover");
	}
	result = GDK_ACTION_COPY;
	return result;
}

static void
tasks_widgets_source_row_on_drag_leave (TasksWidgetsSourceRow* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_remove_css_class ((GtkWidget*) self, "drop-hover");
}

static void
tasks_widgets_source_row_on_drag_drop_move_tasks_data_free (gpointer _data)
{
	TasksWidgetsSourceRowOnDragDropMoveTasksData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TasksWidgetsSourceRowOnDragDropMoveTasksData, _data_);
}

static void
tasks_widgets_source_row_on_drag_drop_move_tasks (TasksWidgetsSourceRow* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	TasksWidgetsSourceRowOnDragDropMoveTasksData* _data_;
	TasksWidgetsSourceRow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (TasksWidgetsSourceRowOnDragDropMoveTasksData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tasks_widgets_source_row_on_drag_drop_move_tasks_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	tasks_widgets_source_row_on_drag_drop_move_tasks_co (_data_);
}

static void
tasks_widgets_source_row_on_drag_drop_move_tasks_finish (TasksWidgetsSourceRow* self,
                                                         GAsyncResult* _res_,
                                                         GError** error)
{
	TasksWidgetsSourceRowOnDragDropMoveTasksData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
tasks_widgets_source_row_on_drag_drop_move_tasks_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	TasksWidgetsSourceRowOnDragDropMoveTasksData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tasks_widgets_source_row_on_drag_drop_move_tasks_co (_data_);
}

static gboolean
tasks_widgets_source_row_on_drag_drop_move_tasks_co (TasksWidgetsSourceRowOnDragDropMoveTasksData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = tasks_application_model;
	_data_->_state_ = 1;
	tasks_task_model_get_registry (_data_->_tmp0_, tasks_widgets_source_row_on_drag_drop_move_tasks_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = tasks_task_model_get_registry_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	_data_->registry = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->received_drag_data;
	_data_->_tmp3_ = gee_multi_map_get_keys ((GeeMultiMap*) _data_->_tmp2_);
	_data_->source_uids = _data_->_tmp3_;
	{
		_data_->_tmp4_ = _data_->source_uids;
		_data_->_tmp5_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp4_);
		_data_->_source_uid_it = _data_->_tmp5_;
		while (TRUE) {
			_data_->_tmp6_ = _data_->_source_uid_it;
			if (!gee_iterator_next (_data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_source_uid_it;
			_data_->_tmp8_ = gee_iterator_get (_data_->_tmp7_);
			_data_->source_uid = (gchar*) _data_->_tmp8_;
			_data_->_tmp9_ = _data_->registry;
			_data_->_tmp10_ = _data_->source_uid;
			_data_->_tmp11_ = e_source_registry_ref_source (_data_->_tmp9_, _data_->_tmp10_);
			_data_->src_source = _data_->_tmp11_;
			_data_->_tmp12_ = _data_->self->priv->received_drag_data;
			_data_->_tmp13_ = _data_->source_uid;
			_data_->_tmp14_ = gee_multi_map_get ((GeeMultiMap*) _data_->_tmp12_, _data_->_tmp13_);
			_data_->component_uids = _data_->_tmp14_;
			{
				_data_->_tmp15_ = _data_->component_uids;
				_data_->_tmp16_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp15_);
				_data_->_component_uid_it = _data_->_tmp16_;
				while (TRUE) {
					_data_->_tmp17_ = _data_->_component_uid_it;
					if (!gee_iterator_next (_data_->_tmp17_)) {
						break;
					}
					_data_->_tmp18_ = _data_->_component_uid_it;
					_data_->_tmp19_ = gee_iterator_get (_data_->_tmp18_);
					_data_->component_uid = (gchar*) _data_->_tmp19_;
					_data_->_tmp21_ = tasks_application_model;
					_data_->_tmp22_ = _data_->src_source;
					_data_->_tmp23_ = _data_->self->priv->_source;
					_data_->_tmp24_ = _data_->component_uid;
					_data_->_state_ = 2;
					tasks_task_model_move_task (_data_->_tmp21_, _data_->_tmp22_, _data_->_tmp23_, _data_->_tmp24_, tasks_widgets_source_row_on_drag_drop_move_tasks_ready, _data_);
					return FALSE;
					_state_2:
					_data_->_tmp20_ = tasks_task_model_move_task_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_free0 (_data_->component_uid);
						_g_object_unref0 (_data_->_component_uid_it);
						_g_object_unref0 (_data_->component_uids);
						_g_object_unref0 (_data_->src_source);
						_g_free0 (_data_->source_uid);
						_g_object_unref0 (_data_->_source_uid_it);
						_g_object_unref0 (_data_->source_uids);
						_g_object_unref0 (_data_->registry);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					if (!_data_->_tmp20_) {
						_data_->_tmp25_ = _data_->component_uid;
						_data_->_tmp26_ = _data_->self->priv->_source;
						_data_->_tmp27_ = e_source_get_uid (_data_->_tmp26_);
						_data_->_tmp28_ = _data_->_tmp27_;
						g_warning ("SourceRow.vala:101: Couldn't move task %s to %s", _data_->_tmp25_, _data_->_tmp28_);
					}
					_g_free0 (_data_->component_uid);
				}
				_g_object_unref0 (_data_->_component_uid_it);
			}
			_g_object_unref0 (_data_->component_uids);
			_g_object_unref0 (_data_->src_source);
			_g_free0 (_data_->source_uid);
		}
		_g_object_unref0 (_data_->_source_uid_it);
	}
	_g_object_unref0 (_data_->source_uids);
	_g_object_unref0 (_data_->registry);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block36Data*
block36_data_ref (Block36Data* _data36_)
{
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}

static void
block36_data_unref (void * _userdata_)
{
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		TasksWidgetsSourceRow* self;
		self = _data36_->self;
		_g_object_unref0 (_data36_->error_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}

static void
___lambda27_ (Block36Data* _data36_)
{
	TasksWidgetsSourceRow* self;
	GraniteMessageDialog* _tmp0_;
	self = _data36_->self;
	_tmp0_ = _data36_->error_dialog;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
}

static void
____lambda27__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda27_ (self);
}

static void
___lambda26_ (TasksWidgetsSourceRow* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		tasks_widgets_source_row_on_drag_drop_move_tasks_finish (self, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		Block36Data* _data36_;
		GThemedIcon* _tmp0_;
		GThemedIcon* _tmp1_;
		GraniteMessageDialog* _tmp2_;
		GraniteMessageDialog* _tmp3_;
		GraniteMessageDialog* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		GraniteMessageDialog* _tmp7_;
		GraniteMessageDialog* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_data36_ = g_slice_new0 (Block36Data);
		_data36_->_ref_count_ = 1;
		_data36_->self = g_object_ref (self);
		_tmp0_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp1_ = _tmp0_;
		_tmp2_ = granite_message_dialog_new (_ ("Moving task failed"), _ ("There was an error while moving the task to the desired list."), (GIcon*) _tmp1_, GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp2_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_data36_->error_dialog = _tmp3_;
		_tmp4_ = _data36_->error_dialog;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		granite_message_dialog_show_error_details (_tmp4_, _tmp6_);
		_tmp7_ = _data36_->error_dialog;
		gtk_window_present ((GtkWindow*) _tmp7_);
		_tmp8_ = _data36_->error_dialog;
		g_signal_connect_data ((GtkDialog*) _tmp8_, "response", (GCallback) ____lambda27__gtk_dialog_response, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
		_g_error_free0 (e);
		block36_data_unref (_data36_);
		_data36_ = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda26__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda26_ ((TasksWidgetsSourceRow*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
tasks_widgets_source_row_on_drag_drop (TasksWidgetsSourceRow* self,
                                       GValue* value,
                                       gdouble x,
                                       gdouble y)
{
	GValue _tmp0_;
	gboolean drop_successful = FALSE;
	gboolean _tmp1_ = FALSE;
	GeeHashMultiMap* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp0_ = *value;
	tasks_widgets_source_row_parse_data (self, g_value_get_string (&_tmp0_));
	drop_successful = FALSE;
	_tmp2_ = self->priv->received_drag_data;
	if (_tmp2_ != NULL) {
		GeeHashMultiMap* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->priv->received_drag_data;
		_tmp4_ = gee_multi_map_get_size ((GeeMultiMap*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		drop_successful = TRUE;
		tasks_widgets_source_row_on_drag_drop_move_tasks (self, ____lambda26__gasync_ready_callback, g_object_ref (self));
	}
	result = drop_successful;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
tasks_widgets_source_row_parse_data (TasksWidgetsSourceRow* self,
                                     const gchar* uri)
{
	GeeHashMultiMap* _tmp0_;
	gchar* uri_scheme = NULL;
	gchar* _tmp1_;
	gchar* source_uid = NULL;
	gchar* component_uid = NULL;
	const gchar* _tmp2_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->received_drag_data);
	self->priv->received_drag_data = _tmp0_;
	_tmp1_ = g_strdup ("task://");
	uri_scheme = _tmp1_;
	source_uid = NULL;
	component_uid = NULL;
	_tmp2_ = uri_scheme;
	if (g_str_has_prefix (uri, _tmp2_)) {
		gchar** uri_parts = NULL;
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gint uri_parts_length1;
		gint _uri_parts_size_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		_tmp3_ = uri_scheme;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = string_substring (uri, (glong) _tmp5_, (glong) -1);
		_tmp7_ = _tmp6_;
		_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "/", 0);
		_tmp10_ = _tmp9_;
		_tmp10__length1 = _vala_array_length (_tmp8_);
		_g_free0 (_tmp7_);
		uri_parts = _tmp10_;
		uri_parts_length1 = _tmp10__length1;
		_uri_parts_size_ = uri_parts_length1;
		_tmp11_ = uri_parts;
		_tmp11__length1 = uri_parts_length1;
		if (_tmp11__length1 == 2) {
			gchar** _tmp12_;
			gint _tmp12__length1;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar** _tmp15_;
			gint _tmp15__length1;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp12_ = uri_parts;
			_tmp12__length1 = uri_parts_length1;
			_tmp13_ = _tmp12_[0];
			_tmp14_ = g_strdup (_tmp13_);
			_g_free0 (source_uid);
			source_uid = _tmp14_;
			_tmp15_ = uri_parts;
			_tmp15__length1 = uri_parts_length1;
			_tmp16_ = _tmp15_[1];
			_tmp17_ = g_strdup (_tmp16_);
			_g_free0 (component_uid);
			component_uid = _tmp17_;
		}
		uri_parts = (_vala_array_free (uri_parts, uri_parts_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp19_ = source_uid;
	if (_tmp19_ == NULL) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp20_;
		_tmp20_ = component_uid;
		_tmp18_ = _tmp20_ == NULL;
	}
	if (_tmp18_) {
		g_warning ("SourceRow.vala:154: Can't handle drop data: Unexpected uri format: %s", uri);
	} else {
		const gchar* _tmp21_;
		ESource* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp21_ = source_uid;
		_tmp22_ = self->priv->_source;
		_tmp23_ = e_source_get_uid (_tmp22_);
		_tmp24_ = _tmp23_;
		if (g_strcmp0 (_tmp21_, _tmp24_) == 0) {
			g_debug ("SourceRow.vala:157: Dropped task onto the same list, so we have nothin" \
"g to do.");
		} else {
			GeeHashMultiMap* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			_tmp25_ = self->priv->received_drag_data;
			_tmp26_ = source_uid;
			_tmp27_ = component_uid;
			gee_multi_map_set ((GeeMultiMap*) _tmp25_, _tmp26_, _tmp27_);
		}
	}
	_g_free0 (component_uid);
	_g_free0 (source_uid);
	_g_free0 (uri_scheme);
}

void
tasks_widgets_source_row_update_request (TasksWidgetsSourceRow* self)
{
	ESource* _tmp0_;
	GtkGrid* _tmp1_;
	GtkLabel* _tmp2_;
	ESource* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	ESource* _tmp6_;
	ESourceConnectionStatus _tmp7_;
	ESourceConnectionStatus _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_source;
	_tmp1_ = self->priv->source_color;
	tasks_application_set_task_color (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->display_name_label;
	_tmp3_ = self->priv->_source;
	_tmp4_ = e_source_get_display_name (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp2_, _tmp5_);
	_tmp6_ = self->priv->_source;
	_tmp7_ = e_source_get_connection_status (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == E_SOURCE_CONNECTION_STATUS_CONNECTING) {
		GtkStack* _tmp9_;
		_tmp9_ = self->priv->status_stack;
		gtk_stack_set_visible_child_name (_tmp9_, "spinner");
	} else {
		GtkStack* _tmp10_;
		ESource* _tmp11_;
		ESourceConnectionStatus _tmp12_;
		ESourceConnectionStatus _tmp13_;
		_tmp10_ = self->priv->status_stack;
		gtk_stack_set_visible_child_name (_tmp10_, "image");
		_tmp11_ = self->priv->_source;
		_tmp12_ = e_source_get_connection_status (_tmp11_);
		_tmp13_ = _tmp12_;
		switch (_tmp13_) {
			case E_SOURCE_CONNECTION_STATUS_AWAITING_CREDENTIALS:
			{
				GtkImage* _tmp14_;
				GtkImage* _tmp15_;
				_tmp14_ = self->priv->status_image;
				g_object_set (_tmp14_, "icon-name", "dialog-password-symbolic", NULL);
				_tmp15_ = self->priv->status_image;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, _ ("Waiting for login credentials"));
				break;
			}
			case E_SOURCE_CONNECTION_STATUS_DISCONNECTED:
			{
				GtkImage* _tmp16_;
				GtkImage* _tmp17_;
				_tmp16_ = self->priv->status_image;
				g_object_set (_tmp16_, "icon-name", "network-offline-symbolic", NULL);
				_tmp17_ = self->priv->status_image;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp17_, _ ("Currently disconnected from the (possibly remote) data store"));
				break;
			}
			case E_SOURCE_CONNECTION_STATUS_SSL_FAILED:
			{
				GtkImage* _tmp18_;
				GtkImage* _tmp19_;
				_tmp18_ = self->priv->status_image;
				g_object_set (_tmp18_, "icon-name", "security-low-symbolic", NULL);
				_tmp19_ = self->priv->status_image;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp19_, _ ("SSL certificate trust was rejected for the connection"));
				break;
			}
			default:
			{
				GtkImage* _tmp20_;
				GtkImage* _tmp21_;
				_tmp20_ = self->priv->status_image;
				g_object_set (_tmp20_, "gicon", NULL, NULL);
				_tmp21_ = self->priv->status_image;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp21_, NULL);
				break;
			}
		}
	}
}

static gboolean
__lambda28_ (TasksWidgetsSourceRow* self)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	gboolean result;
	_tmp0_ = gtk_widget_get_parent ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	gtk_list_box_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_list_box_get_type (), GtkListBox), (GtkWidget*) self);
	g_signal_emit_by_name ((GtkWidget*) self, "destroy");
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda28__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda28_ ((TasksWidgetsSourceRow*) self);
	return result;
}

void
tasks_widgets_source_row_remove_request (TasksWidgetsSourceRow* self)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	_tmp1_ = self->priv->revealer;
	_tmp2_ = gtk_revealer_get_transition_duration (_tmp1_);
	_tmp3_ = _tmp2_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp3_, ___lambda28__gsource_func, g_object_ref (self), g_object_unref);
}

ESource*
tasks_widgets_source_row_get_source (TasksWidgetsSourceRow* self)
{
	ESource* result;
	ESource* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source;
	result = _tmp0_;
	return result;
}

static void
tasks_widgets_source_row_set_source (TasksWidgetsSourceRow* self,
                                     ESource* value)
{
	ESource* old_value;
	g_return_if_fail (self != NULL);
	old_value = tasks_widgets_source_row_get_source (self);
	if (old_value != value) {
		ESource* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_source);
		self->priv->_source = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tasks_widgets_source_row_properties[TASKS_WIDGETS_SOURCE_ROW_SOURCE_PROPERTY]);
	}
}

static GObject *
tasks_widgets_source_row_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TasksWidgetsSourceRow * self;
	GtkGrid* _tmp0_ = NULL;
	GtkGrid* _tmp1_;
	ESource* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkLabel* _tmp5_ = NULL;
	GtkImage* _tmp6_ = NULL;
	GtkSpinner* spinner = NULL;
	gchar* _tmp7_;
	GtkSpinner* _tmp8_ = NULL;
	GtkStack* _tmp9_;
	GtkStack* _tmp10_;
	GtkImage* _tmp11_;
	GtkStack* _tmp12_;
	GtkSpinner* _tmp13_;
	GtkBox* box = NULL;
	GtkBox* _tmp14_ = NULL;
	GtkBox* _tmp15_;
	GtkGrid* _tmp16_;
	GtkBox* _tmp17_;
	GtkLabel* _tmp18_;
	GtkBox* _tmp19_;
	GtkStack* _tmp20_;
	GtkBox* _tmp21_;
	GtkWidget* _tmp22_;
	GtkRevealer* _tmp23_ = NULL;
	GtkRevealer* _tmp24_;
	parent_class = G_OBJECT_CLASS (tasks_widgets_source_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp0_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->source_color);
	self->priv->source_color = _tmp0_;
	_tmp1_ = self->priv->source_color;
	gtk_widget_add_css_class ((GtkWidget*) _tmp1_, "source-color");
	_tmp2_ = self->priv->_source;
	_tmp3_ = e_source_get_display_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp5_, 9);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->display_name_label);
	self->priv->display_name_label = _tmp5_;
	_tmp6_ = (GtkImage*) gtk_image_new ();
	gtk_image_set_pixel_size (_tmp6_, 16);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->status_image);
	self->priv->status_image = _tmp6_;
	_tmp7_ = g_strdup (_ ("Connecting…"));
	_tmp8_ = (GtkSpinner*) gtk_spinner_new ();
	gtk_spinner_set_spinning (_tmp8_, TRUE);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp8_, _tmp7_);
	_g_free0 (_tmp7_);
	g_object_ref_sink (_tmp8_);
	spinner = _tmp8_;
	_tmp9_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->status_stack);
	self->priv->status_stack = _tmp9_;
	_tmp10_ = self->priv->status_stack;
	_tmp11_ = self->priv->status_image;
	gtk_stack_add_named (_tmp10_, (GtkWidget*) _tmp11_, "image");
	_tmp12_ = self->priv->status_stack;
	_tmp13_ = spinner;
	gtk_stack_add_named (_tmp12_, (GtkWidget*) _tmp13_, "spinner");
	_tmp14_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp14_, 6);
	g_object_ref_sink (_tmp14_);
	box = _tmp14_;
	_tmp15_ = box;
	_tmp16_ = self->priv->source_color;
	gtk_box_append (_tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = box;
	_tmp18_ = self->priv->display_name_label;
	gtk_box_append (_tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = box;
	_tmp20_ = self->priv->status_stack;
	gtk_box_append (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = box;
	_tmp22_ = _g_object_ref0 ((GtkWidget*) _tmp21_);
	_tmp23_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_reveal_child (_tmp23_, TRUE);
	gtk_revealer_set_child (_tmp23_, _tmp22_);
	_g_object_unref0 (_tmp22_);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->revealer);
	self->priv->revealer = _tmp23_;
	_tmp24_ = self->priv->revealer;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp24_);
	tasks_widgets_source_row_build_drag_and_drop (self);
	tasks_widgets_source_row_update_request (self);
	_g_object_unref0 (box);
	_g_object_unref0 (spinner);
	return obj;
}

static void
tasks_widgets_source_row_class_init (TasksWidgetsSourceRowClass * klass,
                                     gpointer klass_data)
{
	tasks_widgets_source_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TasksWidgetsSourceRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_tasks_widgets_source_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tasks_widgets_source_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = tasks_widgets_source_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = tasks_widgets_source_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TASKS_WIDGETS_SOURCE_ROW_SOURCE_PROPERTY, tasks_widgets_source_row_properties[TASKS_WIDGETS_SOURCE_ROW_SOURCE_PROPERTY] = g_param_spec_object ("source", "source", "source", e_source_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
tasks_widgets_source_row_instance_init (TasksWidgetsSourceRow * self,
                                        gpointer klass)
{
	self->priv = tasks_widgets_source_row_get_instance_private (self);
}

static void
tasks_widgets_source_row_finalize (GObject * obj)
{
	TasksWidgetsSourceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow);
	_g_object_unref0 (self->priv->_source);
	_g_object_unref0 (self->priv->source_color);
	_g_object_unref0 (self->priv->status_image);
	_g_object_unref0 (self->priv->display_name_label);
	_g_object_unref0 (self->priv->status_stack);
	_g_object_unref0 (self->priv->revealer);
	_g_object_unref0 (self->priv->received_drag_data);
	G_OBJECT_CLASS (tasks_widgets_source_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tasks_widgets_source_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TasksWidgetsSourceRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasks_widgets_source_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TasksWidgetsSourceRow), 0, (GInstanceInitFunc) tasks_widgets_source_row_instance_init, NULL };
	GType tasks_widgets_source_row_type_id;
	tasks_widgets_source_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "TasksWidgetsSourceRow", &g_define_type_info, 0);
	TasksWidgetsSourceRow_private_offset = g_type_add_instance_private (tasks_widgets_source_row_type_id, sizeof (TasksWidgetsSourceRowPrivate));
	return tasks_widgets_source_row_type_id;
}

GType
tasks_widgets_source_row_get_type (void)
{
	static gsize tasks_widgets_source_row_type_id__once = 0;
	if (g_once_init_enter (&tasks_widgets_source_row_type_id__once)) {
		GType tasks_widgets_source_row_type_id;
		tasks_widgets_source_row_type_id = tasks_widgets_source_row_get_type_once ();
		g_once_init_leave (&tasks_widgets_source_row_type_id__once, tasks_widgets_source_row_type_id);
	}
	return tasks_widgets_source_row_type_id__once;
}

static void
_vala_tasks_widgets_source_row_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	TasksWidgetsSourceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow);
	switch (property_id) {
		case TASKS_WIDGETS_SOURCE_ROW_SOURCE_PROPERTY:
		g_value_set_object (value, tasks_widgets_source_row_get_source (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tasks_widgets_source_row_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	TasksWidgetsSourceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow);
	switch (property_id) {
		case TASKS_WIDGETS_SOURCE_ROW_SOURCE_PROPERTY:
		tasks_widgets_source_row_set_source (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

