/* MainWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*
 * Copyright 2019-2023 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <libedataserver/libedataserver.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <gdk/gdk.h>
#include <adwaita.h>

#define TASKS_MAIN_WINDOW_ACTION_GROUP_PREFIX "win"
#define TASKS_MAIN_WINDOW_ACTION_PREFIX TASKS_MAIN_WINDOW_ACTION_GROUP_PREFIX "."
#define TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST "action-delete-selected-list"
#define TASKS_MAIN_WINDOW_SCHEDULED_LIST_UID "scheduled"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TASKS_TYPE_MAIN_WINDOW (tasks_main_window_get_type ())
#define TASKS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_MAIN_WINDOW, TasksMainWindow))
#define TASKS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_MAIN_WINDOW, TasksMainWindowClass))
#define TASKS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_MAIN_WINDOW))
#define TASKS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_MAIN_WINDOW))
#define TASKS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_MAIN_WINDOW, TasksMainWindowClass))

typedef struct _TasksMainWindow TasksMainWindow;
typedef struct _TasksMainWindowClass TasksMainWindowClass;
typedef struct _TasksMainWindowPrivate TasksMainWindowPrivate;

#define TASKS_WIDGETS_TYPE_SOURCE_ROW (tasks_widgets_source_row_get_type ())
#define TASKS_WIDGETS_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow))
#define TASKS_WIDGETS_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRowClass))
#define TASKS_WIDGETS_IS_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_WIDGETS_TYPE_SOURCE_ROW))
#define TASKS_WIDGETS_IS_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_WIDGETS_TYPE_SOURCE_ROW))
#define TASKS_WIDGETS_SOURCE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRowClass))

typedef struct _TasksWidgetsSourceRow TasksWidgetsSourceRow;
typedef struct _TasksWidgetsSourceRowClass TasksWidgetsSourceRowClass;
enum  {
	TASKS_MAIN_WINDOW_0_PROPERTY,
	TASKS_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* tasks_main_window_properties[TASKS_MAIN_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TASKS_TYPE_LIST_VIEW (tasks_list_view_get_type ())
#define TASKS_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_LIST_VIEW, TasksListView))
#define TASKS_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_LIST_VIEW, TasksListViewClass))
#define TASKS_IS_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_LIST_VIEW))
#define TASKS_IS_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_LIST_VIEW))
#define TASKS_LIST_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_LIST_VIEW, TasksListViewClass))

typedef struct _TasksListView TasksListView;
typedef struct _TasksListViewClass TasksListViewClass;
typedef struct _Block1Data Block1Data;

#define TASKS_TYPE_TASK_MODEL (tasks_task_model_get_type ())
#define TASKS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModel))
#define TASKS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))
#define TASKS_IS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_TASK_MODEL))
#define TASKS_IS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_TASK_MODEL))
#define TASKS_TASK_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))

typedef struct _TasksTaskModel TasksTaskModel;
typedef struct _TasksTaskModelClass TasksTaskModelClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TASKS_WIDGETS_TYPE_SCHEDULED_ROW (tasks_widgets_scheduled_row_get_type ())
#define TASKS_WIDGETS_SCHEDULED_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_WIDGETS_TYPE_SCHEDULED_ROW, TasksWidgetsScheduledRow))
#define TASKS_WIDGETS_SCHEDULED_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_WIDGETS_TYPE_SCHEDULED_ROW, TasksWidgetsScheduledRowClass))
#define TASKS_WIDGETS_IS_SCHEDULED_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_WIDGETS_TYPE_SCHEDULED_ROW))
#define TASKS_WIDGETS_IS_SCHEDULED_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_WIDGETS_TYPE_SCHEDULED_ROW))
#define TASKS_WIDGETS_SCHEDULED_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_WIDGETS_TYPE_SCHEDULED_ROW, TasksWidgetsScheduledRowClass))

typedef struct _TasksWidgetsScheduledRow TasksWidgetsScheduledRow;
typedef struct _TasksWidgetsScheduledRowClass TasksWidgetsScheduledRowClass;

#define TASKS_TYPE_SCHEDULED_VIEW (tasks_scheduled_view_get_type ())
#define TASKS_SCHEDULED_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_SCHEDULED_VIEW, TasksScheduledView))
#define TASKS_SCHEDULED_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_SCHEDULED_VIEW, TasksScheduledViewClass))
#define TASKS_IS_SCHEDULED_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_SCHEDULED_VIEW))
#define TASKS_IS_SCHEDULED_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_SCHEDULED_VIEW))
#define TASKS_SCHEDULED_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_SCHEDULED_VIEW, TasksScheduledViewClass))

typedef struct _TasksScheduledView TasksScheduledView;
typedef struct _TasksScheduledViewClass TasksScheduledViewClass;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

#define TASKS_TYPE_POPOVER_MENUITEM (tasks_popover_menuitem_get_type ())
#define TASKS_POPOVER_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_POPOVER_MENUITEM, TasksPopoverMenuitem))
#define TASKS_POPOVER_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_POPOVER_MENUITEM, TasksPopoverMenuitemClass))
#define TASKS_IS_POPOVER_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_POPOVER_MENUITEM))
#define TASKS_IS_POPOVER_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_POPOVER_MENUITEM))
#define TASKS_POPOVER_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_POPOVER_MENUITEM, TasksPopoverMenuitemClass))

typedef struct _TasksPopoverMenuitem TasksPopoverMenuitem;
typedef struct _TasksPopoverMenuitemClass TasksPopoverMenuitemClass;
typedef struct _Block7Data Block7Data;

#define TASKS_TYPE_APPLICATION (tasks_application_get_type ())
#define TASKS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_APPLICATION, TasksApplication))
#define TASKS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_APPLICATION, TasksApplicationClass))
#define TASKS_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_APPLICATION))
#define TASKS_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_APPLICATION))
#define TASKS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_APPLICATION, TasksApplicationClass))

typedef struct _TasksApplication TasksApplication;
typedef struct _TasksApplicationClass TasksApplicationClass;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TasksMainWindow {
	GtkApplicationWindow parent_instance;
	TasksMainWindowPrivate * priv;
};

struct _TasksMainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _TasksMainWindowPrivate {
	GtkListBox* listbox;
	GeeHashMap* source_rows;
	GeeCollection* collection_sources;
	GtkStack* list_view_stack;
	GtkBox* add_tasklist_buttonbox;
	GtkPopover* add_tasklist_popover;
};

struct _Block1Data {
	int _ref_count_;
	TasksMainWindow* self;
	ESource* source;
};

struct _Block2Data {
	int _ref_count_;
	TasksMainWindow* self;
	gchar* error_dialog_primary_text;
	gchar* error_dialog_secondary_text;
};

struct _Block3Data {
	int _ref_count_;
	TasksMainWindow* self;
	gchar* error_message;
	gchar* primary_text;
	gchar* secondary_text;
};

struct _Block4Data {
	int _ref_count_;
	TasksMainWindow* self;
	ESource* source;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	GraniteMessageDialog* message_dialog;
};

struct _Block6Data {
	int _ref_count_;
	TasksMainWindow* self;
	ESource* collection_source;
};

struct _Block7Data {
	int _ref_count_;
	TasksMainWindow* self;
	TasksWidgetsScheduledRow* scheduled_row;
};

struct _Block8Data {
	int _ref_count_;
	Block7Data * _data7_;
	gchar* last_selected_list;
};

struct _Block9Data {
	int _ref_count_;
	Block8Data * _data8_;
	ESource* default_task_list;
};

static gint TasksMainWindow_private_offset;
static gpointer tasks_main_window_parent_class = NULL;
static GeeMultiMap* tasks_main_window_action_accelerators;
static GeeMultiMap* tasks_main_window_action_accelerators = NULL;
VALA_EXTERN TasksTaskModel* tasks_application_model;
VALA_EXTERN GSettings* tasks_application_settings;

VALA_EXTERN GType tasks_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksMainWindow, g_object_unref)
VALA_EXTERN GType tasks_widgets_source_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksWidgetsSourceRow, g_object_unref)
static void tasks_main_window_action_delete_selected_list (TasksMainWindow* self);
static void _tasks_main_window_action_delete_selected_list_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                      GVariant* parameter,
                                                                                      gpointer self);
VALA_EXTERN TasksMainWindow* tasks_main_window_new (GtkApplication* application);
VALA_EXTERN TasksMainWindow* tasks_main_window_construct (GType object_type,
                                              GtkApplication* application);
static void tasks_main_window_on_listbox_row_selected (TasksMainWindow* self,
                                                GtkListBoxRow* row);
VALA_EXTERN GType tasks_list_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksListView, g_object_unref)
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN ESource* tasks_widgets_source_row_get_source (TasksWidgetsSourceRow* self);
VALA_EXTERN GType tasks_task_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksTaskModel, g_object_unref)
VALA_EXTERN void tasks_task_model_refresh_task_list (TasksTaskModel* self,
                                         ESource* task_list,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN gboolean tasks_task_model_refresh_task_list_finish (TasksTaskModel* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static void ____lambda100_ (Block1Data* _data1_,
                     GObject* obj,
                     GAsyncResult* res);
static void _____lambda100__gasync_ready_callback (GObject* source_object,
                                            GAsyncResult* res,
                                            gpointer self);
VALA_EXTERN TasksListView* tasks_list_view_new (ESource* source);
VALA_EXTERN TasksListView* tasks_list_view_construct (GType object_type,
                                          ESource* source);
VALA_EXTERN gboolean tasks_task_model_is_remove_task_list_supported (TasksTaskModel* self,
                                                         ESource* source);
VALA_EXTERN GType tasks_widgets_scheduled_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksWidgetsScheduledRow, g_object_unref)
VALA_EXTERN GType tasks_scheduled_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksScheduledView, g_object_unref)
VALA_EXTERN TasksScheduledView* tasks_scheduled_view_new (TasksTaskModel* model);
VALA_EXTERN TasksScheduledView* tasks_scheduled_view_construct (GType object_type,
                                                    TasksTaskModel* model);
VALA_EXTERN void tasks_list_view_update_request (TasksListView* self);
static void tasks_main_window_add_new_list (TasksMainWindow* self,
                                     ESource* collection_source);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN void tasks_task_model_add_task_list (TasksTaskModel* self,
                                     ESource* task_list,
                                     ESource* collection_or_sibling,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void tasks_task_model_add_task_list_finish (TasksTaskModel* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void ___lambda116_ (Block2Data* _data2_,
                    GObject* obj,
                    GAsyncResult* res);
static void tasks_main_window_show_error_dialog (TasksMainWindow* self,
                                          const gchar* primary_text,
                                          const gchar* secondary_text,
                                          GError* e);
static void ____lambda116__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda31_ (Block3Data* _data3_);
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static gboolean ___lambda31__gsource_func (gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda29_ (Block5Data* _data5_,
                   gint response);
VALA_EXTERN void tasks_task_model_remove_task_list (TasksTaskModel* self,
                                        ESource* task_list,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void tasks_task_model_remove_task_list_finish (TasksTaskModel* self,
                                               GAsyncResult* _res_,
                                               GError** error);
static void ___lambda30_ (TasksMainWindow* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda30__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ____lambda29__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void tasks_main_window_header_update_func (TasksMainWindow* self,
                                           GtkListBoxRow* lbrow,
                                           GtkListBoxRow* lbbefore);
VALA_EXTERN gchar* tasks_util_get_esource_collection_display_name (ESource* source);
static gint tasks_main_window_sort_function (GtkListBoxRow* lbrow,
                                      GtkListBoxRow* lbbefore,
                                      TasksMainWindow* self);
static void tasks_main_window_add_collection_source (TasksMainWindow* self,
                                              ESource* collection_source);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
VALA_EXTERN guint tasks_util_esource_hash_func (ESource* source);
static guint _tasks_util_esource_hash_func_gee_hash_data_func (gconstpointer v,
                                                        gpointer self);
VALA_EXTERN gboolean tasks_util_esource_equal_func (ESource* a,
                                        ESource* b);
static gboolean _tasks_util_esource_equal_func_gee_equal_data_func (gconstpointer a,
                                                             gconstpointer b,
                                                             gpointer self);
VALA_EXTERN GType tasks_popover_menuitem_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksPopoverMenuitem, g_object_unref)
VALA_EXTERN gboolean tasks_task_model_is_add_task_list_supported (TasksTaskModel* self,
                                                      ESource* source);
VALA_EXTERN TasksPopoverMenuitem* tasks_popover_menuitem_new (void);
VALA_EXTERN TasksPopoverMenuitem* tasks_popover_menuitem_construct (GType object_type);
VALA_EXTERN void tasks_popover_menuitem_set_text (TasksPopoverMenuitem* self,
                                      const gchar* value);
static void __lambda117_ (Block6Data* _data6_);
static void ___lambda117__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void tasks_main_window_add_source (TasksMainWindow* self,
                                   ESource* source);
VALA_EXTERN TasksWidgetsSourceRow* tasks_widgets_source_row_new (ESource* source);
VALA_EXTERN TasksWidgetsSourceRow* tasks_widgets_source_row_construct (GType object_type,
                                                           ESource* source);
static gboolean ___lambda118_ (TasksMainWindow* self);
static gboolean ____lambda118__gsource_func (gpointer self);
static void tasks_main_window_update_source (TasksMainWindow* self,
                                      ESource* source);
static void tasks_main_window_remove_source (TasksMainWindow* self,
                                      ESource* source);
VALA_EXTERN void tasks_widgets_source_row_update_request (TasksWidgetsSourceRow* self);
static gboolean ____lambda120_ (TasksMainWindow* self);
static gboolean _____lambda120__gsource_func (gpointer self);
VALA_EXTERN void tasks_widgets_source_row_remove_request (TasksWidgetsSourceRow* self);
static gboolean __lambda119_ (TasksMainWindow* self);
static gboolean ___lambda119__gsource_func (gpointer self);
static GObject * tasks_main_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gint _tasks_main_window_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                              GtkListBoxRow* row2,
                                                              gpointer self);
VALA_EXTERN TasksWidgetsScheduledRow* tasks_widgets_scheduled_row_new (void);
VALA_EXTERN TasksWidgetsScheduledRow* tasks_widgets_scheduled_row_construct (GType object_type);
static gboolean _tasks_main_window___lambda121_ (TasksMainWindow* self);
VALA_EXTERN GType tasks_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksApplication, g_object_unref)
VALA_EXTERN void tasks_application_request_background (TasksApplication* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void tasks_application_request_background_finish (TasksApplication* self,
                                                  GAsyncResult* _res_);
static void __lambda122_ (TasksMainWindow* self);
static void ___lambda122__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static gboolean __tasks_main_window___lambda121__gtk_window_close_request (GtkWindow* _sender,
                                                                    gpointer self);
static void _tasks_main_window___lambda123_ (TasksMainWindow* self);
static void __tasks_main_window___lambda123__gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
static void _tasks_main_window_add_source_tasks_task_model_task_list_added (TasksTaskModel* _sender,
                                                                     ESource* task_list,
                                                                     gpointer self);
static void _tasks_main_window_update_source_tasks_task_model_task_list_modified (TasksTaskModel* _sender,
                                                                           ESource* task_list,
                                                                           gpointer self);
static void _tasks_main_window_remove_source_tasks_task_model_task_list_removed (TasksTaskModel* _sender,
                                                                          ESource* task_list,
                                                                          gpointer self);
VALA_EXTERN void tasks_task_model_get_registry (TasksTaskModel* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN ESourceRegistry* tasks_task_model_get_registry_finish (TasksTaskModel* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void _tasks_main_window___lambda124_ (Block7Data* _data7_,
                                      GObject* obj,
                                      GAsyncResult* res);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void _tasks_main_window_header_update_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                            GtkListBoxRow* before,
                                                                            gpointer self);
static void _tasks_main_window_on_listbox_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                           GtkListBoxRow* row,
                                                                           gpointer self);
static void __lambda125_ (TasksMainWindow* self,
                   ESource* collection_source);
static void ___lambda125__gfunc (gconstpointer data,
                          gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void ___lambda126_ (Block9Data* _data9_,
                    ESource* source);
static void ____lambda126__gfunc (gconstpointer data,
                           gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void __tasks_main_window___lambda124__gasync_ready_callback (GObject* source_object,
                                                             GAsyncResult* res,
                                                             gpointer self);
static void tasks_main_window_finalize (GObject * obj);
static GType tasks_main_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry TASKS_MAIN_WINDOW_ACTION_ENTRIES[1] = {{TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST, _tasks_main_window_action_delete_selected_list_gsimple_action_activate_callback}};

static inline gpointer
tasks_main_window_get_instance_private (TasksMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, TasksMainWindow_private_offset);
}

static void
_tasks_main_window_action_delete_selected_list_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self)
{
	tasks_main_window_action_delete_selected_list ((TasksMainWindow*) self);
}

TasksMainWindow*
tasks_main_window_construct (GType object_type,
                             GtkApplication* application)
{
	TasksMainWindow * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	self = (TasksMainWindow*) g_object_new (object_type, "application", application, "icon-name", "io.elementary.tasks", "title", _ ("Tasks"), NULL);
	return self;
}

TasksMainWindow*
tasks_main_window_new (GtkApplication* application)
{
	return tasks_main_window_construct (TASKS_TYPE_MAIN_WINDOW, application);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->source);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
____lambda100_ (Block1Data* _data1_,
                GObject* obj,
                GAsyncResult* res)
{
	TasksMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		TasksTaskModel* _tmp0_;
		_tmp0_ = tasks_application_model;
		tasks_task_model_refresh_task_list_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		ESource* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data1_->source;
		_tmp2_ = e_source_dup_display_name (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("MainWindow.vala:207: Error syncing task list '%s': %s", _tmp3_, _tmp5_);
		_g_free0 (_tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_____lambda100__gasync_ready_callback (GObject* source_object,
                                       GAsyncResult* res,
                                       gpointer self)
{
	____lambda100_ (self, source_object, res);
	block1_data_unref (self);
}

static void
tasks_main_window_on_listbox_row_selected (TasksMainWindow* self,
                                           GtkListBoxRow* row)
{
	g_return_if_fail (self != NULL);
	if (row != NULL) {
		TasksListView* list_view = NULL;
		TasksListView* _tmp35_;
		list_view = NULL;
		if (TASKS_WIDGETS_IS_SOURCE_ROW (row)) {
			Block1Data* _data1_;
			ESource* _tmp0_;
			ESource* _tmp1_;
			ESource* _tmp2_;
			gchar* source_uid = NULL;
			ESource* _tmp3_;
			gchar* _tmp4_;
			TasksTaskModel* _tmp5_;
			ESource* _tmp6_;
			GtkStack* _tmp7_;
			const gchar* _tmp8_;
			GtkWidget* _tmp9_;
			TasksListView* _tmp10_;
			TasksListView* _tmp11_;
			GtkStack* _tmp17_;
			const gchar* _tmp18_;
			GSettings* _tmp19_;
			const gchar* _tmp20_;
			GAction* _tmp21_;
			TasksTaskModel* _tmp22_;
			ESource* _tmp23_;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			_tmp0_ = tasks_widgets_source_row_get_source (G_TYPE_CHECK_INSTANCE_CAST (row, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow));
			_tmp1_ = _tmp0_;
			_tmp2_ = _g_object_ref0 (_tmp1_);
			_data1_->source = _tmp2_;
			_tmp3_ = _data1_->source;
			_tmp4_ = e_source_dup_uid (_tmp3_);
			source_uid = _tmp4_;
			_tmp5_ = tasks_application_model;
			_tmp6_ = _data1_->source;
			tasks_task_model_refresh_task_list (_tmp5_, _tmp6_, NULL, _____lambda100__gasync_ready_callback, block1_data_ref (_data1_));
			_tmp7_ = self->priv->list_view_stack;
			_tmp8_ = source_uid;
			_tmp9_ = gtk_stack_get_child_by_name (_tmp7_, _tmp8_);
			_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TASKS_TYPE_LIST_VIEW, TasksListView));
			_g_object_unref0 (list_view);
			list_view = _tmp10_;
			_tmp11_ = list_view;
			if (_tmp11_ == NULL) {
				ESource* _tmp12_;
				TasksListView* _tmp13_;
				GtkStack* _tmp14_;
				TasksListView* _tmp15_;
				const gchar* _tmp16_;
				_tmp12_ = _data1_->source;
				_tmp13_ = tasks_list_view_new (_tmp12_);
				g_object_ref_sink (_tmp13_);
				_g_object_unref0 (list_view);
				list_view = _tmp13_;
				_tmp14_ = self->priv->list_view_stack;
				_tmp15_ = list_view;
				_tmp16_ = source_uid;
				gtk_stack_add_named (_tmp14_, (GtkWidget*) _tmp15_, _tmp16_);
			}
			_tmp17_ = self->priv->list_view_stack;
			_tmp18_ = source_uid;
			gtk_stack_set_visible_child_name (_tmp17_, _tmp18_);
			_tmp19_ = tasks_application_settings;
			_tmp20_ = source_uid;
			g_settings_set_string (_tmp19_, "selected-list", _tmp20_);
			_tmp21_ = g_action_map_lookup_action ((GActionMap*) self, TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST);
			_tmp22_ = tasks_application_model;
			_tmp23_ = _data1_->source;
			g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, g_simple_action_get_type (), GSimpleAction), tasks_task_model_is_remove_task_list_supported (_tmp22_, _tmp23_));
			_g_free0 (source_uid);
			block1_data_unref (_data1_);
			_data1_ = NULL;
		} else {
			if (TASKS_WIDGETS_IS_SCHEDULED_ROW (row)) {
				TasksScheduledView* scheduled_view = NULL;
				GtkStack* _tmp24_;
				GtkWidget* _tmp25_;
				TasksScheduledView* _tmp26_;
				TasksScheduledView* _tmp27_;
				GtkStack* _tmp32_;
				GSettings* _tmp33_;
				GAction* _tmp34_;
				_tmp24_ = self->priv->list_view_stack;
				_tmp25_ = gtk_stack_get_child_by_name (_tmp24_, TASKS_MAIN_WINDOW_SCHEDULED_LIST_UID);
				_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TASKS_TYPE_SCHEDULED_VIEW, TasksScheduledView));
				scheduled_view = _tmp26_;
				_tmp27_ = scheduled_view;
				if (_tmp27_ == NULL) {
					TasksTaskModel* _tmp28_;
					TasksScheduledView* _tmp29_;
					GtkStack* _tmp30_;
					TasksScheduledView* _tmp31_;
					_tmp28_ = tasks_application_model;
					_tmp29_ = tasks_scheduled_view_new (_tmp28_);
					g_object_ref_sink (_tmp29_);
					_g_object_unref0 (scheduled_view);
					scheduled_view = _tmp29_;
					_tmp30_ = self->priv->list_view_stack;
					_tmp31_ = scheduled_view;
					gtk_stack_add_named (_tmp30_, (GtkWidget*) _tmp31_, TASKS_MAIN_WINDOW_SCHEDULED_LIST_UID);
				}
				_tmp32_ = self->priv->list_view_stack;
				gtk_stack_set_visible_child_name (_tmp32_, TASKS_MAIN_WINDOW_SCHEDULED_LIST_UID);
				_tmp33_ = tasks_application_settings;
				g_settings_set_string (_tmp33_, "selected-list", TASKS_MAIN_WINDOW_SCHEDULED_LIST_UID);
				_tmp34_ = g_action_map_lookup_action ((GActionMap*) self, TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST);
				g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, g_simple_action_get_type (), GSimpleAction), FALSE);
				_g_object_unref0 (scheduled_view);
			}
		}
		_tmp35_ = list_view;
		if (_tmp35_ != NULL) {
			TasksListView* _tmp36_;
			_tmp36_ = list_view;
			tasks_list_view_update_request (_tmp36_);
		}
		_g_object_unref0 (list_view);
	} else {
		GAction* _tmp37_;
		GtkListBoxRow* first_row = NULL;
		GtkListBox* _tmp38_;
		GtkListBoxRow* _tmp39_;
		GtkListBoxRow* _tmp40_;
		GtkListBoxRow* _tmp41_;
		_tmp37_ = g_action_map_lookup_action ((GActionMap*) self, TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST);
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, g_simple_action_get_type (), GSimpleAction), FALSE);
		_tmp38_ = self->priv->listbox;
		_tmp39_ = gtk_list_box_get_row_at_index (_tmp38_, 0);
		_tmp40_ = _g_object_ref0 (_tmp39_);
		first_row = _tmp40_;
		_tmp41_ = first_row;
		if (_tmp41_ != NULL) {
			GtkListBox* _tmp42_;
			GtkListBoxRow* _tmp43_;
			_tmp42_ = self->priv->listbox;
			_tmp43_ = first_row;
			gtk_list_box_select_row (_tmp42_, _tmp43_);
		}
		_g_object_unref0 (first_row);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data2_->self;
		_g_free0 (_data2_->error_dialog_secondary_text);
		_g_free0 (_data2_->error_dialog_primary_text);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
___lambda116_ (Block2Data* _data2_,
               GObject* obj,
               GAsyncResult* res)
{
	TasksMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		TasksTaskModel* _tmp0_;
		_tmp0_ = tasks_application_model;
		tasks_task_model_add_task_list_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("MainWindow.vala:260: %s", _tmp2_);
		_tmp3_ = e;
		tasks_main_window_show_error_dialog (self, _data2_->error_dialog_primary_text, _data2_->error_dialog_secondary_text, _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda116__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda116_ (self, source_object, res);
	block2_data_unref (self);
}

static void
tasks_main_window_add_new_list (TasksMainWindow* self,
                                ESource* collection_source)
{
	Block2Data* _data2_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (collection_source != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_strdup (_ ("Creating a new task list failed"));
	_data2_->error_dialog_primary_text = _tmp0_;
	_tmp1_ = g_strdup (_ ("The task list registry may be unavailable or unable to be written to."));
	_data2_->error_dialog_secondary_text = _tmp1_;
	{
		ESource* new_source = NULL;
		ESource* _tmp2_;
		ESourceTaskList* new_source_tasklist_extension = NULL;
		ESourceExtension* _tmp3_;
		ESourceTaskList* _tmp4_;
		TasksTaskModel* _tmp5_;
		_tmp2_ = e_source_new (NULL, NULL, &_inner_error0_);
		new_source = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = e_source_get_extension (new_source, E_SOURCE_EXTENSION_TASK_LIST);
		new_source_tasklist_extension = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, e_source_task_list_get_type (), ESourceTaskList);
		e_source_set_display_name (new_source, _ ("New list"));
		_tmp4_ = new_source_tasklist_extension;
		e_source_selectable_set_color ((ESourceSelectable*) _tmp4_, "#0e9a83");
		_tmp5_ = tasks_application_model;
		tasks_task_model_add_task_list (_tmp5_, new_source, collection_source, ____lambda116__gasync_ready_callback, block2_data_ref (_data2_));
		_g_object_unref0 (new_source);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("MainWindow.vala:266: %s", _tmp7_);
		_tmp8_ = e;
		tasks_main_window_show_error_dialog (self, _data2_->error_dialog_primary_text, _data2_->error_dialog_secondary_text, _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data3_->self;
		_g_free0 (_data3_->error_message);
		_g_free0 (_data3_->primary_text);
		_g_free0 (_data3_->secondary_text);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static gboolean
__lambda31_ (Block3Data* _data3_)
{
	TasksMainWindow* self;
	GraniteMessageDialog* error_dialog = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GtkWindow* _tmp2_;
	GraniteMessageDialog* _tmp3_ = NULL;
	GraniteMessageDialog* _tmp4_;
	gboolean result;
	self = _data3_->self;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 ((GtkWindow*) self);
	_tmp3_ = granite_message_dialog_new (_data3_->primary_text, _data3_->secondary_text, (GIcon*) _tmp1_, GTK_BUTTONS_CLOSE);
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	error_dialog = _tmp4_;
	granite_message_dialog_show_error_details (error_dialog, _data3_->error_message);
	gtk_window_present ((GtkWindow*) error_dialog);
	g_signal_connect_object ((GtkDialog*) error_dialog, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) error_dialog, 0);
	result = G_SOURCE_REMOVE;
	_g_object_unref0 (error_dialog);
	return result;
}

static gboolean
___lambda31__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda31_ (self);
	return result;
}

static void
tasks_main_window_show_error_dialog (TasksMainWindow* self,
                                     const gchar* primary_text,
                                     const gchar* secondary_text,
                                     GError* e)
{
	Block3Data* _data3_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (primary_text != NULL);
	g_return_if_fail (secondary_text != NULL);
	g_return_if_fail (e != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_strdup (primary_text);
	_g_free0 (_data3_->primary_text);
	_data3_->primary_text = _tmp0_;
	_tmp1_ = g_strdup (secondary_text);
	_g_free0 (_data3_->secondary_text);
	_data3_->secondary_text = _tmp1_;
	_tmp2_ = e->message;
	_tmp3_ = g_strdup (_tmp2_);
	_data3_->error_message = _tmp3_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda31__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->source);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data5_->_data4_->self;
		_g_object_unref0 (_data5_->message_dialog);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda30_ (TasksMainWindow* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		TasksTaskModel* _tmp0_;
		_tmp0_ = tasks_application_model;
		tasks_task_model_remove_task_list_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("MainWindow.vala:315: %s", _tmp2_);
		_tmp3_ = e;
		tasks_main_window_show_error_dialog (self, _ ("Deleting the task list failed"), _ ("The task list registry may be unavailable or unable to be written to."), _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda30__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda30_ ((TasksMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
___lambda29_ (Block5Data* _data5_,
              gint response)
{
	Block4Data* _data4_;
	TasksMainWindow* self;
	GraniteMessageDialog* _tmp2_;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	if (response == ((gint) GTK_RESPONSE_YES)) {
		TasksTaskModel* _tmp0_;
		ESource* _tmp1_;
		_tmp0_ = tasks_application_model;
		_tmp1_ = _data4_->source;
		tasks_task_model_remove_task_list (_tmp0_, _tmp1_, ____lambda30__gasync_ready_callback, g_object_ref (self));
	}
	_tmp2_ = _data5_->message_dialog;
	gtk_window_destroy ((GtkWindow*) _tmp2_);
}

static void
____lambda29__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda29_ (self, response_id);
}

static void
tasks_main_window_action_delete_selected_list (TasksMainWindow* self)
{
	Block4Data* _data4_;
	TasksWidgetsSourceRow* list_row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	TasksWidgetsSourceRow* _tmp2_;
	ESource* _tmp3_;
	ESource* _tmp4_;
	ESource* _tmp5_;
	TasksTaskModel* _tmp6_;
	ESource* _tmp7_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	list_row = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow);
	_tmp2_ = list_row;
	_tmp3_ = tasks_widgets_source_row_get_source (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_data4_->source = _tmp5_;
	_tmp6_ = tasks_application_model;
	_tmp7_ = _data4_->source;
	if (tasks_task_model_is_remove_task_list_supported (_tmp6_, _tmp7_)) {
		Block5Data* _data5_;
		ESource* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GThemedIcon* _tmp13_;
		GtkWindow* _tmp14_;
		GraniteMessageDialog* _tmp15_ = NULL;
		GraniteMessageDialog* _tmp16_;
		GtkWidget* trash_button = NULL;
		GraniteMessageDialog* _tmp17_;
		GtkWidget* _tmp18_;
		GtkWidget* _tmp19_;
		GraniteMessageDialog* _tmp20_;
		GraniteMessageDialog* _tmp21_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->_data4_ = block4_data_ref (_data4_);
		_tmp8_ = _data4_->source;
		_tmp9_ = e_source_get_display_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf (_ ("Delete “%s”?"), _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = (GThemedIcon*) g_themed_icon_new ("dialog-question");
		_tmp14_ = _g_object_ref0 ((GtkWindow*) self);
		_tmp15_ = granite_message_dialog_new_with_image_from_icon_name (_tmp12_, _ ("The list and all its tasks will be permanently deleted. If you've shar" \
"ed this list, other people will no longer have access."), "edit-delete", GTK_BUTTONS_CANCEL);
		granite_message_dialog_set_badge_icon (_tmp15_, (GIcon*) _tmp13_);
		_g_object_unref0 (_tmp13_);
		gtk_window_set_transient_for ((GtkWindow*) _tmp15_, _tmp14_);
		_g_object_unref0 (_tmp14_);
		g_object_ref_sink (_tmp15_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp12_);
		_data5_->message_dialog = _tmp16_;
		_tmp17_ = _data5_->message_dialog;
		_tmp18_ = granite_dialog_add_button ((GraniteDialog*) _tmp17_, _ ("Delete Anyway"), (gint) GTK_RESPONSE_YES);
		trash_button = _tmp18_;
		_tmp19_ = trash_button;
		gtk_widget_add_css_class (_tmp19_, GRANITE_STYLE_CLASS_DESTRUCTIVE_ACTION);
		_tmp20_ = _data5_->message_dialog;
		g_signal_connect_data ((GtkDialog*) _tmp20_, "response", (GCallback) ____lambda29__gtk_dialog_response, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
		_tmp21_ = _data5_->message_dialog;
		gtk_window_present ((GtkWindow*) _tmp21_);
		block5_data_unref (_data5_);
		_data5_ = NULL;
	} else {
		GdkDisplay* _tmp22_;
		_tmp22_ = gdk_display_get_default ();
		gdk_display_beep (_tmp22_);
	}
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
tasks_main_window_header_update_func (TasksMainWindow* self,
                                      GtkListBoxRow* lbrow,
                                      GtkListBoxRow* lbbefore)
{
	TasksWidgetsSourceRow* row = NULL;
	TasksWidgetsSourceRow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GraniteHeaderLabel* header_label = NULL;
	TasksWidgetsSourceRow* _tmp14_;
	ESource* _tmp15_;
	ESource* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GraniteHeaderLabel* _tmp19_ = NULL;
	GraniteHeaderLabel* _tmp20_;
	TasksWidgetsSourceRow* _tmp21_;
	GraniteHeaderLabel* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lbrow != NULL);
	if (!TASKS_WIDGETS_IS_SOURCE_ROW (lbrow)) {
		return;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbrow, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow));
	row = _tmp0_;
	if (lbbefore != NULL) {
		_tmp1_ = TASKS_WIDGETS_IS_SOURCE_ROW (lbbefore);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		TasksWidgetsSourceRow* before = NULL;
		TasksWidgetsSourceRow* _tmp2_;
		TasksWidgetsSourceRow* _tmp3_;
		ESource* _tmp4_;
		ESource* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		TasksWidgetsSourceRow* _tmp8_;
		ESource* _tmp9_;
		ESource* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbbefore, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow));
		before = _tmp2_;
		_tmp3_ = row;
		_tmp4_ = tasks_widgets_source_row_get_source (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = e_source_get_parent (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = before;
		_tmp9_ = tasks_widgets_source_row_get_source (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = e_source_get_parent (_tmp10_);
		_tmp12_ = _tmp11_;
		if (g_strcmp0 (_tmp7_, _tmp12_) == 0) {
			TasksWidgetsSourceRow* _tmp13_;
			_tmp13_ = row;
			gtk_list_box_row_set_header ((GtkListBoxRow*) _tmp13_, NULL);
			_g_object_unref0 (before);
			_g_object_unref0 (row);
			return;
		}
		_g_object_unref0 (before);
	}
	_tmp14_ = row;
	_tmp15_ = tasks_widgets_source_row_get_source (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = tasks_util_get_esource_collection_display_name (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = granite_header_label_new (_tmp18_);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp19_, 6);
	g_object_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	header_label = _tmp20_;
	_tmp21_ = row;
	_tmp22_ = header_label;
	gtk_list_box_row_set_header ((GtkListBoxRow*) _tmp21_, (GtkWidget*) _tmp22_);
	_g_object_unref0 (header_label);
	_g_object_unref0 (row);
}

static gint
tasks_main_window_sort_function (GtkListBoxRow* lbrow,
                                 GtkListBoxRow* lbbefore,
                                 TasksMainWindow* self)
{
	TasksWidgetsSourceRow* row = NULL;
	TasksWidgetsSourceRow* _tmp0_;
	TasksWidgetsSourceRow* before = NULL;
	TasksWidgetsSourceRow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	TasksWidgetsSourceRow* _tmp3_;
	ESource* _tmp4_;
	ESource* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (lbrow != NULL, 0);
	g_return_val_if_fail (lbbefore != NULL, 0);
	if (!TASKS_WIDGETS_IS_SOURCE_ROW (lbrow)) {
		result = -1;
		return result;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbrow, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow));
	row = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbbefore, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow));
	before = _tmp1_;
	_tmp3_ = row;
	_tmp4_ = tasks_widgets_source_row_get_source (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = e_source_get_parent (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		TasksWidgetsSourceRow* _tmp8_;
		ESource* _tmp9_;
		ESource* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp8_ = before;
		_tmp9_ = tasks_widgets_source_row_get_source (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = e_source_get_parent (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp2_ = _tmp12_ == NULL;
	}
	if (_tmp2_) {
		result = -1;
		_g_object_unref0 (before);
		_g_object_unref0 (row);
		return result;
	} else {
		TasksWidgetsSourceRow* _tmp13_;
		ESource* _tmp14_;
		ESource* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		TasksWidgetsSourceRow* _tmp18_;
		ESource* _tmp19_;
		ESource* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp13_ = row;
		_tmp14_ = tasks_widgets_source_row_get_source (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = e_source_get_parent (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = before;
		_tmp19_ = tasks_widgets_source_row_get_source (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = e_source_get_parent (_tmp20_);
		_tmp22_ = _tmp21_;
		if (g_strcmp0 (_tmp17_, _tmp22_) == 0) {
			TasksWidgetsSourceRow* _tmp23_;
			ESource* _tmp24_;
			ESource* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			TasksWidgetsSourceRow* _tmp28_;
			ESource* _tmp29_;
			ESource* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			_tmp23_ = row;
			_tmp24_ = tasks_widgets_source_row_get_source (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = e_source_get_display_name (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = before;
			_tmp29_ = tasks_widgets_source_row_get_source (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = e_source_get_display_name (_tmp30_);
			_tmp32_ = _tmp31_;
			result = g_utf8_collate (_tmp27_, _tmp32_);
			_g_object_unref0 (before);
			_g_object_unref0 (row);
			return result;
		} else {
			TasksWidgetsSourceRow* _tmp33_;
			ESource* _tmp34_;
			ESource* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			TasksWidgetsSourceRow* _tmp38_;
			ESource* _tmp39_;
			ESource* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			_tmp33_ = row;
			_tmp34_ = tasks_widgets_source_row_get_source (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = e_source_get_parent (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = before;
			_tmp39_ = tasks_widgets_source_row_get_source (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = e_source_get_parent (_tmp40_);
			_tmp42_ = _tmp41_;
			result = g_utf8_collate (_tmp37_, _tmp42_);
			_g_object_unref0 (before);
			_g_object_unref0 (row);
			return result;
		}
	}
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->collection_source);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static guint
_tasks_util_esource_hash_func_gee_hash_data_func (gconstpointer v,
                                                  gpointer self)
{
	guint result;
	result = tasks_util_esource_hash_func ((ESource*) v);
	return result;
}

static gboolean
_tasks_util_esource_equal_func_gee_equal_data_func (gconstpointer a,
                                                    gconstpointer b,
                                                    gpointer self)
{
	gboolean result;
	result = tasks_util_esource_equal_func ((ESource*) a, (ESource*) b);
	return result;
}

static void
__lambda117_ (Block6Data* _data6_)
{
	TasksMainWindow* self;
	GtkPopover* _tmp0_;
	self = _data6_->self;
	_tmp0_ = self->priv->add_tasklist_popover;
	gtk_popover_popdown (_tmp0_);
	tasks_main_window_add_new_list (self, _data6_->collection_source);
}

static void
___lambda117__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda117_ (self);
}

static void
tasks_main_window_add_collection_source (TasksMainWindow* self,
                                         ESource* collection_source)
{
	Block6Data* _data6_;
	ESource* _tmp0_;
	GeeCollection* _tmp1_;
	ESourceTaskList* collection_source_tasklist_extension = NULL;
	ESourceExtension* _tmp3_;
	ESourceTaskList* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp13_;
	TasksPopoverMenuitem* source_button = NULL;
	gchar* _tmp14_;
	TasksTaskModel* _tmp15_;
	TasksPopoverMenuitem* _tmp16_ = NULL;
	TasksPopoverMenuitem* _tmp17_;
	GtkBox* _tmp18_;
	TasksPopoverMenuitem* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (collection_source != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (collection_source);
	_g_object_unref0 (_data6_->collection_source);
	_data6_->collection_source = _tmp0_;
	_tmp1_ = self->priv->collection_sources;
	if (_tmp1_ == NULL) {
		GeeHashSet* _tmp2_;
		_tmp2_ = gee_hash_set_new (e_source_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tasks_util_esource_hash_func_gee_hash_data_func, NULL, NULL, _tasks_util_esource_equal_func_gee_equal_data_func, NULL, NULL);
		_g_object_unref0 (self->priv->collection_sources);
		self->priv->collection_sources = (GeeCollection*) _tmp2_;
	}
	_tmp3_ = e_source_get_extension (_data6_->collection_source, E_SOURCE_EXTENSION_TASK_LIST);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, e_source_task_list_get_type (), ESourceTaskList));
	collection_source_tasklist_extension = _tmp4_;
	_tmp7_ = self->priv->collection_sources;
	if (gee_collection_contains (_tmp7_, _data6_->collection_source)) {
		_tmp6_ = TRUE;
	} else {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = e_source_get_enabled (_data6_->collection_source);
		_tmp9_ = _tmp8_;
		_tmp6_ = !_tmp9_;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		ESourceTaskList* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp10_ = collection_source_tasklist_extension;
		_tmp11_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp5_ = !_tmp12_;
	}
	if (_tmp5_) {
		_g_object_unref0 (collection_source_tasklist_extension);
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return;
	}
	_tmp13_ = self->priv->collection_sources;
	gee_collection_add (_tmp13_, _data6_->collection_source);
	_tmp14_ = tasks_util_get_esource_collection_display_name (_data6_->collection_source);
	_tmp15_ = tasks_application_model;
	_tmp16_ = tasks_popover_menuitem_new ();
	tasks_popover_menuitem_set_text (_tmp16_, _tmp14_);
	_g_free0 (_tmp14_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, tasks_task_model_is_add_task_list_supported (_tmp15_, _data6_->collection_source));
	g_object_ref_sink (_tmp16_);
	source_button = _tmp16_;
	_tmp17_ = source_button;
	g_signal_connect_data ((GtkButton*) _tmp17_, "clicked", (GCallback) ___lambda117__gtk_button_clicked, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp18_ = self->priv->add_tasklist_buttonbox;
	_tmp19_ = source_button;
	gtk_box_append (_tmp18_, (GtkWidget*) _tmp19_);
	_g_object_unref0 (source_button);
	_g_object_unref0 (collection_source_tasklist_extension);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static gboolean
___lambda118_ (TasksMainWindow* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->listbox;
	gtk_list_box_invalidate_sort (_tmp0_);
	_tmp1_ = self->priv->listbox;
	gtk_list_box_invalidate_headers (_tmp1_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda118__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda118_ ((TasksMainWindow*) self);
	return result;
}

static void
tasks_main_window_add_source (TasksMainWindow* self,
                              ESource* source)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GeeHashMap* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->source_rows;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (e_source_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TASKS_WIDGETS_TYPE_SOURCE_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->source_rows);
		self->priv->source_rows = _tmp1_;
	}
	_tmp2_ = e_source_dup_display_name (source);
	_tmp3_ = _tmp2_;
	g_debug ("MainWindow.vala:400: Adding row '%s'", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->source_rows;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, source)) {
		GeeHashMap* _tmp5_;
		TasksWidgetsSourceRow* _tmp6_;
		TasksWidgetsSourceRow* _tmp7_;
		GtkListBox* _tmp8_;
		GeeHashMap* _tmp9_;
		gpointer _tmp10_;
		TasksWidgetsSourceRow* _tmp11_;
		_tmp5_ = self->priv->source_rows;
		_tmp6_ = tasks_widgets_source_row_new (source);
		g_object_ref_sink (_tmp6_);
		_tmp7_ = _tmp6_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, source, _tmp7_);
		_g_object_unref0 (_tmp7_);
		_tmp8_ = self->priv->listbox;
		_tmp9_ = self->priv->source_rows;
		_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, source);
		_tmp11_ = (TasksWidgetsSourceRow*) _tmp10_;
		gtk_list_box_append (_tmp8_, (GtkWidget*) _tmp11_);
		_g_object_unref0 (_tmp11_);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda118__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static gboolean
____lambda120_ (TasksMainWindow* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->listbox;
	gtk_list_box_invalidate_sort (_tmp0_);
	_tmp1_ = self->priv->listbox;
	gtk_list_box_invalidate_headers (_tmp1_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
_____lambda120__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda120_ ((TasksMainWindow*) self);
	return result;
}

static void
tasks_main_window_update_source (TasksMainWindow* self,
                                 ESource* source)
{
	ESourceTaskList* list = NULL;
	ESourceExtension* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ESourceTaskList* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = e_source_get_extension (source, E_SOURCE_EXTENSION_TASK_LIST);
	list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_task_list_get_type (), ESourceTaskList);
	_tmp2_ = list;
	_tmp3_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != TRUE) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = e_source_get_enabled (source);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_ != TRUE;
	}
	if (_tmp1_) {
		tasks_main_window_remove_source (self, source);
	} else {
		GeeHashMap* _tmp7_;
		_tmp7_ = self->priv->source_rows;
		if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp7_, source)) {
			tasks_main_window_add_source (self, source);
		} else {
			GeeHashMap* _tmp8_;
			gpointer _tmp9_;
			TasksWidgetsSourceRow* _tmp10_;
			TasksListView* list_view = NULL;
			GtkStack* _tmp11_;
			GtkWidget* _tmp12_;
			TasksListView* _tmp13_;
			_tmp8_ = self->priv->source_rows;
			_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, source);
			_tmp10_ = (TasksWidgetsSourceRow*) _tmp9_;
			tasks_widgets_source_row_update_request (_tmp10_);
			_g_object_unref0 (_tmp10_);
			_tmp11_ = self->priv->list_view_stack;
			_tmp12_ = gtk_stack_get_visible_child (_tmp11_);
			list_view = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TASKS_TYPE_LIST_VIEW, TasksListView);
			_tmp13_ = list_view;
			if (_tmp13_ != NULL) {
				TasksListView* _tmp14_;
				_tmp14_ = list_view;
				tasks_list_view_update_request (_tmp14_);
			}
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda120__gsource_func, g_object_ref (self), g_object_unref);
		}
	}
}

static gboolean
__lambda119_ (TasksMainWindow* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->listbox;
	gtk_list_box_invalidate_sort (_tmp0_);
	_tmp1_ = self->priv->listbox;
	gtk_list_box_invalidate_headers (_tmp1_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda119__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda119_ ((TasksMainWindow*) self);
	return result;
}

static void
tasks_main_window_remove_source (TasksMainWindow* self,
                                 ESource* source)
{
	GtkListBox* _tmp0_;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	TasksWidgetsSourceRow* _tmp3_;
	GeeHashMap* _tmp4_;
	gpointer _tmp5_;
	TasksWidgetsSourceRow* _tmp6_;
	GeeHashMap* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = self->priv->source_rows;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, source);
	_tmp3_ = (TasksWidgetsSourceRow*) _tmp2_;
	gtk_list_box_unselect_row (_tmp0_, (GtkListBoxRow*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->source_rows;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, source);
	_tmp6_ = (TasksWidgetsSourceRow*) _tmp5_;
	tasks_widgets_source_row_remove_request (_tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->source_rows;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, source, NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda119__gsource_func, g_object_ref (self), g_object_unref);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->scheduled_row);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gint
_tasks_main_window_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                         GtkListBoxRow* row2,
                                                         gpointer self)
{
	gint result;
	result = tasks_main_window_sort_function (row1, row2, (TasksMainWindow*) self);
	return result;
}

static void
__lambda122_ (TasksMainWindow* self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
___lambda122__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda122_ ((TasksMainWindow*) self);
	g_object_unref (self);
}

static gboolean
_tasks_main_window___lambda121_ (TasksMainWindow* self)
{
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	gboolean result;
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	tasks_application_request_background (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TASKS_TYPE_APPLICATION, TasksApplication), ___lambda122__gasync_ready_callback, g_object_ref (self));
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__tasks_main_window___lambda121__gtk_window_close_request (GtkWindow* _sender,
                                                           gpointer self)
{
	gboolean result;
	result = _tasks_main_window___lambda121_ ((TasksMainWindow*) self);
	return result;
}

static void
_tasks_main_window___lambda123_ (TasksMainWindow* self)
{
	GtkPopover* _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = self->priv->add_tasklist_popover;
	gtk_popover_popdown (_tmp0_);
	{
		g_app_info_launch_default_for_uri ("settings://accounts/online", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("MainWindow.vala:135: Failed to open account settings: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__tasks_main_window___lambda123__gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	_tasks_main_window___lambda123_ ((TasksMainWindow*) self);
}

static void
_tasks_main_window_add_source_tasks_task_model_task_list_added (TasksTaskModel* _sender,
                                                                ESource* task_list,
                                                                gpointer self)
{
	tasks_main_window_add_source ((TasksMainWindow*) self, task_list);
}

static void
_tasks_main_window_update_source_tasks_task_model_task_list_modified (TasksTaskModel* _sender,
                                                                      ESource* task_list,
                                                                      gpointer self)
{
	tasks_main_window_update_source ((TasksMainWindow*) self, task_list);
}

static void
_tasks_main_window_remove_source_tasks_task_model_task_list_removed (TasksTaskModel* _sender,
                                                                     ESource* task_list,
                                                                     gpointer self)
{
	tasks_main_window_remove_source ((TasksMainWindow*) self, task_list);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data8_->_data7_->self;
		_g_free0 (_data8_->last_selected_list);
		block7_data_unref (_data8_->_data7_);
		_data8_->_data7_ = NULL;
		g_slice_free (Block8Data, _data8_);
	}
}

static void
_tasks_main_window_header_update_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                       GtkListBoxRow* before,
                                                                       gpointer self)
{
	tasks_main_window_header_update_func ((TasksMainWindow*) self, row, before);
}

static void
_tasks_main_window_on_listbox_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                      GtkListBoxRow* row,
                                                                      gpointer self)
{
	tasks_main_window_on_listbox_row_selected ((TasksMainWindow*) self, row);
}

static void
__lambda125_ (TasksMainWindow* self,
              ESource* collection_source)
{
	g_return_if_fail (collection_source != NULL);
	tasks_main_window_add_collection_source (self, collection_source);
}

static void
___lambda125__gfunc (gconstpointer data,
                     gpointer self)
{
	__lambda125_ ((TasksMainWindow*) self, (ESource*) data);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data9_->_data8_->_data7_->self;
		_g_object_unref0 (_data9_->default_task_list);
		block8_data_unref (_data9_->_data8_);
		_data9_->_data8_ = NULL;
		g_slice_free (Block9Data, _data9_);
	}
}

static void
___lambda126_ (Block9Data* _data9_,
               ESource* source)
{
	Block8Data* _data8_;
	Block7Data* _data7_;
	TasksMainWindow* self;
	ESourceTaskList* list = NULL;
	ESourceExtension* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ESourceTaskList* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	_data8_ = _data9_->_data8_;
	_data7_ = _data8_->_data7_;
	self = _data7_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = e_source_get_extension (source, E_SOURCE_EXTENSION_TASK_LIST);
	list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_task_list_get_type (), ESourceTaskList);
	_tmp3_ = list;
	_tmp4_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == TRUE) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = e_source_get_enabled (source);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ == TRUE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = !e_source_has_extension (source, E_SOURCE_EXTENSION_COLLECTION);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp9_;
		tasks_main_window_add_source (self, source);
		_tmp9_ = _data8_->last_selected_list;
		if (g_strcmp0 (_tmp9_, "") == 0) {
			ESource* _tmp10_;
			_tmp10_ = _data9_->default_task_list;
			_tmp8_ = _tmp10_ == source;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			GeeHashMap* _tmp11_;
			gpointer _tmp12_;
			TasksWidgetsSourceRow* _tmp13_;
			GtkListBox* _tmp14_;
			GeeHashMap* _tmp15_;
			gpointer _tmp16_;
			TasksWidgetsSourceRow* _tmp17_;
			_tmp11_ = self->priv->source_rows;
			_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, source);
			_tmp13_ = (TasksWidgetsSourceRow*) _tmp12_;
			_vala_assert (_tmp13_ != NULL, "source_rows[source] != null");
			_g_object_unref0 (_tmp13_);
			_tmp14_ = self->priv->listbox;
			_tmp15_ = self->priv->source_rows;
			_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, source);
			_tmp17_ = (TasksWidgetsSourceRow*) _tmp16_;
			gtk_list_box_select_row (_tmp14_, (GtkListBoxRow*) _tmp17_);
			_g_object_unref0 (_tmp17_);
		} else {
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = _data8_->last_selected_list;
			_tmp19_ = e_source_get_uid (source);
			_tmp20_ = _tmp19_;
			if (g_strcmp0 (_tmp18_, _tmp20_) == 0) {
				GeeHashMap* _tmp21_;
				gpointer _tmp22_;
				TasksWidgetsSourceRow* _tmp23_;
				GtkListBox* _tmp24_;
				GeeHashMap* _tmp25_;
				gpointer _tmp26_;
				TasksWidgetsSourceRow* _tmp27_;
				_tmp21_ = self->priv->source_rows;
				_tmp22_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp21_, source);
				_tmp23_ = (TasksWidgetsSourceRow*) _tmp22_;
				_vala_assert (_tmp23_ != NULL, "source_rows[source] != null");
				_g_object_unref0 (_tmp23_);
				_tmp24_ = self->priv->listbox;
				_tmp25_ = self->priv->source_rows;
				_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp25_, source);
				_tmp27_ = (TasksWidgetsSourceRow*) _tmp26_;
				gtk_list_box_select_row (_tmp24_, (GtkListBoxRow*) _tmp27_);
				_g_object_unref0 (_tmp27_);
			}
		}
	}
}

static void
____lambda126__gfunc (gconstpointer data,
                      gpointer self)
{
	___lambda126_ (self, (ESource*) data);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_tasks_main_window___lambda124_ (Block7Data* _data7_,
                                 GObject* obj,
                                 GAsyncResult* res)
{
	TasksMainWindow* self;
	Block8Data* _data8_;
	ESourceRegistry* registry = NULL;
	GtkListBox* _tmp6_;
	GtkListBox* _tmp7_;
	ESourceRegistry* _tmp8_;
	ESource* _tmp9_;
	ESource* _tmp10_;
	GList* task_list_collections = NULL;
	ESourceRegistry* _tmp11_;
	GList* _tmp12_;
	GList* _tmp13_;
	GSettings* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
	self = _data7_->self;
	g_return_if_fail (res != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->_data7_ = block7_data_ref (_data7_);
	{
		ESourceRegistry* _tmp0_ = NULL;
		TasksTaskModel* _tmp1_;
		ESourceRegistry* _tmp2_;
		ESourceRegistry* _tmp3_;
		_tmp1_ = tasks_application_model;
		_tmp2_ = tasks_task_model_get_registry_finish (_tmp1_, res, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (registry);
		registry = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("MainWindow.vala:150: %s", _tmp5_);
		_g_error_free0 (e);
		_g_object_unref0 (registry);
		block8_data_unref (_data8_);
		_data8_ = NULL;
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (registry);
		block8_data_unref (_data8_);
		_data8_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp6_ = self->priv->listbox;
	gtk_list_box_set_header_func (_tmp6_, _tasks_main_window_header_update_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp7_ = self->priv->listbox;
	g_signal_connect_object (_tmp7_, "row-selected", (GCallback) _tasks_main_window_on_listbox_row_selected_gtk_list_box_row_selected, self, 0);
	_tmp8_ = registry;
	_tmp9_ = e_source_registry_ref_builtin_task_list (_tmp8_);
	_tmp10_ = _tmp9_;
	tasks_main_window_add_collection_source (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = registry;
	_tmp12_ = e_source_registry_list_sources (_tmp11_, E_SOURCE_EXTENSION_COLLECTION);
	task_list_collections = _tmp12_;
	_tmp13_ = task_list_collections;
	g_list_foreach (_tmp13_, ___lambda125__gfunc, self);
	_tmp14_ = tasks_application_settings;
	_tmp15_ = g_settings_get_string (_tmp14_, "selected-list");
	_data8_->last_selected_list = _tmp15_;
	_tmp16_ = _data8_->last_selected_list;
	if (g_strcmp0 (_tmp16_, TASKS_MAIN_WINDOW_SCHEDULED_LIST_UID) == 0) {
		GtkListBox* _tmp17_;
		TasksWidgetsScheduledRow* _tmp18_;
		GtkListBox* _tmp19_;
		TasksWidgetsScheduledRow* _tmp20_;
		_tmp17_ = self->priv->listbox;
		_tmp18_ = _data7_->scheduled_row;
		gtk_list_box_select_row (_tmp17_, (GtkListBoxRow*) _tmp18_);
		_tmp19_ = self->priv->listbox;
		_tmp20_ = _data7_->scheduled_row;
		g_signal_emit_by_name (_tmp19_, "row-selected", (GtkListBoxRow*) _tmp20_);
	} else {
		Block9Data* _data9_;
		ESourceRegistry* _tmp21_;
		ESource* _tmp22_;
		ESource* _tmp23_;
		GList* task_lists = NULL;
		ESourceRegistry* _tmp24_;
		GList* _tmp25_;
		GList* _tmp26_;
		_data9_ = g_slice_new0 (Block9Data);
		_data9_->_ref_count_ = 1;
		_data9_->_data8_ = block8_data_ref (_data8_);
		_tmp21_ = registry;
		g_object_get (_tmp21_, "default-task-list", &_tmp22_, NULL);
		_tmp23_ = _tmp22_;
		_data9_->default_task_list = _tmp23_;
		_tmp24_ = registry;
		_tmp25_ = e_source_registry_list_sources (_tmp24_, E_SOURCE_EXTENSION_TASK_LIST);
		task_lists = _tmp25_;
		_tmp26_ = task_lists;
		g_list_foreach (_tmp26_, ____lambda126__gfunc, _data9_);
		(task_lists == NULL) ? NULL : (task_lists = (_g_list_free__g_object_unref0_ (task_lists), NULL));
		block9_data_unref (_data9_);
		_data9_ = NULL;
	}
	(task_list_collections == NULL) ? NULL : (task_list_collections = (_g_list_free__g_object_unref0_ (task_list_collections), NULL));
	_g_object_unref0 (registry);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
__tasks_main_window___lambda124__gasync_ready_callback (GObject* source_object,
                                                        GAsyncResult* res,
                                                        gpointer self)
{
	_tasks_main_window___lambda124_ (self, source_object, res);
	block7_data_unref (self);
}

static GObject *
tasks_main_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TasksMainWindow * self;
	Block7Data* _data7_;
	GtkApplication* application_instance = NULL;
	GApplication* _tmp0_;
	AdwHeaderBar* sidebar_header = NULL;
	AdwHeaderBar* _tmp20_ = NULL;
	GtkListBox* _tmp21_;
	GtkListBox* _tmp22_;
	TasksWidgetsScheduledRow* _tmp23_;
	GtkListBox* _tmp24_;
	TasksWidgetsScheduledRow* _tmp25_;
	GtkScrolledWindow* scrolledwindow = NULL;
	GtkListBox* _tmp26_;
	GtkWidget* _tmp27_;
	GtkScrolledWindow* _tmp28_ = NULL;
	GtkBox* _tmp29_;
	TasksPopoverMenuitem* online_accounts_button = NULL;
	gchar* _tmp30_;
	TasksPopoverMenuitem* _tmp31_ = NULL;
	GtkBox* add_tasklist_box = NULL;
	GtkBox* _tmp32_;
	GtkBox* _tmp33_;
	GtkBox* _tmp34_;
	GtkBox* _tmp35_;
	GtkSeparator* _tmp36_;
	GtkSeparator* _tmp37_;
	GtkBox* _tmp38_;
	TasksPopoverMenuitem* _tmp39_;
	GtkBox* _tmp40_;
	GtkWidget* _tmp41_;
	GtkPopover* _tmp42_ = NULL;
	GtkPopover* _tmp43_;
	GtkLabel* add_list_label = NULL;
	GtkLabel* _tmp44_;
	GtkBox* add_list_button_box = NULL;
	GtkBox* _tmp45_;
	GtkBox* _tmp46_;
	GtkImage* _tmp47_;
	GtkImage* _tmp48_;
	GtkBox* _tmp49_;
	GtkLabel* _tmp50_;
	GtkMenuButton* add_tasklist_button = NULL;
	GtkBox* _tmp51_;
	GtkWidget* _tmp52_;
	GtkPopover* _tmp53_;
	GtkPopover* _tmp54_;
	GtkMenuButton* _tmp55_ = NULL;
	GtkLabel* _tmp56_;
	GtkMenuButton* _tmp57_;
	GtkActionBar* actionbar = NULL;
	GtkActionBar* _tmp58_;
	GtkActionBar* _tmp59_;
	GtkMenuButton* _tmp60_;
	AdwToolbarView* sidebar = NULL;
	GtkScrolledWindow* _tmp61_;
	GtkWidget* _tmp62_;
	AdwToolbarView* _tmp63_ = NULL;
	AdwToolbarView* _tmp64_;
	AdwHeaderBar* _tmp65_;
	AdwToolbarView* _tmp66_;
	GtkActionBar* _tmp67_;
	AdwToolbarView* _tmp68_;
	GtkStack* _tmp69_;
	GtkPaned* paned = NULL;
	AdwToolbarView* _tmp70_;
	GtkWidget* _tmp71_;
	GtkStack* _tmp72_;
	GtkWidget* _tmp73_;
	GtkPaned* _tmp74_ = NULL;
	GtkPaned* _tmp75_;
	GtkGrid* _tmp76_ = NULL;
	GtkGrid* _tmp77_;
	TasksPopoverMenuitem* _tmp78_;
	GSettings* _tmp79_;
	GtkPaned* _tmp80_;
	TasksTaskModel* _tmp81_;
	TasksTaskModel* _tmp82_;
	TasksTaskModel* _tmp83_;
	TasksTaskModel* _tmp84_;
	parent_class = G_OBJECT_CLASS (tasks_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_TYPE_MAIN_WINDOW, TasksMainWindow);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	g_action_map_add_action_entries ((GActionMap*) self, TASKS_MAIN_WINDOW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (TASKS_MAIN_WINDOW_ACTION_ENTRIES), self);
	_tmp0_ = g_application_get_default ();
	application_instance = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication);
	{
		GeeIterator* _action_it = NULL;
		GeeMultiMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp1_ = tasks_main_window_action_accelerators;
		_tmp2_ = gee_multi_map_get_keys (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_action_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gchar* action = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GtkApplication* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GeeMultiMap* _tmp13_;
			const gchar* _tmp14_;
			GeeCollection* _tmp15_;
			GeeCollection* _tmp16_;
			gint _tmp17_ = 0;
			gpointer* _tmp18_;
			gchar** _tmp19_;
			gint _tmp19__length1;
			_tmp6_ = _action_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _action_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			action = (gchar*) _tmp8_;
			_tmp9_ = application_instance;
			_tmp10_ = action;
			_tmp11_ = g_strconcat (TASKS_MAIN_WINDOW_ACTION_PREFIX, _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = tasks_main_window_action_accelerators;
			_tmp14_ = action;
			_tmp15_ = gee_multi_map_get (_tmp13_, _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp18_ = gee_collection_to_array (_tmp16_, &_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp19__length1 = _tmp17_;
			gtk_application_set_accels_for_action (_tmp9_, _tmp12_, _tmp19_);
			_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_tmp16_);
			_g_free0 (_tmp12_);
			_g_free0 (action);
		}
		_g_object_unref0 (_action_it);
	}
	_tmp20_ = (AdwHeaderBar*) adw_header_bar_new ();
	adw_header_bar_set_show_end_title_buttons (_tmp20_, FALSE);
	adw_header_bar_set_show_title (_tmp20_, FALSE);
	g_object_ref_sink (_tmp20_);
	sidebar_header = _tmp20_;
	_tmp21_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->listbox);
	self->priv->listbox = _tmp21_;
	_tmp22_ = self->priv->listbox;
	gtk_list_box_set_sort_func (_tmp22_, _tasks_main_window_sort_function_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp23_ = tasks_widgets_scheduled_row_new ();
	g_object_ref_sink (_tmp23_);
	_data7_->scheduled_row = _tmp23_;
	_tmp24_ = self->priv->listbox;
	_tmp25_ = _data7_->scheduled_row;
	gtk_list_box_append (_tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->listbox;
	_tmp27_ = _g_object_ref0 ((GtkWidget*) _tmp26_);
	_tmp28_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp28_, _tmp27_);
	_g_object_unref0 (_tmp27_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp28_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp28_, TRUE);
	g_object_set (_tmp28_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp28_);
	scrolledwindow = _tmp28_;
	_tmp29_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->add_tasklist_buttonbox);
	self->priv->add_tasklist_buttonbox = _tmp29_;
	_tmp30_ = g_strdup (_ ("Online Accounts Settings…"));
	_tmp31_ = tasks_popover_menuitem_new ();
	tasks_popover_menuitem_set_text (_tmp31_, _tmp30_);
	_g_free0 (_tmp30_);
	g_object_ref_sink (_tmp31_);
	online_accounts_button = _tmp31_;
	_tmp32_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp32_);
	add_tasklist_box = _tmp32_;
	_tmp33_ = add_tasklist_box;
	_tmp34_ = self->priv->add_tasklist_buttonbox;
	gtk_box_append (_tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = add_tasklist_box;
	_tmp36_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp36_);
	_tmp37_ = _tmp36_;
	gtk_box_append (_tmp35_, (GtkWidget*) _tmp37_);
	_g_object_unref0 (_tmp37_);
	_tmp38_ = add_tasklist_box;
	_tmp39_ = online_accounts_button;
	gtk_box_append (_tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = add_tasklist_box;
	_tmp41_ = _g_object_ref0 ((GtkWidget*) _tmp40_);
	_tmp42_ = (GtkPopover*) gtk_popover_new ();
	gtk_popover_set_child (_tmp42_, _tmp41_);
	_g_object_unref0 (_tmp41_);
	g_object_ref_sink (_tmp42_);
	_g_object_unref0 (self->priv->add_tasklist_popover);
	self->priv->add_tasklist_popover = _tmp42_;
	_tmp43_ = self->priv->add_tasklist_popover;
	gtk_widget_add_css_class ((GtkWidget*) _tmp43_, GRANITE_STYLE_CLASS_MENU);
	_tmp44_ = (GtkLabel*) gtk_label_new (_ ("Add Task List…"));
	g_object_ref_sink (_tmp44_);
	add_list_label = _tmp44_;
	_tmp45_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp45_);
	add_list_button_box = _tmp45_;
	_tmp46_ = add_list_button_box;
	_tmp47_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic");
	g_object_ref_sink (_tmp47_);
	_tmp48_ = _tmp47_;
	gtk_box_append (_tmp46_, (GtkWidget*) _tmp48_);
	_g_object_unref0 (_tmp48_);
	_tmp49_ = add_list_button_box;
	_tmp50_ = add_list_label;
	gtk_box_append (_tmp49_, (GtkWidget*) _tmp50_);
	_tmp51_ = add_list_button_box;
	_tmp52_ = _g_object_ref0 ((GtkWidget*) _tmp51_);
	_tmp53_ = self->priv->add_tasklist_popover;
	_tmp54_ = _g_object_ref0 (_tmp53_);
	_tmp55_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_menu_button_set_child (_tmp55_, _tmp52_);
	_g_object_unref0 (_tmp52_);
	gtk_menu_button_set_has_frame (_tmp55_, FALSE);
	gtk_menu_button_set_popover (_tmp55_, _tmp54_);
	_g_object_unref0 (_tmp54_);
	gtk_menu_button_set_direction (_tmp55_, GTK_ARROW_UP);
	g_object_ref_sink (_tmp55_);
	add_tasklist_button = _tmp55_;
	_tmp56_ = add_list_label;
	_tmp57_ = add_tasklist_button;
	gtk_label_set_mnemonic_widget (_tmp56_, (GtkWidget*) _tmp57_);
	_tmp58_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp58_);
	actionbar = _tmp58_;
	_tmp59_ = actionbar;
	_tmp60_ = add_tasklist_button;
	gtk_action_bar_pack_start (_tmp59_, (GtkWidget*) _tmp60_);
	_tmp61_ = scrolledwindow;
	_tmp62_ = _g_object_ref0 ((GtkWidget*) _tmp61_);
	_tmp63_ = (AdwToolbarView*) adw_toolbar_view_new ();
	adw_toolbar_view_set_content (_tmp63_, _tmp62_);
	_g_object_unref0 (_tmp62_);
	adw_toolbar_view_set_bottom_bar_style (_tmp63_, ADW_TOOLBAR_RAISED);
	g_object_ref_sink (_tmp63_);
	sidebar = _tmp63_;
	_tmp64_ = sidebar;
	_tmp65_ = sidebar_header;
	adw_toolbar_view_add_top_bar (_tmp64_, (GtkWidget*) _tmp65_);
	_tmp66_ = sidebar;
	_tmp67_ = actionbar;
	adw_toolbar_view_add_bottom_bar (_tmp66_, (GtkWidget*) _tmp67_);
	_tmp68_ = sidebar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp68_, GRANITE_STYLE_CLASS_SIDEBAR);
	_tmp69_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp69_);
	_g_object_unref0 (self->priv->list_view_stack);
	self->priv->list_view_stack = _tmp69_;
	_tmp70_ = sidebar;
	_tmp71_ = _g_object_ref0 ((GtkWidget*) _tmp70_);
	_tmp72_ = self->priv->list_view_stack;
	_tmp73_ = _g_object_ref0 ((GtkWidget*) _tmp72_);
	_tmp74_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_paned_set_start_child (_tmp74_, _tmp71_);
	_g_object_unref0 (_tmp71_);
	gtk_paned_set_end_child (_tmp74_, _tmp73_);
	_g_object_unref0 (_tmp73_);
	gtk_paned_set_resize_start_child (_tmp74_, FALSE);
	gtk_paned_set_shrink_end_child (_tmp74_, FALSE);
	gtk_paned_set_shrink_start_child (_tmp74_, FALSE);
	g_object_ref_sink (_tmp74_);
	paned = _tmp74_;
	_tmp75_ = paned;
	gtk_window_set_child ((GtkWindow*) self, (GtkWidget*) _tmp75_);
	_tmp76_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_visible ((GtkWidget*) _tmp76_, FALSE);
	g_object_ref_sink (_tmp76_);
	_tmp77_ = _tmp76_;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp77_);
	_g_object_unref0 (_tmp77_);
	g_signal_connect_object ((GtkWindow*) self, "close-request", (GCallback) __tasks_main_window___lambda121__gtk_window_close_request, self, 0);
	_tmp78_ = online_accounts_button;
	g_signal_connect_object ((GtkButton*) _tmp78_, "clicked", (GCallback) __tasks_main_window___lambda123__gtk_button_clicked, self, 0);
	_tmp79_ = tasks_application_settings;
	_tmp80_ = paned;
	g_settings_bind (_tmp79_, "pane-position", (GObject*) _tmp80_, "position", G_SETTINGS_BIND_DEFAULT);
	_tmp81_ = tasks_application_model;
	g_signal_connect_object (_tmp81_, "task-list-added", (GCallback) _tasks_main_window_add_source_tasks_task_model_task_list_added, self, 0);
	_tmp82_ = tasks_application_model;
	g_signal_connect_object (_tmp82_, "task-list-modified", (GCallback) _tasks_main_window_update_source_tasks_task_model_task_list_modified, self, 0);
	_tmp83_ = tasks_application_model;
	g_signal_connect_object (_tmp83_, "task-list-removed", (GCallback) _tasks_main_window_remove_source_tasks_task_model_task_list_removed, self, 0);
	_tmp84_ = tasks_application_model;
	tasks_task_model_get_registry (_tmp84_, __tasks_main_window___lambda124__gasync_ready_callback, block7_data_ref (_data7_));
	_g_object_unref0 (paned);
	_g_object_unref0 (sidebar);
	_g_object_unref0 (actionbar);
	_g_object_unref0 (add_tasklist_button);
	_g_object_unref0 (add_list_button_box);
	_g_object_unref0 (add_list_label);
	_g_object_unref0 (add_tasklist_box);
	_g_object_unref0 (online_accounts_button);
	_g_object_unref0 (scrolledwindow);
	_g_object_unref0 (sidebar_header);
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return obj;
}

static void
tasks_main_window_class_init (TasksMainWindowClass * klass,
                              gpointer klass_data)
{
	GeeHashMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	tasks_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TasksMainWindow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = tasks_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = tasks_main_window_finalize;
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	tasks_main_window_action_accelerators = (GeeMultiMap*) _tmp0_;
	_tmp1_ = tasks_main_window_action_accelerators;
	gee_multi_map_set (_tmp1_, TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST, "<Control>BackSpace");
}

static void
tasks_main_window_instance_init (TasksMainWindow * self,
                                 gpointer klass)
{
	self->priv = tasks_main_window_get_instance_private (self);
}

static void
tasks_main_window_finalize (GObject * obj)
{
	TasksMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_TYPE_MAIN_WINDOW, TasksMainWindow);
	_g_object_unref0 (self->priv->listbox);
	_g_object_unref0 (self->priv->source_rows);
	_g_object_unref0 (self->priv->collection_sources);
	_g_object_unref0 (self->priv->list_view_stack);
	_g_object_unref0 (self->priv->add_tasklist_buttonbox);
	_g_object_unref0 (self->priv->add_tasklist_popover);
	G_OBJECT_CLASS (tasks_main_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tasks_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TasksMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasks_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TasksMainWindow), 0, (GInstanceInitFunc) tasks_main_window_instance_init, NULL };
	GType tasks_main_window_type_id;
	tasks_main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "TasksMainWindow", &g_define_type_info, 0);
	TasksMainWindow_private_offset = g_type_add_instance_private (tasks_main_window_type_id, sizeof (TasksMainWindowPrivate));
	return tasks_main_window_type_id;
}

GType
tasks_main_window_get_type (void)
{
	static gsize tasks_main_window_type_id__once = 0;
	if (g_once_init_enter (&tasks_main_window_type_id__once)) {
		GType tasks_main_window_type_id;
		tasks_main_window_type_id = tasks_main_window_get_type_once ();
		g_once_init_leave (&tasks_main_window_type_id__once, tasks_main_window_type_id);
	}
	return tasks_main_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

