/* string.c generated by valac 0.56.18, the Vala compiler
 * generated from string.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "io.elementary.photos.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

gint64 g_ascii_strtoll (const gchar* str,
                        gchar** endptr,
                        guint num_base);
static void _vala_array_add112 (guchar* * array,
                         gint* length,
                         gint* size,
                         guchar value);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

inline gboolean
is_string_empty (const gchar* s)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (s == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = string_get (s, (glong) 0) == '\0';
	}
	result = _tmp0_;
	return result;
}

gint
utf8_cs_compare (const gchar* a,
                 const gchar* b)
{
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = g_utf8_collate (a, b);
	return result;
}

gint
utf8_ci_compare (const gchar* a,
                 const gchar* b)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_utf8_strdown (a, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strdown (b, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_collate (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

gchar*
uchar_array_to_string (guchar* data,
                       gint data_length1,
                       gint length)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	if (length < 0) {
		length = data_length1;
	}
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				guchar _tmp3_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = ctr;
					ctr = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(ctr < length)) {
					break;
				}
				_tmp3_ = data[ctr];
				if (_tmp3_ != ((guchar) '\0')) {
					GString* _tmp4_;
					guchar _tmp5_;
					_tmp4_ = builder;
					_tmp5_ = data[ctr];
					g_string_append_c (_tmp4_, (gchar) _tmp5_);
				} else {
					break;
				}
			}
		}
	}
	_tmp6_ = builder;
	_tmp7_ = _tmp6_->str;
	_tmp8_ = g_strdup (_tmp7_);
	result = _tmp8_;
	_g_string_free0 (builder);
	return result;
}

static void
_vala_array_add112 (guchar* * array,
                    gint* length,
                    gint* size,
                    guchar value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guchar, *array, *size);
	}
	(*array)[(*length)++] = value;
}

guchar*
string_to_uchar_array (const gchar* str,
                       gint* result_length1)
{
	guchar* data = NULL;
	guchar* _tmp0_;
	gint data_length1;
	gint _data_size_;
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = g_new0 (guchar, 0);
	data = _tmp0_;
	data_length1 = 0;
	_data_size_ = data_length1;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = ctr;
					ctr = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = strlen (str);
				_tmp4_ = _tmp3_;
				if (!(ctr < _tmp4_)) {
					break;
				}
				_vala_array_add112 (&data, &data_length1, &_data_size_, (guchar) string_get (str, (glong) ctr));
			}
		}
	}
	_tmp5_ = data;
	_tmp5__length1 = data_length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

inline gchar*
guarded_markup_escape_text (const gchar* plain)
{
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* result;
	if (!is_string_empty (plain)) {
		_tmp1_ = g_utf8_validate (plain, (gssize) -1, NULL);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_markup_escape_text (plain, (gssize) -1);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

glong
find_last_offset (const gchar* str,
                  gchar c)
{
	glong offset = 0L;
	gint _tmp0_;
	gint _tmp1_;
	glong result;
	g_return_val_if_fail (str != NULL, 0L);
	_tmp0_ = strlen (str);
	_tmp1_ = _tmp0_;
	offset = (glong) _tmp1_;
	while (TRUE) {
		glong _tmp2_;
		offset = offset - 1;
		_tmp2_ = offset;
		if (!(_tmp2_ >= ((glong) 0))) {
			break;
		}
		if (string_get (str, offset) == c) {
			result = offset;
			return result;
		}
	}
	result = (glong) -1;
	return result;
}

gboolean
is_in_ci_array (const gchar* str,
                gchar** strings,
                gint strings_length1)
{
	gchar* strdown = NULL;
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = g_utf8_strdown (str, (gssize) -1);
	strdown = _tmp0_;
	{
		gchar** str_element_collection = NULL;
		gint str_element_collection_length1 = 0;
		gint _str_element_collection_size_ = 0;
		gint str_element_it = 0;
		str_element_collection = strings;
		str_element_collection_length1 = strings_length1;
		for (str_element_it = 0; str_element_it < str_element_collection_length1; str_element_it = str_element_it + 1) {
			gchar* _tmp1_;
			gchar* str_element = NULL;
			_tmp1_ = g_strdup (str_element_collection[str_element_it]);
			str_element = _tmp1_;
			{
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				_tmp2_ = strdown;
				_tmp3_ = str_element;
				if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
					result = TRUE;
					_g_free0 (str_element);
					_g_free0 (strdown);
					return result;
				}
				_g_free0 (str_element);
			}
		}
	}
	result = FALSE;
	_g_free0 (strdown);
	return result;
}

static GType
prepare_input_text_options_get_type_once (void)
{
	static const GFlagsValue values[] = {{PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL, "PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL", "empty-is-null"}, {PREPARE_INPUT_TEXT_OPTIONS_VALIDATE, "PREPARE_INPUT_TEXT_OPTIONS_VALIDATE", "validate"}, {PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL, "PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL", "invalid-is-null"}, {PREPARE_INPUT_TEXT_OPTIONS_STRIP, "PREPARE_INPUT_TEXT_OPTIONS_STRIP", "strip"}, {PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF, "PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF", "strip-crlf"}, {PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE, "PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE", "normalize"}, {PREPARE_INPUT_TEXT_OPTIONS_DEFAULT, "PREPARE_INPUT_TEXT_OPTIONS_DEFAULT", "default"}, {0, NULL, NULL}};
	GType prepare_input_text_options_type_id;
	prepare_input_text_options_type_id = g_flags_register_static ("PrepareInputTextOptions", values);
	return prepare_input_text_options_type_id;
}

GType
prepare_input_text_options_get_type (void)
{
	static volatile gsize prepare_input_text_options_type_id__once = 0;
	if (g_once_init_enter (&prepare_input_text_options_type_id__once)) {
		GType prepare_input_text_options_type_id;
		prepare_input_text_options_type_id = prepare_input_text_options_get_type_once ();
		g_once_init_leave (&prepare_input_text_options_type_id__once, prepare_input_text_options_type_id);
	}
	return prepare_input_text_options_type_id__once;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_delimit (const gchar* self,
                const gchar* delimiters,
                gchar new_delimiter)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strdelimit (_result_, delimiters, new_delimiter);
	result = _result_;
	return result;
}

gchar*
prepare_input_text (const gchar* text,
                    PrepareInputTextOptions options,
                    gint dest_length)
{
	gboolean _tmp0_ = FALSE;
	gchar* prepped = NULL;
	gchar* _tmp3_;
	gboolean _tmp10_ = FALSE;
	gchar* result;
	if (text == NULL) {
		result = NULL;
		return result;
	}
	if ((options & PREPARE_INPUT_TEXT_OPTIONS_VALIDATE) != 0) {
		_tmp0_ = !g_utf8_validate (text, (gssize) -1, NULL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		if ((options & PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL) != 0) {
			_tmp1_ = NULL;
		} else {
			_tmp1_ = "";
		}
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_strdup (text);
	prepped = _tmp3_;
	if ((options & PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE) != 0) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = prepped;
		_tmp5_ = g_utf8_normalize (_tmp4_, (gssize) -1, G_NORMALIZE_NFC);
		_g_free0 (prepped);
		prepped = _tmp5_;
	}
	if ((options & PREPARE_INPUT_TEXT_OPTIONS_STRIP) != 0) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = prepped;
		_tmp7_ = string_strip (_tmp6_);
		_g_free0 (prepped);
		prepped = _tmp7_;
	}
	if ((options & PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) != 0) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = prepped;
		_tmp9_ = string_delimit (_tmp8_, "\n\r", ' ');
		_g_free0 (prepped);
		prepped = _tmp9_;
	}
	if ((options & PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL) != 0) {
		const gchar* _tmp11_;
		_tmp11_ = prepped;
		_tmp10_ = is_string_empty (_tmp11_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		result = NULL;
		_g_free0 (prepped);
		return result;
	}
	if (dest_length >= 0) {
		GString* sb = NULL;
		const gchar* _tmp12_;
		GString* _tmp13_;
		GString* _tmp14_;
		GString* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp12_ = prepped;
		_tmp13_ = g_string_new (_tmp12_);
		sb = _tmp13_;
		_tmp14_ = sb;
		g_string_truncate (_tmp14_, (gsize) dest_length);
		_tmp15_ = sb;
		_tmp16_ = _tmp15_->str;
		_tmp17_ = g_strdup (_tmp16_);
		result = _tmp17_;
		_g_string_free0 (sb);
		_g_free0 (prepped);
		return result;
	}
	result = prepped;
	return result;
}

gint64
parse_int64 (const gchar* str,
             gint num_base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, (guint) num_base);
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

inline gboolean
string_contains_char (const gchar* haystack,
                      gunichar needle)
{
	gboolean result;
	g_return_val_if_fail (haystack != NULL, FALSE);
	result = string_index_of_char (haystack, needle, 0) >= 0;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

inline gboolean
string_contains_str (const gchar* haystack,
                     const gchar* needle)
{
	gboolean result;
	g_return_val_if_fail (haystack != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = string_index_of (haystack, needle, 0) >= 0;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

inline gchar*
string_sliced_at (const gchar* str,
                  gint index)
{
	gchar* _tmp0_ = NULL;
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	if (index >= 0) {
		gint _tmp1_;
		gint _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = strlen (str);
		_tmp2_ = _tmp1_;
		_tmp3_ = string_slice (str, (glong) index, (glong) _tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

inline gchar*
string_sliced_at_first_str (const gchar* haystack,
                            const gchar* needle,
                            gint start_index)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (haystack != NULL, NULL);
	g_return_val_if_fail (needle != NULL, NULL);
	_tmp0_ = string_sliced_at (haystack, string_index_of (haystack, needle, start_index));
	result = _tmp0_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

inline gchar*
string_sliced_at_last_str (const gchar* haystack,
                           const gchar* needle,
                           gint start_index)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (haystack != NULL, NULL);
	g_return_val_if_fail (needle != NULL, NULL);
	_tmp0_ = string_sliced_at (haystack, string_last_index_of (haystack, needle, start_index));
	result = _tmp0_;
	return result;
}

inline gchar*
string_sliced_at_first_char (const gchar* haystack,
                             gunichar ch,
                             gint start_index)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (haystack != NULL, NULL);
	_tmp0_ = string_sliced_at (haystack, string_index_of_char (haystack, ch, start_index));
	result = _tmp0_;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

inline gchar*
string_sliced_at_last_char (const gchar* haystack,
                            gunichar ch,
                            gint start_index)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (haystack != NULL, NULL);
	_tmp0_ = string_sliced_at (haystack, string_last_index_of_char (haystack, ch, start_index));
	result = _tmp0_;
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

gchar*
string_strip_leading_zeroes (const gchar* str)
{
	GString* stripped = NULL;
	GString* _tmp0_;
	gboolean prev_is_space = FALSE;
	GString* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = g_string_new ("");
	stripped = _tmp0_;
	prev_is_space = TRUE;
	{
		const gchar* iter = NULL;
		iter = str;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				const gchar* _tmp4_;
				gunichar ch = 0U;
				const gchar* _tmp5_;
				gboolean _tmp6_ = FALSE;
				if (!_tmp1_) {
					const gchar* _tmp2_;
					const gchar* _tmp3_;
					_tmp2_ = iter;
					_tmp3_ = g_utf8_next_char (_tmp2_);
					iter = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = iter;
				if (!(string_get_char (_tmp4_, (glong) 0) != ((gunichar) 0))) {
					break;
				}
				_tmp5_ = iter;
				ch = string_get_char (_tmp5_, (glong) 0);
				if (!prev_is_space) {
					_tmp6_ = TRUE;
				} else {
					_tmp6_ = ch != ((gunichar) '0');
				}
				if (_tmp6_) {
					GString* _tmp7_;
					_tmp7_ = stripped;
					g_string_append_unichar (_tmp7_, ch);
					prev_is_space = g_unichar_isspace (ch);
				}
			}
		}
	}
	_tmp8_ = stripped;
	_tmp9_ = _tmp8_->str;
	_tmp10_ = g_strdup (_tmp9_);
	result = _tmp10_;
	_g_string_free0 (stripped);
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

gchar*
string_remove_diacritics (const gchar* istring)
{
	GString* builder = NULL;
	GString* _tmp0_;
	gunichar ch = 0U;
	gint i = 0;
	GString* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (istring != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	i = 0;
	while (TRUE) {
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		GString* _tmp3_;
		_tmp2_ = string_get_next_char (istring, &i, &_tmp1_);
		ch = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		switch (g_unichar_type (ch)) {
			case G_UNICODE_CONTROL:
			case G_UNICODE_FORMAT:
			case G_UNICODE_UNASSIGNED:
			case G_UNICODE_NON_SPACING_MARK:
			case G_UNICODE_COMBINING_MARK:
			case G_UNICODE_ENCLOSING_MARK:
			{
				continue;
			}
			default:
			break;
		}
		_tmp3_ = builder;
		g_string_append_unichar (_tmp3_, ch);
	}
	_tmp4_ = builder;
	_tmp5_ = _tmp4_->str;
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	_g_string_free0 (builder);
	return result;
}

gchar*
string_to_hex_string (const gchar* str)
{
	GString* builder = NULL;
	GString* _tmp0_;
	guint8* data = NULL;
	GString* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	data = (guint8*) str;
	while (TRUE) {
		guint8* _tmp1_;
		const gchar* _tmp2_ = NULL;
		guint8* _tmp3_;
		GString* _tmp4_;
		guint8* _tmp5_;
		_tmp1_ = data;
		if (!(((gint) (*_tmp1_)) != 0)) {
			break;
		}
		_tmp3_ = data;
		if (((gint) (*_tmp3_)) != 0) {
			_tmp2_ = " ";
		} else {
			_tmp2_ = "";
		}
		_tmp4_ = builder;
		_tmp5_ = data;
		data = _tmp5_ + 1;
		g_string_append_printf (_tmp4_, "%02Xh%s", (guint) (*_tmp5_), _tmp2_);
	}
	_tmp6_ = builder;
	_tmp7_ = _tmp6_->str;
	_tmp8_ = g_strdup (_tmp7_);
	result = _tmp8_;
	_g_string_free0 (builder);
	return result;
}

guint
string_collated_hash (void* ptr)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	GHashFunc _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	guint _tmp4_;
	guint result;
	_tmp0_ = g_strdup ((const gchar*) ptr);
	str = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_utf8_collate_key (str, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp1_ (_tmp3_);
	_g_free0 (_tmp3_);
	result = _tmp4_;
	_g_free0 (str);
	return result;
}

guint
string_precollated_hash (void* ptr)
{
	GHashFunc _tmp0_;
	guint result;
	_tmp0_ = g_str_hash;
	result = _tmp0_ ((const gchar*) ptr);
	return result;
}

gint
string_collated_compare (void* a,
                         void* b)
{
	gchar* astr = NULL;
	gchar* _tmp0_;
	gchar* bstr = NULL;
	gchar* _tmp1_;
	gint _result_ = 0;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_ = 0;
	gint result;
	_tmp0_ = g_strdup ((const gchar*) a);
	astr = _tmp0_;
	_tmp1_ = g_strdup ((const gchar*) b);
	bstr = _tmp1_;
	_tmp2_ = astr;
	_tmp3_ = bstr;
	_result_ = g_utf8_collate (_tmp2_, _tmp3_);
	if (_result_ != 0) {
		_tmp4_ = _result_;
	} else {
		GCompareFunc _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = ((GCompareFunc) g_strcmp0);
		_tmp6_ = astr;
		_tmp7_ = bstr;
		_tmp4_ = _tmp5_ (_tmp6_, _tmp7_);
	}
	result = _tmp4_;
	_g_free0 (bstr);
	_g_free0 (astr);
	return result;
}

gint
string_precollated_compare (const gchar* astr,
                            const gchar* akey,
                            const gchar* bstr,
                            const gchar* bkey)
{
	gint _result_ = 0;
	GCompareFunc _tmp0_;
	gint _tmp1_ = 0;
	gint result;
	g_return_val_if_fail (astr != NULL, 0);
	g_return_val_if_fail (akey != NULL, 0);
	g_return_val_if_fail (bstr != NULL, 0);
	g_return_val_if_fail (bkey != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_result_ = _tmp0_ (akey, bkey);
	if (_result_ != 0) {
		_tmp1_ = _result_;
	} else {
		GCompareFunc _tmp2_;
		_tmp2_ = ((GCompareFunc) g_strcmp0);
		_tmp1_ = _tmp2_ (astr, bstr);
	}
	result = _tmp1_;
	return result;
}

gboolean
string_collated_equals (void* a,
                        void* b)
{
	gboolean result;
	result = string_collated_compare (a, b) == 0;
	return result;
}

gboolean
string_precollated_equals (const gchar* astr,
                           const gchar* akey,
                           const gchar* bstr,
                           const gchar* bkey)
{
	gboolean result;
	g_return_val_if_fail (astr != NULL, FALSE);
	g_return_val_if_fail (akey != NULL, FALSE);
	g_return_val_if_fail (bstr != NULL, FALSE);
	g_return_val_if_fail (bkey != NULL, FALSE);
	result = string_precollated_compare (astr, akey, bstr, bkey) == 0;
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

