/* Photo.c generated by valac 0.56.18, the Vala compiler
 * generated from Photo.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* Specifies how pixel data is fetched from the backing file on disk.  MASTER is the original*/
/* backing photo of any supported photo file format; SOURCE is either the master or the editable*/
/* file, that is, the appropriate reference file for user display; BASELINE is an appropriate*/
/* file with the proviso that it may be a suitable substitute for the master and/or the editable.*/
/* UNMODIFIED represents the photo with no edits, i.e. the head of the pipeline.*/
/**/
/* In general, callers want to use the BASELINE unless requirements are specific.*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>

#define PHOTO_SCALING_FUDGE 64
#define PHOTO_PRECACHE_TIME_TO_LIVE 180
#define PHOTO_MIN_EMBEDDED_SIZE 1024
#define LIBRARY_PHOTO_FLAG_HIDDEN ((guint64) 0x0000000000000001)
#define LIBRARY_PHOTO_FLAG_FAVORITE ((guint64) 0x0000000000000002)
#define LIBRARY_PHOTO_FLAG_TRASH ((guint64) 0x0000000000000004)
#define LIBRARY_PHOTO_FLAG_OFFLINE ((guint64) 0x0000000000000008)
#define LIBRARY_PHOTO_FLAG_FLAGGED ((guint64) 0x0000000000000010)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _thumbnails_unref0(var) ((var == NULL) ? NULL : (var = (thumbnails_unref (var), NULL)))
#define _photo_row_unref0(var) ((var == NULL) ? NULL : (var = (photo_row_unref (var), NULL)))
typedef struct _ParamSpecPhotoImportParams ParamSpecPhotoImportParams;
enum  {
	PHOTO_TRANSFORMATION_STATE_0_PROPERTY,
	PHOTO_TRANSFORMATION_STATE_NUM_PROPERTIES
};
static GParamSpec* photo_transformation_state_properties[PHOTO_TRANSFORMATION_STATE_NUM_PROPERTIES];
enum  {
	PHOTO_TRANSFORMATION_STATE_BROKEN_SIGNAL,
	PHOTO_TRANSFORMATION_STATE_NUM_SIGNALS
};
static guint photo_transformation_state_signals[PHOTO_TRANSFORMATION_STATE_NUM_SIGNALS] = {0};

#define PHOTO_TYPE_BACKING_READERS (photo_backing_readers_get_type ())
#define PHOTO_BACKING_READERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_BACKING_READERS, PhotoBackingReaders))
#define PHOTO_BACKING_READERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_BACKING_READERS, PhotoBackingReadersClass))
#define PHOTO_IS_BACKING_READERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_BACKING_READERS))
#define PHOTO_IS_BACKING_READERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_BACKING_READERS))
#define PHOTO_BACKING_READERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_BACKING_READERS, PhotoBackingReadersClass))

typedef struct _PhotoBackingReaders PhotoBackingReaders;
typedef struct _PhotoBackingReadersClass PhotoBackingReadersClass;
enum  {
	PHOTO_0_PROPERTY,
	PHOTO_NUM_PROPERTIES
};
static GParamSpec* photo_properties[PHOTO_NUM_PROPERTIES];
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))
#define _photo_backing_readers_unref0(var) ((var == NULL) ? NULL : (var = (photo_backing_readers_unref (var), NULL)))
#define _pixel_transformer_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformer_unref (var), NULL)))
#define _pixel_transformation_bundle_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_bundle_unref (var), NULL)))
#define _one_shot_scheduler_unref0(var) ((var == NULL) ? NULL : (var = (one_shot_scheduler_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _PhotoBackingReadersPrivate PhotoBackingReadersPrivate;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _photo_preview_unref0(var) ((var == NULL) ? NULL : (var = (photo_preview_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _photo_file_interrogator_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_interrogator_unref (var), NULL)))
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
#define _photo_reimport_master_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_master_state_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL (photo_reimport_master_state_impl_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl))
#define PHOTO_REIMPORT_MASTER_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImplClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL))
#define PHOTO_IS_REIMPORT_MASTER_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL))
#define PHOTO_REIMPORT_MASTER_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImplClass))

typedef struct _PhotoReimportMasterStateImpl PhotoReimportMasterStateImpl;
typedef struct _PhotoReimportMasterStateImplClass PhotoReimportMasterStateImplClass;
typedef struct _PhotoReimportMasterStateImplPrivate PhotoReimportMasterStateImplPrivate;
#define _photo_reimport_editable_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_editable_state_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL (photo_reimport_editable_state_impl_get_type ())
#define PHOTO_REIMPORT_EDITABLE_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl))
#define PHOTO_REIMPORT_EDITABLE_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImplClass))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL))
#define PHOTO_REIMPORT_EDITABLE_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImplClass))

typedef struct _PhotoReimportEditableStateImpl PhotoReimportEditableStateImpl;
typedef struct _PhotoReimportEditableStateImplClass PhotoReimportEditableStateImplClass;
typedef struct _PhotoReimportEditableStateImplPrivate PhotoReimportEditableStateImplPrivate;
#define _photo_reimport_raw_development_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_raw_development_state_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL (photo_reimport_raw_development_state_impl_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImpl))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImplClass))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImplClass))

typedef struct _PhotoReimportRawDevelopmentStateImpl PhotoReimportRawDevelopmentStateImpl;
typedef struct _PhotoReimportRawDevelopmentStateImplClass PhotoReimportRawDevelopmentStateImplClass;

#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT (photo_reimport_raw_development_state_impl_dev_to_reimport_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimport))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimportClass))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_IS_DEV_TO_REIMPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_IS_DEV_TO_REIMPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimportClass))

typedef struct _PhotoReimportRawDevelopmentStateImplDevToReimport PhotoReimportRawDevelopmentStateImplDevToReimport;
typedef struct _PhotoReimportRawDevelopmentStateImplDevToReimportClass PhotoReimportRawDevelopmentStateImplDevToReimportClass;
typedef struct _PhotoReimportRawDevelopmentStateImplPrivate PhotoReimportRawDevelopmentStateImplPrivate;
typedef struct _PhotoReimportRawDevelopmentStateImplDevToReimportPrivate PhotoReimportRawDevelopmentStateImplDevToReimportPrivate;
#define _photo_reimport_raw_development_state_impl_dev_to_reimport_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_raw_development_state_impl_dev_to_reimport_unref (var), NULL)))
#define _key_value_map_unref0(var) ((var == NULL) ? NULL : (var = (key_value_map_unref (var), NULL)))
#define _pixel_transformation_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_unref (var), NULL)))

#define PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL (photo_photo_transformation_state_impl_get_type ())
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImpl))
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImplClass))
#define PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL))
#define PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL))
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImplClass))

typedef struct _PhotoPhotoTransformationStateImpl PhotoPhotoTransformationStateImpl;
typedef struct _PhotoPhotoTransformationStateImplClass PhotoPhotoTransformationStateImplClass;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
typedef struct _PhotoPhotoTransformationStateImplPrivate PhotoPhotoTransformationStateImplPrivate;
enum  {
	PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_0_PROPERTY,
	PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_NUM_PROPERTIES
};
static GParamSpec* photo_photo_transformation_state_impl_properties[PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_NUM_PROPERTIES];
typedef struct _PhotoParamSpecBackingReaders PhotoParamSpecBackingReaders;
typedef struct _PhotoParamSpecReimportMasterState PhotoParamSpecReimportMasterState;
typedef struct _PhotoParamSpecReimportEditableState PhotoParamSpecReimportEditableState;
typedef struct _PhotoParamSpecReimportRawDevelopmentState PhotoParamSpecReimportRawDevelopmentState;
typedef struct _PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport;
enum  {
	PHOTO_EDITABLE_REPLACED_SIGNAL,
	PHOTO_RAW_DEVELOPMENT_MODIFIED_SIGNAL,
	PHOTO_BASELINE_REPLACED_SIGNAL,
	PHOTO_MASTER_REIMPORTED_SIGNAL,
	PHOTO_EDITABLE_REIMPORTED_SIGNAL,
	PHOTO_BASELINE_REIMPORTED_SIGNAL,
	PHOTO_SOURCE_REIMPORTED_SIGNAL,
	PHOTO_NUM_SIGNALS
};
static guint photo_signals[PHOTO_NUM_SIGNALS] = {0};
#define _transaction_controller_unref0(var) ((var == NULL) ? NULL : (var = (transaction_controller_unref (var), NULL)))
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))

#define TYPE_PHOTO_MONITOR (photo_monitor_get_type ())
#define PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_MONITOR, PhotoMonitor))
#define PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_MONITOR, PhotoMonitorClass))
#define IS_PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_MONITOR))
#define IS_PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_MONITOR))
#define PHOTO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_MONITOR, PhotoMonitorClass))

typedef struct _PhotoMonitor PhotoMonitor;
typedef struct _PhotoMonitorClass PhotoMonitorClass;
#define _hierarchical_tag_index_unref0(var) ((var == NULL) ? NULL : (var = (hierarchical_tag_index_unref (var), NULL)))
enum  {
	LIBRARY_PHOTO_SOURCE_COLLECTION_MASTER_REIMPORTED_SIGNAL,
	LIBRARY_PHOTO_SOURCE_COLLECTION_EDITABLE_REIMPORTED_SIGNAL,
	LIBRARY_PHOTO_SOURCE_COLLECTION_BASELINE_REIMPORTED_SIGNAL,
	LIBRARY_PHOTO_SOURCE_COLLECTION_SOURCE_REIMPORTED_SIGNAL,
	LIBRARY_PHOTO_SOURCE_COLLECTION_NUM_SIGNALS
};
static guint library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_NUM_SIGNALS] = {0};
enum  {
	LIBRARY_PHOTO_0_PROPERTY,
	LIBRARY_PHOTO_NUM_PROPERTIES
};
static GParamSpec* library_photo_properties[LIBRARY_PHOTO_NUM_PROPERTIES];
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ParamSpecPhotoImportParams {
	GParamSpec parent_instance;
};

struct _PhotoTransformationStatePrivate {
	gboolean is_broke;
};

struct _PhotoPrivate {
	gint64 cached_exposure_time;
	GRecMutex __lock_row;
	BackingPhotoRow* editable;
	PhotoBackingReaders* readers;
	GRecMutex __lock_readers;
	PixelTransformer* transformer;
	PixelTransformationBundle* adjustments;
	gchar* file_title;
	GFileMonitor* editable_monitor;
	OneShotScheduler* reimport_editable_scheduler;
	OneShotScheduler* update_editable_attributes_scheduler;
	OneShotScheduler* remove_editable_scheduler;
	GdkPixbuf* unmodified_precached;
	GRecMutex __lock_unmodified_precached;
	GTimer* secs_since_access;
	GeeHashMap* developments;
	GRecMutex __lock_developments;
};

struct _PhotoBackingReaders {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoBackingReadersPrivate * priv;
	PhotoFileReader* master;
	PhotoFileReader* developer;
	PhotoFileReader* editable;
};

struct _PhotoBackingReadersClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoBackingReaders *self);
};

struct _PhotoReimportMasterStateImpl {
	PhotoReimportMasterState parent_instance;
	PhotoReimportMasterStateImplPrivate * priv;
	PhotoRow* row;
	PhotoMetadata* metadata;
	gchar** alterations;
	gint alterations_length1;
	gint _alterations_size_;
	gboolean metadata_only;
};

struct _PhotoReimportMasterStateImplClass {
	PhotoReimportMasterStateClass parent_class;
};

struct _PhotoReimportEditableStateImpl {
	PhotoReimportEditableState parent_instance;
	PhotoReimportEditableStateImplPrivate * priv;
	BackingPhotoRow* backing_state;
	PhotoMetadata* metadata;
	gboolean metadata_only;
};

struct _PhotoReimportEditableStateImplClass {
	PhotoReimportEditableStateClass parent_class;
};

struct _PhotoReimportRawDevelopmentStateImpl {
	PhotoReimportRawDevelopmentState parent_instance;
	PhotoReimportRawDevelopmentStateImplPrivate * priv;
	GeeCollection* list;
	gboolean metadata_only;
};

struct _PhotoReimportRawDevelopmentStateImplClass {
	PhotoReimportRawDevelopmentStateClass parent_class;
};

struct _PhotoReimportRawDevelopmentStateImplDevToReimport {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportRawDevelopmentStateImplDevToReimportPrivate * priv;
	BackingPhotoRow* backing;
	PhotoMetadata* metadata;
};

struct _PhotoReimportRawDevelopmentStateImplDevToReimportClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportRawDevelopmentStateImplDevToReimport *self);
};

struct _PhotoPhotoTransformationStateImpl {
	PhotoTransformationState parent_instance;
	PhotoPhotoTransformationStateImplPrivate * priv;
};

struct _PhotoPhotoTransformationStateImplClass {
	PhotoTransformationStateClass parent_class;
};

struct _PhotoPhotoTransformationStateImplPrivate {
	Photo* photo;
	Orientation orientation;
	GeeHashMap* transformations;
	GeeHashMap* original_transformations;
	PixelTransformer* transformer;
	PixelTransformationBundle* adjustments;
	gboolean enhanced;
};

struct _PhotoParamSpecBackingReaders {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecReimportMasterState {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecReimportEditableState {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecReimportRawDevelopmentState {
	GParamSpec parent_instance;
};

struct _PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport {
	GParamSpec parent_instance;
};

struct _LibraryPhotoSourceCollectionPrivate {
	TransactionController* _transaction_controller;
	GeeHashMap* by_editable_file;
	GeeHashMap* by_raw_development_file;
	GeeMultiMap* filesize_to_photo;
	GeeHashMap* photo_to_master_filesize;
	GeeHashMap* photo_to_editable_filesize;
	GeeMultiMap* photo_to_raw_development_filesize;
};

struct _LibraryPhotoPrivate {
	gboolean block_thumbnail_generation;
	OneShotScheduler* thumbnail_scheduler;
	GeeCollection* import_keywords;
};

struct _LibraryPhotoSourceHoldingTankPrivate {
	GeeHashMap* editable_file_map;
	GeeHashMap* development_file_map;
	GeeMultiMap* reverse_editable_file_map;
	GeeMultiMap* reverse_development_file_map;
};

static gpointer photo_import_params_parent_class = NULL;
static gint PhotoTransformationState_private_offset;
static gpointer photo_transformation_state_parent_class = NULL;
static gint Photo_private_offset;
static gpointer photo_parent_class = NULL;
static gboolean photo__develop_raw_photos_to_files;
static gboolean photo__develop_raw_photos_to_files = FALSE;
static gint PhotoPhotoTransformationStateImpl_private_offset;
static gpointer photo_photo_transformation_state_impl_parent_class = NULL;
static gpointer photo_backing_readers_parent_class = NULL;
static gpointer photo_reimport_master_state_parent_class = NULL;
static gpointer photo_reimport_master_state_impl_parent_class = NULL;
static gpointer photo_reimport_editable_state_parent_class = NULL;
static gpointer photo_reimport_editable_state_impl_parent_class = NULL;
static gpointer photo_reimport_raw_development_state_parent_class = NULL;
static gpointer photo_reimport_raw_development_state_impl_parent_class = NULL;
static gpointer photo_reimport_raw_development_state_impl_dev_to_reimport_parent_class = NULL;
static DateableIface * photo_dateable_parent_iface = NULL;
static gint LibraryPhotoSourceCollection_private_offset;
static gpointer library_photo_source_collection_parent_class = NULL;
static gint LibraryPhoto_private_offset;
static gpointer library_photo_parent_class = NULL;
LibraryPhotoSourceCollection* library_photo_global = NULL;
static FlaggableIface * library_photo_flaggable_parent_iface = NULL;
static MonitorableIface * library_photo_monitorable_parent_iface = NULL;
static gint LibraryPhotoSourceHoldingTank_private_offset;
static gpointer library_photo_source_holding_tank_parent_class = NULL;

static void photo_import_params_finalize (PhotoImportParams * obj);
static GType photo_import_params_get_type_once (void);
static void photo_transformation_state_real_broken (PhotoTransformationState* self);
static void photo_transformation_state_finalize (GObject * obj);
static GType photo_transformation_state_get_type_once (void);
static gpointer photo_backing_readers_ref (gpointer instance);
static void photo_backing_readers_unref (gpointer instance);
static GParamSpec* photo_param_spec_backing_readers (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags) G_GNUC_UNUSED ;
static void photo_value_set_backing_readers (GValue* value,
                                      gpointer v_object) G_GNUC_UNUSED ;
static void photo_value_take_backing_readers (GValue* value,
                                       gpointer v_object) G_GNUC_UNUSED ;
static gpointer photo_value_get_backing_readers (const GValue* value) G_GNUC_UNUSED ;
static GType photo_backing_readers_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PhotoBackingReaders* photo_backing_readers_new (void);
static PhotoBackingReaders* photo_backing_readers_construct (GType object_type);
static BackingPhotoRow* photo_get_backing_row (Photo* self,
                                        BackingPhotoID* id);
static void photo_internal_remove_all_transformations (Photo* self,
                                                gboolean notify);
static void photo_real_notify_editable_replaced (Photo* self,
                                          GFile* old_file,
                                          GFile* new_file);
static void photo_real_notify_raw_development_modified (Photo* self);
static void photo_real_notify_baseline_replaced (Photo* self);
static void photo_real_notify_master_reimported (Photo* self,
                                          PhotoMetadata* metadata);
static void photo_real_notify_editable_reimported (Photo* self,
                                            PhotoMetadata* metadata);
static void photo_real_notify_source_reimported (Photo* self,
                                          PhotoMetadata* metadata);
static void photo_real_notify_baseline_reimported (Photo* self,
                                            PhotoMetadata* metadata);
static gboolean photo_real_internal_delete_backing (DataSource* base,
                                             GError** error);
static void photo_detach_editable (Photo* self,
                            gboolean delete_editable,
                            gboolean remove_transformations,
                            gboolean notify);
static gboolean photo_delete_raw_development (Photo* self,
                                       RawDeveloper d);
static void photo_develop_photo (Photo* self,
                          RawDeveloper d);
static BackingFileState** photo_real_get_backing_files_state (MediaSource* base,
                                                       gint* result_length1);
static void _vala_array_add7 (BackingFileState** * array,
                       gint* length,
                       gint* size,
                       BackingFileState* value);
static void _vala_array_add8 (BackingFileState** * array,
                       gint* length,
                       gint* size,
                       BackingFileState* value);
static void _vala_array_add9 (BackingFileState** * array,
                       gint* length,
                       gint* size,
                       BackingFileState* value);
static PhotoFileReader* photo_get_backing_reader (Photo* self,
                                           BackingFetchMode mode);
static PhotoFileReader* photo_get_master_reader (Photo* self);
static PhotoFileReader* photo_get_baseline_reader (Photo* self);
static PhotoFileReader* photo_get_source_reader (Photo* self);
static PhotoFileReader* photo_get_raw_developer_reader (Photo* self);
static PhotoFileFormat* _photo_file_format_dup (PhotoFileFormat* self);
static void _vala_array_add10 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add11 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add12 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add13 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add14 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static PhotoReimportMasterStateImpl* photo_reimport_master_state_impl_new (PhotoRow* row,
                                                                    PhotoMetadata* metadata,
                                                                    gchar** alterations,
                                                                    gint alterations_length1);
static PhotoReimportMasterStateImpl* photo_reimport_master_state_impl_construct (GType object_type,
                                                                          PhotoRow* row,
                                                                          PhotoMetadata* metadata,
                                                                          gchar** alterations,
                                                                          gint alterations_length1);
static GType photo_reimport_master_state_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void photo_real_apply_user_metadata_for_reimport (Photo* self,
                                                  PhotoMetadata* metadata);
static void _vala_array_add15 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add16 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gboolean photo_verify_file_for_reimport (Photo* self,
                                         GFile* file,
                                         BackingPhotoRow** backing,
                                         DetectedPhotoInformation** detected,
                                         GError** error);
static PhotoReimportEditableStateImpl* photo_reimport_editable_state_impl_new (BackingPhotoRow* backing_state,
                                                                        PhotoMetadata* metadata);
static PhotoReimportEditableStateImpl* photo_reimport_editable_state_impl_construct (GType object_type,
                                                                              BackingPhotoRow* backing_state,
                                                                              PhotoMetadata* metadata);
static GType photo_reimport_editable_state_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType photo_reimport_raw_development_state_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PhotoReimportRawDevelopmentStateImpl* photo_reimport_raw_development_state_impl_new (void);
static PhotoReimportRawDevelopmentStateImpl* photo_reimport_raw_development_state_impl_construct (GType object_type);
static void photo_reimport_raw_development_state_impl_add (PhotoReimportRawDevelopmentStateImpl* self,
                                                    BackingPhotoRow* backing,
                                                    PhotoMetadata* metadata);
static gint photo_reimport_raw_development_state_impl_get_size (PhotoReimportRawDevelopmentStateImpl* self);
static gpointer photo_reimport_raw_development_state_impl_dev_to_reimport_ref (gpointer instance);
static void photo_reimport_raw_development_state_impl_dev_to_reimport_unref (gpointer instance);
static GParamSpec* photo_reimport_raw_development_state_impl_param_spec_dev_to_reimport (const gchar* name,
                                                                                  const gchar* nick,
                                                                                  const gchar* blurb,
                                                                                  GType object_type,
                                                                                  GParamFlags flags) G_GNUC_UNUSED ;
static void photo_reimport_raw_development_state_impl_value_set_dev_to_reimport (GValue* value,
                                                                          gpointer v_object) G_GNUC_UNUSED ;
static void photo_reimport_raw_development_state_impl_value_take_dev_to_reimport (GValue* value,
                                                                           gpointer v_object) G_GNUC_UNUSED ;
static gpointer photo_reimport_raw_development_state_impl_value_get_dev_to_reimport (const GValue* value) G_GNUC_UNUSED ;
VALA_EXTERN GType photo_reimport_raw_development_state_impl_dev_to_reimport_get_type (void) G_GNUC_CONST ;
static gchar* photo_real_get_typename (DataSource* base);
static gint64 photo_real_get_instance_id (DataSource* base);
static gchar* photo_real_get_source_id (DataSource* base);
static PhotoFileFormat photo_real_get_preferred_thumbnail_format (ThumbnailSource* base);
static GdkPixbuf* photo_real_create_thumbnail (ThumbnailSource* base,
                                        gint scale,
                                        GError** error);
static gboolean photo_is_extension_found (const gchar* basename,
                                   gchar** extensions,
                                   gint extensions_length1);
static GFile* photo_real_get_file (MediaSource* base);
static void _vala_array_add17 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add18 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add19 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add20 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add21 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add22 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add23 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static GFile* photo_real_get_master_file (MediaSource* base);
static gint64 photo_real_get_timestamp (MediaSource* base);
static inline void photo_real_get_event_id (MediaSource* base,
                              EventID* result);
static void photo_real_get_import_id (MediaSource* base,
                               ImportID* result);
static gchar* photo_real_get_master_md5 (MediaSource* base);
static void photo_notify_flags_altered (Photo* self,
                                 Alteration* additional_alteration);
static void photo_real_commit_backlinks (DataSource* base,
                                  SourceCollection* sources,
                                  const gchar* backlinks);
static gboolean photo_real_set_event_id (MediaSource* base,
                                  EventID* event_id);
static gchar* photo_real_to_string (DataObject* base);
static gboolean photo_real_equals (DataSource* base,
                            DataSource* source);
static void photo_file_exif_updated (Photo* self);
static guint64 photo_real_get_filesize (MediaSource* base);
static guint64 photo_real_get_master_filesize (MediaSource* base);
static gint64 photo_real_get_exposure_time (Dateable* base);
static gchar* photo_real_get_basename (MediaSource* base);
static gchar* photo_real_get_title (MediaSource* base);
static gchar* photo_real_get_comment (MediaSource* base);
static void photo_real_set_title (MediaSource* base,
                           const gchar* title);
static gboolean photo_real_set_comment (MediaSource* base,
                                 const gchar* comment);
static void photo_real_set_exposure_time (Dateable* base,
                                   gint64 time);
static void photo_real_get_dimensions (MediaSource* base,
                                PhotoException disallowed_steps,
                                Dimensions* result);
VALA_EXTERN void compute_arb_rotated_size (gdouble src_width,
                               gdouble src_height,
                               gdouble angle,
                               gdouble* dest_width,
                               gdouble* dest_height);
static void photo_locked_create_adjustments_from_data (Photo* self);
static KeyValueMap* photo_get_transformation (Photo* self,
                                       const gchar* name);
static PixelTransformationBundle* photo_locked_original_color_adjustments (Photo* self);
static KeyValueMap* photo_get_color_adjustments_map (Photo* self);
static gboolean photo_has_transformation (Photo* self,
                                   const gchar* name);
static gboolean photo_remove_transformation (Photo* self,
                                      const gchar* name);
static gboolean photo_set_transformation (Photo* self,
                                   KeyValueMap* trans);
static PhotoMetadata* photo_real_get_metadata (PhotoSource* base);
static PhotoPhotoTransformationStateImpl* photo_photo_transformation_state_impl_new (Photo* photo,
                                                                              Orientation orientation,
                                                                              GeeHashMap* transformations,
                                                                              PixelTransformer* transformer,
                                                                              PixelTransformationBundle* adjustments,
                                                                              GeeHashMap* original_transformations,
                                                                              gboolean enhanced);
static PhotoPhotoTransformationStateImpl* photo_photo_transformation_state_impl_construct (GType object_type,
                                                                                    Photo* photo,
                                                                                    Orientation orientation,
                                                                                    GeeHashMap* transformations,
                                                                                    PixelTransformer* transformer,
                                                                                    PixelTransformationBundle* adjustments,
                                                                                    GeeHashMap* original_transformations,
                                                                                    gboolean enhanced);
static GType photo_photo_transformation_state_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static Orientation photo_photo_transformation_state_impl_get_orientation (PhotoPhotoTransformationStateImpl* self);
static gboolean photo_photo_transformation_state_impl_get_enhanced (PhotoPhotoTransformationStateImpl* self);
static GeeHashMap* photo_photo_transformation_state_impl_get_transformations (PhotoPhotoTransformationStateImpl* self);
static GeeHashMap* photo_photo_transformation_state_impl_get_original_transformations (PhotoPhotoTransformationStateImpl* self);
static PixelTransformer* photo_photo_transformation_state_impl_get_transformer (PhotoPhotoTransformationStateImpl* self);
static PixelTransformationBundle* photo_photo_transformation_state_impl_get_color_adjustments (PhotoPhotoTransformationStateImpl* self);
static void photo_real_rotate (Photo* self,
                        Rotation rotation);
static gboolean photo_set_original_transforms (Photo* self,
                                        KeyValueMap* trans);
static gboolean photo_clear_original_transforms (Photo* self);
static void photo_set_raw_crop (Photo* self,
                         Box* crop);
static gboolean photo_get_raw_straighten (Photo* self,
                                   gdouble* angle);
static void photo_set_raw_straighten (Photo* self,
                               gdouble theta);
static EditingToolsRedeyeInstance* photo_get_raw_redeye_instances (Photo* self,
                                                            gint* result_length1);
static gboolean photo_calculate_pixbuf_dimensions (Photo* self,
                                            Scaling* scaling,
                                            PhotoException exceptions,
                                            Dimensions* scaled_image,
                                            Dimensions* scaled_to_viewport);
static gboolean photo_locked_calculate_pixbuf_dimensions (Photo* self,
                                                   Scaling* scaling,
                                                   PhotoException exceptions,
                                                   Dimensions* scaled_image,
                                                   Dimensions* scaled_to_viewport);
static GdkPixbuf* photo_load_raw_pixbuf (Photo* self,
                                  Scaling* scaling,
                                  PhotoException exceptions,
                                  BackingFetchMode fetch_mode,
                                  GError** error);
static GdkPixbuf* photo_get_untransformed_pixbuf (Photo* self,
                                           Scaling* scaling,
                                           gboolean rotate,
                                           BackingFetchMode fetch_mode,
                                           GError** error);
static GdkPixbuf* photo_real_get_pixbuf (PhotoSource* base,
                                  Scaling* scaling,
                                  GError** error);
static GdkPixbuf* photo_do_redeye (Photo* self,
                            GdkPixbuf* pixbuf,
                            EditingToolsRedeyeInstance* inst);
VALA_EXTERN GdkPixbuf* rotate_arb (GdkPixbuf* source_pixbuf,
                       gdouble angle);
static gboolean photo_real_has_user_generated_metadata (Photo* self);
static void photo_real_set_user_metadata_for_export (Photo* self,
                                              PhotoMetadata* metadata);
static gboolean photo_export_fullsized_backing (Photo* self,
                                         GFile* file,
                                         gboolean export_metadata,
                                         GError** error);
static GFile* photo_generate_new_editable_file (Photo* self,
                                         PhotoFileFormat* file_format,
                                         GError** error);
static gboolean photo_launch_editor (GFile* file,
                              PhotoFileFormat file_format,
                              const gchar* commandline,
                              GError** error);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void photo_halt_monitoring_editable (Photo* self);
static void photo_attach_editable (Photo* self,
                            PhotoFileFormat file_format,
                            GFile* file,
                            GError** error);
static void photo_start_monitoring_editable (Photo* self,
                                      GFile* file,
                                      GError** error);
static void photo_on_editable_file_changed (Photo* self,
                                     GFile* file,
                                     GFile* other_file,
                                     GFileMonitorEvent event);
static void _photo_on_editable_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                             GFile* file,
                                                             GFile* other_file,
                                                             GFileMonitorEvent event_type,
                                                             gpointer self);
static void photo_update_editable (Photo* self,
                            gboolean only_attributes,
                            PhotoFileReader* new_reader,
                            GError** error);
static void photo_update_editable_attributes (Photo* self,
                                       GError** error);
static void _vala_array_add24 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add25 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add26 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add27 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add28 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add29 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void photo_on_reimport_editable (Photo* self);
static void _photo_on_reimport_editable_one_shot_callback (gpointer self);
static void photo_on_update_editable_attributes (Photo* self);
static void _photo_on_update_editable_attributes_one_shot_callback (gpointer self);
static void photo_on_remove_editable (Photo* self);
static void _photo_on_remove_editable_one_shot_callback (gpointer self);
static GdkPixbuf* photo_red_reduce_pixel (Photo* self,
                                   GdkPixbuf* pixbuf,
                                   gint x,
                                   gint y);
static void photo_real_editable_replaced (Photo* self,
                                   GFile* old_file,
                                   GFile* new_file);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void photo_real_raw_development_modified (Photo* self);
static void photo_real_baseline_replaced (Photo* self);
static void photo_real_master_reimported (Photo* self,
                                   PhotoMetadata* metadata);
static void g_cclosure_user_marshal_VOID__MEDIA_METADATA (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void photo_real_editable_reimported (Photo* self,
                                     PhotoMetadata* metadata);
static void photo_real_baseline_reimported (Photo* self,
                                     PhotoMetadata* metadata);
static void photo_real_source_reimported (Photo* self,
                                   PhotoMetadata* metadata);
static void photo_photo_transformation_state_impl_on_photo_baseline_replaced (PhotoPhotoTransformationStateImpl* self);
static void _photo_photo_transformation_state_impl_on_photo_baseline_replaced_photo_baseline_replaced (Photo* _sender,
                                                                                                gpointer self);
static GeeHashMap* photo_photo_transformation_state_impl_copy_transformations (GeeHashMap* original);
static void photo_photo_transformation_state_impl_finalize (GObject * obj);
static GType photo_photo_transformation_state_impl_get_type_once (void);
static void photo_backing_readers_finalize (PhotoBackingReaders * obj);
static GType photo_backing_readers_get_type_once (void);
static void photo_reimport_master_state_finalize (PhotoReimportMasterState * obj);
static GType photo_reimport_master_state_get_type_once (void);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static void photo_reimport_master_state_impl_finalize (PhotoReimportMasterState * obj);
static GType photo_reimport_master_state_impl_get_type_once (void);
static void photo_reimport_editable_state_finalize (PhotoReimportEditableState * obj);
static GType photo_reimport_editable_state_get_type_once (void);
static void photo_reimport_editable_state_impl_finalize (PhotoReimportEditableState * obj);
static GType photo_reimport_editable_state_impl_get_type_once (void);
static void photo_reimport_raw_development_state_finalize (PhotoReimportRawDevelopmentState * obj);
static GType photo_reimport_raw_development_state_get_type_once (void);
static PhotoReimportRawDevelopmentStateImplDevToReimport* photo_reimport_raw_development_state_impl_dev_to_reimport_new (BackingPhotoRow* backing,
                                                                                                                  PhotoMetadata* metadata);
static PhotoReimportRawDevelopmentStateImplDevToReimport* photo_reimport_raw_development_state_impl_dev_to_reimport_construct (GType object_type,
                                                                                                                        BackingPhotoRow* backing,
                                                                                                                        PhotoMetadata* metadata);
static void photo_reimport_raw_development_state_impl_dev_to_reimport_finalize (PhotoReimportRawDevelopmentStateImplDevToReimport * obj);
static GType photo_reimport_raw_development_state_impl_dev_to_reimport_get_type_once (void);
static void photo_reimport_raw_development_state_impl_finalize (PhotoReimportRawDevelopmentState * obj);
static GType photo_reimport_raw_development_state_impl_get_type_once (void);
static void photo_finalize (GObject * obj);
static GType photo_get_type_once (void);
static void _vala_photo_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec);
static void _vala_photo_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec);
static guint _file_hash_gee_hash_data_func (gconstpointer v,
                                     gpointer self);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a,
                                          gconstpointer b,
                                          gpointer self);
static gint _int64_compare_gcompare_data_func (gconstpointer a,
                                        gconstpointer b,
                                        gpointer self);
static gint64* _int64_dup (gint64* self);
static gboolean _int64_equal_gee_equal_data_func (gconstpointer a,
                                           gconstpointer b,
                                           gpointer self);
static gint64 _photo_get_photo_key_get_source_database_key (DataSource* source,
                                                     gpointer self);
static void library_photo_source_collection_on_trashcan_contents_altered (LibraryPhotoSourceCollection* self,
                                                                   GeeCollection* added,
                                                                   GeeCollection* removed);
static void _library_photo_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                         GeeCollection* added,
                                                                                                         GeeCollection* removed,
                                                                                                         gpointer self);
static void library_photo_source_collection_on_offline_contents_altered (LibraryPhotoSourceCollection* self,
                                                                  GeeCollection* added,
                                                                  GeeCollection* removed);
static void _library_photo_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                        GeeCollection* added,
                                                                                                        GeeCollection* removed,
                                                                                                        gpointer self);
static MediaSourceHoldingTank* library_photo_source_collection_real_create_trashcan (MediaSourceCollection* base);
static gboolean library_photo_source_collection_check_if_trashed_photo (LibraryPhotoSourceCollection* self,
                                                                 DataSource* source,
                                                                 Alteration* alteration);
static gboolean _library_photo_source_collection_check_if_trashed_photo_source_holding_tank_check_to_keep (DataSource* source,
                                                                                                    Alteration* alteration,
                                                                                                    gpointer self);
static MediaSourceHoldingTank* library_photo_source_collection_real_create_offline_bin (MediaSourceCollection* base);
static gboolean library_photo_source_collection_check_if_offline_photo (LibraryPhotoSourceCollection* self,
                                                                 DataSource* source,
                                                                 Alteration* alteration);
static gboolean _library_photo_source_collection_check_if_offline_photo_source_holding_tank_check_to_keep (DataSource* source,
                                                                                                    Alteration* alteration,
                                                                                                    gpointer self);
static MediaMonitor* library_photo_source_collection_real_create_media_monitor (MediaSourceCollection* base,
                                                                         Workers* workers,
                                                                         GCancellable* cancellable);
VALA_EXTERN PhotoMonitor* photo_monitor_new (Workers* workers,
                                 GCancellable* cancellable);
VALA_EXTERN PhotoMonitor* photo_monitor_construct (GType object_type,
                                       Workers* workers,
                                       GCancellable* cancellable);
VALA_EXTERN GType photo_monitor_get_type (void) G_GNUC_CONST ;
static gboolean library_photo_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                                    DataSource* source);
static gchar* library_photo_source_collection_real_get_typename (MediaSourceCollection* base);
static gboolean library_photo_source_collection_real_is_file_recognized (MediaSourceCollection* base,
                                                                  GFile* file);
static void library_photo_source_collection_real_notify_contents_altered (DataCollection* base,
                                                                   GeeIterable* added,
                                                                   GeeIterable* removed);
static void library_photo_source_collection_on_editable_replaced (LibraryPhotoSourceCollection* self,
                                                           Photo* photo,
                                                           GFile* old_file,
                                                           GFile* new_file);
static void _library_photo_source_collection_on_editable_replaced_photo_editable_replaced (Photo* _sender,
                                                                                    GFile* old_file,
                                                                                    GFile* new_file,
                                                                                    gpointer self);
static void library_photo_source_collection_on_raw_development_modified (LibraryPhotoSourceCollection* self,
                                                                  Photo* _photo);
static void _library_photo_source_collection_on_raw_development_modified_photo_raw_development_modified (Photo* _sender,
                                                                                                  gpointer self);
static void library_photo_source_collection_real_items_altered (DataCollection* base,
                                                         GeeMap* items);
static void library_photo_source_collection_real_postprocess_imported_media (MediaSourceCollection* base,
                                                                      GeeCollection* media_sources);
VALA_EXTERN HierarchicalTagIndex* hierarchical_tag_utilities_process_hierarchical_import_keywords (GeeCollection* h_keywords);
static void library_photo_source_collection_real_notify_master_reimported (LibraryPhotoSourceCollection* self,
                                                                    LibraryPhoto* photo,
                                                                    PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_editable_reimported (LibraryPhotoSourceCollection* self,
                                                                      LibraryPhoto* photo,
                                                                      PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_source_reimported (LibraryPhotoSourceCollection* self,
                                                                    LibraryPhoto* photo,
                                                                    PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_baseline_reimported (LibraryPhotoSourceCollection* self,
                                                                      LibraryPhoto* photo,
                                                                      PhotoMetadata* metadata);
static MediaSource* library_photo_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base,
                                                                       gint64 numeric_id);
static MediaSource* library_photo_source_collection_real_fetch_by_source_id (MediaSourceCollection* base,
                                                                      const gchar* source_id);
static GeeCollection* library_photo_source_collection_real_get_event_source_ids (MediaSourceCollection* base,
                                                                          EventID* event_id);
static void library_photo_source_collection_compare_backing (LibraryPhotoSourceCollection* self,
                                                      LibraryPhoto* photo,
                                                      GFileInfo* info,
                                                      GeeCollection* matches_master,
                                                      GeeCollection* matches_editable,
                                                      GeeCollection* matches_development);
static gboolean library_photo_source_collection_real_has_backlink (SourceCollection* base,
                                                            SourceBacklink* backlink);
static void library_photo_source_collection_real_remove_backlink (SourceCollection* base,
                                                           SourceBacklink* backlink);
static void library_photo_source_collection_real_master_reimported (LibraryPhotoSourceCollection* self,
                                                             LibraryPhoto* photo,
                                                             PhotoMetadata* metadata);
static void g_cclosure_user_marshal_VOID__OBJECT_MEDIA_METADATA (GClosure * closure,
                                                          GValue * return_value,
                                                          guint n_param_values,
                                                          const GValue * param_values,
                                                          gpointer invocation_hint,
                                                          gpointer marshal_data);
static void library_photo_source_collection_real_editable_reimported (LibraryPhotoSourceCollection* self,
                                                               LibraryPhoto* photo,
                                                               PhotoMetadata* metadata);
static void library_photo_source_collection_real_baseline_reimported (LibraryPhotoSourceCollection* self,
                                                               LibraryPhoto* photo,
                                                               PhotoMetadata* metadata);
static void library_photo_source_collection_real_source_reimported (LibraryPhotoSourceCollection* self,
                                                             LibraryPhoto* photo,
                                                             PhotoMetadata* metadata);
static void library_photo_source_collection_finalize (DataCollection * obj);
static GType library_photo_source_collection_get_type_once (void);
static LibraryPhoto* library_photo_new (PhotoRow* row);
static LibraryPhoto* library_photo_construct (GType object_type,
                                       PhotoRow* row);
static void library_photo_generate_thumbnails (LibraryPhoto* self);
static void _library_photo_generate_thumbnails_one_shot_callback (gpointer self);
static LibraryPhoto* library_photo_new_from_import_params (PhotoImportParams* import_params);
static LibraryPhoto* library_photo_construct_from_import_params (GType object_type,
                                                          PhotoImportParams* import_params);
static void library_photo_real_notify_master_reimported (Photo* base,
                                                  PhotoMetadata* metadata);
static void library_photo_real_notify_editable_reimported (Photo* base,
                                                    PhotoMetadata* metadata);
static void library_photo_real_notify_source_reimported (Photo* base,
                                                  PhotoMetadata* metadata);
static void library_photo_real_notify_baseline_reimported (Photo* base,
                                                    PhotoMetadata* metadata);
static void library_photo_real_notify_altered (DataObject* base,
                                        Alteration* alteration);
static GdkPixbuf* library_photo_real_get_preview_pixbuf (MediaSource* base,
                                                  Scaling* scaling,
                                                  GError** error);
static void library_photo_real_rotate (Photo* base,
                                Rotation rotation);
static GdkPixbuf* library_photo_real_get_thumbnail (ThumbnailSource* base,
                                             gint scale,
                                             GError** error);
static void library_photo_duplicate_backing_photo (LibraryPhoto* self,
                                            BackingPhotoRow* backing,
                                            BackingPhotoID* result,
                                            GError** error);
VALA_EXTERN GFile* library_files_duplicate (GFile* src,
                                GFileProgressCallback progress_callback,
                                gpointer progress_callback_target,
                                gboolean blacklist,
                                GError** error);
static void library_photo_on_duplicate_progress (LibraryPhoto* self,
                                          gint64 current,
                                          gint64 total);
static void _library_photo_on_duplicate_progress_gfile_progress_callback (gint64 current_num_bytes,
                                                                   gint64 total_num_bytes,
                                                                   gpointer self);
static gboolean library_photo_real_is_trashed (MediaSource* base);
static void library_photo_real_trash (MediaSource* base);
static void library_photo_real_untrash (MediaSource* base);
static gboolean library_photo_real_is_offline (Monitorable* base);
static void library_photo_real_mark_offline (Monitorable* base);
static void library_photo_real_mark_online (Monitorable* base);
static gboolean library_photo_real_is_flagged (Flaggable* base);
static void library_photo_real_mark_flagged (Flaggable* base);
static void library_photo_real_mark_unflagged (Flaggable* base);
static gboolean library_photo_real_internal_delete_backing (DataSource* base,
                                                     GError** error);
static void library_photo_real_destroy (DataSource* base);
static gboolean library_photo_real_has_user_generated_metadata (Photo* base);
static void library_photo_real_set_user_metadata_for_export (Photo* base,
                                                      PhotoMetadata* metadata);
static void library_photo_real_apply_user_metadata_for_reimport (Photo* base,
                                                          PhotoMetadata* metadata);
VALA_EXTERN gchar* hierarchical_tag_utilities_make_flat_tag_safe (const gchar* in_tag);
VALA_EXTERN gchar* hierarchical_tag_utilities_flat_to_hierarchical (const gchar* name);
static void library_photo_finalize (GObject * obj);
static GType library_photo_get_type_once (void);
static void library_photo_source_holding_tank_real_notify_contents_altered (SourceHoldingTank* base,
                                                                     GeeCollection* added,
                                                                     GeeCollection* removed);
static void library_photo_source_holding_tank_on_editable_replaced (LibraryPhotoSourceHoldingTank* self,
                                                             Photo* _photo,
                                                             GFile* old_file,
                                                             GFile* new_file);
static void _library_photo_source_holding_tank_on_editable_replaced_photo_editable_replaced (Photo* _sender,
                                                                                      GFile* old_file,
                                                                                      GFile* new_file,
                                                                                      gpointer self);
static void library_photo_source_holding_tank_on_raw_development_modified (LibraryPhotoSourceHoldingTank* self,
                                                                    Photo* _photo);
static void _library_photo_source_holding_tank_on_raw_development_modified_photo_raw_development_modified (Photo* _sender,
                                                                                                    gpointer self);
static void library_photo_source_holding_tank_finalize (SourceHoldingTank * obj);
static GType library_photo_source_holding_tank_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* PHOTO_IMAGE_EXTENSIONS[69] = {"jpg", "jpeg", "jpe", "tiff", "tif", "png", "gif", "bmp", "ppm", "pgm", "pbm", "pnm", "thm", "tga", "ilbm", "pcx", "ecw", "img", "sid", "cd5", "fits", "pgf", "cgm", "svg", "odg", "eps", "pdf", "swf", "wmf", "emf", "xps", "pns", "jps", "mpo", "3fr", "arw", "srf", "sr2", "bay", "crw", "cr2", "cap", "iiq", "eip", "dcs", "dcr", "drf", "k25", "kdc", "dng", "erf", "fff", "mef", "mos", "mrw", "nef", "nrw", "orf", "ptx", "pef", "pxn", "r3d", "raf", "raw", "rw2", "rwl", "rwz", "x3f", "srw"};

static GType
backing_fetch_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{BACKING_FETCH_MODE_SOURCE, "BACKING_FETCH_MODE_SOURCE", "source"}, {BACKING_FETCH_MODE_BASELINE, "BACKING_FETCH_MODE_BASELINE", "baseline"}, {BACKING_FETCH_MODE_MASTER, "BACKING_FETCH_MODE_MASTER", "master"}, {BACKING_FETCH_MODE_UNMODIFIED, "BACKING_FETCH_MODE_UNMODIFIED", "unmodified"}, {0, NULL, NULL}};
	GType backing_fetch_mode_type_id;
	backing_fetch_mode_type_id = g_enum_register_static ("BackingFetchMode", values);
	return backing_fetch_mode_type_id;
}

GType
backing_fetch_mode_get_type (void)
{
	static volatile gsize backing_fetch_mode_type_id__once = 0;
	if (g_once_init_enter (&backing_fetch_mode_type_id__once)) {
		GType backing_fetch_mode_type_id;
		backing_fetch_mode_type_id = backing_fetch_mode_get_type_once ();
		g_once_init_leave (&backing_fetch_mode_type_id__once, backing_fetch_mode_type_id);
	}
	return backing_fetch_mode_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_thumbnails_ref0 (gpointer self)
{
	return self ? thumbnails_ref (self) : NULL;
}

PhotoImportParams*
photo_import_params_construct (GType object_type,
                               GFile* file,
                               GFile* final_associated_file,
                               ImportID* import_id,
                               PhotoFileSnifferOptions sniffer_options,
                               const gchar* exif_md5,
                               const gchar* thumbnail_md5,
                               const gchar* full_md5,
                               Thumbnails* thumbnails)
{
	PhotoImportParams* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	ImportID _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	Thumbnails* _tmp6_;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (import_id != NULL, NULL);
	self = (PhotoImportParams*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp0_;
	_tmp1_ = _g_object_ref0 (final_associated_file);
	_g_object_unref0 (self->final_associated_file);
	self->final_associated_file = _tmp1_;
	_tmp2_ = *import_id;
	self->import_id = _tmp2_;
	self->sniffer_options = sniffer_options;
	_tmp3_ = g_strdup (exif_md5);
	_g_free0 (self->exif_md5);
	self->exif_md5 = _tmp3_;
	_tmp4_ = g_strdup (thumbnail_md5);
	_g_free0 (self->thumbnail_md5);
	self->thumbnail_md5 = _tmp4_;
	_tmp5_ = g_strdup (full_md5);
	_g_free0 (self->full_md5);
	self->full_md5 = _tmp5_;
	_tmp6_ = _thumbnails_ref0 (thumbnails);
	_thumbnails_unref0 (self->thumbnails);
	self->thumbnails = _tmp6_;
	return self;
}

PhotoImportParams*
photo_import_params_new (GFile* file,
                         GFile* final_associated_file,
                         ImportID* import_id,
                         PhotoFileSnifferOptions sniffer_options,
                         const gchar* exif_md5,
                         const gchar* thumbnail_md5,
                         const gchar* full_md5,
                         Thumbnails* thumbnails)
{
	return photo_import_params_construct (TYPE_PHOTO_IMPORT_PARAMS, file, final_associated_file, import_id, sniffer_options, exif_md5, thumbnail_md5, full_md5, thumbnails);
}

PhotoImportParams*
photo_import_params_construct_create_placeholder (GType object_type,
                                                  GFile* file,
                                                  ImportID* import_id)
{
	PhotoImportParams* self = NULL;
	GFile* _tmp0_;
	ImportID _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (import_id != NULL, NULL);
	self = (PhotoImportParams*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp0_;
	_tmp1_ = *import_id;
	self->import_id = _tmp1_;
	self->sniffer_options = PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5;
	_g_free0 (self->exif_md5);
	self->exif_md5 = NULL;
	_g_free0 (self->thumbnail_md5);
	self->thumbnail_md5 = NULL;
	_g_free0 (self->full_md5);
	self->full_md5 = NULL;
	_thumbnails_unref0 (self->thumbnails);
	self->thumbnails = NULL;
	return self;
}

PhotoImportParams*
photo_import_params_new_create_placeholder (GFile* file,
                                            ImportID* import_id)
{
	return photo_import_params_construct_create_placeholder (TYPE_PHOTO_IMPORT_PARAMS, file, import_id);
}

static void
value_photo_import_params_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_photo_import_params_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_import_params_unref (value->data[0].v_pointer);
	}
}

static void
value_photo_import_params_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_import_params_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_photo_import_params_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_photo_import_params_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoImportParams * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_import_params_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_photo_import_params_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	PhotoImportParams ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_import_params_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_photo_import_params (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecPhotoImportParams* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_IMPORT_PARAMS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_photo_import_params (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_IMPORT_PARAMS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_photo_import_params (GValue* value,
                               gpointer v_object)
{
	PhotoImportParams * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_IMPORT_PARAMS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_IMPORT_PARAMS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_import_params_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_import_params_unref (old);
	}
}

void
value_take_photo_import_params (GValue* value,
                                gpointer v_object)
{
	PhotoImportParams * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_IMPORT_PARAMS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_IMPORT_PARAMS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_import_params_unref (old);
	}
}

static void
photo_import_params_class_init (PhotoImportParamsClass * klass,
                                gpointer klass_data)
{
	photo_import_params_parent_class = g_type_class_peek_parent (klass);
	((PhotoImportParamsClass *) klass)->finalize = photo_import_params_finalize;
}

static void
photo_import_params_instance_init (PhotoImportParams * self,
                                   gpointer klass)
{
	PhotoRow* _tmp0_;
	self->final_associated_file = NULL;
	_tmp0_ = photo_row_new ();
	self->row = _tmp0_;
	self->keywords = NULL;
	self->ref_count = 1;
}

static void
photo_import_params_finalize (PhotoImportParams * obj)
{
	PhotoImportParams * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParams);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->file);
	_g_object_unref0 (self->final_associated_file);
	_g_free0 (self->exif_md5);
	_g_free0 (self->thumbnail_md5);
	_g_free0 (self->full_md5);
	_thumbnails_unref0 (self->thumbnails);
	_photo_row_unref0 (self->row);
	_g_object_unref0 (self->keywords);
}

static GType
photo_import_params_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_photo_import_params_init, value_photo_import_params_free_value, value_photo_import_params_copy_value, value_photo_import_params_peek_pointer, "p", value_photo_import_params_collect_value, "p", value_photo_import_params_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoImportParamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_import_params_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoImportParams), 0, (GInstanceInitFunc) photo_import_params_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_import_params_type_id;
	photo_import_params_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoImportParams", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return photo_import_params_type_id;
}

GType
photo_import_params_get_type (void)
{
	static volatile gsize photo_import_params_type_id__once = 0;
	if (g_once_init_enter (&photo_import_params_type_id__once)) {
		GType photo_import_params_type_id;
		photo_import_params_type_id = photo_import_params_get_type_once ();
		g_once_init_leave (&photo_import_params_type_id__once, photo_import_params_type_id);
	}
	return photo_import_params_type_id__once;
}

gpointer
photo_import_params_ref (gpointer instance)
{
	PhotoImportParams * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_import_params_unref (gpointer instance)
{
	PhotoImportParams * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_IMPORT_PARAMS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
photo_transformation_state_get_instance_private (PhotoTransformationState* self)
{
	return G_STRUCT_MEMBER_P (self, PhotoTransformationState_private_offset);
}

PhotoTransformationState*
photo_transformation_state_construct (GType object_type)
{
	PhotoTransformationState * self = NULL;
	self = (PhotoTransformationState*) g_object_new (object_type, NULL);
	return self;
}

gboolean
photo_transformation_state_is_broken (PhotoTransformationState* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->is_broke;
	return result;
}

static void
photo_transformation_state_real_broken (PhotoTransformationState* self)
{
	self->priv->is_broke = TRUE;
}

static void
photo_transformation_state_class_init (PhotoTransformationStateClass * klass,
                                       gpointer klass_data)
{
	photo_transformation_state_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PhotoTransformationState_private_offset);
	((PhotoTransformationStateClass *) klass)->broken = photo_transformation_state_real_broken;
	G_OBJECT_CLASS (klass)->finalize = photo_transformation_state_finalize;
	photo_transformation_state_signals[PHOTO_TRANSFORMATION_STATE_BROKEN_SIGNAL] = g_signal_new ("broken", TYPE_PHOTO_TRANSFORMATION_STATE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoTransformationStateClass, broken), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
photo_transformation_state_instance_init (PhotoTransformationState * self,
                                          gpointer klass)
{
	self->priv = photo_transformation_state_get_instance_private (self);
	self->priv->is_broke = FALSE;
}

static void
photo_transformation_state_finalize (GObject * obj)
{
	PhotoTransformationState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationState);
	G_OBJECT_CLASS (photo_transformation_state_parent_class)->finalize (obj);
}

static GType
photo_transformation_state_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoTransformationStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_transformation_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoTransformationState), 0, (GInstanceInitFunc) photo_transformation_state_instance_init, NULL };
	GType photo_transformation_state_type_id;
	photo_transformation_state_type_id = g_type_register_static (G_TYPE_OBJECT, "PhotoTransformationState", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	PhotoTransformationState_private_offset = g_type_add_instance_private (photo_transformation_state_type_id, sizeof (PhotoTransformationStatePrivate));
	return photo_transformation_state_type_id;
}

GType
photo_transformation_state_get_type (void)
{
	static volatile gsize photo_transformation_state_type_id__once = 0;
	if (g_once_init_enter (&photo_transformation_state_type_id__once)) {
		GType photo_transformation_state_type_id;
		photo_transformation_state_type_id = photo_transformation_state_get_type_once ();
		g_once_init_leave (&photo_transformation_state_type_id__once, photo_transformation_state_type_id);
	}
	return photo_transformation_state_type_id__once;
}

static inline gpointer
photo_get_instance_private (Photo* self)
{
	return G_STRUCT_MEMBER_P (self, Photo_private_offset);
}

gboolean
photo_exception_prohibits (PhotoException self,
                           PhotoException exception)
{
	gboolean result;
	result = (self & exception) != 0;
	return result;
}

gboolean
photo_exception_allows (PhotoException self,
                        PhotoException exception)
{
	gboolean result;
	result = (self & exception) == 0;
	return result;
}

static GType
photo_exception_get_type_once (void)
{
	static const GEnumValue values[] = {{PHOTO_EXCEPTION_NONE, "PHOTO_EXCEPTION_NONE", "none"}, {PHOTO_EXCEPTION_ORIENTATION, "PHOTO_EXCEPTION_ORIENTATION", "orientation"}, {PHOTO_EXCEPTION_CROP, "PHOTO_EXCEPTION_CROP", "crop"}, {PHOTO_EXCEPTION_REDEYE, "PHOTO_EXCEPTION_REDEYE", "redeye"}, {PHOTO_EXCEPTION_ADJUST, "PHOTO_EXCEPTION_ADJUST", "adjust"}, {PHOTO_EXCEPTION_STRAIGHTEN, "PHOTO_EXCEPTION_STRAIGHTEN", "straighten"}, {PHOTO_EXCEPTION_ALL, "PHOTO_EXCEPTION_ALL", "all"}, {0, NULL, NULL}};
	GType photo_exception_type_id;
	photo_exception_type_id = g_enum_register_static ("PhotoException", values);
	return photo_exception_type_id;
}

GType
photo_exception_get_type (void)
{
	static volatile gsize photo_exception_type_id__once = 0;
	if (g_once_init_enter (&photo_exception_type_id__once)) {
		GType photo_exception_type_id;
		photo_exception_type_id = photo_exception_get_type_once ();
		g_once_init_leave (&photo_exception_type_id__once, photo_exception_type_id);
	}
	return photo_exception_type_id__once;
}

static gpointer
_photo_row_ref0 (gpointer self)
{
	return self ? photo_row_ref (self) : NULL;
}

static gpointer
_backing_photo_row_ref0 (gpointer self)
{
	return self ? backing_photo_row_ref (self) : NULL;
}

Photo*
photo_construct (GType object_type,
                 PhotoRow* row)
{
	Photo * self = NULL;
	PhotoRow* _tmp0_;
	PhotoRow* _tmp1_;
	PhotoRow* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	PhotoRow* _tmp5_;
	PhotoRow* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	PhotoBackingReaders* _tmp9_;
	BackingPhotoRow* _tmp10_;
	BackingPhotoRow* _tmp11_;
	const gchar* _tmp12_;
	PhotoFileReader* _tmp13_;
	gchar* basename = NULL;
	BackingPhotoRow* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp20_;
	BackingPhotoID _tmp24_;
	BackingPhotoRow* _tmp38_;
	gboolean _tmp50_ = FALSE;
	BackingPhotoRow* _tmp51_;
	PhotoBackingReaders* _tmp60_;
	PhotoFileReader* _tmp61_;
	PhotoRow* _tmp74_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (row != NULL, NULL);
	self = (Photo*) photo_source_construct (object_type, DATA_OBJECT_INVALID_OBJECT_ID);
	_tmp0_ = _photo_row_ref0 (row);
	_photo_row_unref0 (self->row);
	self->row = _tmp0_;
	_tmp1_ = self->row;
	_tmp2_ = self->row;
	_tmp3_ = _tmp2_->title;
	_tmp4_ = media_source_prep_title (_tmp3_);
	_g_free0 (_tmp1_->title);
	_tmp1_->title = _tmp4_;
	_tmp5_ = self->row;
	_tmp6_ = self->row;
	_tmp7_ = _tmp6_->comment;
	_tmp8_ = media_source_prep_comment (_tmp7_);
	_g_free0 (_tmp5_->comment);
	_tmp5_->comment = _tmp8_;
	_tmp9_ = self->priv->readers;
	_tmp10_ = row->master;
	_tmp11_ = row->master;
	_tmp12_ = _tmp11_->filepath;
	_tmp13_ = photo_file_format_create_reader (_tmp10_->file_format, _tmp12_);
	_photo_file_adapter_unref0 (_tmp9_->master);
	_tmp9_->master = _tmp13_;
	_tmp14_ = row->master;
	_tmp15_ = _tmp14_->filepath;
	_tmp16_ = string_sliced_at_last_char (_tmp15_, (gunichar) G_DIR_SEPARATOR, 0);
	basename = _tmp16_;
	_tmp17_ = basename;
	if (_tmp17_ != NULL) {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp18_ = basename;
		_tmp19_ = string_sliced_at (_tmp18_, 1);
		_g_free0 (self->priv->file_title);
		self->priv->file_title = _tmp19_;
	}
	_tmp20_ = self->priv->file_title;
	if (is_string_empty (_tmp20_)) {
		BackingPhotoRow* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp21_ = row->master;
		_tmp22_ = _tmp21_->filepath;
		_tmp23_ = g_strdup (_tmp22_);
		_g_free0 (self->priv->file_title);
		self->priv->file_title = _tmp23_;
	}
	_tmp24_ = row->editable_id;
	if (_tmp24_.id != BACKING_PHOTO_ID_INVALID) {
		BackingPhotoRow* e = NULL;
		BackingPhotoID _tmp25_;
		BackingPhotoRow* _tmp26_;
		BackingPhotoRow* _tmp27_;
		_tmp25_ = row->editable_id;
		_tmp26_ = photo_get_backing_row (self, &_tmp25_);
		e = _tmp26_;
		_tmp27_ = e;
		if (_tmp27_ != NULL) {
			BackingPhotoRow* _tmp28_;
			BackingPhotoRow* _tmp29_;
			PhotoBackingReaders* _tmp30_;
			BackingPhotoRow* _tmp31_;
			BackingPhotoRow* _tmp32_;
			const gchar* _tmp33_;
			PhotoFileReader* _tmp34_;
			_tmp28_ = e;
			_tmp29_ = _backing_photo_row_ref0 (_tmp28_);
			_backing_photo_row_unref0 (self->priv->editable);
			self->priv->editable = _tmp29_;
			_tmp30_ = self->priv->readers;
			_tmp31_ = self->priv->editable;
			_tmp32_ = self->priv->editable;
			_tmp33_ = _tmp32_->filepath;
			_tmp34_ = photo_file_format_create_reader (_tmp31_->file_format, _tmp33_);
			_photo_file_adapter_unref0 (_tmp30_->editable);
			_tmp30_->editable = _tmp34_;
		} else {
			{
				PhotoTable* _tmp35_;
				PhotoTable* _tmp36_;
				PhotoRow* _tmp37_;
				_tmp35_ = photo_table_get_instance ();
				_tmp36_ = _tmp35_;
				_tmp37_ = self->row;
				photo_table_detach_editable (_tmp36_, _tmp37_, &_inner_error0_);
				_database_table_unref0 (_tmp36_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch0_database_error;
					}
					_backing_photo_row_unref0 (e);
					_g_free0 (basename);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			goto __finally0;
			__catch0_database_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_backing_photo_row_unref0 (e);
				_g_free0 (basename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			photo_internal_remove_all_transformations (self, FALSE);
		}
		_backing_photo_row_unref0 (e);
	}
	_tmp38_ = row->master;
	if (_tmp38_->file_format == PHOTO_FILE_FORMAT_RAW) {
		GeeHashMap* _tmp39_;
		gint _tmp40_ = 0;
		RawDeveloper* _tmp41_;
		_tmp39_ = gee_hash_map_new (TYPE_RAW_DEVELOPER, NULL, NULL, TYPE_BACKING_PHOTO_ROW, (GBoxedCopyFunc) backing_photo_row_ref, (GDestroyNotify) backing_photo_row_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->developments);
		self->priv->developments = _tmp39_;
		_tmp41_ = raw_developer_as_array (&_tmp40_);
		{
			RawDeveloper* d_collection = NULL;
			gint d_collection_length1 = 0;
			gint _d_collection_size_ = 0;
			gint d_it = 0;
			d_collection = _tmp41_;
			d_collection_length1 = _tmp40_;
			for (d_it = 0; d_it < d_collection_length1; d_it = d_it + 1) {
				RawDeveloper d = 0;
				d = d_collection[d_it];
				{
					BackingPhotoID id = {0};
					BackingPhotoID* _tmp42_;
					gint _tmp42__length1;
					BackingPhotoID _tmp43_;
					BackingPhotoID _tmp44_;
					_tmp42_ = row->development_ids;
					_tmp42__length1 = row->development_ids_length1;
					_tmp43_ = _tmp42_[d];
					id = _tmp43_;
					_tmp44_ = id;
					if (_tmp44_.id != BACKING_PHOTO_ID_INVALID) {
						BackingPhotoRow* bpr = NULL;
						BackingPhotoID _tmp45_;
						BackingPhotoRow* _tmp46_;
						BackingPhotoRow* _tmp47_;
						_tmp45_ = id;
						_tmp46_ = photo_get_backing_row (self, &_tmp45_);
						bpr = _tmp46_;
						_tmp47_ = bpr;
						if (_tmp47_ != NULL) {
							GeeHashMap* _tmp48_;
							BackingPhotoRow* _tmp49_;
							_tmp48_ = self->priv->developments;
							_tmp49_ = bpr;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp48_, (gpointer) ((gintptr) d), _tmp49_);
						}
						_backing_photo_row_unref0 (bpr);
					}
				}
			}
			d_collection = (g_free (d_collection), NULL);
		}
	}
	_tmp51_ = row->master;
	if (_tmp51_->file_format == PHOTO_FILE_FORMAT_RAW) {
		GeeHashMap* _tmp52_;
		_tmp52_ = self->priv->developments;
		_tmp50_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp52_, (gpointer) ((gintptr) row->developer));
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		BackingPhotoRow* r = NULL;
		GeeHashMap* _tmp53_;
		gpointer _tmp54_;
		PhotoBackingReaders* _tmp55_;
		BackingPhotoRow* _tmp56_;
		BackingPhotoRow* _tmp57_;
		const gchar* _tmp58_;
		PhotoFileReader* _tmp59_;
		_tmp53_ = self->priv->developments;
		_tmp54_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp53_, (gpointer) ((gintptr) row->developer));
		r = (BackingPhotoRow*) _tmp54_;
		_tmp55_ = self->priv->readers;
		_tmp56_ = r;
		_tmp57_ = r;
		_tmp58_ = _tmp57_->filepath;
		_tmp59_ = photo_file_format_create_reader (_tmp56_->file_format, _tmp58_);
		_photo_file_adapter_unref0 (_tmp55_->developer);
		_tmp55_->developer = _tmp59_;
		_backing_photo_row_unref0 (r);
	}
	_tmp60_ = self->priv->readers;
	_tmp61_ = _tmp60_->editable;
	if (_tmp61_ != NULL) {
		BackingPhotoRow* _tmp62_;
		BackingPhotoRow* _tmp63_;
		_tmp62_ = self->priv->editable;
		_tmp63_ = _backing_photo_row_ref0 (_tmp62_);
		_backing_photo_row_unref0 (self->backing_photo_row);
		self->backing_photo_row = _tmp63_;
	} else {
		BackingPhotoRow* _tmp64_;
		_tmp64_ = row->master;
		if (_tmp64_->file_format != PHOTO_FILE_FORMAT_RAW) {
			PhotoRow* _tmp65_;
			BackingPhotoRow* _tmp66_;
			BackingPhotoRow* _tmp67_;
			_tmp65_ = self->row;
			_tmp66_ = _tmp65_->master;
			_tmp67_ = _backing_photo_row_ref0 (_tmp66_);
			_backing_photo_row_unref0 (self->backing_photo_row);
			self->backing_photo_row = _tmp67_;
		} else {
			GeeHashMap* _tmp68_;
			_tmp68_ = self->priv->developments;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp68_, (gpointer) ((gintptr) row->developer))) {
				GeeHashMap* _tmp69_;
				gpointer _tmp70_;
				_tmp69_ = self->priv->developments;
				_tmp70_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp69_, (gpointer) ((gintptr) row->developer));
				_backing_photo_row_unref0 (self->backing_photo_row);
				self->backing_photo_row = (BackingPhotoRow*) _tmp70_;
			} else {
				PhotoRow* _tmp71_;
				BackingPhotoRow* _tmp72_;
				BackingPhotoRow* _tmp73_;
				_tmp71_ = self->row;
				_tmp72_ = _tmp71_->master;
				_tmp73_ = _backing_photo_row_ref0 (_tmp72_);
				_backing_photo_row_unref0 (self->backing_photo_row);
				self->backing_photo_row = _tmp73_;
			}
		}
	}
	_tmp74_ = self->row;
	self->priv->cached_exposure_time = _tmp74_->exposure_time;
	_g_free0 (basename);
	return self;
}

static void
photo_real_notify_editable_replaced (Photo* self,
                                     GFile* old_file,
                                     GFile* new_file)
{
	g_signal_emit (self, photo_signals[PHOTO_EDITABLE_REPLACED_SIGNAL], 0, old_file, new_file);
}

void
photo_notify_editable_replaced (Photo* self,
                                GFile* old_file,
                                GFile* new_file)
{
	PhotoClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->notify_editable_replaced) {
		_klass_->notify_editable_replaced (self, old_file, new_file);
	}
}

static void
photo_real_notify_raw_development_modified (Photo* self)
{
	g_signal_emit (self, photo_signals[PHOTO_RAW_DEVELOPMENT_MODIFIED_SIGNAL], 0);
}

void
photo_notify_raw_development_modified (Photo* self)
{
	PhotoClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->notify_raw_development_modified) {
		_klass_->notify_raw_development_modified (self);
	}
}

static void
photo_real_notify_baseline_replaced (Photo* self)
{
	g_signal_emit (self, photo_signals[PHOTO_BASELINE_REPLACED_SIGNAL], 0);
}

void
photo_notify_baseline_replaced (Photo* self)
{
	PhotoClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->notify_baseline_replaced) {
		_klass_->notify_baseline_replaced (self);
	}
}

static void
photo_real_notify_master_reimported (Photo* self,
                                     PhotoMetadata* metadata)
{
	g_signal_emit (self, photo_signals[PHOTO_MASTER_REIMPORTED_SIGNAL], 0, metadata);
}

void
photo_notify_master_reimported (Photo* self,
                                PhotoMetadata* metadata)
{
	PhotoClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->notify_master_reimported) {
		_klass_->notify_master_reimported (self, metadata);
	}
}

static void
photo_real_notify_editable_reimported (Photo* self,
                                       PhotoMetadata* metadata)
{
	g_signal_emit (self, photo_signals[PHOTO_EDITABLE_REIMPORTED_SIGNAL], 0, metadata);
}

void
photo_notify_editable_reimported (Photo* self,
                                  PhotoMetadata* metadata)
{
	PhotoClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->notify_editable_reimported) {
		_klass_->notify_editable_reimported (self, metadata);
	}
}

static void
photo_real_notify_source_reimported (Photo* self,
                                     PhotoMetadata* metadata)
{
	g_signal_emit (self, photo_signals[PHOTO_SOURCE_REIMPORTED_SIGNAL], 0, metadata);
}

void
photo_notify_source_reimported (Photo* self,
                                PhotoMetadata* metadata)
{
	PhotoClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->notify_source_reimported) {
		_klass_->notify_source_reimported (self, metadata);
	}
}

static void
photo_real_notify_baseline_reimported (Photo* self,
                                       PhotoMetadata* metadata)
{
	g_signal_emit (self, photo_signals[PHOTO_BASELINE_REIMPORTED_SIGNAL], 0, metadata);
}

void
photo_notify_baseline_reimported (Photo* self,
                                  PhotoMetadata* metadata)
{
	PhotoClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->notify_baseline_reimported) {
		_klass_->notify_baseline_reimported (self, metadata);
	}
}

static gboolean
photo_real_internal_delete_backing (DataSource* base,
                                    GError** error)
{
	Photo * self;
	gboolean ret = FALSE;
	GFile* file = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (Photo*) base;
	ret = TRUE;
	file = NULL;
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			if (_tmp2_ != NULL) {
				PhotoBackingReaders* _tmp3_;
				PhotoFileReader* _tmp4_;
				GFile* _tmp5_;
				_tmp3_ = self->priv->readers;
				_tmp4_ = _tmp3_->editable;
				_tmp5_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp4_);
				_g_object_unref0 (file);
				file = _tmp5_;
			}
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp6_;
			_tmp6_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (file);
			return _tmp7_;
		}
	}
	photo_detach_editable (self, TRUE, FALSE, TRUE);
	if (photo_get_master_file_format (self) == PHOTO_FILE_FORMAT_RAW) {
		gint _tmp8_ = 0;
		RawDeveloper* _tmp9_;
		_tmp9_ = raw_developer_as_array (&_tmp8_);
		{
			RawDeveloper* d_collection = NULL;
			gint d_collection_length1 = 0;
			gint _d_collection_size_ = 0;
			gint d_it = 0;
			d_collection = _tmp9_;
			d_collection_length1 = _tmp8_;
			for (d_it = 0; d_it < d_collection_length1; d_it = d_it + 1) {
				RawDeveloper d = 0;
				d = d_collection[d_it];
				{
					photo_delete_raw_development (self, d);
				}
			}
			d_collection = (g_free (d_collection), NULL);
		}
	}
	media_source_delete_original_file ((MediaSource*) self);
	_tmp11_ = DATA_SOURCE_CLASS (photo_parent_class)->internal_delete_backing ((DataSource*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp12_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		return _tmp12_;
	}
	if (_tmp11_) {
		_tmp10_ = ret;
	} else {
		_tmp10_ = FALSE;
	}
	result = _tmp10_;
	_g_object_unref0 (file);
	return result;
}

static BackingPhotoRow*
photo_get_backing_row (Photo* self,
                       BackingPhotoID* id)
{
	BackingPhotoID _tmp0_;
	BackingPhotoRow* backing_row = NULL;
	BackingPhotoRow* _tmp12_;
	GError* _inner_error0_ = NULL;
	BackingPhotoRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = *id;
	if (_tmp0_.id == BACKING_PHOTO_ID_INVALID) {
		result = NULL;
		return result;
	}
	backing_row = NULL;
	{
		BackingPhotoRow* _tmp1_ = NULL;
		BackingPhotoTable* _tmp2_;
		BackingPhotoTable* _tmp3_;
		BackingPhotoID _tmp4_;
		BackingPhotoRow* _tmp5_;
		BackingPhotoRow* _tmp6_;
		BackingPhotoRow* _tmp7_;
		_tmp2_ = backing_photo_table_get_instance ();
		_tmp3_ = _tmp2_;
		_tmp4_ = *id;
		_tmp5_ = backing_photo_table_fetch (_tmp3_, &_tmp4_, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_database_table_unref0 (_tmp3_);
		_tmp1_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_backing_photo_row_unref0 (backing_row);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp7_ = _tmp1_;
		_tmp1_ = NULL;
		_backing_photo_row_unref0 (backing_row);
		backing_row = _tmp7_;
		_backing_photo_row_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = data_object_to_string ((DataObject*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = err;
		_tmp11_ = _tmp10_->message;
		g_warning ("Photo.vala:470: Unable to fetch backing state for %s: %s", _tmp9_, _tmp11_);
		_g_free0 (_tmp9_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_backing_photo_row_unref0 (backing_row);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp12_ = backing_row;
	if (_tmp12_ == NULL) {
		{
			BackingPhotoTable* _tmp13_;
			BackingPhotoTable* _tmp14_;
			BackingPhotoID _tmp15_;
			_tmp13_ = backing_photo_table_get_instance ();
			_tmp14_ = _tmp13_;
			_tmp15_ = *id;
			backing_photo_table_remove (_tmp14_, &_tmp15_, &_inner_error0_);
			_database_table_unref0 (_tmp14_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch1_database_error;
				}
				_backing_photo_row_unref0 (backing_row);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		goto __finally1;
		__catch1_database_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_backing_photo_row_unref0 (backing_row);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		result = NULL;
		_backing_photo_row_unref0 (backing_row);
		return result;
	}
	result = backing_row;
	return result;
}

gboolean
photo_is_raw_developer_complete (Photo* self,
                                 RawDeveloper d)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeHashMap* _tmp0_;
		gboolean _tmp9_ = FALSE;
		_tmp0_ = self->priv->developments;
		g_rec_mutex_lock (&self->priv->__lock_developments);
		{
			gboolean _tmp1_ = FALSE;
			GeeHashMap* _tmp2_;
			_tmp2_ = self->priv->developments;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, (gpointer) ((gintptr) d))) {
				GeeHashMap* _tmp3_;
				gpointer _tmp4_;
				BackingPhotoRow* _tmp5_;
				const gchar* _tmp6_;
				_tmp3_ = self->priv->developments;
				_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, (gpointer) ((gintptr) d));
				_tmp5_ = (BackingPhotoRow*) _tmp4_;
				_tmp6_ = _tmp5_->filepath;
				_tmp1_ = g_file_test (_tmp6_, G_FILE_TEST_EXISTS);
				_backing_photo_row_unref0 (_tmp5_);
			} else {
				_tmp1_ = FALSE;
			}
			result = _tmp1_;
			{
				GeeHashMap* _tmp7_;
				_tmp7_ = self->priv->developments;
				g_rec_mutex_unlock (&self->priv->__lock_developments);
			}
			return result;
		}
		__finally0:
		{
			GeeHashMap* _tmp8_;
			_tmp8_ = self->priv->developments;
			g_rec_mutex_unlock (&self->priv->__lock_developments);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
}

gboolean
photo_is_raw_developer_available (Photo* self,
                                  RawDeveloper d)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->developments;
		g_rec_mutex_lock (&self->priv->__lock_developments);
		{
			GeeHashMap* _tmp1_;
			_tmp1_ = self->priv->developments;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) d))) {
				result = TRUE;
				{
					GeeHashMap* _tmp2_;
					_tmp2_ = self->priv->developments;
					g_rec_mutex_unlock (&self->priv->__lock_developments);
				}
				return result;
			}
		}
		__finally0:
		{
			GeeHashMap* _tmp3_;
			_tmp3_ = self->priv->developments;
			g_rec_mutex_unlock (&self->priv->__lock_developments);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
	}
	switch (d) {
		case RAW_DEVELOPER_SHOTWELL:
		{
			result = TRUE;
			return result;
		}
		case RAW_DEVELOPER_CAMERA:
		{
			result = FALSE;
			return result;
		}
		case RAW_DEVELOPER_EMBEDDED:
		{
			{
				PhotoMetadata* meta = NULL;
				PhotoMetadata* _tmp5_;
				guint num_previews = 0U;
				PhotoMetadata* _tmp6_;
				_tmp5_ = photo_get_master_metadata (self, &_inner_error0_);
				meta = _tmp5_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp6_ = meta;
				num_previews = photo_metadata_get_preview_count (_tmp6_);
				if (num_previews > ((guint) 0)) {
					PhotoPreview* prev = NULL;
					PhotoMetadata* _tmp7_;
					PhotoPreview* _tmp8_;
					PhotoPreview* _tmp9_;
					Dimensions dims = {0};
					PhotoPreview* _tmp10_;
					Dimensions _tmp11_ = {0};
					gint _tmp12_ = 0;
					Dimensions _tmp13_;
					Dimensions _tmp14_;
					gint preview_major_axis = 0;
					_tmp7_ = meta;
					_tmp8_ = photo_metadata_get_preview (_tmp7_, num_previews - 1);
					prev = _tmp8_;
					_tmp9_ = prev;
					if (_tmp9_ == NULL) {
						result = FALSE;
						_photo_preview_unref0 (prev);
						_media_metadata_unref0 (meta);
						return result;
					}
					_tmp10_ = prev;
					photo_preview_get_pixel_dimensions (_tmp10_, &_tmp11_);
					dims = _tmp11_;
					_tmp13_ = dims;
					_tmp14_ = dims;
					if (_tmp13_.width > _tmp14_.height) {
						Dimensions _tmp15_;
						_tmp15_ = dims;
						_tmp12_ = _tmp15_.width;
					} else {
						Dimensions _tmp16_;
						_tmp16_ = dims;
						_tmp12_ = _tmp16_.height;
					}
					preview_major_axis = _tmp12_;
					if (preview_major_axis < PHOTO_MIN_EMBEDDED_SIZE) {
						result = FALSE;
						_photo_preview_unref0 (prev);
						_media_metadata_unref0 (meta);
						return result;
					}
					result = TRUE;
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					return result;
				}
				result = FALSE;
				_media_metadata_unref0 (meta);
				return result;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp17_;
				const gchar* _tmp18_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp17_ = e;
				_tmp18_ = _tmp17_->message;
				g_debug ("Photo.vala:537: Error accessing embedded preview. Message: %s", _tmp18_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp19_ = FALSE;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp19_;
			}
			result = FALSE;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

void
photo_add_backing_photo_for_development (Photo* self,
                                         RawDeveloper d,
                                         BackingPhotoRow* bpr,
                                         GError** error)
{
	PhotoRow* _tmp0_;
	Alteration* _tmp4_;
	Alteration* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bpr != NULL);
	_tmp0_ = self->row;
	photo_import_developed_backing_photo (_tmp0_, d, bpr, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	{
		GeeHashMap* _tmp1_;
		_tmp1_ = self->priv->developments;
		g_rec_mutex_lock (&self->priv->__lock_developments);
		{
			GeeHashMap* _tmp2_;
			_tmp2_ = self->priv->developments;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, (gpointer) ((gintptr) d), bpr);
		}
		__finally0:
		{
			GeeHashMap* _tmp3_;
			_tmp3_ = self->priv->developments;
			g_rec_mutex_unlock (&self->priv->__lock_developments);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
	_tmp4_ = alteration_new ("image", "developer");
	_tmp5_ = _tmp4_;
	data_object_notify_altered ((DataObject*) self, _tmp5_);
	_alteration_unref0 (_tmp5_);
}

void
photo_import_developed_backing_photo (PhotoRow* row,
                                      RawDeveloper d,
                                      BackingPhotoRow* bpr,
                                      GError** error)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* info = NULL;
	GFile* _tmp2_;
	GFileInfo* _tmp3_;
	gint64 mod_time = 0LL;
	GFileInfo* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	gint64 _tmp7_;
	PhotoFileInterrogator* interrogator = NULL;
	GFile* _tmp8_;
	PhotoFileInterrogator* _tmp9_;
	PhotoFileInterrogator* _tmp10_;
	DetectedPhotoInformation* detected = NULL;
	PhotoFileInterrogator* _tmp11_;
	DetectedPhotoInformation* _tmp12_;
	DetectedPhotoInformation* _tmp13_;
	Dimensions _tmp14_;
	GFileInfo* _tmp15_;
	Orientation _tmp16_ = 0;
	DetectedPhotoInformation* _tmp17_;
	PhotoMetadata* _tmp18_;
	BackingPhotoTable* _tmp21_;
	BackingPhotoTable* _tmp22_;
	PhotoTable* _tmp23_;
	PhotoTable* _tmp24_;
	BackingPhotoID _tmp25_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (row != NULL);
	g_return_if_fail (bpr != NULL);
	_tmp0_ = bpr->filepath;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_info (_tmp2_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
	info = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		return;
	}
	_tmp4_ = info;
	_tmp5_ = g_file_info_get_modification_date_time (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_date_time_to_unix (_tmp6_);
	_g_date_time_unref0 (_tmp6_);
	mod_time = _tmp7_;
	_tmp8_ = file;
	_tmp9_ = photo_file_interrogator_new (_tmp8_, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL);
	interrogator = _tmp9_;
	_tmp10_ = interrogator;
	photo_file_interrogator_interrogate (_tmp10_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_interrogator_unref0 (interrogator);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return;
	}
	_tmp11_ = interrogator;
	_tmp12_ = photo_file_interrogator_get_detected_photo_information (_tmp11_);
	detected = _tmp12_;
	_tmp13_ = detected;
	_tmp14_ = _tmp13_->image_dim;
	bpr->dim = _tmp14_;
	_tmp15_ = info;
	bpr->filesize = g_file_info_get_size (_tmp15_);
	bpr->timestamp = mod_time;
	_tmp17_ = detected;
	_tmp18_ = _tmp17_->metadata;
	if (_tmp18_ != NULL) {
		DetectedPhotoInformation* _tmp19_;
		PhotoMetadata* _tmp20_;
		_tmp19_ = detected;
		_tmp20_ = _tmp19_->metadata;
		_tmp16_ = photo_metadata_get_orientation (_tmp20_);
	} else {
		_tmp16_ = ORIENTATION_TOP_LEFT;
	}
	bpr->original_orientation = _tmp16_;
	_tmp21_ = backing_photo_table_get_instance ();
	_tmp22_ = _tmp21_;
	backing_photo_table_add (_tmp22_, bpr, &_inner_error0_);
	_database_table_unref0 (_tmp22_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_detected_photo_information_unref0 (detected);
		_photo_file_interrogator_unref0 (interrogator);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return;
	}
	_tmp23_ = photo_table_get_instance ();
	_tmp24_ = _tmp23_;
	_tmp25_ = bpr->id;
	photo_table_update_raw_development (_tmp24_, row, d, &_tmp25_, &_inner_error0_);
	_database_table_unref0 (_tmp24_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_detected_photo_information_unref0 (detected);
		_photo_file_interrogator_unref0 (interrogator);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return;
	}
	_detected_photo_information_unref0 (detected);
	_photo_file_interrogator_unref0 (interrogator);
	_g_object_unref0 (info);
	_g_object_unref0 (file);
}

static void
photo_develop_photo (Photo* self,
                     RawDeveloper d)
{
	gboolean wrote_img_to_disk = FALSE;
	BackingPhotoRow* bps = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	wrote_img_to_disk = FALSE;
	bps = NULL;
	switch (d) {
		case RAW_DEVELOPER_SHOTWELL:
		{
			{
				BackingPhotoRow* _tmp0_ = NULL;
				PhotoRow* _tmp1_;
				BackingPhotoRow* _tmp2_;
				const gchar* _tmp3_;
				BackingPhotoRow* _tmp4_;
				BackingPhotoRow* _tmp5_;
				GdkPixbuf* pix = NULL;
				GdkPixbuf* _tmp13_;
				PhotoFileWriter* writer = NULL;
				BackingPhotoRow* _tmp17_;
				const gchar* _tmp18_;
				PhotoFileWriter* _tmp19_;
				PhotoFileWriter* _tmp20_;
				GdkPixbuf* _tmp21_;
				PhotoMetadata* meta = NULL;
				PhotoMetadata* _tmp22_;
				PhotoFileMetadataWriter* mwriter = NULL;
				BackingPhotoRow* _tmp23_;
				const gchar* _tmp24_;
				PhotoFileMetadataWriter* _tmp25_;
				PhotoFileMetadataWriter* _tmp26_;
				PhotoMetadata* _tmp27_;
				_tmp1_ = self->row;
				_tmp2_ = _tmp1_->master;
				_tmp3_ = _tmp2_->filepath;
				_tmp4_ = raw_developer_create_backing_row_for_development (d, _tmp3_, NULL, &_inner_error0_);
				_tmp0_ = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp5_ = _tmp0_;
				_tmp0_ = NULL;
				_backing_photo_row_unref0 (bps);
				bps = _tmp5_;
				pix = NULL;
				{
					PhotoBackingReaders* _tmp6_;
					_tmp6_ = self->priv->readers;
					g_rec_mutex_lock (&self->priv->__lock_readers);
					{
						GdkPixbuf* _tmp7_ = NULL;
						Scaling _tmp8_ = {0};
						GdkPixbuf* _tmp9_;
						GdkPixbuf* _tmp10_;
						scaling_for_original (&_tmp8_);
						_tmp9_ = photo_get_master_pixbuf (self, &_tmp8_, FALSE, &_inner_error0_);
						_tmp7_ = _tmp9_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
						_tmp10_ = _tmp7_;
						_tmp7_ = NULL;
						_g_object_unref0 (pix);
						pix = _tmp10_;
						_g_object_unref0 (_tmp7_);
					}
					goto __finally1;
					__catch1_g_error:
					{
						GError* _lock_error_ = NULL;
						GError* _tmp11_;
						_lock_error_ = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp11_ = _lock_error_;
						_lock_error_ = NULL;
						_inner_error0_ = _tmp11_;
						_g_error_free0 (_lock_error_);
						goto __finally1;
					}
					__finally1:
					{
						GError* _inner_error1_ = NULL;
						PhotoBackingReaders* _tmp12_;
						_tmp12_ = self->priv->readers;
						g_rec_mutex_unlock (&self->priv->__lock_readers);
					}
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (pix);
						_backing_photo_row_unref0 (_tmp0_);
						goto __catch0_g_error;
					}
				}
				_tmp13_ = pix;
				if (_tmp13_ == NULL) {
					g_debug ("Photo.vala:602: Could not get preview pixbuf");
					_g_object_unref0 (pix);
					_backing_photo_row_unref0 (_tmp0_);
					{
						GError* _inner_error0_ = NULL;
						if (wrote_img_to_disk) {
							{
								BackingPhotoRow* _tmp14_;
								_tmp14_ = bps;
								photo_add_backing_photo_for_development (self, d, _tmp14_, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									goto __catch2_g_error;
								}
								photo_notify_raw_development_modified (self);
							}
							goto __finally2;
							__catch2_g_error:
							{
								GError* e = NULL;
								GError* _tmp15_;
								const gchar* _tmp16_;
								e = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp15_ = e;
								_tmp16_ = _tmp15_->message;
								g_debug ("Photo.vala:634: Error adding backing photo as development. Message: %s", _tmp16_);
								_g_error_free0 (e);
							}
							__finally2:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch0_g_error;
							}
						}
					}
					_backing_photo_row_unref0 (bps);
					return;
				}
				_tmp17_ = bps;
				_tmp18_ = _tmp17_->filepath;
				_tmp19_ = photo_file_format_create_writer (PHOTO_FILE_FORMAT_JFIF, _tmp18_, &_inner_error0_);
				writer = _tmp19_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (pix);
					_backing_photo_row_unref0 (_tmp0_);
					goto __catch0_g_error;
				}
				_tmp20_ = writer;
				_tmp21_ = pix;
				photo_file_writer_write (_tmp20_, _tmp21_, JPEG_QUALITY_HIGH, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_photo_file_adapter_unref0 (writer);
					_g_object_unref0 (pix);
					_backing_photo_row_unref0 (_tmp0_);
					goto __catch0_g_error;
				}
				wrote_img_to_disk = TRUE;
				_tmp22_ = photo_get_master_metadata (self, &_inner_error0_);
				meta = _tmp22_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_photo_file_adapter_unref0 (writer);
					_g_object_unref0 (pix);
					_backing_photo_row_unref0 (_tmp0_);
					goto __catch0_g_error;
				}
				_tmp23_ = bps;
				_tmp24_ = _tmp23_->filepath;
				_tmp25_ = photo_file_format_create_metadata_writer (PHOTO_FILE_FORMAT_JFIF, _tmp24_, &_inner_error0_);
				mwriter = _tmp25_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_media_metadata_unref0 (meta);
					_photo_file_adapter_unref0 (writer);
					_g_object_unref0 (pix);
					_backing_photo_row_unref0 (_tmp0_);
					goto __catch0_g_error;
				}
				_tmp26_ = mwriter;
				_tmp27_ = meta;
				photo_file_metadata_writer_write_metadata (_tmp26_, _tmp27_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_photo_file_adapter_unref0 (mwriter);
					_media_metadata_unref0 (meta);
					_photo_file_adapter_unref0 (writer);
					_g_object_unref0 (pix);
					_backing_photo_row_unref0 (_tmp0_);
					goto __catch0_g_error;
				}
				_photo_file_adapter_unref0 (mwriter);
				_media_metadata_unref0 (meta);
				_photo_file_adapter_unref0 (writer);
				_g_object_unref0 (pix);
				_backing_photo_row_unref0 (_tmp0_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				GError* _tmp28_;
				const gchar* _tmp29_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp28_ = err;
				_tmp29_ = _tmp28_->message;
				g_debug ("Photo.vala:625: Error developing photo: %s", _tmp29_);
				_g_error_free0 (err);
			}
			__finally0:
			{
				GError* _inner_error1_ = NULL;
				if (wrote_img_to_disk) {
					{
						BackingPhotoRow* _tmp30_;
						_tmp30_ = bps;
						photo_add_backing_photo_for_development (self, d, _tmp30_, &_inner_error1_);
						if (G_UNLIKELY (_inner_error1_ != NULL)) {
							goto __catch3_g_error;
						}
						photo_notify_raw_development_modified (self);
					}
					goto __finally3;
					__catch3_g_error:
					{
						GError* e = NULL;
						GError* _tmp31_;
						const gchar* _tmp32_;
						e = _inner_error1_;
						_inner_error1_ = NULL;
						_tmp31_ = e;
						_tmp32_ = _tmp31_->message;
						g_debug ("Photo.vala:634: Error adding backing photo as development. Message: %s", _tmp32_);
						_g_error_free0 (e);
					}
					__finally3:
					if (G_UNLIKELY (_inner_error1_ != NULL)) {
						_backing_photo_row_unref0 (bps);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error1_->message, g_quark_to_string (_inner_error1_->domain), _inner_error1_->code);
						g_clear_error (&_inner_error1_);
						return;
					}
				}
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_backing_photo_row_unref0 (bps);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			break;
		}
		case RAW_DEVELOPER_CAMERA:
		{
			break;
		}
		case RAW_DEVELOPER_EMBEDDED:
		{
			{
				PhotoMetadata* meta = NULL;
				PhotoMetadata* _tmp33_;
				guint c = 0U;
				PhotoMetadata* _tmp34_;
				PhotoPreview* prev = NULL;
				PhotoMetadata* _tmp38_;
				PhotoPreview* _tmp39_;
				PhotoPreview* _tmp40_;
				GdkPixbuf* pix = NULL;
				PhotoPreview* _tmp44_;
				GdkPixbuf* _tmp45_;
				GdkPixbuf* _tmp46_;
				BackingPhotoRow* _tmp50_ = NULL;
				PhotoRow* _tmp51_;
				BackingPhotoRow* _tmp52_;
				const gchar* _tmp53_;
				BackingPhotoRow* _tmp54_;
				BackingPhotoRow* _tmp55_;
				PhotoFileWriter* writer = NULL;
				BackingPhotoRow* _tmp56_;
				const gchar* _tmp57_;
				PhotoFileWriter* _tmp58_;
				PhotoFileWriter* _tmp59_;
				GdkPixbuf* _tmp60_;
				PhotoFileMetadataWriter* mwriter = NULL;
				BackingPhotoRow* _tmp61_;
				const gchar* _tmp62_;
				PhotoFileMetadataWriter* _tmp63_;
				PhotoFileMetadataWriter* _tmp64_;
				PhotoMetadata* _tmp65_;
				_tmp33_ = photo_get_master_metadata (self, &_inner_error0_);
				meta = _tmp33_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch4_g_error;
				}
				_tmp34_ = meta;
				c = photo_metadata_get_preview_count (_tmp34_);
				if (c <= ((guint) 0)) {
					_media_metadata_unref0 (meta);
					{
						GError* _inner_error0_ = NULL;
						if (wrote_img_to_disk) {
							{
								BackingPhotoRow* _tmp35_;
								_tmp35_ = bps;
								photo_add_backing_photo_for_development (self, d, _tmp35_, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									goto __catch5_g_error;
								}
								photo_notify_raw_development_modified (self);
							}
							goto __finally5;
							__catch5_g_error:
							{
								GError* e = NULL;
								GError* _tmp36_;
								const gchar* _tmp37_;
								e = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp36_ = e;
								_tmp37_ = _tmp36_->message;
								g_debug ("Photo.vala:689: Error adding backing photo as development. Message: %s", _tmp37_);
								_g_error_free0 (e);
							}
							__finally5:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch4_g_error;
							}
						}
					}
					_backing_photo_row_unref0 (bps);
					return;
				}
				_tmp38_ = meta;
				_tmp39_ = photo_metadata_get_preview (_tmp38_, c - 1);
				prev = _tmp39_;
				_tmp40_ = prev;
				if (_tmp40_ == NULL) {
					g_debug ("Photo.vala:656: Could not get preview from metadata");
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					{
						GError* _inner_error0_ = NULL;
						if (wrote_img_to_disk) {
							{
								BackingPhotoRow* _tmp41_;
								_tmp41_ = bps;
								photo_add_backing_photo_for_development (self, d, _tmp41_, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									goto __catch6_g_error;
								}
								photo_notify_raw_development_modified (self);
							}
							goto __finally6;
							__catch6_g_error:
							{
								GError* e = NULL;
								GError* _tmp42_;
								const gchar* _tmp43_;
								e = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp42_ = e;
								_tmp43_ = _tmp42_->message;
								g_debug ("Photo.vala:689: Error adding backing photo as development. Message: %s", _tmp43_);
								_g_error_free0 (e);
							}
							__finally6:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch4_g_error;
							}
						}
					}
					_backing_photo_row_unref0 (bps);
					return;
				}
				_tmp44_ = prev;
				_tmp45_ = photo_preview_get_pixbuf (_tmp44_, &_inner_error0_);
				pix = _tmp45_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					goto __catch4_g_error;
				}
				_tmp46_ = pix;
				if (_tmp46_ == NULL) {
					g_debug ("Photo.vala:662: Could not get preview pixbuf");
					_g_object_unref0 (pix);
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					{
						GError* _inner_error0_ = NULL;
						if (wrote_img_to_disk) {
							{
								BackingPhotoRow* _tmp47_;
								_tmp47_ = bps;
								photo_add_backing_photo_for_development (self, d, _tmp47_, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									goto __catch7_g_error;
								}
								photo_notify_raw_development_modified (self);
							}
							goto __finally7;
							__catch7_g_error:
							{
								GError* e = NULL;
								GError* _tmp48_;
								const gchar* _tmp49_;
								e = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp48_ = e;
								_tmp49_ = _tmp48_->message;
								g_debug ("Photo.vala:689: Error adding backing photo as development. Message: %s", _tmp49_);
								_g_error_free0 (e);
							}
							__finally7:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch4_g_error;
							}
						}
					}
					_backing_photo_row_unref0 (bps);
					return;
				}
				_tmp51_ = self->row;
				_tmp52_ = _tmp51_->master;
				_tmp53_ = _tmp52_->filepath;
				_tmp54_ = raw_developer_create_backing_row_for_development (d, _tmp53_, NULL, &_inner_error0_);
				_tmp50_ = _tmp54_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (pix);
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					goto __catch4_g_error;
				}
				_tmp55_ = _tmp50_;
				_tmp50_ = NULL;
				_backing_photo_row_unref0 (bps);
				bps = _tmp55_;
				_tmp56_ = bps;
				_tmp57_ = _tmp56_->filepath;
				_tmp58_ = photo_file_format_create_writer (PHOTO_FILE_FORMAT_JFIF, _tmp57_, &_inner_error0_);
				writer = _tmp58_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_backing_photo_row_unref0 (_tmp50_);
					_g_object_unref0 (pix);
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					goto __catch4_g_error;
				}
				_tmp59_ = writer;
				_tmp60_ = pix;
				photo_file_writer_write (_tmp59_, _tmp60_, JPEG_QUALITY_HIGH, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_photo_file_adapter_unref0 (writer);
					_backing_photo_row_unref0 (_tmp50_);
					_g_object_unref0 (pix);
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					goto __catch4_g_error;
				}
				wrote_img_to_disk = TRUE;
				_tmp61_ = bps;
				_tmp62_ = _tmp61_->filepath;
				_tmp63_ = photo_file_format_create_metadata_writer (PHOTO_FILE_FORMAT_JFIF, _tmp62_, &_inner_error0_);
				mwriter = _tmp63_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_photo_file_adapter_unref0 (writer);
					_backing_photo_row_unref0 (_tmp50_);
					_g_object_unref0 (pix);
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					goto __catch4_g_error;
				}
				_tmp64_ = mwriter;
				_tmp65_ = meta;
				photo_file_metadata_writer_write_metadata (_tmp64_, _tmp65_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_photo_file_adapter_unref0 (mwriter);
					_photo_file_adapter_unref0 (writer);
					_backing_photo_row_unref0 (_tmp50_);
					_g_object_unref0 (pix);
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					goto __catch4_g_error;
				}
				_photo_file_adapter_unref0 (mwriter);
				_photo_file_adapter_unref0 (writer);
				_backing_photo_row_unref0 (_tmp50_);
				_g_object_unref0 (pix);
				_photo_preview_unref0 (prev);
				_media_metadata_unref0 (meta);
			}
			goto __finally4;
			__catch4_g_error:
			{
				GError* e = NULL;
				GError* _tmp66_;
				const gchar* _tmp67_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp66_ = e;
				_tmp67_ = _tmp66_->message;
				g_debug ("Photo.vala:679: Error accessing embedded preview. Message: %s", _tmp67_);
				_g_error_free0 (e);
				{
					GError* _inner_error0_ = NULL;
					if (wrote_img_to_disk) {
						{
							BackingPhotoRow* _tmp68_;
							_tmp68_ = bps;
							photo_add_backing_photo_for_development (self, d, _tmp68_, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch8_g_error;
							}
							photo_notify_raw_development_modified (self);
						}
						goto __finally8;
						__catch8_g_error:
						{
							GError* e = NULL;
							GError* _tmp69_;
							const gchar* _tmp70_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp69_ = e;
							_tmp70_ = _tmp69_->message;
							g_debug ("Photo.vala:689: Error adding backing photo as development. Message: %s", _tmp70_);
							_g_error_free0 (e);
						}
						__finally8:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_backing_photo_row_unref0 (bps);
						}
					}
				}
				_backing_photo_row_unref0 (bps);
				return;
			}
			__finally4:
			{
				GError* _inner_error1_ = NULL;
				if (wrote_img_to_disk) {
					{
						BackingPhotoRow* _tmp71_;
						_tmp71_ = bps;
						photo_add_backing_photo_for_development (self, d, _tmp71_, &_inner_error1_);
						if (G_UNLIKELY (_inner_error1_ != NULL)) {
							goto __catch9_g_error;
						}
						photo_notify_raw_development_modified (self);
					}
					goto __finally9;
					__catch9_g_error:
					{
						GError* e = NULL;
						GError* _tmp72_;
						const gchar* _tmp73_;
						e = _inner_error1_;
						_inner_error1_ = NULL;
						_tmp72_ = e;
						_tmp73_ = _tmp72_->message;
						g_debug ("Photo.vala:689: Error adding backing photo as development. Message: %s", _tmp73_);
						_g_error_free0 (e);
					}
					__finally9:
					if (G_UNLIKELY (_inner_error1_ != NULL)) {
						_backing_photo_row_unref0 (bps);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error1_->message, g_quark_to_string (_inner_error1_->domain), _inner_error1_->code);
						g_clear_error (&_inner_error1_);
						return;
					}
				}
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_backing_photo_row_unref0 (bps);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_backing_photo_row_unref0 (bps);
}

void
photo_set_default_raw_developer (Photo* self,
                                 RawDeveloper d)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			_tmp1_->developer = d;
		}
		__finally0:
		{
			PhotoRow* _tmp2_;
			_tmp2_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
photo_set_raw_developer (Photo* self,
                         RawDeveloper d)
{
	gboolean _tmp0_ = FALSE;
	Alteration* _tmp25_;
	Alteration* _tmp26_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (photo_get_master_file_format (self) != PHOTO_FILE_FORMAT_RAW) {
		return;
	}
	if (photo_is_raw_developer_available (self, RAW_DEVELOPER_CAMERA)) {
		_tmp0_ = d == RAW_DEVELOPER_EMBEDDED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		d = RAW_DEVELOPER_CAMERA;
	}
	if (!photo_is_raw_developer_available (self, RAW_DEVELOPER_EMBEDDED)) {
		d = RAW_DEVELOPER_SHOTWELL;
	}
	{
		GeeHashMap* _tmp1_;
		_tmp1_ = self->priv->developments;
		g_rec_mutex_lock (&self->priv->__lock_developments);
		{
			RawDeveloper stale_raw_developer = 0;
			PhotoRow* _tmp2_;
			GeeHashMap* _tmp4_;
			PhotoRow* _tmp6_;
			GeeHashMap* _tmp7_;
			gpointer _tmp8_;
			PhotoBackingReaders* _tmp9_;
			BackingPhotoRow* _tmp10_;
			BackingPhotoRow* _tmp11_;
			const gchar* _tmp12_;
			PhotoFileReader* _tmp13_;
			BackingPhotoRow* _tmp14_;
			gboolean _tmp22_ = FALSE;
			_tmp2_ = self->row;
			stale_raw_developer = _tmp2_->developer;
			if (!photo_is_raw_developer_complete (self, d)) {
				photo_develop_photo (self, d);
				{
					photo_populate_prefetched (self, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					g_clear_error (&_inner_error0_);
					{
						GeeHashMap* _tmp3_;
						_tmp3_ = self->priv->developments;
						g_rec_mutex_unlock (&self->priv->__lock_developments);
					}
					return;
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp4_ = self->priv->developments;
			if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, (gpointer) ((gintptr) d))) {
				{
					GeeHashMap* _tmp5_;
					_tmp5_ = self->priv->developments;
					g_rec_mutex_unlock (&self->priv->__lock_developments);
				}
				return;
			}
			photo_revert_to_master (self, FALSE);
			_tmp6_ = self->row;
			_tmp6_->developer = d;
			_tmp7_ = self->priv->developments;
			_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, (gpointer) ((gintptr) d));
			_backing_photo_row_unref0 (self->backing_photo_row);
			self->backing_photo_row = (BackingPhotoRow*) _tmp8_;
			_tmp9_ = self->priv->readers;
			_tmp10_ = self->backing_photo_row;
			_tmp11_ = self->backing_photo_row;
			_tmp12_ = _tmp11_->filepath;
			_tmp13_ = photo_file_format_create_reader (_tmp10_->file_format, _tmp12_);
			_photo_file_adapter_unref0 (_tmp9_->developer);
			_tmp9_->developer = _tmp13_;
			_tmp14_ = self->backing_photo_row;
			photo_set_orientation (self, _tmp14_->original_orientation);
			{
				PhotoTable* _tmp15_;
				PhotoTable* _tmp16_;
				PhotoRow* _tmp17_;
				BackingPhotoRow* _tmp18_;
				BackingPhotoID _tmp19_;
				_tmp15_ = photo_table_get_instance ();
				_tmp16_ = _tmp15_;
				_tmp17_ = self->row;
				_tmp18_ = self->backing_photo_row;
				_tmp19_ = _tmp18_->id;
				photo_table_update_raw_development (_tmp16_, _tmp17_, d, &_tmp19_, &_inner_error0_);
				_database_table_unref0 (_tmp16_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				GError* _tmp20_;
				const gchar* _tmp21_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp20_ = e;
				_tmp21_ = _tmp20_->message;
				g_warning ("Photo.vala:757: Error updating database: %s", _tmp21_);
				_g_error_free0 (e);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			if (stale_raw_developer != RAW_DEVELOPER_CAMERA) {
				PhotoRow* _tmp23_;
				_tmp23_ = self->row;
				_tmp22_ = stale_raw_developer != _tmp23_->developer;
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				photo_delete_raw_development (self, stale_raw_developer);
			}
		}
		__finally0:
		{
			GeeHashMap* _tmp24_;
			_tmp24_ = self->priv->developments;
			g_rec_mutex_unlock (&self->priv->__lock_developments);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp25_ = alteration_new ("image", "developer");
	_tmp26_ = _tmp25_;
	data_object_notify_altered ((DataObject*) self, _tmp26_);
	_alteration_unref0 (_tmp26_);
	photo_discard_prefetched (self, TRUE);
}

RawDeveloper
photo_get_raw_developer (Photo* self)
{
	PhotoRow* _tmp0_;
	RawDeveloper result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->row;
	result = _tmp0_->developer;
	return result;
}

static gboolean
photo_delete_raw_development (Photo* self,
                              RawDeveloper d)
{
	gboolean ret = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	ret = FALSE;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->developments;
		g_rec_mutex_lock (&self->priv->__lock_developments);
		{
			GeeHashMap* _tmp1_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			BackingPhotoRow* bpr = NULL;
			GeeHashMap* _tmp7_;
			gpointer _tmp8_;
			BackingPhotoRow* _tmp9_;
			const gchar* _tmp10_;
			GeeHashMap* _tmp31_;
			_tmp1_ = self->priv->developments;
			if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) d))) {
				result = FALSE;
				{
					GeeHashMap* _tmp2_;
					_tmp2_ = self->priv->developments;
					g_rec_mutex_unlock (&self->priv->__lock_developments);
				}
				return result;
			}
			_tmp3_ = data_object_to_string ((DataObject*) self);
			_tmp4_ = _tmp3_;
			_tmp5_ = raw_developer_to_string (d);
			_tmp6_ = _tmp5_;
			g_debug ("Photo.vala:794: Delete raw development: %s %s", _tmp4_, _tmp6_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp4_);
			_tmp7_ = self->priv->developments;
			_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, (gpointer) ((gintptr) d));
			bpr = (BackingPhotoRow*) _tmp8_;
			_tmp9_ = bpr;
			_tmp10_ = _tmp9_->filepath;
			if (_tmp10_ != NULL) {
				GFile* f = NULL;
				BackingPhotoRow* _tmp11_;
				const gchar* _tmp12_;
				GFile* _tmp13_;
				_tmp11_ = bpr;
				_tmp12_ = _tmp11_->filepath;
				_tmp13_ = g_file_new_for_path (_tmp12_);
				f = _tmp13_;
				{
					if (d == RAW_DEVELOPER_CAMERA) {
						GFile* _tmp14_;
						_tmp14_ = f;
						g_file_trash (_tmp14_, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
					} else {
						GFile* _tmp15_;
						_tmp15_ = f;
						g_file_delete (_tmp15_, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					BackingPhotoRow* _tmp16_;
					const gchar* _tmp17_;
					GError* _tmp18_;
					const gchar* _tmp19_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp16_ = bpr;
					_tmp17_ = _tmp16_->filepath;
					_tmp18_ = e;
					_tmp19_ = _tmp18_->message;
					g_warning ("Photo.vala:805: Unable to delete RAW development: %s error: %s", _tmp17_, _tmp19_);
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp20_ = FALSE;
					_g_object_unref0 (f);
					_backing_photo_row_unref0 (bpr);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp20_;
				}
				_g_object_unref0 (f);
			}
			{
				PhotoTable* _tmp21_;
				PhotoTable* _tmp22_;
				PhotoRow* _tmp23_;
				BackingPhotoTable* _tmp24_;
				BackingPhotoTable* _tmp25_;
				BackingPhotoRow* _tmp26_;
				BackingPhotoID _tmp27_;
				_tmp21_ = photo_table_get_instance ();
				_tmp22_ = _tmp21_;
				_tmp23_ = self->row;
				photo_table_remove_development (_tmp22_, _tmp23_, d, &_inner_error0_);
				_database_table_unref0 (_tmp22_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
				_tmp24_ = backing_photo_table_get_instance ();
				_tmp25_ = _tmp24_;
				_tmp26_ = bpr;
				_tmp27_ = _tmp26_->id;
				backing_photo_table_remove (_tmp25_, &_tmp27_, &_inner_error0_);
				_database_table_unref0 (_tmp25_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				GError* _tmp28_;
				const gchar* _tmp29_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp28_ = e;
				_tmp29_ = _tmp28_->message;
				g_warning ("Photo.vala:814: Database error while deleting RAW development: %s", _tmp29_);
				_g_error_free0 (e);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp30_ = FALSE;
				_backing_photo_row_unref0 (bpr);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp30_;
			}
			_tmp31_ = self->priv->developments;
			ret = gee_abstract_map_unset ((GeeAbstractMap*) _tmp31_, (gpointer) ((gintptr) d), NULL);
			_backing_photo_row_unref0 (bpr);
		}
		__finally0:
		{
			GeeHashMap* _tmp32_;
			_tmp32_ = self->priv->developments;
			g_rec_mutex_unlock (&self->priv->__lock_developments);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp33_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp33_;
		}
	}
	photo_notify_raw_development_modified (self);
	result = ret;
	return result;
}

void
photo_redevelop_raw (Photo* self,
                     RawDeveloper d)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->developments;
		g_rec_mutex_lock (&self->priv->__lock_developments);
		{
			RawDeveloper dev = 0;
			photo_delete_raw_development (self, d);
			dev = d;
			if (dev == RAW_DEVELOPER_CAMERA) {
				dev = RAW_DEVELOPER_EMBEDDED;
			}
			photo_set_raw_developer (self, dev);
		}
		__finally0:
		{
			GeeHashMap* _tmp1_;
			_tmp1_ = self->priv->developments;
			g_rec_mutex_unlock (&self->priv->__lock_developments);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
_vala_array_add7 (BackingFileState** * array,
                  gint* length,
                  gint* size,
                  BackingFileState* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BackingFileState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (BackingFileState** * array,
                  gint* length,
                  gint* size,
                  BackingFileState* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BackingFileState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add9 (BackingFileState** * array,
                  gint* length,
                  gint* size,
                  BackingFileState* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BackingFileState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static BackingFileState**
photo_real_get_backing_files_state (MediaSource* base,
                                    gint* result_length1)
{
	Photo * self;
	BackingFileState** backing = NULL;
	BackingFileState** _tmp0_;
	gint backing_length1;
	gint _backing_size_;
	BackingFileState** _tmp21_;
	gint _tmp21__length1;
	GError* _inner_error0_ = NULL;
	BackingFileState** result;
	self = (Photo*) base;
	_tmp0_ = g_new0 (BackingFileState*, 0 + 1);
	backing = _tmp0_;
	backing_length1 = 0;
	_backing_size_ = backing_length1;
	{
		PhotoRow* _tmp1_;
		_tmp1_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp2_;
			BackingPhotoRow* _tmp3_;
			PhotoRow* _tmp4_;
			const gchar* _tmp5_;
			BackingFileState* _tmp6_;
			_tmp2_ = self->row;
			_tmp3_ = _tmp2_->master;
			_tmp4_ = self->row;
			_tmp5_ = _tmp4_->md5;
			_tmp6_ = backing_file_state_new_from_photo_row (_tmp3_, _tmp5_);
			_vala_array_add7 (&backing, &backing_length1, &_backing_size_, _tmp6_);
			if (photo_has_editable (self)) {
				BackingPhotoRow* _tmp7_;
				BackingFileState* _tmp8_;
				_tmp7_ = self->priv->editable;
				_tmp8_ = backing_file_state_new_from_photo_row (_tmp7_, NULL);
				_vala_array_add8 (&backing, &backing_length1, &_backing_size_, _tmp8_);
			}
			if (photo_is_developed (self)) {
				GeeCollection* dev_rows = NULL;
				GeeCollection* _tmp9_;
				GeeCollection* _tmp10_;
				_tmp9_ = photo_get_raw_development_photo_rows (self);
				dev_rows = _tmp9_;
				_tmp10_ = dev_rows;
				if (_tmp10_ != NULL) {
					{
						GeeIterator* _r_it = NULL;
						GeeCollection* _tmp11_;
						GeeIterator* _tmp12_;
						_tmp11_ = dev_rows;
						_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
						_r_it = _tmp12_;
						while (TRUE) {
							GeeIterator* _tmp13_;
							BackingPhotoRow* r = NULL;
							GeeIterator* _tmp14_;
							gpointer _tmp15_;
							BackingPhotoRow* _tmp16_;
							const gchar* _tmp17_;
							BackingPhotoRow* _tmp18_;
							BackingFileState* _tmp19_;
							_tmp13_ = _r_it;
							if (!gee_iterator_next (_tmp13_)) {
								break;
							}
							_tmp14_ = _r_it;
							_tmp15_ = gee_iterator_get (_tmp14_);
							r = (BackingPhotoRow*) _tmp15_;
							_tmp16_ = r;
							_tmp17_ = _tmp16_->filepath;
							g_debug ("Photo.vala:849: adding: %s", _tmp17_);
							_tmp18_ = r;
							_tmp19_ = backing_file_state_new_from_photo_row (_tmp18_, NULL);
							_vala_array_add9 (&backing, &backing_length1, &_backing_size_, _tmp19_);
							_backing_photo_row_unref0 (r);
						}
						_g_object_unref0 (_r_it);
					}
				}
				_g_object_unref0 (dev_rows);
			}
		}
		__finally0:
		{
			PhotoRow* _tmp20_;
			_tmp20_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			backing = (_vala_array_free (backing, backing_length1, (GDestroyNotify) backing_file_state_unref), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp21_ = backing;
	_tmp21__length1 = backing_length1;
	if (result_length1) {
		*result_length1 = _tmp21__length1;
	}
	result = _tmp21_;
	return result;
}

static PhotoFileReader*
photo_get_backing_reader (Photo* self,
                          BackingFetchMode mode)
{
	PhotoFileReader* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (mode) {
		case BACKING_FETCH_MODE_MASTER:
		{
			PhotoFileReader* _tmp0_;
			_tmp0_ = photo_get_master_reader (self);
			result = _tmp0_;
			return result;
		}
		case BACKING_FETCH_MODE_BASELINE:
		{
			PhotoFileReader* _tmp1_;
			_tmp1_ = photo_get_baseline_reader (self);
			result = _tmp1_;
			return result;
		}
		case BACKING_FETCH_MODE_SOURCE:
		{
			PhotoFileReader* _tmp2_;
			_tmp2_ = photo_get_source_reader (self);
			result = _tmp2_;
			return result;
		}
		case BACKING_FETCH_MODE_UNMODIFIED:
		{
			if (photo_get_master_file_format (self) == PHOTO_FILE_FORMAT_RAW) {
				PhotoFileReader* _tmp3_;
				_tmp3_ = photo_get_raw_developer_reader (self);
				result = _tmp3_;
				return result;
			} else {
				PhotoFileReader* _tmp4_;
				_tmp4_ = photo_get_master_reader (self);
				result = _tmp4_;
				return result;
			}
		}
		default:
		{
			GEnumValue* _tmp5_;
			_tmp5_ = g_enum_get_value (g_type_class_ref (TYPE_BACKING_FETCH_MODE), mode);
			g_error ("Photo.vala:878: Unknown backing fetch mode %s", (_tmp5_ != NULL) ? _tmp5_->value_name : NULL);
		}
	}
}

static gpointer
_photo_file_adapter_ref0 (gpointer self)
{
	return self ? photo_file_adapter_ref (self) : NULL;
}

static PhotoFileReader*
photo_get_master_reader (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoFileReader* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoFileReader* _tmp3_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->master;
			_tmp3_ = _photo_file_adapter_ref0 (_tmp2_);
			result = _tmp3_;
			{
				PhotoBackingReaders* _tmp4_;
				_tmp4_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp5_;
			_tmp5_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

PhotoFileReader*
photo_get_editable_reader (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoFileReader* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoFileReader* _tmp3_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			_tmp3_ = _photo_file_adapter_ref0 (_tmp2_);
			result = _tmp3_;
			{
				PhotoBackingReaders* _tmp4_;
				_tmp4_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp5_;
			_tmp5_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static PhotoFileReader*
photo_get_baseline_reader (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoFileReader* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoBackingReaders* _tmp7_;
			PhotoFileReader* _tmp8_;
			PhotoBackingReaders* _tmp13_;
			PhotoFileReader* _tmp14_;
			PhotoFileReader* _tmp15_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			if (_tmp2_ != NULL) {
				PhotoBackingReaders* _tmp3_;
				PhotoFileReader* _tmp4_;
				PhotoFileReader* _tmp5_;
				_tmp3_ = self->priv->readers;
				_tmp4_ = _tmp3_->editable;
				_tmp5_ = _photo_file_adapter_ref0 (_tmp4_);
				result = _tmp5_;
				{
					PhotoBackingReaders* _tmp6_;
					_tmp6_ = self->priv->readers;
					g_rec_mutex_unlock (&self->priv->__lock_readers);
				}
				return result;
			}
			_tmp7_ = self->priv->readers;
			_tmp8_ = _tmp7_->developer;
			if (_tmp8_ != NULL) {
				PhotoBackingReaders* _tmp9_;
				PhotoFileReader* _tmp10_;
				PhotoFileReader* _tmp11_;
				_tmp9_ = self->priv->readers;
				_tmp10_ = _tmp9_->developer;
				_tmp11_ = _photo_file_adapter_ref0 (_tmp10_);
				result = _tmp11_;
				{
					PhotoBackingReaders* _tmp12_;
					_tmp12_ = self->priv->readers;
					g_rec_mutex_unlock (&self->priv->__lock_readers);
				}
				return result;
			}
			_tmp13_ = self->priv->readers;
			_tmp14_ = _tmp13_->master;
			_tmp15_ = _photo_file_adapter_ref0 (_tmp14_);
			result = _tmp15_;
			{
				PhotoBackingReaders* _tmp16_;
				_tmp16_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp17_;
			_tmp17_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static PhotoFileReader*
photo_get_source_reader (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoFileReader* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoBackingReaders* _tmp7_;
			PhotoFileReader* _tmp8_;
			PhotoBackingReaders* _tmp13_;
			PhotoFileReader* _tmp14_;
			PhotoFileReader* _tmp15_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			if (_tmp2_ != NULL) {
				PhotoBackingReaders* _tmp3_;
				PhotoFileReader* _tmp4_;
				PhotoFileReader* _tmp5_;
				_tmp3_ = self->priv->readers;
				_tmp4_ = _tmp3_->editable;
				_tmp5_ = _photo_file_adapter_ref0 (_tmp4_);
				result = _tmp5_;
				{
					PhotoBackingReaders* _tmp6_;
					_tmp6_ = self->priv->readers;
					g_rec_mutex_unlock (&self->priv->__lock_readers);
				}
				return result;
			}
			_tmp7_ = self->priv->readers;
			_tmp8_ = _tmp7_->developer;
			if (_tmp8_ != NULL) {
				PhotoBackingReaders* _tmp9_;
				PhotoFileReader* _tmp10_;
				PhotoFileReader* _tmp11_;
				_tmp9_ = self->priv->readers;
				_tmp10_ = _tmp9_->developer;
				_tmp11_ = _photo_file_adapter_ref0 (_tmp10_);
				result = _tmp11_;
				{
					PhotoBackingReaders* _tmp12_;
					_tmp12_ = self->priv->readers;
					g_rec_mutex_unlock (&self->priv->__lock_readers);
				}
				return result;
			}
			_tmp13_ = self->priv->readers;
			_tmp14_ = _tmp13_->master;
			_tmp15_ = _photo_file_adapter_ref0 (_tmp14_);
			result = _tmp15_;
			{
				PhotoBackingReaders* _tmp16_;
				_tmp16_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp17_;
			_tmp17_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static PhotoFileReader*
photo_get_raw_developer_reader (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoFileReader* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoFileReader* _tmp3_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->developer;
			_tmp3_ = _photo_file_adapter_ref0 (_tmp2_);
			result = _tmp3_;
			{
				PhotoBackingReaders* _tmp4_;
				_tmp4_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp5_;
			_tmp5_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

gboolean
photo_is_developed (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->developer;
			result = _tmp2_ != NULL;
			{
				PhotoBackingReaders* _tmp3_;
				_tmp3_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp4_;
			_tmp4_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
}

gboolean
photo_has_editable (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			result = _tmp2_ != NULL;
			{
				PhotoBackingReaders* _tmp3_;
				_tmp3_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp4_;
			_tmp4_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
}

gboolean
photo_does_master_exist (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->master;
			result = photo_file_adapter_file_exists ((PhotoFileAdapter*) _tmp2_);
			{
				PhotoBackingReaders* _tmp3_;
				_tmp3_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp4_;
			_tmp4_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
}

gboolean
photo_does_editable_exist (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp8_ = FALSE;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			gboolean _tmp1_ = FALSE;
			PhotoBackingReaders* _tmp2_;
			PhotoFileReader* _tmp3_;
			_tmp2_ = self->priv->readers;
			_tmp3_ = _tmp2_->editable;
			if (_tmp3_ != NULL) {
				PhotoBackingReaders* _tmp4_;
				PhotoFileReader* _tmp5_;
				_tmp4_ = self->priv->readers;
				_tmp5_ = _tmp4_->editable;
				_tmp1_ = photo_file_adapter_file_exists ((PhotoFileAdapter*) _tmp5_);
			} else {
				_tmp1_ = FALSE;
			}
			result = _tmp1_;
			{
				PhotoBackingReaders* _tmp6_;
				_tmp6_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp7_;
			_tmp7_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
}

gboolean
photo_is_master_baseline (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			result = _tmp2_ == NULL;
			{
				PhotoBackingReaders* _tmp3_;
				_tmp3_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp4_;
			_tmp4_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
}

gboolean
photo_is_master_source (Photo* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = !photo_has_editable (self);
	return result;
}

gboolean
photo_is_editable_baseline (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			result = _tmp2_ != NULL;
			{
				PhotoBackingReaders* _tmp3_;
				_tmp3_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp4_;
			_tmp4_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
}

gboolean
photo_is_editable_source (Photo* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = photo_has_editable (self);
	return result;
}

BackingPhotoRow*
photo_get_master_photo_row (Photo* self)
{
	GError* _inner_error0_ = NULL;
	BackingPhotoRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			BackingPhotoRow* _tmp2_;
			BackingPhotoRow* _tmp3_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->master;
			_tmp3_ = _backing_photo_row_ref0 (_tmp2_);
			result = _tmp3_;
			{
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

BackingPhotoRow*
photo_get_editable_photo_row (Photo* self)
{
	GError* _inner_error0_ = NULL;
	BackingPhotoRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			if (backing_photo_id_is_valid (&_tmp1_->editable_id)) {
				BackingPhotoRow* _tmp2_;
				BackingPhotoRow* _tmp3_;
				_tmp2_ = self->priv->editable;
				_tmp3_ = _backing_photo_row_ref0 (_tmp2_);
				result = _tmp3_;
				{
					PhotoRow* _tmp4_;
					_tmp4_ = self->row;
					g_rec_mutex_unlock (&self->priv->__lock_row);
				}
				return result;
			} else {
				result = NULL;
				{
					PhotoRow* _tmp5_;
					_tmp5_ = self->row;
					g_rec_mutex_unlock (&self->priv->__lock_row);
				}
				return result;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp6_;
			_tmp6_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

GeeCollection*
photo_get_raw_development_photo_rows (Photo* self)
{
	GError* _inner_error0_ = NULL;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			GeeCollection* _tmp1_ = NULL;
			GeeHashMap* _tmp2_;
			_tmp2_ = self->priv->developments;
			if (_tmp2_ != NULL) {
				GeeHashMap* _tmp3_;
				GeeCollection* _tmp4_;
				GeeCollection* _tmp5_;
				_tmp3_ = self->priv->developments;
				_tmp4_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp3_);
				_tmp5_ = _tmp4_;
				_g_object_unref0 (_tmp1_);
				_tmp1_ = _tmp5_;
			} else {
				_g_object_unref0 (_tmp1_);
				_tmp1_ = NULL;
			}
			result = _tmp1_;
			{
				PhotoRow* _tmp6_;
				_tmp6_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

BackingPhotoRow*
photo_get_raw_development_photo_row (Photo* self,
                                     RawDeveloper d)
{
	GError* _inner_error0_ = NULL;
	BackingPhotoRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* _tmp1_ = NULL;
			GeeHashMap* _tmp2_;
			_tmp2_ = self->priv->developments;
			if (_tmp2_ != NULL) {
				GeeHashMap* _tmp3_;
				gpointer _tmp4_;
				_tmp3_ = self->priv->developments;
				_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, (gpointer) ((gintptr) d));
				_backing_photo_row_unref0 (_tmp1_);
				_tmp1_ = (BackingPhotoRow*) _tmp4_;
			} else {
				_backing_photo_row_unref0 (_tmp1_);
				_tmp1_ = NULL;
			}
			result = _tmp1_;
			{
				PhotoRow* _tmp5_;
				_tmp5_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp6_;
			_tmp6_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static PhotoFileFormat*
_photo_file_format_dup (PhotoFileFormat* self)
{
	PhotoFileFormat* dup;
	dup = g_new0 (PhotoFileFormat, 1);
	memcpy (dup, self, sizeof (PhotoFileFormat));
	return dup;
}

static gpointer
__photo_file_format_dup0 (gpointer self)
{
	return self ? _photo_file_format_dup (self) : NULL;
}

PhotoFileFormat*
photo_get_editable_file_format (Photo* self)
{
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoFileReader* _tmp2_;
	PhotoFileFormat _tmp3_;
	PhotoFileFormat* _tmp4_;
	PhotoFileFormat* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = photo_get_editable_reader (self);
	reader = _tmp0_;
	_tmp1_ = reader;
	if (_tmp1_ == NULL) {
		result = NULL;
		_photo_file_adapter_unref0 (reader);
		return result;
	}
	_tmp2_ = reader;
	_tmp3_ = photo_file_adapter_get_file_format ((PhotoFileAdapter*) _tmp2_);
	_tmp4_ = __photo_file_format_dup0 (&_tmp3_);
	result = _tmp4_;
	_photo_file_adapter_unref0 (reader);
	return result;
}

PhotoFileFormat
photo_get_export_format_for_parameters (Photo* self,
                                        ExportFormatParameters* params)
{
	PhotoFileFormat _result_ = 0;
	ExportFormatParameters _tmp0_;
	PhotoFileFormat result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (params != NULL, 0);
	_result_ = photo_file_format_get_system_default_format ();
	_tmp0_ = *params;
	switch (_tmp0_.mode) {
		case EXPORT_FORMAT_MODE_UNMODIFIED:
		{
			_result_ = photo_get_master_file_format (self);
			break;
		}
		case EXPORT_FORMAT_MODE_CURRENT:
		{
			_result_ = photo_get_best_export_file_format (self);
			break;
		}
		case EXPORT_FORMAT_MODE_SPECIFIED:
		{
			ExportFormatParameters _tmp1_;
			_tmp1_ = *params;
			_result_ = _tmp1_.specified_format;
			break;
		}
		default:
		{
			g_error ("Photo.vala:1032: get_export_format_for_parameters: unsupported export " \
"format mode");
		}
	}
	result = _result_;
	return result;
}

gchar*
photo_get_export_basename_for_parameters (Photo* self,
                                          ExportFormatParameters* params)
{
	gchar* _result_ = NULL;
	ExportFormatParameters _tmp0_;
	const gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = *params;
	switch (_tmp0_.mode) {
		case EXPORT_FORMAT_MODE_UNMODIFIED:
		{
			GFile* _tmp1_;
			GFile* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = media_source_get_master_file ((MediaSource*) self);
			_tmp2_ = _tmp1_;
			_tmp3_ = g_file_get_basename (_tmp2_);
			_g_free0 (_result_);
			_result_ = _tmp3_;
			_g_object_unref0 (_tmp2_);
			break;
		}
		case EXPORT_FORMAT_MODE_CURRENT:
		case EXPORT_FORMAT_MODE_SPECIFIED:
		{
			ExportFormatParameters _tmp4_;
			PhotoFileFormat _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = *params;
			_tmp5_ = photo_get_export_format_for_parameters (self, &_tmp4_);
			_tmp6_ = photo_get_export_basename (self, &_tmp5_);
			result = _tmp6_;
			_g_free0 (_result_);
			return result;
		}
		default:
		{
			g_error ("Photo.vala:1051: get_export_basename_for_parameters: unsupported expor" \
"t format mode");
		}
	}
	_tmp7_ = _result_;
	_vala_assert (_tmp7_ != NULL, "result != null");
	result = _result_;
	return result;
}

ImportResult
photo_prepare_for_import (PhotoImportParams* params)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* info = NULL;
	GFileInfo* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp11_;
	gint64 mod_time = 0LL;
	GFileInfo* _tmp15_;
	GDateTime* _tmp16_;
	GDateTime* _tmp17_;
	gint64 _tmp18_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	PhotoFileInterrogator* interrogator = NULL;
	GFile* _tmp24_;
	PhotoFileInterrogator* _tmp25_;
	DetectedPhotoInformation* detected = NULL;
	PhotoFileInterrogator* _tmp32_;
	DetectedPhotoInformation* _tmp33_;
	DetectedPhotoInformation* _tmp34_;
	Orientation orientation = 0;
	gint64 exposure_time = 0LL;
	gchar* title = NULL;
	gchar* _tmp44_;
	gchar* comment = NULL;
	gchar* _tmp45_;
	DetectedPhotoInformation* _tmp46_;
	PhotoMetadata* _tmp47_;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp65_ = FALSE;
	DetectedPhotoInformation* _tmp66_;
	PhotoRow* _tmp72_;
	PhotoRow* _tmp73_;
	BackingPhotoRow* _tmp74_;
	GFile* _tmp75_;
	gchar* _tmp76_;
	PhotoRow* _tmp77_;
	BackingPhotoRow* _tmp78_;
	DetectedPhotoInformation* _tmp79_;
	Dimensions _tmp80_;
	PhotoRow* _tmp81_;
	BackingPhotoRow* _tmp82_;
	GFileInfo* _tmp83_;
	PhotoRow* _tmp84_;
	BackingPhotoRow* _tmp85_;
	PhotoRow* _tmp86_;
	PhotoRow* _tmp87_;
	PhotoRow* _tmp88_;
	BackingPhotoRow* _tmp89_;
	PhotoRow* _tmp90_;
	ImportID _tmp91_;
	PhotoRow* _tmp92_;
	PhotoRow* _tmp93_;
	PhotoRow* _tmp94_;
	DetectedPhotoInformation* _tmp95_;
	const gchar* _tmp96_;
	gchar* _tmp97_;
	PhotoRow* _tmp98_;
	DetectedPhotoInformation* _tmp99_;
	const gchar* _tmp100_;
	gchar* _tmp101_;
	PhotoRow* _tmp102_;
	DetectedPhotoInformation* _tmp103_;
	const gchar* _tmp104_;
	gchar* _tmp105_;
	PhotoRow* _tmp106_;
	PhotoRow* _tmp107_;
	PhotoRow* _tmp108_;
	BackingPhotoRow* _tmp109_;
	DetectedPhotoInformation* _tmp110_;
	PhotoRow* _tmp111_;
	const gchar* _tmp112_;
	gchar* _tmp113_;
	PhotoRow* _tmp114_;
	const gchar* _tmp115_;
	gchar* _tmp116_;
	Thumbnails* _tmp117_;
	GError* _inner_error0_ = NULL;
	ImportResult result;
	g_return_val_if_fail (params != NULL, 0);
	_tmp0_ = params->file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	file = _tmp1_;
	info = NULL;
	{
		GFileInfo* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFileInfo* _tmp4_;
		GFileInfo* _tmp5_;
		_tmp3_ = file;
		_tmp4_ = g_file_query_info (_tmp3_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (info);
		info = _tmp5_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = IMPORT_RESULT_FILE_ERROR;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	_tmp6_ = info;
	if (g_file_info_get_file_type (_tmp6_) != G_FILE_TYPE_REGULAR) {
		result = IMPORT_RESULT_NOT_A_FILE;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_tmp7_ = file;
	if (!photo_is_file_image (_tmp7_)) {
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = file;
		_tmp9_ = g_file_get_path (_tmp8_);
		_tmp10_ = _tmp9_;
		g_message ("Photo.vala:1089: Not importing %s: Not an image file", _tmp10_);
		_g_free0 (_tmp10_);
		result = IMPORT_RESULT_NOT_AN_IMAGE;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_tmp11_ = file;
	if (!photo_file_format_is_file_supported (_tmp11_)) {
		GFile* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = file;
		_tmp13_ = g_file_get_path (_tmp12_);
		_tmp14_ = _tmp13_;
		g_message ("Photo.vala:1095: Not importing %s: Unsupported extension", _tmp14_);
		_g_free0 (_tmp14_);
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_tmp15_ = info;
	_tmp16_ = g_file_info_get_modification_date_time (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_date_time_to_unix (_tmp17_);
	_g_date_time_unref0 (_tmp17_);
	mod_time = _tmp18_;
	_tmp21_ = params->exif_md5;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_;
		_tmp22_ = params->thumbnail_md5;
		_tmp20_ = _tmp22_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		const gchar* _tmp23_;
		_tmp23_ = params->full_md5;
		_tmp19_ = _tmp23_ != NULL;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		params->sniffer_options = params->sniffer_options | PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5;
	}
	_tmp24_ = file;
	_tmp25_ = photo_file_interrogator_new (_tmp24_, params->sniffer_options);
	interrogator = _tmp25_;
	{
		PhotoFileInterrogator* _tmp26_;
		_tmp26_ = interrogator;
		photo_file_interrogator_interrogate (_tmp26_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GFile* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		GError* _tmp30_;
		const gchar* _tmp31_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = file;
		_tmp28_ = g_file_get_path (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = err;
		_tmp31_ = _tmp30_->message;
		g_warning ("Photo.vala:1112: Unable to interrogate photo file %s: %s", _tmp29_, _tmp31_);
		_g_free0 (_tmp29_);
		result = IMPORT_RESULT_DECODE_ERROR;
		_g_error_free0 (err);
		_photo_file_interrogator_unref0 (interrogator);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_photo_file_interrogator_unref0 (interrogator);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	_tmp32_ = interrogator;
	_tmp33_ = photo_file_interrogator_get_detected_photo_information (_tmp32_);
	detected = _tmp33_;
	_tmp34_ = detected;
	if (_tmp34_ == NULL) {
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
		_detected_photo_information_unref0 (detected);
		_photo_file_interrogator_unref0 (interrogator);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	if ((params->sniffer_options & PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5) != 0) {
		DetectedPhotoInformation* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		DetectedPhotoInformation* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		DetectedPhotoInformation* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		_tmp35_ = detected;
		_tmp36_ = params->exif_md5;
		_tmp37_ = g_strdup (_tmp36_);
		_g_free0 (_tmp35_->exif_md5);
		_tmp35_->exif_md5 = _tmp37_;
		_tmp38_ = detected;
		_tmp39_ = params->thumbnail_md5;
		_tmp40_ = g_strdup (_tmp39_);
		_g_free0 (_tmp38_->thumbnail_md5);
		_tmp38_->thumbnail_md5 = _tmp40_;
		_tmp41_ = detected;
		_tmp42_ = params->full_md5;
		_tmp43_ = g_strdup (_tmp42_);
		_g_free0 (_tmp41_->md5);
		_tmp41_->md5 = _tmp43_;
	}
	orientation = ORIENTATION_TOP_LEFT;
	exposure_time = (gint64) 0;
	_tmp44_ = g_strdup ("");
	title = _tmp44_;
	_tmp45_ = g_strdup ("");
	comment = _tmp45_;
	_tmp46_ = detected;
	_tmp47_ = _tmp46_->metadata;
	if (_tmp47_ != NULL) {
		MetadataDateTime* date_time = NULL;
		DetectedPhotoInformation* _tmp48_;
		PhotoMetadata* _tmp49_;
		MetadataDateTime* _tmp50_;
		MetadataDateTime* _tmp51_;
		DetectedPhotoInformation* _tmp53_;
		PhotoMetadata* _tmp54_;
		DetectedPhotoInformation* _tmp55_;
		PhotoMetadata* _tmp56_;
		gchar* _tmp57_;
		DetectedPhotoInformation* _tmp58_;
		PhotoMetadata* _tmp59_;
		gchar* _tmp60_;
		DetectedPhotoInformation* _tmp61_;
		PhotoMetadata* _tmp62_;
		GeeSet* _tmp63_;
		_tmp48_ = detected;
		_tmp49_ = _tmp48_->metadata;
		_tmp50_ = photo_metadata_get_exposure_date_time (_tmp49_);
		date_time = _tmp50_;
		_tmp51_ = date_time;
		if (_tmp51_ != NULL) {
			MetadataDateTime* _tmp52_;
			_tmp52_ = date_time;
			exposure_time = metadata_date_time_get_timestamp (_tmp52_);
		}
		_tmp53_ = detected;
		_tmp54_ = _tmp53_->metadata;
		orientation = photo_metadata_get_orientation (_tmp54_);
		_tmp55_ = detected;
		_tmp56_ = _tmp55_->metadata;
		_tmp57_ = media_metadata_get_title ((MediaMetadata*) _tmp56_);
		_g_free0 (title);
		title = _tmp57_;
		_tmp58_ = detected;
		_tmp59_ = _tmp58_->metadata;
		_tmp60_ = media_metadata_get_comment ((MediaMetadata*) _tmp59_);
		_g_free0 (comment);
		comment = _tmp60_;
		_tmp61_ = detected;
		_tmp62_ = _tmp61_->metadata;
		_tmp63_ = photo_metadata_get_keywords (_tmp62_, NULL, NULL, NULL);
		_g_object_unref0 (params->keywords);
		params->keywords = (GeeCollection*) _tmp63_;
		_metadata_date_time_unref0 (date_time);
	}
	_tmp66_ = detected;
	if (_tmp66_->colorspace != GDK_COLORSPACE_RGB) {
		_tmp65_ = TRUE;
	} else {
		DetectedPhotoInformation* _tmp67_;
		_tmp67_ = detected;
		_tmp65_ = _tmp67_->channels < 3;
	}
	if (_tmp65_) {
		_tmp64_ = TRUE;
	} else {
		DetectedPhotoInformation* _tmp68_;
		_tmp68_ = detected;
		_tmp64_ = _tmp68_->bits_per_channel != 8;
	}
	if (_tmp64_) {
		GFile* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		_tmp69_ = file;
		_tmp70_ = g_file_get_path (_tmp69_);
		_tmp71_ = _tmp70_;
		g_message ("Photo.vala:1156: Not importing %s: Unsupported color format", _tmp71_);
		_g_free0 (_tmp71_);
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
		_g_free0 (comment);
		_g_free0 (title);
		_detected_photo_information_unref0 (detected);
		_photo_file_interrogator_unref0 (interrogator);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_tmp72_ = params->row;
	photo_id_init (&_tmp72_->photo_id, PHOTO_ID_INVALID);
	_tmp73_ = params->row;
	_tmp74_ = _tmp73_->master;
	_tmp75_ = file;
	_tmp76_ = g_file_get_path (_tmp75_);
	_g_free0 (_tmp74_->filepath);
	_tmp74_->filepath = _tmp76_;
	_tmp77_ = params->row;
	_tmp78_ = _tmp77_->master;
	_tmp79_ = detected;
	_tmp80_ = _tmp79_->image_dim;
	_tmp78_->dim = _tmp80_;
	_tmp81_ = params->row;
	_tmp82_ = _tmp81_->master;
	_tmp83_ = info;
	_tmp82_->filesize = g_file_info_get_size (_tmp83_);
	_tmp84_ = params->row;
	_tmp85_ = _tmp84_->master;
	_tmp85_->timestamp = mod_time;
	_tmp86_ = params->row;
	_tmp86_->exposure_time = exposure_time;
	_tmp87_ = params->row;
	_tmp87_->orientation = orientation;
	_tmp88_ = params->row;
	_tmp89_ = _tmp88_->master;
	_tmp89_->original_orientation = orientation;
	_tmp90_ = params->row;
	_tmp91_ = params->import_id;
	_tmp90_->import_id = _tmp91_;
	_tmp92_ = params->row;
	event_id_init (&_tmp92_->event_id, EVENT_ID_INVALID);
	_tmp93_ = params->row;
	_g_object_unref0 (_tmp93_->transformations);
	_tmp93_->transformations = NULL;
	_tmp94_ = params->row;
	_tmp95_ = detected;
	_tmp96_ = _tmp95_->md5;
	_tmp97_ = g_strdup (_tmp96_);
	_g_free0 (_tmp94_->md5);
	_tmp94_->md5 = _tmp97_;
	_tmp98_ = params->row;
	_tmp99_ = detected;
	_tmp100_ = _tmp99_->thumbnail_md5;
	_tmp101_ = g_strdup (_tmp100_);
	_g_free0 (_tmp98_->thumbnail_md5);
	_tmp98_->thumbnail_md5 = _tmp101_;
	_tmp102_ = params->row;
	_tmp103_ = detected;
	_tmp104_ = _tmp103_->exif_md5;
	_tmp105_ = g_strdup (_tmp104_);
	_g_free0 (_tmp102_->exif_md5);
	_tmp102_->exif_md5 = _tmp105_;
	_tmp106_ = params->row;
	_tmp106_->time_created = (gint64) 0;
	_tmp107_ = params->row;
	_tmp107_->flags = (guint64) 0;
	_tmp108_ = params->row;
	_tmp109_ = _tmp108_->master;
	_tmp110_ = detected;
	_tmp109_->file_format = _tmp110_->file_format;
	_tmp111_ = params->row;
	_tmp112_ = title;
	_tmp113_ = g_strdup (_tmp112_);
	_g_free0 (_tmp111_->title);
	_tmp111_->title = _tmp113_;
	_tmp114_ = params->row;
	_tmp115_ = comment;
	_tmp116_ = g_strdup (_tmp115_);
	_g_free0 (_tmp114_->comment);
	_tmp114_->comment = _tmp116_;
	_tmp117_ = params->thumbnails;
	if (_tmp117_ != NULL) {
		PhotoFileReader* reader = NULL;
		PhotoRow* _tmp118_;
		BackingPhotoRow* _tmp119_;
		PhotoRow* _tmp120_;
		BackingPhotoRow* _tmp121_;
		const gchar* _tmp122_;
		PhotoFileReader* _tmp123_;
		_tmp118_ = params->row;
		_tmp119_ = _tmp118_->master;
		_tmp120_ = params->row;
		_tmp121_ = _tmp120_->master;
		_tmp122_ = _tmp121_->filepath;
		_tmp123_ = photo_file_format_create_reader (_tmp119_->file_format, _tmp122_);
		reader = _tmp123_;
		{
			Thumbnails* _tmp124_;
			PhotoFileReader* _tmp125_;
			PhotoRow* _tmp126_;
			PhotoRow* _tmp127_;
			BackingPhotoRow* _tmp128_;
			Dimensions _tmp129_;
			_tmp124_ = params->thumbnails;
			_tmp125_ = reader;
			_tmp126_ = params->row;
			_tmp127_ = params->row;
			_tmp128_ = _tmp127_->master;
			_tmp129_ = _tmp128_->dim;
			thumbnail_cache_generate_for_photo (_tmp124_, _tmp125_, _tmp126_->orientation, &_tmp129_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* err = NULL;
			GError* _tmp130_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp130_ = err;
			result = import_result_convert_error (_tmp130_, IMPORT_RESULT_FILE_ERROR);
			_g_error_free0 (err);
			_photo_file_adapter_unref0 (reader);
			_g_free0 (comment);
			_g_free0 (title);
			_detected_photo_information_unref0 (detected);
			_photo_file_interrogator_unref0 (interrogator);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return result;
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_photo_file_adapter_unref0 (reader);
			_g_free0 (comment);
			_g_free0 (title);
			_detected_photo_information_unref0 (detected);
			_photo_file_interrogator_unref0 (interrogator);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
		_photo_file_adapter_unref0 (reader);
	}
	result = IMPORT_RESULT_SUCCESS;
	_g_free0 (comment);
	_g_free0 (title);
	_detected_photo_information_unref0 (detected);
	_photo_file_interrogator_unref0 (interrogator);
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	return result;
}

void
photo_create_pre_import (PhotoImportParams* params)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	PhotoRow* _tmp2_;
	PhotoRow* _tmp3_;
	BackingPhotoRow* _tmp4_;
	gchar* _tmp5_;
	PhotoRow* _tmp6_;
	BackingPhotoRow* _tmp7_;
	PhotoRow* _tmp8_;
	BackingPhotoRow* _tmp9_;
	PhotoRow* _tmp10_;
	BackingPhotoRow* _tmp11_;
	PhotoRow* _tmp12_;
	PhotoRow* _tmp13_;
	PhotoRow* _tmp14_;
	BackingPhotoRow* _tmp15_;
	PhotoRow* _tmp16_;
	ImportID _tmp17_;
	PhotoRow* _tmp18_;
	PhotoRow* _tmp19_;
	PhotoRow* _tmp20_;
	PhotoRow* _tmp21_;
	PhotoRow* _tmp22_;
	PhotoRow* _tmp23_;
	PhotoRow* _tmp24_;
	PhotoRow* _tmp25_;
	BackingPhotoRow* _tmp26_;
	PhotoRow* _tmp27_;
	PhotoRow* _tmp28_;
	PhotoFileInterrogator* interrogator = NULL;
	GFile* _tmp29_;
	PhotoFileInterrogator* _tmp30_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (params != NULL);
	_tmp0_ = params->file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	file = _tmp1_;
	_tmp2_ = params->row;
	photo_id_init (&_tmp2_->photo_id, PHOTO_ID_INVALID);
	_tmp3_ = params->row;
	_tmp4_ = _tmp3_->master;
	_tmp5_ = g_file_get_path (file);
	_g_free0 (_tmp4_->filepath);
	_tmp4_->filepath = _tmp5_;
	_tmp6_ = params->row;
	_tmp7_ = _tmp6_->master;
	dimensions_init (&_tmp7_->dim, 0, 0);
	_tmp8_ = params->row;
	_tmp9_ = _tmp8_->master;
	_tmp9_->filesize = (gint64) 0;
	_tmp10_ = params->row;
	_tmp11_ = _tmp10_->master;
	_tmp11_->timestamp = (gint64) 0;
	_tmp12_ = params->row;
	_tmp12_->exposure_time = (gint64) 0;
	_tmp13_ = params->row;
	_tmp13_->orientation = ORIENTATION_TOP_LEFT;
	_tmp14_ = params->row;
	_tmp15_ = _tmp14_->master;
	_tmp15_->original_orientation = ORIENTATION_TOP_LEFT;
	_tmp16_ = params->row;
	_tmp17_ = params->import_id;
	_tmp16_->import_id = _tmp17_;
	_tmp18_ = params->row;
	event_id_init (&_tmp18_->event_id, EVENT_ID_INVALID);
	_tmp19_ = params->row;
	_g_object_unref0 (_tmp19_->transformations);
	_tmp19_->transformations = NULL;
	_tmp20_ = params->row;
	_g_free0 (_tmp20_->md5);
	_tmp20_->md5 = NULL;
	_tmp21_ = params->row;
	_g_free0 (_tmp21_->thumbnail_md5);
	_tmp21_->thumbnail_md5 = NULL;
	_tmp22_ = params->row;
	_g_free0 (_tmp22_->exif_md5);
	_tmp22_->exif_md5 = NULL;
	_tmp23_ = params->row;
	_tmp23_->time_created = (gint64) 0;
	_tmp24_ = params->row;
	_tmp24_->flags = (guint64) 0;
	_tmp25_ = params->row;
	_tmp26_ = _tmp25_->master;
	_tmp26_->file_format = PHOTO_FILE_FORMAT_JFIF;
	_tmp27_ = params->row;
	_g_free0 (_tmp27_->title);
	_tmp27_->title = NULL;
	_tmp28_ = params->row;
	_g_free0 (_tmp28_->comment);
	_tmp28_->comment = NULL;
	_tmp29_ = params->file;
	_tmp30_ = photo_file_interrogator_new (_tmp29_, params->sniffer_options);
	interrogator = _tmp30_;
	{
		DetectedPhotoInformation* detected = NULL;
		DetectedPhotoInformation* _tmp31_;
		DetectedPhotoInformation* _tmp32_;
		photo_file_interrogator_interrogate (interrogator, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp31_ = photo_file_interrogator_get_detected_photo_information (interrogator);
		detected = _tmp31_;
		_tmp32_ = detected;
		if (_tmp32_ != NULL) {
			PhotoRow* _tmp33_;
			BackingPhotoRow* _tmp34_;
			DetectedPhotoInformation* _tmp35_;
			MetadataDateTime* date_time = NULL;
			DetectedPhotoInformation* _tmp36_;
			PhotoMetadata* _tmp37_;
			MetadataDateTime* _tmp38_;
			MetadataDateTime* _tmp39_;
			_tmp33_ = params->row;
			_tmp34_ = _tmp33_->master;
			_tmp35_ = detected;
			_tmp34_->file_format = _tmp35_->file_format;
			_tmp36_ = detected;
			_tmp37_ = _tmp36_->metadata;
			_tmp38_ = photo_metadata_get_exposure_date_time (_tmp37_);
			date_time = _tmp38_;
			_tmp39_ = date_time;
			if (_tmp39_ != NULL) {
				PhotoRow* _tmp40_;
				MetadataDateTime* _tmp41_;
				_tmp40_ = params->row;
				_tmp41_ = date_time;
				_tmp40_->exposure_time = metadata_date_time_get_timestamp (_tmp41_);
			}
			_metadata_date_time_unref0 (date_time);
		}
		_detected_photo_information_unref0 (detected);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp42_;
		gchar* _tmp43_;
		GError* _tmp44_;
		const gchar* _tmp45_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp42_ = g_file_get_path (file);
		_tmp43_ = _tmp42_;
		_tmp44_ = err;
		_tmp45_ = _tmp44_->message;
		g_debug ("Photo.vala:1235: Unable to interrogate photo file %s: %s", _tmp43_, _tmp45_);
		_g_free0 (_tmp43_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_photo_file_interrogator_unref0 (interrogator);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_photo_file_interrogator_unref0 (interrogator);
	_g_object_unref0 (file);
}

BackingPhotoRow*
photo_query_backing_photo_row (Photo* self,
                               GFile* file,
                               PhotoFileSnifferOptions options,
                               DetectedPhotoInformation** detected,
                               GError** error)
{
	DetectedPhotoInformation* _vala_detected = NULL;
	BackingPhotoRow* backing = NULL;
	BackingPhotoRow* _tmp0_;
	GFileInfo* info = NULL;
	PhotoFileInterrogator* interrogator = NULL;
	PhotoFileInterrogator* _tmp8_;
	PhotoFileInterrogator* _tmp9_;
	PhotoFileInterrogator* _tmp10_;
	DetectedPhotoInformation* _tmp11_;
	DetectedPhotoInformation* _tmp12_;
	gint64 mod_time = 0LL;
	GFileInfo* _tmp15_;
	GDateTime* _tmp16_;
	GDateTime* _tmp17_;
	gint64 _tmp18_;
	BackingPhotoRow* _tmp19_;
	gchar* _tmp20_;
	BackingPhotoRow* _tmp21_;
	BackingPhotoRow* _tmp22_;
	GFileInfo* _tmp23_;
	BackingPhotoRow* _tmp24_;
	DetectedPhotoInformation* _tmp25_;
	BackingPhotoRow* _tmp26_;
	DetectedPhotoInformation* _tmp27_;
	Dimensions _tmp28_;
	Orientation _tmp29_ = 0;
	DetectedPhotoInformation* _tmp30_;
	PhotoMetadata* _tmp31_;
	BackingPhotoRow* _tmp34_;
	GError* _inner_error0_ = NULL;
	BackingPhotoRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_detected_photo_information_unref0 (_vala_detected);
	_vala_detected = NULL;
	_tmp0_ = backing_photo_row_new ();
	backing = _tmp0_;
	info = NULL;
	{
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		_tmp2_ = g_file_query_info (file, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (info);
		info = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = g_file_get_path (file);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_critical ("Photo.vala:1250: Unable to read file information for %s: %s", _tmp5_, _tmp7_);
		_g_free0 (_tmp5_);
		result = NULL;
		_g_error_free0 (err);
		_g_object_unref0 (info);
		_backing_photo_row_unref0 (backing);
		if (detected) {
			*detected = _vala_detected;
		} else {
			_detected_photo_information_unref0 (_vala_detected);
		}
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (info);
		_backing_photo_row_unref0 (backing);
		_detected_photo_information_unref0 (_vala_detected);
		return NULL;
	}
	_tmp8_ = photo_file_interrogator_new (file, options);
	interrogator = _tmp8_;
	_tmp9_ = interrogator;
	photo_file_interrogator_interrogate (_tmp9_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_interrogator_unref0 (interrogator);
		_g_object_unref0 (info);
		_backing_photo_row_unref0 (backing);
		_detected_photo_information_unref0 (_vala_detected);
		return NULL;
	}
	_tmp10_ = interrogator;
	_tmp11_ = photo_file_interrogator_get_detected_photo_information (_tmp10_);
	_detected_photo_information_unref0 (_vala_detected);
	_vala_detected = _tmp11_;
	_tmp12_ = _vala_detected;
	if (_tmp12_ == NULL) {
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = data_object_to_string ((DataObject*) self);
		_tmp14_ = _tmp13_;
		g_critical ("Photo.vala:1260: Photo update: %s no longer a recognized image", _tmp14_);
		_g_free0 (_tmp14_);
		result = NULL;
		_photo_file_interrogator_unref0 (interrogator);
		_g_object_unref0 (info);
		_backing_photo_row_unref0 (backing);
		if (detected) {
			*detected = _vala_detected;
		} else {
			_detected_photo_information_unref0 (_vala_detected);
		}
		return result;
	}
	_tmp15_ = info;
	_tmp16_ = g_file_info_get_modification_date_time (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_date_time_to_unix (_tmp17_);
	_g_date_time_unref0 (_tmp17_);
	mod_time = _tmp18_;
	_tmp19_ = backing;
	_tmp20_ = g_file_get_path (file);
	_g_free0 (_tmp19_->filepath);
	_tmp19_->filepath = _tmp20_;
	_tmp21_ = backing;
	_tmp21_->timestamp = mod_time;
	_tmp22_ = backing;
	_tmp23_ = info;
	_tmp22_->filesize = g_file_info_get_size (_tmp23_);
	_tmp24_ = backing;
	_tmp25_ = _vala_detected;
	_tmp24_->file_format = _tmp25_->file_format;
	_tmp26_ = backing;
	_tmp27_ = _vala_detected;
	_tmp28_ = _tmp27_->image_dim;
	_tmp26_->dim = _tmp28_;
	_tmp30_ = _vala_detected;
	_tmp31_ = _tmp30_->metadata;
	if (_tmp31_ != NULL) {
		DetectedPhotoInformation* _tmp32_;
		PhotoMetadata* _tmp33_;
		_tmp32_ = _vala_detected;
		_tmp33_ = _tmp32_->metadata;
		_tmp29_ = photo_metadata_get_orientation (_tmp33_);
	} else {
		_tmp29_ = ORIENTATION_TOP_LEFT;
	}
	_tmp34_ = backing;
	_tmp34_->original_orientation = _tmp29_;
	result = backing;
	_photo_file_interrogator_unref0 (interrogator);
	_g_object_unref0 (info);
	if (detected) {
		*detected = _vala_detected;
	} else {
		_detected_photo_information_unref0 (_vala_detected);
	}
	return result;
}

static void
_vala_array_add10 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add11 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add12 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add13 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add14 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gpointer
_media_metadata_ref0 (gpointer self)
{
	return self ? media_metadata_ref (self) : NULL;
}

gboolean
photo_prepare_for_reimport_master (Photo* self,
                                   PhotoReimportMasterState** reimport_state,
                                   GError** error)
{
	PhotoReimportMasterState* _vala_reimport_state = NULL;
	GFile* file = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	DetectedPhotoInformation* detected = NULL;
	BackingPhotoRow* backing = NULL;
	GFile* _tmp4_;
	DetectedPhotoInformation* _tmp5_ = NULL;
	BackingPhotoRow* _tmp6_;
	BackingPhotoRow* _tmp8_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	DetectedPhotoInformation* _tmp14_;
	PhotoRow* updated_row = NULL;
	PhotoRow* _tmp20_;
	gchar** list = NULL;
	gchar** _tmp26_;
	gint list_length1;
	gint _list_size_;
	PhotoRow* _tmp27_;
	const gchar* _tmp28_;
	DetectedPhotoInformation* _tmp29_;
	const gchar* _tmp30_;
	PhotoRow* _tmp32_;
	BackingPhotoRow* _tmp33_;
	BackingPhotoRow* _tmp34_;
	DetectedPhotoInformation* _tmp39_;
	PhotoMetadata* _tmp40_;
	PhotoRow* _tmp65_;
	BackingPhotoRow* _tmp66_;
	BackingPhotoRow* _tmp67_;
	PhotoRow* _tmp68_;
	DetectedPhotoInformation* _tmp69_;
	const gchar* _tmp70_;
	gchar* _tmp71_;
	PhotoRow* _tmp72_;
	DetectedPhotoInformation* _tmp73_;
	const gchar* _tmp74_;
	gchar* _tmp75_;
	PhotoRow* _tmp76_;
	DetectedPhotoInformation* _tmp77_;
	const gchar* _tmp78_;
	gchar* _tmp79_;
	PhotoMetadata* metadata = NULL;
	DetectedPhotoInformation* _tmp80_;
	PhotoMetadata* _tmp81_;
	PhotoRow* _tmp103_;
	PhotoMetadata* _tmp104_;
	gchar** _tmp105_;
	gint _tmp105__length1;
	PhotoReimportMasterStateImpl* _tmp106_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_photo_reimport_master_state_unref0 (_vala_reimport_state);
	_vala_reimport_state = NULL;
	_tmp0_ = photo_get_master_reader (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp1_);
	_tmp3_ = _tmp2_;
	_photo_file_adapter_unref0 (_tmp1_);
	file = _tmp3_;
	_tmp4_ = file;
	_tmp6_ = photo_query_backing_photo_row (self, _tmp4_, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL, &_tmp5_, &_inner_error0_);
	_detected_photo_information_unref0 (detected);
	detected = _tmp5_;
	backing = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_detected_photo_information_unref0 (detected);
		_g_object_unref0 (file);
		_photo_reimport_master_state_unref0 (_vala_reimport_state);
		return _tmp7_;
	}
	_tmp8_ = backing;
	if (_tmp8_ == NULL) {
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = file;
		_tmp10_ = g_file_get_path (_tmp9_);
		_tmp11_ = _tmp10_;
		g_warning ("Photo.vala:1348: Unable to retrieve photo state from %s for reimport", _tmp11_);
		_g_free0 (_tmp11_);
		result = FALSE;
		_backing_photo_row_unref0 (backing);
		_detected_photo_information_unref0 (detected);
		_g_object_unref0 (file);
		if (reimport_state) {
			*reimport_state = _vala_reimport_state;
		} else {
			_photo_reimport_master_state_unref0 (_vala_reimport_state);
		}
		return result;
	}
	_tmp14_ = detected;
	if (_tmp14_->colorspace != GDK_COLORSPACE_RGB) {
		_tmp13_ = TRUE;
	} else {
		DetectedPhotoInformation* _tmp15_;
		_tmp15_ = detected;
		_tmp13_ = _tmp15_->channels < 3;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		DetectedPhotoInformation* _tmp16_;
		_tmp16_ = detected;
		_tmp12_ = _tmp16_->bits_per_channel != 8;
	}
	if (_tmp12_) {
		GFile* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp17_ = file;
		_tmp18_ = g_file_get_path (_tmp17_);
		_tmp19_ = _tmp18_;
		g_warning ("Photo.vala:1356: Not re-importing %s: Unsupported color format", _tmp19_);
		_g_free0 (_tmp19_);
		result = FALSE;
		_backing_photo_row_unref0 (backing);
		_detected_photo_information_unref0 (detected);
		_g_object_unref0 (file);
		if (reimport_state) {
			*reimport_state = _vala_reimport_state;
		} else {
			_photo_reimport_master_state_unref0 (_vala_reimport_state);
		}
		return result;
	}
	_tmp20_ = photo_row_new ();
	updated_row = _tmp20_;
	{
		PhotoRow* _tmp21_;
		_tmp21_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp22_;
			PhotoRow* _tmp23_;
			_tmp22_ = self->row;
			_tmp23_ = _photo_row_ref0 (_tmp22_);
			_photo_row_unref0 (updated_row);
			updated_row = _tmp23_;
		}
		__finally0:
		{
			PhotoRow* _tmp24_;
			_tmp24_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp25_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_photo_row_unref0 (updated_row);
			_backing_photo_row_unref0 (backing);
			_detected_photo_information_unref0 (detected);
			_g_object_unref0 (file);
			_photo_reimport_master_state_unref0 (_vala_reimport_state);
			return _tmp25_;
		}
	}
	_tmp26_ = g_new0 (gchar*, 0 + 1);
	list = _tmp26_;
	list_length1 = 0;
	_list_size_ = list_length1;
	_tmp27_ = updated_row;
	_tmp28_ = _tmp27_->md5;
	_tmp29_ = detected;
	_tmp30_ = _tmp29_->md5;
	if (g_strcmp0 (_tmp28_, _tmp30_) != 0) {
		gchar* _tmp31_;
		_tmp31_ = g_strdup ("metadata:md5");
		_vala_array_add10 (&list, &list_length1, &_list_size_, _tmp31_);
	}
	_tmp32_ = updated_row;
	_tmp33_ = _tmp32_->master;
	_tmp34_ = backing;
	if (_tmp33_->original_orientation != _tmp34_->original_orientation) {
		gchar* _tmp35_;
		PhotoRow* _tmp36_;
		BackingPhotoRow* _tmp37_;
		BackingPhotoRow* _tmp38_;
		_tmp35_ = g_strdup ("image:orientation");
		_vala_array_add11 (&list, &list_length1, &_list_size_, _tmp35_);
		_tmp36_ = updated_row;
		_tmp37_ = _tmp36_->master;
		_tmp38_ = backing;
		_tmp37_->original_orientation = _tmp38_->original_orientation;
	}
	_tmp39_ = detected;
	_tmp40_ = _tmp39_->metadata;
	if (_tmp40_ != NULL) {
		MetadataDateTime* date_time = NULL;
		DetectedPhotoInformation* _tmp41_;
		PhotoMetadata* _tmp42_;
		MetadataDateTime* _tmp43_;
		gboolean _tmp44_ = FALSE;
		MetadataDateTime* _tmp45_;
		PhotoRow* _tmp49_;
		const gchar* _tmp50_;
		DetectedPhotoInformation* _tmp51_;
		PhotoMetadata* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gboolean _tmp55_;
		PhotoRow* _tmp57_;
		const gchar* _tmp58_;
		DetectedPhotoInformation* _tmp59_;
		PhotoMetadata* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gboolean _tmp63_;
		_tmp41_ = detected;
		_tmp42_ = _tmp41_->metadata;
		_tmp43_ = photo_metadata_get_exposure_date_time (_tmp42_);
		date_time = _tmp43_;
		_tmp45_ = date_time;
		if (_tmp45_ != NULL) {
			PhotoRow* _tmp46_;
			MetadataDateTime* _tmp47_;
			_tmp46_ = updated_row;
			_tmp47_ = date_time;
			_tmp44_ = _tmp46_->exposure_time != metadata_date_time_get_timestamp (_tmp47_);
		} else {
			_tmp44_ = FALSE;
		}
		if (_tmp44_) {
			gchar* _tmp48_;
			_tmp48_ = g_strdup ("metadata:exposure-time");
			_vala_array_add12 (&list, &list_length1, &_list_size_, _tmp48_);
		}
		_tmp49_ = updated_row;
		_tmp50_ = _tmp49_->title;
		_tmp51_ = detected;
		_tmp52_ = _tmp51_->metadata;
		_tmp53_ = media_metadata_get_title ((MediaMetadata*) _tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = g_strcmp0 (_tmp50_, _tmp54_) != 0;
		_g_free0 (_tmp54_);
		if (_tmp55_) {
			gchar* _tmp56_;
			_tmp56_ = g_strdup ("metadata:name");
			_vala_array_add13 (&list, &list_length1, &_list_size_, _tmp56_);
		}
		_tmp57_ = updated_row;
		_tmp58_ = _tmp57_->comment;
		_tmp59_ = detected;
		_tmp60_ = _tmp59_->metadata;
		_tmp61_ = media_metadata_get_comment ((MediaMetadata*) _tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = g_strcmp0 (_tmp58_, _tmp62_) != 0;
		_g_free0 (_tmp62_);
		if (_tmp63_) {
			gchar* _tmp64_;
			_tmp64_ = g_strdup ("metadata:comment");
			_vala_array_add14 (&list, &list_length1, &_list_size_, _tmp64_);
		}
		_metadata_date_time_unref0 (date_time);
	}
	_tmp65_ = updated_row;
	_tmp66_ = backing;
	_tmp67_ = _backing_photo_row_ref0 (_tmp66_);
	_backing_photo_row_unref0 (_tmp65_->master);
	_tmp65_->master = _tmp67_;
	_tmp68_ = updated_row;
	_tmp69_ = detected;
	_tmp70_ = _tmp69_->md5;
	_tmp71_ = g_strdup (_tmp70_);
	_g_free0 (_tmp68_->md5);
	_tmp68_->md5 = _tmp71_;
	_tmp72_ = updated_row;
	_tmp73_ = detected;
	_tmp74_ = _tmp73_->exif_md5;
	_tmp75_ = g_strdup (_tmp74_);
	_g_free0 (_tmp72_->exif_md5);
	_tmp72_->exif_md5 = _tmp75_;
	_tmp76_ = updated_row;
	_tmp77_ = detected;
	_tmp78_ = _tmp77_->thumbnail_md5;
	_tmp79_ = g_strdup (_tmp78_);
	_g_free0 (_tmp76_->thumbnail_md5);
	_tmp76_->thumbnail_md5 = _tmp79_;
	metadata = NULL;
	_tmp80_ = detected;
	_tmp81_ = _tmp80_->metadata;
	if (_tmp81_ != NULL) {
		DetectedPhotoInformation* _tmp82_;
		PhotoMetadata* _tmp83_;
		PhotoMetadata* _tmp84_;
		MetadataDateTime* date_time = NULL;
		DetectedPhotoInformation* _tmp85_;
		PhotoMetadata* _tmp86_;
		MetadataDateTime* _tmp87_;
		MetadataDateTime* _tmp88_;
		PhotoRow* _tmp91_;
		DetectedPhotoInformation* _tmp92_;
		PhotoMetadata* _tmp93_;
		gchar* _tmp94_;
		PhotoRow* _tmp95_;
		DetectedPhotoInformation* _tmp96_;
		PhotoMetadata* _tmp97_;
		gchar* _tmp98_;
		PhotoRow* _tmp99_;
		DetectedPhotoInformation* _tmp100_;
		PhotoMetadata* _tmp101_;
		gchar* _tmp102_;
		_tmp82_ = detected;
		_tmp83_ = _tmp82_->metadata;
		_tmp84_ = _media_metadata_ref0 (_tmp83_);
		_media_metadata_unref0 (metadata);
		metadata = _tmp84_;
		_tmp85_ = detected;
		_tmp86_ = _tmp85_->metadata;
		_tmp87_ = photo_metadata_get_exposure_date_time (_tmp86_);
		date_time = _tmp87_;
		_tmp88_ = date_time;
		if (_tmp88_ != NULL) {
			PhotoRow* _tmp89_;
			MetadataDateTime* _tmp90_;
			_tmp89_ = updated_row;
			_tmp90_ = date_time;
			_tmp89_->exposure_time = metadata_date_time_get_timestamp (_tmp90_);
		}
		_tmp91_ = updated_row;
		_tmp92_ = detected;
		_tmp93_ = _tmp92_->metadata;
		_tmp94_ = media_metadata_get_title ((MediaMetadata*) _tmp93_);
		_g_free0 (_tmp91_->title);
		_tmp91_->title = _tmp94_;
		_tmp95_ = updated_row;
		_tmp96_ = detected;
		_tmp97_ = _tmp96_->metadata;
		_tmp98_ = media_metadata_get_comment ((MediaMetadata*) _tmp97_);
		_g_free0 (_tmp95_->comment);
		_tmp95_->comment = _tmp98_;
		_tmp99_ = updated_row;
		_tmp100_ = detected;
		_tmp101_ = _tmp100_->metadata;
		_tmp102_ = media_metadata_get_comment ((MediaMetadata*) _tmp101_);
		_g_free0 (_tmp99_->comment);
		_tmp99_->comment = _tmp102_;
		_metadata_date_time_unref0 (date_time);
	}
	_tmp103_ = updated_row;
	_tmp104_ = metadata;
	_tmp105_ = list;
	_tmp105__length1 = list_length1;
	_tmp106_ = photo_reimport_master_state_impl_new (_tmp103_, _tmp104_, _tmp105_, _tmp105__length1);
	_photo_reimport_master_state_unref0 (_vala_reimport_state);
	_vala_reimport_state = (PhotoReimportMasterState*) _tmp106_;
	result = TRUE;
	_media_metadata_unref0 (metadata);
	list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_free), NULL);
	_photo_row_unref0 (updated_row);
	_backing_photo_row_unref0 (backing);
	_detected_photo_information_unref0 (detected);
	_g_object_unref0 (file);
	if (reimport_state) {
		*reimport_state = _vala_reimport_state;
	} else {
		_photo_reimport_master_state_unref0 (_vala_reimport_state);
	}
	return result;
}

static void
photo_real_apply_user_metadata_for_reimport (Photo* self,
                                             PhotoMetadata* metadata)
{
	g_critical ("Type `%s' does not implement abstract method `photo_apply_user_metadata_for_reimport'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
photo_apply_user_metadata_for_reimport (Photo* self,
                                        PhotoMetadata* metadata)
{
	PhotoClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->apply_user_metadata_for_reimport) {
		_klass_->apply_user_metadata_for_reimport (self, metadata);
	}
}

static gpointer
_photo_reimport_master_state_ref0 (gpointer self)
{
	return self ? photo_reimport_master_state_ref (self) : NULL;
}

static void
_vala_array_add15 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add16 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
photo_finish_reimport_master (Photo* self,
                              PhotoReimportMasterState* state,
                              GError** error)
{
	PhotoReimportMasterStateImpl* reimport_state = NULL;
	PhotoReimportMasterStateImpl* _tmp0_;
	PhotoTable* _tmp1_;
	PhotoTable* _tmp2_;
	PhotoRow* _tmp3_;
	PhotoMetadata* _tmp18_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	PhotoMetadata* _tmp26_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	_tmp0_ = _photo_reimport_master_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (state, PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl));
	reimport_state = _tmp0_;
	_tmp1_ = photo_table_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = reimport_state->row;
	photo_table_reimport (_tmp2_, _tmp3_, &_inner_error0_);
	_database_table_unref0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_photo_reimport_master_state_unref0 (reimport_state);
			return;
		} else {
			_photo_reimport_master_state_unref0 (reimport_state);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		PhotoRow* _tmp4_;
		_tmp4_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* original_master = NULL;
			PhotoRow* _tmp5_;
			BackingPhotoRow* _tmp6_;
			BackingPhotoRow* _tmp7_;
			PhotoRow* _tmp8_;
			PhotoRow* _tmp9_;
			PhotoRow* _tmp10_;
			BackingPhotoRow* _tmp11_;
			BackingPhotoRow* _tmp12_;
			PhotoRow* _tmp13_;
			BackingPhotoRow* _tmp14_;
			PhotoRow* _tmp15_;
			BackingPhotoRow* _tmp16_;
			_tmp5_ = self->row;
			_tmp6_ = _tmp5_->master;
			_tmp7_ = _backing_photo_row_ref0 (_tmp6_);
			original_master = _tmp7_;
			_tmp8_ = reimport_state->row;
			_tmp9_ = _photo_row_ref0 (_tmp8_);
			_photo_row_unref0 (self->row);
			self->row = _tmp9_;
			_tmp10_ = self->row;
			_tmp11_ = original_master;
			_tmp12_ = _backing_photo_row_ref0 (_tmp11_);
			_backing_photo_row_unref0 (_tmp10_->master);
			_tmp10_->master = _tmp12_;
			_tmp13_ = self->row;
			_tmp14_ = _tmp13_->master;
			_tmp15_ = reimport_state->row;
			_tmp16_ = _tmp15_->master;
			backing_photo_row_copy_from (_tmp14_, _tmp16_);
			if (!reimport_state->metadata_only) {
				photo_internal_remove_all_transformations (self, FALSE);
			}
			_backing_photo_row_unref0 (original_master);
		}
		__finally0:
		{
			PhotoRow* _tmp17_;
			_tmp17_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_photo_reimport_master_state_unref0 (reimport_state);
				return;
			} else {
				_photo_reimport_master_state_unref0 (reimport_state);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp18_ = reimport_state->metadata;
	if (_tmp18_ != NULL) {
		PhotoMetadata* _tmp19_;
		_tmp19_ = reimport_state->metadata;
		photo_apply_user_metadata_for_reimport (self, _tmp19_);
	}
	if (!reimport_state->metadata_only) {
		gchar* _tmp20_;
		_tmp20_ = g_strdup ("image:master");
		_vala_array_add15 (&reimport_state->alterations, &reimport_state->alterations_length1, &reimport_state->_alterations_size_, _tmp20_);
		if (photo_is_master_baseline (self)) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("image:baseline");
			_vala_array_add16 (&reimport_state->alterations, &reimport_state->alterations_length1, &reimport_state->_alterations_size_, _tmp21_);
		}
	}
	_tmp22_ = reimport_state->alterations;
	_tmp22__length1 = reimport_state->alterations_length1;
	if (_tmp22__length1 > 0) {
		gchar** _tmp23_;
		gint _tmp23__length1;
		Alteration* _tmp24_;
		Alteration* _tmp25_;
		_tmp23_ = reimport_state->alterations;
		_tmp23__length1 = reimport_state->alterations_length1;
		_tmp24_ = alteration_new_from_array (_tmp23_, _tmp23__length1);
		_tmp25_ = _tmp24_;
		data_object_notify_altered ((DataObject*) self, _tmp25_);
		_alteration_unref0 (_tmp25_);
	}
	_tmp26_ = reimport_state->metadata;
	photo_notify_master_reimported (self, _tmp26_);
	if (photo_is_master_baseline (self)) {
		PhotoMetadata* _tmp27_;
		_tmp27_ = reimport_state->metadata;
		photo_notify_baseline_reimported (self, _tmp27_);
	}
	if (photo_is_master_source (self)) {
		PhotoMetadata* _tmp28_;
		_tmp28_ = reimport_state->metadata;
		photo_notify_source_reimported (self, _tmp28_);
	}
	_photo_reimport_master_state_unref0 (reimport_state);
}

static gboolean
photo_verify_file_for_reimport (Photo* self,
                                GFile* file,
                                BackingPhotoRow** backing,
                                DetectedPhotoInformation** detected,
                                GError** error)
{
	BackingPhotoRow* _vala_backing = NULL;
	DetectedPhotoInformation* _vala_detected = NULL;
	BackingPhotoRow* _tmp0_ = NULL;
	DetectedPhotoInformation* _tmp1_ = NULL;
	BackingPhotoRow* _tmp2_;
	BackingPhotoRow* _tmp4_;
	BackingPhotoRow* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	DetectedPhotoInformation* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp2_ = photo_query_backing_photo_row (self, file, PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5, &_tmp1_, &_inner_error0_);
	_detected_photo_information_unref0 (_vala_detected);
	_vala_detected = _tmp1_;
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_backing_photo_row_unref0 (_vala_backing);
		_detected_photo_information_unref0 (_vala_detected);
		return _tmp3_;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	_backing_photo_row_unref0 (_vala_backing);
	_vala_backing = _tmp4_;
	_tmp5_ = _vala_backing;
	if (_tmp5_ == NULL) {
		result = FALSE;
		_backing_photo_row_unref0 (_tmp0_);
		if (backing) {
			*backing = _vala_backing;
		} else {
			_backing_photo_row_unref0 (_vala_backing);
		}
		if (detected) {
			*detected = _vala_detected;
		} else {
			_detected_photo_information_unref0 (_vala_detected);
		}
		return result;
	}
	_tmp8_ = _vala_detected;
	if (_tmp8_->colorspace != GDK_COLORSPACE_RGB) {
		_tmp7_ = TRUE;
	} else {
		DetectedPhotoInformation* _tmp9_;
		_tmp9_ = _vala_detected;
		_tmp7_ = _tmp9_->channels < 3;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		DetectedPhotoInformation* _tmp10_;
		_tmp10_ = _vala_detected;
		_tmp6_ = _tmp10_->bits_per_channel != 8;
	}
	if (_tmp6_) {
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = g_file_get_path (file);
		_tmp12_ = _tmp11_;
		g_warning ("Photo.vala:1476: Not re-importing %s: Unsupported color format", _tmp12_);
		_g_free0 (_tmp12_);
		result = FALSE;
		_backing_photo_row_unref0 (_tmp0_);
		if (backing) {
			*backing = _vala_backing;
		} else {
			_backing_photo_row_unref0 (_vala_backing);
		}
		if (detected) {
			*detected = _vala_detected;
		} else {
			_detected_photo_information_unref0 (_vala_detected);
		}
		return result;
	}
	result = TRUE;
	_backing_photo_row_unref0 (_tmp0_);
	if (backing) {
		*backing = _vala_backing;
	} else {
		_backing_photo_row_unref0 (_vala_backing);
	}
	if (detected) {
		*detected = _vala_detected;
	} else {
		_detected_photo_information_unref0 (_vala_detected);
	}
	return result;
}

gboolean
photo_prepare_for_reimport_editable (Photo* self,
                                     PhotoReimportEditableState** state,
                                     GError** error)
{
	PhotoReimportEditableState* _vala_state = NULL;
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	DetectedPhotoInformation* detected = NULL;
	BackingPhotoRow* backing = NULL;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_;
	BackingPhotoRow* _tmp4_ = NULL;
	DetectedPhotoInformation* _tmp5_ = NULL;
	gboolean _tmp6_;
	BackingPhotoRow* _tmp8_;
	DetectedPhotoInformation* _tmp9_;
	PhotoMetadata* _tmp10_;
	PhotoReimportEditableStateImpl* _tmp11_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_photo_reimport_editable_state_unref0 (_vala_state);
	_vala_state = NULL;
	_tmp0_ = photo_get_editable_file (self);
	file = _tmp0_;
	_tmp1_ = file;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (file);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_editable_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp3_ = file;
	_tmp6_ = photo_verify_file_for_reimport (self, _tmp3_, &_tmp4_, &_tmp5_, &_inner_error0_);
	_backing_photo_row_unref0 (backing);
	backing = _tmp4_;
	_detected_photo_information_unref0 (detected);
	detected = _tmp5_;
	_tmp2_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_backing_photo_row_unref0 (backing);
		_detected_photo_information_unref0 (detected);
		_g_object_unref0 (file);
		_photo_reimport_editable_state_unref0 (_vala_state);
		return _tmp7_;
	}
	if (!_tmp2_) {
		result = FALSE;
		_backing_photo_row_unref0 (backing);
		_detected_photo_information_unref0 (detected);
		_g_object_unref0 (file);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_editable_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp8_ = backing;
	_tmp9_ = detected;
	_tmp10_ = _tmp9_->metadata;
	_tmp11_ = photo_reimport_editable_state_impl_new (_tmp8_, _tmp10_);
	_photo_reimport_editable_state_unref0 (_vala_state);
	_vala_state = (PhotoReimportEditableState*) _tmp11_;
	result = TRUE;
	_backing_photo_row_unref0 (backing);
	_detected_photo_information_unref0 (detected);
	_g_object_unref0 (file);
	if (state) {
		*state = _vala_state;
	} else {
		_photo_reimport_editable_state_unref0 (_vala_state);
	}
	return result;
}

static gpointer
_photo_reimport_editable_state_ref0 (gpointer self)
{
	return self ? photo_reimport_editable_state_ref (self) : NULL;
}

void
photo_finish_reimport_editable (Photo* self,
                                PhotoReimportEditableState* state,
                                GError** error)
{
	BackingPhotoID editable_id = {0};
	BackingPhotoID _tmp0_ = {0};
	PhotoReimportEditableStateImpl* reimport_state = NULL;
	PhotoReimportEditableStateImpl* _tmp1_;
	PhotoReimportEditableStateImpl* _tmp2_;
	PhotoReimportEditableStateImpl* _tmp16_;
	PhotoMetadata* _tmp17_;
	gchar* list = NULL;
	gchar* _tmp28_;
	PhotoReimportEditableStateImpl* _tmp29_;
	const gchar* _tmp32_;
	Alteration* _tmp33_;
	Alteration* _tmp34_;
	PhotoReimportEditableStateImpl* _tmp35_;
	PhotoMetadata* _tmp36_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	photo_get_editable_id (self, &_tmp0_);
	editable_id = _tmp0_;
	if (backing_photo_id_is_invalid (&editable_id)) {
		return;
	}
	_tmp1_ = _photo_reimport_editable_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (state, PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl));
	reimport_state = _tmp1_;
	_tmp2_ = reimport_state;
	if (!_tmp2_->metadata_only) {
		BackingPhotoTable* _tmp3_;
		BackingPhotoTable* _tmp4_;
		PhotoReimportEditableStateImpl* _tmp5_;
		BackingPhotoRow* _tmp6_;
		_tmp3_ = backing_photo_table_get_instance ();
		_tmp4_ = _tmp3_;
		_tmp5_ = reimport_state;
		_tmp6_ = _tmp5_->backing_state;
		backing_photo_table_update (_tmp4_, _tmp6_, &_inner_error0_);
		_database_table_unref0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_photo_reimport_editable_state_unref0 (reimport_state);
				return;
			} else {
				_photo_reimport_editable_state_unref0 (reimport_state);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				PhotoReimportEditableStateImpl* _tmp8_;
				BackingPhotoRow* _tmp9_;
				BackingPhotoRow* _tmp10_;
				PhotoReimportEditableStateImpl* _tmp11_;
				BackingPhotoRow* _tmp12_;
				_tmp8_ = reimport_state;
				_tmp9_ = _tmp8_->backing_state;
				_tmp10_ = _backing_photo_row_ref0 (_tmp9_);
				_backing_photo_row_unref0 (self->priv->editable);
				self->priv->editable = _tmp10_;
				_tmp11_ = reimport_state;
				_tmp12_ = _tmp11_->backing_state;
				photo_set_orientation (self, _tmp12_->original_orientation);
				photo_internal_remove_all_transformations (self, FALSE);
			}
			__finally0:
			{
				PhotoRow* _tmp13_;
				_tmp13_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_photo_reimport_editable_state_unref0 (reimport_state);
					return;
				} else {
					_photo_reimport_editable_state_unref0 (reimport_state);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	} else {
		PhotoReimportEditableStateImpl* _tmp14_;
		BackingPhotoRow* _tmp15_;
		_tmp14_ = reimport_state;
		_tmp15_ = _tmp14_->backing_state;
		photo_set_orientation (self, _tmp15_->original_orientation);
	}
	_tmp16_ = reimport_state;
	_tmp17_ = _tmp16_->metadata;
	if (_tmp17_ != NULL) {
		PhotoReimportEditableStateImpl* _tmp18_;
		PhotoMetadata* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		PhotoReimportEditableStateImpl* _tmp22_;
		PhotoMetadata* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		PhotoReimportEditableStateImpl* _tmp26_;
		PhotoMetadata* _tmp27_;
		_tmp18_ = reimport_state;
		_tmp19_ = _tmp18_->metadata;
		_tmp20_ = media_metadata_get_title ((MediaMetadata*) _tmp19_);
		_tmp21_ = _tmp20_;
		media_source_set_title ((MediaSource*) self, _tmp21_);
		_g_free0 (_tmp21_);
		_tmp22_ = reimport_state;
		_tmp23_ = _tmp22_->metadata;
		_tmp24_ = media_metadata_get_comment ((MediaMetadata*) _tmp23_);
		_tmp25_ = _tmp24_;
		media_source_set_comment ((MediaSource*) self, _tmp25_);
		_g_free0 (_tmp25_);
		_tmp26_ = reimport_state;
		_tmp27_ = _tmp26_->metadata;
		photo_apply_user_metadata_for_reimport (self, _tmp27_);
	}
	_tmp28_ = g_strdup ("metadata:name,image:orientation,metadata:exposure-time");
	list = _tmp28_;
	_tmp29_ = reimport_state;
	if (!_tmp29_->metadata_only) {
		const gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp30_ = list;
		_tmp31_ = g_strconcat (_tmp30_, "image:editable,image:baseline", NULL);
		_g_free0 (list);
		list = _tmp31_;
	}
	_tmp32_ = list;
	_tmp33_ = alteration_new_from_list (_tmp32_);
	_tmp34_ = _tmp33_;
	data_object_notify_altered ((DataObject*) self, _tmp34_);
	_alteration_unref0 (_tmp34_);
	_tmp35_ = reimport_state;
	_tmp36_ = _tmp35_->metadata;
	photo_notify_editable_reimported (self, _tmp36_);
	if (photo_is_editable_baseline (self)) {
		PhotoReimportEditableStateImpl* _tmp37_;
		PhotoMetadata* _tmp38_;
		_tmp37_ = reimport_state;
		_tmp38_ = _tmp37_->metadata;
		photo_notify_baseline_reimported (self, _tmp38_);
	}
	if (photo_is_editable_source (self)) {
		PhotoReimportEditableStateImpl* _tmp39_;
		PhotoMetadata* _tmp40_;
		_tmp39_ = reimport_state;
		_tmp40_ = _tmp39_->metadata;
		photo_notify_source_reimported (self, _tmp40_);
	}
	_g_free0 (list);
	_photo_reimport_editable_state_unref0 (reimport_state);
}

static gpointer
_photo_reimport_raw_development_state_ref0 (gpointer self)
{
	return self ? photo_reimport_raw_development_state_ref (self) : NULL;
}

gboolean
photo_prepare_for_reimport_raw_development (Photo* self,
                                            PhotoReimportRawDevelopmentState** state,
                                            GError** error)
{
	PhotoReimportRawDevelopmentState* _vala_state = NULL;
	GeeCollection* files = NULL;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	PhotoReimportRawDevelopmentStateImpl* reimport_state = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp2_;
	PhotoReimportRawDevelopmentStateImpl* _tmp18_;
	PhotoReimportRawDevelopmentState* _tmp19_;
	PhotoReimportRawDevelopmentStateImpl* _tmp20_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_photo_reimport_raw_development_state_unref0 (_vala_state);
	_vala_state = NULL;
	_tmp0_ = photo_get_raw_developer_files (self);
	files = _tmp0_;
	_tmp1_ = files;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (files);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_raw_development_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp2_ = photo_reimport_raw_development_state_impl_new ();
	reimport_state = _tmp2_;
	{
		GeeIterator* _file_it = NULL;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp3_ = files;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_file_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			GFile* file = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			DetectedPhotoInformation* detected = NULL;
			BackingPhotoRow* backing = NULL;
			gboolean _tmp8_ = FALSE;
			GFile* _tmp9_;
			BackingPhotoRow* _tmp10_ = NULL;
			DetectedPhotoInformation* _tmp11_ = NULL;
			gboolean _tmp12_;
			PhotoReimportRawDevelopmentStateImpl* _tmp14_;
			BackingPhotoRow* _tmp15_;
			DetectedPhotoInformation* _tmp16_;
			PhotoMetadata* _tmp17_;
			_tmp5_ = _file_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _file_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			file = (GFile*) _tmp7_;
			_tmp9_ = file;
			_tmp12_ = photo_verify_file_for_reimport (self, _tmp9_, &_tmp10_, &_tmp11_, &_inner_error0_);
			_backing_photo_row_unref0 (backing);
			backing = _tmp10_;
			_detected_photo_information_unref0 (detected);
			detected = _tmp11_;
			_tmp8_ = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp13_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_backing_photo_row_unref0 (backing);
				_detected_photo_information_unref0 (detected);
				_g_object_unref0 (file);
				_g_object_unref0 (_file_it);
				_photo_reimport_raw_development_state_unref0 (reimport_state);
				_g_object_unref0 (files);
				_photo_reimport_raw_development_state_unref0 (_vala_state);
				return _tmp13_;
			}
			if (!_tmp8_) {
				_backing_photo_row_unref0 (backing);
				_detected_photo_information_unref0 (detected);
				_g_object_unref0 (file);
				continue;
			}
			_tmp14_ = reimport_state;
			_tmp15_ = backing;
			_tmp16_ = detected;
			_tmp17_ = _tmp16_->metadata;
			photo_reimport_raw_development_state_impl_add (_tmp14_, _tmp15_, _tmp17_);
			_backing_photo_row_unref0 (backing);
			_detected_photo_information_unref0 (detected);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_it);
	}
	_tmp18_ = reimport_state;
	_tmp19_ = _photo_reimport_raw_development_state_ref0 ((PhotoReimportRawDevelopmentState*) _tmp18_);
	_photo_reimport_raw_development_state_unref0 (_vala_state);
	_vala_state = _tmp19_;
	_tmp20_ = reimport_state;
	result = photo_reimport_raw_development_state_impl_get_size (_tmp20_) > 0;
	_photo_reimport_raw_development_state_unref0 (reimport_state);
	_g_object_unref0 (files);
	if (state) {
		*state = _vala_state;
	} else {
		_photo_reimport_raw_development_state_unref0 (_vala_state);
	}
	return result;
}

void
photo_finish_reimport_raw_development (Photo* self,
                                       PhotoReimportRawDevelopmentState* state,
                                       GError** error)
{
	PhotoReimportRawDevelopmentStateImpl* reimport_state = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp0_;
	gchar* list = NULL;
	gchar* _tmp25_;
	PhotoReimportRawDevelopmentStateImpl* _tmp26_;
	const gchar* _tmp29_;
	Alteration* _tmp30_;
	Alteration* _tmp31_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	if (photo_get_master_file_format (self) != PHOTO_FILE_FORMAT_RAW) {
		return;
	}
	_tmp0_ = _photo_reimport_raw_development_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (state, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImpl));
	reimport_state = _tmp0_;
	{
		GeeIterator* _dev_it = NULL;
		PhotoReimportRawDevelopmentStateImpl* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp1_ = reimport_state;
		_tmp2_ = _tmp1_->list;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_dev_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			PhotoReimportRawDevelopmentStateImplDevToReimport* dev = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			PhotoReimportRawDevelopmentStateImpl* _tmp7_;
			_tmp4_ = _dev_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _dev_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			dev = (PhotoReimportRawDevelopmentStateImplDevToReimport*) _tmp6_;
			_tmp7_ = reimport_state;
			if (!_tmp7_->metadata_only) {
				BackingPhotoTable* _tmp8_;
				BackingPhotoTable* _tmp9_;
				PhotoReimportRawDevelopmentStateImplDevToReimport* _tmp10_;
				BackingPhotoRow* _tmp11_;
				_tmp8_ = backing_photo_table_get_instance ();
				_tmp9_ = _tmp8_;
				_tmp10_ = dev;
				_tmp11_ = _tmp10_->backing;
				backing_photo_table_update (_tmp9_, _tmp11_, &_inner_error0_);
				_database_table_unref0 (_tmp9_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
						_g_object_unref0 (_dev_it);
						_photo_reimport_raw_development_state_unref0 (reimport_state);
						return;
					} else {
						_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
						_g_object_unref0 (_dev_it);
						_photo_reimport_raw_development_state_unref0 (reimport_state);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				{
					PhotoRow* _tmp12_;
					_tmp12_ = self->row;
					g_rec_mutex_lock (&self->priv->__lock_row);
					{
						gint _tmp13_ = 0;
						RawDeveloper* _tmp14_;
						_tmp14_ = raw_developer_as_array (&_tmp13_);
						{
							RawDeveloper* d_collection = NULL;
							gint d_collection_length1 = 0;
							gint _d_collection_size_ = 0;
							gint d_it = 0;
							d_collection = _tmp14_;
							d_collection_length1 = _tmp13_;
							for (d_it = 0; d_it < d_collection_length1; d_it = d_it + 1) {
								RawDeveloper d = 0;
								d = d_collection[d_it];
								{
									BackingPhotoID id = {0};
									PhotoRow* _tmp15_;
									BackingPhotoID* _tmp16_;
									gint _tmp16__length1;
									BackingPhotoID _tmp17_;
									BackingPhotoID _tmp18_;
									_tmp15_ = self->row;
									_tmp16_ = _tmp15_->development_ids;
									_tmp16__length1 = _tmp15_->development_ids_length1;
									_tmp17_ = _tmp16_[d];
									id = _tmp17_;
									_tmp18_ = id;
									if (_tmp18_.id != BACKING_PHOTO_ID_INVALID) {
										BackingPhotoRow* bpr = NULL;
										BackingPhotoID _tmp19_;
										BackingPhotoRow* _tmp20_;
										BackingPhotoRow* _tmp21_;
										_tmp19_ = id;
										_tmp20_ = photo_get_backing_row (self, &_tmp19_);
										bpr = _tmp20_;
										_tmp21_ = bpr;
										if (_tmp21_ != NULL) {
											GeeHashMap* _tmp22_;
											BackingPhotoRow* _tmp23_;
											_tmp22_ = self->priv->developments;
											_tmp23_ = bpr;
											gee_abstract_map_set ((GeeAbstractMap*) _tmp22_, (gpointer) ((gintptr) d), _tmp23_);
										}
										_backing_photo_row_unref0 (bpr);
									}
								}
							}
							d_collection = (g_free (d_collection), NULL);
						}
					}
					__finally0:
					{
						PhotoRow* _tmp24_;
						_tmp24_ = self->row;
						g_rec_mutex_unlock (&self->priv->__lock_row);
					}
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
							_g_object_unref0 (_dev_it);
							_photo_reimport_raw_development_state_unref0 (reimport_state);
							return;
						} else {
							_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
							_g_object_unref0 (_dev_it);
							_photo_reimport_raw_development_state_unref0 (reimport_state);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
			}
			_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
		}
		_g_object_unref0 (_dev_it);
	}
	_tmp25_ = g_strdup ("metadata:name,image:orientation,metadata:exposure-time");
	list = _tmp25_;
	_tmp26_ = reimport_state;
	if (!_tmp26_->metadata_only) {
		const gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp27_ = list;
		_tmp28_ = g_strconcat (_tmp27_, "image:editable,image:baseline", NULL);
		_g_free0 (list);
		list = _tmp28_;
	}
	_tmp29_ = list;
	_tmp30_ = alteration_new_from_list (_tmp29_);
	_tmp31_ = _tmp30_;
	data_object_notify_altered ((DataObject*) self, _tmp31_);
	_alteration_unref0 (_tmp31_);
	photo_notify_raw_development_modified (self);
	_g_free0 (list);
	_photo_reimport_raw_development_state_unref0 (reimport_state);
}

static gchar*
photo_real_get_typename (DataSource* base)
{
	Photo * self;
	gchar* _tmp0_;
	gchar* result;
	self = (Photo*) base;
	_tmp0_ = g_strdup (PHOTO_TYPENAME);
	result = _tmp0_;
	return result;
}

static gint64
photo_real_get_instance_id (DataSource* base)
{
	Photo * self;
	PhotoID _tmp0_ = {0};
	gint64 result;
	self = (Photo*) base;
	photo_get_photo_id (self, &_tmp0_);
	result = _tmp0_.id;
	return result;
}

static gchar*
photo_real_get_source_id (DataSource* base)
{
	Photo * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = (Photo*) base;
	_tmp0_ = data_source_get_typename ((DataSource*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s%016" G_GINT64_MODIFIER "x", _tmp1_, data_source_get_instance_id ((DataSource*) self));
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

void
photo_set_master_timestamp (Photo* self,
                            GFileInfo* info)
{
	gint64 mod_time = 0LL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint64 _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = g_file_info_get_modification_date_time (info);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_to_unix (_tmp1_);
	_g_date_time_unref0 (_tmp1_);
	mod_time = _tmp2_;
	{
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				PhotoRow* _tmp4_;
				BackingPhotoRow* _tmp5_;
				PhotoTable* _tmp7_;
				PhotoTable* _tmp8_;
				PhotoRow* _tmp9_;
				PhotoID _tmp10_;
				PhotoRow* _tmp11_;
				BackingPhotoRow* _tmp12_;
				_tmp4_ = self->row;
				_tmp5_ = _tmp4_->master;
				if (_tmp5_->timestamp == mod_time) {
					{
						GError* _inner_error0_ = NULL;
						PhotoRow* _tmp6_;
						_tmp6_ = self->row;
						g_rec_mutex_unlock (&self->priv->__lock_row);
					}
					return;
				}
				_tmp7_ = photo_table_get_instance ();
				_tmp8_ = _tmp7_;
				_tmp9_ = self->row;
				_tmp10_ = _tmp9_->photo_id;
				photo_table_update_timestamp (_tmp8_, &_tmp10_, mod_time, &_inner_error0_);
				_database_table_unref0 (_tmp8_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp11_ = self->row;
				_tmp12_ = _tmp11_->master;
				_tmp12_->timestamp = mod_time;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _lock_error_ = NULL;
				GError* _tmp13_;
				_lock_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp13_ = _lock_error_;
				_lock_error_ = NULL;
				_inner_error0_ = _tmp13_;
				_g_error_free0 (_lock_error_);
				goto __finally1;
			}
			__finally1:
			{
				GError* _inner_error1_ = NULL;
				PhotoRow* _tmp14_;
				_tmp14_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch0_database_error;
				}
				goto __finally0;
			}
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp15_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = err;
		app_window_database_error (_tmp15_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (photo_is_master_baseline (self)) {
		Alteration* _tmp16_;
		Alteration* _tmp17_;
		_tmp16_ = alteration_new_from_list ("metadata:master-timestamp,metadata:baseline-timestamp");
		_tmp17_ = _tmp16_;
		data_object_notify_altered ((DataObject*) self, _tmp17_);
		_alteration_unref0 (_tmp17_);
	} else {
		Alteration* _tmp18_;
		Alteration* _tmp19_;
		_tmp18_ = alteration_new ("metadata", "master-timestamp");
		_tmp19_ = _tmp18_;
		data_object_notify_altered ((DataObject*) self, _tmp19_);
		_alteration_unref0 (_tmp19_);
	}
}

void
photo_update_editable_modification_time (Photo* self,
                                         GFileInfo* info,
                                         GError** error)
{
	gint64 mod_time = 0LL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint64 _tmp2_;
	gboolean altered = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = g_file_info_get_modification_date_time (info);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_to_unix (_tmp1_);
	_g_date_time_unref0 (_tmp1_);
	mod_time = _tmp2_;
	altered = FALSE;
	{
		PhotoRow* _tmp3_;
		_tmp3_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			gboolean _tmp4_ = FALSE;
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			if (backing_photo_id_is_valid (&_tmp5_->editable_id)) {
				BackingPhotoRow* _tmp6_;
				_tmp6_ = self->priv->editable;
				_tmp4_ = _tmp6_->timestamp != mod_time;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				BackingPhotoTable* _tmp7_;
				BackingPhotoTable* _tmp8_;
				PhotoRow* _tmp9_;
				BackingPhotoID _tmp10_;
				BackingPhotoRow* _tmp11_;
				_tmp7_ = backing_photo_table_get_instance ();
				_tmp8_ = _tmp7_;
				_tmp9_ = self->row;
				_tmp10_ = _tmp9_->editable_id;
				backing_photo_table_update_timestamp (_tmp8_, &_tmp10_, mod_time, &_inner_error0_);
				_database_table_unref0 (_tmp8_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp11_ = self->priv->editable;
				_tmp11_->timestamp = mod_time;
				altered = TRUE;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _lock_error_ = NULL;
			GError* _tmp12_;
			_lock_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp12_ = _lock_error_;
			_lock_error_ = NULL;
			_inner_error0_ = _tmp12_;
			_g_error_free0 (_lock_error_);
			goto __finally0;
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			PhotoRow* _tmp13_;
			_tmp13_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	if (altered) {
		Alteration* _tmp14_;
		Alteration* _tmp15_;
		_tmp14_ = alteration_new_from_list ("metadata:editable-timestamp,metadata:baseline-timestamp");
		_tmp15_ = _tmp14_;
		data_object_notify_altered ((DataObject*) self, _tmp15_);
		_alteration_unref0 (_tmp15_);
	}
}

void
photo_update_many_editable_timestamps (GeeMap* map,
                                       GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (map != NULL);
	database_table_begin_transaction ();
	{
		GeeIterator* _photo_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (map);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_photo_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			Photo* photo = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Photo* _tmp8_;
			Photo* _tmp9_;
			gpointer _tmp10_;
			GFileInfo* _tmp11_;
			_tmp5_ = _photo_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _photo_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			photo = (Photo*) _tmp7_;
			_tmp8_ = photo;
			_tmp9_ = photo;
			_tmp10_ = gee_map_get (map, _tmp9_);
			_tmp11_ = (GFileInfo*) _tmp10_;
			photo_update_editable_modification_time (_tmp8_, _tmp11_, &_inner_error0_);
			_g_object_unref0 (_tmp11_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (photo);
					_g_object_unref0 (_photo_it);
					return;
				} else {
					_g_object_unref0 (photo);
					_g_object_unref0 (_photo_it);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_g_object_unref0 (photo);
		}
		_g_object_unref0 (_photo_it);
	}
	database_table_commit_transaction (&_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static PhotoFileFormat
photo_real_get_preferred_thumbnail_format (ThumbnailSource* base)
{
	Photo * self;
	PhotoFileFormat _tmp0_ = 0;
	PhotoFileFormat result;
	self = (Photo*) base;
	if (photo_file_format_can_write_image (photo_get_file_format (self))) {
		_tmp0_ = photo_get_file_format (self);
	} else {
		_tmp0_ = photo_file_format_get_system_default_format ();
	}
	result = _tmp0_;
	return result;
}

static GdkPixbuf*
photo_real_create_thumbnail (ThumbnailSource* base,
                             gint scale,
                             GError** error)
{
	Photo * self;
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_ = {0};
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (Photo*) base;
	scaling_for_best_fit (scale, TRUE, &_tmp1_);
	_tmp2_ = photo_source_get_pixbuf ((PhotoSource*) self, &_tmp1_, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return result;
}

gboolean
photo_is_file_image (GFile* file)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	if (photo_file_format_is_file_supported (file)) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_file_get_basename (file);
		_tmp2_ = _tmp1_;
		_tmp0_ = photo_is_extension_found (_tmp2_, PHOTO_IMAGE_EXTENSIONS, (gint) G_N_ELEMENTS (PHOTO_IMAGE_EXTENSIONS));
		_g_free0 (_tmp2_);
	}
	result = _tmp0_;
	return result;
}

gboolean
photo_can_write_file (Photo* self)
{
	GFile* file = NULL;
	PhotoRow* _tmp0_;
	BackingPhotoRow* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFileInfo* file_info = NULL;
	GFileInfo* _tmp11_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->row;
	_tmp1_ = _tmp0_->master;
	_tmp2_ = _tmp1_->filepath;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	file = _tmp3_;
	{
		GFileInfo* _tmp4_ = NULL;
		GFile* _tmp5_;
		GFileInfo* _tmp6_;
		GFileInfo* _tmp7_;
		_tmp5_ = file;
		_tmp6_ = g_file_query_info (_tmp5_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (file_info);
		file_info = _tmp7_;
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("Photo.vala:1703: Error while testing if file is writeable: %s\n", _tmp9_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	_tmp11_ = file_info;
	result = g_file_info_get_attribute_boolean (_tmp11_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
	_g_object_unref0 (file_info);
	_g_object_unref0 (file);
	return result;
}

static gboolean
photo_is_extension_found (const gchar* basename,
                          gchar** extensions,
                          gint extensions_length1)
{
	gchar* name = NULL;
	gchar* ext = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (basename != NULL, FALSE);
	disassemble_filename (basename, &_tmp0_, &_tmp1_);
	_g_free0 (name);
	name = _tmp0_;
	_g_free0 (ext);
	ext = _tmp1_;
	_tmp2_ = ext;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_free0 (ext);
		_g_free0 (name);
		return result;
	}
	_tmp3_ = ext;
	_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
	_g_free0 (ext);
	ext = _tmp4_;
	{
		gchar** extension_collection = NULL;
		gint extension_collection_length1 = 0;
		gint _extension_collection_size_ = 0;
		gint extension_it = 0;
		extension_collection = extensions;
		extension_collection_length1 = extensions_length1;
		for (extension_it = 0; extension_it < extension_collection_length1; extension_it = extension_it + 1) {
			gchar* _tmp5_;
			gchar* extension = NULL;
			_tmp5_ = g_strdup (extension_collection[extension_it]);
			extension = _tmp5_;
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = ext;
				_tmp7_ = extension;
				if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
					result = TRUE;
					_g_free0 (extension);
					_g_free0 (ext);
					_g_free0 (name);
					return result;
				}
				_g_free0 (extension);
			}
		}
	}
	result = FALSE;
	_g_free0 (ext);
	_g_free0 (name);
	return result;
}

gboolean
photo_is_duplicate (GFile* file,
                    const gchar* thumbnail_md5,
                    const gchar* full_md5,
                    PhotoFileFormat file_format)
{
	PhotoTable* _tmp0_;
	PhotoTable* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	_tmp0_ = photo_table_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_table_has_duplicate (_tmp1_, file, thumbnail_md5, full_md5, file_format);
	_database_table_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

PhotoID*
photo_get_duplicate_ids (GFile* file,
                         const gchar* thumbnail_md5,
                         const gchar* full_md5,
                         PhotoFileFormat file_format,
                         gint* result_length1)
{
	PhotoTable* _tmp0_;
	PhotoTable* _tmp1_;
	gint _tmp2_ = 0;
	PhotoID* _tmp3_;
	PhotoID* _tmp4_;
	gint _tmp4__length1;
	PhotoID* _tmp5_;
	gint _tmp5__length1;
	PhotoID* result;
	_tmp0_ = photo_table_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp3_ = photo_table_get_duplicate_ids (_tmp1_, file, thumbnail_md5, full_md5, file_format, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_database_table_unref0 (_tmp1_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

gint64
photo_get_photo_key (DataSource* source)
{
	PhotoID _tmp0_ = {0};
	gint64 result;
	g_return_val_if_fail (source != NULL, 0LL);
	photo_get_photo_id ((Photo*) G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto), &_tmp0_);
	result = _tmp0_.id;
	return result;
}

static GFile*
photo_real_get_file (MediaSource* base)
{
	Photo * self;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	self = (Photo*) base;
	_tmp0_ = photo_get_source_reader (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp1_);
	_tmp3_ = _tmp2_;
	_photo_file_adapter_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
_vala_array_add17 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add18 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add19 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add20 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
photo_set_master_file (Photo* self,
                       GFile* file)
{
	gchar* filepath = NULL;
	gchar* _tmp0_;
	gboolean altered = FALSE;
	gboolean is_baseline = FALSE;
	gboolean is_source = FALSE;
	gboolean name_changed = FALSE;
	GFile* old_file = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_path (file);
	filepath = _tmp0_;
	altered = FALSE;
	is_baseline = FALSE;
	is_source = FALSE;
	name_changed = FALSE;
	old_file = NULL;
	{
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				{
					PhotoBackingReaders* _tmp2_;
					_tmp2_ = self->priv->readers;
					g_rec_mutex_lock (&self->priv->__lock_readers);
					{
						PhotoBackingReaders* _tmp3_;
						PhotoFileReader* _tmp4_;
						GFile* _tmp5_;
						GFile* _tmp6_;
						_tmp3_ = self->priv->readers;
						_tmp4_ = _tmp3_->master;
						_tmp5_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp4_);
						_g_object_unref0 (old_file);
						old_file = _tmp5_;
						_tmp6_ = old_file;
						if (!g_file_equal (file, _tmp6_)) {
							PhotoTable* _tmp7_;
							PhotoTable* _tmp8_;
							PhotoID _tmp9_ = {0};
							const gchar* _tmp10_;
							PhotoRow* _tmp11_;
							BackingPhotoRow* _tmp12_;
							const gchar* _tmp13_;
							gchar* _tmp14_;
							gchar* _tmp15_;
							PhotoBackingReaders* _tmp16_;
							PhotoRow* _tmp17_;
							BackingPhotoRow* _tmp18_;
							const gchar* _tmp19_;
							PhotoFileReader* _tmp20_;
							gboolean _tmp21_ = FALSE;
							PhotoRow* _tmp22_;
							const gchar* _tmp23_;
							_tmp7_ = photo_table_get_instance ();
							_tmp8_ = _tmp7_;
							photo_get_photo_id (self, &_tmp9_);
							_tmp10_ = filepath;
							photo_table_set_filepath (_tmp8_, &_tmp9_, _tmp10_, &_inner_error0_);
							_database_table_unref0 (_tmp8_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch2_g_error;
							}
							_tmp11_ = self->row;
							_tmp12_ = _tmp11_->master;
							_tmp13_ = filepath;
							_tmp14_ = g_strdup (_tmp13_);
							_g_free0 (_tmp12_->filepath);
							_tmp12_->filepath = _tmp14_;
							_tmp15_ = g_file_get_basename (file);
							_g_free0 (self->priv->file_title);
							self->priv->file_title = _tmp15_;
							_tmp16_ = self->priv->readers;
							_tmp17_ = self->row;
							_tmp18_ = _tmp17_->master;
							_tmp19_ = filepath;
							_tmp20_ = photo_file_format_create_reader (_tmp18_->file_format, _tmp19_);
							_photo_file_adapter_unref0 (_tmp16_->master);
							_tmp16_->master = _tmp20_;
							altered = TRUE;
							is_baseline = photo_is_master_baseline (self);
							is_source = photo_is_master_source (self);
							_tmp22_ = self->row;
							_tmp23_ = _tmp22_->title;
							if (is_string_empty (_tmp23_)) {
								GFile* _tmp24_;
								gchar* _tmp25_;
								gchar* _tmp26_;
								gchar* _tmp27_;
								gchar* _tmp28_;
								_tmp24_ = old_file;
								_tmp25_ = g_file_get_basename (_tmp24_);
								_tmp26_ = _tmp25_;
								_tmp27_ = g_file_get_basename (file);
								_tmp28_ = _tmp27_;
								_tmp21_ = g_strcmp0 (_tmp26_, _tmp28_) != 0;
								_g_free0 (_tmp28_);
								_g_free0 (_tmp26_);
							} else {
								_tmp21_ = FALSE;
							}
							name_changed = _tmp21_;
						}
					}
					goto __finally2;
					__catch2_g_error:
					{
						GError* _lock_error_ = NULL;
						GError* _tmp29_;
						_lock_error_ = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp29_ = _lock_error_;
						_lock_error_ = NULL;
						_inner_error0_ = _tmp29_;
						_g_error_free0 (_lock_error_);
						goto __finally2;
					}
					__finally2:
					{
						GError* _inner_error1_ = NULL;
						PhotoBackingReaders* _tmp30_;
						_tmp30_ = self->priv->readers;
						g_rec_mutex_unlock (&self->priv->__lock_readers);
					}
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _lock_error_ = NULL;
				GError* _tmp31_;
				_lock_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp31_ = _lock_error_;
				_lock_error_ = NULL;
				_inner_error0_ = _tmp31_;
				_g_error_free0 (_lock_error_);
				goto __finally1;
			}
			__finally1:
			{
				GError* _inner_error1_ = NULL;
				PhotoRow* _tmp32_;
				_tmp32_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch0_database_error;
				}
				goto __finally0;
			}
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp33_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp33_ = err;
		app_window_database_error (_tmp33_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (old_file);
		_g_free0 (filepath);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (altered) {
		GFile* _tmp34_;
		gchar** alteration_list = NULL;
		gchar** _tmp35_;
		gint alteration_list_length1;
		gint _alteration_list_size_;
		gchar* _tmp36_;
		gchar** _tmp40_;
		gint _tmp40__length1;
		Alteration* _tmp41_;
		Alteration* _tmp42_;
		_tmp34_ = old_file;
		media_source_notify_master_replaced ((MediaSource*) self, _tmp34_, file);
		if (is_baseline) {
			photo_notify_baseline_replaced (self);
		}
		_tmp35_ = g_new0 (gchar*, 0 + 1);
		alteration_list = _tmp35_;
		alteration_list_length1 = 0;
		_alteration_list_size_ = alteration_list_length1;
		_tmp36_ = g_strdup ("backing:master");
		_vala_array_add17 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp36_);
		if (name_changed) {
			gchar* _tmp37_;
			_tmp37_ = g_strdup ("metadata:name");
			_vala_array_add18 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp37_);
		}
		if (is_source) {
			gchar* _tmp38_;
			_tmp38_ = g_strdup ("backing:source");
			_vala_array_add19 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp38_);
		}
		if (is_baseline) {
			gchar* _tmp39_;
			_tmp39_ = g_strdup ("backing:baseline");
			_vala_array_add20 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp39_);
		}
		_tmp40_ = alteration_list;
		_tmp40__length1 = alteration_list_length1;
		_tmp41_ = alteration_new_from_array (_tmp40_, _tmp40__length1);
		_tmp42_ = _tmp41_;
		data_object_notify_altered ((DataObject*) self, _tmp42_);
		_alteration_unref0 (_tmp42_);
		alteration_list = (_vala_array_free (alteration_list, alteration_list_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_object_unref0 (old_file);
	_g_free0 (filepath);
}

static void
_vala_array_add21 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add22 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add23 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
photo_set_editable_file (Photo* self,
                         GFile* file)
{
	gchar* filepath = NULL;
	gchar* _tmp0_;
	gboolean altered = FALSE;
	gboolean is_baseline = FALSE;
	gboolean is_source = FALSE;
	GFile* old_file = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_path (file);
	filepath = _tmp0_;
	altered = FALSE;
	is_baseline = FALSE;
	is_source = FALSE;
	old_file = NULL;
	{
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				{
					PhotoBackingReaders* _tmp2_;
					_tmp2_ = self->priv->readers;
					g_rec_mutex_lock (&self->priv->__lock_readers);
					{
						GFile* _tmp3_ = NULL;
						PhotoBackingReaders* _tmp4_;
						PhotoFileReader* _tmp5_;
						GFile* _tmp9_;
						gboolean _tmp10_ = FALSE;
						GFile* _tmp11_;
						_tmp4_ = self->priv->readers;
						_tmp5_ = _tmp4_->editable;
						if (_tmp5_ != NULL) {
							PhotoBackingReaders* _tmp6_;
							PhotoFileReader* _tmp7_;
							GFile* _tmp8_;
							_tmp6_ = self->priv->readers;
							_tmp7_ = _tmp6_->editable;
							_tmp8_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp7_);
							_g_object_unref0 (_tmp3_);
							_tmp3_ = _tmp8_;
						} else {
							_g_object_unref0 (_tmp3_);
							_tmp3_ = NULL;
						}
						_tmp9_ = _g_object_ref0 (_tmp3_);
						_g_object_unref0 (old_file);
						old_file = _tmp9_;
						_tmp11_ = old_file;
						if (_tmp11_ != NULL) {
							GFile* _tmp12_;
							_tmp12_ = old_file;
							_tmp10_ = !g_file_equal (_tmp12_, file);
						} else {
							_tmp10_ = FALSE;
						}
						if (_tmp10_) {
							BackingPhotoTable* _tmp13_;
							BackingPhotoTable* _tmp14_;
							PhotoRow* _tmp15_;
							BackingPhotoID _tmp16_;
							const gchar* _tmp17_;
							BackingPhotoRow* _tmp18_;
							const gchar* _tmp19_;
							gchar* _tmp20_;
							PhotoBackingReaders* _tmp21_;
							BackingPhotoRow* _tmp22_;
							const gchar* _tmp23_;
							PhotoFileReader* _tmp24_;
							_tmp13_ = backing_photo_table_get_instance ();
							_tmp14_ = _tmp13_;
							_tmp15_ = self->row;
							_tmp16_ = _tmp15_->editable_id;
							_tmp17_ = filepath;
							backing_photo_table_set_filepath (_tmp14_, &_tmp16_, _tmp17_, &_inner_error0_);
							_database_table_unref0 (_tmp14_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (_tmp3_);
								goto __catch2_g_error;
							}
							_tmp18_ = self->priv->editable;
							_tmp19_ = filepath;
							_tmp20_ = g_strdup (_tmp19_);
							_g_free0 (_tmp18_->filepath);
							_tmp18_->filepath = _tmp20_;
							_tmp21_ = self->priv->readers;
							_tmp22_ = self->priv->editable;
							_tmp23_ = filepath;
							_tmp24_ = photo_file_format_create_reader (_tmp22_->file_format, _tmp23_);
							_photo_file_adapter_unref0 (_tmp21_->editable);
							_tmp21_->editable = _tmp24_;
							altered = TRUE;
							is_baseline = photo_is_editable_baseline (self);
							is_source = photo_is_editable_source (self);
						}
						_g_object_unref0 (_tmp3_);
					}
					goto __finally2;
					__catch2_g_error:
					{
						GError* _lock_error_ = NULL;
						GError* _tmp25_;
						_lock_error_ = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp25_ = _lock_error_;
						_lock_error_ = NULL;
						_inner_error0_ = _tmp25_;
						_g_error_free0 (_lock_error_);
						goto __finally2;
					}
					__finally2:
					{
						GError* _inner_error1_ = NULL;
						PhotoBackingReaders* _tmp26_;
						_tmp26_ = self->priv->readers;
						g_rec_mutex_unlock (&self->priv->__lock_readers);
					}
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _lock_error_ = NULL;
				GError* _tmp27_;
				_lock_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp27_ = _lock_error_;
				_lock_error_ = NULL;
				_inner_error0_ = _tmp27_;
				_g_error_free0 (_lock_error_);
				goto __finally1;
			}
			__finally1:
			{
				GError* _inner_error1_ = NULL;
				PhotoRow* _tmp28_;
				_tmp28_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch0_database_error;
				}
				goto __finally0;
			}
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp29_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = err;
		app_window_database_error (_tmp29_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (old_file);
		_g_free0 (filepath);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (altered) {
		GFile* _tmp30_;
		gchar** alteration_list = NULL;
		gchar** _tmp31_;
		gint alteration_list_length1;
		gint _alteration_list_size_;
		gchar* _tmp32_;
		gchar** _tmp35_;
		gint _tmp35__length1;
		Alteration* _tmp36_;
		Alteration* _tmp37_;
		_tmp30_ = old_file;
		photo_notify_editable_replaced (self, _tmp30_, file);
		if (is_baseline) {
			photo_notify_baseline_replaced (self);
		}
		_tmp31_ = g_new0 (gchar*, 0 + 1);
		alteration_list = _tmp31_;
		alteration_list_length1 = 0;
		_alteration_list_size_ = alteration_list_length1;
		_tmp32_ = g_strdup ("backing:editable");
		_vala_array_add21 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp32_);
		if (is_baseline) {
			gchar* _tmp33_;
			_tmp33_ = g_strdup ("backing:baseline");
			_vala_array_add22 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp33_);
		}
		if (is_source) {
			gchar* _tmp34_;
			_tmp34_ = g_strdup ("backing:source");
			_vala_array_add23 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp34_);
		}
		_tmp35_ = alteration_list;
		_tmp35__length1 = alteration_list_length1;
		_tmp36_ = alteration_new_from_array (_tmp35_, _tmp35__length1);
		_tmp37_ = _tmp36_;
		data_object_notify_altered ((DataObject*) self, _tmp37_);
		_alteration_unref0 (_tmp37_);
		alteration_list = (_vala_array_free (alteration_list, alteration_list_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_object_unref0 (old_file);
	_g_free0 (filepath);
}

void
photo_set_many_editable_file (GeeMap* map,
                              GError** error)
{
	GeeMapIterator* map_iter = NULL;
	GeeMapIterator* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (map != NULL);
	database_table_begin_transaction ();
	_tmp0_ = gee_map_map_iterator (map);
	map_iter = _tmp0_;
	while (TRUE) {
		GeeMapIterator* _tmp1_;
		GeeMapIterator* _tmp2_;
		gpointer _tmp3_;
		Photo* _tmp4_;
		GeeMapIterator* _tmp5_;
		gpointer _tmp6_;
		GFile* _tmp7_;
		_tmp1_ = map_iter;
		if (!gee_map_iterator_next (_tmp1_)) {
			break;
		}
		_tmp2_ = map_iter;
		_tmp3_ = gee_map_iterator_get_key (_tmp2_);
		_tmp4_ = (Photo*) _tmp3_;
		_tmp5_ = map_iter;
		_tmp6_ = gee_map_iterator_get_value (_tmp5_);
		_tmp7_ = (GFile*) _tmp6_;
		photo_set_editable_file (_tmp4_, _tmp7_);
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp4_);
	}
	database_table_commit_transaction (&_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (map_iter);
			return;
		} else {
			_g_object_unref0 (map_iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (map_iter);
}

GFile*
photo_get_actual_file (Photo* self)
{
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = photo_get_baseline_reader (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp1_);
	_tmp3_ = _tmp2_;
	_photo_file_adapter_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GFile*
photo_real_get_master_file (MediaSource* base)
{
	Photo * self;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	self = (Photo*) base;
	_tmp0_ = photo_get_master_reader (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp1_);
	_tmp3_ = _tmp2_;
	_photo_file_adapter_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

GFile*
photo_get_editable_file (Photo* self)
{
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_;
	GFile* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = photo_get_editable_reader (self);
	reader = _tmp0_;
	_tmp2_ = reader;
	if (_tmp2_ != NULL) {
		PhotoFileReader* _tmp3_;
		GFile* _tmp4_;
		_tmp3_ = reader;
		_tmp4_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp3_);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp4_;
	} else {
		_g_object_unref0 (_tmp1_);
		_tmp1_ = NULL;
	}
	result = _tmp1_;
	_photo_file_adapter_unref0 (reader);
	return result;
}

GeeCollection*
photo_get_raw_developer_files (Photo* self)
{
	GeeArrayList* ret = NULL;
	GeeArrayList* _tmp0_;
	GError* _inner_error0_ = NULL;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (photo_get_master_file_format (self) != PHOTO_FILE_FORMAT_RAW) {
		result = NULL;
		return result;
	}
	_tmp0_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		PhotoRow* _tmp1_;
		_tmp1_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			{
				GeeIterator* _row_it = NULL;
				GeeHashMap* _tmp2_;
				GeeCollection* _tmp3_;
				GeeCollection* _tmp4_;
				GeeCollection* _tmp5_;
				GeeIterator* _tmp6_;
				GeeIterator* _tmp7_;
				_tmp2_ = self->priv->developments;
				_tmp3_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _tmp4_;
				_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
				_tmp7_ = _tmp6_;
				_g_object_unref0 (_tmp5_);
				_row_it = _tmp7_;
				while (TRUE) {
					GeeIterator* _tmp8_;
					BackingPhotoRow* row = NULL;
					GeeIterator* _tmp9_;
					gpointer _tmp10_;
					GeeArrayList* _tmp11_;
					BackingPhotoRow* _tmp12_;
					const gchar* _tmp13_;
					GFile* _tmp14_;
					GFile* _tmp15_;
					_tmp8_ = _row_it;
					if (!gee_iterator_next (_tmp8_)) {
						break;
					}
					_tmp9_ = _row_it;
					_tmp10_ = gee_iterator_get (_tmp9_);
					row = (BackingPhotoRow*) _tmp10_;
					_tmp11_ = ret;
					_tmp12_ = row;
					_tmp13_ = _tmp12_->filepath;
					_tmp14_ = g_file_new_for_path (_tmp13_);
					_tmp15_ = _tmp14_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp15_);
					_g_object_unref0 (_tmp15_);
					_backing_photo_row_unref0 (row);
				}
				_g_object_unref0 (_row_it);
			}
		}
		__finally0:
		{
			PhotoRow* _tmp16_;
			_tmp16_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (ret);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = (GeeCollection*) ret;
	return result;
}

GFile*
photo_get_source_file (Photo* self)
{
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = photo_get_source_reader (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp1_);
	_tmp3_ = _tmp2_;
	_photo_file_adapter_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

PhotoFileFormat
photo_get_file_format (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoFileFormat result;
	g_return_val_if_fail (self != NULL, 0);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* _tmp1_;
			_tmp1_ = self->backing_photo_row;
			result = _tmp1_->file_format;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
}

PhotoFileFormat
photo_get_best_export_file_format (Photo* self)
{
	PhotoFileFormat file_format = 0;
	PhotoFileFormat result;
	g_return_val_if_fail (self != NULL, 0);
	file_format = photo_get_file_format (self);
	if (!photo_file_format_can_write (file_format)) {
		file_format = photo_file_format_get_system_default_format ();
	}
	result = file_format;
	return result;
}

PhotoFileFormat
photo_get_master_file_format (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoFileFormat result;
	g_return_val_if_fail (self != NULL, 0);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->master;
			result = photo_file_adapter_get_file_format ((PhotoFileAdapter*) _tmp2_);
			{
				PhotoRow* _tmp3_;
				_tmp3_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
}

static gint64
photo_real_get_timestamp (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	gint64 result;
	self = (Photo*) base;
	{
		PhotoRow* _tmp0_;
		gint64 _tmp4_ = -1LL;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* _tmp1_;
			_tmp1_ = self->backing_photo_row;
			result = _tmp1_->timestamp;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

void
photo_get_photo_id (Photo* self,
                    PhotoID* result)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			PhotoID _tmp2_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->photo_id;
			*result = _tmp2_;
			{
				PhotoRow* _tmp3_;
				_tmp3_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return;
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static inline void
photo_real_get_event_id (MediaSource* base,
                         EventID* result)
{
	Photo * self;
	PhotoRow* _tmp0_;
	EventID _tmp1_;
	self = (Photo*) base;
	_tmp0_ = self->row;
	_tmp1_ = _tmp0_->event_id;
	*result = _tmp1_;
	return;
}

inline gint64
photo_get_raw_event_id (Photo* self)
{
	PhotoRow* _tmp0_;
	EventID _tmp1_;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->row;
	_tmp1_ = _tmp0_->event_id;
	result = _tmp1_.id;
	return result;
}

static void
photo_real_get_import_id (MediaSource* base,
                          ImportID* result)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	self = (Photo*) base;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			ImportID _tmp2_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->import_id;
			*result = _tmp2_;
			{
				PhotoRow* _tmp3_;
				_tmp3_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return;
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
photo_get_editable_id (Photo* self,
                       BackingPhotoID* result)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			BackingPhotoID _tmp2_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->editable_id;
			*result = _tmp2_;
			{
				PhotoRow* _tmp3_;
				_tmp3_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return;
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
photo_real_get_master_md5 (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (Photo*) base;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->md5;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			{
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

guint64
photo_get_flags (Photo* self)
{
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	{
		PhotoRow* _tmp0_;
		guint64 _tmp4_ = 0ULL;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			result = _tmp1_->flags;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static void
photo_notify_flags_altered (Photo* self,
                            Alteration* additional_alteration)
{
	Alteration* alteration = NULL;
	Alteration* _tmp0_;
	Alteration* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = alteration_new ("metadata", "flags");
	alteration = _tmp0_;
	if (additional_alteration != NULL) {
		Alteration* _tmp1_;
		Alteration* _tmp2_;
		_tmp1_ = alteration;
		_tmp2_ = alteration_compress (_tmp1_, additional_alteration);
		_alteration_unref0 (alteration);
		alteration = _tmp2_;
	}
	_tmp3_ = alteration;
	data_object_notify_altered ((DataObject*) self, _tmp3_);
	_alteration_unref0 (alteration);
}

guint64
photo_replace_flags (Photo* self,
                     guint64 flags,
                     Alteration* additional_alteration)
{
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoTable* _tmp1_;
			PhotoTable* _tmp2_;
			PhotoID _tmp3_ = {0};
			_tmp1_ = photo_table_get_instance ();
			_tmp2_ = _tmp1_;
			photo_get_photo_id (self, &_tmp3_);
			committed = photo_table_replace_flags (_tmp2_, &_tmp3_, flags);
			_database_table_unref0 (_tmp2_);
			if (committed) {
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				_tmp4_->flags = flags;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp6_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	if (committed) {
		photo_notify_flags_altered (self, additional_alteration);
	}
	result = flags;
	return result;
}

gboolean
photo_is_flag_set (Photo* self,
                   guint64 mask)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			result = media_source_internal_is_flag_set (_tmp1_->flags, mask);
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

guint64
photo_add_flags (Photo* self,
                 guint64 mask,
                 Alteration* additional_alteration)
{
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	flags = (guint64) 0;
	committed = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			PhotoRow* _tmp2_;
			_tmp1_ = self->row;
			flags = media_source_internal_add_flags (_tmp1_->flags, mask);
			_tmp2_ = self->row;
			if (_tmp2_->flags != flags) {
				PhotoTable* _tmp3_;
				PhotoTable* _tmp4_;
				PhotoID _tmp5_ = {0};
				_tmp3_ = photo_table_get_instance ();
				_tmp4_ = _tmp3_;
				photo_get_photo_id (self, &_tmp5_);
				committed = photo_table_replace_flags (_tmp4_, &_tmp5_, flags);
				_database_table_unref0 (_tmp4_);
				if (committed) {
					PhotoRow* _tmp6_;
					_tmp6_ = self->row;
					_tmp6_->flags = flags;
				}
			}
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp8_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
	}
	if (committed) {
		photo_notify_flags_altered (self, additional_alteration);
	}
	result = flags;
	return result;
}

guint64
photo_remove_flags (Photo* self,
                    guint64 mask,
                    Alteration* additional_alteration)
{
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	flags = (guint64) 0;
	committed = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			PhotoRow* _tmp2_;
			_tmp1_ = self->row;
			flags = media_source_internal_remove_flags (_tmp1_->flags, mask);
			_tmp2_ = self->row;
			if (_tmp2_->flags != flags) {
				PhotoTable* _tmp3_;
				PhotoTable* _tmp4_;
				PhotoID _tmp5_ = {0};
				_tmp3_ = photo_table_get_instance ();
				_tmp4_ = _tmp3_;
				photo_get_photo_id (self, &_tmp5_);
				committed = photo_table_replace_flags (_tmp4_, &_tmp5_, flags);
				_database_table_unref0 (_tmp4_);
				if (committed) {
					PhotoRow* _tmp6_;
					_tmp6_ = self->row;
					_tmp6_->flags = flags;
				}
			}
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp8_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
	}
	if (committed) {
		photo_notify_flags_altered (self, additional_alteration);
	}
	result = flags;
	return result;
}

guint64
photo_add_remove_flags (Photo* self,
                        guint64 add,
                        guint64 remove,
                        Alteration* additional_alteration)
{
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	flags = (guint64) 0;
	committed = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			PhotoRow* _tmp2_;
			_tmp1_ = self->row;
			flags = (_tmp1_->flags | add) & (~remove);
			_tmp2_ = self->row;
			if (_tmp2_->flags != flags) {
				PhotoTable* _tmp3_;
				PhotoTable* _tmp4_;
				PhotoID _tmp5_ = {0};
				_tmp3_ = photo_table_get_instance ();
				_tmp4_ = _tmp3_;
				photo_get_photo_id (self, &_tmp5_);
				committed = photo_table_replace_flags (_tmp4_, &_tmp5_, flags);
				_database_table_unref0 (_tmp4_);
				if (committed) {
					PhotoRow* _tmp6_;
					_tmp6_ = self->row;
					_tmp6_->flags = flags;
				}
			}
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp8_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
	}
	if (committed) {
		photo_notify_flags_altered (self, additional_alteration);
	}
	result = flags;
	return result;
}

void
photo_add_remove_many_flags (GeeCollection* add,
                             guint64 add_mask,
                             Alteration* additional_add_alteration,
                             GeeCollection* remove,
                             guint64 remove_mask,
                             Alteration* additional_remove_alteration,
                             GError** error)
{
	GError* _inner_error0_ = NULL;
	database_table_begin_transaction ();
	if (add != NULL) {
		{
			GeeIterator* _photo_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator ((GeeIterable*) add);
			_photo_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				Photo* photo = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				Photo* _tmp4_;
				_tmp1_ = _photo_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _photo_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				photo = (Photo*) _tmp3_;
				_tmp4_ = photo;
				photo_add_flags (_tmp4_, add_mask, additional_add_alteration);
				_g_object_unref0 (photo);
			}
			_g_object_unref0 (_photo_it);
		}
	}
	if (remove != NULL) {
		{
			GeeIterator* _photo_it = NULL;
			GeeIterator* _tmp5_;
			_tmp5_ = gee_iterable_iterator ((GeeIterable*) remove);
			_photo_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				Photo* photo = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				Photo* _tmp9_;
				_tmp6_ = _photo_it;
				if (!gee_iterator_next (_tmp6_)) {
					break;
				}
				_tmp7_ = _photo_it;
				_tmp8_ = gee_iterator_get (_tmp7_);
				photo = (Photo*) _tmp8_;
				_tmp9_ = photo;
				photo_remove_flags (_tmp9_, remove_mask, additional_remove_alteration);
				_g_object_unref0 (photo);
			}
			_g_object_unref0 (_photo_it);
		}
	}
	database_table_commit_transaction (&_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

guint64
photo_toggle_flags (Photo* self,
                    guint64 mask,
                    Alteration* additional_alteration)
{
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	flags = (guint64) 0;
	committed = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			PhotoRow* _tmp2_;
			_tmp1_ = self->row;
			flags = _tmp1_->flags ^ mask;
			_tmp2_ = self->row;
			if (_tmp2_->flags != flags) {
				PhotoTable* _tmp3_;
				PhotoTable* _tmp4_;
				PhotoID _tmp5_ = {0};
				_tmp3_ = photo_table_get_instance ();
				_tmp4_ = _tmp3_;
				photo_get_photo_id (self, &_tmp5_);
				committed = photo_table_replace_flags (_tmp4_, &_tmp5_, flags);
				_database_table_unref0 (_tmp4_);
				if (committed) {
					PhotoRow* _tmp6_;
					_tmp6_ = self->row;
					_tmp6_->flags = flags;
				}
			}
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp8_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
	}
	if (committed) {
		photo_notify_flags_altered (self, additional_alteration);
	}
	result = flags;
	return result;
}

gboolean
photo_is_master_metadata_dirty (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			result = _tmp1_->metadata_dirty;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

void
photo_set_master_metadata_dirty (Photo* self,
                                 gboolean dirty,
                                 GError** error)
{
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	committed = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			if (_tmp1_->metadata_dirty != dirty) {
				PhotoTable* _tmp2_;
				PhotoTable* _tmp3_;
				PhotoID _tmp4_ = {0};
				PhotoRow* _tmp5_;
				_tmp2_ = photo_table_get_instance ();
				_tmp3_ = _tmp2_;
				photo_get_photo_id (self, &_tmp4_);
				photo_table_set_metadata_dirty (_tmp3_, &_tmp4_, dirty, &_inner_error0_);
				_database_table_unref0 (_tmp3_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp5_ = self->row;
				_tmp5_->metadata_dirty = dirty;
				committed = TRUE;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _lock_error_ = NULL;
			GError* _tmp6_;
			_lock_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = _lock_error_;
			_lock_error_ = NULL;
			_inner_error0_ = _tmp6_;
			_g_error_free0 (_lock_error_);
			goto __finally0;
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	if (committed) {
		Alteration* _tmp8_;
		Alteration* _tmp9_;
		_tmp8_ = alteration_new ("metadata", "master-dirty");
		_tmp9_ = _tmp8_;
		data_object_notify_altered ((DataObject*) self, _tmp9_);
		_alteration_unref0 (_tmp9_);
	}
}

gboolean
photo_is_enhanced (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			result = _tmp1_->enhanced;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

void
photo_set_enhanced (Photo* self,
                    gboolean enhanced)
{
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	committed = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			if (_tmp1_->enhanced != enhanced) {
				PhotoTable* _tmp2_;
				PhotoTable* _tmp3_;
				PhotoID _tmp4_ = {0};
				_tmp2_ = photo_table_get_instance ();
				_tmp3_ = _tmp2_;
				photo_get_photo_id (self, &_tmp4_);
				committed = photo_table_set_enhanced (_tmp3_, &_tmp4_, enhanced);
				_database_table_unref0 (_tmp3_);
				if (committed) {
					PhotoRow* _tmp5_;
					_tmp5_ = self->row;
					_tmp5_->enhanced = enhanced;
				}
			}
		}
		__finally0:
		{
			PhotoRow* _tmp6_;
			_tmp6_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (committed) {
		Alteration* _tmp7_;
		Alteration* _tmp8_;
		_tmp7_ = alteration_new ("metadata", "enhanced");
		_tmp8_ = _tmp7_;
		data_object_notify_altered ((DataObject*) self, _tmp8_);
		_alteration_unref0 (_tmp8_);
	}
}

static void
photo_real_commit_backlinks (DataSource* base,
                             SourceCollection* sources,
                             const gchar* backlinks)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	self = (Photo*) base;
	{
		PhotoTable* _tmp0_;
		PhotoTable* _tmp1_;
		PhotoID _tmp2_ = {0};
		_tmp0_ = photo_table_get_instance ();
		_tmp1_ = _tmp0_;
		photo_get_photo_id (self, &_tmp2_);
		photo_table_update_backlinks (_tmp1_, &_tmp2_, backlinks, &_inner_error0_);
		_database_table_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				PhotoRow* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = self->row;
				_tmp5_ = g_strdup (backlinks);
				_g_free0 (_tmp4_->backlinks);
				_tmp4_->backlinks = _tmp5_;
			}
			__finally1:
			{
				PhotoRow* _tmp6_;
				_tmp6_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch0_database_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = data_object_to_string ((DataObject*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = err;
		_tmp10_ = _tmp9_->message;
		g_warning ("Photo.vala:2190: Unable to update link state for %s: %s", _tmp8_, _tmp10_);
		_g_free0 (_tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
photo_real_set_event_id (MediaSource* base,
                         EventID* event_id)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (Photo*) base;
	g_return_val_if_fail (event_id != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp11_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			gboolean committed = FALSE;
			PhotoTable* _tmp1_;
			PhotoTable* _tmp2_;
			PhotoRow* _tmp3_;
			PhotoID _tmp4_;
			EventID _tmp5_;
			gboolean _tmp6_;
			_tmp1_ = photo_table_get_instance ();
			_tmp2_ = _tmp1_;
			_tmp3_ = self->row;
			_tmp4_ = _tmp3_->photo_id;
			_tmp5_ = *event_id;
			_tmp6_ = photo_table_set_event (_tmp2_, &_tmp4_, &_tmp5_);
			_database_table_unref0 (_tmp2_);
			committed = _tmp6_;
			if (committed) {
				PhotoRow* _tmp7_;
				EventID _tmp8_;
				_tmp7_ = self->row;
				_tmp8_ = *event_id;
				_tmp7_->event_id = _tmp8_;
			}
			result = committed;
			{
				PhotoRow* _tmp9_;
				_tmp9_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp10_;
			_tmp10_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp11_;
	}
}

static gchar*
photo_real_to_string (DataObject* base)
{
	Photo * self;
	gchar* _tmp0_ = NULL;
	PhotoID _tmp9_ = {0};
	gchar* _tmp10_;
	gchar* _tmp11_;
	PhotoFileReader* _tmp12_;
	PhotoFileReader* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* result;
	self = (Photo*) base;
	if (!photo_is_master_baseline (self)) {
		GFile* _tmp1_;
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = photo_get_actual_file (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (" (", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp6_, ")", NULL);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp7_;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_g_object_unref0 (_tmp2_);
	} else {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp8_;
	}
	photo_get_photo_id (self, &_tmp9_);
	_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp9_.id);
	_tmp11_ = _tmp10_;
	_tmp12_ = photo_get_master_reader (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup_printf ("[%s] %s%s", _tmp11_, _tmp15_, _tmp0_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp15_);
	_photo_file_adapter_unref0 (_tmp13_);
	_g_free0 (_tmp11_);
	result = _tmp17_;
	_g_free0 (_tmp0_);
	return result;
}

static gboolean
photo_real_equals (DataSource* base,
                   DataSource* source)
{
	Photo * self;
	Photo* photo = NULL;
	Photo* _tmp0_;
	Photo* _tmp1_;
	gboolean result;
	self = (Photo*) base;
	_tmp0_ = _g_object_ref0 (IS_PHOTO (source) ? ((Photo*) source) : NULL);
	photo = _tmp0_;
	_tmp1_ = photo;
	if (_tmp1_ != NULL) {
		PhotoID photo_id = {0};
		PhotoID _tmp2_ = {0};
		PhotoID other_photo_id = {0};
		Photo* _tmp3_;
		PhotoID _tmp4_ = {0};
		gboolean _tmp5_ = FALSE;
		Photo* _tmp6_;
		photo_get_photo_id (self, &_tmp2_);
		photo_id = _tmp2_;
		_tmp3_ = photo;
		photo_get_photo_id (_tmp3_, &_tmp4_);
		other_photo_id = _tmp4_;
		_tmp6_ = photo;
		if (self != _tmp6_) {
			PhotoID _tmp7_;
			_tmp7_ = photo_id;
			_tmp5_ = _tmp7_.id != PHOTO_ID_INVALID;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			PhotoID _tmp8_;
			PhotoID _tmp9_;
			_tmp8_ = photo_id;
			_tmp9_ = other_photo_id;
			_vala_assert (_tmp8_.id != _tmp9_.id, "photo_id.id != other_photo_id.id");
		}
	}
	result = DATA_SOURCE_CLASS (photo_parent_class)->equals ((DataSource*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), source);
	_g_object_unref0 (photo);
	return result;
}

static void
photo_file_exif_updated (Photo* self)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFileInfo* info = NULL;
	gint64 mod_time = 0LL;
	GFileInfo* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	gint64 _tmp10_;
	PhotoFileInterrogator* interrogator = NULL;
	PhotoFileInterrogator* _tmp11_;
	DetectedPhotoInformation* detected = NULL;
	DetectedPhotoInformation* _tmp16_;
	DetectedPhotoInformation* _tmp17_;
	gboolean success = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = media_source_get_file ((MediaSource*) self);
	file = _tmp0_;
	info = NULL;
	{
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		_tmp2_ = g_file_query_info (file, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (info);
		info = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = data_object_to_string ((DataObject*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = err->message;
		g_error ("Photo.vala:2239: Unable to read file information for %s: %s", _tmp5_, _tmp6_);
		_g_free0 (_tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = info;
	_tmp8_ = g_file_info_get_modification_date_time (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_date_time_to_unix (_tmp9_);
	_g_date_time_unref0 (_tmp9_);
	mod_time = _tmp10_;
	_tmp11_ = photo_file_interrogator_new (file, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL);
	interrogator = _tmp11_;
	{
		photo_file_interrogator_interrogate (interrogator, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = g_file_get_path (file);
		_tmp13_ = _tmp12_;
		_tmp14_ = err;
		_tmp15_ = _tmp14_->message;
		g_warning ("Photo.vala:2249: Unable to interrogate photo file %s: %s", _tmp13_, _tmp15_);
		_g_free0 (_tmp13_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_photo_file_interrogator_unref0 (interrogator);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp16_ = photo_file_interrogator_get_detected_photo_information (interrogator);
	detected = _tmp16_;
	_tmp17_ = detected;
	if (_tmp17_ == NULL) {
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp18_ = data_object_to_string ((DataObject*) self);
		_tmp19_ = _tmp18_;
		g_critical ("Photo.vala:2254: file_exif_updated: %s no longer an image", _tmp19_);
		_g_free0 (_tmp19_);
		_detected_photo_information_unref0 (detected);
		_photo_file_interrogator_unref0 (interrogator);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return;
	}
	{
		PhotoRow* _tmp20_;
		_tmp20_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoTable* _tmp21_;
			PhotoTable* _tmp22_;
			PhotoID _tmp23_ = {0};
			GFileInfo* _tmp24_;
			DetectedPhotoInformation* _tmp25_;
			const gchar* _tmp26_;
			DetectedPhotoInformation* _tmp27_;
			const gchar* _tmp28_;
			DetectedPhotoInformation* _tmp29_;
			const gchar* _tmp30_;
			PhotoRow* _tmp31_;
			_tmp21_ = photo_table_get_instance ();
			_tmp22_ = _tmp21_;
			photo_get_photo_id (self, &_tmp23_);
			_tmp24_ = info;
			_tmp25_ = detected;
			_tmp26_ = _tmp25_->md5;
			_tmp27_ = detected;
			_tmp28_ = _tmp27_->exif_md5;
			_tmp29_ = detected;
			_tmp30_ = _tmp29_->thumbnail_md5;
			_tmp31_ = self->row;
			success = photo_table_master_exif_updated (_tmp22_, &_tmp23_, g_file_info_get_size (_tmp24_), mod_time, _tmp26_, _tmp28_, _tmp30_, _tmp31_);
			_database_table_unref0 (_tmp22_);
		}
		__finally2:
		{
			PhotoRow* _tmp32_;
			_tmp32_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_detected_photo_information_unref0 (detected);
			_photo_file_interrogator_unref0 (interrogator);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (success) {
		Alteration* _tmp33_;
		Alteration* _tmp34_;
		_tmp33_ = alteration_new_from_list ("metadata:exif,metadata:md5");
		_tmp34_ = _tmp33_;
		data_object_notify_altered ((DataObject*) self, _tmp34_);
		_alteration_unref0 (_tmp34_);
	}
	_detected_photo_information_unref0 (detected);
	_photo_file_interrogator_unref0 (interrogator);
	_g_object_unref0 (info);
	_g_object_unref0 (file);
}

static guint64
photo_real_get_filesize (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	guint64 result;
	self = (Photo*) base;
	{
		PhotoRow* _tmp0_;
		guint64 _tmp4_ = 0ULL;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* _tmp1_;
			_tmp1_ = self->backing_photo_row;
			result = (guint64) _tmp1_->filesize;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static guint64
photo_real_get_master_filesize (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	guint64 result;
	self = (Photo*) base;
	{
		PhotoRow* _tmp0_;
		guint64 _tmp5_ = 0ULL;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			BackingPhotoRow* _tmp2_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->master;
			result = (guint64) _tmp2_->filesize;
			{
				PhotoRow* _tmp3_;
				_tmp3_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
}

guint64
photo_get_editable_filesize (Photo* self)
{
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	{
		PhotoRow* _tmp0_;
		guint64 _tmp4_ = 0ULL;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* _tmp1_;
			_tmp1_ = self->priv->editable;
			result = (guint64) _tmp1_->filesize;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static gint64
photo_real_get_exposure_time (Dateable* base)
{
	Photo * self;
	gint64 result;
	self = (Photo*) base;
	result = self->priv->cached_exposure_time;
	return result;
}

static gchar*
photo_real_get_basename (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (Photo*) base;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			const gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = self->priv->file_title;
			_tmp2_ = g_strdup (_tmp1_);
			result = _tmp2_;
			{
				PhotoRow* _tmp3_;
				_tmp3_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gchar*
photo_real_get_title (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (Photo*) base;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->title;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			{
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gchar*
photo_real_get_comment (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (Photo*) base;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->comment;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			{
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static void
photo_real_set_title (MediaSource* base,
                      const gchar* title)
{
	Photo * self;
	gchar* new_title = NULL;
	gchar* _tmp0_;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	self = (Photo*) base;
	_tmp0_ = media_source_prep_title (title);
	new_title = _tmp0_;
	committed = FALSE;
	{
		PhotoRow* _tmp1_;
		_tmp1_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			const gchar* _tmp2_;
			PhotoRow* _tmp3_;
			const gchar* _tmp4_;
			PhotoTable* _tmp6_;
			PhotoTable* _tmp7_;
			PhotoRow* _tmp8_;
			PhotoID _tmp9_;
			const gchar* _tmp10_;
			_tmp2_ = new_title;
			_tmp3_ = self->row;
			_tmp4_ = _tmp3_->title;
			if (g_strcmp0 (_tmp2_, _tmp4_) == 0) {
				{
					PhotoRow* _tmp5_;
					_tmp5_ = self->row;
					g_rec_mutex_unlock (&self->priv->__lock_row);
				}
				_g_free0 (new_title);
				return;
			}
			_tmp6_ = photo_table_get_instance ();
			_tmp7_ = _tmp6_;
			_tmp8_ = self->row;
			_tmp9_ = _tmp8_->photo_id;
			_tmp10_ = new_title;
			committed = photo_table_set_title (_tmp7_, &_tmp9_, _tmp10_);
			_database_table_unref0 (_tmp7_);
			if (committed) {
				PhotoRow* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = self->row;
				_tmp12_ = new_title;
				_tmp13_ = g_strdup (_tmp12_);
				_g_free0 (_tmp11_->title);
				_tmp11_->title = _tmp13_;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp14_;
			_tmp14_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (new_title);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (committed) {
		Alteration* _tmp15_;
		Alteration* _tmp16_;
		_tmp15_ = alteration_new ("metadata", "name");
		_tmp16_ = _tmp15_;
		data_object_notify_altered ((DataObject*) self, _tmp16_);
		_alteration_unref0 (_tmp16_);
	}
	_g_free0 (new_title);
}

static gboolean
photo_real_set_comment (MediaSource* base,
                        const gchar* comment)
{
	Photo * self;
	gchar* new_comment = NULL;
	gchar* _tmp0_;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (Photo*) base;
	_tmp0_ = media_source_prep_comment (comment);
	new_comment = _tmp0_;
	committed = FALSE;
	{
		PhotoRow* _tmp1_;
		_tmp1_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			const gchar* _tmp2_;
			PhotoRow* _tmp3_;
			const gchar* _tmp4_;
			PhotoTable* _tmp6_;
			PhotoTable* _tmp7_;
			PhotoRow* _tmp8_;
			PhotoID _tmp9_;
			const gchar* _tmp10_;
			_tmp2_ = new_comment;
			_tmp3_ = self->row;
			_tmp4_ = _tmp3_->comment;
			if (g_strcmp0 (_tmp2_, _tmp4_) == 0) {
				result = TRUE;
				{
					PhotoRow* _tmp5_;
					_tmp5_ = self->row;
					g_rec_mutex_unlock (&self->priv->__lock_row);
				}
				_g_free0 (new_comment);
				return result;
			}
			_tmp6_ = photo_table_get_instance ();
			_tmp7_ = _tmp6_;
			_tmp8_ = self->row;
			_tmp9_ = _tmp8_->photo_id;
			_tmp10_ = new_comment;
			committed = photo_table_set_comment (_tmp7_, &_tmp9_, _tmp10_);
			_database_table_unref0 (_tmp7_);
			if (committed) {
				PhotoRow* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = self->row;
				_tmp12_ = new_comment;
				_tmp13_ = g_strdup (_tmp12_);
				_g_free0 (_tmp11_->comment);
				_tmp11_->comment = _tmp13_;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp14_;
			_tmp14_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp15_ = FALSE;
			_g_free0 (new_comment);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp15_;
		}
	}
	if (committed) {
		Alteration* _tmp16_;
		Alteration* _tmp17_;
		_tmp16_ = alteration_new ("metadata", "comment");
		_tmp17_ = _tmp16_;
		data_object_notify_altered ((DataObject*) self, _tmp17_);
		_alteration_unref0 (_tmp17_);
	}
	result = committed;
	_g_free0 (new_comment);
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

void
photo_set_import_id (Photo* self,
                     ImportID* import_id)
{
	GError* dberr = NULL;
	GError* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (import_id != NULL);
	dberr = NULL;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			{
				PhotoTable* _tmp1_;
				PhotoTable* _tmp2_;
				PhotoRow* _tmp3_;
				PhotoID _tmp4_;
				ImportID _tmp5_;
				PhotoRow* _tmp7_;
				ImportID _tmp8_;
				_tmp1_ = photo_table_get_instance ();
				_tmp2_ = _tmp1_;
				_tmp3_ = self->row;
				_tmp4_ = _tmp3_->photo_id;
				_tmp5_ = *import_id;
				photo_table_set_import_id (_tmp2_, &_tmp4_, &_tmp5_, &_inner_error0_);
				_database_table_unref0 (_tmp2_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch1_database_error;
					}
					{
						PhotoRow* _tmp6_;
						_tmp6_ = self->row;
						g_rec_mutex_unlock (&self->priv->__lock_row);
					}
					_g_error_free0 (dberr);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp7_ = self->row;
				_tmp8_ = *import_id;
				_tmp7_->import_id = _tmp8_;
			}
			goto __finally1;
			__catch1_database_error:
			{
				GError* err = NULL;
				GError* _tmp9_;
				GError* _tmp10_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp9_ = err;
				_tmp10_ = _g_error_copy0 (_tmp9_);
				_g_error_free0 (dberr);
				dberr = _tmp10_;
				_g_error_free0 (err);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (dberr);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp11_;
			_tmp11_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_error_free0 (dberr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp12_ = dberr;
	if (_tmp12_ == NULL) {
		Alteration* _tmp13_;
		Alteration* _tmp14_;
		_tmp13_ = alteration_new ("metadata", "import-id");
		_tmp14_ = _tmp13_;
		data_object_notify_altered ((DataObject*) self, _tmp14_);
		_alteration_unref0 (_tmp14_);
	} else {
		gchar* _tmp15_;
		gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		_tmp15_ = data_object_to_string ((DataObject*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = dberr;
		_tmp18_ = _tmp17_->message;
		g_warning ("Photo.vala:2370: Unable to write import ID for %s: %s", _tmp16_, _tmp18_);
		_g_free0 (_tmp16_);
	}
	_g_error_free0 (dberr);
}

void
photo_set_title_persistent (Photo* self,
                            const gchar* title,
                            GError** error)
{
	PhotoFileReader* source = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp5_;
	PhotoMetadata* _tmp6_;
	PhotoMetadata* _tmp7_;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp8_;
	PhotoFileMetadataWriter* _tmp9_;
	PhotoFileReader* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = photo_get_source_reader (self);
	source = _tmp0_;
	_tmp1_ = source;
	if (!photo_file_format_can_write_metadata (photo_file_adapter_get_file_format ((PhotoFileAdapter*) _tmp1_))) {
		PhotoFileReader* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = source;
		_tmp3_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) _tmp2_);
		_tmp4_ = _tmp3_;
		g_warning ("Photo.vala:2379: No photo file writer available for %s", _tmp4_);
		_g_free0 (_tmp4_);
		media_source_set_title ((MediaSource*) self, title);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp5_ = source;
	_tmp6_ = photo_file_reader_read_metadata (_tmp5_, &_inner_error0_);
	metadata = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp7_ = metadata;
	photo_metadata_set_title (_tmp7_, title, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
	_tmp8_ = source;
	_tmp9_ = photo_file_reader_create_metadata_writer (_tmp8_, &_inner_error0_);
	writer = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp10_ = source;
	_tmp11_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp10_);
	_tmp12_ = _tmp11_;
	library_monitor_blacklist_file (_tmp12_, "Photo.set_persistent_title");
	_g_object_unref0 (_tmp12_);
	{
		PhotoFileMetadataWriter* _tmp13_;
		PhotoMetadata* _tmp14_;
		_tmp13_ = writer;
		_tmp14_ = metadata;
		photo_file_metadata_writer_write_metadata (_tmp13_, _tmp14_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		PhotoFileReader* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		_tmp15_ = source;
		_tmp16_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp15_);
		_tmp17_ = _tmp16_;
		library_monitor_unblacklist_file (_tmp17_);
		_g_object_unref0 (_tmp17_);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (writer);
		_media_metadata_unref0 (metadata);
		_photo_file_adapter_unref0 (source);
		return;
	}
	media_source_set_title ((MediaSource*) self, title);
	photo_file_exif_updated (self);
	_photo_file_adapter_unref0 (writer);
	_media_metadata_unref0 (metadata);
	_photo_file_adapter_unref0 (source);
}

void
photo_set_comment_persistent (Photo* self,
                              const gchar* comment,
                              GError** error)
{
	PhotoFileReader* source = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp5_;
	PhotoMetadata* _tmp6_;
	PhotoMetadata* _tmp7_;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp8_;
	PhotoFileMetadataWriter* _tmp9_;
	PhotoFileReader* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = photo_get_source_reader (self);
	source = _tmp0_;
	_tmp1_ = source;
	if (!photo_file_format_can_write_metadata (photo_file_adapter_get_file_format ((PhotoFileAdapter*) _tmp1_))) {
		PhotoFileReader* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = source;
		_tmp3_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) _tmp2_);
		_tmp4_ = _tmp3_;
		g_warning ("Photo.vala:2407: No photo file writer available for %s", _tmp4_);
		_g_free0 (_tmp4_);
		media_source_set_comment ((MediaSource*) self, comment);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp5_ = source;
	_tmp6_ = photo_file_reader_read_metadata (_tmp5_, &_inner_error0_);
	metadata = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp7_ = metadata;
	photo_metadata_set_comment (_tmp7_, comment);
	_tmp8_ = source;
	_tmp9_ = photo_file_reader_create_metadata_writer (_tmp8_, &_inner_error0_);
	writer = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp10_ = source;
	_tmp11_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp10_);
	_tmp12_ = _tmp11_;
	library_monitor_blacklist_file (_tmp12_, "Photo.set_persistent_comment");
	_g_object_unref0 (_tmp12_);
	{
		PhotoFileMetadataWriter* _tmp13_;
		PhotoMetadata* _tmp14_;
		_tmp13_ = writer;
		_tmp14_ = metadata;
		photo_file_metadata_writer_write_metadata (_tmp13_, _tmp14_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		PhotoFileReader* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		_tmp15_ = source;
		_tmp16_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp15_);
		_tmp17_ = _tmp16_;
		library_monitor_unblacklist_file (_tmp17_);
		_g_object_unref0 (_tmp17_);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (writer);
		_media_metadata_unref0 (metadata);
		_photo_file_adapter_unref0 (source);
		return;
	}
	media_source_set_comment ((MediaSource*) self, comment);
	photo_file_exif_updated (self);
	_photo_file_adapter_unref0 (writer);
	_media_metadata_unref0 (metadata);
	_photo_file_adapter_unref0 (source);
}

static void
photo_real_set_exposure_time (Dateable* base,
                              gint64 time)
{
	Photo * self;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	self = (Photo*) base;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoTable* _tmp1_;
			PhotoTable* _tmp2_;
			PhotoRow* _tmp3_;
			PhotoID _tmp4_;
			_tmp1_ = photo_table_get_instance ();
			_tmp2_ = _tmp1_;
			_tmp3_ = self->row;
			_tmp4_ = _tmp3_->photo_id;
			committed = photo_table_set_exposure_time (_tmp2_, &_tmp4_, time);
			_database_table_unref0 (_tmp2_);
			if (committed) {
				PhotoRow* _tmp5_;
				_tmp5_ = self->row;
				_tmp5_->exposure_time = time;
				self->priv->cached_exposure_time = time;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp6_;
			_tmp6_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (committed) {
		Alteration* _tmp7_;
		Alteration* _tmp8_;
		_tmp7_ = alteration_new ("metadata", "exposure-time");
		_tmp8_ = _tmp7_;
		data_object_notify_altered ((DataObject*) self, _tmp8_);
		_alteration_unref0 (_tmp8_);
	}
}

void
photo_set_exposure_time_persistent (Photo* self,
                                    gint64 time,
                                    GError** error)
{
	PhotoFileReader* source = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp5_;
	PhotoMetadata* _tmp6_;
	PhotoMetadata* _tmp7_;
	MetadataDateTime* _tmp8_;
	MetadataDateTime* _tmp9_;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp10_;
	PhotoFileMetadataWriter* _tmp11_;
	PhotoFileReader* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = photo_get_source_reader (self);
	source = _tmp0_;
	_tmp1_ = source;
	if (!photo_file_format_can_write_metadata (photo_file_adapter_get_file_format ((PhotoFileAdapter*) _tmp1_))) {
		PhotoFileReader* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = source;
		_tmp3_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) _tmp2_);
		_tmp4_ = _tmp3_;
		g_warning ("Photo.vala:2450: No photo file writer available for %s", _tmp4_);
		_g_free0 (_tmp4_);
		dateable_set_exposure_time ((Dateable*) self, time);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp5_ = source;
	_tmp6_ = photo_file_reader_read_metadata (_tmp5_, &_inner_error0_);
	metadata = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp7_ = metadata;
	_tmp8_ = metadata_date_time_new (time);
	_tmp9_ = _tmp8_;
	photo_metadata_set_exposure_date_time (_tmp7_, _tmp9_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
	_metadata_date_time_unref0 (_tmp9_);
	_tmp10_ = source;
	_tmp11_ = photo_file_reader_create_metadata_writer (_tmp10_, &_inner_error0_);
	writer = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp12_ = source;
	_tmp13_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp12_);
	_tmp14_ = _tmp13_;
	library_monitor_blacklist_file (_tmp14_, "Photo.set_exposure_time_persistent");
	_g_object_unref0 (_tmp14_);
	{
		PhotoFileMetadataWriter* _tmp15_;
		PhotoMetadata* _tmp16_;
		_tmp15_ = writer;
		_tmp16_ = metadata;
		photo_file_metadata_writer_write_metadata (_tmp15_, _tmp16_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		PhotoFileReader* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		_tmp17_ = source;
		_tmp18_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp17_);
		_tmp19_ = _tmp18_;
		library_monitor_unblacklist_file (_tmp19_);
		_g_object_unref0 (_tmp19_);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (writer);
		_media_metadata_unref0 (metadata);
		_photo_file_adapter_unref0 (source);
		return;
	}
	dateable_set_exposure_time ((Dateable*) self, time);
	photo_file_exif_updated (self);
	_photo_file_adapter_unref0 (writer);
	_media_metadata_unref0 (metadata);
	_photo_file_adapter_unref0 (source);
}

/**
     * Returns the width and height of the Photo after various
     * arbitrary stages of the pipeline have been applied in
     * the same order they're applied in get_pixbuf_with_options.
     * With no argument passed, it works exactly like the
     * previous incarnation did.
     *
     * @param disallowed_steps Which pipeline steps should NOT
     *      be taken into account when computing image dimensions
     *      (matching the convention set by get_pixbuf_with_options ()).
     *      Pipeline steps that do not affect the image geometry are
     *      ignored.
     */
static void
photo_real_get_dimensions (MediaSource* base,
                           PhotoException disallowed_steps,
                           Dimensions* result)
{
	Photo * self;
	Dimensions returned_dims = {0};
	Dimensions _tmp0_ = {0};
	self = (Photo*) base;
	photo_get_raw_dimensions (self, &_tmp0_);
	returned_dims = _tmp0_;
	if (photo_exception_allows (disallowed_steps, PHOTO_EXCEPTION_ORIENTATION)) {
		Orientation ori_tmp = 0;
		ori_tmp = photo_get_orientation (self);
		switch (ori_tmp) {
			case ORIENTATION_LEFT_TOP:
			case ORIENTATION_RIGHT_TOP:
			case ORIENTATION_LEFT_BOTTOM:
			case ORIENTATION_RIGHT_BOTTOM:
			{
				gint width_tmp = 0;
				Dimensions _tmp1_;
				Dimensions _tmp2_;
				_tmp1_ = returned_dims;
				width_tmp = _tmp1_.width;
				_tmp2_ = returned_dims;
				returned_dims.width = _tmp2_.height;
				returned_dims.height = width_tmp;
				break;
			}
			default:
			{
				break;
			}
		}
	}
	if (photo_exception_allows (disallowed_steps, PHOTO_EXCEPTION_STRAIGHTEN)) {
		gdouble x_size = 0.0;
		gdouble y_size = 0.0;
		gdouble angle = 0.0;
		gdouble _tmp3_ = 0.0;
		Dimensions _tmp4_;
		Dimensions _tmp5_;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		angle = 0.0;
		photo_get_straighten (self, &_tmp3_);
		angle = _tmp3_;
		_tmp4_ = returned_dims;
		_tmp5_ = returned_dims;
		compute_arb_rotated_size ((gdouble) _tmp4_.width, (gdouble) _tmp5_.height, angle, &_tmp6_, &_tmp7_);
		x_size = _tmp6_;
		y_size = _tmp7_;
		returned_dims.width = (gint) x_size;
		returned_dims.height = (gint) y_size;
	}
	if (photo_exception_allows (disallowed_steps, PHOTO_EXCEPTION_CROP)) {
		Box crop = {0};
		Box _tmp8_ = {0};
		gboolean _tmp9_;
		_tmp9_ = photo_get_crop (self, &_tmp8_, disallowed_steps);
		crop = _tmp8_;
		if (_tmp9_) {
			Dimensions _tmp10_ = {0};
			box_get_dimensions (&crop, &_tmp10_);
			returned_dims = _tmp10_;
		}
	}
	*result = returned_dims;
	return;
}

static void
photo_locked_create_adjustments_from_data (Photo* self)
{
	PixelTransformationBundle* _tmp0_;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp1_;
	KeyValueMap* _tmp2_;
	PixelTransformationBundle* _tmp6_;
	PixelTransformer* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pixel_transformation_bundle_new ();
	_pixel_transformation_bundle_unref0 (self->priv->adjustments);
	self->priv->adjustments = _tmp0_;
	_tmp1_ = photo_get_transformation (self, "adjustments");
	map = _tmp1_;
	_tmp2_ = map;
	if (_tmp2_ == NULL) {
		PixelTransformationBundle* _tmp3_;
		_tmp3_ = self->priv->adjustments;
		pixel_transformation_bundle_set_to_identity (_tmp3_);
	} else {
		PixelTransformationBundle* _tmp4_;
		KeyValueMap* _tmp5_;
		_tmp4_ = self->priv->adjustments;
		_tmp5_ = map;
		pixel_transformation_bundle_load (_tmp4_, _tmp5_);
	}
	_tmp6_ = self->priv->adjustments;
	_tmp7_ = pixel_transformation_bundle_generate_transformer (_tmp6_);
	_pixel_transformer_unref0 (self->priv->transformer);
	self->priv->transformer = _tmp7_;
	_key_value_map_unref0 (map);
}

PixelTransformationBundle*
photo_get_color_adjustments (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PixelTransformationBundle* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PixelTransformationBundle* _tmp1_;
			PixelTransformationBundle* _tmp2_;
			PixelTransformationBundle* _tmp3_;
			_tmp1_ = self->priv->adjustments;
			if (_tmp1_ == NULL) {
				photo_locked_create_adjustments_from_data (self);
			}
			_tmp2_ = self->priv->adjustments;
			_tmp3_ = pixel_transformation_bundle_copy (_tmp2_);
			result = _tmp3_;
			{
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static PixelTransformationBundle*
photo_locked_original_color_adjustments (Photo* self)
{
	PixelTransformationBundle* original_adjustments = NULL;
	PixelTransformationBundle* _tmp0_;
	KeyValueMap* map = NULL;
	PhotoRow* _tmp1_;
	GeeHashMap* _tmp2_;
	KeyValueMap* _tmp10_;
	PixelTransformationBundle* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = pixel_transformation_bundle_new ();
	original_adjustments = _tmp0_;
	_tmp1_ = self->row;
	_tmp2_ = _tmp1_->original_transforms;
	if (_tmp2_ != NULL) {
		PhotoRow* _tmp3_;
		GeeHashMap* _tmp4_;
		gpointer _tmp5_;
		KeyValueMap* _tmp6_;
		_tmp3_ = self->row;
		_tmp4_ = _tmp3_->original_transforms;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, "adjustments");
		_key_value_map_unref0 (map);
		map = (KeyValueMap*) _tmp5_;
		_tmp6_ = map;
		if (_tmp6_ != NULL) {
			KeyValueMap* _tmp7_;
			KeyValueMap* _tmp8_;
			_tmp7_ = map;
			_tmp8_ = key_value_map_copy (_tmp7_);
			_key_value_map_unref0 (map);
			map = _tmp8_;
		}
	} else {
		KeyValueMap* _tmp9_;
		_tmp9_ = key_value_map_new ("adjustments");
		_key_value_map_unref0 (map);
		map = _tmp9_;
	}
	_tmp10_ = map;
	if (_tmp10_ == NULL) {
		PixelTransformationBundle* _tmp11_;
		_tmp11_ = original_adjustments;
		pixel_transformation_bundle_set_to_identity (_tmp11_);
	} else {
		PixelTransformationBundle* _tmp12_;
		KeyValueMap* _tmp13_;
		_tmp12_ = original_adjustments;
		_tmp13_ = map;
		pixel_transformation_bundle_load (_tmp12_, _tmp13_);
	}
	result = original_adjustments;
	_key_value_map_unref0 (map);
	return result;
}

static KeyValueMap*
photo_get_color_adjustments_map (Photo* self)
{
	GError* _inner_error0_ = NULL;
	KeyValueMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			KeyValueMap* map = NULL;
			KeyValueMap* _tmp1_;
			KeyValueMap* _tmp2_;
			_tmp1_ = photo_get_transformation (self, "adjustments");
			map = _tmp1_;
			_tmp2_ = map;
			if (_tmp2_ == NULL) {
				KeyValueMap* _tmp3_;
				_tmp3_ = key_value_map_new ("adjustments");
				_key_value_map_unref0 (map);
				map = _tmp3_;
			}
			result = map;
			{
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

PixelTransformer*
photo_get_pixel_transformer (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PixelTransformer* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PixelTransformer* _tmp1_;
			PixelTransformer* _tmp2_;
			PixelTransformer* _tmp3_;
			_tmp1_ = self->priv->transformer;
			if (_tmp1_ == NULL) {
				photo_locked_create_adjustments_from_data (self);
			}
			_tmp2_ = self->priv->transformer;
			_tmp3_ = pixel_transformer_copy (_tmp2_);
			result = _tmp3_;
			{
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

gboolean
photo_has_color_adjustments (Photo* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = photo_has_transformation (self, "adjustments");
	return result;
}

PixelTransformation*
photo_get_color_adjustment (Photo* self,
                            PixelTransformationType type)
{
	PixelTransformationBundle* _tmp0_;
	PixelTransformationBundle* _tmp1_;
	PixelTransformation* _tmp2_;
	PixelTransformation* _tmp3_;
	PixelTransformation* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = photo_get_color_adjustments (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = pixel_transformation_bundle_get_transformation (_tmp1_, type);
	_tmp3_ = _tmp2_;
	_pixel_transformation_bundle_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

void
photo_set_color_adjustments (Photo* self,
                             PixelTransformationBundle* new_adjustments)
{
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp4_;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_adjustments != NULL);
	photo_set_enhanced (self, FALSE);
	if (pixel_transformation_bundle_is_identity (new_adjustments)) {
		gboolean _result_ = FALSE;
		{
			PhotoRow* _tmp0_;
			_tmp0_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				_result_ = photo_remove_transformation (self, "adjustments");
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
				self->priv->adjustments = NULL;
				_pixel_transformer_unref0 (self->priv->transformer);
				self->priv->transformer = NULL;
			}
			__finally0:
			{
				PhotoRow* _tmp1_;
				_tmp1_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		if (_result_) {
			Alteration* _tmp2_;
			Alteration* _tmp3_;
			_tmp2_ = alteration_new ("image", "color-adjustments");
			_tmp3_ = _tmp2_;
			data_object_notify_altered ((DataObject*) self, _tmp3_);
			_alteration_unref0 (_tmp3_);
		}
		return;
	}
	_tmp4_ = pixel_transformation_bundle_save (new_adjustments, "adjustments");
	map = _tmp4_;
	{
		PhotoRow* _tmp5_;
		_tmp5_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			gboolean _tmp6_ = FALSE;
			PixelTransformer* _tmp7_;
			KeyValueMap* _tmp25_;
			_tmp7_ = self->priv->transformer;
			if (_tmp7_ == NULL) {
				_tmp6_ = TRUE;
			} else {
				PixelTransformationBundle* _tmp8_;
				_tmp8_ = self->priv->adjustments;
				_tmp6_ = _tmp8_ == NULL;
			}
			if (_tmp6_) {
				PixelTransformationBundle* _tmp9_;
				PixelTransformer* _tmp10_;
				_tmp9_ = pixel_transformation_bundle_copy (new_adjustments);
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
				self->priv->adjustments = _tmp9_;
				_tmp10_ = pixel_transformation_bundle_generate_transformer (new_adjustments);
				_pixel_transformer_unref0 (self->priv->transformer);
				self->priv->transformer = _tmp10_;
			} else {
				PixelTransformationBundle* _tmp24_;
				{
					GeeIterator* _transformation_it = NULL;
					GeeIterable* _tmp11_;
					GeeIterable* _tmp12_;
					GeeIterator* _tmp13_;
					GeeIterator* _tmp14_;
					_tmp11_ = pixel_transformation_bundle_get_transformations (new_adjustments);
					_tmp12_ = _tmp11_;
					_tmp13_ = gee_iterable_iterator (_tmp12_);
					_tmp14_ = _tmp13_;
					_g_object_unref0 (_tmp12_);
					_transformation_it = _tmp14_;
					while (TRUE) {
						GeeIterator* _tmp15_;
						PixelTransformation* transformation = NULL;
						GeeIterator* _tmp16_;
						gpointer _tmp17_;
						PixelTransformer* _tmp18_;
						PixelTransformationBundle* _tmp19_;
						PixelTransformation* _tmp20_;
						PixelTransformation* _tmp21_;
						PixelTransformation* _tmp22_;
						PixelTransformation* _tmp23_;
						_tmp15_ = _transformation_it;
						if (!gee_iterator_next (_tmp15_)) {
							break;
						}
						_tmp16_ = _transformation_it;
						_tmp17_ = gee_iterator_get (_tmp16_);
						transformation = (PixelTransformation*) _tmp17_;
						_tmp18_ = self->priv->transformer;
						_tmp19_ = self->priv->adjustments;
						_tmp20_ = transformation;
						_tmp21_ = pixel_transformation_bundle_get_transformation (_tmp19_, pixel_transformation_get_transformation_type (_tmp20_));
						_tmp22_ = _tmp21_;
						_tmp23_ = transformation;
						pixel_transformer_replace_transformation (_tmp18_, _tmp22_, _tmp23_);
						_pixel_transformation_unref0 (_tmp22_);
						_pixel_transformation_unref0 (transformation);
					}
					_g_object_unref0 (_transformation_it);
				}
				_tmp24_ = pixel_transformation_bundle_copy (new_adjustments);
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
				self->priv->adjustments = _tmp24_;
			}
			_tmp25_ = map;
			committed = photo_set_transformation (self, _tmp25_);
		}
		__finally1:
		{
			PhotoRow* _tmp26_;
			_tmp26_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_key_value_map_unref0 (map);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (committed) {
		Alteration* _tmp27_;
		Alteration* _tmp28_;
		_tmp27_ = alteration_new ("image", "color-adjustments");
		_tmp28_ = _tmp27_;
		data_object_notify_altered ((DataObject*) self, _tmp28_);
		_alteration_unref0 (_tmp28_);
	}
	_key_value_map_unref0 (map);
}

static PhotoMetadata*
photo_real_get_metadata (PhotoSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	PhotoMetadata* result;
	self = (Photo*) base;
	{
		PhotoMetadata* _tmp0_ = NULL;
		PhotoFileReader* _tmp1_;
		PhotoFileReader* _tmp2_;
		PhotoMetadata* _tmp3_;
		PhotoMetadata* _tmp4_;
		PhotoMetadata* _tmp5_;
		_tmp1_ = photo_get_source_reader (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = photo_file_reader_read_metadata (_tmp2_, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_photo_file_adapter_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_media_metadata_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning ("Photo.vala:2666: Unable to load metadata: %s", _tmp7_);
		result = NULL;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

PhotoMetadata*
photo_get_master_metadata (Photo* self,
                           GError** error)
{
	PhotoMetadata* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_;
	PhotoFileReader* _tmp2_;
	PhotoMetadata* _tmp3_;
	PhotoMetadata* _tmp4_;
	PhotoMetadata* _tmp5_;
	GError* _inner_error0_ = NULL;
	PhotoMetadata* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = photo_get_master_reader (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = photo_file_reader_read_metadata (_tmp2_, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_photo_file_adapter_unref0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_media_metadata_unref0 (_tmp0_);
	return result;
}

PhotoMetadata*
photo_get_editable_metadata (Photo* self,
                             GError** error)
{
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_;
	PhotoMetadata* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_;
	GError* _inner_error0_ = NULL;
	PhotoMetadata* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = photo_get_editable_reader (self);
	reader = _tmp0_;
	_tmp2_ = reader;
	if (_tmp2_ != NULL) {
		PhotoFileReader* _tmp3_;
		PhotoMetadata* _tmp4_;
		_tmp3_ = reader;
		_tmp4_ = photo_file_reader_read_metadata (_tmp3_, &_inner_error0_);
		_media_metadata_unref0 (_tmp1_);
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_media_metadata_unref0 (_tmp1_);
			_photo_file_adapter_unref0 (reader);
			return NULL;
		}
	} else {
		_media_metadata_unref0 (_tmp1_);
		_tmp1_ = NULL;
	}
	result = _tmp1_;
	_photo_file_adapter_unref0 (reader);
	return result;
}

gboolean
photo_persist_master_metadata (Photo* self,
                               PhotoMetadata* metadata,
                               PhotoReimportMasterState** state,
                               GError** error)
{
	PhotoReimportMasterState* _vala_state = NULL;
	PhotoFileReader* master_reader = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoFileMetadataWriter* _tmp2_ = NULL;
	PhotoFileReader* _tmp3_;
	PhotoFileMetadataWriter* _tmp4_;
	gboolean _tmp7_ = FALSE;
	PhotoReimportMasterState* _tmp8_ = NULL;
	gboolean _tmp9_;
	PhotoReimportMasterState* _tmp11_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (metadata != NULL, FALSE);
	_photo_reimport_master_state_unref0 (_vala_state);
	_vala_state = NULL;
	_tmp0_ = photo_get_master_reader (self);
	master_reader = _tmp0_;
	_tmp1_ = master_reader;
	if (!photo_file_format_can_write_metadata (photo_file_adapter_get_file_format ((PhotoFileAdapter*) _tmp1_))) {
		result = FALSE;
		_photo_file_adapter_unref0 (master_reader);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_master_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp3_ = master_reader;
	_tmp4_ = photo_file_reader_create_metadata_writer (_tmp3_, &_inner_error0_);
	_tmp2_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (master_reader);
		_photo_reimport_master_state_unref0 (_vala_state);
		return _tmp5_;
	}
	photo_file_metadata_writer_write_metadata (_tmp2_, metadata, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (_tmp2_);
		_photo_file_adapter_unref0 (master_reader);
		_photo_reimport_master_state_unref0 (_vala_state);
		return _tmp6_;
	}
	_tmp9_ = photo_prepare_for_reimport_master (self, &_tmp8_, &_inner_error0_);
	_photo_reimport_master_state_unref0 (_vala_state);
	_vala_state = _tmp8_;
	_tmp7_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (_tmp2_);
		_photo_file_adapter_unref0 (master_reader);
		_photo_reimport_master_state_unref0 (_vala_state);
		return _tmp10_;
	}
	if (!_tmp7_) {
		result = FALSE;
		_photo_file_adapter_unref0 (_tmp2_);
		_photo_file_adapter_unref0 (master_reader);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_master_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp11_ = _vala_state;
	G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl)->metadata_only = TRUE;
	result = TRUE;
	_photo_file_adapter_unref0 (_tmp2_);
	_photo_file_adapter_unref0 (master_reader);
	if (state) {
		*state = _vala_state;
	} else {
		_photo_reimport_master_state_unref0 (_vala_state);
	}
	return result;
}

void
photo_finish_update_master_metadata (Photo* self,
                                     PhotoReimportMasterState* state,
                                     GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	photo_finish_reimport_master (self, state, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gboolean
photo_persist_editable_metadata (Photo* self,
                                 PhotoMetadata* metadata,
                                 PhotoReimportEditableState** state,
                                 GError** error)
{
	PhotoReimportEditableState* _vala_state = NULL;
	PhotoFileReader* editable_reader = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoFileReader* _tmp2_;
	PhotoFileMetadataWriter* _tmp3_ = NULL;
	PhotoFileReader* _tmp4_;
	PhotoFileMetadataWriter* _tmp5_;
	gboolean _tmp8_ = FALSE;
	PhotoReimportEditableState* _tmp9_ = NULL;
	gboolean _tmp10_;
	PhotoReimportEditableState* _tmp12_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (metadata != NULL, FALSE);
	_photo_reimport_editable_state_unref0 (_vala_state);
	_vala_state = NULL;
	_tmp0_ = photo_get_editable_reader (self);
	editable_reader = _tmp0_;
	_tmp1_ = editable_reader;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_photo_file_adapter_unref0 (editable_reader);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_editable_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp2_ = editable_reader;
	if (!photo_file_format_can_write_metadata (photo_file_adapter_get_file_format ((PhotoFileAdapter*) _tmp2_))) {
		result = FALSE;
		_photo_file_adapter_unref0 (editable_reader);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_editable_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp4_ = editable_reader;
	_tmp5_ = photo_file_reader_create_metadata_writer (_tmp4_, &_inner_error0_);
	_tmp3_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (editable_reader);
		_photo_reimport_editable_state_unref0 (_vala_state);
		return _tmp6_;
	}
	photo_file_metadata_writer_write_metadata (_tmp3_, metadata, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (_tmp3_);
		_photo_file_adapter_unref0 (editable_reader);
		_photo_reimport_editable_state_unref0 (_vala_state);
		return _tmp7_;
	}
	_tmp10_ = photo_prepare_for_reimport_editable (self, &_tmp9_, &_inner_error0_);
	_photo_reimport_editable_state_unref0 (_vala_state);
	_vala_state = _tmp9_;
	_tmp8_ = _tmp10_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (_tmp3_);
		_photo_file_adapter_unref0 (editable_reader);
		_photo_reimport_editable_state_unref0 (_vala_state);
		return _tmp11_;
	}
	if (!_tmp8_) {
		result = FALSE;
		_photo_file_adapter_unref0 (_tmp3_);
		_photo_file_adapter_unref0 (editable_reader);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_editable_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp12_ = _vala_state;
	G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl)->metadata_only = TRUE;
	result = TRUE;
	_photo_file_adapter_unref0 (_tmp3_);
	_photo_file_adapter_unref0 (editable_reader);
	if (state) {
		*state = _vala_state;
	} else {
		_photo_reimport_editable_state_unref0 (_vala_state);
	}
	return result;
}

void
photo_finish_update_editable_metadata (Photo* self,
                                       PhotoReimportEditableState* state,
                                       GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	photo_finish_reimport_editable (self, state, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
photo_get_raw_dimensions (Photo* self,
                          Dimensions* result)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* _tmp1_;
			Dimensions _tmp2_;
			_tmp1_ = self->backing_photo_row;
			_tmp2_ = _tmp1_->dim;
			*result = _tmp2_;
			{
				PhotoRow* _tmp3_;
				_tmp3_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return;
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gboolean
photo_has_transformations (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp8_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			gboolean _tmp1_ = FALSE;
			PhotoRow* _tmp2_;
			BackingPhotoRow* _tmp3_;
			_tmp2_ = self->row;
			_tmp3_ = self->backing_photo_row;
			if (_tmp2_->orientation != _tmp3_->original_orientation) {
				_tmp1_ = TRUE;
			} else {
				PhotoRow* _tmp4_;
				GeeHashMap* _tmp5_;
				_tmp4_ = self->row;
				_tmp5_ = _tmp4_->transformations;
				_tmp1_ = _tmp5_ != NULL;
			}
			result = _tmp1_;
			{
				PhotoRow* _tmp6_;
				_tmp6_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
}

gboolean
photo_only_metadata_changed (Photo* self)
{
	MetadataDateTime* date_time = NULL;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	date_time = NULL;
	_tmp0_ = photo_source_get_metadata ((PhotoSource*) self);
	metadata = _tmp0_;
	_tmp1_ = metadata;
	if (_tmp1_ != NULL) {
		PhotoMetadata* _tmp2_;
		MetadataDateTime* _tmp3_;
		_tmp2_ = metadata;
		_tmp3_ = photo_metadata_get_exposure_date_time (_tmp2_);
		_metadata_date_time_unref0 (date_time);
		date_time = _tmp3_;
	}
	{
		PhotoRow* _tmp4_;
		gboolean _tmp17_ = FALSE;
		_tmp4_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			gboolean _tmp5_ = FALSE;
			PhotoRow* _tmp6_;
			GeeHashMap* _tmp7_;
			_tmp6_ = self->row;
			_tmp7_ = _tmp6_->transformations;
			if (_tmp7_ == NULL) {
				gboolean _tmp8_ = FALSE;
				PhotoRow* _tmp9_;
				BackingPhotoRow* _tmp10_;
				_tmp9_ = self->row;
				_tmp10_ = self->backing_photo_row;
				if (_tmp9_->orientation != _tmp10_->original_orientation) {
					_tmp8_ = TRUE;
				} else {
					gboolean _tmp11_ = FALSE;
					MetadataDateTime* _tmp12_;
					_tmp12_ = date_time;
					if (_tmp12_ != NULL) {
						PhotoRow* _tmp13_;
						MetadataDateTime* _tmp14_;
						_tmp13_ = self->row;
						_tmp14_ = date_time;
						_tmp11_ = _tmp13_->exposure_time != metadata_date_time_get_timestamp (_tmp14_);
					} else {
						_tmp11_ = FALSE;
					}
					_tmp8_ = _tmp11_;
				}
				_tmp5_ = _tmp8_;
			} else {
				_tmp5_ = FALSE;
			}
			result = _tmp5_;
			{
				PhotoRow* _tmp15_;
				_tmp15_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			_media_metadata_unref0 (metadata);
			_metadata_date_time_unref0 (date_time);
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp16_;
			_tmp16_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		_media_metadata_unref0 (metadata);
		_metadata_date_time_unref0 (date_time);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp17_;
	}
}

gboolean
photo_has_alterations (Photo* self)
{
	MetadataDateTime* date_time = NULL;
	gchar* title = NULL;
	gchar* comment = NULL;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* _tmp1_;
	MetadataDateTime* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	date_time = NULL;
	title = NULL;
	comment = NULL;
	_tmp0_ = photo_source_get_metadata ((PhotoSource*) self);
	metadata = _tmp0_;
	_tmp1_ = metadata;
	if (_tmp1_ != NULL) {
		PhotoMetadata* _tmp2_;
		MetadataDateTime* _tmp3_;
		PhotoMetadata* _tmp4_;
		gchar* _tmp5_;
		PhotoMetadata* _tmp6_;
		gchar* _tmp7_;
		_tmp2_ = metadata;
		_tmp3_ = photo_metadata_get_exposure_date_time (_tmp2_);
		_metadata_date_time_unref0 (date_time);
		date_time = _tmp3_;
		_tmp4_ = metadata;
		_tmp5_ = media_metadata_get_title ((MediaMetadata*) _tmp4_);
		_g_free0 (title);
		title = _tmp5_;
		_tmp6_ = metadata;
		_tmp7_ = media_metadata_get_comment ((MediaMetadata*) _tmp6_);
		_g_free0 (comment);
		comment = _tmp7_;
	}
	_tmp8_ = date_time;
	if (_tmp8_ == NULL) {
		{
			PhotoRow* _tmp9_;
			_tmp9_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				BackingPhotoRow* _tmp10_;
				PhotoRow* _tmp11_;
				_tmp10_ = self->backing_photo_row;
				_tmp11_ = self->row;
				if (_tmp10_->timestamp != _tmp11_->exposure_time) {
					result = TRUE;
					{
						PhotoRow* _tmp12_;
						_tmp12_ = self->row;
						g_rec_mutex_unlock (&self->priv->__lock_row);
					}
					_media_metadata_unref0 (metadata);
					_g_free0 (comment);
					_g_free0 (title);
					_metadata_date_time_unref0 (date_time);
					return result;
				}
			}
			__finally0:
			{
				PhotoRow* _tmp13_;
				_tmp13_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp14_ = FALSE;
				_media_metadata_unref0 (metadata);
				_g_free0 (comment);
				_g_free0 (title);
				_metadata_date_time_unref0 (date_time);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp14_;
			}
		}
	}
	{
		PhotoRow* _tmp15_;
		gboolean _tmp36_ = FALSE;
		_tmp15_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			PhotoRow* _tmp20_;
			GeeHashMap* _tmp21_;
			_tmp20_ = self->row;
			_tmp21_ = _tmp20_->transformations;
			if (_tmp21_ != NULL) {
				_tmp19_ = TRUE;
			} else {
				PhotoRow* _tmp22_;
				BackingPhotoRow* _tmp23_;
				_tmp22_ = self->row;
				_tmp23_ = self->backing_photo_row;
				_tmp19_ = _tmp22_->orientation != _tmp23_->original_orientation;
			}
			if (_tmp19_) {
				_tmp18_ = TRUE;
			} else {
				gboolean _tmp24_ = FALSE;
				MetadataDateTime* _tmp25_;
				_tmp25_ = date_time;
				if (_tmp25_ != NULL) {
					PhotoRow* _tmp26_;
					MetadataDateTime* _tmp27_;
					_tmp26_ = self->row;
					_tmp27_ = date_time;
					_tmp24_ = _tmp26_->exposure_time != metadata_date_time_get_timestamp (_tmp27_);
				} else {
					_tmp24_ = FALSE;
				}
				_tmp18_ = _tmp24_;
			}
			if (_tmp18_) {
				_tmp17_ = TRUE;
			} else {
				gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				_tmp28_ = media_source_get_comment ((MediaSource*) self);
				_tmp29_ = _tmp28_;
				_tmp30_ = comment;
				_tmp17_ = g_strcmp0 (_tmp29_, _tmp30_) != 0;
				_g_free0 (_tmp29_);
			}
			if (_tmp17_) {
				_tmp16_ = TRUE;
			} else {
				gchar* _tmp31_;
				gchar* _tmp32_;
				const gchar* _tmp33_;
				_tmp31_ = media_source_get_title ((MediaSource*) self);
				_tmp32_ = _tmp31_;
				_tmp33_ = title;
				_tmp16_ = g_strcmp0 (_tmp32_, _tmp33_) != 0;
				_g_free0 (_tmp32_);
			}
			result = _tmp16_;
			{
				PhotoRow* _tmp34_;
				_tmp34_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			_media_metadata_unref0 (metadata);
			_g_free0 (comment);
			_g_free0 (title);
			_metadata_date_time_unref0 (date_time);
			return result;
		}
		__finally1:
		{
			PhotoRow* _tmp35_;
			_tmp35_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		_media_metadata_unref0 (metadata);
		_g_free0 (comment);
		_g_free0 (title);
		_metadata_date_time_unref0 (date_time);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp36_;
	}
}

PhotoTransformationState*
photo_save_transformation_state (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoTransformationState* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PixelTransformer* _tmp1_ = NULL;
			PixelTransformer* _tmp2_;
			PixelTransformationBundle* _tmp5_ = NULL;
			PixelTransformationBundle* _tmp6_;
			PhotoRow* _tmp9_;
			PhotoRow* _tmp10_;
			GeeHashMap* _tmp11_;
			PhotoRow* _tmp12_;
			GeeHashMap* _tmp13_;
			PhotoRow* _tmp14_;
			PhotoPhotoTransformationStateImpl* _tmp15_;
			_tmp2_ = self->priv->transformer;
			if (_tmp2_ != NULL) {
				PixelTransformer* _tmp3_;
				PixelTransformer* _tmp4_;
				_tmp3_ = self->priv->transformer;
				_tmp4_ = pixel_transformer_copy (_tmp3_);
				_pixel_transformer_unref0 (_tmp1_);
				_tmp1_ = _tmp4_;
			} else {
				_pixel_transformer_unref0 (_tmp1_);
				_tmp1_ = NULL;
			}
			_tmp6_ = self->priv->adjustments;
			if (_tmp6_ != NULL) {
				PixelTransformationBundle* _tmp7_;
				PixelTransformationBundle* _tmp8_;
				_tmp7_ = self->priv->adjustments;
				_tmp8_ = pixel_transformation_bundle_copy (_tmp7_);
				_pixel_transformation_bundle_unref0 (_tmp5_);
				_tmp5_ = _tmp8_;
			} else {
				_pixel_transformation_bundle_unref0 (_tmp5_);
				_tmp5_ = NULL;
			}
			_tmp9_ = self->row;
			_tmp10_ = self->row;
			_tmp11_ = _tmp10_->transformations;
			_tmp12_ = self->row;
			_tmp13_ = _tmp12_->original_transforms;
			_tmp14_ = self->row;
			_tmp15_ = photo_photo_transformation_state_impl_new (self, _tmp9_->orientation, _tmp11_, _tmp1_, _tmp5_, _tmp13_, _tmp14_->enhanced);
			result = (PhotoTransformationState*) _tmp15_;
			_pixel_transformation_bundle_unref0 (_tmp5_);
			_pixel_transformer_unref0 (_tmp1_);
			{
				PhotoRow* _tmp16_;
				_tmp16_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp17_;
			_tmp17_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gpointer
_pixel_transformer_ref0 (gpointer self)
{
	return self ? pixel_transformer_ref (self) : NULL;
}

static gpointer
_pixel_transformation_bundle_ref0 (gpointer self)
{
	return self ? pixel_transformation_bundle_ref (self) : NULL;
}

gboolean
photo_load_transformation_state (Photo* self,
                                 PhotoTransformationState* state)
{
	PhotoPhotoTransformationStateImpl* state_impl = NULL;
	PhotoPhotoTransformationStateImpl* _tmp0_;
	PhotoPhotoTransformationStateImpl* _tmp1_;
	Orientation saved_orientation = 0;
	PhotoPhotoTransformationStateImpl* _tmp2_;
	gboolean saved_enhanced = FALSE;
	PhotoPhotoTransformationStateImpl* _tmp3_;
	GeeHashMap* saved_transformations = NULL;
	PhotoPhotoTransformationStateImpl* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* saved_original_transformations = NULL;
	PhotoPhotoTransformationStateImpl* _tmp6_;
	GeeHashMap* _tmp7_;
	PixelTransformer* saved_transformer = NULL;
	PhotoPhotoTransformationStateImpl* _tmp8_;
	PixelTransformer* _tmp9_;
	PixelTransformationBundle* saved_adjustments = NULL;
	PhotoPhotoTransformationStateImpl* _tmp10_;
	PixelTransformationBundle* _tmp11_;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL (state) ? ((PhotoPhotoTransformationStateImpl*) state) : NULL);
	state_impl = _tmp0_;
	_tmp1_ = state_impl;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (state_impl);
		return result;
	}
	_tmp2_ = state_impl;
	saved_orientation = photo_photo_transformation_state_impl_get_orientation (_tmp2_);
	_tmp3_ = state_impl;
	saved_enhanced = photo_photo_transformation_state_impl_get_enhanced (_tmp3_);
	_tmp4_ = state_impl;
	_tmp5_ = photo_photo_transformation_state_impl_get_transformations (_tmp4_);
	saved_transformations = _tmp5_;
	_tmp6_ = state_impl;
	_tmp7_ = photo_photo_transformation_state_impl_get_original_transformations (_tmp6_);
	saved_original_transformations = _tmp7_;
	_tmp8_ = state_impl;
	_tmp9_ = photo_photo_transformation_state_impl_get_transformer (_tmp8_);
	saved_transformer = _tmp9_;
	_tmp10_ = state_impl;
	_tmp11_ = photo_photo_transformation_state_impl_get_color_adjustments (_tmp10_);
	saved_adjustments = _tmp11_;
	{
		PhotoRow* _tmp12_;
		_tmp12_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoTable* _tmp13_;
			PhotoTable* _tmp14_;
			PhotoRow* _tmp15_;
			PhotoID _tmp16_;
			GeeHashMap* _tmp17_;
			GeeHashMap* _tmp18_;
			_tmp13_ = photo_table_get_instance ();
			_tmp14_ = _tmp13_;
			_tmp15_ = self->row;
			_tmp16_ = _tmp15_->photo_id;
			_tmp17_ = saved_transformations;
			_tmp18_ = saved_transformations;
			committed = photo_table_set_transformation_state (_tmp14_, &_tmp16_, saved_orientation, _tmp17_, _tmp18_, saved_enhanced);
			_database_table_unref0 (_tmp14_);
			if (committed) {
				PhotoRow* _tmp19_;
				PhotoRow* _tmp20_;
				GeeHashMap* _tmp21_;
				GeeHashMap* _tmp22_;
				PhotoRow* _tmp23_;
				GeeHashMap* _tmp24_;
				GeeHashMap* _tmp25_;
				PhotoRow* _tmp26_;
				PixelTransformer* _tmp27_;
				PixelTransformer* _tmp28_;
				PixelTransformationBundle* _tmp29_;
				PixelTransformationBundle* _tmp30_;
				_tmp19_ = self->row;
				_tmp19_->orientation = saved_orientation;
				_tmp20_ = self->row;
				_tmp21_ = saved_transformations;
				_tmp22_ = _g_object_ref0 (_tmp21_);
				_g_object_unref0 (_tmp20_->transformations);
				_tmp20_->transformations = _tmp22_;
				_tmp23_ = self->row;
				_tmp24_ = saved_original_transformations;
				_tmp25_ = _g_object_ref0 (_tmp24_);
				_g_object_unref0 (_tmp23_->original_transforms);
				_tmp23_->original_transforms = _tmp25_;
				_tmp26_ = self->row;
				_tmp26_->enhanced = saved_enhanced;
				_tmp27_ = saved_transformer;
				_tmp28_ = _pixel_transformer_ref0 (_tmp27_);
				_pixel_transformer_unref0 (self->priv->transformer);
				self->priv->transformer = _tmp28_;
				_tmp29_ = saved_adjustments;
				_tmp30_ = _pixel_transformation_bundle_ref0 (_tmp29_);
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
				self->priv->adjustments = _tmp30_;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp31_;
			_tmp31_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp32_ = FALSE;
			_pixel_transformation_bundle_unref0 (saved_adjustments);
			_pixel_transformer_unref0 (saved_transformer);
			_g_object_unref0 (saved_original_transformations);
			_g_object_unref0 (saved_transformations);
			_g_object_unref0 (state_impl);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp32_;
		}
	}
	if (committed) {
		Alteration* _tmp33_;
		Alteration* _tmp34_;
		_tmp33_ = alteration_new ("image", "transformation-state");
		_tmp34_ = _tmp33_;
		data_object_notify_altered ((DataObject*) self, _tmp34_);
		_alteration_unref0 (_tmp34_);
	}
	result = committed;
	_pixel_transformation_bundle_unref0 (saved_adjustments);
	_pixel_transformer_unref0 (saved_transformer);
	_g_object_unref0 (saved_original_transformations);
	_g_object_unref0 (saved_transformations);
	_g_object_unref0 (state_impl);
	return result;
}

void
photo_remove_all_transformations (Photo* self)
{
	g_return_if_fail (self != NULL);
	photo_internal_remove_all_transformations (self, TRUE);
}

static void
photo_internal_remove_all_transformations (Photo* self,
                                           gboolean notify)
{
	gboolean is_altered = FALSE;
	gboolean _tmp17_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	is_altered = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoTable* _tmp1_;
			PhotoTable* _tmp2_;
			PhotoRow* _tmp3_;
			PhotoID _tmp4_;
			PhotoRow* _tmp5_;
			PhotoRow* _tmp6_;
			PhotoRow* _tmp7_;
			BackingPhotoRow* _tmp8_;
			_tmp1_ = photo_table_get_instance ();
			_tmp2_ = _tmp1_;
			_tmp3_ = self->row;
			_tmp4_ = _tmp3_->photo_id;
			is_altered = photo_table_remove_all_transformations (_tmp2_, &_tmp4_);
			_database_table_unref0 (_tmp2_);
			_tmp5_ = self->row;
			_g_object_unref0 (_tmp5_->transformations);
			_tmp5_->transformations = NULL;
			_tmp6_ = self->row;
			_tmp6_->enhanced = FALSE;
			_pixel_transformer_unref0 (self->priv->transformer);
			self->priv->transformer = NULL;
			_pixel_transformation_bundle_unref0 (self->priv->adjustments);
			self->priv->adjustments = NULL;
			_tmp7_ = self->row;
			_tmp8_ = self->backing_photo_row;
			if (_tmp7_->orientation != _tmp8_->original_orientation) {
				PhotoTable* _tmp9_;
				PhotoTable* _tmp10_;
				PhotoRow* _tmp11_;
				PhotoID _tmp12_;
				BackingPhotoRow* _tmp13_;
				PhotoRow* _tmp14_;
				BackingPhotoRow* _tmp15_;
				_tmp9_ = photo_table_get_instance ();
				_tmp10_ = _tmp9_;
				_tmp11_ = self->row;
				_tmp12_ = _tmp11_->photo_id;
				_tmp13_ = self->backing_photo_row;
				photo_table_set_orientation (_tmp10_, &_tmp12_, _tmp13_->original_orientation);
				_database_table_unref0 (_tmp10_);
				_tmp14_ = self->row;
				_tmp15_ = self->backing_photo_row;
				_tmp14_->orientation = _tmp15_->original_orientation;
				is_altered = TRUE;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp16_;
			_tmp16_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (is_altered) {
		_tmp17_ = notify;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		Alteration* _tmp18_;
		Alteration* _tmp19_;
		_tmp18_ = alteration_new ("image", "revert");
		_tmp19_ = _tmp18_;
		data_object_notify_altered ((DataObject*) self, _tmp19_);
		_alteration_unref0 (_tmp19_);
	}
}

Orientation
photo_get_original_orientation (Photo* self)
{
	GError* _inner_error0_ = NULL;
	Orientation result;
	g_return_val_if_fail (self != NULL, 0);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* _tmp1_;
			_tmp1_ = self->backing_photo_row;
			result = _tmp1_->original_orientation;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
}

Orientation
photo_get_orientation (Photo* self)
{
	GError* _inner_error0_ = NULL;
	Orientation result;
	g_return_val_if_fail (self != NULL, 0);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			result = _tmp1_->orientation;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
}

gboolean
photo_set_orientation (Photo* self,
                       Orientation orientation)
{
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	committed = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			if (_tmp1_->orientation != orientation) {
				PhotoTable* _tmp2_;
				PhotoTable* _tmp3_;
				PhotoRow* _tmp4_;
				PhotoID _tmp5_;
				_tmp2_ = photo_table_get_instance ();
				_tmp3_ = _tmp2_;
				_tmp4_ = self->row;
				_tmp5_ = _tmp4_->photo_id;
				committed = photo_table_set_orientation (_tmp3_, &_tmp5_, orientation);
				_database_table_unref0 (_tmp3_);
				if (committed) {
					PhotoRow* _tmp6_;
					_tmp6_ = self->row;
					_tmp6_->orientation = orientation;
				}
			}
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp8_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
	}
	if (committed) {
		Alteration* _tmp9_;
		Alteration* _tmp10_;
		_tmp9_ = alteration_new ("image", "orientation");
		_tmp10_ = _tmp9_;
		data_object_notify_altered ((DataObject*) self, _tmp10_);
		_alteration_unref0 (_tmp10_);
	}
	result = committed;
	return result;
}

gboolean
photo_check_can_rotate (Photo* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->can_rotate_now;
	return result;
}

static void
photo_real_rotate (Photo* self,
                   Rotation rotation)
{
	GError* _inner_error0_ = NULL;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			photo_set_orientation (self, orientation_perform (photo_get_orientation (self), rotation));
		}
		__finally0:
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
photo_rotate (Photo* self,
              Rotation rotation)
{
	PhotoClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->rotate) {
		_klass_->rotate (self, rotation);
	}
}

static gboolean
photo_has_transformation (Photo* self,
                          const gchar* name)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp8_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			gboolean _tmp1_ = FALSE;
			PhotoRow* _tmp2_;
			GeeHashMap* _tmp3_;
			_tmp2_ = self->row;
			_tmp3_ = _tmp2_->transformations;
			if (_tmp3_ != NULL) {
				PhotoRow* _tmp4_;
				GeeHashMap* _tmp5_;
				_tmp4_ = self->row;
				_tmp5_ = _tmp4_->transformations;
				_tmp1_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, name);
			} else {
				_tmp1_ = FALSE;
			}
			result = _tmp1_;
			{
				PhotoRow* _tmp6_;
				_tmp6_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
}

static KeyValueMap*
photo_get_transformation (Photo* self,
                          const gchar* name)
{
	KeyValueMap* map = NULL;
	GError* _inner_error0_ = NULL;
	KeyValueMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	map = NULL;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			GeeHashMap* _tmp2_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->transformations;
			if (_tmp2_ != NULL) {
				PhotoRow* _tmp3_;
				GeeHashMap* _tmp4_;
				gpointer _tmp5_;
				KeyValueMap* _tmp6_;
				_tmp3_ = self->row;
				_tmp4_ = _tmp3_->transformations;
				_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, name);
				_key_value_map_unref0 (map);
				map = (KeyValueMap*) _tmp5_;
				_tmp6_ = map;
				if (_tmp6_ != NULL) {
					KeyValueMap* _tmp7_;
					KeyValueMap* _tmp8_;
					_tmp7_ = map;
					_tmp8_ = key_value_map_copy (_tmp7_);
					_key_value_map_unref0 (map);
					map = _tmp8_;
				}
			}
		}
		__finally0:
		{
			PhotoRow* _tmp9_;
			_tmp9_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_key_value_map_unref0 (map);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = map;
	return result;
}

static gboolean
photo_set_transformation (Photo* self,
                          KeyValueMap* trans)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (trans != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp16_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			GeeHashMap* _tmp2_;
			PhotoRow* _tmp5_;
			GeeHashMap* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			PhotoTable* _tmp9_;
			PhotoTable* _tmp10_;
			PhotoRow* _tmp11_;
			PhotoID _tmp12_;
			gboolean _tmp13_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->transformations;
			if (_tmp2_ == NULL) {
				PhotoRow* _tmp3_;
				GeeHashMap* _tmp4_;
				_tmp3_ = self->row;
				_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_KEY_VALUE_MAP, (GBoxedCopyFunc) key_value_map_ref, (GDestroyNotify) key_value_map_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
				_g_object_unref0 (_tmp3_->transformations);
				_tmp3_->transformations = _tmp4_;
			}
			_tmp5_ = self->row;
			_tmp6_ = _tmp5_->transformations;
			_tmp7_ = key_value_map_get_group (trans);
			_tmp8_ = _tmp7_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _tmp8_, trans);
			_g_free0 (_tmp8_);
			_tmp9_ = photo_table_get_instance ();
			_tmp10_ = _tmp9_;
			_tmp11_ = self->row;
			_tmp12_ = _tmp11_->photo_id;
			_tmp13_ = photo_table_set_transformation (_tmp10_, &_tmp12_, trans);
			_database_table_unref0 (_tmp10_);
			result = _tmp13_;
			{
				PhotoRow* _tmp14_;
				_tmp14_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp15_;
			_tmp15_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp16_;
	}
}

static gboolean
photo_set_original_transforms (Photo* self,
                               KeyValueMap* trans)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (trans != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp16_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			GeeHashMap* _tmp2_;
			PhotoRow* _tmp5_;
			GeeHashMap* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			PhotoTable* _tmp9_;
			PhotoTable* _tmp10_;
			PhotoRow* _tmp11_;
			PhotoID _tmp12_;
			gboolean _tmp13_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->original_transforms;
			if (_tmp2_ == NULL) {
				PhotoRow* _tmp3_;
				GeeHashMap* _tmp4_;
				_tmp3_ = self->row;
				_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_KEY_VALUE_MAP, (GBoxedCopyFunc) key_value_map_ref, (GDestroyNotify) key_value_map_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
				_g_object_unref0 (_tmp3_->original_transforms);
				_tmp3_->original_transforms = _tmp4_;
			}
			_tmp5_ = self->row;
			_tmp6_ = _tmp5_->original_transforms;
			_tmp7_ = key_value_map_get_group (trans);
			_tmp8_ = _tmp7_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _tmp8_, trans);
			_g_free0 (_tmp8_);
			_tmp9_ = photo_table_get_instance ();
			_tmp10_ = _tmp9_;
			_tmp11_ = self->row;
			_tmp12_ = _tmp11_->photo_id;
			_tmp13_ = photo_table_set_original_transforms (_tmp10_, &_tmp12_, trans);
			_database_table_unref0 (_tmp10_);
			result = _tmp13_;
			{
				PhotoRow* _tmp14_;
				_tmp14_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp15_;
			_tmp15_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp16_;
	}
}

static gboolean
photo_clear_original_transforms (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp12_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			GeeHashMap* _tmp2_;
			PhotoTable* _tmp5_;
			PhotoTable* _tmp6_;
			PhotoRow* _tmp7_;
			PhotoID _tmp8_;
			gboolean _tmp9_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->original_transforms;
			if (_tmp2_ == NULL) {
				PhotoRow* _tmp3_;
				GeeHashMap* _tmp4_;
				_tmp3_ = self->row;
				_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_KEY_VALUE_MAP, (GBoxedCopyFunc) key_value_map_ref, (GDestroyNotify) key_value_map_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
				_g_object_unref0 (_tmp3_->original_transforms);
				_tmp3_->original_transforms = _tmp4_;
			}
			_tmp5_ = photo_table_get_instance ();
			_tmp6_ = _tmp5_;
			_tmp7_ = self->row;
			_tmp8_ = _tmp7_->photo_id;
			_tmp9_ = photo_table_set_original_transforms (_tmp6_, &_tmp8_, NULL);
			_database_table_unref0 (_tmp6_);
			result = _tmp9_;
			{
				PhotoRow* _tmp10_;
				_tmp10_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp11_;
			_tmp11_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp12_;
	}
}

static gboolean
photo_remove_transformation (Photo* self,
                             const gchar* name)
{
	gboolean altered_cache = FALSE;
	gboolean altered_persistent = FALSE;
	gboolean _tmp16_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			GeeHashMap* _tmp2_;
			PhotoTable* _tmp10_;
			PhotoTable* _tmp11_;
			PhotoRow* _tmp12_;
			PhotoID _tmp13_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->transformations;
			if (_tmp2_ != NULL) {
				PhotoRow* _tmp3_;
				GeeHashMap* _tmp4_;
				PhotoRow* _tmp5_;
				GeeHashMap* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				_tmp3_ = self->row;
				_tmp4_ = _tmp3_->transformations;
				altered_cache = gee_abstract_map_unset ((GeeAbstractMap*) _tmp4_, name, NULL);
				_tmp5_ = self->row;
				_tmp6_ = _tmp5_->transformations;
				_tmp7_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_ == 0) {
					PhotoRow* _tmp9_;
					_tmp9_ = self->row;
					_g_object_unref0 (_tmp9_->transformations);
					_tmp9_->transformations = NULL;
				}
			} else {
				altered_cache = FALSE;
			}
			_tmp10_ = photo_table_get_instance ();
			_tmp11_ = _tmp10_;
			_tmp12_ = self->row;
			_tmp13_ = _tmp12_->photo_id;
			altered_persistent = photo_table_remove_transformation (_tmp11_, &_tmp13_, name);
			_database_table_unref0 (_tmp11_);
		}
		__finally0:
		{
			PhotoRow* _tmp14_;
			_tmp14_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp15_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp15_;
		}
	}
	if (altered_cache) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = altered_persistent;
	}
	result = _tmp16_;
	return result;
}

gboolean
photo_has_crop (Photo* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = photo_has_transformation (self, "crop");
	return result;
}

gboolean
photo_get_raw_crop (Photo* self,
                    Box* crop)
{
	Box _vala_crop = {0};
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	gint left = 0;
	KeyValueMap* _tmp2_;
	gint top = 0;
	KeyValueMap* _tmp3_;
	gint right = 0;
	KeyValueMap* _tmp4_;
	gint bottom = 0;
	KeyValueMap* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	box_init (&_vala_crop, 0, 0, 0, 0);
	_tmp0_ = photo_get_transformation (self, "crop");
	map = _tmp0_;
	_tmp1_ = map;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_key_value_map_unref0 (map);
		if (crop) {
			*crop = _vala_crop;
		}
		return result;
	}
	_tmp2_ = map;
	left = key_value_map_get_int (_tmp2_, "left", -1);
	_tmp3_ = map;
	top = key_value_map_get_int (_tmp3_, "top", -1);
	_tmp4_ = map;
	right = key_value_map_get_int (_tmp4_, "right", -1);
	_tmp5_ = map;
	bottom = key_value_map_get_int (_tmp5_, "bottom", -1);
	if (left == -1) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = top == -1;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = right == -1;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = bottom == -1;
	}
	if (_tmp6_) {
		result = FALSE;
		_key_value_map_unref0 (map);
		if (crop) {
			*crop = _vala_crop;
		}
		return result;
	}
	box_init (&_vala_crop, left, top, right, bottom);
	result = TRUE;
	_key_value_map_unref0 (map);
	if (crop) {
		*crop = _vala_crop;
	}
	return result;
}

static void
photo_set_raw_crop (Photo* self,
                    Box* crop)
{
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	Box _tmp2_;
	KeyValueMap* _tmp3_;
	Box _tmp4_;
	KeyValueMap* _tmp5_;
	Box _tmp6_;
	KeyValueMap* _tmp7_;
	Box _tmp8_;
	KeyValueMap* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (crop != NULL);
	_tmp0_ = key_value_map_new ("crop");
	map = _tmp0_;
	_tmp1_ = map;
	_tmp2_ = *crop;
	key_value_map_set_int (_tmp1_, "left", _tmp2_.left);
	_tmp3_ = map;
	_tmp4_ = *crop;
	key_value_map_set_int (_tmp3_, "top", _tmp4_.top);
	_tmp5_ = map;
	_tmp6_ = *crop;
	key_value_map_set_int (_tmp5_, "right", _tmp6_.right);
	_tmp7_ = map;
	_tmp8_ = *crop;
	key_value_map_set_int (_tmp7_, "bottom", _tmp8_.bottom);
	_tmp9_ = map;
	if (photo_set_transformation (self, _tmp9_)) {
		Alteration* _tmp10_;
		Alteration* _tmp11_;
		_tmp10_ = alteration_new ("image", "crop");
		_tmp11_ = _tmp10_;
		data_object_notify_altered ((DataObject*) self, _tmp11_);
		_alteration_unref0 (_tmp11_);
	}
	_key_value_map_unref0 (map);
}

static gboolean
photo_get_raw_straighten (Photo* self,
                          gdouble* angle)
{
	gdouble _vala_angle = 0.0;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	KeyValueMap* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = photo_get_transformation (self, "straighten");
	map = _tmp0_;
	_tmp1_ = map;
	if (_tmp1_ == NULL) {
		_vala_angle = 0.0;
		result = FALSE;
		_key_value_map_unref0 (map);
		if (angle) {
			*angle = _vala_angle;
		}
		return result;
	}
	_tmp2_ = map;
	_vala_angle = key_value_map_get_double (_tmp2_, "angle", 0.0);
	result = TRUE;
	_key_value_map_unref0 (map);
	if (angle) {
		*angle = _vala_angle;
	}
	return result;
}

static void
photo_set_raw_straighten (Photo* self,
                          gdouble theta)
{
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	KeyValueMap* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = key_value_map_new ("straighten");
	map = _tmp0_;
	_tmp1_ = map;
	key_value_map_set_double (_tmp1_, "angle", theta);
	_tmp2_ = map;
	if (photo_set_transformation (self, _tmp2_)) {
		Alteration* _tmp3_;
		Alteration* _tmp4_;
		_tmp3_ = alteration_new ("image", "straighten");
		_tmp4_ = _tmp3_;
		data_object_notify_altered ((DataObject*) self, _tmp4_);
		_alteration_unref0 (_tmp4_);
	}
	_key_value_map_unref0 (map);
}

static EditingToolsRedeyeInstance*
photo_get_raw_redeye_instances (Photo* self,
                                gint* result_length1)
{
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	gint num_points = 0;
	KeyValueMap* _tmp4_;
	EditingToolsRedeyeInstance* res = NULL;
	EditingToolsRedeyeInstance* _tmp5_;
	gint res_length1;
	gint _res_size_;
	GdkPoint default_point = {0};
	GdkPoint _tmp6_ = {0};
	EditingToolsRedeyeInstance* _tmp29_;
	gint _tmp29__length1;
	EditingToolsRedeyeInstance* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = photo_get_transformation (self, "redeye");
	map = _tmp0_;
	_tmp1_ = map;
	if (_tmp1_ == NULL) {
		EditingToolsRedeyeInstance* _tmp2_;
		EditingToolsRedeyeInstance* _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = g_new0 (EditingToolsRedeyeInstance, 0);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		_key_value_map_unref0 (map);
		return result;
	}
	_tmp4_ = map;
	num_points = key_value_map_get_int (_tmp4_, "num_points", -1);
	_vala_assert (num_points > 0, "num_points > 0");
	_tmp5_ = g_new0 (EditingToolsRedeyeInstance, num_points);
	res = _tmp5_;
	res_length1 = num_points;
	_res_size_ = res_length1;
	_tmp6_.x = 0;
	default_point = _tmp6_;
	default_point.x = -1;
	default_point.y = -1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gchar* center_key = NULL;
				gchar* _tmp9_;
				gchar* radius_key = NULL;
				gchar* _tmp10_;
				EditingToolsRedeyeInstance* _tmp11_;
				gint _tmp11__length1;
				KeyValueMap* _tmp12_;
				const gchar* _tmp13_;
				GdkPoint _tmp14_;
				GdkPoint _tmp15_ = {0};
				EditingToolsRedeyeInstance* _tmp16_;
				gint _tmp16__length1;
				EditingToolsRedeyeInstance _tmp17_;
				GdkPoint _tmp18_;
				GdkPoint _tmp19_;
				EditingToolsRedeyeInstance* _tmp20_;
				gint _tmp20__length1;
				EditingToolsRedeyeInstance _tmp21_;
				GdkPoint _tmp22_;
				GdkPoint _tmp23_;
				EditingToolsRedeyeInstance* _tmp24_;
				gint _tmp24__length1;
				KeyValueMap* _tmp25_;
				const gchar* _tmp26_;
				EditingToolsRedeyeInstance* _tmp27_;
				gint _tmp27__length1;
				EditingToolsRedeyeInstance _tmp28_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				if (!(i < num_points)) {
					break;
				}
				_tmp9_ = g_strdup_printf ("center%d", i);
				center_key = _tmp9_;
				_tmp10_ = g_strdup_printf ("radius%d", i);
				radius_key = _tmp10_;
				_tmp11_ = res;
				_tmp11__length1 = res_length1;
				_tmp12_ = map;
				_tmp13_ = center_key;
				_tmp14_ = default_point;
				key_value_map_get_point (_tmp12_, _tmp13_, &_tmp14_, &_tmp15_);
				_tmp11_[i].center = _tmp15_;
				_tmp16_ = res;
				_tmp16__length1 = res_length1;
				_tmp17_ = _tmp16_[i];
				_tmp18_ = _tmp17_.center;
				_tmp19_ = default_point;
				_vala_assert (_tmp18_.x != _tmp19_.x, "res[i].center.x != default_point.x");
				_tmp20_ = res;
				_tmp20__length1 = res_length1;
				_tmp21_ = _tmp20_[i];
				_tmp22_ = _tmp21_.center;
				_tmp23_ = default_point;
				_vala_assert (_tmp22_.y != _tmp23_.y, "res[i].center.y != default_point.y");
				_tmp24_ = res;
				_tmp24__length1 = res_length1;
				_tmp25_ = map;
				_tmp26_ = radius_key;
				_tmp24_[i].radius = key_value_map_get_int (_tmp25_, _tmp26_, -1);
				_tmp27_ = res;
				_tmp27__length1 = res_length1;
				_tmp28_ = _tmp27_[i];
				_vala_assert (_tmp28_.radius != -1, "res[i].radius != -1");
				_g_free0 (radius_key);
				_g_free0 (center_key);
			}
		}
	}
	_tmp29_ = res;
	_tmp29__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp29__length1;
	}
	result = _tmp29_;
	_key_value_map_unref0 (map);
	return result;
}

gboolean
photo_has_redeye_transformations (Photo* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = photo_has_transformation (self, "redeye");
	return result;
}

void
photo_add_redeye_instance (Photo* self,
                           EditingToolsRedeyeInstance* redeye)
{
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	gint num_points = 0;
	KeyValueMap* _tmp4_;
	gint _tmp5_;
	gchar* radius_key = NULL;
	gchar* _tmp6_;
	gchar* center_key = NULL;
	gchar* _tmp7_;
	KeyValueMap* _tmp8_;
	const gchar* _tmp9_;
	EditingToolsRedeyeInstance _tmp10_;
	KeyValueMap* _tmp11_;
	const gchar* _tmp12_;
	EditingToolsRedeyeInstance _tmp13_;
	GdkPoint _tmp14_;
	KeyValueMap* _tmp15_;
	KeyValueMap* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (redeye != NULL);
	_tmp0_ = photo_get_transformation (self, "redeye");
	map = _tmp0_;
	_tmp1_ = map;
	if (_tmp1_ == NULL) {
		KeyValueMap* _tmp2_;
		KeyValueMap* _tmp3_;
		_tmp2_ = key_value_map_new ("redeye");
		_key_value_map_unref0 (map);
		map = _tmp2_;
		_tmp3_ = map;
		key_value_map_set_int (_tmp3_, "num_points", 0);
	}
	_tmp4_ = map;
	num_points = key_value_map_get_int (_tmp4_, "num_points", -1);
	_vala_assert (num_points >= 0, "num_points >= 0");
	_tmp5_ = num_points;
	num_points = _tmp5_ + 1;
	_tmp6_ = g_strdup_printf ("radius%d", num_points - 1);
	radius_key = _tmp6_;
	_tmp7_ = g_strdup_printf ("center%d", num_points - 1);
	center_key = _tmp7_;
	_tmp8_ = map;
	_tmp9_ = radius_key;
	_tmp10_ = *redeye;
	key_value_map_set_int (_tmp8_, _tmp9_, _tmp10_.radius);
	_tmp11_ = map;
	_tmp12_ = center_key;
	_tmp13_ = *redeye;
	_tmp14_ = _tmp13_.center;
	key_value_map_set_point (_tmp11_, _tmp12_, &_tmp14_);
	_tmp15_ = map;
	key_value_map_set_int (_tmp15_, "num_points", num_points);
	_tmp16_ = map;
	if (photo_set_transformation (self, _tmp16_)) {
		Alteration* _tmp17_;
		Alteration* _tmp18_;
		_tmp17_ = alteration_new ("image", "redeye");
		_tmp18_ = _tmp17_;
		data_object_notify_altered ((DataObject*) self, _tmp18_);
		_alteration_unref0 (_tmp18_);
	}
	_g_free0 (center_key);
	_g_free0 (radius_key);
	_key_value_map_unref0 (map);
}

static gboolean
photo_calculate_pixbuf_dimensions (Photo* self,
                                   Scaling* scaling,
                                   PhotoException exceptions,
                                   Dimensions* scaled_image,
                                   Dimensions* scaled_to_viewport)
{
	Dimensions _vala_scaled_image = {0};
	Dimensions _vala_scaled_to_viewport = {0};
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (scaling != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp7_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			Scaling _tmp1_;
			Dimensions _tmp2_ = {0};
			Dimensions _tmp3_ = {0};
			gboolean _tmp4_;
			_tmp1_ = *scaling;
			_tmp4_ = photo_locked_calculate_pixbuf_dimensions (self, &_tmp1_, exceptions, &_tmp2_, &_tmp3_);
			_vala_scaled_image = _tmp2_;
			_vala_scaled_to_viewport = _tmp3_;
			result = _tmp4_;
			{
				PhotoRow* _tmp5_;
				_tmp5_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (scaled_image) {
				*scaled_image = _vala_scaled_image;
			}
			if (scaled_to_viewport) {
				*scaled_to_viewport = _vala_scaled_to_viewport;
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp6_;
			_tmp6_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
}

static gboolean
photo_locked_calculate_pixbuf_dimensions (Photo* self,
                                          Scaling* scaling,
                                          PhotoException exceptions,
                                          Dimensions* scaled_image,
                                          Dimensions* scaled_to_viewport)
{
	Dimensions _vala_scaled_image = {0};
	Dimensions _vala_scaled_to_viewport = {0};
	Dimensions raw = {0};
	Dimensions _tmp0_ = {0};
	Orientation orientation = 0;
	gboolean _tmp31_ = FALSE;
	Dimensions _tmp32_;
	Dimensions _tmp33_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (scaling != NULL, FALSE);
	photo_get_raw_dimensions (self, &_tmp0_);
	raw = _tmp0_;
	if (scaling_is_unscaled (scaling)) {
		Dimensions _tmp1_;
		Dimensions _tmp2_;
		_tmp1_ = raw;
		_vala_scaled_image = _tmp1_;
		_tmp2_ = raw;
		_vala_scaled_to_viewport = _tmp2_;
		result = FALSE;
		if (scaled_image) {
			*scaled_image = _vala_scaled_image;
		}
		if (scaled_to_viewport) {
			*scaled_to_viewport = _vala_scaled_to_viewport;
		}
		return result;
	}
	orientation = photo_get_orientation (self);
	dimensions_init (&_vala_scaled_image, 0, 0);
	dimensions_init (&_vala_scaled_to_viewport, 0, 0);
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_CROP)) {
		Box crop = {0};
		Box _tmp3_ = {0};
		gboolean _tmp4_;
		_tmp4_ = photo_get_raw_crop (self, &_tmp3_);
		crop = _tmp3_;
		if (_tmp4_) {
			Dimensions rotated_raw = {0};
			Dimensions _tmp5_;
			Box scaled_crop = {0};
			Dimensions _tmp11_ = {0};
			Dimensions _tmp12_ = {0};
			Box _tmp13_ = {0};
			Dimensions _tmp14_ = {0};
			gboolean _tmp15_ = FALSE;
			Dimensions _tmp18_ = {0};
			Dimensions _tmp19_ = {0};
			Dimensions _tmp20_ = {0};
			_tmp5_ = raw;
			rotated_raw = _tmp5_;
			if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
				Dimensions _tmp6_;
				Box _tmp7_;
				Box _tmp8_ = {0};
				Dimensions _tmp9_;
				Dimensions _tmp10_ = {0};
				_tmp6_ = raw;
				_tmp7_ = crop;
				orientation_rotate_box (orientation, &_tmp6_, &_tmp7_, &_tmp8_);
				crop = _tmp8_;
				_tmp9_ = raw;
				orientation_rotate_dimensions (orientation, &_tmp9_, &_tmp10_);
				rotated_raw = _tmp10_;
			}
			box_get_dimensions (&crop, &_tmp11_);
			scaling_get_scaled_dimensions (scaling, &_tmp11_, &_tmp12_);
			box_get_scaled (&crop, &_tmp12_, &_tmp13_);
			scaled_crop = _tmp13_;
			box_get_dimensions (&scaled_crop, &_tmp14_);
			_vala_scaled_to_viewport = _tmp14_;
			if (box_get_width (&crop) <= box_get_width (&scaled_crop)) {
				_tmp15_ = box_get_height (&crop) <= box_get_height (&scaled_crop);
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				Dimensions _tmp16_;
				Dimensions _tmp17_ = {0};
				_tmp16_ = raw;
				_vala_scaled_image = _tmp16_;
				box_get_dimensions (&crop, &_tmp17_);
				_vala_scaled_to_viewport = _tmp17_;
				result = FALSE;
				if (scaled_image) {
					*scaled_image = _vala_scaled_image;
				}
				if (scaled_to_viewport) {
					*scaled_to_viewport = _vala_scaled_to_viewport;
				}
				return result;
			}
			box_get_dimensions (&crop, &_tmp18_);
			box_get_dimensions (&scaled_crop, &_tmp19_);
			dimensions_get_scaled_similar (&rotated_raw, &_tmp18_, &_tmp19_, &_tmp20_);
			_vala_scaled_image = _tmp20_;
			if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
				Dimensions _tmp21_;
				Dimensions _tmp22_ = {0};
				_tmp21_ = _vala_scaled_image;
				orientation_derotate_dimensions (orientation, &_tmp21_, &_tmp22_);
				_vala_scaled_image = _tmp22_;
			}
		}
	}
	if (!dimensions_has_area (&_vala_scaled_image)) {
		Dimensions rotated_raw = {0};
		Dimensions _tmp23_;
		Dimensions _tmp26_;
		Dimensions _tmp27_ = {0};
		Dimensions _tmp28_;
		_tmp23_ = raw;
		rotated_raw = _tmp23_;
		if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
			Dimensions _tmp24_;
			Dimensions _tmp25_ = {0};
			_tmp24_ = raw;
			orientation_rotate_dimensions (orientation, &_tmp24_, &_tmp25_);
			rotated_raw = _tmp25_;
		}
		_tmp26_ = rotated_raw;
		scaling_get_scaled_dimensions (scaling, &_tmp26_, &_tmp27_);
		_vala_scaled_image = _tmp27_;
		_tmp28_ = _vala_scaled_image;
		_vala_scaled_to_viewport = _tmp28_;
		if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
			Dimensions _tmp29_;
			Dimensions _tmp30_ = {0};
			_tmp29_ = _vala_scaled_image;
			orientation_derotate_dimensions (orientation, &_tmp29_, &_tmp30_);
			_vala_scaled_image = _tmp30_;
		}
	}
	_tmp32_ = _vala_scaled_image;
	_tmp33_ = raw;
	if (_tmp32_.width >= _tmp33_.width) {
		Dimensions _tmp34_;
		Dimensions _tmp35_;
		_tmp34_ = _vala_scaled_image;
		_tmp35_ = raw;
		_tmp31_ = _tmp34_.height >= _tmp35_.height;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		Dimensions _tmp36_;
		_tmp36_ = raw;
		_vala_scaled_image = _tmp36_;
		result = FALSE;
		if (scaled_image) {
			*scaled_image = _vala_scaled_image;
		}
		if (scaled_to_viewport) {
			*scaled_to_viewport = _vala_scaled_to_viewport;
		}
		return result;
	}
	_vala_assert (dimensions_has_area (&_vala_scaled_image), "scaled_image.has_area ()");
	_vala_assert (dimensions_has_area (&_vala_scaled_to_viewport), "scaled_to_viewport.has_area ()");
	result = TRUE;
	if (scaled_image) {
		*scaled_image = _vala_scaled_image;
	}
	if (scaled_to_viewport) {
		*scaled_to_viewport = _vala_scaled_to_viewport;
	}
	return result;
}

static GdkPixbuf*
photo_load_raw_pixbuf (Photo* self,
                       Scaling* scaling,
                       PhotoException exceptions,
                       BackingFetchMode fetch_mode,
                       GError** error)
{
	PhotoFileReader* loader = NULL;
	PhotoFileReader* _tmp0_;
	Dimensions scaled_image = {0};
	Dimensions scaled_to_viewport = {0};
	gboolean is_scaled = FALSE;
	Scaling _tmp5_;
	Dimensions _tmp6_ = {0};
	Dimensions _tmp7_ = {0};
	gboolean _tmp8_;
	GdkPixbuf* pixbuf = NULL;
	PhotoFileReader* _tmp13_;
	Dimensions _tmp14_ = {0};
	Dimensions _tmp15_;
	GdkPixbuf* _tmp16_;
	GdkPixbuf* _tmp17_;
	Dimensions _tmp18_ = {0};
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp0_ = photo_get_backing_reader (self, fetch_mode);
	loader = _tmp0_;
	if (scaling_is_unscaled (scaling)) {
		GdkPixbuf* _tmp1_ = NULL;
		PhotoFileReader* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp2_ = loader;
		_tmp3_ = photo_file_reader_unscaled_read (_tmp2_, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_photo_file_adapter_unref0 (loader);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp4_;
		_g_object_unref0 (_tmp1_);
		_photo_file_adapter_unref0 (loader);
		return result;
	}
	_tmp5_ = *scaling;
	_tmp8_ = photo_calculate_pixbuf_dimensions (self, &_tmp5_, exceptions, &_tmp6_, &_tmp7_);
	scaled_image = _tmp6_;
	scaled_to_viewport = _tmp7_;
	is_scaled = _tmp8_;
	if (!is_scaled) {
		GdkPixbuf* _tmp9_ = NULL;
		PhotoFileReader* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
		_tmp10_ = loader;
		_tmp11_ = photo_file_reader_unscaled_read (_tmp10_, &_inner_error0_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_photo_file_adapter_unref0 (loader);
			return NULL;
		}
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		result = _tmp12_;
		_g_object_unref0 (_tmp9_);
		_photo_file_adapter_unref0 (loader);
		return result;
	}
	_tmp13_ = loader;
	photo_get_raw_dimensions (self, &_tmp14_);
	_tmp15_ = scaled_image;
	_tmp16_ = photo_file_reader_scaled_read (_tmp13_, &_tmp14_, &_tmp15_, &_inner_error0_);
	pixbuf = _tmp16_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (loader);
		return NULL;
	}
	_tmp17_ = pixbuf;
	dimensions_for_pixbuf (_tmp17_, &_tmp18_);
	_vala_assert (dimensions_approx_equals (&scaled_image, &_tmp18_, PHOTO_SCALING_FUDGE), "scaled_image.approx_equals (Dimensions.for_pixbuf (pixbuf), SCALING_FUDGE)");
	result = pixbuf;
	_photo_file_adapter_unref0 (loader);
	return result;
}

GdkPixbuf*
photo_get_master_pixbuf (Photo* self,
                         Scaling* scaling,
                         gboolean rotate,
                         GError** error)
{
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp1_ = *scaling;
	_tmp2_ = photo_get_untransformed_pixbuf (self, &_tmp1_, rotate, BACKING_FETCH_MODE_MASTER, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return result;
}

GdkPixbuf*
photo_get_unmodified_pixbuf (Photo* self,
                             Scaling* scaling,
                             gboolean rotate,
                             GError** error)
{
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp1_ = *scaling;
	_tmp2_ = photo_get_untransformed_pixbuf (self, &_tmp1_, rotate, BACKING_FETCH_MODE_UNMODIFIED, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static GdkPixbuf*
photo_get_untransformed_pixbuf (Photo* self,
                                Scaling* scaling,
                                gboolean rotate,
                                BackingFetchMode fetch_mode,
                                GError** error)
{
	Dimensions scaled_image = {0};
	Dimensions scaled_to_viewport = {0};
	Orientation original_orientation = 0;
	GdkPixbuf* pixbuf = NULL;
	Scaling _tmp5_;
	GdkPixbuf* _tmp6_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			Scaling _tmp1_;
			Dimensions _tmp2_ = {0};
			Dimensions _tmp3_ = {0};
			_tmp1_ = *scaling;
			photo_calculate_pixbuf_dimensions (self, &_tmp1_, PHOTO_EXCEPTION_NONE, &_tmp2_, &_tmp3_);
			scaled_image = _tmp2_;
			scaled_to_viewport = _tmp3_;
			original_orientation = photo_get_original_orientation (self);
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = *scaling;
	_tmp6_ = photo_load_raw_pixbuf (self, &_tmp5_, PHOTO_EXCEPTION_NONE, fetch_mode, &_inner_error0_);
	pixbuf = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	if (rotate) {
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
		_tmp7_ = pixbuf;
		_tmp8_ = orientation_rotate_pixbuf (original_orientation, _tmp7_);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp8_;
	}
	result = pixbuf;
	return result;
}

static GdkPixbuf*
photo_real_get_pixbuf (PhotoSource* base,
                       Scaling* scaling,
                       GError** error)
{
	Photo * self;
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (Photo*) base;
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp1_ = *scaling;
	_tmp2_ = photo_get_pixbuf_with_options (self, &_tmp1_, PHOTO_EXCEPTION_NONE, BACKING_FETCH_MODE_BASELINE, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Populates the cached version of the unmodified image.
     */
void
photo_populate_prefetched (Photo* self,
                           GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GdkPixbuf* _tmp0_;
		_tmp0_ = self->priv->unmodified_precached;
		g_rec_mutex_lock (&self->priv->__lock_unmodified_precached);
		{
			GdkPixbuf* _tmp1_;
			_tmp1_ = self->priv->unmodified_precached;
			if (_tmp1_ == NULL) {
				GdkPixbuf* _tmp2_ = NULL;
				Scaling _tmp3_ = {0};
				GdkPixbuf* _tmp4_;
				GdkPixbuf* _tmp5_;
				GTimer* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				scaling_for_original (&_tmp3_);
				_tmp4_ = photo_load_raw_pixbuf (self, &_tmp3_, PHOTO_EXCEPTION_ALL, BACKING_FETCH_MODE_SOURCE, &_inner_error0_);
				_tmp2_ = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp5_ = _tmp2_;
				_tmp2_ = NULL;
				_g_object_unref0 (self->priv->unmodified_precached);
				self->priv->unmodified_precached = _tmp5_;
				_tmp6_ = g_timer_new ();
				_g_timer_destroy0 (self->priv->secs_since_access);
				self->priv->secs_since_access = _tmp6_;
				g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, (GSourceFunc) photo_discard_prefetched, g_object_ref (self), g_object_unref);
				_tmp7_ = data_object_to_string ((DataObject*) self);
				_tmp8_ = _tmp7_;
				g_debug ("Photo.vala:3327: spawning new precache timeout for %s", _tmp8_);
				_g_free0 (_tmp8_);
				_g_object_unref0 (_tmp2_);
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _lock_error_ = NULL;
			GError* _tmp9_;
			_lock_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = _lock_error_;
			_lock_error_ = NULL;
			_inner_error0_ = _tmp9_;
			_g_error_free0 (_lock_error_);
			goto __finally0;
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			GdkPixbuf* _tmp10_;
			_tmp10_ = self->priv->unmodified_precached;
			g_rec_mutex_unlock (&self->priv->__lock_unmodified_precached);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
}

/**
     * Get a copy of what's in the cache.
     *
     * @return A Pixbuf with the image data from unmodified_precached.
     */
GdkPixbuf*
photo_get_prefetched_copy (Photo* self)
{
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GdkPixbuf* _tmp0_;
		_tmp0_ = self->priv->unmodified_precached;
		g_rec_mutex_lock (&self->priv->__lock_unmodified_precached);
		{
			GdkPixbuf* _tmp1_;
			GdkPixbuf* _tmp5_;
			GdkPixbuf* _tmp6_;
			_tmp1_ = self->priv->unmodified_precached;
			if (_tmp1_ == NULL) {
				{
					photo_populate_prefetched (self, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					gchar* _tmp2_;
					gchar* _tmp3_;
					g_clear_error (&_inner_error0_);
					_tmp2_ = data_object_to_string ((DataObject*) self);
					_tmp3_ = _tmp2_;
					g_warning ("Photo.vala:3343: raw pixbuf for %s could not be loaded", _tmp3_);
					_g_free0 (_tmp3_);
					result = NULL;
					{
						GdkPixbuf* _tmp4_;
						_tmp4_ = self->priv->unmodified_precached;
						g_rec_mutex_unlock (&self->priv->__lock_unmodified_precached);
					}
					return result;
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp5_ = self->priv->unmodified_precached;
			_tmp6_ = gdk_pixbuf_copy (_tmp5_);
			result = _tmp6_;
			{
				GdkPixbuf* _tmp7_;
				_tmp7_ = self->priv->unmodified_precached;
				g_rec_mutex_unlock (&self->priv->__lock_unmodified_precached);
			}
			return result;
		}
		__finally0:
		{
			GdkPixbuf* _tmp8_;
			_tmp8_ = self->priv->unmodified_precached;
			g_rec_mutex_unlock (&self->priv->__lock_unmodified_precached);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

/**
     * Discards the cached version of the unmodified image.
     *
     * @param immed Whether the cached version should be discarded now, or not.
     */
gboolean
photo_discard_prefetched (Photo* self,
                          gboolean immed)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GdkPixbuf* _tmp0_;
		gboolean _tmp12_ = FALSE;
		_tmp0_ = self->priv->unmodified_precached;
		g_rec_mutex_lock (&self->priv->__lock_unmodified_precached);
		{
			GTimer* _tmp1_;
			gdouble tmp = 0.0;
			gboolean _tmp3_ = FALSE;
			GTimer* _tmp4_;
			gulong _tmp5_ = 0UL;
			gdouble _tmp6_;
			_tmp1_ = self->priv->secs_since_access;
			if (_tmp1_ == NULL) {
				result = FALSE;
				{
					GdkPixbuf* _tmp2_;
					_tmp2_ = self->priv->unmodified_precached;
					g_rec_mutex_unlock (&self->priv->__lock_unmodified_precached);
				}
				return result;
			}
			_tmp4_ = self->priv->secs_since_access;
			_tmp6_ = g_timer_elapsed (_tmp4_, &_tmp5_);
			tmp = (gdouble) _tmp5_;
			if (_tmp6_ > ((gdouble) PHOTO_PRECACHE_TIME_TO_LIVE)) {
				_tmp3_ = TRUE;
			} else {
				_tmp3_ = immed;
			}
			if (_tmp3_) {
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = data_object_to_string ((DataObject*) self);
				_tmp8_ = _tmp7_;
				g_debug ("pipeline not run in over %d seconds or got immediate command, discardi" \
"ng " "cached original for %s", PHOTO_PRECACHE_TIME_TO_LIVE, _tmp8_);
				_g_free0 (_tmp8_);
				_g_object_unref0 (self->priv->unmodified_precached);
				self->priv->unmodified_precached = NULL;
				_g_timer_destroy0 (self->priv->secs_since_access);
				self->priv->secs_since_access = NULL;
				result = FALSE;
				{
					GdkPixbuf* _tmp9_;
					_tmp9_ = self->priv->unmodified_precached;
					g_rec_mutex_unlock (&self->priv->__lock_unmodified_precached);
				}
				return result;
			}
			result = TRUE;
			{
				GdkPixbuf* _tmp10_;
				_tmp10_ = self->priv->unmodified_precached;
				g_rec_mutex_unlock (&self->priv->__lock_unmodified_precached);
			}
			return result;
		}
		__finally0:
		{
			GdkPixbuf* _tmp11_;
			_tmp11_ = self->priv->unmodified_precached;
			g_rec_mutex_unlock (&self->priv->__lock_unmodified_precached);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp12_;
	}
}

/**
     * Returns a fully transformed and scaled pixbuf.  Transformations may be excluded via
     * the mask. If the image is smaller than the scaling, it will be returned in its actual size.
     * The caller is responsible for scaling thereafter.
     *
     * @param scaling A scaling object that describes the size the output pixbuf should be.
     * @param exceptions The parts of the pipeline that should be skipped; defaults to NONE if
     *      left unset.
     * @param fetch_mode The fetch mode; if left unset, defaults to BASELINE so that
     *      we get the image exactly as it is in the file.
     */
GdkPixbuf*
photo_get_pixbuf_with_options (Photo* self,
                               Scaling* scaling,
                               PhotoException exceptions,
                               BackingFetchMode fetch_mode,
                               GError** error)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean is_scaled = FALSE;
	gboolean is_cropped = FALSE;
	gboolean is_straightened = FALSE;
	Dimensions scaled_to_viewport = {0};
	Dimensions original = {0};
	Dimensions scaled = {0};
	EditingToolsRedeyeInstance* redeye_instances = NULL;
	gint redeye_instances_length1;
	gint _redeye_instances_size_;
	Box crop = {0};
	gdouble straightening_angle = 0.0;
	PixelTransformer* transformer = NULL;
	Orientation orientation = 0;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp22_;
	GTimer* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GdkPixbuf* _tmp26_;
	gboolean _tmp64_ = FALSE;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp3_ = photo_get_develop_raw_photos_to_files ();
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp2_ = photo_get_master_file_format (self) == PHOTO_FILE_FORMAT_RAW;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		if (fetch_mode == BACKING_FETCH_MODE_BASELINE) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = fetch_mode == BACKING_FETCH_MODE_UNMODIFIED;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = fetch_mode == BACKING_FETCH_MODE_SOURCE;
		}
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !photo_is_raw_developer_complete (self, photo_get_raw_developer (self));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		photo_set_raw_developer (self, photo_get_raw_developer (self));
	}
	dimensions_init (&original, 0, 0);
	dimensions_init (&scaled, 0, 0);
	redeye_instances = NULL;
	redeye_instances_length1 = 0;
	_redeye_instances_size_ = redeye_instances_length1;
	transformer = NULL;
	{
		PhotoRow* _tmp7_;
		_tmp7_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			Dimensions _tmp8_ = {0};
			Dimensions _tmp9_ = {0};
			Dimensions _tmp10_ = {0};
			Dimensions _tmp11_;
			Dimensions _tmp12_ = {0};
			Dimensions _tmp13_;
			gint _tmp14_ = 0;
			EditingToolsRedeyeInstance* _tmp15_;
			Box _tmp16_ = {0};
			gboolean _tmp17_;
			gdouble _tmp18_ = 0.0;
			gboolean _tmp19_;
			media_source_get_dimensions ((MediaSource*) self, PHOTO_EXCEPTION_ALL, &_tmp8_);
			original = _tmp8_;
			media_source_get_dimensions ((MediaSource*) self, exceptions, &_tmp9_);
			scaling_get_scaled_dimensions (scaling, &_tmp9_, &_tmp10_);
			scaled = _tmp10_;
			_tmp11_ = scaled;
			scaled_to_viewport = _tmp11_;
			media_source_get_dimensions ((MediaSource*) self, PHOTO_EXCEPTION_NONE, &_tmp12_);
			_tmp13_ = scaled;
			is_scaled = !dimensions_equals (&_tmp12_, &_tmp13_);
			_tmp15_ = photo_get_raw_redeye_instances (self, &_tmp14_);
			redeye_instances = (g_free (redeye_instances), NULL);
			redeye_instances = _tmp15_;
			redeye_instances_length1 = _tmp14_;
			_redeye_instances_size_ = redeye_instances_length1;
			_tmp17_ = photo_get_raw_crop (self, &_tmp16_);
			crop = _tmp16_;
			is_cropped = _tmp17_;
			_tmp19_ = photo_get_raw_straighten (self, &_tmp18_);
			straightening_angle = _tmp18_;
			is_straightened = _tmp19_;
			if (photo_has_color_adjustments (self)) {
				PixelTransformer* _tmp20_;
				_tmp20_ = photo_get_pixel_transformer (self);
				_pixel_transformer_unref0 (transformer);
				transformer = _tmp20_;
			}
			orientation = photo_get_orientation (self);
		}
		__finally0:
		{
			PhotoRow* _tmp21_;
			_tmp21_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_pixel_transformer_unref0 (transformer);
			redeye_instances = (g_free (redeye_instances), NULL);
			return NULL;
		}
	}
	photo_populate_prefetched (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_pixel_transformer_unref0 (transformer);
		redeye_instances = (g_free (redeye_instances), NULL);
		return NULL;
	}
	_tmp22_ = photo_get_prefetched_copy (self);
	pixbuf = _tmp22_;
	_tmp23_ = self->priv->secs_since_access;
	g_timer_start (_tmp23_);
	_tmp24_ = data_object_to_string ((DataObject*) self);
	_tmp25_ = _tmp24_;
	g_debug ("Photo.vala:3449: pipeline being run against %s, timer restarted.", _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = pixbuf;
	_vala_assert (_tmp26_ != NULL, "pixbuf != null");
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_REDEYE)) {
		EditingToolsRedeyeInstance* _tmp27_;
		gint _tmp27__length1;
		_tmp27_ = redeye_instances;
		_tmp27__length1 = redeye_instances_length1;
		{
			EditingToolsRedeyeInstance* instance_collection = NULL;
			gint instance_collection_length1 = 0;
			gint _instance_collection_size_ = 0;
			gint instance_it = 0;
			instance_collection = _tmp27_;
			instance_collection_length1 = _tmp27__length1;
			for (instance_it = 0; instance_it < instance_collection_length1; instance_it = instance_it + 1) {
				EditingToolsRedeyeInstance instance = {0};
				instance = instance_collection[instance_it];
				{
					GdkPixbuf* _tmp28_;
					EditingToolsRedeyeInstance _tmp29_;
					GdkPixbuf* _tmp30_;
					_tmp28_ = pixbuf;
					_tmp29_ = instance;
					_tmp30_ = photo_do_redeye (self, _tmp28_, &_tmp29_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp30_;
				}
			}
		}
	}
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_STRAIGHTEN)) {
		if (is_straightened) {
			GdkPixbuf* _tmp31_;
			GdkPixbuf* _tmp32_;
			_tmp31_ = pixbuf;
			_tmp32_ = rotate_arb (_tmp31_, straightening_angle);
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp32_;
		}
	}
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_CROP)) {
		if (is_cropped) {
			Box _tmp33_;
			GdkPixbuf* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			Box _tmp37_;
			GdkPixbuf* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			Box _tmp41_;
			Box _tmp42_;
			GdkPixbuf* _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			Box _tmp46_;
			Box _tmp47_;
			GdkPixbuf* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			GdkPixbuf* _tmp51_;
			Box _tmp52_;
			Box _tmp53_;
			GdkPixbuf* _tmp54_;
			_tmp33_ = crop;
			_tmp34_ = pixbuf;
			_tmp35_ = gdk_pixbuf_get_width (_tmp34_);
			_tmp36_ = _tmp35_;
			crop.left = CLAMP (_tmp33_.left, 0, _tmp36_ - 2);
			_tmp37_ = crop;
			_tmp38_ = pixbuf;
			_tmp39_ = gdk_pixbuf_get_height (_tmp38_);
			_tmp40_ = _tmp39_;
			crop.top = CLAMP (_tmp37_.top, 0, _tmp40_ - 2);
			_tmp41_ = crop;
			_tmp42_ = crop;
			_tmp43_ = pixbuf;
			_tmp44_ = gdk_pixbuf_get_width (_tmp43_);
			_tmp45_ = _tmp44_;
			crop.right = CLAMP (_tmp41_.right, _tmp42_.left + 1, _tmp45_ - 1);
			_tmp46_ = crop;
			_tmp47_ = crop;
			_tmp48_ = pixbuf;
			_tmp49_ = gdk_pixbuf_get_height (_tmp48_);
			_tmp50_ = _tmp49_;
			crop.bottom = CLAMP (_tmp46_.bottom, _tmp47_.top + 1, _tmp50_ - 1);
			_tmp51_ = pixbuf;
			_tmp52_ = crop;
			_tmp53_ = crop;
			_tmp54_ = gdk_pixbuf_new_subpixbuf (_tmp51_, _tmp52_.left, _tmp53_.top, box_get_width (&crop), box_get_height (&crop));
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp54_;
		}
	}
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
		GdkPixbuf* _tmp55_;
		GdkPixbuf* _tmp56_;
		_tmp55_ = pixbuf;
		_tmp56_ = orientation_rotate_pixbuf (orientation, _tmp55_);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp56_;
	}
	if (is_scaled) {
		GdkPixbuf* _tmp57_;
		Dimensions _tmp58_;
		Dimensions _tmp59_;
		GdkPixbuf* _tmp60_;
		_tmp57_ = pixbuf;
		_tmp58_ = scaled_to_viewport;
		_tmp59_ = scaled_to_viewport;
		_tmp60_ = gdk_pixbuf_scale_simple (_tmp57_, _tmp58_.width, _tmp59_.height, GDK_INTERP_BILINEAR);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp60_;
	}
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ADJUST)) {
		PixelTransformer* _tmp61_;
		_tmp61_ = transformer;
		if (_tmp61_ != NULL) {
			PixelTransformer* _tmp62_;
			GdkPixbuf* _tmp63_;
			_tmp62_ = transformer;
			_tmp63_ = pixbuf;
			pixel_transformer_transform_pixbuf (_tmp62_, _tmp63_, NULL);
		}
	}
	if (is_scaled) {
		_tmp64_ = !is_straightened;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		GdkPixbuf* _tmp65_;
		Dimensions _tmp66_ = {0};
		_tmp65_ = pixbuf;
		dimensions_for_pixbuf (_tmp65_, &_tmp66_);
		_vala_assert (dimensions_approx_equals (&scaled_to_viewport, &_tmp66_, PHOTO_SCALING_FUDGE), "scaled_to_viewport.approx_equals (Dimensions.for_pixbuf (pixbuf), SCALING_FUDGE)");
	}
	result = pixbuf;
	_pixel_transformer_unref0 (transformer);
	redeye_instances = (g_free (redeye_instances), NULL);
	return result;
}

static gboolean
photo_real_has_user_generated_metadata (Photo* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `photo_has_user_generated_metadata'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
photo_has_user_generated_metadata (Photo* self)
{
	PhotoClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->has_user_generated_metadata) {
		return _klass_->has_user_generated_metadata (self);
	}
	return FALSE;
}

static void
photo_real_set_user_metadata_for_export (Photo* self,
                                         PhotoMetadata* metadata)
{
	g_critical ("Type `%s' does not implement abstract method `photo_set_user_metadata_for_export'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
photo_set_user_metadata_for_export (Photo* self,
                                    PhotoMetadata* metadata)
{
	PhotoClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->set_user_metadata_for_export) {
		_klass_->set_user_metadata_for_export (self, metadata);
	}
}

gchar*
photo_get_export_basename (Photo* self,
                           PhotoFileFormat* file_format)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (file_format != NULL) {
		PhotoFileFormatProperties* _tmp0_;
		PhotoFileFormatProperties* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp0_ = photo_file_format_get_properties (*file_format);
		_tmp1_ = _tmp0_;
		_tmp2_ = media_source_get_master_file ((MediaSource*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = photo_file_format_properties_convert_file_extension (_tmp1_, _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_get_basename (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (_tmp3_);
		_photo_file_format_properties_unref0 (_tmp1_);
		result = _tmp7_;
		return result;
	} else {
		if (photo_file_format_can_write (photo_get_file_format (self))) {
			PhotoFileFormatProperties* _tmp8_;
			PhotoFileFormatProperties* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_;
			GFile* _tmp12_;
			GFile* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp8_ = photo_file_format_get_properties (photo_get_file_format (self));
			_tmp9_ = _tmp8_;
			_tmp10_ = media_source_get_master_file ((MediaSource*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = photo_file_format_properties_convert_file_extension (_tmp9_, _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_file_get_basename (_tmp13_);
			_tmp15_ = _tmp14_;
			_g_object_unref0 (_tmp13_);
			_g_object_unref0 (_tmp11_);
			_photo_file_format_properties_unref0 (_tmp9_);
			result = _tmp15_;
			return result;
		} else {
			PhotoFileFormatProperties* _tmp16_;
			PhotoFileFormatProperties* _tmp17_;
			GFile* _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp16_ = photo_file_format_get_properties (photo_file_format_get_system_default_format ());
			_tmp17_ = _tmp16_;
			_tmp18_ = media_source_get_master_file ((MediaSource*) self);
			_tmp19_ = _tmp18_;
			_tmp20_ = photo_file_format_properties_convert_file_extension (_tmp17_, _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_file_get_basename (_tmp21_);
			_tmp23_ = _tmp22_;
			_g_object_unref0 (_tmp21_);
			_g_object_unref0 (_tmp19_);
			_photo_file_format_properties_unref0 (_tmp17_);
			result = _tmp23_;
			return result;
		}
	}
}

static gboolean
photo_export_fullsized_backing (Photo* self,
                                GFile* file,
                                gboolean export_metadata,
                                GError** error)
{
	PhotoFileReader* export_reader = NULL;
	gboolean is_master = FALSE;
	PhotoFileReader* _tmp24_;
	PhotoFileFormatProperties* format_properties = NULL;
	PhotoFileReader* _tmp25_;
	PhotoFileFormatProperties* _tmp26_;
	GFile* dest_file = NULL;
	PhotoFileFormatProperties* _tmp27_;
	GFile* _tmp28_;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp29_;
	GFile* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	PhotoFileMetadataWriter* _tmp33_;
	PhotoFileMetadataWriter* _tmp34_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	PhotoFileMetadataWriter* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	PhotoFileReader* _tmp41_;
	GFile* _tmp42_;
	GFile* _tmp43_;
	GFile* _tmp44_;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp55_;
	PhotoMetadata* _tmp56_;
	PhotoMetadata* _tmp58_;
	PhotoFileMetadataWriter* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	PhotoFileMetadataWriter* _tmp81_;
	PhotoMetadata* _tmp82_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	export_reader = NULL;
	is_master = TRUE;
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			gboolean _tmp1_ = FALSE;
			PhotoBackingReaders* _tmp2_;
			PhotoFileReader* _tmp3_;
			_tmp2_ = self->priv->readers;
			_tmp3_ = _tmp2_->editable;
			if (_tmp3_ != NULL) {
				PhotoBackingReaders* _tmp4_;
				PhotoFileReader* _tmp5_;
				_tmp4_ = self->priv->readers;
				_tmp5_ = _tmp4_->editable;
				_tmp1_ = photo_file_format_can_write_metadata (photo_file_adapter_get_file_format ((PhotoFileAdapter*) _tmp5_));
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				PhotoBackingReaders* _tmp6_;
				PhotoFileReader* _tmp7_;
				PhotoFileReader* _tmp8_;
				_tmp6_ = self->priv->readers;
				_tmp7_ = _tmp6_->editable;
				_tmp8_ = _photo_file_adapter_ref0 (_tmp7_);
				_photo_file_adapter_unref0 (export_reader);
				export_reader = _tmp8_;
				is_master = FALSE;
			} else {
				gboolean _tmp9_ = FALSE;
				PhotoBackingReaders* _tmp10_;
				PhotoFileReader* _tmp11_;
				_tmp10_ = self->priv->readers;
				_tmp11_ = _tmp10_->developer;
				if (_tmp11_ != NULL) {
					PhotoBackingReaders* _tmp12_;
					PhotoFileReader* _tmp13_;
					_tmp12_ = self->priv->readers;
					_tmp13_ = _tmp12_->developer;
					_tmp9_ = photo_file_format_can_write_metadata (photo_file_adapter_get_file_format ((PhotoFileAdapter*) _tmp13_));
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					PhotoBackingReaders* _tmp14_;
					PhotoFileReader* _tmp15_;
					PhotoFileReader* _tmp16_;
					_tmp14_ = self->priv->readers;
					_tmp15_ = _tmp14_->developer;
					_tmp16_ = _photo_file_adapter_ref0 (_tmp15_);
					_photo_file_adapter_unref0 (export_reader);
					export_reader = _tmp16_;
					is_master = FALSE;
				} else {
					PhotoBackingReaders* _tmp17_;
					PhotoFileReader* _tmp18_;
					_tmp17_ = self->priv->readers;
					_tmp18_ = _tmp17_->master;
					if (photo_file_format_can_write_metadata (photo_file_adapter_get_file_format ((PhotoFileAdapter*) _tmp18_))) {
						PhotoBackingReaders* _tmp19_;
						PhotoFileReader* _tmp20_;
						PhotoFileReader* _tmp21_;
						_tmp19_ = self->priv->readers;
						_tmp20_ = _tmp19_->master;
						_tmp21_ = _photo_file_adapter_ref0 (_tmp20_);
						_photo_file_adapter_unref0 (export_reader);
						export_reader = _tmp21_;
					}
				}
			}
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp22_;
			_tmp22_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp23_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_photo_file_adapter_unref0 (export_reader);
			return _tmp23_;
		}
	}
	_tmp24_ = export_reader;
	if (_tmp24_ == NULL) {
		result = FALSE;
		_photo_file_adapter_unref0 (export_reader);
		return result;
	}
	_tmp25_ = export_reader;
	_tmp26_ = photo_file_format_get_properties (photo_file_adapter_get_file_format ((PhotoFileAdapter*) _tmp25_));
	format_properties = _tmp26_;
	_tmp27_ = format_properties;
	_tmp28_ = photo_file_format_properties_convert_file_extension (_tmp27_, file);
	dest_file = _tmp28_;
	_tmp29_ = export_reader;
	_tmp30_ = dest_file;
	_tmp31_ = g_file_get_path (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = photo_file_format_create_metadata_writer (photo_file_adapter_get_file_format ((PhotoFileAdapter*) _tmp29_), _tmp32_, &_inner_error0_);
	_tmp34_ = _tmp33_;
	_g_free0 (_tmp32_);
	writer = _tmp34_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp35_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dest_file);
		_photo_file_format_properties_unref0 (format_properties);
		_photo_file_adapter_unref0 (export_reader);
		return _tmp35_;
	}
	_tmp36_ = data_object_to_string ((DataObject*) self);
	_tmp37_ = _tmp36_;
	_tmp38_ = writer;
	_tmp39_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) _tmp38_);
	_tmp40_ = _tmp39_;
	g_debug ("Photo.vala:3616: Exporting full-sized copy of %s to %s", _tmp37_, _tmp40_);
	_g_free0 (_tmp40_);
	_g_free0 (_tmp37_);
	_tmp41_ = export_reader;
	_tmp42_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = dest_file;
	g_file_copy (_tmp43_, _tmp44_, G_FILE_COPY_OVERWRITE | G_FILE_COPY_TARGET_DEFAULT_PERMS, NULL, NULL, NULL, &_inner_error0_);
	_g_object_unref0 (_tmp43_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp45_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (writer);
		_g_object_unref0 (dest_file);
		_photo_file_format_properties_unref0 (format_properties);
		_photo_file_adapter_unref0 (export_reader);
		return _tmp45_;
	}
	if (!photo_has_alterations (self)) {
		_tmp50_ = is_master;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		_tmp49_ = !photo_has_user_generated_metadata (self);
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp51_ = media_source_get_title ((MediaSource*) self);
		_tmp52_ = _tmp51_;
		_tmp48_ = _tmp52_ == NULL;
		_g_free0 (_tmp52_);
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp53_ = media_source_get_comment ((MediaSource*) self);
		_tmp54_ = _tmp53_;
		_tmp47_ = _tmp54_ == NULL;
		_g_free0 (_tmp54_);
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		_tmp46_ = export_metadata;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		result = TRUE;
		_photo_file_adapter_unref0 (writer);
		_g_object_unref0 (dest_file);
		_photo_file_format_properties_unref0 (format_properties);
		_photo_file_adapter_unref0 (export_reader);
		return result;
	}
	_tmp55_ = export_reader;
	_tmp56_ = photo_file_reader_read_metadata (_tmp55_, &_inner_error0_);
	metadata = _tmp56_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp57_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (writer);
		_g_object_unref0 (dest_file);
		_photo_file_format_properties_unref0 (format_properties);
		_photo_file_adapter_unref0 (export_reader);
		return _tmp57_;
	}
	_tmp58_ = metadata;
	if (_tmp58_ == NULL) {
		PhotoFileReader* _tmp59_;
		PhotoMetadata* _tmp60_;
		_tmp59_ = export_reader;
		_tmp60_ = photo_file_format_create_metadata (photo_file_adapter_get_file_format ((PhotoFileAdapter*) _tmp59_));
		_media_metadata_unref0 (metadata);
		metadata = _tmp60_;
	}
	_tmp61_ = writer;
	_tmp62_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) _tmp61_);
	_tmp63_ = _tmp62_;
	g_debug ("Photo.vala:3634: Updating metadata of %s", _tmp63_);
	_g_free0 (_tmp63_);
	if (media_source_get_exposure_time ((MediaSource*) self) != ((gint64) 0)) {
		PhotoMetadata* _tmp64_;
		MetadataDateTime* _tmp65_;
		MetadataDateTime* _tmp66_;
		_tmp64_ = metadata;
		_tmp65_ = metadata_date_time_new (media_source_get_exposure_time ((MediaSource*) self));
		_tmp66_ = _tmp65_;
		photo_metadata_set_exposure_date_time (_tmp64_, _tmp66_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_metadata_date_time_unref0 (_tmp66_);
	} else {
		PhotoMetadata* _tmp67_;
		_tmp67_ = metadata;
		photo_metadata_set_exposure_date_time (_tmp67_, NULL, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
	}
	if (export_metadata) {
		PhotoMetadata* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		PhotoMetadata* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		PhotoMetadata* _tmp74_;
		Dimensions _tmp75_ = {0};
		PhotoMetadata* _tmp76_;
		PhotoMetadata* _tmp77_;
		PhotoMetadata* _tmp79_;
		_tmp68_ = metadata;
		_tmp69_ = media_source_get_title ((MediaSource*) self);
		_tmp70_ = _tmp69_;
		photo_metadata_set_title (_tmp68_, _tmp70_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_g_free0 (_tmp70_);
		_tmp71_ = metadata;
		_tmp72_ = media_source_get_comment ((MediaSource*) self);
		_tmp73_ = _tmp72_;
		photo_metadata_set_comment (_tmp71_, _tmp73_);
		_g_free0 (_tmp73_);
		_tmp74_ = metadata;
		media_source_get_dimensions ((MediaSource*) self, PHOTO_EXCEPTION_NONE, &_tmp75_);
		photo_metadata_set_pixel_dimensions (_tmp74_, &_tmp75_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_tmp76_ = metadata;
		photo_metadata_set_orientation (_tmp76_, photo_get_orientation (self));
		_tmp77_ = metadata;
		photo_metadata_set_software (_tmp77_, _ (RESOURCES_APP_TITLE), RESOURCES_APP_VERSION);
		if (photo_get_orientation (self) != photo_get_original_orientation (self)) {
			PhotoMetadata* _tmp78_;
			_tmp78_ = metadata;
			photo_metadata_remove_exif_thumbnail (_tmp78_);
		}
		_tmp79_ = metadata;
		photo_set_user_metadata_for_export (self, _tmp79_);
	} else {
		PhotoMetadata* _tmp80_;
		_tmp80_ = metadata;
		photo_metadata_clear (_tmp80_);
	}
	_tmp81_ = writer;
	_tmp82_ = metadata;
	photo_file_metadata_writer_write_metadata (_tmp81_, _tmp82_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp83_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		_photo_file_adapter_unref0 (writer);
		_g_object_unref0 (dest_file);
		_photo_file_format_properties_unref0 (format_properties);
		_photo_file_adapter_unref0 (export_reader);
		return _tmp83_;
	}
	result = TRUE;
	_media_metadata_unref0 (metadata);
	_photo_file_adapter_unref0 (writer);
	_g_object_unref0 (dest_file);
	_photo_file_format_properties_unref0 (format_properties);
	_photo_file_adapter_unref0 (export_reader);
	return result;
}

gboolean
photo_is_export_required (Photo* self,
                          Scaling* scaling,
                          PhotoFileFormat export_format)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (scaling != NULL, FALSE);
	if (!scaling_is_unscaled (scaling)) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = photo_has_alterations (self);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = photo_has_user_generated_metadata (self);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = export_format != photo_get_file_format (self);
	}
	result = _tmp0_;
	return result;
}

void
photo_export (Photo* self,
              GFile* dest_file,
              Scaling* scaling,
              JpegQuality quality,
              PhotoFileFormat export_format,
              gboolean direct_copy_unmodified,
              gboolean export_metadata,
              GError** error)
{
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp7_;
	PhotoMetadata* _tmp8_;
	PhotoFileWriter* writer = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	PhotoFileWriter* _tmp12_;
	PhotoFileWriter* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	PhotoFileWriter* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GEnumValue* _tmp19_;
	GdkPixbuf* pixbuf = NULL;
	gboolean _tmp20_ = FALSE;
	PhotoFileWriter* _tmp29_;
	GdkPixbuf* _tmp30_;
	PhotoFileWriter* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gboolean _tmp50_ = FALSE;
	PhotoFileMetadataWriter* _tmp58_ = NULL;
	gchar* _tmp59_;
	gchar* _tmp60_;
	PhotoFileMetadataWriter* _tmp61_;
	PhotoFileMetadataWriter* _tmp62_;
	PhotoMetadata* _tmp63_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dest_file != NULL);
	g_return_if_fail (scaling != NULL);
	if (direct_copy_unmodified) {
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = media_source_get_master_file ((MediaSource*) self);
		_tmp1_ = _tmp0_;
		g_file_copy (_tmp1_, dest_file, G_FILE_COPY_OVERWRITE | G_FILE_COPY_TARGET_DEFAULT_PERMS, NULL, NULL, NULL, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		return;
	}
	if (scaling_is_unscaled (scaling)) {
		gboolean _tmp5_ = FALSE;
		if (!photo_has_alterations (self)) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = photo_only_metadata_changed (self);
		}
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = export_format == photo_get_file_format (self);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = photo_get_file_format (self) == PHOTO_FILE_FORMAT_JFIF;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp6_ = FALSE;
		_tmp6_ = photo_export_fullsized_backing (self, dest_file, export_metadata, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		if (_tmp6_) {
			return;
		}
	}
	_tmp7_ = photo_source_get_metadata ((PhotoSource*) self);
	metadata = _tmp7_;
	_tmp8_ = metadata;
	if (_tmp8_ == NULL) {
		PhotoMetadata* _tmp9_;
		_tmp9_ = photo_file_format_create_metadata (export_format);
		_media_metadata_unref0 (metadata);
		metadata = _tmp9_;
	}
	if (!photo_file_format_can_write (export_format)) {
		export_format = photo_file_format_get_system_default_format ();
	}
	_tmp10_ = g_file_get_path (dest_file);
	_tmp11_ = _tmp10_;
	_tmp12_ = photo_file_format_create_writer (export_format, _tmp11_, &_inner_error0_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	writer = _tmp13_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		return;
	}
	_tmp14_ = data_object_to_string ((DataObject*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = writer;
	_tmp17_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_enum_get_value (g_type_class_ref (TYPE_PHOTO_FILE_FORMAT), export_format);
	g_debug ("Photo.vala:3708: Saving transformed version of %s to %s in file format" \
" %s", _tmp15_, _tmp18_, (_tmp19_ != NULL) ? _tmp19_->value_name : NULL);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	if (photo_get_file_format (self) == PHOTO_FILE_FORMAT_JFIF) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = photo_get_file_format (self) == PHOTO_FILE_FORMAT_RAW;
	}
	if (_tmp20_) {
		GdkPixbuf* _tmp21_ = NULL;
		Scaling _tmp22_;
		GdkPixbuf* _tmp23_;
		GdkPixbuf* _tmp24_;
		_tmp22_ = *scaling;
		_tmp23_ = photo_get_pixbuf_with_options (self, &_tmp22_, PHOTO_EXCEPTION_ORIENTATION, BACKING_FETCH_MODE_SOURCE, &_inner_error0_);
		_tmp21_ = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (pixbuf);
			_photo_file_adapter_unref0 (writer);
			_media_metadata_unref0 (metadata);
			return;
		}
		_tmp24_ = _tmp21_;
		_tmp21_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp24_;
		_g_object_unref0 (_tmp21_);
	} else {
		GdkPixbuf* _tmp25_ = NULL;
		Scaling _tmp26_;
		GdkPixbuf* _tmp27_;
		GdkPixbuf* _tmp28_;
		_tmp26_ = *scaling;
		_tmp27_ = photo_get_pixbuf_with_options (self, &_tmp26_, PHOTO_EXCEPTION_NONE, BACKING_FETCH_MODE_SOURCE, &_inner_error0_);
		_tmp25_ = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (pixbuf);
			_photo_file_adapter_unref0 (writer);
			_media_metadata_unref0 (metadata);
			return;
		}
		_tmp28_ = _tmp25_;
		_tmp25_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp28_;
		_g_object_unref0 (_tmp25_);
	}
	_tmp29_ = writer;
	_tmp30_ = pixbuf;
	photo_file_writer_write (_tmp29_, _tmp30_, quality, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (pixbuf);
		_photo_file_adapter_unref0 (writer);
		_media_metadata_unref0 (metadata);
		return;
	}
	_tmp31_ = writer;
	_tmp32_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) _tmp31_);
	_tmp33_ = _tmp32_;
	g_debug ("Photo.vala:3727: Setting EXIF for %s", _tmp33_);
	_g_free0 (_tmp33_);
	if (export_metadata) {
		PhotoMetadata* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		PhotoMetadata* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		PhotoMetadata* _tmp40_;
		PhotoMetadata* _tmp45_;
		PhotoMetadata* _tmp46_;
		PhotoMetadata* _tmp47_;
		_tmp34_ = metadata;
		_tmp35_ = media_source_get_title ((MediaSource*) self);
		_tmp36_ = _tmp35_;
		photo_metadata_set_title (_tmp34_, _tmp36_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_g_free0 (_tmp36_);
		_tmp37_ = metadata;
		_tmp38_ = media_source_get_comment ((MediaSource*) self);
		_tmp39_ = _tmp38_;
		photo_metadata_set_comment (_tmp37_, _tmp39_);
		_g_free0 (_tmp39_);
		_tmp40_ = metadata;
		photo_metadata_set_software (_tmp40_, _ (RESOURCES_APP_TITLE), RESOURCES_APP_VERSION);
		if (media_source_get_exposure_time ((MediaSource*) self) != ((gint64) 0)) {
			PhotoMetadata* _tmp41_;
			MetadataDateTime* _tmp42_;
			MetadataDateTime* _tmp43_;
			_tmp41_ = metadata;
			_tmp42_ = metadata_date_time_new (media_source_get_exposure_time ((MediaSource*) self));
			_tmp43_ = _tmp42_;
			photo_metadata_set_exposure_date_time (_tmp41_, _tmp43_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
			_metadata_date_time_unref0 (_tmp43_);
		} else {
			PhotoMetadata* _tmp44_;
			_tmp44_ = metadata;
			photo_metadata_set_exposure_date_time (_tmp44_, NULL, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		}
		_tmp45_ = metadata;
		photo_metadata_remove_tag (_tmp45_, "Exif.Iop.RelatedImageWidth");
		_tmp46_ = metadata;
		photo_metadata_remove_tag (_tmp46_, "Exif.Iop.RelatedImageHeight");
		_tmp47_ = metadata;
		photo_metadata_remove_exif_thumbnail (_tmp47_);
		if (photo_has_user_generated_metadata (self)) {
			PhotoMetadata* _tmp48_;
			_tmp48_ = metadata;
			photo_set_user_metadata_for_export (self, _tmp48_);
		}
	} else {
		PhotoMetadata* _tmp49_;
		_tmp49_ = metadata;
		photo_metadata_clear (_tmp49_);
	}
	if (photo_get_file_format (self) == PHOTO_FILE_FORMAT_JFIF) {
		_tmp50_ = TRUE;
	} else {
		_tmp50_ = photo_get_file_format (self) == PHOTO_FILE_FORMAT_RAW;
	}
	if (_tmp50_) {
		PhotoMetadata* _tmp51_;
		Dimensions _tmp52_ = {0};
		PhotoMetadata* _tmp53_;
		_tmp51_ = metadata;
		media_source_get_dimensions ((MediaSource*) self, PHOTO_EXCEPTION_ORIENTATION, &_tmp52_);
		photo_metadata_set_pixel_dimensions (_tmp51_, &_tmp52_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_tmp53_ = metadata;
		photo_metadata_set_orientation (_tmp53_, photo_get_orientation (self));
	} else {
		PhotoMetadata* _tmp54_;
		GdkPixbuf* _tmp55_;
		Dimensions _tmp56_ = {0};
		PhotoMetadata* _tmp57_;
		_tmp54_ = metadata;
		_tmp55_ = pixbuf;
		dimensions_for_pixbuf (_tmp55_, &_tmp56_);
		photo_metadata_set_pixel_dimensions (_tmp54_, &_tmp56_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_tmp57_ = metadata;
		photo_metadata_set_orientation (_tmp57_, ORIENTATION_TOP_LEFT);
	}
	_tmp59_ = g_file_get_path (dest_file);
	_tmp60_ = _tmp59_;
	_tmp61_ = photo_file_format_create_metadata_writer (export_format, _tmp60_, &_inner_error0_);
	_tmp62_ = _tmp61_;
	_g_free0 (_tmp60_);
	_tmp58_ = _tmp62_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (pixbuf);
		_photo_file_adapter_unref0 (writer);
		_media_metadata_unref0 (metadata);
		return;
	}
	_tmp63_ = metadata;
	photo_file_metadata_writer_write_metadata (_tmp58_, _tmp63_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (_tmp58_);
		_g_object_unref0 (pixbuf);
		_photo_file_adapter_unref0 (writer);
		_media_metadata_unref0 (metadata);
		return;
	}
	_photo_file_adapter_unref0 (_tmp58_);
	_g_object_unref0 (pixbuf);
	_photo_file_adapter_unref0 (writer);
	_media_metadata_unref0 (metadata);
}

static GFile*
photo_generate_new_editable_file (Photo* self,
                                  PhotoFileFormat* file_format,
                                  GError** error)
{
	PhotoFileFormat _vala_file_format = 0;
	GFile* backing = NULL;
	gchar* name = NULL;
	gchar* ext = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	gchar* editable_basename = NULL;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean collision = FALSE;
	GFile* _tmp18_ = NULL;
	GFile* _tmp19_;
	GFile* _tmp20_;
	gboolean _tmp21_ = FALSE;
	GFile* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			GFile* _tmp1_;
			_vala_file_format = photo_get_file_format (self);
			_tmp1_ = media_source_get_file ((MediaSource*) self);
			_g_object_unref0 (backing);
			backing = _tmp1_;
		}
		__finally0:
		{
			PhotoRow* _tmp2_;
			_tmp2_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (backing);
			return NULL;
		}
	}
	if (!photo_file_format_can_write (_vala_file_format)) {
		_vala_file_format = photo_file_format_get_system_default_format ();
	}
	_tmp3_ = g_file_get_basename (backing);
	_tmp4_ = _tmp3_;
	disassemble_filename (_tmp4_, &_tmp5_, &_tmp6_);
	_g_free0 (name);
	name = _tmp5_;
	_g_free0 (ext);
	ext = _tmp6_;
	_g_free0 (_tmp4_);
	_tmp8_ = ext;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		PhotoFileFormatProperties* _tmp9_;
		PhotoFileFormatProperties* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = photo_file_format_get_properties (_vala_file_format);
		_tmp10_ = _tmp9_;
		_tmp11_ = ext;
		_tmp7_ = !photo_file_format_properties_is_recognized_extension (_tmp10_, _tmp11_);
		_photo_file_format_properties_unref0 (_tmp10_);
	}
	if (_tmp7_) {
		PhotoFileFormatProperties* _tmp12_;
		PhotoFileFormatProperties* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = photo_file_format_get_properties (_vala_file_format);
		_tmp13_ = _tmp12_;
		_tmp14_ = photo_file_format_properties_get_default_extension (_tmp13_);
		_g_free0 (ext);
		ext = _tmp14_;
		_photo_file_format_properties_unref0 (_tmp13_);
	}
	_tmp15_ = name;
	_tmp16_ = ext;
	_tmp17_ = g_strdup_printf ("%s_%s.%s", _tmp15_, _ ("modified"), _tmp16_);
	editable_basename = _tmp17_;
	_tmp19_ = g_file_get_parent (backing);
	_tmp20_ = _tmp19_;
	_tmp22_ = generate_unique_file (_tmp20_, editable_basename, &_tmp21_, &_inner_error0_);
	collision = _tmp21_;
	_tmp23_ = _tmp22_;
	_g_object_unref0 (_tmp20_);
	_tmp18_ = _tmp23_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (editable_basename);
		_g_free0 (ext);
		_g_free0 (name);
		_g_object_unref0 (backing);
		return NULL;
	}
	_tmp24_ = _tmp18_;
	_tmp18_ = NULL;
	result = _tmp24_;
	_g_object_unref0 (_tmp18_);
	_g_free0 (editable_basename);
	_g_free0 (ext);
	_g_free0 (name);
	_g_object_unref0 (backing);
	if (file_format) {
		*file_format = _vala_file_format;
	}
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
photo_launch_editor (GFile* file,
                     PhotoFileFormat file_format,
                     const gchar* commandline,
                     GError** error)
{
	GAppInfo* app = NULL;
	GList* files = NULL;
	GFile* _tmp4_;
	GAppInfo* _tmp5_;
	gchar** argv = NULL;
	gchar** _tmp10_;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	GPid child_pid = 0;
	gboolean _tmp15_ = FALSE;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GPid _tmp17_ = 0;
	gboolean _tmp18_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (commandline != NULL, FALSE);
	if (is_string_empty (commandline)) {
		result = FALSE;
		return result;
	}
	{
		GAppInfo* _tmp0_ = NULL;
		GAppInfo* _tmp1_;
		GAppInfo* _tmp2_;
		_tmp1_ = g_app_info_create_from_commandline (commandline, "", G_APP_INFO_CREATE_NONE, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (app);
		app = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (app);
		app = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (app);
		return _tmp3_;
	}
	files = NULL;
	_tmp4_ = _g_object_ref0 (file);
	files = g_list_insert (files, _tmp4_, -1);
	_tmp5_ = app;
	if (_tmp5_ != NULL) {
		gboolean _tmp6_ = FALSE;
		GAppInfo* _tmp7_;
		GList* _tmp8_;
		_tmp7_ = app;
		_tmp8_ = files;
		_tmp6_ = g_app_info_launch (_tmp7_, _tmp8_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp9_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
			_g_object_unref0 (app);
			return _tmp9_;
		}
		result = _tmp6_;
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
		_g_object_unref0 (app);
		return result;
	}
	_tmp10_ = g_new0 (gchar*, 2 + 1);
	argv = _tmp10_;
	argv_length1 = 2;
	_argv_size_ = argv_length1;
	_tmp11_ = argv;
	_tmp11__length1 = argv_length1;
	_tmp12_ = g_strdup (commandline);
	_g_free0 (_tmp11_[0]);
	_tmp11_[0] = _tmp12_;
	_tmp13_ = argv;
	_tmp13__length1 = argv_length1;
	_tmp14_ = g_file_get_path (file);
	_g_free0 (_tmp13_[1]);
	_tmp13_[1] = _tmp14_;
	_tmp16_ = argv;
	_tmp16__length1 = argv_length1;
	_tmp18_ = g_spawn_async ("/", _tmp16_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp17_, &_inner_error0_);
	child_pid = _tmp17_;
	_tmp15_ = _tmp18_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp19_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
		_g_object_unref0 (app);
		return _tmp19_;
	}
	result = _tmp15_;
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
	_g_object_unref0 (app);
	return result;
}

void
photo_open_with_raw_external_editor (Photo* self,
                                     const gchar* external_editor,
                                     GError** error)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (external_editor != NULL);
	_tmp0_ = media_source_get_master_file ((MediaSource*) self);
	_tmp1_ = _tmp0_;
	photo_launch_editor (_tmp1_, photo_get_master_file_format (self), external_editor, &_inner_error0_);
	_g_object_unref0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
photo_open_with_external_editor (Photo* self,
                                 const gchar* external_editor,
                                 GError** error)
{
	GFile* modified_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (external_editor != NULL);
	_tmp0_ = photo_get_modified_file (self, &_inner_error0_);
	modified_file = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = modified_file;
	photo_launch_editor (_tmp1_, photo_get_file_format (self), external_editor, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (modified_file);
		return;
	}
	_g_object_unref0 (modified_file);
}

GFile*
photo_get_modified_file (Photo* self,
                         GError** error)
{
	GFile* current_editable_file = NULL;
	GFile* create_editable_file = NULL;
	PhotoFileFormat editable_file_format = 0;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GFile* _tmp17_;
	gboolean _tmp23_ = FALSE;
	GFile* _tmp24_;
	GFile* _tmp38_;
	GFileMonitor* _tmp39_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	current_editable_file = NULL;
	create_editable_file = NULL;
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			GFile* _tmp6_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			if (_tmp2_ != NULL) {
				PhotoBackingReaders* _tmp3_;
				PhotoFileReader* _tmp4_;
				GFile* _tmp5_;
				_tmp3_ = self->priv->readers;
				_tmp4_ = _tmp3_->editable;
				_tmp5_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp4_);
				_g_object_unref0 (current_editable_file);
				current_editable_file = _tmp5_;
			}
			_tmp6_ = current_editable_file;
			if (_tmp6_ == NULL) {
				GFile* _tmp7_ = NULL;
				PhotoFileFormat _tmp8_ = 0;
				GFile* _tmp9_;
				GFile* _tmp10_;
				_tmp9_ = photo_generate_new_editable_file (self, &_tmp8_, &_inner_error0_);
				editable_file_format = _tmp8_;
				_tmp7_ = _tmp9_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp10_ = _tmp7_;
				_tmp7_ = NULL;
				_g_object_unref0 (create_editable_file);
				create_editable_file = _tmp10_;
				_g_object_unref0 (_tmp7_);
			} else {
				PhotoBackingReaders* _tmp11_;
				PhotoFileReader* _tmp12_;
				_tmp11_ = self->priv->readers;
				_tmp12_ = _tmp11_->editable;
				editable_file_format = photo_file_adapter_get_file_format ((PhotoFileAdapter*) _tmp12_);
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _lock_error_ = NULL;
			GError* _tmp13_;
			_lock_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp13_ = _lock_error_;
			_lock_error_ = NULL;
			_inner_error0_ = _tmp13_;
			_g_error_free0 (_lock_error_);
			goto __finally0;
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			PhotoBackingReaders* _tmp14_;
			_tmp14_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (create_editable_file);
			_g_object_unref0 (current_editable_file);
			return NULL;
		}
	}
	_tmp17_ = create_editable_file;
	if (_tmp17_ == NULL) {
		GFile* _tmp18_;
		_tmp18_ = current_editable_file;
		_tmp16_ = _tmp18_ != NULL;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		gboolean _tmp19_ = FALSE;
		GFile* _tmp20_;
		_tmp20_ = current_editable_file;
		if (!g_file_query_exists (_tmp20_, NULL)) {
			_tmp19_ = TRUE;
		} else {
			_tmp19_ = photo_has_transformations (self);
		}
		_tmp15_ = _tmp19_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		GFile* _tmp21_;
		GFile* _tmp22_;
		_tmp21_ = current_editable_file;
		_tmp22_ = _g_object_ref0 (_tmp21_);
		_g_object_unref0 (create_editable_file);
		create_editable_file = _tmp22_;
	}
	_tmp24_ = create_editable_file;
	if (_tmp24_ != NULL) {
		_tmp23_ = photo_file_format_can_write (editable_file_format);
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		GFile* _tmp35_;
		GFile* _tmp36_;
		GFile* _tmp37_;
		photo_halt_monitoring_editable (self);
		{
			GFile* _tmp25_;
			Scaling _tmp26_ = {0};
			_tmp25_ = create_editable_file;
			scaling_for_original (&_tmp26_);
			photo_export (self, _tmp25_, &_tmp26_, JPEG_QUALITY_MAXIMUM, editable_file_format, FALSE, TRUE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GError* _tmp33_;
			GError* _tmp34_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			{
				GFile* _tmp27_;
				_tmp27_ = create_editable_file;
				g_file_delete (_tmp27_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* delete_err = NULL;
				GFile* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				GError* _tmp31_;
				const gchar* _tmp32_;
				delete_err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp28_ = create_editable_file;
				_tmp29_ = g_file_get_path (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = delete_err;
				_tmp32_ = _tmp31_->message;
				g_warning ("Photo.vala:3878: Unable to delete editable file %s after export error:" \
" %s", _tmp30_, _tmp32_);
				_g_free0 (_tmp30_);
				_g_error_free0 (delete_err);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (err);
				_g_object_unref0 (create_editable_file);
				_g_object_unref0 (current_editable_file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp33_ = err;
			_tmp34_ = _g_error_copy0 (_tmp33_);
			_inner_error0_ = _tmp34_;
			_g_error_free0 (err);
			goto __finally1;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (create_editable_file);
			_g_object_unref0 (current_editable_file);
			return NULL;
		}
		_tmp35_ = create_editable_file;
		photo_attach_editable (self, editable_file_format, _tmp35_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (create_editable_file);
			_g_object_unref0 (current_editable_file);
			return NULL;
		}
		_tmp36_ = create_editable_file;
		_tmp37_ = _g_object_ref0 (_tmp36_);
		_g_object_unref0 (current_editable_file);
		current_editable_file = _tmp37_;
	}
	_tmp38_ = current_editable_file;
	_vala_assert (_tmp38_ != NULL, "current_editable_file != null");
	_tmp39_ = self->priv->editable_monitor;
	if (_tmp39_ == NULL) {
		GFile* _tmp40_;
		_tmp40_ = current_editable_file;
		photo_start_monitoring_editable (self, _tmp40_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (create_editable_file);
			_g_object_unref0 (current_editable_file);
			return NULL;
		}
	}
	result = current_editable_file;
	_g_object_unref0 (create_editable_file);
	return result;
}

void
photo_revert_to_master (Photo* self,
                        gboolean notify)
{
	g_return_if_fail (self != NULL);
	photo_detach_editable (self, TRUE, TRUE, notify);
}

static void
_photo_on_editable_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                        GFile* file,
                                                        GFile* other_file,
                                                        GFileMonitorEvent event_type,
                                                        gpointer self)
{
	photo_on_editable_file_changed ((Photo*) self, file, other_file, event_type);
}

static void
photo_start_monitoring_editable (Photo* self,
                                 GFile* file,
                                 GError** error)
{
	GFileMonitor* _tmp0_ = NULL;
	GFileMonitor* _tmp1_;
	GFileMonitor* _tmp2_;
	GFileMonitor* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	photo_halt_monitoring_editable (self);
	library_monitor_blacklist_file (file, "Photo.start_monitoring_editable");
	_tmp1_ = g_file_monitor (file, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->editable_monitor);
	self->priv->editable_monitor = _tmp2_;
	_tmp3_ = self->priv->editable_monitor;
	g_signal_connect_object (_tmp3_, "changed", (GCallback) _photo_on_editable_file_changed_g_file_monitor_changed, self, 0);
	_g_object_unref0 (_tmp0_);
}

static void
photo_halt_monitoring_editable (Photo* self)
{
	GFileMonitor* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFileMonitor* _tmp4_;
	guint _tmp5_;
	GFileMonitor* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->editable_monitor;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = photo_get_editable_file (self);
	file = _tmp1_;
	_tmp2_ = file;
	if (_tmp2_ != NULL) {
		GFile* _tmp3_;
		_tmp3_ = file;
		library_monitor_unblacklist_file (_tmp3_);
	}
	_tmp4_ = self->priv->editable_monitor;
	g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _photo_on_editable_file_changed_g_file_monitor_changed, self);
	_tmp6_ = self->priv->editable_monitor;
	g_file_monitor_cancel (_tmp6_);
	_g_object_unref0 (self->priv->editable_monitor);
	self->priv->editable_monitor = NULL;
	_g_object_unref0 (file);
}

static void
photo_attach_editable (Photo* self,
                       PhotoFileFormat file_format,
                       GFile* file,
                       GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	PhotoFileReader* _tmp2_;
	PhotoFileReader* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	photo_internal_remove_all_transformations (self, FALSE);
	_tmp0_ = g_file_get_path (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_create_reader (file_format, _tmp1_);
	_tmp3_ = _tmp2_;
	photo_update_editable (self, FALSE, _tmp3_, &_inner_error0_);
	_photo_file_adapter_unref0 (_tmp3_);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
photo_update_editable_attributes (Photo* self,
                                  GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	photo_update_editable (self, TRUE, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
photo_reimport_editable (Photo* self,
                         GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	photo_update_editable (self, FALSE, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
_vala_array_add24 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add25 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add26 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add27 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add28 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add29 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
photo_update_editable (Photo* self,
                       gboolean only_attributes,
                       PhotoFileReader* new_reader,
                       GError** error)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	PhotoFileReader* old_reader = NULL;
	PhotoFileReader* _tmp2_;
	PhotoFileReader* _tmp3_ = NULL;
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp5_;
	PhotoFileReader* _tmp6_;
	gboolean timestamp_changed = FALSE;
	gboolean filesize_changed = FALSE;
	gboolean is_new_editable = FALSE;
	BackingPhotoID editable_id = {0};
	BackingPhotoID _tmp7_ = {0};
	GFile* file = NULL;
	PhotoFileReader* _tmp8_;
	GFile* _tmp9_;
	DetectedPhotoInformation* detected = NULL;
	BackingPhotoRow* backing = NULL;
	GFile* _tmp10_;
	DetectedPhotoInformation* _tmp11_ = NULL;
	BackingPhotoRow* _tmp12_;
	gboolean _tmp75_ = FALSE;
	gchar** alteration_list = NULL;
	gchar** _tmp84_;
	gint alteration_list_length1;
	gint _alteration_list_size_;
	gboolean _tmp88_ = FALSE;
	gchar** _tmp92_;
	gint _tmp92__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (only_attributes) {
		_tmp1_ = new_reader == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !only_attributes;
	}
	_vala_assert (_tmp0_, "(only_attributes && new_reader == null) || (!only_attributes)");
	_tmp2_ = photo_get_editable_reader (self);
	old_reader = _tmp2_;
	_tmp3_ = new_reader;
	if (_tmp3_ == NULL) {
		PhotoFileReader* _tmp4_;
		_tmp4_ = old_reader;
		_tmp3_ = _tmp4_;
	}
	_tmp5_ = _photo_file_adapter_ref0 (_tmp3_);
	reader = _tmp5_;
	_tmp6_ = reader;
	if (_tmp6_ == NULL) {
		photo_detach_editable (self, FALSE, TRUE, TRUE);
		_photo_file_adapter_unref0 (reader);
		_photo_file_adapter_unref0 (old_reader);
		return;
	}
	timestamp_changed = FALSE;
	filesize_changed = FALSE;
	is_new_editable = FALSE;
	photo_get_editable_id (self, &_tmp7_);
	editable_id = _tmp7_;
	_tmp8_ = reader;
	_tmp9_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp8_);
	file = _tmp9_;
	_tmp10_ = file;
	_tmp12_ = photo_query_backing_photo_row (self, _tmp10_, PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5, &_tmp11_, &_inner_error0_);
	_detected_photo_information_unref0 (detected);
	detected = _tmp11_;
	backing = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_detected_photo_information_unref0 (detected);
		_g_object_unref0 (file);
		_photo_file_adapter_unref0 (reader);
		_photo_file_adapter_unref0 (old_reader);
		return;
	}
	if (backing_photo_id_is_invalid (&editable_id)) {
		BackingPhotoRow* _tmp13_;
		_tmp13_ = backing;
		if (_tmp13_ != NULL) {
			BackingPhotoTable* _tmp14_;
			BackingPhotoTable* _tmp15_;
			BackingPhotoRow* _tmp16_;
			_tmp14_ = backing_photo_table_get_instance ();
			_tmp15_ = _tmp14_;
			_tmp16_ = backing;
			backing_photo_table_add (_tmp15_, _tmp16_, &_inner_error0_);
			_database_table_unref0 (_tmp15_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_backing_photo_row_unref0 (backing);
				_detected_photo_information_unref0 (detected);
				_g_object_unref0 (file);
				_photo_file_adapter_unref0 (reader);
				_photo_file_adapter_unref0 (old_reader);
				return;
			}
			{
				PhotoRow* _tmp17_;
				_tmp17_ = self->row;
				g_rec_mutex_lock (&self->priv->__lock_row);
				{
					PhotoTable* _tmp18_;
					PhotoTable* _tmp19_;
					PhotoRow* _tmp20_;
					BackingPhotoRow* _tmp21_;
					BackingPhotoID _tmp22_;
					BackingPhotoRow* _tmp23_;
					BackingPhotoRow* _tmp24_;
					BackingPhotoRow* _tmp25_;
					BackingPhotoRow* _tmp26_;
					BackingPhotoRow* _tmp27_;
					timestamp_changed = TRUE;
					filesize_changed = TRUE;
					_tmp18_ = photo_table_get_instance ();
					_tmp19_ = _tmp18_;
					_tmp20_ = self->row;
					_tmp21_ = backing;
					_tmp22_ = _tmp21_->id;
					photo_table_attach_editable (_tmp19_, _tmp20_, &_tmp22_, &_inner_error0_);
					_database_table_unref0 (_tmp19_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp23_ = backing;
					_tmp24_ = _backing_photo_row_ref0 (_tmp23_);
					_backing_photo_row_unref0 (self->priv->editable);
					self->priv->editable = _tmp24_;
					_tmp25_ = self->priv->editable;
					_tmp26_ = _backing_photo_row_ref0 (_tmp25_);
					_backing_photo_row_unref0 (self->backing_photo_row);
					self->backing_photo_row = _tmp26_;
					_tmp27_ = self->backing_photo_row;
					photo_set_orientation (self, _tmp27_->original_orientation);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* _lock_error_ = NULL;
					GError* _tmp28_;
					_lock_error_ = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp28_ = _lock_error_;
					_lock_error_ = NULL;
					_inner_error0_ = _tmp28_;
					_g_error_free0 (_lock_error_);
					goto __finally0;
				}
				__finally0:
				{
					GError* _inner_error1_ = NULL;
					PhotoRow* _tmp29_;
					_tmp29_ = self->row;
					g_rec_mutex_unlock (&self->priv->__lock_row);
				}
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_backing_photo_row_unref0 (backing);
					_detected_photo_information_unref0 (detected);
					_g_object_unref0 (file);
					_photo_file_adapter_unref0 (reader);
					_photo_file_adapter_unref0 (old_reader);
					return;
				}
			}
		}
		is_new_editable = TRUE;
	}
	if (only_attributes) {
		GFileInfo* info = NULL;
		gint64 mod_time = 0LL;
		GFileInfo* _tmp38_;
		GDateTime* _tmp39_;
		GDateTime* _tmp40_;
		gint64 _tmp41_;
		BackingPhotoTable* _tmp42_;
		BackingPhotoTable* _tmp43_;
		BackingPhotoID _tmp44_;
		GFileInfo* _tmp45_;
		_vala_assert (backing_photo_id_is_valid (&editable_id), "editable_id.is_valid ()");
		{
			GFileInfo* _tmp30_ = NULL;
			GFile* _tmp31_;
			GFileInfo* _tmp32_;
			GFileInfo* _tmp33_;
			_tmp31_ = file;
			_tmp32_ = g_file_query_filesystem_info (_tmp31_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, NULL, &_inner_error0_);
			_tmp30_ = _tmp32_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp33_ = _tmp30_;
			_tmp30_ = NULL;
			_g_object_unref0 (info);
			info = _tmp33_;
			_g_object_unref0 (_tmp30_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			gchar* _tmp34_;
			gchar* _tmp35_;
			GError* _tmp36_;
			const gchar* _tmp37_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp34_ = data_object_to_string ((DataObject*) self);
			_tmp35_ = _tmp34_;
			_tmp36_ = err;
			_tmp37_ = _tmp36_->message;
			g_warning ("Photo.vala:4000: Unable to read editable filesystem info for %s: %s", _tmp35_, _tmp37_);
			_g_free0 (_tmp35_);
			photo_detach_editable (self, FALSE, TRUE, TRUE);
			_g_error_free0 (err);
			_g_object_unref0 (info);
			_backing_photo_row_unref0 (backing);
			_detected_photo_information_unref0 (detected);
			_g_object_unref0 (file);
			_photo_file_adapter_unref0 (reader);
			_photo_file_adapter_unref0 (old_reader);
			return;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (info);
			_backing_photo_row_unref0 (backing);
			_detected_photo_information_unref0 (detected);
			_g_object_unref0 (file);
			_photo_file_adapter_unref0 (reader);
			_photo_file_adapter_unref0 (old_reader);
			return;
		}
		_tmp38_ = info;
		_tmp39_ = g_file_info_get_modification_date_time (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_date_time_to_unix (_tmp40_);
		_g_date_time_unref0 (_tmp40_);
		mod_time = _tmp41_;
		_tmp42_ = backing_photo_table_get_instance ();
		_tmp43_ = _tmp42_;
		_tmp44_ = editable_id;
		_tmp45_ = info;
		backing_photo_table_update_attributes (_tmp43_, &_tmp44_, mod_time, g_file_info_get_size (_tmp45_), &_inner_error0_);
		_database_table_unref0 (_tmp43_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (info);
			_backing_photo_row_unref0 (backing);
			_detected_photo_information_unref0 (detected);
			_g_object_unref0 (file);
			_photo_file_adapter_unref0 (reader);
			_photo_file_adapter_unref0 (old_reader);
			return;
		}
		{
			PhotoRow* _tmp46_;
			_tmp46_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				BackingPhotoRow* _tmp47_;
				BackingPhotoRow* _tmp48_;
				GFileInfo* _tmp49_;
				BackingPhotoRow* _tmp50_;
				BackingPhotoRow* _tmp51_;
				GFileInfo* _tmp52_;
				_tmp47_ = self->priv->editable;
				timestamp_changed = _tmp47_->timestamp != mod_time;
				_tmp48_ = self->priv->editable;
				_tmp49_ = info;
				filesize_changed = _tmp48_->filesize != g_file_info_get_size (_tmp49_);
				_tmp50_ = self->priv->editable;
				_tmp50_->timestamp = mod_time;
				_tmp51_ = self->priv->editable;
				_tmp52_ = info;
				_tmp51_->filesize = g_file_info_get_size (_tmp52_);
			}
			__finally2:
			{
				PhotoRow* _tmp53_;
				_tmp53_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (info);
				_backing_photo_row_unref0 (backing);
				_detected_photo_information_unref0 (detected);
				_g_object_unref0 (file);
				_photo_file_adapter_unref0 (reader);
				_photo_file_adapter_unref0 (old_reader);
				return;
			}
		}
		_g_object_unref0 (info);
	} else {
		gboolean _tmp54_ = FALSE;
		if (backing_photo_id_is_valid (&editable_id)) {
			_tmp54_ = !is_new_editable;
		} else {
			_tmp54_ = FALSE;
		}
		if (_tmp54_) {
			BackingPhotoRow* _tmp55_;
			BackingPhotoID _tmp56_;
			BackingPhotoTable* _tmp57_;
			BackingPhotoTable* _tmp58_;
			BackingPhotoRow* _tmp59_;
			_tmp55_ = backing;
			_tmp56_ = editable_id;
			_tmp55_->id = _tmp56_;
			_tmp57_ = backing_photo_table_get_instance ();
			_tmp58_ = _tmp57_;
			_tmp59_ = backing;
			backing_photo_table_update (_tmp58_, _tmp59_, &_inner_error0_);
			_database_table_unref0 (_tmp58_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_backing_photo_row_unref0 (backing);
				_detected_photo_information_unref0 (detected);
				_g_object_unref0 (file);
				_photo_file_adapter_unref0 (reader);
				_photo_file_adapter_unref0 (old_reader);
				return;
			}
			{
				PhotoRow* _tmp60_;
				_tmp60_ = self->row;
				g_rec_mutex_lock (&self->priv->__lock_row);
				{
					BackingPhotoRow* _tmp61_;
					BackingPhotoRow* _tmp62_;
					BackingPhotoRow* _tmp63_;
					BackingPhotoRow* _tmp64_;
					BackingPhotoRow* _tmp65_;
					BackingPhotoRow* _tmp66_;
					BackingPhotoRow* _tmp67_;
					BackingPhotoRow* _tmp68_;
					BackingPhotoRow* _tmp69_;
					_tmp61_ = self->priv->editable;
					_tmp62_ = backing;
					timestamp_changed = _tmp61_->timestamp != _tmp62_->timestamp;
					_tmp63_ = self->priv->editable;
					_tmp64_ = backing;
					filesize_changed = _tmp63_->filesize != _tmp64_->filesize;
					_tmp65_ = backing;
					_tmp66_ = _backing_photo_row_ref0 (_tmp65_);
					_backing_photo_row_unref0 (self->priv->editable);
					self->priv->editable = _tmp66_;
					_tmp67_ = self->priv->editable;
					_tmp68_ = _backing_photo_row_ref0 (_tmp67_);
					_backing_photo_row_unref0 (self->backing_photo_row);
					self->backing_photo_row = _tmp68_;
					_tmp69_ = self->backing_photo_row;
					photo_set_orientation (self, _tmp69_->original_orientation);
				}
				__finally3:
				{
					PhotoRow* _tmp70_;
					_tmp70_ = self->row;
					g_rec_mutex_unlock (&self->priv->__lock_row);
				}
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_backing_photo_row_unref0 (backing);
					_detected_photo_information_unref0 (detected);
					_g_object_unref0 (file);
					_photo_file_adapter_unref0 (reader);
					_photo_file_adapter_unref0 (old_reader);
					return;
				}
			}
		}
	}
	if (new_reader != NULL) {
		{
			PhotoBackingReaders* _tmp71_;
			_tmp71_ = self->priv->readers;
			g_rec_mutex_lock (&self->priv->__lock_readers);
			{
				PhotoBackingReaders* _tmp72_;
				PhotoFileReader* _tmp73_;
				_tmp72_ = self->priv->readers;
				_tmp73_ = _photo_file_adapter_ref0 (new_reader);
				_photo_file_adapter_unref0 (_tmp72_->editable);
				_tmp72_->editable = _tmp73_;
			}
			__finally4:
			{
				PhotoBackingReaders* _tmp74_;
				_tmp74_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_backing_photo_row_unref0 (backing);
				_detected_photo_information_unref0 (detected);
				_g_object_unref0 (file);
				_photo_file_adapter_unref0 (reader);
				_photo_file_adapter_unref0 (old_reader);
				return;
			}
		}
	}
	if (!only_attributes) {
		PhotoFileReader* _tmp76_;
		PhotoFileReader* _tmp77_;
		_tmp76_ = reader;
		_tmp77_ = old_reader;
		_tmp75_ = _tmp76_ != _tmp77_;
	} else {
		_tmp75_ = FALSE;
	}
	if (_tmp75_) {
		GFile* _tmp78_ = NULL;
		PhotoFileReader* _tmp79_;
		GFile* _tmp82_ = NULL;
		photo_notify_baseline_replaced (self);
		_tmp79_ = old_reader;
		if (_tmp79_ != NULL) {
			PhotoFileReader* _tmp80_;
			GFile* _tmp81_;
			_tmp80_ = old_reader;
			_tmp81_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp80_);
			_g_object_unref0 (_tmp78_);
			_tmp78_ = _tmp81_;
		} else {
			_g_object_unref0 (_tmp78_);
			_tmp78_ = NULL;
		}
		if (new_reader != NULL) {
			GFile* _tmp83_;
			_tmp83_ = photo_file_adapter_get_file ((PhotoFileAdapter*) new_reader);
			_g_object_unref0 (_tmp82_);
			_tmp82_ = _tmp83_;
		} else {
			_g_object_unref0 (_tmp82_);
			_tmp82_ = NULL;
		}
		photo_notify_editable_replaced (self, _tmp78_, _tmp82_);
		_g_object_unref0 (_tmp82_);
		_g_object_unref0 (_tmp78_);
	}
	_tmp84_ = g_new0 (gchar*, 0 + 1);
	alteration_list = _tmp84_;
	alteration_list_length1 = 0;
	_alteration_list_size_ = alteration_list_length1;
	if (timestamp_changed) {
		gchar* _tmp85_;
		gchar* _tmp86_;
		_tmp85_ = g_strdup ("metadata:editable-timestamp");
		_vala_array_add24 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp85_);
		_tmp86_ = g_strdup ("metadata:baseline-timestamp");
		_vala_array_add25 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp86_);
		if (photo_is_editable_source (self)) {
			gchar* _tmp87_;
			_tmp87_ = g_strdup ("metadata:source-timestamp");
			_vala_array_add26 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp87_);
		}
	}
	if (filesize_changed) {
		_tmp88_ = TRUE;
	} else {
		_tmp88_ = new_reader != NULL;
	}
	if (_tmp88_) {
		gchar* _tmp89_;
		gchar* _tmp90_;
		_tmp89_ = g_strdup ("image:editable");
		_vala_array_add27 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp89_);
		_tmp90_ = g_strdup ("image:baseline");
		_vala_array_add28 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp90_);
		if (photo_is_editable_source (self)) {
			gchar* _tmp91_;
			_tmp91_ = g_strdup ("image:source");
			_vala_array_add29 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp91_);
		}
	}
	_tmp92_ = alteration_list;
	_tmp92__length1 = alteration_list_length1;
	if (_tmp92__length1 > 0) {
		gchar** _tmp93_;
		gint _tmp93__length1;
		Alteration* _tmp94_;
		Alteration* _tmp95_;
		_tmp93_ = alteration_list;
		_tmp93__length1 = alteration_list_length1;
		_tmp94_ = alteration_new_from_array (_tmp93_, _tmp93__length1);
		_tmp95_ = _tmp94_;
		data_object_notify_altered ((DataObject*) self, _tmp95_);
		_alteration_unref0 (_tmp95_);
	}
	alteration_list = (_vala_array_free (alteration_list, alteration_list_length1, (GDestroyNotify) g_free), NULL);
	_backing_photo_row_unref0 (backing);
	_detected_photo_information_unref0 (detected);
	_g_object_unref0 (file);
	_photo_file_adapter_unref0 (reader);
	_photo_file_adapter_unref0 (old_reader);
}

static void
photo_detach_editable (Photo* self,
                       gboolean delete_editable,
                       gboolean remove_transformations,
                       gboolean notify)
{
	gboolean has_editable = FALSE;
	GFile* editable_file = NULL;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	photo_halt_monitoring_editable (self);
	has_editable = FALSE;
	editable_file = NULL;
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			if (_tmp2_ != NULL) {
				PhotoBackingReaders* _tmp3_;
				PhotoFileReader* _tmp4_;
				GFile* _tmp5_;
				PhotoBackingReaders* _tmp6_;
				_tmp3_ = self->priv->readers;
				_tmp4_ = _tmp3_->editable;
				_tmp5_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp4_);
				_g_object_unref0 (editable_file);
				editable_file = _tmp5_;
				_tmp6_ = self->priv->readers;
				_photo_file_adapter_unref0 (_tmp6_->editable);
				_tmp6_->editable = NULL;
				has_editable = TRUE;
			}
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp7_;
			_tmp7_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (editable_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (has_editable) {
		BackingPhotoID editable_id = {0};
		backing_photo_id_init (&editable_id, BACKING_PHOTO_ID_INVALID);
		{
			{
				PhotoRow* _tmp8_;
				_tmp8_ = self->row;
				g_rec_mutex_lock (&self->priv->__lock_row);
				{
					PhotoRow* _tmp9_;
					BackingPhotoID _tmp10_;
					PhotoRow* _tmp14_;
					BackingPhotoRow* _tmp15_;
					BackingPhotoRow* _tmp16_;
					_tmp9_ = self->row;
					_tmp10_ = _tmp9_->editable_id;
					editable_id = _tmp10_;
					if (backing_photo_id_is_valid (&editable_id)) {
						PhotoTable* _tmp11_;
						PhotoTable* _tmp12_;
						PhotoRow* _tmp13_;
						_tmp11_ = photo_table_get_instance ();
						_tmp12_ = _tmp11_;
						_tmp13_ = self->row;
						photo_table_detach_editable (_tmp12_, _tmp13_, &_inner_error0_);
						_database_table_unref0 (_tmp12_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch2_g_error;
						}
					}
					_tmp14_ = self->row;
					_tmp15_ = _tmp14_->master;
					_tmp16_ = _backing_photo_row_ref0 (_tmp15_);
					_backing_photo_row_unref0 (self->backing_photo_row);
					self->backing_photo_row = _tmp16_;
				}
				goto __finally2;
				__catch2_g_error:
				{
					GError* _lock_error_ = NULL;
					GError* _tmp17_;
					_lock_error_ = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp17_ = _lock_error_;
					_lock_error_ = NULL;
					_inner_error0_ = _tmp17_;
					_g_error_free0 (_lock_error_);
					goto __finally2;
				}
				__finally2:
				{
					GError* _inner_error1_ = NULL;
					PhotoRow* _tmp18_;
					_tmp18_ = self->row;
					g_rec_mutex_unlock (&self->priv->__lock_row);
				}
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch1_database_error;
					}
					goto __finally1;
				}
			}
		}
		goto __finally1;
		__catch1_database_error:
		{
			GError* err = NULL;
			GError* _tmp19_;
			const gchar* _tmp20_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp19_ = err;
			_tmp20_ = _tmp19_->message;
			g_warning ("Photo.vala:4098: Unable to remove editable from PhotoTable: %s", _tmp20_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (editable_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			if (backing_photo_id_is_valid (&editable_id)) {
				BackingPhotoTable* _tmp21_;
				BackingPhotoTable* _tmp22_;
				BackingPhotoID _tmp23_;
				_tmp21_ = backing_photo_table_get_instance ();
				_tmp22_ = _tmp21_;
				_tmp23_ = editable_id;
				backing_photo_table_remove (_tmp22_, &_tmp23_, &_inner_error0_);
				_database_table_unref0 (_tmp22_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch3_database_error;
					}
					_g_object_unref0 (editable_file);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
		goto __finally3;
		__catch3_database_error:
		{
			GError* err = NULL;
			GError* _tmp24_;
			const gchar* _tmp25_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp24_ = err;
			_tmp25_ = _tmp24_->message;
			g_warning ("Photo.vala:4106: Unable to remove editable from BackingPhotoTable: %s", _tmp25_);
			_g_error_free0 (err);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (editable_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (remove_transformations) {
		photo_internal_remove_all_transformations (self, FALSE);
	}
	if (has_editable) {
		GFile* _tmp26_;
		photo_notify_baseline_replaced (self);
		_tmp26_ = editable_file;
		photo_notify_editable_replaced (self, _tmp26_, NULL);
	}
	if (delete_editable) {
		GFile* _tmp28_;
		_tmp28_ = editable_file;
		_tmp27_ = _tmp28_ != NULL;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		{
			GFile* _tmp29_;
			_tmp29_ = editable_file;
			g_file_trash (_tmp29_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch4_g_error;
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* err = NULL;
			GFile* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			GError* _tmp35_;
			const gchar* _tmp36_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp30_ = editable_file;
			_tmp31_ = g_file_get_path (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = data_object_to_string ((DataObject*) self);
			_tmp34_ = _tmp33_;
			_tmp35_ = err;
			_tmp36_ = _tmp35_->message;
			g_warning ("Photo.vala:4123: Unable to trash editable %s for %s: %s", _tmp32_, _tmp34_, _tmp36_);
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
			_g_error_free0 (err);
		}
		__finally4:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (editable_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (has_editable) {
		_tmp38_ = TRUE;
	} else {
		_tmp38_ = remove_transformations;
	}
	if (_tmp38_) {
		_tmp37_ = notify;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		Alteration* _tmp39_;
		Alteration* _tmp40_;
		_tmp39_ = alteration_new ("image", "revert");
		_tmp40_ = _tmp39_;
		data_object_notify_altered ((DataObject*) self, _tmp40_);
		_alteration_unref0 (_tmp40_);
	}
	_g_object_unref0 (editable_file);
}

static void
_photo_on_reimport_editable_one_shot_callback (gpointer self)
{
	photo_on_reimport_editable ((Photo*) self);
}

static void
_photo_on_update_editable_attributes_one_shot_callback (gpointer self)
{
	photo_on_update_editable_attributes ((Photo*) self);
}

static void
_photo_on_remove_editable_one_shot_callback (gpointer self)
{
	photo_on_remove_editable ((Photo*) self);
}

static void
photo_on_editable_file_changed (Photo* self,
                                GFile* file,
                                GFile* other_file,
                                GFileMonitorEvent event)
{
	GEnumValue* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			gboolean _tmp1_ = FALSE;
			PhotoBackingReaders* _tmp2_;
			PhotoFileReader* _tmp3_;
			_tmp2_ = self->priv->readers;
			_tmp3_ = _tmp2_->editable;
			if (_tmp3_ != NULL) {
				PhotoBackingReaders* _tmp4_;
				PhotoFileReader* _tmp5_;
				GFile* _tmp6_;
				GFile* _tmp7_;
				_tmp4_ = self->priv->readers;
				_tmp5_ = _tmp4_->editable;
				_tmp6_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp1_ = g_file_equal (file, _tmp7_);
				_g_object_unref0 (_tmp7_);
			} else {
				_tmp1_ = FALSE;
			}
			_vala_assert (_tmp1_, "readers.editable != null && file.equal (readers.editable.get_file ())");
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp8_;
			_tmp8_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp9_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), event);
	_tmp10_ = g_file_get_path (file);
	_tmp11_ = _tmp10_;
	g_debug ("Photo.vala:4139: EDITABLE %s: %s", (_tmp9_ != NULL) ? _tmp9_->value_name : NULL, _tmp11_);
	_g_free0 (_tmp11_);
	switch (event) {
		case G_FILE_MONITOR_EVENT_CHANGED:
		case G_FILE_MONITOR_EVENT_CREATED:
		{
			OneShotScheduler* _tmp12_;
			OneShotScheduler* _tmp14_;
			_tmp12_ = self->priv->reimport_editable_scheduler;
			if (_tmp12_ == NULL) {
				OneShotScheduler* _tmp13_;
				_tmp13_ = one_shot_scheduler_new ("Photo.reimport_editable", _photo_on_reimport_editable_one_shot_callback, self);
				_one_shot_scheduler_unref0 (self->priv->reimport_editable_scheduler);
				self->priv->reimport_editable_scheduler = _tmp13_;
			}
			_tmp14_ = self->priv->reimport_editable_scheduler;
			one_shot_scheduler_after_timeout (_tmp14_, (guint) 1000, TRUE);
			break;
		}
		case G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED:
		{
			OneShotScheduler* _tmp15_;
			OneShotScheduler* _tmp17_;
			_tmp15_ = self->priv->update_editable_attributes_scheduler;
			if (_tmp15_ == NULL) {
				OneShotScheduler* _tmp16_;
				_tmp16_ = one_shot_scheduler_new ("Photo.update_editable_attributes", _photo_on_update_editable_attributes_one_shot_callback, self);
				_one_shot_scheduler_unref0 (self->priv->update_editable_attributes_scheduler);
				self->priv->update_editable_attributes_scheduler = _tmp16_;
			}
			_tmp17_ = self->priv->update_editable_attributes_scheduler;
			one_shot_scheduler_after_timeout (_tmp17_, (guint) 1000, TRUE);
			break;
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			OneShotScheduler* _tmp18_;
			OneShotScheduler* _tmp20_;
			_tmp18_ = self->priv->remove_editable_scheduler;
			if (_tmp18_ == NULL) {
				OneShotScheduler* _tmp19_;
				_tmp19_ = one_shot_scheduler_new ("Photo.remove_editable", _photo_on_remove_editable_one_shot_callback, self);
				_one_shot_scheduler_unref0 (self->priv->remove_editable_scheduler);
				self->priv->remove_editable_scheduler = _tmp19_;
			}
			_tmp20_ = self->priv->remove_editable_scheduler;
			one_shot_scheduler_after_timeout (_tmp20_, (guint) 3000, TRUE);
			break;
		}
		default:
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
		{
			break;
		}
	}
	photo_discard_prefetched (self, TRUE);
}

static void
photo_on_reimport_editable (Photo* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	photo_discard_prefetched (self, TRUE);
	_tmp0_ = data_object_to_string ((DataObject*) self);
	_tmp1_ = _tmp0_;
	g_debug ("Photo.vala:4185: Reimporting editable for %s", _tmp1_);
	_g_free0 (_tmp1_);
	{
		photo_reimport_editable (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = data_object_to_string ((DataObject*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_warning ("Photo.vala:4189: Unable to reimport photo %s changed by external edito" \
"r: %s", _tmp3_, _tmp5_);
		_g_free0 (_tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
photo_on_update_editable_attributes (Photo* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = data_object_to_string ((DataObject*) self);
	_tmp1_ = _tmp0_;
	g_debug ("Photo.vala:4195: Updating editable attributes for %s", _tmp1_);
	_g_free0 (_tmp1_);
	{
		photo_update_editable_attributes (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_warning ("Photo.vala:4199: Unable to update editable attributes: %s", _tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
photo_on_remove_editable (Photo* self)
{
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* file = NULL;
	PhotoFileReader* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = photo_get_editable_reader (self);
	reader = _tmp0_;
	_tmp1_ = reader;
	if (_tmp1_ == NULL) {
		_photo_file_adapter_unref0 (reader);
		return;
	}
	_tmp2_ = reader;
	_tmp3_ = photo_file_adapter_get_file ((PhotoFileAdapter*) _tmp2_);
	file = _tmp3_;
	_tmp4_ = file;
	if (g_file_query_exists (_tmp4_, NULL)) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = data_object_to_string ((DataObject*) self);
		_tmp6_ = _tmp5_;
		g_debug ("Photo.vala:4211: Not removing editable for %s: file exists", _tmp6_);
		_g_free0 (_tmp6_);
		_g_object_unref0 (file);
		_photo_file_adapter_unref0 (reader);
		return;
	}
	_tmp7_ = data_object_to_string ((DataObject*) self);
	_tmp8_ = _tmp7_;
	g_debug ("Photo.vala:4216: Removing editable for %s: file no longer exists", _tmp8_);
	_g_free0 (_tmp8_);
	photo_detach_editable (self, FALSE, TRUE, TRUE);
	_g_object_unref0 (file);
	_photo_file_adapter_unref0 (reader);
}

void
photo_get_original_dimensions (Photo* self,
                               Dimensions* result)
{
	Dimensions dim = {0};
	Dimensions _tmp0_ = {0};
	Orientation orientation = 0;
	Dimensions _tmp1_;
	Dimensions _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	photo_get_raw_dimensions (self, &_tmp0_);
	dim = _tmp0_;
	orientation = photo_get_orientation (self);
	_tmp1_ = dim;
	orientation_rotate_dimensions (orientation, &_tmp1_, &_tmp2_);
	*result = _tmp2_;
	return;
}

void
photo_get_master_dimensions (Photo* self,
                             Dimensions* result)
{
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	photo_get_raw_dimensions (self, &_tmp0_);
	orientation_rotate_dimensions (photo_get_original_orientation (self), &_tmp0_, &_tmp1_);
	*result = _tmp1_;
	return;
}

gboolean
photo_get_crop (Photo* self,
                Box* crop,
                PhotoException exceptions)
{
	Box _vala_crop = {0};
	Box raw = {0};
	Box _tmp0_ = {0};
	gboolean _tmp1_;
	Dimensions dim = {0};
	Dimensions _tmp2_ = {0};
	Orientation orientation = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = photo_get_raw_crop (self, &_tmp0_);
	raw = _tmp0_;
	if (!_tmp1_) {
		box_init (&_vala_crop, 0, 0, 0, 0);
		result = FALSE;
		if (crop) {
			*crop = _vala_crop;
		}
		return result;
	}
	media_source_get_dimensions ((MediaSource*) self, PHOTO_EXCEPTION_CROP | PHOTO_EXCEPTION_ORIENTATION, &_tmp2_);
	dim = _tmp2_;
	orientation = photo_get_orientation (self);
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
		Dimensions _tmp3_;
		Box _tmp4_;
		Box _tmp5_ = {0};
		_tmp3_ = dim;
		_tmp4_ = raw;
		orientation_rotate_box (orientation, &_tmp3_, &_tmp4_, &_tmp5_);
		_vala_crop = _tmp5_;
	} else {
		Box _tmp6_;
		_tmp6_ = raw;
		_vala_crop = _tmp6_;
	}
	result = TRUE;
	if (crop) {
		*crop = _vala_crop;
	}
	return result;
}

void
photo_set_crop (Photo* self,
                Box* crop)
{
	Dimensions dim = {0};
	Dimensions _tmp0_ = {0};
	Orientation orientation = 0;
	Box derotated = {0};
	Dimensions _tmp1_;
	Box _tmp2_;
	Box _tmp3_ = {0};
	Box _tmp4_;
	Dimensions _tmp5_;
	Box _tmp6_;
	Box _tmp7_;
	Dimensions _tmp8_;
	Box _tmp9_;
	Dimensions _tmp10_;
	Box _tmp11_;
	Box _tmp12_;
	Dimensions _tmp13_;
	Box _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (crop != NULL);
	media_source_get_dimensions ((MediaSource*) self, PHOTO_EXCEPTION_CROP | PHOTO_EXCEPTION_ORIENTATION, &_tmp0_);
	dim = _tmp0_;
	orientation = photo_get_orientation (self);
	_tmp1_ = dim;
	_tmp2_ = *crop;
	orientation_derotate_box (orientation, &_tmp1_, &_tmp2_, &_tmp3_);
	derotated = _tmp3_;
	_tmp4_ = derotated;
	_tmp5_ = dim;
	derotated.left = CLAMP (_tmp4_.left, 0, _tmp5_.width - 2);
	_tmp6_ = derotated;
	_tmp7_ = derotated;
	_tmp8_ = dim;
	derotated.right = CLAMP (_tmp6_.right, _tmp7_.left, _tmp8_.width - 1);
	_tmp9_ = derotated;
	_tmp10_ = dim;
	derotated.top = CLAMP (_tmp9_.top, 0, _tmp10_.height - 2);
	_tmp11_ = derotated;
	_tmp12_ = derotated;
	_tmp13_ = dim;
	derotated.bottom = CLAMP (_tmp11_.bottom, _tmp12_.top, _tmp13_.height - 1);
	_tmp14_ = derotated;
	photo_set_raw_crop (self, &_tmp14_);
}

gboolean
photo_get_straighten (Photo* self,
                      gdouble* theta)
{
	gdouble _vala_theta = 0.0;
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = photo_get_raw_straighten (self, &_tmp0_);
	_vala_theta = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		if (theta) {
			*theta = _vala_theta;
		}
		return result;
	}
	result = TRUE;
	if (theta) {
		*theta = _vala_theta;
	}
	return result;
}

void
photo_set_straighten (Photo* self,
                      gdouble theta)
{
	g_return_if_fail (self != NULL);
	photo_set_raw_straighten (self, theta);
}

static GdkPixbuf*
photo_do_redeye (Photo* self,
                 GdkPixbuf* pixbuf,
                 EditingToolsRedeyeInstance* inst)
{
	gdouble r = 0.0;
	EditingToolsRedeyeInstance _tmp0_;
	gint* x_insets_first_quadrant = NULL;
	EditingToolsRedeyeInstance _tmp1_;
	gint* _tmp2_;
	gint x_insets_first_quadrant_length1;
	gint _x_insets_first_quadrant_size_;
	gint i = 0;
	gint x_bounds_min = 0;
	EditingToolsRedeyeInstance _tmp7_;
	GdkPoint _tmp8_;
	EditingToolsRedeyeInstance _tmp9_;
	gint x_bounds_max = 0;
	EditingToolsRedeyeInstance _tmp10_;
	GdkPoint _tmp11_;
	EditingToolsRedeyeInstance _tmp12_;
	gint ymin = 0;
	EditingToolsRedeyeInstance _tmp13_;
	GdkPoint _tmp14_;
	EditingToolsRedeyeInstance _tmp15_;
	gint _tmp16_ = 0;
	gint ymax = 0;
	EditingToolsRedeyeInstance _tmp17_;
	GdkPoint _tmp18_;
	gint _tmp19_ = 0;
	gint _tmp20_;
	gint _tmp21_;
	gint inset_index = 0;
	EditingToolsRedeyeInstance _tmp41_;
	GdkPoint _tmp42_;
	EditingToolsRedeyeInstance _tmp43_;
	GdkPoint _tmp44_;
	EditingToolsRedeyeInstance _tmp45_;
	gint* _tmp46_;
	gint _tmp46__length1;
	GdkPixbuf* _tmp64_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pixbuf != NULL, NULL);
	g_return_val_if_fail (inst != NULL, NULL);
	_tmp0_ = *inst;
	r = (gdouble) _tmp0_.radius;
	_tmp1_ = *inst;
	_tmp2_ = g_new0 (gint, _tmp1_.radius + 1);
	x_insets_first_quadrant = _tmp2_;
	x_insets_first_quadrant_length1 = _tmp1_.radius + 1;
	_x_insets_first_quadrant_size_ = x_insets_first_quadrant_length1;
	i = 0;
	{
		gdouble y = 0.0;
		y = r;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gdouble theta = 0.0;
				gint x = 0;
				gint* _tmp4_;
				gint _tmp4__length1;
				EditingToolsRedeyeInstance _tmp5_;
				gint _tmp6_;
				if (!_tmp3_) {
					y -= 1.0;
				}
				_tmp3_ = FALSE;
				if (!(y >= 0.0)) {
					break;
				}
				theta = asin (y / r);
				x = (gint) ((r * cos (theta)) + 0.5);
				_tmp4_ = x_insets_first_quadrant;
				_tmp4__length1 = x_insets_first_quadrant_length1;
				_tmp5_ = *inst;
				_tmp4_[i] = _tmp5_.radius - x;
				_tmp6_ = i;
				i = _tmp6_ + 1;
			}
		}
	}
	_tmp7_ = *inst;
	_tmp8_ = _tmp7_.center;
	_tmp9_ = *inst;
	x_bounds_min = _tmp8_.x - _tmp9_.radius;
	_tmp10_ = *inst;
	_tmp11_ = _tmp10_.center;
	_tmp12_ = *inst;
	x_bounds_max = _tmp11_.x + _tmp12_.radius;
	_tmp13_ = *inst;
	_tmp14_ = _tmp13_.center;
	_tmp15_ = *inst;
	ymin = _tmp14_.y - _tmp15_.radius;
	if (ymin < 0) {
		_tmp16_ = 0;
	} else {
		_tmp16_ = ymin;
	}
	ymin = _tmp16_;
	_tmp17_ = *inst;
	_tmp18_ = _tmp17_.center;
	ymax = _tmp18_.y;
	_tmp20_ = gdk_pixbuf_get_height (pixbuf);
	_tmp21_ = _tmp20_;
	if (ymax > (_tmp21_ - 1)) {
		gint _tmp22_;
		gint _tmp23_;
		_tmp22_ = gdk_pixbuf_get_height (pixbuf);
		_tmp23_ = _tmp22_;
		_tmp19_ = _tmp23_ - 1;
	} else {
		_tmp19_ = ymax;
	}
	ymax = _tmp19_;
	inset_index = 0;
	{
		gint y_it = 0;
		y_it = ymin;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				gint xmin = 0;
				gint* _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				gint _tmp28_ = 0;
				gint xmax = 0;
				gint* _tmp29_;
				gint _tmp29__length1;
				gint _tmp30_;
				gint _tmp31_ = 0;
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp40_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = y_it;
					y_it = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(y_it <= ymax)) {
					break;
				}
				_tmp26_ = x_insets_first_quadrant;
				_tmp26__length1 = x_insets_first_quadrant_length1;
				_tmp27_ = _tmp26_[inset_index];
				xmin = x_bounds_min + _tmp27_;
				if (xmin < 0) {
					_tmp28_ = 0;
				} else {
					_tmp28_ = xmin;
				}
				xmin = _tmp28_;
				_tmp29_ = x_insets_first_quadrant;
				_tmp29__length1 = x_insets_first_quadrant_length1;
				_tmp30_ = _tmp29_[inset_index];
				xmax = x_bounds_max - _tmp30_;
				_tmp32_ = gdk_pixbuf_get_width (pixbuf);
				_tmp33_ = _tmp32_;
				if (xmax > (_tmp33_ - 1)) {
					gint _tmp34_;
					gint _tmp35_;
					_tmp34_ = gdk_pixbuf_get_width (pixbuf);
					_tmp35_ = _tmp34_;
					_tmp31_ = _tmp35_ - 1;
				} else {
					_tmp31_ = xmax;
				}
				xmax = _tmp31_;
				{
					gint x_it = 0;
					x_it = xmin;
					{
						gboolean _tmp36_ = FALSE;
						_tmp36_ = TRUE;
						while (TRUE) {
							GdkPixbuf* _tmp38_;
							GdkPixbuf* _tmp39_;
							if (!_tmp36_) {
								gint _tmp37_;
								_tmp37_ = x_it;
								x_it = _tmp37_ + 1;
							}
							_tmp36_ = FALSE;
							if (!(x_it <= xmax)) {
								break;
							}
							_tmp38_ = photo_red_reduce_pixel (self, pixbuf, x_it, y_it);
							_tmp39_ = _tmp38_;
							_g_object_unref0 (_tmp39_);
						}
					}
				}
				_tmp40_ = inset_index;
				inset_index = _tmp40_ + 1;
			}
		}
	}
	_tmp41_ = *inst;
	_tmp42_ = _tmp41_.center;
	ymin = _tmp42_.y;
	_tmp43_ = *inst;
	_tmp44_ = _tmp43_.center;
	_tmp45_ = *inst;
	ymax = _tmp44_.y + _tmp45_.radius;
	_tmp46_ = x_insets_first_quadrant;
	_tmp46__length1 = x_insets_first_quadrant_length1;
	inset_index = _tmp46__length1 - 1;
	{
		gint y_it = 0;
		y_it = ymin;
		{
			gboolean _tmp47_ = FALSE;
			_tmp47_ = TRUE;
			while (TRUE) {
				gint xmin = 0;
				gint* _tmp49_;
				gint _tmp49__length1;
				gint _tmp50_;
				gint _tmp51_ = 0;
				gint xmax = 0;
				gint* _tmp52_;
				gint _tmp52__length1;
				gint _tmp53_;
				gint _tmp54_ = 0;
				gint _tmp55_;
				gint _tmp56_;
				gint _tmp63_;
				if (!_tmp47_) {
					gint _tmp48_;
					_tmp48_ = y_it;
					y_it = _tmp48_ + 1;
				}
				_tmp47_ = FALSE;
				if (!(y_it <= ymax)) {
					break;
				}
				_tmp49_ = x_insets_first_quadrant;
				_tmp49__length1 = x_insets_first_quadrant_length1;
				_tmp50_ = _tmp49_[inset_index];
				xmin = x_bounds_min + _tmp50_;
				if (xmin < 0) {
					_tmp51_ = 0;
				} else {
					_tmp51_ = xmin;
				}
				xmin = _tmp51_;
				_tmp52_ = x_insets_first_quadrant;
				_tmp52__length1 = x_insets_first_quadrant_length1;
				_tmp53_ = _tmp52_[inset_index];
				xmax = x_bounds_max - _tmp53_;
				_tmp55_ = gdk_pixbuf_get_width (pixbuf);
				_tmp56_ = _tmp55_;
				if (xmax > (_tmp56_ - 1)) {
					gint _tmp57_;
					gint _tmp58_;
					_tmp57_ = gdk_pixbuf_get_width (pixbuf);
					_tmp58_ = _tmp57_;
					_tmp54_ = _tmp58_ - 1;
				} else {
					_tmp54_ = xmax;
				}
				xmax = _tmp54_;
				{
					gint x_it = 0;
					x_it = xmin;
					{
						gboolean _tmp59_ = FALSE;
						_tmp59_ = TRUE;
						while (TRUE) {
							GdkPixbuf* _tmp61_;
							GdkPixbuf* _tmp62_;
							if (!_tmp59_) {
								gint _tmp60_;
								_tmp60_ = x_it;
								x_it = _tmp60_ + 1;
							}
							_tmp59_ = FALSE;
							if (!(x_it <= xmax)) {
								break;
							}
							_tmp61_ = photo_red_reduce_pixel (self, pixbuf, x_it, y_it);
							_tmp62_ = _tmp61_;
							_g_object_unref0 (_tmp62_);
						}
					}
				}
				_tmp63_ = inset_index;
				inset_index = _tmp63_ - 1;
			}
		}
	}
	_tmp64_ = _g_object_ref0 (pixbuf);
	result = _tmp64_;
	x_insets_first_quadrant = (g_free (x_insets_first_quadrant), NULL);
	return result;
}

static GdkPixbuf*
photo_red_reduce_pixel (Photo* self,
                        GdkPixbuf* pixbuf,
                        gint x,
                        gint y)
{
	gint px_start_byte_offset = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GdkPixbuf* _tmp13_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pixbuf != NULL, NULL);
	px_start_byte_offset = (y * gdk_pixbuf_get_rowstride (pixbuf)) + (x * gdk_pixbuf_get_n_channels (pixbuf));
	if (x >= 0) {
		_tmp2_ = y >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = gdk_pixbuf_get_width (pixbuf);
		_tmp4_ = _tmp3_;
		_tmp1_ = x < _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp5_;
		gint _tmp6_;
		_tmp5_ = gdk_pixbuf_get_height (pixbuf);
		_tmp6_ = _tmp5_;
		_tmp0_ = y < _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guchar* pixel_data = NULL;
		guint8* _tmp7_;
		gint pixel_data_length1;
		gint _pixel_data_size_;
		guchar g = '\0';
		guchar* _tmp8_;
		gint _tmp8__length1;
		guchar _tmp9_;
		guchar b = '\0';
		guchar* _tmp10_;
		gint _tmp10__length1;
		guchar _tmp11_;
		guchar r = '\0';
		guchar* _tmp12_;
		gint _tmp12__length1;
		_tmp7_ = gdk_pixbuf_get_pixels (pixbuf);
		pixel_data = _tmp7_;
		pixel_data_length1 = -1;
		_pixel_data_size_ = pixel_data_length1;
		_tmp8_ = pixel_data;
		_tmp8__length1 = pixel_data_length1;
		_tmp9_ = _tmp8_[px_start_byte_offset + 1];
		g = _tmp9_;
		_tmp10_ = pixel_data;
		_tmp10__length1 = pixel_data_length1;
		_tmp11_ = _tmp10_[px_start_byte_offset + 2];
		b = _tmp11_;
		r = (guchar) ((g + b) / 2);
		_tmp12_ = pixel_data;
		_tmp12__length1 = pixel_data_length1;
		_tmp12_[px_start_byte_offset] = r;
	}
	_tmp13_ = _g_object_ref0 (pixbuf);
	result = _tmp13_;
	return result;
}

void
photo_unscaled_to_raw_point (Photo* self,
                             GdkPoint* unscaled_point,
                             GdkPoint* result)
{
	Orientation unscaled_orientation = 0;
	Dimensions unscaled_dims = {0};
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	gint unscaled_x_offset_raw = 0;
	gint unscaled_y_offset_raw = 0;
	Box crop_box = {0};
	Box _tmp2_ = {0};
	gboolean _tmp3_;
	GdkPoint derotated_point = {0};
	Dimensions _tmp6_;
	GdkPoint _tmp7_;
	GdkPoint _tmp8_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (unscaled_point != NULL);
	unscaled_orientation = photo_get_orientation (self);
	media_source_get_dimensions ((MediaSource*) self, PHOTO_EXCEPTION_NONE, &_tmp0_);
	orientation_rotate_dimensions (unscaled_orientation, &_tmp0_, &_tmp1_);
	unscaled_dims = _tmp1_;
	unscaled_x_offset_raw = 0;
	unscaled_y_offset_raw = 0;
	_tmp3_ = photo_get_raw_crop (self, &_tmp2_);
	crop_box = _tmp2_;
	if (_tmp3_) {
		Box _tmp4_;
		Box _tmp5_;
		_tmp4_ = crop_box;
		unscaled_x_offset_raw = _tmp4_.left;
		_tmp5_ = crop_box;
		unscaled_y_offset_raw = _tmp5_.top;
	}
	_tmp6_ = unscaled_dims;
	_tmp7_ = *unscaled_point;
	orientation_derotate_point (unscaled_orientation, &_tmp6_, &_tmp7_, &_tmp8_);
	derotated_point = _tmp8_;
	derotated_point.x = derotated_point.x + unscaled_x_offset_raw;
	derotated_point.y = derotated_point.y + unscaled_y_offset_raw;
	*result = derotated_point;
	return;
}

void
photo_unscaled_to_raw_rect (Photo* self,
                            GdkRectangle* unscaled_rect,
                            GdkRectangle* result)
{
	GdkPoint upper_left = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint lower_right = {0};
	GdkPoint _tmp1_ = {0};
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkPoint _tmp4_;
	GdkRectangle _tmp5_;
	GdkPoint _tmp6_;
	GdkRectangle _tmp7_;
	GdkPoint _tmp8_;
	GdkPoint _tmp9_ = {0};
	GdkPoint _tmp10_;
	GdkPoint _tmp11_ = {0};
	GdkPoint _tmp12_;
	GdkPoint _tmp13_;
	GdkPoint _tmp16_;
	GdkPoint _tmp17_;
	GdkRectangle raw_rect = {0};
	GdkPoint _tmp20_;
	GdkPoint _tmp21_;
	GdkPoint _tmp22_;
	GdkPoint _tmp23_;
	GdkPoint _tmp24_;
	GdkPoint _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unscaled_rect != NULL);
	_tmp0_.x = 0;
	upper_left = _tmp0_;
	_tmp1_.x = 0;
	lower_right = _tmp1_;
	_tmp2_ = *unscaled_rect;
	upper_left.x = _tmp2_.x;
	_tmp3_ = *unscaled_rect;
	upper_left.y = _tmp3_.y;
	_tmp4_ = upper_left;
	_tmp5_ = *unscaled_rect;
	lower_right.x = _tmp4_.x + _tmp5_.width;
	_tmp6_ = upper_left;
	_tmp7_ = *unscaled_rect;
	lower_right.y = _tmp6_.y + _tmp7_.height;
	_tmp8_ = upper_left;
	photo_unscaled_to_raw_point (self, &_tmp8_, &_tmp9_);
	upper_left = _tmp9_;
	_tmp10_ = lower_right;
	photo_unscaled_to_raw_point (self, &_tmp10_, &_tmp11_);
	lower_right = _tmp11_;
	_tmp12_ = upper_left;
	_tmp13_ = lower_right;
	if (_tmp12_.x > _tmp13_.x) {
		gint temp = 0;
		GdkPoint _tmp14_;
		GdkPoint _tmp15_;
		_tmp14_ = upper_left;
		temp = _tmp14_.x;
		_tmp15_ = lower_right;
		upper_left.x = _tmp15_.x;
		lower_right.x = temp;
	}
	_tmp16_ = upper_left;
	_tmp17_ = lower_right;
	if (_tmp16_.y > _tmp17_.y) {
		gint temp = 0;
		GdkPoint _tmp18_;
		GdkPoint _tmp19_;
		_tmp18_ = upper_left;
		temp = _tmp18_.y;
		_tmp19_ = lower_right;
		upper_left.y = _tmp19_.y;
		lower_right.y = temp;
	}
	memset (&raw_rect, 0, sizeof (GdkRectangle));
	_tmp20_ = upper_left;
	raw_rect.x = _tmp20_.x;
	_tmp21_ = upper_left;
	raw_rect.y = _tmp21_.y;
	_tmp22_ = lower_right;
	_tmp23_ = upper_left;
	raw_rect.width = _tmp22_.x - _tmp23_.x;
	_tmp24_ = lower_right;
	_tmp25_ = upper_left;
	raw_rect.height = _tmp24_.y - _tmp25_.y;
	*result = raw_rect;
	return;
}

PixelTransformationBundle*
photo_get_enhance_transformations (Photo* self)
{
	GdkPixbuf* pixbuf = NULL;
	PixelTransformationBundle* transformations = NULL;
	GdkPixbuf* _tmp4_;
	PixelTransformationBundle* _tmp5_;
	GError* _inner_error0_ = NULL;
	PixelTransformationBundle* result;
	g_return_val_if_fail (self != NULL, NULL);
	pixbuf = NULL;
	{
		GdkPixbuf* _tmp0_ = NULL;
		Scaling _tmp1_ = {0};
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		scaling_for_best_fit (360, FALSE, &_tmp1_);
		_tmp2_ = photo_get_pixbuf_with_options (self, &_tmp1_, PHOTO_EXCEPTION_ALL, BACKING_FETCH_MODE_BASELINE, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("Photo.vala:4451: %s", "Photo: get_enhance_transformations: couldn't obtain pixbuf to build " "transform histogram");
		result = NULL;
		_g_object_unref0 (pixbuf);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp4_ = pixbuf;
	_tmp5_ = auto_enhance_create_auto_enhance_adjustments (_tmp4_);
	transformations = _tmp5_;
	result = transformations;
	_g_object_unref0 (pixbuf);
	return result;
}

gboolean
photo_enhance (Photo* self)
{
	PixelTransformationBundle* transformations = NULL;
	PixelTransformationBundle* _tmp0_;
	PixelTransformationBundle* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = photo_get_enhance_transformations (self);
	transformations = _tmp0_;
	_tmp1_ = transformations;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_pixel_transformation_bundle_unref0 (transformations);
		return result;
	}
	{
		PhotoRow* _tmp2_;
		_tmp2_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			KeyValueMap* _tmp3_;
			KeyValueMap* _tmp4_;
			PixelTransformationBundle* _tmp5_;
			photo_clear_original_transforms (self);
			_tmp3_ = photo_get_color_adjustments_map (self);
			_tmp4_ = _tmp3_;
			photo_set_original_transforms (self, _tmp4_);
			_key_value_map_unref0 (_tmp4_);
			_tmp5_ = transformations;
			photo_set_color_adjustments (self, _tmp5_);
		}
		__finally0:
		{
			PhotoRow* _tmp6_;
			_tmp6_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			_pixel_transformation_bundle_unref0 (transformations);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp7_;
		}
	}
	photo_set_enhanced (self, TRUE);
	result = TRUE;
	_pixel_transformation_bundle_unref0 (transformations);
	return result;
}

gboolean
photo_unenhance (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			if (_tmp1_->enhanced) {
				gboolean _tmp2_ = FALSE;
				PhotoRow* _tmp3_;
				GeeHashMap* _tmp4_;
				_tmp3_ = self->row;
				_tmp4_ = _tmp3_->original_transforms;
				if (_tmp4_ == NULL) {
					_tmp2_ = TRUE;
				} else {
					PhotoRow* _tmp5_;
					GeeHashMap* _tmp6_;
					gpointer _tmp7_;
					KeyValueMap* _tmp8_;
					_tmp5_ = self->row;
					_tmp6_ = _tmp5_->original_transforms;
					_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, "adjustments");
					_tmp8_ = (KeyValueMap*) _tmp7_;
					_tmp2_ = _tmp8_ == NULL;
					_key_value_map_unref0 (_tmp8_);
				}
				if (_tmp2_) {
					gboolean _result_ = FALSE;
					photo_remove_transformation (self, "adjustments");
					_result_ = FALSE;
					_result_ = photo_remove_transformation (self, "adjustments");
					_pixel_transformation_bundle_unref0 (self->priv->adjustments);
					self->priv->adjustments = NULL;
					_pixel_transformer_unref0 (self->priv->transformer);
					self->priv->transformer = NULL;
					if (_result_) {
						Alteration* _tmp9_;
						Alteration* _tmp10_;
						_tmp9_ = alteration_new ("image", "color-adjustments");
						_tmp10_ = _tmp9_;
						data_object_notify_altered ((DataObject*) self, _tmp10_);
						_alteration_unref0 (_tmp10_);
					}
				} else {
					PixelTransformationBundle* _tmp11_;
					PixelTransformationBundle* _tmp12_;
					_tmp11_ = photo_locked_original_color_adjustments (self);
					_tmp12_ = _tmp11_;
					photo_set_color_adjustments (self, _tmp12_);
					_pixel_transformation_bundle_unref0 (_tmp12_);
				}
				photo_set_enhanced (self, FALSE);
				result = TRUE;
				{
					PhotoRow* _tmp13_;
					_tmp13_ = self->row;
					g_rec_mutex_unlock (&self->priv->__lock_row);
				}
				return result;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp14_;
			_tmp14_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp15_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp15_;
		}
	}
	result = FALSE;
	return result;
}

gboolean
photo_get_develop_raw_photos_to_files (void)
{
	gboolean result;
	result = photo__develop_raw_photos_to_files;
	return result;
}

void
photo_set_develop_raw_photos_to_files (gboolean value)
{
	photo__develop_raw_photos_to_files = value;
}

static void
photo_real_editable_replaced (Photo* self,
                              GFile* old_file,
                              GFile* new_file)
{
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
photo_real_raw_development_modified (Photo* self)
{
}

static void
photo_real_baseline_replaced (Photo* self)
{
}

static void
photo_real_master_reimported (Photo* self,
                              PhotoMetadata* metadata)
{
}

static void
g_cclosure_user_marshal_VOID__MEDIA_METADATA (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__MEDIA_METADATA) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__MEDIA_METADATA callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__MEDIA_METADATA) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_media_metadata (param_values + 1), data2);
}

static void
photo_real_editable_reimported (Photo* self,
                                PhotoMetadata* metadata)
{
}

static void
photo_real_baseline_reimported (Photo* self,
                                PhotoMetadata* metadata)
{
}

static void
photo_real_source_reimported (Photo* self,
                              PhotoMetadata* metadata)
{
}

static inline gpointer
photo_photo_transformation_state_impl_get_instance_private (PhotoPhotoTransformationStateImpl* self)
{
	return G_STRUCT_MEMBER_P (self, PhotoPhotoTransformationStateImpl_private_offset);
}

static void
_photo_photo_transformation_state_impl_on_photo_baseline_replaced_photo_baseline_replaced (Photo* _sender,
                                                                                           gpointer self)
{
	photo_photo_transformation_state_impl_on_photo_baseline_replaced ((PhotoPhotoTransformationStateImpl*) self);
}

static PhotoPhotoTransformationStateImpl*
photo_photo_transformation_state_impl_construct (GType object_type,
                                                 Photo* photo,
                                                 Orientation orientation,
                                                 GeeHashMap* transformations,
                                                 PixelTransformer* transformer,
                                                 PixelTransformationBundle* adjustments,
                                                 GeeHashMap* original_transformations,
                                                 gboolean enhanced)
{
	PhotoPhotoTransformationStateImpl * self = NULL;
	Photo* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	PixelTransformer* _tmp3_;
	PixelTransformationBundle* _tmp4_;
	g_return_val_if_fail (photo != NULL, NULL);
	self = (PhotoPhotoTransformationStateImpl*) photo_transformation_state_construct (object_type);
	_tmp0_ = _g_object_ref0 (photo);
	_g_object_unref0 (self->priv->photo);
	self->priv->photo = _tmp0_;
	self->priv->orientation = orientation;
	_tmp1_ = photo_photo_transformation_state_impl_copy_transformations (transformations);
	_g_object_unref0 (self->priv->transformations);
	self->priv->transformations = _tmp1_;
	_tmp2_ = photo_photo_transformation_state_impl_copy_transformations (original_transformations);
	_g_object_unref0 (self->priv->original_transformations);
	self->priv->original_transformations = _tmp2_;
	_tmp3_ = _pixel_transformer_ref0 (transformer);
	_pixel_transformer_unref0 (self->priv->transformer);
	self->priv->transformer = _tmp3_;
	_tmp4_ = _pixel_transformation_bundle_ref0 (adjustments);
	_pixel_transformation_bundle_unref0 (self->priv->adjustments);
	self->priv->adjustments = _tmp4_;
	self->priv->enhanced = enhanced;
	g_signal_connect_object (photo, "baseline-replaced", (GCallback) _photo_photo_transformation_state_impl_on_photo_baseline_replaced_photo_baseline_replaced, self, 0);
	return self;
}

static PhotoPhotoTransformationStateImpl*
photo_photo_transformation_state_impl_new (Photo* photo,
                                           Orientation orientation,
                                           GeeHashMap* transformations,
                                           PixelTransformer* transformer,
                                           PixelTransformationBundle* adjustments,
                                           GeeHashMap* original_transformations,
                                           gboolean enhanced)
{
	return photo_photo_transformation_state_impl_construct (PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, photo, orientation, transformations, transformer, adjustments, original_transformations, enhanced);
}

static gboolean
photo_photo_transformation_state_impl_get_enhanced (PhotoPhotoTransformationStateImpl* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->enhanced;
	return result;
}

static Orientation
photo_photo_transformation_state_impl_get_orientation (PhotoPhotoTransformationStateImpl* self)
{
	Orientation result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->orientation;
	return result;
}

static GeeHashMap*
photo_photo_transformation_state_impl_get_transformations (PhotoPhotoTransformationStateImpl* self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->transformations;
	_tmp1_ = photo_photo_transformation_state_impl_copy_transformations (_tmp0_);
	result = _tmp1_;
	return result;
}

static GeeHashMap*
photo_photo_transformation_state_impl_get_original_transformations (PhotoPhotoTransformationStateImpl* self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->original_transformations;
	_tmp1_ = photo_photo_transformation_state_impl_copy_transformations (_tmp0_);
	result = _tmp1_;
	return result;
}

static PixelTransformer*
photo_photo_transformation_state_impl_get_transformer (PhotoPhotoTransformationStateImpl* self)
{
	PixelTransformer* _tmp0_ = NULL;
	PixelTransformer* _tmp1_;
	PixelTransformer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->transformer;
	if (_tmp1_ != NULL) {
		PixelTransformer* _tmp2_;
		PixelTransformer* _tmp3_;
		_tmp2_ = self->priv->transformer;
		_tmp3_ = pixel_transformer_copy (_tmp2_);
		_pixel_transformer_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		_pixel_transformer_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

static PixelTransformationBundle*
photo_photo_transformation_state_impl_get_color_adjustments (PhotoPhotoTransformationStateImpl* self)
{
	PixelTransformationBundle* _tmp0_ = NULL;
	PixelTransformationBundle* _tmp1_;
	PixelTransformationBundle* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->adjustments;
	if (_tmp1_ != NULL) {
		PixelTransformationBundle* _tmp2_;
		PixelTransformationBundle* _tmp3_;
		_tmp2_ = self->priv->adjustments;
		_tmp3_ = pixel_transformation_bundle_copy (_tmp2_);
		_pixel_transformation_bundle_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		_pixel_transformation_bundle_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

static GeeHashMap*
photo_photo_transformation_state_impl_copy_transformations (GeeHashMap* original)
{
	GeeHashMap* clone = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* result;
	if (original == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_KEY_VALUE_MAP, (GBoxedCopyFunc) key_value_map_ref, (GDestroyNotify) key_value_map_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	clone = _tmp0_;
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp1_ = gee_abstract_map_get_keys ((GeeAbstractMap*) original);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_object_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gchar* object = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GeeHashMap* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gpointer _tmp12_;
			KeyValueMap* _tmp13_;
			KeyValueMap* _tmp14_;
			KeyValueMap* _tmp15_;
			_tmp6_ = _object_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _object_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			object = (gchar*) _tmp8_;
			_tmp9_ = clone;
			_tmp10_ = object;
			_tmp11_ = object;
			_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) original, _tmp11_);
			_tmp13_ = (KeyValueMap*) _tmp12_;
			_tmp14_ = key_value_map_copy (_tmp13_);
			_tmp15_ = _tmp14_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, _tmp10_, _tmp15_);
			_key_value_map_unref0 (_tmp15_);
			_key_value_map_unref0 (_tmp13_);
			_g_free0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	result = clone;
	return result;
}

static void
photo_photo_transformation_state_impl_on_photo_baseline_replaced (PhotoPhotoTransformationStateImpl* self)
{
	g_return_if_fail (self != NULL);
	if (!photo_transformation_state_is_broken ((PhotoTransformationState*) self)) {
		g_signal_emit ((PhotoTransformationState*) self, photo_transformation_state_signals[PHOTO_TRANSFORMATION_STATE_BROKEN_SIGNAL], 0);
	}
}

static void
photo_photo_transformation_state_impl_class_init (PhotoPhotoTransformationStateImplClass * klass,
                                                  gpointer klass_data)
{
	photo_photo_transformation_state_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PhotoPhotoTransformationStateImpl_private_offset);
	G_OBJECT_CLASS (klass)->finalize = photo_photo_transformation_state_impl_finalize;
}

static void
photo_photo_transformation_state_impl_instance_init (PhotoPhotoTransformationStateImpl * self,
                                                     gpointer klass)
{
	self->priv = photo_photo_transformation_state_impl_get_instance_private (self);
}

static void
photo_photo_transformation_state_impl_finalize (GObject * obj)
{
	PhotoPhotoTransformationStateImpl * self;
	Photo* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImpl);
	_tmp0_ = self->priv->photo;
	g_signal_parse_name ("baseline-replaced", TYPE_PHOTO, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _photo_photo_transformation_state_impl_on_photo_baseline_replaced_photo_baseline_replaced, self);
	_g_object_unref0 (self->priv->photo);
	_g_object_unref0 (self->priv->transformations);
	_g_object_unref0 (self->priv->original_transformations);
	_pixel_transformer_unref0 (self->priv->transformer);
	_pixel_transformation_bundle_unref0 (self->priv->adjustments);
	G_OBJECT_CLASS (photo_photo_transformation_state_impl_parent_class)->finalize (obj);
}

static GType
photo_photo_transformation_state_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoPhotoTransformationStateImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_photo_transformation_state_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoPhotoTransformationStateImpl), 0, (GInstanceInitFunc) photo_photo_transformation_state_impl_instance_init, NULL };
	GType photo_photo_transformation_state_impl_type_id;
	photo_photo_transformation_state_impl_type_id = g_type_register_static (TYPE_PHOTO_TRANSFORMATION_STATE, "PhotoPhotoTransformationStateImpl", &g_define_type_info, 0);
	PhotoPhotoTransformationStateImpl_private_offset = g_type_add_instance_private (photo_photo_transformation_state_impl_type_id, sizeof (PhotoPhotoTransformationStateImplPrivate));
	return photo_photo_transformation_state_impl_type_id;
}

static GType
photo_photo_transformation_state_impl_get_type (void)
{
	static volatile gsize photo_photo_transformation_state_impl_type_id__once = 0;
	if (g_once_init_enter (&photo_photo_transformation_state_impl_type_id__once)) {
		GType photo_photo_transformation_state_impl_type_id;
		photo_photo_transformation_state_impl_type_id = photo_photo_transformation_state_impl_get_type_once ();
		g_once_init_leave (&photo_photo_transformation_state_impl_type_id__once, photo_photo_transformation_state_impl_type_id);
	}
	return photo_photo_transformation_state_impl_type_id__once;
}

static PhotoBackingReaders*
photo_backing_readers_construct (GType object_type)
{
	PhotoBackingReaders* self = NULL;
	self = (PhotoBackingReaders*) g_type_create_instance (object_type);
	return self;
}

static PhotoBackingReaders*
photo_backing_readers_new (void)
{
	return photo_backing_readers_construct (PHOTO_TYPE_BACKING_READERS);
}

static void
photo_value_backing_readers_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
photo_value_backing_readers_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_backing_readers_unref (value->data[0].v_pointer);
	}
}

static void
photo_value_backing_readers_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_backing_readers_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
photo_value_backing_readers_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
photo_value_backing_readers_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoBackingReaders * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_backing_readers_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
photo_value_backing_readers_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	PhotoBackingReaders ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_backing_readers_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
photo_param_spec_backing_readers (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	PhotoParamSpecBackingReaders* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PHOTO_TYPE_BACKING_READERS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
photo_value_get_backing_readers (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_BACKING_READERS), NULL);
	return value->data[0].v_pointer;
}

static void
photo_value_set_backing_readers (GValue* value,
                                 gpointer v_object)
{
	PhotoBackingReaders * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_BACKING_READERS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_BACKING_READERS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_backing_readers_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_backing_readers_unref (old);
	}
}

static void
photo_value_take_backing_readers (GValue* value,
                                  gpointer v_object)
{
	PhotoBackingReaders * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_BACKING_READERS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_BACKING_READERS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_backing_readers_unref (old);
	}
}

static void
photo_backing_readers_class_init (PhotoBackingReadersClass * klass,
                                  gpointer klass_data)
{
	photo_backing_readers_parent_class = g_type_class_peek_parent (klass);
	((PhotoBackingReadersClass *) klass)->finalize = photo_backing_readers_finalize;
}

static void
photo_backing_readers_instance_init (PhotoBackingReaders * self,
                                     gpointer klass)
{
	self->ref_count = 1;
}

static void
photo_backing_readers_finalize (PhotoBackingReaders * obj)
{
	PhotoBackingReaders * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_BACKING_READERS, PhotoBackingReaders);
	g_signal_handlers_destroy (self);
	_photo_file_adapter_unref0 (self->master);
	_photo_file_adapter_unref0 (self->developer);
	_photo_file_adapter_unref0 (self->editable);
}

static GType
photo_backing_readers_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { photo_value_backing_readers_init, photo_value_backing_readers_free_value, photo_value_backing_readers_copy_value, photo_value_backing_readers_peek_pointer, "p", photo_value_backing_readers_collect_value, "p", photo_value_backing_readers_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoBackingReadersClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_backing_readers_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoBackingReaders), 0, (GInstanceInitFunc) photo_backing_readers_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_backing_readers_type_id;
	photo_backing_readers_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoBackingReaders", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return photo_backing_readers_type_id;
}

static GType
photo_backing_readers_get_type (void)
{
	static volatile gsize photo_backing_readers_type_id__once = 0;
	if (g_once_init_enter (&photo_backing_readers_type_id__once)) {
		GType photo_backing_readers_type_id;
		photo_backing_readers_type_id = photo_backing_readers_get_type_once ();
		g_once_init_leave (&photo_backing_readers_type_id__once, photo_backing_readers_type_id);
	}
	return photo_backing_readers_type_id__once;
}

static gpointer
photo_backing_readers_ref (gpointer instance)
{
	PhotoBackingReaders * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
photo_backing_readers_unref (gpointer instance)
{
	PhotoBackingReaders * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_BACKING_READERS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

PhotoReimportMasterState*
photo_reimport_master_state_construct (GType object_type)
{
	PhotoReimportMasterState* self = NULL;
	self = (PhotoReimportMasterState*) g_type_create_instance (object_type);
	return self;
}

static void
photo_value_reimport_master_state_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
photo_value_reimport_master_state_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_reimport_master_state_unref (value->data[0].v_pointer);
	}
}

static void
photo_value_reimport_master_state_copy_value (const GValue* src_value,
                                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_reimport_master_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
photo_value_reimport_master_state_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
photo_value_reimport_master_state_collect_value (GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoReimportMasterState * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_reimport_master_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
photo_value_reimport_master_state_lcopy_value (const GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	PhotoReimportMasterState ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_reimport_master_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
photo_param_spec_reimport_master_state (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags)
{
	PhotoParamSpecReimportMasterState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PHOTO_TYPE_REIMPORT_MASTER_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
photo_value_get_reimport_master_state (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_MASTER_STATE), NULL);
	return value->data[0].v_pointer;
}

void
photo_value_set_reimport_master_state (GValue* value,
                                       gpointer v_object)
{
	PhotoReimportMasterState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_MASTER_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_REIMPORT_MASTER_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_reimport_master_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_master_state_unref (old);
	}
}

void
photo_value_take_reimport_master_state (GValue* value,
                                        gpointer v_object)
{
	PhotoReimportMasterState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_MASTER_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_REIMPORT_MASTER_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_master_state_unref (old);
	}
}

static void
photo_reimport_master_state_class_init (PhotoReimportMasterStateClass * klass,
                                        gpointer klass_data)
{
	photo_reimport_master_state_parent_class = g_type_class_peek_parent (klass);
	((PhotoReimportMasterStateClass *) klass)->finalize = photo_reimport_master_state_finalize;
}

static void
photo_reimport_master_state_instance_init (PhotoReimportMasterState * self,
                                           gpointer klass)
{
	self->ref_count = 1;
}

static void
photo_reimport_master_state_finalize (PhotoReimportMasterState * obj)
{
	PhotoReimportMasterState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState);
	g_signal_handlers_destroy (self);
}

static GType
photo_reimport_master_state_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { photo_value_reimport_master_state_init, photo_value_reimport_master_state_free_value, photo_value_reimport_master_state_copy_value, photo_value_reimport_master_state_peek_pointer, "p", photo_value_reimport_master_state_collect_value, "p", photo_value_reimport_master_state_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoReimportMasterStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_reimport_master_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoReimportMasterState), 0, (GInstanceInitFunc) photo_reimport_master_state_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_reimport_master_state_type_id;
	photo_reimport_master_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoReimportMasterState", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return photo_reimport_master_state_type_id;
}

GType
photo_reimport_master_state_get_type (void)
{
	static volatile gsize photo_reimport_master_state_type_id__once = 0;
	if (g_once_init_enter (&photo_reimport_master_state_type_id__once)) {
		GType photo_reimport_master_state_type_id;
		photo_reimport_master_state_type_id = photo_reimport_master_state_get_type_once ();
		g_once_init_leave (&photo_reimport_master_state_type_id__once, photo_reimport_master_state_type_id);
	}
	return photo_reimport_master_state_type_id__once;
}

gpointer
photo_reimport_master_state_ref (gpointer instance)
{
	PhotoReimportMasterState * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_reimport_master_state_unref (gpointer instance)
{
	PhotoReimportMasterState * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_REIMPORT_MASTER_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static PhotoReimportMasterStateImpl*
photo_reimport_master_state_impl_construct (GType object_type,
                                            PhotoRow* row,
                                            PhotoMetadata* metadata,
                                            gchar** alterations,
                                            gint alterations_length1)
{
	PhotoReimportMasterStateImpl* self = NULL;
	PhotoRow* _tmp0_;
	PhotoMetadata* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (row != NULL, NULL);
	self = (PhotoReimportMasterStateImpl*) photo_reimport_master_state_construct (object_type);
	_tmp0_ = _photo_row_ref0 (row);
	_photo_row_unref0 (self->row);
	self->row = _tmp0_;
	_tmp1_ = _media_metadata_ref0 (metadata);
	_media_metadata_unref0 (self->metadata);
	self->metadata = _tmp1_;
	_tmp2_ = (alterations != NULL) ? _vala_array_dup4 (alterations, alterations_length1) : alterations;
	_tmp2__length1 = alterations_length1;
	self->alterations = (_vala_array_free (self->alterations, self->alterations_length1, (GDestroyNotify) g_free), NULL);
	self->alterations = _tmp2_;
	self->alterations_length1 = _tmp2__length1;
	self->_alterations_size_ = self->alterations_length1;
	return self;
}

static PhotoReimportMasterStateImpl*
photo_reimport_master_state_impl_new (PhotoRow* row,
                                      PhotoMetadata* metadata,
                                      gchar** alterations,
                                      gint alterations_length1)
{
	return photo_reimport_master_state_impl_construct (PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, row, metadata, alterations, alterations_length1);
}

static void
photo_reimport_master_state_impl_class_init (PhotoReimportMasterStateImplClass * klass,
                                             gpointer klass_data)
{
	photo_reimport_master_state_impl_parent_class = g_type_class_peek_parent (klass);
	((PhotoReimportMasterStateClass *) klass)->finalize = photo_reimport_master_state_impl_finalize;
}

static void
photo_reimport_master_state_impl_instance_init (PhotoReimportMasterStateImpl * self,
                                                gpointer klass)
{
	PhotoRow* _tmp0_;
	_tmp0_ = photo_row_new ();
	self->row = _tmp0_;
	self->metadata_only = FALSE;
}

static void
photo_reimport_master_state_impl_finalize (PhotoReimportMasterState * obj)
{
	PhotoReimportMasterStateImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl);
	_photo_row_unref0 (self->row);
	_media_metadata_unref0 (self->metadata);
	self->alterations = (_vala_array_free (self->alterations, self->alterations_length1, (GDestroyNotify) g_free), NULL);
	PHOTO_REIMPORT_MASTER_STATE_CLASS (photo_reimport_master_state_impl_parent_class)->finalize (obj);
}

static GType
photo_reimport_master_state_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoReimportMasterStateImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_reimport_master_state_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoReimportMasterStateImpl), 0, (GInstanceInitFunc) photo_reimport_master_state_impl_instance_init, NULL };
	GType photo_reimport_master_state_impl_type_id;
	photo_reimport_master_state_impl_type_id = g_type_register_static (PHOTO_TYPE_REIMPORT_MASTER_STATE, "PhotoReimportMasterStateImpl", &g_define_type_info, 0);
	return photo_reimport_master_state_impl_type_id;
}

static GType
photo_reimport_master_state_impl_get_type (void)
{
	static volatile gsize photo_reimport_master_state_impl_type_id__once = 0;
	if (g_once_init_enter (&photo_reimport_master_state_impl_type_id__once)) {
		GType photo_reimport_master_state_impl_type_id;
		photo_reimport_master_state_impl_type_id = photo_reimport_master_state_impl_get_type_once ();
		g_once_init_leave (&photo_reimport_master_state_impl_type_id__once, photo_reimport_master_state_impl_type_id);
	}
	return photo_reimport_master_state_impl_type_id__once;
}

PhotoReimportEditableState*
photo_reimport_editable_state_construct (GType object_type)
{
	PhotoReimportEditableState* self = NULL;
	self = (PhotoReimportEditableState*) g_type_create_instance (object_type);
	return self;
}

static void
photo_value_reimport_editable_state_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
photo_value_reimport_editable_state_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_reimport_editable_state_unref (value->data[0].v_pointer);
	}
}

static void
photo_value_reimport_editable_state_copy_value (const GValue* src_value,
                                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_reimport_editable_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
photo_value_reimport_editable_state_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
photo_value_reimport_editable_state_collect_value (GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoReimportEditableState * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_reimport_editable_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
photo_value_reimport_editable_state_lcopy_value (const GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	PhotoReimportEditableState ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_reimport_editable_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
photo_param_spec_reimport_editable_state (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags)
{
	PhotoParamSpecReimportEditableState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PHOTO_TYPE_REIMPORT_EDITABLE_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
photo_value_get_reimport_editable_state (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_EDITABLE_STATE), NULL);
	return value->data[0].v_pointer;
}

void
photo_value_set_reimport_editable_state (GValue* value,
                                         gpointer v_object)
{
	PhotoReimportEditableState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_EDITABLE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_REIMPORT_EDITABLE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_reimport_editable_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_editable_state_unref (old);
	}
}

void
photo_value_take_reimport_editable_state (GValue* value,
                                          gpointer v_object)
{
	PhotoReimportEditableState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_EDITABLE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_REIMPORT_EDITABLE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_editable_state_unref (old);
	}
}

static void
photo_reimport_editable_state_class_init (PhotoReimportEditableStateClass * klass,
                                          gpointer klass_data)
{
	photo_reimport_editable_state_parent_class = g_type_class_peek_parent (klass);
	((PhotoReimportEditableStateClass *) klass)->finalize = photo_reimport_editable_state_finalize;
}

static void
photo_reimport_editable_state_instance_init (PhotoReimportEditableState * self,
                                             gpointer klass)
{
	self->ref_count = 1;
}

static void
photo_reimport_editable_state_finalize (PhotoReimportEditableState * obj)
{
	PhotoReimportEditableState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableState);
	g_signal_handlers_destroy (self);
}

static GType
photo_reimport_editable_state_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { photo_value_reimport_editable_state_init, photo_value_reimport_editable_state_free_value, photo_value_reimport_editable_state_copy_value, photo_value_reimport_editable_state_peek_pointer, "p", photo_value_reimport_editable_state_collect_value, "p", photo_value_reimport_editable_state_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoReimportEditableStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_reimport_editable_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoReimportEditableState), 0, (GInstanceInitFunc) photo_reimport_editable_state_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_reimport_editable_state_type_id;
	photo_reimport_editable_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoReimportEditableState", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return photo_reimport_editable_state_type_id;
}

GType
photo_reimport_editable_state_get_type (void)
{
	static volatile gsize photo_reimport_editable_state_type_id__once = 0;
	if (g_once_init_enter (&photo_reimport_editable_state_type_id__once)) {
		GType photo_reimport_editable_state_type_id;
		photo_reimport_editable_state_type_id = photo_reimport_editable_state_get_type_once ();
		g_once_init_leave (&photo_reimport_editable_state_type_id__once, photo_reimport_editable_state_type_id);
	}
	return photo_reimport_editable_state_type_id__once;
}

gpointer
photo_reimport_editable_state_ref (gpointer instance)
{
	PhotoReimportEditableState * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_reimport_editable_state_unref (gpointer instance)
{
	PhotoReimportEditableState * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_REIMPORT_EDITABLE_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static PhotoReimportEditableStateImpl*
photo_reimport_editable_state_impl_construct (GType object_type,
                                              BackingPhotoRow* backing_state,
                                              PhotoMetadata* metadata)
{
	PhotoReimportEditableStateImpl* self = NULL;
	BackingPhotoRow* _tmp0_;
	PhotoMetadata* _tmp1_;
	g_return_val_if_fail (backing_state != NULL, NULL);
	self = (PhotoReimportEditableStateImpl*) photo_reimport_editable_state_construct (object_type);
	_tmp0_ = _backing_photo_row_ref0 (backing_state);
	_backing_photo_row_unref0 (self->backing_state);
	self->backing_state = _tmp0_;
	_tmp1_ = _media_metadata_ref0 (metadata);
	_media_metadata_unref0 (self->metadata);
	self->metadata = _tmp1_;
	return self;
}

static PhotoReimportEditableStateImpl*
photo_reimport_editable_state_impl_new (BackingPhotoRow* backing_state,
                                        PhotoMetadata* metadata)
{
	return photo_reimport_editable_state_impl_construct (PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, backing_state, metadata);
}

static void
photo_reimport_editable_state_impl_class_init (PhotoReimportEditableStateImplClass * klass,
                                               gpointer klass_data)
{
	photo_reimport_editable_state_impl_parent_class = g_type_class_peek_parent (klass);
	((PhotoReimportEditableStateClass *) klass)->finalize = photo_reimport_editable_state_impl_finalize;
}

static void
photo_reimport_editable_state_impl_instance_init (PhotoReimportEditableStateImpl * self,
                                                  gpointer klass)
{
	BackingPhotoRow* _tmp0_;
	_tmp0_ = backing_photo_row_new ();
	self->backing_state = _tmp0_;
	self->metadata_only = FALSE;
}

static void
photo_reimport_editable_state_impl_finalize (PhotoReimportEditableState * obj)
{
	PhotoReimportEditableStateImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl);
	_backing_photo_row_unref0 (self->backing_state);
	_media_metadata_unref0 (self->metadata);
	PHOTO_REIMPORT_EDITABLE_STATE_CLASS (photo_reimport_editable_state_impl_parent_class)->finalize (obj);
}

static GType
photo_reimport_editable_state_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoReimportEditableStateImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_reimport_editable_state_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoReimportEditableStateImpl), 0, (GInstanceInitFunc) photo_reimport_editable_state_impl_instance_init, NULL };
	GType photo_reimport_editable_state_impl_type_id;
	photo_reimport_editable_state_impl_type_id = g_type_register_static (PHOTO_TYPE_REIMPORT_EDITABLE_STATE, "PhotoReimportEditableStateImpl", &g_define_type_info, 0);
	return photo_reimport_editable_state_impl_type_id;
}

static GType
photo_reimport_editable_state_impl_get_type (void)
{
	static volatile gsize photo_reimport_editable_state_impl_type_id__once = 0;
	if (g_once_init_enter (&photo_reimport_editable_state_impl_type_id__once)) {
		GType photo_reimport_editable_state_impl_type_id;
		photo_reimport_editable_state_impl_type_id = photo_reimport_editable_state_impl_get_type_once ();
		g_once_init_leave (&photo_reimport_editable_state_impl_type_id__once, photo_reimport_editable_state_impl_type_id);
	}
	return photo_reimport_editable_state_impl_type_id__once;
}

PhotoReimportRawDevelopmentState*
photo_reimport_raw_development_state_construct (GType object_type)
{
	PhotoReimportRawDevelopmentState* self = NULL;
	self = (PhotoReimportRawDevelopmentState*) g_type_create_instance (object_type);
	return self;
}

static void
photo_value_reimport_raw_development_state_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
photo_value_reimport_raw_development_state_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_reimport_raw_development_state_unref (value->data[0].v_pointer);
	}
}

static void
photo_value_reimport_raw_development_state_copy_value (const GValue* src_value,
                                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_reimport_raw_development_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
photo_value_reimport_raw_development_state_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
photo_value_reimport_raw_development_state_collect_value (GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoReimportRawDevelopmentState * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_reimport_raw_development_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
photo_value_reimport_raw_development_state_lcopy_value (const GValue* value,
                                                        guint n_collect_values,
                                                        GTypeCValue* collect_values,
                                                        guint collect_flags)
{
	PhotoReimportRawDevelopmentState ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_reimport_raw_development_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
photo_param_spec_reimport_raw_development_state (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags)
{
	PhotoParamSpecReimportRawDevelopmentState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
photo_value_get_reimport_raw_development_state (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE), NULL);
	return value->data[0].v_pointer;
}

void
photo_value_set_reimport_raw_development_state (GValue* value,
                                                gpointer v_object)
{
	PhotoReimportRawDevelopmentState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_reimport_raw_development_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_raw_development_state_unref (old);
	}
}

void
photo_value_take_reimport_raw_development_state (GValue* value,
                                                 gpointer v_object)
{
	PhotoReimportRawDevelopmentState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_raw_development_state_unref (old);
	}
}

static void
photo_reimport_raw_development_state_class_init (PhotoReimportRawDevelopmentStateClass * klass,
                                                 gpointer klass_data)
{
	photo_reimport_raw_development_state_parent_class = g_type_class_peek_parent (klass);
	((PhotoReimportRawDevelopmentStateClass *) klass)->finalize = photo_reimport_raw_development_state_finalize;
}

static void
photo_reimport_raw_development_state_instance_init (PhotoReimportRawDevelopmentState * self,
                                                    gpointer klass)
{
	self->ref_count = 1;
}

static void
photo_reimport_raw_development_state_finalize (PhotoReimportRawDevelopmentState * obj)
{
	PhotoReimportRawDevelopmentState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentState);
	g_signal_handlers_destroy (self);
}

static GType
photo_reimport_raw_development_state_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { photo_value_reimport_raw_development_state_init, photo_value_reimport_raw_development_state_free_value, photo_value_reimport_raw_development_state_copy_value, photo_value_reimport_raw_development_state_peek_pointer, "p", photo_value_reimport_raw_development_state_collect_value, "p", photo_value_reimport_raw_development_state_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoReimportRawDevelopmentStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_reimport_raw_development_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoReimportRawDevelopmentState), 0, (GInstanceInitFunc) photo_reimport_raw_development_state_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_reimport_raw_development_state_type_id;
	photo_reimport_raw_development_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoReimportRawDevelopmentState", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return photo_reimport_raw_development_state_type_id;
}

GType
photo_reimport_raw_development_state_get_type (void)
{
	static volatile gsize photo_reimport_raw_development_state_type_id__once = 0;
	if (g_once_init_enter (&photo_reimport_raw_development_state_type_id__once)) {
		GType photo_reimport_raw_development_state_type_id;
		photo_reimport_raw_development_state_type_id = photo_reimport_raw_development_state_get_type_once ();
		g_once_init_leave (&photo_reimport_raw_development_state_type_id__once, photo_reimport_raw_development_state_type_id);
	}
	return photo_reimport_raw_development_state_type_id__once;
}

gpointer
photo_reimport_raw_development_state_ref (gpointer instance)
{
	PhotoReimportRawDevelopmentState * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_reimport_raw_development_state_unref (gpointer instance)
{
	PhotoReimportRawDevelopmentState * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static PhotoReimportRawDevelopmentStateImpl*
photo_reimport_raw_development_state_impl_construct (GType object_type)
{
	PhotoReimportRawDevelopmentStateImpl* self = NULL;
	self = (PhotoReimportRawDevelopmentStateImpl*) photo_reimport_raw_development_state_construct (object_type);
	return self;
}

static PhotoReimportRawDevelopmentStateImpl*
photo_reimport_raw_development_state_impl_new (void)
{
	return photo_reimport_raw_development_state_impl_construct (PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL);
}

static void
photo_reimport_raw_development_state_impl_add (PhotoReimportRawDevelopmentStateImpl* self,
                                               BackingPhotoRow* backing,
                                               PhotoMetadata* metadata)
{
	GeeCollection* _tmp0_;
	PhotoReimportRawDevelopmentStateImplDevToReimport* _tmp1_;
	PhotoReimportRawDevelopmentStateImplDevToReimport* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backing != NULL);
	_tmp0_ = self->list;
	_tmp1_ = photo_reimport_raw_development_state_impl_dev_to_reimport_new (backing, metadata);
	_tmp2_ = _tmp1_;
	gee_collection_add (_tmp0_, _tmp2_);
	_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (_tmp2_);
}

static gint
photo_reimport_raw_development_state_impl_get_size (PhotoReimportRawDevelopmentStateImpl* self)
{
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->list;
	_tmp1_ = gee_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static PhotoReimportRawDevelopmentStateImplDevToReimport*
photo_reimport_raw_development_state_impl_dev_to_reimport_construct (GType object_type,
                                                                     BackingPhotoRow* backing,
                                                                     PhotoMetadata* metadata)
{
	PhotoReimportRawDevelopmentStateImplDevToReimport* self = NULL;
	BackingPhotoRow* _tmp0_;
	PhotoMetadata* _tmp1_;
	g_return_val_if_fail (backing != NULL, NULL);
	self = (PhotoReimportRawDevelopmentStateImplDevToReimport*) g_type_create_instance (object_type);
	_tmp0_ = _backing_photo_row_ref0 (backing);
	_backing_photo_row_unref0 (self->backing);
	self->backing = _tmp0_;
	_tmp1_ = _media_metadata_ref0 (metadata);
	_media_metadata_unref0 (self->metadata);
	self->metadata = _tmp1_;
	return self;
}

static PhotoReimportRawDevelopmentStateImplDevToReimport*
photo_reimport_raw_development_state_impl_dev_to_reimport_new (BackingPhotoRow* backing,
                                                               PhotoMetadata* metadata)
{
	return photo_reimport_raw_development_state_impl_dev_to_reimport_construct (PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, backing, metadata);
}

static void
photo_reimport_raw_development_state_impl_value_dev_to_reimport_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
photo_reimport_raw_development_state_impl_value_dev_to_reimport_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_reimport_raw_development_state_impl_dev_to_reimport_unref (value->data[0].v_pointer);
	}
}

static void
photo_reimport_raw_development_state_impl_value_dev_to_reimport_copy_value (const GValue* src_value,
                                                                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_reimport_raw_development_state_impl_dev_to_reimport_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
photo_reimport_raw_development_state_impl_value_dev_to_reimport_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
photo_reimport_raw_development_state_impl_value_dev_to_reimport_collect_value (GValue* value,
                                                                               guint n_collect_values,
                                                                               GTypeCValue* collect_values,
                                                                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoReimportRawDevelopmentStateImplDevToReimport * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_reimport_raw_development_state_impl_dev_to_reimport_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
photo_reimport_raw_development_state_impl_value_dev_to_reimport_lcopy_value (const GValue* value,
                                                                             guint n_collect_values,
                                                                             GTypeCValue* collect_values,
                                                                             guint collect_flags)
{
	PhotoReimportRawDevelopmentStateImplDevToReimport ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_reimport_raw_development_state_impl_dev_to_reimport_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
photo_reimport_raw_development_state_impl_param_spec_dev_to_reimport (const gchar* name,
                                                                      const gchar* nick,
                                                                      const gchar* blurb,
                                                                      GType object_type,
                                                                      GParamFlags flags)
{
	PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
photo_reimport_raw_development_state_impl_value_get_dev_to_reimport (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT), NULL);
	return value->data[0].v_pointer;
}

static void
photo_reimport_raw_development_state_impl_value_set_dev_to_reimport (GValue* value,
                                                                     gpointer v_object)
{
	PhotoReimportRawDevelopmentStateImplDevToReimport * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_reimport_raw_development_state_impl_dev_to_reimport_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_raw_development_state_impl_dev_to_reimport_unref (old);
	}
}

static void
photo_reimport_raw_development_state_impl_value_take_dev_to_reimport (GValue* value,
                                                                      gpointer v_object)
{
	PhotoReimportRawDevelopmentStateImplDevToReimport * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_raw_development_state_impl_dev_to_reimport_unref (old);
	}
}

static void
photo_reimport_raw_development_state_impl_dev_to_reimport_class_init (PhotoReimportRawDevelopmentStateImplDevToReimportClass * klass,
                                                                      gpointer klass_data)
{
	photo_reimport_raw_development_state_impl_dev_to_reimport_parent_class = g_type_class_peek_parent (klass);
	((PhotoReimportRawDevelopmentStateImplDevToReimportClass *) klass)->finalize = photo_reimport_raw_development_state_impl_dev_to_reimport_finalize;
}

static void
photo_reimport_raw_development_state_impl_dev_to_reimport_instance_init (PhotoReimportRawDevelopmentStateImplDevToReimport * self,
                                                                         gpointer klass)
{
	BackingPhotoRow* _tmp0_;
	_tmp0_ = backing_photo_row_new ();
	self->backing = _tmp0_;
	self->ref_count = 1;
}

static void
photo_reimport_raw_development_state_impl_dev_to_reimport_finalize (PhotoReimportRawDevelopmentStateImplDevToReimport * obj)
{
	PhotoReimportRawDevelopmentStateImplDevToReimport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimport);
	g_signal_handlers_destroy (self);
	_backing_photo_row_unref0 (self->backing);
	_media_metadata_unref0 (self->metadata);
}

static GType
photo_reimport_raw_development_state_impl_dev_to_reimport_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { photo_reimport_raw_development_state_impl_value_dev_to_reimport_init, photo_reimport_raw_development_state_impl_value_dev_to_reimport_free_value, photo_reimport_raw_development_state_impl_value_dev_to_reimport_copy_value, photo_reimport_raw_development_state_impl_value_dev_to_reimport_peek_pointer, "p", photo_reimport_raw_development_state_impl_value_dev_to_reimport_collect_value, "p", photo_reimport_raw_development_state_impl_value_dev_to_reimport_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoReimportRawDevelopmentStateImplDevToReimportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_reimport_raw_development_state_impl_dev_to_reimport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoReimportRawDevelopmentStateImplDevToReimport), 0, (GInstanceInitFunc) photo_reimport_raw_development_state_impl_dev_to_reimport_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_reimport_raw_development_state_impl_dev_to_reimport_type_id;
	photo_reimport_raw_development_state_impl_dev_to_reimport_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoReimportRawDevelopmentStateImplDevToReimport", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return photo_reimport_raw_development_state_impl_dev_to_reimport_type_id;
}

GType
photo_reimport_raw_development_state_impl_dev_to_reimport_get_type (void)
{
	static volatile gsize photo_reimport_raw_development_state_impl_dev_to_reimport_type_id__once = 0;
	if (g_once_init_enter (&photo_reimport_raw_development_state_impl_dev_to_reimport_type_id__once)) {
		GType photo_reimport_raw_development_state_impl_dev_to_reimport_type_id;
		photo_reimport_raw_development_state_impl_dev_to_reimport_type_id = photo_reimport_raw_development_state_impl_dev_to_reimport_get_type_once ();
		g_once_init_leave (&photo_reimport_raw_development_state_impl_dev_to_reimport_type_id__once, photo_reimport_raw_development_state_impl_dev_to_reimport_type_id);
	}
	return photo_reimport_raw_development_state_impl_dev_to_reimport_type_id__once;
}

static gpointer
photo_reimport_raw_development_state_impl_dev_to_reimport_ref (gpointer instance)
{
	PhotoReimportRawDevelopmentStateImplDevToReimport * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
photo_reimport_raw_development_state_impl_dev_to_reimport_unref (gpointer instance)
{
	PhotoReimportRawDevelopmentStateImplDevToReimport * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
photo_reimport_raw_development_state_impl_class_init (PhotoReimportRawDevelopmentStateImplClass * klass,
                                                      gpointer klass_data)
{
	photo_reimport_raw_development_state_impl_parent_class = g_type_class_peek_parent (klass);
	((PhotoReimportRawDevelopmentStateClass *) klass)->finalize = photo_reimport_raw_development_state_impl_finalize;
}

static void
photo_reimport_raw_development_state_impl_instance_init (PhotoReimportRawDevelopmentStateImpl * self,
                                                         gpointer klass)
{
	GeeArrayList* _tmp0_;
	_tmp0_ = gee_array_list_new (PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, (GBoxedCopyFunc) photo_reimport_raw_development_state_impl_dev_to_reimport_ref, (GDestroyNotify) photo_reimport_raw_development_state_impl_dev_to_reimport_unref, NULL, NULL, NULL);
	self->list = (GeeCollection*) _tmp0_;
	self->metadata_only = FALSE;
}

static void
photo_reimport_raw_development_state_impl_finalize (PhotoReimportRawDevelopmentState * obj)
{
	PhotoReimportRawDevelopmentStateImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImpl);
	_g_object_unref0 (self->list);
	PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS (photo_reimport_raw_development_state_impl_parent_class)->finalize (obj);
}

static GType
photo_reimport_raw_development_state_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoReimportRawDevelopmentStateImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_reimport_raw_development_state_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoReimportRawDevelopmentStateImpl), 0, (GInstanceInitFunc) photo_reimport_raw_development_state_impl_instance_init, NULL };
	GType photo_reimport_raw_development_state_impl_type_id;
	photo_reimport_raw_development_state_impl_type_id = g_type_register_static (PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, "PhotoReimportRawDevelopmentStateImpl", &g_define_type_info, 0);
	return photo_reimport_raw_development_state_impl_type_id;
}

static GType
photo_reimport_raw_development_state_impl_get_type (void)
{
	static volatile gsize photo_reimport_raw_development_state_impl_type_id__once = 0;
	if (g_once_init_enter (&photo_reimport_raw_development_state_impl_type_id__once)) {
		GType photo_reimport_raw_development_state_impl_type_id;
		photo_reimport_raw_development_state_impl_type_id = photo_reimport_raw_development_state_impl_get_type_once ();
		g_once_init_leave (&photo_reimport_raw_development_state_impl_type_id__once, photo_reimport_raw_development_state_impl_type_id);
	}
	return photo_reimport_raw_development_state_impl_type_id__once;
}

static void
photo_class_init (PhotoClass * klass,
                  gpointer klass_data)
{
	photo_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Photo_private_offset);
	((PhotoClass *) klass)->notify_editable_replaced = (void (*) (Photo*, GFile*, GFile*)) photo_real_notify_editable_replaced;
	((PhotoClass *) klass)->notify_raw_development_modified = (void (*) (Photo*)) photo_real_notify_raw_development_modified;
	((PhotoClass *) klass)->notify_baseline_replaced = (void (*) (Photo*)) photo_real_notify_baseline_replaced;
	((PhotoClass *) klass)->notify_master_reimported = (void (*) (Photo*, PhotoMetadata*)) photo_real_notify_master_reimported;
	((PhotoClass *) klass)->notify_editable_reimported = (void (*) (Photo*, PhotoMetadata*)) photo_real_notify_editable_reimported;
	((PhotoClass *) klass)->notify_source_reimported = (void (*) (Photo*, PhotoMetadata*)) photo_real_notify_source_reimported;
	((PhotoClass *) klass)->notify_baseline_reimported = (void (*) (Photo*, PhotoMetadata*)) photo_real_notify_baseline_reimported;
	((DataSourceClass *) klass)->internal_delete_backing = (gboolean (*) (DataSource*, GError**)) photo_real_internal_delete_backing;
	((MediaSourceClass *) klass)->get_backing_files_state = (BackingFileState** (*) (MediaSource*, gint*)) photo_real_get_backing_files_state;
	((PhotoClass *) klass)->apply_user_metadata_for_reimport = (void (*) (Photo*, PhotoMetadata*)) photo_real_apply_user_metadata_for_reimport;
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource*)) photo_real_get_typename;
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource*)) photo_real_get_instance_id;
	((DataSourceClass *) klass)->get_source_id = (gchar* (*) (DataSource*)) photo_real_get_source_id;
	((ThumbnailSourceClass *) klass)->get_preferred_thumbnail_format = (PhotoFileFormat (*) (ThumbnailSource*)) photo_real_get_preferred_thumbnail_format;
	((ThumbnailSourceClass *) klass)->create_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) photo_real_create_thumbnail;
	((MediaSourceClass *) klass)->get_file = (GFile* (*) (MediaSource*)) photo_real_get_file;
	((MediaSourceClass *) klass)->get_master_file = (GFile* (*) (MediaSource*)) photo_real_get_master_file;
	((MediaSourceClass *) klass)->get_timestamp = (gint64 (*) (MediaSource*)) photo_real_get_timestamp;
	((MediaSourceClass *) klass)->get_event_id = (void (*) (MediaSource*, EventID*)) photo_real_get_event_id;
	((MediaSourceClass *) klass)->get_import_id = (void (*) (MediaSource*, ImportID*)) photo_real_get_import_id;
	((MediaSourceClass *) klass)->get_master_md5 = (gchar* (*) (MediaSource*)) photo_real_get_master_md5;
	((DataSourceClass *) klass)->commit_backlinks = (void (*) (DataSource*, SourceCollection*, const gchar*)) photo_real_commit_backlinks;
	((MediaSourceClass *) klass)->set_event_id = (gboolean (*) (MediaSource*, EventID*)) photo_real_set_event_id;
	((DataObjectClass *) klass)->to_string = (gchar* (*) (DataObject*)) photo_real_to_string;
	((DataSourceClass *) klass)->equals = (gboolean (*) (DataSource*, DataSource*)) photo_real_equals;
	((MediaSourceClass *) klass)->get_filesize = (guint64 (*) (MediaSource*)) photo_real_get_filesize;
	((MediaSourceClass *) klass)->get_master_filesize = (guint64 (*) (MediaSource*)) photo_real_get_master_filesize;
	((MediaSourceClass *) klass)->get_exposure_time = (gint64 (*) (MediaSource*)) photo_real_get_exposure_time;
	((MediaSourceClass *) klass)->get_basename = (gchar* (*) (MediaSource*)) photo_real_get_basename;
	((MediaSourceClass *) klass)->get_title = (gchar* (*) (MediaSource*)) photo_real_get_title;
	((MediaSourceClass *) klass)->get_comment = (gchar* (*) (MediaSource*)) photo_real_get_comment;
	((MediaSourceClass *) klass)->set_title = (void (*) (MediaSource*, const gchar*)) photo_real_set_title;
	((MediaSourceClass *) klass)->set_comment = (gboolean (*) (MediaSource*, const gchar*)) photo_real_set_comment;
	((MediaSourceClass *) klass)->get_dimensions = (void (*) (MediaSource*, PhotoException, Dimensions*)) photo_real_get_dimensions;
	((PhotoSourceClass *) klass)->get_metadata = (PhotoMetadata* (*) (PhotoSource*)) photo_real_get_metadata;
	((PhotoClass *) klass)->rotate = (void (*) (Photo*, Rotation)) photo_real_rotate;
	((PhotoSourceClass *) klass)->get_pixbuf = (GdkPixbuf* (*) (PhotoSource*, Scaling*, GError**)) photo_real_get_pixbuf;
	((PhotoClass *) klass)->has_user_generated_metadata = (gboolean (*) (Photo*)) photo_real_has_user_generated_metadata;
	((PhotoClass *) klass)->set_user_metadata_for_export = (void (*) (Photo*, PhotoMetadata*)) photo_real_set_user_metadata_for_export;
	((PhotoClass *) klass)->editable_replaced = photo_real_editable_replaced;
	((PhotoClass *) klass)->raw_development_modified = photo_real_raw_development_modified;
	((PhotoClass *) klass)->baseline_replaced = photo_real_baseline_replaced;
	((PhotoClass *) klass)->master_reimported = photo_real_master_reimported;
	((PhotoClass *) klass)->editable_reimported = photo_real_editable_reimported;
	((PhotoClass *) klass)->baseline_reimported = photo_real_baseline_reimported;
	((PhotoClass *) klass)->source_reimported = photo_real_source_reimported;
	G_OBJECT_CLASS (klass)->get_property = _vala_photo_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_photo_set_property;
	G_OBJECT_CLASS (klass)->finalize = photo_finalize;
	photo_signals[PHOTO_EDITABLE_REPLACED_SIGNAL] = g_signal_new ("editable-replaced", TYPE_PHOTO, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoClass, editable_replaced), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_get_type ());
	photo_signals[PHOTO_RAW_DEVELOPMENT_MODIFIED_SIGNAL] = g_signal_new ("raw-development-modified", TYPE_PHOTO, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoClass, raw_development_modified), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	photo_signals[PHOTO_BASELINE_REPLACED_SIGNAL] = g_signal_new ("baseline-replaced", TYPE_PHOTO, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoClass, baseline_replaced), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	photo_signals[PHOTO_MASTER_REIMPORTED_SIGNAL] = g_signal_new ("master-reimported", TYPE_PHOTO, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoClass, master_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__MEDIA_METADATA, G_TYPE_NONE, 1, TYPE_PHOTO_METADATA);
	photo_signals[PHOTO_EDITABLE_REIMPORTED_SIGNAL] = g_signal_new ("editable-reimported", TYPE_PHOTO, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoClass, editable_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__MEDIA_METADATA, G_TYPE_NONE, 1, TYPE_PHOTO_METADATA);
	photo_signals[PHOTO_BASELINE_REIMPORTED_SIGNAL] = g_signal_new ("baseline-reimported", TYPE_PHOTO, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoClass, baseline_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__MEDIA_METADATA, G_TYPE_NONE, 1, TYPE_PHOTO_METADATA);
	photo_signals[PHOTO_SOURCE_REIMPORTED_SIGNAL] = g_signal_new ("source-reimported", TYPE_PHOTO, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoClass, source_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__MEDIA_METADATA, G_TYPE_NONE, 1, TYPE_PHOTO_METADATA);
}

static void
photo_dateable_interface_init (DateableIface * iface,
                               gpointer iface_data)
{
	photo_dateable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_exposure_time = (gint64 (*) (Dateable*)) photo_real_get_exposure_time;
	iface->set_exposure_time = (void (*) (Dateable*, gint64)) photo_real_set_exposure_time;
}

static void
photo_instance_init (Photo * self,
                     gpointer klass)
{
	BackingPhotoRow* _tmp0_;
	PhotoBackingReaders* _tmp1_;
	self->priv = photo_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_row);
	_tmp0_ = backing_photo_row_new ();
	self->priv->editable = _tmp0_;
	g_rec_mutex_init (&self->priv->__lock_readers);
	_tmp1_ = photo_backing_readers_new ();
	self->priv->readers = _tmp1_;
	self->priv->transformer = NULL;
	self->priv->adjustments = NULL;
	self->priv->file_title = NULL;
	self->priv->editable_monitor = NULL;
	self->priv->reimport_editable_scheduler = NULL;
	self->priv->update_editable_attributes_scheduler = NULL;
	self->priv->remove_editable_scheduler = NULL;
	self->can_rotate_now = TRUE;
	g_rec_mutex_init (&self->priv->__lock_unmodified_precached);
	self->priv->unmodified_precached = NULL;
	self->priv->secs_since_access = NULL;
	g_rec_mutex_init (&self->priv->__lock_developments);
	self->priv->developments = NULL;
	self->backing_photo_row = NULL;
}

static void
photo_finalize (GObject * obj)
{
	Photo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO, Photo);
	g_rec_mutex_clear (&self->priv->__lock_row);
	_photo_row_unref0 (self->row);
	_backing_photo_row_unref0 (self->priv->editable);
	g_rec_mutex_clear (&self->priv->__lock_readers);
	_photo_backing_readers_unref0 (self->priv->readers);
	_pixel_transformer_unref0 (self->priv->transformer);
	_pixel_transformation_bundle_unref0 (self->priv->adjustments);
	_g_free0 (self->priv->file_title);
	_g_object_unref0 (self->priv->editable_monitor);
	_one_shot_scheduler_unref0 (self->priv->reimport_editable_scheduler);
	_one_shot_scheduler_unref0 (self->priv->update_editable_attributes_scheduler);
	_one_shot_scheduler_unref0 (self->priv->remove_editable_scheduler);
	g_rec_mutex_clear (&self->priv->__lock_unmodified_precached);
	_g_object_unref0 (self->priv->unmodified_precached);
	_g_timer_destroy0 (self->priv->secs_since_access);
	g_rec_mutex_clear (&self->priv->__lock_developments);
	_g_object_unref0 (self->priv->developments);
	_backing_photo_row_unref0 (self->backing_photo_row);
	G_OBJECT_CLASS (photo_parent_class)->finalize (obj);
}

static GType
photo_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Photo), 0, (GInstanceInitFunc) photo_instance_init, NULL };
	static const GInterfaceInfo dateable_info = { (GInterfaceInitFunc) photo_dateable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType photo_type_id;
	photo_type_id = g_type_register_static (TYPE_PHOTO_SOURCE, "Photo", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (photo_type_id, TYPE_DATEABLE, &dateable_info);
	Photo_private_offset = g_type_add_instance_private (photo_type_id, sizeof (PhotoPrivate));
	return photo_type_id;
}

GType
photo_get_type (void)
{
	static volatile gsize photo_type_id__once = 0;
	if (g_once_init_enter (&photo_type_id__once)) {
		GType photo_type_id;
		photo_type_id = photo_get_type_once ();
		g_once_init_leave (&photo_type_id__once, photo_type_id);
	}
	return photo_type_id__once;
}

static void
_vala_photo_get_property (GObject * object,
                          guint property_id,
                          GValue * value,
                          GParamSpec * pspec)
{
	Photo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PHOTO, Photo);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_photo_set_property (GObject * object,
                          guint property_id,
                          const GValue * value,
                          GParamSpec * pspec)
{
	Photo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PHOTO, Photo);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
library_photo_source_collection_get_instance_private (LibraryPhotoSourceCollection* self)
{
	return G_STRUCT_MEMBER_P (self, LibraryPhotoSourceCollection_private_offset);
}

static GType
library_photo_source_collection_state_get_type_once (void)
{
	static const GEnumValue values[] = {{LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_UNKNOWN, "LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_UNKNOWN", "unknown"}, {LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE, "LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE", "online"}, {LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE, "LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE", "offline"}, {LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH, "LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH", "trash"}, {LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE, "LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE", "editable"}, {LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER, "LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER", "developer"}, {0, NULL, NULL}};
	GType library_photo_source_collection_state_type_id;
	library_photo_source_collection_state_type_id = g_enum_register_static ("LibraryPhotoSourceCollectionState", values);
	return library_photo_source_collection_state_type_id;
}

GType
library_photo_source_collection_state_get_type (void)
{
	static volatile gsize library_photo_source_collection_state_type_id__once = 0;
	if (g_once_init_enter (&library_photo_source_collection_state_type_id__once)) {
		GType library_photo_source_collection_state_type_id;
		library_photo_source_collection_state_type_id = library_photo_source_collection_state_get_type_once ();
		g_once_init_leave (&library_photo_source_collection_state_type_id__once, library_photo_source_collection_state_type_id);
	}
	return library_photo_source_collection_state_type_id__once;
}

static guint
_file_hash_gee_hash_data_func (gconstpointer v,
                               gpointer self)
{
	guint result;
	result = file_hash ((GFile*) v);
	return result;
}

static gboolean
_file_equal_gee_equal_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gboolean result;
	result = file_equal ((GFile*) a, (GFile*) b);
	return result;
}

static gint
_int64_compare_gcompare_data_func (gconstpointer a,
                                   gconstpointer b,
                                   gpointer self)
{
	gint result;
	result = int64_compare ((gint64*) a, (gint64*) b);
	return result;
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static gboolean
_int64_equal_gee_equal_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gboolean result;
	result = int64_equal ((gint64*) a, (gint64*) b);
	return result;
}

static gint64
_photo_get_photo_key_get_source_database_key (DataSource* source,
                                              gpointer self)
{
	gint64 result;
	result = photo_get_photo_key (source);
	return result;
}

static void
_library_photo_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                    GeeCollection* added,
                                                                                                    GeeCollection* removed,
                                                                                                    gpointer self)
{
	library_photo_source_collection_on_trashcan_contents_altered ((LibraryPhotoSourceCollection*) self, added, removed);
}

static void
_library_photo_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                   GeeCollection* added,
                                                                                                   GeeCollection* removed,
                                                                                                   gpointer self)
{
	library_photo_source_collection_on_offline_contents_altered ((LibraryPhotoSourceCollection*) self, added, removed);
}

LibraryPhotoSourceCollection*
library_photo_source_collection_construct (GType object_type)
{
	LibraryPhotoSourceCollection* self = NULL;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSourceHoldingTank* _tmp2_;
	MediaSourceHoldingTank* _tmp3_;
	self = (LibraryPhotoSourceCollection*) media_source_collection_construct (object_type, "LibraryPhotoSourceCollection", _photo_get_photo_key_get_source_database_key, NULL);
	_tmp0_ = media_source_collection_get_trashcan ((MediaSourceCollection*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect ((SourceHoldingTank*) _tmp1_, "contents-altered", (GCallback) _library_photo_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered, self);
	_source_holding_tank_unref0 (_tmp1_);
	_tmp2_ = media_source_collection_get_offline_bin ((MediaSourceCollection*) self);
	_tmp3_ = _tmp2_;
	g_signal_connect ((SourceHoldingTank*) _tmp3_, "contents-altered", (GCallback) _library_photo_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered, self);
	_source_holding_tank_unref0 (_tmp3_);
	return self;
}

LibraryPhotoSourceCollection*
library_photo_source_collection_new (void)
{
	return library_photo_source_collection_construct (TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION);
}

static gboolean
_library_photo_source_collection_check_if_trashed_photo_source_holding_tank_check_to_keep (DataSource* source,
                                                                                           Alteration* alteration,
                                                                                           gpointer self)
{
	gboolean result;
	result = library_photo_source_collection_check_if_trashed_photo ((LibraryPhotoSourceCollection*) self, source, alteration);
	return result;
}

static MediaSourceHoldingTank*
library_photo_source_collection_real_create_trashcan (MediaSourceCollection* base)
{
	LibraryPhotoSourceCollection * self;
	LibraryPhotoSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* result;
	self = (LibraryPhotoSourceCollection*) base;
	_tmp0_ = library_photo_source_holding_tank_new (self, _library_photo_source_collection_check_if_trashed_photo_source_holding_tank_check_to_keep, self, _photo_get_photo_key_get_source_database_key, NULL);
	result = (MediaSourceHoldingTank*) _tmp0_;
	return result;
}

static gboolean
_library_photo_source_collection_check_if_offline_photo_source_holding_tank_check_to_keep (DataSource* source,
                                                                                           Alteration* alteration,
                                                                                           gpointer self)
{
	gboolean result;
	result = library_photo_source_collection_check_if_offline_photo ((LibraryPhotoSourceCollection*) self, source, alteration);
	return result;
}

static MediaSourceHoldingTank*
library_photo_source_collection_real_create_offline_bin (MediaSourceCollection* base)
{
	LibraryPhotoSourceCollection * self;
	LibraryPhotoSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* result;
	self = (LibraryPhotoSourceCollection*) base;
	_tmp0_ = library_photo_source_holding_tank_new (self, _library_photo_source_collection_check_if_offline_photo_source_holding_tank_check_to_keep, self, _photo_get_photo_key_get_source_database_key, NULL);
	result = (MediaSourceHoldingTank*) _tmp0_;
	return result;
}

static MediaMonitor*
library_photo_source_collection_real_create_media_monitor (MediaSourceCollection* base,
                                                           Workers* workers,
                                                           GCancellable* cancellable)
{
	LibraryPhotoSourceCollection * self;
	PhotoMonitor* _tmp0_;
	MediaMonitor* result;
	self = (LibraryPhotoSourceCollection*) base;
	g_return_val_if_fail (workers != NULL, NULL);
	g_return_val_if_fail (cancellable != NULL, NULL);
	_tmp0_ = photo_monitor_new (workers, cancellable);
	result = (MediaMonitor*) _tmp0_;
	return result;
}

static gboolean
library_photo_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                           DataSource* source)
{
	LibraryPhotoSourceCollection * self;
	gboolean result;
	self = (LibraryPhotoSourceCollection*) base;
	g_return_val_if_fail (source != NULL, FALSE);
	result = IS_LIBRARY_PHOTO (source);
	return result;
}

static gchar*
library_photo_source_collection_real_get_typename (MediaSourceCollection* base)
{
	LibraryPhotoSourceCollection * self;
	gchar* _tmp0_;
	gchar* result;
	self = (LibraryPhotoSourceCollection*) base;
	_tmp0_ = g_strdup (PHOTO_TYPENAME);
	result = _tmp0_;
	return result;
}

static gboolean
library_photo_source_collection_real_is_file_recognized (MediaSourceCollection* base,
                                                         GFile* file)
{
	LibraryPhotoSourceCollection * self;
	gboolean result;
	self = (LibraryPhotoSourceCollection*) base;
	g_return_val_if_fail (file != NULL, FALSE);
	result = photo_file_format_is_file_supported (file);
	return result;
}

static void
_library_photo_source_collection_on_editable_replaced_photo_editable_replaced (Photo* _sender,
                                                                               GFile* old_file,
                                                                               GFile* new_file,
                                                                               gpointer self)
{
	library_photo_source_collection_on_editable_replaced ((LibraryPhotoSourceCollection*) self, _sender, old_file, new_file);
}

static void
_library_photo_source_collection_on_raw_development_modified_photo_raw_development_modified (Photo* _sender,
                                                                                             gpointer self)
{
	library_photo_source_collection_on_raw_development_modified ((LibraryPhotoSourceCollection*) self, _sender);
}

static void
library_photo_source_collection_real_notify_contents_altered (DataCollection* base,
                                                              GeeIterable* added,
                                                              GeeIterable* removed)
{
	LibraryPhotoSourceCollection * self;
	self = (LibraryPhotoSourceCollection*) base;
	if (added != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator (added);
			_object_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				DataObject* object = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				LibraryPhoto* photo = NULL;
				DataObject* _tmp4_;
				LibraryPhoto* _tmp5_;
				GFile* editable = NULL;
				LibraryPhoto* _tmp6_;
				GFile* _tmp7_;
				GFile* _tmp8_;
				LibraryPhoto* _tmp12_;
				GeeCollection* raw_list = NULL;
				LibraryPhoto* _tmp13_;
				GeeCollection* _tmp14_;
				GeeCollection* _tmp15_;
				LibraryPhoto* _tmp24_;
				gint64 master_filesize = 0LL;
				LibraryPhoto* _tmp25_;
				BackingPhotoRow* _tmp26_;
				BackingPhotoRow* _tmp27_;
				gint64 _tmp28_;
				gint64 _tmp29_ = 0LL;
				LibraryPhoto* _tmp30_;
				BackingPhotoRow* _tmp31_;
				BackingPhotoRow* _tmp32_;
				gboolean _tmp33_;
				gint64 editable_filesize = 0LL;
				GeeMultiMap* _tmp37_;
				LibraryPhoto* _tmp38_;
				GeeHashMap* _tmp39_;
				LibraryPhoto* _tmp40_;
				GeeCollection* raw_rows = NULL;
				LibraryPhoto* _tmp45_;
				GeeCollection* _tmp46_;
				GeeCollection* _tmp47_;
				_tmp1_ = _object_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _object_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				object = (DataObject*) _tmp3_;
				_tmp4_ = object;
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
				photo = _tmp5_;
				_tmp6_ = photo;
				_tmp7_ = photo_get_editable_file ((Photo*) _tmp6_);
				editable = _tmp7_;
				_tmp8_ = editable;
				if (_tmp8_ != NULL) {
					GeeHashMap* _tmp9_;
					GFile* _tmp10_;
					LibraryPhoto* _tmp11_;
					_tmp9_ = self->priv->by_editable_file;
					_tmp10_ = editable;
					_tmp11_ = photo;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, _tmp10_, _tmp11_);
				}
				_tmp12_ = photo;
				g_signal_connect ((Photo*) _tmp12_, "editable-replaced", (GCallback) _library_photo_source_collection_on_editable_replaced_photo_editable_replaced, self);
				_tmp13_ = photo;
				_tmp14_ = photo_get_raw_developer_files ((Photo*) _tmp13_);
				raw_list = _tmp14_;
				_tmp15_ = raw_list;
				if (_tmp15_ != NULL) {
					{
						GeeIterator* _f_it = NULL;
						GeeCollection* _tmp16_;
						GeeIterator* _tmp17_;
						_tmp16_ = raw_list;
						_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
						_f_it = _tmp17_;
						while (TRUE) {
							GeeIterator* _tmp18_;
							GFile* f = NULL;
							GeeIterator* _tmp19_;
							gpointer _tmp20_;
							GeeHashMap* _tmp21_;
							GFile* _tmp22_;
							LibraryPhoto* _tmp23_;
							_tmp18_ = _f_it;
							if (!gee_iterator_next (_tmp18_)) {
								break;
							}
							_tmp19_ = _f_it;
							_tmp20_ = gee_iterator_get (_tmp19_);
							f = (GFile*) _tmp20_;
							_tmp21_ = self->priv->by_raw_development_file;
							_tmp22_ = f;
							_tmp23_ = photo;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, _tmp22_, _tmp23_);
							_g_object_unref0 (f);
						}
						_g_object_unref0 (_f_it);
					}
				}
				_tmp24_ = photo;
				g_signal_connect ((Photo*) _tmp24_, "raw-development-modified", (GCallback) _library_photo_source_collection_on_raw_development_modified_photo_raw_development_modified, self);
				_tmp25_ = photo;
				_tmp26_ = photo_get_master_photo_row ((Photo*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = _tmp27_->filesize;
				_backing_photo_row_unref0 (_tmp27_);
				master_filesize = _tmp28_;
				_tmp30_ = photo;
				_tmp31_ = photo_get_editable_photo_row ((Photo*) _tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = _tmp32_ != NULL;
				_backing_photo_row_unref0 (_tmp32_);
				if (_tmp33_) {
					LibraryPhoto* _tmp34_;
					BackingPhotoRow* _tmp35_;
					BackingPhotoRow* _tmp36_;
					_tmp34_ = photo;
					_tmp35_ = photo_get_editable_photo_row ((Photo*) _tmp34_);
					_tmp36_ = _tmp35_;
					_tmp29_ = _tmp36_->filesize;
					_backing_photo_row_unref0 (_tmp36_);
				} else {
					_tmp29_ = (gint64) -1;
				}
				editable_filesize = _tmp29_;
				_tmp37_ = self->priv->filesize_to_photo;
				_tmp38_ = photo;
				gee_multi_map_set (_tmp37_, &master_filesize, _tmp38_);
				_tmp39_ = self->priv->photo_to_master_filesize;
				_tmp40_ = photo;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp39_, _tmp40_, &master_filesize);
				if (editable_filesize >= ((gint64) 0)) {
					GeeMultiMap* _tmp41_;
					LibraryPhoto* _tmp42_;
					GeeHashMap* _tmp43_;
					LibraryPhoto* _tmp44_;
					_tmp41_ = self->priv->filesize_to_photo;
					_tmp42_ = photo;
					gee_multi_map_set (_tmp41_, &editable_filesize, _tmp42_);
					_tmp43_ = self->priv->photo_to_editable_filesize;
					_tmp44_ = photo;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp43_, _tmp44_, &editable_filesize);
				}
				_tmp45_ = photo;
				_tmp46_ = photo_get_raw_development_photo_rows ((Photo*) _tmp45_);
				raw_rows = _tmp46_;
				_tmp47_ = raw_rows;
				if (_tmp47_ != NULL) {
					{
						GeeIterator* _row_it = NULL;
						GeeCollection* _tmp48_;
						GeeIterator* _tmp49_;
						_tmp48_ = raw_rows;
						_tmp49_ = gee_iterable_iterator ((GeeIterable*) _tmp48_);
						_row_it = _tmp49_;
						while (TRUE) {
							GeeIterator* _tmp50_;
							BackingPhotoRow* row = NULL;
							GeeIterator* _tmp51_;
							gpointer _tmp52_;
							BackingPhotoRow* _tmp53_;
							_tmp50_ = _row_it;
							if (!gee_iterator_next (_tmp50_)) {
								break;
							}
							_tmp51_ = _row_it;
							_tmp52_ = gee_iterator_get (_tmp51_);
							row = (BackingPhotoRow*) _tmp52_;
							_tmp53_ = row;
							if (_tmp53_->filesize >= ((gint64) 0)) {
								GeeMultiMap* _tmp54_;
								BackingPhotoRow* _tmp55_;
								LibraryPhoto* _tmp56_;
								GeeMultiMap* _tmp57_;
								LibraryPhoto* _tmp58_;
								BackingPhotoRow* _tmp59_;
								_tmp54_ = self->priv->filesize_to_photo;
								_tmp55_ = row;
								_tmp56_ = photo;
								gee_multi_map_set (_tmp54_, &_tmp55_->filesize, _tmp56_);
								_tmp57_ = self->priv->photo_to_raw_development_filesize;
								_tmp58_ = photo;
								_tmp59_ = row;
								gee_multi_map_set (_tmp57_, _tmp58_, &_tmp59_->filesize);
							}
							_backing_photo_row_unref0 (row);
						}
						_g_object_unref0 (_row_it);
					}
				}
				_g_object_unref0 (raw_rows);
				_g_object_unref0 (raw_list);
				_g_object_unref0 (editable);
				_g_object_unref0 (photo);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	if (removed != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp60_;
			_tmp60_ = gee_iterable_iterator (removed);
			_object_it = _tmp60_;
			while (TRUE) {
				GeeIterator* _tmp61_;
				DataObject* object = NULL;
				GeeIterator* _tmp62_;
				gpointer _tmp63_;
				LibraryPhoto* photo = NULL;
				DataObject* _tmp64_;
				LibraryPhoto* _tmp65_;
				GFile* editable = NULL;
				LibraryPhoto* _tmp66_;
				GFile* _tmp67_;
				GFile* _tmp68_;
				LibraryPhoto* _tmp74_;
				guint _tmp75_;
				GeeCollection* raw_list = NULL;
				LibraryPhoto* _tmp76_;
				GeeCollection* _tmp77_;
				GeeCollection* _tmp78_;
				LibraryPhoto* _tmp86_;
				guint _tmp87_;
				gint64 master_filesize = 0LL;
				LibraryPhoto* _tmp88_;
				BackingPhotoRow* _tmp89_;
				BackingPhotoRow* _tmp90_;
				gint64 _tmp91_;
				gint64 _tmp92_ = 0LL;
				LibraryPhoto* _tmp93_;
				BackingPhotoRow* _tmp94_;
				BackingPhotoRow* _tmp95_;
				gboolean _tmp96_;
				gint64 editable_filesize = 0LL;
				GeeMultiMap* _tmp100_;
				LibraryPhoto* _tmp101_;
				GeeHashMap* _tmp102_;
				LibraryPhoto* _tmp103_;
				GeeCollection* raw_rows = NULL;
				LibraryPhoto* _tmp108_;
				GeeCollection* _tmp109_;
				GeeCollection* _tmp110_;
				_tmp61_ = _object_it;
				if (!gee_iterator_next (_tmp61_)) {
					break;
				}
				_tmp62_ = _object_it;
				_tmp63_ = gee_iterator_get (_tmp62_);
				object = (DataObject*) _tmp63_;
				_tmp64_ = object;
				_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
				photo = _tmp65_;
				_tmp66_ = photo;
				_tmp67_ = photo_get_editable_file ((Photo*) _tmp66_);
				editable = _tmp67_;
				_tmp68_ = editable;
				if (_tmp68_ != NULL) {
					gboolean is_removed = FALSE;
					GeeHashMap* _tmp69_;
					LibraryPhoto* _tmp70_;
					GFile* _tmp71_;
					GFile* _tmp72_;
					gboolean _tmp73_;
					_tmp69_ = self->priv->by_editable_file;
					_tmp70_ = photo;
					_tmp71_ = photo_get_editable_file ((Photo*) _tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = gee_abstract_map_unset ((GeeAbstractMap*) _tmp69_, _tmp72_, NULL);
					_g_object_unref0 (_tmp72_);
					is_removed = _tmp73_;
					_vala_assert (is_removed, "is_removed");
				}
				_tmp74_ = photo;
				g_signal_parse_name ("editable-replaced", TYPE_PHOTO, &_tmp75_, NULL, FALSE);
				g_signal_handlers_disconnect_matched ((Photo*) _tmp74_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp75_, 0, NULL, (GCallback) _library_photo_source_collection_on_editable_replaced_photo_editable_replaced, self);
				_tmp76_ = photo;
				_tmp77_ = photo_get_raw_developer_files ((Photo*) _tmp76_);
				raw_list = _tmp77_;
				_tmp78_ = raw_list;
				if (_tmp78_ != NULL) {
					{
						GeeIterator* _f_it = NULL;
						GeeCollection* _tmp79_;
						GeeIterator* _tmp80_;
						_tmp79_ = raw_list;
						_tmp80_ = gee_iterable_iterator ((GeeIterable*) _tmp79_);
						_f_it = _tmp80_;
						while (TRUE) {
							GeeIterator* _tmp81_;
							GFile* f = NULL;
							GeeIterator* _tmp82_;
							gpointer _tmp83_;
							GeeHashMap* _tmp84_;
							GFile* _tmp85_;
							_tmp81_ = _f_it;
							if (!gee_iterator_next (_tmp81_)) {
								break;
							}
							_tmp82_ = _f_it;
							_tmp83_ = gee_iterator_get (_tmp82_);
							f = (GFile*) _tmp83_;
							_tmp84_ = self->priv->by_raw_development_file;
							_tmp85_ = f;
							gee_abstract_map_unset ((GeeAbstractMap*) _tmp84_, _tmp85_, NULL);
							_g_object_unref0 (f);
						}
						_g_object_unref0 (_f_it);
					}
				}
				_tmp86_ = photo;
				g_signal_parse_name ("raw-development-modified", TYPE_PHOTO, &_tmp87_, NULL, FALSE);
				g_signal_handlers_disconnect_matched ((Photo*) _tmp86_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp87_, 0, NULL, (GCallback) _library_photo_source_collection_on_raw_development_modified_photo_raw_development_modified, self);
				_tmp88_ = photo;
				_tmp89_ = photo_get_master_photo_row ((Photo*) _tmp88_);
				_tmp90_ = _tmp89_;
				_tmp91_ = _tmp90_->filesize;
				_backing_photo_row_unref0 (_tmp90_);
				master_filesize = _tmp91_;
				_tmp93_ = photo;
				_tmp94_ = photo_get_editable_photo_row ((Photo*) _tmp93_);
				_tmp95_ = _tmp94_;
				_tmp96_ = _tmp95_ != NULL;
				_backing_photo_row_unref0 (_tmp95_);
				if (_tmp96_) {
					LibraryPhoto* _tmp97_;
					BackingPhotoRow* _tmp98_;
					BackingPhotoRow* _tmp99_;
					_tmp97_ = photo;
					_tmp98_ = photo_get_editable_photo_row ((Photo*) _tmp97_);
					_tmp99_ = _tmp98_;
					_tmp92_ = _tmp99_->filesize;
					_backing_photo_row_unref0 (_tmp99_);
				} else {
					_tmp92_ = (gint64) -1;
				}
				editable_filesize = _tmp92_;
				_tmp100_ = self->priv->filesize_to_photo;
				_tmp101_ = photo;
				gee_multi_map_remove (_tmp100_, &master_filesize, _tmp101_);
				_tmp102_ = self->priv->photo_to_master_filesize;
				_tmp103_ = photo;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp102_, _tmp103_, NULL);
				if (editable_filesize >= ((gint64) 0)) {
					GeeMultiMap* _tmp104_;
					LibraryPhoto* _tmp105_;
					GeeHashMap* _tmp106_;
					LibraryPhoto* _tmp107_;
					_tmp104_ = self->priv->filesize_to_photo;
					_tmp105_ = photo;
					gee_multi_map_remove (_tmp104_, &editable_filesize, _tmp105_);
					_tmp106_ = self->priv->photo_to_editable_filesize;
					_tmp107_ = photo;
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp106_, _tmp107_, NULL);
				}
				_tmp108_ = photo;
				_tmp109_ = photo_get_raw_development_photo_rows ((Photo*) _tmp108_);
				raw_rows = _tmp109_;
				_tmp110_ = raw_rows;
				if (_tmp110_ != NULL) {
					{
						GeeIterator* _row_it = NULL;
						GeeCollection* _tmp111_;
						GeeIterator* _tmp112_;
						_tmp111_ = raw_rows;
						_tmp112_ = gee_iterable_iterator ((GeeIterable*) _tmp111_);
						_row_it = _tmp112_;
						while (TRUE) {
							GeeIterator* _tmp113_;
							BackingPhotoRow* row = NULL;
							GeeIterator* _tmp114_;
							gpointer _tmp115_;
							BackingPhotoRow* _tmp116_;
							_tmp113_ = _row_it;
							if (!gee_iterator_next (_tmp113_)) {
								break;
							}
							_tmp114_ = _row_it;
							_tmp115_ = gee_iterator_get (_tmp114_);
							row = (BackingPhotoRow*) _tmp115_;
							_tmp116_ = row;
							if (_tmp116_->filesize >= ((gint64) 0)) {
								GeeMultiMap* _tmp117_;
								BackingPhotoRow* _tmp118_;
								LibraryPhoto* _tmp119_;
								GeeMultiMap* _tmp120_;
								LibraryPhoto* _tmp121_;
								BackingPhotoRow* _tmp122_;
								_tmp117_ = self->priv->filesize_to_photo;
								_tmp118_ = row;
								_tmp119_ = photo;
								gee_multi_map_remove (_tmp117_, &_tmp118_->filesize, _tmp119_);
								_tmp120_ = self->priv->photo_to_raw_development_filesize;
								_tmp121_ = photo;
								_tmp122_ = row;
								gee_multi_map_remove (_tmp120_, _tmp121_, &_tmp122_->filesize);
							}
							_backing_photo_row_unref0 (row);
						}
						_g_object_unref0 (_row_it);
					}
				}
				_g_object_unref0 (raw_rows);
				_g_object_unref0 (raw_list);
				_g_object_unref0 (editable);
				_g_object_unref0 (photo);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	DATA_COLLECTION_CLASS (library_photo_source_collection_parent_class)->notify_contents_altered ((DataCollection*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), added, removed);
}

static void
library_photo_source_collection_on_editable_replaced (LibraryPhotoSourceCollection* self,
                                                      Photo* photo,
                                                      GFile* old_file,
                                                      GFile* new_file)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo != NULL);
	if (old_file != NULL) {
		gboolean is_removed = FALSE;
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->by_editable_file;
		is_removed = gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, old_file, NULL);
		_vala_assert (is_removed, "is_removed");
	}
	if (new_file != NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = self->priv->by_editable_file;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, new_file, G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_LIBRARY_PHOTO, LibraryPhoto));
	}
}

static void
library_photo_source_collection_on_raw_development_modified (LibraryPhotoSourceCollection* self,
                                                             Photo* _photo)
{
	LibraryPhoto* photo = NULL;
	LibraryPhoto* _tmp0_;
	LibraryPhoto* _tmp1_;
	GeeMultiMap* _tmp2_;
	LibraryPhoto* _tmp3_;
	GeeCollection* raw_list = NULL;
	LibraryPhoto* _tmp19_;
	GeeCollection* _tmp20_;
	GeeCollection* _tmp21_;
	GeeCollection* raw_rows = NULL;
	LibraryPhoto* _tmp30_;
	GeeCollection* _tmp31_;
	GeeCollection* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_photo != NULL);
	_tmp0_ = _g_object_ref0 (IS_LIBRARY_PHOTO (_photo) ? ((LibraryPhoto*) _photo) : NULL);
	photo = _tmp0_;
	_tmp1_ = photo;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (photo);
		return;
	}
	_tmp2_ = self->priv->photo_to_raw_development_filesize;
	_tmp3_ = photo;
	if (gee_multi_map_contains (_tmp2_, _tmp3_)) {
		GeeMultiMap* _tmp17_;
		LibraryPhoto* _tmp18_;
		{
			GeeIterator* _s_it = NULL;
			GeeMultiMap* _tmp4_;
			LibraryPhoto* _tmp5_;
			GeeCollection* _tmp6_;
			GeeCollection* _tmp7_;
			GeeIterator* _tmp8_;
			GeeIterator* _tmp9_;
			_tmp4_ = self->priv->photo_to_raw_development_filesize;
			_tmp5_ = photo;
			_tmp6_ = gee_multi_map_get (_tmp4_, _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
			_tmp9_ = _tmp8_;
			_g_object_unref0 (_tmp7_);
			_s_it = _tmp9_;
			while (TRUE) {
				GeeIterator* _tmp10_;
				gint64 s = 0LL;
				GeeIterator* _tmp11_;
				gpointer _tmp12_;
				gint64* _tmp13_;
				gint64 _tmp14_;
				GeeMultiMap* _tmp15_;
				LibraryPhoto* _tmp16_;
				_tmp10_ = _s_it;
				if (!gee_iterator_next (_tmp10_)) {
					break;
				}
				_tmp11_ = _s_it;
				_tmp12_ = gee_iterator_get (_tmp11_);
				_tmp13_ = (gint64*) _tmp12_;
				_tmp14_ = *_tmp13_;
				_g_free0 (_tmp13_);
				s = _tmp14_;
				_tmp15_ = self->priv->filesize_to_photo;
				_tmp16_ = photo;
				gee_multi_map_remove (_tmp15_, &s, _tmp16_);
			}
			_g_object_unref0 (_s_it);
		}
		_tmp17_ = self->priv->photo_to_raw_development_filesize;
		_tmp18_ = photo;
		gee_multi_map_remove_all (_tmp17_, _tmp18_);
	}
	_tmp19_ = photo;
	_tmp20_ = photo_get_raw_developer_files ((Photo*) _tmp19_);
	raw_list = _tmp20_;
	_tmp21_ = raw_list;
	if (_tmp21_ != NULL) {
		{
			GeeIterator* _f_it = NULL;
			GeeCollection* _tmp22_;
			GeeIterator* _tmp23_;
			_tmp22_ = raw_list;
			_tmp23_ = gee_iterable_iterator ((GeeIterable*) _tmp22_);
			_f_it = _tmp23_;
			while (TRUE) {
				GeeIterator* _tmp24_;
				GFile* f = NULL;
				GeeIterator* _tmp25_;
				gpointer _tmp26_;
				GeeHashMap* _tmp27_;
				GFile* _tmp28_;
				LibraryPhoto* _tmp29_;
				_tmp24_ = _f_it;
				if (!gee_iterator_next (_tmp24_)) {
					break;
				}
				_tmp25_ = _f_it;
				_tmp26_ = gee_iterator_get (_tmp25_);
				f = (GFile*) _tmp26_;
				_tmp27_ = self->priv->by_raw_development_file;
				_tmp28_ = f;
				_tmp29_ = photo;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp28_, _tmp29_);
				_g_object_unref0 (f);
			}
			_g_object_unref0 (_f_it);
		}
	}
	_tmp30_ = photo;
	_tmp31_ = photo_get_raw_development_photo_rows ((Photo*) _tmp30_);
	raw_rows = _tmp31_;
	_tmp32_ = raw_rows;
	if (_tmp32_ != NULL) {
		{
			GeeIterator* _row_it = NULL;
			GeeCollection* _tmp33_;
			GeeIterator* _tmp34_;
			_tmp33_ = raw_rows;
			_tmp34_ = gee_iterable_iterator ((GeeIterable*) _tmp33_);
			_row_it = _tmp34_;
			while (TRUE) {
				GeeIterator* _tmp35_;
				BackingPhotoRow* row = NULL;
				GeeIterator* _tmp36_;
				gpointer _tmp37_;
				BackingPhotoRow* _tmp38_;
				_tmp35_ = _row_it;
				if (!gee_iterator_next (_tmp35_)) {
					break;
				}
				_tmp36_ = _row_it;
				_tmp37_ = gee_iterator_get (_tmp36_);
				row = (BackingPhotoRow*) _tmp37_;
				_tmp38_ = row;
				if (_tmp38_->filesize > ((gint64) 0)) {
					GeeMultiMap* _tmp39_;
					BackingPhotoRow* _tmp40_;
					LibraryPhoto* _tmp41_;
					GeeMultiMap* _tmp42_;
					LibraryPhoto* _tmp43_;
					BackingPhotoRow* _tmp44_;
					_tmp39_ = self->priv->filesize_to_photo;
					_tmp40_ = row;
					_tmp41_ = photo;
					gee_multi_map_set (_tmp39_, &_tmp40_->filesize, _tmp41_);
					_tmp42_ = self->priv->photo_to_raw_development_filesize;
					_tmp43_ = photo;
					_tmp44_ = row;
					gee_multi_map_set (_tmp42_, _tmp43_, &_tmp44_->filesize);
				}
				_backing_photo_row_unref0 (row);
			}
			_g_object_unref0 (_row_it);
		}
	}
	_g_object_unref0 (raw_rows);
	_g_object_unref0 (raw_list);
	_g_object_unref0 (photo);
}

static gpointer
__int64_dup0 (gpointer self)
{
	return self ? _int64_dup (self) : NULL;
}

static void
library_photo_source_collection_real_items_altered (DataCollection* base,
                                                    GeeMap* items)
{
	LibraryPhotoSourceCollection * self;
	self = (LibraryPhotoSourceCollection*) base;
	g_return_if_fail (items != NULL);
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (items);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Alteration* alteration = NULL;
			DataObject* _tmp8_;
			gpointer _tmp9_;
			LibraryPhoto* photo = NULL;
			DataObject* _tmp10_;
			LibraryPhoto* _tmp11_;
			gboolean _tmp12_ = FALSE;
			Alteration* _tmp13_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = gee_map_get (items, _tmp8_);
			alteration = (Alteration*) _tmp9_;
			_tmp10_ = object;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
			photo = _tmp11_;
			_tmp13_ = alteration;
			if (alteration_has_detail (_tmp13_, "image", "master")) {
				_tmp12_ = TRUE;
			} else {
				Alteration* _tmp14_;
				_tmp14_ = alteration;
				_tmp12_ = alteration_has_detail (_tmp14_, "image", "editable");
			}
			if (_tmp12_) {
				gint64 old_master_filesize = 0LL;
				GeeHashMap* _tmp15_;
				LibraryPhoto* _tmp16_;
				gpointer _tmp17_;
				gint64* _tmp18_;
				gint64 _tmp19_;
				gint64* _tmp20_ = NULL;
				GeeHashMap* _tmp21_;
				LibraryPhoto* _tmp22_;
				gint64 old_editable_filesize = 0LL;
				GeeHashMap* _tmp28_;
				LibraryPhoto* _tmp29_;
				GeeMultiMap* _tmp30_;
				LibraryPhoto* _tmp31_;
				gint64 master_filesize = 0LL;
				LibraryPhoto* _tmp36_;
				BackingPhotoRow* _tmp37_;
				BackingPhotoRow* _tmp38_;
				gint64 _tmp39_;
				gint64 _tmp40_ = 0LL;
				LibraryPhoto* _tmp41_;
				BackingPhotoRow* _tmp42_;
				BackingPhotoRow* _tmp43_;
				gboolean _tmp44_;
				gint64 editable_filesize = 0LL;
				GeeHashMap* _tmp48_;
				LibraryPhoto* _tmp49_;
				GeeMultiMap* _tmp50_;
				LibraryPhoto* _tmp51_;
				_tmp15_ = self->priv->photo_to_master_filesize;
				_tmp16_ = photo;
				_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
				_tmp18_ = (gint64*) _tmp17_;
				_tmp19_ = *_tmp18_;
				_g_free0 (_tmp18_);
				old_master_filesize = _tmp19_;
				_tmp21_ = self->priv->photo_to_editable_filesize;
				_tmp22_ = photo;
				if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp21_, _tmp22_)) {
					GeeHashMap* _tmp23_;
					LibraryPhoto* _tmp24_;
					gpointer _tmp25_;
					_tmp23_ = self->priv->photo_to_editable_filesize;
					_tmp24_ = photo;
					_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, _tmp24_);
					_g_free0 (_tmp20_);
					_tmp20_ = (gint64*) _tmp25_;
				} else {
					gint64 _tmp26_;
					gint64* _tmp27_;
					_tmp26_ = (gint64) -1;
					_tmp27_ = __int64_dup0 (&_tmp26_);
					_g_free0 (_tmp20_);
					_tmp20_ = _tmp27_;
				}
				old_editable_filesize = *_tmp20_;
				_tmp28_ = self->priv->photo_to_master_filesize;
				_tmp29_ = photo;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp28_, _tmp29_, NULL);
				_tmp30_ = self->priv->filesize_to_photo;
				_tmp31_ = photo;
				gee_multi_map_remove (_tmp30_, &old_master_filesize, _tmp31_);
				if (old_editable_filesize >= ((gint64) 0)) {
					GeeHashMap* _tmp32_;
					LibraryPhoto* _tmp33_;
					GeeMultiMap* _tmp34_;
					LibraryPhoto* _tmp35_;
					_tmp32_ = self->priv->photo_to_editable_filesize;
					_tmp33_ = photo;
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp32_, _tmp33_, NULL);
					_tmp34_ = self->priv->filesize_to_photo;
					_tmp35_ = photo;
					gee_multi_map_remove (_tmp34_, &old_editable_filesize, _tmp35_);
				}
				_tmp36_ = photo;
				_tmp37_ = photo_get_master_photo_row ((Photo*) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = _tmp38_->filesize;
				_backing_photo_row_unref0 (_tmp38_);
				master_filesize = _tmp39_;
				_tmp41_ = photo;
				_tmp42_ = photo_get_editable_photo_row ((Photo*) _tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = _tmp43_ != NULL;
				_backing_photo_row_unref0 (_tmp43_);
				if (_tmp44_) {
					LibraryPhoto* _tmp45_;
					BackingPhotoRow* _tmp46_;
					BackingPhotoRow* _tmp47_;
					_tmp45_ = photo;
					_tmp46_ = photo_get_editable_photo_row ((Photo*) _tmp45_);
					_tmp47_ = _tmp46_;
					_tmp40_ = _tmp47_->filesize;
					_backing_photo_row_unref0 (_tmp47_);
				} else {
					_tmp40_ = (gint64) -1;
				}
				editable_filesize = _tmp40_;
				_tmp48_ = self->priv->photo_to_master_filesize;
				_tmp49_ = photo;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp48_, _tmp49_, &master_filesize);
				_tmp50_ = self->priv->filesize_to_photo;
				_tmp51_ = photo;
				gee_multi_map_set (_tmp50_, &master_filesize, _tmp51_);
				if (editable_filesize >= ((gint64) 0)) {
					GeeHashMap* _tmp52_;
					LibraryPhoto* _tmp53_;
					GeeMultiMap* _tmp54_;
					LibraryPhoto* _tmp55_;
					_tmp52_ = self->priv->photo_to_editable_filesize;
					_tmp53_ = photo;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp52_, _tmp53_, &editable_filesize);
					_tmp54_ = self->priv->filesize_to_photo;
					_tmp55_ = photo;
					gee_multi_map_set (_tmp54_, &editable_filesize, _tmp55_);
				}
				_g_free0 (_tmp20_);
			}
			_g_object_unref0 (photo);
			_alteration_unref0 (alteration);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	DATA_COLLECTION_CLASS (library_photo_source_collection_parent_class)->items_altered ((DataCollection*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), items);
}

static void
library_photo_source_collection_real_postprocess_imported_media (MediaSourceCollection* base,
                                                                 GeeCollection* media_sources)
{
	LibraryPhotoSourceCollection * self;
	GeeHashMultiMap* map = NULL;
	GeeHashMultiMap* _tmp0_;
	self = (LibraryPhotoSourceCollection*) base;
	g_return_if_fail (media_sources != NULL);
	_tmp0_ = gee_hash_multi_map_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	map = _tmp0_;
	{
		GeeIterator* _media_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) media_sources);
		_media_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			MediaSource* media = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			LibraryPhoto* photo = NULL;
			MediaSource* _tmp5_;
			LibraryPhoto* _tmp6_;
			PhotoMetadata* metadata = NULL;
			LibraryPhoto* _tmp7_;
			PhotoMetadata* _tmp8_;
			HierarchicalTagIndex* global_index = NULL;
			HierarchicalTagIndex* _tmp9_;
			HierarchicalTagIndex* htag_index = NULL;
			PhotoMetadata* _tmp10_;
			LibraryPhoto* _tmp15_;
			GeeCollection* _tmp16_;
			GeeCollection* _tmp17_;
			gboolean _tmp18_;
			PhotoMetadata* _tmp49_;
			_tmp2_ = _media_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _media_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			media = (MediaSource*) _tmp4_;
			_tmp5_ = media;
			_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
			photo = _tmp6_;
			_tmp7_ = photo;
			_tmp8_ = photo_source_get_metadata ((PhotoSource*) _tmp7_);
			metadata = _tmp8_;
			_tmp9_ = hierarchical_tag_index_get_global_index ();
			global_index = _tmp9_;
			htag_index = NULL;
			_tmp10_ = metadata;
			if (photo_metadata_has_hierarchical_keywords (_tmp10_)) {
				PhotoMetadata* _tmp11_;
				GeeSet* _tmp12_;
				GeeSet* _tmp13_;
				HierarchicalTagIndex* _tmp14_;
				_tmp11_ = metadata;
				_tmp12_ = photo_metadata_get_hierarchical_keywords (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = hierarchical_tag_utilities_process_hierarchical_import_keywords ((GeeCollection*) _tmp13_);
				_hierarchical_tag_index_unref0 (htag_index);
				htag_index = _tmp14_;
				_g_object_unref0 (_tmp13_);
			}
			_tmp15_ = photo;
			_tmp16_ = library_photo_get_import_keywords (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp17_ != NULL;
			_g_object_unref0 (_tmp17_);
			if (_tmp18_) {
				{
					GeeIterator* _keyword_it = NULL;
					LibraryPhoto* _tmp19_;
					GeeCollection* _tmp20_;
					GeeCollection* _tmp21_;
					GeeIterator* _tmp22_;
					GeeIterator* _tmp23_;
					_tmp19_ = photo;
					_tmp20_ = library_photo_get_import_keywords (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
					_tmp23_ = _tmp22_;
					_g_object_unref0 (_tmp21_);
					_keyword_it = _tmp23_;
					while (TRUE) {
						GeeIterator* _tmp24_;
						gchar* keyword = NULL;
						GeeIterator* _tmp25_;
						gpointer _tmp26_;
						gboolean _tmp27_ = FALSE;
						HierarchicalTagIndex* _tmp28_;
						gchar* name = NULL;
						const gchar* _tmp31_;
						gchar* _tmp32_;
						HierarchicalTagIndex* _tmp33_;
						const gchar* _tmp34_;
						const gchar* _tmp43_;
						_tmp24_ = _keyword_it;
						if (!gee_iterator_next (_tmp24_)) {
							break;
						}
						_tmp25_ = _keyword_it;
						_tmp26_ = gee_iterator_get (_tmp25_);
						keyword = (gchar*) _tmp26_;
						_tmp28_ = htag_index;
						if (_tmp28_ != NULL) {
							HierarchicalTagIndex* _tmp29_;
							const gchar* _tmp30_;
							_tmp29_ = htag_index;
							_tmp30_ = keyword;
							_tmp27_ = hierarchical_tag_index_is_tag_in_index (_tmp29_, _tmp30_);
						} else {
							_tmp27_ = FALSE;
						}
						if (_tmp27_) {
							_g_free0 (keyword);
							continue;
						}
						_tmp31_ = keyword;
						_tmp32_ = tag_prep_tag_name (_tmp31_);
						name = _tmp32_;
						_tmp33_ = global_index;
						_tmp34_ = name;
						if (hierarchical_tag_index_is_tag_in_index (_tmp33_, _tmp34_)) {
							gchar* most_derived_path = NULL;
							HierarchicalTagIndex* _tmp35_;
							const gchar* _tmp36_;
							gchar* _tmp37_;
							GeeHashMultiMap* _tmp38_;
							const gchar* _tmp39_;
							Tag* _tmp40_;
							Tag* _tmp41_;
							LibraryPhoto* _tmp42_;
							_tmp35_ = global_index;
							_tmp36_ = name;
							_tmp37_ = hierarchical_tag_index_get_path_for_name (_tmp35_, _tmp36_);
							most_derived_path = _tmp37_;
							_tmp38_ = map;
							_tmp39_ = most_derived_path;
							_tmp40_ = tag_for_path (_tmp39_);
							_tmp41_ = _tmp40_;
							_tmp42_ = photo;
							gee_multi_map_set ((GeeMultiMap*) _tmp38_, _tmp41_, _tmp42_);
							_g_object_unref0 (_tmp41_);
							_g_free0 (most_derived_path);
							_g_free0 (name);
							_g_free0 (keyword);
							continue;
						}
						_tmp43_ = name;
						if (_tmp43_ != NULL) {
							GeeHashMultiMap* _tmp44_;
							const gchar* _tmp45_;
							Tag* _tmp46_;
							Tag* _tmp47_;
							LibraryPhoto* _tmp48_;
							_tmp44_ = map;
							_tmp45_ = name;
							_tmp46_ = tag_for_path (_tmp45_);
							_tmp47_ = _tmp46_;
							_tmp48_ = photo;
							gee_multi_map_set ((GeeMultiMap*) _tmp44_, _tmp47_, _tmp48_);
							_g_object_unref0 (_tmp47_);
						}
						_g_free0 (name);
						_g_free0 (keyword);
					}
					_g_object_unref0 (_keyword_it);
				}
			}
			_tmp49_ = metadata;
			if (photo_metadata_has_hierarchical_keywords (_tmp49_)) {
				{
					GeeIterator* _path_it = NULL;
					HierarchicalTagIndex* _tmp50_;
					GeeCollection* _tmp51_;
					GeeCollection* _tmp52_;
					GeeIterator* _tmp53_;
					GeeIterator* _tmp54_;
					_tmp50_ = htag_index;
					_tmp51_ = hierarchical_tag_index_get_all_paths (_tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = gee_iterable_iterator ((GeeIterable*) _tmp52_);
					_tmp54_ = _tmp53_;
					_g_object_unref0 (_tmp52_);
					_path_it = _tmp54_;
					while (TRUE) {
						GeeIterator* _tmp55_;
						gchar* path = NULL;
						GeeIterator* _tmp56_;
						gpointer _tmp57_;
						gchar* name = NULL;
						const gchar* _tmp58_;
						gchar* _tmp59_;
						const gchar* _tmp60_;
						_tmp55_ = _path_it;
						if (!gee_iterator_next (_tmp55_)) {
							break;
						}
						_tmp56_ = _path_it;
						_tmp57_ = gee_iterator_get (_tmp56_);
						path = (gchar*) _tmp57_;
						_tmp58_ = path;
						_tmp59_ = tag_prep_tag_name (_tmp58_);
						name = _tmp59_;
						_tmp60_ = name;
						if (_tmp60_ != NULL) {
							GeeHashMultiMap* _tmp61_;
							const gchar* _tmp62_;
							Tag* _tmp63_;
							Tag* _tmp64_;
							LibraryPhoto* _tmp65_;
							_tmp61_ = map;
							_tmp62_ = name;
							_tmp63_ = tag_for_path (_tmp62_);
							_tmp64_ = _tmp63_;
							_tmp65_ = photo;
							gee_multi_map_set ((GeeMultiMap*) _tmp61_, _tmp64_, _tmp65_);
							_g_object_unref0 (_tmp64_);
						}
						_g_free0 (name);
						_g_free0 (path);
					}
					_g_object_unref0 (_path_it);
				}
			}
			_hierarchical_tag_index_unref0 (htag_index);
			_hierarchical_tag_index_unref0 (global_index);
			_media_metadata_unref0 (metadata);
			_g_object_unref0 (photo);
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
	{
		GeeIterator* _media_it = NULL;
		GeeIterator* _tmp66_;
		_tmp66_ = gee_iterable_iterator ((GeeIterable*) media_sources);
		_media_it = _tmp66_;
		while (TRUE) {
			GeeIterator* _tmp67_;
			MediaSource* media = NULL;
			GeeIterator* _tmp68_;
			gpointer _tmp69_;
			LibraryPhoto* photo = NULL;
			MediaSource* _tmp70_;
			LibraryPhoto* _tmp71_;
			LibraryPhoto* _tmp72_;
			_tmp67_ = _media_it;
			if (!gee_iterator_next (_tmp67_)) {
				break;
			}
			_tmp68_ = _media_it;
			_tmp69_ = gee_iterator_get (_tmp68_);
			media = (MediaSource*) _tmp69_;
			_tmp70_ = media;
			_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
			photo = _tmp71_;
			_tmp72_ = photo;
			library_photo_clear_import_keywords (_tmp72_);
			_g_object_unref0 (photo);
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
	{
		GeeIterator* _tag_it = NULL;
		GeeHashMultiMap* _tmp73_;
		GeeSet* _tmp74_;
		GeeSet* _tmp75_;
		GeeIterator* _tmp76_;
		GeeIterator* _tmp77_;
		_tmp73_ = map;
		_tmp74_ = gee_multi_map_get_keys ((GeeMultiMap*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = gee_iterable_iterator ((GeeIterable*) _tmp75_);
		_tmp77_ = _tmp76_;
		_g_object_unref0 (_tmp75_);
		_tag_it = _tmp77_;
		while (TRUE) {
			GeeIterator* _tmp78_;
			Tag* tag = NULL;
			GeeIterator* _tmp79_;
			gpointer _tmp80_;
			Tag* _tmp81_;
			GeeHashMultiMap* _tmp82_;
			Tag* _tmp83_;
			GeeCollection* _tmp84_;
			GeeCollection* _tmp85_;
			_tmp78_ = _tag_it;
			if (!gee_iterator_next (_tmp78_)) {
				break;
			}
			_tmp79_ = _tag_it;
			_tmp80_ = gee_iterator_get (_tmp79_);
			tag = (Tag*) _tmp80_;
			_tmp81_ = tag;
			_tmp82_ = map;
			_tmp83_ = tag;
			_tmp84_ = gee_multi_map_get ((GeeMultiMap*) _tmp82_, _tmp83_);
			_tmp85_ = _tmp84_;
			tag_attach_many (_tmp81_, _tmp85_);
			_g_object_unref0 (_tmp85_);
			_g_object_unref0 (tag);
		}
		_g_object_unref0 (_tag_it);
	}
	MEDIA_SOURCE_COLLECTION_CLASS (library_photo_source_collection_parent_class)->postprocess_imported_media (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), media_sources);
	_g_object_unref0 (map);
}

static void
library_photo_source_collection_real_notify_master_reimported (LibraryPhotoSourceCollection* self,
                                                               LibraryPhoto* photo,
                                                               PhotoMetadata* metadata)
{
	g_return_if_fail (photo != NULL);
	g_signal_emit (self, library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_MASTER_REIMPORTED_SIGNAL], 0, photo, metadata);
}

void
library_photo_source_collection_notify_master_reimported (LibraryPhotoSourceCollection* self,
                                                          LibraryPhoto* photo,
                                                          PhotoMetadata* metadata)
{
	LibraryPhotoSourceCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_master_reimported) {
		_klass_->notify_master_reimported (self, photo, metadata);
	}
}

static void
library_photo_source_collection_real_notify_editable_reimported (LibraryPhotoSourceCollection* self,
                                                                 LibraryPhoto* photo,
                                                                 PhotoMetadata* metadata)
{
	g_return_if_fail (photo != NULL);
	g_signal_emit (self, library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_EDITABLE_REIMPORTED_SIGNAL], 0, photo, metadata);
}

void
library_photo_source_collection_notify_editable_reimported (LibraryPhotoSourceCollection* self,
                                                            LibraryPhoto* photo,
                                                            PhotoMetadata* metadata)
{
	LibraryPhotoSourceCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_editable_reimported) {
		_klass_->notify_editable_reimported (self, photo, metadata);
	}
}

static void
library_photo_source_collection_real_notify_source_reimported (LibraryPhotoSourceCollection* self,
                                                               LibraryPhoto* photo,
                                                               PhotoMetadata* metadata)
{
	g_return_if_fail (photo != NULL);
	g_signal_emit (self, library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_SOURCE_REIMPORTED_SIGNAL], 0, photo, metadata);
}

void
library_photo_source_collection_notify_source_reimported (LibraryPhotoSourceCollection* self,
                                                          LibraryPhoto* photo,
                                                          PhotoMetadata* metadata)
{
	LibraryPhotoSourceCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_source_reimported) {
		_klass_->notify_source_reimported (self, photo, metadata);
	}
}

static void
library_photo_source_collection_real_notify_baseline_reimported (LibraryPhotoSourceCollection* self,
                                                                 LibraryPhoto* photo,
                                                                 PhotoMetadata* metadata)
{
	g_return_if_fail (photo != NULL);
	g_signal_emit (self, library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_BASELINE_REIMPORTED_SIGNAL], 0, photo, metadata);
}

void
library_photo_source_collection_notify_baseline_reimported (LibraryPhotoSourceCollection* self,
                                                            LibraryPhoto* photo,
                                                            PhotoMetadata* metadata)
{
	LibraryPhotoSourceCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_baseline_reimported) {
		_klass_->notify_baseline_reimported (self, photo, metadata);
	}
}

static MediaSource*
library_photo_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base,
                                                          gint64 numeric_id)
{
	LibraryPhotoSourceCollection * self;
	PhotoID _tmp0_ = {0};
	LibraryPhoto* _tmp1_;
	MediaSource* result;
	self = (LibraryPhotoSourceCollection*) base;
	photo_id_init (&_tmp0_, numeric_id);
	_tmp1_ = library_photo_source_collection_fetch (self, &_tmp0_);
	result = (MediaSource*) _tmp1_;
	return result;
}

static void
library_photo_source_collection_on_trashcan_contents_altered (LibraryPhotoSourceCollection* self,
                                                              GeeCollection* added,
                                                              GeeCollection* removed)
{
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((MediaSourceCollection*) self, "trashcan-contents-altered", G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_COLLECTION, GeeCollection));
}

static gboolean
library_photo_source_collection_check_if_trashed_photo (LibraryPhotoSourceCollection* self,
                                                        DataSource* source,
                                                        Alteration* alteration)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (alteration != NULL, FALSE);
	result = media_source_is_trashed ((MediaSource*) G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto));
	return result;
}

static void
library_photo_source_collection_on_offline_contents_altered (LibraryPhotoSourceCollection* self,
                                                             GeeCollection* added,
                                                             GeeCollection* removed)
{
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((MediaSourceCollection*) self, "offline-contents-altered", G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_COLLECTION, GeeCollection));
}

static gboolean
library_photo_source_collection_check_if_offline_photo (LibraryPhotoSourceCollection* self,
                                                        DataSource* source,
                                                        Alteration* alteration)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (alteration != NULL, FALSE);
	result = media_source_is_offline ((MediaSource*) G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto));
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static MediaSource*
library_photo_source_collection_real_fetch_by_source_id (MediaSourceCollection* base,
                                                         const gchar* source_id)
{
	LibraryPhotoSourceCollection * self;
	gchar* numeric_only = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	MediaSource* _tmp3_;
	MediaSource* result;
	self = (LibraryPhotoSourceCollection*) base;
	g_return_val_if_fail (source_id != NULL, NULL);
	_vala_assert (g_str_has_prefix (source_id, PHOTO_TYPENAME), "source_id.has_prefix (Photo.TYPENAME)");
	_tmp0_ = strlen (PHOTO_TYPENAME);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_substring (source_id, (glong) _tmp1_, (glong) -1);
	numeric_only = _tmp2_;
	_tmp3_ = media_source_collection_fetch_by_numeric_id ((MediaSourceCollection*) self, parse_int64 (numeric_only, 16));
	result = _tmp3_;
	_g_free0 (numeric_only);
	return result;
}

static GeeCollection*
library_photo_source_collection_real_get_event_source_ids (MediaSourceCollection* base,
                                                           EventID* event_id)
{
	LibraryPhotoSourceCollection * self;
	PhotoTable* _tmp0_;
	PhotoTable* _tmp1_;
	EventID _tmp2_;
	GeeArrayList* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* result;
	self = (LibraryPhotoSourceCollection*) base;
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = photo_table_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = *event_id;
	_tmp3_ = photo_table_get_event_source_ids (_tmp1_, &_tmp2_);
	_tmp4_ = (GeeCollection*) _tmp3_;
	_database_table_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

LibraryPhoto*
library_photo_source_collection_fetch (LibraryPhotoSourceCollection* self,
                                       PhotoID* photo_id)
{
	PhotoID _tmp0_;
	DataSource* _tmp1_;
	LibraryPhoto* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (photo_id != NULL, NULL);
	_tmp0_ = *photo_id;
	_tmp1_ = database_source_collection_fetch_by_key ((DatabaseSourceCollection*) self, _tmp0_.id);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	return result;
}

LibraryPhoto*
library_photo_source_collection_fetch_by_editable_file (LibraryPhotoSourceCollection* self,
                                                        GFile* file)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	LibraryPhoto* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = self->priv->by_editable_file;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, file);
	result = (LibraryPhoto*) _tmp1_;
	return result;
}

LibraryPhoto*
library_photo_source_collection_fetch_by_raw_development_file (LibraryPhotoSourceCollection* self,
                                                               GFile* file)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	LibraryPhoto* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = self->priv->by_raw_development_file;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, file);
	result = (LibraryPhoto*) _tmp1_;
	return result;
}

static void
library_photo_source_collection_compare_backing (LibraryPhotoSourceCollection* self,
                                                 LibraryPhoto* photo,
                                                 GFileInfo* info,
                                                 GeeCollection* matches_master,
                                                 GeeCollection* matches_editable,
                                                 GeeCollection* matches_development)
{
	BackingPhotoRow* _tmp0_;
	BackingPhotoRow* _tmp1_;
	gboolean _tmp2_;
	BackingPhotoRow* editable = NULL;
	BackingPhotoRow* _tmp3_;
	gboolean _tmp4_ = FALSE;
	BackingPhotoRow* _tmp5_;
	GeeCollection* development = NULL;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (matches_master != NULL);
	g_return_if_fail (matches_editable != NULL);
	g_return_if_fail (matches_development != NULL);
	_tmp0_ = photo_get_master_photo_row ((Photo*) photo);
	_tmp1_ = _tmp0_;
	_tmp2_ = backing_photo_row_matches_file_info (_tmp1_, info);
	_backing_photo_row_unref0 (_tmp1_);
	if (_tmp2_) {
		gee_collection_add (matches_master, photo);
	}
	_tmp3_ = photo_get_editable_photo_row ((Photo*) photo);
	editable = _tmp3_;
	_tmp5_ = editable;
	if (_tmp5_ != NULL) {
		BackingPhotoRow* _tmp6_;
		_tmp6_ = editable;
		_tmp4_ = backing_photo_row_matches_file_info (_tmp6_, info);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gee_collection_add (matches_editable, photo);
	}
	_tmp7_ = photo_get_raw_development_photo_rows ((Photo*) photo);
	development = _tmp7_;
	_tmp8_ = development;
	if (_tmp8_ != NULL) {
		{
			GeeIterator* _row_it = NULL;
			GeeCollection* _tmp9_;
			GeeIterator* _tmp10_;
			_tmp9_ = development;
			_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
			_row_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_;
				BackingPhotoRow* row = NULL;
				GeeIterator* _tmp12_;
				gpointer _tmp13_;
				BackingPhotoRow* _tmp14_;
				_tmp11_ = _row_it;
				if (!gee_iterator_next (_tmp11_)) {
					break;
				}
				_tmp12_ = _row_it;
				_tmp13_ = gee_iterator_get (_tmp12_);
				row = (BackingPhotoRow*) _tmp13_;
				_tmp14_ = row;
				if (backing_photo_row_matches_file_info (_tmp14_, info)) {
					gee_collection_add (matches_development, photo);
					_backing_photo_row_unref0 (row);
					break;
				}
				_backing_photo_row_unref0 (row);
			}
			_g_object_unref0 (_row_it);
		}
	}
	_g_object_unref0 (development);
	_backing_photo_row_unref0 (editable);
}

void
library_photo_source_collection_fetch_by_matching_backing (LibraryPhotoSourceCollection* self,
                                                           GFileInfo* info,
                                                           GeeCollection* matches_master,
                                                           GeeCollection* matches_editable,
                                                           GeeCollection* matched_development)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (matches_master != NULL);
	g_return_if_fail (matches_editable != NULL);
	g_return_if_fail (matched_development != NULL);
	{
		GeeIterator* _photo_it = NULL;
		GeeMultiMap* _tmp0_;
		gint64 _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->filesize_to_photo;
		_tmp1_ = g_file_info_get_size (info);
		_tmp2_ = gee_multi_map_get (_tmp0_, &_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_photo_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			LibraryPhoto* photo = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			LibraryPhoto* _tmp9_;
			_tmp6_ = _photo_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _photo_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			photo = (LibraryPhoto*) _tmp8_;
			_tmp9_ = photo;
			library_photo_source_collection_compare_backing (self, _tmp9_, info, matches_master, matches_editable, matched_development);
			_g_object_unref0 (photo);
		}
		_g_object_unref0 (_photo_it);
	}
	{
		GeeIterator* _media_it = NULL;
		GeeCollection* _tmp10_;
		GeeCollection* _tmp11_;
		GeeIterator* _tmp12_;
		GeeIterator* _tmp13_;
		_tmp10_ = media_source_collection_get_offline_bin_contents ((MediaSourceCollection*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_media_it = _tmp13_;
		while (TRUE) {
			GeeIterator* _tmp14_;
			MediaSource* media = NULL;
			GeeIterator* _tmp15_;
			gpointer _tmp16_;
			MediaSource* _tmp17_;
			_tmp14_ = _media_it;
			if (!gee_iterator_next (_tmp14_)) {
				break;
			}
			_tmp15_ = _media_it;
			_tmp16_ = gee_iterator_get (_tmp15_);
			media = (MediaSource*) _tmp16_;
			_tmp17_ = media;
			library_photo_source_collection_compare_backing (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_LIBRARY_PHOTO, LibraryPhoto), info, matches_master, matches_editable, matched_development);
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
}

void
library_photo_source_collection_get_basename_filesize_duplicate (LibraryPhotoSourceCollection* self,
                                                                 const gchar* basename,
                                                                 gint64 filesize,
                                                                 PhotoID* result)
{
	PhotoID _tmp16_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (basename != NULL);
	{
		GeeIterator* _photo_it = NULL;
		GeeMultiMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = self->priv->filesize_to_photo;
		_tmp1_ = gee_multi_map_get (_tmp0_, &filesize);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_photo_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			LibraryPhoto* photo = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			LibraryPhoto* _tmp8_;
			GFile* _tmp9_;
			GFile* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _photo_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _photo_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			photo = (LibraryPhoto*) _tmp7_;
			_tmp8_ = photo;
			_tmp9_ = media_source_get_master_file ((MediaSource*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_file_get_basename (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = utf8_ci_compare (_tmp12_, basename) == 0;
			_g_free0 (_tmp12_);
			_g_object_unref0 (_tmp10_);
			if (_tmp13_) {
				LibraryPhoto* _tmp14_;
				PhotoID _tmp15_ = {0};
				_tmp14_ = photo;
				photo_get_photo_id ((Photo*) _tmp14_, &_tmp15_);
				*result = _tmp15_;
				_g_object_unref0 (photo);
				_g_object_unref0 (_photo_it);
				return;
			}
			_g_object_unref0 (photo);
		}
		_g_object_unref0 (_photo_it);
	}
	photo_id_init (&_tmp16_, PHOTO_ID_INVALID);
	*result = _tmp16_;
	return;
}

gboolean
library_photo_source_collection_has_basename_filesize_duplicate (LibraryPhotoSourceCollection* self,
                                                                 const gchar* basename,
                                                                 gint64 filesize)
{
	PhotoID _tmp0_ = {0};
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (basename != NULL, FALSE);
	library_photo_source_collection_get_basename_filesize_duplicate (self, basename, filesize, &_tmp0_);
	result = photo_id_is_valid (&_tmp0_);
	return result;
}

LibraryPhoto*
library_photo_source_collection_get_trashed_by_file (LibraryPhotoSourceCollection* self,
                                                     GFile* file)
{
	LibraryPhoto* photo = NULL;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSource* _tmp2_;
	LibraryPhoto* _tmp3_;
	LibraryPhoto* _tmp4_;
	LibraryPhoto* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = media_source_collection_get_trashcan ((MediaSourceCollection*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = media_source_holding_tank_fetch_by_master_file (_tmp1_, file);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_source_holding_tank_unref0 (_tmp1_);
	photo = _tmp3_;
	_tmp4_ = photo;
	if (_tmp4_ == NULL) {
		MediaSourceHoldingTank* _tmp5_;
		LibraryPhotoSourceHoldingTank* _tmp6_;
		LibraryPhoto* _tmp7_;
		_tmp5_ = media_source_collection_get_trashcan ((MediaSourceCollection*) self);
		_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTank);
		_tmp7_ = library_photo_source_holding_tank_fetch_by_backing_file (_tmp6_, file);
		_g_object_unref0 (photo);
		photo = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
		_source_holding_tank_unref0 (_tmp6_);
	}
	result = photo;
	return result;
}

LibraryPhoto*
library_photo_source_collection_get_trashed_by_md5 (LibraryPhotoSourceCollection* self,
                                                    const gchar* md5)
{
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSource* _tmp2_;
	LibraryPhoto* _tmp3_;
	LibraryPhoto* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (md5 != NULL, NULL);
	_tmp0_ = media_source_collection_get_trashcan ((MediaSourceCollection*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = media_source_holding_tank_fetch_by_md5 (_tmp1_, md5);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_source_holding_tank_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

LibraryPhoto*
library_photo_source_collection_get_offline_by_file (LibraryPhotoSourceCollection* self,
                                                     GFile* file)
{
	LibraryPhoto* photo = NULL;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSource* _tmp2_;
	LibraryPhoto* _tmp3_;
	LibraryPhoto* _tmp4_;
	LibraryPhoto* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = media_source_collection_get_offline_bin ((MediaSourceCollection*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = media_source_holding_tank_fetch_by_master_file (_tmp1_, file);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_source_holding_tank_unref0 (_tmp1_);
	photo = _tmp3_;
	_tmp4_ = photo;
	if (_tmp4_ == NULL) {
		MediaSourceHoldingTank* _tmp5_;
		LibraryPhotoSourceHoldingTank* _tmp6_;
		LibraryPhoto* _tmp7_;
		_tmp5_ = media_source_collection_get_offline_bin ((MediaSourceCollection*) self);
		_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTank);
		_tmp7_ = library_photo_source_holding_tank_fetch_by_backing_file (_tmp6_, file);
		_g_object_unref0 (photo);
		photo = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
		_source_holding_tank_unref0 (_tmp6_);
	}
	result = photo;
	return result;
}

LibraryPhoto*
library_photo_source_collection_get_offline_by_md5 (LibraryPhotoSourceCollection* self,
                                                    const gchar* md5)
{
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSource* _tmp2_;
	LibraryPhoto* _tmp3_;
	LibraryPhoto* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (md5 != NULL, NULL);
	_tmp0_ = media_source_collection_get_offline_bin ((MediaSourceCollection*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = media_source_holding_tank_fetch_by_md5 (_tmp1_, md5);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_source_holding_tank_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gint
library_photo_source_collection_get_offline_count (LibraryPhotoSourceCollection* self)
{
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = media_source_collection_get_offline_bin ((MediaSourceCollection*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = source_holding_tank_get_count ((SourceHoldingTank*) _tmp1_);
	_source_holding_tank_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

LibraryPhoto*
library_photo_source_collection_get_state_by_file (LibraryPhotoSourceCollection* self,
                                                   GFile* file,
                                                   LibraryPhotoSourceCollectionState* state)
{
	LibraryPhotoSourceCollectionState _vala_state = 0;
	LibraryPhoto* photo = NULL;
	MediaSource* _tmp0_;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	LibraryPhoto* _tmp3_;
	LibraryPhoto* _tmp4_;
	LibraryPhoto* _tmp5_;
	LibraryPhoto* _tmp6_;
	LibraryPhoto* _tmp7_;
	LibraryPhoto* _tmp8_;
	LibraryPhoto* _tmp9_;
	LibraryPhoto* _tmp10_;
	LibraryPhoto* _tmp11_;
	LibraryPhoto* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = media_source_collection_fetch_by_master_file ((MediaSourceCollection*) self, file);
	photo = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_tmp1_ = photo;
	if (_tmp1_ != NULL) {
		_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE;
		result = photo;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_tmp2_ = library_photo_source_collection_fetch_by_editable_file (self, file);
	_g_object_unref0 (photo);
	photo = _tmp2_;
	_tmp3_ = photo;
	if (_tmp3_ != NULL) {
		_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE;
		result = photo;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_tmp4_ = library_photo_source_collection_fetch_by_raw_development_file (self, file);
	_g_object_unref0 (photo);
	photo = _tmp4_;
	_tmp5_ = photo;
	if (_tmp5_ != NULL) {
		_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER;
		result = photo;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_tmp6_ = library_photo_source_collection_get_trashed_by_file (self, file);
	_tmp7_ = IS_LIBRARY_PHOTO (_tmp6_) ? ((LibraryPhoto*) _tmp6_) : NULL;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (_tmp6_);
	}
	_g_object_unref0 (photo);
	photo = _tmp7_;
	_tmp8_ = photo;
	if (_tmp8_ != NULL) {
		_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH;
		result = photo;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_tmp9_ = library_photo_source_collection_get_offline_by_file (self, file);
	_tmp10_ = IS_LIBRARY_PHOTO (_tmp9_) ? ((LibraryPhoto*) _tmp9_) : NULL;
	if (_tmp10_ == NULL) {
		_g_object_unref0 (_tmp9_);
	}
	_g_object_unref0 (photo);
	photo = _tmp10_;
	_tmp11_ = photo;
	if (_tmp11_ != NULL) {
		_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE;
		result = photo;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_UNKNOWN;
	result = NULL;
	_g_object_unref0 (photo);
	if (state) {
		*state = _vala_state;
	}
	return result;
}

static gboolean
library_photo_source_collection_real_has_backlink (SourceCollection* base,
                                                   SourceBacklink* backlink)
{
	LibraryPhotoSourceCollection * self;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	gboolean _tmp2_;
	MediaSourceHoldingTank* _tmp3_;
	MediaSourceHoldingTank* _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	self = (LibraryPhotoSourceCollection*) base;
	g_return_val_if_fail (backlink != NULL, FALSE);
	if (SOURCE_COLLECTION_CLASS (library_photo_source_collection_parent_class)->has_backlink ((SourceCollection*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), backlink)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = media_source_collection_get_trashcan ((MediaSourceCollection*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = source_holding_tank_has_backlink ((SourceHoldingTank*) _tmp1_, backlink);
	_source_holding_tank_unref0 (_tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = media_source_collection_get_offline_bin ((MediaSourceCollection*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = source_holding_tank_has_backlink ((SourceHoldingTank*) _tmp4_, backlink);
	_source_holding_tank_unref0 (_tmp4_);
	if (_tmp5_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
library_photo_source_collection_real_remove_backlink (SourceCollection* base,
                                                      SourceBacklink* backlink)
{
	LibraryPhotoSourceCollection * self;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSourceHoldingTank* _tmp2_;
	MediaSourceHoldingTank* _tmp3_;
	self = (LibraryPhotoSourceCollection*) base;
	g_return_if_fail (backlink != NULL);
	_tmp0_ = media_source_collection_get_trashcan ((MediaSourceCollection*) self);
	_tmp1_ = _tmp0_;
	source_holding_tank_remove_backlink ((SourceHoldingTank*) _tmp1_, backlink);
	_source_holding_tank_unref0 (_tmp1_);
	_tmp2_ = media_source_collection_get_offline_bin ((MediaSourceCollection*) self);
	_tmp3_ = _tmp2_;
	source_holding_tank_remove_backlink ((SourceHoldingTank*) _tmp3_, backlink);
	_source_holding_tank_unref0 (_tmp3_);
	SOURCE_COLLECTION_CLASS (library_photo_source_collection_parent_class)->remove_backlink ((SourceCollection*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), backlink);
}

static TransactionController*
library_photo_source_collection_real_get_transaction_controller (MediaSourceCollection* base)
{
	TransactionController* result;
	LibraryPhotoSourceCollection* self;
	TransactionController* _tmp0_;
	TransactionController* _tmp2_;
	self = (LibraryPhotoSourceCollection*) base;
	_tmp0_ = self->priv->_transaction_controller;
	if (_tmp0_ == NULL) {
		MediaSourceTransactionController* _tmp1_;
		_tmp1_ = media_source_transaction_controller_new ((MediaSourceCollection*) self);
		_transaction_controller_unref0 (self->priv->_transaction_controller);
		self->priv->_transaction_controller = (TransactionController*) _tmp1_;
	}
	_tmp2_ = self->priv->_transaction_controller;
	result = _tmp2_;
	return result;
}

static void
library_photo_source_collection_real_master_reimported (LibraryPhotoSourceCollection* self,
                                                        LibraryPhoto* photo,
                                                        PhotoMetadata* metadata)
{
	g_return_if_fail (photo != NULL);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_MEDIA_METADATA (GClosure * closure,
                                                     GValue * return_value,
                                                     guint n_param_values,
                                                     const GValue * param_values,
                                                     gpointer invocation_hint,
                                                     gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_MEDIA_METADATA) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_MEDIA_METADATA callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_MEDIA_METADATA) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), value_get_media_metadata (param_values + 2), data2);
}

static void
library_photo_source_collection_real_editable_reimported (LibraryPhotoSourceCollection* self,
                                                          LibraryPhoto* photo,
                                                          PhotoMetadata* metadata)
{
	g_return_if_fail (photo != NULL);
}

static void
library_photo_source_collection_real_baseline_reimported (LibraryPhotoSourceCollection* self,
                                                          LibraryPhoto* photo,
                                                          PhotoMetadata* metadata)
{
	g_return_if_fail (photo != NULL);
}

static void
library_photo_source_collection_real_source_reimported (LibraryPhotoSourceCollection* self,
                                                        LibraryPhoto* photo,
                                                        PhotoMetadata* metadata)
{
	g_return_if_fail (photo != NULL);
}

static void
library_photo_source_collection_class_init (LibraryPhotoSourceCollectionClass * klass,
                                            gpointer klass_data)
{
	library_photo_source_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = library_photo_source_collection_finalize;
	g_type_class_adjust_private_offset (klass, &LibraryPhotoSourceCollection_private_offset);
	((MediaSourceCollectionClass *) klass)->create_trashcan = (MediaSourceHoldingTank* (*) (MediaSourceCollection*)) library_photo_source_collection_real_create_trashcan;
	((MediaSourceCollectionClass *) klass)->create_offline_bin = (MediaSourceHoldingTank* (*) (MediaSourceCollection*)) library_photo_source_collection_real_create_offline_bin;
	((MediaSourceCollectionClass *) klass)->create_media_monitor = (MediaMonitor* (*) (MediaSourceCollection*, Workers*, GCancellable*)) library_photo_source_collection_real_create_media_monitor;
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection*, DataSource*)) library_photo_source_collection_real_holds_type_of_source;
	((MediaSourceCollectionClass *) klass)->get_typename = (gchar* (*) (MediaSourceCollection*)) library_photo_source_collection_real_get_typename;
	((MediaSourceCollectionClass *) klass)->is_file_recognized = (gboolean (*) (MediaSourceCollection*, GFile*)) library_photo_source_collection_real_is_file_recognized;
	((DataCollectionClass *) klass)->notify_contents_altered = (void (*) (DataCollection*, GeeIterable*, GeeIterable*)) library_photo_source_collection_real_notify_contents_altered;
	((DataCollectionClass *) klass)->items_altered = (void (*) (DataCollection*, GeeMap*)) library_photo_source_collection_real_items_altered;
	((MediaSourceCollectionClass *) klass)->postprocess_imported_media = (void (*) (MediaSourceCollection*, GeeCollection*)) library_photo_source_collection_real_postprocess_imported_media;
	((LibraryPhotoSourceCollectionClass *) klass)->notify_master_reimported = (void (*) (LibraryPhotoSourceCollection*, LibraryPhoto*, PhotoMetadata*)) library_photo_source_collection_real_notify_master_reimported;
	((LibraryPhotoSourceCollectionClass *) klass)->notify_editable_reimported = (void (*) (LibraryPhotoSourceCollection*, LibraryPhoto*, PhotoMetadata*)) library_photo_source_collection_real_notify_editable_reimported;
	((LibraryPhotoSourceCollectionClass *) klass)->notify_source_reimported = (void (*) (LibraryPhotoSourceCollection*, LibraryPhoto*, PhotoMetadata*)) library_photo_source_collection_real_notify_source_reimported;
	((LibraryPhotoSourceCollectionClass *) klass)->notify_baseline_reimported = (void (*) (LibraryPhotoSourceCollection*, LibraryPhoto*, PhotoMetadata*)) library_photo_source_collection_real_notify_baseline_reimported;
	((MediaSourceCollectionClass *) klass)->fetch_by_numeric_id = (MediaSource* (*) (MediaSourceCollection*, gint64)) library_photo_source_collection_real_fetch_by_numeric_id;
	((MediaSourceCollectionClass *) klass)->fetch_by_source_id = (MediaSource* (*) (MediaSourceCollection*, const gchar*)) library_photo_source_collection_real_fetch_by_source_id;
	((MediaSourceCollectionClass *) klass)->get_event_source_ids = (GeeCollection* (*) (MediaSourceCollection*, EventID*)) library_photo_source_collection_real_get_event_source_ids;
	((SourceCollectionClass *) klass)->has_backlink = (gboolean (*) (SourceCollection*, SourceBacklink*)) library_photo_source_collection_real_has_backlink;
	((SourceCollectionClass *) klass)->remove_backlink = (void (*) (SourceCollection*, SourceBacklink*)) library_photo_source_collection_real_remove_backlink;
	((LibraryPhotoSourceCollectionClass *) klass)->master_reimported = library_photo_source_collection_real_master_reimported;
	((LibraryPhotoSourceCollectionClass *) klass)->editable_reimported = library_photo_source_collection_real_editable_reimported;
	((LibraryPhotoSourceCollectionClass *) klass)->baseline_reimported = library_photo_source_collection_real_baseline_reimported;
	((LibraryPhotoSourceCollectionClass *) klass)->source_reimported = library_photo_source_collection_real_source_reimported;
	MEDIA_SOURCE_COLLECTION_CLASS (klass)->get_transaction_controller = (TransactionController* (*) (MediaSourceCollection*)) library_photo_source_collection_real_get_transaction_controller;
	library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_MASTER_REIMPORTED_SIGNAL] = g_signal_new ("master-reimported", TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibraryPhotoSourceCollectionClass, master_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_MEDIA_METADATA, G_TYPE_NONE, 2, TYPE_LIBRARY_PHOTO, TYPE_PHOTO_METADATA);
	library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_EDITABLE_REIMPORTED_SIGNAL] = g_signal_new ("editable-reimported", TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibraryPhotoSourceCollectionClass, editable_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_MEDIA_METADATA, G_TYPE_NONE, 2, TYPE_LIBRARY_PHOTO, TYPE_PHOTO_METADATA);
	library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_BASELINE_REIMPORTED_SIGNAL] = g_signal_new ("baseline-reimported", TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibraryPhotoSourceCollectionClass, baseline_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_MEDIA_METADATA, G_TYPE_NONE, 2, TYPE_LIBRARY_PHOTO, TYPE_PHOTO_METADATA);
	library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_SOURCE_REIMPORTED_SIGNAL] = g_signal_new ("source-reimported", TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibraryPhotoSourceCollectionClass, source_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_MEDIA_METADATA, G_TYPE_NONE, 2, TYPE_LIBRARY_PHOTO, TYPE_PHOTO_METADATA);
}

static void
library_photo_source_collection_instance_init (LibraryPhotoSourceCollection * self,
                                               gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeTreeMultiMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeTreeMultiMap* _tmp5_;
	self->priv = library_photo_source_collection_get_instance_private (self);
	self->priv->_transaction_controller = NULL;
	_tmp0_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->by_editable_file = _tmp0_;
	_tmp1_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->by_raw_development_file = _tmp1_;
	_tmp2_ = gee_tree_multi_map_new (G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _int64_compare_gcompare_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->filesize_to_photo = (GeeMultiMap*) _tmp2_;
	_tmp3_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, _int64_equal_gee_equal_data_func, NULL, NULL);
	self->priv->photo_to_master_filesize = _tmp3_;
	_tmp4_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, _int64_equal_gee_equal_data_func, NULL, NULL);
	self->priv->photo_to_editable_filesize = _tmp4_;
	_tmp5_ = gee_tree_multi_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->photo_to_raw_development_filesize = (GeeMultiMap*) _tmp5_;
}

static void
library_photo_source_collection_finalize (DataCollection * obj)
{
	LibraryPhotoSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	_transaction_controller_unref0 (self->priv->_transaction_controller);
	_g_object_unref0 (self->priv->by_editable_file);
	_g_object_unref0 (self->priv->by_raw_development_file);
	_g_object_unref0 (self->priv->filesize_to_photo);
	_g_object_unref0 (self->priv->photo_to_master_filesize);
	_g_object_unref0 (self->priv->photo_to_editable_filesize);
	_g_object_unref0 (self->priv->photo_to_raw_development_filesize);
	DATA_COLLECTION_CLASS (library_photo_source_collection_parent_class)->finalize (obj);
}

static GType
library_photo_source_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibraryPhotoSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_photo_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryPhotoSourceCollection), 0, (GInstanceInitFunc) library_photo_source_collection_instance_init, NULL };
	GType library_photo_source_collection_type_id;
	library_photo_source_collection_type_id = g_type_register_static (TYPE_MEDIA_SOURCE_COLLECTION, "LibraryPhotoSourceCollection", &g_define_type_info, 0);
	LibraryPhotoSourceCollection_private_offset = g_type_add_instance_private (library_photo_source_collection_type_id, sizeof (LibraryPhotoSourceCollectionPrivate));
	return library_photo_source_collection_type_id;
}

GType
library_photo_source_collection_get_type (void)
{
	static volatile gsize library_photo_source_collection_type_id__once = 0;
	if (g_once_init_enter (&library_photo_source_collection_type_id__once)) {
		GType library_photo_source_collection_type_id;
		library_photo_source_collection_type_id = library_photo_source_collection_get_type_once ();
		g_once_init_leave (&library_photo_source_collection_type_id__once, library_photo_source_collection_type_id);
	}
	return library_photo_source_collection_type_id__once;
}

static inline gpointer
library_photo_get_instance_private (LibraryPhoto* self)
{
	return G_STRUCT_MEMBER_P (self, LibraryPhoto_private_offset);
}

static void
_library_photo_generate_thumbnails_one_shot_callback (gpointer self)
{
	library_photo_generate_thumbnails ((LibraryPhoto*) self);
}

static LibraryPhoto*
library_photo_construct (GType object_type,
                         PhotoRow* row)
{
	LibraryPhoto * self = NULL;
	OneShotScheduler* _tmp0_;
	g_return_val_if_fail (row != NULL, NULL);
	self = (LibraryPhoto*) photo_construct (object_type, row);
	_g_object_unref0 (self->priv->import_keywords);
	self->priv->import_keywords = NULL;
	_tmp0_ = one_shot_scheduler_new ("LibraryPhoto", _library_photo_generate_thumbnails_one_shot_callback, self);
	_one_shot_scheduler_unref0 (self->priv->thumbnail_scheduler);
	self->priv->thumbnail_scheduler = _tmp0_;
	if ((row->flags & (LIBRARY_PHOTO_FLAG_TRASH | LIBRARY_PHOTO_FLAG_OFFLINE)) != ((guint64) 0)) {
		LibraryPhotoSourceCollection* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = library_photo_global;
		_tmp2_ = row->backlinks;
		data_source_rehydrate_backlinks ((DataSource*) self, (SourceCollection*) _tmp1_, _tmp2_);
	}
	return self;
}

static LibraryPhoto*
library_photo_new (PhotoRow* row)
{
	return library_photo_construct (TYPE_LIBRARY_PHOTO, row);
}

static LibraryPhoto*
library_photo_construct_from_import_params (GType object_type,
                                            PhotoImportParams* import_params)
{
	LibraryPhoto * self = NULL;
	PhotoRow* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	OneShotScheduler* _tmp3_;
	PhotoRow* _tmp4_;
	g_return_val_if_fail (import_params != NULL, NULL);
	_tmp0_ = import_params->row;
	self = (LibraryPhoto*) photo_construct (object_type, _tmp0_);
	_tmp1_ = import_params->keywords;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->import_keywords);
	self->priv->import_keywords = _tmp2_;
	_tmp3_ = one_shot_scheduler_new ("LibraryPhoto", _library_photo_generate_thumbnails_one_shot_callback, self);
	_one_shot_scheduler_unref0 (self->priv->thumbnail_scheduler);
	self->priv->thumbnail_scheduler = _tmp3_;
	_tmp4_ = import_params->row;
	if ((_tmp4_->flags & (LIBRARY_PHOTO_FLAG_TRASH | LIBRARY_PHOTO_FLAG_OFFLINE)) != ((guint64) 0)) {
		LibraryPhotoSourceCollection* _tmp5_;
		PhotoRow* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = library_photo_global;
		_tmp6_ = import_params->row;
		_tmp7_ = _tmp6_->backlinks;
		data_source_rehydrate_backlinks ((DataSource*) self, (SourceCollection*) _tmp5_, _tmp7_);
	}
	return self;
}

static LibraryPhoto*
library_photo_new_from_import_params (PhotoImportParams* import_params)
{
	return library_photo_construct_from_import_params (TYPE_LIBRARY_PHOTO, import_params);
}

void
library_photo_init (ProgressMonitor monitor,
                    gpointer monitor_target)
{
	LibraryPhotoSourceCollection* _tmp0_;
	GeeArrayList* all = NULL;
	PhotoTable* _tmp1_;
	PhotoTable* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* all_photos = NULL;
	GeeArrayList* _tmp5_;
	GeeArrayList* trashed_photos = NULL;
	GeeArrayList* _tmp6_;
	GeeArrayList* offline_photos = NULL;
	GeeArrayList* _tmp7_;
	gint count = 0;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	LibraryPhotoSourceCollection* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeCollection* _tmp26_;
	GeeCollection* _tmp27_;
	LibraryPhotoSourceCollection* _tmp28_;
	GeeArrayList* _tmp29_;
	LibraryPhotoSourceCollection* _tmp30_;
	GeeArrayList* _tmp31_;
	_tmp0_ = library_photo_source_collection_new ();
	_data_collection_unref0 (library_photo_global);
	library_photo_global = _tmp0_;
	_tmp1_ = photo_table_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = photo_table_get_all (_tmp2_);
	_tmp4_ = _tmp3_;
	_database_table_unref0 (_tmp2_);
	all = _tmp4_;
	_tmp5_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	all_photos = _tmp5_;
	_tmp6_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	trashed_photos = _tmp6_;
	_tmp7_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	offline_photos = _tmp7_;
	_tmp8_ = all;
	_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	count = _tmp10_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				PhotoRow* row = NULL;
				GeeArrayList* _tmp13_;
				gpointer _tmp14_;
				LibraryPhoto* photo = NULL;
				PhotoRow* _tmp15_;
				LibraryPhoto* _tmp16_;
				guint64 flags = 0ULL;
				PhotoRow* _tmp17_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = ctr;
					ctr = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp13_ = all;
				_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, ctr);
				row = (PhotoRow*) _tmp14_;
				_tmp15_ = row;
				_tmp16_ = library_photo_new (_tmp15_);
				photo = _tmp16_;
				_tmp17_ = row;
				flags = _tmp17_->flags;
				if ((flags & LIBRARY_PHOTO_FLAG_TRASH) != ((guint64) 0)) {
					GeeArrayList* _tmp18_;
					LibraryPhoto* _tmp19_;
					_tmp18_ = trashed_photos;
					_tmp19_ = photo;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
				} else {
					if ((flags & LIBRARY_PHOTO_FLAG_OFFLINE) != ((guint64) 0)) {
						GeeArrayList* _tmp20_;
						LibraryPhoto* _tmp21_;
						_tmp20_ = offline_photos;
						_tmp21_ = photo;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
					} else {
						GeeArrayList* _tmp22_;
						LibraryPhoto* _tmp23_;
						_tmp22_ = all_photos;
						_tmp23_ = photo;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
					}
				}
				if (monitor != NULL) {
					monitor ((guint64) ctr, (guint64) count, TRUE, monitor_target);
				}
				_g_object_unref0 (photo);
				_photo_row_unref0 (row);
			}
		}
	}
	_tmp24_ = library_photo_global;
	_tmp25_ = all_photos;
	_tmp26_ = data_collection_add_many ((DataCollection*) _tmp24_, (GeeCollection*) _tmp25_, NULL, NULL);
	_tmp27_ = _tmp26_;
	_g_object_unref0 (_tmp27_);
	_tmp28_ = library_photo_global;
	_tmp29_ = trashed_photos;
	media_source_collection_add_many_to_trash ((MediaSourceCollection*) _tmp28_, (GeeCollection*) _tmp29_);
	_tmp30_ = library_photo_global;
	_tmp31_ = offline_photos;
	media_source_collection_add_many_to_offline ((MediaSourceCollection*) _tmp30_, (GeeCollection*) _tmp31_);
	_g_object_unref0 (offline_photos);
	_g_object_unref0 (trashed_photos);
	_g_object_unref0 (all_photos);
	_g_object_unref0 (all);
}

void
library_photo_terminate (void)
{
}

ImportResult
library_photo_import_create (PhotoImportParams* params,
                             LibraryPhoto** photo)
{
	LibraryPhoto* _vala_photo = NULL;
	PhotoID photo_id = {0};
	PhotoTable* _tmp0_;
	PhotoTable* _tmp1_;
	PhotoRow* _tmp2_;
	PhotoID _tmp3_ = {0};
	PhotoID _tmp4_;
	LibraryPhoto* _tmp5_;
	ImportResult result;
	g_return_val_if_fail (params != NULL, 0);
	_tmp0_ = photo_table_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = params->row;
	photo_table_add (_tmp1_, _tmp2_, &_tmp3_);
	_tmp4_ = _tmp3_;
	_database_table_unref0 (_tmp1_);
	photo_id = _tmp4_;
	if (photo_id_is_invalid (&photo_id)) {
		_g_object_unref0 (_vala_photo);
		_vala_photo = NULL;
		result = IMPORT_RESULT_DATABASE_ERROR;
		if (photo) {
			*photo = _vala_photo;
		} else {
			_g_object_unref0 (_vala_photo);
		}
		return result;
	}
	_tmp5_ = library_photo_new_from_import_params (params);
	_g_object_unref0 (_vala_photo);
	_vala_photo = _tmp5_;
	result = IMPORT_RESULT_SUCCESS;
	if (photo) {
		*photo = _vala_photo;
	} else {
		_g_object_unref0 (_vala_photo);
	}
	return result;
}

void
library_photo_import_failed (LibraryPhoto* photo)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (photo != NULL);
	{
		PhotoTable* _tmp0_;
		PhotoTable* _tmp1_;
		PhotoID _tmp2_ = {0};
		_tmp0_ = photo_table_get_instance ();
		_tmp1_ = _tmp0_;
		photo_get_photo_id ((Photo*) photo, &_tmp2_);
		photo_table_remove (_tmp1_, &_tmp2_, &_inner_error0_);
		_database_table_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		app_window_database_error (_tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
library_photo_real_notify_master_reimported (Photo* base,
                                             PhotoMetadata* metadata)
{
	LibraryPhoto * self;
	LibraryPhotoSourceCollection* _tmp0_;
	self = (LibraryPhoto*) base;
	PHOTO_CLASS (library_photo_parent_class)->notify_master_reimported (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), metadata);
	_tmp0_ = library_photo_global;
	library_photo_source_collection_notify_master_reimported (_tmp0_, self, metadata);
}

static void
library_photo_real_notify_editable_reimported (Photo* base,
                                               PhotoMetadata* metadata)
{
	LibraryPhoto * self;
	LibraryPhotoSourceCollection* _tmp0_;
	self = (LibraryPhoto*) base;
	PHOTO_CLASS (library_photo_parent_class)->notify_editable_reimported (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), metadata);
	_tmp0_ = library_photo_global;
	library_photo_source_collection_notify_editable_reimported (_tmp0_, self, metadata);
}

static void
library_photo_real_notify_source_reimported (Photo* base,
                                             PhotoMetadata* metadata)
{
	LibraryPhoto * self;
	LibraryPhotoSourceCollection* _tmp0_;
	self = (LibraryPhoto*) base;
	PHOTO_CLASS (library_photo_parent_class)->notify_source_reimported (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), metadata);
	_tmp0_ = library_photo_global;
	library_photo_source_collection_notify_source_reimported (_tmp0_, self, metadata);
}

static void
library_photo_real_notify_baseline_reimported (Photo* base,
                                               PhotoMetadata* metadata)
{
	LibraryPhoto * self;
	LibraryPhotoSourceCollection* _tmp0_;
	self = (LibraryPhoto*) base;
	PHOTO_CLASS (library_photo_parent_class)->notify_baseline_reimported (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), metadata);
	_tmp0_ = library_photo_global;
	library_photo_source_collection_notify_baseline_reimported (_tmp0_, self, metadata);
}

static void
library_photo_generate_thumbnails (LibraryPhoto* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		thumbnail_cache_import_from_source ((ThumbnailSource*) self, TRUE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = data_object_to_string ((DataObject*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_warning ("Photo.vala:5178: Unable to generate thumbnails for %s: %s", _tmp1_, _tmp3_);
		_g_free0 (_tmp1_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	thumbnail_source_notify_thumbnail_altered ((ThumbnailSource*) self);
}

GeeCollection*
library_photo_get_import_keywords (LibraryPhoto* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->import_keywords;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
library_photo_clear_import_keywords (LibraryPhoto* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->import_keywords);
	self->priv->import_keywords = NULL;
}

static void
library_photo_real_notify_altered (DataObject* base,
                                   Alteration* alteration)
{
	LibraryPhoto * self;
	gboolean _tmp0_ = FALSE;
	self = (LibraryPhoto*) base;
	g_return_if_fail (alteration != NULL);
	if (!self->priv->block_thumbnail_generation) {
		_tmp0_ = alteration_has_subject (alteration, "image");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		OneShotScheduler* _tmp1_;
		_tmp1_ = self->priv->thumbnail_scheduler;
		one_shot_scheduler_at_priority_idle (_tmp1_, G_PRIORITY_LOW);
	}
	DATA_OBJECT_CLASS (library_photo_parent_class)->notify_altered ((DataObject*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), alteration);
}

static GdkPixbuf*
library_photo_real_get_preview_pixbuf (MediaSource* base,
                                       Scaling* scaling,
                                       GError** error)
{
	LibraryPhoto * self;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (LibraryPhoto*) base;
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp0_ = thumbnail_source_get_thumbnail ((ThumbnailSource*) self, (gint) THUMBNAIL_CACHE_SIZE_BIG, &_inner_error0_);
	pixbuf = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = scaling_perform_on_pixbuf (scaling, pixbuf, GDK_INTERP_BILINEAR, TRUE);
	result = _tmp1_;
	_g_object_unref0 (pixbuf);
	return result;
}

static void
library_photo_real_rotate (Photo* base,
                           Rotation rotation)
{
	LibraryPhoto * self;
	GError* _inner_error0_ = NULL;
	self = (LibraryPhoto*) base;
	self->priv->block_thumbnail_generation = TRUE;
	PHOTO_CLASS (library_photo_parent_class)->rotate (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), rotation);
	self->priv->block_thumbnail_generation = FALSE;
	{
		thumbnail_cache_rotate ((ThumbnailSource*) self, rotation, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = data_object_to_string ((DataObject*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_warning ("Photo.vala:5223: Unable to update thumbnails for %s: %s", _tmp1_, _tmp3_);
		_g_free0 (_tmp1_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	thumbnail_source_notify_thumbnail_altered ((ThumbnailSource*) self);
}

static GdkPixbuf*
library_photo_real_get_thumbnail (ThumbnailSource* base,
                                  gint scale,
                                  GError** error)
{
	LibraryPhoto * self;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (LibraryPhoto*) base;
	_tmp1_ = thumbnail_cache_fetch ((ThumbnailSource*) self, scale, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static void
_library_photo_on_duplicate_progress_gfile_progress_callback (gint64 current_num_bytes,
                                                              gint64 total_num_bytes,
                                                              gpointer self)
{
	library_photo_on_duplicate_progress ((LibraryPhoto*) self, current_num_bytes, total_num_bytes);
}

static void
library_photo_duplicate_backing_photo (LibraryPhoto* self,
                                       BackingPhotoRow* backing,
                                       BackingPhotoID* result,
                                       GError** error)
{
	BackingPhotoID backing_id = {0};
	gboolean _tmp0_ = FALSE;
	GFile* file = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	backing_photo_id_init (&backing_id, BACKING_PHOTO_ID_INVALID);
	if (backing == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = backing->filepath;
		_tmp0_ = _tmp1_ == NULL;
	}
	if (_tmp0_) {
		*result = backing_id;
		return;
	}
	_tmp2_ = backing->filepath;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	file = _tmp3_;
	_tmp4_ = file;
	if (g_file_query_exists (_tmp4_, NULL)) {
		GFile* dupe_file = NULL;
		GFile* _tmp5_;
		GFile* _tmp6_;
		DetectedPhotoInformation* detected = NULL;
		BackingPhotoRow* state = NULL;
		GFile* _tmp7_;
		DetectedPhotoInformation* _tmp8_ = NULL;
		BackingPhotoRow* _tmp9_;
		BackingPhotoRow* _tmp10_;
		_tmp5_ = file;
		_tmp6_ = library_files_duplicate (_tmp5_, _library_photo_on_duplicate_progress_gfile_progress_callback, self, TRUE, &_inner_error0_);
		dupe_file = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (file);
			return;
		}
		_tmp7_ = dupe_file;
		_tmp9_ = photo_query_backing_photo_row ((Photo*) self, _tmp7_, PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5, &_tmp8_, &_inner_error0_);
		_detected_photo_information_unref0 (detected);
		detected = _tmp8_;
		state = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_detected_photo_information_unref0 (detected);
			_g_object_unref0 (dupe_file);
			_g_object_unref0 (file);
			return;
		}
		_tmp10_ = state;
		if (_tmp10_ != NULL) {
			BackingPhotoTable* _tmp11_;
			BackingPhotoTable* _tmp12_;
			BackingPhotoRow* _tmp13_;
			BackingPhotoRow* _tmp14_;
			BackingPhotoID _tmp15_;
			_tmp11_ = backing_photo_table_get_instance ();
			_tmp12_ = _tmp11_;
			_tmp13_ = state;
			backing_photo_table_add (_tmp12_, _tmp13_, &_inner_error0_);
			_database_table_unref0 (_tmp12_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_backing_photo_row_unref0 (state);
				_detected_photo_information_unref0 (detected);
				_g_object_unref0 (dupe_file);
				_g_object_unref0 (file);
				return;
			}
			_tmp14_ = state;
			_tmp15_ = _tmp14_->id;
			backing_id = _tmp15_;
		}
		_backing_photo_row_unref0 (state);
		_detected_photo_information_unref0 (detected);
		_g_object_unref0 (dupe_file);
	}
	*result = backing_id;
	_g_object_unref0 (file);
	return;
}

LibraryPhoto*
library_photo_duplicate (LibraryPhoto* self,
                         GError** error)
{
	GFile* dupe_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	BackingPhotoID dupe_editable_id = {0};
	BackingPhotoRow* _tmp4_;
	BackingPhotoRow* _tmp5_;
	BackingPhotoID _tmp6_ = {0};
	BackingPhotoID _tmp7_;
	BackingPhotoID dupe_raw_shotwell_id = {0};
	BackingPhotoRow* _tmp8_;
	BackingPhotoRow* _tmp9_;
	BackingPhotoID _tmp10_ = {0};
	BackingPhotoID _tmp11_;
	BackingPhotoID dupe_raw_camera_id = {0};
	BackingPhotoRow* _tmp12_;
	BackingPhotoRow* _tmp13_;
	BackingPhotoID _tmp14_ = {0};
	BackingPhotoID _tmp15_;
	BackingPhotoID dupe_raw_embedded_id = {0};
	BackingPhotoRow* _tmp16_;
	BackingPhotoRow* _tmp17_;
	BackingPhotoID _tmp18_ = {0};
	BackingPhotoID _tmp19_;
	PhotoID dupe_id = {0};
	PhotoTable* _tmp20_;
	PhotoTable* _tmp21_;
	PhotoID _tmp22_ = {0};
	GFile* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	BackingPhotoID _tmp26_;
	BackingPhotoID _tmp27_;
	BackingPhotoID _tmp28_;
	BackingPhotoID _tmp29_;
	PhotoID _tmp30_ = {0};
	PhotoID _tmp31_;
	PhotoRow* dupe_row = NULL;
	PhotoTable* _tmp32_;
	PhotoTable* _tmp33_;
	PhotoID _tmp34_;
	PhotoRow* _tmp35_;
	PhotoRow* _tmp36_;
	LibraryPhoto* dupe = NULL;
	PhotoRow* _tmp37_;
	LibraryPhoto* _tmp38_;
	LibraryPhoto* _tmp39_;
	LibraryPhotoSourceCollection* _tmp40_;
	LibraryPhoto* _tmp41_;
	LibraryPhoto* _tmp42_;
	Event* _tmp43_;
	Event* _tmp44_;
	gboolean _tmp45_;
	GeeCollection* tags = NULL;
	TagSourceCollection* _tmp50_;
	GeeList* _tmp51_;
	GeeCollection* _tmp52_;
	GError* _inner_error0_ = NULL;
	LibraryPhoto* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = media_source_get_master_file ((MediaSource*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = library_files_duplicate (_tmp1_, _library_photo_on_duplicate_progress_gfile_progress_callback, self, TRUE, &_inner_error0_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	dupe_file = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = photo_get_editable_photo_row ((Photo*) self);
	_tmp5_ = _tmp4_;
	library_photo_duplicate_backing_photo (self, _tmp5_, &_tmp6_, &_inner_error0_);
	_tmp7_ = _tmp6_;
	_backing_photo_row_unref0 (_tmp5_);
	dupe_editable_id = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dupe_file);
		return NULL;
	}
	_tmp8_ = photo_get_raw_development_photo_row ((Photo*) self, RAW_DEVELOPER_SHOTWELL);
	_tmp9_ = _tmp8_;
	library_photo_duplicate_backing_photo (self, _tmp9_, &_tmp10_, &_inner_error0_);
	_tmp11_ = _tmp10_;
	_backing_photo_row_unref0 (_tmp9_);
	dupe_raw_shotwell_id = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dupe_file);
		return NULL;
	}
	_tmp12_ = photo_get_raw_development_photo_row ((Photo*) self, RAW_DEVELOPER_CAMERA);
	_tmp13_ = _tmp12_;
	library_photo_duplicate_backing_photo (self, _tmp13_, &_tmp14_, &_inner_error0_);
	_tmp15_ = _tmp14_;
	_backing_photo_row_unref0 (_tmp13_);
	dupe_raw_camera_id = _tmp15_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dupe_file);
		return NULL;
	}
	_tmp16_ = photo_get_raw_development_photo_row ((Photo*) self, RAW_DEVELOPER_EMBEDDED);
	_tmp17_ = _tmp16_;
	library_photo_duplicate_backing_photo (self, _tmp17_, &_tmp18_, &_inner_error0_);
	_tmp19_ = _tmp18_;
	_backing_photo_row_unref0 (_tmp17_);
	dupe_raw_embedded_id = _tmp19_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dupe_file);
		return NULL;
	}
	_tmp20_ = photo_table_get_instance ();
	_tmp21_ = _tmp20_;
	photo_get_photo_id ((Photo*) self, &_tmp22_);
	_tmp23_ = dupe_file;
	_tmp24_ = g_file_get_path (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = dupe_editable_id;
	_tmp27_ = dupe_raw_shotwell_id;
	_tmp28_ = dupe_raw_camera_id;
	_tmp29_ = dupe_raw_embedded_id;
	photo_table_duplicate (_tmp21_, &_tmp22_, _tmp25_, &_tmp26_, &_tmp27_, &_tmp28_, &_tmp29_, &_tmp30_);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp25_);
	_database_table_unref0 (_tmp21_);
	dupe_id = _tmp31_;
	_tmp32_ = photo_table_get_instance ();
	_tmp33_ = _tmp32_;
	_tmp34_ = dupe_id;
	_tmp35_ = photo_table_get_row (_tmp33_, &_tmp34_);
	_tmp36_ = _tmp35_;
	_database_table_unref0 (_tmp33_);
	dupe_row = _tmp36_;
	_tmp37_ = dupe_row;
	_tmp38_ = library_photo_new (_tmp37_);
	dupe = _tmp38_;
	_tmp39_ = dupe;
	thumbnail_cache_duplicate ((ThumbnailSource*) self, (ThumbnailSource*) _tmp39_);
	_tmp40_ = library_photo_global;
	_tmp41_ = dupe;
	data_collection_add ((DataCollection*) _tmp40_, (DataObject*) _tmp41_);
	_tmp42_ = dupe;
	_tmp43_ = media_source_get_event ((MediaSource*) _tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = _tmp44_ != NULL;
	_g_object_unref0 (_tmp44_);
	if (_tmp45_) {
		LibraryPhoto* _tmp46_;
		Event* _tmp47_;
		Event* _tmp48_;
		LibraryPhoto* _tmp49_;
		_tmp46_ = dupe;
		_tmp47_ = media_source_get_event ((MediaSource*) _tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = dupe;
		event_attach (_tmp48_, (MediaSource*) _tmp49_);
		_g_object_unref0 (_tmp48_);
	}
	_tmp50_ = tag_global;
	_tmp51_ = tag_source_collection_fetch_for_source (_tmp50_, (MediaSource*) self);
	tags = (GeeCollection*) _tmp51_;
	_tmp52_ = tags;
	if (_tmp52_ != NULL) {
		{
			GeeIterator* _tag_it = NULL;
			GeeCollection* _tmp53_;
			GeeIterator* _tmp54_;
			_tmp53_ = tags;
			_tmp54_ = gee_iterable_iterator ((GeeIterable*) _tmp53_);
			_tag_it = _tmp54_;
			while (TRUE) {
				GeeIterator* _tmp55_;
				Tag* tag = NULL;
				GeeIterator* _tmp56_;
				gpointer _tmp57_;
				Tag* _tmp58_;
				LibraryPhoto* _tmp59_;
				_tmp55_ = _tag_it;
				if (!gee_iterator_next (_tmp55_)) {
					break;
				}
				_tmp56_ = _tag_it;
				_tmp57_ = gee_iterator_get (_tmp56_);
				tag = (Tag*) _tmp57_;
				_tmp58_ = tag;
				_tmp59_ = dupe;
				tag_attach (_tmp58_, (MediaSource*) _tmp59_);
				_g_object_unref0 (tag);
			}
			_g_object_unref0 (_tag_it);
		}
	}
	result = dupe;
	_g_object_unref0 (tags);
	_photo_row_unref0 (dupe_row);
	_g_object_unref0 (dupe_file);
	return result;
}

static void
library_photo_on_duplicate_progress (LibraryPhoto* self,
                                     gint64 current,
                                     gint64 total)
{
	g_return_if_fail (self != NULL);
	spin_event_loop ();
}

static gboolean
library_photo_real_is_trashed (MediaSource* base)
{
	LibraryPhoto * self;
	gboolean result;
	self = (LibraryPhoto*) base;
	result = photo_is_flag_set ((Photo*) self, LIBRARY_PHOTO_FLAG_TRASH);
	return result;
}

static void
library_photo_real_trash (MediaSource* base)
{
	LibraryPhoto * self;
	self = (LibraryPhoto*) base;
	photo_add_flags ((Photo*) self, LIBRARY_PHOTO_FLAG_TRASH, NULL);
}

static void
library_photo_real_untrash (MediaSource* base)
{
	LibraryPhoto * self;
	self = (LibraryPhoto*) base;
	photo_remove_flags ((Photo*) self, LIBRARY_PHOTO_FLAG_TRASH, NULL);
}

static gboolean
library_photo_real_is_offline (Monitorable* base)
{
	LibraryPhoto * self;
	gboolean result;
	self = (LibraryPhoto*) base;
	result = photo_is_flag_set ((Photo*) self, LIBRARY_PHOTO_FLAG_OFFLINE);
	return result;
}

static void
library_photo_real_mark_offline (Monitorable* base)
{
	LibraryPhoto * self;
	self = (LibraryPhoto*) base;
	photo_add_flags ((Photo*) self, LIBRARY_PHOTO_FLAG_OFFLINE, NULL);
}

static void
library_photo_real_mark_online (Monitorable* base)
{
	LibraryPhoto * self;
	self = (LibraryPhoto*) base;
	photo_remove_flags ((Photo*) self, LIBRARY_PHOTO_FLAG_OFFLINE, NULL);
}

static gboolean
library_photo_real_is_flagged (Flaggable* base)
{
	LibraryPhoto * self;
	gboolean result;
	self = (LibraryPhoto*) base;
	result = photo_is_flag_set ((Photo*) self, LIBRARY_PHOTO_FLAG_FLAGGED);
	return result;
}

static void
library_photo_real_mark_flagged (Flaggable* base)
{
	LibraryPhoto * self;
	Alteration* _tmp0_;
	Alteration* _tmp1_;
	self = (LibraryPhoto*) base;
	_tmp0_ = alteration_new ("metadata", "flagged");
	_tmp1_ = _tmp0_;
	photo_add_flags ((Photo*) self, LIBRARY_PHOTO_FLAG_FLAGGED, _tmp1_);
	_alteration_unref0 (_tmp1_);
}

static void
library_photo_real_mark_unflagged (Flaggable* base)
{
	LibraryPhoto * self;
	Alteration* _tmp0_;
	Alteration* _tmp1_;
	self = (LibraryPhoto*) base;
	_tmp0_ = alteration_new ("metadata", "flagged");
	_tmp1_ = _tmp0_;
	photo_remove_flags ((Photo*) self, LIBRARY_PHOTO_FLAG_FLAGGED, _tmp1_);
	_alteration_unref0 (_tmp1_);
}

static gboolean
library_photo_real_internal_delete_backing (DataSource* base,
                                            GError** error)
{
	LibraryPhoto * self;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (LibraryPhoto*) base;
	_tmp0_ = DATA_SOURCE_CLASS (library_photo_parent_class)->internal_delete_backing ((DataSource*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	result = media_source_delete_original_file ((MediaSource*) self);
	return result;
}

static void
library_photo_real_destroy (DataSource* base)
{
	LibraryPhoto * self;
	PhotoID photo_id = {0};
	PhotoID _tmp0_ = {0};
	GError* _inner_error0_ = NULL;
	self = (LibraryPhoto*) base;
	photo_get_photo_id ((Photo*) self, &_tmp0_);
	photo_id = _tmp0_;
	thumbnail_cache_remove ((ThumbnailSource*) self);
	{
		PhotoTable* _tmp1_;
		PhotoTable* _tmp2_;
		PhotoID _tmp3_;
		_tmp1_ = photo_table_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = photo_id;
		photo_table_remove (_tmp2_, &_tmp3_, &_inner_error0_);
		_database_table_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		app_window_database_error (_tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	DATA_SOURCE_CLASS (library_photo_parent_class)->destroy ((DataSource*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo));
}

gboolean
library_photo_has_nontrash_duplicate (GFile* file,
                                      const gchar* thumbnail_md5,
                                      const gchar* full_md5,
                                      PhotoFileFormat file_format)
{
	PhotoID _tmp0_ = {0};
	gboolean result;
	library_photo_get_nontrash_duplicate (file, thumbnail_md5, full_md5, file_format, &_tmp0_);
	result = photo_id_is_valid (&_tmp0_);
	return result;
}

void
library_photo_get_nontrash_duplicate (GFile* file,
                                      const gchar* thumbnail_md5,
                                      const gchar* full_md5,
                                      PhotoFileFormat file_format,
                                      PhotoID* result)
{
	PhotoID* ids = NULL;
	gint _tmp0_ = 0;
	PhotoID* _tmp1_;
	gint ids_length1;
	gint _ids_size_;
	gboolean _tmp2_ = FALSE;
	PhotoID* _tmp3_;
	gint _tmp3__length1;
	PhotoID* _tmp6_;
	gint _tmp6__length1;
	PhotoID _tmp13_ = {0};
	_tmp1_ = photo_get_duplicate_ids (file, thumbnail_md5, full_md5, file_format, &_tmp0_);
	ids = _tmp1_;
	ids_length1 = _tmp0_;
	_ids_size_ = ids_length1;
	_tmp3_ = ids;
	_tmp3__length1 = ids_length1;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		PhotoID* _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = ids;
		_tmp4__length1 = ids_length1;
		_tmp2_ = _tmp4__length1 == 0;
	}
	if (_tmp2_) {
		PhotoID _tmp5_ = {0};
		photo_id_init (&_tmp5_, PHOTO_ID_INVALID);
		*result = _tmp5_;
		ids = (g_free (ids), NULL);
		return;
	}
	_tmp6_ = ids;
	_tmp6__length1 = ids_length1;
	{
		PhotoID* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp6_;
		id_collection_length1 = _tmp6__length1;
		for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
			PhotoID id = {0};
			id = id_collection[id_it];
			{
				LibraryPhoto* photo = NULL;
				LibraryPhotoSourceCollection* _tmp7_;
				PhotoID _tmp8_;
				LibraryPhoto* _tmp9_;
				gboolean _tmp10_ = FALSE;
				LibraryPhoto* _tmp11_;
				_tmp7_ = library_photo_global;
				_tmp8_ = id;
				_tmp9_ = library_photo_source_collection_fetch (_tmp7_, &_tmp8_);
				photo = _tmp9_;
				_tmp11_ = photo;
				if (_tmp11_ != NULL) {
					LibraryPhoto* _tmp12_;
					_tmp12_ = photo;
					_tmp10_ = !media_source_is_trashed ((MediaSource*) _tmp12_);
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					*result = id;
					_g_object_unref0 (photo);
					ids = (g_free (ids), NULL);
					return;
				}
				_g_object_unref0 (photo);
			}
		}
	}
	photo_id_init (&_tmp13_, PHOTO_ID_INVALID);
	*result = _tmp13_;
	ids = (g_free (ids), NULL);
	return;
}

static gboolean
library_photo_real_has_user_generated_metadata (Photo* base)
{
	LibraryPhoto * self;
	GeeList* tags = NULL;
	TagSourceCollection* _tmp0_;
	GeeList* _tmp1_;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp2_;
	PhotoMetadata* _tmp3_;
	GeeSet* keywords = NULL;
	PhotoMetadata* _tmp9_;
	GeeSet* _tmp10_;
	gint _tmp11_ = 0;
	GeeList* _tmp12_;
	gint tags_count = 0;
	gint _tmp16_ = 0;
	GeeSet* _tmp17_;
	gint keywords_count = 0;
	gboolean _tmp21_ = FALSE;
	GeeList* _tmp22_;
	gboolean result;
	self = (LibraryPhoto*) base;
	_tmp0_ = tag_global;
	_tmp1_ = tag_source_collection_fetch_for_source (_tmp0_, (MediaSource*) self);
	tags = _tmp1_;
	_tmp2_ = photo_source_get_metadata ((PhotoSource*) self);
	metadata = _tmp2_;
	_tmp3_ = metadata;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		GeeList* _tmp5_;
		_tmp5_ = tags;
		if (_tmp5_ != NULL) {
			_tmp4_ = TRUE;
		} else {
			GeeList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			_tmp6_ = tags;
			_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp4_ = _tmp8_ > 0;
		}
		result = _tmp4_;
		_media_metadata_unref0 (metadata);
		_g_object_unref0 (tags);
		return result;
	}
	_tmp9_ = metadata;
	_tmp10_ = photo_metadata_get_keywords (_tmp9_, NULL, NULL, NULL);
	keywords = _tmp10_;
	_tmp12_ = tags;
	if (_tmp12_ != NULL) {
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp13_ = tags;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_;
	} else {
		_tmp11_ = 0;
	}
	tags_count = _tmp11_;
	_tmp17_ = keywords;
	if (_tmp17_ != NULL) {
		GeeSet* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		_tmp18_ = keywords;
		_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp16_ = _tmp20_;
	} else {
		_tmp16_ = 0;
	}
	keywords_count = _tmp16_;
	if (tags_count != keywords_count) {
		result = TRUE;
		_g_object_unref0 (keywords);
		_media_metadata_unref0 (metadata);
		_g_object_unref0 (tags);
		return result;
	}
	_tmp22_ = tags;
	if (_tmp22_ != NULL) {
		GeeSet* _tmp23_;
		_tmp23_ = keywords;
		_tmp21_ = _tmp23_ != NULL;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		{
			GeeList* _tag_list = NULL;
			GeeList* _tmp24_;
			gint _tag_size = 0;
			GeeList* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint _tag_index = 0;
			_tmp24_ = tags;
			_tag_list = _tmp24_;
			_tmp25_ = _tag_list;
			_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
			_tmp27_ = _tmp26_;
			_tag_size = _tmp27_;
			_tag_index = -1;
			while (TRUE) {
				gint _tmp28_;
				gint _tmp29_;
				Tag* tag = NULL;
				GeeList* _tmp30_;
				gpointer _tmp31_;
				GeeSet* _tmp32_;
				Tag* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gboolean _tmp38_;
				_tag_index = _tag_index + 1;
				_tmp28_ = _tag_index;
				_tmp29_ = _tag_size;
				if (!(_tmp28_ < _tmp29_)) {
					break;
				}
				_tmp30_ = _tag_list;
				_tmp31_ = gee_list_get (_tmp30_, _tag_index);
				tag = (Tag*) _tmp31_;
				_tmp32_ = keywords;
				_tmp33_ = tag;
				_tmp34_ = data_object_get_name ((DataObject*) _tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_utf8_normalize (_tmp35_, (gssize) -1, G_NORMALIZE_DEFAULT);
				_tmp37_ = _tmp36_;
				_tmp38_ = !gee_collection_contains ((GeeCollection*) _tmp32_, _tmp37_);
				_g_free0 (_tmp37_);
				_g_free0 (_tmp35_);
				if (_tmp38_) {
					result = TRUE;
					_g_object_unref0 (tag);
					_g_object_unref0 (keywords);
					_media_metadata_unref0 (metadata);
					_g_object_unref0 (tags);
					return result;
				}
				_g_object_unref0 (tag);
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (keywords);
	_media_metadata_unref0 (metadata);
	_g_object_unref0 (tags);
	return result;
}

static void
library_photo_real_set_user_metadata_for_export (Photo* base,
                                                 PhotoMetadata* metadata)
{
	LibraryPhoto * self;
	GeeList* photo_tags = NULL;
	TagSourceCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	self = (LibraryPhoto*) base;
	g_return_if_fail (metadata != NULL);
	_tmp0_ = tag_global;
	_tmp1_ = tag_source_collection_fetch_for_source (_tmp0_, (MediaSource*) self);
	photo_tags = _tmp1_;
	_tmp2_ = photo_tags;
	if (_tmp2_ != NULL) {
		GeeCollection* string_tags = NULL;
		GeeArrayList* _tmp3_;
		GeeCollection* _tmp16_;
		_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		string_tags = (GeeCollection*) _tmp3_;
		{
			GeeList* _tag_list = NULL;
			GeeList* _tmp4_;
			gint _tag_size = 0;
			GeeList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _tag_index = 0;
			_tmp4_ = photo_tags;
			_tag_list = _tmp4_;
			_tmp5_ = _tag_list;
			_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tag_size = _tmp7_;
			_tag_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				Tag* tag = NULL;
				GeeList* _tmp10_;
				gpointer _tmp11_;
				GeeCollection* _tmp12_;
				Tag* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tag_index = _tag_index + 1;
				_tmp8_ = _tag_index;
				_tmp9_ = _tag_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _tag_list;
				_tmp11_ = gee_list_get (_tmp10_, _tag_index);
				tag = (Tag*) _tmp11_;
				_tmp12_ = string_tags;
				_tmp13_ = tag;
				_tmp14_ = data_object_get_name ((DataObject*) _tmp13_);
				_tmp15_ = _tmp14_;
				gee_collection_add (_tmp12_, _tmp15_);
				_g_free0 (_tmp15_);
				_g_object_unref0 (tag);
			}
		}
		_tmp16_ = string_tags;
		photo_metadata_set_keywords (metadata, _tmp16_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_g_object_unref0 (string_tags);
	} else {
		photo_metadata_set_keywords (metadata, NULL, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
	}
	_g_object_unref0 (photo_tags);
}

static void
library_photo_real_apply_user_metadata_for_reimport (Photo* base,
                                                     PhotoMetadata* metadata)
{
	LibraryPhoto * self;
	HierarchicalTagIndex* new_htag_index = NULL;
	GeeCollection* keywords = NULL;
	GeeSet* _tmp3_;
	GeeCollection* _tmp4_;
	HierarchicalTagIndex* _tmp31_;
	self = (LibraryPhoto*) base;
	g_return_if_fail (metadata != NULL);
	new_htag_index = NULL;
	if (photo_metadata_has_hierarchical_keywords (metadata)) {
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		HierarchicalTagIndex* _tmp2_;
		_tmp0_ = photo_metadata_get_hierarchical_keywords (metadata);
		_tmp1_ = _tmp0_;
		_tmp2_ = hierarchical_tag_utilities_process_hierarchical_import_keywords ((GeeCollection*) _tmp1_);
		_hierarchical_tag_index_unref0 (new_htag_index);
		new_htag_index = _tmp2_;
		_g_object_unref0 (_tmp1_);
	}
	_tmp3_ = photo_metadata_get_keywords (metadata, NULL, NULL, NULL);
	keywords = (GeeCollection*) _tmp3_;
	_tmp4_ = keywords;
	if (_tmp4_ != NULL) {
		{
			GeeIterator* _keyword_it = NULL;
			GeeCollection* _tmp5_;
			GeeIterator* _tmp6_;
			_tmp5_ = keywords;
			_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
			_keyword_it = _tmp6_;
			while (TRUE) {
				GeeIterator* _tmp7_;
				gchar* keyword = NULL;
				GeeIterator* _tmp8_;
				gpointer _tmp9_;
				gboolean _tmp10_ = FALSE;
				HierarchicalTagIndex* _tmp11_;
				gchar* safe_keyword = NULL;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* promoted_keyword = NULL;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				TagSourceCollection* _tmp18_;
				const gchar* _tmp19_;
				TagSourceCollection* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp28_;
				Tag* _tmp29_;
				Tag* _tmp30_;
				_tmp7_ = _keyword_it;
				if (!gee_iterator_next (_tmp7_)) {
					break;
				}
				_tmp8_ = _keyword_it;
				_tmp9_ = gee_iterator_get (_tmp8_);
				keyword = (gchar*) _tmp9_;
				_tmp11_ = new_htag_index;
				if (_tmp11_ != NULL) {
					HierarchicalTagIndex* _tmp12_;
					const gchar* _tmp13_;
					_tmp12_ = new_htag_index;
					_tmp13_ = keyword;
					_tmp10_ = hierarchical_tag_index_is_tag_in_index (_tmp12_, _tmp13_);
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					_g_free0 (keyword);
					continue;
				}
				_tmp14_ = keyword;
				_tmp15_ = hierarchical_tag_utilities_make_flat_tag_safe (_tmp14_);
				safe_keyword = _tmp15_;
				_tmp16_ = safe_keyword;
				_tmp17_ = hierarchical_tag_utilities_flat_to_hierarchical (_tmp16_);
				promoted_keyword = _tmp17_;
				_tmp18_ = tag_global;
				_tmp19_ = safe_keyword;
				if (tag_source_collection_exists (_tmp18_, _tmp19_, FALSE)) {
					const gchar* _tmp20_;
					Tag* _tmp21_;
					Tag* _tmp22_;
					_tmp20_ = safe_keyword;
					_tmp21_ = tag_for_path (_tmp20_);
					_tmp22_ = _tmp21_;
					tag_attach (_tmp22_, (MediaSource*) self);
					_g_object_unref0 (_tmp22_);
					_g_free0 (promoted_keyword);
					_g_free0 (safe_keyword);
					_g_free0 (keyword);
					continue;
				}
				_tmp23_ = tag_global;
				_tmp24_ = promoted_keyword;
				if (tag_source_collection_exists (_tmp23_, _tmp24_, FALSE)) {
					const gchar* _tmp25_;
					Tag* _tmp26_;
					Tag* _tmp27_;
					_tmp25_ = promoted_keyword;
					_tmp26_ = tag_for_path (_tmp25_);
					_tmp27_ = _tmp26_;
					tag_attach (_tmp27_, (MediaSource*) self);
					_g_object_unref0 (_tmp27_);
					_g_free0 (promoted_keyword);
					_g_free0 (safe_keyword);
					_g_free0 (keyword);
					continue;
				}
				_tmp28_ = keyword;
				_tmp29_ = tag_for_path (_tmp28_);
				_tmp30_ = _tmp29_;
				tag_attach (_tmp30_, (MediaSource*) self);
				_g_object_unref0 (_tmp30_);
				_g_free0 (promoted_keyword);
				_g_free0 (safe_keyword);
				_g_free0 (keyword);
			}
			_g_object_unref0 (_keyword_it);
		}
	}
	_tmp31_ = new_htag_index;
	if (_tmp31_ != NULL) {
		{
			GeeIterator* _path_it = NULL;
			HierarchicalTagIndex* _tmp32_;
			GeeCollection* _tmp33_;
			GeeCollection* _tmp34_;
			GeeIterator* _tmp35_;
			GeeIterator* _tmp36_;
			_tmp32_ = new_htag_index;
			_tmp33_ = hierarchical_tag_index_get_all_paths (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = gee_iterable_iterator ((GeeIterable*) _tmp34_);
			_tmp36_ = _tmp35_;
			_g_object_unref0 (_tmp34_);
			_path_it = _tmp36_;
			while (TRUE) {
				GeeIterator* _tmp37_;
				gchar* path = NULL;
				GeeIterator* _tmp38_;
				gpointer _tmp39_;
				const gchar* _tmp40_;
				Tag* _tmp41_;
				Tag* _tmp42_;
				_tmp37_ = _path_it;
				if (!gee_iterator_next (_tmp37_)) {
					break;
				}
				_tmp38_ = _path_it;
				_tmp39_ = gee_iterator_get (_tmp38_);
				path = (gchar*) _tmp39_;
				_tmp40_ = path;
				_tmp41_ = tag_for_path (_tmp40_);
				_tmp42_ = _tmp41_;
				tag_attach (_tmp42_, (MediaSource*) self);
				_g_object_unref0 (_tmp42_);
				_g_free0 (path);
			}
			_g_object_unref0 (_path_it);
		}
	}
	_g_object_unref0 (keywords);
	_hierarchical_tag_index_unref0 (new_htag_index);
}

static void
library_photo_class_init (LibraryPhotoClass * klass,
                          gpointer klass_data)
{
	library_photo_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &LibraryPhoto_private_offset);
	((PhotoClass *) klass)->notify_master_reimported = (void (*) (Photo*, PhotoMetadata*)) library_photo_real_notify_master_reimported;
	((PhotoClass *) klass)->notify_editable_reimported = (void (*) (Photo*, PhotoMetadata*)) library_photo_real_notify_editable_reimported;
	((PhotoClass *) klass)->notify_source_reimported = (void (*) (Photo*, PhotoMetadata*)) library_photo_real_notify_source_reimported;
	((PhotoClass *) klass)->notify_baseline_reimported = (void (*) (Photo*, PhotoMetadata*)) library_photo_real_notify_baseline_reimported;
	((DataObjectClass *) klass)->notify_altered = (void (*) (DataObject*, Alteration*)) library_photo_real_notify_altered;
	((MediaSourceClass *) klass)->get_preview_pixbuf = (GdkPixbuf* (*) (MediaSource*, Scaling*, GError**)) library_photo_real_get_preview_pixbuf;
	((PhotoClass *) klass)->rotate = (void (*) (Photo*, Rotation)) library_photo_real_rotate;
	((ThumbnailSourceClass *) klass)->get_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) library_photo_real_get_thumbnail;
	((MediaSourceClass *) klass)->is_trashed = (gboolean (*) (MediaSource*)) library_photo_real_is_trashed;
	((MediaSourceClass *) klass)->trash = (void (*) (MediaSource*)) library_photo_real_trash;
	((MediaSourceClass *) klass)->untrash = (void (*) (MediaSource*)) library_photo_real_untrash;
	((MediaSourceClass *) klass)->is_offline = (gboolean (*) (MediaSource*)) library_photo_real_is_offline;
	((MediaSourceClass *) klass)->mark_offline = (void (*) (MediaSource*)) library_photo_real_mark_offline;
	((MediaSourceClass *) klass)->mark_online = (void (*) (MediaSource*)) library_photo_real_mark_online;
	((DataSourceClass *) klass)->internal_delete_backing = (gboolean (*) (DataSource*, GError**)) library_photo_real_internal_delete_backing;
	((DataSourceClass *) klass)->destroy = (void (*) (DataSource*)) library_photo_real_destroy;
	((PhotoClass *) klass)->has_user_generated_metadata = (gboolean (*) (Photo*)) library_photo_real_has_user_generated_metadata;
	((PhotoClass *) klass)->set_user_metadata_for_export = (void (*) (Photo*, PhotoMetadata*)) library_photo_real_set_user_metadata_for_export;
	((PhotoClass *) klass)->apply_user_metadata_for_reimport = (void (*) (Photo*, PhotoMetadata*)) library_photo_real_apply_user_metadata_for_reimport;
	G_OBJECT_CLASS (klass)->finalize = library_photo_finalize;
}

static void
library_photo_flaggable_interface_init (FlaggableIface * iface,
                                        gpointer iface_data)
{
	library_photo_flaggable_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_flagged = (gboolean (*) (Flaggable*)) library_photo_real_is_flagged;
	iface->mark_flagged = (void (*) (Flaggable*)) library_photo_real_mark_flagged;
	iface->mark_unflagged = (void (*) (Flaggable*)) library_photo_real_mark_unflagged;
}

static void
library_photo_monitorable_interface_init (MonitorableIface * iface,
                                          gpointer iface_data)
{
	library_photo_monitorable_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_offline = (gboolean (*) (Monitorable*)) library_photo_real_is_offline;
	iface->mark_offline = (void (*) (Monitorable*)) library_photo_real_mark_offline;
	iface->mark_online = (void (*) (Monitorable*)) library_photo_real_mark_online;
	iface->set_master_file = (void (*) (Monitorable*, GFile*)) photo_set_master_file;
	iface->set_master_timestamp = (void (*) (Monitorable*, GFileInfo*)) photo_set_master_timestamp;
}

static void
library_photo_instance_init (LibraryPhoto * self,
                             gpointer klass)
{
	self->priv = library_photo_get_instance_private (self);
	self->priv->block_thumbnail_generation = FALSE;
	self->priv->thumbnail_scheduler = NULL;
}

static void
library_photo_finalize (GObject * obj)
{
	LibraryPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_one_shot_scheduler_unref0 (self->priv->thumbnail_scheduler);
	_g_object_unref0 (self->priv->import_keywords);
	G_OBJECT_CLASS (library_photo_parent_class)->finalize (obj);
}

static GType
library_photo_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibraryPhotoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_photo_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryPhoto), 0, (GInstanceInitFunc) library_photo_instance_init, NULL };
	static const GInterfaceInfo flaggable_info = { (GInterfaceInitFunc) library_photo_flaggable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo monitorable_info = { (GInterfaceInitFunc) library_photo_monitorable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType library_photo_type_id;
	library_photo_type_id = g_type_register_static (TYPE_PHOTO, "LibraryPhoto", &g_define_type_info, 0);
	g_type_add_interface_static (library_photo_type_id, TYPE_FLAGGABLE, &flaggable_info);
	g_type_add_interface_static (library_photo_type_id, TYPE_MONITORABLE, &monitorable_info);
	LibraryPhoto_private_offset = g_type_add_instance_private (library_photo_type_id, sizeof (LibraryPhotoPrivate));
	return library_photo_type_id;
}

GType
library_photo_get_type (void)
{
	static volatile gsize library_photo_type_id__once = 0;
	if (g_once_init_enter (&library_photo_type_id__once)) {
		GType library_photo_type_id;
		library_photo_type_id = library_photo_get_type_once ();
		g_once_init_leave (&library_photo_type_id__once, library_photo_type_id);
	}
	return library_photo_type_id__once;
}

static inline gpointer
library_photo_source_holding_tank_get_instance_private (LibraryPhotoSourceHoldingTank* self)
{
	return G_STRUCT_MEMBER_P (self, LibraryPhotoSourceHoldingTank_private_offset);
}

LibraryPhotoSourceHoldingTank*
library_photo_source_holding_tank_construct (GType object_type,
                                             LibraryPhotoSourceCollection* sources,
                                             SourceHoldingTankCheckToKeep check_to_keep,
                                             gpointer check_to_keep_target,
                                             GetSourceDatabaseKey get_key,
                                             gpointer get_key_target)
{
	LibraryPhotoSourceHoldingTank* self = NULL;
	g_return_val_if_fail (sources != NULL, NULL);
	self = (LibraryPhotoSourceHoldingTank*) media_source_holding_tank_construct (object_type, (MediaSourceCollection*) sources, check_to_keep, check_to_keep_target, get_key, get_key_target);
	return self;
}

LibraryPhotoSourceHoldingTank*
library_photo_source_holding_tank_new (LibraryPhotoSourceCollection* sources,
                                       SourceHoldingTankCheckToKeep check_to_keep,
                                       gpointer check_to_keep_target,
                                       GetSourceDatabaseKey get_key,
                                       gpointer get_key_target)
{
	return library_photo_source_holding_tank_construct (TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, sources, check_to_keep, check_to_keep_target, get_key, get_key_target);
}

LibraryPhoto*
library_photo_source_holding_tank_fetch_by_backing_file (LibraryPhotoSourceHoldingTank* self,
                                                         GFile* file)
{
	LibraryPhoto* ret = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	LibraryPhoto* _tmp2_;
	GeeHashMap* _tmp3_;
	gpointer _tmp4_;
	LibraryPhoto* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	ret = NULL;
	_tmp0_ = self->priv->editable_file_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, file);
	_g_object_unref0 (ret);
	ret = (LibraryPhoto*) _tmp1_;
	_tmp2_ = ret;
	if (_tmp2_ != NULL) {
		result = ret;
		return result;
	}
	_tmp3_ = self->priv->development_file_map;
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, file);
	result = (LibraryPhoto*) _tmp4_;
	_g_object_unref0 (ret);
	return result;
}

static void
_library_photo_source_holding_tank_on_editable_replaced_photo_editable_replaced (Photo* _sender,
                                                                                 GFile* old_file,
                                                                                 GFile* new_file,
                                                                                 gpointer self)
{
	library_photo_source_holding_tank_on_editable_replaced ((LibraryPhotoSourceHoldingTank*) self, _sender, old_file, new_file);
}

static void
_library_photo_source_holding_tank_on_raw_development_modified_photo_raw_development_modified (Photo* _sender,
                                                                                               gpointer self)
{
	library_photo_source_holding_tank_on_raw_development_modified ((LibraryPhotoSourceHoldingTank*) self, _sender);
}

static void
library_photo_source_holding_tank_real_notify_contents_altered (SourceHoldingTank* base,
                                                                GeeCollection* added,
                                                                GeeCollection* removed)
{
	LibraryPhotoSourceHoldingTank * self;
	self = (LibraryPhotoSourceHoldingTank*) base;
	if (added != NULL) {
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator ((GeeIterable*) added);
			_source_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				DataSource* source = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				LibraryPhoto* photo = NULL;
				DataSource* _tmp4_;
				LibraryPhoto* _tmp5_;
				LibraryPhoto* _tmp6_;
				GFile* _tmp7_;
				GFile* _tmp8_;
				gboolean _tmp9_;
				GeeCollection* raw_files = NULL;
				LibraryPhoto* _tmp20_;
				GeeCollection* _tmp21_;
				GeeCollection* _tmp22_;
				LibraryPhoto* _tmp34_;
				LibraryPhoto* _tmp35_;
				_tmp1_ = _source_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _source_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				source = (DataSource*) _tmp3_;
				_tmp4_ = source;
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
				photo = _tmp5_;
				_tmp6_ = photo;
				_tmp7_ = photo_get_editable_file ((Photo*) _tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = _tmp8_ != NULL;
				_g_object_unref0 (_tmp8_);
				if (_tmp9_) {
					GeeHashMap* _tmp10_;
					LibraryPhoto* _tmp11_;
					GFile* _tmp12_;
					GFile* _tmp13_;
					LibraryPhoto* _tmp14_;
					GeeMultiMap* _tmp15_;
					LibraryPhoto* _tmp16_;
					LibraryPhoto* _tmp17_;
					GFile* _tmp18_;
					GFile* _tmp19_;
					_tmp10_ = self->priv->editable_file_map;
					_tmp11_ = photo;
					_tmp12_ = photo_get_editable_file ((Photo*) _tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = photo;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, _tmp13_, _tmp14_);
					_g_object_unref0 (_tmp13_);
					_tmp15_ = self->priv->reverse_editable_file_map;
					_tmp16_ = photo;
					_tmp17_ = photo;
					_tmp18_ = photo_get_editable_file ((Photo*) _tmp17_);
					_tmp19_ = _tmp18_;
					gee_multi_map_set (_tmp15_, _tmp16_, _tmp19_);
					_g_object_unref0 (_tmp19_);
				}
				_tmp20_ = photo;
				_tmp21_ = photo_get_raw_developer_files ((Photo*) _tmp20_);
				raw_files = _tmp21_;
				_tmp22_ = raw_files;
				if (_tmp22_ != NULL) {
					{
						GeeIterator* _f_it = NULL;
						GeeCollection* _tmp23_;
						GeeIterator* _tmp24_;
						_tmp23_ = raw_files;
						_tmp24_ = gee_iterable_iterator ((GeeIterable*) _tmp23_);
						_f_it = _tmp24_;
						while (TRUE) {
							GeeIterator* _tmp25_;
							GFile* f = NULL;
							GeeIterator* _tmp26_;
							gpointer _tmp27_;
							GeeHashMap* _tmp28_;
							GFile* _tmp29_;
							LibraryPhoto* _tmp30_;
							GeeMultiMap* _tmp31_;
							LibraryPhoto* _tmp32_;
							GFile* _tmp33_;
							_tmp25_ = _f_it;
							if (!gee_iterator_next (_tmp25_)) {
								break;
							}
							_tmp26_ = _f_it;
							_tmp27_ = gee_iterator_get (_tmp26_);
							f = (GFile*) _tmp27_;
							_tmp28_ = self->priv->development_file_map;
							_tmp29_ = f;
							_tmp30_ = photo;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, _tmp29_, _tmp30_);
							_tmp31_ = self->priv->reverse_development_file_map;
							_tmp32_ = photo;
							_tmp33_ = f;
							gee_multi_map_set (_tmp31_, _tmp32_, _tmp33_);
							_g_object_unref0 (f);
						}
						_g_object_unref0 (_f_it);
					}
				}
				_tmp34_ = photo;
				g_signal_connect ((Photo*) _tmp34_, "editable-replaced", (GCallback) _library_photo_source_holding_tank_on_editable_replaced_photo_editable_replaced, self);
				_tmp35_ = photo;
				g_signal_connect ((Photo*) _tmp35_, "raw-development-modified", (GCallback) _library_photo_source_holding_tank_on_raw_development_modified_photo_raw_development_modified, self);
				_g_object_unref0 (raw_files);
				_g_object_unref0 (photo);
				_g_object_unref0 (source);
			}
			_g_object_unref0 (_source_it);
		}
	}
	if (removed != NULL) {
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp36_;
			_tmp36_ = gee_iterable_iterator ((GeeIterable*) removed);
			_source_it = _tmp36_;
			while (TRUE) {
				GeeIterator* _tmp37_;
				DataSource* source = NULL;
				GeeIterator* _tmp38_;
				gpointer _tmp39_;
				LibraryPhoto* photo = NULL;
				DataSource* _tmp40_;
				LibraryPhoto* _tmp41_;
				GeeMultiMap* _tmp64_;
				LibraryPhoto* _tmp65_;
				GeeMultiMap* _tmp66_;
				LibraryPhoto* _tmp67_;
				LibraryPhoto* _tmp68_;
				guint _tmp69_;
				LibraryPhoto* _tmp70_;
				guint _tmp71_;
				_tmp37_ = _source_it;
				if (!gee_iterator_next (_tmp37_)) {
					break;
				}
				_tmp38_ = _source_it;
				_tmp39_ = gee_iterator_get (_tmp38_);
				source = (DataSource*) _tmp39_;
				_tmp40_ = source;
				_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
				photo = _tmp41_;
				{
					GeeIterator* _f_it = NULL;
					GeeMultiMap* _tmp42_;
					LibraryPhoto* _tmp43_;
					GeeCollection* _tmp44_;
					GeeCollection* _tmp45_;
					GeeIterator* _tmp46_;
					GeeIterator* _tmp47_;
					_tmp42_ = self->priv->reverse_editable_file_map;
					_tmp43_ = photo;
					_tmp44_ = gee_multi_map_get (_tmp42_, _tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = gee_iterable_iterator ((GeeIterable*) _tmp45_);
					_tmp47_ = _tmp46_;
					_g_object_unref0 (_tmp45_);
					_f_it = _tmp47_;
					while (TRUE) {
						GeeIterator* _tmp48_;
						GFile* f = NULL;
						GeeIterator* _tmp49_;
						gpointer _tmp50_;
						GeeHashMap* _tmp51_;
						GFile* _tmp52_;
						_tmp48_ = _f_it;
						if (!gee_iterator_next (_tmp48_)) {
							break;
						}
						_tmp49_ = _f_it;
						_tmp50_ = gee_iterator_get (_tmp49_);
						f = (GFile*) _tmp50_;
						_tmp51_ = self->priv->editable_file_map;
						_tmp52_ = f;
						gee_abstract_map_unset ((GeeAbstractMap*) _tmp51_, _tmp52_, NULL);
						_g_object_unref0 (f);
					}
					_g_object_unref0 (_f_it);
				}
				{
					GeeIterator* _f_it = NULL;
					GeeMultiMap* _tmp53_;
					LibraryPhoto* _tmp54_;
					GeeCollection* _tmp55_;
					GeeCollection* _tmp56_;
					GeeIterator* _tmp57_;
					GeeIterator* _tmp58_;
					_tmp53_ = self->priv->reverse_development_file_map;
					_tmp54_ = photo;
					_tmp55_ = gee_multi_map_get (_tmp53_, _tmp54_);
					_tmp56_ = _tmp55_;
					_tmp57_ = gee_iterable_iterator ((GeeIterable*) _tmp56_);
					_tmp58_ = _tmp57_;
					_g_object_unref0 (_tmp56_);
					_f_it = _tmp58_;
					while (TRUE) {
						GeeIterator* _tmp59_;
						GFile* f = NULL;
						GeeIterator* _tmp60_;
						gpointer _tmp61_;
						GeeHashMap* _tmp62_;
						GFile* _tmp63_;
						_tmp59_ = _f_it;
						if (!gee_iterator_next (_tmp59_)) {
							break;
						}
						_tmp60_ = _f_it;
						_tmp61_ = gee_iterator_get (_tmp60_);
						f = (GFile*) _tmp61_;
						_tmp62_ = self->priv->development_file_map;
						_tmp63_ = f;
						gee_abstract_map_unset ((GeeAbstractMap*) _tmp62_, _tmp63_, NULL);
						_g_object_unref0 (f);
					}
					_g_object_unref0 (_f_it);
				}
				_tmp64_ = self->priv->reverse_editable_file_map;
				_tmp65_ = photo;
				gee_multi_map_remove_all (_tmp64_, _tmp65_);
				_tmp66_ = self->priv->reverse_development_file_map;
				_tmp67_ = photo;
				gee_multi_map_remove_all (_tmp66_, _tmp67_);
				_tmp68_ = photo;
				g_signal_parse_name ("editable-replaced", TYPE_PHOTO, &_tmp69_, NULL, FALSE);
				g_signal_handlers_disconnect_matched ((Photo*) _tmp68_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp69_, 0, NULL, (GCallback) _library_photo_source_holding_tank_on_editable_replaced_photo_editable_replaced, self);
				_tmp70_ = photo;
				g_signal_parse_name ("raw-development-modified", TYPE_PHOTO, &_tmp71_, NULL, FALSE);
				g_signal_handlers_disconnect_matched ((Photo*) _tmp70_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp71_, 0, NULL, (GCallback) _library_photo_source_holding_tank_on_raw_development_modified_photo_raw_development_modified, self);
				_g_object_unref0 (photo);
				_g_object_unref0 (source);
			}
			_g_object_unref0 (_source_it);
		}
	}
	SOURCE_HOLDING_TANK_CLASS (library_photo_source_holding_tank_parent_class)->notify_contents_altered ((SourceHoldingTank*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank), added, removed);
}

static void
library_photo_source_holding_tank_on_editable_replaced (LibraryPhotoSourceHoldingTank* self,
                                                        Photo* _photo,
                                                        GFile* old_file,
                                                        GFile* new_file)
{
	LibraryPhoto* photo = NULL;
	LibraryPhoto* _tmp0_;
	LibraryPhoto* _tmp1_;
	GeeMultiMap* _tmp7_;
	LibraryPhoto* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_photo != NULL);
	_tmp0_ = _g_object_ref0 (IS_LIBRARY_PHOTO (_photo) ? ((LibraryPhoto*) _photo) : NULL);
	photo = _tmp0_;
	_tmp1_ = photo;
	_vala_assert (_tmp1_ != NULL, "photo != null");
	if (old_file != NULL) {
		GeeHashMap* _tmp2_;
		GeeMultiMap* _tmp3_;
		LibraryPhoto* _tmp4_;
		_tmp2_ = self->priv->editable_file_map;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp2_, old_file, NULL);
		_tmp3_ = self->priv->reverse_editable_file_map;
		_tmp4_ = photo;
		gee_multi_map_remove (_tmp3_, _tmp4_, old_file);
	}
	if (new_file != NULL) {
		GeeHashMap* _tmp5_;
		LibraryPhoto* _tmp6_;
		_tmp5_ = self->priv->editable_file_map;
		_tmp6_ = photo;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, new_file, _tmp6_);
	}
	_tmp7_ = self->priv->reverse_editable_file_map;
	_tmp8_ = photo;
	gee_multi_map_set (_tmp7_, _tmp8_, new_file);
	_g_object_unref0 (photo);
}

static void
library_photo_source_holding_tank_on_raw_development_modified (LibraryPhotoSourceHoldingTank* self,
                                                               Photo* _photo)
{
	LibraryPhoto* photo = NULL;
	LibraryPhoto* _tmp0_;
	LibraryPhoto* _tmp1_;
	GeeMultiMap* _tmp2_;
	LibraryPhoto* _tmp3_;
	GeeCollection* raw_list = NULL;
	LibraryPhoto* _tmp17_;
	GeeCollection* _tmp18_;
	GeeCollection* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_photo != NULL);
	_tmp0_ = _g_object_ref0 (IS_LIBRARY_PHOTO (_photo) ? ((LibraryPhoto*) _photo) : NULL);
	photo = _tmp0_;
	_tmp1_ = photo;
	_vala_assert (_tmp1_ != NULL, "photo != null");
	_tmp2_ = self->priv->reverse_development_file_map;
	_tmp3_ = photo;
	if (gee_multi_map_contains (_tmp2_, _tmp3_)) {
		GeeMultiMap* _tmp15_;
		LibraryPhoto* _tmp16_;
		{
			GeeIterator* _f_it = NULL;
			GeeMultiMap* _tmp4_;
			LibraryPhoto* _tmp5_;
			GeeCollection* _tmp6_;
			GeeCollection* _tmp7_;
			GeeIterator* _tmp8_;
			GeeIterator* _tmp9_;
			_tmp4_ = self->priv->reverse_development_file_map;
			_tmp5_ = photo;
			_tmp6_ = gee_multi_map_get (_tmp4_, _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
			_tmp9_ = _tmp8_;
			_g_object_unref0 (_tmp7_);
			_f_it = _tmp9_;
			while (TRUE) {
				GeeIterator* _tmp10_;
				GFile* f = NULL;
				GeeIterator* _tmp11_;
				gpointer _tmp12_;
				GeeHashMap* _tmp13_;
				GFile* _tmp14_;
				_tmp10_ = _f_it;
				if (!gee_iterator_next (_tmp10_)) {
					break;
				}
				_tmp11_ = _f_it;
				_tmp12_ = gee_iterator_get (_tmp11_);
				f = (GFile*) _tmp12_;
				_tmp13_ = self->priv->development_file_map;
				_tmp14_ = f;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp13_, _tmp14_, NULL);
				_g_object_unref0 (f);
			}
			_g_object_unref0 (_f_it);
		}
		_tmp15_ = self->priv->reverse_development_file_map;
		_tmp16_ = photo;
		gee_multi_map_remove_all (_tmp15_, _tmp16_);
	}
	_tmp17_ = photo;
	_tmp18_ = photo_get_raw_developer_files ((Photo*) _tmp17_);
	raw_list = _tmp18_;
	_tmp19_ = raw_list;
	if (_tmp19_ != NULL) {
		{
			GeeIterator* _f_it = NULL;
			GeeCollection* _tmp20_;
			GeeIterator* _tmp21_;
			_tmp20_ = raw_list;
			_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
			_f_it = _tmp21_;
			while (TRUE) {
				GeeIterator* _tmp22_;
				GFile* f = NULL;
				GeeIterator* _tmp23_;
				gpointer _tmp24_;
				GeeHashMap* _tmp25_;
				GFile* _tmp26_;
				LibraryPhoto* _tmp27_;
				GeeMultiMap* _tmp28_;
				LibraryPhoto* _tmp29_;
				GFile* _tmp30_;
				_tmp22_ = _f_it;
				if (!gee_iterator_next (_tmp22_)) {
					break;
				}
				_tmp23_ = _f_it;
				_tmp24_ = gee_iterator_get (_tmp23_);
				f = (GFile*) _tmp24_;
				_tmp25_ = self->priv->development_file_map;
				_tmp26_ = f;
				_tmp27_ = photo;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, _tmp26_, _tmp27_);
				_tmp28_ = self->priv->reverse_development_file_map;
				_tmp29_ = photo;
				_tmp30_ = f;
				gee_multi_map_set (_tmp28_, _tmp29_, _tmp30_);
				_g_object_unref0 (f);
			}
			_g_object_unref0 (_f_it);
		}
	}
	_g_object_unref0 (raw_list);
	_g_object_unref0 (photo);
}

static void
library_photo_source_holding_tank_class_init (LibraryPhotoSourceHoldingTankClass * klass,
                                              gpointer klass_data)
{
	library_photo_source_holding_tank_parent_class = g_type_class_peek_parent (klass);
	((SourceHoldingTankClass *) klass)->finalize = library_photo_source_holding_tank_finalize;
	g_type_class_adjust_private_offset (klass, &LibraryPhotoSourceHoldingTank_private_offset);
	((SourceHoldingTankClass *) klass)->notify_contents_altered = (void (*) (SourceHoldingTank*, GeeCollection*, GeeCollection*)) library_photo_source_holding_tank_real_notify_contents_altered;
}

static void
library_photo_source_holding_tank_instance_init (LibraryPhotoSourceHoldingTank * self,
                                                 gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMultiMap* _tmp2_;
	GeeHashMultiMap* _tmp3_;
	self->priv = library_photo_source_holding_tank_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->editable_file_map = _tmp0_;
	_tmp1_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->development_file_map = _tmp1_;
	_tmp2_ = gee_hash_multi_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
	self->priv->reverse_editable_file_map = (GeeMultiMap*) _tmp2_;
	_tmp3_ = gee_hash_multi_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
	self->priv->reverse_development_file_map = (GeeMultiMap*) _tmp3_;
}

static void
library_photo_source_holding_tank_finalize (SourceHoldingTank * obj)
{
	LibraryPhotoSourceHoldingTank * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTank);
	_g_object_unref0 (self->priv->editable_file_map);
	_g_object_unref0 (self->priv->development_file_map);
	_g_object_unref0 (self->priv->reverse_editable_file_map);
	_g_object_unref0 (self->priv->reverse_development_file_map);
	SOURCE_HOLDING_TANK_CLASS (library_photo_source_holding_tank_parent_class)->finalize (obj);
}

static GType
library_photo_source_holding_tank_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibraryPhotoSourceHoldingTankClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_photo_source_holding_tank_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryPhotoSourceHoldingTank), 0, (GInstanceInitFunc) library_photo_source_holding_tank_instance_init, NULL };
	GType library_photo_source_holding_tank_type_id;
	library_photo_source_holding_tank_type_id = g_type_register_static (TYPE_MEDIA_SOURCE_HOLDING_TANK, "LibraryPhotoSourceHoldingTank", &g_define_type_info, 0);
	LibraryPhotoSourceHoldingTank_private_offset = g_type_add_instance_private (library_photo_source_holding_tank_type_id, sizeof (LibraryPhotoSourceHoldingTankPrivate));
	return library_photo_source_holding_tank_type_id;
}

GType
library_photo_source_holding_tank_get_type (void)
{
	static volatile gsize library_photo_source_holding_tank_type_id__once = 0;
	if (g_once_init_enter (&library_photo_source_holding_tank_type_id__once)) {
		GType library_photo_source_holding_tank_type_id;
		library_photo_source_holding_tank_type_id = library_photo_source_holding_tank_get_type_once ();
		g_once_init_leave (&library_photo_source_holding_tank_type_id__once, library_photo_source_holding_tank_type_id);
	}
	return library_photo_source_holding_tank_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

