/* KeyValueMap.c generated by valac 0.56.18, the Vala compiler
 * generated from KeyValueMap.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecKeyValueMap ParamSpecKeyValueMap;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _KeyValueMapPrivate {
	gchar* group;
	GeeHashMap* map;
};

struct _ParamSpecKeyValueMap {
	GParamSpec parent_instance;
};

static gint KeyValueMap_private_offset;
static gpointer key_value_map_parent_class = NULL;

static void key_value_map_finalize (KeyValueMap * obj);
static GType key_value_map_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
key_value_map_get_instance_private (KeyValueMap* self)
{
	return G_STRUCT_MEMBER_P (self, KeyValueMap_private_offset);
}

KeyValueMap*
key_value_map_construct (GType object_type,
                         const gchar* group)
{
	KeyValueMap* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (group != NULL, NULL);
	self = (KeyValueMap*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (group);
	_g_free0 (self->priv->group);
	self->priv->group = _tmp0_;
	return self;
}

KeyValueMap*
key_value_map_new (const gchar* group)
{
	return key_value_map_construct (TYPE_KEY_VALUE_MAP, group);
}

KeyValueMap*
key_value_map_copy (KeyValueMap* self)
{
	KeyValueMap* clone = NULL;
	const gchar* _tmp0_;
	KeyValueMap* _tmp1_;
	KeyValueMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->group;
	_tmp1_ = key_value_map_new (_tmp0_);
	clone = _tmp1_;
	{
		GeeIterator* _key_it = NULL;
		GeeHashMap* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeSet* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp2_ = self->priv->map;
		_tmp3_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_key_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			gchar* key = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			KeyValueMap* _tmp11_;
			GeeHashMap* _tmp12_;
			const gchar* _tmp13_;
			GeeHashMap* _tmp14_;
			const gchar* _tmp15_;
			gpointer _tmp16_;
			gchar* _tmp17_;
			_tmp8_ = _key_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _key_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			key = (gchar*) _tmp10_;
			_tmp11_ = clone;
			_tmp12_ = _tmp11_->priv->map;
			_tmp13_ = key;
			_tmp14_ = self->priv->map;
			_tmp15_ = key;
			_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
			_tmp17_ = (gchar*) _tmp16_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, _tmp13_, _tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_it);
	}
	result = clone;
	return result;
}

gchar*
key_value_map_get_group (KeyValueMap* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->group;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

GeeSet*
key_value_map_get_keys (KeyValueMap* self)
{
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
key_value_map_has_key (KeyValueMap* self,
                       const gchar* key)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = self->priv->map;
	result = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, key);
	return result;
}

void
key_value_map_set_string (KeyValueMap* self,
                          const gchar* key,
                          const gchar* value)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_vala_assert (key != NULL, "key != null");
	_tmp0_ = self->priv->map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, key, value);
}

void
key_value_map_set_int (KeyValueMap* self,
                       const gchar* key,
                       gint value)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_vala_assert (key != NULL, "key != null");
	_tmp0_ = self->priv->map;
	_tmp1_ = g_strdup_printf ("%i", value);
	_tmp2_ = _tmp1_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, key, _tmp2_);
	_g_free0 (_tmp2_);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

void
key_value_map_set_double (KeyValueMap* self,
                          const gchar* key,
                          gdouble value)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_vala_assert (key != NULL, "key != null");
	_tmp0_ = self->priv->map;
	_tmp1_ = double_to_string (value);
	_tmp2_ = _tmp1_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, key, _tmp2_);
	_g_free0 (_tmp2_);
}

void
key_value_map_set_float (KeyValueMap* self,
                         const gchar* key,
                         gfloat value)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_vala_assert (key != NULL, "key != null");
	_tmp0_ = self->priv->map;
	_tmp1_ = g_strdup_printf ("%g", value);
	_tmp2_ = _tmp1_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, key, _tmp2_);
	_g_free0 (_tmp2_);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

void
key_value_map_set_bool (KeyValueMap* self,
                        const gchar* key,
                        gboolean value)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_vala_assert (key != NULL, "key != null");
	_tmp0_ = self->priv->map;
	_tmp1_ = bool_to_string (value);
	_tmp2_ = _tmp1_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, key, _tmp2_);
	_g_free0 (_tmp2_);
}

gchar*
key_value_map_get_string (KeyValueMap* self,
                          const gchar* key,
                          const gchar* def)
{
	gchar* value = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, key);
	value = (gchar*) _tmp1_;
	_tmp3_ = value;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = value;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = def;
	}
	_tmp5_ = g_strdup (_tmp2_);
	result = _tmp5_;
	_g_free0 (value);
	return result;
}

gint
key_value_map_get_int (KeyValueMap* self,
                       const gchar* key,
                       gint def)
{
	gchar* value = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gint _tmp2_ = 0;
	const gchar* _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, key);
	value = (gchar*) _tmp1_;
	_tmp3_ = value;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = value;
		_tmp2_ = atoi (_tmp4_);
	} else {
		_tmp2_ = def;
	}
	result = _tmp2_;
	_g_free0 (value);
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

gdouble
key_value_map_get_double (KeyValueMap* self,
                          const gchar* key,
                          gdouble def)
{
	gchar* value = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gdouble _tmp2_ = 0.0;
	const gchar* _tmp3_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (key != NULL, 0.0);
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, key);
	value = (gchar*) _tmp1_;
	_tmp3_ = value;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = value;
		_tmp2_ = double_parse (_tmp4_);
	} else {
		_tmp2_ = def;
	}
	result = _tmp2_;
	_g_free0 (value);
	return result;
}

gfloat
key_value_map_get_float (KeyValueMap* self,
                         const gchar* key,
                         gfloat def)
{
	gchar* value = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gfloat _tmp2_ = 0.0F;
	const gchar* _tmp3_;
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	g_return_val_if_fail (key != NULL, 0.0F);
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, key);
	value = (gchar*) _tmp1_;
	_tmp3_ = value;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = value;
		_tmp2_ = (gfloat) double_parse (_tmp4_);
	} else {
		_tmp2_ = def;
	}
	result = _tmp2_;
	_g_free0 (value);
	return result;
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

gboolean
key_value_map_get_bool (KeyValueMap* self,
                        const gchar* key,
                        gboolean def)
{
	gchar* value = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, key);
	value = (gchar*) _tmp1_;
	_tmp3_ = value;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = value;
		_tmp2_ = bool_parse (_tmp4_);
	} else {
		_tmp2_ = def;
	}
	result = _tmp2_;
	_g_free0 (value);
	return result;
}

void
key_value_map_get_point (KeyValueMap* self,
                         const gchar* key,
                         GdkPoint* def,
                         GdkPoint* result)
{
	gchar* value = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (def != NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, key);
	value = (gchar*) _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ == NULL) {
		GdkPoint _tmp3_;
		_tmp3_ = *def;
		*result = _tmp3_;
		_g_free0 (value);
		return;
	} else {
		GdkPoint _result_ = {0};
		GdkPoint _tmp4_ = {0};
		const gchar* _tmp5_;
		_tmp4_.x = 0;
		_result_ = _tmp4_;
		_tmp5_ = value;
		if (sscanf (_tmp5_, "(%d, %d)", &_result_.x, &_result_.y) == 2) {
			*result = _result_;
			_g_free0 (value);
			return;
		} else {
			GdkPoint _tmp6_;
			_tmp6_ = *def;
			*result = _tmp6_;
			_g_free0 (value);
			return;
		}
	}
}

void
key_value_map_set_point (KeyValueMap* self,
                         const gchar* key,
                         GdkPoint* point)
{
	GeeHashMap* _tmp0_;
	GdkPoint _tmp1_;
	GdkPoint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (point != NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = *point;
	_tmp2_ = *point;
	_tmp3_ = g_strdup_printf ("(%d, %d)", _tmp1_.x, _tmp2_.y);
	_tmp4_ = _tmp3_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, key, _tmp4_);
	_g_free0 (_tmp4_);
}

static void
value_key_value_map_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_key_value_map_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		key_value_map_unref (value->data[0].v_pointer);
	}
}

static void
value_key_value_map_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = key_value_map_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_key_value_map_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_key_value_map_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		KeyValueMap * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = key_value_map_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_key_value_map_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	KeyValueMap ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = key_value_map_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_key_value_map (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ParamSpecKeyValueMap* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_KEY_VALUE_MAP), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_key_value_map (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_KEY_VALUE_MAP), NULL);
	return value->data[0].v_pointer;
}

void
value_set_key_value_map (GValue* value,
                         gpointer v_object)
{
	KeyValueMap * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_KEY_VALUE_MAP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_KEY_VALUE_MAP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		key_value_map_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		key_value_map_unref (old);
	}
}

void
value_take_key_value_map (GValue* value,
                          gpointer v_object)
{
	KeyValueMap * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_KEY_VALUE_MAP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_KEY_VALUE_MAP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		key_value_map_unref (old);
	}
}

static void
key_value_map_class_init (KeyValueMapClass * klass,
                          gpointer klass_data)
{
	key_value_map_parent_class = g_type_class_peek_parent (klass);
	((KeyValueMapClass *) klass)->finalize = key_value_map_finalize;
	g_type_class_adjust_private_offset (klass, &KeyValueMap_private_offset);
}

static void
key_value_map_instance_init (KeyValueMap * self,
                             gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = key_value_map_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->map = _tmp0_;
	self->ref_count = 1;
}

static void
key_value_map_finalize (KeyValueMap * obj)
{
	KeyValueMap * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KEY_VALUE_MAP, KeyValueMap);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->group);
	_g_object_unref0 (self->priv->map);
}

static GType
key_value_map_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_key_value_map_init, value_key_value_map_free_value, value_key_value_map_copy_value, value_key_value_map_peek_pointer, "p", value_key_value_map_collect_value, "p", value_key_value_map_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (KeyValueMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) key_value_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyValueMap), 0, (GInstanceInitFunc) key_value_map_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType key_value_map_type_id;
	key_value_map_type_id = g_type_register_fundamental (g_type_fundamental_next (), "KeyValueMap", &g_define_type_info, &g_define_type_fundamental_info, 0);
	KeyValueMap_private_offset = g_type_add_instance_private (key_value_map_type_id, sizeof (KeyValueMapPrivate));
	return key_value_map_type_id;
}

GType
key_value_map_get_type (void)
{
	static volatile gsize key_value_map_type_id__once = 0;
	if (g_once_init_enter (&key_value_map_type_id__once)) {
		GType key_value_map_type_id;
		key_value_map_type_id = key_value_map_get_type_once ();
		g_once_init_leave (&key_value_map_type_id__once, key_value_map_type_id);
	}
	return key_value_map_type_id__once;
}

gpointer
key_value_map_ref (gpointer instance)
{
	KeyValueMap * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
key_value_map_unref (gpointer instance)
{
	KeyValueMap * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		KEY_VALUE_MAP_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

