/* InboxMonitor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from InboxMonitor.vala, do not modify */

/*
* Copyright 2021 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <camel/camel.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_INBOX_MONITOR (mail_inbox_monitor_get_type ())
#define MAIL_INBOX_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_INBOX_MONITOR, MailInboxMonitor))
#define MAIL_INBOX_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_INBOX_MONITOR, MailInboxMonitorClass))
#define MAIL_IS_INBOX_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_INBOX_MONITOR))
#define MAIL_IS_INBOX_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_INBOX_MONITOR))
#define MAIL_INBOX_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_INBOX_MONITOR, MailInboxMonitorClass))

typedef struct _MailInboxMonitor MailInboxMonitor;
typedef struct _MailInboxMonitorClass MailInboxMonitorClass;
typedef struct _MailInboxMonitorPrivate MailInboxMonitorPrivate;

#define MAIL_BACKEND_TYPE_SESSION (mail_backend_session_get_type ())
#define MAIL_BACKEND_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSession))
#define MAIL_BACKEND_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))
#define MAIL_BACKEND_IS_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_IS_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))

typedef struct _MailBackendSession MailBackendSession;
typedef struct _MailBackendSessionClass MailBackendSessionClass;

#define MAIL_BACKEND_TYPE_ACCOUNT (mail_backend_account_get_type ())
#define MAIL_BACKEND_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccount))
#define MAIL_BACKEND_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))
#define MAIL_BACKEND_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))

typedef struct _MailBackendAccount MailBackendAccount;
typedef struct _MailBackendAccountClass MailBackendAccountClass;
enum  {
	MAIL_INBOX_MONITOR_0_PROPERTY,
	MAIL_INBOX_MONITOR_NUM_PROPERTIES
};
static GParamSpec* mail_inbox_monitor_properties[MAIL_INBOX_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _MailInboxMonitorStartData MailInboxMonitorStartData;
typedef struct _Block20Data Block20Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MailInboxMonitorInboxFolderSynchronizeSyncData MailInboxMonitorInboxFolderSynchronizeSyncData;
typedef struct _Block21Data Block21Data;
typedef struct _Block22Data Block22Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _MailInboxMonitor {
	GObject parent_instance;
	MailInboxMonitorPrivate * priv;
};

struct _MailInboxMonitorClass {
	GObjectClass parent_class;
};

struct _MailInboxMonitorPrivate {
	GNetworkMonitor* network_monitor;
	MailBackendSession* session;
	GHashTable* inbox_folders;
	GRecMutex __lock_inbox_folders;
	GHashTable* synchronize_timeout_ids;
	GRecMutex __lock_synchronize_timeout_ids;
};

struct _MailInboxMonitorStartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailInboxMonitor* self;
	MailBackendSession* _tmp0_;
	MailBackendSession* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeLinkedList* _tmp3_;
	MailBackendSession* _tmp4_;
	MailBackendSession* _tmp5_;
};

struct _Block20Data {
	int _ref_count_;
	MailInboxMonitor* self;
	MailBackendAccount* account;
};

struct _MailInboxMonitorInboxFolderSynchronizeSyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailInboxMonitor* self;
	MailBackendAccount* account;
	GNetworkMonitor* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	CamelService* _tmp3_;
	CamelService* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	CamelFolder* inbox_folder;
	GHashTable* _tmp7_;
	gconstpointer _tmp8_;
	CamelFolder* _tmp9_;
	CamelFolder* _tmp10_;
	CamelService* _tmp11_;
	CamelService* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	CamelFolder* _tmp15_;
	GError* e;
	CamelService* _tmp16_;
	CamelService* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	const gchar* _tmp21_;
	GError* _inner_error0_;
};

struct _Block21Data {
	int _ref_count_;
	MailInboxMonitor* self;
	CamelFolder* inbox_folder;
};

struct _Block22Data {
	int _ref_count_;
	Block21Data * _data21_;
	GHashTable* sender_names;
	GSList* unseen_message_infos;
};

static gint MailInboxMonitor_private_offset;
static gpointer mail_inbox_monitor_parent_class = NULL;

VALA_EXTERN GType mail_inbox_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailInboxMonitor, g_object_unref)
VALA_EXTERN GType mail_backend_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendSession, g_object_unref)
VALA_EXTERN GType mail_backend_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendAccount, g_object_unref)
static void mail_inbox_monitor_start_data_free (gpointer _data);
VALA_EXTERN void mail_inbox_monitor_start (MailInboxMonitor* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN void mail_inbox_monitor_start_finish (MailInboxMonitor* self,
                                      GAsyncResult* _res_);
static gboolean mail_inbox_monitor_start_co (MailInboxMonitorStartData* _data_);
VALA_EXTERN void mail_backend_session_start (MailBackendSession* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void mail_backend_session_start_finish (MailBackendSession* self,
                                        GAsyncResult* _res_);
static void mail_inbox_monitor_start_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
VALA_EXTERN GeeLinkedList* mail_backend_session_get_accounts (MailBackendSession* self);
static gboolean __lambda148_ (MailInboxMonitor* self,
                       MailBackendAccount* account);
static void mail_inbox_monitor_add_account (MailInboxMonitor* self,
                                     MailBackendAccount* account);
static gboolean ___lambda148__gee_forall_func (gpointer g,
                                        gpointer self);
static void _mail_inbox_monitor_add_account_mail_backend_session_account_added (MailBackendSession* _sender,
                                                                         MailBackendAccount* account,
                                                                         gpointer self);
static void mail_inbox_monitor_remove_account (MailInboxMonitor* self,
                                        MailBackendAccount* account);
static void _mail_inbox_monitor_remove_account_mail_backend_session_account_removed (MailBackendSession* _sender,
                                                                              MailBackendAccount* account,
                                                                              gpointer self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
VALA_EXTERN CamelService* mail_backend_account_get_service (MailBackendAccount* self);
static void ______lambda149_ (Block20Data* _data20_,
                       CamelFolderChangeInfo* change_info);
static void mail_inbox_monitor_inbox_folder_changed (MailInboxMonitor* self,
                                              MailBackendAccount* account,
                                              CamelFolderChangeInfo* changes);
static void _______lambda149__camel_folder_changed (CamelFolder* _sender,
                                             CamelFolderChangeInfo* changes,
                                             gpointer self);
static gboolean ______lambda151_ (Block20Data* _data20_);
static void mail_inbox_monitor_inbox_folder_synchronize_sync (MailInboxMonitor* self,
                                                       MailBackendAccount* account,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void mail_inbox_monitor_inbox_folder_synchronize_sync_finish (MailInboxMonitor* self,
                                                              GAsyncResult* _res_);
static gboolean _______lambda151__gsource_func (gpointer self);
static void mail_inbox_monitor_inbox_folder_synchronize_sync_data_free (gpointer _data);
static gboolean mail_inbox_monitor_inbox_folder_synchronize_sync_co (MailInboxMonitorInboxFolderSynchronizeSyncData* _data_);
static void mail_inbox_monitor_inbox_folder_synchronize_sync_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static void block22_data_unref (void * _userdata_);
static void _g_free0_ (gpointer var);
static void ___lambda150_ (Block22Data* _data22_,
                    const gchar* added_uid);
static void ____lambda150__gfunc (gconstpointer data,
                           gpointer self);
VALA_EXTERN MailInboxMonitor* mail_inbox_monitor_new (void);
VALA_EXTERN MailInboxMonitor* mail_inbox_monitor_construct (GType object_type);
static GObject * mail_inbox_monitor_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
VALA_EXTERN guint mail_backend_account_hash (MailBackendAccount* account);
static guint _mail_backend_account_hash_ghash_func (gconstpointer key);
VALA_EXTERN gboolean mail_backend_account_equal (MailBackendAccount* self,
                                     MailBackendAccount* account2);
static gboolean _mail_backend_account_equal_gequal_func (gconstpointer a,
                                                  gconstpointer b);
VALA_EXTERN MailBackendSession* mail_backend_session_get_default (void);
static void mail_inbox_monitor_finalize (GObject * obj);
static GType mail_inbox_monitor_get_type_once (void);

static inline gpointer
mail_inbox_monitor_get_instance_private (MailInboxMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, MailInboxMonitor_private_offset);
}

static void
mail_inbox_monitor_start_data_free (gpointer _data)
{
	MailInboxMonitorStartData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailInboxMonitorStartData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
mail_inbox_monitor_start (MailInboxMonitor* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	MailInboxMonitorStartData* _data_;
	MailInboxMonitor* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailInboxMonitorStartData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_inbox_monitor_start_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_inbox_monitor_start_co (_data_);
}

void
mail_inbox_monitor_start_finish (MailInboxMonitor* self,
                                 GAsyncResult* _res_)
{
	MailInboxMonitorStartData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_inbox_monitor_start_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	MailInboxMonitorStartData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_inbox_monitor_start_co (_data_);
}

static gboolean
__lambda148_ (MailInboxMonitor* self,
              MailBackendAccount* account)
{
	gboolean result;
	g_return_val_if_fail (account != NULL, FALSE);
	mail_inbox_monitor_add_account (self, account);
	result = TRUE;
	_g_object_unref0 (account);
	return result;
}

static gboolean
___lambda148__gee_forall_func (gpointer g,
                               gpointer self)
{
	gboolean result;
	result = __lambda148_ ((MailInboxMonitor*) self, (MailBackendAccount*) g);
	return result;
}

static void
_mail_inbox_monitor_add_account_mail_backend_session_account_added (MailBackendSession* _sender,
                                                                    MailBackendAccount* account,
                                                                    gpointer self)
{
	mail_inbox_monitor_add_account ((MailInboxMonitor*) self, account);
}

static void
_mail_inbox_monitor_remove_account_mail_backend_session_account_removed (MailBackendSession* _sender,
                                                                         MailBackendAccount* account,
                                                                         gpointer self)
{
	mail_inbox_monitor_remove_account ((MailInboxMonitor*) self, account);
}

static gboolean
mail_inbox_monitor_start_co (MailInboxMonitorStartData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->session;
	_data_->_state_ = 1;
	mail_backend_session_start (_data_->_tmp0_, mail_inbox_monitor_start_ready, _data_);
	return FALSE;
	_state_1:
	mail_backend_session_start_finish (_data_->_tmp0_, _data_->_res_);
	_data_->_tmp1_ = _data_->self->priv->session;
	_data_->_tmp2_ = mail_backend_session_get_accounts (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _data_->_tmp3_, ___lambda148__gee_forall_func, _data_->self);
	_g_object_unref0 (_data_->_tmp3_);
	_data_->_tmp4_ = _data_->self->priv->session;
	g_signal_connect_object (_data_->_tmp4_, "account-added", (GCallback) _mail_inbox_monitor_add_account_mail_backend_session_account_added, _data_->self, 0);
	_data_->_tmp5_ = _data_->self->priv->session;
	g_signal_connect_object (_data_->_tmp5_, "account-removed", (GCallback) _mail_inbox_monitor_remove_account_mail_backend_session_account_removed, _data_->self, 0);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_inbox_monitor_remove_account (MailInboxMonitor* self,
                                   MailBackendAccount* account)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->inbox_folders;
		g_rec_mutex_lock (&self->priv->__lock_inbox_folders);
		{
			GHashTable* _tmp1_;
			_tmp1_ = self->priv->inbox_folders;
			g_hash_table_remove (_tmp1_, account);
		}
		__finally0:
		{
			GHashTable* _tmp2_;
			_tmp2_ = self->priv->inbox_folders;
			g_rec_mutex_unlock (&self->priv->__lock_inbox_folders);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		GHashTable* _tmp3_;
		_tmp3_ = self->priv->synchronize_timeout_ids;
		g_rec_mutex_lock (&self->priv->__lock_synchronize_timeout_ids);
		{
			GHashTable* _tmp4_;
			GHashTable* _tmp7_;
			_tmp4_ = self->priv->synchronize_timeout_ids;
			if (g_hash_table_contains (_tmp4_, account)) {
				GHashTable* _tmp5_;
				gconstpointer _tmp6_;
				_tmp5_ = self->priv->synchronize_timeout_ids;
				_tmp6_ = g_hash_table_lookup (_tmp5_, account);
				g_source_remove ((guint) ((guintptr) _tmp6_));
			}
			_tmp7_ = self->priv->synchronize_timeout_ids;
			g_hash_table_remove (_tmp7_, account);
		}
		__finally1:
		{
			GHashTable* _tmp8_;
			_tmp8_ = self->priv->synchronize_timeout_ids;
			g_rec_mutex_unlock (&self->priv->__lock_synchronize_timeout_ids);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		MailInboxMonitor* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->account);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static void
______lambda149_ (Block20Data* _data20_,
                  CamelFolderChangeInfo* change_info)
{
	MailInboxMonitor* self;
	self = _data20_->self;
	g_return_if_fail (change_info != NULL);
	mail_inbox_monitor_inbox_folder_changed (self, _data20_->account, change_info);
}

static void
_______lambda149__camel_folder_changed (CamelFolder* _sender,
                                        CamelFolderChangeInfo* changes,
                                        gpointer self)
{
	______lambda149_ (self, changes);
}

static gboolean
______lambda151_ (Block20Data* _data20_)
{
	MailInboxMonitor* self;
	gboolean result;
	self = _data20_->self;
	mail_inbox_monitor_inbox_folder_synchronize_sync (self, _data20_->account, NULL, NULL);
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
_______lambda151__gsource_func (gpointer self)
{
	gboolean result;
	result = ______lambda151_ (self);
	return result;
}

static void
mail_inbox_monitor_add_account (MailInboxMonitor* self,
                                MailBackendAccount* account)
{
	Block20Data* _data20_;
	MailBackendAccount* _tmp0_;
	CamelStore* store = NULL;
	CamelService* _tmp1_;
	CamelService* _tmp2_;
	CamelStore* _tmp3_;
	CamelStore* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (account);
	_g_object_unref0 (_data20_->account);
	_data20_->account = _tmp0_;
	_tmp1_ = mail_backend_account_get_service (_data20_->account);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, camel_store_get_type (), CamelStore));
	store = _tmp3_;
	_tmp4_ = store;
	if (_tmp4_ != NULL) {
		{
			CamelFolder* folder = NULL;
			CamelStore* _tmp5_;
			CamelFolder* _tmp6_;
			CamelFolder* _tmp7_;
			_tmp5_ = store;
			_tmp6_ = camel_store_get_inbox_folder_sync (_tmp5_, NULL, &_inner_error0_);
			folder = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp7_ = folder;
			if (_tmp7_ != NULL) {
				CamelFolder* inbox_folder = NULL;
				CamelStore* _tmp8_;
				CamelFolder* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				CamelFolder* _tmp12_;
				CamelFolder* _tmp13_;
				_tmp8_ = store;
				_tmp9_ = folder;
				_tmp10_ = camel_folder_get_full_name (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = camel_store_get_folder_sync (_tmp8_, _tmp11_, CAMEL_STORE_FOLDER_NONE, NULL, &_inner_error0_);
				inbox_folder = _tmp12_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (folder);
					goto __catch0_g_error;
				}
				_tmp13_ = inbox_folder;
				if (_tmp13_ != NULL) {
					CamelFolder* _tmp14_;
					guint refresh_interval_in_minutes = 0U;
					CamelFolder* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					guint refresh_timeout_id = 0U;
					_tmp14_ = inbox_folder;
					g_signal_connect_data (_tmp14_, "changed", (GCallback) _______lambda149__camel_folder_changed, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
					{
						GHashTable* _tmp15_;
						_tmp15_ = self->priv->inbox_folders;
						g_rec_mutex_lock (&self->priv->__lock_inbox_folders);
						{
							GHashTable* _tmp16_;
							MailBackendAccount* _tmp17_;
							CamelFolder* _tmp18_;
							CamelFolder* _tmp19_;
							_tmp16_ = self->priv->inbox_folders;
							_tmp17_ = _g_object_ref0 (_data20_->account);
							_tmp18_ = inbox_folder;
							_tmp19_ = _g_object_ref0 (_tmp18_);
							g_hash_table_insert (_tmp16_, _tmp17_, _tmp19_);
						}
						__finally1:
						{
							GHashTable* _tmp20_;
							_tmp20_ = self->priv->inbox_folders;
							g_rec_mutex_unlock (&self->priv->__lock_inbox_folders);
						}
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (inbox_folder);
							_g_object_unref0 (folder);
							goto __catch0_g_error;
						}
					}
					refresh_interval_in_minutes = (guint) 15;
					_tmp21_ = folder;
					_tmp22_ = camel_folder_get_display_name (_tmp21_);
					_tmp23_ = _tmp22_;
					g_debug ("InboxMonitor.vala:82: [%s] Checking inbox for new mail every %u minute" \
"s…", _tmp23_, refresh_interval_in_minutes);
					refresh_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, refresh_interval_in_minutes * 60, _______lambda151__gsource_func, block20_data_ref (_data20_), block20_data_unref);
					{
						GHashTable* _tmp24_;
						_tmp24_ = self->priv->synchronize_timeout_ids;
						g_rec_mutex_lock (&self->priv->__lock_synchronize_timeout_ids);
						{
							GHashTable* _tmp25_;
							MailBackendAccount* _tmp26_;
							_tmp25_ = self->priv->synchronize_timeout_ids;
							_tmp26_ = _g_object_ref0 (_data20_->account);
							g_hash_table_insert (_tmp25_, _tmp26_, (gpointer) ((guintptr) refresh_timeout_id));
						}
						__finally2:
						{
							GHashTable* _tmp27_;
							_tmp27_ = self->priv->synchronize_timeout_ids;
							g_rec_mutex_unlock (&self->priv->__lock_synchronize_timeout_ids);
						}
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (inbox_folder);
							_g_object_unref0 (folder);
							goto __catch0_g_error;
						}
					}
					mail_inbox_monitor_inbox_folder_synchronize_sync (self, _data20_->account, NULL, NULL);
				}
				_g_object_unref0 (inbox_folder);
			} else {
				CamelService* _tmp28_;
				CamelService* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				_tmp28_ = mail_backend_account_get_service (_data20_->account);
				_tmp29_ = _tmp28_;
				_tmp30_ = camel_service_get_display_name (_tmp29_);
				_tmp31_ = _tmp30_;
				g_debug ("InboxMonitor.vala:95: [%s] Inbox folder not found. Can't automatically" \
" check for new messages.", _tmp31_);
			}
			_g_object_unref0 (folder);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			CamelService* _tmp32_;
			CamelService* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			GError* _tmp36_;
			const gchar* _tmp37_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp32_ = mail_backend_account_get_service (_data20_->account);
			_tmp33_ = _tmp32_;
			_tmp34_ = camel_service_get_display_name (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = e;
			_tmp37_ = _tmp36_->message;
			g_debug ("InboxMonitor.vala:98: [%s] Error getting inbox folder: %s", _tmp35_, _tmp37_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (store);
			block20_data_unref (_data20_);
			_data20_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		CamelService* _tmp38_;
		CamelService* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		_tmp38_ = mail_backend_account_get_service (_data20_->account);
		_tmp39_ = _tmp38_;
		_tmp40_ = camel_service_get_display_name (_tmp39_);
		_tmp41_ = _tmp40_;
		g_debug ("InboxMonitor.vala:101: [%s] No store available.", _tmp41_);
	}
	_g_object_unref0 (store);
	block20_data_unref (_data20_);
	_data20_ = NULL;
}

static void
mail_inbox_monitor_inbox_folder_synchronize_sync_data_free (gpointer _data)
{
	MailInboxMonitorInboxFolderSynchronizeSyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailInboxMonitorInboxFolderSynchronizeSyncData, _data_);
}

static void
mail_inbox_monitor_inbox_folder_synchronize_sync (MailInboxMonitor* self,
                                                  MailBackendAccount* account,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	MailInboxMonitorInboxFolderSynchronizeSyncData* _data_;
	MailInboxMonitor* _tmp0_;
	MailBackendAccount* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	_data_ = g_slice_new0 (MailInboxMonitorInboxFolderSynchronizeSyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_inbox_monitor_inbox_folder_synchronize_sync_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (account);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	mail_inbox_monitor_inbox_folder_synchronize_sync_co (_data_);
}

static void
mail_inbox_monitor_inbox_folder_synchronize_sync_finish (MailInboxMonitor* self,
                                                         GAsyncResult* _res_)
{
	MailInboxMonitorInboxFolderSynchronizeSyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_inbox_monitor_inbox_folder_synchronize_sync_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	MailInboxMonitorInboxFolderSynchronizeSyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_inbox_monitor_inbox_folder_synchronize_sync_co (_data_);
}

static gboolean
mail_inbox_monitor_inbox_folder_synchronize_sync_co (MailInboxMonitorInboxFolderSynchronizeSyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->network_monitor;
	_data_->_tmp1_ = g_network_monitor_get_network_available (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (!_data_->_tmp2_) {
		_data_->_tmp3_ = mail_backend_account_get_service (_data_->account);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = camel_service_get_display_name (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		g_debug ("InboxMonitor.vala:107: [%s] Network is not avaible. Skipping…", _data_->_tmp6_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->self->priv->inbox_folders;
	_data_->_tmp8_ = g_hash_table_lookup (_data_->_tmp7_, _data_->account);
	_data_->_tmp9_ = _g_object_ref0 ((CamelFolder*) _data_->_tmp8_);
	_data_->inbox_folder = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->inbox_folder;
	if (_data_->_tmp10_ != NULL) {
		_data_->_tmp11_ = mail_backend_account_get_service (_data_->account);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = camel_service_get_display_name (_data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		g_debug ("InboxMonitor.vala:113: [%s] Refreshing…", _data_->_tmp14_);
		{
			_data_->_tmp15_ = _data_->inbox_folder;
			_data_->_state_ = 1;
			camel_folder_refresh_info (_data_->_tmp15_, G_PRIORITY_DEFAULT, NULL, mail_inbox_monitor_inbox_folder_synchronize_sync_ready, _data_);
			return FALSE;
			_state_1:
			camel_folder_refresh_info_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp16_ = mail_backend_account_get_service (_data_->account);
			_data_->_tmp17_ = _data_->_tmp16_;
			_data_->_tmp18_ = camel_service_get_display_name (_data_->_tmp17_);
			_data_->_tmp19_ = _data_->_tmp18_;
			_data_->_tmp20_ = _data_->e;
			_data_->_tmp21_ = _data_->_tmp20_->message;
			g_debug ("InboxMonitor.vala:118: [%s] Error refreshing: %s", _data_->_tmp19_, _data_->_tmp21_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->inbox_folder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->inbox_folder);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		MailInboxMonitor* self;
		self = _data21_->self;
		_g_object_unref0 (_data21_->inbox_folder);
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		MailInboxMonitor* self;
		self = _data22_->_data21_->self;
		(_data22_->unseen_message_infos == NULL) ? NULL : (_data22_->unseen_message_infos = (_g_slist_free__g_object_unref0_ (_data22_->unseen_message_infos), NULL));
		_g_hash_table_unref0 (_data22_->sender_names);
		block21_data_unref (_data22_->_data21_);
		_data22_->_data21_ = NULL;
		g_slice_free (Block22Data, _data22_);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
___lambda150_ (Block22Data* _data22_,
               const gchar* added_uid)
{
	Block21Data* _data21_;
	MailInboxMonitor* self;
	CamelMessageInfo* message_info = NULL;
	CamelFolder* _tmp0_;
	CamelMessageInfo* _tmp1_;
	CamelMessageInfo* _tmp2_;
	CamelMessageFlags _tmp3_;
	CamelMessageFlags _tmp4_;
	_data21_ = _data22_->_data21_;
	self = _data21_->self;
	g_return_if_fail (added_uid != NULL);
	_tmp0_ = _data21_->inbox_folder;
	_tmp1_ = camel_folder_get_message_info (_tmp0_, added_uid);
	message_info = _tmp1_;
	_tmp2_ = message_info;
	g_object_get (_tmp2_, "flags", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (!((_tmp4_ & CAMEL_MESSAGE_SEEN) == CAMEL_MESSAGE_SEEN)) {
		const gchar* sender_address = NULL;
		const gchar* sender_name = NULL;
		CamelInternetAddress* camel_address = NULL;
		CamelInternetAddress* _tmp5_;
		CamelInternetAddress* _tmp6_;
		CamelMessageInfo* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		CamelInternetAddress* _tmp10_;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_;
		GHashTable* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		CamelMessageInfo* _tmp18_;
		CamelMessageInfo* _tmp19_;
		_tmp5_ = camel_internet_address_new ();
		camel_address = _tmp5_;
		_tmp6_ = camel_address;
		_tmp7_ = message_info;
		_tmp8_ = camel_message_info_get_from (_tmp7_);
		_tmp9_ = _tmp8_;
		camel_address_unformat ((CamelAddress*) _tmp6_, _tmp9_);
		_tmp10_ = camel_address;
		camel_internet_address_get (_tmp10_, 0, &_tmp11_, &_tmp12_);
		sender_name = _tmp11_;
		sender_address = _tmp12_;
		_tmp13_ = sender_name;
		if (_tmp13_ == NULL) {
			const gchar* _tmp14_;
			_tmp14_ = sender_address;
			sender_name = _tmp14_;
		}
		_tmp15_ = _data22_->sender_names;
		_tmp16_ = sender_name;
		_tmp17_ = g_strdup (_tmp16_);
		g_hash_table_add (_tmp15_, _tmp17_);
		_tmp18_ = message_info;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		_data22_->unseen_message_infos = g_slist_append (_data22_->unseen_message_infos, _tmp19_);
		_g_object_unref0 (camel_address);
	}
	_g_object_unref0 (message_info);
}

static void
____lambda150__gfunc (gconstpointer data,
                      gpointer self)
{
	___lambda150_ (self, (const gchar*) data);
}

static gconstpointer
_vala_hash_set_next_value (GHashTableIter *self)
{
	void* vi = NULL;
	GHashTableIter* htp = NULL;
	void* _tmp0_;
	gconstpointer value = NULL;
	gconstpointer _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gboolean _tmp3_;
	gconstpointer result;
	vi = &(*self);
	_tmp0_ = vi;
	htp = _tmp0_;
	_tmp3_ = g_hash_table_iter_next (htp, (gpointer*) (&_tmp2_), (gpointer*) NULL);
	value = _tmp2_;
	if (_tmp3_) {
		gconstpointer _tmp4_;
		_tmp4_ = value;
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = NULL;
	}
	result = _tmp1_;
	return result;
}

static void
mail_inbox_monitor_inbox_folder_changed (MailInboxMonitor* self,
                                         MailBackendAccount* account,
                                         CamelFolderChangeInfo* changes)
{
	Block21Data* _data21_;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	CamelFolder* _tmp2_;
	CamelFolder* _tmp3_;
	GPtrArray* added_uids = NULL;
	GPtrArray* _tmp4_;
	GPtrArray* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (changes != NULL);
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->self = g_object_ref (self);
	_tmp0_ = self->priv->inbox_folders;
	_tmp1_ = g_hash_table_lookup (_tmp0_, account);
	_tmp2_ = _g_object_ref0 ((CamelFolder*) _tmp1_);
	_data21_->inbox_folder = _tmp2_;
	_tmp3_ = _data21_->inbox_folder;
	if (_tmp3_ == NULL) {
		block21_data_unref (_data21_);
		_data21_ = NULL;
		return;
	}
	_tmp4_ = camel_folder_change_info_get_added_uids (changes);
	added_uids = _tmp4_;
	_tmp5_ = added_uids;
	if (_tmp5_ != NULL) {
		Block22Data* _data22_;
		GHashFunc _tmp6_;
		GEqualFunc _tmp7_;
		GHashTable* _tmp8_;
		GPtrArray* _tmp9_;
		guint unseen_message_infos_length = 0U;
		GSList* _tmp10_;
		_data22_ = g_slice_new0 (Block22Data);
		_data22_->_ref_count_ = 1;
		_data22_->_data21_ = block21_data_ref (_data21_);
		_tmp6_ = g_str_hash;
		_tmp7_ = g_str_equal;
		_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, NULL, _g_free0_);
		_data22_->sender_names = _tmp8_;
		_data22_->unseen_message_infos = NULL;
		_tmp9_ = added_uids;
		g_ptr_array_foreach (_tmp9_, ____lambda150__gfunc, _data22_);
		_tmp10_ = _data22_->unseen_message_infos;
		unseen_message_infos_length = g_slist_length (_tmp10_);
		if (unseen_message_infos_length == ((guint) 1)) {
			CamelMessageInfo* unseen_message_info = NULL;
			GSList* _tmp11_;
			gconstpointer _tmp12_;
			CamelMessageInfo* _tmp13_;
			GNotification* notification = NULL;
			GHashTable* _tmp14_;
			GHashTableIter _tmp15_ = {0};
			gconstpointer _tmp16_;
			CamelFolder* _tmp17_;
			CamelStore* _tmp18_;
			CamelStore* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			GNotification* _tmp24_;
			GNotification* _tmp25_;
			GNotification* _tmp26_;
			CamelMessageInfo* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			GApplication* _tmp30_;
			CamelMessageInfo* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			GNotification* _tmp34_;
			_tmp11_ = _data22_->unseen_message_infos;
			_tmp12_ = g_slist_nth_data (_tmp11_, (guint) 0);
			_tmp13_ = _g_object_ref0 ((CamelMessageInfo*) _tmp12_);
			unseen_message_info = _tmp13_;
			_tmp14_ = _data22_->sender_names;
			g_hash_table_iter_init (&_tmp15_, _tmp14_);
			_tmp16_ = _vala_hash_set_next_value (&_tmp15_);
			_tmp17_ = _data21_->inbox_folder;
			_tmp18_ = camel_folder_get_parent_store (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = camel_service_get_display_name ((CamelService*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strdup_printf (_ ("%s to %s"), (const gchar*) _tmp16_, _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_notification_new (_tmp23_);
			_tmp25_ = _tmp24_;
			_g_free0 (_tmp23_);
			notification = _tmp25_;
			_tmp26_ = notification;
			_tmp27_ = unseen_message_info;
			_tmp28_ = camel_message_info_get_subject (_tmp27_);
			_tmp29_ = _tmp28_;
			g_notification_set_body (_tmp26_, _tmp29_);
			_tmp30_ = g_application_get_default ();
			_tmp31_ = unseen_message_info;
			_tmp32_ = camel_message_info_get_uid (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = notification;
			g_application_send_notification (_tmp30_, _tmp33_, _tmp34_);
			_g_object_unref0 (notification);
			_g_object_unref0 (unseen_message_info);
		} else {
			if (unseen_message_infos_length > ((guint) 1)) {
				GNotification* notification = NULL;
				gchar* messages_count = NULL;
				gchar* _tmp35_;
				GHashTable* _tmp36_;
				guint _tmp37_;
				guint _tmp38_;
				GApplication* _tmp70_;
				GSList* _tmp71_;
				gconstpointer _tmp72_;
				const gchar* _tmp73_;
				const gchar* _tmp74_;
				GNotification* _tmp75_;
				_tmp35_ = g_strdup_printf (ngettext ("%u new message", "%u new messages", (gulong) unseen_message_infos_length), unseen_message_infos_length);
				messages_count = _tmp35_;
				_tmp36_ = _data22_->sender_names;
				_tmp37_ = g_hash_table_size (_tmp36_);
				_tmp38_ = _tmp37_;
				if (_tmp38_ == ((guint) 1)) {
					gchar* sender_name = NULL;
					GHashTable* _tmp39_;
					GHashTableIter _tmp40_ = {0};
					gconstpointer _tmp41_;
					gchar* _tmp42_;
					const gchar* _tmp43_;
					CamelFolder* _tmp44_;
					CamelStore* _tmp45_;
					CamelStore* _tmp46_;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					GNotification* _tmp51_;
					GNotification* _tmp52_;
					const gchar* _tmp53_;
					_tmp39_ = _data22_->sender_names;
					g_hash_table_iter_init (&_tmp40_, _tmp39_);
					_tmp41_ = _vala_hash_set_next_value (&_tmp40_);
					_tmp42_ = g_strdup ((const gchar*) _tmp41_);
					sender_name = _tmp42_;
					_tmp43_ = sender_name;
					_tmp44_ = _data21_->inbox_folder;
					_tmp45_ = camel_folder_get_parent_store (_tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = camel_service_get_display_name ((CamelService*) _tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = g_strdup_printf (_ ("%s to %s"), _tmp43_, _tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = g_notification_new (_tmp50_);
					_g_object_unref0 (notification);
					notification = _tmp51_;
					_g_free0 (_tmp50_);
					_tmp52_ = notification;
					_tmp53_ = messages_count;
					g_notification_set_body (_tmp52_, _tmp53_);
					_g_free0 (sender_name);
				} else {
					CamelFolder* _tmp54_;
					CamelStore* _tmp55_;
					CamelStore* _tmp56_;
					const gchar* _tmp57_;
					const gchar* _tmp58_;
					GNotification* _tmp59_;
					GNotification* _tmp60_;
					GHashTable* _tmp61_;
					guint _tmp62_;
					guint _tmp63_;
					const gchar* _tmp64_;
					GHashTable* _tmp65_;
					guint _tmp66_;
					guint _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
					_tmp54_ = _data21_->inbox_folder;
					_tmp55_ = camel_folder_get_parent_store (_tmp54_);
					_tmp56_ = _tmp55_;
					_tmp57_ = camel_service_get_display_name ((CamelService*) _tmp56_);
					_tmp58_ = _tmp57_;
					_tmp59_ = g_notification_new (_tmp58_);
					_g_object_unref0 (notification);
					notification = _tmp59_;
					_tmp60_ = notification;
					_tmp61_ = _data22_->sender_names;
					_tmp62_ = g_hash_table_size (_tmp61_);
					_tmp63_ = _tmp62_;
					_tmp64_ = messages_count;
					_tmp65_ = _data22_->sender_names;
					_tmp66_ = g_hash_table_size (_tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = g_strdup_printf (ngettext ("%s from %u sender", "%s from %u senders", (gulong) _tmp63_), _tmp64_, _tmp67_);
					_tmp69_ = _tmp68_;
					g_notification_set_body (_tmp60_, _tmp69_);
					_g_free0 (_tmp69_);
				}
				_tmp70_ = g_application_get_default ();
				_tmp71_ = _data22_->unseen_message_infos;
				_tmp72_ = g_slist_nth_data (_tmp71_, (guint) 0);
				_tmp73_ = camel_message_info_get_uid ((CamelMessageInfo*) _tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = notification;
				g_application_send_notification (_tmp70_, _tmp74_, _tmp75_);
				_g_free0 (messages_count);
				_g_object_unref0 (notification);
			}
		}
		block22_data_unref (_data22_);
		_data22_ = NULL;
	}
	block21_data_unref (_data21_);
	_data21_ = NULL;
}

MailInboxMonitor*
mail_inbox_monitor_construct (GType object_type)
{
	MailInboxMonitor * self = NULL;
	self = (MailInboxMonitor*) g_object_new (object_type, NULL);
	return self;
}

MailInboxMonitor*
mail_inbox_monitor_new (void)
{
	return mail_inbox_monitor_construct (MAIL_TYPE_INBOX_MONITOR);
}

static guint
_mail_backend_account_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = mail_backend_account_hash ((MailBackendAccount*) key);
	return result;
}

static gboolean
_mail_backend_account_equal_gequal_func (gconstpointer a,
                                         gconstpointer b)
{
	gboolean result;
	result = mail_backend_account_equal (a, (MailBackendAccount*) b);
	return result;
}

static GObject *
mail_inbox_monitor_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailInboxMonitor * self;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GNetworkMonitor* _tmp2_;
	GNetworkMonitor* _tmp3_;
	MailBackendSession* _tmp4_;
	MailBackendSession* _tmp5_;
	parent_class = G_OBJECT_CLASS (mail_inbox_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_INBOX_MONITOR, MailInboxMonitor);
	_tmp0_ = g_hash_table_new_full (_mail_backend_account_hash_ghash_func, _mail_backend_account_equal_gequal_func, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->inbox_folders);
	self->priv->inbox_folders = _tmp0_;
	_tmp1_ = g_hash_table_new_full (_mail_backend_account_hash_ghash_func, _mail_backend_account_equal_gequal_func, _g_object_unref0_, NULL);
	_g_hash_table_unref0 (self->priv->synchronize_timeout_ids);
	self->priv->synchronize_timeout_ids = _tmp1_;
	_tmp2_ = g_network_monitor_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->network_monitor);
	self->priv->network_monitor = _tmp3_;
	_tmp4_ = mail_backend_session_get_default ();
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->session);
	self->priv->session = _tmp5_;
	return obj;
}

static void
mail_inbox_monitor_class_init (MailInboxMonitorClass * klass,
                               gpointer klass_data)
{
	mail_inbox_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailInboxMonitor_private_offset);
	G_OBJECT_CLASS (klass)->constructor = mail_inbox_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_inbox_monitor_finalize;
}

static void
mail_inbox_monitor_instance_init (MailInboxMonitor * self,
                                  gpointer klass)
{
	self->priv = mail_inbox_monitor_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_inbox_folders);
	g_rec_mutex_init (&self->priv->__lock_synchronize_timeout_ids);
}

static void
mail_inbox_monitor_finalize (GObject * obj)
{
	MailInboxMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_INBOX_MONITOR, MailInboxMonitor);
	_g_object_unref0 (self->priv->network_monitor);
	_g_object_unref0 (self->priv->session);
	g_rec_mutex_clear (&self->priv->__lock_inbox_folders);
	_g_hash_table_unref0 (self->priv->inbox_folders);
	g_rec_mutex_clear (&self->priv->__lock_synchronize_timeout_ids);
	_g_hash_table_unref0 (self->priv->synchronize_timeout_ids);
	G_OBJECT_CLASS (mail_inbox_monitor_parent_class)->finalize (obj);
}

static GType
mail_inbox_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailInboxMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_inbox_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailInboxMonitor), 0, (GInstanceInitFunc) mail_inbox_monitor_instance_init, NULL };
	GType mail_inbox_monitor_type_id;
	mail_inbox_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "MailInboxMonitor", &g_define_type_info, 0);
	MailInboxMonitor_private_offset = g_type_add_instance_private (mail_inbox_monitor_type_id, sizeof (MailInboxMonitorPrivate));
	return mail_inbox_monitor_type_id;
}

GType
mail_inbox_monitor_get_type (void)
{
	static volatile gsize mail_inbox_monitor_type_id__once = 0;
	if (g_once_init_enter (&mail_inbox_monitor_type_id__once)) {
		GType mail_inbox_monitor_type_id;
		mail_inbox_monitor_type_id = mail_inbox_monitor_get_type_once ();
		g_once_init_leave (&mail_inbox_monitor_type_id__once, mail_inbox_monitor_type_id);
	}
	return mail_inbox_monitor_type_id__once;
}

