/* CopyMoveJob.c generated by valac 0.56.18, the Vala compiler
 * generated from CopyMoveJob.vala, do not modify */

/* Copyright 2022 elementary LLC (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, Inc.,; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "pantheon-files-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer marlin_file_operations_copy_move_job_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static guint _g_file_hash_ghash_func (gconstpointer key);
static gboolean _g_file_equal_gequal_func (gconstpointer a,
                                    gconstpointer b);
static const gchar* marlin_file_operations_copy_move_job_real_get_scan_primary (FilesFileOperationsCommonJob* base);
static void marlin_file_operations_copy_move_job_real_report_count_progress (FilesFileOperationsCommonJob* base,
                                                                      SourceInfo* source_info);
static void marlin_file_operations_copy_move_job_finalize (FilesFileOperationsCommonJob * obj);
static GType marlin_file_operations_copy_move_job_get_type_once (void);

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static guint
_g_file_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = g_file_hash (key);
	return result;
}

static gboolean
_g_file_equal_gequal_func (gconstpointer a,
                           gconstpointer b)
{
	gboolean result;
	result = g_file_equal (a, (GFile*) b);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FilesFileOperationsCopyMoveJob*
marlin_file_operations_copy_move_job_construct (GType object_type,
                                                GtkWindow* parent_window,
                                                GList* files,
                                                GFile* destination)
{
	FilesFileOperationsCopyMoveJob* self = NULL;
	GList* _tmp0_;
	GFile* _tmp1_;
	self = (FilesFileOperationsCopyMoveJob*) marlin_file_operations_common_job_construct (object_type, parent_window);
	_tmp0_ = g_list_copy_deep (files, (GCopyFunc) g_object_ref, NULL);
	(self->files == NULL) ? NULL : (self->files = (_g_list_free__g_object_unref0_ (self->files), NULL));
	self->files = _tmp0_;
	_tmp1_ = _g_object_ref0 (destination);
	_g_object_unref0 (self->destination);
	self->destination = _tmp1_;
	return self;
}

FilesFileOperationsCopyMoveJob*
marlin_file_operations_copy_move_job_new (GtkWindow* parent_window,
                                          GList* files,
                                          GFile* destination)
{
	return marlin_file_operations_copy_move_job_construct (MARLIN_FILE_OPERATIONS_TYPE_COPY_MOVE_JOB, parent_window, files, destination);
}

FilesFileOperationsCopyMoveJob*
marlin_file_operations_copy_move_job_construct_move (GType object_type,
                                                     GtkWindow* parent_window,
                                                     GList* files,
                                                     GFile* destination)
{
	FilesFileOperationsCopyMoveJob* self = NULL;
	GList* _tmp0_;
	GFile* _tmp1_;
	self = (FilesFileOperationsCopyMoveJob*) marlin_file_operations_common_job_construct (object_type, parent_window);
	_tmp0_ = g_list_copy_deep (files, (GCopyFunc) g_object_ref, NULL);
	(self->files == NULL) ? NULL : (self->files = (_g_list_free__g_object_unref0_ (self->files), NULL));
	self->files = _tmp0_;
	_tmp1_ = _g_object_ref0 (destination);
	_g_object_unref0 (self->destination);
	self->destination = _tmp1_;
	self->is_move = TRUE;
	return self;
}

FilesFileOperationsCopyMoveJob*
marlin_file_operations_copy_move_job_new_move (GtkWindow* parent_window,
                                               GList* files,
                                               GFile* destination)
{
	return marlin_file_operations_copy_move_job_construct_move (MARLIN_FILE_OPERATIONS_TYPE_COPY_MOVE_JOB, parent_window, files, destination);
}

static const gchar*
marlin_file_operations_copy_move_job_real_get_scan_primary (FilesFileOperationsCommonJob* base)
{
	FilesFileOperationsCopyMoveJob * self;
	const gchar* result;
	self = (FilesFileOperationsCopyMoveJob*) base;
	if (self->is_move) {
		result = _ ("Error while moving.");
		return result;
	} else {
		result = _ ("Error while copying.");
		return result;
	}
}

static void
marlin_file_operations_copy_move_job_real_report_count_progress (FilesFileOperationsCommonJob* base,
                                                                 SourceInfo* source_info)
{
	FilesFileOperationsCopyMoveJob * self;
	gchar* s = NULL;
	gchar* num_bytes_format = NULL;
	gchar* _tmp0_;
	PFProgressInfo* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	PFProgressInfo* _tmp8_;
	self = (FilesFileOperationsCopyMoveJob*) base;
	g_return_if_fail (source_info != NULL);
	_tmp0_ = g_format_size_full ((guint64) source_info->num_bytes, G_FORMAT_SIZE_DEFAULT);
	num_bytes_format = _tmp0_;
	if (!self->is_move) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = num_bytes_format;
		_tmp2_ = g_strdup_printf (ngettext ("Preparing to copy %'d file (%s)", "Preparing to copy %'d files (%s)", (gulong) source_info->num_files), source_info->num_files, _tmp1_);
		_g_free0 (s);
		s = _tmp2_;
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = num_bytes_format;
		_tmp4_ = g_strdup_printf (ngettext ("Preparing to move %'d file (%s)", "Preparing to move %'d files (%s)", (gulong) source_info->num_files), source_info->num_files, _tmp3_);
		_g_free0 (s);
		s = _tmp4_;
	}
	_tmp5_ = ((FilesFileOperationsCommonJob*) self)->progress;
	_tmp6_ = s;
	_tmp7_ = g_strdup (_tmp6_);
	pf_progress_info_take_details (_tmp5_, _tmp7_);
	_tmp8_ = ((FilesFileOperationsCommonJob*) self)->progress;
	pf_progress_info_pulse_progress (_tmp8_);
	_g_free0 (num_bytes_format);
	_g_free0 (s);
}

void
marlin_file_operations_copy_move_job_report_link_progress (FilesFileOperationsCopyMoveJob* self,
                                                           gint total,
                                                           gint left)
{
	gchar* s = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	PFProgressInfo* _tmp5_;
	gchar* _tmp6_;
	PFProgressInfo* _tmp7_;
	gchar* _tmp8_;
	PFProgressInfo* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->destination;
	_tmp1_ = g_file_get_parse_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (_ ("Creating links in \"%s\""), _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	s = _tmp4_;
	_tmp5_ = ((FilesFileOperationsCommonJob*) self)->progress;
	_tmp6_ = g_strdup (s);
	pf_progress_info_take_status (_tmp5_, _tmp6_);
	_tmp7_ = ((FilesFileOperationsCommonJob*) self)->progress;
	_tmp8_ = g_strdup_printf (ngettext ("Making link to %'d file", "Making links to %'d files", (gulong) left), left);
	pf_progress_info_take_details (_tmp7_, _tmp8_);
	_tmp9_ = ((FilesFileOperationsCommonJob*) self)->progress;
	pf_progress_info_update_progress (_tmp9_, (gdouble) left, (gdouble) total);
	_g_free0 (s);
}

void
marlin_file_operations_copy_move_job_report_copy_progress (FilesFileOperationsCopyMoveJob* self,
                                                           SourceInfo* source_info,
                                                           TransferInfo* transfer_info)
{
	gint64 now = 0LL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	gchar* srcname = NULL;
	GList* _tmp5_;
	gconstpointer _tmp6_;
	gchar* _tmp7_;
	gchar* destname = NULL;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gint files_left = 0;
	gboolean _tmp10_ = FALSE;
	gint64 total_size = 0LL;
	gdouble elapsed = 0.0;
	GTimer* _tmp36_;
	gdouble transfer_rate = 0.0;
	gboolean _tmp37_ = FALSE;
	PFProgressInfo* _tmp56_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_info != NULL);
	g_return_if_fail (transfer_info != NULL);
	now = g_get_monotonic_time () * 1000;
	if (transfer_info->last_report_time != ((guint64) 0)) {
		_tmp0_ = llabs (((gint64) transfer_info->last_report_time) - now) < ((gint64) (100 * MARLIN_FILE_OPERATIONS_COMMON_JOB_NSEC_PER_MSEC));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp2_ = self->files;
	_tmp3_ = _tmp2_->data;
	if (((GFile*) _tmp3_) == NULL) {
		_tmp1_ = TRUE;
	} else {
		GFile* _tmp4_;
		_tmp4_ = self->destination;
		_tmp1_ = _tmp4_ == NULL;
	}
	if (_tmp1_) {
		return;
	}
	_tmp5_ = self->files;
	_tmp6_ = _tmp5_->data;
	_tmp7_ = files_file_utils_custom_basename_from_file ((GFile*) _tmp6_);
	srcname = _tmp7_;
	_tmp8_ = self->destination;
	_tmp9_ = files_file_utils_custom_basename_from_file (_tmp8_);
	destname = _tmp9_;
	transfer_info->last_report_time = (guint64) now;
	files_left = source_info->num_files - transfer_info->num_files;
	if (files_left < 0) {
		_g_free0 (destname);
		_g_free0 (srcname);
		return;
	}
	if (files_left != transfer_info->last_reported_files_left) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = transfer_info->last_reported_files_left == 0;
	}
	if (_tmp10_) {
		gchar* s = NULL;
		PFProgressInfo* _tmp34_;
		gchar* _tmp35_;
		transfer_info->last_reported_files_left = files_left;
		if (source_info->num_files == 1) {
			GFile* _tmp11_;
			_tmp11_ = self->destination;
			if (_tmp11_ != NULL) {
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				if (self->is_move) {
					_tmp12_ = _ ("Moving \"%s\" to \"%s\"");
				} else {
					_tmp12_ = _ ("Copying \"%s\" to \"%s\"");
				}
				_tmp13_ = srcname;
				_tmp14_ = destname;
				_tmp15_ = g_strdup_printf (_tmp12_, _tmp13_, _tmp14_);
				_g_free0 (s);
				s = _tmp15_;
			} else {
				const gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp16_ = srcname;
				_tmp17_ = g_strdup_printf (_ ("Duplicating \"%s\""), _tmp16_);
				_g_free0 (s);
				s = _tmp17_;
			}
		} else {
			gboolean _tmp18_ = FALSE;
			GList* _tmp19_;
			_tmp19_ = self->files;
			if (_tmp19_ != NULL) {
				GList* _tmp20_;
				GList* _tmp21_;
				_tmp20_ = self->files;
				_tmp21_ = _tmp20_->next;
				_tmp18_ = _tmp21_ == NULL;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				GFile* _tmp22_;
				_tmp22_ = self->destination;
				if (_tmp22_ != NULL) {
					const gchar* _tmp23_ = NULL;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					if (self->is_move) {
						_tmp23_ = ngettext ("Moving %'d file (in \"%s\") to \"%s\"", "Moving %'d files (in \"%s\") to \"%s\"", (gulong) files_left);
					} else {
						_tmp23_ = ngettext ("Copying %'d file (in \"%s\") to \"%s\"", "Copying %'d files (in \"%s\") to \"%s\"", (gulong) files_left);
					}
					_tmp24_ = srcname;
					_tmp25_ = destname;
					_tmp26_ = g_strdup_printf (_tmp23_, files_left, _tmp24_, _tmp25_);
					_g_free0 (s);
					s = _tmp26_;
				} else {
					const gchar* _tmp27_;
					gchar* _tmp28_;
					_tmp27_ = destname;
					_tmp28_ = g_strdup_printf (ngettext ("Duplicating %'d file (in \"%s\")", "Duplicating %'d files (in \"%s\")", (gulong) files_left), files_left, _tmp27_);
					_g_free0 (s);
					s = _tmp28_;
				}
			} else {
				GFile* _tmp29_;
				_tmp29_ = self->destination;
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_ = NULL;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					if (self->is_move) {
						_tmp30_ = ngettext ("Moving %'d file to \"%s\"", "Moving %'d files to \"%s\"", (gulong) files_left);
					} else {
						_tmp30_ = ngettext ("Copying %'d file to \"%s\"", "Copying %'d files to \"%s\"", (gulong) files_left);
					}
					_tmp31_ = destname;
					_tmp32_ = g_strdup_printf (_tmp30_, files_left, _tmp31_);
					_g_free0 (s);
					s = _tmp32_;
				} else {
					gchar* _tmp33_;
					_tmp33_ = g_strdup_printf (ngettext ("Duplicating %'d file", "Duplicating %'d files", (gulong) files_left), files_left);
					_g_free0 (s);
					s = _tmp33_;
				}
			}
		}
		_tmp34_ = ((FilesFileOperationsCommonJob*) self)->progress;
		_tmp35_ = s;
		s = NULL;
		pf_progress_info_take_status (_tmp34_, _tmp35_);
		_g_free0 (s);
	}
	total_size = MAX (source_info->num_bytes, transfer_info->num_bytes);
	_tmp36_ = ((FilesFileOperationsCommonJob*) self)->time;
	elapsed = g_timer_elapsed (_tmp36_, NULL);
	transfer_rate = (gdouble) 0;
	if (elapsed > ((gdouble) 0)) {
		transfer_rate = transfer_info->num_bytes / elapsed;
	}
	if (elapsed < ((gdouble) MARLIN_FILE_OPERATIONS_COMMON_JOB_SECONDS_NEEDED_FOR_RELIABLE_TRANSFER_RATE)) {
		_tmp37_ = transfer_rate > ((gdouble) 0);
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		gchar* num_bytes_format = NULL;
		gchar* _tmp38_;
		gchar* total_size_format = NULL;
		gchar* _tmp39_;
		PFProgressInfo* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		_tmp38_ = g_format_size_full ((guint64) transfer_info->num_bytes, G_FORMAT_SIZE_DEFAULT);
		num_bytes_format = _tmp38_;
		_tmp39_ = g_format_size_full ((guint64) total_size, G_FORMAT_SIZE_DEFAULT);
		total_size_format = _tmp39_;
		_tmp40_ = ((FilesFileOperationsCommonJob*) self)->progress;
		_tmp41_ = num_bytes_format;
		_tmp42_ = total_size_format;
		_tmp43_ = g_strdup_printf (_ ("%s of %s"), _tmp41_, _tmp42_);
		pf_progress_info_take_details (_tmp40_, _tmp43_);
		_g_free0 (total_size_format);
		_g_free0 (num_bytes_format);
	} else {
		gchar* num_bytes_format = NULL;
		gchar* _tmp44_;
		gchar* total_size_format = NULL;
		gchar* _tmp45_;
		gchar* transfer_rate_format = NULL;
		gchar* _tmp46_;
		gint remaining_time = 0;
		gint formated_time_unit = 0;
		gchar* formated_remaining_time = NULL;
		gint _tmp47_ = 0;
		gchar* _tmp48_;
		gchar* s = NULL;
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		PFProgressInfo* _tmp54_;
		gchar* _tmp55_;
		_tmp44_ = g_format_size_full ((guint64) transfer_info->num_bytes, G_FORMAT_SIZE_DEFAULT);
		num_bytes_format = _tmp44_;
		_tmp45_ = g_format_size_full ((guint64) total_size, G_FORMAT_SIZE_DEFAULT);
		total_size_format = _tmp45_;
		_tmp46_ = g_format_size_full ((guint64) transfer_rate, G_FORMAT_SIZE_DEFAULT);
		transfer_rate_format = _tmp46_;
		remaining_time = (gint) ((total_size - transfer_info->num_bytes) / transfer_rate);
		_tmp48_ = files_file_utils_format_time (remaining_time, &_tmp47_);
		formated_time_unit = _tmp47_;
		formated_remaining_time = _tmp48_;
		_tmp49_ = num_bytes_format;
		_tmp50_ = total_size_format;
		_tmp51_ = formated_remaining_time;
		_tmp52_ = transfer_rate_format;
		_tmp53_ = g_strdup_printf (ngettext ("%s of %s \xE2\x80\x94 %s left (%s/sec)", "%s of %s \xE2\x80\x94 %s left (%s/sec)", (gulong) formated_time_unit), _tmp49_, _tmp50_, _tmp51_, _tmp52_);
		s = _tmp53_;
		_tmp54_ = ((FilesFileOperationsCommonJob*) self)->progress;
		_tmp55_ = s;
		s = NULL;
		pf_progress_info_take_details (_tmp54_, _tmp55_);
		_g_free0 (s);
		_g_free0 (formated_remaining_time);
		_g_free0 (transfer_rate_format);
		_g_free0 (total_size_format);
		_g_free0 (num_bytes_format);
	}
	_tmp56_ = ((FilesFileOperationsCommonJob*) self)->progress;
	pf_progress_info_update_progress (_tmp56_, (gdouble) transfer_info->num_bytes, (gdouble) total_size);
	_g_free0 (destname);
	_g_free0 (srcname);
}

void
marlin_file_operations_copy_move_job_report_move_progress (FilesFileOperationsCopyMoveJob* self,
                                                           gint total,
                                                           gint left)
{
	gchar* dest_basename = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* s = NULL;
	gchar* _tmp2_;
	PFProgressInfo* _tmp3_;
	gchar* _tmp4_;
	PFProgressInfo* _tmp5_;
	gchar* _tmp6_;
	PFProgressInfo* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->destination;
	_tmp1_ = files_file_utils_custom_basename_from_file (_tmp0_);
	dest_basename = _tmp1_;
	_tmp2_ = g_strdup_printf (_ ("Preparing to move to \"%s\""), dest_basename);
	s = _tmp2_;
	_tmp3_ = ((FilesFileOperationsCommonJob*) self)->progress;
	_tmp4_ = g_strdup (s);
	pf_progress_info_take_status (_tmp3_, _tmp4_);
	_tmp5_ = ((FilesFileOperationsCommonJob*) self)->progress;
	_tmp6_ = g_strdup_printf (ngettext ("Preparing to move %'d file", "Preparing to move %'d files", (gulong) left), left);
	pf_progress_info_take_details (_tmp5_, _tmp6_);
	_tmp7_ = ((FilesFileOperationsCommonJob*) self)->progress;
	pf_progress_info_pulse_progress (_tmp7_);
	_g_free0 (s);
	_g_free0 (dest_basename);
}

static void
marlin_file_operations_copy_move_job_class_init (FilesFileOperationsCopyMoveJobClass * klass,
                                                 gpointer klass_data)
{
	marlin_file_operations_copy_move_job_parent_class = g_type_class_peek_parent (klass);
	((FilesFileOperationsCommonJobClass *) klass)->finalize = marlin_file_operations_copy_move_job_finalize;
	((FilesFileOperationsCommonJobClass *) klass)->get_scan_primary = (const gchar* (*) (FilesFileOperationsCommonJob*)) marlin_file_operations_copy_move_job_real_get_scan_primary;
	((FilesFileOperationsCommonJobClass *) klass)->report_count_progress = (void (*) (FilesFileOperationsCommonJob*, SourceInfo*)) marlin_file_operations_copy_move_job_real_report_count_progress;
}

static void
marlin_file_operations_copy_move_job_instance_init (FilesFileOperationsCopyMoveJob * self,
                                                    gpointer klass)
{
	GHashTable* _tmp0_;
	self->is_move = FALSE;
	_tmp0_ = g_hash_table_new_full (_g_file_hash_ghash_func, _g_file_equal_gequal_func, _g_object_unref0_, NULL);
	self->debuting_files = _tmp0_;
	self->replace_all = FALSE;
	self->merge_all = FALSE;
	self->keep_all_newest = FALSE;
	self->skip_all_conflict = FALSE;
}

static void
marlin_file_operations_copy_move_job_finalize (FilesFileOperationsCommonJob * obj)
{
	FilesFileOperationsCopyMoveJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MARLIN_FILE_OPERATIONS_TYPE_COPY_MOVE_JOB, FilesFileOperationsCopyMoveJob);
	files_file_changes_consume_changes (TRUE);
	(self->files == NULL) ? NULL : (self->files = (_g_list_free__g_object_unref0_ (self->files), NULL));
	_g_object_unref0 (self->destination);
	_g_hash_table_unref0 (self->debuting_files);
	MARLIN_FILE_OPERATIONS_COMMON_JOB_CLASS (marlin_file_operations_copy_move_job_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
marlin_file_operations_copy_move_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesFileOperationsCopyMoveJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) marlin_file_operations_copy_move_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesFileOperationsCopyMoveJob), 0, (GInstanceInitFunc) marlin_file_operations_copy_move_job_instance_init, NULL };
	GType marlin_file_operations_copy_move_job_type_id;
	marlin_file_operations_copy_move_job_type_id = g_type_register_static (MARLIN_FILE_OPERATIONS_TYPE_COMMON_JOB, "FilesFileOperationsCopyMoveJob", &g_define_type_info, 0);
	return marlin_file_operations_copy_move_job_type_id;
}

GType
marlin_file_operations_copy_move_job_get_type (void)
{
	static volatile gsize marlin_file_operations_copy_move_job_type_id__once = 0;
	if (g_once_init_enter (&marlin_file_operations_copy_move_job_type_id__once)) {
		GType marlin_file_operations_copy_move_job_type_id;
		marlin_file_operations_copy_move_job_type_id = marlin_file_operations_copy_move_job_get_type_once ();
		g_once_init_leave (&marlin_file_operations_copy_move_job_type_id__once, marlin_file_operations_copy_move_job_type_id);
	}
	return marlin_file_operations_copy_move_job_type_id__once;
}

