/* AppMenu.c generated by valac 0.56.18, the Vala compiler
 * generated from AppMenu.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0
 * SPDX-FileCopyrightText: 2020-2023 elementary, Inc. (https://elementary.io)
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "pantheon-files-core.h"
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_TYPE_APP_MENU (files_app_menu_get_type ())
#define FILES_APP_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_APP_MENU, FilesAppMenu))
#define FILES_APP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_APP_MENU, FilesAppMenuClass))
#define FILES_IS_APP_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_APP_MENU))
#define FILES_IS_APP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_APP_MENU))
#define FILES_APP_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_APP_MENU, FilesAppMenuClass))

typedef struct _FilesAppMenu FilesAppMenu;
typedef struct _FilesAppMenuClass FilesAppMenuClass;
typedef struct _FilesAppMenuPrivate FilesAppMenuPrivate;
enum  {
	FILES_APP_MENU_0_PROPERTY,
	FILES_APP_MENU_NUM_PROPERTIES
};
static GParamSpec* files_app_menu_properties[FILES_APP_MENU_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _FilesAppMenu {
	GtkPopover parent_instance;
	FilesAppMenuPrivate * priv;
};

struct _FilesAppMenuClass {
	GtkPopoverClass parent_class;
};

struct _FilesAppMenuPrivate {
	GtkButton* redo_button;
	GtkButton* undo_button;
	GtkButton* zoom_default_button;
	GtkButton* zoom_in_button;
	GtkButton* zoom_out_button;
	gchar** redo_accels;
	gint redo_accels_length1;
	gint _redo_accels_size_;
	gchar** undo_accels;
	gint undo_accels_length1;
	gint _undo_accels_size_;
	FilesUndoManager* undo_manager;
};

static gint FilesAppMenu_private_offset;
static gpointer files_app_menu_parent_class = NULL;
VALA_EXTERN GSettings* files_icon_view_settings;
VALA_EXTERN GSettings* files_list_view_settings;
VALA_EXTERN GSettings* files_column_view_settings;

VALA_EXTERN GType files_app_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesAppMenu, g_object_unref)
static void files_app_menu_set_undo_redo_tooltips (FilesAppMenu* self);
VALA_EXTERN void files_app_menu_on_zoom_setting_changed (FilesAppMenu* self,
                                             GSettings* settings,
                                             const gchar* key);
VALA_EXTERN FilesAppMenu* files_app_menu_new (void);
VALA_EXTERN FilesAppMenu* files_app_menu_construct (GType object_type);
static GObject * files_app_menu_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static GVariant* _variant_new18 (const gchar* value);
static GVariant* _variant_new19 (const gchar* value);
static GVariant* _variant_new20 (const gchar* value);
static void _files_app_menu_set_undo_redo_tooltips_files_undo_manager_request_menu_update (FilesUndoManager* _sender,
                                                                                    gpointer self);
static void _files_app_menu_on_zoom_setting_changed_g_settings_changed (GSettings* _sender,
                                                                 const gchar* key,
                                                                 gpointer self);
static void files_app_menu_finalize (GObject * obj);
static GType files_app_menu_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
files_app_menu_get_instance_private (FilesAppMenu* self)
{
	return G_STRUCT_MEMBER_P (self, FilesAppMenu_private_offset);
}

static void
files_app_menu_set_undo_redo_tooltips (FilesAppMenu* self)
{
	const gchar* undo_action_s = NULL;
	FilesUndoManager* _tmp0_;
	const gchar* _tmp1_;
	const gchar* redo_action_s = NULL;
	FilesUndoManager* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_;
	GtkButton* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_;
	GtkButton* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_manager;
	_tmp1_ = files_undo_manager_get_next_undo_description (_tmp0_);
	undo_action_s = _tmp1_;
	_tmp2_ = self->priv->undo_manager;
	_tmp3_ = files_undo_manager_get_next_redo_description (_tmp2_);
	redo_action_s = _tmp3_;
	_tmp5_ = undo_action_s;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = undo_action_s;
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = _ ("No operation to undo");
	}
	_tmp7_ = self->priv->undo_button;
	_tmp8_ = self->priv->undo_accels;
	_tmp8__length1 = self->priv->undo_accels_length1;
	_tmp9_ = granite_markup_accel_tooltip (_tmp8_, (gint) _tmp8__length1, _tmp4_);
	_tmp10_ = _tmp9_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp7_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp12_ = redo_action_s;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		_tmp13_ = redo_action_s;
		_tmp11_ = _tmp13_;
	} else {
		_tmp11_ = _ ("No operation to redo");
	}
	_tmp14_ = self->priv->redo_button;
	_tmp15_ = self->priv->redo_accels;
	_tmp15__length1 = self->priv->redo_accels_length1;
	_tmp16_ = granite_markup_accel_tooltip (_tmp15_, (gint) _tmp15__length1, _tmp11_);
	_tmp17_ = _tmp16_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp14_, _tmp17_);
	_g_free0 (_tmp17_);
}

void
files_app_menu_on_zoom_setting_changed (FilesAppMenu* self,
                                        GSettings* settings,
                                        const gchar* key)
{
	FilesZoomLevel default_zoom = 0;
	FilesZoomLevel zoom_level = 0;
	GtkButton* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint max_zoom = 0;
	gint min_zoom = 0;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	if (settings == NULL) {
		GtkButton* _tmp0_;
		g_critical ("AppMenu.vala:165: Zoom string from settinggs: Null settings");
		_tmp0_ = self->priv->zoom_default_button;
		gtk_button_set_label (_tmp0_, "");
		return;
	}
	default_zoom = (FilesZoomLevel) g_settings_get_enum (settings, "default-zoom-level");
	zoom_level = (FilesZoomLevel) g_settings_get_enum (settings, "zoom-level");
	_tmp1_ = self->priv->zoom_default_button;
	_tmp2_ = g_strdup_printf ("%.0f%%", (((gdouble) files_zoom_level_to_icon_size (zoom_level)) / ((gdouble) files_zoom_level_to_icon_size (default_zoom))) * 100);
	_tmp3_ = _tmp2_;
	gtk_button_set_label (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	max_zoom = g_settings_get_enum (settings, "maximum-zoom-level");
	min_zoom = g_settings_get_enum (settings, "minimum-zoom-level");
	_tmp4_ = self->priv->zoom_in_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, zoom_level < max_zoom);
	_tmp5_ = self->priv->zoom_out_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, zoom_level > min_zoom);
}

FilesAppMenu*
files_app_menu_construct (GType object_type)
{
	FilesAppMenu * self = NULL;
	self = (FilesAppMenu*) g_object_new (object_type, NULL);
	return self;
}

FilesAppMenu*
files_app_menu_new (void)
{
	return files_app_menu_construct (FILES_TYPE_APP_MENU);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GVariant*
_variant_new18 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new19 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new20 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
_files_app_menu_set_undo_redo_tooltips_files_undo_manager_request_menu_update (FilesUndoManager* _sender,
                                                                               gpointer self)
{
	files_app_menu_set_undo_redo_tooltips ((FilesAppMenu*) self);
}

static void
_files_app_menu_on_zoom_setting_changed_g_settings_changed (GSettings* _sender,
                                                            const gchar* key,
                                                            gpointer self)
{
	files_app_menu_on_zoom_setting_changed ((FilesAppMenu*) self, _sender, key);
}

static GObject *
files_app_menu_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesAppMenu * self;
	GtkApplication* app_instance = NULL;
	GApplication* _tmp0_;
	GtkApplication* _tmp1_;
	gchar* _tmp2_;
	GVariant* _tmp3_;
	GtkButton* _tmp4_ = NULL;
	GtkButton* _tmp5_;
	GtkApplication* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GVariant* _tmp13_;
	GtkButton* _tmp14_ = NULL;
	GtkButton* _tmp15_;
	GtkApplication* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GVariant* _tmp23_;
	GtkButton* _tmp24_ = NULL;
	GtkButton* _tmp25_;
	GtkApplication* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GtkBox* icon_size_box = NULL;
	GtkBox* _tmp32_ = NULL;
	GtkBox* _tmp33_;
	GtkStyleContext* _tmp34_;
	GtkBox* _tmp35_;
	GtkButton* _tmp36_;
	GtkBox* _tmp37_;
	GtkButton* _tmp38_;
	GtkBox* _tmp39_;
	GtkButton* _tmp40_;
	GtkBox* undo_redo_box = NULL;
	GtkBox* _tmp41_ = NULL;
	GtkBox* _tmp42_;
	GtkStyleContext* _tmp43_;
	gchar* _tmp44_;
	GtkButton* _tmp45_ = NULL;
	gchar* _tmp46_;
	GtkButton* _tmp47_ = NULL;
	GtkBox* _tmp48_;
	GtkButton* _tmp49_;
	GtkBox* _tmp50_;
	GtkButton* _tmp51_;
	GtkApplication* _tmp52_;
	gchar** _tmp53_;
	gchar** _tmp54_;
	GtkApplication* _tmp55_;
	gchar** _tmp56_;
	gchar** _tmp57_;
	GraniteSwitchModelButton* double_click_button = NULL;
	gchar* _tmp58_;
	gchar* _tmp59_;
	GraniteSwitchModelButton* _tmp60_ = NULL;
	GraniteSwitchModelButton* folders_before_files = NULL;
	gchar* _tmp61_;
	GraniteSwitchModelButton* _tmp62_ = NULL;
	GraniteSwitchModelButton* restore_tabs = NULL;
	gchar* _tmp63_;
	GraniteSwitchModelButton* _tmp64_ = NULL;
	GraniteHeaderLabel* show_header = NULL;
	GraniteHeaderLabel* _tmp65_;
	GtkCheckButton* show_hidden_button = NULL;
	gchar* _tmp66_;
	GtkCheckButton* _tmp67_ = NULL;
	GtkCheckButton* _tmp68_;
	GtkStyleContext* _tmp69_;
	GtkCheckButton* _tmp70_;
	GraniteAccelLabel* _tmp71_;
	GraniteAccelLabel* _tmp72_;
	GtkCheckButton* show_local_thumbnails = NULL;
	gchar* _tmp73_;
	GtkCheckButton* _tmp74_ = NULL;
	GtkCheckButton* _tmp75_;
	GtkStyleContext* _tmp76_;
	GtkCheckButton* show_remote_thumbnails = NULL;
	gchar* _tmp77_;
	GtkCheckButton* _tmp78_ = NULL;
	GtkCheckButton* _tmp79_;
	GtkStyleContext* _tmp80_;
	GtkBox* menu_box = NULL;
	GtkBox* _tmp81_ = NULL;
	GtkBox* _tmp82_;
	GtkBox* _tmp83_;
	GtkBox* _tmp84_;
	GtkBox* _tmp85_;
	GtkBox* _tmp86_;
	GtkSeparator* _tmp87_ = NULL;
	GtkSeparator* _tmp88_;
	GtkBox* _tmp89_;
	GraniteSwitchModelButton* _tmp90_;
	GtkBox* _tmp91_;
	GraniteSwitchModelButton* _tmp92_;
	GtkBox* _tmp93_;
	GraniteSwitchModelButton* _tmp94_;
	GtkBox* _tmp95_;
	GtkSeparator* _tmp96_ = NULL;
	GtkSeparator* _tmp97_;
	GtkBox* _tmp98_;
	GraniteHeaderLabel* _tmp99_;
	GtkBox* _tmp100_;
	GtkCheckButton* _tmp101_;
	GtkBox* _tmp102_;
	GtkCheckButton* _tmp103_;
	GtkBox* _tmp104_;
	GtkCheckButton* _tmp105_;
	GtkBox* _tmp106_;
	GtkBox* _tmp107_;
	FilesUndoManager* _tmp108_;
	FilesUndoManager* _tmp109_;
	GSettings* _tmp110_;
	GSettings* _tmp111_;
	GSettings* _tmp112_;
	parent_class = G_OBJECT_CLASS (files_app_menu_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_APP_MENU, FilesAppMenu);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	app_instance = _tmp1_;
	_tmp2_ = g_strdup ("win.zoom");
	_tmp3_ = _variant_new18 ("ZOOM_OUT");
	_tmp4_ = (GtkButton*) gtk_button_new_from_icon_name ("zoom-out-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp4_, _tmp2_);
	_g_free0 (_tmp2_);
	g_object_set ((GtkActionable*) _tmp4_, "action-target", _tmp3_, NULL);
	_g_variant_unref0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->zoom_out_button);
	self->priv->zoom_out_button = _tmp4_;
	_tmp5_ = self->priv->zoom_out_button;
	_tmp6_ = app_instance;
	_tmp8_ = _tmp7_ = gtk_application_get_accels_for_action (_tmp6_, "win.zoom::ZOOM_OUT");
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _vala_array_length (_tmp7_);
	_tmp10_ = granite_markup_accel_tooltip (_tmp9_, (gint) _vala_array_length (_tmp7_), _ ("Zoom Out"));
	_tmp11_ = _tmp10_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp5_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = g_strdup ("win.zoom");
	_tmp13_ = _variant_new19 ("ZOOM_NORMAL");
	_tmp14_ = (GtkButton*) gtk_button_new_with_label ("100%");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp14_, _tmp12_);
	_g_free0 (_tmp12_);
	g_object_set ((GtkActionable*) _tmp14_, "action-target", _tmp13_, NULL);
	_g_variant_unref0 (_tmp13_);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->zoom_default_button);
	self->priv->zoom_default_button = _tmp14_;
	_tmp15_ = self->priv->zoom_default_button;
	_tmp16_ = app_instance;
	_tmp18_ = _tmp17_ = gtk_application_get_accels_for_action (_tmp16_, "win.zoom::ZOOM_NORMAL");
	_tmp19_ = _tmp18_;
	_tmp19__length1 = _vala_array_length (_tmp17_);
	_tmp20_ = granite_markup_accel_tooltip (_tmp19_, (gint) _vala_array_length (_tmp17_), _ ("Zoom 1:1"));
	_tmp21_ = _tmp20_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp15_, _tmp21_);
	_g_free0 (_tmp21_);
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
	_tmp22_ = g_strdup ("win.zoom");
	_tmp23_ = _variant_new20 ("ZOOM_IN");
	_tmp24_ = (GtkButton*) gtk_button_new_from_icon_name ("zoom-in-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp24_, _tmp22_);
	_g_free0 (_tmp22_);
	g_object_set ((GtkActionable*) _tmp24_, "action-target", _tmp23_, NULL);
	_g_variant_unref0 (_tmp23_);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->zoom_in_button);
	self->priv->zoom_in_button = _tmp24_;
	_tmp25_ = self->priv->zoom_in_button;
	_tmp26_ = app_instance;
	_tmp28_ = _tmp27_ = gtk_application_get_accels_for_action (_tmp26_, "win.zoom::ZOOM_IN");
	_tmp29_ = _tmp28_;
	_tmp29__length1 = _vala_array_length (_tmp27_);
	_tmp30_ = granite_markup_accel_tooltip (_tmp29_, (gint) _vala_array_length (_tmp27_), _ ("Zoom In"));
	_tmp31_ = _tmp30_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp25_, _tmp31_);
	_g_free0 (_tmp31_);
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
	_tmp32_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_set_homogeneous (_tmp32_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp32_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp32_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp32_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp32_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp32_, 12);
	g_object_ref_sink (_tmp32_);
	icon_size_box = _tmp32_;
	_tmp33_ = icon_size_box;
	_tmp34_ = gtk_widget_get_style_context ((GtkWidget*) _tmp33_);
	gtk_style_context_add_class (_tmp34_, GTK_STYLE_CLASS_LINKED);
	_tmp35_ = icon_size_box;
	_tmp36_ = self->priv->zoom_out_button;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = icon_size_box;
	_tmp38_ = self->priv->zoom_default_button;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = icon_size_box;
	_tmp40_ = self->priv->zoom_in_button;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_set_homogeneous (_tmp41_, TRUE);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp41_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp41_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp41_, 12);
	g_object_ref_sink (_tmp41_);
	undo_redo_box = _tmp41_;
	_tmp42_ = undo_redo_box;
	_tmp43_ = gtk_widget_get_style_context ((GtkWidget*) _tmp42_);
	gtk_style_context_add_class (_tmp43_, GTK_STYLE_CLASS_LINKED);
	_tmp44_ = g_strdup ("win.undo");
	_tmp45_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp45_, _tmp44_);
	_g_free0 (_tmp44_);
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->undo_button);
	self->priv->undo_button = _tmp45_;
	_tmp46_ = g_strdup ("win.redo");
	_tmp47_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-redo-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp47_, _tmp46_);
	_g_free0 (_tmp46_);
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->priv->redo_button);
	self->priv->redo_button = _tmp47_;
	_tmp48_ = undo_redo_box;
	_tmp49_ = self->priv->undo_button;
	gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = undo_redo_box;
	_tmp51_ = self->priv->redo_button;
	gtk_container_add ((GtkContainer*) _tmp50_, (GtkWidget*) _tmp51_);
	_tmp52_ = app_instance;
	_tmp54_ = _tmp53_ = gtk_application_get_accels_for_action (_tmp52_, "win.undo");
	self->priv->undo_accels = (_vala_array_free (self->priv->undo_accels, self->priv->undo_accels_length1, (GDestroyNotify) g_free), NULL);
	self->priv->undo_accels = _tmp54_;
	self->priv->undo_accels_length1 = _vala_array_length (_tmp53_);
	self->priv->_undo_accels_size_ = self->priv->undo_accels_length1;
	_tmp55_ = app_instance;
	_tmp57_ = _tmp56_ = gtk_application_get_accels_for_action (_tmp55_, "win.redo");
	self->priv->redo_accels = (_vala_array_free (self->priv->redo_accels, self->priv->redo_accels_length1, (GDestroyNotify) g_free), NULL);
	self->priv->redo_accels = _tmp57_;
	self->priv->redo_accels_length1 = _vala_array_length (_tmp56_);
	self->priv->_redo_accels_size_ = self->priv->redo_accels_length1;
	_tmp58_ = g_strdup (_ ("Double-click on a folder opens it, single-click selects it"));
	_tmp59_ = g_strdup ("win.singleclick-select");
	_tmp60_ = granite_switch_model_button_new (_ ("Double-click to Navigate"));
	granite_switch_model_button_set_description (_tmp60_, _tmp58_);
	_g_free0 (_tmp58_);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp60_, _tmp59_);
	_g_free0 (_tmp59_);
	g_object_ref_sink (_tmp60_);
	double_click_button = _tmp60_;
	_tmp61_ = g_strdup ("win.folders-before-files");
	_tmp62_ = granite_switch_model_button_new (_ ("Sort Folders before Files"));
	gtk_actionable_set_action_name ((GtkActionable*) _tmp62_, _tmp61_);
	_g_free0 (_tmp61_);
	g_object_ref_sink (_tmp62_);
	folders_before_files = _tmp62_;
	_tmp63_ = g_strdup ("win.restore-tabs-on-startup");
	_tmp64_ = granite_switch_model_button_new (_ ("Restore Tabs from Last Time"));
	gtk_actionable_set_action_name ((GtkActionable*) _tmp64_, _tmp63_);
	_g_free0 (_tmp63_);
	g_object_ref_sink (_tmp64_);
	restore_tabs = _tmp64_;
	_tmp65_ = granite_header_label_new (_ ("Show in View"));
	g_object_ref_sink (_tmp65_);
	show_header = _tmp65_;
	_tmp66_ = g_strdup ("win.show-hidden");
	_tmp67_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp67_, _tmp66_);
	_g_free0 (_tmp66_);
	g_object_ref_sink (_tmp67_);
	show_hidden_button = _tmp67_;
	_tmp68_ = show_hidden_button;
	_tmp69_ = gtk_widget_get_style_context ((GtkWidget*) _tmp68_);
	gtk_style_context_add_class (_tmp69_, GTK_STYLE_CLASS_MENUITEM);
	_tmp70_ = show_hidden_button;
	_tmp71_ = granite_accel_label_new (_ ("Hidden Files"), "<Ctrl>h");
	g_object_ref_sink (_tmp71_);
	_tmp72_ = _tmp71_;
	gtk_container_add ((GtkContainer*) _tmp70_, (GtkWidget*) _tmp72_);
	_g_object_unref0 (_tmp72_);
	_tmp73_ = g_strdup ("win.show-local-thumbnails");
	_tmp74_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Local Thumbnails"));
	gtk_actionable_set_action_name ((GtkActionable*) _tmp74_, _tmp73_);
	_g_free0 (_tmp73_);
	g_object_ref_sink (_tmp74_);
	show_local_thumbnails = _tmp74_;
	_tmp75_ = show_local_thumbnails;
	_tmp76_ = gtk_widget_get_style_context ((GtkWidget*) _tmp75_);
	gtk_style_context_add_class (_tmp76_, GTK_STYLE_CLASS_MENUITEM);
	_tmp77_ = g_strdup ("win.show-remote-thumbnails");
	_tmp78_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Remote Thumbnails"));
	gtk_actionable_set_action_name ((GtkActionable*) _tmp78_, _tmp77_);
	_g_free0 (_tmp77_);
	g_object_ref_sink (_tmp78_);
	show_remote_thumbnails = _tmp78_;
	_tmp79_ = show_remote_thumbnails;
	_tmp80_ = gtk_widget_get_style_context ((GtkWidget*) _tmp79_);
	gtk_style_context_add_class (_tmp80_, GTK_STYLE_CLASS_MENUITEM);
	_tmp81_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp81_, 6);
	g_object_ref_sink (_tmp81_);
	menu_box = _tmp81_;
	_tmp82_ = menu_box;
	_tmp83_ = icon_size_box;
	gtk_container_add ((GtkContainer*) _tmp82_, (GtkWidget*) _tmp83_);
	_tmp84_ = menu_box;
	_tmp85_ = undo_redo_box;
	gtk_container_add ((GtkContainer*) _tmp84_, (GtkWidget*) _tmp85_);
	_tmp86_ = menu_box;
	_tmp87_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp87_, 3);
	g_object_ref_sink (_tmp87_);
	_tmp88_ = _tmp87_;
	gtk_container_add ((GtkContainer*) _tmp86_, (GtkWidget*) _tmp88_);
	_g_object_unref0 (_tmp88_);
	_tmp89_ = menu_box;
	_tmp90_ = double_click_button;
	gtk_container_add ((GtkContainer*) _tmp89_, (GtkWidget*) _tmp90_);
	_tmp91_ = menu_box;
	_tmp92_ = folders_before_files;
	gtk_container_add ((GtkContainer*) _tmp91_, (GtkWidget*) _tmp92_);
	_tmp93_ = menu_box;
	_tmp94_ = restore_tabs;
	gtk_container_add ((GtkContainer*) _tmp93_, (GtkWidget*) _tmp94_);
	_tmp95_ = menu_box;
	_tmp96_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp96_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp96_, 3);
	g_object_ref_sink (_tmp96_);
	_tmp97_ = _tmp96_;
	gtk_container_add ((GtkContainer*) _tmp95_, (GtkWidget*) _tmp97_);
	_g_object_unref0 (_tmp97_);
	_tmp98_ = menu_box;
	_tmp99_ = show_header;
	gtk_container_add ((GtkContainer*) _tmp98_, (GtkWidget*) _tmp99_);
	_tmp100_ = menu_box;
	_tmp101_ = show_hidden_button;
	gtk_container_add ((GtkContainer*) _tmp100_, (GtkWidget*) _tmp101_);
	_tmp102_ = menu_box;
	_tmp103_ = show_local_thumbnails;
	gtk_container_add ((GtkContainer*) _tmp102_, (GtkWidget*) _tmp103_);
	_tmp104_ = menu_box;
	_tmp105_ = show_remote_thumbnails;
	gtk_container_add ((GtkContainer*) _tmp104_, (GtkWidget*) _tmp105_);
	_tmp106_ = menu_box;
	gtk_widget_show_all ((GtkWidget*) _tmp106_);
	_tmp107_ = menu_box;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp107_, NULL);
	_tmp108_ = files_undo_manager_instance ();
	self->priv->undo_manager = _tmp108_;
	_tmp109_ = self->priv->undo_manager;
	g_signal_connect_object (_tmp109_, "request-menu-update", (GCallback) _files_app_menu_set_undo_redo_tooltips_files_undo_manager_request_menu_update, self, 0);
	files_app_menu_set_undo_redo_tooltips (self);
	_tmp110_ = files_icon_view_settings;
	g_signal_connect_object (_tmp110_, "changed::zoom-level", (GCallback) _files_app_menu_on_zoom_setting_changed_g_settings_changed, self, 0);
	_tmp111_ = files_list_view_settings;
	g_signal_connect_object (_tmp111_, "changed::zoom-level", (GCallback) _files_app_menu_on_zoom_setting_changed_g_settings_changed, self, 0);
	_tmp112_ = files_column_view_settings;
	g_signal_connect_object (_tmp112_, "changed::zoom-level", (GCallback) _files_app_menu_on_zoom_setting_changed_g_settings_changed, self, 0);
	_g_object_unref0 (menu_box);
	_g_object_unref0 (show_remote_thumbnails);
	_g_object_unref0 (show_local_thumbnails);
	_g_object_unref0 (show_hidden_button);
	_g_object_unref0 (show_header);
	_g_object_unref0 (restore_tabs);
	_g_object_unref0 (folders_before_files);
	_g_object_unref0 (double_click_button);
	_g_object_unref0 (undo_redo_box);
	_g_object_unref0 (icon_size_box);
	_g_object_unref0 (app_instance);
	return obj;
}

static void
files_app_menu_class_init (FilesAppMenuClass * klass,
                           gpointer klass_data)
{
	files_app_menu_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesAppMenu_private_offset);
	G_OBJECT_CLASS (klass)->constructor = files_app_menu_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_app_menu_finalize;
}

static void
files_app_menu_instance_init (FilesAppMenu * self,
                              gpointer klass)
{
	self->priv = files_app_menu_get_instance_private (self);
}

static void
files_app_menu_finalize (GObject * obj)
{
	FilesAppMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_APP_MENU, FilesAppMenu);
	_g_object_unref0 (self->priv->redo_button);
	_g_object_unref0 (self->priv->undo_button);
	_g_object_unref0 (self->priv->zoom_default_button);
	_g_object_unref0 (self->priv->zoom_in_button);
	_g_object_unref0 (self->priv->zoom_out_button);
	self->priv->redo_accels = (_vala_array_free (self->priv->redo_accels, self->priv->redo_accels_length1, (GDestroyNotify) g_free), NULL);
	self->priv->undo_accels = (_vala_array_free (self->priv->undo_accels, self->priv->undo_accels_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (files_app_menu_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_app_menu_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesAppMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_app_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesAppMenu), 0, (GInstanceInitFunc) files_app_menu_instance_init, NULL };
	GType files_app_menu_type_id;
	files_app_menu_type_id = g_type_register_static (gtk_popover_get_type (), "FilesAppMenu", &g_define_type_info, 0);
	FilesAppMenu_private_offset = g_type_add_instance_private (files_app_menu_type_id, sizeof (FilesAppMenuPrivate));
	return files_app_menu_type_id;
}

GType
files_app_menu_get_type (void)
{
	static volatile gsize files_app_menu_type_id__once = 0;
	if (g_once_init_enter (&files_app_menu_type_id__once)) {
		GType files_app_menu_type_id;
		files_app_menu_type_id = files_app_menu_get_type_once ();
		g_once_init_leave (&files_app_menu_type_id__once, files_app_menu_type_id);
	}
	return files_app_menu_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

