/* Application.c generated by valac 0.56.18, the Vala compiler
 * generated from Application.vala, do not modify */

/**TODO** move the volume manager here? */

#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdio.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include "pantheon-files-core.h"
#include <gdk/gdk.h>
#include <unistd.h>
#include <handy.h>

#define FILES_APPLICATION_MARLIN_ACCEL_MAP_SAVE_DELAY 15
#define FILES_APPLICATION_MAX_WINDOWS ((guint) 25)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_TYPE_APPLICATION (files_application_get_type ())
#define FILES_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_APPLICATION, FilesApplication))
#define FILES_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_APPLICATION, FilesApplicationClass))
#define FILES_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_APPLICATION))
#define FILES_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_APPLICATION))
#define FILES_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_APPLICATION, FilesApplicationClass))

typedef struct _FilesApplication FilesApplication;
typedef struct _FilesApplicationClass FilesApplicationClass;
typedef struct _FilesApplicationPrivate FilesApplicationPrivate;

#define FILES_PROGRESS_TYPE_UI_HANDLER (files_progress_ui_handler_get_type ())
#define FILES_PROGRESS_UI_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_PROGRESS_TYPE_UI_HANDLER, FilesProgressUIHandler))
#define FILES_PROGRESS_UI_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_PROGRESS_TYPE_UI_HANDLER, FilesProgressUIHandlerClass))
#define FILES_PROGRESS_IS_UI_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_PROGRESS_TYPE_UI_HANDLER))
#define FILES_PROGRESS_IS_UI_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_PROGRESS_TYPE_UI_HANDLER))
#define FILES_PROGRESS_UI_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_PROGRESS_TYPE_UI_HANDLER, FilesProgressUIHandlerClass))

typedef struct _FilesProgressUIHandler FilesProgressUIHandler;
typedef struct _FilesProgressUIHandlerClass FilesProgressUIHandlerClass;

#define FILES_TYPE_CLIPBOARD_MANAGER (files_clipboard_manager_get_type ())
#define FILES_CLIPBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_CLIPBOARD_MANAGER, FilesClipboardManager))
#define FILES_CLIPBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_CLIPBOARD_MANAGER, FilesClipboardManagerClass))
#define FILES_IS_CLIPBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_CLIPBOARD_MANAGER))
#define FILES_IS_CLIPBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_CLIPBOARD_MANAGER))
#define FILES_CLIPBOARD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_CLIPBOARD_MANAGER, FilesClipboardManagerClass))

typedef struct _FilesClipboardManager FilesClipboardManager;
typedef struct _FilesClipboardManagerClass FilesClipboardManagerClass;
enum  {
	FILES_APPLICATION_0_PROPERTY,
	FILES_APPLICATION_GNOME_INTERFACE_SETTINGS_PROPERTY,
	FILES_APPLICATION_GNOME_PRIVACY_SETTINGS_PROPERTY,
	FILES_APPLICATION_GTK_FILE_CHOOSER_SETTINGS_PROPERTY,
	FILES_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* files_application_properties[FILES_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

#define FILES_VIEW_TYPE_WINDOW (files_view_window_get_type ())
#define FILES_VIEW_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_WINDOW, FilesViewWindow))
#define FILES_VIEW_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_WINDOW, FilesViewWindowClass))
#define FILES_VIEW_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_WINDOW))
#define FILES_VIEW_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_WINDOW))
#define FILES_VIEW_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_WINDOW, FilesViewWindowClass))

typedef struct _FilesViewWindow FilesViewWindow;
typedef struct _FilesViewWindowClass FilesViewWindowClass;
typedef struct _FilesViewWindowPrivate FilesViewWindowPrivate;
typedef struct _Block2Data Block2Data;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _FilesApplication {
	GtkApplication parent_instance;
	FilesApplicationPrivate * priv;
};

struct _FilesApplicationClass {
	GtkApplicationClass parent_class;
};

struct _FilesApplicationPrivate {
	GVolumeMonitor* volume_monitor;
	FilesProgressUIHandler* progress_handler;
	FilesClipboardManager* clipboard;
	GtkRecentManager* recent;
	GSettings* _gnome_interface_settings;
	GSettings* _gnome_privacy_settings;
	GSettings* _gtk_file_chooser_settings;
	gboolean quitting;
};

struct _Block1Data {
	int _ref_count_;
	FilesApplication* self;
	GraniteSettings* granite_settings;
	GtkSettings* gtk_settings;
};

struct _FilesViewWindow {
	HdyApplicationWindow parent_instance;
	FilesViewWindowPrivate * priv;
	GtkBuilder* ui;
	HdyHeaderBar* headerbar;
	FilesViewChromeViewSwitcher* view_switcher;
	HdyTabView* tab_view;
	HdyTabBar* tab_bar;
	FilesSidebarInterface* sidebar;
};

struct _FilesViewWindowClass {
	HdyApplicationWindowClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	FilesApplication* self;
	GFile* file;
};

VALA_EXTERN GSettings* files_app_settings;
GSettings* files_app_settings = NULL;
VALA_EXTERN GSettings* files_icon_view_settings;
GSettings* files_icon_view_settings = NULL;
VALA_EXTERN GSettings* files_list_view_settings;
GSettings* files_list_view_settings = NULL;
VALA_EXTERN GSettings* files_column_view_settings;
GSettings* files_column_view_settings = NULL;
static gint FilesApplication_private_offset;
static gpointer files_application_parent_class = NULL;

VALA_EXTERN GType files_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesApplication, g_object_unref)
VALA_EXTERN GType files_progress_ui_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesProgressUIHandler, g_object_unref)
VALA_EXTERN GType files_clipboard_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesClipboardManager, g_object_unref)
static gint files_application_real_handle_local_options (GApplication* base,
                                                  GVariantDict* options);
VALA_EXTERN gboolean files_is_admin (void);
static void files_application_real_startup (GApplication* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void files_application_init_schemas (FilesApplication* self);
static void __lambda15_ (FilesApplication* self);
static void ___lambda15__gtk_icon_theme_changed (GtkIconTheme* _sender,
                                          gpointer self);
VALA_EXTERN FilesProgressUIHandler* files_progress_ui_handler_new (void);
VALA_EXTERN FilesProgressUIHandler* files_progress_ui_handler_construct (GType object_type);
VALA_EXTERN FilesClipboardManager* files_clipboard_manager_get_for_display (GdkDisplay* display);
static void files_application_mount_removed_callback (FilesApplication* self,
                                               GVolumeMonitor* monitor,
                                               GMount* mount);
static void _files_application_mount_removed_callback_g_volume_monitor_mount_removed (GVolumeMonitor* _sender,
                                                                               GMount* mount,
                                                                               gpointer self);
static void __lambda210_ (Block1Data* _data1_);
VALA_EXTERN void files_emblem_renderer_clear_cache (void);
static void ___lambda210__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
VALA_EXTERN void files_application_quit (FilesApplication* self);
static void _files_application_quit_g_simple_action_activate (GSimpleAction* _sender,
                                                       GVariant* parameter,
                                                       gpointer self);
VALA_EXTERN FilesClipboardManager* files_application_get_clipboard_manager (FilesApplication* self);
VALA_EXTERN GtkRecentManager* files_application_get_recent_manager (FilesApplication* self);
static gint files_application_real_command_line (GApplication* base,
                                          GApplicationCommandLine* cmd);
VALA_EXTERN GType files_view_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewWindow, g_object_unref)
VALA_EXTERN FilesViewWindow* files_view_window_new (FilesApplication* _application);
VALA_EXTERN FilesViewWindow* files_view_window_construct (GType object_type,
                                              FilesApplication* _application);
VALA_EXTERN void files_view_window_open_tabs (FilesViewWindow* self,
                                  GFile** files,
                                  gint files_length1,
                                  FilesViewMode mode,
                                  gboolean ignore_duplicate,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void files_view_window_open_tabs_finish (FilesViewWindow* self,
                                         GAsyncResult* _res_);
static GFile** _vala_array_dup1 (GFile** self,
                          gssize length);
static void files_application_real_window_added (GtkApplication* base,
                                          GtkWindow* window);
static void files_application_real_quit_mainloop (GApplication* base);
static void __lambda211_ (FilesApplication* self,
                   GtkWindow* window);
VALA_EXTERN void files_view_window_quit (FilesViewWindow* self);
static void ___lambda211__gfunc (gconstpointer data,
                          gpointer self);
VALA_EXTERN void files_application_folder_deleted (FilesApplication* self,
                                       GFile* file);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda74_ (Block2Data* _data2_,
                  GtkWindow* window);
static void ___lambda74__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN void files_view_window_mount_removed (FilesViewWindow* self,
                                      GMount* mount);
VALA_EXTERN GSettings* files_application_get_gnome_interface_settings (FilesApplication* self);
VALA_EXTERN GSettings* files_application_get_gnome_privacy_settings (FilesApplication* self);
VALA_EXTERN GSettings* files_application_get_gtk_file_chooser_settings (FilesApplication* self);
VALA_EXTERN FilesApplication* files_application_new (void);
VALA_EXTERN FilesApplication* files_application_construct (GType object_type);
static void files_application_set_gnome_interface_settings (FilesApplication* self,
                                                     GSettings* value);
static void files_application_set_gnome_privacy_settings (FilesApplication* self,
                                                   GSettings* value);
static void files_application_set_gtk_file_chooser_settings (FilesApplication* self,
                                                      GSettings* value);
static GObject * files_application_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void files_application_finalize (GObject * obj);
static GType files_application_get_type_once (void);
static void _vala_files_application_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_files_application_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
files_application_get_instance_private (FilesApplication* self)
{
	return G_STRUCT_MEMBER_P (self, FilesApplication_private_offset);
}

static gint
files_application_real_handle_local_options (GApplication* base,
                                             GVariantDict* options)
{
	FilesApplication * self;
	gboolean _tmp1_ = FALSE;
	gboolean remote = FALSE;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp17_ = FALSE;
	GError* _inner_error0_ = NULL;
	gint result;
	self = (FilesApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "io.elementary.files %s\n", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	if (files_is_admin ()) {
		const gchar* _tmp2_;
		_tmp2_ = g_getenv ("PKEXEC_UID");
		_tmp1_ = _tmp2_ == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		FILE* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = stderr;
		_tmp4_ = g_strconcat (_ ("Error: Running Files as root using sudo is not possible."), " ", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, _ ("Please use the command: io.elementary.files-pkexec [folder]"), NULL);
		_tmp7_ = _tmp6_;
		fprintf (_tmp3_, "%s", _tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		result = EXIT_FAILURE;
		return result;
	}
	{
		g_application_register ((GApplication*) self, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = stderr;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		fprintf (_tmp8_, "Error: failed to register application: %s", _tmp10_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp11_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp11_;
	}
	_tmp12_ = g_application_get_is_remote ((GApplication*) self);
	_tmp13_ = _tmp12_;
	remote = _tmp13_;
	if (g_variant_dict_contains (options, "quit")) {
		if (g_variant_dict_contains (options, G_OPTION_REMAINING)) {
			FILE* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp14_ = stderr;
			_tmp15_ = g_strconcat (_ ("--quit cannot be used with URIs."), "\n", NULL);
			_tmp16_ = _tmp15_;
			fprintf (_tmp14_, "%s", _tmp16_);
			_g_free0 (_tmp16_);
			result = EXIT_FAILURE;
			return result;
		}
		if (remote) {
			g_action_group_activate_action ((GActionGroup*) self, "quit", NULL);
		}
		result = EXIT_SUCCESS;
		return result;
	}
	if (!remote) {
		_tmp17_ = g_variant_dict_contains (options, "debug");
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		g_setenv ("G_MESSAGES_DEBUG", "all", FALSE);
		g_variant_dict_remove (options, "debug");
	}
	result = -1;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FilesApplication* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->gtk_settings);
		_g_object_unref0 (_data1_->granite_settings);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda15_ (FilesApplication* self)
{
	files_icon_info_clear_caches ();
}

static void
___lambda15__gtk_icon_theme_changed (GtkIconTheme* _sender,
                                     gpointer self)
{
	__lambda15_ ((FilesApplication*) self);
}

static void
_files_application_mount_removed_callback_g_volume_monitor_mount_removed (GVolumeMonitor* _sender,
                                                                          GMount* mount,
                                                                          gpointer self)
{
	files_application_mount_removed_callback ((FilesApplication*) self, _sender, mount);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda210_ (Block1Data* _data1_)
{
	FilesApplication* self;
	GraniteSettingsColorScheme _tmp0_;
	GraniteSettingsColorScheme _tmp1_;
	self = _data1_->self;
	_tmp0_ = granite_settings_get_prefers_color_scheme (_data1_->granite_settings);
	_tmp1_ = _tmp0_;
	g_object_set (_data1_->gtk_settings, "gtk-application-prefer-dark-theme", _tmp1_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
	files_emblem_renderer_clear_cache ();
}

static void
___lambda210__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda210_ (self);
}

static void
_files_application_quit_g_simple_action_activate (GSimpleAction* _sender,
                                                  GVariant* parameter,
                                                  gpointer self)
{
	files_application_quit ((FilesApplication*) self);
}

static void
files_application_real_startup (GApplication* base)
{
	FilesApplication * self;
	Block1Data* _data1_;
	GtkIconTheme* _tmp0_;
	FilesProgressUIHandler* _tmp1_;
	GdkDisplay* _tmp2_;
	FilesClipboardManager* _tmp3_;
	GtkRecentManager* _tmp4_;
	FilesPluginManager* _tmp5_;
	GVolumeMonitor* _tmp6_;
	GVolumeMonitor* _tmp7_;
	GtkCssProvider* app_provider = NULL;
	GtkCssProvider* _tmp8_;
	GdkScreen* _tmp9_;
	GraniteSettings* _tmp10_;
	GraniteSettings* _tmp11_;
	GtkSettings* _tmp12_;
	GtkSettings* _tmp13_;
	GraniteSettingsColorScheme _tmp14_;
	GraniteSettingsColorScheme _tmp15_;
	GSimpleAction* quit_action = NULL;
	GSimpleAction* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	self = (FilesApplication*) base;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	G_APPLICATION_CLASS (files_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	files_application_init_schemas (self);
	_tmp0_ = gtk_icon_theme_get_default ();
	g_signal_connect_object (_tmp0_, "changed", (GCallback) ___lambda15__gtk_icon_theme_changed, self, 0);
	_tmp1_ = files_progress_ui_handler_new ();
	_g_object_unref0 (self->priv->progress_handler);
	self->priv->progress_handler = _tmp1_;
	_tmp2_ = gdk_display_get_default ();
	_tmp3_ = files_clipboard_manager_get_for_display (_tmp2_);
	_g_object_unref0 (self->priv->clipboard);
	self->priv->clipboard = _tmp3_;
	_tmp4_ = gtk_recent_manager_new ();
	_g_object_unref0 (self->priv->recent);
	self->priv->recent = _tmp4_;
	_tmp5_ = files_plugin_manager_new (PLUGIN_DIR, (guint) getuid ());
	_g_object_unref0 (plugins);
	plugins = _tmp5_;
	_tmp6_ = g_volume_monitor_get ();
	_g_object_unref0 (self->priv->volume_monitor);
	self->priv->volume_monitor = _tmp6_;
	_tmp7_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp7_, "mount-removed", (GCallback) _files_application_mount_removed_callback_g_volume_monitor_mount_removed, self, 0);
	_tmp8_ = gtk_css_provider_new ();
	app_provider = _tmp8_;
	gtk_css_provider_load_from_resource (app_provider, "/io/elementary/files/Application.css");
	_tmp9_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp9_, (GtkStyleProvider*) app_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp10_ = granite_settings_get_default ();
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_data1_->granite_settings = _tmp11_;
	_tmp12_ = gtk_settings_get_default ();
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_data1_->gtk_settings = _tmp13_;
	_tmp14_ = granite_settings_get_prefers_color_scheme (_data1_->granite_settings);
	_tmp15_ = _tmp14_;
	g_object_set (_data1_->gtk_settings, "gtk-application-prefer-dark-theme", _tmp15_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
	g_signal_connect_data ((GObject*) _data1_->granite_settings, "notify::prefers-color-scheme", (GCallback) ___lambda210__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp16_ = g_simple_action_new ("quit", NULL);
	quit_action = _tmp16_;
	g_signal_connect_object (quit_action, "activate", (GCallback) _files_application_quit_g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) self, (GAction*) quit_action);
	_tmp17_ = g_strdup ("<Ctrl>Q");
	_tmp18_ = g_new0 (gchar*, 1 + 1);
	_tmp18_[0] = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp19_);
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (quit_action);
	_g_object_unref0 (app_provider);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

FilesClipboardManager*
files_application_get_clipboard_manager (FilesApplication* self)
{
	FilesClipboardManager* _tmp0_;
	FilesClipboardManager* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->clipboard;
	result = _tmp0_;
	return result;
}

GtkRecentManager*
files_application_get_recent_manager (FilesApplication* self)
{
	GtkRecentManager* _tmp0_;
	GtkRecentManager* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->recent;
	result = _tmp0_;
	return result;
}

static GFile**
_vala_array_dup1 (GFile** self,
                  gssize length)
{
	if (length >= 0) {
		GFile** result;
		gssize i;
		result = g_new0 (GFile*, length + 1);
		for (i = 0; i < length; i++) {
			GFile* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gint
files_application_real_command_line (GApplication* base,
                                     GApplicationCommandLine* cmd)
{
	FilesApplication * self;
	GVariantDict* options = NULL;
	GVariantDict* _tmp0_;
	FilesViewWindow* window = NULL;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	FilesViewWindow* _tmp3_;
	gboolean new_window = FALSE;
	gboolean _tmp4_ = FALSE;
	FilesViewWindow* _tmp5_;
	const gchar** uris = NULL;
	gint uris_length1 = 0;
	gint _uris_size_ = 0;
	GVariantDict* _tmp12_;
	const gchar** _tmp13_ = NULL;
	gboolean _tmp14_;
	FilesViewWindow* _tmp43_;
	gint result;
	self = (FilesApplication*) base;
	g_return_val_if_fail (cmd != NULL, 0);
	_tmp0_ = g_application_command_line_get_options_dict (cmd);
	options = _tmp0_;
	_tmp1_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, FILES_VIEW_TYPE_WINDOW, FilesViewWindow));
	window = _tmp3_;
	new_window = FALSE;
	_tmp5_ = window;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		GVariantDict* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_;
		_tmp7_ = options;
		_tmp9_ = g_variant_dict_lookup (_tmp7_, "new-window", "b", &_tmp8_, NULL);
		new_window = _tmp8_;
		if (_tmp9_) {
			_tmp6_ = new_window;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp4_ = _tmp6_;
	}
	if (_tmp4_) {
		GList* _tmp10_;
		FilesViewWindow* _tmp11_;
		_tmp10_ = gtk_application_get_windows ((GtkApplication*) self);
		if (g_list_length (_tmp10_) >= FILES_APPLICATION_MAX_WINDOWS) {
			G_TYPE_INSTANCE_GET_CLASS (cmd, g_application_command_line_get_type (), GApplicationCommandLineClass)->printerr_literal (cmd, "Error: failed to create new window, maximum limit reached.");
			result = EXIT_FAILURE;
			_g_object_unref0 (window);
			return result;
		}
		_tmp11_ = files_view_window_new (self);
		g_object_ref_sink (_tmp11_);
		_g_object_unref0 (window);
		window = _tmp11_;
		new_window = TRUE;
	}
	_tmp12_ = options;
	_tmp14_ = g_variant_dict_lookup (_tmp12_, G_OPTION_REMAINING, "^a&s", &_tmp13_, NULL);
	uris = (g_free (uris), NULL);
	uris = _tmp13_;
	uris_length1 = -1;
	_uris_size_ = uris_length1;
	if (_tmp14_) {
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* working_directory = NULL;
		gchar* _tmp19_;
		GFile** files = NULL;
		const gchar** _tmp20_;
		gint _tmp20__length1;
		GFile** _tmp21_;
		gint files_length1;
		gint _files_size_;
		FilesViewWindow* _tmp35_;
		GFile** _tmp36_;
		gint _tmp36__length1;
		GFile** _tmp37_;
		gint _tmp37__length1;
		_tmp16_ = g_application_command_line_get_cwd (cmd);
		_tmp17_ = g_strdup (_tmp16_);
		_tmp15_ = _tmp17_;
		if (_tmp15_ == NULL) {
			gchar* _tmp18_;
			_tmp18_ = g_get_current_dir ();
			_g_free0 (_tmp15_);
			_tmp15_ = _tmp18_;
		}
		_tmp19_ = _tmp15_;
		_tmp15_ = NULL;
		working_directory = _tmp19_;
		_tmp20_ = uris;
		_tmp20__length1 = uris_length1;
		_tmp21_ = g_new0 (GFile*, g_strv_length (_tmp20_) + 1);
		files = _tmp21_;
		files_length1 = g_strv_length (_tmp20_);
		_files_size_ = files_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp22_ = FALSE;
				_tmp22_ = TRUE;
				while (TRUE) {
					const gchar** _tmp24_;
					gint _tmp24__length1;
					const gchar* _tmp25_;
					gchar* uri = NULL;
					const gchar** _tmp26_;
					gint _tmp26__length1;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					gchar* _tmp29_;
					GFile** _tmp30_;
					gint _tmp30__length1;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					GFile* _tmp34_;
					if (!_tmp22_) {
						gint _tmp23_;
						i = i + 1;
						_tmp23_ = i;
					}
					_tmp22_ = FALSE;
					_tmp24_ = uris;
					_tmp24__length1 = uris_length1;
					_tmp25_ = _tmp24_[i];
					if (!(_tmp25_ != NULL)) {
						break;
					}
					_tmp26_ = uris;
					_tmp26__length1 = uris_length1;
					_tmp27_ = _tmp26_[i];
					_tmp28_ = working_directory;
					_tmp29_ = files_file_utils_sanitize_path (_tmp27_, _tmp28_, TRUE);
					uri = _tmp29_;
					_tmp30_ = files;
					_tmp30__length1 = files_length1;
					_tmp31_ = uri;
					_tmp32_ = files_file_utils_escape_uri (_tmp31_, TRUE, TRUE);
					_tmp33_ = _tmp32_;
					_tmp34_ = g_file_new_for_uri (_tmp33_);
					_g_object_unref0 (_tmp30_[i]);
					_tmp30_[i] = _tmp34_;
					_g_free0 (_tmp33_);
					_g_free0 (uri);
				}
			}
		}
		_tmp35_ = window;
		_tmp36_ = files;
		_tmp36__length1 = files_length1;
		_tmp37_ = (_tmp36_ != NULL) ? _vala_array_dup1 (_tmp36_, _tmp36__length1) : _tmp36_;
		_tmp37__length1 = _tmp36__length1;
		files_view_window_open_tabs (_tmp35_, _tmp37_, (gint) _tmp37__length1, FILES_VIEW_MODE_PREFERRED, !new_window, NULL, NULL);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_free0 (working_directory);
		_g_free0 (_tmp15_);
	} else {
		FilesViewWindow* _tmp38_;
		HdyTabView* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		_tmp38_ = window;
		_tmp39_ = _tmp38_->tab_view;
		_tmp40_ = hdy_tab_view_get_n_pages (_tmp39_);
		_tmp41_ = _tmp40_;
		if (_tmp41_ == 0) {
			FilesViewWindow* _tmp42_;
			_tmp42_ = window;
			files_view_window_open_tabs (_tmp42_, NULL, (gint) 0, FILES_VIEW_MODE_PREFERRED, FALSE, NULL, NULL);
		}
	}
	_tmp43_ = window;
	gtk_window_present ((GtkWindow*) _tmp43_);
	result = EXIT_SUCCESS;
	uris = (g_free (uris), NULL);
	_g_object_unref0 (window);
	return result;
}

static void
files_application_real_window_added (GtkApplication* base,
                                     GtkWindow* window)
{
	FilesApplication * self;
	FilesPluginManager* _tmp0_;
	self = (FilesApplication*) base;
	g_return_if_fail (window != NULL);
	_tmp0_ = plugins;
	files_plugin_manager_interface_loaded (_tmp0_, (GtkWidget*) window);
	GTK_APPLICATION_CLASS (files_application_parent_class)->window_added (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), window);
}

static void
files_application_real_quit_mainloop (GApplication* base)
{
	FilesApplication * self;
	self = (FilesApplication*) base;
	g_warning ("Application.vala:228: Quitting mainloop");
	files_icon_info_clear_caches ();
	G_APPLICATION_CLASS (files_application_parent_class)->quit_mainloop ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}

static void
__lambda211_ (FilesApplication* self,
              GtkWindow* window)
{
	g_return_if_fail (window != NULL);
	files_view_window_quit (G_TYPE_CHECK_INSTANCE_CAST (window, FILES_VIEW_TYPE_WINDOW, FilesViewWindow));
}

static void
___lambda211__gfunc (gconstpointer data,
                     gpointer self)
{
	__lambda211_ ((FilesApplication*) self, (GtkWindow*) data);
}

void
files_application_quit (FilesApplication* self)
{
	GList* window_list = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->quitting) {
		return;
	}
	self->priv->quitting = TRUE;
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	window_list = _tmp0_;
	_tmp1_ = window_list;
	g_list_foreach (_tmp1_, ___lambda211__gfunc, self);
	g_application_quit ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		FilesApplication* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->file);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda74_ (Block2Data* _data2_,
             GtkWindow* window)
{
	FilesApplication* self;
	self = _data2_->self;
	g_return_if_fail (window != NULL);
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (window, FILES_VIEW_TYPE_WINDOW, FilesViewWindow), "folder-deleted", _data2_->file);
}

static void
___lambda74__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda74_ (self, (GtkWindow*) data);
}

void
files_application_folder_deleted (FilesApplication* self,
                                  GFile* file)
{
	Block2Data* _data2_;
	GFile* _tmp0_;
	GList* window_list = NULL;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data2_->file);
	_data2_->file = _tmp0_;
	_tmp1_ = gtk_application_get_windows ((GtkApplication*) self);
	window_list = _tmp1_;
	g_list_foreach (window_list, ___lambda74__gfunc, _data2_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
files_application_mount_removed_callback (FilesApplication* self,
                                          GVolumeMonitor* monitor,
                                          GMount* mount)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (mount != NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp1_;
			GtkWindow* window = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp1_;
			{
				GtkWindow* _tmp2_;
				_tmp2_ = window;
				files_view_window_mount_removed (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, FILES_VIEW_TYPE_WINDOW, FilesViewWindow), mount);
				_g_object_unref0 (window);
			}
		}
	}
}

static void
files_application_init_schemas (FilesApplication* self)
{
	FilesPreferences* prefs = NULL;
	FilesPreferences* _tmp0_;
	GSettings* _tmp1_;
	GSettingsSchema* _tmp2_;
	GSettingsSchema* _tmp3_;
	GSettingsSchema* _tmp4_;
	gboolean _tmp5_;
	GSettings* _tmp8_;
	FilesPreferences* _tmp9_;
	GSettings* _tmp10_;
	FilesPreferences* _tmp11_;
	GSettings* _tmp12_;
	FilesPreferences* _tmp13_;
	GSettings* _tmp14_;
	FilesPreferences* _tmp15_;
	GSettings* _tmp16_;
	FilesPreferences* _tmp17_;
	FilesPreferences* _tmp18_;
	GSettings* _tmp19_;
	FilesPreferences* _tmp20_;
	FilesPreferences* _tmp21_;
	GSettings* _tmp22_;
	FilesPreferences* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = files_preferences_get_default ();
	prefs = _tmp0_;
	_tmp1_ = files_app_settings;
	g_object_get (_tmp1_, "settings-schema", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = g_settings_schema_has_key (_tmp4_, "singleclick-select");
	_g_settings_schema_unref0 (_tmp4_);
	if (_tmp5_) {
		GSettings* _tmp6_;
		FilesPreferences* _tmp7_;
		_tmp6_ = files_app_settings;
		_tmp7_ = prefs;
		g_settings_bind (_tmp6_, "singleclick-select", (GObject*) _tmp7_, "singleclick-select", G_SETTINGS_BIND_DEFAULT);
	}
	_tmp8_ = files_app_settings;
	_tmp9_ = prefs;
	g_settings_bind (_tmp8_, "show-hiddenfiles", (GObject*) _tmp9_, "show-hidden-files", G_SETTINGS_BIND_DEFAULT);
	_tmp10_ = files_app_settings;
	_tmp11_ = prefs;
	g_settings_bind (_tmp10_, "show-remote-thumbnails", (GObject*) _tmp11_, "show-remote-thumbnails", G_SETTINGS_BIND_DEFAULT);
	_tmp12_ = files_app_settings;
	_tmp13_ = prefs;
	g_settings_bind (_tmp12_, "show-local-thumbnails", (GObject*) _tmp13_, "show-local-thumbnails", G_SETTINGS_BIND_DEFAULT);
	_tmp14_ = files_app_settings;
	_tmp15_ = prefs;
	g_settings_bind (_tmp14_, "date-format", (GObject*) _tmp15_, "date-format", G_SETTINGS_BIND_DEFAULT);
	_tmp16_ = self->priv->_gnome_interface_settings;
	_tmp17_ = files_preferences_get_default ();
	_tmp18_ = _tmp17_;
	g_settings_bind (_tmp16_, "clock-format", (GObject*) _tmp18_, "clock-format", G_SETTINGS_BIND_GET);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = self->priv->_gnome_privacy_settings;
	_tmp20_ = files_preferences_get_default ();
	_tmp21_ = _tmp20_;
	g_settings_bind (_tmp19_, "remember-recent-files", (GObject*) _tmp21_, "remember-history", G_SETTINGS_BIND_GET);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = self->priv->_gtk_file_chooser_settings;
	_tmp23_ = prefs;
	g_settings_bind (_tmp22_, "sort-directories-first", (GObject*) _tmp23_, "sort-directories-first", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (prefs);
}

FilesApplication*
files_application_construct (GType object_type)
{
	FilesApplication * self = NULL;
	self = (FilesApplication*) g_object_new (object_type, NULL);
	return self;
}

FilesApplication*
files_application_new (void)
{
	return files_application_construct (FILES_TYPE_APPLICATION);
}

GSettings*
files_application_get_gnome_interface_settings (FilesApplication* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gnome_interface_settings;
	result = _tmp0_;
	return result;
}

static void
files_application_set_gnome_interface_settings (FilesApplication* self,
                                                GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_application_get_gnome_interface_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gnome_interface_settings);
		self->priv->_gnome_interface_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_application_properties[FILES_APPLICATION_GNOME_INTERFACE_SETTINGS_PROPERTY]);
	}
}

GSettings*
files_application_get_gnome_privacy_settings (FilesApplication* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gnome_privacy_settings;
	result = _tmp0_;
	return result;
}

static void
files_application_set_gnome_privacy_settings (FilesApplication* self,
                                              GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_application_get_gnome_privacy_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gnome_privacy_settings);
		self->priv->_gnome_privacy_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_application_properties[FILES_APPLICATION_GNOME_PRIVACY_SETTINGS_PROPERTY]);
	}
}

GSettings*
files_application_get_gtk_file_chooser_settings (FilesApplication* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gtk_file_chooser_settings;
	result = _tmp0_;
	return result;
}

static void
files_application_set_gtk_file_chooser_settings (FilesApplication* self,
                                                 GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_application_get_gtk_file_chooser_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gtk_file_chooser_settings);
		self->priv->_gtk_file_chooser_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_application_properties[FILES_APPLICATION_GTK_FILE_CHOOSER_SETTINGS_PROPERTY]);
	}
}

static GObject *
files_application_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesApplication * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GApplicationFlags _tmp6_;
	GApplicationFlags _tmp7_;
	parent_class = G_OBJECT_CLASS (files_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_APPLICATION, FilesApplication);
	_tmp0_ = g_settings_new ("org.gnome.desktop.interface");
	_tmp1_ = _tmp0_;
	files_application_set_gnome_interface_settings (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = g_settings_new ("org.gnome.desktop.privacy");
	_tmp3_ = _tmp2_;
	files_application_set_gnome_privacy_settings (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = g_settings_new ("org.gtk.Settings.FileChooser");
	_tmp5_ = _tmp4_;
	files_application_set_gtk_file_chooser_settings (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	g_application_set_application_id ((GApplication*) self, FILES_APP_ID);
	_tmp6_ = g_application_get_flags ((GApplication*) self);
	_tmp7_ = _tmp6_;
	g_application_set_flags ((GApplication*) self, _tmp7_ | G_APPLICATION_HANDLES_COMMAND_LINE);
	g_application_set_option_context_parameter_string ((GApplication*) self, _ ("\n\nBrowse the file system with the file manager"));
	g_application_add_main_option ((GApplication*) self, "version", '\0', G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, _ ("Show the version of the program"), NULL);
	g_application_add_main_option ((GApplication*) self, "tab", 't', G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, _ ("Open one or more URIs, each in their own tab"), NULL);
	g_application_add_main_option ((GApplication*) self, "new-window", 'n', G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, _ ("New Window"), NULL);
	g_application_add_main_option ((GApplication*) self, "quit", 'q', G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, _ ("Quit Files"), NULL);
	g_application_add_main_option ((GApplication*) self, "debug", 'd', G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, _ ("Enable debug logging"), NULL);
	g_application_add_main_option ((GApplication*) self, G_OPTION_REMAINING, '\0', G_OPTION_FLAG_NONE, G_OPTION_ARG_STRING_ARRAY, "\0", _ ("[URI…]"));
	return obj;
}

static void
files_application_class_init (FilesApplicationClass * klass,
                              gpointer klass_data)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	files_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesApplication_private_offset);
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) files_application_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) files_application_real_startup;
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) files_application_real_command_line;
	((GtkApplicationClass *) klass)->window_added = (void (*) (GtkApplication*, GtkWindow*)) files_application_real_window_added;
	((GApplicationClass *) klass)->quit_mainloop = (void (*) (GApplication*)) files_application_real_quit_mainloop;
	G_OBJECT_CLASS (klass)->get_property = _vala_files_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_application_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_APPLICATION_GNOME_INTERFACE_SETTINGS_PROPERTY, files_application_properties[FILES_APPLICATION_GNOME_INTERFACE_SETTINGS_PROPERTY] = g_param_spec_object ("gnome-interface-settings", "gnome-interface-settings", "gnome-interface-settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_APPLICATION_GNOME_PRIVACY_SETTINGS_PROPERTY, files_application_properties[FILES_APPLICATION_GNOME_PRIVACY_SETTINGS_PROPERTY] = g_param_spec_object ("gnome-privacy-settings", "gnome-privacy-settings", "gnome-privacy-settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_APPLICATION_GTK_FILE_CHOOSER_SETTINGS_PROPERTY, files_application_properties[FILES_APPLICATION_GTK_FILE_CHOOSER_SETTINGS_PROPERTY] = g_param_spec_object ("gtk-file-chooser-settings", "gtk-file-chooser-settings", "gtk-file-chooser-settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_settings_new ("io.elementary.files.preferences");
	_g_object_unref0 (files_app_settings);
	files_app_settings = _tmp0_;
	_tmp1_ = g_settings_new ("io.elementary.files.icon-view");
	_g_object_unref0 (files_icon_view_settings);
	files_icon_view_settings = _tmp1_;
	_tmp2_ = g_settings_new ("io.elementary.files.list-view");
	_g_object_unref0 (files_list_view_settings);
	files_list_view_settings = _tmp2_;
	_tmp3_ = g_settings_new ("io.elementary.files.column-view");
	_g_object_unref0 (files_column_view_settings);
	files_column_view_settings = _tmp3_;
}

static void
files_application_instance_init (FilesApplication * self,
                                 gpointer klass)
{
	self->priv = files_application_get_instance_private (self);
	self->priv->quitting = FALSE;
}

static void
files_application_finalize (GObject * obj)
{
	FilesApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_APPLICATION, FilesApplication);
	_g_object_unref0 (self->priv->volume_monitor);
	_g_object_unref0 (self->priv->progress_handler);
	_g_object_unref0 (self->priv->clipboard);
	_g_object_unref0 (self->priv->recent);
	_g_object_unref0 (self->priv->_gnome_interface_settings);
	_g_object_unref0 (self->priv->_gnome_privacy_settings);
	_g_object_unref0 (self->priv->_gtk_file_chooser_settings);
	G_OBJECT_CLASS (files_application_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesApplication), 0, (GInstanceInitFunc) files_application_instance_init, NULL };
	GType files_application_type_id;
	files_application_type_id = g_type_register_static (gtk_application_get_type (), "FilesApplication", &g_define_type_info, 0);
	FilesApplication_private_offset = g_type_add_instance_private (files_application_type_id, sizeof (FilesApplicationPrivate));
	return files_application_type_id;
}

GType
files_application_get_type (void)
{
	static volatile gsize files_application_type_id__once = 0;
	if (g_once_init_enter (&files_application_type_id__once)) {
		GType files_application_type_id;
		files_application_type_id = files_application_get_type_once ();
		g_once_init_leave (&files_application_type_id__once, files_application_type_id);
	}
	return files_application_type_id__once;
}

static void
_vala_files_application_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	FilesApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_APPLICATION, FilesApplication);
	switch (property_id) {
		case FILES_APPLICATION_GNOME_INTERFACE_SETTINGS_PROPERTY:
		g_value_set_object (value, files_application_get_gnome_interface_settings (self));
		break;
		case FILES_APPLICATION_GNOME_PRIVACY_SETTINGS_PROPERTY:
		g_value_set_object (value, files_application_get_gnome_privacy_settings (self));
		break;
		case FILES_APPLICATION_GTK_FILE_CHOOSER_SETTINGS_PROPERTY:
		g_value_set_object (value, files_application_get_gtk_file_chooser_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_application_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	FilesApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_APPLICATION, FilesApplication);
	switch (property_id) {
		case FILES_APPLICATION_GNOME_INTERFACE_SETTINGS_PROPERTY:
		files_application_set_gnome_interface_settings (self, g_value_get_object (value));
		break;
		case FILES_APPLICATION_GNOME_PRIVACY_SETTINGS_PROPERTY:
		files_application_set_gnome_privacy_settings (self, g_value_get_object (value));
		break;
		case FILES_APPLICATION_GTK_FILE_CHOOSER_SETTINGS_PROPERTY:
		files_application_set_gtk_file_chooser_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

