/* AnimatorFade.c generated by valac 0.56.18, the Vala compiler
 * generated from AnimatorFade.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ANIMATOR_ACTION (animator_action_get_type ())
#define ANIMATOR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR_ACTION, AnimatorAction))
#define ANIMATOR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR_ACTION, AnimatorActionClass))
#define IS_ANIMATOR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR_ACTION))
#define IS_ANIMATOR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR_ACTION))
#define ANIMATOR_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR_ACTION, AnimatorActionClass))

typedef struct _AnimatorAction AnimatorAction;
typedef struct _AnimatorActionClass AnimatorActionClass;
typedef struct _AnimatorActionPrivate AnimatorActionPrivate;
typedef enum  {
	ANIMATION_TYPE_UNKNOWN = 0,
	ANIMATION_TYPE_NODES,
	ANIMATION_TYPE_NODE,
	ANIMATION_TYPE_FADE,
	ANIMATION_TYPE_PAN,
	ANIMATION_TYPE_SCALE,
	ANIMATION_TYPE_PANSCALE
} AnimationType;

#define TYPE_ANIMATION_TYPE (animation_type_get_type ())

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_ANIMATOR_FADE (animator_fade_get_type ())
#define ANIMATOR_FADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR_FADE, AnimatorFade))
#define ANIMATOR_FADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR_FADE, AnimatorFadeClass))
#define IS_ANIMATOR_FADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR_FADE))
#define IS_ANIMATOR_FADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR_FADE))
#define ANIMATOR_FADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR_FADE, AnimatorFadeClass))

typedef struct _AnimatorFade AnimatorFade;
typedef struct _AnimatorFadeClass AnimatorFadeClass;
typedef struct _AnimatorFadePrivate AnimatorFadePrivate;

#define TYPE_ANIMATOR_POSITIONS (animator_positions_get_type ())
#define ANIMATOR_POSITIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR_POSITIONS, AnimatorPositions))
#define ANIMATOR_POSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR_POSITIONS, AnimatorPositionsClass))
#define IS_ANIMATOR_POSITIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR_POSITIONS))
#define IS_ANIMATOR_POSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR_POSITIONS))
#define ANIMATOR_POSITIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR_POSITIONS, AnimatorPositionsClass))

typedef struct _AnimatorPositions AnimatorPositions;
typedef struct _AnimatorPositionsClass AnimatorPositionsClass;

#define TYPE_ANIMATOR_CALLOUTS (animator_callouts_get_type ())
#define ANIMATOR_CALLOUTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR_CALLOUTS, AnimatorCallouts))
#define ANIMATOR_CALLOUTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR_CALLOUTS, AnimatorCalloutsClass))
#define IS_ANIMATOR_CALLOUTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR_CALLOUTS))
#define IS_ANIMATOR_CALLOUTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR_CALLOUTS))
#define ANIMATOR_CALLOUTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR_CALLOUTS, AnimatorCalloutsClass))

typedef struct _AnimatorCallouts AnimatorCallouts;
typedef struct _AnimatorCalloutsClass AnimatorCalloutsClass;
enum  {
	ANIMATOR_FADE_0_PROPERTY,
	ANIMATOR_FADE_NUM_PROPERTIES
};
static GParamSpec* animator_fade_properties[ANIMATOR_FADE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_LAYOUT (layout_get_type ())
#define LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUT, Layout))
#define LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUT, LayoutClass))
#define IS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUT))
#define IS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUT))
#define LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUT, LayoutClass))

typedef struct _Layout Layout;
typedef struct _LayoutClass LayoutClass;
typedef enum  {
	NODE_SIDE_LEFT = 1,
	NODE_SIDE_TOP = 2,
	NODE_SIDE_RIGHT = 4,
	NODE_SIDE_BOTTOM = 8
} NodeSide;

#define TYPE_NODE_SIDE (node_side_get_type ())

#define TYPE_CALLOUT (callout_get_type ())
#define CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALLOUT, Callout))
#define CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALLOUT, CalloutClass))
#define IS_CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALLOUT))
#define IS_CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALLOUT))
#define CALLOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALLOUT, CalloutClass))

typedef struct _Callout Callout;
typedef struct _CalloutClass CalloutClass;
typedef enum  {
	CALLOUT_MODE_NONE = 0,
	CALLOUT_MODE_SELECTED,
	CALLOUT_MODE_EDITABLE,
	CALLOUT_MODE_HIDING,
	CALLOUT_MODE_HIDDEN
} CalloutMode;

#define TYPE_CALLOUT_MODE (callout_mode_get_type ())

struct _AnimatorAction {
	GObject parent_instance;
	AnimatorActionPrivate * priv;
	gchar* _name;
	gboolean _save;
	gint _id;
};

struct _AnimatorActionClass {
	GObjectClass parent_class;
	AnimationType (*type) (AnimatorAction* self);
	void (*capture) (AnimatorAction* self, DrawArea* da);
	void (*adjust) (AnimatorAction* self, DrawArea* da);
	void (*on_completion) (AnimatorAction* self, DrawArea* da);
};

struct _AnimatorFade {
	AnimatorAction parent_instance;
	AnimatorFadePrivate * priv;
};

struct _AnimatorFadeClass {
	AnimatorActionClass parent_class;
};

struct _AnimatorFadePrivate {
	guint _num;
	AnimatorPositions* _pos;
	AnimatorCallouts* _callouts;
	gboolean _fade_out;
};

static gint AnimatorFade_private_offset;
static gpointer animator_fade_parent_class = NULL;

VALA_EXTERN GType animator_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatorAction, g_object_unref)
VALA_EXTERN GType animation_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType animator_fade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatorFade, g_object_unref)
VALA_EXTERN GType animator_positions_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatorPositions, g_object_unref)
VALA_EXTERN GType animator_callouts_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatorCallouts, g_object_unref)
VALA_EXTERN AnimationType animator_action_type (AnimatorAction* self);
VALA_EXTERN void animator_action_capture (AnimatorAction* self,
                              DrawArea* da);
VALA_EXTERN void animator_action_adjust (AnimatorAction* self,
                             DrawArea* da);
VALA_EXTERN void animator_action_on_completion (AnimatorAction* self,
                                    DrawArea* da);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN AnimatorFade* animator_fade_new (DrawArea* da,
                                 GArray* n,
                                 gboolean fade_out,
                                 const gchar* name);
VALA_EXTERN AnimatorFade* animator_fade_construct (GType object_type,
                                       DrawArea* da,
                                       GArray* n,
                                       gboolean fade_out,
                                       const gchar* name);
VALA_EXTERN AnimatorAction* animator_action_new (const gchar* name,
                                     gboolean save);
VALA_EXTERN AnimatorAction* animator_action_construct (GType object_type,
                                           const gchar* name,
                                           gboolean save);
VALA_EXTERN AnimatorPositions* animator_positions_new (DrawArea* da,
                                           GArray* nodes);
VALA_EXTERN AnimatorPositions* animator_positions_construct (GType object_type,
                                                 DrawArea* da,
                                                 GArray* nodes);
VALA_EXTERN AnimatorCallouts* animator_callouts_new (DrawArea* da,
                                         GArray* nodes,
                                         gboolean fade_out);
VALA_EXTERN AnimatorCallouts* animator_callouts_construct (GType object_type,
                                               DrawArea* da,
                                               GArray* nodes,
                                               gboolean fade_out);
static AnimationType animator_fade_real_type (AnimatorAction* base);
static void animator_fade_real_capture (AnimatorAction* base,
                                 DrawArea* da);
VALA_EXTERN void animator_positions_gather_new_positions (AnimatorPositions* self);
VALA_EXTERN void animator_callouts_gather_new_callout_alphas (AnimatorCallouts* self,
                                                  gboolean fade_out);
static void animator_fade_real_adjust (AnimatorAction* base,
                                DrawArea* da);
VALA_EXTERN gint animator_action_get_index (AnimatorAction* self);
VALA_EXTERN gdouble animator_action_get_frames (AnimatorAction* self);
VALA_EXTERN void animator_action_set_index (AnimatorAction* self,
                                gint value);
VALA_EXTERN guint animator_positions_length (AnimatorPositions* self);
VALA_EXTERN gdouble animator_positions_new_x (AnimatorPositions* self,
                                  gint index);
VALA_EXTERN gdouble animator_positions_old_x (AnimatorPositions* self,
                                  gint index);
VALA_EXTERN gdouble animator_positions_new_y (AnimatorPositions* self,
                                  gint index);
VALA_EXTERN gdouble animator_positions_old_y (AnimatorPositions* self,
                                  gint index);
VALA_EXTERN Node* animator_positions_node (AnimatorPositions* self,
                               gint index);
VALA_EXTERN void node_set_posx (Node* self,
                    gdouble value);
VALA_EXTERN void node_set_posy (Node* self,
                    gdouble value);
VALA_EXTERN GType layout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layout, g_object_unref)
VALA_EXTERN Layout* node_get_layout (Node* self);
VALA_EXTERN GType node_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NodeSide layout_get_side (Layout* self,
                          Node* n);
VALA_EXTERN void node_set_side (Node* self,
                    NodeSide value);
VALA_EXTERN guint animator_callouts_length (AnimatorCallouts* self);
VALA_EXTERN gdouble animator_callouts_new_alpha (AnimatorCallouts* self,
                                     gint index);
VALA_EXTERN gdouble animator_callouts_old_alpha (AnimatorCallouts* self,
                                     gint index);
VALA_EXTERN Node* animator_callouts_node (AnimatorCallouts* self,
                              gint index);
VALA_EXTERN GType callout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Callout, g_object_unref)
VALA_EXTERN Callout* node_get_callout (Node* self);
VALA_EXTERN void callout_set_alpha (Callout* self,
                        gdouble value);
static void animator_fade_real_on_completion (AnimatorAction* base,
                                       DrawArea* da);
VALA_EXTERN GType callout_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void callout_set_mode (Callout* self,
                       CalloutMode value);
static void animator_fade_finalize (GObject * obj);
static GType animator_fade_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
animator_fade_get_instance_private (AnimatorFade* self)
{
	return G_STRUCT_MEMBER_P (self, AnimatorFade_private_offset);
}

AnimatorFade*
animator_fade_construct (GType object_type,
                         DrawArea* da,
                         GArray* n,
                         gboolean fade_out,
                         const gchar* name)
{
	AnimatorFade * self = NULL;
	AnimatorPositions* _tmp0_;
	AnimatorCallouts* _tmp1_;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (AnimatorFade*) animator_action_construct (object_type, name, TRUE);
	self->priv->_num = n->len;
	_tmp0_ = animator_positions_new (da, n);
	_g_object_unref0 (self->priv->_pos);
	self->priv->_pos = _tmp0_;
	_tmp1_ = animator_callouts_new (da, n, fade_out);
	_g_object_unref0 (self->priv->_callouts);
	self->priv->_callouts = _tmp1_;
	self->priv->_fade_out = fade_out;
	return self;
}

AnimatorFade*
animator_fade_new (DrawArea* da,
                   GArray* n,
                   gboolean fade_out,
                   const gchar* name)
{
	return animator_fade_construct (TYPE_ANIMATOR_FADE, da, n, fade_out, name);
}

static AnimationType
animator_fade_real_type (AnimatorAction* base)
{
	AnimatorFade * self;
	AnimationType result;
	self = (AnimatorFade*) base;
	result = ANIMATION_TYPE_FADE;
	return result;
}

static void
animator_fade_real_capture (AnimatorAction* base,
                            DrawArea* da)
{
	AnimatorFade * self;
	AnimatorPositions* _tmp0_;
	AnimatorCallouts* _tmp1_;
	self = (AnimatorFade*) base;
	g_return_if_fail (da != NULL);
	_tmp0_ = self->priv->_pos;
	animator_positions_gather_new_positions (_tmp0_);
	_tmp1_ = self->priv->_callouts;
	animator_callouts_gather_new_callout_alphas (_tmp1_, self->priv->_fade_out);
}

static void
animator_fade_real_adjust (AnimatorAction* base,
                           DrawArea* da)
{
	AnimatorFade * self;
	gdouble divisor = 0.0;
	gint _tmp0_;
	gint _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	self = (AnimatorFade*) base;
	g_return_if_fail (da != NULL);
	_tmp0_ = animator_action_get_index ((AnimatorAction*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = animator_action_get_frames ((AnimatorAction*) self);
	_tmp3_ = _tmp2_;
	divisor = _tmp1_ / _tmp3_;
	_tmp4_ = animator_action_get_index ((AnimatorAction*) self);
	_tmp5_ = _tmp4_;
	animator_action_set_index ((AnimatorAction*) self, _tmp5_ + 1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				AnimatorPositions* _tmp8_;
				gdouble dx = 0.0;
				AnimatorPositions* _tmp9_;
				AnimatorPositions* _tmp10_;
				gdouble dy = 0.0;
				AnimatorPositions* _tmp11_;
				AnimatorPositions* _tmp12_;
				gdouble x = 0.0;
				AnimatorPositions* _tmp13_;
				gdouble y = 0.0;
				AnimatorPositions* _tmp14_;
				AnimatorPositions* _tmp15_;
				Node* _tmp16_;
				Node* _tmp17_;
				AnimatorPositions* _tmp18_;
				Node* _tmp19_;
				Node* _tmp20_;
				AnimatorPositions* _tmp21_;
				Node* _tmp22_;
				Node* _tmp23_;
				AnimatorPositions* _tmp24_;
				Node* _tmp25_;
				Node* _tmp26_;
				Layout* _tmp27_;
				Layout* _tmp28_;
				AnimatorPositions* _tmp29_;
				Node* _tmp30_;
				Node* _tmp31_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = self->priv->_pos;
				if (!(((guint) i) < animator_positions_length (_tmp8_))) {
					break;
				}
				_tmp9_ = self->priv->_pos;
				_tmp10_ = self->priv->_pos;
				dx = animator_positions_new_x (_tmp9_, i) - animator_positions_old_x (_tmp10_, i);
				_tmp11_ = self->priv->_pos;
				_tmp12_ = self->priv->_pos;
				dy = animator_positions_new_y (_tmp11_, i) - animator_positions_old_y (_tmp12_, i);
				_tmp13_ = self->priv->_pos;
				x = animator_positions_old_x (_tmp13_, i) + (dx * divisor);
				_tmp14_ = self->priv->_pos;
				y = animator_positions_old_y (_tmp14_, i) + (dy * divisor);
				_tmp15_ = self->priv->_pos;
				_tmp16_ = animator_positions_node (_tmp15_, i);
				_tmp17_ = _tmp16_;
				node_set_posx (_tmp17_, x);
				_g_object_unref0 (_tmp17_);
				_tmp18_ = self->priv->_pos;
				_tmp19_ = animator_positions_node (_tmp18_, i);
				_tmp20_ = _tmp19_;
				node_set_posy (_tmp20_, y);
				_g_object_unref0 (_tmp20_);
				_tmp21_ = self->priv->_pos;
				_tmp22_ = animator_positions_node (_tmp21_, i);
				_tmp23_ = _tmp22_;
				_tmp24_ = self->priv->_pos;
				_tmp25_ = animator_positions_node (_tmp24_, i);
				_tmp26_ = _tmp25_;
				_tmp27_ = node_get_layout (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = self->priv->_pos;
				_tmp30_ = animator_positions_node (_tmp29_, i);
				_tmp31_ = _tmp30_;
				node_set_side (_tmp23_, layout_get_side (_tmp28_, _tmp31_));
				_g_object_unref0 (_tmp31_);
				_g_object_unref0 (_tmp26_);
				_g_object_unref0 (_tmp23_);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = TRUE;
			while (TRUE) {
				AnimatorCallouts* _tmp34_;
				gdouble dal = 0.0;
				AnimatorCallouts* _tmp35_;
				AnimatorCallouts* _tmp36_;
				gdouble al = 0.0;
				AnimatorCallouts* _tmp37_;
				AnimatorCallouts* _tmp38_;
				Node* _tmp39_;
				Node* _tmp40_;
				Callout* _tmp41_;
				Callout* _tmp42_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = self->priv->_callouts;
				if (!(((guint) i) < animator_callouts_length (_tmp34_))) {
					break;
				}
				_tmp35_ = self->priv->_callouts;
				_tmp36_ = self->priv->_callouts;
				dal = animator_callouts_new_alpha (_tmp35_, i) - animator_callouts_old_alpha (_tmp36_, i);
				_tmp37_ = self->priv->_callouts;
				al = animator_callouts_old_alpha (_tmp37_, i) + (dal * divisor);
				_tmp38_ = self->priv->_callouts;
				_tmp39_ = animator_callouts_node (_tmp38_, i);
				_tmp40_ = _tmp39_;
				_tmp41_ = node_get_callout (_tmp40_);
				_tmp42_ = _tmp41_;
				callout_set_alpha (_tmp42_, al);
				_g_object_unref0 (_tmp40_);
			}
		}
	}
}

static void
animator_fade_real_on_completion (AnimatorAction* base,
                                  DrawArea* da)
{
	AnimatorFade * self;
	self = (AnimatorFade*) base;
	g_return_if_fail (da != NULL);
	if (self->priv->_fade_out) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					AnimatorCallouts* _tmp2_;
					AnimatorCallouts* _tmp3_;
					Node* _tmp4_;
					Node* _tmp5_;
					Callout* _tmp6_;
					Callout* _tmp7_;
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = i;
						i = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					_tmp2_ = self->priv->_callouts;
					if (!(((guint) i) < animator_callouts_length (_tmp2_))) {
						break;
					}
					_tmp3_ = self->priv->_callouts;
					_tmp4_ = animator_callouts_node (_tmp3_, i);
					_tmp5_ = _tmp4_;
					_tmp6_ = node_get_callout (_tmp5_);
					_tmp7_ = _tmp6_;
					callout_set_mode (_tmp7_, CALLOUT_MODE_HIDDEN);
					_g_object_unref0 (_tmp5_);
				}
			}
		}
	}
}

static void
animator_fade_class_init (AnimatorFadeClass * klass,
                          gpointer klass_data)
{
	animator_fade_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AnimatorFade_private_offset);
	((AnimatorActionClass *) klass)->type = (AnimationType (*) (AnimatorAction*)) animator_fade_real_type;
	((AnimatorActionClass *) klass)->capture = (void (*) (AnimatorAction*, DrawArea*)) animator_fade_real_capture;
	((AnimatorActionClass *) klass)->adjust = (void (*) (AnimatorAction*, DrawArea*)) animator_fade_real_adjust;
	((AnimatorActionClass *) klass)->on_completion = (void (*) (AnimatorAction*, DrawArea*)) animator_fade_real_on_completion;
	G_OBJECT_CLASS (klass)->finalize = animator_fade_finalize;
}

static void
animator_fade_instance_init (AnimatorFade * self,
                             gpointer klass)
{
	self->priv = animator_fade_get_instance_private (self);
}

static void
animator_fade_finalize (GObject * obj)
{
	AnimatorFade * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ANIMATOR_FADE, AnimatorFade);
	_g_object_unref0 (self->priv->_pos);
	_g_object_unref0 (self->priv->_callouts);
	G_OBJECT_CLASS (animator_fade_parent_class)->finalize (obj);
}

static GType
animator_fade_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AnimatorFadeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) animator_fade_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AnimatorFade), 0, (GInstanceInitFunc) animator_fade_instance_init, NULL };
	GType animator_fade_type_id;
	animator_fade_type_id = g_type_register_static (TYPE_ANIMATOR_ACTION, "AnimatorFade", &g_define_type_info, 0);
	AnimatorFade_private_offset = g_type_add_instance_private (animator_fade_type_id, sizeof (AnimatorFadePrivate));
	return animator_fade_type_id;
}

GType
animator_fade_get_type (void)
{
	static volatile gsize animator_fade_type_id__once = 0;
	if (g_once_init_enter (&animator_fade_type_id__once)) {
		GType animator_fade_type_id;
		animator_fade_type_id = animator_fade_get_type_once ();
		g_once_init_leave (&animator_fade_type_id__once, animator_fade_type_id);
	}
	return animator_fade_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

