/* ConnectionInspector.c generated by valac 0.56.18, the Vala compiler
 * generated from ConnectionInspector.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <handy.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CONNECTION_INSPECTOR (connection_inspector_get_type ())
#define CONNECTION_INSPECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION_INSPECTOR, ConnectionInspector))
#define CONNECTION_INSPECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION_INSPECTOR, ConnectionInspectorClass))
#define IS_CONNECTION_INSPECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION_INSPECTOR))
#define IS_CONNECTION_INSPECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION_INSPECTOR))
#define CONNECTION_INSPECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION_INSPECTOR, ConnectionInspectorClass))

typedef struct _ConnectionInspector ConnectionInspector;
typedef struct _ConnectionInspectorClass ConnectionInspectorClass;
typedef struct _ConnectionInspectorPrivate ConnectionInspectorPrivate;

#define TYPE_NOTE_VIEW (note_view_get_type ())
#define NOTE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTE_VIEW, NoteView))
#define NOTE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTE_VIEW, NoteViewClass))
#define IS_NOTE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTE_VIEW))
#define IS_NOTE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTE_VIEW))
#define NOTE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTE_VIEW, NoteViewClass))

typedef struct _NoteView NoteView;
typedef struct _NoteViewClass NoteViewClass;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;
enum  {
	CONNECTION_INSPECTOR_0_PROPERTY,
	CONNECTION_INSPECTOR_NUM_PROPERTIES
};
static GParamSpec* connection_inspector_properties[CONNECTION_INSPECTOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_UNICODE_INSERT (unicode_insert_get_type ())
#define UNICODE_INSERT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNICODE_INSERT, UnicodeInsert))
#define UNICODE_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNICODE_INSERT, UnicodeInsertClass))
#define IS_UNICODE_INSERT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNICODE_INSERT))
#define IS_UNICODE_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNICODE_INSERT))
#define UNICODE_INSERT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNICODE_INSERT, UnicodeInsertClass))

typedef struct _UnicodeInsert UnicodeInsert;
typedef struct _UnicodeInsertClass UnicodeInsertClass;

#define TYPE_NODE_LINK (node_link_get_type ())
#define NODE_LINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_LINK, NodeLink))
#define NODE_LINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_LINK, NodeLinkClass))
#define IS_NODE_LINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_LINK))
#define IS_NODE_LINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_LINK))
#define NODE_LINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_LINK, NodeLinkClass))

typedef struct _NodeLink NodeLink;
typedef struct _NodeLinkClass NodeLinkClass;

#define TYPE_UNDO_BUFFER (undo_buffer_get_type ())
#define UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_BUFFER, UndoBuffer))
#define UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_BUFFER, UndoBufferClass))
#define IS_UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_BUFFER))
#define IS_UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_BUFFER))
#define UNDO_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_BUFFER, UndoBufferClass))

typedef struct _UndoBuffer UndoBuffer;
typedef struct _UndoBufferClass UndoBufferClass;

#define TYPE_UNDO_ITEM (undo_item_get_type ())
#define UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_ITEM, UndoItem))
#define UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_ITEM, UndoItemClass))
#define IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_ITEM))
#define IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_ITEM))
#define UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_ITEM, UndoItemClass))

typedef struct _UndoItem UndoItem;
typedef struct _UndoItemClass UndoItemClass;

#define TYPE_UNDO_CONNECTION_NOTE (undo_connection_note_get_type ())
#define UNDO_CONNECTION_NOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_CONNECTION_NOTE, UndoConnectionNote))
#define UNDO_CONNECTION_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_CONNECTION_NOTE, UndoConnectionNoteClass))
#define IS_UNDO_CONNECTION_NOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_CONNECTION_NOTE))
#define IS_UNDO_CONNECTION_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_CONNECTION_NOTE))
#define UNDO_CONNECTION_NOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_CONNECTION_NOTE, UndoConnectionNoteClass))

typedef struct _UndoConnectionNote UndoConnectionNote;
typedef struct _UndoConnectionNoteClass UndoConnectionNoteClass;

#define TYPE_NODE_LINKS (node_links_get_type ())
#define NODE_LINKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_LINKS, NodeLinks))
#define NODE_LINKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_LINKS, NodeLinksClass))
#define IS_NODE_LINKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_LINKS))
#define IS_NODE_LINKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_LINKS))
#define NODE_LINKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_LINKS, NodeLinksClass))

typedef struct _NodeLinks NodeLinks;
typedef struct _NodeLinksClass NodeLinksClass;
#define _node_link_unref0(var) ((var == NULL) ? NULL : (var = (node_link_unref (var), NULL)))
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;

struct _ConnectionInspector {
	GtkBox parent_instance;
	ConnectionInspectorPrivate * priv;
};

struct _ConnectionInspectorClass {
	GtkBoxClass parent_class;
};

struct _ConnectionInspectorPrivate {
	GtkScrolledWindow* _sw;
	GtkColorButton* _color;
	GtkButton* _reset;
	NoteView* _note;
	DrawArea* _da;
	gchar* _orig_note;
	Connection* _connection;
};

static gint ConnectionInspector_private_offset;
static gpointer connection_inspector_parent_class = NULL;

VALA_EXTERN GType connection_inspector_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionInspector, g_object_unref)
VALA_EXTERN GType note_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NoteView, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Connection, g_object_unref)
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN ConnectionInspector* connection_inspector_new (MainWindow* win);
VALA_EXTERN ConnectionInspector* connection_inspector_construct (GType object_type,
                                                     MainWindow* win);
static void connection_inspector_create_title (ConnectionInspector* self);
static void connection_inspector_create_color (ConnectionInspector* self);
static void connection_inspector_create_note (ConnectionInspector* self,
                                       MainWindow* win);
static void connection_inspector_create_buttons (ConnectionInspector* self);
static void connection_inspector_tab_changed (ConnectionInspector* self,
                                       DrawArea* da);
static void _connection_inspector_tab_changed_main_window_canvas_changed (MainWindow* _sender,
                                                                   DrawArea* da,
                                                                   gpointer self);
static void connection_inspector_connection_changed (ConnectionInspector* self);
static void _connection_inspector_connection_changed_draw_area_current_changed (DrawArea* _sender,
                                                                         DrawArea* da,
                                                                         gpointer self);
VALA_EXTERN void connection_inspector_set_width (ConnectionInspector* self,
                                     gint width);
VALA_EXTERN gchar* utils_make_title (const gchar* str);
static void __lambda69_ (ConnectionInspector* self);
VALA_EXTERN void draw_area_change_current_connection_color (DrawArea* self,
                                                GdkRGBA* color);
static void ___lambda69__gtk_color_button_color_set (GtkColorButton* _sender,
                                              gpointer self);
static void __lambda70_ (ConnectionInspector* self);
static void ___lambda70__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
VALA_EXTERN NoteView* note_view_new (void);
VALA_EXTERN NoteView* note_view_construct (GType object_type);
VALA_EXTERN gpointer unicode_insert_ref (gpointer instance);
VALA_EXTERN void unicode_insert_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_unicode_insert (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_unicode_insert (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_unicode_insert (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_unicode_insert (const GValue* value);
VALA_EXTERN GType unicode_insert_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UnicodeInsert, unicode_insert_unref)
VALA_EXTERN void note_view_add_unicode_completion (NoteView* self,
                                       MainWindow* win,
                                       UnicodeInsert* unicoder);
VALA_EXTERN UnicodeInsert* main_window_get_unicoder (MainWindow* self);
static void connection_inspector_note_changed (ConnectionInspector* self);
static void _connection_inspector_note_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                                 gpointer self);
static gboolean connection_inspector_note_focus_in (ConnectionInspector* self,
                                             GdkEventFocus* e);
static gboolean _connection_inspector_note_focus_in_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                        GdkEventFocus* event,
                                                                        gpointer self);
static gboolean connection_inspector_note_focus_out (ConnectionInspector* self,
                                              GdkEventFocus* e);
static gboolean _connection_inspector_note_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                          GdkEventFocus* event,
                                                                          gpointer self);
VALA_EXTERN gpointer node_link_ref (gpointer instance);
VALA_EXTERN void node_link_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_link (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_node_link (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_node_link (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_node_link (const GValue* value);
VALA_EXTERN GType node_link_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeLink, node_link_unref)
static gint connection_inspector_note_node_link_added (ConnectionInspector* self,
                                                NodeLink* link,
                                                gchar** text);
static gint _connection_inspector_note_node_link_added_note_view_node_link_added (NoteView* _sender,
                                                                           NodeLink* link,
                                                                           gchar** text,
                                                                           gpointer self);
static void connection_inspector_note_node_link_clicked (ConnectionInspector* self,
                                                  gint id);
static void _connection_inspector_note_node_link_clicked_note_view_node_link_clicked (NoteView* _sender,
                                                                               gint id,
                                                                               gpointer self);
static void connection_inspector_note_node_link_hover (ConnectionInspector* self,
                                                gint id);
static void _connection_inspector_note_node_link_hover_note_view_node_link_hover (NoteView* _sender,
                                                                           gint id,
                                                                           gpointer self);
static void connection_inspector_connection_delete (ConnectionInspector* self);
static void _connection_inspector_connection_delete_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
VALA_EXTERN void draw_area_change_current_connection_note (DrawArea* self,
                                               const gchar* note);
VALA_EXTERN Connection* draw_area_get_current_connection (DrawArea* self);
VALA_EXTERN const gchar* connection_get_note (Connection* self);
VALA_EXTERN GType undo_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoBuffer, g_object_unref)
VALA_EXTERN UndoBuffer* draw_area_get_undo_buffer (DrawArea* self);
VALA_EXTERN GType undo_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoItem, g_object_unref)
VALA_EXTERN void undo_buffer_add_item (UndoBuffer* self,
                           UndoItem* item);
VALA_EXTERN UndoConnectionNote* undo_connection_note_new (Connection* c,
                                              const gchar* old_note);
VALA_EXTERN UndoConnectionNote* undo_connection_note_construct (GType object_type,
                                                    Connection* c,
                                                    const gchar* old_note);
VALA_EXTERN GType undo_connection_note_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoConnectionNote, g_object_unref)
VALA_EXTERN gint draw_area_add_note_node_link (DrawArea* self,
                                   NodeLink* link,
                                   gchar** text);
VALA_EXTERN void draw_area_note_node_link_clicked (DrawArea* self,
                                       gint id);
VALA_EXTERN gpointer node_links_ref (gpointer instance);
VALA_EXTERN void node_links_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_links (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_node_links (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_node_links (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_node_links (const GValue* value);
VALA_EXTERN GType node_links_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeLinks, node_links_unref)
VALA_EXTERN NodeLinks* draw_area_get_node_links (DrawArea* self);
VALA_EXTERN NodeLink* node_links_get_node_link (NodeLinks* self,
                                    gint id);
VALA_EXTERN void note_view_show_tooltip (NoteView* self,
                             const gchar* tooltip);
VALA_EXTERN gchar* node_link_get_tooltip (NodeLink* self,
                              DrawArea* da);
VALA_EXTERN void draw_area_delete_connection (DrawArea* self);
VALA_EXTERN void connection_inspector_grab_note (ConnectionInspector* self);
VALA_EXTERN GdkRGBA* connection_get_color (Connection* self);
static GdkRGBA* _vala_GdkRGBA_copy (GdkRGBA* self);
static void _vala_GdkRGBA_free (GdkRGBA* self);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN Theme* draw_area_get_theme (DrawArea* self);
VALA_EXTERN GdkRGBA* theme_get_color (Theme* self,
                          const gchar* name);
VALA_EXTERN void connection_inspector_grab_first (ConnectionInspector* self);
static void connection_inspector_finalize (GObject * obj);
static GType connection_inspector_get_type_once (void);

static const GtkTargetEntry CONNECTION_INSPECTOR_DRAG_TARGETS[1] = {{"text/uri-list", (guint) 0, (guint) 0}};

static inline gpointer
connection_inspector_get_instance_private (ConnectionInspector* self)
{
	return G_STRUCT_MEMBER_P (self, ConnectionInspector_private_offset);
}

static void
_connection_inspector_tab_changed_main_window_canvas_changed (MainWindow* _sender,
                                                              DrawArea* da,
                                                              gpointer self)
{
	connection_inspector_tab_changed ((ConnectionInspector*) self, da);
}

ConnectionInspector*
connection_inspector_construct (GType object_type,
                                MainWindow* win)
{
	ConnectionInspector * self = NULL;
	g_return_val_if_fail (win != NULL, NULL);
	self = (ConnectionInspector*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 10, NULL);
	connection_inspector_create_title (self);
	connection_inspector_create_color (self);
	connection_inspector_create_note (self, win);
	connection_inspector_create_buttons (self);
	g_signal_connect_object (win, "canvas-changed", (GCallback) _connection_inspector_tab_changed_main_window_canvas_changed, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

ConnectionInspector*
connection_inspector_new (MainWindow* win)
{
	return connection_inspector_construct (TYPE_CONNECTION_INSPECTOR, win);
}

static void
_connection_inspector_connection_changed_draw_area_current_changed (DrawArea* _sender,
                                                                    DrawArea* da,
                                                                    gpointer self)
{
	connection_inspector_connection_changed ((ConnectionInspector*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
connection_inspector_tab_changed (ConnectionInspector* self,
                                  DrawArea* da)
{
	DrawArea* _tmp0_;
	DrawArea* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	if (_tmp0_ != NULL) {
		DrawArea* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->_da;
		g_signal_parse_name ("current-changed", TYPE_DRAW_AREA, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _connection_inspector_connection_changed_draw_area_current_changed, self);
	}
	if (da != NULL) {
		g_signal_connect_object (da, "current-changed", (GCallback) _connection_inspector_connection_changed_draw_area_current_changed, self, 0);
	}
	_tmp3_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp3_;
}

void
connection_inspector_set_width (ConnectionInspector* self,
                                gint width)
{
	GtkScrolledWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_sw;
	g_object_set ((GtkWidget*) _tmp0_, "width-request", width, NULL);
}

static void
connection_inspector_create_title (ConnectionInspector* self)
{
	GtkLabel* title = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strconcat ("<big>", _ ("Connection"), NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "</big>", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = (GtkLabel*) gtk_label_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	title = _tmp5_;
	gtk_label_set_use_markup (title, TRUE);
	gtk_label_set_justify (title, GTK_JUSTIFY_CENTER);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) title, FALSE, TRUE, (guint) 0);
	_g_object_unref0 (title);
}

static void
__lambda69_ (ConnectionInspector* self)
{
	DrawArea* _tmp0_;
	GtkColorButton* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_;
	_tmp0_ = self->priv->_da;
	_tmp1_ = self->priv->_color;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp1_, &_tmp2_);
	_tmp3_ = _tmp2_;
	draw_area_change_current_connection_color (_tmp0_, &_tmp3_);
}

static void
___lambda69__gtk_color_button_color_set (GtkColorButton* _sender,
                                         gpointer self)
{
	__lambda69_ ((ConnectionInspector*) self);
}

static void
__lambda70_ (ConnectionInspector* self)
{
	DrawArea* _tmp0_;
	_tmp0_ = self->priv->_da;
	draw_area_change_current_connection_color (_tmp0_, NULL);
}

static void
___lambda70__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda70_ ((ConnectionInspector*) self);
}

static void
connection_inspector_create_color (ConnectionInspector* self)
{
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkLabel* lbl = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkBox* bbox = NULL;
	GtkBox* _tmp5_;
	GtkColorButton* _tmp6_;
	GtkColorButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GtkColorButton* _tmp11_;
	GtkButton* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp1_ = utils_make_title (_ ("Color"));
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	lbl = _tmp4_;
	gtk_box_set_homogeneous (box, TRUE);
	gtk_label_set_xalign (lbl, (gfloat) 0);
	gtk_label_set_use_markup (lbl, TRUE);
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp5_);
	bbox = _tmp5_;
	_tmp6_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->_color);
	self->priv->_color = _tmp6_;
	_tmp7_ = self->priv->_color;
	g_signal_connect_object (_tmp7_, "color-set", (GCallback) ___lambda69__gtk_color_button_color_set, self, 0);
	_tmp8_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->_reset);
	self->priv->_reset = _tmp8_;
	_tmp9_ = self->priv->_reset;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp9_, _ ("Use Theme Default Color"));
	_tmp10_ = self->priv->_reset;
	g_signal_connect_object (_tmp10_, "clicked", (GCallback) ___lambda70__gtk_button_clicked, self, 0);
	_tmp11_ = self->priv->_color;
	gtk_box_pack_start (bbox, (GtkWidget*) _tmp11_, TRUE, TRUE, (guint) 0);
	_tmp12_ = self->priv->_reset;
	gtk_box_pack_start (bbox, (GtkWidget*) _tmp12_, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (box, (GtkWidget*) lbl, FALSE, TRUE, (guint) 0);
	gtk_box_pack_end (box, (GtkWidget*) bbox, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) box, FALSE, TRUE, (guint) 0);
	_g_object_unref0 (bbox);
	_g_object_unref0 (lbl);
	_g_object_unref0 (box);
}

static void
_connection_inspector_note_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                            gpointer self)
{
	connection_inspector_note_changed ((ConnectionInspector*) self);
}

static gboolean
_connection_inspector_note_focus_in_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                               GdkEventFocus* event,
                                                               gpointer self)
{
	gboolean result;
	result = connection_inspector_note_focus_in ((ConnectionInspector*) self, event);
	return result;
}

static gboolean
_connection_inspector_note_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                 GdkEventFocus* event,
                                                                 gpointer self)
{
	gboolean result;
	result = connection_inspector_note_focus_out ((ConnectionInspector*) self, event);
	return result;
}

static gint
_connection_inspector_note_node_link_added_note_view_node_link_added (NoteView* _sender,
                                                                      NodeLink* link,
                                                                      gchar** text,
                                                                      gpointer self)
{
	gint result;
	result = connection_inspector_note_node_link_added ((ConnectionInspector*) self, link, text);
	return result;
}

static void
_connection_inspector_note_node_link_clicked_note_view_node_link_clicked (NoteView* _sender,
                                                                          gint id,
                                                                          gpointer self)
{
	connection_inspector_note_node_link_clicked ((ConnectionInspector*) self, id);
}

static void
_connection_inspector_note_node_link_hover_note_view_node_link_hover (NoteView* _sender,
                                                                      gint id,
                                                                      gpointer self)
{
	connection_inspector_note_node_link_hover ((ConnectionInspector*) self, id);
}

static void
connection_inspector_create_note (ConnectionInspector* self,
                                  MainWindow* win)
{
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkLabel* lbl = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	NoteView* _tmp5_;
	NoteView* _tmp6_;
	NoteView* _tmp7_;
	UnicodeInsert* _tmp8_;
	UnicodeInsert* _tmp9_;
	NoteView* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextBuffer* _tmp12_;
	NoteView* _tmp13_;
	GtkTextBuffer* _tmp14_;
	GtkTextBuffer* _tmp15_;
	NoteView* _tmp16_;
	NoteView* _tmp17_;
	NoteView* _tmp18_;
	NoteView* _tmp19_;
	NoteView* _tmp20_;
	GtkScrolledWindow* _tmp21_;
	GtkScrolledWindow* _tmp22_;
	GtkScrolledWindow* _tmp23_;
	GtkScrolledWindow* _tmp24_;
	NoteView* _tmp25_;
	GtkScrolledWindow* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 10);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp1_ = utils_make_title (_ ("Note"));
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	lbl = _tmp4_;
	gtk_label_set_xalign (lbl, (gfloat) 0);
	gtk_label_set_use_markup (lbl, TRUE);
	_tmp5_ = note_view_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->_note);
	self->priv->_note = _tmp5_;
	_tmp6_ = self->priv->_note;
	gtk_text_view_set_wrap_mode ((GtkTextView*) _tmp6_, GTK_WRAP_WORD);
	_tmp7_ = self->priv->_note;
	_tmp8_ = main_window_get_unicoder (win);
	_tmp9_ = _tmp8_;
	note_view_add_unicode_completion (_tmp7_, win, _tmp9_);
	_tmp10_ = self->priv->_note;
	_tmp11_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp10_);
	_tmp12_ = _tmp11_;
	g_object_set (_tmp12_, "text", "", NULL);
	_tmp13_ = self->priv->_note;
	_tmp14_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp13_);
	_tmp15_ = _tmp14_;
	g_signal_connect_object (_tmp15_, "changed", (GCallback) _connection_inspector_note_changed_gtk_text_buffer_changed, self, 0);
	_tmp16_ = self->priv->_note;
	g_signal_connect_object ((GtkWidget*) _tmp16_, "focus-in-event", (GCallback) _connection_inspector_note_focus_in_gtk_widget_focus_in_event, self, 0);
	_tmp17_ = self->priv->_note;
	g_signal_connect_object ((GtkWidget*) _tmp17_, "focus-out-event", (GCallback) _connection_inspector_note_focus_out_gtk_widget_focus_out_event, self, 0);
	_tmp18_ = self->priv->_note;
	g_signal_connect_object (_tmp18_, "node-link-added", (GCallback) _connection_inspector_note_node_link_added_note_view_node_link_added, self, 0);
	_tmp19_ = self->priv->_note;
	g_signal_connect_object (_tmp19_, "node-link-clicked", (GCallback) _connection_inspector_note_node_link_clicked_note_view_node_link_clicked, self, 0);
	_tmp20_ = self->priv->_note;
	g_signal_connect_object (_tmp20_, "node-link-hover", (GCallback) _connection_inspector_note_node_link_hover_note_view_node_link_hover, self, 0);
	_tmp21_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->_sw);
	self->priv->_sw = _tmp21_;
	_tmp22_ = self->priv->_sw;
	gtk_scrolled_window_set_min_content_width (_tmp22_, 300);
	_tmp23_ = self->priv->_sw;
	gtk_scrolled_window_set_min_content_height (_tmp23_, 100);
	_tmp24_ = self->priv->_sw;
	_tmp25_ = self->priv->_note;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	gtk_box_pack_start (box, (GtkWidget*) lbl, FALSE, FALSE, (guint) 0);
	_tmp26_ = self->priv->_sw;
	gtk_box_pack_start (box, (GtkWidget*) _tmp26_, TRUE, TRUE, (guint) 0);
	gtk_widget_set_margin_bottom ((GtkWidget*) box, 20);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) box, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (lbl);
	_g_object_unref0 (box);
}

static void
_connection_inspector_connection_delete_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	connection_inspector_connection_delete ((ConnectionInspector*) self);
}

static void
connection_inspector_create_buttons (ConnectionInspector* self)
{
	GtkGrid* grid = NULL;
	GtkGrid* _tmp0_;
	GtkButton* del_btn = NULL;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	gtk_grid_set_column_homogeneous (grid, TRUE);
	gtk_grid_set_column_spacing (grid, 5);
	_tmp1_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp1_);
	del_btn = _tmp1_;
	gtk_widget_set_tooltip_text ((GtkWidget*) del_btn, _ ("Delete Connection"));
	g_signal_connect_object (del_btn, "clicked", (GCallback) _connection_inspector_connection_delete_gtk_button_clicked, self, 0);
	gtk_grid_attach (grid, (GtkWidget*) del_btn, 0, 0, 1, 1);
	_g_object_unref0 (del_btn);
	_g_object_unref0 (grid);
}

static void
connection_inspector_note_changed (ConnectionInspector* self)
{
	DrawArea* _tmp0_;
	NoteView* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = self->priv->_note;
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_object_get (_tmp3_, "text", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	draw_area_change_current_connection_note (_tmp0_, _tmp6_);
	_g_free0 (_tmp6_);
}

static gboolean
connection_inspector_note_focus_in (ConnectionInspector* self,
                                    GdkEventFocus* e)
{
	DrawArea* _tmp0_;
	Connection* _tmp1_;
	NoteView* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_connection (_tmp0_);
	_g_object_unref0 (self->priv->_connection);
	self->priv->_connection = _tmp1_;
	_tmp2_ = self->priv->_note;
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp2_);
	_tmp4_ = _tmp3_;
	g_object_get (_tmp4_, "text", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (self->priv->_orig_note);
	self->priv->_orig_note = _tmp6_;
	result = FALSE;
	return result;
}

static gboolean
connection_inspector_note_focus_out (ConnectionInspector* self,
                                     GdkEventFocus* e)
{
	gboolean _tmp0_ = FALSE;
	Connection* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp1_ = self->priv->_connection;
	if (_tmp1_ != NULL) {
		Connection* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp2_ = self->priv->_connection;
		_tmp3_ = connection_get_note (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->_orig_note;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		DrawArea* _tmp6_;
		UndoBuffer* _tmp7_;
		UndoBuffer* _tmp8_;
		Connection* _tmp9_;
		const gchar* _tmp10_;
		UndoConnectionNote* _tmp11_;
		UndoConnectionNote* _tmp12_;
		_tmp6_ = self->priv->_da;
		_tmp7_ = draw_area_get_undo_buffer (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->priv->_connection;
		_tmp10_ = self->priv->_orig_note;
		_tmp11_ = undo_connection_note_new (_tmp9_, _tmp10_);
		_tmp12_ = _tmp11_;
		undo_buffer_add_item (_tmp8_, (UndoItem*) _tmp12_);
		_g_object_unref0 (_tmp12_);
	}
	result = FALSE;
	return result;
}

static gint
connection_inspector_note_node_link_added (ConnectionInspector* self,
                                           NodeLink* link,
                                           gchar** text)
{
	gchar* _vala_text = NULL;
	DrawArea* _tmp0_;
	gchar* _tmp1_ = NULL;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (link != NULL, 0);
	_tmp0_ = self->priv->_da;
	_tmp2_ = draw_area_add_note_node_link (_tmp0_, link, &_tmp1_);
	_g_free0 (_vala_text);
	_vala_text = _tmp1_;
	result = _tmp2_;
	if (text) {
		*text = _vala_text;
	} else {
		_g_free0 (_vala_text);
	}
	return result;
}

static void
connection_inspector_note_node_link_clicked (ConnectionInspector* self,
                                             gint id)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_note_node_link_clicked (_tmp0_, id);
}

static void
connection_inspector_note_node_link_hover (ConnectionInspector* self,
                                           gint id)
{
	NodeLink* link = NULL;
	DrawArea* _tmp0_;
	NodeLinks* _tmp1_;
	NodeLinks* _tmp2_;
	NodeLink* _tmp3_;
	NodeLink* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_node_links (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = node_links_get_node_link (_tmp2_, id);
	link = _tmp3_;
	_tmp4_ = link;
	if (_tmp4_ != NULL) {
		NoteView* _tmp5_;
		NodeLink* _tmp6_;
		DrawArea* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = self->priv->_note;
		_tmp6_ = link;
		_tmp7_ = self->priv->_da;
		_tmp8_ = node_link_get_tooltip (_tmp6_, _tmp7_);
		_tmp9_ = _tmp8_;
		note_view_show_tooltip (_tmp5_, _tmp9_);
		_g_free0 (_tmp9_);
	}
	_node_link_unref0 (link);
}

static void
connection_inspector_connection_delete (ConnectionInspector* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_delete_connection (_tmp0_);
}

void
connection_inspector_grab_note (ConnectionInspector* self)
{
	NoteView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_note;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

static GdkRGBA*
_vala_GdkRGBA_copy (GdkRGBA* self)
{
	return g_boxed_copy (gdk_rgba_get_type (), self);
}

static gpointer
__vala_GdkRGBA_copy0 (gpointer self)
{
	return self ? _vala_GdkRGBA_copy (self) : NULL;
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

static void
connection_inspector_connection_changed (ConnectionInspector* self)
{
	Connection* current = NULL;
	DrawArea* _tmp0_;
	Connection* _tmp1_;
	Connection* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_connection (_tmp0_);
	current = _tmp1_;
	_tmp2_ = current;
	if (_tmp2_ != NULL) {
		gchar* note = NULL;
		Connection* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		GdkRGBA* _tmp7_ = NULL;
		Connection* _tmp8_;
		GdkRGBA* _tmp9_;
		GdkRGBA* _tmp10_;
		GtkColorButton* _tmp19_;
		GdkRGBA _tmp20_;
		GtkColorButton* _tmp21_;
		NoteView* _tmp22_;
		GtkTextBuffer* _tmp23_;
		GtkTextBuffer* _tmp24_;
		const gchar* _tmp25_;
		GtkButton* _tmp26_;
		Connection* _tmp27_;
		GdkRGBA* _tmp28_;
		GdkRGBA* _tmp29_;
		_tmp3_ = current;
		_tmp4_ = connection_get_note (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		note = _tmp6_;
		_tmp8_ = current;
		_tmp9_ = connection_get_color (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ != NULL) {
			Connection* _tmp11_;
			GdkRGBA* _tmp12_;
			GdkRGBA* _tmp13_;
			GdkRGBA* _tmp14_;
			_tmp11_ = current;
			_tmp12_ = connection_get_color (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = __vala_GdkRGBA_copy0 (_tmp13_);
			__vala_GdkRGBA_free0 (_tmp7_);
			_tmp7_ = _tmp14_;
		} else {
			DrawArea* _tmp15_;
			Theme* _tmp16_;
			Theme* _tmp17_;
			GdkRGBA* _tmp18_;
			_tmp15_ = self->priv->_da;
			_tmp16_ = draw_area_get_theme (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = theme_get_color (_tmp17_, "connection_background");
			__vala_GdkRGBA_free0 (_tmp7_);
			_tmp7_ = _tmp18_;
			_g_object_unref0 (_tmp17_);
		}
		_tmp19_ = self->priv->_color;
		_tmp20_ = *_tmp7_;
		gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp19_, &_tmp20_);
		_tmp21_ = self->priv->_color;
		gtk_color_button_set_alpha (_tmp21_, (guint) 65535);
		_tmp22_ = self->priv->_note;
		_tmp23_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = note;
		g_object_set (_tmp24_, "text", _tmp25_, NULL);
		_tmp26_ = self->priv->_reset;
		_tmp27_ = current;
		_tmp28_ = connection_get_color (_tmp27_);
		_tmp29_ = _tmp28_;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp26_, _tmp29_ != NULL);
		__vala_GdkRGBA_free0 (_tmp7_);
		_g_free0 (note);
	}
	_g_object_unref0 (current);
}

void
connection_inspector_grab_first (ConnectionInspector* self)
{
	GtkColorButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_color;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

static void
connection_inspector_class_init (ConnectionInspectorClass * klass,
                                 gpointer klass_data)
{
	connection_inspector_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConnectionInspector_private_offset);
	G_OBJECT_CLASS (klass)->finalize = connection_inspector_finalize;
}

static void
connection_inspector_instance_init (ConnectionInspector * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	self->priv = connection_inspector_get_instance_private (self);
	self->priv->_da = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_orig_note = _tmp0_;
	self->priv->_connection = NULL;
}

static void
connection_inspector_finalize (GObject * obj)
{
	ConnectionInspector * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONNECTION_INSPECTOR, ConnectionInspector);
	_g_object_unref0 (self->priv->_sw);
	_g_object_unref0 (self->priv->_color);
	_g_object_unref0 (self->priv->_reset);
	_g_object_unref0 (self->priv->_note);
	_g_object_unref0 (self->priv->_da);
	_g_free0 (self->priv->_orig_note);
	_g_object_unref0 (self->priv->_connection);
	G_OBJECT_CLASS (connection_inspector_parent_class)->finalize (obj);
}

static GType
connection_inspector_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConnectionInspectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) connection_inspector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConnectionInspector), 0, (GInstanceInitFunc) connection_inspector_instance_init, NULL };
	GType connection_inspector_type_id;
	connection_inspector_type_id = g_type_register_static (gtk_box_get_type (), "ConnectionInspector", &g_define_type_info, 0);
	ConnectionInspector_private_offset = g_type_add_instance_private (connection_inspector_type_id, sizeof (ConnectionInspectorPrivate));
	return connection_inspector_type_id;
}

GType
connection_inspector_get_type (void)
{
	static volatile gsize connection_inspector_type_id__once = 0;
	if (g_once_init_enter (&connection_inspector_type_id__once)) {
		GType connection_inspector_type_id;
		connection_inspector_type_id = connection_inspector_get_type_once ();
		g_once_init_leave (&connection_inspector_type_id__once, connection_inspector_type_id);
	}
	return connection_inspector_type_id__once;
}

