#ifndef CFG_DEFS_H
#define CFG_DEFS_H 1

static const struct {
	const char *name;
	const char *value;
} config_cache[] = {
	{ "",	"" },
	{ "SYSTEM_MAIL",	"unknown" },
	{ "alt_char_set",	"acs_map" },
	{ "ansi_cc",	"-DCC_HAS_PROTOS" },
	{ "ar_flags",	"-curvU" },
	{ "baddef_remove",	"no" },
	{ "bool_defs",	"yes" },
	{ "build",	"x86_64-pc-linux-gnu" },
	{ "build_alias",	"x86_64-pc-linux-gnu" },
	{ "c11_noreturn",	"no," },
	{ "c_compiler_gnu",	"yes" },
	{ "c_inline",	"inline" },
	{ "chtype_decl",	"yes" },
	{ "chtype_type",	"scalar" },
	{ "color_curses",	"yes" },
	{ "curs_performance",	"no" },
	{ "curs_touchline",	"sysv" },
	{ "curses_dir",	"no" },
	{ "curses_incdir",	"no" },
	{ "dcl_errno",	"yes" },
	{ "define_sigwinch",	"yes" },
	{ "env_CC_set",	"" },
	{ "env_CC_value",	"" },
	{ "env_CFLAGS_set",	"set" },
	{ "env_CFLAGS_value",	"'-march=x86-64 -mtune=generic -O2 -pipe -fno-plt -fexceptions         -Wp,-D_FORTIFY_SOURCE=3 -Wformat -Werror=format-security         -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer -g -ffile-prefix-map=/build/lynx/src=/usr/src/debug/lynx'" },
	{ "env_CPPFLAGS_set",	"" },
	{ "env_CPPFLAGS_value",	"" },
	{ "env_CPP_set",	"" },
	{ "env_CPP_value",	"" },
	{ "env_LDFLAGS_set",	"set" },
	{ "env_LDFLAGS_value",	"'-Wl,-O1 -Wl,--sort-common -Wl,--as-needed -Wl,-z,relro -Wl,-z,now          -Wl,-z,pack-relative-relocs'" },
	{ "env_build_alias_set",	"" },
	{ "env_build_alias_value",	"" },
	{ "env_host_alias_set",	"" },
	{ "env_host_alias_value",	"" },
	{ "env_target_alias_set",	"" },
	{ "env_target_alias_value",	"" },
	{ "fancy_curses",	"yes" },
	{ "find_linkage_brotlidec",	"yes" },
	{ "find_linkage_bz2",	"yes" },
	{ "find_linkage_iconv",	"yes" },
	{ "find_linkage_idn2",	"yes" },
	{ "find_linkage_intl",	"yes" },
	{ "find_linkage_ssl",	"yes" },
	{ "find_linkage_z",	"yes" },
	{ "fionbio",	"ioctl" },
	{ "func__nc_free_and_exit",	"yes" },
	{ "func__nc_freeall",	"yes" },
	{ "func_alloca_works",	"yes" },
	{ "func_arc4random",	"yes" },
	{ "func_assume_default_colors",	"yes" },
	{ "func_atoll",	"yes" },
	{ "func_cbreak",	"yes" },
	{ "func_ctermid",	"yes" },
	{ "func_curses_exit",	"no" },
	{ "func_curses_version",	"yes" },
	{ "func_cuserid",	"yes" },
	{ "func_dcgettext",	"yes" },
	{ "func_decl_getgrgid",	"yes" },
	{ "func_decl_getgrnam",	"yes" },
	{ "func_decl_sleep",	"yes" },
	{ "func_decl_strstr",	"yes" },
	{ "func_define_key",	"yes" },
	{ "func_delscreen",	"yes" },
	{ "func_fork",	"yes" },
	{ "func_fork_works",	"yes" },
	{ "func_fseeko",	"yes" },
	{ "func_ftime",	"yes" },
	{ "func_getattrs",	"yes" },
	{ "func_getbegx",	"yes" },
	{ "func_getbegy",	"yes" },
	{ "func_getcwd",	"yes" },
	{ "func_getgroups",	"yes" },
	{ "func_gethostbyname",	"yes" },
	{ "func_gethostname",	"yes" },
	{ "func_getpwuid",	"yes" },
	{ "func_gettext",	"yes" },
	{ "func_gettimeofday",	"yes" },
	{ "func_getuid",	"yes" },
	{ "func_iconv",	"yes" },
	{ "func_inet_ntoa",	"yes" },
	{ "func_keypad",	"yes" },
	{ "func_lstat",	"yes" },
	{ "func_mkdtemp",	"yes" },
	{ "func_mktime",	"yes" },
	{ "func_napms",	"yes" },
	{ "func_newpad",	"yes" },
	{ "func_newterm",	"yes" },
	{ "func_pnoutrefresh",	"yes" },
	{ "func_popen",	"yes" },
	{ "func_putenv",	"yes" },
	{ "func_readdir",	"yes" },
	{ "func_resizeterm",	"yes" },
	{ "func_setuid",	"yes" },
	{ "func_sigaction",	"yes" },
	{ "func_sleep",	"yes" },
	{ "func_socket",	"yes" },
	{ "func_strcasecmp",	"yes" },
	{ "func_strerror",	"yes" },
	{ "func_strstr",	"yes" },
	{ "func_tgoto",	"no" },
	{ "func_touchline",	"yes" },
	{ "func_touchwin",	"yes" },
	{ "func_truncate",	"yes" },
	{ "func_ttyname",	"yes" },
	{ "func_unsetenv",	"yes" },
	{ "func_use_default_colors",	"yes" },
	{ "func_use_legacy_coding",	"yes" },
	{ "func_usleep",	"yes" },
	{ "func_vasprintf",	"yes" },
	{ "func_vfork",	"yes" },
	{ "func_vfork_works",	"yes" },
	{ "func_waitpid",	"yes" },
	{ "func_wattr_get",	"yes" },
	{ "func_wborder",	"yes" },
	{ "func_wcwidth",	"yes" },
	{ "func_wredrawln",	"yes" },
	{ "func_wresize",	"yes" },
	{ "func_zError",	"yes" },
	{ "getaddrinfo",	"yes" },
	{ "gnu_dftsrc_219",	"yes" },
	{ "gnu_library",	"yes" },
	{ "gnu_library_219",	"yes" },
	{ "gnutls_compat",	"no" },
	{ "have_decl_exit",	"yes" },
	{ "have_errno",	"no" },
	{ "have_h_errno",	"no" },
	{ "have_inet_aton",	"yes" },
	{ "have_ssl",	"yes" },
	{ "have_ttytype",	"yes" },
	{ "have_utmp",	"utmp" },
	{ "have_utmp_ut_host",	"yes" },
	{ "have_utmp_ut_name",	"ut_name" },
	{ "have_utmp_ut_session",	"yes" },
	{ "have_utmp_ut_syslen",	"no" },
	{ "have_utmp_ut_xstatus",	"ut_exit.e_exit" },
	{ "have_utmp_ut_xtime",	"yes" },
	{ "header_arpa_inet_h",	"yes" },
	{ "header_curses_term_h",	"no" },
	{ "header_dirent_dirent_h",	"yes" },
	{ "header_fcntl_h",	"yes" },
	{ "header_intl",	"" },
	{ "header_inttypes_h",	"yes" },
	{ "header_lastlog_h",	"yes" },
	{ "header_libgt",	"" },
	{ "header_libintl_h",	"yes" },
	{ "header_limits_h",	"yes" },
	{ "header_memory_h",	"yes" },
	{ "header_ncurses_h",	"yes" },
	{ "header_path_brotlidec",	"/usr/include" },
	{ "header_path_bz2",	"/usr/include" },
	{ "header_path_iconv",	"/usr/include" },
	{ "header_path_idn2",	"/usr/include" },
	{ "header_path_intl",	"/usr/include" },
	{ "header_path_ssl",	"/usr/include/openssl" },
	{ "header_path_z",	"/usr/include" },
	{ "header_paths_h",	"yes" },
	{ "header_pwd_h",	"yes" },
	{ "header_stdc",	"yes" },
	{ "header_stdint_h",	"yes" },
	{ "header_stdlib_h",	"yes" },
	{ "header_string_h",	"yes" },
	{ "header_strings_h",	"yes" },
	{ "header_sys_fcntl_h",	"yes" },
	{ "header_sys_filio_h",	"no" },
	{ "header_sys_ioctl_h",	"yes" },
	{ "header_sys_param_h",	"yes" },
	{ "header_sys_stat_h",	"yes" },
	{ "header_sys_termio_h",	"no" },
	{ "header_sys_time_h",	"yes" },
	{ "header_sys_timeb_h",	"yes" },
	{ "header_sys_types_h",	"yes" },
	{ "header_sys_wait_h",	"yes" },
	{ "header_syslog_h",	"yes" },
	{ "header_term_h",	"yes" },
	{ "header_termio_h",	"yes" },
	{ "header_termios_h",	"yes" },
	{ "header_time",	"yes" },
	{ "header_unistd_h",	"yes" },
	{ "header_vfork_h",	"no" },
	{ "header_wchar_h",	"yes" },
	{ "host",	"x86_64-pc-linux-gnu" },
	{ "host_alias",	"x86_64-pc-linux-gnu" },
	{ "ipv6type",	"linux-glibc" },
	{ "langinfo_codeset",	"yes" },
	{ "lib_dir_opendir",	"no" },
	{ "lib_dl_dlsym",	"yes" },
	{ "lib_inet_main",	"no" },
	{ "lib_ncurses___tgoto",	"yes" },
	{ "library_file_brotlidec",	"-lbrotlidec" },
	{ "library_file_bz2",	"-lbz2" },
	{ "library_file_idn2",	"-lidn2" },
	{ "library_file_z",	"-lz" },
	{ "library_path_brotlidec",	"/usr/lib" },
	{ "library_path_bz2",	"/usr/lib" },
	{ "library_path_iconv",	"/usr/lib" },
	{ "library_path_idn2",	"/usr/lib" },
	{ "library_path_intl",	"/usr/lib" },
	{ "library_path_ssl",	"" },
	{ "library_path_z",	"/usr/lib" },
	{ "locale",	"yes" },
	{ "make_PHONY",	"yes" },
	{ "makeflags",	"" },
	{ "mixedcase",	"yes" },
	{ "ncurses_broken",	"no" },
	{ "ncurses_header",	"ncurses.h" },
	{ "ncurses_version",	"6.5.20240427" },
	{ "need_xopen_extension",	"_XOPEN_SOURCE_EXTENDED" },
	{ "netlibs",	"" },
	{ "ngroups",	"yes" },
	{ "objext",	"o" },
	{ "path_BROTLI",	"/usr/bin/brotli" },
	{ "path_BZIP2",	"/usr/bin/bzip2" },
	{ "path_EGREP",	"'grep -E'" },
	{ "path_FGREP",	"'grep -F'" },
	{ "path_GMSGFMT",	"/usr/bin/msgfmt" },
	{ "path_GZIP",	"/usr/bin/gzip" },
	{ "path_INSTALL",	"'/usr/bin/install -c'" },
	{ "path_MSGFMT",	"/usr/bin/msgfmt" },
	{ "path_MSGINIT",	"/usr/bin/msginit" },
	{ "path_MV",	"/usr/bin/mv" },
	{ "path_RM",	"/usr/bin/rm" },
	{ "path_TAR",	"/usr/bin/tar" },
	{ "path_UNCOMPRESS",	"/usr/bin/gunzip" },
	{ "path_XGETTEXT",	"/usr/bin/xgettext" },
	{ "path_ZCAT",	"/usr/bin/zcat" },
	{ "path_ac_pt_PKG_CONFIG",	"/usr/bin/pkg-config" },
	{ "path_ac_pt_WINDRES",	"none" },
	{ "path_install",	"'/usr/bin/install -c'" },
	{ "path_lastlog",	"_PATH_LASTLOG" },
	{ "pkg_config_ssl",	"no" },
	{ "posix_visible",	"no" },
	{ "prog_CPP",	"'gcc -E'" },
	{ "prog_GREP",	"grep" },
	{ "prog_MAKE_LOWER_TAGS",	"no" },
	{ "prog_MAKE_UPPER_TAGS",	"no" },
	{ "prog_YACC",	"'bison -y'" },
	{ "prog_ac_ct_AR",	"ar" },
	{ "prog_ac_ct_CC",	"gcc" },
	{ "prog_ac_ct_RANLIB",	"ranlib" },
	{ "prog_cc_g",	"yes" },
	{ "prog_cc_stdc",	"" },
	{ "prog_cf_ldd_prog",	"ldd" },
	{ "prog_cpp_comments",	"yes" },
	{ "prog_make_make_set",	"yes" },
	{ "proto_iconv_arg1",	"" },
	{ "proto_iconv_const",	"no" },
	{ "pw_gecos",	"yes" },
	{ "rand_max",	"0xFFFFFFFFUL" },
	{ "screen",	"curses" },
	{ "set_errno",	"yes" },
	{ "sizechange",	"yes" },
	{ "sizeof",	"8" },
	{ "sizeof_int",	"4" },
	{ "sizeof_long",	"8" },
	{ "sizeof_off_t",	"8" },
	{ "sizeof_size_t",	"8" },
	{ "sizeof_time_t",	"8" },
	{ "srand_func",	"arc4random_stir/arc4random" },
	{ "struct_dirent64",	"no" },
	{ "sys_file_offset_bits",	"no" },
	{ "sys_large_files",	"no" },
	{ "sys_largefile_CC",	"no" },
	{ "sys_largefile_source",	"no" },
	{ "system_mail_flags",	"'-t -oi'" },
	{ "system_name",	"linux-gnu" },
	{ "sysv_utmp",	"yes" },
	{ "target",	"x86_64-pc-linux-gnu" },
	{ "target_alias",	"x86_64-pc-linux-gnu" },
	{ "term_header",	"term.h" },
	{ "termio_and_curses",	"yes" },
	{ "termio_and_termios",	"yes" },
	{ "tm_gmtoff",	"yes" },
	{ "type_getgroups",	"gid_t" },
	{ "type_int",	"yes" },
	{ "type_intptr_t",	"yes" },
	{ "type_long",	"yes" },
	{ "type_long_long",	"yes" },
	{ "type_mode_t",	"yes" },
	{ "type_off_t",	"yes" },
	{ "type_pid_t",	"yes" },
	{ "type_size_t",	"yes" },
	{ "type_socklen_t",	"yes" },
	{ "type_ssize_t",	"yes" },
	{ "type_time_t",	"yes" },
	{ "type_uid_t",	"yes" },
	{ "type_unionwait",	"no" },
	{ "unctrl_header",	"unctrl.h" },
	{ "use_libgnutls",	"no" },
	{ "use_libnss_compat",	"no" },
	{ "use_libsocks5",	"no" },
	{ "use_libsocks",	"no" },
	{ "use_libssl",	"/usr" },
	{ "working_alloca_h",	"yes" },
};

static const struct {
	const char *name;
	const char *value;
} config_defines[] = {
	{ "ALT_CHAR_SET",	"acs_map" },
	{ "BROTLI_PATH",	"\"/usr/bin/brotli\"" },
	{ "BZIP2_PATH",	"\"/usr/bin/bzip2\"" },
	{ "CAN_SET_ERRNO",	"1" },
	{ "CJK_EX",	"1" },
	{ "COLOR_CURSES",	"1" },
	{ "DIRED_SUPPORT",	"1" },
	{ "DISP_PARTIAL",	"1" },
	{ "ENABLE_IPV6",	"1" },
	{ "ENABLE_NLS",	"1" },
	{ "EXP_CHINESEUTF8_SUPPORT",	"1" },
	{ "FANCY_CURSES",	"1" },
	{ "GETGROUPS_T",	"gid_t" },
	{ "GZIP_PATH",	"\"/usr/bin/gzip\"" },
	{ "HAVE_ALLOCA",	"1" },
	{ "HAVE_ALLOCA_H",	"1" },
	{ "HAVE_ARPA_INET_H",	"1" },
	{ "HAVE_ASSUME_DEFAULT_COLORS",	"1" },
	{ "HAVE_ATOLL",	"1" },
	{ "HAVE_CBREAK",	"1" },
	{ "HAVE_CTERMID",	"1" },
	{ "HAVE_CURSES_VERSION",	"1" },
	{ "HAVE_CUSERID",	"1" },
	{ "HAVE_DEFINE_KEY",	"1" },
	{ "HAVE_DELSCREEN",	"1" },
	{ "HAVE_DIRENT_H",	"1" },
	{ "HAVE_FCNTL_H",	"1" },
	{ "HAVE_FTIME",	"1" },
	{ "HAVE_GAI_STRERROR",	"1" },
	{ "HAVE_GETADDRINFO",	"1" },
	{ "HAVE_GETATTRS",	"1" },
	{ "HAVE_GETBEGX",	"1" },
	{ "HAVE_GETBEGY",	"1" },
	{ "HAVE_GETBKGD",	"1" },
	{ "HAVE_GETCWD",	"1" },
	{ "HAVE_GETGROUPS",	"1" },
	{ "HAVE_GETPWUID",	"1" },
	{ "HAVE_GETTEXT",	"1" },
	{ "HAVE_GETTIMEOFDAY",	"1" },
	{ "HAVE_GETUID",	"1" },
	{ "HAVE_ICONV",	"1" },
	{ "HAVE_INET_ATON",	"1" },
	{ "HAVE_INTTYPES_H",	"1" },
	{ "HAVE_KEYPAD",	"1" },
	{ "HAVE_LANGINFO_CODESET",	"1" },
	{ "HAVE_LIBINTL_H",	"1" },
	{ "HAVE_LIMITS_H",	"1" },
	{ "HAVE_LONG_LONG",	"1" },
	{ "HAVE_LSTAT",	"1" },
	{ "HAVE_LYHELP_H",	"1" },
	{ "HAVE_MEMORY_H",	"1" },
	{ "HAVE_MKDTEMP",	"1" },
	{ "HAVE_MKTIME",	"1" },
	{ "HAVE_NAPMS",	"1" },
	{ "HAVE_NCURSES_H",	"1" },
	{ "HAVE_NEWPAD",	"1" },
	{ "HAVE_NEWTERM",	"1" },
	{ "HAVE_PNOUTREFRESH",	"1" },
	{ "HAVE_POPEN",	"1" },
	{ "HAVE_PUTENV",	"1" },
	{ "HAVE_PWD_H",	"1" },
	{ "HAVE_READDIR",	"1" },
	{ "HAVE_RESIZETERM",	"1" },
	{ "HAVE_SETUID",	"1" },
	{ "HAVE_SIGACTION",	"1" },
	{ "HAVE_SIZECHANGE",	"1" },
	{ "HAVE_SLEEP",	"1" },
	{ "HAVE_STDINT_H",	"1" },
	{ "HAVE_STDLIB_H",	"1" },
	{ "HAVE_STRERROR",	"1" },
	{ "HAVE_STRINGS_H",	"1" },
	{ "HAVE_STRING_H",	"1" },
	{ "HAVE_SYSLOG_H",	"1" },
	{ "HAVE_SYSV_TOUCHLINE",	"1" },
	{ "HAVE_SYS_FCNTL_H",	"1" },
	{ "HAVE_SYS_IOCTL_H",	"1" },
	{ "HAVE_SYS_PARAM_H",	"1" },
	{ "HAVE_SYS_STAT_H",	"1" },
	{ "HAVE_SYS_TIMEB_H",	"1" },
	{ "HAVE_SYS_TIME_H",	"1" },
	{ "HAVE_SYS_TYPES_H",	"1" },
	{ "HAVE_SYS_WAIT_H",	"1" },
	{ "HAVE_TERMIOS_H",	"1" },
	{ "HAVE_TERMIO_H",	"1" },
	{ "HAVE_TERM_H",	"1" },
	{ "HAVE_TOUCHLINE",	"1" },
	{ "HAVE_TOUCHWIN",	"1" },
	{ "HAVE_TRUNCATE",	"1" },
	{ "HAVE_TTYNAME",	"1" },
	{ "HAVE_TTYTYPE",	"1" },
	{ "HAVE_TYPE_CHTYPE",	"1" },
	{ "HAVE_UNISTD_H",	"1" },
	{ "HAVE_UNSETENV",	"1" },
	{ "HAVE_USE_DEFAULT_COLORS",	"1" },
	{ "HAVE_USE_LEGACY_CODING",	"1" },
	{ "HAVE_USLEEP",	"1" },
	{ "HAVE_UTMP",	"1" },
	{ "HAVE_UTMP_UT_HOST",	"1" },
	{ "HAVE_UTMP_UT_SESSION",	"1" },
	{ "HAVE_UTMP_UT_XSTATUS",	"1" },
	{ "HAVE_UTMP_UT_XTIME",	"1" },
	{ "HAVE_VASPRINTF",	"1" },
	{ "HAVE_WAITPID",	"1" },
	{ "HAVE_WATTR_GET",	"1" },
	{ "HAVE_WBORDER",	"1" },
	{ "HAVE_WCHAR_H",	"1" },
	{ "HAVE_WCWIDTH",	"1" },
	{ "HAVE_WREDRAWLN",	"1" },
	{ "HAVE_WRESIZE",	"1" },
	{ "HAVE_ZERROR",	"1" },
	{ "HAVE__NC_FREEALL",	"1" },
	{ "HAVE__NC_FREE_AND_EXIT",	"1" },
	{ "HOMEPAGE_URL",	"\"https://lynx.invisible-island.net/\"" },
	{ "ICONV_CONST",	"" },
	{ "INSTALL_ARGS",	"\"-c\"" },
	{ "INSTALL_PATH",	"\"/usr/bin/install\"" },
	{ "LOCALE",	"1" },
	{ "LONG_LIST",	"1" },
	{ "LYNX_CFG_FILE",	"\"/etc/lynx.cfg\"" },
	{ "LYNX_CFG_H",	"1" },
	{ "LYNX_CFG_PATH",	"\"/etc\"" },
	{ "LYNX_LSS_FILE",	"\"/etc/lynx.lss\"" },
	{ "LYNX_RAND_MAX",	"0xFFFFFFFFUL" },
	{ "MIME_LIBDIR",	"\"/etc/\"" },
	{ "MV_PATH",	"\"/usr/bin/mv\"" },
	{ "NCURSES",	"1" },
	{ "NLS_TEXTDOMAIN",	"\"lynx\"" },
	{ "OK_GZIP",	"1" },
	{ "OK_OVERRIDE",	"1" },
	{ "OK_PERMIT",	"1" },
	{ "OK_TAR",	"1" },
	{ "OK_UUDECODE",	"1" },
	{ "OK_ZIP",	"1" },
	{ "RM_PATH",	"\"/usr/bin/rm\"" },
	{ "SIZEOF_INT",	"4" },
	{ "SIZEOF_LONG",	"8" },
	{ "SIZEOF_OFF_T",	"8" },
	{ "SIZEOF_SIZE_T",	"8" },
	{ "SIZEOF_TIME_T",	"8" },
	{ "STDC_HEADERS",	"1" },
	{ "SYSTEM_MAIL",	"\"unknown\"" },
	{ "SYSTEM_MAIL_FLAGS",	"\"-t -oi\"" },
	{ "SYSTEM_NAME",	"\"linux-gnu\"" },
	{ "TAR_DOWN_OPTIONS",	"\"-xf\"" },
	{ "TAR_FILE_OPTIONS",	"\"\"" },
	{ "TAR_PATH",	"\"/usr/bin/tar\"" },
	{ "TAR_PIPE_OPTIONS",	"\"-\"" },
	{ "TAR_UP_OPTIONS",	"\"-cf\"" },
	{ "TERMIO_AND_CURSES",	"1" },
	{ "TIME_WITH_SYS_TIME",	"1" },
	{ "UNCOMPRESS_PATH",	"\"/usr/bin/gunzip\"" },
	{ "UNDERLINE_LINKS",	"0" },
	{ "UNIX",	"1" },
	{ "USE_ADDRLIST_PAGE",	"1" },
	{ "USE_ALT_BINDINGS",	"1" },
	{ "USE_ASCII_CTYPES",	"1" },
	{ "USE_BROTLI",	"1" },
	{ "USE_BZLIB",	"1" },
	{ "USE_CACHEJAR",	"1" },
	{ "USE_COLOR_STYLE",	"1" },
	{ "USE_DEFAULT_COLORS",	"1" },
	{ "USE_EXTERNALS",	"1" },
	{ "USE_FILE_UPLOAD",	"1" },
	{ "USE_IDN2",	"1" },
	{ "USE_JAPANESEUTF8_SUPPORT",	"1" },
	{ "USE_JUSTIFY_ELTS",	"1" },
	{ "USE_LOCALE_CHARSET",	"1" },
	{ "USE_OPENSSL_INCL",	"1" },
	{ "USE_PERSISTENT_COOKIES",	"1" },
	{ "USE_PRETTYSRC",	"1" },
	{ "USE_PROGRESSBAR",	"1" },
	{ "USE_READPROGRESS",	"1" },
	{ "USE_SCROLLBAR",	"1" },
	{ "USE_SESSIONS",	"1" },
	{ "USE_SOURCE_CACHE",	"1" },
	{ "USE_SSL",	"1" },
	{ "USE_SYSV_UTMP",	"1" },
	{ "USE_X509_SUPPORT",	"1" },
	{ "USE_ZLIB",	"1" },
	{ "ZCAT_PATH",	"\"/usr/bin/zcat\"" },
	{ "lstat",	"stat" },
	{ "lynx_rand",	"arc4random" },
	{ "lynx_srand",	"(void)" },
	{ "ut_xstatus",	"ut_exit.e_exit" },
};

#endif /* CFG_DEFS_H */
