/* ----------------------------------------------------------------------------
  Copyright (c) 2021, Daan Leijen
  This is free software; you can redistribute it and/or modify it
  under the terms of the MIT License. A copy of the license can be
  found in the "LICENSE" file at the root of this distribution.
-----------------------------------------------------------------------------*/

// This file is included from "bbcode.c" and contains html color names

#include "common.h"

typedef struct style_color_s {
  const char* name;
  ic_color_t color;
} style_color_t;

#define IC_HTML_COLOR_COUNT (172)

// ordered list of HTML color names (so we can use binary search)
static style_color_t html_colors[IC_HTML_COLOR_COUNT+1] = {
  { "aliceblue",      IC_RGB(0xf0f8ff) },
  { "ansi-aqua",      IC_ANSI_AQUA },
  { "ansi-black",     IC_ANSI_BLACK },
  { "ansi-blue",      IC_ANSI_BLUE },
  { "ansi-cyan",      IC_ANSI_CYAN },
  { "ansi-darkgray",  IC_ANSI_DARKGRAY },
  { "ansi-darkgrey",  IC_ANSI_DARKGRAY },
  { "ansi-default",   IC_ANSI_DEFAULT },
  { "ansi-fuchsia",   IC_ANSI_FUCHSIA },
  { "ansi-gray",      IC_ANSI_GRAY },
  { "ansi-green",     IC_ANSI_GREEN },
  { "ansi-grey",      IC_ANSI_GRAY },
  { "ansi-lightgray", IC_ANSI_LIGHTGRAY },
  { "ansi-lightgrey", IC_ANSI_LIGHTGRAY },
  { "ansi-lime" ,     IC_ANSI_LIME },
  { "ansi-magenta",   IC_ANSI_MAGENTA },
  { "ansi-maroon",    IC_ANSI_MAROON },
  { "ansi-navy",      IC_ANSI_NAVY },
  { "ansi-olive",     IC_ANSI_OLIVE },
  { "ansi-purple",    IC_ANSI_PURPLE },
  { "ansi-red",       IC_ANSI_RED },
  { "ansi-silver",    IC_ANSI_SILVER },
  { "ansi-teal",      IC_ANSI_TEAL },
  { "ansi-white",     IC_ANSI_WHITE },
  { "ansi-yellow",    IC_ANSI_YELLOW },
  { "antiquewhite",   IC_RGB(0xfaebd7) },
  { "aqua", IC_RGB(0x00ffff) },
  { "aquamarine", IC_RGB(0x7fffd4) },
  { "azure", IC_RGB(0xf0ffff) },
  { "beige", IC_RGB(0xf5f5dc) },
  { "bisque", IC_RGB(0xffe4c4) },
  { "black", IC_RGB(0x000000) },
  { "blanchedalmond", IC_RGB(0xffebcd) },
  { "blue", IC_RGB(0x0000ff) },
  { "blueviolet", IC_RGB(0x8a2be2) },
  { "brown", IC_RGB(0xa52a2a) },
  { "burlywood", IC_RGB(0xdeb887) },
  { "cadetblue", IC_RGB(0x5f9ea0) },
  { "chartreuse", IC_RGB(0x7fff00) },
  { "chocolate", IC_RGB(0xd2691e) },
  { "coral", IC_RGB(0xff7f50) },
  { "cornflowerblue", IC_RGB(0x6495ed) },
  { "cornsilk", IC_RGB(0xfff8dc) },
  { "crimson", IC_RGB(0xdc143c) },
  { "cyan", IC_RGB(0x00ffff) },
  { "darkblue", IC_RGB(0x00008b) },
  { "darkcyan", IC_RGB(0x008b8b) },
  { "darkgoldenrod", IC_RGB(0xb8860b) },
  { "darkgray", IC_RGB(0xa9a9a9) },
  { "darkgreen", IC_RGB(0x006400) },
  { "darkgrey", IC_RGB(0xa9a9a9) },
  { "darkkhaki", IC_RGB(0xbdb76b) },
  { "darkmagenta", IC_RGB(0x8b008b) },
  { "darkolivegreen", IC_RGB(0x556b2f) },
  { "darkorange", IC_RGB(0xff8c00) },
  { "darkorchid", IC_RGB(0x9932cc) },
  { "darkred", IC_RGB(0x8b0000) },
  { "darksalmon", IC_RGB(0xe9967a) },
  { "darkseagreen", IC_RGB(0x8fbc8f) },
  { "darkslateblue", IC_RGB(0x483d8b) },
  { "darkslategray", IC_RGB(0x2f4f4f) },
  { "darkslategrey", IC_RGB(0x2f4f4f) },
  { "darkturquoise", IC_RGB(0x00ced1) },
  { "darkviolet", IC_RGB(0x9400d3) },
  { "deeppink", IC_RGB(0xff1493) },
  { "deepskyblue", IC_RGB(0x00bfff) },
  { "dimgray", IC_RGB(0x696969) },
  { "dimgrey", IC_RGB(0x696969) },
  { "dodgerblue", IC_RGB(0x1e90ff) },
  { "firebrick", IC_RGB(0xb22222) },
  { "floralwhite", IC_RGB(0xfffaf0) },
  { "forestgreen", IC_RGB(0x228b22) },
  { "fuchsia", IC_RGB(0xff00ff) },
  { "gainsboro", IC_RGB(0xdcdcdc) },
  { "ghostwhite", IC_RGB(0xf8f8ff) },
  { "gold", IC_RGB(0xffd700) },
  { "goldenrod", IC_RGB(0xdaa520) },
  { "gray", IC_RGB(0x808080) },
  { "green", IC_RGB(0x008000) },
  { "greenyellow", IC_RGB(0xadff2f) },
  { "grey", IC_RGB(0x808080) },
  { "honeydew", IC_RGB(0xf0fff0) },
  { "hotpink", IC_RGB(0xff69b4) },
  { "indianred", IC_RGB(0xcd5c5c) },
  { "indigo", IC_RGB(0x4b0082) },
  { "ivory", IC_RGB(0xfffff0) },
  { "khaki", IC_RGB(0xf0e68c) },
  { "lavender", IC_RGB(0xe6e6fa) },
  { "lavenderblush", IC_RGB(0xfff0f5) },
  { "lawngreen", IC_RGB(0x7cfc00) },
  { "lemonchiffon", IC_RGB(0xfffacd) },
  { "lightblue", IC_RGB(0xadd8e6) },
  { "lightcoral", IC_RGB(0xf08080) },
  { "lightcyan", IC_RGB(0xe0ffff) },
  { "lightgoldenrodyellow", IC_RGB(0xfafad2) },
  { "lightgray", IC_RGB(0xd3d3d3) },
  { "lightgreen", IC_RGB(0x90ee90) },
  { "lightgrey", IC_RGB(0xd3d3d3) },
  { "lightpink", IC_RGB(0xffb6c1) },
  { "lightsalmon", IC_RGB(0xffa07a) },
  { "lightseagreen", IC_RGB(0x20b2aa) },
  { "lightskyblue", IC_RGB(0x87cefa) },
  { "lightslategray", IC_RGB(0x778899) },
  { "lightslategrey", IC_RGB(0x778899) },
  { "lightsteelblue", IC_RGB(0xb0c4de) },
  { "lightyellow", IC_RGB(0xffffe0) },
  { "lime", IC_RGB(0x00ff00) },
  { "limegreen", IC_RGB(0x32cd32) },
  { "linen", IC_RGB(0xfaf0e6) },
  { "magenta", IC_RGB(0xff00ff) },
  { "maroon", IC_RGB(0x800000) },
  { "mediumaquamarine", IC_RGB(0x66cdaa) },
  { "mediumblue", IC_RGB(0x0000cd) },
  { "mediumorchid", IC_RGB(0xba55d3) },
  { "mediumpurple", IC_RGB(0x9370db) },
  { "mediumseagreen", IC_RGB(0x3cb371) },
  { "mediumslateblue", IC_RGB(0x7b68ee) },
  { "mediumspringgreen", IC_RGB(0x00fa9a) },
  { "mediumturquoise", IC_RGB(0x48d1cc) },
  { "mediumvioletred", IC_RGB(0xc71585) },
  { "midnightblue", IC_RGB(0x191970) },
  { "mintcream", IC_RGB(0xf5fffa) },
  { "mistyrose", IC_RGB(0xffe4e1) },
  { "moccasin", IC_RGB(0xffe4b5) },
  { "navajowhite", IC_RGB(0xffdead) },
  { "navy", IC_RGB(0x000080) },
  { "oldlace", IC_RGB(0xfdf5e6) },
  { "olive", IC_RGB(0x808000) },
  { "olivedrab", IC_RGB(0x6b8e23) },
  { "orange", IC_RGB(0xffa500) },
  { "orangered", IC_RGB(0xff4500) },
  { "orchid", IC_RGB(0xda70d6) },
  { "palegoldenrod", IC_RGB(0xeee8aa) },
  { "palegreen", IC_RGB(0x98fb98) },
  { "paleturquoise", IC_RGB(0xafeeee) },
  { "palevioletred", IC_RGB(0xdb7093) },
  { "papayawhip", IC_RGB(0xffefd5) },
  { "peachpuff", IC_RGB(0xffdab9) },
  { "peru", IC_RGB(0xcd853f) },
  { "pink", IC_RGB(0xffc0cb) },
  { "plum", IC_RGB(0xdda0dd) },
  { "powderblue", IC_RGB(0xb0e0e6) },
  { "purple", IC_RGB(0x800080) },
  { "rebeccapurple", IC_RGB(0x663399) },
  { "red", IC_RGB(0xff0000) },
  { "rosybrown", IC_RGB(0xbc8f8f) },
  { "royalblue", IC_RGB(0x4169e1) },
  { "saddlebrown", IC_RGB(0x8b4513) },
  { "salmon", IC_RGB(0xfa8072) },
  { "sandybrown", IC_RGB(0xf4a460) },
  { "seagreen", IC_RGB(0x2e8b57) },
  { "seashell", IC_RGB(0xfff5ee) },
  { "sienna", IC_RGB(0xa0522d) },
  { "silver", IC_RGB(0xc0c0c0) },
  { "skyblue", IC_RGB(0x87ceeb) },
  { "slateblue", IC_RGB(0x6a5acd) },
  { "slategray", IC_RGB(0x708090) },
  { "slategrey", IC_RGB(0x708090) },
  { "snow", IC_RGB(0xfffafa) },
  { "springgreen", IC_RGB(0x00ff7f) },
  { "steelblue", IC_RGB(0x4682b4) },
  { "tan", IC_RGB(0xd2b48c) },
  { "teal", IC_RGB(0x008080) },
  { "thistle", IC_RGB(0xd8bfd8) },
  { "tomato", IC_RGB(0xff6347) },
  { "turquoise", IC_RGB(0x40e0d0) },
  { "violet", IC_RGB(0xee82ee) },
  { "wheat", IC_RGB(0xf5deb3) },
  { "white", IC_RGB(0xffffff) },
  { "whitesmoke", IC_RGB(0xf5f5f5) },
  { "yellow", IC_RGB(0xffff00) },
  { "yellowgreen", IC_RGB(0x9acd32) },
  {NULL, 0}
}; 
