/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Property definitions for LLDB.                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: TargetProperties.td                                                  *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// Property definitions for language
#ifdef LLDB_PROPERTIES_language
static constexpr PropertyDefinition g_language_properties[] = {
  {"enable-filter-for-line-breakpoints", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "If true, allow Language plugins to filter locations when setting breakpoints by line number or regex."},
};
#undef LLDB_PROPERTIES_language
#endif // language Property

// Property definitions for platform
#ifdef LLDB_PROPERTIES_platform
static constexpr PropertyDefinition g_platform_properties[] = {
  {"module-cache-directory", OptionValue::eTypeFileSpec, true, 0, "", {}, "Root directory for cached modules."},
  {"use-module-cache", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "Use module cache."},
};
#undef LLDB_PROPERTIES_platform
#endif // platform Property

// Property definitions for process
#ifdef LLDB_PROPERTIES_process
static constexpr PropertyDefinition g_process_properties[] = {
  {"detach-keeps-stopped", OptionValue::eTypeBoolean, true, 0, nullptr, {}, "If true, detach will attempt to keep the process stopped."},
  {"disable-language-runtime-unwindplans", OptionValue::eTypeBoolean, true, 0, nullptr, {}, "If true, language runtime augmented/overridden backtraces will not be used when printing a stack trace."},
  {"disable-memory-cache", OptionValue::eTypeBoolean, false, 0, nullptr, {}, "Disable reading and caching of memory in fixed-size units."},
  {"extra-startup-command", OptionValue::eTypeArray, false, OptionValue::eTypeString, nullptr, {}, "A list containing extra commands understood by the particular process plugin used.  For instance, to turn on debugserver logging set this to 'QSetLogging:bitmask=LOG_DEFAULT;'"},
  {"follow-fork-mode", OptionValue::eTypeEnum, false, eFollowParent, nullptr, OptionEnumValues(g_follow_fork_mode_values), "Debugger's behavior upon fork or vfork."},
  {"highmem-virtual-addressable-bits", OptionValue::eTypeUInt64, false, 0, nullptr, {}, "The number of bits used for addressing high memory, when it differs from low memory in the same Process. When this is non-zero, target.process.virtual-addressable-bits will be the value for low memory (0x000... addresses) and this setting will be the value for high memory (0xfff... addresses). When this is zero, target.process.virtual-addressable-bits applies to all addresses. It is very uncommon to use this setting."},
  {"ignore-breakpoints-in-expressions", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "If true, breakpoints will be ignored during expression evaluation."},
  {"interrupt-timeout", OptionValue::eTypeUInt64, false, 20, nullptr, {}, "The time in seconds to wait for an interrupt succeed in stopping the target."},
  {"memory-cache-line-size", OptionValue::eTypeUInt64, false, 512, nullptr, {}, "The memory cache line size"},
  {"python-os-plugin-path", OptionValue::eTypeFileSpec, false, 1, nullptr, {}, "A path to a python OS plug-in module file that contains a OperatingSystemPlugIn class."},
  {"run-all-threads", OptionValue::eTypeBoolean, false, 0, nullptr, {}, "If true, stepping operations will run all threads.  This is equivalent to setting the run-mode option to 'all-threads'."},
  {"stop-on-exec", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "If true, stop when the inferior exec's."},
  {"stop-on-sharedlibrary-events", OptionValue::eTypeBoolean, true, 0, nullptr, {}, "If true, stop when a shared library is loaded or unloaded."},
  {"unwind-on-error-in-expressions", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "If true, errors in expression evaluation will unwind the stack back to the state before the call."},
  {"utility-expression-timeout", OptionValue::eTypeUInt64, false, 15, nullptr, {}, "The time in seconds to wait for LLDB-internal utility expressions."},
  {"virtual-addressable-bits", OptionValue::eTypeUInt64, false, 0, nullptr, {}, "The number of bits used for addressing. If the value is 39, then bits 0..38 are used for addressing. The default value of 0 means unspecified."},
  {"optimization-warnings", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "If true, warn when stopped in code that is optimized where stepping and variable availability may not behave as expected."},
  {"unsupported-language-warnings", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "If true, warn when stopped in code that is written in a source language that LLDB does not support."},
};
#undef LLDB_PROPERTIES_process
#endif // process Property

// Property definitions for process_experimental
#ifdef LLDB_PROPERTIES_process_experimental
static constexpr PropertyDefinition g_process_experimental_properties[] = {
  {"os-plugin-reports-all-threads", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "Set to False if your Python OS Plugin doesn't report all threads on each stop."},
};
#undef LLDB_PROPERTIES_process_experimental
#endif // process_experimental Property

// Property definitions for target
#ifdef LLDB_PROPERTIES_target
static constexpr PropertyDefinition g_target_properties[] = {
  {"arg0", OptionValue::eTypeString, false, 0, "", {}, "The first argument passed to the program in the argument array which can be different from the executable itself."},
  {"auto-apply-fixits", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "Automatically apply fix-it hints to expressions."},
  {"auto-import-clang-modules", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "Automatically load Clang modules referred to by the program."},
  {"auto-install-main-executable", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "Always install the main executable when connected to a remote platform."},
  {"auto-source-map-relative", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "Automatically deduce source path mappings based on source file breakpoint resolution. It only deduces source mapping if source file breakpoint request is using full path and if the debug info contains relative paths."},
  {"breakpoints-use-platform-avoid-list", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "Consult the platform module avoid list when setting non-module specific breakpoints."},
  {"clang-module-search-paths", OptionValue::eTypeFileSpecList, false, 0, "", {}, "List of directories to be searched when locating modules for Clang."},
  {"debug-file-search-paths", OptionValue::eTypeFileSpecList, false, 0, "", {}, "List of directories to be searched when locating debug symbol files. See also symbols.enable-external-lookup."},
  {"debug-utility-expression", OptionValue::eTypeBoolean, false, 0, nullptr, {}, "Enable debugging of LLDB-internal utility expressions."},
  {"default-arch", OptionValue::eTypeArch, true, 0, "", {}, "Default architecture to choose, when there's a choice."},
  {"detach-on-error", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "debugserver will detach (rather than killing) a process if it loses connection with lldb."},
  {"disable-aslr", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "Disable Address Space Layout Randomization (ASLR)"},
  {"disable-stdio", OptionValue::eTypeBoolean, false, 0, nullptr, {}, "Disable stdin/stdout for process (e.g. for a GUI application)"},
  {"disassembly-cpu", OptionValue::eTypeString, false, 0, "", {}, "Override the CPU for disassembling. Takes the same values as the -mcpu clang flag."},
  {"disassembly-features", OptionValue::eTypeString, false, 0, "", {}, "Specify additional CPU features for disassembling."},
  {"x86-disassembly-flavor", OptionValue::eTypeEnum, false, eX86DisFlavorDefault, nullptr, OptionEnumValues(g_x86_dis_flavor_value_types), "The default disassembly flavor to use for x86 or x86-64 targets."},
  {"display-expression-in-crashlogs", OptionValue::eTypeBoolean, false, 0, nullptr, {}, "Expressions that crash will show up in crash logs if the host system supports executable specific crash log strings and this setting is set to true."},
  {"display-recognized-arguments", OptionValue::eTypeBoolean, false, 0, nullptr, {}, "Show recognized arguments in variable listings by default."},
  {"display-runtime-support-values", OptionValue::eTypeBoolean, false, 0, nullptr, {}, "If true, LLDB will show variables that are meant to support the operation of a language's runtime support."},
  {"objc-dynamic-class-extractor", OptionValue::eTypeEnum, false, eDynamicClassInfoHelperAuto, nullptr, OptionEnumValues(g_dynamic_class_info_helper_value_types), "Configure how LLDB parses dynamic Objective-C class metadata. By default LLDB will choose the most appropriate method for the target OS."},
  {"enable-synthetic-value", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "Should synthetic values be used by default whenever available."},
  {"env-vars", OptionValue::eTypeDictionary, false, OptionValue::eTypeString, nullptr, {}, "A list of user provided environment variables to be passed to the executable's environment, and their values."},
  {"error-path", OptionValue::eTypeFileSpec, false, 0, "", {}, "The file/path to be used by the executable program for writing its standard error."},
  {"exec-search-paths", OptionValue::eTypeFileSpecList, false, 0, "", {}, "Executable search paths to use when locating executable files whose paths don't match the local file system."},
  {"expr-alloc-address", OptionValue::eTypeUInt64, false, 0, nullptr, {}, "Start address within the process address space of memory allocation for expression evaluation."},
  {"expr-alloc-align", OptionValue::eTypeUInt64, false, 0, nullptr, {}, "Alignment for each memory allocation for expression evaluation."},
  {"expr-alloc-size", OptionValue::eTypeUInt64, false, 0, nullptr, {}, "Amount of memory in bytes to allocate for expression evaluation."},
  {"expr-error-limit", OptionValue::eTypeUInt64, false, 5, nullptr, {}, "The maximum amount of errors to emit while parsing an expression. A value of 0 means to always continue parsing if possible."},
  {"expr-prefix", OptionValue::eTypeFileSpec, false, 0, "", {}, "Path to a file containing expressions to be prepended to all expressions."},
  {"hex-immediate-style", OptionValue::eTypeEnum, false, Disassembler::eHexStyleC, nullptr, OptionEnumValues(g_hex_immediate_style_values), "Which style to use for printing hexadecimal disassembly values."},
  {"import-std-module", OptionValue::eTypeEnum, false, eImportStdModuleFalse, nullptr, OptionEnumValues(g_import_std_module_value_types), "Import the 'std' C++ module to improve expression parsing involving  C++ standard library types."},
  {"inherit-env", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "Inherit the environment from the process that is running LLDB."},
  {"inherit-tcc", OptionValue::eTypeBoolean, false, 0, nullptr, {}, "Inherit the TCC permissions from the inferior's parent instead of making the process itself responsible."},
  {"inline-breakpoint-strategy", OptionValue::eTypeEnum, false, eInlineBreakpointsAlways, nullptr, OptionEnumValues(g_inline_breakpoint_enums), "The strategy to use when settings breakpoints by file and line. Breakpoint locations can end up being inlined by the compiler, so that a compile unit 'a.c' might contain an inlined function from another source file. Usually this is limited to breakpoint locations from inlined functions from header or other include files, or more accurately non-implementation source files. Sometimes code might #include implementation files and cause inlined breakpoint locations in inlined implementation files. Always checking for inlined breakpoint locations can be expensive (memory and time), so if you have a project with many headers and find that setting breakpoints is slow, then you can change this setting to headers. This setting allows you to control exactly which strategy is used when setting file and line breakpoints."},
  {"input-path", OptionValue::eTypeFileSpec, false, 0, "", {}, "The file/path to be used by the executable program for reading its standard input."},
  {"language", OptionValue::eTypeLanguage, false, eLanguageTypeUnknown, nullptr, {}, "The language to use when interpreting expressions entered in commands."},
  {"launch-working-dir", OptionValue::eTypeString, false, 0, "", {}, "A default value for the working directory to use when launching processes. It is ignored when empty. This setting is only used when the target is launched. If you change this setting, the new value will only apply to subsequent launches. Commands that take an explicit working directory will override this setting."},
  {"load-cwd-lldbinit", OptionValue::eTypeEnum, false, eLoadCWDlldbinitWarn, nullptr, OptionEnumValues(g_load_cwd_lldbinit_values), "Allow LLDB to .lldbinit files from the current directory automatically."},
  {"load-script-from-symbol-file", OptionValue::eTypeEnum, false, eLoadScriptFromSymFileWarn, nullptr, OptionEnumValues(g_load_script_from_sym_file_values), "Allow LLDB to load scripting resources embedded in symbol files when available."},
  {"max-children-count", OptionValue::eTypeUInt64, false, 256, nullptr, {}, "Maximum number of children to expand in any level of depth."},
  {"max-children-depth", OptionValue::eTypeUInt64, false, 4294967295, nullptr, {}, "Maximum depth to expand children."},
  {"max-memory-read-size", OptionValue::eTypeUInt64, false, 4294967295, nullptr, {}, "Maximum number of bytes that 'memory read' will fetch before --force must be specified."},
  {"max-string-summary-length", OptionValue::eTypeUInt64, false, 1024, nullptr, {}, "Maximum number of characters to show when using %s in summary strings."},
  {"max-zero-padding-in-float-format", OptionValue::eTypeUInt64, false, 6, nullptr, {}, "The maximum number of zeroes to insert when displaying a very small float before falling back to scientific notation."},
  {"memory-module-load-level", OptionValue::eTypeEnum, false, eMemoryModuleLoadLevelComplete, nullptr, OptionEnumValues(g_memory_module_load_level_values), "Loading modules from memory can be slow as reading the symbol tables and other data can take a long time depending on your connection to the debug target. This setting helps users control how much information gets loaded when loading modules from memory.'complete' is the default value for this setting which will load all sections and symbols by reading them from memory (slowest, most accurate). 'partial' will load sections and attempt to find function bounds without downloading the symbol table (faster, still accurate, missing symbol names). 'minimal' is the fastest setting and will load section data with no symbols, but should rarely be used as stack frames in these memory regions will be inaccurate and not provide any context (fastest). "},
  {"move-to-nearest-code", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "Move breakpoints to nearest code."},
  {"notify-about-fixits", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "Print the fixed expression text."},
  {"object-map", OptionValue::eTypePathMap, false, 0, "", {}, "Object path remappings apply substitutions to the paths of object files, typically needed to debug from a different host than the one that built the target.  The object-map property consists of an array of pairs, the first element is a path prefix, and the second is its replacement.  The syntax is `prefix1 replacement1 prefix2 replacement2...`.  The pairs are checked in order, the first prefix that matches is used, and that prefix is substituted with the replacement."},
  {"output-path", OptionValue::eTypeFileSpec, false, 0, "", {}, "The file/path to be used by the executable program for writing its standard output."},
  {"prefer-dynamic-value", OptionValue::eTypeEnum, false, eDynamicDontRunTarget, nullptr, OptionEnumValues(g_dynamic_value_types), "Should printed values be shown as their dynamic value."},
  {"preload-symbols", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "Enable loading of symbol tables before they are needed."},
  {"require-hardware-breakpoint", OptionValue::eTypeBoolean, false, 0, nullptr, {}, "Require all breakpoints to be hardware breakpoints."},
  {"retries-with-fixits", OptionValue::eTypeUInt64, false, 1, nullptr, {}, "Maximum number of attempts to fix an expression with Fix-Its"},
  {"run-args", OptionValue::eTypeArgs, false, 0, "", {}, "A list containing all the arguments to be passed to the executable when it is run. Note that this does NOT include the argv[0] which is in target.arg0."},
  {"save-jit-objects-dir", OptionValue::eTypeFileSpec, false, 0, "", {}, "If specified, the directory to save intermediate object files generated by the LLVM JIT"},
  {"show-hex-variable-values-with-leading-zeroes", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "Whether to display leading zeroes when printing variable values in hex format."},
  {"skip-prologue", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "Skip function prologues when setting breakpoints by name."},
  {"source-map", OptionValue::eTypePathMap, false, 0, "", {}, "Source path remappings apply substitutions to the paths of source files, typically needed to debug from a different host than the one that built the target.  The source-map property consists of an array of pairs, the first element is a path prefix, and the second is its replacement.  The syntax is `prefix1 replacement1 prefix2 replacement2...`.  The pairs are checked in order, the first prefix that matches is used, and that prefix is substituted with the replacement.  A common pattern is to use source-map in conjunction with the clang -fdebug-prefix-map flag.  In the build, use `-fdebug-prefix-map=/path/to/build_dir=.` to rewrite the host specific build directory to `.`.  Then for debugging, use `settings set target.source-map . /path/to/local_dir` to convert `.` to a valid local path."},
  {"source-realpath-prefixes", OptionValue::eTypeFileSpecList, false, 0, "", {}, "Realpath any source paths that start with one of these prefixes. If the debug info contains symlinks which match the original source file's basename but don't match its location that the user will use to set breakpoints, then this setting can help resolve breakpoints correctly. This handles both symlinked files and directories. Wild card prefixes: An empty string matches all paths. A forward slash matches absolute paths."},
  {"trap-handler-names", OptionValue::eTypeArray, true, OptionValue::eTypeString, nullptr, {}, "A list of trap handler function names, e.g. a common Unix user process one is _sigtramp."},
  {"unset-env-vars", OptionValue::eTypeArray, false, OptionValue::eTypeString, nullptr, {}, "A list of environment variable names to be unset in the inferior's environment. This is most useful to unset some host environment variables when target.inherit-env is true. target.env-vars takes precedence over target.unset-env-vars."},
  {"use-fast-stepping", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "Use a fast stepping algorithm based on running from branch to branch rather than instruction single-stepping."},
  {"use-hex-immediates", OptionValue::eTypeBoolean, false, 1, nullptr, {}, "Show immediates in disassembly as hexadecimal."},
};
#undef LLDB_PROPERTIES_target
#endif // target Property

// Property definitions for target_experimental
#ifdef LLDB_PROPERTIES_target_experimental
static constexpr PropertyDefinition g_target_experimental_properties[] = {
  {"inject-local-vars", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "If true, inject local variables explicitly into the expression text. This will fix symbol resolution when there are name collisions between ivars and local variables. But it can make expressions run much more slowly."},
  {"use-DIL", OptionValue::eTypeBoolean, true, 0, nullptr, {}, "If true, use the alternative DIL implementation for frame variable evaluation."},
};
#undef LLDB_PROPERTIES_target_experimental
#endif // target_experimental Property

// Property definitions for thread
#ifdef LLDB_PROPERTIES_thread
static constexpr PropertyDefinition g_thread_properties[] = {
  {"trace-thread", OptionValue::eTypeBoolean, false, 0, nullptr, {}, "If true, this thread will single-step and log execution."},
  {"max-backtrace-depth", OptionValue::eTypeUInt64, false, 600000, nullptr, {}, "Maximum number of frames to backtrace."},
  {"single-thread-plan-timeout", OptionValue::eTypeUInt64, true, 1000, nullptr, {}, "The time in milliseconds to wait for single thread ThreadPlan to move forward before resuming all threads to resolve any potential deadlock. Specify value 0 to disable timeout."},
  {"step-avoid-libraries", OptionValue::eTypeFileSpecList, true, 0, "", {}, "A list of libraries that source stepping won't stop in."},
  {"step-avoid-regexp", OptionValue::eTypeRegex, true, 0, "^std::", {}, "A regular expression defining functions step-in won't stop in."},
  {"step-in-avoid-nodebug", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "If true, step-in will not stop in functions with no debug information."},
  {"step-out-avoid-nodebug", OptionValue::eTypeBoolean, true, 0, nullptr, {}, "If true, when step-in/step-out/step-over leave the current frame, they will continue to step out till they come to a function with debug information. Passing a frame argument to step-out will override this option."},
};
#undef LLDB_PROPERTIES_thread
#endif // thread Property

