
#include "ooxml/resourceids.hxx"
#include "ooxml/QNameToString.hxx"
#include "unordered_map"

namespace writerfilter
{

#ifdef DBG_UTIL

    /* ooxml */
    static const std::unordered_map<Id, const char*> g_QNameToStringMap {

    { NS_ooxml::LN_shape, "ooxml:shape" },
    { NS_ooxml::LN_token, "ooxml:token" },
    { NS_ooxml::LN_inputstream, "ooxml:inputstream" },
    { NS_ooxml::LN_trackchange, "ooxml:trackchange" },
    { NS_ooxml::LN_object, "ooxml:object" },
    { NS_ooxml::LN_tblStart, "ooxml:tblStart" },
    { NS_ooxml::LN_tblEnd, "ooxml:tblEnd" },
    { NS_ooxml::LN_tcStart, "ooxml:tcStart" },
    { NS_ooxml::LN_tcEnd, "ooxml:tcEnd" },
    { NS_ooxml::LN_tblDepth, "ooxml:tblDepth" },
    { NS_ooxml::LN_inTbl, "ooxml:inTbl" },
    { NS_ooxml::LN_tblCell, "ooxml:tblCell" },
    { NS_ooxml::LN_tblRow, "ooxml:tblRow" },
    { NS_ooxml::LN_ffdata, "ooxml:ffdata" },
    { NS_ooxml::LN_starmath, "ooxml:starmath" },
    { NS_ooxml::LN_blip, "ooxml:blip" },
    { NS_ooxml::LN_payload, "ooxml:payload" },
    { NS_ooxml::LN_footnote, "ooxml:footnote" },
    { NS_ooxml::LN_endnote, "ooxml:endnote" },
    { NS_ooxml::LN_annotation, "ooxml:annotation" },
    { NS_ooxml::LN_headerl, "ooxml:headerl" },
    { NS_ooxml::LN_headerr, "ooxml:headerr" },
    { NS_ooxml::LN_headerf, "ooxml:headerf" },
    { NS_ooxml::LN_footerl, "ooxml:footerl" },
    { NS_ooxml::LN_footerr, "ooxml:footerr" },
    { NS_ooxml::LN_footerf, "ooxml:footerf" },
    { NS_ooxml::LN_CT_Settings_widowControl, "ooxml:CT_Settings_widowControl" },
    { NS_ooxml::LN_CT_Settings_longerSpaceSequence, "ooxml:CT_Settings_longerSpaceSequence" },
    { NS_ooxml::LN_THEMETABLE, "ooxml:THEMETABLE" },
    { NS_ooxml::LN_CT_Hyperlink_r_id, "ooxml:CT_Hyperlink_r_id" },
    { NS_ooxml::LN_hlinkClick_hlinkClick, "ooxml:hlinkClick_hlinkClick" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigDirection_tl, "ooxml:Value_drawingml_ST_LightRigDirection_tl" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigDirection_t, "ooxml:Value_drawingml_ST_LightRigDirection_t" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigDirection_tr, "ooxml:Value_drawingml_ST_LightRigDirection_tr" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigDirection_l, "ooxml:Value_drawingml_ST_LightRigDirection_l" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigDirection_r, "ooxml:Value_drawingml_ST_LightRigDirection_r" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigDirection_bl, "ooxml:Value_drawingml_ST_LightRigDirection_bl" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigDirection_b, "ooxml:Value_drawingml_ST_LightRigDirection_b" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigDirection_br, "ooxml:Value_drawingml_ST_LightRigDirection_br" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_legacyFlat1, "ooxml:Value_drawingml_ST_LightRigType_legacyFlat1" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_legacyFlat2, "ooxml:Value_drawingml_ST_LightRigType_legacyFlat2" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_legacyFlat3, "ooxml:Value_drawingml_ST_LightRigType_legacyFlat3" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_legacyFlat4, "ooxml:Value_drawingml_ST_LightRigType_legacyFlat4" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_legacyNormal1, "ooxml:Value_drawingml_ST_LightRigType_legacyNormal1" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_legacyNormal2, "ooxml:Value_drawingml_ST_LightRigType_legacyNormal2" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_legacyNormal3, "ooxml:Value_drawingml_ST_LightRigType_legacyNormal3" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_legacyNormal4, "ooxml:Value_drawingml_ST_LightRigType_legacyNormal4" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_legacyHarsh1, "ooxml:Value_drawingml_ST_LightRigType_legacyHarsh1" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_legacyHarsh2, "ooxml:Value_drawingml_ST_LightRigType_legacyHarsh2" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_legacyHarsh3, "ooxml:Value_drawingml_ST_LightRigType_legacyHarsh3" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_legacyHarsh4, "ooxml:Value_drawingml_ST_LightRigType_legacyHarsh4" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_threePt, "ooxml:Value_drawingml_ST_LightRigType_threePt" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_balanced, "ooxml:Value_drawingml_ST_LightRigType_balanced" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_soft, "ooxml:Value_drawingml_ST_LightRigType_soft" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_harsh, "ooxml:Value_drawingml_ST_LightRigType_harsh" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_flood, "ooxml:Value_drawingml_ST_LightRigType_flood" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_contrasting, "ooxml:Value_drawingml_ST_LightRigType_contrasting" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_morning, "ooxml:Value_drawingml_ST_LightRigType_morning" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_sunrise, "ooxml:Value_drawingml_ST_LightRigType_sunrise" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_sunset, "ooxml:Value_drawingml_ST_LightRigType_sunset" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_chilly, "ooxml:Value_drawingml_ST_LightRigType_chilly" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_freezing, "ooxml:Value_drawingml_ST_LightRigType_freezing" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_flat, "ooxml:Value_drawingml_ST_LightRigType_flat" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_twoPt, "ooxml:Value_drawingml_ST_LightRigType_twoPt" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_glow, "ooxml:Value_drawingml_ST_LightRigType_glow" },
    { NS_ooxml::LN_Value_drawingml_ST_LightRigType_brightRoom, "ooxml:Value_drawingml_ST_LightRigType_brightRoom" },
    { NS_ooxml::LN_Value_drawingml_ST_BevelPresetType_relaxedInset, "ooxml:Value_drawingml_ST_BevelPresetType_relaxedInset" },
    { NS_ooxml::LN_Value_drawingml_ST_BevelPresetType_circle, "ooxml:Value_drawingml_ST_BevelPresetType_circle" },
    { NS_ooxml::LN_Value_drawingml_ST_BevelPresetType_slope, "ooxml:Value_drawingml_ST_BevelPresetType_slope" },
    { NS_ooxml::LN_Value_drawingml_ST_BevelPresetType_cross, "ooxml:Value_drawingml_ST_BevelPresetType_cross" },
    { NS_ooxml::LN_Value_drawingml_ST_BevelPresetType_angle, "ooxml:Value_drawingml_ST_BevelPresetType_angle" },
    { NS_ooxml::LN_Value_drawingml_ST_BevelPresetType_softRound, "ooxml:Value_drawingml_ST_BevelPresetType_softRound" },
    { NS_ooxml::LN_Value_drawingml_ST_BevelPresetType_convex, "ooxml:Value_drawingml_ST_BevelPresetType_convex" },
    { NS_ooxml::LN_Value_drawingml_ST_BevelPresetType_coolSlant, "ooxml:Value_drawingml_ST_BevelPresetType_coolSlant" },
    { NS_ooxml::LN_Value_drawingml_ST_BevelPresetType_divot, "ooxml:Value_drawingml_ST_BevelPresetType_divot" },
    { NS_ooxml::LN_Value_drawingml_ST_BevelPresetType_riblet, "ooxml:Value_drawingml_ST_BevelPresetType_riblet" },
    { NS_ooxml::LN_Value_drawingml_ST_BevelPresetType_hardEdge, "ooxml:Value_drawingml_ST_BevelPresetType_hardEdge" },
    { NS_ooxml::LN_Value_drawingml_ST_BevelPresetType_artDeco, "ooxml:Value_drawingml_ST_BevelPresetType_artDeco" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetMaterialType_legacyMatte, "ooxml:Value_drawingml_ST_PresetMaterialType_legacyMatte" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetMaterialType_legacyPlastic, "ooxml:Value_drawingml_ST_PresetMaterialType_legacyPlastic" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetMaterialType_legacyMetal, "ooxml:Value_drawingml_ST_PresetMaterialType_legacyMetal" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetMaterialType_legacyWireframe, "ooxml:Value_drawingml_ST_PresetMaterialType_legacyWireframe" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetMaterialType_matte, "ooxml:Value_drawingml_ST_PresetMaterialType_matte" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetMaterialType_plastic, "ooxml:Value_drawingml_ST_PresetMaterialType_plastic" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetMaterialType_metal, "ooxml:Value_drawingml_ST_PresetMaterialType_metal" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetMaterialType_warmMatte, "ooxml:Value_drawingml_ST_PresetMaterialType_warmMatte" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetMaterialType_translucentPowder, "ooxml:Value_drawingml_ST_PresetMaterialType_translucentPowder" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetMaterialType_powder, "ooxml:Value_drawingml_ST_PresetMaterialType_powder" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetMaterialType_dkEdge, "ooxml:Value_drawingml_ST_PresetMaterialType_dkEdge" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetMaterialType_softEdge, "ooxml:Value_drawingml_ST_PresetMaterialType_softEdge" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetMaterialType_clear, "ooxml:Value_drawingml_ST_PresetMaterialType_clear" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetMaterialType_flat, "ooxml:Value_drawingml_ST_PresetMaterialType_flat" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetMaterialType_softmetal, "ooxml:Value_drawingml_ST_PresetMaterialType_softmetal" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyObliqueTopLeft, "ooxml:Value_drawingml_ST_PresetCameraType_legacyObliqueTopLeft" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyObliqueTop, "ooxml:Value_drawingml_ST_PresetCameraType_legacyObliqueTop" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyObliqueTopRight, "ooxml:Value_drawingml_ST_PresetCameraType_legacyObliqueTopRight" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyObliqueLeft, "ooxml:Value_drawingml_ST_PresetCameraType_legacyObliqueLeft" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyObliqueFront, "ooxml:Value_drawingml_ST_PresetCameraType_legacyObliqueFront" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyObliqueRight, "ooxml:Value_drawingml_ST_PresetCameraType_legacyObliqueRight" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyObliqueBottomLeft, "ooxml:Value_drawingml_ST_PresetCameraType_legacyObliqueBottomLeft" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyObliqueBottom, "ooxml:Value_drawingml_ST_PresetCameraType_legacyObliqueBottom" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyObliqueBottomRight, "ooxml:Value_drawingml_ST_PresetCameraType_legacyObliqueBottomRight" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyPerspectiveTopLeft, "ooxml:Value_drawingml_ST_PresetCameraType_legacyPerspectiveTopLeft" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyPerspectiveTop, "ooxml:Value_drawingml_ST_PresetCameraType_legacyPerspectiveTop" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyPerspectiveTopRight, "ooxml:Value_drawingml_ST_PresetCameraType_legacyPerspectiveTopRight" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyPerspectiveLeft, "ooxml:Value_drawingml_ST_PresetCameraType_legacyPerspectiveLeft" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyPerspectiveFront, "ooxml:Value_drawingml_ST_PresetCameraType_legacyPerspectiveFront" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyPerspectiveRight, "ooxml:Value_drawingml_ST_PresetCameraType_legacyPerspectiveRight" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyPerspectiveBottomLeft, "ooxml:Value_drawingml_ST_PresetCameraType_legacyPerspectiveBottomLeft" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyPerspectiveBottom, "ooxml:Value_drawingml_ST_PresetCameraType_legacyPerspectiveBottom" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_legacyPerspectiveBottomRight, "ooxml:Value_drawingml_ST_PresetCameraType_legacyPerspectiveBottomRight" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_orthographicFront, "ooxml:Value_drawingml_ST_PresetCameraType_orthographicFront" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricTopUp, "ooxml:Value_drawingml_ST_PresetCameraType_isometricTopUp" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricTopDown, "ooxml:Value_drawingml_ST_PresetCameraType_isometricTopDown" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricBottomUp, "ooxml:Value_drawingml_ST_PresetCameraType_isometricBottomUp" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricBottomDown, "ooxml:Value_drawingml_ST_PresetCameraType_isometricBottomDown" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricLeftUp, "ooxml:Value_drawingml_ST_PresetCameraType_isometricLeftUp" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricLeftDown, "ooxml:Value_drawingml_ST_PresetCameraType_isometricLeftDown" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricRightUp, "ooxml:Value_drawingml_ST_PresetCameraType_isometricRightUp" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricRightDown, "ooxml:Value_drawingml_ST_PresetCameraType_isometricRightDown" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricOffAxis1Left, "ooxml:Value_drawingml_ST_PresetCameraType_isometricOffAxis1Left" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricOffAxis1Right, "ooxml:Value_drawingml_ST_PresetCameraType_isometricOffAxis1Right" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricOffAxis1Top, "ooxml:Value_drawingml_ST_PresetCameraType_isometricOffAxis1Top" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricOffAxis2Left, "ooxml:Value_drawingml_ST_PresetCameraType_isometricOffAxis2Left" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricOffAxis2Right, "ooxml:Value_drawingml_ST_PresetCameraType_isometricOffAxis2Right" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricOffAxis2Top, "ooxml:Value_drawingml_ST_PresetCameraType_isometricOffAxis2Top" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricOffAxis3Left, "ooxml:Value_drawingml_ST_PresetCameraType_isometricOffAxis3Left" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricOffAxis3Right, "ooxml:Value_drawingml_ST_PresetCameraType_isometricOffAxis3Right" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricOffAxis3Bottom, "ooxml:Value_drawingml_ST_PresetCameraType_isometricOffAxis3Bottom" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricOffAxis4Left, "ooxml:Value_drawingml_ST_PresetCameraType_isometricOffAxis4Left" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricOffAxis4Right, "ooxml:Value_drawingml_ST_PresetCameraType_isometricOffAxis4Right" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_isometricOffAxis4Bottom, "ooxml:Value_drawingml_ST_PresetCameraType_isometricOffAxis4Bottom" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_obliqueTopLeft, "ooxml:Value_drawingml_ST_PresetCameraType_obliqueTopLeft" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_obliqueTop, "ooxml:Value_drawingml_ST_PresetCameraType_obliqueTop" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_obliqueTopRight, "ooxml:Value_drawingml_ST_PresetCameraType_obliqueTopRight" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_obliqueLeft, "ooxml:Value_drawingml_ST_PresetCameraType_obliqueLeft" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_obliqueRight, "ooxml:Value_drawingml_ST_PresetCameraType_obliqueRight" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_obliqueBottomLeft, "ooxml:Value_drawingml_ST_PresetCameraType_obliqueBottomLeft" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_obliqueBottom, "ooxml:Value_drawingml_ST_PresetCameraType_obliqueBottom" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_obliqueBottomRight, "ooxml:Value_drawingml_ST_PresetCameraType_obliqueBottomRight" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_perspectiveFront, "ooxml:Value_drawingml_ST_PresetCameraType_perspectiveFront" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_perspectiveLeft, "ooxml:Value_drawingml_ST_PresetCameraType_perspectiveLeft" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_perspectiveRight, "ooxml:Value_drawingml_ST_PresetCameraType_perspectiveRight" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_perspectiveAbove, "ooxml:Value_drawingml_ST_PresetCameraType_perspectiveAbove" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_perspectiveBelow, "ooxml:Value_drawingml_ST_PresetCameraType_perspectiveBelow" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_perspectiveAboveLeftFacing, "ooxml:Value_drawingml_ST_PresetCameraType_perspectiveAboveLeftFacing" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_perspectiveAboveRightFacing, "ooxml:Value_drawingml_ST_PresetCameraType_perspectiveAboveRightFacing" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_perspectiveContrastingLeftFacing, "ooxml:Value_drawingml_ST_PresetCameraType_perspectiveContrastingLeftFacing" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_perspectiveContrastingRightFacing, "ooxml:Value_drawingml_ST_PresetCameraType_perspectiveContrastingRightFacing" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_perspectiveHeroicLeftFacing, "ooxml:Value_drawingml_ST_PresetCameraType_perspectiveHeroicLeftFacing" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_perspectiveHeroicRightFacing, "ooxml:Value_drawingml_ST_PresetCameraType_perspectiveHeroicRightFacing" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_perspectiveHeroicExtremeLeftFacing, "ooxml:Value_drawingml_ST_PresetCameraType_perspectiveHeroicExtremeLeftFacing" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_perspectiveHeroicExtremeRightFacing, "ooxml:Value_drawingml_ST_PresetCameraType_perspectiveHeroicExtremeRightFacing" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_perspectiveRelaxed, "ooxml:Value_drawingml_ST_PresetCameraType_perspectiveRelaxed" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetCameraType_perspectiveRelaxedModerately, "ooxml:Value_drawingml_ST_PresetCameraType_perspectiveRelaxedModerately" },
    { NS_ooxml::LN_Value_drawingml_ST_ColorSchemeIndex_dk1, "ooxml:Value_drawingml_ST_ColorSchemeIndex_dk1" },
    { NS_ooxml::LN_Value_drawingml_ST_ColorSchemeIndex_lt1, "ooxml:Value_drawingml_ST_ColorSchemeIndex_lt1" },
    { NS_ooxml::LN_Value_drawingml_ST_ColorSchemeIndex_dk2, "ooxml:Value_drawingml_ST_ColorSchemeIndex_dk2" },
    { NS_ooxml::LN_Value_drawingml_ST_ColorSchemeIndex_lt2, "ooxml:Value_drawingml_ST_ColorSchemeIndex_lt2" },
    { NS_ooxml::LN_Value_drawingml_ST_ColorSchemeIndex_accent1, "ooxml:Value_drawingml_ST_ColorSchemeIndex_accent1" },
    { NS_ooxml::LN_Value_drawingml_ST_ColorSchemeIndex_accent2, "ooxml:Value_drawingml_ST_ColorSchemeIndex_accent2" },
    { NS_ooxml::LN_Value_drawingml_ST_ColorSchemeIndex_accent3, "ooxml:Value_drawingml_ST_ColorSchemeIndex_accent3" },
    { NS_ooxml::LN_Value_drawingml_ST_ColorSchemeIndex_accent4, "ooxml:Value_drawingml_ST_ColorSchemeIndex_accent4" },
    { NS_ooxml::LN_Value_drawingml_ST_ColorSchemeIndex_accent5, "ooxml:Value_drawingml_ST_ColorSchemeIndex_accent5" },
    { NS_ooxml::LN_Value_drawingml_ST_ColorSchemeIndex_accent6, "ooxml:Value_drawingml_ST_ColorSchemeIndex_accent6" },
    { NS_ooxml::LN_Value_drawingml_ST_ColorSchemeIndex_hlink, "ooxml:Value_drawingml_ST_ColorSchemeIndex_hlink" },
    { NS_ooxml::LN_Value_drawingml_ST_ColorSchemeIndex_folHlink, "ooxml:Value_drawingml_ST_ColorSchemeIndex_folHlink" },
    { NS_ooxml::LN_CT_ColorScheme_dk1, "ooxml:CT_ColorScheme_dk1" },
    { NS_ooxml::LN_CT_ColorScheme_lt1, "ooxml:CT_ColorScheme_lt1" },
    { NS_ooxml::LN_CT_ColorScheme_dk2, "ooxml:CT_ColorScheme_dk2" },
    { NS_ooxml::LN_CT_ColorScheme_lt2, "ooxml:CT_ColorScheme_lt2" },
    { NS_ooxml::LN_CT_ColorScheme_accent1, "ooxml:CT_ColorScheme_accent1" },
    { NS_ooxml::LN_CT_ColorScheme_accent2, "ooxml:CT_ColorScheme_accent2" },
    { NS_ooxml::LN_CT_ColorScheme_accent3, "ooxml:CT_ColorScheme_accent3" },
    { NS_ooxml::LN_CT_ColorScheme_accent4, "ooxml:CT_ColorScheme_accent4" },
    { NS_ooxml::LN_CT_ColorScheme_accent5, "ooxml:CT_ColorScheme_accent5" },
    { NS_ooxml::LN_CT_ColorScheme_accent6, "ooxml:CT_ColorScheme_accent6" },
    { NS_ooxml::LN_CT_ColorScheme_hlink, "ooxml:CT_ColorScheme_hlink" },
    { NS_ooxml::LN_CT_ColorScheme_folHlink, "ooxml:CT_ColorScheme_folHlink" },
    { NS_ooxml::LN_CT_ColorScheme_extLst, "ooxml:CT_ColorScheme_extLst" },
    { NS_ooxml::LN_CT_ColorScheme_name, "ooxml:CT_ColorScheme_name" },
    { NS_ooxml::LN_CT_SupplementalFont_script, "ooxml:CT_SupplementalFont_script" },
    { NS_ooxml::LN_CT_SupplementalFont_typeface, "ooxml:CT_SupplementalFont_typeface" },
    { NS_ooxml::LN_CT_FontCollection_latin, "ooxml:CT_FontCollection_latin" },
    { NS_ooxml::LN_CT_FontCollection_ea, "ooxml:CT_FontCollection_ea" },
    { NS_ooxml::LN_CT_FontCollection_cs, "ooxml:CT_FontCollection_cs" },
    { NS_ooxml::LN_CT_FontCollection_font, "ooxml:CT_FontCollection_font" },
    { NS_ooxml::LN_CT_FontCollection_extLst, "ooxml:CT_FontCollection_extLst" },
    { NS_ooxml::LN_CT_FontScheme_majorFont, "ooxml:CT_FontScheme_majorFont" },
    { NS_ooxml::LN_CT_FontScheme_minorFont, "ooxml:CT_FontScheme_minorFont" },
    { NS_ooxml::LN_CT_FontScheme_extLst, "ooxml:CT_FontScheme_extLst" },
    { NS_ooxml::LN_CT_FontScheme_name, "ooxml:CT_FontScheme_name" },
    { NS_ooxml::LN_CT_LineStyleList_ln, "ooxml:CT_LineStyleList_ln" },
    { NS_ooxml::LN_CT_EffectStyleList_effectStyle, "ooxml:CT_EffectStyleList_effectStyle" },
    { NS_ooxml::LN_CT_StyleMatrix_fillStyleLst, "ooxml:CT_StyleMatrix_fillStyleLst" },
    { NS_ooxml::LN_CT_StyleMatrix_lnStyleLst, "ooxml:CT_StyleMatrix_lnStyleLst" },
    { NS_ooxml::LN_CT_StyleMatrix_effectStyleLst, "ooxml:CT_StyleMatrix_effectStyleLst" },
    { NS_ooxml::LN_CT_StyleMatrix_bgFillStyleLst, "ooxml:CT_StyleMatrix_bgFillStyleLst" },
    { NS_ooxml::LN_CT_StyleMatrix_name, "ooxml:CT_StyleMatrix_name" },
    { NS_ooxml::LN_CT_BaseStyles_clrScheme, "ooxml:CT_BaseStyles_clrScheme" },
    { NS_ooxml::LN_CT_BaseStyles_fontScheme, "ooxml:CT_BaseStyles_fontScheme" },
    { NS_ooxml::LN_CT_BaseStyles_fmtScheme, "ooxml:CT_BaseStyles_fmtScheme" },
    { NS_ooxml::LN_CT_BaseStyles_extLst, "ooxml:CT_BaseStyles_extLst" },
    { NS_ooxml::LN_CT_TextFont_typeface, "ooxml:CT_TextFont_typeface" },
    { NS_ooxml::LN_CT_TextFont_panose, "ooxml:CT_TextFont_panose" },
    { NS_ooxml::LN_CT_TextFont_pitchFamily, "ooxml:CT_TextFont_pitchFamily" },
    { NS_ooxml::LN_CT_TextFont_charset, "ooxml:CT_TextFont_charset" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_none, "ooxml:Value_drawingml_ST_TextUnderlineType_none" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_words, "ooxml:Value_drawingml_ST_TextUnderlineType_words" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_sng, "ooxml:Value_drawingml_ST_TextUnderlineType_sng" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dbl, "ooxml:Value_drawingml_ST_TextUnderlineType_dbl" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_heavy, "ooxml:Value_drawingml_ST_TextUnderlineType_heavy" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dotted, "ooxml:Value_drawingml_ST_TextUnderlineType_dotted" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dottedHeavy, "ooxml:Value_drawingml_ST_TextUnderlineType_dottedHeavy" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dash, "ooxml:Value_drawingml_ST_TextUnderlineType_dash" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dashHeavy, "ooxml:Value_drawingml_ST_TextUnderlineType_dashHeavy" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dashLong, "ooxml:Value_drawingml_ST_TextUnderlineType_dashLong" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dashLongHeavy, "ooxml:Value_drawingml_ST_TextUnderlineType_dashLongHeavy" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dotDash, "ooxml:Value_drawingml_ST_TextUnderlineType_dotDash" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dotDashHeavy, "ooxml:Value_drawingml_ST_TextUnderlineType_dotDashHeavy" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dotDotDash, "ooxml:Value_drawingml_ST_TextUnderlineType_dotDotDash" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_dotDotDashHeavy, "ooxml:Value_drawingml_ST_TextUnderlineType_dotDotDashHeavy" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_wavy, "ooxml:Value_drawingml_ST_TextUnderlineType_wavy" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_wavyHeavy, "ooxml:Value_drawingml_ST_TextUnderlineType_wavyHeavy" },
    { NS_ooxml::LN_Value_drawingml_ST_TextUnderlineType_wavyDbl, "ooxml:Value_drawingml_ST_TextUnderlineType_wavyDbl" },
    { NS_ooxml::LN_Value_drawingml_ST_TextStrikeType_noStrike, "ooxml:Value_drawingml_ST_TextStrikeType_noStrike" },
    { NS_ooxml::LN_Value_drawingml_ST_TextStrikeType_sngStrike, "ooxml:Value_drawingml_ST_TextStrikeType_sngStrike" },
    { NS_ooxml::LN_Value_drawingml_ST_TextStrikeType_dblStrike, "ooxml:Value_drawingml_ST_TextStrikeType_dblStrike" },
    { NS_ooxml::LN_Value_drawingml_ST_TextCapsType_none, "ooxml:Value_drawingml_ST_TextCapsType_none" },
    { NS_ooxml::LN_Value_drawingml_ST_TextCapsType_small, "ooxml:Value_drawingml_ST_TextCapsType_small" },
    { NS_ooxml::LN_Value_drawingml_ST_TextCapsType_all, "ooxml:Value_drawingml_ST_TextCapsType_all" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw1, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw1" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw2, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw2" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw3, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw3" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw4, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw4" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw5, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw5" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw6, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw6" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw7, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw7" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw8, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw8" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw9, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw9" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw10, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw10" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw11, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw11" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw12, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw12" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw13, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw13" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw14, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw14" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw15, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw15" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw16, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw16" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw17, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw17" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw18, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw18" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw19, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw19" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetShadowVal_shdw20, "ooxml:Value_drawingml_ST_PresetShadowVal_shdw20" },
    { NS_ooxml::LN_Value_drawingml_ST_PathShadeType_shape, "ooxml:Value_drawingml_ST_PathShadeType_shape" },
    { NS_ooxml::LN_Value_drawingml_ST_PathShadeType_circle, "ooxml:Value_drawingml_ST_PathShadeType_circle" },
    { NS_ooxml::LN_Value_drawingml_ST_PathShadeType_rect, "ooxml:Value_drawingml_ST_PathShadeType_rect" },
    { NS_ooxml::LN_Value_drawingml_ST_TileFlipMode_none, "ooxml:Value_drawingml_ST_TileFlipMode_none" },
    { NS_ooxml::LN_Value_drawingml_ST_TileFlipMode_x, "ooxml:Value_drawingml_ST_TileFlipMode_x" },
    { NS_ooxml::LN_Value_drawingml_ST_TileFlipMode_y, "ooxml:Value_drawingml_ST_TileFlipMode_y" },
    { NS_ooxml::LN_Value_drawingml_ST_TileFlipMode_xy, "ooxml:Value_drawingml_ST_TileFlipMode_xy" },
    { NS_ooxml::LN_CT_GradientStop_pos, "ooxml:CT_GradientStop_pos" },
    { NS_ooxml::LN_CT_TileInfoProperties_tx, "ooxml:CT_TileInfoProperties_tx" },
    { NS_ooxml::LN_CT_TileInfoProperties_ty, "ooxml:CT_TileInfoProperties_ty" },
    { NS_ooxml::LN_CT_TileInfoProperties_sx, "ooxml:CT_TileInfoProperties_sx" },
    { NS_ooxml::LN_CT_TileInfoProperties_sy, "ooxml:CT_TileInfoProperties_sy" },
    { NS_ooxml::LN_CT_TileInfoProperties_flip, "ooxml:CT_TileInfoProperties_flip" },
    { NS_ooxml::LN_CT_TileInfoProperties_algn, "ooxml:CT_TileInfoProperties_algn" },
    { NS_ooxml::LN_CT_StretchInfoProperties_fillRect, "ooxml:CT_StretchInfoProperties_fillRect" },
    { NS_ooxml::LN_EG_FillModeProperties_tile, "ooxml:EG_FillModeProperties_tile" },
    { NS_ooxml::LN_EG_FillModeProperties_stretch, "ooxml:EG_FillModeProperties_stretch" },
    { NS_ooxml::LN_Value_drawingml_ST_BlipCompression_email, "ooxml:Value_drawingml_ST_BlipCompression_email" },
    { NS_ooxml::LN_Value_drawingml_ST_BlipCompression_screen, "ooxml:Value_drawingml_ST_BlipCompression_screen" },
    { NS_ooxml::LN_Value_drawingml_ST_BlipCompression_print, "ooxml:Value_drawingml_ST_BlipCompression_print" },
    { NS_ooxml::LN_Value_drawingml_ST_BlipCompression_hqprint, "ooxml:Value_drawingml_ST_BlipCompression_hqprint" },
    { NS_ooxml::LN_Value_drawingml_ST_BlipCompression_none, "ooxml:Value_drawingml_ST_BlipCompression_none" },
    { NS_ooxml::LN_CT_Blip_alphaBiLevel, "ooxml:CT_Blip_alphaBiLevel" },
    { NS_ooxml::LN_CT_Blip_alphaCeiling, "ooxml:CT_Blip_alphaCeiling" },
    { NS_ooxml::LN_CT_Blip_alphaFloor, "ooxml:CT_Blip_alphaFloor" },
    { NS_ooxml::LN_CT_Blip_alphaInv, "ooxml:CT_Blip_alphaInv" },
    { NS_ooxml::LN_CT_Blip_alphaMod, "ooxml:CT_Blip_alphaMod" },
    { NS_ooxml::LN_CT_Blip_alphaModFix, "ooxml:CT_Blip_alphaModFix" },
    { NS_ooxml::LN_CT_Blip_alphaRepl, "ooxml:CT_Blip_alphaRepl" },
    { NS_ooxml::LN_CT_Blip_biLevel, "ooxml:CT_Blip_biLevel" },
    { NS_ooxml::LN_CT_Blip_blur, "ooxml:CT_Blip_blur" },
    { NS_ooxml::LN_CT_Blip_clrChange, "ooxml:CT_Blip_clrChange" },
    { NS_ooxml::LN_CT_Blip_clrRepl, "ooxml:CT_Blip_clrRepl" },
    { NS_ooxml::LN_CT_Blip_duotone, "ooxml:CT_Blip_duotone" },
    { NS_ooxml::LN_CT_Blip_fillOverlay, "ooxml:CT_Blip_fillOverlay" },
    { NS_ooxml::LN_CT_Blip_grayscl, "ooxml:CT_Blip_grayscl" },
    { NS_ooxml::LN_CT_Blip_hsl, "ooxml:CT_Blip_hsl" },
    { NS_ooxml::LN_CT_Blip_lum, "ooxml:CT_Blip_lum" },
    { NS_ooxml::LN_CT_Blip_tint, "ooxml:CT_Blip_tint" },
    { NS_ooxml::LN_CT_Blip_extLst, "ooxml:CT_Blip_extLst" },
    { NS_ooxml::LN_CT_Blip_cstate, "ooxml:CT_Blip_cstate" },
    { NS_ooxml::LN_CT_BlipFillProperties_blip, "ooxml:CT_BlipFillProperties_blip" },
    { NS_ooxml::LN_CT_BlipFillProperties_srcRect, "ooxml:CT_BlipFillProperties_srcRect" },
    { NS_ooxml::LN_CT_BlipFillProperties_dpi, "ooxml:CT_BlipFillProperties_dpi" },
    { NS_ooxml::LN_CT_BlipFillProperties_rotWithShape, "ooxml:CT_BlipFillProperties_rotWithShape" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_pct5, "ooxml:Value_drawingml_ST_PresetPatternVal_pct5" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_pct10, "ooxml:Value_drawingml_ST_PresetPatternVal_pct10" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_pct20, "ooxml:Value_drawingml_ST_PresetPatternVal_pct20" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_pct25, "ooxml:Value_drawingml_ST_PresetPatternVal_pct25" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_pct30, "ooxml:Value_drawingml_ST_PresetPatternVal_pct30" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_pct40, "ooxml:Value_drawingml_ST_PresetPatternVal_pct40" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_pct50, "ooxml:Value_drawingml_ST_PresetPatternVal_pct50" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_pct60, "ooxml:Value_drawingml_ST_PresetPatternVal_pct60" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_pct70, "ooxml:Value_drawingml_ST_PresetPatternVal_pct70" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_pct75, "ooxml:Value_drawingml_ST_PresetPatternVal_pct75" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_pct80, "ooxml:Value_drawingml_ST_PresetPatternVal_pct80" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_pct90, "ooxml:Value_drawingml_ST_PresetPatternVal_pct90" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_horz, "ooxml:Value_drawingml_ST_PresetPatternVal_horz" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_vert, "ooxml:Value_drawingml_ST_PresetPatternVal_vert" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_ltHorz, "ooxml:Value_drawingml_ST_PresetPatternVal_ltHorz" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_ltVert, "ooxml:Value_drawingml_ST_PresetPatternVal_ltVert" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_dkHorz, "ooxml:Value_drawingml_ST_PresetPatternVal_dkHorz" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_dkVert, "ooxml:Value_drawingml_ST_PresetPatternVal_dkVert" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_narHorz, "ooxml:Value_drawingml_ST_PresetPatternVal_narHorz" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_narVert, "ooxml:Value_drawingml_ST_PresetPatternVal_narVert" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_dashHorz, "ooxml:Value_drawingml_ST_PresetPatternVal_dashHorz" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_dashVert, "ooxml:Value_drawingml_ST_PresetPatternVal_dashVert" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_cross, "ooxml:Value_drawingml_ST_PresetPatternVal_cross" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_dnDiag, "ooxml:Value_drawingml_ST_PresetPatternVal_dnDiag" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_upDiag, "ooxml:Value_drawingml_ST_PresetPatternVal_upDiag" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_ltDnDiag, "ooxml:Value_drawingml_ST_PresetPatternVal_ltDnDiag" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_ltUpDiag, "ooxml:Value_drawingml_ST_PresetPatternVal_ltUpDiag" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_dkDnDiag, "ooxml:Value_drawingml_ST_PresetPatternVal_dkDnDiag" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_dkUpDiag, "ooxml:Value_drawingml_ST_PresetPatternVal_dkUpDiag" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_wdDnDiag, "ooxml:Value_drawingml_ST_PresetPatternVal_wdDnDiag" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_wdUpDiag, "ooxml:Value_drawingml_ST_PresetPatternVal_wdUpDiag" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_dashDnDiag, "ooxml:Value_drawingml_ST_PresetPatternVal_dashDnDiag" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_dashUpDiag, "ooxml:Value_drawingml_ST_PresetPatternVal_dashUpDiag" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_diagCross, "ooxml:Value_drawingml_ST_PresetPatternVal_diagCross" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_smCheck, "ooxml:Value_drawingml_ST_PresetPatternVal_smCheck" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_lgCheck, "ooxml:Value_drawingml_ST_PresetPatternVal_lgCheck" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_smGrid, "ooxml:Value_drawingml_ST_PresetPatternVal_smGrid" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_lgGrid, "ooxml:Value_drawingml_ST_PresetPatternVal_lgGrid" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_dotGrid, "ooxml:Value_drawingml_ST_PresetPatternVal_dotGrid" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_smConfetti, "ooxml:Value_drawingml_ST_PresetPatternVal_smConfetti" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_lgConfetti, "ooxml:Value_drawingml_ST_PresetPatternVal_lgConfetti" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_horzBrick, "ooxml:Value_drawingml_ST_PresetPatternVal_horzBrick" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_diagBrick, "ooxml:Value_drawingml_ST_PresetPatternVal_diagBrick" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_solidDmnd, "ooxml:Value_drawingml_ST_PresetPatternVal_solidDmnd" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_openDmnd, "ooxml:Value_drawingml_ST_PresetPatternVal_openDmnd" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_dotDmnd, "ooxml:Value_drawingml_ST_PresetPatternVal_dotDmnd" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_plaid, "ooxml:Value_drawingml_ST_PresetPatternVal_plaid" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_sphere, "ooxml:Value_drawingml_ST_PresetPatternVal_sphere" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_weave, "ooxml:Value_drawingml_ST_PresetPatternVal_weave" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_divot, "ooxml:Value_drawingml_ST_PresetPatternVal_divot" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_shingle, "ooxml:Value_drawingml_ST_PresetPatternVal_shingle" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_wave, "ooxml:Value_drawingml_ST_PresetPatternVal_wave" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_trellis, "ooxml:Value_drawingml_ST_PresetPatternVal_trellis" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetPatternVal_zigZag, "ooxml:Value_drawingml_ST_PresetPatternVal_zigZag" },
    { NS_ooxml::LN_Value_drawingml_ST_BlendMode_over, "ooxml:Value_drawingml_ST_BlendMode_over" },
    { NS_ooxml::LN_Value_drawingml_ST_BlendMode_mult, "ooxml:Value_drawingml_ST_BlendMode_mult" },
    { NS_ooxml::LN_Value_drawingml_ST_BlendMode_screen, "ooxml:Value_drawingml_ST_BlendMode_screen" },
    { NS_ooxml::LN_Value_drawingml_ST_BlendMode_darken, "ooxml:Value_drawingml_ST_BlendMode_darken" },
    { NS_ooxml::LN_Value_drawingml_ST_BlendMode_lighten, "ooxml:Value_drawingml_ST_BlendMode_lighten" },
    { NS_ooxml::LN_EG_Effect_cont, "ooxml:EG_Effect_cont" },
    { NS_ooxml::LN_EG_Effect_effect, "ooxml:EG_Effect_effect" },
    { NS_ooxml::LN_EG_Effect_alphaBiLevel, "ooxml:EG_Effect_alphaBiLevel" },
    { NS_ooxml::LN_EG_Effect_alphaCeiling, "ooxml:EG_Effect_alphaCeiling" },
    { NS_ooxml::LN_EG_Effect_alphaFloor, "ooxml:EG_Effect_alphaFloor" },
    { NS_ooxml::LN_EG_Effect_alphaInv, "ooxml:EG_Effect_alphaInv" },
    { NS_ooxml::LN_EG_Effect_alphaMod, "ooxml:EG_Effect_alphaMod" },
    { NS_ooxml::LN_EG_Effect_alphaModFix, "ooxml:EG_Effect_alphaModFix" },
    { NS_ooxml::LN_EG_Effect_alphaOutset, "ooxml:EG_Effect_alphaOutset" },
    { NS_ooxml::LN_EG_Effect_alphaRepl, "ooxml:EG_Effect_alphaRepl" },
    { NS_ooxml::LN_EG_Effect_biLevel, "ooxml:EG_Effect_biLevel" },
    { NS_ooxml::LN_EG_Effect_blend, "ooxml:EG_Effect_blend" },
    { NS_ooxml::LN_EG_Effect_blur, "ooxml:EG_Effect_blur" },
    { NS_ooxml::LN_EG_Effect_clrChange, "ooxml:EG_Effect_clrChange" },
    { NS_ooxml::LN_EG_Effect_clrRepl, "ooxml:EG_Effect_clrRepl" },
    { NS_ooxml::LN_EG_Effect_duotone, "ooxml:EG_Effect_duotone" },
    { NS_ooxml::LN_EG_Effect_fill, "ooxml:EG_Effect_fill" },
    { NS_ooxml::LN_EG_Effect_fillOverlay, "ooxml:EG_Effect_fillOverlay" },
    { NS_ooxml::LN_EG_Effect_glow, "ooxml:EG_Effect_glow" },
    { NS_ooxml::LN_EG_Effect_grayscl, "ooxml:EG_Effect_grayscl" },
    { NS_ooxml::LN_EG_Effect_hsl, "ooxml:EG_Effect_hsl" },
    { NS_ooxml::LN_EG_Effect_innerShdw, "ooxml:EG_Effect_innerShdw" },
    { NS_ooxml::LN_EG_Effect_lum, "ooxml:EG_Effect_lum" },
    { NS_ooxml::LN_EG_Effect_outerShdw, "ooxml:EG_Effect_outerShdw" },
    { NS_ooxml::LN_EG_Effect_prstShdw, "ooxml:EG_Effect_prstShdw" },
    { NS_ooxml::LN_EG_Effect_reflection, "ooxml:EG_Effect_reflection" },
    { NS_ooxml::LN_EG_Effect_relOff, "ooxml:EG_Effect_relOff" },
    { NS_ooxml::LN_EG_Effect_softEdge, "ooxml:EG_Effect_softEdge" },
    { NS_ooxml::LN_EG_Effect_tint, "ooxml:EG_Effect_tint" },
    { NS_ooxml::LN_EG_Effect_xfrm, "ooxml:EG_Effect_xfrm" },
    { NS_ooxml::LN_Value_drawingml_ST_EffectContainerType_sib, "ooxml:Value_drawingml_ST_EffectContainerType_sib" },
    { NS_ooxml::LN_Value_drawingml_ST_EffectContainerType_tree, "ooxml:Value_drawingml_ST_EffectContainerType_tree" },
    { NS_ooxml::LN_CT_EffectContainer_type, "ooxml:CT_EffectContainer_type" },
    { NS_ooxml::LN_CT_EffectContainer_name, "ooxml:CT_EffectContainer_name" },
    { NS_ooxml::LN_Value_drawingml_ST_LineEndType_none, "ooxml:Value_drawingml_ST_LineEndType_none" },
    { NS_ooxml::LN_Value_drawingml_ST_LineEndType_triangle, "ooxml:Value_drawingml_ST_LineEndType_triangle" },
    { NS_ooxml::LN_Value_drawingml_ST_LineEndType_stealth, "ooxml:Value_drawingml_ST_LineEndType_stealth" },
    { NS_ooxml::LN_Value_drawingml_ST_LineEndType_diamond, "ooxml:Value_drawingml_ST_LineEndType_diamond" },
    { NS_ooxml::LN_Value_drawingml_ST_LineEndType_oval, "ooxml:Value_drawingml_ST_LineEndType_oval" },
    { NS_ooxml::LN_Value_drawingml_ST_LineEndType_arrow, "ooxml:Value_drawingml_ST_LineEndType_arrow" },
    { NS_ooxml::LN_Value_drawingml_ST_LineEndWidth_sm, "ooxml:Value_drawingml_ST_LineEndWidth_sm" },
    { NS_ooxml::LN_Value_drawingml_ST_LineEndWidth_med, "ooxml:Value_drawingml_ST_LineEndWidth_med" },
    { NS_ooxml::LN_Value_drawingml_ST_LineEndWidth_lg, "ooxml:Value_drawingml_ST_LineEndWidth_lg" },
    { NS_ooxml::LN_Value_drawingml_ST_LineEndLength_sm, "ooxml:Value_drawingml_ST_LineEndLength_sm" },
    { NS_ooxml::LN_Value_drawingml_ST_LineEndLength_med, "ooxml:Value_drawingml_ST_LineEndLength_med" },
    { NS_ooxml::LN_Value_drawingml_ST_LineEndLength_lg, "ooxml:Value_drawingml_ST_LineEndLength_lg" },
    { NS_ooxml::LN_CT_LineEndProperties_type, "ooxml:CT_LineEndProperties_type" },
    { NS_ooxml::LN_CT_LineEndProperties_w, "ooxml:CT_LineEndProperties_w" },
    { NS_ooxml::LN_CT_LineEndProperties_len, "ooxml:CT_LineEndProperties_len" },
    { NS_ooxml::LN_EG_LineFillProperties_noFill, "ooxml:EG_LineFillProperties_noFill" },
    { NS_ooxml::LN_EG_LineFillProperties_solidFill, "ooxml:EG_LineFillProperties_solidFill" },
    { NS_ooxml::LN_EG_LineFillProperties_gradFill, "ooxml:EG_LineFillProperties_gradFill" },
    { NS_ooxml::LN_EG_LineFillProperties_pattFill, "ooxml:EG_LineFillProperties_pattFill" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetLineDashVal_solid, "ooxml:Value_drawingml_ST_PresetLineDashVal_solid" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetLineDashVal_dot, "ooxml:Value_drawingml_ST_PresetLineDashVal_dot" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetLineDashVal_dash, "ooxml:Value_drawingml_ST_PresetLineDashVal_dash" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetLineDashVal_lgDash, "ooxml:Value_drawingml_ST_PresetLineDashVal_lgDash" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetLineDashVal_dashDot, "ooxml:Value_drawingml_ST_PresetLineDashVal_dashDot" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetLineDashVal_lgDashDot, "ooxml:Value_drawingml_ST_PresetLineDashVal_lgDashDot" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetLineDashVal_lgDashDotDot, "ooxml:Value_drawingml_ST_PresetLineDashVal_lgDashDotDot" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetLineDashVal_sysDash, "ooxml:Value_drawingml_ST_PresetLineDashVal_sysDash" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetLineDashVal_sysDot, "ooxml:Value_drawingml_ST_PresetLineDashVal_sysDot" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetLineDashVal_sysDashDot, "ooxml:Value_drawingml_ST_PresetLineDashVal_sysDashDot" },
    { NS_ooxml::LN_Value_drawingml_ST_PresetLineDashVal_sysDashDotDot, "ooxml:Value_drawingml_ST_PresetLineDashVal_sysDashDotDot" },
    { NS_ooxml::LN_Value_drawingml_ST_LineCap_rnd, "ooxml:Value_drawingml_ST_LineCap_rnd" },
    { NS_ooxml::LN_Value_drawingml_ST_LineCap_sq, "ooxml:Value_drawingml_ST_LineCap_sq" },
    { NS_ooxml::LN_Value_drawingml_ST_LineCap_flat, "ooxml:Value_drawingml_ST_LineCap_flat" },
    { NS_ooxml::LN_Value_drawingml_ST_PenAlignment_ctr, "ooxml:Value_drawingml_ST_PenAlignment_ctr" },
    { NS_ooxml::LN_Value_drawingml_ST_PenAlignment_in, "ooxml:Value_drawingml_ST_PenAlignment_in" },
    { NS_ooxml::LN_Value_drawingml_ST_CompoundLine_sng, "ooxml:Value_drawingml_ST_CompoundLine_sng" },
    { NS_ooxml::LN_Value_drawingml_ST_CompoundLine_dbl, "ooxml:Value_drawingml_ST_CompoundLine_dbl" },
    { NS_ooxml::LN_Value_drawingml_ST_CompoundLine_thickThin, "ooxml:Value_drawingml_ST_CompoundLine_thickThin" },
    { NS_ooxml::LN_Value_drawingml_ST_CompoundLine_thinThick, "ooxml:Value_drawingml_ST_CompoundLine_thinThick" },
    { NS_ooxml::LN_Value_drawingml_ST_CompoundLine_tri, "ooxml:Value_drawingml_ST_CompoundLine_tri" },
    { NS_ooxml::LN_CT_LineProperties_headEnd, "ooxml:CT_LineProperties_headEnd" },
    { NS_ooxml::LN_CT_LineProperties_tailEnd, "ooxml:CT_LineProperties_tailEnd" },
    { NS_ooxml::LN_CT_LineProperties_extLst, "ooxml:CT_LineProperties_extLst" },
    { NS_ooxml::LN_CT_LineProperties_w, "ooxml:CT_LineProperties_w" },
    { NS_ooxml::LN_CT_LineProperties_cap, "ooxml:CT_LineProperties_cap" },
    { NS_ooxml::LN_CT_LineProperties_cmpd, "ooxml:CT_LineProperties_cmpd" },
    { NS_ooxml::LN_CT_LineProperties_algn, "ooxml:CT_LineProperties_algn" },
    { NS_ooxml::LN_CT_ShapeProperties_xfrm, "ooxml:CT_ShapeProperties_xfrm" },
    { NS_ooxml::LN_CT_ShapeProperties_ln, "ooxml:CT_ShapeProperties_ln" },
    { NS_ooxml::LN_CT_ShapeProperties_scene3d, "ooxml:CT_ShapeProperties_scene3d" },
    { NS_ooxml::LN_CT_ShapeProperties_sp3d, "ooxml:CT_ShapeProperties_sp3d" },
    { NS_ooxml::LN_CT_ShapeProperties_extLst, "ooxml:CT_ShapeProperties_extLst" },
    { NS_ooxml::LN_CT_ShapeProperties_bwMode, "ooxml:CT_ShapeProperties_bwMode" },
    { NS_ooxml::LN_CT_OfficeArtExtension_Decorative, "ooxml:CT_OfficeArtExtension_Decorative" },
    { NS_ooxml::LN_OfficeArtExtension_Decorative_val, "ooxml:OfficeArtExtension_Decorative_val" },
    { NS_ooxml::LN_CT_Angle_val, "ooxml:CT_Angle_val" },
    { NS_ooxml::LN_CT_PositiveFixedAngle_val, "ooxml:CT_PositiveFixedAngle_val" },
    { NS_ooxml::LN_CT_Percentage_val, "ooxml:CT_Percentage_val" },
    { NS_ooxml::LN_CT_PositivePercentage_val, "ooxml:CT_PositivePercentage_val" },
    { NS_ooxml::LN_CT_FixedPercentage_val, "ooxml:CT_FixedPercentage_val" },
    { NS_ooxml::LN_CT_PositiveFixedPercentage_val, "ooxml:CT_PositiveFixedPercentage_val" },
    { NS_ooxml::LN_CT_Point2D_x, "ooxml:CT_Point2D_x" },
    { NS_ooxml::LN_CT_Point2D_y, "ooxml:CT_Point2D_y" },
    { NS_ooxml::LN_CT_PositiveSize2D_cx, "ooxml:CT_PositiveSize2D_cx" },
    { NS_ooxml::LN_CT_PositiveSize2D_cy, "ooxml:CT_PositiveSize2D_cy" },
    { NS_ooxml::LN_CT_ScRgbColor_r, "ooxml:CT_ScRgbColor_r" },
    { NS_ooxml::LN_CT_ScRgbColor_g, "ooxml:CT_ScRgbColor_g" },
    { NS_ooxml::LN_CT_ScRgbColor_b, "ooxml:CT_ScRgbColor_b" },
    { NS_ooxml::LN_CT_SRgbColor_val, "ooxml:CT_SRgbColor_val" },
    { NS_ooxml::LN_CT_HslColor_hue, "ooxml:CT_HslColor_hue" },
    { NS_ooxml::LN_CT_HslColor_sat, "ooxml:CT_HslColor_sat" },
    { NS_ooxml::LN_CT_HslColor_lum, "ooxml:CT_HslColor_lum" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_scrollBar, "ooxml:Value_drawingml_ST_SystemColorVal_scrollBar" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_background, "ooxml:Value_drawingml_ST_SystemColorVal_background" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_activeCaption, "ooxml:Value_drawingml_ST_SystemColorVal_activeCaption" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_inactiveCaption, "ooxml:Value_drawingml_ST_SystemColorVal_inactiveCaption" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_menu, "ooxml:Value_drawingml_ST_SystemColorVal_menu" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_window, "ooxml:Value_drawingml_ST_SystemColorVal_window" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_windowFrame, "ooxml:Value_drawingml_ST_SystemColorVal_windowFrame" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_menuText, "ooxml:Value_drawingml_ST_SystemColorVal_menuText" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_windowText, "ooxml:Value_drawingml_ST_SystemColorVal_windowText" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_captionText, "ooxml:Value_drawingml_ST_SystemColorVal_captionText" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_activeBorder, "ooxml:Value_drawingml_ST_SystemColorVal_activeBorder" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_inactiveBorder, "ooxml:Value_drawingml_ST_SystemColorVal_inactiveBorder" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_appWorkspace, "ooxml:Value_drawingml_ST_SystemColorVal_appWorkspace" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_highlight, "ooxml:Value_drawingml_ST_SystemColorVal_highlight" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_highlightText, "ooxml:Value_drawingml_ST_SystemColorVal_highlightText" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_btnFace, "ooxml:Value_drawingml_ST_SystemColorVal_btnFace" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_btnShadow, "ooxml:Value_drawingml_ST_SystemColorVal_btnShadow" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_grayText, "ooxml:Value_drawingml_ST_SystemColorVal_grayText" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_btnText, "ooxml:Value_drawingml_ST_SystemColorVal_btnText" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_inactiveCaptionText, "ooxml:Value_drawingml_ST_SystemColorVal_inactiveCaptionText" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_btnHighlight, "ooxml:Value_drawingml_ST_SystemColorVal_btnHighlight" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_3dDkShadow, "ooxml:Value_drawingml_ST_SystemColorVal_3dDkShadow" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_3dLight, "ooxml:Value_drawingml_ST_SystemColorVal_3dLight" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_infoText, "ooxml:Value_drawingml_ST_SystemColorVal_infoText" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_infoBk, "ooxml:Value_drawingml_ST_SystemColorVal_infoBk" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_hotLight, "ooxml:Value_drawingml_ST_SystemColorVal_hotLight" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_gradientActiveCaption, "ooxml:Value_drawingml_ST_SystemColorVal_gradientActiveCaption" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_gradientInactiveCaption, "ooxml:Value_drawingml_ST_SystemColorVal_gradientInactiveCaption" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_menuHighlight, "ooxml:Value_drawingml_ST_SystemColorVal_menuHighlight" },
    { NS_ooxml::LN_Value_drawingml_ST_SystemColorVal_menuBar, "ooxml:Value_drawingml_ST_SystemColorVal_menuBar" },
    { NS_ooxml::LN_CT_SystemColor_val, "ooxml:CT_SystemColor_val" },
    { NS_ooxml::LN_CT_SystemColor_lastClr, "ooxml:CT_SystemColor_lastClr" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_bg1, "ooxml:Value_drawingml_ST_SchemeColorVal_bg1" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_tx1, "ooxml:Value_drawingml_ST_SchemeColorVal_tx1" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_bg2, "ooxml:Value_drawingml_ST_SchemeColorVal_bg2" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_tx2, "ooxml:Value_drawingml_ST_SchemeColorVal_tx2" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_accent1, "ooxml:Value_drawingml_ST_SchemeColorVal_accent1" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_accent2, "ooxml:Value_drawingml_ST_SchemeColorVal_accent2" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_accent3, "ooxml:Value_drawingml_ST_SchemeColorVal_accent3" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_accent4, "ooxml:Value_drawingml_ST_SchemeColorVal_accent4" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_accent5, "ooxml:Value_drawingml_ST_SchemeColorVal_accent5" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_accent6, "ooxml:Value_drawingml_ST_SchemeColorVal_accent6" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_hlink, "ooxml:Value_drawingml_ST_SchemeColorVal_hlink" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_folHlink, "ooxml:Value_drawingml_ST_SchemeColorVal_folHlink" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_phClr, "ooxml:Value_drawingml_ST_SchemeColorVal_phClr" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_dk1, "ooxml:Value_drawingml_ST_SchemeColorVal_dk1" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_lt1, "ooxml:Value_drawingml_ST_SchemeColorVal_lt1" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_dk2, "ooxml:Value_drawingml_ST_SchemeColorVal_dk2" },
    { NS_ooxml::LN_Value_drawingml_ST_SchemeColorVal_lt2, "ooxml:Value_drawingml_ST_SchemeColorVal_lt2" },
    { NS_ooxml::LN_CT_SchemeColor_val, "ooxml:CT_SchemeColor_val" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_aliceBlue, "ooxml:Value_ST_PresetColorVal_aliceBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_antiqueWhite, "ooxml:Value_ST_PresetColorVal_antiqueWhite" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_aqua, "ooxml:Value_ST_PresetColorVal_aqua" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_aquamarine, "ooxml:Value_ST_PresetColorVal_aquamarine" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_azure, "ooxml:Value_ST_PresetColorVal_azure" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_beige, "ooxml:Value_ST_PresetColorVal_beige" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_bisque, "ooxml:Value_ST_PresetColorVal_bisque" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_black, "ooxml:Value_ST_PresetColorVal_black" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_blanchedAlmond, "ooxml:Value_ST_PresetColorVal_blanchedAlmond" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_blue, "ooxml:Value_ST_PresetColorVal_blue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_blueViolet, "ooxml:Value_ST_PresetColorVal_blueViolet" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_brown, "ooxml:Value_ST_PresetColorVal_brown" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_burlyWood, "ooxml:Value_ST_PresetColorVal_burlyWood" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_cadetBlue, "ooxml:Value_ST_PresetColorVal_cadetBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_chartreuse, "ooxml:Value_ST_PresetColorVal_chartreuse" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_chocolate, "ooxml:Value_ST_PresetColorVal_chocolate" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_coral, "ooxml:Value_ST_PresetColorVal_coral" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_cornflowerBlue, "ooxml:Value_ST_PresetColorVal_cornflowerBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_cornsilk, "ooxml:Value_ST_PresetColorVal_cornsilk" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_crimson, "ooxml:Value_ST_PresetColorVal_crimson" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_cyan, "ooxml:Value_ST_PresetColorVal_cyan" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_deepPink, "ooxml:Value_ST_PresetColorVal_deepPink" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_deepSkyBlue, "ooxml:Value_ST_PresetColorVal_deepSkyBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dimGray, "ooxml:Value_ST_PresetColorVal_dimGray" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkBlue, "ooxml:Value_ST_PresetColorVal_dkBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkCyan, "ooxml:Value_ST_PresetColorVal_dkCyan" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkGoldenrod, "ooxml:Value_ST_PresetColorVal_dkGoldenrod" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkGray, "ooxml:Value_ST_PresetColorVal_dkGray" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkGreen, "ooxml:Value_ST_PresetColorVal_dkGreen" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkKhaki, "ooxml:Value_ST_PresetColorVal_dkKhaki" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkMagenta, "ooxml:Value_ST_PresetColorVal_dkMagenta" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkOliveGreen, "ooxml:Value_ST_PresetColorVal_dkOliveGreen" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkOrange, "ooxml:Value_ST_PresetColorVal_dkOrange" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkOrchid, "ooxml:Value_ST_PresetColorVal_dkOrchid" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkRed, "ooxml:Value_ST_PresetColorVal_dkRed" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkSalmon, "ooxml:Value_ST_PresetColorVal_dkSalmon" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkSeaGreen, "ooxml:Value_ST_PresetColorVal_dkSeaGreen" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkSlateBlue, "ooxml:Value_ST_PresetColorVal_dkSlateBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkSlateGray, "ooxml:Value_ST_PresetColorVal_dkSlateGray" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkTurquoise, "ooxml:Value_ST_PresetColorVal_dkTurquoise" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dkViolet, "ooxml:Value_ST_PresetColorVal_dkViolet" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_dodgerBlue, "ooxml:Value_ST_PresetColorVal_dodgerBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_firebrick, "ooxml:Value_ST_PresetColorVal_firebrick" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_floralWhite, "ooxml:Value_ST_PresetColorVal_floralWhite" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_forestGreen, "ooxml:Value_ST_PresetColorVal_forestGreen" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_fuchsia, "ooxml:Value_ST_PresetColorVal_fuchsia" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_gainsboro, "ooxml:Value_ST_PresetColorVal_gainsboro" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_ghostWhite, "ooxml:Value_ST_PresetColorVal_ghostWhite" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_gold, "ooxml:Value_ST_PresetColorVal_gold" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_goldenrod, "ooxml:Value_ST_PresetColorVal_goldenrod" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_gray, "ooxml:Value_ST_PresetColorVal_gray" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_green, "ooxml:Value_ST_PresetColorVal_green" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_greenYellow, "ooxml:Value_ST_PresetColorVal_greenYellow" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_honeydew, "ooxml:Value_ST_PresetColorVal_honeydew" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_hotPink, "ooxml:Value_ST_PresetColorVal_hotPink" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_indianRed, "ooxml:Value_ST_PresetColorVal_indianRed" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_indigo, "ooxml:Value_ST_PresetColorVal_indigo" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_ivory, "ooxml:Value_ST_PresetColorVal_ivory" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_khaki, "ooxml:Value_ST_PresetColorVal_khaki" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_lavender, "ooxml:Value_ST_PresetColorVal_lavender" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_lavenderBlush, "ooxml:Value_ST_PresetColorVal_lavenderBlush" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_lawnGreen, "ooxml:Value_ST_PresetColorVal_lawnGreen" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_lemonChiffon, "ooxml:Value_ST_PresetColorVal_lemonChiffon" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_lime, "ooxml:Value_ST_PresetColorVal_lime" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_limeGreen, "ooxml:Value_ST_PresetColorVal_limeGreen" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_linen, "ooxml:Value_ST_PresetColorVal_linen" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_ltBlue, "ooxml:Value_ST_PresetColorVal_ltBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_ltCoral, "ooxml:Value_ST_PresetColorVal_ltCoral" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_ltCyan, "ooxml:Value_ST_PresetColorVal_ltCyan" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_ltGoldenrodYellow, "ooxml:Value_ST_PresetColorVal_ltGoldenrodYellow" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_ltGray, "ooxml:Value_ST_PresetColorVal_ltGray" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_ltGreen, "ooxml:Value_ST_PresetColorVal_ltGreen" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_ltPink, "ooxml:Value_ST_PresetColorVal_ltPink" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_ltSalmon, "ooxml:Value_ST_PresetColorVal_ltSalmon" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_ltSeaGreen, "ooxml:Value_ST_PresetColorVal_ltSeaGreen" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_ltSkyBlue, "ooxml:Value_ST_PresetColorVal_ltSkyBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_ltSlateGray, "ooxml:Value_ST_PresetColorVal_ltSlateGray" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_ltSteelBlue, "ooxml:Value_ST_PresetColorVal_ltSteelBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_ltYellow, "ooxml:Value_ST_PresetColorVal_ltYellow" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_magenta, "ooxml:Value_ST_PresetColorVal_magenta" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_maroon, "ooxml:Value_ST_PresetColorVal_maroon" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_medAquamarine, "ooxml:Value_ST_PresetColorVal_medAquamarine" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_medBlue, "ooxml:Value_ST_PresetColorVal_medBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_medOrchid, "ooxml:Value_ST_PresetColorVal_medOrchid" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_medPurple, "ooxml:Value_ST_PresetColorVal_medPurple" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_medSeaGreen, "ooxml:Value_ST_PresetColorVal_medSeaGreen" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_medSlateBlue, "ooxml:Value_ST_PresetColorVal_medSlateBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_medSpringGreen, "ooxml:Value_ST_PresetColorVal_medSpringGreen" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_medTurquoise, "ooxml:Value_ST_PresetColorVal_medTurquoise" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_medVioletRed, "ooxml:Value_ST_PresetColorVal_medVioletRed" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_midnightBlue, "ooxml:Value_ST_PresetColorVal_midnightBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_mintCream, "ooxml:Value_ST_PresetColorVal_mintCream" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_mistyRose, "ooxml:Value_ST_PresetColorVal_mistyRose" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_moccasin, "ooxml:Value_ST_PresetColorVal_moccasin" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_navajoWhite, "ooxml:Value_ST_PresetColorVal_navajoWhite" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_navy, "ooxml:Value_ST_PresetColorVal_navy" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_oldLace, "ooxml:Value_ST_PresetColorVal_oldLace" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_olive, "ooxml:Value_ST_PresetColorVal_olive" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_oliveDrab, "ooxml:Value_ST_PresetColorVal_oliveDrab" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_orange, "ooxml:Value_ST_PresetColorVal_orange" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_orangeRed, "ooxml:Value_ST_PresetColorVal_orangeRed" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_orchid, "ooxml:Value_ST_PresetColorVal_orchid" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_paleGoldenrod, "ooxml:Value_ST_PresetColorVal_paleGoldenrod" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_paleGreen, "ooxml:Value_ST_PresetColorVal_paleGreen" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_paleTurquoise, "ooxml:Value_ST_PresetColorVal_paleTurquoise" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_paleVioletRed, "ooxml:Value_ST_PresetColorVal_paleVioletRed" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_papayaWhip, "ooxml:Value_ST_PresetColorVal_papayaWhip" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_peachPuff, "ooxml:Value_ST_PresetColorVal_peachPuff" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_peru, "ooxml:Value_ST_PresetColorVal_peru" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_pink, "ooxml:Value_ST_PresetColorVal_pink" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_plum, "ooxml:Value_ST_PresetColorVal_plum" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_powderBlue, "ooxml:Value_ST_PresetColorVal_powderBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_purple, "ooxml:Value_ST_PresetColorVal_purple" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_red, "ooxml:Value_ST_PresetColorVal_red" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_rosyBrown, "ooxml:Value_ST_PresetColorVal_rosyBrown" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_royalBlue, "ooxml:Value_ST_PresetColorVal_royalBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_saddleBrown, "ooxml:Value_ST_PresetColorVal_saddleBrown" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_salmon, "ooxml:Value_ST_PresetColorVal_salmon" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_sandyBrown, "ooxml:Value_ST_PresetColorVal_sandyBrown" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_seaGreen, "ooxml:Value_ST_PresetColorVal_seaGreen" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_seaShell, "ooxml:Value_ST_PresetColorVal_seaShell" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_sienna, "ooxml:Value_ST_PresetColorVal_sienna" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_silver, "ooxml:Value_ST_PresetColorVal_silver" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_skyBlue, "ooxml:Value_ST_PresetColorVal_skyBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_slateBlue, "ooxml:Value_ST_PresetColorVal_slateBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_slateGray, "ooxml:Value_ST_PresetColorVal_slateGray" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_snow, "ooxml:Value_ST_PresetColorVal_snow" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_springGreen, "ooxml:Value_ST_PresetColorVal_springGreen" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_steelBlue, "ooxml:Value_ST_PresetColorVal_steelBlue" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_tan, "ooxml:Value_ST_PresetColorVal_tan" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_teal, "ooxml:Value_ST_PresetColorVal_teal" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_thistle, "ooxml:Value_ST_PresetColorVal_thistle" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_tomato, "ooxml:Value_ST_PresetColorVal_tomato" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_turquoise, "ooxml:Value_ST_PresetColorVal_turquoise" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_violet, "ooxml:Value_ST_PresetColorVal_violet" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_wheat, "ooxml:Value_ST_PresetColorVal_wheat" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_white, "ooxml:Value_ST_PresetColorVal_white" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_whiteSmoke, "ooxml:Value_ST_PresetColorVal_whiteSmoke" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_yellow, "ooxml:Value_ST_PresetColorVal_yellow" },
    { NS_ooxml::LN_Value_ST_PresetColorVal_yellowGreen, "ooxml:Value_ST_PresetColorVal_yellowGreen" },
    { NS_ooxml::LN_CT_PresetColor_val, "ooxml:CT_PresetColor_val" },
    { NS_ooxml::LN_CT_Transform2D_off, "ooxml:CT_Transform2D_off" },
    { NS_ooxml::LN_CT_Transform2D_ext, "ooxml:CT_Transform2D_ext" },
    { NS_ooxml::LN_CT_Transform2D_rot, "ooxml:CT_Transform2D_rot" },
    { NS_ooxml::LN_CT_Transform2D_flipH, "ooxml:CT_Transform2D_flipH" },
    { NS_ooxml::LN_CT_Transform2D_flipV, "ooxml:CT_Transform2D_flipV" },
    { NS_ooxml::LN_Value_drawingml_ST_RectAlignment_tl, "ooxml:Value_drawingml_ST_RectAlignment_tl" },
    { NS_ooxml::LN_Value_drawingml_ST_RectAlignment_t, "ooxml:Value_drawingml_ST_RectAlignment_t" },
    { NS_ooxml::LN_Value_drawingml_ST_RectAlignment_tr, "ooxml:Value_drawingml_ST_RectAlignment_tr" },
    { NS_ooxml::LN_Value_drawingml_ST_RectAlignment_l, "ooxml:Value_drawingml_ST_RectAlignment_l" },
    { NS_ooxml::LN_Value_drawingml_ST_RectAlignment_ctr, "ooxml:Value_drawingml_ST_RectAlignment_ctr" },
    { NS_ooxml::LN_Value_drawingml_ST_RectAlignment_r, "ooxml:Value_drawingml_ST_RectAlignment_r" },
    { NS_ooxml::LN_Value_drawingml_ST_RectAlignment_bl, "ooxml:Value_drawingml_ST_RectAlignment_bl" },
    { NS_ooxml::LN_Value_drawingml_ST_RectAlignment_b, "ooxml:Value_drawingml_ST_RectAlignment_b" },
    { NS_ooxml::LN_Value_drawingml_ST_RectAlignment_br, "ooxml:Value_drawingml_ST_RectAlignment_br" },
    { NS_ooxml::LN_EG_ColorChoice_scrgbClr, "ooxml:EG_ColorChoice_scrgbClr" },
    { NS_ooxml::LN_EG_ColorChoice_srgbClr, "ooxml:EG_ColorChoice_srgbClr" },
    { NS_ooxml::LN_EG_ColorChoice_hslClr, "ooxml:EG_ColorChoice_hslClr" },
    { NS_ooxml::LN_EG_ColorChoice_sysClr, "ooxml:EG_ColorChoice_sysClr" },
    { NS_ooxml::LN_EG_ColorChoice_schemeClr, "ooxml:EG_ColorChoice_schemeClr" },
    { NS_ooxml::LN_EG_ColorChoice_prstClr, "ooxml:EG_ColorChoice_prstClr" },
    { NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_clr, "ooxml:Value_drawingml_ST_BlackWhiteMode_clr" },
    { NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_auto, "ooxml:Value_drawingml_ST_BlackWhiteMode_auto" },
    { NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_gray, "ooxml:Value_drawingml_ST_BlackWhiteMode_gray" },
    { NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_ltGray, "ooxml:Value_drawingml_ST_BlackWhiteMode_ltGray" },
    { NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_invGray, "ooxml:Value_drawingml_ST_BlackWhiteMode_invGray" },
    { NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_grayWhite, "ooxml:Value_drawingml_ST_BlackWhiteMode_grayWhite" },
    { NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_blackGray, "ooxml:Value_drawingml_ST_BlackWhiteMode_blackGray" },
    { NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_blackWhite, "ooxml:Value_drawingml_ST_BlackWhiteMode_blackWhite" },
    { NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_black, "ooxml:Value_drawingml_ST_BlackWhiteMode_black" },
    { NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_white, "ooxml:Value_drawingml_ST_BlackWhiteMode_white" },
    { NS_ooxml::LN_Value_drawingml_ST_BlackWhiteMode_hidden, "ooxml:Value_drawingml_ST_BlackWhiteMode_hidden" },
    { NS_ooxml::LN_AG_Blob_r_embed, "ooxml:AG_Blob_r_embed" },
    { NS_ooxml::LN_AG_Blob_r_link, "ooxml:AG_Blob_r_link" },
    { NS_ooxml::LN_CT_Hyperlink_URL, "ooxml:CT_Hyperlink_URL" },
    { NS_ooxml::LN_CT_GraphicalObjectFrameLocking_extLst, "ooxml:CT_GraphicalObjectFrameLocking_extLst" },
    { NS_ooxml::LN_CT_GraphicalObjectFrameLocking_noGrp, "ooxml:CT_GraphicalObjectFrameLocking_noGrp" },
    { NS_ooxml::LN_CT_GraphicalObjectFrameLocking_noDrilldown, "ooxml:CT_GraphicalObjectFrameLocking_noDrilldown" },
    { NS_ooxml::LN_CT_GraphicalObjectFrameLocking_noSelect, "ooxml:CT_GraphicalObjectFrameLocking_noSelect" },
    { NS_ooxml::LN_CT_GraphicalObjectFrameLocking_noChangeAspect, "ooxml:CT_GraphicalObjectFrameLocking_noChangeAspect" },
    { NS_ooxml::LN_CT_GraphicalObjectFrameLocking_noMove, "ooxml:CT_GraphicalObjectFrameLocking_noMove" },
    { NS_ooxml::LN_CT_GraphicalObjectFrameLocking_noResize, "ooxml:CT_GraphicalObjectFrameLocking_noResize" },
    { NS_ooxml::LN_CT_OfficeArtExtension, "ooxml:CT_OfficeArtExtension" },
    { NS_ooxml::LN_CT_NonVisualDrawingProps_a_hlinkClick, "ooxml:CT_NonVisualDrawingProps_a_hlinkClick" },
    { NS_ooxml::LN_CT_NonVisualDrawingProps_hlinkHover, "ooxml:CT_NonVisualDrawingProps_hlinkHover" },
    { NS_ooxml::LN_CT_NonVisualDrawingProps_extLst, "ooxml:CT_NonVisualDrawingProps_extLst" },
    { NS_ooxml::LN_CT_NonVisualDrawingProps_id, "ooxml:CT_NonVisualDrawingProps_id" },
    { NS_ooxml::LN_CT_NonVisualDrawingProps_name, "ooxml:CT_NonVisualDrawingProps_name" },
    { NS_ooxml::LN_CT_NonVisualDrawingProps_descr, "ooxml:CT_NonVisualDrawingProps_descr" },
    { NS_ooxml::LN_CT_NonVisualDrawingProps_hidden, "ooxml:CT_NonVisualDrawingProps_hidden" },
    { NS_ooxml::LN_CT_NonVisualDrawingProps_title, "ooxml:CT_NonVisualDrawingProps_title" },
    { NS_ooxml::LN_CT_NonVisualPictureProperties_picLocks, "ooxml:CT_NonVisualPictureProperties_picLocks" },
    { NS_ooxml::LN_CT_NonVisualPictureProperties_extLst, "ooxml:CT_NonVisualPictureProperties_extLst" },
    { NS_ooxml::LN_CT_NonVisualPictureProperties_preferRelativeResize, "ooxml:CT_NonVisualPictureProperties_preferRelativeResize" },
    { NS_ooxml::LN_CT_NonVisualGraphicFrameProperties_graphicFrameLocks, "ooxml:CT_NonVisualGraphicFrameProperties_graphicFrameLocks" },
    { NS_ooxml::LN_CT_NonVisualGraphicFrameProperties_extLst, "ooxml:CT_NonVisualGraphicFrameProperties_extLst" },
    { NS_ooxml::LN_CT_GraphicalObjectData_pic, "ooxml:CT_GraphicalObjectData_pic" },
    { NS_ooxml::LN_CT_GraphicalObjectData_relIds, "ooxml:CT_GraphicalObjectData_relIds" },
    { NS_ooxml::LN_CT_GraphicalObjectData_lockedCanvas, "ooxml:CT_GraphicalObjectData_lockedCanvas" },
    { NS_ooxml::LN_CT_GraphicalObjectData_chart, "ooxml:CT_GraphicalObjectData_chart" },
    { NS_ooxml::LN_CT_GraphicalObjectData_wsp, "ooxml:CT_GraphicalObjectData_wsp" },
    { NS_ooxml::LN_CT_GraphicalObjectData_wgp, "ooxml:CT_GraphicalObjectData_wgp" },
    { NS_ooxml::LN_CT_GraphicalObjectData_wpc, "ooxml:CT_GraphicalObjectData_wpc" },
    { NS_ooxml::LN_CT_GraphicalObjectData_uri, "ooxml:CT_GraphicalObjectData_uri" },
    { NS_ooxml::LN_CT_GraphicalObject_graphicData, "ooxml:CT_GraphicalObject_graphicData" },
    { NS_ooxml::LN_graphic_graphic, "ooxml:graphic_graphic" },
    { NS_ooxml::LN_ST_SizeRelFromH_margin, "ooxml:ST_SizeRelFromH_margin" },
    { NS_ooxml::LN_ST_SizeRelFromH_page, "ooxml:ST_SizeRelFromH_page" },
    { NS_ooxml::LN_ST_SizeRelFromH_leftMargin, "ooxml:ST_SizeRelFromH_leftMargin" },
    { NS_ooxml::LN_ST_SizeRelFromH_rightMargin, "ooxml:ST_SizeRelFromH_rightMargin" },
    { NS_ooxml::LN_ST_SizeRelFromH_insideMargin, "ooxml:ST_SizeRelFromH_insideMargin" },
    { NS_ooxml::LN_ST_SizeRelFromH_outsideMargin, "ooxml:ST_SizeRelFromH_outsideMargin" },
    { NS_ooxml::LN_ST_SizeRelFromV_margin, "ooxml:ST_SizeRelFromV_margin" },
    { NS_ooxml::LN_ST_SizeRelFromV_page, "ooxml:ST_SizeRelFromV_page" },
    { NS_ooxml::LN_ST_SizeRelFromV_topMargin, "ooxml:ST_SizeRelFromV_topMargin" },
    { NS_ooxml::LN_ST_SizeRelFromV_bottomMargin, "ooxml:ST_SizeRelFromV_bottomMargin" },
    { NS_ooxml::LN_ST_SizeRelFromV_insideMargin, "ooxml:ST_SizeRelFromV_insideMargin" },
    { NS_ooxml::LN_ST_SizeRelFromV_outsideMargin, "ooxml:ST_SizeRelFromV_outsideMargin" },
    { NS_ooxml::LN_CT_SizeRelH_pctWidth, "ooxml:CT_SizeRelH_pctWidth" },
    { NS_ooxml::LN_CT_SizeRelH_relativeFrom, "ooxml:CT_SizeRelH_relativeFrom" },
    { NS_ooxml::LN_CT_SizeRelV_pctHeight, "ooxml:CT_SizeRelV_pctHeight" },
    { NS_ooxml::LN_CT_SizeRelV_relativeFrom, "ooxml:CT_SizeRelV_relativeFrom" },
    { NS_ooxml::LN_sizeRelH_sizeRelH, "ooxml:sizeRelH_sizeRelH" },
    { NS_ooxml::LN_sizeRelV_sizeRelV, "ooxml:sizeRelV_sizeRelV" },
    { NS_ooxml::LN_CT_String_val, "ooxml:CT_String_val" },
    { NS_ooxml::LN_CT_SdtCheckbox_checked, "ooxml:CT_SdtCheckbox_checked" },
    { NS_ooxml::LN_CT_SdtCheckbox_checkedState, "ooxml:CT_SdtCheckbox_checkedState" },
    { NS_ooxml::LN_CT_SdtCheckbox_uncheckedState, "ooxml:CT_SdtCheckbox_uncheckedState" },
    { NS_ooxml::LN_ST_SchemeColorVal_bg1, "ooxml:ST_SchemeColorVal_bg1" },
    { NS_ooxml::LN_ST_SchemeColorVal_tx1, "ooxml:ST_SchemeColorVal_tx1" },
    { NS_ooxml::LN_ST_SchemeColorVal_bg2, "ooxml:ST_SchemeColorVal_bg2" },
    { NS_ooxml::LN_ST_SchemeColorVal_tx2, "ooxml:ST_SchemeColorVal_tx2" },
    { NS_ooxml::LN_ST_SchemeColorVal_accent1, "ooxml:ST_SchemeColorVal_accent1" },
    { NS_ooxml::LN_ST_SchemeColorVal_accent2, "ooxml:ST_SchemeColorVal_accent2" },
    { NS_ooxml::LN_ST_SchemeColorVal_accent3, "ooxml:ST_SchemeColorVal_accent3" },
    { NS_ooxml::LN_ST_SchemeColorVal_accent4, "ooxml:ST_SchemeColorVal_accent4" },
    { NS_ooxml::LN_ST_SchemeColorVal_accent5, "ooxml:ST_SchemeColorVal_accent5" },
    { NS_ooxml::LN_ST_SchemeColorVal_accent6, "ooxml:ST_SchemeColorVal_accent6" },
    { NS_ooxml::LN_ST_SchemeColorVal_hlink, "ooxml:ST_SchemeColorVal_hlink" },
    { NS_ooxml::LN_ST_SchemeColorVal_folHlink, "ooxml:ST_SchemeColorVal_folHlink" },
    { NS_ooxml::LN_ST_SchemeColorVal_dk1, "ooxml:ST_SchemeColorVal_dk1" },
    { NS_ooxml::LN_ST_SchemeColorVal_lt1, "ooxml:ST_SchemeColorVal_lt1" },
    { NS_ooxml::LN_ST_SchemeColorVal_dk2, "ooxml:ST_SchemeColorVal_dk2" },
    { NS_ooxml::LN_ST_SchemeColorVal_lt2, "ooxml:ST_SchemeColorVal_lt2" },
    { NS_ooxml::LN_ST_SchemeColorVal_phClr, "ooxml:ST_SchemeColorVal_phClr" },
    { NS_ooxml::LN_ST_RectAlignment_none, "ooxml:ST_RectAlignment_none" },
    { NS_ooxml::LN_ST_RectAlignment_tl, "ooxml:ST_RectAlignment_tl" },
    { NS_ooxml::LN_ST_RectAlignment_t, "ooxml:ST_RectAlignment_t" },
    { NS_ooxml::LN_ST_RectAlignment_tr, "ooxml:ST_RectAlignment_tr" },
    { NS_ooxml::LN_ST_RectAlignment_l, "ooxml:ST_RectAlignment_l" },
    { NS_ooxml::LN_ST_RectAlignment_ctr, "ooxml:ST_RectAlignment_ctr" },
    { NS_ooxml::LN_ST_RectAlignment_r, "ooxml:ST_RectAlignment_r" },
    { NS_ooxml::LN_ST_RectAlignment_bl, "ooxml:ST_RectAlignment_bl" },
    { NS_ooxml::LN_ST_RectAlignment_b, "ooxml:ST_RectAlignment_b" },
    { NS_ooxml::LN_ST_RectAlignment_br, "ooxml:ST_RectAlignment_br" },
    { NS_ooxml::LN_ST_LineCap_rnd, "ooxml:ST_LineCap_rnd" },
    { NS_ooxml::LN_ST_LineCap_sq, "ooxml:ST_LineCap_sq" },
    { NS_ooxml::LN_ST_LineCap_flat, "ooxml:ST_LineCap_flat" },
    { NS_ooxml::LN_ST_CompoundLine_sng, "ooxml:ST_CompoundLine_sng" },
    { NS_ooxml::LN_ST_CompoundLine_dbl, "ooxml:ST_CompoundLine_dbl" },
    { NS_ooxml::LN_ST_CompoundLine_thickThin, "ooxml:ST_CompoundLine_thickThin" },
    { NS_ooxml::LN_ST_CompoundLine_thinThick, "ooxml:ST_CompoundLine_thinThick" },
    { NS_ooxml::LN_ST_CompoundLine_tri, "ooxml:ST_CompoundLine_tri" },
    { NS_ooxml::LN_ST_PenAlignment_ctr, "ooxml:ST_PenAlignment_ctr" },
    { NS_ooxml::LN_ST_PenAlignment_in, "ooxml:ST_PenAlignment_in" },
    { NS_ooxml::LN_ST_OnOff_true, "ooxml:ST_OnOff_true" },
    { NS_ooxml::LN_ST_OnOff_false, "ooxml:ST_OnOff_false" },
    { NS_ooxml::LN_ST_OnOff_0, "ooxml:ST_OnOff_0" },
    { NS_ooxml::LN_ST_OnOff_1, "ooxml:ST_OnOff_1" },
    { NS_ooxml::LN_ST_PathShadeType_shape, "ooxml:ST_PathShadeType_shape" },
    { NS_ooxml::LN_ST_PathShadeType_circle, "ooxml:ST_PathShadeType_circle" },
    { NS_ooxml::LN_ST_PathShadeType_rect, "ooxml:ST_PathShadeType_rect" },
    { NS_ooxml::LN_ST_PresetLineDashVal_solid, "ooxml:ST_PresetLineDashVal_solid" },
    { NS_ooxml::LN_ST_PresetLineDashVal_dot, "ooxml:ST_PresetLineDashVal_dot" },
    { NS_ooxml::LN_ST_PresetLineDashVal_sysDot, "ooxml:ST_PresetLineDashVal_sysDot" },
    { NS_ooxml::LN_ST_PresetLineDashVal_dash, "ooxml:ST_PresetLineDashVal_dash" },
    { NS_ooxml::LN_ST_PresetLineDashVal_sysDash, "ooxml:ST_PresetLineDashVal_sysDash" },
    { NS_ooxml::LN_ST_PresetLineDashVal_lgDash, "ooxml:ST_PresetLineDashVal_lgDash" },
    { NS_ooxml::LN_ST_PresetLineDashVal_dashDot, "ooxml:ST_PresetLineDashVal_dashDot" },
    { NS_ooxml::LN_ST_PresetLineDashVal_sysDashDot, "ooxml:ST_PresetLineDashVal_sysDashDot" },
    { NS_ooxml::LN_ST_PresetLineDashVal_lgDashDot, "ooxml:ST_PresetLineDashVal_lgDashDot" },
    { NS_ooxml::LN_ST_PresetLineDashVal_lgDashDotDot, "ooxml:ST_PresetLineDashVal_lgDashDotDot" },
    { NS_ooxml::LN_ST_PresetLineDashVal_sysDashDotDot, "ooxml:ST_PresetLineDashVal_sysDashDotDot" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyObliqueTopLeft, "ooxml:ST_PresetCameraType_legacyObliqueTopLeft" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyObliqueTop, "ooxml:ST_PresetCameraType_legacyObliqueTop" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyObliqueTopRight, "ooxml:ST_PresetCameraType_legacyObliqueTopRight" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyObliqueLeft, "ooxml:ST_PresetCameraType_legacyObliqueLeft" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyObliqueFront, "ooxml:ST_PresetCameraType_legacyObliqueFront" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyObliqueRight, "ooxml:ST_PresetCameraType_legacyObliqueRight" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyObliqueBottomLeft, "ooxml:ST_PresetCameraType_legacyObliqueBottomLeft" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyObliqueBottom, "ooxml:ST_PresetCameraType_legacyObliqueBottom" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyObliqueBottomRight, "ooxml:ST_PresetCameraType_legacyObliqueBottomRight" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveTopLeft, "ooxml:ST_PresetCameraType_legacyPerspectiveTopLeft" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveTop, "ooxml:ST_PresetCameraType_legacyPerspectiveTop" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveTopRight, "ooxml:ST_PresetCameraType_legacyPerspectiveTopRight" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveLeft, "ooxml:ST_PresetCameraType_legacyPerspectiveLeft" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveFront, "ooxml:ST_PresetCameraType_legacyPerspectiveFront" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveRight, "ooxml:ST_PresetCameraType_legacyPerspectiveRight" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveBottomLeft, "ooxml:ST_PresetCameraType_legacyPerspectiveBottomLeft" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveBottom, "ooxml:ST_PresetCameraType_legacyPerspectiveBottom" },
    { NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveBottomRight, "ooxml:ST_PresetCameraType_legacyPerspectiveBottomRight" },
    { NS_ooxml::LN_ST_PresetCameraType_orthographicFront, "ooxml:ST_PresetCameraType_orthographicFront" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricTopUp, "ooxml:ST_PresetCameraType_isometricTopUp" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricTopDown, "ooxml:ST_PresetCameraType_isometricTopDown" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricBottomUp, "ooxml:ST_PresetCameraType_isometricBottomUp" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricBottomDown, "ooxml:ST_PresetCameraType_isometricBottomDown" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricLeftUp, "ooxml:ST_PresetCameraType_isometricLeftUp" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricLeftDown, "ooxml:ST_PresetCameraType_isometricLeftDown" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricRightUp, "ooxml:ST_PresetCameraType_isometricRightUp" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricRightDown, "ooxml:ST_PresetCameraType_isometricRightDown" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis1Left, "ooxml:ST_PresetCameraType_isometricOffAxis1Left" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis1Right, "ooxml:ST_PresetCameraType_isometricOffAxis1Right" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis1Top, "ooxml:ST_PresetCameraType_isometricOffAxis1Top" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis2Left, "ooxml:ST_PresetCameraType_isometricOffAxis2Left" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis2Right, "ooxml:ST_PresetCameraType_isometricOffAxis2Right" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis2Top, "ooxml:ST_PresetCameraType_isometricOffAxis2Top" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis3Left, "ooxml:ST_PresetCameraType_isometricOffAxis3Left" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis3Right, "ooxml:ST_PresetCameraType_isometricOffAxis3Right" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis3Bottom, "ooxml:ST_PresetCameraType_isometricOffAxis3Bottom" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis4Left, "ooxml:ST_PresetCameraType_isometricOffAxis4Left" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis4Right, "ooxml:ST_PresetCameraType_isometricOffAxis4Right" },
    { NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis4Bottom, "ooxml:ST_PresetCameraType_isometricOffAxis4Bottom" },
    { NS_ooxml::LN_ST_PresetCameraType_obliqueTopLeft, "ooxml:ST_PresetCameraType_obliqueTopLeft" },
    { NS_ooxml::LN_ST_PresetCameraType_obliqueTop, "ooxml:ST_PresetCameraType_obliqueTop" },
    { NS_ooxml::LN_ST_PresetCameraType_obliqueTopRight, "ooxml:ST_PresetCameraType_obliqueTopRight" },
    { NS_ooxml::LN_ST_PresetCameraType_obliqueLeft, "ooxml:ST_PresetCameraType_obliqueLeft" },
    { NS_ooxml::LN_ST_PresetCameraType_obliqueRight, "ooxml:ST_PresetCameraType_obliqueRight" },
    { NS_ooxml::LN_ST_PresetCameraType_obliqueBottomLeft, "ooxml:ST_PresetCameraType_obliqueBottomLeft" },
    { NS_ooxml::LN_ST_PresetCameraType_obliqueBottom, "ooxml:ST_PresetCameraType_obliqueBottom" },
    { NS_ooxml::LN_ST_PresetCameraType_obliqueBottomRight, "ooxml:ST_PresetCameraType_obliqueBottomRight" },
    { NS_ooxml::LN_ST_PresetCameraType_perspectiveFront, "ooxml:ST_PresetCameraType_perspectiveFront" },
    { NS_ooxml::LN_ST_PresetCameraType_perspectiveLeft, "ooxml:ST_PresetCameraType_perspectiveLeft" },
    { NS_ooxml::LN_ST_PresetCameraType_perspectiveRight, "ooxml:ST_PresetCameraType_perspectiveRight" },
    { NS_ooxml::LN_ST_PresetCameraType_perspectiveAbove, "ooxml:ST_PresetCameraType_perspectiveAbove" },
    { NS_ooxml::LN_ST_PresetCameraType_perspectiveBelow, "ooxml:ST_PresetCameraType_perspectiveBelow" },
    { NS_ooxml::LN_ST_PresetCameraType_perspectiveAboveLeftFacing, "ooxml:ST_PresetCameraType_perspectiveAboveLeftFacing" },
    { NS_ooxml::LN_ST_PresetCameraType_perspectiveAboveRightFacing, "ooxml:ST_PresetCameraType_perspectiveAboveRightFacing" },
    { NS_ooxml::LN_ST_PresetCameraType_perspectiveContrastingLeftFacing, "ooxml:ST_PresetCameraType_perspectiveContrastingLeftFacing" },
    { NS_ooxml::LN_ST_PresetCameraType_perspectiveContrastingRightFacing, "ooxml:ST_PresetCameraType_perspectiveContrastingRightFacing" },
    { NS_ooxml::LN_ST_PresetCameraType_perspectiveHeroicLeftFacing, "ooxml:ST_PresetCameraType_perspectiveHeroicLeftFacing" },
    { NS_ooxml::LN_ST_PresetCameraType_perspectiveHeroicRightFacing, "ooxml:ST_PresetCameraType_perspectiveHeroicRightFacing" },
    { NS_ooxml::LN_ST_PresetCameraType_perspectiveHeroicExtremeLeftFacing, "ooxml:ST_PresetCameraType_perspectiveHeroicExtremeLeftFacing" },
    { NS_ooxml::LN_ST_PresetCameraType_perspectiveHeroicExtremeRightFacing, "ooxml:ST_PresetCameraType_perspectiveHeroicExtremeRightFacing" },
    { NS_ooxml::LN_ST_PresetCameraType_perspectiveRelaxed, "ooxml:ST_PresetCameraType_perspectiveRelaxed" },
    { NS_ooxml::LN_ST_PresetCameraType_perspectiveRelaxedModerately, "ooxml:ST_PresetCameraType_perspectiveRelaxedModerately" },
    { NS_ooxml::LN_ST_LightRigType_legacyFlat1, "ooxml:ST_LightRigType_legacyFlat1" },
    { NS_ooxml::LN_ST_LightRigType_legacyFlat2, "ooxml:ST_LightRigType_legacyFlat2" },
    { NS_ooxml::LN_ST_LightRigType_legacyFlat3, "ooxml:ST_LightRigType_legacyFlat3" },
    { NS_ooxml::LN_ST_LightRigType_legacyFlat4, "ooxml:ST_LightRigType_legacyFlat4" },
    { NS_ooxml::LN_ST_LightRigType_legacyNormal1, "ooxml:ST_LightRigType_legacyNormal1" },
    { NS_ooxml::LN_ST_LightRigType_legacyNormal2, "ooxml:ST_LightRigType_legacyNormal2" },
    { NS_ooxml::LN_ST_LightRigType_legacyNormal3, "ooxml:ST_LightRigType_legacyNormal3" },
    { NS_ooxml::LN_ST_LightRigType_legacyNormal4, "ooxml:ST_LightRigType_legacyNormal4" },
    { NS_ooxml::LN_ST_LightRigType_legacyHarsh1, "ooxml:ST_LightRigType_legacyHarsh1" },
    { NS_ooxml::LN_ST_LightRigType_legacyHarsh2, "ooxml:ST_LightRigType_legacyHarsh2" },
    { NS_ooxml::LN_ST_LightRigType_legacyHarsh3, "ooxml:ST_LightRigType_legacyHarsh3" },
    { NS_ooxml::LN_ST_LightRigType_legacyHarsh4, "ooxml:ST_LightRigType_legacyHarsh4" },
    { NS_ooxml::LN_ST_LightRigType_threePt, "ooxml:ST_LightRigType_threePt" },
    { NS_ooxml::LN_ST_LightRigType_balanced, "ooxml:ST_LightRigType_balanced" },
    { NS_ooxml::LN_ST_LightRigType_soft, "ooxml:ST_LightRigType_soft" },
    { NS_ooxml::LN_ST_LightRigType_harsh, "ooxml:ST_LightRigType_harsh" },
    { NS_ooxml::LN_ST_LightRigType_flood, "ooxml:ST_LightRigType_flood" },
    { NS_ooxml::LN_ST_LightRigType_contrasting, "ooxml:ST_LightRigType_contrasting" },
    { NS_ooxml::LN_ST_LightRigType_morning, "ooxml:ST_LightRigType_morning" },
    { NS_ooxml::LN_ST_LightRigType_sunrise, "ooxml:ST_LightRigType_sunrise" },
    { NS_ooxml::LN_ST_LightRigType_sunset, "ooxml:ST_LightRigType_sunset" },
    { NS_ooxml::LN_ST_LightRigType_chilly, "ooxml:ST_LightRigType_chilly" },
    { NS_ooxml::LN_ST_LightRigType_freezing, "ooxml:ST_LightRigType_freezing" },
    { NS_ooxml::LN_ST_LightRigType_flat, "ooxml:ST_LightRigType_flat" },
    { NS_ooxml::LN_ST_LightRigType_twoPt, "ooxml:ST_LightRigType_twoPt" },
    { NS_ooxml::LN_ST_LightRigType_glow, "ooxml:ST_LightRigType_glow" },
    { NS_ooxml::LN_ST_LightRigType_brightRoom, "ooxml:ST_LightRigType_brightRoom" },
    { NS_ooxml::LN_ST_LightRigDirection_tl, "ooxml:ST_LightRigDirection_tl" },
    { NS_ooxml::LN_ST_LightRigDirection_t, "ooxml:ST_LightRigDirection_t" },
    { NS_ooxml::LN_ST_LightRigDirection_tr, "ooxml:ST_LightRigDirection_tr" },
    { NS_ooxml::LN_ST_LightRigDirection_l, "ooxml:ST_LightRigDirection_l" },
    { NS_ooxml::LN_ST_LightRigDirection_r, "ooxml:ST_LightRigDirection_r" },
    { NS_ooxml::LN_ST_LightRigDirection_bl, "ooxml:ST_LightRigDirection_bl" },
    { NS_ooxml::LN_ST_LightRigDirection_b, "ooxml:ST_LightRigDirection_b" },
    { NS_ooxml::LN_ST_LightRigDirection_br, "ooxml:ST_LightRigDirection_br" },
    { NS_ooxml::LN_ST_BevelPresetType_relaxedInset, "ooxml:ST_BevelPresetType_relaxedInset" },
    { NS_ooxml::LN_ST_BevelPresetType_circle, "ooxml:ST_BevelPresetType_circle" },
    { NS_ooxml::LN_ST_BevelPresetType_slope, "ooxml:ST_BevelPresetType_slope" },
    { NS_ooxml::LN_ST_BevelPresetType_cross, "ooxml:ST_BevelPresetType_cross" },
    { NS_ooxml::LN_ST_BevelPresetType_angle, "ooxml:ST_BevelPresetType_angle" },
    { NS_ooxml::LN_ST_BevelPresetType_softRound, "ooxml:ST_BevelPresetType_softRound" },
    { NS_ooxml::LN_ST_BevelPresetType_convex, "ooxml:ST_BevelPresetType_convex" },
    { NS_ooxml::LN_ST_BevelPresetType_coolSlant, "ooxml:ST_BevelPresetType_coolSlant" },
    { NS_ooxml::LN_ST_BevelPresetType_divot, "ooxml:ST_BevelPresetType_divot" },
    { NS_ooxml::LN_ST_BevelPresetType_riblet, "ooxml:ST_BevelPresetType_riblet" },
    { NS_ooxml::LN_ST_BevelPresetType_hardEdge, "ooxml:ST_BevelPresetType_hardEdge" },
    { NS_ooxml::LN_ST_BevelPresetType_artDeco, "ooxml:ST_BevelPresetType_artDeco" },
    { NS_ooxml::LN_ST_PresetMaterialType_legacyMatte, "ooxml:ST_PresetMaterialType_legacyMatte" },
    { NS_ooxml::LN_ST_PresetMaterialType_legacyPlastic, "ooxml:ST_PresetMaterialType_legacyPlastic" },
    { NS_ooxml::LN_ST_PresetMaterialType_legacyMetal, "ooxml:ST_PresetMaterialType_legacyMetal" },
    { NS_ooxml::LN_ST_PresetMaterialType_legacyWireframe, "ooxml:ST_PresetMaterialType_legacyWireframe" },
    { NS_ooxml::LN_ST_PresetMaterialType_matte, "ooxml:ST_PresetMaterialType_matte" },
    { NS_ooxml::LN_ST_PresetMaterialType_plastic, "ooxml:ST_PresetMaterialType_plastic" },
    { NS_ooxml::LN_ST_PresetMaterialType_metal, "ooxml:ST_PresetMaterialType_metal" },
    { NS_ooxml::LN_ST_PresetMaterialType_warmMatte, "ooxml:ST_PresetMaterialType_warmMatte" },
    { NS_ooxml::LN_ST_PresetMaterialType_translucentPowder, "ooxml:ST_PresetMaterialType_translucentPowder" },
    { NS_ooxml::LN_ST_PresetMaterialType_powder, "ooxml:ST_PresetMaterialType_powder" },
    { NS_ooxml::LN_ST_PresetMaterialType_dkEdge, "ooxml:ST_PresetMaterialType_dkEdge" },
    { NS_ooxml::LN_ST_PresetMaterialType_softEdge, "ooxml:ST_PresetMaterialType_softEdge" },
    { NS_ooxml::LN_ST_PresetMaterialType_clear, "ooxml:ST_PresetMaterialType_clear" },
    { NS_ooxml::LN_ST_PresetMaterialType_flat, "ooxml:ST_PresetMaterialType_flat" },
    { NS_ooxml::LN_ST_PresetMaterialType_softmetal, "ooxml:ST_PresetMaterialType_softmetal" },
    { NS_ooxml::LN_ST_PresetMaterialType_none, "ooxml:ST_PresetMaterialType_none" },
    { NS_ooxml::LN_ST_Ligatures_none, "ooxml:ST_Ligatures_none" },
    { NS_ooxml::LN_ST_Ligatures_standard, "ooxml:ST_Ligatures_standard" },
    { NS_ooxml::LN_ST_Ligatures_contextual, "ooxml:ST_Ligatures_contextual" },
    { NS_ooxml::LN_ST_Ligatures_historical, "ooxml:ST_Ligatures_historical" },
    { NS_ooxml::LN_ST_Ligatures_discretional, "ooxml:ST_Ligatures_discretional" },
    { NS_ooxml::LN_ST_Ligatures_standardContextual, "ooxml:ST_Ligatures_standardContextual" },
    { NS_ooxml::LN_ST_Ligatures_standardHistorical, "ooxml:ST_Ligatures_standardHistorical" },
    { NS_ooxml::LN_ST_Ligatures_contextualHistorical, "ooxml:ST_Ligatures_contextualHistorical" },
    { NS_ooxml::LN_ST_Ligatures_standardDiscretional, "ooxml:ST_Ligatures_standardDiscretional" },
    { NS_ooxml::LN_ST_Ligatures_contextualDiscretional, "ooxml:ST_Ligatures_contextualDiscretional" },
    { NS_ooxml::LN_ST_Ligatures_historicalDiscretional, "ooxml:ST_Ligatures_historicalDiscretional" },
    { NS_ooxml::LN_ST_Ligatures_standardContextualHistorical, "ooxml:ST_Ligatures_standardContextualHistorical" },
    { NS_ooxml::LN_ST_Ligatures_standardContextualDiscretional, "ooxml:ST_Ligatures_standardContextualDiscretional" },
    { NS_ooxml::LN_ST_Ligatures_standardHistoricalDiscretional, "ooxml:ST_Ligatures_standardHistoricalDiscretional" },
    { NS_ooxml::LN_ST_Ligatures_contextualHistoricalDiscretional, "ooxml:ST_Ligatures_contextualHistoricalDiscretional" },
    { NS_ooxml::LN_ST_Ligatures_all, "ooxml:ST_Ligatures_all" },
    { NS_ooxml::LN_ST_NumForm_default, "ooxml:ST_NumForm_default" },
    { NS_ooxml::LN_ST_NumForm_lining, "ooxml:ST_NumForm_lining" },
    { NS_ooxml::LN_ST_NumForm_oldStyle, "ooxml:ST_NumForm_oldStyle" },
    { NS_ooxml::LN_ST_NumSpacing_default, "ooxml:ST_NumSpacing_default" },
    { NS_ooxml::LN_ST_NumSpacing_proportional, "ooxml:ST_NumSpacing_proportional" },
    { NS_ooxml::LN_ST_NumSpacing_tabular, "ooxml:ST_NumSpacing_tabular" },
    { NS_ooxml::LN_EG_ColorTransform_tint, "ooxml:EG_ColorTransform_tint" },
    { NS_ooxml::LN_EG_ColorTransform_shade, "ooxml:EG_ColorTransform_shade" },
    { NS_ooxml::LN_EG_ColorTransform_alpha, "ooxml:EG_ColorTransform_alpha" },
    { NS_ooxml::LN_EG_ColorTransform_hueMod, "ooxml:EG_ColorTransform_hueMod" },
    { NS_ooxml::LN_EG_ColorTransform_sat, "ooxml:EG_ColorTransform_sat" },
    { NS_ooxml::LN_EG_ColorTransform_satOff, "ooxml:EG_ColorTransform_satOff" },
    { NS_ooxml::LN_EG_ColorTransform_satMod, "ooxml:EG_ColorTransform_satMod" },
    { NS_ooxml::LN_EG_ColorTransform_lum, "ooxml:EG_ColorTransform_lum" },
    { NS_ooxml::LN_EG_ColorTransform_lumOff, "ooxml:EG_ColorTransform_lumOff" },
    { NS_ooxml::LN_EG_ColorTransform_lumMod, "ooxml:EG_ColorTransform_lumMod" },
    { NS_ooxml::LN_EG_FillProperties_noFill, "ooxml:EG_FillProperties_noFill" },
    { NS_ooxml::LN_EG_FillProperties_solidFill, "ooxml:EG_FillProperties_solidFill" },
    { NS_ooxml::LN_EG_FillProperties_gradFill, "ooxml:EG_FillProperties_gradFill" },
    { NS_ooxml::LN_EG_ShadeProperties_lin, "ooxml:EG_ShadeProperties_lin" },
    { NS_ooxml::LN_EG_ShadeProperties_path, "ooxml:EG_ShadeProperties_path" },
    { NS_ooxml::LN_EG_LineDashProperties_prstDash, "ooxml:EG_LineDashProperties_prstDash" },
    { NS_ooxml::LN_EG_LineJoinProperties_round, "ooxml:EG_LineJoinProperties_round" },
    { NS_ooxml::LN_EG_LineJoinProperties_bevel, "ooxml:EG_LineJoinProperties_bevel" },
    { NS_ooxml::LN_EG_LineJoinProperties_miter, "ooxml:EG_LineJoinProperties_miter" },
    { NS_ooxml::LN_CT_Glow_rad, "ooxml:CT_Glow_rad" },
    { NS_ooxml::LN_CT_GradientFillProperties_gsLst, "ooxml:CT_GradientFillProperties_gsLst" },
    { NS_ooxml::LN_CT_GradientStopList_gs, "ooxml:CT_GradientStopList_gs" },
    { NS_ooxml::LN_CT_LinearShadeProperties_ang, "ooxml:CT_LinearShadeProperties_ang" },
    { NS_ooxml::LN_CT_LinearShadeProperties_scaled, "ooxml:CT_LinearShadeProperties_scaled" },
    { NS_ooxml::LN_CT_PathShadeProperties_fillToRect, "ooxml:CT_PathShadeProperties_fillToRect" },
    { NS_ooxml::LN_CT_PathShadeProperties_path, "ooxml:CT_PathShadeProperties_path" },
    { NS_ooxml::LN_CT_RelativeRect_l, "ooxml:CT_RelativeRect_l" },
    { NS_ooxml::LN_CT_RelativeRect_t, "ooxml:CT_RelativeRect_t" },
    { NS_ooxml::LN_CT_RelativeRect_r, "ooxml:CT_RelativeRect_r" },
    { NS_ooxml::LN_CT_RelativeRect_b, "ooxml:CT_RelativeRect_b" },
    { NS_ooxml::LN_CT_PresetLineDashProperties_val, "ooxml:CT_PresetLineDashProperties_val" },
    { NS_ooxml::LN_CT_LineJoinMiterProperties_lim, "ooxml:CT_LineJoinMiterProperties_lim" },
    { NS_ooxml::LN_CT_Camera_prst, "ooxml:CT_Camera_prst" },
    { NS_ooxml::LN_CT_LightRig_rot, "ooxml:CT_LightRig_rot" },
    { NS_ooxml::LN_CT_LightRig_rig, "ooxml:CT_LightRig_rig" },
    { NS_ooxml::LN_CT_LightRig_dir, "ooxml:CT_LightRig_dir" },
    { NS_ooxml::LN_CT_SphereCoords_lat, "ooxml:CT_SphereCoords_lat" },
    { NS_ooxml::LN_CT_SphereCoords_lon, "ooxml:CT_SphereCoords_lon" },
    { NS_ooxml::LN_CT_SphereCoords_rev, "ooxml:CT_SphereCoords_rev" },
    { NS_ooxml::LN_CT_Bevel_w, "ooxml:CT_Bevel_w" },
    { NS_ooxml::LN_CT_Bevel_h, "ooxml:CT_Bevel_h" },
    { NS_ooxml::LN_CT_Bevel_prst, "ooxml:CT_Bevel_prst" },
    { NS_ooxml::LN_CT_StyleSet_id, "ooxml:CT_StyleSet_id" },
    { NS_ooxml::LN_CT_StyleSet_val, "ooxml:CT_StyleSet_val" },
    { NS_ooxml::LN_CT_OnOff_val, "ooxml:CT_OnOff_val" },
    { NS_ooxml::LN_CT_Shadow_blurRad, "ooxml:CT_Shadow_blurRad" },
    { NS_ooxml::LN_CT_Shadow_dist, "ooxml:CT_Shadow_dist" },
    { NS_ooxml::LN_CT_Shadow_dir, "ooxml:CT_Shadow_dir" },
    { NS_ooxml::LN_CT_Shadow_sx, "ooxml:CT_Shadow_sx" },
    { NS_ooxml::LN_CT_Shadow_sy, "ooxml:CT_Shadow_sy" },
    { NS_ooxml::LN_CT_Shadow_kx, "ooxml:CT_Shadow_kx" },
    { NS_ooxml::LN_CT_Shadow_ky, "ooxml:CT_Shadow_ky" },
    { NS_ooxml::LN_CT_Shadow_algn, "ooxml:CT_Shadow_algn" },
    { NS_ooxml::LN_CT_Reflection_blurRad, "ooxml:CT_Reflection_blurRad" },
    { NS_ooxml::LN_CT_Reflection_stA, "ooxml:CT_Reflection_stA" },
    { NS_ooxml::LN_CT_Reflection_stPos, "ooxml:CT_Reflection_stPos" },
    { NS_ooxml::LN_CT_Reflection_endA, "ooxml:CT_Reflection_endA" },
    { NS_ooxml::LN_CT_Reflection_endPos, "ooxml:CT_Reflection_endPos" },
    { NS_ooxml::LN_CT_Reflection_dist, "ooxml:CT_Reflection_dist" },
    { NS_ooxml::LN_CT_Reflection_dir, "ooxml:CT_Reflection_dir" },
    { NS_ooxml::LN_CT_Reflection_fadeDir, "ooxml:CT_Reflection_fadeDir" },
    { NS_ooxml::LN_CT_Reflection_sx, "ooxml:CT_Reflection_sx" },
    { NS_ooxml::LN_CT_Reflection_sy, "ooxml:CT_Reflection_sy" },
    { NS_ooxml::LN_CT_Reflection_kx, "ooxml:CT_Reflection_kx" },
    { NS_ooxml::LN_CT_Reflection_ky, "ooxml:CT_Reflection_ky" },
    { NS_ooxml::LN_CT_Reflection_algn, "ooxml:CT_Reflection_algn" },
    { NS_ooxml::LN_CT_TextOutlineEffect_w, "ooxml:CT_TextOutlineEffect_w" },
    { NS_ooxml::LN_CT_TextOutlineEffect_cap, "ooxml:CT_TextOutlineEffect_cap" },
    { NS_ooxml::LN_CT_TextOutlineEffect_cmpd, "ooxml:CT_TextOutlineEffect_cmpd" },
    { NS_ooxml::LN_CT_TextOutlineEffect_algn, "ooxml:CT_TextOutlineEffect_algn" },
    { NS_ooxml::LN_CT_Scene3D_camera, "ooxml:CT_Scene3D_camera" },
    { NS_ooxml::LN_CT_Scene3D_lightRig, "ooxml:CT_Scene3D_lightRig" },
    { NS_ooxml::LN_CT_Props3D_bevelT, "ooxml:CT_Props3D_bevelT" },
    { NS_ooxml::LN_CT_Props3D_bevelB, "ooxml:CT_Props3D_bevelB" },
    { NS_ooxml::LN_CT_Props3D_extrusionClr, "ooxml:CT_Props3D_extrusionClr" },
    { NS_ooxml::LN_CT_Props3D_contourClr, "ooxml:CT_Props3D_contourClr" },
    { NS_ooxml::LN_CT_Props3D_extrusionH, "ooxml:CT_Props3D_extrusionH" },
    { NS_ooxml::LN_CT_Props3D_contourW, "ooxml:CT_Props3D_contourW" },
    { NS_ooxml::LN_CT_Props3D_prstMaterial, "ooxml:CT_Props3D_prstMaterial" },
    { NS_ooxml::LN_CT_Ligatures_val, "ooxml:CT_Ligatures_val" },
    { NS_ooxml::LN_CT_NumForm_val, "ooxml:CT_NumForm_val" },
    { NS_ooxml::LN_CT_NumSpacing_val, "ooxml:CT_NumSpacing_val" },
    { NS_ooxml::LN_CT_StylisticSets_styleSet, "ooxml:CT_StylisticSets_styleSet" },
    { NS_ooxml::LN_glow_glow, "ooxml:glow_glow" },
    { NS_ooxml::LN_shadow_shadow, "ooxml:shadow_shadow" },
    { NS_ooxml::LN_reflection_reflection, "ooxml:reflection_reflection" },
    { NS_ooxml::LN_textOutline_textOutline, "ooxml:textOutline_textOutline" },
    { NS_ooxml::LN_textFill_textFill, "ooxml:textFill_textFill" },
    { NS_ooxml::LN_scene3d_scene3d, "ooxml:scene3d_scene3d" },
    { NS_ooxml::LN_props3d_props3d, "ooxml:props3d_props3d" },
    { NS_ooxml::LN_ligatures_ligatures, "ooxml:ligatures_ligatures" },
    { NS_ooxml::LN_numForm_numForm, "ooxml:numForm_numForm" },
    { NS_ooxml::LN_numSpacing_numSpacing, "ooxml:numSpacing_numSpacing" },
    { NS_ooxml::LN_stylisticSets_stylisticSets, "ooxml:stylisticSets_stylisticSets" },
    { NS_ooxml::LN_cntxtAlts_cntxtAlts, "ooxml:cntxtAlts_cntxtAlts" },
    { NS_ooxml::LN_CT_CommentsEx_commentEx, "ooxml:CT_CommentsEx_commentEx" },
    { NS_ooxml::LN_CT_CommentEx_paraId, "ooxml:CT_CommentEx_paraId" },
    { NS_ooxml::LN_CT_CommentEx_paraIdParent, "ooxml:CT_CommentEx_paraIdParent" },
    { NS_ooxml::LN_CT_CommentEx_done, "ooxml:CT_CommentEx_done" },
    { NS_ooxml::LN_Value_ST_ShapeType_line, "ooxml:Value_ST_ShapeType_line" },
    { NS_ooxml::LN_Value_ST_ShapeType_lineInv, "ooxml:Value_ST_ShapeType_lineInv" },
    { NS_ooxml::LN_Value_ST_ShapeType_triangle, "ooxml:Value_ST_ShapeType_triangle" },
    { NS_ooxml::LN_Value_ST_ShapeType_rtTriangle, "ooxml:Value_ST_ShapeType_rtTriangle" },
    { NS_ooxml::LN_Value_ST_ShapeType_rect, "ooxml:Value_ST_ShapeType_rect" },
    { NS_ooxml::LN_Value_ST_ShapeType_diamond, "ooxml:Value_ST_ShapeType_diamond" },
    { NS_ooxml::LN_Value_ST_ShapeType_parallelogram, "ooxml:Value_ST_ShapeType_parallelogram" },
    { NS_ooxml::LN_Value_ST_ShapeType_trapezoid, "ooxml:Value_ST_ShapeType_trapezoid" },
    { NS_ooxml::LN_Value_ST_ShapeType_nonIsoscelesTrapezoid, "ooxml:Value_ST_ShapeType_nonIsoscelesTrapezoid" },
    { NS_ooxml::LN_Value_ST_ShapeType_pentagon, "ooxml:Value_ST_ShapeType_pentagon" },
    { NS_ooxml::LN_Value_ST_ShapeType_hexagon, "ooxml:Value_ST_ShapeType_hexagon" },
    { NS_ooxml::LN_Value_ST_ShapeType_heptagon, "ooxml:Value_ST_ShapeType_heptagon" },
    { NS_ooxml::LN_Value_ST_ShapeType_octagon, "ooxml:Value_ST_ShapeType_octagon" },
    { NS_ooxml::LN_Value_ST_ShapeType_decagon, "ooxml:Value_ST_ShapeType_decagon" },
    { NS_ooxml::LN_Value_ST_ShapeType_dodecagon, "ooxml:Value_ST_ShapeType_dodecagon" },
    { NS_ooxml::LN_Value_ST_ShapeType_star4, "ooxml:Value_ST_ShapeType_star4" },
    { NS_ooxml::LN_Value_ST_ShapeType_star5, "ooxml:Value_ST_ShapeType_star5" },
    { NS_ooxml::LN_Value_ST_ShapeType_star6, "ooxml:Value_ST_ShapeType_star6" },
    { NS_ooxml::LN_Value_ST_ShapeType_star7, "ooxml:Value_ST_ShapeType_star7" },
    { NS_ooxml::LN_Value_ST_ShapeType_star8, "ooxml:Value_ST_ShapeType_star8" },
    { NS_ooxml::LN_Value_ST_ShapeType_star10, "ooxml:Value_ST_ShapeType_star10" },
    { NS_ooxml::LN_Value_ST_ShapeType_star12, "ooxml:Value_ST_ShapeType_star12" },
    { NS_ooxml::LN_Value_ST_ShapeType_star16, "ooxml:Value_ST_ShapeType_star16" },
    { NS_ooxml::LN_Value_ST_ShapeType_star24, "ooxml:Value_ST_ShapeType_star24" },
    { NS_ooxml::LN_Value_ST_ShapeType_star32, "ooxml:Value_ST_ShapeType_star32" },
    { NS_ooxml::LN_Value_ST_ShapeType_roundRect, "ooxml:Value_ST_ShapeType_roundRect" },
    { NS_ooxml::LN_Value_ST_ShapeType_round1Rect, "ooxml:Value_ST_ShapeType_round1Rect" },
    { NS_ooxml::LN_Value_ST_ShapeType_round2SameRect, "ooxml:Value_ST_ShapeType_round2SameRect" },
    { NS_ooxml::LN_Value_ST_ShapeType_round2DiagRect, "ooxml:Value_ST_ShapeType_round2DiagRect" },
    { NS_ooxml::LN_Value_ST_ShapeType_snipRoundRect, "ooxml:Value_ST_ShapeType_snipRoundRect" },
    { NS_ooxml::LN_Value_ST_ShapeType_snip1Rect, "ooxml:Value_ST_ShapeType_snip1Rect" },
    { NS_ooxml::LN_Value_ST_ShapeType_snip2SameRect, "ooxml:Value_ST_ShapeType_snip2SameRect" },
    { NS_ooxml::LN_Value_ST_ShapeType_snip2DiagRect, "ooxml:Value_ST_ShapeType_snip2DiagRect" },
    { NS_ooxml::LN_Value_ST_ShapeType_plaque, "ooxml:Value_ST_ShapeType_plaque" },
    { NS_ooxml::LN_Value_ST_ShapeType_ellipse, "ooxml:Value_ST_ShapeType_ellipse" },
    { NS_ooxml::LN_Value_ST_ShapeType_teardrop, "ooxml:Value_ST_ShapeType_teardrop" },
    { NS_ooxml::LN_Value_ST_ShapeType_homePlate, "ooxml:Value_ST_ShapeType_homePlate" },
    { NS_ooxml::LN_Value_ST_ShapeType_chevron, "ooxml:Value_ST_ShapeType_chevron" },
    { NS_ooxml::LN_Value_ST_ShapeType_pieWedge, "ooxml:Value_ST_ShapeType_pieWedge" },
    { NS_ooxml::LN_Value_ST_ShapeType_pie, "ooxml:Value_ST_ShapeType_pie" },
    { NS_ooxml::LN_Value_ST_ShapeType_blockArc, "ooxml:Value_ST_ShapeType_blockArc" },
    { NS_ooxml::LN_Value_ST_ShapeType_donut, "ooxml:Value_ST_ShapeType_donut" },
    { NS_ooxml::LN_Value_ST_ShapeType_noSmoking, "ooxml:Value_ST_ShapeType_noSmoking" },
    { NS_ooxml::LN_Value_ST_ShapeType_rightArrow, "ooxml:Value_ST_ShapeType_rightArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_leftArrow, "ooxml:Value_ST_ShapeType_leftArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_upArrow, "ooxml:Value_ST_ShapeType_upArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_downArrow, "ooxml:Value_ST_ShapeType_downArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_stripedRightArrow, "ooxml:Value_ST_ShapeType_stripedRightArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_notchedRightArrow, "ooxml:Value_ST_ShapeType_notchedRightArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_bentUpArrow, "ooxml:Value_ST_ShapeType_bentUpArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_leftRightArrow, "ooxml:Value_ST_ShapeType_leftRightArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_upDownArrow, "ooxml:Value_ST_ShapeType_upDownArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_leftUpArrow, "ooxml:Value_ST_ShapeType_leftUpArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_leftRightUpArrow, "ooxml:Value_ST_ShapeType_leftRightUpArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_quadArrow, "ooxml:Value_ST_ShapeType_quadArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_leftArrowCallout, "ooxml:Value_ST_ShapeType_leftArrowCallout" },
    { NS_ooxml::LN_Value_ST_ShapeType_rightArrowCallout, "ooxml:Value_ST_ShapeType_rightArrowCallout" },
    { NS_ooxml::LN_Value_ST_ShapeType_upArrowCallout, "ooxml:Value_ST_ShapeType_upArrowCallout" },
    { NS_ooxml::LN_Value_ST_ShapeType_downArrowCallout, "ooxml:Value_ST_ShapeType_downArrowCallout" },
    { NS_ooxml::LN_Value_ST_ShapeType_leftRightArrowCallout, "ooxml:Value_ST_ShapeType_leftRightArrowCallout" },
    { NS_ooxml::LN_Value_ST_ShapeType_upDownArrowCallout, "ooxml:Value_ST_ShapeType_upDownArrowCallout" },
    { NS_ooxml::LN_Value_ST_ShapeType_quadArrowCallout, "ooxml:Value_ST_ShapeType_quadArrowCallout" },
    { NS_ooxml::LN_Value_ST_ShapeType_bentArrow, "ooxml:Value_ST_ShapeType_bentArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_uturnArrow, "ooxml:Value_ST_ShapeType_uturnArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_circularArrow, "ooxml:Value_ST_ShapeType_circularArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_leftCircularArrow, "ooxml:Value_ST_ShapeType_leftCircularArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_leftRightCircularArrow, "ooxml:Value_ST_ShapeType_leftRightCircularArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_curvedRightArrow, "ooxml:Value_ST_ShapeType_curvedRightArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_curvedLeftArrow, "ooxml:Value_ST_ShapeType_curvedLeftArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_curvedUpArrow, "ooxml:Value_ST_ShapeType_curvedUpArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_curvedDownArrow, "ooxml:Value_ST_ShapeType_curvedDownArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_swooshArrow, "ooxml:Value_ST_ShapeType_swooshArrow" },
    { NS_ooxml::LN_Value_ST_ShapeType_cube, "ooxml:Value_ST_ShapeType_cube" },
    { NS_ooxml::LN_Value_ST_ShapeType_can, "ooxml:Value_ST_ShapeType_can" },
    { NS_ooxml::LN_Value_ST_ShapeType_lightningBolt, "ooxml:Value_ST_ShapeType_lightningBolt" },
    { NS_ooxml::LN_Value_ST_ShapeType_heart, "ooxml:Value_ST_ShapeType_heart" },
    { NS_ooxml::LN_Value_ST_ShapeType_sun, "ooxml:Value_ST_ShapeType_sun" },
    { NS_ooxml::LN_Value_ST_ShapeType_moon, "ooxml:Value_ST_ShapeType_moon" },
    { NS_ooxml::LN_Value_ST_ShapeType_smileyFace, "ooxml:Value_ST_ShapeType_smileyFace" },
    { NS_ooxml::LN_Value_ST_ShapeType_irregularSeal1, "ooxml:Value_ST_ShapeType_irregularSeal1" },
    { NS_ooxml::LN_Value_ST_ShapeType_irregularSeal2, "ooxml:Value_ST_ShapeType_irregularSeal2" },
    { NS_ooxml::LN_Value_ST_ShapeType_foldedCorner, "ooxml:Value_ST_ShapeType_foldedCorner" },
    { NS_ooxml::LN_Value_ST_ShapeType_bevel, "ooxml:Value_ST_ShapeType_bevel" },
    { NS_ooxml::LN_Value_ST_ShapeType_frame, "ooxml:Value_ST_ShapeType_frame" },
    { NS_ooxml::LN_Value_ST_ShapeType_halfFrame, "ooxml:Value_ST_ShapeType_halfFrame" },
    { NS_ooxml::LN_Value_ST_ShapeType_corner, "ooxml:Value_ST_ShapeType_corner" },
    { NS_ooxml::LN_Value_ST_ShapeType_diagStripe, "ooxml:Value_ST_ShapeType_diagStripe" },
    { NS_ooxml::LN_Value_ST_ShapeType_chord, "ooxml:Value_ST_ShapeType_chord" },
    { NS_ooxml::LN_Value_ST_ShapeType_arc, "ooxml:Value_ST_ShapeType_arc" },
    { NS_ooxml::LN_Value_ST_ShapeType_leftBracket, "ooxml:Value_ST_ShapeType_leftBracket" },
    { NS_ooxml::LN_Value_ST_ShapeType_rightBracket, "ooxml:Value_ST_ShapeType_rightBracket" },
    { NS_ooxml::LN_Value_ST_ShapeType_leftBrace, "ooxml:Value_ST_ShapeType_leftBrace" },
    { NS_ooxml::LN_Value_ST_ShapeType_rightBrace, "ooxml:Value_ST_ShapeType_rightBrace" },
    { NS_ooxml::LN_Value_ST_ShapeType_bracketPair, "ooxml:Value_ST_ShapeType_bracketPair" },
    { NS_ooxml::LN_Value_ST_ShapeType_bracePair, "ooxml:Value_ST_ShapeType_bracePair" },
    { NS_ooxml::LN_Value_ST_ShapeType_straightConnector1, "ooxml:Value_ST_ShapeType_straightConnector1" },
    { NS_ooxml::LN_Value_ST_ShapeType_bentConnector2, "ooxml:Value_ST_ShapeType_bentConnector2" },
    { NS_ooxml::LN_Value_ST_ShapeType_bentConnector3, "ooxml:Value_ST_ShapeType_bentConnector3" },
    { NS_ooxml::LN_Value_ST_ShapeType_bentConnector4, "ooxml:Value_ST_ShapeType_bentConnector4" },
    { NS_ooxml::LN_Value_ST_ShapeType_bentConnector5, "ooxml:Value_ST_ShapeType_bentConnector5" },
    { NS_ooxml::LN_Value_ST_ShapeType_curvedConnector2, "ooxml:Value_ST_ShapeType_curvedConnector2" },
    { NS_ooxml::LN_Value_ST_ShapeType_curvedConnector3, "ooxml:Value_ST_ShapeType_curvedConnector3" },
    { NS_ooxml::LN_Value_ST_ShapeType_curvedConnector4, "ooxml:Value_ST_ShapeType_curvedConnector4" },
    { NS_ooxml::LN_Value_ST_ShapeType_curvedConnector5, "ooxml:Value_ST_ShapeType_curvedConnector5" },
    { NS_ooxml::LN_Value_ST_ShapeType_callout1, "ooxml:Value_ST_ShapeType_callout1" },
    { NS_ooxml::LN_Value_ST_ShapeType_callout2, "ooxml:Value_ST_ShapeType_callout2" },
    { NS_ooxml::LN_Value_ST_ShapeType_callout3, "ooxml:Value_ST_ShapeType_callout3" },
    { NS_ooxml::LN_Value_ST_ShapeType_accentCallout1, "ooxml:Value_ST_ShapeType_accentCallout1" },
    { NS_ooxml::LN_Value_ST_ShapeType_accentCallout2, "ooxml:Value_ST_ShapeType_accentCallout2" },
    { NS_ooxml::LN_Value_ST_ShapeType_accentCallout3, "ooxml:Value_ST_ShapeType_accentCallout3" },
    { NS_ooxml::LN_Value_ST_ShapeType_borderCallout1, "ooxml:Value_ST_ShapeType_borderCallout1" },
    { NS_ooxml::LN_Value_ST_ShapeType_borderCallout2, "ooxml:Value_ST_ShapeType_borderCallout2" },
    { NS_ooxml::LN_Value_ST_ShapeType_borderCallout3, "ooxml:Value_ST_ShapeType_borderCallout3" },
    { NS_ooxml::LN_Value_ST_ShapeType_accentBorderCallout1, "ooxml:Value_ST_ShapeType_accentBorderCallout1" },
    { NS_ooxml::LN_Value_ST_ShapeType_accentBorderCallout2, "ooxml:Value_ST_ShapeType_accentBorderCallout2" },
    { NS_ooxml::LN_Value_ST_ShapeType_accentBorderCallout3, "ooxml:Value_ST_ShapeType_accentBorderCallout3" },
    { NS_ooxml::LN_Value_ST_ShapeType_wedgeRectCallout, "ooxml:Value_ST_ShapeType_wedgeRectCallout" },
    { NS_ooxml::LN_Value_ST_ShapeType_wedgeRoundRectCallout, "ooxml:Value_ST_ShapeType_wedgeRoundRectCallout" },
    { NS_ooxml::LN_Value_ST_ShapeType_wedgeEllipseCallout, "ooxml:Value_ST_ShapeType_wedgeEllipseCallout" },
    { NS_ooxml::LN_Value_ST_ShapeType_cloudCallout, "ooxml:Value_ST_ShapeType_cloudCallout" },
    { NS_ooxml::LN_Value_ST_ShapeType_cloud, "ooxml:Value_ST_ShapeType_cloud" },
    { NS_ooxml::LN_Value_ST_ShapeType_ribbon, "ooxml:Value_ST_ShapeType_ribbon" },
    { NS_ooxml::LN_Value_ST_ShapeType_ribbon2, "ooxml:Value_ST_ShapeType_ribbon2" },
    { NS_ooxml::LN_Value_ST_ShapeType_ellipseRibbon, "ooxml:Value_ST_ShapeType_ellipseRibbon" },
    { NS_ooxml::LN_Value_ST_ShapeType_ellipseRibbon2, "ooxml:Value_ST_ShapeType_ellipseRibbon2" },
    { NS_ooxml::LN_Value_ST_ShapeType_leftRightRibbon, "ooxml:Value_ST_ShapeType_leftRightRibbon" },
    { NS_ooxml::LN_Value_ST_ShapeType_verticalScroll, "ooxml:Value_ST_ShapeType_verticalScroll" },
    { NS_ooxml::LN_Value_ST_ShapeType_horizontalScroll, "ooxml:Value_ST_ShapeType_horizontalScroll" },
    { NS_ooxml::LN_Value_ST_ShapeType_wave, "ooxml:Value_ST_ShapeType_wave" },
    { NS_ooxml::LN_Value_ST_ShapeType_doubleWave, "ooxml:Value_ST_ShapeType_doubleWave" },
    { NS_ooxml::LN_Value_ST_ShapeType_plus, "ooxml:Value_ST_ShapeType_plus" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartProcess, "ooxml:Value_ST_ShapeType_flowChartProcess" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartDecision, "ooxml:Value_ST_ShapeType_flowChartDecision" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartInputOutput, "ooxml:Value_ST_ShapeType_flowChartInputOutput" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartPredefinedProcess, "ooxml:Value_ST_ShapeType_flowChartPredefinedProcess" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartInternalStorage, "ooxml:Value_ST_ShapeType_flowChartInternalStorage" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartDocument, "ooxml:Value_ST_ShapeType_flowChartDocument" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartMultidocument, "ooxml:Value_ST_ShapeType_flowChartMultidocument" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartTerminator, "ooxml:Value_ST_ShapeType_flowChartTerminator" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartPreparation, "ooxml:Value_ST_ShapeType_flowChartPreparation" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartManualInput, "ooxml:Value_ST_ShapeType_flowChartManualInput" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartManualOperation, "ooxml:Value_ST_ShapeType_flowChartManualOperation" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartConnector, "ooxml:Value_ST_ShapeType_flowChartConnector" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartPunchedCard, "ooxml:Value_ST_ShapeType_flowChartPunchedCard" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartPunchedTape, "ooxml:Value_ST_ShapeType_flowChartPunchedTape" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartSummingJunction, "ooxml:Value_ST_ShapeType_flowChartSummingJunction" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartOr, "ooxml:Value_ST_ShapeType_flowChartOr" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartCollate, "ooxml:Value_ST_ShapeType_flowChartCollate" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartSort, "ooxml:Value_ST_ShapeType_flowChartSort" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartExtract, "ooxml:Value_ST_ShapeType_flowChartExtract" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartMerge, "ooxml:Value_ST_ShapeType_flowChartMerge" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartOfflineStorage, "ooxml:Value_ST_ShapeType_flowChartOfflineStorage" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartOnlineStorage, "ooxml:Value_ST_ShapeType_flowChartOnlineStorage" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartMagneticTape, "ooxml:Value_ST_ShapeType_flowChartMagneticTape" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartMagneticDisk, "ooxml:Value_ST_ShapeType_flowChartMagneticDisk" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartMagneticDrum, "ooxml:Value_ST_ShapeType_flowChartMagneticDrum" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartDisplay, "ooxml:Value_ST_ShapeType_flowChartDisplay" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartDelay, "ooxml:Value_ST_ShapeType_flowChartDelay" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartAlternateProcess, "ooxml:Value_ST_ShapeType_flowChartAlternateProcess" },
    { NS_ooxml::LN_Value_ST_ShapeType_flowChartOffpageConnector, "ooxml:Value_ST_ShapeType_flowChartOffpageConnector" },
    { NS_ooxml::LN_Value_ST_ShapeType_actionButtonBlank, "ooxml:Value_ST_ShapeType_actionButtonBlank" },
    { NS_ooxml::LN_Value_ST_ShapeType_actionButtonHome, "ooxml:Value_ST_ShapeType_actionButtonHome" },
    { NS_ooxml::LN_Value_ST_ShapeType_actionButtonHelp, "ooxml:Value_ST_ShapeType_actionButtonHelp" },
    { NS_ooxml::LN_Value_ST_ShapeType_actionButtonInformation, "ooxml:Value_ST_ShapeType_actionButtonInformation" },
    { NS_ooxml::LN_Value_ST_ShapeType_actionButtonForwardNext, "ooxml:Value_ST_ShapeType_actionButtonForwardNext" },
    { NS_ooxml::LN_Value_ST_ShapeType_actionButtonBackPrevious, "ooxml:Value_ST_ShapeType_actionButtonBackPrevious" },
    { NS_ooxml::LN_Value_ST_ShapeType_actionButtonEnd, "ooxml:Value_ST_ShapeType_actionButtonEnd" },
    { NS_ooxml::LN_Value_ST_ShapeType_actionButtonBeginning, "ooxml:Value_ST_ShapeType_actionButtonBeginning" },
    { NS_ooxml::LN_Value_ST_ShapeType_actionButtonReturn, "ooxml:Value_ST_ShapeType_actionButtonReturn" },
    { NS_ooxml::LN_Value_ST_ShapeType_actionButtonDocument, "ooxml:Value_ST_ShapeType_actionButtonDocument" },
    { NS_ooxml::LN_Value_ST_ShapeType_actionButtonSound, "ooxml:Value_ST_ShapeType_actionButtonSound" },
    { NS_ooxml::LN_Value_ST_ShapeType_actionButtonMovie, "ooxml:Value_ST_ShapeType_actionButtonMovie" },
    { NS_ooxml::LN_Value_ST_ShapeType_gear6, "ooxml:Value_ST_ShapeType_gear6" },
    { NS_ooxml::LN_Value_ST_ShapeType_gear9, "ooxml:Value_ST_ShapeType_gear9" },
    { NS_ooxml::LN_Value_ST_ShapeType_funnel, "ooxml:Value_ST_ShapeType_funnel" },
    { NS_ooxml::LN_Value_ST_ShapeType_mathPlus, "ooxml:Value_ST_ShapeType_mathPlus" },
    { NS_ooxml::LN_Value_ST_ShapeType_mathMinus, "ooxml:Value_ST_ShapeType_mathMinus" },
    { NS_ooxml::LN_Value_ST_ShapeType_mathMultiply, "ooxml:Value_ST_ShapeType_mathMultiply" },
    { NS_ooxml::LN_Value_ST_ShapeType_mathDivide, "ooxml:Value_ST_ShapeType_mathDivide" },
    { NS_ooxml::LN_Value_ST_ShapeType_mathEqual, "ooxml:Value_ST_ShapeType_mathEqual" },
    { NS_ooxml::LN_Value_ST_ShapeType_mathNotEqual, "ooxml:Value_ST_ShapeType_mathNotEqual" },
    { NS_ooxml::LN_Value_ST_ShapeType_cornerTabs, "ooxml:Value_ST_ShapeType_cornerTabs" },
    { NS_ooxml::LN_Value_ST_ShapeType_squareTabs, "ooxml:Value_ST_ShapeType_squareTabs" },
    { NS_ooxml::LN_Value_ST_ShapeType_plaqueTabs, "ooxml:Value_ST_ShapeType_plaqueTabs" },
    { NS_ooxml::LN_Value_ST_ShapeType_chartX, "ooxml:Value_ST_ShapeType_chartX" },
    { NS_ooxml::LN_Value_ST_ShapeType_chartStar, "ooxml:Value_ST_ShapeType_chartStar" },
    { NS_ooxml::LN_Value_ST_ShapeType_chartPlus, "ooxml:Value_ST_ShapeType_chartPlus" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textNoShape, "ooxml:Value_drawingml_ST_TextShapeType_textNoShape" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textPlain, "ooxml:Value_drawingml_ST_TextShapeType_textPlain" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textStop, "ooxml:Value_drawingml_ST_TextShapeType_textStop" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textTriangle, "ooxml:Value_drawingml_ST_TextShapeType_textTriangle" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textTriangleInverted, "ooxml:Value_drawingml_ST_TextShapeType_textTriangleInverted" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textChevron, "ooxml:Value_drawingml_ST_TextShapeType_textChevron" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textChevronInverted, "ooxml:Value_drawingml_ST_TextShapeType_textChevronInverted" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textRingInside, "ooxml:Value_drawingml_ST_TextShapeType_textRingInside" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textRingOutside, "ooxml:Value_drawingml_ST_TextShapeType_textRingOutside" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textArchUp, "ooxml:Value_drawingml_ST_TextShapeType_textArchUp" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textArchDown, "ooxml:Value_drawingml_ST_TextShapeType_textArchDown" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCircle, "ooxml:Value_drawingml_ST_TextShapeType_textCircle" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textButton, "ooxml:Value_drawingml_ST_TextShapeType_textButton" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textArchUpPour, "ooxml:Value_drawingml_ST_TextShapeType_textArchUpPour" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textArchDownPour, "ooxml:Value_drawingml_ST_TextShapeType_textArchDownPour" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCirclePour, "ooxml:Value_drawingml_ST_TextShapeType_textCirclePour" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textButtonPour, "ooxml:Value_drawingml_ST_TextShapeType_textButtonPour" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCurveUp, "ooxml:Value_drawingml_ST_TextShapeType_textCurveUp" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCurveDown, "ooxml:Value_drawingml_ST_TextShapeType_textCurveDown" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCanUp, "ooxml:Value_drawingml_ST_TextShapeType_textCanUp" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCanDown, "ooxml:Value_drawingml_ST_TextShapeType_textCanDown" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textWave1, "ooxml:Value_drawingml_ST_TextShapeType_textWave1" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textWave2, "ooxml:Value_drawingml_ST_TextShapeType_textWave2" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textDoubleWave1, "ooxml:Value_drawingml_ST_TextShapeType_textDoubleWave1" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textWave4, "ooxml:Value_drawingml_ST_TextShapeType_textWave4" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textInflate, "ooxml:Value_drawingml_ST_TextShapeType_textInflate" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textDeflate, "ooxml:Value_drawingml_ST_TextShapeType_textDeflate" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textInflateBottom, "ooxml:Value_drawingml_ST_TextShapeType_textInflateBottom" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textDeflateBottom, "ooxml:Value_drawingml_ST_TextShapeType_textDeflateBottom" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textInflateTop, "ooxml:Value_drawingml_ST_TextShapeType_textInflateTop" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textDeflateTop, "ooxml:Value_drawingml_ST_TextShapeType_textDeflateTop" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textDeflateInflate, "ooxml:Value_drawingml_ST_TextShapeType_textDeflateInflate" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textDeflateInflateDeflate, "ooxml:Value_drawingml_ST_TextShapeType_textDeflateInflateDeflate" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textFadeRight, "ooxml:Value_drawingml_ST_TextShapeType_textFadeRight" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textFadeLeft, "ooxml:Value_drawingml_ST_TextShapeType_textFadeLeft" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textFadeUp, "ooxml:Value_drawingml_ST_TextShapeType_textFadeUp" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textFadeDown, "ooxml:Value_drawingml_ST_TextShapeType_textFadeDown" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textSlantUp, "ooxml:Value_drawingml_ST_TextShapeType_textSlantUp" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textSlantDown, "ooxml:Value_drawingml_ST_TextShapeType_textSlantDown" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCascadeUp, "ooxml:Value_drawingml_ST_TextShapeType_textCascadeUp" },
    { NS_ooxml::LN_Value_drawingml_ST_TextShapeType_textCascadeDown, "ooxml:Value_drawingml_ST_TextShapeType_textCascadeDown" },
    { NS_ooxml::LN_CT_GeomGuideList_gd, "ooxml:CT_GeomGuideList_gd" },
    { NS_ooxml::LN_Value_drawingml_ST_PathFillMode_none, "ooxml:Value_drawingml_ST_PathFillMode_none" },
    { NS_ooxml::LN_Value_drawingml_ST_PathFillMode_norm, "ooxml:Value_drawingml_ST_PathFillMode_norm" },
    { NS_ooxml::LN_Value_drawingml_ST_PathFillMode_lighten, "ooxml:Value_drawingml_ST_PathFillMode_lighten" },
    { NS_ooxml::LN_Value_drawingml_ST_PathFillMode_lightenLess, "ooxml:Value_drawingml_ST_PathFillMode_lightenLess" },
    { NS_ooxml::LN_Value_drawingml_ST_PathFillMode_darken, "ooxml:Value_drawingml_ST_PathFillMode_darken" },
    { NS_ooxml::LN_Value_drawingml_ST_PathFillMode_darkenLess, "ooxml:Value_drawingml_ST_PathFillMode_darkenLess" },
    { NS_ooxml::LN_CT_PresetGeometry2D_avLst, "ooxml:CT_PresetGeometry2D_avLst" },
    { NS_ooxml::LN_CT_PresetGeometry2D_prst, "ooxml:CT_PresetGeometry2D_prst" },
    { NS_ooxml::LN_CT_CustomGeometry2D_avLst, "ooxml:CT_CustomGeometry2D_avLst" },
    { NS_ooxml::LN_CT_CustomGeometry2D_gdLst, "ooxml:CT_CustomGeometry2D_gdLst" },
    { NS_ooxml::LN_CT_CustomGeometry2D_ahLst, "ooxml:CT_CustomGeometry2D_ahLst" },
    { NS_ooxml::LN_CT_CustomGeometry2D_cxnLst, "ooxml:CT_CustomGeometry2D_cxnLst" },
    { NS_ooxml::LN_CT_CustomGeometry2D_rect, "ooxml:CT_CustomGeometry2D_rect" },
    { NS_ooxml::LN_CT_CustomGeometry2D_pathLst, "ooxml:CT_CustomGeometry2D_pathLst" },
    { NS_ooxml::LN_EG_Geometry_custGeom, "ooxml:EG_Geometry_custGeom" },
    { NS_ooxml::LN_EG_Geometry_prstGeom, "ooxml:EG_Geometry_prstGeom" },
    { NS_ooxml::LN_CT_EffectExtent_l, "ooxml:CT_EffectExtent_l" },
    { NS_ooxml::LN_CT_EffectExtent_t, "ooxml:CT_EffectExtent_t" },
    { NS_ooxml::LN_CT_EffectExtent_r, "ooxml:CT_EffectExtent_r" },
    { NS_ooxml::LN_CT_EffectExtent_b, "ooxml:CT_EffectExtent_b" },
    { NS_ooxml::LN_CT_Inline_extent, "ooxml:CT_Inline_extent" },
    { NS_ooxml::LN_CT_Inline_effectExtent, "ooxml:CT_Inline_effectExtent" },
    { NS_ooxml::LN_CT_Inline_docPr, "ooxml:CT_Inline_docPr" },
    { NS_ooxml::LN_CT_Inline_cNvGraphicFramePr, "ooxml:CT_Inline_cNvGraphicFramePr" },
    { NS_ooxml::LN_CT_Inline_a_graphic, "ooxml:CT_Inline_a_graphic" },
    { NS_ooxml::LN_CT_Inline_wp14_sizeRelH, "ooxml:CT_Inline_wp14_sizeRelH" },
    { NS_ooxml::LN_CT_Inline_wp14_sizeRelV, "ooxml:CT_Inline_wp14_sizeRelV" },
    { NS_ooxml::LN_CT_Inline_distT, "ooxml:CT_Inline_distT" },
    { NS_ooxml::LN_CT_Inline_distB, "ooxml:CT_Inline_distB" },
    { NS_ooxml::LN_CT_Inline_distL, "ooxml:CT_Inline_distL" },
    { NS_ooxml::LN_CT_Inline_distR, "ooxml:CT_Inline_distR" },
    { NS_ooxml::LN_CT_Inline_wp14_anchorId, "ooxml:CT_Inline_wp14_anchorId" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_WrapText_bothSides, "ooxml:Value_wordprocessingDrawing_ST_WrapText_bothSides" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_WrapText_left, "ooxml:Value_wordprocessingDrawing_ST_WrapText_left" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_WrapText_right, "ooxml:Value_wordprocessingDrawing_ST_WrapText_right" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_WrapText_largest, "ooxml:Value_wordprocessingDrawing_ST_WrapText_largest" },
    { NS_ooxml::LN_CT_WrapPath_start, "ooxml:CT_WrapPath_start" },
    { NS_ooxml::LN_CT_WrapPath_lineTo, "ooxml:CT_WrapPath_lineTo" },
    { NS_ooxml::LN_CT_WrapPath_edited, "ooxml:CT_WrapPath_edited" },
    { NS_ooxml::LN_CT_WrapSquare_effectExtent, "ooxml:CT_WrapSquare_effectExtent" },
    { NS_ooxml::LN_CT_WrapSquare_wrapText, "ooxml:CT_WrapSquare_wrapText" },
    { NS_ooxml::LN_CT_WrapSquare_distT, "ooxml:CT_WrapSquare_distT" },
    { NS_ooxml::LN_CT_WrapSquare_distB, "ooxml:CT_WrapSquare_distB" },
    { NS_ooxml::LN_CT_WrapSquare_distL, "ooxml:CT_WrapSquare_distL" },
    { NS_ooxml::LN_CT_WrapSquare_distR, "ooxml:CT_WrapSquare_distR" },
    { NS_ooxml::LN_CT_WrapTight_wrapPolygon, "ooxml:CT_WrapTight_wrapPolygon" },
    { NS_ooxml::LN_CT_WrapTight_wrapText, "ooxml:CT_WrapTight_wrapText" },
    { NS_ooxml::LN_CT_WrapTight_distL, "ooxml:CT_WrapTight_distL" },
    { NS_ooxml::LN_CT_WrapTight_distR, "ooxml:CT_WrapTight_distR" },
    { NS_ooxml::LN_CT_WrapThrough_wrapPolygon, "ooxml:CT_WrapThrough_wrapPolygon" },
    { NS_ooxml::LN_CT_WrapThrough_wrapText, "ooxml:CT_WrapThrough_wrapText" },
    { NS_ooxml::LN_CT_WrapThrough_distL, "ooxml:CT_WrapThrough_distL" },
    { NS_ooxml::LN_CT_WrapThrough_distR, "ooxml:CT_WrapThrough_distR" },
    { NS_ooxml::LN_CT_WrapTopBottom_effectExtent, "ooxml:CT_WrapTopBottom_effectExtent" },
    { NS_ooxml::LN_CT_WrapTopBottom_distT, "ooxml:CT_WrapTopBottom_distT" },
    { NS_ooxml::LN_CT_WrapTopBottom_distB, "ooxml:CT_WrapTopBottom_distB" },
    { NS_ooxml::LN_EG_WrapType_wrapNone, "ooxml:EG_WrapType_wrapNone" },
    { NS_ooxml::LN_EG_WrapType_wrapSquare, "ooxml:EG_WrapType_wrapSquare" },
    { NS_ooxml::LN_EG_WrapType_wrapTight, "ooxml:EG_WrapType_wrapTight" },
    { NS_ooxml::LN_EG_WrapType_wrapThrough, "ooxml:EG_WrapType_wrapThrough" },
    { NS_ooxml::LN_EG_WrapType_wrapTopAndBottom, "ooxml:EG_WrapType_wrapTopAndBottom" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromH_margin, "ooxml:Value_wordprocessingDrawing_ST_RelFromH_margin" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromH_page, "ooxml:Value_wordprocessingDrawing_ST_RelFromH_page" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromH_column, "ooxml:Value_wordprocessingDrawing_ST_RelFromH_column" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromH_character, "ooxml:Value_wordprocessingDrawing_ST_RelFromH_character" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromH_leftMargin, "ooxml:Value_wordprocessingDrawing_ST_RelFromH_leftMargin" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromH_rightMargin, "ooxml:Value_wordprocessingDrawing_ST_RelFromH_rightMargin" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromH_insideMargin, "ooxml:Value_wordprocessingDrawing_ST_RelFromH_insideMargin" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromH_outsideMargin, "ooxml:Value_wordprocessingDrawing_ST_RelFromH_outsideMargin" },
    { NS_ooxml::LN_CT_PosH_align, "ooxml:CT_PosH_align" },
    { NS_ooxml::LN_CT_PosH_posOffset, "ooxml:CT_PosH_posOffset" },
    { NS_ooxml::LN_CT_PosH_relativeFrom, "ooxml:CT_PosH_relativeFrom" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromV_margin, "ooxml:Value_wordprocessingDrawing_ST_RelFromV_margin" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromV_page, "ooxml:Value_wordprocessingDrawing_ST_RelFromV_page" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromV_paragraph, "ooxml:Value_wordprocessingDrawing_ST_RelFromV_paragraph" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromV_line, "ooxml:Value_wordprocessingDrawing_ST_RelFromV_line" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromV_topMargin, "ooxml:Value_wordprocessingDrawing_ST_RelFromV_topMargin" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromV_bottomMargin, "ooxml:Value_wordprocessingDrawing_ST_RelFromV_bottomMargin" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromV_insideMargin, "ooxml:Value_wordprocessingDrawing_ST_RelFromV_insideMargin" },
    { NS_ooxml::LN_Value_wordprocessingDrawing_ST_RelFromV_outsideMargin, "ooxml:Value_wordprocessingDrawing_ST_RelFromV_outsideMargin" },
    { NS_ooxml::LN_CT_PosV_align, "ooxml:CT_PosV_align" },
    { NS_ooxml::LN_CT_PosV_posOffset, "ooxml:CT_PosV_posOffset" },
    { NS_ooxml::LN_CT_PosV_relativeFrom, "ooxml:CT_PosV_relativeFrom" },
    { NS_ooxml::LN_CT_Anchor_simplePos_elem, "ooxml:CT_Anchor_simplePos_elem" },
    { NS_ooxml::LN_CT_Anchor_positionH, "ooxml:CT_Anchor_positionH" },
    { NS_ooxml::LN_CT_Anchor_positionV, "ooxml:CT_Anchor_positionV" },
    { NS_ooxml::LN_CT_Anchor_extent, "ooxml:CT_Anchor_extent" },
    { NS_ooxml::LN_CT_Anchor_effectExtent, "ooxml:CT_Anchor_effectExtent" },
    { NS_ooxml::LN_CT_Anchor_docPr, "ooxml:CT_Anchor_docPr" },
    { NS_ooxml::LN_CT_Anchor_cNvGraphicFramePr, "ooxml:CT_Anchor_cNvGraphicFramePr" },
    { NS_ooxml::LN_CT_Anchor_a_graphic, "ooxml:CT_Anchor_a_graphic" },
    { NS_ooxml::LN_CT_Anchor_wp14_sizeRelV, "ooxml:CT_Anchor_wp14_sizeRelV" },
    { NS_ooxml::LN_CT_Anchor_distT, "ooxml:CT_Anchor_distT" },
    { NS_ooxml::LN_CT_Anchor_distB, "ooxml:CT_Anchor_distB" },
    { NS_ooxml::LN_CT_Anchor_distL, "ooxml:CT_Anchor_distL" },
    { NS_ooxml::LN_CT_Anchor_distR, "ooxml:CT_Anchor_distR" },
    { NS_ooxml::LN_CT_Anchor_simplePos_attr, "ooxml:CT_Anchor_simplePos_attr" },
    { NS_ooxml::LN_CT_Anchor_relativeHeight, "ooxml:CT_Anchor_relativeHeight" },
    { NS_ooxml::LN_CT_Anchor_behindDoc, "ooxml:CT_Anchor_behindDoc" },
    { NS_ooxml::LN_CT_Anchor_locked, "ooxml:CT_Anchor_locked" },
    { NS_ooxml::LN_CT_Anchor_layoutInCell, "ooxml:CT_Anchor_layoutInCell" },
    { NS_ooxml::LN_CT_Anchor_hidden, "ooxml:CT_Anchor_hidden" },
    { NS_ooxml::LN_CT_Anchor_allowOverlap, "ooxml:CT_Anchor_allowOverlap" },
    { NS_ooxml::LN_CT_Anchor_wp14_anchorId, "ooxml:CT_Anchor_wp14_anchorId" },
    { NS_ooxml::LN_inline_inline, "ooxml:inline_inline" },
    { NS_ooxml::LN_anchor_anchor, "ooxml:anchor_anchor" },
    { NS_ooxml::LN_CT_Integer255_val, "ooxml:CT_Integer255_val" },
    { NS_ooxml::LN_CT_Integer2_val, "ooxml:CT_Integer2_val" },
    { NS_ooxml::LN_CT_SpacingRule_val, "ooxml:CT_SpacingRule_val" },
    { NS_ooxml::LN_CT_UnSignedInteger_val, "ooxml:CT_UnSignedInteger_val" },
    { NS_ooxml::LN_CT_Char_val, "ooxml:CT_Char_val" },
    { NS_ooxml::LN_Value_math_ST_OnOff_on, "ooxml:Value_math_ST_OnOff_on" },
    { NS_ooxml::LN_Value_math_ST_OnOff_off, "ooxml:Value_math_ST_OnOff_off" },
    { NS_ooxml::LN_Value_math_ST_XAlign_left, "ooxml:Value_math_ST_XAlign_left" },
    { NS_ooxml::LN_Value_math_ST_XAlign_center, "ooxml:Value_math_ST_XAlign_center" },
    { NS_ooxml::LN_Value_math_ST_XAlign_right, "ooxml:Value_math_ST_XAlign_right" },
    { NS_ooxml::LN_CT_XAlign_val, "ooxml:CT_XAlign_val" },
    { NS_ooxml::LN_Value_math_ST_YAlign_top, "ooxml:Value_math_ST_YAlign_top" },
    { NS_ooxml::LN_Value_math_ST_YAlign_center, "ooxml:Value_math_ST_YAlign_center" },
    { NS_ooxml::LN_Value_math_ST_YAlign_bot, "ooxml:Value_math_ST_YAlign_bot" },
    { NS_ooxml::LN_CT_YAlign_val, "ooxml:CT_YAlign_val" },
    { NS_ooxml::LN_Value_math_ST_Shp_centered, "ooxml:Value_math_ST_Shp_centered" },
    { NS_ooxml::LN_Value_math_ST_Shp_match, "ooxml:Value_math_ST_Shp_match" },
    { NS_ooxml::LN_CT_Shp_val, "ooxml:CT_Shp_val" },
    { NS_ooxml::LN_Value_math_ST_FType_bar, "ooxml:Value_math_ST_FType_bar" },
    { NS_ooxml::LN_Value_math_ST_FType_skw, "ooxml:Value_math_ST_FType_skw" },
    { NS_ooxml::LN_Value_math_ST_FType_lin, "ooxml:Value_math_ST_FType_lin" },
    { NS_ooxml::LN_Value_math_ST_FType_noBar, "ooxml:Value_math_ST_FType_noBar" },
    { NS_ooxml::LN_CT_FType_val, "ooxml:CT_FType_val" },
    { NS_ooxml::LN_Value_math_ST_LimLoc_undOvr, "ooxml:Value_math_ST_LimLoc_undOvr" },
    { NS_ooxml::LN_Value_math_ST_LimLoc_subSup, "ooxml:Value_math_ST_LimLoc_subSup" },
    { NS_ooxml::LN_CT_LimLoc_val, "ooxml:CT_LimLoc_val" },
    { NS_ooxml::LN_Value_math_ST_TopBot_top, "ooxml:Value_math_ST_TopBot_top" },
    { NS_ooxml::LN_Value_math_ST_TopBot_bot, "ooxml:Value_math_ST_TopBot_bot" },
    { NS_ooxml::LN_CT_TopBot_val, "ooxml:CT_TopBot_val" },
    { NS_ooxml::LN_Value_math_ST_Script_roman, "ooxml:Value_math_ST_Script_roman" },
    { NS_ooxml::LN_Value_math_ST_Script_script, "ooxml:Value_math_ST_Script_script" },
    { NS_ooxml::LN_Value_math_ST_Script_fraktur, "ooxml:Value_math_ST_Script_fraktur" },
    { NS_ooxml::LN_Value_math_ST_Script_doublemstruck, "ooxml:Value_math_ST_Script_doublemstruck" },
    { NS_ooxml::LN_Value_math_ST_Script_sansmserif, "ooxml:Value_math_ST_Script_sansmserif" },
    { NS_ooxml::LN_Value_math_ST_Script_monospace, "ooxml:Value_math_ST_Script_monospace" },
    { NS_ooxml::LN_CT_Script_val, "ooxml:CT_Script_val" },
    { NS_ooxml::LN_Value_ST_Style_b, "ooxml:Value_ST_Style_b" },
    { NS_ooxml::LN_Value_ST_Style_bi, "ooxml:Value_ST_Style_bi" },
    { NS_ooxml::LN_Value_ST_Style_i, "ooxml:Value_ST_Style_i" },
    { NS_ooxml::LN_Value_ST_Style_p, "ooxml:Value_ST_Style_p" },
    { NS_ooxml::LN_CT_Style_val, "ooxml:CT_Style_val" },
    { NS_ooxml::LN_Value_math_ST_Jc_start, "ooxml:Value_math_ST_Jc_start" },
    { NS_ooxml::LN_Value_math_ST_Jc_end, "ooxml:Value_math_ST_Jc_end" },
    { NS_ooxml::LN_Value_math_ST_Jc_left, "ooxml:Value_math_ST_Jc_left" },
    { NS_ooxml::LN_Value_math_ST_Jc_right, "ooxml:Value_math_ST_Jc_right" },
    { NS_ooxml::LN_Value_math_ST_Jc_center, "ooxml:Value_math_ST_Jc_center" },
    { NS_ooxml::LN_Value_math_ST_Jc_centerGroup, "ooxml:Value_math_ST_Jc_centerGroup" },
    { NS_ooxml::LN_CT_OMathJc_val, "ooxml:CT_OMathJc_val" },
    { NS_ooxml::LN_CT_TwipsMeasure_val, "ooxml:CT_TwipsMeasure_val" },
    { NS_ooxml::LN_Value_math_ST_BreakBin_before, "ooxml:Value_math_ST_BreakBin_before" },
    { NS_ooxml::LN_Value_math_ST_BreakBin_after, "ooxml:Value_math_ST_BreakBin_after" },
    { NS_ooxml::LN_Value_math_ST_BreakBin_repeat, "ooxml:Value_math_ST_BreakBin_repeat" },
    { NS_ooxml::LN_CT_BreakBin_val, "ooxml:CT_BreakBin_val" },
    { NS_ooxml::LN_Value_math_ST_BreakBinSub_mm, "ooxml:Value_math_ST_BreakBinSub_mm" },
    { NS_ooxml::LN_Value_math_ST_BreakBinSub_mp, "ooxml:Value_math_ST_BreakBinSub_mp" },
    { NS_ooxml::LN_Value_math_ST_BreakBinSub_pm, "ooxml:Value_math_ST_BreakBinSub_pm" },
    { NS_ooxml::LN_CT_BreakBinSub_val, "ooxml:CT_BreakBinSub_val" },
    { NS_ooxml::LN_CT_PictureNonVisual_cNvPr, "ooxml:CT_PictureNonVisual_cNvPr" },
    { NS_ooxml::LN_CT_PictureNonVisual_cNvPicPr, "ooxml:CT_PictureNonVisual_cNvPicPr" },
    { NS_ooxml::LN_CT_Picture_nvPicPr, "ooxml:CT_Picture_nvPicPr" },
    { NS_ooxml::LN_CT_Picture_blipFill, "ooxml:CT_Picture_blipFill" },
    { NS_ooxml::LN_CT_Picture_spPr, "ooxml:CT_Picture_spPr" },
    { NS_ooxml::LN_pic_pic, "ooxml:pic_pic" },
    { NS_ooxml::LN_CT_RelIds_dm, "ooxml:CT_RelIds_dm" },
    { NS_ooxml::LN_CT_RelIds_lo, "ooxml:CT_RelIds_lo" },
    { NS_ooxml::LN_CT_RelIds_qs, "ooxml:CT_RelIds_qs" },
    { NS_ooxml::LN_CT_RelIds_cs, "ooxml:CT_RelIds_cs" },
    { NS_ooxml::LN_dgm_relIds, "ooxml:dgm_relIds" },
    { NS_ooxml::LN_CT_GvmlGroupShape_nvGrpSpPr, "ooxml:CT_GvmlGroupShape_nvGrpSpPr" },
    { NS_ooxml::LN_CT_GvmlGroupShape_grpSpPr, "ooxml:CT_GvmlGroupShape_grpSpPr" },
    { NS_ooxml::LN_lc_lockedCanvas, "ooxml:lc_lockedCanvas" },
    { NS_ooxml::LN_CT_RelId_chart, "ooxml:CT_RelId_chart" },
    { NS_ooxml::LN_c_chart, "ooxml:c_chart" },
    { NS_ooxml::LN_CT_WordprocessingShape_cNvSpPr, "ooxml:CT_WordprocessingShape_cNvSpPr" },
    { NS_ooxml::LN_CT_WordprocessingShape_spPr, "ooxml:CT_WordprocessingShape_spPr" },
    { NS_ooxml::LN_wps_wsp, "ooxml:wps_wsp" },
    { NS_ooxml::LN_CT_WordprocessingGroup_cNvGrpSpPr, "ooxml:CT_WordprocessingGroup_cNvGrpSpPr" },
    { NS_ooxml::LN_CT_WordprocessingGroup_grpSpPr, "ooxml:CT_WordprocessingGroup_grpSpPr" },
    { NS_ooxml::LN_wpg_wgp, "ooxml:wpg_wgp" },
    { NS_ooxml::LN_CT_WholeE2oFormatting_ln, "ooxml:CT_WholeE2oFormatting_ln" },
    { NS_ooxml::LN_CT_WordprocessingCanvas_bg, "ooxml:CT_WordprocessingCanvas_bg" },
    { NS_ooxml::LN_CT_WordprocessingCanvas_whole, "ooxml:CT_WordprocessingCanvas_whole" },
    { NS_ooxml::LN_CT_WordprocessingCanvas_wsp, "ooxml:CT_WordprocessingCanvas_wsp" },
    { NS_ooxml::LN_CT_WordprocessingCanvas_pic, "ooxml:CT_WordprocessingCanvas_pic" },
    { NS_ooxml::LN_CT_WordprocessingCanvas_wgp, "ooxml:CT_WordprocessingCanvas_wgp" },
    { NS_ooxml::LN_wpc_wpc, "ooxml:wpc_wpc" },
    { NS_ooxml::LN_Value_vml_ST_FillType_solid, "ooxml:Value_vml_ST_FillType_solid" },
    { NS_ooxml::LN_Value_vml_ST_FillType_gradient, "ooxml:Value_vml_ST_FillType_gradient" },
    { NS_ooxml::LN_Value_vml_ST_FillType_gradientRadial, "ooxml:Value_vml_ST_FillType_gradientRadial" },
    { NS_ooxml::LN_Value_vml_ST_FillType_tile, "ooxml:Value_vml_ST_FillType_tile" },
    { NS_ooxml::LN_Value_vml_ST_FillType_pattern, "ooxml:Value_vml_ST_FillType_pattern" },
    { NS_ooxml::LN_Value_vml_ST_FillType_frame, "ooxml:Value_vml_ST_FillType_frame" },
    { NS_ooxml::LN_Value_vml_ST_StrokeLineStyle_single, "ooxml:Value_vml_ST_StrokeLineStyle_single" },
    { NS_ooxml::LN_Value_vml_ST_StrokeLineStyle_thinThin, "ooxml:Value_vml_ST_StrokeLineStyle_thinThin" },
    { NS_ooxml::LN_Value_vml_ST_StrokeLineStyle_thinThick, "ooxml:Value_vml_ST_StrokeLineStyle_thinThick" },
    { NS_ooxml::LN_Value_vml_ST_StrokeLineStyle_thickThin, "ooxml:Value_vml_ST_StrokeLineStyle_thickThin" },
    { NS_ooxml::LN_Value_vml_ST_StrokeLineStyle_thickBetweenThin, "ooxml:Value_vml_ST_StrokeLineStyle_thickBetweenThin" },
    { NS_ooxml::LN_Value_vml_ST_StrokeJoinStyle_round, "ooxml:Value_vml_ST_StrokeJoinStyle_round" },
    { NS_ooxml::LN_Value_vml_ST_StrokeJoinStyle_bevel, "ooxml:Value_vml_ST_StrokeJoinStyle_bevel" },
    { NS_ooxml::LN_Value_vml_ST_StrokeJoinStyle_miter, "ooxml:Value_vml_ST_StrokeJoinStyle_miter" },
    { NS_ooxml::LN_Value_vml_ST_StrokeEndCap_flat, "ooxml:Value_vml_ST_StrokeEndCap_flat" },
    { NS_ooxml::LN_Value_vml_ST_StrokeEndCap_square, "ooxml:Value_vml_ST_StrokeEndCap_square" },
    { NS_ooxml::LN_Value_vml_ST_StrokeEndCap_round, "ooxml:Value_vml_ST_StrokeEndCap_round" },
    { NS_ooxml::LN_Value_vml_ST_StrokeArrowLength_short, "ooxml:Value_vml_ST_StrokeArrowLength_short" },
    { NS_ooxml::LN_Value_vml_ST_StrokeArrowLength_medium, "ooxml:Value_vml_ST_StrokeArrowLength_medium" },
    { NS_ooxml::LN_Value_vml_ST_StrokeArrowLength_long, "ooxml:Value_vml_ST_StrokeArrowLength_long" },
    { NS_ooxml::LN_Value_vml_ST_StrokeArrowWidth_narrow, "ooxml:Value_vml_ST_StrokeArrowWidth_narrow" },
    { NS_ooxml::LN_Value_vml_ST_StrokeArrowWidth_medium, "ooxml:Value_vml_ST_StrokeArrowWidth_medium" },
    { NS_ooxml::LN_Value_vml_ST_StrokeArrowWidth_wide, "ooxml:Value_vml_ST_StrokeArrowWidth_wide" },
    { NS_ooxml::LN_Value_vml_ST_StrokeArrowType_none, "ooxml:Value_vml_ST_StrokeArrowType_none" },
    { NS_ooxml::LN_Value_vml_ST_StrokeArrowType_block, "ooxml:Value_vml_ST_StrokeArrowType_block" },
    { NS_ooxml::LN_Value_vml_ST_StrokeArrowType_classic, "ooxml:Value_vml_ST_StrokeArrowType_classic" },
    { NS_ooxml::LN_Value_vml_ST_StrokeArrowType_oval, "ooxml:Value_vml_ST_StrokeArrowType_oval" },
    { NS_ooxml::LN_Value_vml_ST_StrokeArrowType_diamond, "ooxml:Value_vml_ST_StrokeArrowType_diamond" },
    { NS_ooxml::LN_Value_vml_ST_StrokeArrowType_open, "ooxml:Value_vml_ST_StrokeArrowType_open" },
    { NS_ooxml::LN_Value_vml_ST_ImageAspect_ignore, "ooxml:Value_vml_ST_ImageAspect_ignore" },
    { NS_ooxml::LN_Value_vml_ST_ImageAspect_atMost, "ooxml:Value_vml_ST_ImageAspect_atMost" },
    { NS_ooxml::LN_Value_vml_ST_ImageAspect_atLeast, "ooxml:Value_vml_ST_ImageAspect_atLeast" },
    { NS_ooxml::LN_Value_vml_ST_TrueFalseBlank_t, "ooxml:Value_vml_ST_TrueFalseBlank_t" },
    { NS_ooxml::LN_Value_vml_ST_TrueFalseBlank_f, "ooxml:Value_vml_ST_TrueFalseBlank_f" },
    { NS_ooxml::LN_Value_vml_ST_TrueFalseBlank_true, "ooxml:Value_vml_ST_TrueFalseBlank_true" },
    { NS_ooxml::LN_Value_vml_ST_TrueFalseBlank_false, "ooxml:Value_vml_ST_TrueFalseBlank_false" },
    { NS_ooxml::LN_Value_vml_ST_TrueFalseBlank_, "ooxml:Value_vml_ST_TrueFalseBlank_" },
    { NS_ooxml::LN_CT_Background_id, "ooxml:CT_Background_id" },
    { NS_ooxml::LN_background_background, "ooxml:background_background" },
    { NS_ooxml::LN_OLEObject_OLEObject, "ooxml:OLEObject_OLEObject" },
    { NS_ooxml::LN_CT_OLEObject_LinkType, "ooxml:CT_OLEObject_LinkType" },
    { NS_ooxml::LN_CT_OLEObject_LockedField, "ooxml:CT_OLEObject_LockedField" },
    { NS_ooxml::LN_CT_OLEObject_FieldCodes, "ooxml:CT_OLEObject_FieldCodes" },
    { NS_ooxml::LN_CT_OLEObject_Type, "ooxml:CT_OLEObject_Type" },
    { NS_ooxml::LN_CT_OLEObject_ProgID, "ooxml:CT_OLEObject_ProgID" },
    { NS_ooxml::LN_CT_OLEObject_ShapeID, "ooxml:CT_OLEObject_ShapeID" },
    { NS_ooxml::LN_CT_OLEObject_DrawAspect, "ooxml:CT_OLEObject_DrawAspect" },
    { NS_ooxml::LN_CT_OLEObject_ObjectID, "ooxml:CT_OLEObject_ObjectID" },
    { NS_ooxml::LN_CT_OLEObject_r_id, "ooxml:CT_OLEObject_r_id" },
    { NS_ooxml::LN_CT_OLEObject_UpdateMode, "ooxml:CT_OLEObject_UpdateMode" },
    { NS_ooxml::LN_Value_vmlOffice_ST_Angle_any, "ooxml:Value_vmlOffice_ST_Angle_any" },
    { NS_ooxml::LN_Value_vmlOffice_ST_Angle_30, "ooxml:Value_vmlOffice_ST_Angle_30" },
    { NS_ooxml::LN_Value_vmlOffice_ST_Angle_45, "ooxml:Value_vmlOffice_ST_Angle_45" },
    { NS_ooxml::LN_Value_vmlOffice_ST_Angle_60, "ooxml:Value_vmlOffice_ST_Angle_60" },
    { NS_ooxml::LN_Value_vmlOffice_ST_Angle_90, "ooxml:Value_vmlOffice_ST_Angle_90" },
    { NS_ooxml::LN_Value_vmlOffice_ST_Angle_auto, "ooxml:Value_vmlOffice_ST_Angle_auto" },
    { NS_ooxml::LN_Value_vmlOffice_ST_OLELinkType_Picture, "ooxml:Value_vmlOffice_ST_OLELinkType_Picture" },
    { NS_ooxml::LN_Value_vmlOffice_ST_OLELinkType_Bitmap, "ooxml:Value_vmlOffice_ST_OLELinkType_Bitmap" },
    { NS_ooxml::LN_Value_vmlOffice_ST_OLELinkType_EnhancedMetaFile, "ooxml:Value_vmlOffice_ST_OLELinkType_EnhancedMetaFile" },
    { NS_ooxml::LN_Value_vmlOffice_ST_TrueFalseBlank_, "ooxml:Value_vmlOffice_ST_TrueFalseBlank_" },
    { NS_ooxml::LN_Value_vmlOffice_ST_TrueFalseBlank_t, "ooxml:Value_vmlOffice_ST_TrueFalseBlank_t" },
    { NS_ooxml::LN_Value_vmlOffice_ST_TrueFalseBlank_f, "ooxml:Value_vmlOffice_ST_TrueFalseBlank_f" },
    { NS_ooxml::LN_Value_vmlOffice_ST_TrueFalseBlank_true, "ooxml:Value_vmlOffice_ST_TrueFalseBlank_true" },
    { NS_ooxml::LN_Value_vmlOffice_ST_TrueFalseBlank_false, "ooxml:Value_vmlOffice_ST_TrueFalseBlank_false" },
    { NS_ooxml::LN_Value_vmlOffice_ST_FillType_gradientCenter, "ooxml:Value_vmlOffice_ST_FillType_gradientCenter" },
    { NS_ooxml::LN_Value_vmlOffice_ST_FillType_solid, "ooxml:Value_vmlOffice_ST_FillType_solid" },
    { NS_ooxml::LN_Value_vmlOffice_ST_FillType_pattern, "ooxml:Value_vmlOffice_ST_FillType_pattern" },
    { NS_ooxml::LN_Value_vmlOffice_ST_FillType_tile, "ooxml:Value_vmlOffice_ST_FillType_tile" },
    { NS_ooxml::LN_Value_vmlOffice_ST_FillType_frame, "ooxml:Value_vmlOffice_ST_FillType_frame" },
    { NS_ooxml::LN_Value_vmlOffice_ST_FillType_gradientUnscaled, "ooxml:Value_vmlOffice_ST_FillType_gradientUnscaled" },
    { NS_ooxml::LN_Value_vmlOffice_ST_FillType_gradientRadial, "ooxml:Value_vmlOffice_ST_FillType_gradientRadial" },
    { NS_ooxml::LN_Value_vmlOffice_ST_FillType_gradient, "ooxml:Value_vmlOffice_ST_FillType_gradient" },
    { NS_ooxml::LN_Value_vmlOffice_ST_FillType_background, "ooxml:Value_vmlOffice_ST_FillType_background" },
    { NS_ooxml::LN_wrap_wrap, "ooxml:wrap_wrap" },
    { NS_ooxml::LN_CT_Wrap_type, "ooxml:CT_Wrap_type" },
    { NS_ooxml::LN_CT_Wrap_side, "ooxml:CT_Wrap_side" },
    { NS_ooxml::LN_CT_Wrap_anchorx, "ooxml:CT_Wrap_anchorx" },
    { NS_ooxml::LN_CT_Wrap_anchory, "ooxml:CT_Wrap_anchory" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_WrapType_topAndBottom, "ooxml:Value_vml_wordprocessingDrawing_ST_WrapType_topAndBottom" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_WrapType_square, "ooxml:Value_vml_wordprocessingDrawing_ST_WrapType_square" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_WrapType_none, "ooxml:Value_vml_wordprocessingDrawing_ST_WrapType_none" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_WrapType_tight, "ooxml:Value_vml_wordprocessingDrawing_ST_WrapType_tight" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_WrapType_through, "ooxml:Value_vml_wordprocessingDrawing_ST_WrapType_through" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_WrapSide_both, "ooxml:Value_vml_wordprocessingDrawing_ST_WrapSide_both" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_WrapSide_left, "ooxml:Value_vml_wordprocessingDrawing_ST_WrapSide_left" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_WrapSide_right, "ooxml:Value_vml_wordprocessingDrawing_ST_WrapSide_right" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_WrapSide_largest, "ooxml:Value_vml_wordprocessingDrawing_ST_WrapSide_largest" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_HorizontalAnchor_margin, "ooxml:Value_vml_wordprocessingDrawing_ST_HorizontalAnchor_margin" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_HorizontalAnchor_page, "ooxml:Value_vml_wordprocessingDrawing_ST_HorizontalAnchor_page" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_HorizontalAnchor_text, "ooxml:Value_vml_wordprocessingDrawing_ST_HorizontalAnchor_text" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_HorizontalAnchor_char, "ooxml:Value_vml_wordprocessingDrawing_ST_HorizontalAnchor_char" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_VerticalAnchor_margin, "ooxml:Value_vml_wordprocessingDrawing_ST_VerticalAnchor_margin" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_VerticalAnchor_page, "ooxml:Value_vml_wordprocessingDrawing_ST_VerticalAnchor_page" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_VerticalAnchor_text, "ooxml:Value_vml_wordprocessingDrawing_ST_VerticalAnchor_text" },
    { NS_ooxml::LN_Value_vml_wordprocessingDrawing_ST_VerticalAnchor_line, "ooxml:Value_vml_wordprocessingDrawing_ST_VerticalAnchor_line" },
    { NS_ooxml::LN_EG_RunInnerContent_noBreakHyphen, "ooxml:EG_RunInnerContent_noBreakHyphen" },
    { NS_ooxml::LN_EG_RunInnerContent_softHyphen, "ooxml:EG_RunInnerContent_softHyphen" },
    { NS_ooxml::LN_EG_RunInnerContent_cr, "ooxml:EG_RunInnerContent_cr" },
    { NS_ooxml::LN_CT_LongHexNumber_val, "ooxml:CT_LongHexNumber_val" },
    { NS_ooxml::LN_CT_ShortHexNumber_val, "ooxml:CT_ShortHexNumber_val" },
    { NS_ooxml::LN_CT_UcharHexNumber_val, "ooxml:CT_UcharHexNumber_val" },
    { NS_ooxml::LN_CT_DecimalNumber_val, "ooxml:CT_DecimalNumber_val" },
    { NS_ooxml::LN_CT_SignedTwipsMeasure_val, "ooxml:CT_SignedTwipsMeasure_val" },
    { NS_ooxml::LN_CT_PixelsMeasure_val, "ooxml:CT_PixelsMeasure_val" },
    { NS_ooxml::LN_CT_HpsMeasure_val, "ooxml:CT_HpsMeasure_val" },
    { NS_ooxml::LN_CT_SignedHpsMeasure_val, "ooxml:CT_SignedHpsMeasure_val" },
    { NS_ooxml::LN_CT_MacroName_val, "ooxml:CT_MacroName_val" },
    { NS_ooxml::LN_CT_TextScale_val, "ooxml:CT_TextScale_val" },
    { NS_ooxml::LN_Value_ST_HighlightColor_black, "ooxml:Value_ST_HighlightColor_black" },
    { NS_ooxml::LN_Value_ST_HighlightColor_blue, "ooxml:Value_ST_HighlightColor_blue" },
    { NS_ooxml::LN_Value_ST_HighlightColor_cyan, "ooxml:Value_ST_HighlightColor_cyan" },
    { NS_ooxml::LN_Value_ST_HighlightColor_green, "ooxml:Value_ST_HighlightColor_green" },
    { NS_ooxml::LN_Value_ST_HighlightColor_magenta, "ooxml:Value_ST_HighlightColor_magenta" },
    { NS_ooxml::LN_Value_ST_HighlightColor_red, "ooxml:Value_ST_HighlightColor_red" },
    { NS_ooxml::LN_Value_ST_HighlightColor_yellow, "ooxml:Value_ST_HighlightColor_yellow" },
    { NS_ooxml::LN_Value_ST_HighlightColor_white, "ooxml:Value_ST_HighlightColor_white" },
    { NS_ooxml::LN_Value_ST_HighlightColor_darkBlue, "ooxml:Value_ST_HighlightColor_darkBlue" },
    { NS_ooxml::LN_Value_ST_HighlightColor_darkCyan, "ooxml:Value_ST_HighlightColor_darkCyan" },
    { NS_ooxml::LN_Value_ST_HighlightColor_darkGreen, "ooxml:Value_ST_HighlightColor_darkGreen" },
    { NS_ooxml::LN_Value_ST_HighlightColor_darkMagenta, "ooxml:Value_ST_HighlightColor_darkMagenta" },
    { NS_ooxml::LN_Value_ST_HighlightColor_darkRed, "ooxml:Value_ST_HighlightColor_darkRed" },
    { NS_ooxml::LN_Value_ST_HighlightColor_darkYellow, "ooxml:Value_ST_HighlightColor_darkYellow" },
    { NS_ooxml::LN_Value_ST_HighlightColor_darkGray, "ooxml:Value_ST_HighlightColor_darkGray" },
    { NS_ooxml::LN_Value_ST_HighlightColor_lightGray, "ooxml:Value_ST_HighlightColor_lightGray" },
    { NS_ooxml::LN_Value_ST_HighlightColor_none, "ooxml:Value_ST_HighlightColor_none" },
    { NS_ooxml::LN_CT_Highlight_val, "ooxml:CT_Highlight_val" },
    { NS_ooxml::LN_Value_ST_HexColorAuto_auto, "ooxml:Value_ST_HexColorAuto_auto" },
    { NS_ooxml::LN_CT_Color_val, "ooxml:CT_Color_val" },
    { NS_ooxml::LN_CT_Color_themeColor, "ooxml:CT_Color_themeColor" },
    { NS_ooxml::LN_CT_Color_themeTint, "ooxml:CT_Color_themeTint" },
    { NS_ooxml::LN_CT_Color_themeShade, "ooxml:CT_Color_themeShade" },
    { NS_ooxml::LN_CT_Lang_val, "ooxml:CT_Lang_val" },
    { NS_ooxml::LN_CT_Guid_val, "ooxml:CT_Guid_val" },
    { NS_ooxml::LN_Value_ST_Underline_single, "ooxml:Value_ST_Underline_single" },
    { NS_ooxml::LN_Value_ST_Underline_words, "ooxml:Value_ST_Underline_words" },
    { NS_ooxml::LN_Value_ST_Underline_double, "ooxml:Value_ST_Underline_double" },
    { NS_ooxml::LN_Value_ST_Underline_thick, "ooxml:Value_ST_Underline_thick" },
    { NS_ooxml::LN_Value_ST_Underline_dotted, "ooxml:Value_ST_Underline_dotted" },
    { NS_ooxml::LN_Value_ST_Underline_dottedHeavy, "ooxml:Value_ST_Underline_dottedHeavy" },
    { NS_ooxml::LN_Value_ST_Underline_dash, "ooxml:Value_ST_Underline_dash" },
    { NS_ooxml::LN_Value_ST_Underline_dashedHeavy, "ooxml:Value_ST_Underline_dashedHeavy" },
    { NS_ooxml::LN_Value_ST_Underline_dashLong, "ooxml:Value_ST_Underline_dashLong" },
    { NS_ooxml::LN_Value_ST_Underline_dashLongHeavy, "ooxml:Value_ST_Underline_dashLongHeavy" },
    { NS_ooxml::LN_Value_ST_Underline_dotDash, "ooxml:Value_ST_Underline_dotDash" },
    { NS_ooxml::LN_Value_ST_Underline_dashDotHeavy, "ooxml:Value_ST_Underline_dashDotHeavy" },
    { NS_ooxml::LN_Value_ST_Underline_dotDotDash, "ooxml:Value_ST_Underline_dotDotDash" },
    { NS_ooxml::LN_Value_ST_Underline_dashDotDotHeavy, "ooxml:Value_ST_Underline_dashDotDotHeavy" },
    { NS_ooxml::LN_Value_ST_Underline_wave, "ooxml:Value_ST_Underline_wave" },
    { NS_ooxml::LN_Value_ST_Underline_wavyHeavy, "ooxml:Value_ST_Underline_wavyHeavy" },
    { NS_ooxml::LN_Value_ST_Underline_wavyDouble, "ooxml:Value_ST_Underline_wavyDouble" },
    { NS_ooxml::LN_Value_ST_Underline_none, "ooxml:Value_ST_Underline_none" },
    { NS_ooxml::LN_CT_Underline_val, "ooxml:CT_Underline_val" },
    { NS_ooxml::LN_CT_Underline_color, "ooxml:CT_Underline_color" },
    { NS_ooxml::LN_CT_Underline_themeColor, "ooxml:CT_Underline_themeColor" },
    { NS_ooxml::LN_CT_Underline_themeTint, "ooxml:CT_Underline_themeTint" },
    { NS_ooxml::LN_CT_Underline_themeShade, "ooxml:CT_Underline_themeShade" },
    { NS_ooxml::LN_Value_ST_TextEffect_none, "ooxml:Value_ST_TextEffect_none" },
    { NS_ooxml::LN_Value_ST_TextEffect_lights, "ooxml:Value_ST_TextEffect_lights" },
    { NS_ooxml::LN_Value_ST_TextEffect_blinkBackground, "ooxml:Value_ST_TextEffect_blinkBackground" },
    { NS_ooxml::LN_Value_ST_TextEffect_sparkle, "ooxml:Value_ST_TextEffect_sparkle" },
    { NS_ooxml::LN_Value_ST_TextEffect_antsBlack, "ooxml:Value_ST_TextEffect_antsBlack" },
    { NS_ooxml::LN_Value_ST_TextEffect_antsRed, "ooxml:Value_ST_TextEffect_antsRed" },
    { NS_ooxml::LN_Value_ST_TextEffect_shimmer, "ooxml:Value_ST_TextEffect_shimmer" },
    { NS_ooxml::LN_CT_TextEffect_val, "ooxml:CT_TextEffect_val" },
    { NS_ooxml::LN_Value_ST_Border_nil, "ooxml:Value_ST_Border_nil" },
    { NS_ooxml::LN_Value_ST_Border_none, "ooxml:Value_ST_Border_none" },
    { NS_ooxml::LN_Value_ST_Border_single, "ooxml:Value_ST_Border_single" },
    { NS_ooxml::LN_Value_ST_Border_thick, "ooxml:Value_ST_Border_thick" },
    { NS_ooxml::LN_Value_ST_Border_double, "ooxml:Value_ST_Border_double" },
    { NS_ooxml::LN_Value_ST_Border_dotted, "ooxml:Value_ST_Border_dotted" },
    { NS_ooxml::LN_Value_ST_Border_dashed, "ooxml:Value_ST_Border_dashed" },
    { NS_ooxml::LN_Value_ST_Border_dotDash, "ooxml:Value_ST_Border_dotDash" },
    { NS_ooxml::LN_Value_ST_Border_dotDotDash, "ooxml:Value_ST_Border_dotDotDash" },
    { NS_ooxml::LN_Value_ST_Border_triple, "ooxml:Value_ST_Border_triple" },
    { NS_ooxml::LN_Value_ST_Border_thinThickSmallGap, "ooxml:Value_ST_Border_thinThickSmallGap" },
    { NS_ooxml::LN_Value_ST_Border_thickThinSmallGap, "ooxml:Value_ST_Border_thickThinSmallGap" },
    { NS_ooxml::LN_Value_ST_Border_thinThickThinSmallGap, "ooxml:Value_ST_Border_thinThickThinSmallGap" },
    { NS_ooxml::LN_Value_ST_Border_thinThickMediumGap, "ooxml:Value_ST_Border_thinThickMediumGap" },
    { NS_ooxml::LN_Value_ST_Border_thickThinMediumGap, "ooxml:Value_ST_Border_thickThinMediumGap" },
    { NS_ooxml::LN_Value_ST_Border_thinThickThinMediumGap, "ooxml:Value_ST_Border_thinThickThinMediumGap" },
    { NS_ooxml::LN_Value_ST_Border_thinThickLargeGap, "ooxml:Value_ST_Border_thinThickLargeGap" },
    { NS_ooxml::LN_Value_ST_Border_thickThinLargeGap, "ooxml:Value_ST_Border_thickThinLargeGap" },
    { NS_ooxml::LN_Value_ST_Border_thinThickThinLargeGap, "ooxml:Value_ST_Border_thinThickThinLargeGap" },
    { NS_ooxml::LN_Value_ST_Border_wave, "ooxml:Value_ST_Border_wave" },
    { NS_ooxml::LN_Value_ST_Border_doubleWave, "ooxml:Value_ST_Border_doubleWave" },
    { NS_ooxml::LN_Value_ST_Border_dashSmallGap, "ooxml:Value_ST_Border_dashSmallGap" },
    { NS_ooxml::LN_Value_ST_Border_dashDotStroked, "ooxml:Value_ST_Border_dashDotStroked" },
    { NS_ooxml::LN_Value_ST_Border_threeDEmboss, "ooxml:Value_ST_Border_threeDEmboss" },
    { NS_ooxml::LN_Value_ST_Border_threeDEngrave, "ooxml:Value_ST_Border_threeDEngrave" },
    { NS_ooxml::LN_Value_ST_Border_outset, "ooxml:Value_ST_Border_outset" },
    { NS_ooxml::LN_Value_ST_Border_inset, "ooxml:Value_ST_Border_inset" },
    { NS_ooxml::LN_Value_ST_Border_apples, "ooxml:Value_ST_Border_apples" },
    { NS_ooxml::LN_Value_ST_Border_archedScallops, "ooxml:Value_ST_Border_archedScallops" },
    { NS_ooxml::LN_Value_ST_Border_babyPacifier, "ooxml:Value_ST_Border_babyPacifier" },
    { NS_ooxml::LN_Value_ST_Border_babyRattle, "ooxml:Value_ST_Border_babyRattle" },
    { NS_ooxml::LN_Value_ST_Border_balloons3Colors, "ooxml:Value_ST_Border_balloons3Colors" },
    { NS_ooxml::LN_Value_ST_Border_balloonsHotAir, "ooxml:Value_ST_Border_balloonsHotAir" },
    { NS_ooxml::LN_Value_ST_Border_basicBlackDashes, "ooxml:Value_ST_Border_basicBlackDashes" },
    { NS_ooxml::LN_Value_ST_Border_basicBlackDots, "ooxml:Value_ST_Border_basicBlackDots" },
    { NS_ooxml::LN_Value_ST_Border_basicBlackSquares, "ooxml:Value_ST_Border_basicBlackSquares" },
    { NS_ooxml::LN_Value_ST_Border_basicThinLines, "ooxml:Value_ST_Border_basicThinLines" },
    { NS_ooxml::LN_Value_ST_Border_basicWhiteDashes, "ooxml:Value_ST_Border_basicWhiteDashes" },
    { NS_ooxml::LN_Value_ST_Border_basicWhiteDots, "ooxml:Value_ST_Border_basicWhiteDots" },
    { NS_ooxml::LN_Value_ST_Border_basicWhiteSquares, "ooxml:Value_ST_Border_basicWhiteSquares" },
    { NS_ooxml::LN_Value_ST_Border_basicWideInline, "ooxml:Value_ST_Border_basicWideInline" },
    { NS_ooxml::LN_Value_ST_Border_basicWideMidline, "ooxml:Value_ST_Border_basicWideMidline" },
    { NS_ooxml::LN_Value_ST_Border_basicWideOutline, "ooxml:Value_ST_Border_basicWideOutline" },
    { NS_ooxml::LN_Value_ST_Border_bats, "ooxml:Value_ST_Border_bats" },
    { NS_ooxml::LN_Value_ST_Border_birds, "ooxml:Value_ST_Border_birds" },
    { NS_ooxml::LN_Value_ST_Border_birdsFlight, "ooxml:Value_ST_Border_birdsFlight" },
    { NS_ooxml::LN_Value_ST_Border_cabins, "ooxml:Value_ST_Border_cabins" },
    { NS_ooxml::LN_Value_ST_Border_cakeSlice, "ooxml:Value_ST_Border_cakeSlice" },
    { NS_ooxml::LN_Value_ST_Border_candyCorn, "ooxml:Value_ST_Border_candyCorn" },
    { NS_ooxml::LN_Value_ST_Border_celticKnotwork, "ooxml:Value_ST_Border_celticKnotwork" },
    { NS_ooxml::LN_Value_ST_Border_certificateBanner, "ooxml:Value_ST_Border_certificateBanner" },
    { NS_ooxml::LN_Value_ST_Border_chainLink, "ooxml:Value_ST_Border_chainLink" },
    { NS_ooxml::LN_Value_ST_Border_champagneBottle, "ooxml:Value_ST_Border_champagneBottle" },
    { NS_ooxml::LN_Value_ST_Border_checkedBarBlack, "ooxml:Value_ST_Border_checkedBarBlack" },
    { NS_ooxml::LN_Value_ST_Border_checkedBarColor, "ooxml:Value_ST_Border_checkedBarColor" },
    { NS_ooxml::LN_Value_ST_Border_checkered, "ooxml:Value_ST_Border_checkered" },
    { NS_ooxml::LN_Value_ST_Border_christmasTree, "ooxml:Value_ST_Border_christmasTree" },
    { NS_ooxml::LN_Value_ST_Border_circlesLines, "ooxml:Value_ST_Border_circlesLines" },
    { NS_ooxml::LN_Value_ST_Border_circlesRectangles, "ooxml:Value_ST_Border_circlesRectangles" },
    { NS_ooxml::LN_Value_ST_Border_classicalWave, "ooxml:Value_ST_Border_classicalWave" },
    { NS_ooxml::LN_Value_ST_Border_clocks, "ooxml:Value_ST_Border_clocks" },
    { NS_ooxml::LN_Value_ST_Border_compass, "ooxml:Value_ST_Border_compass" },
    { NS_ooxml::LN_Value_ST_Border_confetti, "ooxml:Value_ST_Border_confetti" },
    { NS_ooxml::LN_Value_ST_Border_confettiGrays, "ooxml:Value_ST_Border_confettiGrays" },
    { NS_ooxml::LN_Value_ST_Border_confettiOutline, "ooxml:Value_ST_Border_confettiOutline" },
    { NS_ooxml::LN_Value_ST_Border_confettiStreamers, "ooxml:Value_ST_Border_confettiStreamers" },
    { NS_ooxml::LN_Value_ST_Border_confettiWhite, "ooxml:Value_ST_Border_confettiWhite" },
    { NS_ooxml::LN_Value_ST_Border_cornerTriangles, "ooxml:Value_ST_Border_cornerTriangles" },
    { NS_ooxml::LN_Value_ST_Border_couponCutoutDashes, "ooxml:Value_ST_Border_couponCutoutDashes" },
    { NS_ooxml::LN_Value_ST_Border_couponCutoutDots, "ooxml:Value_ST_Border_couponCutoutDots" },
    { NS_ooxml::LN_Value_ST_Border_crazyMaze, "ooxml:Value_ST_Border_crazyMaze" },
    { NS_ooxml::LN_Value_ST_Border_creaturesButterfly, "ooxml:Value_ST_Border_creaturesButterfly" },
    { NS_ooxml::LN_Value_ST_Border_creaturesFish, "ooxml:Value_ST_Border_creaturesFish" },
    { NS_ooxml::LN_Value_ST_Border_creaturesInsects, "ooxml:Value_ST_Border_creaturesInsects" },
    { NS_ooxml::LN_Value_ST_Border_creaturesLadyBug, "ooxml:Value_ST_Border_creaturesLadyBug" },
    { NS_ooxml::LN_Value_ST_Border_crossStitch, "ooxml:Value_ST_Border_crossStitch" },
    { NS_ooxml::LN_Value_ST_Border_cup, "ooxml:Value_ST_Border_cup" },
    { NS_ooxml::LN_Value_ST_Border_decoArch, "ooxml:Value_ST_Border_decoArch" },
    { NS_ooxml::LN_Value_ST_Border_decoArchColor, "ooxml:Value_ST_Border_decoArchColor" },
    { NS_ooxml::LN_Value_ST_Border_decoBlocks, "ooxml:Value_ST_Border_decoBlocks" },
    { NS_ooxml::LN_Value_ST_Border_diamondsGray, "ooxml:Value_ST_Border_diamondsGray" },
    { NS_ooxml::LN_Value_ST_Border_doubleD, "ooxml:Value_ST_Border_doubleD" },
    { NS_ooxml::LN_Value_ST_Border_doubleDiamonds, "ooxml:Value_ST_Border_doubleDiamonds" },
    { NS_ooxml::LN_Value_ST_Border_earth1, "ooxml:Value_ST_Border_earth1" },
    { NS_ooxml::LN_Value_ST_Border_earth2, "ooxml:Value_ST_Border_earth2" },
    { NS_ooxml::LN_Value_ST_Border_eclipsingSquares1, "ooxml:Value_ST_Border_eclipsingSquares1" },
    { NS_ooxml::LN_Value_ST_Border_eclipsingSquares2, "ooxml:Value_ST_Border_eclipsingSquares2" },
    { NS_ooxml::LN_Value_ST_Border_eggsBlack, "ooxml:Value_ST_Border_eggsBlack" },
    { NS_ooxml::LN_Value_ST_Border_fans, "ooxml:Value_ST_Border_fans" },
    { NS_ooxml::LN_Value_ST_Border_film, "ooxml:Value_ST_Border_film" },
    { NS_ooxml::LN_Value_ST_Border_firecrackers, "ooxml:Value_ST_Border_firecrackers" },
    { NS_ooxml::LN_Value_ST_Border_flowersBlockPrint, "ooxml:Value_ST_Border_flowersBlockPrint" },
    { NS_ooxml::LN_Value_ST_Border_flowersDaisies, "ooxml:Value_ST_Border_flowersDaisies" },
    { NS_ooxml::LN_Value_ST_Border_flowersModern1, "ooxml:Value_ST_Border_flowersModern1" },
    { NS_ooxml::LN_Value_ST_Border_flowersModern2, "ooxml:Value_ST_Border_flowersModern2" },
    { NS_ooxml::LN_Value_ST_Border_flowersPansy, "ooxml:Value_ST_Border_flowersPansy" },
    { NS_ooxml::LN_Value_ST_Border_flowersRedRose, "ooxml:Value_ST_Border_flowersRedRose" },
    { NS_ooxml::LN_Value_ST_Border_flowersRoses, "ooxml:Value_ST_Border_flowersRoses" },
    { NS_ooxml::LN_Value_ST_Border_flowersTeacup, "ooxml:Value_ST_Border_flowersTeacup" },
    { NS_ooxml::LN_Value_ST_Border_flowersTiny, "ooxml:Value_ST_Border_flowersTiny" },
    { NS_ooxml::LN_Value_ST_Border_gems, "ooxml:Value_ST_Border_gems" },
    { NS_ooxml::LN_Value_ST_Border_gingerbreadMan, "ooxml:Value_ST_Border_gingerbreadMan" },
    { NS_ooxml::LN_Value_ST_Border_gradient, "ooxml:Value_ST_Border_gradient" },
    { NS_ooxml::LN_Value_ST_Border_handmade1, "ooxml:Value_ST_Border_handmade1" },
    { NS_ooxml::LN_Value_ST_Border_handmade2, "ooxml:Value_ST_Border_handmade2" },
    { NS_ooxml::LN_Value_ST_Border_heartBalloon, "ooxml:Value_ST_Border_heartBalloon" },
    { NS_ooxml::LN_Value_ST_Border_heartGray, "ooxml:Value_ST_Border_heartGray" },
    { NS_ooxml::LN_Value_ST_Border_hearts, "ooxml:Value_ST_Border_hearts" },
    { NS_ooxml::LN_Value_ST_Border_heebieJeebies, "ooxml:Value_ST_Border_heebieJeebies" },
    { NS_ooxml::LN_Value_ST_Border_holly, "ooxml:Value_ST_Border_holly" },
    { NS_ooxml::LN_Value_ST_Border_houseFunky, "ooxml:Value_ST_Border_houseFunky" },
    { NS_ooxml::LN_Value_ST_Border_hypnotic, "ooxml:Value_ST_Border_hypnotic" },
    { NS_ooxml::LN_Value_ST_Border_iceCreamCones, "ooxml:Value_ST_Border_iceCreamCones" },
    { NS_ooxml::LN_Value_ST_Border_lightBulb, "ooxml:Value_ST_Border_lightBulb" },
    { NS_ooxml::LN_Value_ST_Border_lightning1, "ooxml:Value_ST_Border_lightning1" },
    { NS_ooxml::LN_Value_ST_Border_lightning2, "ooxml:Value_ST_Border_lightning2" },
    { NS_ooxml::LN_Value_ST_Border_mapPins, "ooxml:Value_ST_Border_mapPins" },
    { NS_ooxml::LN_Value_ST_Border_mapleLeaf, "ooxml:Value_ST_Border_mapleLeaf" },
    { NS_ooxml::LN_Value_ST_Border_mapleMuffins, "ooxml:Value_ST_Border_mapleMuffins" },
    { NS_ooxml::LN_Value_ST_Border_marquee, "ooxml:Value_ST_Border_marquee" },
    { NS_ooxml::LN_Value_ST_Border_marqueeToothed, "ooxml:Value_ST_Border_marqueeToothed" },
    { NS_ooxml::LN_Value_ST_Border_moons, "ooxml:Value_ST_Border_moons" },
    { NS_ooxml::LN_Value_ST_Border_mosaic, "ooxml:Value_ST_Border_mosaic" },
    { NS_ooxml::LN_Value_ST_Border_musicNotes, "ooxml:Value_ST_Border_musicNotes" },
    { NS_ooxml::LN_Value_ST_Border_northwest, "ooxml:Value_ST_Border_northwest" },
    { NS_ooxml::LN_Value_ST_Border_ovals, "ooxml:Value_ST_Border_ovals" },
    { NS_ooxml::LN_Value_ST_Border_packages, "ooxml:Value_ST_Border_packages" },
    { NS_ooxml::LN_Value_ST_Border_palmsBlack, "ooxml:Value_ST_Border_palmsBlack" },
    { NS_ooxml::LN_Value_ST_Border_palmsColor, "ooxml:Value_ST_Border_palmsColor" },
    { NS_ooxml::LN_Value_ST_Border_paperClips, "ooxml:Value_ST_Border_paperClips" },
    { NS_ooxml::LN_Value_ST_Border_papyrus, "ooxml:Value_ST_Border_papyrus" },
    { NS_ooxml::LN_Value_ST_Border_partyFavor, "ooxml:Value_ST_Border_partyFavor" },
    { NS_ooxml::LN_Value_ST_Border_partyGlass, "ooxml:Value_ST_Border_partyGlass" },
    { NS_ooxml::LN_Value_ST_Border_pencils, "ooxml:Value_ST_Border_pencils" },
    { NS_ooxml::LN_Value_ST_Border_people, "ooxml:Value_ST_Border_people" },
    { NS_ooxml::LN_Value_ST_Border_peopleWaving, "ooxml:Value_ST_Border_peopleWaving" },
    { NS_ooxml::LN_Value_ST_Border_peopleHats, "ooxml:Value_ST_Border_peopleHats" },
    { NS_ooxml::LN_Value_ST_Border_poinsettias, "ooxml:Value_ST_Border_poinsettias" },
    { NS_ooxml::LN_Value_ST_Border_postageStamp, "ooxml:Value_ST_Border_postageStamp" },
    { NS_ooxml::LN_Value_ST_Border_pumpkin1, "ooxml:Value_ST_Border_pumpkin1" },
    { NS_ooxml::LN_Value_ST_Border_pushPinNote2, "ooxml:Value_ST_Border_pushPinNote2" },
    { NS_ooxml::LN_Value_ST_Border_pushPinNote1, "ooxml:Value_ST_Border_pushPinNote1" },
    { NS_ooxml::LN_Value_ST_Border_pyramids, "ooxml:Value_ST_Border_pyramids" },
    { NS_ooxml::LN_Value_ST_Border_pyramidsAbove, "ooxml:Value_ST_Border_pyramidsAbove" },
    { NS_ooxml::LN_Value_ST_Border_quadrants, "ooxml:Value_ST_Border_quadrants" },
    { NS_ooxml::LN_Value_ST_Border_rings, "ooxml:Value_ST_Border_rings" },
    { NS_ooxml::LN_Value_ST_Border_safari, "ooxml:Value_ST_Border_safari" },
    { NS_ooxml::LN_Value_ST_Border_sawtooth, "ooxml:Value_ST_Border_sawtooth" },
    { NS_ooxml::LN_Value_ST_Border_sawtoothGray, "ooxml:Value_ST_Border_sawtoothGray" },
    { NS_ooxml::LN_Value_ST_Border_scaredCat, "ooxml:Value_ST_Border_scaredCat" },
    { NS_ooxml::LN_Value_ST_Border_seattle, "ooxml:Value_ST_Border_seattle" },
    { NS_ooxml::LN_Value_ST_Border_shadowedSquares, "ooxml:Value_ST_Border_shadowedSquares" },
    { NS_ooxml::LN_Value_ST_Border_sharksTeeth, "ooxml:Value_ST_Border_sharksTeeth" },
    { NS_ooxml::LN_Value_ST_Border_shorebirdTracks, "ooxml:Value_ST_Border_shorebirdTracks" },
    { NS_ooxml::LN_Value_ST_Border_skyrocket, "ooxml:Value_ST_Border_skyrocket" },
    { NS_ooxml::LN_Value_ST_Border_snowflakeFancy, "ooxml:Value_ST_Border_snowflakeFancy" },
    { NS_ooxml::LN_Value_ST_Border_snowflakes, "ooxml:Value_ST_Border_snowflakes" },
    { NS_ooxml::LN_Value_ST_Border_sombrero, "ooxml:Value_ST_Border_sombrero" },
    { NS_ooxml::LN_Value_ST_Border_southwest, "ooxml:Value_ST_Border_southwest" },
    { NS_ooxml::LN_Value_ST_Border_stars, "ooxml:Value_ST_Border_stars" },
    { NS_ooxml::LN_Value_ST_Border_starsTop, "ooxml:Value_ST_Border_starsTop" },
    { NS_ooxml::LN_Value_ST_Border_stars3d, "ooxml:Value_ST_Border_stars3d" },
    { NS_ooxml::LN_Value_ST_Border_starsBlack, "ooxml:Value_ST_Border_starsBlack" },
    { NS_ooxml::LN_Value_ST_Border_starsShadowed, "ooxml:Value_ST_Border_starsShadowed" },
    { NS_ooxml::LN_Value_ST_Border_sun, "ooxml:Value_ST_Border_sun" },
    { NS_ooxml::LN_Value_ST_Border_swirligig, "ooxml:Value_ST_Border_swirligig" },
    { NS_ooxml::LN_Value_ST_Border_tornPaper, "ooxml:Value_ST_Border_tornPaper" },
    { NS_ooxml::LN_Value_ST_Border_tornPaperBlack, "ooxml:Value_ST_Border_tornPaperBlack" },
    { NS_ooxml::LN_Value_ST_Border_trees, "ooxml:Value_ST_Border_trees" },
    { NS_ooxml::LN_Value_ST_Border_triangleParty, "ooxml:Value_ST_Border_triangleParty" },
    { NS_ooxml::LN_Value_ST_Border_triangles, "ooxml:Value_ST_Border_triangles" },
    { NS_ooxml::LN_Value_ST_Border_tribal1, "ooxml:Value_ST_Border_tribal1" },
    { NS_ooxml::LN_Value_ST_Border_tribal2, "ooxml:Value_ST_Border_tribal2" },
    { NS_ooxml::LN_Value_ST_Border_tribal3, "ooxml:Value_ST_Border_tribal3" },
    { NS_ooxml::LN_Value_ST_Border_tribal4, "ooxml:Value_ST_Border_tribal4" },
    { NS_ooxml::LN_Value_ST_Border_tribal5, "ooxml:Value_ST_Border_tribal5" },
    { NS_ooxml::LN_Value_ST_Border_tribal6, "ooxml:Value_ST_Border_tribal6" },
    { NS_ooxml::LN_Value_ST_Border_twistedLines1, "ooxml:Value_ST_Border_twistedLines1" },
    { NS_ooxml::LN_Value_ST_Border_twistedLines2, "ooxml:Value_ST_Border_twistedLines2" },
    { NS_ooxml::LN_Value_ST_Border_vine, "ooxml:Value_ST_Border_vine" },
    { NS_ooxml::LN_Value_ST_Border_waveline, "ooxml:Value_ST_Border_waveline" },
    { NS_ooxml::LN_Value_ST_Border_weavingAngles, "ooxml:Value_ST_Border_weavingAngles" },
    { NS_ooxml::LN_Value_ST_Border_weavingBraid, "ooxml:Value_ST_Border_weavingBraid" },
    { NS_ooxml::LN_Value_ST_Border_weavingRibbon, "ooxml:Value_ST_Border_weavingRibbon" },
    { NS_ooxml::LN_Value_ST_Border_weavingStrips, "ooxml:Value_ST_Border_weavingStrips" },
    { NS_ooxml::LN_Value_ST_Border_whiteFlowers, "ooxml:Value_ST_Border_whiteFlowers" },
    { NS_ooxml::LN_Value_ST_Border_woodwork, "ooxml:Value_ST_Border_woodwork" },
    { NS_ooxml::LN_Value_ST_Border_xIllusions, "ooxml:Value_ST_Border_xIllusions" },
    { NS_ooxml::LN_Value_ST_Border_zanyTriangles, "ooxml:Value_ST_Border_zanyTriangles" },
    { NS_ooxml::LN_Value_ST_Border_zigZag, "ooxml:Value_ST_Border_zigZag" },
    { NS_ooxml::LN_Value_ST_Border_zigZagStitch, "ooxml:Value_ST_Border_zigZagStitch" },
    { NS_ooxml::LN_CT_Border_val, "ooxml:CT_Border_val" },
    { NS_ooxml::LN_CT_Border_color, "ooxml:CT_Border_color" },
    { NS_ooxml::LN_CT_Border_themeColor, "ooxml:CT_Border_themeColor" },
    { NS_ooxml::LN_CT_Border_themeTint, "ooxml:CT_Border_themeTint" },
    { NS_ooxml::LN_CT_Border_themeShade, "ooxml:CT_Border_themeShade" },
    { NS_ooxml::LN_CT_Border_sz, "ooxml:CT_Border_sz" },
    { NS_ooxml::LN_CT_Border_space, "ooxml:CT_Border_space" },
    { NS_ooxml::LN_CT_Border_shadow, "ooxml:CT_Border_shadow" },
    { NS_ooxml::LN_CT_Border_frame, "ooxml:CT_Border_frame" },
    { NS_ooxml::LN_Value_ST_Shd_clear, "ooxml:Value_ST_Shd_clear" },
    { NS_ooxml::LN_Value_ST_Shd_solid, "ooxml:Value_ST_Shd_solid" },
    { NS_ooxml::LN_Value_ST_Shd_pct5, "ooxml:Value_ST_Shd_pct5" },
    { NS_ooxml::LN_Value_ST_Shd_pct10, "ooxml:Value_ST_Shd_pct10" },
    { NS_ooxml::LN_Value_ST_Shd_pct20, "ooxml:Value_ST_Shd_pct20" },
    { NS_ooxml::LN_Value_ST_Shd_pct25, "ooxml:Value_ST_Shd_pct25" },
    { NS_ooxml::LN_Value_ST_Shd_pct30, "ooxml:Value_ST_Shd_pct30" },
    { NS_ooxml::LN_Value_ST_Shd_pct40, "ooxml:Value_ST_Shd_pct40" },
    { NS_ooxml::LN_Value_ST_Shd_pct50, "ooxml:Value_ST_Shd_pct50" },
    { NS_ooxml::LN_Value_ST_Shd_pct60, "ooxml:Value_ST_Shd_pct60" },
    { NS_ooxml::LN_Value_ST_Shd_pct70, "ooxml:Value_ST_Shd_pct70" },
    { NS_ooxml::LN_Value_ST_Shd_pct75, "ooxml:Value_ST_Shd_pct75" },
    { NS_ooxml::LN_Value_ST_Shd_pct80, "ooxml:Value_ST_Shd_pct80" },
    { NS_ooxml::LN_Value_ST_Shd_pct90, "ooxml:Value_ST_Shd_pct90" },
    { NS_ooxml::LN_Value_ST_Shd_horzStripe, "ooxml:Value_ST_Shd_horzStripe" },
    { NS_ooxml::LN_Value_ST_Shd_vertStripe, "ooxml:Value_ST_Shd_vertStripe" },
    { NS_ooxml::LN_Value_ST_Shd_reverseDiagStripe, "ooxml:Value_ST_Shd_reverseDiagStripe" },
    { NS_ooxml::LN_Value_ST_Shd_diagStripe, "ooxml:Value_ST_Shd_diagStripe" },
    { NS_ooxml::LN_Value_ST_Shd_horzCross, "ooxml:Value_ST_Shd_horzCross" },
    { NS_ooxml::LN_Value_ST_Shd_diagCross, "ooxml:Value_ST_Shd_diagCross" },
    { NS_ooxml::LN_Value_ST_Shd_thinHorzStripe, "ooxml:Value_ST_Shd_thinHorzStripe" },
    { NS_ooxml::LN_Value_ST_Shd_thinVertStripe, "ooxml:Value_ST_Shd_thinVertStripe" },
    { NS_ooxml::LN_Value_ST_Shd_thinReverseDiagStripe, "ooxml:Value_ST_Shd_thinReverseDiagStripe" },
    { NS_ooxml::LN_Value_ST_Shd_thinDiagStripe, "ooxml:Value_ST_Shd_thinDiagStripe" },
    { NS_ooxml::LN_Value_ST_Shd_thinHorzCross, "ooxml:Value_ST_Shd_thinHorzCross" },
    { NS_ooxml::LN_Value_ST_Shd_thinDiagCross, "ooxml:Value_ST_Shd_thinDiagCross" },
    { NS_ooxml::LN_Value_ST_Shd_pct12, "ooxml:Value_ST_Shd_pct12" },
    { NS_ooxml::LN_Value_ST_Shd_pct15, "ooxml:Value_ST_Shd_pct15" },
    { NS_ooxml::LN_Value_ST_Shd_pct35, "ooxml:Value_ST_Shd_pct35" },
    { NS_ooxml::LN_Value_ST_Shd_pct37, "ooxml:Value_ST_Shd_pct37" },
    { NS_ooxml::LN_Value_ST_Shd_pct45, "ooxml:Value_ST_Shd_pct45" },
    { NS_ooxml::LN_Value_ST_Shd_pct55, "ooxml:Value_ST_Shd_pct55" },
    { NS_ooxml::LN_Value_ST_Shd_pct62, "ooxml:Value_ST_Shd_pct62" },
    { NS_ooxml::LN_Value_ST_Shd_pct65, "ooxml:Value_ST_Shd_pct65" },
    { NS_ooxml::LN_Value_ST_Shd_pct85, "ooxml:Value_ST_Shd_pct85" },
    { NS_ooxml::LN_Value_ST_Shd_pct87, "ooxml:Value_ST_Shd_pct87" },
    { NS_ooxml::LN_Value_ST_Shd_pct95, "ooxml:Value_ST_Shd_pct95" },
    { NS_ooxml::LN_Value_ST_Shd_nil, "ooxml:Value_ST_Shd_nil" },
    { NS_ooxml::LN_CT_Shd_val, "ooxml:CT_Shd_val" },
    { NS_ooxml::LN_CT_Shd_color, "ooxml:CT_Shd_color" },
    { NS_ooxml::LN_CT_Shd_themeColor, "ooxml:CT_Shd_themeColor" },
    { NS_ooxml::LN_CT_Shd_themeTint, "ooxml:CT_Shd_themeTint" },
    { NS_ooxml::LN_CT_Shd_themeShade, "ooxml:CT_Shd_themeShade" },
    { NS_ooxml::LN_CT_Shd_fill, "ooxml:CT_Shd_fill" },
    { NS_ooxml::LN_CT_Shd_themeFill, "ooxml:CT_Shd_themeFill" },
    { NS_ooxml::LN_CT_Shd_themeFillTint, "ooxml:CT_Shd_themeFillTint" },
    { NS_ooxml::LN_CT_Shd_themeFillShade, "ooxml:CT_Shd_themeFillShade" },
    { NS_ooxml::LN_CT_VerticalAlignRun_val, "ooxml:CT_VerticalAlignRun_val" },
    { NS_ooxml::LN_CT_FitText_val, "ooxml:CT_FitText_val" },
    { NS_ooxml::LN_CT_FitText_id, "ooxml:CT_FitText_id" },
    { NS_ooxml::LN_Value_ST_Em_none, "ooxml:Value_ST_Em_none" },
    { NS_ooxml::LN_Value_ST_Em_dot, "ooxml:Value_ST_Em_dot" },
    { NS_ooxml::LN_Value_ST_Em_comma, "ooxml:Value_ST_Em_comma" },
    { NS_ooxml::LN_Value_ST_Em_circle, "ooxml:Value_ST_Em_circle" },
    { NS_ooxml::LN_Value_ST_Em_underDot, "ooxml:Value_ST_Em_underDot" },
    { NS_ooxml::LN_CT_Em_val, "ooxml:CT_Em_val" },
    { NS_ooxml::LN_CT_Language_val, "ooxml:CT_Language_val" },
    { NS_ooxml::LN_CT_Language_eastAsia, "ooxml:CT_Language_eastAsia" },
    { NS_ooxml::LN_CT_Language_bidi, "ooxml:CT_Language_bidi" },
    { NS_ooxml::LN_Value_ST_CombineBrackets_none, "ooxml:Value_ST_CombineBrackets_none" },
    { NS_ooxml::LN_Value_ST_CombineBrackets_round, "ooxml:Value_ST_CombineBrackets_round" },
    { NS_ooxml::LN_Value_ST_CombineBrackets_square, "ooxml:Value_ST_CombineBrackets_square" },
    { NS_ooxml::LN_Value_ST_CombineBrackets_angle, "ooxml:Value_ST_CombineBrackets_angle" },
    { NS_ooxml::LN_Value_ST_CombineBrackets_curly, "ooxml:Value_ST_CombineBrackets_curly" },
    { NS_ooxml::LN_CT_EastAsianLayout_id, "ooxml:CT_EastAsianLayout_id" },
    { NS_ooxml::LN_CT_EastAsianLayout_combine, "ooxml:CT_EastAsianLayout_combine" },
    { NS_ooxml::LN_CT_EastAsianLayout_combineBrackets, "ooxml:CT_EastAsianLayout_combineBrackets" },
    { NS_ooxml::LN_CT_EastAsianLayout_vert, "ooxml:CT_EastAsianLayout_vert" },
    { NS_ooxml::LN_CT_EastAsianLayout_vertCompress, "ooxml:CT_EastAsianLayout_vertCompress" },
    { NS_ooxml::LN_Value_doc_ST_XAlign_left, "ooxml:Value_doc_ST_XAlign_left" },
    { NS_ooxml::LN_Value_doc_ST_XAlign_center, "ooxml:Value_doc_ST_XAlign_center" },
    { NS_ooxml::LN_Value_doc_ST_XAlign_right, "ooxml:Value_doc_ST_XAlign_right" },
    { NS_ooxml::LN_Value_doc_ST_XAlign_inside, "ooxml:Value_doc_ST_XAlign_inside" },
    { NS_ooxml::LN_Value_doc_ST_XAlign_outside, "ooxml:Value_doc_ST_XAlign_outside" },
    { NS_ooxml::LN_Value_doc_ST_YAlign_inline, "ooxml:Value_doc_ST_YAlign_inline" },
    { NS_ooxml::LN_Value_doc_ST_YAlign_top, "ooxml:Value_doc_ST_YAlign_top" },
    { NS_ooxml::LN_Value_doc_ST_YAlign_center, "ooxml:Value_doc_ST_YAlign_center" },
    { NS_ooxml::LN_Value_doc_ST_YAlign_bottom, "ooxml:Value_doc_ST_YAlign_bottom" },
    { NS_ooxml::LN_Value_doc_ST_YAlign_inside, "ooxml:Value_doc_ST_YAlign_inside" },
    { NS_ooxml::LN_Value_doc_ST_YAlign_outside, "ooxml:Value_doc_ST_YAlign_outside" },
    { NS_ooxml::LN_Value_doc_ST_HeightRule_auto, "ooxml:Value_doc_ST_HeightRule_auto" },
    { NS_ooxml::LN_Value_doc_ST_HeightRule_exact, "ooxml:Value_doc_ST_HeightRule_exact" },
    { NS_ooxml::LN_Value_doc_ST_HeightRule_atLeast, "ooxml:Value_doc_ST_HeightRule_atLeast" },
    { NS_ooxml::LN_Value_doc_ST_Wrap_auto, "ooxml:Value_doc_ST_Wrap_auto" },
    { NS_ooxml::LN_Value_doc_ST_Wrap_notBeside, "ooxml:Value_doc_ST_Wrap_notBeside" },
    { NS_ooxml::LN_Value_doc_ST_Wrap_around, "ooxml:Value_doc_ST_Wrap_around" },
    { NS_ooxml::LN_Value_doc_ST_Wrap_tight, "ooxml:Value_doc_ST_Wrap_tight" },
    { NS_ooxml::LN_Value_doc_ST_Wrap_through, "ooxml:Value_doc_ST_Wrap_through" },
    { NS_ooxml::LN_Value_doc_ST_Wrap_none, "ooxml:Value_doc_ST_Wrap_none" },
    { NS_ooxml::LN_Value_doc_ST_VAnchor_text, "ooxml:Value_doc_ST_VAnchor_text" },
    { NS_ooxml::LN_Value_doc_ST_VAnchor_margin, "ooxml:Value_doc_ST_VAnchor_margin" },
    { NS_ooxml::LN_Value_doc_ST_VAnchor_page, "ooxml:Value_doc_ST_VAnchor_page" },
    { NS_ooxml::LN_Value_doc_ST_HAnchor_text, "ooxml:Value_doc_ST_HAnchor_text" },
    { NS_ooxml::LN_Value_doc_ST_HAnchor_margin, "ooxml:Value_doc_ST_HAnchor_margin" },
    { NS_ooxml::LN_Value_doc_ST_HAnchor_page, "ooxml:Value_doc_ST_HAnchor_page" },
    { NS_ooxml::LN_Value_doc_ST_DropCap_none, "ooxml:Value_doc_ST_DropCap_none" },
    { NS_ooxml::LN_Value_doc_ST_DropCap_drop, "ooxml:Value_doc_ST_DropCap_drop" },
    { NS_ooxml::LN_Value_doc_ST_DropCap_margin, "ooxml:Value_doc_ST_DropCap_margin" },
    { NS_ooxml::LN_CT_FramePr_dropCap, "ooxml:CT_FramePr_dropCap" },
    { NS_ooxml::LN_CT_FramePr_lines, "ooxml:CT_FramePr_lines" },
    { NS_ooxml::LN_CT_FramePr_w, "ooxml:CT_FramePr_w" },
    { NS_ooxml::LN_CT_FramePr_h, "ooxml:CT_FramePr_h" },
    { NS_ooxml::LN_CT_FramePr_vSpace, "ooxml:CT_FramePr_vSpace" },
    { NS_ooxml::LN_CT_FramePr_hSpace, "ooxml:CT_FramePr_hSpace" },
    { NS_ooxml::LN_CT_FramePr_wrap, "ooxml:CT_FramePr_wrap" },
    { NS_ooxml::LN_CT_FramePr_hAnchor, "ooxml:CT_FramePr_hAnchor" },
    { NS_ooxml::LN_CT_FramePr_vAnchor, "ooxml:CT_FramePr_vAnchor" },
    { NS_ooxml::LN_CT_FramePr_x, "ooxml:CT_FramePr_x" },
    { NS_ooxml::LN_CT_FramePr_xAlign, "ooxml:CT_FramePr_xAlign" },
    { NS_ooxml::LN_CT_FramePr_y, "ooxml:CT_FramePr_y" },
    { NS_ooxml::LN_CT_FramePr_yAlign, "ooxml:CT_FramePr_yAlign" },
    { NS_ooxml::LN_CT_FramePr_hRule, "ooxml:CT_FramePr_hRule" },
    { NS_ooxml::LN_CT_FramePr_anchorLock, "ooxml:CT_FramePr_anchorLock" },
    { NS_ooxml::LN_Value_ST_TabJc_clear, "ooxml:Value_ST_TabJc_clear" },
    { NS_ooxml::LN_Value_ST_TabJc_start, "ooxml:Value_ST_TabJc_start" },
    { NS_ooxml::LN_Value_ST_TabJc_left, "ooxml:Value_ST_TabJc_left" },
    { NS_ooxml::LN_Value_ST_TabJc_center, "ooxml:Value_ST_TabJc_center" },
    { NS_ooxml::LN_Value_ST_TabJc_end, "ooxml:Value_ST_TabJc_end" },
    { NS_ooxml::LN_Value_ST_TabJc_right, "ooxml:Value_ST_TabJc_right" },
    { NS_ooxml::LN_Value_ST_TabJc_decimal, "ooxml:Value_ST_TabJc_decimal" },
    { NS_ooxml::LN_Value_ST_TabJc_bar, "ooxml:Value_ST_TabJc_bar" },
    { NS_ooxml::LN_Value_ST_TabJc_num, "ooxml:Value_ST_TabJc_num" },
    { NS_ooxml::LN_Value_ST_TabTlc_none, "ooxml:Value_ST_TabTlc_none" },
    { NS_ooxml::LN_Value_ST_TabTlc_dot, "ooxml:Value_ST_TabTlc_dot" },
    { NS_ooxml::LN_Value_ST_TabTlc_hyphen, "ooxml:Value_ST_TabTlc_hyphen" },
    { NS_ooxml::LN_Value_ST_TabTlc_underscore, "ooxml:Value_ST_TabTlc_underscore" },
    { NS_ooxml::LN_Value_ST_TabTlc_heavy, "ooxml:Value_ST_TabTlc_heavy" },
    { NS_ooxml::LN_Value_ST_TabTlc_middleDot, "ooxml:Value_ST_TabTlc_middleDot" },
    { NS_ooxml::LN_CT_TabStop_val, "ooxml:CT_TabStop_val" },
    { NS_ooxml::LN_CT_TabStop_leader, "ooxml:CT_TabStop_leader" },
    { NS_ooxml::LN_CT_TabStop_pos, "ooxml:CT_TabStop_pos" },
    { NS_ooxml::LN_Value_doc_ST_LineSpacingRule_auto, "ooxml:Value_doc_ST_LineSpacingRule_auto" },
    { NS_ooxml::LN_Value_doc_ST_LineSpacingRule_exact, "ooxml:Value_doc_ST_LineSpacingRule_exact" },
    { NS_ooxml::LN_Value_doc_ST_LineSpacingRule_atLeast, "ooxml:Value_doc_ST_LineSpacingRule_atLeast" },
    { NS_ooxml::LN_CT_Spacing_before, "ooxml:CT_Spacing_before" },
    { NS_ooxml::LN_CT_Spacing_beforeLines, "ooxml:CT_Spacing_beforeLines" },
    { NS_ooxml::LN_CT_Spacing_beforeAutospacing, "ooxml:CT_Spacing_beforeAutospacing" },
    { NS_ooxml::LN_CT_Spacing_after, "ooxml:CT_Spacing_after" },
    { NS_ooxml::LN_CT_Spacing_afterLines, "ooxml:CT_Spacing_afterLines" },
    { NS_ooxml::LN_CT_Spacing_afterAutospacing, "ooxml:CT_Spacing_afterAutospacing" },
    { NS_ooxml::LN_CT_Spacing_line, "ooxml:CT_Spacing_line" },
    { NS_ooxml::LN_CT_Spacing_lineRule, "ooxml:CT_Spacing_lineRule" },
    { NS_ooxml::LN_CT_Ind_end, "ooxml:CT_Ind_end" },
    { NS_ooxml::LN_CT_Ind_endChars, "ooxml:CT_Ind_endChars" },
    { NS_ooxml::LN_CT_Ind_start, "ooxml:CT_Ind_start" },
    { NS_ooxml::LN_CT_Ind_startChars, "ooxml:CT_Ind_startChars" },
    { NS_ooxml::LN_CT_Ind_hanging, "ooxml:CT_Ind_hanging" },
    { NS_ooxml::LN_CT_Ind_hangingChars, "ooxml:CT_Ind_hangingChars" },
    { NS_ooxml::LN_CT_Ind_firstLine, "ooxml:CT_Ind_firstLine" },
    { NS_ooxml::LN_CT_Ind_firstLineChars, "ooxml:CT_Ind_firstLineChars" },
    { NS_ooxml::LN_CT_Ind_left, "ooxml:CT_Ind_left" },
    { NS_ooxml::LN_CT_Ind_leftChars, "ooxml:CT_Ind_leftChars" },
    { NS_ooxml::LN_CT_Ind_right, "ooxml:CT_Ind_right" },
    { NS_ooxml::LN_CT_Ind_rightChars, "ooxml:CT_Ind_rightChars" },
    { NS_ooxml::LN_Value_ST_Jc_left, "ooxml:Value_ST_Jc_left" },
    { NS_ooxml::LN_Value_ST_Jc_right, "ooxml:Value_ST_Jc_right" },
    { NS_ooxml::LN_Value_ST_Jc_start, "ooxml:Value_ST_Jc_start" },
    { NS_ooxml::LN_Value_ST_Jc_center, "ooxml:Value_ST_Jc_center" },
    { NS_ooxml::LN_Value_ST_Jc_end, "ooxml:Value_ST_Jc_end" },
    { NS_ooxml::LN_Value_ST_Jc_both, "ooxml:Value_ST_Jc_both" },
    { NS_ooxml::LN_Value_ST_Jc_mediumKashida, "ooxml:Value_ST_Jc_mediumKashida" },
    { NS_ooxml::LN_Value_ST_Jc_distribute, "ooxml:Value_ST_Jc_distribute" },
    { NS_ooxml::LN_Value_ST_Jc_numTab, "ooxml:Value_ST_Jc_numTab" },
    { NS_ooxml::LN_Value_ST_Jc_highKashida, "ooxml:Value_ST_Jc_highKashida" },
    { NS_ooxml::LN_Value_ST_Jc_lowKashida, "ooxml:Value_ST_Jc_lowKashida" },
    { NS_ooxml::LN_Value_ST_Jc_thaiDistribute, "ooxml:Value_ST_Jc_thaiDistribute" },
    { NS_ooxml::LN_CT_Jc_val, "ooxml:CT_Jc_val" },
    { NS_ooxml::LN_Value_doc_ST_View_none, "ooxml:Value_doc_ST_View_none" },
    { NS_ooxml::LN_Value_doc_ST_View_print, "ooxml:Value_doc_ST_View_print" },
    { NS_ooxml::LN_Value_doc_ST_View_outline, "ooxml:Value_doc_ST_View_outline" },
    { NS_ooxml::LN_Value_doc_ST_View_masterPages, "ooxml:Value_doc_ST_View_masterPages" },
    { NS_ooxml::LN_Value_doc_ST_View_normal, "ooxml:Value_doc_ST_View_normal" },
    { NS_ooxml::LN_Value_doc_ST_View_web, "ooxml:Value_doc_ST_View_web" },
    { NS_ooxml::LN_CT_View_val, "ooxml:CT_View_val" },
    { NS_ooxml::LN_Value_doc_ST_Zoom_none, "ooxml:Value_doc_ST_Zoom_none" },
    { NS_ooxml::LN_Value_doc_ST_Zoom_fullPage, "ooxml:Value_doc_ST_Zoom_fullPage" },
    { NS_ooxml::LN_Value_doc_ST_Zoom_bestFit, "ooxml:Value_doc_ST_Zoom_bestFit" },
    { NS_ooxml::LN_Value_doc_ST_Zoom_textFit, "ooxml:Value_doc_ST_Zoom_textFit" },
    { NS_ooxml::LN_CT_Zoom_val, "ooxml:CT_Zoom_val" },
    { NS_ooxml::LN_CT_Zoom_percent, "ooxml:CT_Zoom_percent" },
    { NS_ooxml::LN_CT_WritingStyle_lang, "ooxml:CT_WritingStyle_lang" },
    { NS_ooxml::LN_CT_WritingStyle_vendorID, "ooxml:CT_WritingStyle_vendorID" },
    { NS_ooxml::LN_CT_WritingStyle_dllVersion, "ooxml:CT_WritingStyle_dllVersion" },
    { NS_ooxml::LN_CT_WritingStyle_nlCheck, "ooxml:CT_WritingStyle_nlCheck" },
    { NS_ooxml::LN_CT_WritingStyle_checkStyle, "ooxml:CT_WritingStyle_checkStyle" },
    { NS_ooxml::LN_CT_WritingStyle_appName, "ooxml:CT_WritingStyle_appName" },
    { NS_ooxml::LN_CT_Proof_spelling, "ooxml:CT_Proof_spelling" },
    { NS_ooxml::LN_CT_Proof_grammar, "ooxml:CT_Proof_grammar" },
    { NS_ooxml::LN_Value_doc_ST_DocType_notSpecified, "ooxml:Value_doc_ST_DocType_notSpecified" },
    { NS_ooxml::LN_Value_doc_ST_DocType_letter, "ooxml:Value_doc_ST_DocType_letter" },
    { NS_ooxml::LN_Value_doc_ST_DocType_eMail, "ooxml:Value_doc_ST_DocType_eMail" },
    { NS_ooxml::LN_CT_DocType_val, "ooxml:CT_DocType_val" },
    { NS_ooxml::LN_Value_doc_ST_DocProtect_none, "ooxml:Value_doc_ST_DocProtect_none" },
    { NS_ooxml::LN_Value_doc_ST_DocProtect_readOnly, "ooxml:Value_doc_ST_DocProtect_readOnly" },
    { NS_ooxml::LN_Value_doc_ST_DocProtect_comments, "ooxml:Value_doc_ST_DocProtect_comments" },
    { NS_ooxml::LN_Value_doc_ST_DocProtect_trackedChanges, "ooxml:Value_doc_ST_DocProtect_trackedChanges" },
    { NS_ooxml::LN_Value_doc_ST_DocProtect_forms, "ooxml:Value_doc_ST_DocProtect_forms" },
    { NS_ooxml::LN_Value_doc_ST_CryptProv_rsaAES, "ooxml:Value_doc_ST_CryptProv_rsaAES" },
    { NS_ooxml::LN_Value_doc_ST_CryptProv_rsaFull, "ooxml:Value_doc_ST_CryptProv_rsaFull" },
    { NS_ooxml::LN_Value_doc_ST_AlgClass_hash, "ooxml:Value_doc_ST_AlgClass_hash" },
    { NS_ooxml::LN_Value_doc_ST_AlgType_typeAny, "ooxml:Value_doc_ST_AlgType_typeAny" },
    { NS_ooxml::LN_AG_Password_cryptProviderType, "ooxml:AG_Password_cryptProviderType" },
    { NS_ooxml::LN_AG_Password_cryptAlgorithmClass, "ooxml:AG_Password_cryptAlgorithmClass" },
    { NS_ooxml::LN_AG_Password_cryptAlgorithmType, "ooxml:AG_Password_cryptAlgorithmType" },
    { NS_ooxml::LN_AG_Password_cryptAlgorithmSid, "ooxml:AG_Password_cryptAlgorithmSid" },
    { NS_ooxml::LN_AG_Password_cryptSpinCount, "ooxml:AG_Password_cryptSpinCount" },
    { NS_ooxml::LN_AG_Password_cryptProvider, "ooxml:AG_Password_cryptProvider" },
    { NS_ooxml::LN_AG_Password_algIdExt, "ooxml:AG_Password_algIdExt" },
    { NS_ooxml::LN_AG_Password_algIdExtSource, "ooxml:AG_Password_algIdExtSource" },
    { NS_ooxml::LN_AG_Password_cryptProviderTypeExt, "ooxml:AG_Password_cryptProviderTypeExt" },
    { NS_ooxml::LN_AG_Password_cryptProviderTypeExtSource, "ooxml:AG_Password_cryptProviderTypeExtSource" },
    { NS_ooxml::LN_AG_Password_hash, "ooxml:AG_Password_hash" },
    { NS_ooxml::LN_AG_Password_salt, "ooxml:AG_Password_salt" },
    { NS_ooxml::LN_CT_DocProtect_edit, "ooxml:CT_DocProtect_edit" },
    { NS_ooxml::LN_CT_DocProtect_formatting, "ooxml:CT_DocProtect_formatting" },
    { NS_ooxml::LN_CT_DocProtect_enforcement, "ooxml:CT_DocProtect_enforcement" },
    { NS_ooxml::LN_CT_MailMergeDocType_val, "ooxml:CT_MailMergeDocType_val" },
    { NS_ooxml::LN_CT_MailMergeDataType_val, "ooxml:CT_MailMergeDataType_val" },
    { NS_ooxml::LN_CT_MailMergeDest_val, "ooxml:CT_MailMergeDest_val" },
    { NS_ooxml::LN_CT_MailMergeOdsoFMDFieldType_val, "ooxml:CT_MailMergeOdsoFMDFieldType_val" },
    { NS_ooxml::LN_CT_TrackChangesView_markup, "ooxml:CT_TrackChangesView_markup" },
    { NS_ooxml::LN_CT_TrackChangesView_comments, "ooxml:CT_TrackChangesView_comments" },
    { NS_ooxml::LN_CT_TrackChangesView_insDel, "ooxml:CT_TrackChangesView_insDel" },
    { NS_ooxml::LN_CT_TrackChangesView_formatting, "ooxml:CT_TrackChangesView_formatting" },
    { NS_ooxml::LN_CT_TrackChangesView_inkAnnotations, "ooxml:CT_TrackChangesView_inkAnnotations" },
    { NS_ooxml::LN_CT_Kinsoku_lang, "ooxml:CT_Kinsoku_lang" },
    { NS_ooxml::LN_CT_Kinsoku_val, "ooxml:CT_Kinsoku_val" },
    { NS_ooxml::LN_Value_ST_TextDirection_lrTb, "ooxml:Value_ST_TextDirection_lrTb" },
    { NS_ooxml::LN_Value_ST_TextDirection_tbRl, "ooxml:Value_ST_TextDirection_tbRl" },
    { NS_ooxml::LN_Value_ST_TextDirection_btLr, "ooxml:Value_ST_TextDirection_btLr" },
    { NS_ooxml::LN_Value_ST_TextDirection_lrTbV, "ooxml:Value_ST_TextDirection_lrTbV" },
    { NS_ooxml::LN_Value_ST_TextDirection_tbRlV, "ooxml:Value_ST_TextDirection_tbRlV" },
    { NS_ooxml::LN_Value_ST_TextDirection_tbLrV, "ooxml:Value_ST_TextDirection_tbLrV" },
    { NS_ooxml::LN_CT_TextDirection_val, "ooxml:CT_TextDirection_val" },
    { NS_ooxml::LN_Value_doc_ST_TextAlignment_top, "ooxml:Value_doc_ST_TextAlignment_top" },
    { NS_ooxml::LN_Value_doc_ST_TextAlignment_center, "ooxml:Value_doc_ST_TextAlignment_center" },
    { NS_ooxml::LN_Value_doc_ST_TextAlignment_baseline, "ooxml:Value_doc_ST_TextAlignment_baseline" },
    { NS_ooxml::LN_Value_doc_ST_TextAlignment_bottom, "ooxml:Value_doc_ST_TextAlignment_bottom" },
    { NS_ooxml::LN_Value_doc_ST_TextAlignment_auto, "ooxml:Value_doc_ST_TextAlignment_auto" },
    { NS_ooxml::LN_CT_TextAlignment_val, "ooxml:CT_TextAlignment_val" },
    { NS_ooxml::LN_Value_doc_ST_DisplacedByCustomXml_next, "ooxml:Value_doc_ST_DisplacedByCustomXml_next" },
    { NS_ooxml::LN_Value_doc_ST_DisplacedByCustomXml_prev, "ooxml:Value_doc_ST_DisplacedByCustomXml_prev" },
    { NS_ooxml::LN_Value_doc_ST_AnnotationVMerge_cont, "ooxml:Value_doc_ST_AnnotationVMerge_cont" },
    { NS_ooxml::LN_Value_doc_ST_AnnotationVMerge_rest, "ooxml:Value_doc_ST_AnnotationVMerge_rest" },
    { NS_ooxml::LN_CT_Markup_id, "ooxml:CT_Markup_id" },
    { NS_ooxml::LN_CT_TrackChange_author, "ooxml:CT_TrackChange_author" },
    { NS_ooxml::LN_CT_TrackChange_date, "ooxml:CT_TrackChange_date" },
    { NS_ooxml::LN_EG_RangeMarkupElements_customXmlInsRangeStart, "ooxml:EG_RangeMarkupElements_customXmlInsRangeStart" },
    { NS_ooxml::LN_EG_RangeMarkupElements_customXmlInsRangeEnd, "ooxml:EG_RangeMarkupElements_customXmlInsRangeEnd" },
    { NS_ooxml::LN_EG_RangeMarkupElements_customXmlDelRangeStart, "ooxml:EG_RangeMarkupElements_customXmlDelRangeStart" },
    { NS_ooxml::LN_EG_RangeMarkupElements_customXmlDelRangeEnd, "ooxml:EG_RangeMarkupElements_customXmlDelRangeEnd" },
    { NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveFromRangeStart, "ooxml:EG_RangeMarkupElements_customXmlMoveFromRangeStart" },
    { NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveFromRangeEnd, "ooxml:EG_RangeMarkupElements_customXmlMoveFromRangeEnd" },
    { NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveToRangeStart, "ooxml:EG_RangeMarkupElements_customXmlMoveToRangeStart" },
    { NS_ooxml::LN_EG_RangeMarkupElements_customXmlMoveToRangeEnd, "ooxml:EG_RangeMarkupElements_customXmlMoveToRangeEnd" },
    { NS_ooxml::LN_CT_CellMergeTrackChange_vMerge, "ooxml:CT_CellMergeTrackChange_vMerge" },
    { NS_ooxml::LN_CT_CellMergeTrackChange_vMergeOrig, "ooxml:CT_CellMergeTrackChange_vMergeOrig" },
    { NS_ooxml::LN_CT_TrackChangeRange_displacedByCustomXml, "ooxml:CT_TrackChangeRange_displacedByCustomXml" },
    { NS_ooxml::LN_CT_MarkupRange_displacedByCustomXml, "ooxml:CT_MarkupRange_displacedByCustomXml" },
    { NS_ooxml::LN_CT_MarkupRangeBookmark_id, "ooxml:CT_MarkupRangeBookmark_id" },
    { NS_ooxml::LN_EG_RangeMarkupElements_moveFromRangeEnd, "ooxml:EG_RangeMarkupElements_moveFromRangeEnd" },
    { NS_ooxml::LN_EG_RangeMarkupElements_moveToRangeEnd, "ooxml:EG_RangeMarkupElements_moveToRangeEnd" },
    { NS_ooxml::LN_CT_PermStart_id, "ooxml:CT_PermStart_id" },
    { NS_ooxml::LN_CT_PermStart_colFirst, "ooxml:CT_PermStart_colFirst" },
    { NS_ooxml::LN_CT_PermStart_colLast, "ooxml:CT_PermStart_colLast" },
    { NS_ooxml::LN_CT_PermStart_ed, "ooxml:CT_PermStart_ed" },
    { NS_ooxml::LN_CT_PermStart_edGrp, "ooxml:CT_PermStart_edGrp" },
    { NS_ooxml::LN_CT_PermStart_displacedByCustomXml, "ooxml:CT_PermStart_displacedByCustomXml" },
    { NS_ooxml::LN_CT_PermEnd_id, "ooxml:CT_PermEnd_id" },
    { NS_ooxml::LN_CT_PermEnd_displacedByCustomXml, "ooxml:CT_PermEnd_displacedByCustomXml" },
    { NS_ooxml::LN_EG_RangeMarkupElements_commentRangeStart, "ooxml:EG_RangeMarkupElements_commentRangeStart" },
    { NS_ooxml::LN_EG_RangeMarkupElements_commentRangeEnd, "ooxml:EG_RangeMarkupElements_commentRangeEnd" },
    { NS_ooxml::LN_CT_BookmarkRange_colFirst, "ooxml:CT_BookmarkRange_colFirst" },
    { NS_ooxml::LN_CT_BookmarkRange_colLast, "ooxml:CT_BookmarkRange_colLast" },
    { NS_ooxml::LN_CT_Bookmark_name, "ooxml:CT_Bookmark_name" },
    { NS_ooxml::LN_CT_MoveBookmark_author, "ooxml:CT_MoveBookmark_author" },
    { NS_ooxml::LN_CT_MoveBookmark_date, "ooxml:CT_MoveBookmark_date" },
    { NS_ooxml::LN_EG_RangeMarkupElements_moveFromRangeStart, "ooxml:EG_RangeMarkupElements_moveFromRangeStart" },
    { NS_ooxml::LN_EG_RangeMarkupElements_moveToRangeStart, "ooxml:EG_RangeMarkupElements_moveToRangeStart" },
    { NS_ooxml::LN_CT_Comment_initials, "ooxml:CT_Comment_initials" },
    { NS_ooxml::LN_CT_TrackChangeNumbering_original, "ooxml:CT_TrackChangeNumbering_original" },
    { NS_ooxml::LN_CT_TblPrExChange_tblPrEx, "ooxml:CT_TblPrExChange_tblPrEx" },
    { NS_ooxml::LN_CT_TcPrChange_tcPr, "ooxml:CT_TcPrChange_tcPr" },
    { NS_ooxml::LN_CT_TrPrChange_trPr, "ooxml:CT_TrPrChange_trPr" },
    { NS_ooxml::LN_CT_TblGridChange_tblGrid, "ooxml:CT_TblGridChange_tblGrid" },
    { NS_ooxml::LN_CT_TblPrChange_tblPr, "ooxml:CT_TblPrChange_tblPr" },
    { NS_ooxml::LN_CT_SectPrChange_sectPr, "ooxml:CT_SectPrChange_sectPr" },
    { NS_ooxml::LN_CT_PPrChange_pPr, "ooxml:CT_PPrChange_pPr" },
    { NS_ooxml::LN_CT_RPrChange_rPr, "ooxml:CT_RPrChange_rPr" },
    { NS_ooxml::LN_CT_ParaRPrChange_rPr, "ooxml:CT_ParaRPrChange_rPr" },
    { NS_ooxml::LN_EG_RangeMarkupElements_bookmarkStart, "ooxml:EG_RangeMarkupElements_bookmarkStart" },
    { NS_ooxml::LN_EG_RangeMarkupElements_bookmarkEnd, "ooxml:EG_RangeMarkupElements_bookmarkEnd" },
    { NS_ooxml::LN_EG_RangeMarkupElements_PermStart, "ooxml:EG_RangeMarkupElements_PermStart" },
    { NS_ooxml::LN_EG_RangeMarkupElements_PermEnd, "ooxml:EG_RangeMarkupElements_PermEnd" },
    { NS_ooxml::LN_CT_NumPr_ilvl, "ooxml:CT_NumPr_ilvl" },
    { NS_ooxml::LN_CT_NumPr_numId, "ooxml:CT_NumPr_numId" },
    { NS_ooxml::LN_CT_NumPr_numberingChange, "ooxml:CT_NumPr_numberingChange" },
    { NS_ooxml::LN_CT_NumPr_ins, "ooxml:CT_NumPr_ins" },
    { NS_ooxml::LN_CT_PBdr_top, "ooxml:CT_PBdr_top" },
    { NS_ooxml::LN_CT_PBdr_left, "ooxml:CT_PBdr_left" },
    { NS_ooxml::LN_CT_PBdr_bottom, "ooxml:CT_PBdr_bottom" },
    { NS_ooxml::LN_CT_PBdr_right, "ooxml:CT_PBdr_right" },
    { NS_ooxml::LN_CT_PBdr_between, "ooxml:CT_PBdr_between" },
    { NS_ooxml::LN_CT_PBdr_bar, "ooxml:CT_PBdr_bar" },
    { NS_ooxml::LN_CT_Tabs_tab, "ooxml:CT_Tabs_tab" },
    { NS_ooxml::LN_CT_TextboxTightWrap_val, "ooxml:CT_TextboxTightWrap_val" },
    { NS_ooxml::LN_CT_PPrBase_pStyle, "ooxml:CT_PPrBase_pStyle" },
    { NS_ooxml::LN_CT_PPrBase_keepNext, "ooxml:CT_PPrBase_keepNext" },
    { NS_ooxml::LN_CT_PPrBase_keepLines, "ooxml:CT_PPrBase_keepLines" },
    { NS_ooxml::LN_CT_PPrBase_pageBreakBefore, "ooxml:CT_PPrBase_pageBreakBefore" },
    { NS_ooxml::LN_CT_PPrBase_framePr, "ooxml:CT_PPrBase_framePr" },
    { NS_ooxml::LN_CT_PPrBase_widowControl, "ooxml:CT_PPrBase_widowControl" },
    { NS_ooxml::LN_CT_PPrBase_numPr, "ooxml:CT_PPrBase_numPr" },
    { NS_ooxml::LN_CT_PPrBase_suppressLineNumbers, "ooxml:CT_PPrBase_suppressLineNumbers" },
    { NS_ooxml::LN_CT_PrBase_pBdr, "ooxml:CT_PrBase_pBdr" },
    { NS_ooxml::LN_CT_PrBase_shd, "ooxml:CT_PrBase_shd" },
    { NS_ooxml::LN_CT_PPrBase_tabs, "ooxml:CT_PPrBase_tabs" },
    { NS_ooxml::LN_CT_PPrBase_suppressAutoHyphens, "ooxml:CT_PPrBase_suppressAutoHyphens" },
    { NS_ooxml::LN_CT_PPrBase_kinsoku, "ooxml:CT_PPrBase_kinsoku" },
    { NS_ooxml::LN_CT_PPrBase_wordWrap, "ooxml:CT_PPrBase_wordWrap" },
    { NS_ooxml::LN_CT_PPrBase_overflowPunct, "ooxml:CT_PPrBase_overflowPunct" },
    { NS_ooxml::LN_CT_PPrBase_topLinePunct, "ooxml:CT_PPrBase_topLinePunct" },
    { NS_ooxml::LN_CT_PPrBase_autoSpaceDE, "ooxml:CT_PPrBase_autoSpaceDE" },
    { NS_ooxml::LN_CT_PPrBase_autoSpaceDN, "ooxml:CT_PPrBase_autoSpaceDN" },
    { NS_ooxml::LN_CT_PPrBase_bidi, "ooxml:CT_PPrBase_bidi" },
    { NS_ooxml::LN_CT_PPrBase_adjustRightInd, "ooxml:CT_PPrBase_adjustRightInd" },
    { NS_ooxml::LN_CT_PPrBase_snapToGrid, "ooxml:CT_PPrBase_snapToGrid" },
    { NS_ooxml::LN_CT_PPrBase_spacing, "ooxml:CT_PPrBase_spacing" },
    { NS_ooxml::LN_CT_PPrBase_ind, "ooxml:CT_PPrBase_ind" },
    { NS_ooxml::LN_CT_PPrBase_contextualSpacing, "ooxml:CT_PPrBase_contextualSpacing" },
    { NS_ooxml::LN_CT_PPrBase_mirrorIndents, "ooxml:CT_PPrBase_mirrorIndents" },
    { NS_ooxml::LN_CT_PPrBase_suppressOverlap, "ooxml:CT_PPrBase_suppressOverlap" },
    { NS_ooxml::LN_CT_PPrBase_jc, "ooxml:CT_PPrBase_jc" },
    { NS_ooxml::LN_CT_PPrBase_textDirection, "ooxml:CT_PPrBase_textDirection" },
    { NS_ooxml::LN_CT_PPrBase_textAlignment, "ooxml:CT_PPrBase_textAlignment" },
    { NS_ooxml::LN_CT_PPrBase_textboxTightWrap, "ooxml:CT_PPrBase_textboxTightWrap" },
    { NS_ooxml::LN_CT_PPrBase_outlineLvl, "ooxml:CT_PPrBase_outlineLvl" },
    { NS_ooxml::LN_CT_PPrBase_divId, "ooxml:CT_PPrBase_divId" },
    { NS_ooxml::LN_CT_PPrBase_cnfStyle, "ooxml:CT_PPrBase_cnfStyle" },
    { NS_ooxml::LN_CT_PPr_rPr, "ooxml:CT_PPr_rPr" },
    { NS_ooxml::LN_CT_PPr_sectPr, "ooxml:CT_PPr_sectPr" },
    { NS_ooxml::LN_CT_PPr_pPrChange, "ooxml:CT_PPr_pPrChange" },
    { NS_ooxml::LN_CT_Background_color, "ooxml:CT_Background_color" },
    { NS_ooxml::LN_CT_Background_themeColor, "ooxml:CT_Background_themeColor" },
    { NS_ooxml::LN_CT_Background_themeTint, "ooxml:CT_Background_themeTint" },
    { NS_ooxml::LN_CT_Background_themeShade, "ooxml:CT_Background_themeShade" },
    { NS_ooxml::LN_CT_Background_v_background, "ooxml:CT_Background_v_background" },
    { NS_ooxml::LN_CT_Rel_id, "ooxml:CT_Rel_id" },
    { NS_ooxml::LN_CT_Object_dxaOrig, "ooxml:CT_Object_dxaOrig" },
    { NS_ooxml::LN_CT_Object_dyaOrig, "ooxml:CT_Object_dyaOrig" },
    { NS_ooxml::LN_CT_Picture_movie, "ooxml:CT_Picture_movie" },
    { NS_ooxml::LN_CT_SimpleField_fldData, "ooxml:CT_SimpleField_fldData" },
    { NS_ooxml::LN_CT_SimpleField_instr, "ooxml:CT_SimpleField_instr" },
    { NS_ooxml::LN_CT_SimpleField_fldLock, "ooxml:CT_SimpleField_fldLock" },
    { NS_ooxml::LN_CT_SimpleField_dirty, "ooxml:CT_SimpleField_dirty" },
    { NS_ooxml::LN_Value_ST_FldCharType_begin, "ooxml:Value_ST_FldCharType_begin" },
    { NS_ooxml::LN_Value_ST_FldCharType_separate, "ooxml:Value_ST_FldCharType_separate" },
    { NS_ooxml::LN_Value_ST_FldCharType_end, "ooxml:Value_ST_FldCharType_end" },
    { NS_ooxml::LN_Value_doc_ST_InfoTextType_text, "ooxml:Value_doc_ST_InfoTextType_text" },
    { NS_ooxml::LN_Value_doc_ST_InfoTextType_autoText, "ooxml:Value_doc_ST_InfoTextType_autoText" },
    { NS_ooxml::LN_CT_FFTextType_val, "ooxml:CT_FFTextType_val" },
    { NS_ooxml::LN_CT_FFName_val, "ooxml:CT_FFName_val" },
    { NS_ooxml::LN_CT_FldChar_fldData, "ooxml:CT_FldChar_fldData" },
    { NS_ooxml::LN_CT_FldChar_ffData, "ooxml:CT_FldChar_ffData" },
    { NS_ooxml::LN_CT_FldChar_numberingChange, "ooxml:CT_FldChar_numberingChange" },
    { NS_ooxml::LN_CT_FldChar_fldCharType, "ooxml:CT_FldChar_fldCharType" },
    { NS_ooxml::LN_CT_FldChar_fldLock, "ooxml:CT_FldChar_fldLock" },
    { NS_ooxml::LN_CT_FldChar_dirty, "ooxml:CT_FldChar_dirty" },
    { NS_ooxml::LN_CT_Hyperlink_tgtFrame, "ooxml:CT_Hyperlink_tgtFrame" },
    { NS_ooxml::LN_CT_Hyperlink_tooltip, "ooxml:CT_Hyperlink_tooltip" },
    { NS_ooxml::LN_CT_Hyperlink_docLocation, "ooxml:CT_Hyperlink_docLocation" },
    { NS_ooxml::LN_CT_Hyperlink_history, "ooxml:CT_Hyperlink_history" },
    { NS_ooxml::LN_CT_Hyperlink_anchor, "ooxml:CT_Hyperlink_anchor" },
    { NS_ooxml::LN_CT_FFData_name, "ooxml:CT_FFData_name" },
    { NS_ooxml::LN_CT_FFData_enabled, "ooxml:CT_FFData_enabled" },
    { NS_ooxml::LN_CT_FFData_calcOnExit, "ooxml:CT_FFData_calcOnExit" },
    { NS_ooxml::LN_CT_FFData_entryMacro, "ooxml:CT_FFData_entryMacro" },
    { NS_ooxml::LN_CT_FFData_exitMacro, "ooxml:CT_FFData_exitMacro" },
    { NS_ooxml::LN_CT_FFData_helpText, "ooxml:CT_FFData_helpText" },
    { NS_ooxml::LN_CT_FFData_statusText, "ooxml:CT_FFData_statusText" },
    { NS_ooxml::LN_CT_FFData_checkBox, "ooxml:CT_FFData_checkBox" },
    { NS_ooxml::LN_CT_FFData_ddList, "ooxml:CT_FFData_ddList" },
    { NS_ooxml::LN_CT_FFData_textInput, "ooxml:CT_FFData_textInput" },
    { NS_ooxml::LN_CT_FFHelpText_type, "ooxml:CT_FFHelpText_type" },
    { NS_ooxml::LN_CT_FFHelpText_val, "ooxml:CT_FFHelpText_val" },
    { NS_ooxml::LN_CT_FFStatusText_type, "ooxml:CT_FFStatusText_type" },
    { NS_ooxml::LN_CT_FFStatusText_val, "ooxml:CT_FFStatusText_val" },
    { NS_ooxml::LN_CT_FFCheckBox_size, "ooxml:CT_FFCheckBox_size" },
    { NS_ooxml::LN_CT_FFCheckBox_sizeAuto, "ooxml:CT_FFCheckBox_sizeAuto" },
    { NS_ooxml::LN_CT_FFCheckBox_default, "ooxml:CT_FFCheckBox_default" },
    { NS_ooxml::LN_CT_FFCheckBox_checked, "ooxml:CT_FFCheckBox_checked" },
    { NS_ooxml::LN_CT_FFDDList_result, "ooxml:CT_FFDDList_result" },
    { NS_ooxml::LN_CT_FFDDList_default, "ooxml:CT_FFDDList_default" },
    { NS_ooxml::LN_CT_FFDDList_listEntry, "ooxml:CT_FFDDList_listEntry" },
    { NS_ooxml::LN_CT_FFTextInput_type, "ooxml:CT_FFTextInput_type" },
    { NS_ooxml::LN_CT_FFTextInput_default, "ooxml:CT_FFTextInput_default" },
    { NS_ooxml::LN_CT_FFTextInput_maxLength, "ooxml:CT_FFTextInput_maxLength" },
    { NS_ooxml::LN_CT_FFTextInput_format, "ooxml:CT_FFTextInput_format" },
    { NS_ooxml::LN_Value_ST_SectionMark_continuous, "ooxml:Value_ST_SectionMark_continuous" },
    { NS_ooxml::LN_Value_ST_SectionMark_nextColumn, "ooxml:Value_ST_SectionMark_nextColumn" },
    { NS_ooxml::LN_Value_ST_SectionMark_nextPage, "ooxml:Value_ST_SectionMark_nextPage" },
    { NS_ooxml::LN_Value_ST_SectionMark_evenPage, "ooxml:Value_ST_SectionMark_evenPage" },
    { NS_ooxml::LN_Value_ST_SectionMark_oddPage, "ooxml:Value_ST_SectionMark_oddPage" },
    { NS_ooxml::LN_CT_SectType_val, "ooxml:CT_SectType_val" },
    { NS_ooxml::LN_Value_ST_NumberFormat_decimal, "ooxml:Value_ST_NumberFormat_decimal" },
    { NS_ooxml::LN_Value_ST_NumberFormat_upperRoman, "ooxml:Value_ST_NumberFormat_upperRoman" },
    { NS_ooxml::LN_Value_ST_NumberFormat_lowerRoman, "ooxml:Value_ST_NumberFormat_lowerRoman" },
    { NS_ooxml::LN_Value_ST_NumberFormat_upperLetter, "ooxml:Value_ST_NumberFormat_upperLetter" },
    { NS_ooxml::LN_Value_ST_NumberFormat_lowerLetter, "ooxml:Value_ST_NumberFormat_lowerLetter" },
    { NS_ooxml::LN_Value_ST_NumberFormat_ordinal, "ooxml:Value_ST_NumberFormat_ordinal" },
    { NS_ooxml::LN_Value_ST_NumberFormat_cardinalText, "ooxml:Value_ST_NumberFormat_cardinalText" },
    { NS_ooxml::LN_Value_ST_NumberFormat_ordinalText, "ooxml:Value_ST_NumberFormat_ordinalText" },
    { NS_ooxml::LN_Value_ST_NumberFormat_hex, "ooxml:Value_ST_NumberFormat_hex" },
    { NS_ooxml::LN_Value_ST_NumberFormat_chicago, "ooxml:Value_ST_NumberFormat_chicago" },
    { NS_ooxml::LN_Value_ST_NumberFormat_ideographDigital, "ooxml:Value_ST_NumberFormat_ideographDigital" },
    { NS_ooxml::LN_Value_ST_NumberFormat_japaneseCounting, "ooxml:Value_ST_NumberFormat_japaneseCounting" },
    { NS_ooxml::LN_Value_ST_NumberFormat_aiueo, "ooxml:Value_ST_NumberFormat_aiueo" },
    { NS_ooxml::LN_Value_ST_NumberFormat_iroha, "ooxml:Value_ST_NumberFormat_iroha" },
    { NS_ooxml::LN_Value_ST_NumberFormat_decimalFullWidth, "ooxml:Value_ST_NumberFormat_decimalFullWidth" },
    { NS_ooxml::LN_Value_ST_NumberFormat_decimalHalfWidth, "ooxml:Value_ST_NumberFormat_decimalHalfWidth" },
    { NS_ooxml::LN_Value_ST_NumberFormat_japaneseLegal, "ooxml:Value_ST_NumberFormat_japaneseLegal" },
    { NS_ooxml::LN_Value_ST_NumberFormat_japaneseDigitalTenThousand, "ooxml:Value_ST_NumberFormat_japaneseDigitalTenThousand" },
    { NS_ooxml::LN_Value_ST_NumberFormat_decimalEnclosedCircle, "ooxml:Value_ST_NumberFormat_decimalEnclosedCircle" },
    { NS_ooxml::LN_Value_ST_NumberFormat_decimalFullWidth2, "ooxml:Value_ST_NumberFormat_decimalFullWidth2" },
    { NS_ooxml::LN_Value_ST_NumberFormat_aiueoFullWidth, "ooxml:Value_ST_NumberFormat_aiueoFullWidth" },
    { NS_ooxml::LN_Value_ST_NumberFormat_irohaFullWidth, "ooxml:Value_ST_NumberFormat_irohaFullWidth" },
    { NS_ooxml::LN_Value_ST_NumberFormat_decimalZero, "ooxml:Value_ST_NumberFormat_decimalZero" },
    { NS_ooxml::LN_Value_ST_NumberFormat_bullet, "ooxml:Value_ST_NumberFormat_bullet" },
    { NS_ooxml::LN_Value_ST_NumberFormat_ganada, "ooxml:Value_ST_NumberFormat_ganada" },
    { NS_ooxml::LN_Value_ST_NumberFormat_chosung, "ooxml:Value_ST_NumberFormat_chosung" },
    { NS_ooxml::LN_Value_ST_NumberFormat_decimalEnclosedFullstop, "ooxml:Value_ST_NumberFormat_decimalEnclosedFullstop" },
    { NS_ooxml::LN_Value_ST_NumberFormat_decimalEnclosedParen, "ooxml:Value_ST_NumberFormat_decimalEnclosedParen" },
    { NS_ooxml::LN_Value_ST_NumberFormat_decimalEnclosedCircleChinese, "ooxml:Value_ST_NumberFormat_decimalEnclosedCircleChinese" },
    { NS_ooxml::LN_Value_ST_NumberFormat_ideographEnclosedCircle, "ooxml:Value_ST_NumberFormat_ideographEnclosedCircle" },
    { NS_ooxml::LN_Value_ST_NumberFormat_ideographTraditional, "ooxml:Value_ST_NumberFormat_ideographTraditional" },
    { NS_ooxml::LN_Value_ST_NumberFormat_ideographZodiac, "ooxml:Value_ST_NumberFormat_ideographZodiac" },
    { NS_ooxml::LN_Value_ST_NumberFormat_ideographZodiacTraditional, "ooxml:Value_ST_NumberFormat_ideographZodiacTraditional" },
    { NS_ooxml::LN_Value_ST_NumberFormat_taiwaneseCounting, "ooxml:Value_ST_NumberFormat_taiwaneseCounting" },
    { NS_ooxml::LN_Value_ST_NumberFormat_ideographLegalTraditional, "ooxml:Value_ST_NumberFormat_ideographLegalTraditional" },
    { NS_ooxml::LN_Value_ST_NumberFormat_taiwaneseCountingThousand, "ooxml:Value_ST_NumberFormat_taiwaneseCountingThousand" },
    { NS_ooxml::LN_Value_ST_NumberFormat_taiwaneseDigital, "ooxml:Value_ST_NumberFormat_taiwaneseDigital" },
    { NS_ooxml::LN_Value_ST_NumberFormat_chineseCounting, "ooxml:Value_ST_NumberFormat_chineseCounting" },
    { NS_ooxml::LN_Value_ST_NumberFormat_chineseLegalSimplified, "ooxml:Value_ST_NumberFormat_chineseLegalSimplified" },
    { NS_ooxml::LN_Value_ST_NumberFormat_chineseCountingThousand, "ooxml:Value_ST_NumberFormat_chineseCountingThousand" },
    { NS_ooxml::LN_Value_ST_NumberFormat_koreanDigital, "ooxml:Value_ST_NumberFormat_koreanDigital" },
    { NS_ooxml::LN_Value_ST_NumberFormat_koreanCounting, "ooxml:Value_ST_NumberFormat_koreanCounting" },
    { NS_ooxml::LN_Value_ST_NumberFormat_koreanLegal, "ooxml:Value_ST_NumberFormat_koreanLegal" },
    { NS_ooxml::LN_Value_ST_NumberFormat_koreanDigital2, "ooxml:Value_ST_NumberFormat_koreanDigital2" },
    { NS_ooxml::LN_Value_ST_NumberFormat_vietnameseCounting, "ooxml:Value_ST_NumberFormat_vietnameseCounting" },
    { NS_ooxml::LN_Value_ST_NumberFormat_russianLower, "ooxml:Value_ST_NumberFormat_russianLower" },
    { NS_ooxml::LN_Value_ST_NumberFormat_russianUpper, "ooxml:Value_ST_NumberFormat_russianUpper" },
    { NS_ooxml::LN_Value_ST_NumberFormat_none, "ooxml:Value_ST_NumberFormat_none" },
    { NS_ooxml::LN_Value_ST_NumberFormat_numberInDash, "ooxml:Value_ST_NumberFormat_numberInDash" },
    { NS_ooxml::LN_Value_ST_NumberFormat_hebrew1, "ooxml:Value_ST_NumberFormat_hebrew1" },
    { NS_ooxml::LN_Value_ST_NumberFormat_hebrew2, "ooxml:Value_ST_NumberFormat_hebrew2" },
    { NS_ooxml::LN_Value_ST_NumberFormat_arabicAlpha, "ooxml:Value_ST_NumberFormat_arabicAlpha" },
    { NS_ooxml::LN_Value_ST_NumberFormat_arabicAbjad, "ooxml:Value_ST_NumberFormat_arabicAbjad" },
    { NS_ooxml::LN_Value_ST_NumberFormat_hindiVowels, "ooxml:Value_ST_NumberFormat_hindiVowels" },
    { NS_ooxml::LN_Value_ST_NumberFormat_hindiConsonants, "ooxml:Value_ST_NumberFormat_hindiConsonants" },
    { NS_ooxml::LN_Value_ST_NumberFormat_hindiNumbers, "ooxml:Value_ST_NumberFormat_hindiNumbers" },
    { NS_ooxml::LN_Value_ST_NumberFormat_hindiCounting, "ooxml:Value_ST_NumberFormat_hindiCounting" },
    { NS_ooxml::LN_Value_ST_NumberFormat_thaiLetters, "ooxml:Value_ST_NumberFormat_thaiLetters" },
    { NS_ooxml::LN_Value_ST_NumberFormat_thaiNumbers, "ooxml:Value_ST_NumberFormat_thaiNumbers" },
    { NS_ooxml::LN_Value_ST_NumberFormat_thaiCounting, "ooxml:Value_ST_NumberFormat_thaiCounting" },
    { NS_ooxml::LN_Value_ST_NumberFormat_custom, "ooxml:Value_ST_NumberFormat_custom" },
    { NS_ooxml::LN_Value_ST_PageOrientation_portrait, "ooxml:Value_ST_PageOrientation_portrait" },
    { NS_ooxml::LN_Value_ST_PageOrientation_landscape, "ooxml:Value_ST_PageOrientation_landscape" },
    { NS_ooxml::LN_CT_PageSz_w, "ooxml:CT_PageSz_w" },
    { NS_ooxml::LN_CT_PageSz_h, "ooxml:CT_PageSz_h" },
    { NS_ooxml::LN_CT_PageSz_orient, "ooxml:CT_PageSz_orient" },
    { NS_ooxml::LN_CT_PageSz_code, "ooxml:CT_PageSz_code" },
    { NS_ooxml::LN_CT_PageMar_top, "ooxml:CT_PageMar_top" },
    { NS_ooxml::LN_CT_PageMar_right, "ooxml:CT_PageMar_right" },
    { NS_ooxml::LN_CT_PageMar_bottom, "ooxml:CT_PageMar_bottom" },
    { NS_ooxml::LN_CT_PageMar_left, "ooxml:CT_PageMar_left" },
    { NS_ooxml::LN_CT_PageMar_header, "ooxml:CT_PageMar_header" },
    { NS_ooxml::LN_CT_PageMar_footer, "ooxml:CT_PageMar_footer" },
    { NS_ooxml::LN_CT_PageMar_gutter, "ooxml:CT_PageMar_gutter" },
    { NS_ooxml::LN_CT_PaperSource_first, "ooxml:CT_PaperSource_first" },
    { NS_ooxml::LN_CT_PaperSource_other, "ooxml:CT_PaperSource_other" },
    { NS_ooxml::LN_Value_doc_ST_PageBorderZOrder_front, "ooxml:Value_doc_ST_PageBorderZOrder_front" },
    { NS_ooxml::LN_Value_doc_ST_PageBorderZOrder_back, "ooxml:Value_doc_ST_PageBorderZOrder_back" },
    { NS_ooxml::LN_Value_doc_ST_PageBorderDisplay_allPages, "ooxml:Value_doc_ST_PageBorderDisplay_allPages" },
    { NS_ooxml::LN_Value_doc_ST_PageBorderDisplay_firstPage, "ooxml:Value_doc_ST_PageBorderDisplay_firstPage" },
    { NS_ooxml::LN_Value_doc_ST_PageBorderDisplay_notFirstPage, "ooxml:Value_doc_ST_PageBorderDisplay_notFirstPage" },
    { NS_ooxml::LN_Value_doc_ST_PageBorderOffset_page, "ooxml:Value_doc_ST_PageBorderOffset_page" },
    { NS_ooxml::LN_Value_doc_ST_PageBorderOffset_text, "ooxml:Value_doc_ST_PageBorderOffset_text" },
    { NS_ooxml::LN_CT_PageBorders_top, "ooxml:CT_PageBorders_top" },
    { NS_ooxml::LN_CT_PageBorders_left, "ooxml:CT_PageBorders_left" },
    { NS_ooxml::LN_CT_PageBorders_bottom, "ooxml:CT_PageBorders_bottom" },
    { NS_ooxml::LN_CT_PageBorders_right, "ooxml:CT_PageBorders_right" },
    { NS_ooxml::LN_CT_PageBorders_zOrder, "ooxml:CT_PageBorders_zOrder" },
    { NS_ooxml::LN_CT_PageBorders_display, "ooxml:CT_PageBorders_display" },
    { NS_ooxml::LN_CT_PageBorders_offsetFrom, "ooxml:CT_PageBorders_offsetFrom" },
    { NS_ooxml::LN_Value_ST_ChapterSep_hyphen, "ooxml:Value_ST_ChapterSep_hyphen" },
    { NS_ooxml::LN_Value_ST_ChapterSep_period, "ooxml:Value_ST_ChapterSep_period" },
    { NS_ooxml::LN_Value_ST_ChapterSep_colon, "ooxml:Value_ST_ChapterSep_colon" },
    { NS_ooxml::LN_Value_ST_ChapterSep_emDash, "ooxml:Value_ST_ChapterSep_emDash" },
    { NS_ooxml::LN_Value_ST_ChapterSep_enDash, "ooxml:Value_ST_ChapterSep_enDash" },
    { NS_ooxml::LN_Value_ST_LineNumberRestart_newPage, "ooxml:Value_ST_LineNumberRestart_newPage" },
    { NS_ooxml::LN_Value_ST_LineNumberRestart_newSection, "ooxml:Value_ST_LineNumberRestart_newSection" },
    { NS_ooxml::LN_Value_ST_LineNumberRestart_continuous, "ooxml:Value_ST_LineNumberRestart_continuous" },
    { NS_ooxml::LN_CT_LineNumber_countBy, "ooxml:CT_LineNumber_countBy" },
    { NS_ooxml::LN_CT_LineNumber_start, "ooxml:CT_LineNumber_start" },
    { NS_ooxml::LN_CT_LineNumber_distance, "ooxml:CT_LineNumber_distance" },
    { NS_ooxml::LN_CT_LineNumber_restart, "ooxml:CT_LineNumber_restart" },
    { NS_ooxml::LN_CT_PageNumber_fmt, "ooxml:CT_PageNumber_fmt" },
    { NS_ooxml::LN_CT_PageNumber_start, "ooxml:CT_PageNumber_start" },
    { NS_ooxml::LN_CT_PageNumber_chapStyle, "ooxml:CT_PageNumber_chapStyle" },
    { NS_ooxml::LN_CT_PageNumber_chapSep, "ooxml:CT_PageNumber_chapSep" },
    { NS_ooxml::LN_CT_Column_space, "ooxml:CT_Column_space" },
    { NS_ooxml::LN_CT_Column_w, "ooxml:CT_Column_w" },
    { NS_ooxml::LN_CT_Columns_equalWidth, "ooxml:CT_Columns_equalWidth" },
    { NS_ooxml::LN_CT_Columns_space, "ooxml:CT_Columns_space" },
    { NS_ooxml::LN_CT_Columns_num, "ooxml:CT_Columns_num" },
    { NS_ooxml::LN_CT_Columns_sep, "ooxml:CT_Columns_sep" },
    { NS_ooxml::LN_CT_Columns_col, "ooxml:CT_Columns_col" },
    { NS_ooxml::LN_Value_ST_VerticalJc_top, "ooxml:Value_ST_VerticalJc_top" },
    { NS_ooxml::LN_Value_ST_VerticalJc_center, "ooxml:Value_ST_VerticalJc_center" },
    { NS_ooxml::LN_Value_ST_VerticalJc_both, "ooxml:Value_ST_VerticalJc_both" },
    { NS_ooxml::LN_Value_ST_VerticalJc_bottom, "ooxml:Value_ST_VerticalJc_bottom" },
    { NS_ooxml::LN_CT_VerticalJc_val, "ooxml:CT_VerticalJc_val" },
    { NS_ooxml::LN_Value_doc_ST_DocGrid_default, "ooxml:Value_doc_ST_DocGrid_default" },
    { NS_ooxml::LN_Value_doc_ST_DocGrid_lines, "ooxml:Value_doc_ST_DocGrid_lines" },
    { NS_ooxml::LN_Value_doc_ST_DocGrid_linesAndChars, "ooxml:Value_doc_ST_DocGrid_linesAndChars" },
    { NS_ooxml::LN_Value_doc_ST_DocGrid_snapToChars, "ooxml:Value_doc_ST_DocGrid_snapToChars" },
    { NS_ooxml::LN_CT_DocGrid_type, "ooxml:CT_DocGrid_type" },
    { NS_ooxml::LN_CT_DocGrid_linePitch, "ooxml:CT_DocGrid_linePitch" },
    { NS_ooxml::LN_CT_DocGrid_charSpace, "ooxml:CT_DocGrid_charSpace" },
    { NS_ooxml::LN_Value_ST_HdrFtr_even, "ooxml:Value_ST_HdrFtr_even" },
    { NS_ooxml::LN_Value_ST_HdrFtr_default, "ooxml:Value_ST_HdrFtr_default" },
    { NS_ooxml::LN_Value_ST_HdrFtr_first, "ooxml:Value_ST_HdrFtr_first" },
    { NS_ooxml::LN_Value_doc_ST_FtnEdn_normal, "ooxml:Value_doc_ST_FtnEdn_normal" },
    { NS_ooxml::LN_Value_doc_ST_FtnEdn_separator, "ooxml:Value_doc_ST_FtnEdn_separator" },
    { NS_ooxml::LN_Value_doc_ST_FtnEdn_continuationSeparator, "ooxml:Value_doc_ST_FtnEdn_continuationSeparator" },
    { NS_ooxml::LN_Value_doc_ST_FtnEdn_continuationNotice, "ooxml:Value_doc_ST_FtnEdn_continuationNotice" },
    { NS_ooxml::LN_CT_HdrFtrRef_type, "ooxml:CT_HdrFtrRef_type" },
    { NS_ooxml::LN_CT_HdrFtrRef_id, "ooxml:CT_HdrFtrRef_id" },
    { NS_ooxml::LN_EG_HdrFtrReferences_headerReference, "ooxml:EG_HdrFtrReferences_headerReference" },
    { NS_ooxml::LN_EG_HdrFtrReferences_footerReference, "ooxml:EG_HdrFtrReferences_footerReference" },
    { NS_ooxml::LN_EG_SectPrContents_bidi, "ooxml:EG_SectPrContents_bidi" },
    { NS_ooxml::LN_EG_SectPrContents_cols, "ooxml:EG_SectPrContents_cols" },
    { NS_ooxml::LN_EG_SectPrContents_docGrid, "ooxml:EG_SectPrContents_docGrid" },
    { NS_ooxml::LN_EG_SectPrContents_endnotePr, "ooxml:EG_SectPrContents_endnotePr" },
    { NS_ooxml::LN_EG_SectPrContents_footnotePr, "ooxml:EG_SectPrContents_footnotePr" },
    { NS_ooxml::LN_EG_SectPrContents_formProt, "ooxml:EG_SectPrContents_formProt" },
    { NS_ooxml::LN_EG_SectPrContents_lnNumType, "ooxml:EG_SectPrContents_lnNumType" },
    { NS_ooxml::LN_EG_SectPrContents_noEndnote, "ooxml:EG_SectPrContents_noEndnote" },
    { NS_ooxml::LN_EG_SectPrContents_paperSrc, "ooxml:EG_SectPrContents_paperSrc" },
    { NS_ooxml::LN_EG_SectPrContents_pgBorders, "ooxml:EG_SectPrContents_pgBorders" },
    { NS_ooxml::LN_EG_SectPrContents_pgMar, "ooxml:EG_SectPrContents_pgMar" },
    { NS_ooxml::LN_EG_SectPrContents_pgNumType, "ooxml:EG_SectPrContents_pgNumType" },
    { NS_ooxml::LN_EG_SectPrContents_pgSz, "ooxml:EG_SectPrContents_pgSz" },
    { NS_ooxml::LN_EG_SectPrContents_printerSettings, "ooxml:EG_SectPrContents_printerSettings" },
    { NS_ooxml::LN_EG_SectPrContents_rtlGutter, "ooxml:EG_SectPrContents_rtlGutter" },
    { NS_ooxml::LN_EG_SectPrContents_textDirection, "ooxml:EG_SectPrContents_textDirection" },
    { NS_ooxml::LN_EG_SectPrContents_titlePg, "ooxml:EG_SectPrContents_titlePg" },
    { NS_ooxml::LN_EG_SectPrContents_type, "ooxml:EG_SectPrContents_type" },
    { NS_ooxml::LN_EG_SectPrContents_vAlign, "ooxml:EG_SectPrContents_vAlign" },
    { NS_ooxml::LN_CT_SectPr_sectPrChange, "ooxml:CT_SectPr_sectPrChange" },
    { NS_ooxml::LN_Value_ST_BrType_column, "ooxml:Value_ST_BrType_column" },
    { NS_ooxml::LN_Value_ST_BrType_page, "ooxml:Value_ST_BrType_page" },
    { NS_ooxml::LN_Value_ST_BrType_textWrapping, "ooxml:Value_ST_BrType_textWrapping" },
    { NS_ooxml::LN_Value_ST_BrClear_none, "ooxml:Value_ST_BrClear_none" },
    { NS_ooxml::LN_Value_ST_BrClear_left, "ooxml:Value_ST_BrClear_left" },
    { NS_ooxml::LN_Value_ST_BrClear_right, "ooxml:Value_ST_BrClear_right" },
    { NS_ooxml::LN_Value_ST_BrClear_all, "ooxml:Value_ST_BrClear_all" },
    { NS_ooxml::LN_CT_Br_type, "ooxml:CT_Br_type" },
    { NS_ooxml::LN_CT_Br_clear, "ooxml:CT_Br_clear" },
    { NS_ooxml::LN_Value_ST_PTabAlignment_left, "ooxml:Value_ST_PTabAlignment_left" },
    { NS_ooxml::LN_Value_ST_PTabAlignment_center, "ooxml:Value_ST_PTabAlignment_center" },
    { NS_ooxml::LN_Value_ST_PTabAlignment_right, "ooxml:Value_ST_PTabAlignment_right" },
    { NS_ooxml::LN_Value_ST_PTabRelativeTo_margin, "ooxml:Value_ST_PTabRelativeTo_margin" },
    { NS_ooxml::LN_Value_ST_PTabRelativeTo_indent, "ooxml:Value_ST_PTabRelativeTo_indent" },
    { NS_ooxml::LN_Value_ST_PTabLeader_none, "ooxml:Value_ST_PTabLeader_none" },
    { NS_ooxml::LN_Value_ST_PTabLeader_dot, "ooxml:Value_ST_PTabLeader_dot" },
    { NS_ooxml::LN_Value_ST_PTabLeader_hyphen, "ooxml:Value_ST_PTabLeader_hyphen" },
    { NS_ooxml::LN_Value_ST_PTabLeader_underscore, "ooxml:Value_ST_PTabLeader_underscore" },
    { NS_ooxml::LN_Value_ST_PTabLeader_middleDot, "ooxml:Value_ST_PTabLeader_middleDot" },
    { NS_ooxml::LN_CT_PTab_alignment, "ooxml:CT_PTab_alignment" },
    { NS_ooxml::LN_CT_PTab_relativeTo, "ooxml:CT_PTab_relativeTo" },
    { NS_ooxml::LN_CT_PTab_leader, "ooxml:CT_PTab_leader" },
    { NS_ooxml::LN_CT_Sym_font, "ooxml:CT_Sym_font" },
    { NS_ooxml::LN_CT_Sym_char, "ooxml:CT_Sym_char" },
    { NS_ooxml::LN_CT_Text_space, "ooxml:CT_Text_space" },
    { NS_ooxml::LN_EG_RunInnerContent_instrText, "ooxml:EG_RunInnerContent_instrText" },
    { NS_ooxml::LN_EG_RunInnerContent_delText, "ooxml:EG_RunInnerContent_delText" },
    { NS_ooxml::LN_EG_RunInnerContent_delInstrText, "ooxml:EG_RunInnerContent_delInstrText" },
    { NS_ooxml::LN_EG_RunInnerContent_br, "ooxml:EG_RunInnerContent_br" },
    { NS_ooxml::LN_EG_RunInnerContent_t, "ooxml:EG_RunInnerContent_t" },
    { NS_ooxml::LN_EG_RunInnerContent_r, "ooxml:EG_RunInnerContent_r" },
    { NS_ooxml::LN_EG_RunInnerContent_dayShort, "ooxml:EG_RunInnerContent_dayShort" },
    { NS_ooxml::LN_EG_RunInnerContent_monthShort, "ooxml:EG_RunInnerContent_monthShort" },
    { NS_ooxml::LN_EG_RunInnerContent_yearShort, "ooxml:EG_RunInnerContent_yearShort" },
    { NS_ooxml::LN_EG_RunInnerContent_dayLong, "ooxml:EG_RunInnerContent_dayLong" },
    { NS_ooxml::LN_EG_RunInnerContent_monthLong, "ooxml:EG_RunInnerContent_monthLong" },
    { NS_ooxml::LN_EG_RunInnerContent_yearLong, "ooxml:EG_RunInnerContent_yearLong" },
    { NS_ooxml::LN_EG_RunInnerContent_annotationRef, "ooxml:EG_RunInnerContent_annotationRef" },
    { NS_ooxml::LN_EG_RunInnerContent_footnoteRef, "ooxml:EG_RunInnerContent_footnoteRef" },
    { NS_ooxml::LN_EG_RunInnerContent_endnoteRef, "ooxml:EG_RunInnerContent_endnoteRef" },
    { NS_ooxml::LN_EG_RunInnerContent_separator, "ooxml:EG_RunInnerContent_separator" },
    { NS_ooxml::LN_EG_RunInnerContent_continuationSeparator, "ooxml:EG_RunInnerContent_continuationSeparator" },
    { NS_ooxml::LN_EG_RunInnerContent_sym, "ooxml:EG_RunInnerContent_sym" },
    { NS_ooxml::LN_EG_RunInnerContent_pgNum, "ooxml:EG_RunInnerContent_pgNum" },
    { NS_ooxml::LN_EG_RunInnerContent_tab, "ooxml:EG_RunInnerContent_tab" },
    { NS_ooxml::LN_EG_RunInnerContent_object, "ooxml:EG_RunInnerContent_object" },
    { NS_ooxml::LN_EG_RunInnerContent_pict, "ooxml:EG_RunInnerContent_pict" },
    { NS_ooxml::LN_EG_RunInnerContent_fldChar, "ooxml:EG_RunInnerContent_fldChar" },
    { NS_ooxml::LN_EG_RunInnerContent_ruby, "ooxml:EG_RunInnerContent_ruby" },
    { NS_ooxml::LN_EG_RunInnerContent_footnoteReference, "ooxml:EG_RunInnerContent_footnoteReference" },
    { NS_ooxml::LN_EG_RunInnerContent_endnoteReference, "ooxml:EG_RunInnerContent_endnoteReference" },
    { NS_ooxml::LN_EG_RunInnerContent_commentReference, "ooxml:EG_RunInnerContent_commentReference" },
    { NS_ooxml::LN_EG_RunInnerContent_drawing, "ooxml:EG_RunInnerContent_drawing" },
    { NS_ooxml::LN_EG_RunInnerContent_ptab, "ooxml:EG_RunInnerContent_ptab" },
    { NS_ooxml::LN_EG_RunInnerContent_lastRenderedPageBreak, "ooxml:EG_RunInnerContent_lastRenderedPageBreak" },
    { NS_ooxml::LN_EG_RubyContent_r, "ooxml:EG_RubyContent_r" },
    { NS_ooxml::LN_Value_ST_Hint_default, "ooxml:Value_ST_Hint_default" },
    { NS_ooxml::LN_Value_ST_Hint_eastAsia, "ooxml:Value_ST_Hint_eastAsia" },
    { NS_ooxml::LN_Value_ST_Hint_cs, "ooxml:Value_ST_Hint_cs" },
    { NS_ooxml::LN_Value_ST_Theme_majorEastAsia, "ooxml:Value_ST_Theme_majorEastAsia" },
    { NS_ooxml::LN_Value_ST_Theme_majorBidi, "ooxml:Value_ST_Theme_majorBidi" },
    { NS_ooxml::LN_Value_ST_Theme_majorAscii, "ooxml:Value_ST_Theme_majorAscii" },
    { NS_ooxml::LN_Value_ST_Theme_majorHAnsi, "ooxml:Value_ST_Theme_majorHAnsi" },
    { NS_ooxml::LN_Value_ST_Theme_minorEastAsia, "ooxml:Value_ST_Theme_minorEastAsia" },
    { NS_ooxml::LN_Value_ST_Theme_minorBidi, "ooxml:Value_ST_Theme_minorBidi" },
    { NS_ooxml::LN_Value_ST_Theme_minorAscii, "ooxml:Value_ST_Theme_minorAscii" },
    { NS_ooxml::LN_Value_ST_Theme_minorHAnsi, "ooxml:Value_ST_Theme_minorHAnsi" },
    { NS_ooxml::LN_CT_Fonts_hint, "ooxml:CT_Fonts_hint" },
    { NS_ooxml::LN_CT_Fonts_ascii, "ooxml:CT_Fonts_ascii" },
    { NS_ooxml::LN_CT_Fonts_hAnsi, "ooxml:CT_Fonts_hAnsi" },
    { NS_ooxml::LN_CT_Fonts_eastAsia, "ooxml:CT_Fonts_eastAsia" },
    { NS_ooxml::LN_CT_Fonts_cs, "ooxml:CT_Fonts_cs" },
    { NS_ooxml::LN_CT_Fonts_asciiTheme, "ooxml:CT_Fonts_asciiTheme" },
    { NS_ooxml::LN_CT_Fonts_hAnsiTheme, "ooxml:CT_Fonts_hAnsiTheme" },
    { NS_ooxml::LN_CT_Fonts_eastAsiaTheme, "ooxml:CT_Fonts_eastAsiaTheme" },
    { NS_ooxml::LN_CT_Fonts_cstheme, "ooxml:CT_Fonts_cstheme" },
    { NS_ooxml::LN_EG_RPrBase_rStyle, "ooxml:EG_RPrBase_rStyle" },
    { NS_ooxml::LN_EG_RPrBase_rFonts, "ooxml:EG_RPrBase_rFonts" },
    { NS_ooxml::LN_EG_RPrBase_b, "ooxml:EG_RPrBase_b" },
    { NS_ooxml::LN_EG_RPrBase_bCs, "ooxml:EG_RPrBase_bCs" },
    { NS_ooxml::LN_EG_RPrBase_i, "ooxml:EG_RPrBase_i" },
    { NS_ooxml::LN_EG_RPrBase_iCs, "ooxml:EG_RPrBase_iCs" },
    { NS_ooxml::LN_EG_RPrBase_caps, "ooxml:EG_RPrBase_caps" },
    { NS_ooxml::LN_EG_RPrBase_smallCaps, "ooxml:EG_RPrBase_smallCaps" },
    { NS_ooxml::LN_EG_RPrBase_strike, "ooxml:EG_RPrBase_strike" },
    { NS_ooxml::LN_EG_RPrBase_dstrike, "ooxml:EG_RPrBase_dstrike" },
    { NS_ooxml::LN_EG_RPrBase_outline, "ooxml:EG_RPrBase_outline" },
    { NS_ooxml::LN_EG_RPrBase_shadow, "ooxml:EG_RPrBase_shadow" },
    { NS_ooxml::LN_EG_RPrBase_emboss, "ooxml:EG_RPrBase_emboss" },
    { NS_ooxml::LN_EG_RPrBase_imprint, "ooxml:EG_RPrBase_imprint" },
    { NS_ooxml::LN_EG_RPrBase_noProof, "ooxml:EG_RPrBase_noProof" },
    { NS_ooxml::LN_EG_RPrBase_snapToGrid, "ooxml:EG_RPrBase_snapToGrid" },
    { NS_ooxml::LN_EG_RPrBase_vanish, "ooxml:EG_RPrBase_vanish" },
    { NS_ooxml::LN_EG_RPrBase_webHidden, "ooxml:EG_RPrBase_webHidden" },
    { NS_ooxml::LN_EG_RPrBase_color, "ooxml:EG_RPrBase_color" },
    { NS_ooxml::LN_EG_RPrBase_spacing, "ooxml:EG_RPrBase_spacing" },
    { NS_ooxml::LN_EG_RPrBase_w, "ooxml:EG_RPrBase_w" },
    { NS_ooxml::LN_EG_RPrBase_kern, "ooxml:EG_RPrBase_kern" },
    { NS_ooxml::LN_EG_RPrBase_position, "ooxml:EG_RPrBase_position" },
    { NS_ooxml::LN_EG_RPrBase_sz, "ooxml:EG_RPrBase_sz" },
    { NS_ooxml::LN_EG_RPrBase_szCs, "ooxml:EG_RPrBase_szCs" },
    { NS_ooxml::LN_EG_RPrBase_highlight, "ooxml:EG_RPrBase_highlight" },
    { NS_ooxml::LN_EG_RPrBase_u, "ooxml:EG_RPrBase_u" },
    { NS_ooxml::LN_EG_RPrBase_effect, "ooxml:EG_RPrBase_effect" },
    { NS_ooxml::LN_EG_RPrBase_bdr, "ooxml:EG_RPrBase_bdr" },
    { NS_ooxml::LN_EG_RPrBase_shd, "ooxml:EG_RPrBase_shd" },
    { NS_ooxml::LN_EG_RPrBase_fitText, "ooxml:EG_RPrBase_fitText" },
    { NS_ooxml::LN_EG_RPrBase_vertAlign, "ooxml:EG_RPrBase_vertAlign" },
    { NS_ooxml::LN_EG_RPrBase_rtl, "ooxml:EG_RPrBase_rtl" },
    { NS_ooxml::LN_EG_RPrBase_cs, "ooxml:EG_RPrBase_cs" },
    { NS_ooxml::LN_EG_RPrBase_em, "ooxml:EG_RPrBase_em" },
    { NS_ooxml::LN_EG_RPrBase_lang, "ooxml:EG_RPrBase_lang" },
    { NS_ooxml::LN_EG_RPrBase_eastAsianLayout, "ooxml:EG_RPrBase_eastAsianLayout" },
    { NS_ooxml::LN_EG_RPrBase_specVanish, "ooxml:EG_RPrBase_specVanish" },
    { NS_ooxml::LN_EG_RPrBase_oMath, "ooxml:EG_RPrBase_oMath" },
    { NS_ooxml::LN_EG_RPrBase_w14_glow, "ooxml:EG_RPrBase_w14_glow" },
    { NS_ooxml::LN_EG_RPrBase_w14_shadow, "ooxml:EG_RPrBase_w14_shadow" },
    { NS_ooxml::LN_EG_RPrBase_w14_reflection, "ooxml:EG_RPrBase_w14_reflection" },
    { NS_ooxml::LN_EG_RPrBase_w14_textOutline, "ooxml:EG_RPrBase_w14_textOutline" },
    { NS_ooxml::LN_EG_RPrBase_w14_textFill, "ooxml:EG_RPrBase_w14_textFill" },
    { NS_ooxml::LN_EG_RPrBase_w14_scene3d, "ooxml:EG_RPrBase_w14_scene3d" },
    { NS_ooxml::LN_EG_RPrBase_w14_props3d, "ooxml:EG_RPrBase_w14_props3d" },
    { NS_ooxml::LN_EG_RPrBase_w14_ligatures, "ooxml:EG_RPrBase_w14_ligatures" },
    { NS_ooxml::LN_EG_RPrBase_w14_numForm, "ooxml:EG_RPrBase_w14_numForm" },
    { NS_ooxml::LN_EG_RPrBase_w14_numSpacing, "ooxml:EG_RPrBase_w14_numSpacing" },
    { NS_ooxml::LN_EG_RPrBase_w14_stylisticSets, "ooxml:EG_RPrBase_w14_stylisticSets" },
    { NS_ooxml::LN_EG_RPrBase_w14_cntxtAlts, "ooxml:EG_RPrBase_w14_cntxtAlts" },
    { NS_ooxml::LN_EG_RPrContent_rPrChange, "ooxml:EG_RPrContent_rPrChange" },
    { NS_ooxml::LN_CT_ParaRPr_ins, "ooxml:CT_ParaRPr_ins" },
    { NS_ooxml::LN_CT_ParaRPr_del, "ooxml:CT_ParaRPr_del" },
    { NS_ooxml::LN_CT_ParaRPr_moveFrom, "ooxml:CT_ParaRPr_moveFrom" },
    { NS_ooxml::LN_CT_ParaRPr_moveTo, "ooxml:CT_ParaRPr_moveTo" },
    { NS_ooxml::LN_CT_ParaRPr_rPrChange, "ooxml:CT_ParaRPr_rPrChange" },
    { NS_ooxml::LN_CT_AltChunk, "ooxml:CT_AltChunk" },
    { NS_ooxml::LN_Value_ST_RubyAlign_center, "ooxml:Value_ST_RubyAlign_center" },
    { NS_ooxml::LN_Value_ST_RubyAlign_distributeLetter, "ooxml:Value_ST_RubyAlign_distributeLetter" },
    { NS_ooxml::LN_Value_ST_RubyAlign_distributeSpace, "ooxml:Value_ST_RubyAlign_distributeSpace" },
    { NS_ooxml::LN_Value_ST_RubyAlign_left, "ooxml:Value_ST_RubyAlign_left" },
    { NS_ooxml::LN_Value_ST_RubyAlign_right, "ooxml:Value_ST_RubyAlign_right" },
    { NS_ooxml::LN_Value_ST_RubyAlign_rightVertical, "ooxml:Value_ST_RubyAlign_rightVertical" },
    { NS_ooxml::LN_CT_RubyAlign_val, "ooxml:CT_RubyAlign_val" },
    { NS_ooxml::LN_CT_RubyPr_rubyAlign, "ooxml:CT_RubyPr_rubyAlign" },
    { NS_ooxml::LN_CT_RubyPr_hps, "ooxml:CT_RubyPr_hps" },
    { NS_ooxml::LN_CT_RubyPr_hpsRaise, "ooxml:CT_RubyPr_hpsRaise" },
    { NS_ooxml::LN_CT_RubyPr_hpsBaseText, "ooxml:CT_RubyPr_hpsBaseText" },
    { NS_ooxml::LN_CT_RubyPr_lid, "ooxml:CT_RubyPr_lid" },
    { NS_ooxml::LN_CT_RubyPr_dirty, "ooxml:CT_RubyPr_dirty" },
    { NS_ooxml::LN_CT_RubyPr, "ooxml:CT_RubyPr" },
    { NS_ooxml::LN_CT_Ruby_rt, "ooxml:CT_Ruby_rt" },
    { NS_ooxml::LN_CT_Ruby_rubyBase, "ooxml:CT_Ruby_rubyBase" },
    { NS_ooxml::LN_CT_Lock_val, "ooxml:CT_Lock_val" },
    { NS_ooxml::LN_CT_SdtDateMappingType_val, "ooxml:CT_SdtDateMappingType_val" },
    { NS_ooxml::LN_CT_CalendarType_val, "ooxml:CT_CalendarType_val" },
    { NS_ooxml::LN_CT_SdtText_multiLine, "ooxml:CT_SdtText_multiLine" },
    { NS_ooxml::LN_CT_SdtPlaceholder_docPart, "ooxml:CT_SdtPlaceholder_docPart" },
    { NS_ooxml::LN_CT_DataBinding_prefixMappings, "ooxml:CT_DataBinding_prefixMappings" },
    { NS_ooxml::LN_CT_DataBinding_xpath, "ooxml:CT_DataBinding_xpath" },
    { NS_ooxml::LN_CT_DataBinding_storeItemID, "ooxml:CT_DataBinding_storeItemID" },
    { NS_ooxml::LN_CT_SdtColor_val, "ooxml:CT_SdtColor_val" },
    { NS_ooxml::LN_CT_SdtAppearance_val, "ooxml:CT_SdtAppearance_val" },
    { NS_ooxml::LN_CT_SdtPr_rPr, "ooxml:CT_SdtPr_rPr" },
    { NS_ooxml::LN_CT_SdtPr_alias, "ooxml:CT_SdtPr_alias" },
    { NS_ooxml::LN_CT_SdtPr_lock, "ooxml:CT_SdtPr_lock" },
    { NS_ooxml::LN_CT_SdtPr_placeholder, "ooxml:CT_SdtPr_placeholder" },
    { NS_ooxml::LN_CT_SdtPr_showingPlcHdr, "ooxml:CT_SdtPr_showingPlcHdr" },
    { NS_ooxml::LN_CT_SdtPr_dataBinding, "ooxml:CT_SdtPr_dataBinding" },
    { NS_ooxml::LN_CT_SdtPr_temporary, "ooxml:CT_SdtPr_temporary" },
    { NS_ooxml::LN_CT_SdtPr_id, "ooxml:CT_SdtPr_id" },
    { NS_ooxml::LN_CT_SdtPr_tabIndex, "ooxml:CT_SdtPr_tabIndex" },
    { NS_ooxml::LN_CT_SdtPr_tag, "ooxml:CT_SdtPr_tag" },
    { NS_ooxml::LN_CT_SdtPr_equation, "ooxml:CT_SdtPr_equation" },
    { NS_ooxml::LN_CT_SdtPr_comboBox, "ooxml:CT_SdtPr_comboBox" },
    { NS_ooxml::LN_CT_SdtPr_checkbox, "ooxml:CT_SdtPr_checkbox" },
    { NS_ooxml::LN_CT_SdtPr_date, "ooxml:CT_SdtPr_date" },
    { NS_ooxml::LN_CT_SdtPr_docPartObj, "ooxml:CT_SdtPr_docPartObj" },
    { NS_ooxml::LN_CT_SdtPr_docPartList, "ooxml:CT_SdtPr_docPartList" },
    { NS_ooxml::LN_CT_SdtPr_dropDownList, "ooxml:CT_SdtPr_dropDownList" },
    { NS_ooxml::LN_CT_SdtPr_picture, "ooxml:CT_SdtPr_picture" },
    { NS_ooxml::LN_CT_SdtPr_richText, "ooxml:CT_SdtPr_richText" },
    { NS_ooxml::LN_CT_SdtPr_text, "ooxml:CT_SdtPr_text" },
    { NS_ooxml::LN_CT_SdtPr_citation, "ooxml:CT_SdtPr_citation" },
    { NS_ooxml::LN_CT_SdtPr_group, "ooxml:CT_SdtPr_group" },
    { NS_ooxml::LN_CT_SdtPr_bibliography, "ooxml:CT_SdtPr_bibliography" },
    { NS_ooxml::LN_CT_SdtPr_color, "ooxml:CT_SdtPr_color" },
    { NS_ooxml::LN_CT_SdtPr_appearance, "ooxml:CT_SdtPr_appearance" },
    { NS_ooxml::LN_CT_SdtEndPr_rPr, "ooxml:CT_SdtEndPr_rPr" },
    { NS_ooxml::LN_CT_DirContentRun_val, "ooxml:CT_DirContentRun_val" },
    { NS_ooxml::LN_Value_ST_Direction_ltr, "ooxml:Value_ST_Direction_ltr" },
    { NS_ooxml::LN_Value_ST_Direction_rtl, "ooxml:Value_ST_Direction_rtl" },
    { NS_ooxml::LN_CT_SdtBlock_sdtPr, "ooxml:CT_SdtBlock_sdtPr" },
    { NS_ooxml::LN_CT_SdtBlock_sdtEndPr, "ooxml:CT_SdtBlock_sdtEndPr" },
    { NS_ooxml::LN_CT_SdtBlock_sdtContent, "ooxml:CT_SdtBlock_sdtContent" },
    { NS_ooxml::LN_CT_SdtBlock_sdtEndContent, "ooxml:CT_SdtBlock_sdtEndContent" },
    { NS_ooxml::LN_CT_SdtRun_sdtPr, "ooxml:CT_SdtRun_sdtPr" },
    { NS_ooxml::LN_CT_SdtRun_sdtEndPr, "ooxml:CT_SdtRun_sdtEndPr" },
    { NS_ooxml::LN_CT_SdtRun_sdtContent, "ooxml:CT_SdtRun_sdtContent" },
    { NS_ooxml::LN_CT_SdtRun_sdtEndContent, "ooxml:CT_SdtRun_sdtEndContent" },
    { NS_ooxml::LN_CT_SdtCell_sdtPr, "ooxml:CT_SdtCell_sdtPr" },
    { NS_ooxml::LN_CT_SdtCell_sdtEndPr, "ooxml:CT_SdtCell_sdtEndPr" },
    { NS_ooxml::LN_CT_SdtCell_sdtContent, "ooxml:CT_SdtCell_sdtContent" },
    { NS_ooxml::LN_CT_SdtRow_sdtPr, "ooxml:CT_SdtRow_sdtPr" },
    { NS_ooxml::LN_CT_SdtRow_sdtEndPr, "ooxml:CT_SdtRow_sdtEndPr" },
    { NS_ooxml::LN_CT_SdtRow_sdtContent, "ooxml:CT_SdtRow_sdtContent" },
    { NS_ooxml::LN_CT_SdtDropDownList_listItem, "ooxml:CT_SdtDropDownList_listItem" },
    { NS_ooxml::LN_CT_SdtDate_fullDate, "ooxml:CT_SdtDate_fullDate" },
    { NS_ooxml::LN_CT_SdtDate_dateFormat, "ooxml:CT_SdtDate_dateFormat" },
    { NS_ooxml::LN_CT_SdtDate_lid, "ooxml:CT_SdtDate_lid" },
    { NS_ooxml::LN_CT_SdtDate_storeMappedDataAs, "ooxml:CT_SdtDate_storeMappedDataAs" },
    { NS_ooxml::LN_CT_SdtDate_calendar, "ooxml:CT_SdtDate_calendar" },
    { NS_ooxml::LN_CT_SdtDocPart_docPartGallery, "ooxml:CT_SdtDocPart_docPartGallery" },
    { NS_ooxml::LN_CT_SdtDocPart_docPartCategory, "ooxml:CT_SdtDocPart_docPartCategory" },
    { NS_ooxml::LN_CT_SdtDocPart_docPartUnique, "ooxml:CT_SdtDocPart_docPartUnique" },
    { NS_ooxml::LN_CT_SdtListItem_displayText, "ooxml:CT_SdtListItem_displayText" },
    { NS_ooxml::LN_CT_SdtListItem_value, "ooxml:CT_SdtListItem_value" },
    { NS_ooxml::LN_CT_SdtPlaceholder_docPart_val, "ooxml:CT_SdtPlaceholder_docPart_val" },
    { NS_ooxml::LN_CT_Attr_uri, "ooxml:CT_Attr_uri" },
    { NS_ooxml::LN_CT_Attr_name, "ooxml:CT_Attr_name" },
    { NS_ooxml::LN_CT_Attr_val, "ooxml:CT_Attr_val" },
    { NS_ooxml::LN_CT_CustomXmlRun_customXmlPr, "ooxml:CT_CustomXmlRun_customXmlPr" },
    { NS_ooxml::LN_CT_CustomXmlRun_uri, "ooxml:CT_CustomXmlRun_uri" },
    { NS_ooxml::LN_CT_CustomXmlRun_element, "ooxml:CT_CustomXmlRun_element" },
    { NS_ooxml::LN_CT_CustomXmlBlock_customXmlPr, "ooxml:CT_CustomXmlBlock_customXmlPr" },
    { NS_ooxml::LN_CT_CustomXmlBlock_uri, "ooxml:CT_CustomXmlBlock_uri" },
    { NS_ooxml::LN_CT_CustomXmlBlock_element, "ooxml:CT_CustomXmlBlock_element" },
    { NS_ooxml::LN_CT_CustomXmlCell_customXmlPr, "ooxml:CT_CustomXmlCell_customXmlPr" },
    { NS_ooxml::LN_CT_CustomXmlCell_uri, "ooxml:CT_CustomXmlCell_uri" },
    { NS_ooxml::LN_CT_CustomXmlCell_element, "ooxml:CT_CustomXmlCell_element" },
    { NS_ooxml::LN_CT_CustomXmlRow_customXmlPr, "ooxml:CT_CustomXmlRow_customXmlPr" },
    { NS_ooxml::LN_CT_CustomXmlRow_uri, "ooxml:CT_CustomXmlRow_uri" },
    { NS_ooxml::LN_CT_CustomXmlRow_element, "ooxml:CT_CustomXmlRow_element" },
    { NS_ooxml::LN_CT_SmartTagRun_smartTagPr, "ooxml:CT_SmartTagRun_smartTagPr" },
    { NS_ooxml::LN_CT_SmartTagRun_uri, "ooxml:CT_SmartTagRun_uri" },
    { NS_ooxml::LN_CT_SmartTagRun_element, "ooxml:CT_SmartTagRun_element" },
    { NS_ooxml::LN_CT_SmartTagPr_attr, "ooxml:CT_SmartTagPr_attr" },
    { NS_ooxml::LN_EG_PContent_fldSimple, "ooxml:EG_PContent_fldSimple" },
    { NS_ooxml::LN_EG_PContent_hyperlink, "ooxml:EG_PContent_hyperlink" },
    { NS_ooxml::LN_EG_PContent_subDoc, "ooxml:EG_PContent_subDoc" },
    { NS_ooxml::LN_AG_Parids_paraId, "ooxml:AG_Parids_paraId" },
    { NS_ooxml::LN_Value_ST_TblWidth_nil, "ooxml:Value_ST_TblWidth_nil" },
    { NS_ooxml::LN_Value_ST_TblWidth_pct, "ooxml:Value_ST_TblWidth_pct" },
    { NS_ooxml::LN_Value_ST_TblWidth_dxa, "ooxml:Value_ST_TblWidth_dxa" },
    { NS_ooxml::LN_Value_ST_TblWidth_auto, "ooxml:Value_ST_TblWidth_auto" },
    { NS_ooxml::LN_CT_Height_val, "ooxml:CT_Height_val" },
    { NS_ooxml::LN_CT_Height_hRule, "ooxml:CT_Height_hRule" },
    { NS_ooxml::LN_CT_TblWidth_w, "ooxml:CT_TblWidth_w" },
    { NS_ooxml::LN_CT_TblWidth_type, "ooxml:CT_TblWidth_type" },
    { NS_ooxml::LN_CT_TblPPr_vertAnchor, "ooxml:CT_TblPPr_vertAnchor" },
    { NS_ooxml::LN_CT_TblPPr_tblpYSpec, "ooxml:CT_TblPPr_tblpYSpec" },
    { NS_ooxml::LN_CT_TblPPr_horzAnchor, "ooxml:CT_TblPPr_horzAnchor" },
    { NS_ooxml::LN_CT_TblPPr_tblpXSpec, "ooxml:CT_TblPPr_tblpXSpec" },
    { NS_ooxml::LN_CT_TblPPr_tblpY, "ooxml:CT_TblPPr_tblpY" },
    { NS_ooxml::LN_CT_TblPPr_tblpX, "ooxml:CT_TblPPr_tblpX" },
    { NS_ooxml::LN_CT_TblPPr_leftFromText, "ooxml:CT_TblPPr_leftFromText" },
    { NS_ooxml::LN_CT_TblPPr_rightFromText, "ooxml:CT_TblPPr_rightFromText" },
    { NS_ooxml::LN_CT_TblPPr_topFromText, "ooxml:CT_TblPPr_topFromText" },
    { NS_ooxml::LN_CT_TblPPr_bottomFromText, "ooxml:CT_TblPPr_bottomFromText" },
    { NS_ooxml::LN_CT_TblGridCol_w, "ooxml:CT_TblGridCol_w" },
    { NS_ooxml::LN_CT_TblGridBase_gridCol, "ooxml:CT_TblGridBase_gridCol" },
    { NS_ooxml::LN_CT_TblGrid_tblGridChange, "ooxml:CT_TblGrid_tblGridChange" },
    { NS_ooxml::LN_CT_TcBorders_top, "ooxml:CT_TcBorders_top" },
    { NS_ooxml::LN_CT_TcBorders_start, "ooxml:CT_TcBorders_start" },
    { NS_ooxml::LN_CT_TcBorders_left, "ooxml:CT_TcBorders_left" },
    { NS_ooxml::LN_CT_TcBorders_bottom, "ooxml:CT_TcBorders_bottom" },
    { NS_ooxml::LN_CT_TcBorders_end, "ooxml:CT_TcBorders_end" },
    { NS_ooxml::LN_CT_TcBorders_right, "ooxml:CT_TcBorders_right" },
    { NS_ooxml::LN_CT_TcBorders_insideH, "ooxml:CT_TcBorders_insideH" },
    { NS_ooxml::LN_CT_TcBorders_insideV, "ooxml:CT_TcBorders_insideV" },
    { NS_ooxml::LN_CT_TcBorders_tl2br, "ooxml:CT_TcBorders_tl2br" },
    { NS_ooxml::LN_CT_TcBorders_tr2bl, "ooxml:CT_TcBorders_tr2bl" },
    { NS_ooxml::LN_CT_TcMar_top, "ooxml:CT_TcMar_top" },
    { NS_ooxml::LN_CT_TcMar_start, "ooxml:CT_TcMar_start" },
    { NS_ooxml::LN_CT_TcMar_left, "ooxml:CT_TcMar_left" },
    { NS_ooxml::LN_CT_TcMar_bottom, "ooxml:CT_TcMar_bottom" },
    { NS_ooxml::LN_CT_TcMar_end, "ooxml:CT_TcMar_end" },
    { NS_ooxml::LN_CT_TcMar_right, "ooxml:CT_TcMar_right" },
    { NS_ooxml::LN_Value_ST_Merge_continue, "ooxml:Value_ST_Merge_continue" },
    { NS_ooxml::LN_Value_ST_Merge_restart, "ooxml:Value_ST_Merge_restart" },
    { NS_ooxml::LN_CT_VMerge_val, "ooxml:CT_VMerge_val" },
    { NS_ooxml::LN_CT_HMerge_val, "ooxml:CT_HMerge_val" },
    { NS_ooxml::LN_CT_TcPrBase_cnfStyle, "ooxml:CT_TcPrBase_cnfStyle" },
    { NS_ooxml::LN_CT_TcPrBase_tcW, "ooxml:CT_TcPrBase_tcW" },
    { NS_ooxml::LN_CT_TcPrBase_gridSpan, "ooxml:CT_TcPrBase_gridSpan" },
    { NS_ooxml::LN_CT_TcPrBase_hMerge, "ooxml:CT_TcPrBase_hMerge" },
    { NS_ooxml::LN_CT_TcPrBase_vMerge, "ooxml:CT_TcPrBase_vMerge" },
    { NS_ooxml::LN_CT_TcPrBase_tcBorders, "ooxml:CT_TcPrBase_tcBorders" },
    { NS_ooxml::LN_CT_TcPrBase_shd, "ooxml:CT_TcPrBase_shd" },
    { NS_ooxml::LN_CT_TcPrBase_noWrap, "ooxml:CT_TcPrBase_noWrap" },
    { NS_ooxml::LN_CT_TcPrBase_tcMar, "ooxml:CT_TcPrBase_tcMar" },
    { NS_ooxml::LN_CT_TcPrBase_textDirection, "ooxml:CT_TcPrBase_textDirection" },
    { NS_ooxml::LN_CT_TcPrBase_tcFitText, "ooxml:CT_TcPrBase_tcFitText" },
    { NS_ooxml::LN_CT_TcPrBase_vAlign, "ooxml:CT_TcPrBase_vAlign" },
    { NS_ooxml::LN_CT_TcPrBase_hideMark, "ooxml:CT_TcPrBase_hideMark" },
    { NS_ooxml::LN_CT_TcPrBase_cellDel, "ooxml:CT_TcPrBase_cellDel" },
    { NS_ooxml::LN_CT_TcPrBase_cellIns, "ooxml:CT_TcPrBase_cellIns" },
    { NS_ooxml::LN_CT_TcPrBase_cellMerge, "ooxml:CT_TcPrBase_cellMerge" },
    { NS_ooxml::LN_CT_TcPr_tcPrChange, "ooxml:CT_TcPr_tcPrChange" },
    { NS_ooxml::LN_CT_Cnf_val, "ooxml:CT_Cnf_val" },
    { NS_ooxml::LN_CT_Cnf_firstRow, "ooxml:CT_Cnf_firstRow" },
    { NS_ooxml::LN_CT_Cnf_lastRow, "ooxml:CT_Cnf_lastRow" },
    { NS_ooxml::LN_CT_Cnf_firstColumn, "ooxml:CT_Cnf_firstColumn" },
    { NS_ooxml::LN_CT_Cnf_lastColumn, "ooxml:CT_Cnf_lastColumn" },
    { NS_ooxml::LN_CT_Cnf_oddVBand, "ooxml:CT_Cnf_oddVBand" },
    { NS_ooxml::LN_CT_Cnf_evenVBand, "ooxml:CT_Cnf_evenVBand" },
    { NS_ooxml::LN_CT_Cnf_oddHBand, "ooxml:CT_Cnf_oddHBand" },
    { NS_ooxml::LN_CT_Cnf_evenHBand, "ooxml:CT_Cnf_evenHBand" },
    { NS_ooxml::LN_CT_Cnf_firstRowFirstColumn, "ooxml:CT_Cnf_firstRowFirstColumn" },
    { NS_ooxml::LN_CT_Cnf_firstRowLastColumn, "ooxml:CT_Cnf_firstRowLastColumn" },
    { NS_ooxml::LN_CT_Cnf_lastRowFirstColumn, "ooxml:CT_Cnf_lastRowFirstColumn" },
    { NS_ooxml::LN_CT_Cnf_lastRowLastColumn, "ooxml:CT_Cnf_lastRowLastColumn" },
    { NS_ooxml::LN_CT_TrPrBase_cnfStyle, "ooxml:CT_TrPrBase_cnfStyle" },
    { NS_ooxml::LN_CT_TrPrBase_divId, "ooxml:CT_TrPrBase_divId" },
    { NS_ooxml::LN_CT_TrPrBase_gridBefore, "ooxml:CT_TrPrBase_gridBefore" },
    { NS_ooxml::LN_CT_TrPrBase_gridAfter, "ooxml:CT_TrPrBase_gridAfter" },
    { NS_ooxml::LN_CT_TrPrBase_wBefore, "ooxml:CT_TrPrBase_wBefore" },
    { NS_ooxml::LN_CT_TrPrBase_wAfter, "ooxml:CT_TrPrBase_wAfter" },
    { NS_ooxml::LN_CT_TrPrBase_cantSplit, "ooxml:CT_TrPrBase_cantSplit" },
    { NS_ooxml::LN_CT_TrPrBase_trHeight, "ooxml:CT_TrPrBase_trHeight" },
    { NS_ooxml::LN_CT_TrPrBase_tblHeader, "ooxml:CT_TrPrBase_tblHeader" },
    { NS_ooxml::LN_CT_TrPrBase_tblCellSpacing, "ooxml:CT_TrPrBase_tblCellSpacing" },
    { NS_ooxml::LN_CT_TrPrBase_jc, "ooxml:CT_TrPrBase_jc" },
    { NS_ooxml::LN_CT_TrPrBase_hidden, "ooxml:CT_TrPrBase_hidden" },
    { NS_ooxml::LN_CT_TrPr_ins, "ooxml:CT_TrPr_ins" },
    { NS_ooxml::LN_CT_TrPr_del, "ooxml:CT_TrPr_del" },
    { NS_ooxml::LN_CT_TrPr_trPrChange, "ooxml:CT_TrPr_trPrChange" },
    { NS_ooxml::LN_Value_doc_ST_TblLayout_fixed, "ooxml:Value_doc_ST_TblLayout_fixed" },
    { NS_ooxml::LN_Value_doc_ST_TblLayout_autofit, "ooxml:Value_doc_ST_TblLayout_autofit" },
    { NS_ooxml::LN_CT_TblLayoutType_type, "ooxml:CT_TblLayoutType_type" },
    { NS_ooxml::LN_Value_ST_TblOverlap_never, "ooxml:Value_ST_TblOverlap_never" },
    { NS_ooxml::LN_Value_ST_TblOverlap_overlap, "ooxml:Value_ST_TblOverlap_overlap" },
    { NS_ooxml::LN_CT_TblOverlap_val, "ooxml:CT_TblOverlap_val" },
    { NS_ooxml::LN_CT_TblCellMar_top, "ooxml:CT_TblCellMar_top" },
    { NS_ooxml::LN_CT_TblCellMar_start, "ooxml:CT_TblCellMar_start" },
    { NS_ooxml::LN_CT_TblCellMar_left, "ooxml:CT_TblCellMar_left" },
    { NS_ooxml::LN_CT_TblCellMar_bottom, "ooxml:CT_TblCellMar_bottom" },
    { NS_ooxml::LN_CT_TblCellMar_end, "ooxml:CT_TblCellMar_end" },
    { NS_ooxml::LN_CT_TblCellMar_right, "ooxml:CT_TblCellMar_right" },
    { NS_ooxml::LN_CT_TblBorders_top, "ooxml:CT_TblBorders_top" },
    { NS_ooxml::LN_CT_TblBorders_start, "ooxml:CT_TblBorders_start" },
    { NS_ooxml::LN_CT_TblBorders_left, "ooxml:CT_TblBorders_left" },
    { NS_ooxml::LN_CT_TblBorders_bottom, "ooxml:CT_TblBorders_bottom" },
    { NS_ooxml::LN_CT_TblBorders_end, "ooxml:CT_TblBorders_end" },
    { NS_ooxml::LN_CT_TblBorders_right, "ooxml:CT_TblBorders_right" },
    { NS_ooxml::LN_CT_TblBorders_insideH, "ooxml:CT_TblBorders_insideH" },
    { NS_ooxml::LN_CT_TblBorders_insideV, "ooxml:CT_TblBorders_insideV" },
    { NS_ooxml::LN_CT_TblPrBase_tblStyle, "ooxml:CT_TblPrBase_tblStyle" },
    { NS_ooxml::LN_CT_TblPrBase_tblpPr, "ooxml:CT_TblPrBase_tblpPr" },
    { NS_ooxml::LN_CT_TblPrBase_tblOverlap, "ooxml:CT_TblPrBase_tblOverlap" },
    { NS_ooxml::LN_CT_TblPrBase_bidiVisual, "ooxml:CT_TblPrBase_bidiVisual" },
    { NS_ooxml::LN_CT_TblPrBase_tblStyleRowBandSize, "ooxml:CT_TblPrBase_tblStyleRowBandSize" },
    { NS_ooxml::LN_CT_TblPrBase_tblStyleColBandSize, "ooxml:CT_TblPrBase_tblStyleColBandSize" },
    { NS_ooxml::LN_CT_TblPrBase_tblW, "ooxml:CT_TblPrBase_tblW" },
    { NS_ooxml::LN_CT_TblPrBase_jc, "ooxml:CT_TblPrBase_jc" },
    { NS_ooxml::LN_CT_TblPrBase_tblCellSpacing, "ooxml:CT_TblPrBase_tblCellSpacing" },
    { NS_ooxml::LN_CT_TblPrBase_tblInd, "ooxml:CT_TblPrBase_tblInd" },
    { NS_ooxml::LN_CT_TblPrBase_tblBorders, "ooxml:CT_TblPrBase_tblBorders" },
    { NS_ooxml::LN_CT_TblPrBase_shd, "ooxml:CT_TblPrBase_shd" },
    { NS_ooxml::LN_CT_TblPrBase_tblLayout, "ooxml:CT_TblPrBase_tblLayout" },
    { NS_ooxml::LN_CT_TblPrBase_tblCellMar, "ooxml:CT_TblPrBase_tblCellMar" },
    { NS_ooxml::LN_CT_TblPrBase_tblLook, "ooxml:CT_TblPrBase_tblLook" },
    { NS_ooxml::LN_CT_TblPrBase_tblCaption, "ooxml:CT_TblPrBase_tblCaption" },
    { NS_ooxml::LN_CT_TblPrBase_tblDescription, "ooxml:CT_TblPrBase_tblDescription" },
    { NS_ooxml::LN_CT_TblPr_tblPrChange, "ooxml:CT_TblPr_tblPrChange" },
    { NS_ooxml::LN_CT_TblPrEx_tblPrExChange, "ooxml:CT_TblPrEx_tblPrExChange" },
    { NS_ooxml::LN_CT_TblPrEx_tblBorders, "ooxml:CT_TblPrEx_tblBorders" },
    { NS_ooxml::LN_CT_TblLook_firstRow, "ooxml:CT_TblLook_firstRow" },
    { NS_ooxml::LN_CT_TblLook_lastRow, "ooxml:CT_TblLook_lastRow" },
    { NS_ooxml::LN_CT_TblLook_firstColumn, "ooxml:CT_TblLook_firstColumn" },
    { NS_ooxml::LN_CT_TblLook_lastColumn, "ooxml:CT_TblLook_lastColumn" },
    { NS_ooxml::LN_CT_TblLook_noHBand, "ooxml:CT_TblLook_noHBand" },
    { NS_ooxml::LN_CT_TblLook_noVBand, "ooxml:CT_TblLook_noVBand" },
    { NS_ooxml::LN_CT_TblLook_val, "ooxml:CT_TblLook_val" },
    { NS_ooxml::LN_Value_ST_FtnPos_pageBottom, "ooxml:Value_ST_FtnPos_pageBottom" },
    { NS_ooxml::LN_Value_ST_FtnPos_beneathText, "ooxml:Value_ST_FtnPos_beneathText" },
    { NS_ooxml::LN_Value_ST_FtnPos_sectEnd, "ooxml:Value_ST_FtnPos_sectEnd" },
    { NS_ooxml::LN_Value_ST_FtnPos_docEnd, "ooxml:Value_ST_FtnPos_docEnd" },
    { NS_ooxml::LN_CT_FtnPos_val, "ooxml:CT_FtnPos_val" },
    { NS_ooxml::LN_Value_ST_EdnPos_sectEnd, "ooxml:Value_ST_EdnPos_sectEnd" },
    { NS_ooxml::LN_Value_ST_EdnPos_docEnd, "ooxml:Value_ST_EdnPos_docEnd" },
    { NS_ooxml::LN_CT_EdnPos_val, "ooxml:CT_EdnPos_val" },
    { NS_ooxml::LN_CT_NumFmt_format, "ooxml:CT_NumFmt_format" },
    { NS_ooxml::LN_CT_NumFmt_val, "ooxml:CT_NumFmt_val" },
    { NS_ooxml::LN_Value_ST_RestartNumber_continuous, "ooxml:Value_ST_RestartNumber_continuous" },
    { NS_ooxml::LN_Value_ST_RestartNumber_eachSect, "ooxml:Value_ST_RestartNumber_eachSect" },
    { NS_ooxml::LN_Value_ST_RestartNumber_eachPage, "ooxml:Value_ST_RestartNumber_eachPage" },
    { NS_ooxml::LN_CT_NumRestart_val, "ooxml:CT_NumRestart_val" },
    { NS_ooxml::LN_CT_FtnEdnRef_customMarkFollows, "ooxml:CT_FtnEdnRef_customMarkFollows" },
    { NS_ooxml::LN_CT_FtnEdnRef_id, "ooxml:CT_FtnEdnRef_id" },
    { NS_ooxml::LN_CT_FtnEdnSepRef_id, "ooxml:CT_FtnEdnSepRef_id" },
    { NS_ooxml::LN_CT_FtnEdn_type, "ooxml:CT_FtnEdn_type" },
    { NS_ooxml::LN_CT_FtnEdn_id, "ooxml:CT_FtnEdn_id" },
    { NS_ooxml::LN_EG_FtnEdnNumProps_numStart, "ooxml:EG_FtnEdnNumProps_numStart" },
    { NS_ooxml::LN_EG_FtnEdnNumProps_numRestart, "ooxml:EG_FtnEdnNumProps_numRestart" },
    { NS_ooxml::LN_CT_FtnProps_pos, "ooxml:CT_FtnProps_pos" },
    { NS_ooxml::LN_CT_FtnProps_numFmt, "ooxml:CT_FtnProps_numFmt" },
    { NS_ooxml::LN_CT_EdnProps_pos, "ooxml:CT_EdnProps_pos" },
    { NS_ooxml::LN_CT_EdnProps_numFmt, "ooxml:CT_EdnProps_numFmt" },
    { NS_ooxml::LN_CT_FtnDocProps_footnote, "ooxml:CT_FtnDocProps_footnote" },
    { NS_ooxml::LN_CT_EdnDocProps_endnote, "ooxml:CT_EdnDocProps_endnote" },
    { NS_ooxml::LN_CT_MailMergeSourceType_val, "ooxml:CT_MailMergeSourceType_val" },
    { NS_ooxml::LN_CT_MailMerge_mainDocumentType, "ooxml:CT_MailMerge_mainDocumentType" },
    { NS_ooxml::LN_CT_MailMerge_linkToQuery, "ooxml:CT_MailMerge_linkToQuery" },
    { NS_ooxml::LN_CT_MailMerge_dataType, "ooxml:CT_MailMerge_dataType" },
    { NS_ooxml::LN_CT_MailMerge_connectString, "ooxml:CT_MailMerge_connectString" },
    { NS_ooxml::LN_CT_MailMerge_query, "ooxml:CT_MailMerge_query" },
    { NS_ooxml::LN_CT_MailMerge_dataSource, "ooxml:CT_MailMerge_dataSource" },
    { NS_ooxml::LN_CT_MailMerge_headerSource, "ooxml:CT_MailMerge_headerSource" },
    { NS_ooxml::LN_CT_MailMerge_doNotSuppressBlankLines, "ooxml:CT_MailMerge_doNotSuppressBlankLines" },
    { NS_ooxml::LN_CT_MailMerge_destination, "ooxml:CT_MailMerge_destination" },
    { NS_ooxml::LN_CT_MailMerge_addressFieldName, "ooxml:CT_MailMerge_addressFieldName" },
    { NS_ooxml::LN_CT_MailMerge_mailSubject, "ooxml:CT_MailMerge_mailSubject" },
    { NS_ooxml::LN_CT_MailMerge_mailAsAttachment, "ooxml:CT_MailMerge_mailAsAttachment" },
    { NS_ooxml::LN_CT_MailMerge_viewMergedData, "ooxml:CT_MailMerge_viewMergedData" },
    { NS_ooxml::LN_CT_MailMerge_activeRecord, "ooxml:CT_MailMerge_activeRecord" },
    { NS_ooxml::LN_CT_MailMerge_checkErrors, "ooxml:CT_MailMerge_checkErrors" },
    { NS_ooxml::LN_CT_MailMerge_odso, "ooxml:CT_MailMerge_odso" },
    { NS_ooxml::LN_CT_TargetScreenSz_val, "ooxml:CT_TargetScreenSz_val" },
    { NS_ooxml::LN_CT_Compat_useSingleBorderforContiguousCells, "ooxml:CT_Compat_useSingleBorderforContiguousCells" },
    { NS_ooxml::LN_CT_Compat_wpJustification, "ooxml:CT_Compat_wpJustification" },
    { NS_ooxml::LN_CT_Compat_noTabHangInd, "ooxml:CT_Compat_noTabHangInd" },
    { NS_ooxml::LN_CT_Compat_noLeading, "ooxml:CT_Compat_noLeading" },
    { NS_ooxml::LN_CT_Compat_spaceForUL, "ooxml:CT_Compat_spaceForUL" },
    { NS_ooxml::LN_CT_Compat_noColumnBalance, "ooxml:CT_Compat_noColumnBalance" },
    { NS_ooxml::LN_CT_Compat_balanceSingleByteDoubleByteWidth, "ooxml:CT_Compat_balanceSingleByteDoubleByteWidth" },
    { NS_ooxml::LN_CT_Compat_noExtraLineSpacing, "ooxml:CT_Compat_noExtraLineSpacing" },
    { NS_ooxml::LN_CT_Compat_doNotLeaveBackslashAlone, "ooxml:CT_Compat_doNotLeaveBackslashAlone" },
    { NS_ooxml::LN_CT_Compat_ulTrailSpace, "ooxml:CT_Compat_ulTrailSpace" },
    { NS_ooxml::LN_CT_Compat_doNotExpandShiftReturn, "ooxml:CT_Compat_doNotExpandShiftReturn" },
    { NS_ooxml::LN_CT_Compat_spacingInWholePoints, "ooxml:CT_Compat_spacingInWholePoints" },
    { NS_ooxml::LN_CT_Compat_lineWrapLikeWord6, "ooxml:CT_Compat_lineWrapLikeWord6" },
    { NS_ooxml::LN_CT_Compat_printBodyTextBeforeHeader, "ooxml:CT_Compat_printBodyTextBeforeHeader" },
    { NS_ooxml::LN_CT_Compat_printColBlack, "ooxml:CT_Compat_printColBlack" },
    { NS_ooxml::LN_CT_Compat_wpSpaceWidth, "ooxml:CT_Compat_wpSpaceWidth" },
    { NS_ooxml::LN_CT_Compat_showBreaksInFrames, "ooxml:CT_Compat_showBreaksInFrames" },
    { NS_ooxml::LN_CT_Compat_subFontBySize, "ooxml:CT_Compat_subFontBySize" },
    { NS_ooxml::LN_CT_Compat_suppressBottomSpacing, "ooxml:CT_Compat_suppressBottomSpacing" },
    { NS_ooxml::LN_CT_Compat_suppressTopSpacing, "ooxml:CT_Compat_suppressTopSpacing" },
    { NS_ooxml::LN_CT_Compat_suppressSpacingAtTopOfPage, "ooxml:CT_Compat_suppressSpacingAtTopOfPage" },
    { NS_ooxml::LN_CT_Compat_suppressTopSpacingWP, "ooxml:CT_Compat_suppressTopSpacingWP" },
    { NS_ooxml::LN_CT_Compat_suppressSpBfAfterPgBrk, "ooxml:CT_Compat_suppressSpBfAfterPgBrk" },
    { NS_ooxml::LN_CT_Compat_swapBordersFacingPages, "ooxml:CT_Compat_swapBordersFacingPages" },
    { NS_ooxml::LN_CT_Compat_convMailMergeEsc, "ooxml:CT_Compat_convMailMergeEsc" },
    { NS_ooxml::LN_CT_Compat_truncateFontHeightsLikeWP6, "ooxml:CT_Compat_truncateFontHeightsLikeWP6" },
    { NS_ooxml::LN_CT_Compat_mwSmallCaps, "ooxml:CT_Compat_mwSmallCaps" },
    { NS_ooxml::LN_CT_Compat_usePrinterMetrics, "ooxml:CT_Compat_usePrinterMetrics" },
    { NS_ooxml::LN_CT_Compat_doNotSuppressParagraphBorders, "ooxml:CT_Compat_doNotSuppressParagraphBorders" },
    { NS_ooxml::LN_CT_Compat_wrapTrailSpaces, "ooxml:CT_Compat_wrapTrailSpaces" },
    { NS_ooxml::LN_CT_Compat_footnoteLayoutLikeWW8, "ooxml:CT_Compat_footnoteLayoutLikeWW8" },
    { NS_ooxml::LN_CT_Compat_shapeLayoutLikeWW8, "ooxml:CT_Compat_shapeLayoutLikeWW8" },
    { NS_ooxml::LN_CT_Compat_alignTablesRowByRow, "ooxml:CT_Compat_alignTablesRowByRow" },
    { NS_ooxml::LN_CT_Compat_forgetLastTabAlignment, "ooxml:CT_Compat_forgetLastTabAlignment" },
    { NS_ooxml::LN_CT_Compat_adjustLineHeightInTable, "ooxml:CT_Compat_adjustLineHeightInTable" },
    { NS_ooxml::LN_CT_Compat_autoSpaceLikeWord95, "ooxml:CT_Compat_autoSpaceLikeWord95" },
    { NS_ooxml::LN_CT_Compat_noSpaceRaiseLower, "ooxml:CT_Compat_noSpaceRaiseLower" },
    { NS_ooxml::LN_CT_Compat_doNotUseHTMLParagraphAutoSpacing, "ooxml:CT_Compat_doNotUseHTMLParagraphAutoSpacing" },
    { NS_ooxml::LN_CT_Compat_layoutRawTableWidth, "ooxml:CT_Compat_layoutRawTableWidth" },
    { NS_ooxml::LN_CT_Compat_layoutTableRowsApart, "ooxml:CT_Compat_layoutTableRowsApart" },
    { NS_ooxml::LN_CT_Compat_useWord97LineBreakRules, "ooxml:CT_Compat_useWord97LineBreakRules" },
    { NS_ooxml::LN_CT_Compat_doNotBreakWrappedTables, "ooxml:CT_Compat_doNotBreakWrappedTables" },
    { NS_ooxml::LN_CT_Compat_doNotSnapToGridInCell, "ooxml:CT_Compat_doNotSnapToGridInCell" },
    { NS_ooxml::LN_CT_Compat_selectFldWithFirstOrLastChar, "ooxml:CT_Compat_selectFldWithFirstOrLastChar" },
    { NS_ooxml::LN_CT_Compat_applyBreakingRules, "ooxml:CT_Compat_applyBreakingRules" },
    { NS_ooxml::LN_CT_Compat_doNotWrapTextWithPunct, "ooxml:CT_Compat_doNotWrapTextWithPunct" },
    { NS_ooxml::LN_CT_Compat_doNotUseEastAsianBreakRules, "ooxml:CT_Compat_doNotUseEastAsianBreakRules" },
    { NS_ooxml::LN_CT_Compat_useWord2002TableStyleRules, "ooxml:CT_Compat_useWord2002TableStyleRules" },
    { NS_ooxml::LN_CT_Compat_growAutofit, "ooxml:CT_Compat_growAutofit" },
    { NS_ooxml::LN_CT_Compat_useFELayout, "ooxml:CT_Compat_useFELayout" },
    { NS_ooxml::LN_CT_Compat_useNormalStyleForList, "ooxml:CT_Compat_useNormalStyleForList" },
    { NS_ooxml::LN_CT_Compat_doNotUseIndentAsNumberingTabStop, "ooxml:CT_Compat_doNotUseIndentAsNumberingTabStop" },
    { NS_ooxml::LN_CT_Compat_useAltKinsokuLineBreakRules, "ooxml:CT_Compat_useAltKinsokuLineBreakRules" },
    { NS_ooxml::LN_CT_Compat_allowSpaceOfSameStyleInTable, "ooxml:CT_Compat_allowSpaceOfSameStyleInTable" },
    { NS_ooxml::LN_CT_Compat_doNotSuppressIndentation, "ooxml:CT_Compat_doNotSuppressIndentation" },
    { NS_ooxml::LN_CT_Compat_doNotAutofitConstrainedTables, "ooxml:CT_Compat_doNotAutofitConstrainedTables" },
    { NS_ooxml::LN_CT_Compat_autofitToFirstFixedWidthCell, "ooxml:CT_Compat_autofitToFirstFixedWidthCell" },
    { NS_ooxml::LN_CT_Compat_underlineTabInNumList, "ooxml:CT_Compat_underlineTabInNumList" },
    { NS_ooxml::LN_CT_Compat_displayHangulFixedWidth, "ooxml:CT_Compat_displayHangulFixedWidth" },
    { NS_ooxml::LN_CT_Compat_splitPgBreakAndParaMark, "ooxml:CT_Compat_splitPgBreakAndParaMark" },
    { NS_ooxml::LN_CT_Compat_doNotVertAlignCellWithSp, "ooxml:CT_Compat_doNotVertAlignCellWithSp" },
    { NS_ooxml::LN_CT_Compat_doNotBreakConstrainedForcedTable, "ooxml:CT_Compat_doNotBreakConstrainedForcedTable" },
    { NS_ooxml::LN_CT_Compat_doNotVertAlignInTxbx, "ooxml:CT_Compat_doNotVertAlignInTxbx" },
    { NS_ooxml::LN_CT_Compat_useAnsiKerningPairs, "ooxml:CT_Compat_useAnsiKerningPairs" },
    { NS_ooxml::LN_CT_Compat_cachedColBalance, "ooxml:CT_Compat_cachedColBalance" },
    { NS_ooxml::LN_CT_Compat_compatSetting, "ooxml:CT_Compat_compatSetting" },
    { NS_ooxml::LN_CT_CompatSetting_name, "ooxml:CT_CompatSetting_name" },
    { NS_ooxml::LN_CT_CompatSetting_uri, "ooxml:CT_CompatSetting_uri" },
    { NS_ooxml::LN_CT_CompatSetting_val, "ooxml:CT_CompatSetting_val" },
    { NS_ooxml::LN_CT_DocVar, "ooxml:CT_DocVar" },
    { NS_ooxml::LN_CT_DocVar_name, "ooxml:CT_DocVar_name" },
    { NS_ooxml::LN_CT_DocVar_val, "ooxml:CT_DocVar_val" },
    { NS_ooxml::LN_CT_DocRsids_rsidRoot, "ooxml:CT_DocRsids_rsidRoot" },
    { NS_ooxml::LN_CT_DocRsids_rsid, "ooxml:CT_DocRsids_rsid" },
    { NS_ooxml::LN_CT_CharacterSpacing_val, "ooxml:CT_CharacterSpacing_val" },
    { NS_ooxml::LN_CT_SaveThroughXslt_r_id, "ooxml:CT_SaveThroughXslt_r_id" },
    { NS_ooxml::LN_CT_SaveThroughXslt_solutionID, "ooxml:CT_SaveThroughXslt_solutionID" },
    { NS_ooxml::LN_CT_RPrDefault_rPr, "ooxml:CT_RPrDefault_rPr" },
    { NS_ooxml::LN_CT_PPrDefault_pPr, "ooxml:CT_PPrDefault_pPr" },
    { NS_ooxml::LN_CT_DocDefaults_pPrDefault, "ooxml:CT_DocDefaults_pPrDefault" },
    { NS_ooxml::LN_CT_DocDefaults_rPrDefault, "ooxml:CT_DocDefaults_rPrDefault" },
    { NS_ooxml::LN_CT_LatentStyles_defLockedState, "ooxml:CT_LatentStyles_defLockedState" },
    { NS_ooxml::LN_CT_LatentStyles_defUIPriority, "ooxml:CT_LatentStyles_defUIPriority" },
    { NS_ooxml::LN_CT_LatentStyles_defSemiHidden, "ooxml:CT_LatentStyles_defSemiHidden" },
    { NS_ooxml::LN_CT_LatentStyles_defUnhideWhenUsed, "ooxml:CT_LatentStyles_defUnhideWhenUsed" },
    { NS_ooxml::LN_CT_LatentStyles_defQFormat, "ooxml:CT_LatentStyles_defQFormat" },
    { NS_ooxml::LN_CT_LatentStyles_count, "ooxml:CT_LatentStyles_count" },
    { NS_ooxml::LN_CT_LatentStyles_lsdException, "ooxml:CT_LatentStyles_lsdException" },
    { NS_ooxml::LN_CT_LsdException_name, "ooxml:CT_LsdException_name" },
    { NS_ooxml::LN_CT_LsdException_locked, "ooxml:CT_LsdException_locked" },
    { NS_ooxml::LN_CT_LsdException_uiPriority, "ooxml:CT_LsdException_uiPriority" },
    { NS_ooxml::LN_CT_LsdException_semiHidden, "ooxml:CT_LsdException_semiHidden" },
    { NS_ooxml::LN_CT_LsdException_unhideWhenUsed, "ooxml:CT_LsdException_unhideWhenUsed" },
    { NS_ooxml::LN_CT_LsdException_qFormat, "ooxml:CT_LsdException_qFormat" },
    { NS_ooxml::LN_Value_doc_ST_ColorSchemeIndex_dark1, "ooxml:Value_doc_ST_ColorSchemeIndex_dark1" },
    { NS_ooxml::LN_Value_doc_ST_ColorSchemeIndex_light1, "ooxml:Value_doc_ST_ColorSchemeIndex_light1" },
    { NS_ooxml::LN_Value_doc_ST_ColorSchemeIndex_dark2, "ooxml:Value_doc_ST_ColorSchemeIndex_dark2" },
    { NS_ooxml::LN_Value_doc_ST_ColorSchemeIndex_light2, "ooxml:Value_doc_ST_ColorSchemeIndex_light2" },
    { NS_ooxml::LN_Value_doc_ST_ColorSchemeIndex_accent1, "ooxml:Value_doc_ST_ColorSchemeIndex_accent1" },
    { NS_ooxml::LN_Value_doc_ST_ColorSchemeIndex_accent2, "ooxml:Value_doc_ST_ColorSchemeIndex_accent2" },
    { NS_ooxml::LN_Value_doc_ST_ColorSchemeIndex_accent3, "ooxml:Value_doc_ST_ColorSchemeIndex_accent3" },
    { NS_ooxml::LN_Value_doc_ST_ColorSchemeIndex_accent4, "ooxml:Value_doc_ST_ColorSchemeIndex_accent4" },
    { NS_ooxml::LN_Value_doc_ST_ColorSchemeIndex_accent5, "ooxml:Value_doc_ST_ColorSchemeIndex_accent5" },
    { NS_ooxml::LN_Value_doc_ST_ColorSchemeIndex_accent6, "ooxml:Value_doc_ST_ColorSchemeIndex_accent6" },
    { NS_ooxml::LN_Value_doc_ST_ColorSchemeIndex_hyperlink, "ooxml:Value_doc_ST_ColorSchemeIndex_hyperlink" },
    { NS_ooxml::LN_Value_doc_ST_ColorSchemeIndex_followedHyperlink, "ooxml:Value_doc_ST_ColorSchemeIndex_followedHyperlink" },
    { NS_ooxml::LN_CT_ReadingModeInkLockDown_actualPg, "ooxml:CT_ReadingModeInkLockDown_actualPg" },
    { NS_ooxml::LN_CT_ReadingModeInkLockDown_w, "ooxml:CT_ReadingModeInkLockDown_w" },
    { NS_ooxml::LN_CT_ReadingModeInkLockDown_h, "ooxml:CT_ReadingModeInkLockDown_h" },
    { NS_ooxml::LN_CT_ReadingModeInkLockDown_fontSz, "ooxml:CT_ReadingModeInkLockDown_fontSz" },
    { NS_ooxml::LN_CT_WriteProtection_recommended, "ooxml:CT_WriteProtection_recommended" },
    { NS_ooxml::LN_SETTINGS, "ooxml:SETTINGS" },
    { NS_ooxml::LN_CT_Settings_writeProtection, "ooxml:CT_Settings_writeProtection" },
    { NS_ooxml::LN_CT_Settings_view, "ooxml:CT_Settings_view" },
    { NS_ooxml::LN_CT_Settings_zoom, "ooxml:CT_Settings_zoom" },
    { NS_ooxml::LN_CT_Settings_removePersonalInformation, "ooxml:CT_Settings_removePersonalInformation" },
    { NS_ooxml::LN_CT_Settings_removeDateAndTime, "ooxml:CT_Settings_removeDateAndTime" },
    { NS_ooxml::LN_CT_Settings_doNotDisplayPageBoundaries, "ooxml:CT_Settings_doNotDisplayPageBoundaries" },
    { NS_ooxml::LN_CT_Settings_displayBackgroundShape, "ooxml:CT_Settings_displayBackgroundShape" },
    { NS_ooxml::LN_CT_Settings_printPostScriptOverText, "ooxml:CT_Settings_printPostScriptOverText" },
    { NS_ooxml::LN_CT_Settings_printFractionalCharacterWidth, "ooxml:CT_Settings_printFractionalCharacterWidth" },
    { NS_ooxml::LN_CT_Settings_printFormsData, "ooxml:CT_Settings_printFormsData" },
    { NS_ooxml::LN_CT_Settings_embedTrueTypeFonts, "ooxml:CT_Settings_embedTrueTypeFonts" },
    { NS_ooxml::LN_CT_Settings_embedSystemFonts, "ooxml:CT_Settings_embedSystemFonts" },
    { NS_ooxml::LN_CT_Settings_saveSubsetFonts, "ooxml:CT_Settings_saveSubsetFonts" },
    { NS_ooxml::LN_CT_Settings_saveFormsData, "ooxml:CT_Settings_saveFormsData" },
    { NS_ooxml::LN_CT_Settings_mirrorMargins, "ooxml:CT_Settings_mirrorMargins" },
    { NS_ooxml::LN_CT_Settings_alignBordersAndEdges, "ooxml:CT_Settings_alignBordersAndEdges" },
    { NS_ooxml::LN_CT_Settings_bordersDoNotSurroundHeader, "ooxml:CT_Settings_bordersDoNotSurroundHeader" },
    { NS_ooxml::LN_CT_Settings_bordersDoNotSurroundFooter, "ooxml:CT_Settings_bordersDoNotSurroundFooter" },
    { NS_ooxml::LN_CT_Settings_gutterAtTop, "ooxml:CT_Settings_gutterAtTop" },
    { NS_ooxml::LN_CT_Settings_hideSpellingErrors, "ooxml:CT_Settings_hideSpellingErrors" },
    { NS_ooxml::LN_CT_Settings_hideGrammaticalErrors, "ooxml:CT_Settings_hideGrammaticalErrors" },
    { NS_ooxml::LN_CT_Settings_activeWritingStyle, "ooxml:CT_Settings_activeWritingStyle" },
    { NS_ooxml::LN_CT_Settings_proofState, "ooxml:CT_Settings_proofState" },
    { NS_ooxml::LN_CT_Settings_formsDesign, "ooxml:CT_Settings_formsDesign" },
    { NS_ooxml::LN_CT_Settings_attachedTemplate, "ooxml:CT_Settings_attachedTemplate" },
    { NS_ooxml::LN_CT_Settings_linkStyles, "ooxml:CT_Settings_linkStyles" },
    { NS_ooxml::LN_CT_Settings_stylePaneFormatFilter, "ooxml:CT_Settings_stylePaneFormatFilter" },
    { NS_ooxml::LN_CT_Settings_stylePaneSortMethod, "ooxml:CT_Settings_stylePaneSortMethod" },
    { NS_ooxml::LN_CT_Settings_documentType, "ooxml:CT_Settings_documentType" },
    { NS_ooxml::LN_CT_Settings_mailMerge, "ooxml:CT_Settings_mailMerge" },
    { NS_ooxml::LN_CT_Settings_revisionView, "ooxml:CT_Settings_revisionView" },
    { NS_ooxml::LN_CT_Settings_trackRevisions, "ooxml:CT_Settings_trackRevisions" },
    { NS_ooxml::LN_CT_Settings_doNotTrackMoves, "ooxml:CT_Settings_doNotTrackMoves" },
    { NS_ooxml::LN_CT_Settings_doNotTrackFormatting, "ooxml:CT_Settings_doNotTrackFormatting" },
    { NS_ooxml::LN_CT_Settings_documentProtection, "ooxml:CT_Settings_documentProtection" },
    { NS_ooxml::LN_CT_Settings_autoFormatOverride, "ooxml:CT_Settings_autoFormatOverride" },
    { NS_ooxml::LN_CT_Settings_styleLockTheme, "ooxml:CT_Settings_styleLockTheme" },
    { NS_ooxml::LN_CT_Settings_styleLockQFSet, "ooxml:CT_Settings_styleLockQFSet" },
    { NS_ooxml::LN_CT_Settings_defaultTabStop, "ooxml:CT_Settings_defaultTabStop" },
    { NS_ooxml::LN_CT_Settings_autoHyphenation, "ooxml:CT_Settings_autoHyphenation" },
    { NS_ooxml::LN_CT_Settings_consecutiveHyphenLimit, "ooxml:CT_Settings_consecutiveHyphenLimit" },
    { NS_ooxml::LN_CT_Settings_hyphenationZone, "ooxml:CT_Settings_hyphenationZone" },
    { NS_ooxml::LN_CT_Settings_doNotHyphenateCaps, "ooxml:CT_Settings_doNotHyphenateCaps" },
    { NS_ooxml::LN_CT_Settings_showEnvelope, "ooxml:CT_Settings_showEnvelope" },
    { NS_ooxml::LN_CT_Settings_summaryLength, "ooxml:CT_Settings_summaryLength" },
    { NS_ooxml::LN_CT_Settings_clickAndTypeStyle, "ooxml:CT_Settings_clickAndTypeStyle" },
    { NS_ooxml::LN_CT_Settings_defaultTableStyle, "ooxml:CT_Settings_defaultTableStyle" },
    { NS_ooxml::LN_CT_Settings_evenAndOddHeaders, "ooxml:CT_Settings_evenAndOddHeaders" },
    { NS_ooxml::LN_CT_Settings_bookFoldRevPrinting, "ooxml:CT_Settings_bookFoldRevPrinting" },
    { NS_ooxml::LN_CT_Settings_bookFoldPrinting, "ooxml:CT_Settings_bookFoldPrinting" },
    { NS_ooxml::LN_CT_Settings_bookFoldPrintingSheets, "ooxml:CT_Settings_bookFoldPrintingSheets" },
    { NS_ooxml::LN_CT_Settings_drawingGridHorizontalSpacing, "ooxml:CT_Settings_drawingGridHorizontalSpacing" },
    { NS_ooxml::LN_CT_Settings_drawingGridVerticalSpacing, "ooxml:CT_Settings_drawingGridVerticalSpacing" },
    { NS_ooxml::LN_CT_Settings_displayHorizontalDrawingGridEvery, "ooxml:CT_Settings_displayHorizontalDrawingGridEvery" },
    { NS_ooxml::LN_CT_Settings_displayVerticalDrawingGridEvery, "ooxml:CT_Settings_displayVerticalDrawingGridEvery" },
    { NS_ooxml::LN_CT_Settings_doNotUseMarginsForDrawingGridOrigin, "ooxml:CT_Settings_doNotUseMarginsForDrawingGridOrigin" },
    { NS_ooxml::LN_CT_Settings_drawingGridHorizontalOrigin, "ooxml:CT_Settings_drawingGridHorizontalOrigin" },
    { NS_ooxml::LN_CT_Settings_drawingGridVerticalOrigin, "ooxml:CT_Settings_drawingGridVerticalOrigin" },
    { NS_ooxml::LN_CT_Settings_doNotShadeFormData, "ooxml:CT_Settings_doNotShadeFormData" },
    { NS_ooxml::LN_CT_Settings_noPunctuationKerning, "ooxml:CT_Settings_noPunctuationKerning" },
    { NS_ooxml::LN_CT_Settings_characterSpacingControl, "ooxml:CT_Settings_characterSpacingControl" },
    { NS_ooxml::LN_CT_Settings_printTwoOnOne, "ooxml:CT_Settings_printTwoOnOne" },
    { NS_ooxml::LN_CT_Settings_strictFirstAndLastChars, "ooxml:CT_Settings_strictFirstAndLastChars" },
    { NS_ooxml::LN_CT_Settings_noLineBreaksAfter, "ooxml:CT_Settings_noLineBreaksAfter" },
    { NS_ooxml::LN_CT_Settings_noLineBreaksBefore, "ooxml:CT_Settings_noLineBreaksBefore" },
    { NS_ooxml::LN_CT_Settings_savePreviewPicture, "ooxml:CT_Settings_savePreviewPicture" },
    { NS_ooxml::LN_CT_Settings_doNotValidateAgainstSchema, "ooxml:CT_Settings_doNotValidateAgainstSchema" },
    { NS_ooxml::LN_CT_Settings_saveInvalidXml, "ooxml:CT_Settings_saveInvalidXml" },
    { NS_ooxml::LN_CT_Settings_ignoreMixedContent, "ooxml:CT_Settings_ignoreMixedContent" },
    { NS_ooxml::LN_CT_Settings_alwaysShowPlaceholderText, "ooxml:CT_Settings_alwaysShowPlaceholderText" },
    { NS_ooxml::LN_CT_Settings_doNotDemarcateInvalidXml, "ooxml:CT_Settings_doNotDemarcateInvalidXml" },
    { NS_ooxml::LN_CT_Settings_saveXmlDataOnly, "ooxml:CT_Settings_saveXmlDataOnly" },
    { NS_ooxml::LN_CT_Settings_useXSLTWhenSaving, "ooxml:CT_Settings_useXSLTWhenSaving" },
    { NS_ooxml::LN_CT_Settings_saveThroughXslt, "ooxml:CT_Settings_saveThroughXslt" },
    { NS_ooxml::LN_CT_Settings_showXMLTags, "ooxml:CT_Settings_showXMLTags" },
    { NS_ooxml::LN_CT_Settings_alwaysMergeEmptyNamespace, "ooxml:CT_Settings_alwaysMergeEmptyNamespace" },
    { NS_ooxml::LN_CT_Settings_updateFields, "ooxml:CT_Settings_updateFields" },
    { NS_ooxml::LN_CT_Settings_hdrShapeDefaults, "ooxml:CT_Settings_hdrShapeDefaults" },
    { NS_ooxml::LN_CT_Settings_footnotePr, "ooxml:CT_Settings_footnotePr" },
    { NS_ooxml::LN_CT_Settings_endnotePr, "ooxml:CT_Settings_endnotePr" },
    { NS_ooxml::LN_CT_Settings_compat, "ooxml:CT_Settings_compat" },
    { NS_ooxml::LN_CT_Settings_docVars, "ooxml:CT_Settings_docVars" },
    { NS_ooxml::LN_CT_Settings_rsids, "ooxml:CT_Settings_rsids" },
    { NS_ooxml::LN_CT_Settings_uiCompat97To2003, "ooxml:CT_Settings_uiCompat97To2003" },
    { NS_ooxml::LN_CT_Settings_attachedSchema, "ooxml:CT_Settings_attachedSchema" },
    { NS_ooxml::LN_CT_Settings_themeFontLang, "ooxml:CT_Settings_themeFontLang" },
    { NS_ooxml::LN_CT_Settings_clrSchemeMapping, "ooxml:CT_Settings_clrSchemeMapping" },
    { NS_ooxml::LN_CT_Settings_doNotIncludeSubdocsInStats, "ooxml:CT_Settings_doNotIncludeSubdocsInStats" },
    { NS_ooxml::LN_CT_Settings_doNotAutoCompressPictures, "ooxml:CT_Settings_doNotAutoCompressPictures" },
    { NS_ooxml::LN_CT_Settings_forceUpgrade, "ooxml:CT_Settings_forceUpgrade" },
    { NS_ooxml::LN_CT_Settings_captions, "ooxml:CT_Settings_captions" },
    { NS_ooxml::LN_CT_Settings_readModeInkLockDown, "ooxml:CT_Settings_readModeInkLockDown" },
    { NS_ooxml::LN_CT_Settings_smartTagType, "ooxml:CT_Settings_smartTagType" },
    { NS_ooxml::LN_CT_Settings_shapeDefaults, "ooxml:CT_Settings_shapeDefaults" },
    { NS_ooxml::LN_CT_Settings_doNotEmbedSmartTags, "ooxml:CT_Settings_doNotEmbedSmartTags" },
    { NS_ooxml::LN_CT_Settings_decimalSymbol, "ooxml:CT_Settings_decimalSymbol" },
    { NS_ooxml::LN_CT_Settings_listSeparator, "ooxml:CT_Settings_listSeparator" },
    { NS_ooxml::LN_CT_FrameScrollbar_val, "ooxml:CT_FrameScrollbar_val" },
    { NS_ooxml::LN_CT_FrameLayout_val, "ooxml:CT_FrameLayout_val" },
    { NS_ooxml::LN_CT_LevelSuffix_val, "ooxml:CT_LevelSuffix_val" },
    { NS_ooxml::LN_CT_LevelText_val, "ooxml:CT_LevelText_val" },
    { NS_ooxml::LN_CT_LevelText_null, "ooxml:CT_LevelText_null" },
    { NS_ooxml::LN_CT_LvlLegacy_legacy, "ooxml:CT_LvlLegacy_legacy" },
    { NS_ooxml::LN_CT_LvlLegacy_legacySpace, "ooxml:CT_LvlLegacy_legacySpace" },
    { NS_ooxml::LN_CT_LvlLegacy_legacyIndent, "ooxml:CT_LvlLegacy_legacyIndent" },
    { NS_ooxml::LN_CT_Lvl_start, "ooxml:CT_Lvl_start" },
    { NS_ooxml::LN_CT_Lvl_numFmt, "ooxml:CT_Lvl_numFmt" },
    { NS_ooxml::LN_CT_Lvl_lvlRestart, "ooxml:CT_Lvl_lvlRestart" },
    { NS_ooxml::LN_CT_Lvl_pStyle, "ooxml:CT_Lvl_pStyle" },
    { NS_ooxml::LN_CT_Lvl_isLgl, "ooxml:CT_Lvl_isLgl" },
    { NS_ooxml::LN_CT_Lvl_suff, "ooxml:CT_Lvl_suff" },
    { NS_ooxml::LN_CT_Lvl_lvlText, "ooxml:CT_Lvl_lvlText" },
    { NS_ooxml::LN_CT_Lvl_lvlPicBulletId, "ooxml:CT_Lvl_lvlPicBulletId" },
    { NS_ooxml::LN_CT_Lvl_legacy, "ooxml:CT_Lvl_legacy" },
    { NS_ooxml::LN_CT_Lvl_lvlJc, "ooxml:CT_Lvl_lvlJc" },
    { NS_ooxml::LN_CT_Lvl_pPr, "ooxml:CT_Lvl_pPr" },
    { NS_ooxml::LN_CT_Lvl_rPr, "ooxml:CT_Lvl_rPr" },
    { NS_ooxml::LN_CT_Lvl_ilvl, "ooxml:CT_Lvl_ilvl" },
    { NS_ooxml::LN_CT_Lvl_tplc, "ooxml:CT_Lvl_tplc" },
    { NS_ooxml::LN_CT_Lvl_tentative, "ooxml:CT_Lvl_tentative" },
    { NS_ooxml::LN_Value_ST_MultiLevelType_singleLevel, "ooxml:Value_ST_MultiLevelType_singleLevel" },
    { NS_ooxml::LN_Value_ST_MultiLevelType_multilevel, "ooxml:Value_ST_MultiLevelType_multilevel" },
    { NS_ooxml::LN_Value_ST_MultiLevelType_hybridMultilevel, "ooxml:Value_ST_MultiLevelType_hybridMultilevel" },
    { NS_ooxml::LN_CT_MultiLevelType_val, "ooxml:CT_MultiLevelType_val" },
    { NS_ooxml::LN_CT_NumPicBullet_pict, "ooxml:CT_NumPicBullet_pict" },
    { NS_ooxml::LN_CT_NumPicBullet_numPicBulletId, "ooxml:CT_NumPicBullet_numPicBulletId" },
    { NS_ooxml::LN_CT_AbstractNum_nsid, "ooxml:CT_AbstractNum_nsid" },
    { NS_ooxml::LN_CT_AbstractNum_multiLevelType, "ooxml:CT_AbstractNum_multiLevelType" },
    { NS_ooxml::LN_CT_AbstractNum_tmpl, "ooxml:CT_AbstractNum_tmpl" },
    { NS_ooxml::LN_CT_AbstractNum_name, "ooxml:CT_AbstractNum_name" },
    { NS_ooxml::LN_CT_AbstractNum_styleLink, "ooxml:CT_AbstractNum_styleLink" },
    { NS_ooxml::LN_CT_AbstractNum_numStyleLink, "ooxml:CT_AbstractNum_numStyleLink" },
    { NS_ooxml::LN_CT_AbstractNum_lvl, "ooxml:CT_AbstractNum_lvl" },
    { NS_ooxml::LN_CT_AbstractNum_abstractNumId, "ooxml:CT_AbstractNum_abstractNumId" },
    { NS_ooxml::LN_CT_NumLvl_startOverride, "ooxml:CT_NumLvl_startOverride" },
    { NS_ooxml::LN_CT_NumLvl_lvl, "ooxml:CT_NumLvl_lvl" },
    { NS_ooxml::LN_CT_NumLvl_ilvl, "ooxml:CT_NumLvl_ilvl" },
    { NS_ooxml::LN_CT_Num_abstractNumId, "ooxml:CT_Num_abstractNumId" },
    { NS_ooxml::LN_CT_Num_lvlOverride, "ooxml:CT_Num_lvlOverride" },
    { NS_ooxml::LN_CT_Num_numId, "ooxml:CT_Num_numId" },
    { NS_ooxml::LN_NUMBERING, "ooxml:NUMBERING" },
    { NS_ooxml::LN_CT_Numbering_numPicBullet, "ooxml:CT_Numbering_numPicBullet" },
    { NS_ooxml::LN_CT_Numbering_abstractNum, "ooxml:CT_Numbering_abstractNum" },
    { NS_ooxml::LN_CT_Numbering_num, "ooxml:CT_Numbering_num" },
    { NS_ooxml::LN_CT_Numbering_numIdMacAtCleanup, "ooxml:CT_Numbering_numIdMacAtCleanup" },
    { NS_ooxml::LN_Value_ST_TblStyleOverrideType_wholeTable, "ooxml:Value_ST_TblStyleOverrideType_wholeTable" },
    { NS_ooxml::LN_Value_ST_TblStyleOverrideType_firstRow, "ooxml:Value_ST_TblStyleOverrideType_firstRow" },
    { NS_ooxml::LN_Value_ST_TblStyleOverrideType_lastRow, "ooxml:Value_ST_TblStyleOverrideType_lastRow" },
    { NS_ooxml::LN_Value_ST_TblStyleOverrideType_firstCol, "ooxml:Value_ST_TblStyleOverrideType_firstCol" },
    { NS_ooxml::LN_Value_ST_TblStyleOverrideType_lastCol, "ooxml:Value_ST_TblStyleOverrideType_lastCol" },
    { NS_ooxml::LN_Value_ST_TblStyleOverrideType_band1Vert, "ooxml:Value_ST_TblStyleOverrideType_band1Vert" },
    { NS_ooxml::LN_Value_ST_TblStyleOverrideType_band2Vert, "ooxml:Value_ST_TblStyleOverrideType_band2Vert" },
    { NS_ooxml::LN_Value_ST_TblStyleOverrideType_band1Horz, "ooxml:Value_ST_TblStyleOverrideType_band1Horz" },
    { NS_ooxml::LN_Value_ST_TblStyleOverrideType_band2Horz, "ooxml:Value_ST_TblStyleOverrideType_band2Horz" },
    { NS_ooxml::LN_Value_ST_TblStyleOverrideType_neCell, "ooxml:Value_ST_TblStyleOverrideType_neCell" },
    { NS_ooxml::LN_Value_ST_TblStyleOverrideType_nwCell, "ooxml:Value_ST_TblStyleOverrideType_nwCell" },
    { NS_ooxml::LN_Value_ST_TblStyleOverrideType_seCell, "ooxml:Value_ST_TblStyleOverrideType_seCell" },
    { NS_ooxml::LN_Value_ST_TblStyleOverrideType_swCell, "ooxml:Value_ST_TblStyleOverrideType_swCell" },
    { NS_ooxml::LN_CT_PPrBase, "ooxml:CT_PPrBase" },
    { NS_ooxml::LN_EG_RPrBase, "ooxml:EG_RPrBase" },
    { NS_ooxml::LN_CT_TblPrBase, "ooxml:CT_TblPrBase" },
    { NS_ooxml::LN_CT_TrPrBase, "ooxml:CT_TrPrBase" },
    { NS_ooxml::LN_CT_TcPrBase, "ooxml:CT_TcPrBase" },
    { NS_ooxml::LN_CT_TblStyleOverrideType, "ooxml:CT_TblStyleOverrideType" },
    { NS_ooxml::LN_Value_ST_StyleType_paragraph, "ooxml:Value_ST_StyleType_paragraph" },
    { NS_ooxml::LN_Value_ST_StyleType_character, "ooxml:Value_ST_StyleType_character" },
    { NS_ooxml::LN_Value_ST_StyleType_table, "ooxml:Value_ST_StyleType_table" },
    { NS_ooxml::LN_Value_ST_StyleType_numbering, "ooxml:Value_ST_StyleType_numbering" },
    { NS_ooxml::LN_CT_Style_name, "ooxml:CT_Style_name" },
    { NS_ooxml::LN_CT_Style_aliases, "ooxml:CT_Style_aliases" },
    { NS_ooxml::LN_CT_Style_basedOn, "ooxml:CT_Style_basedOn" },
    { NS_ooxml::LN_CT_Style_next, "ooxml:CT_Style_next" },
    { NS_ooxml::LN_CT_Style_link, "ooxml:CT_Style_link" },
    { NS_ooxml::LN_CT_Style_autoRedefine, "ooxml:CT_Style_autoRedefine" },
    { NS_ooxml::LN_CT_Style_hidden, "ooxml:CT_Style_hidden" },
    { NS_ooxml::LN_CT_Style_uiPriority, "ooxml:CT_Style_uiPriority" },
    { NS_ooxml::LN_CT_Style_semiHidden, "ooxml:CT_Style_semiHidden" },
    { NS_ooxml::LN_CT_Style_unhideWhenUsed, "ooxml:CT_Style_unhideWhenUsed" },
    { NS_ooxml::LN_CT_Style_qFormat, "ooxml:CT_Style_qFormat" },
    { NS_ooxml::LN_CT_Style_locked, "ooxml:CT_Style_locked" },
    { NS_ooxml::LN_CT_Style_personal, "ooxml:CT_Style_personal" },
    { NS_ooxml::LN_CT_Style_personalCompose, "ooxml:CT_Style_personalCompose" },
    { NS_ooxml::LN_CT_Style_personalReply, "ooxml:CT_Style_personalReply" },
    { NS_ooxml::LN_CT_Style_rsid, "ooxml:CT_Style_rsid" },
    { NS_ooxml::LN_CT_Style_pPr, "ooxml:CT_Style_pPr" },
    { NS_ooxml::LN_CT_Style_rPr, "ooxml:CT_Style_rPr" },
    { NS_ooxml::LN_CT_Style_tblPr, "ooxml:CT_Style_tblPr" },
    { NS_ooxml::LN_CT_Style_trPr, "ooxml:CT_Style_trPr" },
    { NS_ooxml::LN_CT_Style_tcPr, "ooxml:CT_Style_tcPr" },
    { NS_ooxml::LN_CT_Style_tblStylePr, "ooxml:CT_Style_tblStylePr" },
    { NS_ooxml::LN_CT_Style_type, "ooxml:CT_Style_type" },
    { NS_ooxml::LN_CT_Style_styleId, "ooxml:CT_Style_styleId" },
    { NS_ooxml::LN_CT_Style_default, "ooxml:CT_Style_default" },
    { NS_ooxml::LN_CT_Style_customStyle, "ooxml:CT_Style_customStyle" },
    { NS_ooxml::LN_STYLESHEET, "ooxml:STYLESHEET" },
    { NS_ooxml::LN_CT_Panose_val, "ooxml:CT_Panose_val" },
    { NS_ooxml::LN_CT_Charset_val, "ooxml:CT_Charset_val" },
    { NS_ooxml::LN_CT_Charset_characterSet, "ooxml:CT_Charset_characterSet" },
    { NS_ooxml::LN_Value_ST_FontFamily_decorative, "ooxml:Value_ST_FontFamily_decorative" },
    { NS_ooxml::LN_Value_ST_FontFamily_modern, "ooxml:Value_ST_FontFamily_modern" },
    { NS_ooxml::LN_Value_ST_FontFamily_roman, "ooxml:Value_ST_FontFamily_roman" },
    { NS_ooxml::LN_Value_ST_FontFamily_script, "ooxml:Value_ST_FontFamily_script" },
    { NS_ooxml::LN_Value_ST_FontFamily_swiss, "ooxml:Value_ST_FontFamily_swiss" },
    { NS_ooxml::LN_Value_ST_FontFamily_auto, "ooxml:Value_ST_FontFamily_auto" },
    { NS_ooxml::LN_CT_FontFamily_val, "ooxml:CT_FontFamily_val" },
    { NS_ooxml::LN_Value_ST_Pitch_fixed, "ooxml:Value_ST_Pitch_fixed" },
    { NS_ooxml::LN_Value_ST_Pitch_variable, "ooxml:Value_ST_Pitch_variable" },
    { NS_ooxml::LN_Value_ST_Pitch_default, "ooxml:Value_ST_Pitch_default" },
    { NS_ooxml::LN_CT_Pitch_val, "ooxml:CT_Pitch_val" },
    { NS_ooxml::LN_CT_FontSig_usb0, "ooxml:CT_FontSig_usb0" },
    { NS_ooxml::LN_CT_FontSig_usb1, "ooxml:CT_FontSig_usb1" },
    { NS_ooxml::LN_CT_FontSig_usb2, "ooxml:CT_FontSig_usb2" },
    { NS_ooxml::LN_CT_FontSig_usb3, "ooxml:CT_FontSig_usb3" },
    { NS_ooxml::LN_CT_FontSig_csb0, "ooxml:CT_FontSig_csb0" },
    { NS_ooxml::LN_CT_FontSig_csb1, "ooxml:CT_FontSig_csb1" },
    { NS_ooxml::LN_CT_FontRel_fontKey, "ooxml:CT_FontRel_fontKey" },
    { NS_ooxml::LN_CT_FontRel_subsetted, "ooxml:CT_FontRel_subsetted" },
    { NS_ooxml::LN_CT_Font_altName, "ooxml:CT_Font_altName" },
    { NS_ooxml::LN_CT_Font_panose1, "ooxml:CT_Font_panose1" },
    { NS_ooxml::LN_CT_Font_charset, "ooxml:CT_Font_charset" },
    { NS_ooxml::LN_CT_Font_characterSet, "ooxml:CT_Font_characterSet" },
    { NS_ooxml::LN_CT_Font_family, "ooxml:CT_Font_family" },
    { NS_ooxml::LN_CT_Font_notTrueType, "ooxml:CT_Font_notTrueType" },
    { NS_ooxml::LN_CT_Font_pitch, "ooxml:CT_Font_pitch" },
    { NS_ooxml::LN_CT_Font_sig, "ooxml:CT_Font_sig" },
    { NS_ooxml::LN_CT_Font_embedRegular, "ooxml:CT_Font_embedRegular" },
    { NS_ooxml::LN_CT_Font_embedBold, "ooxml:CT_Font_embedBold" },
    { NS_ooxml::LN_CT_Font_embedItalic, "ooxml:CT_Font_embedItalic" },
    { NS_ooxml::LN_CT_Font_embedBoldItalic, "ooxml:CT_Font_embedBoldItalic" },
    { NS_ooxml::LN_CT_Font_name, "ooxml:CT_Font_name" },
    { NS_ooxml::LN_FONTTABLE, "ooxml:FONTTABLE" },
    { NS_ooxml::LN_EG_BlockLevelElts_altChunk, "ooxml:EG_BlockLevelElts_altChunk" },
    { NS_ooxml::LN_EG_RunLevelElts_proofErr, "ooxml:EG_RunLevelElts_proofErr" },
    { NS_ooxml::LN_EG_RunLevelElts_permStart, "ooxml:EG_RunLevelElts_permStart" },
    { NS_ooxml::LN_EG_RunLevelElts_permEnd, "ooxml:EG_RunLevelElts_permEnd" },
    { NS_ooxml::LN_EG_RunLevelElts_ins, "ooxml:EG_RunLevelElts_ins" },
    { NS_ooxml::LN_EG_RunLevelElts_del, "ooxml:EG_RunLevelElts_del" },
    { NS_ooxml::LN_EG_RunLevelElts_moveFrom, "ooxml:EG_RunLevelElts_moveFrom" },
    { NS_ooxml::LN_EG_RunLevelElts_moveTo, "ooxml:EG_RunLevelElts_moveTo" },
    { NS_ooxml::LN_CT_ShapeDefaults_v_fill, "ooxml:CT_ShapeDefaults_v_fill" },
    { NS_ooxml::LN_CT_ShapeDefaults_v_stroke, "ooxml:CT_ShapeDefaults_v_stroke" },
    { NS_ooxml::LN_CT_ShapeDefaults_v_textbox, "ooxml:CT_ShapeDefaults_v_textbox" },
    { NS_ooxml::LN_CT_ShapeDefaults_v_shadow, "ooxml:CT_ShapeDefaults_v_shadow" },
    { NS_ooxml::LN_CT_ShapeDefaults_colormru, "ooxml:CT_ShapeDefaults_colormru" },
    { NS_ooxml::LN_CT_ShapeDefaults_colormenu, "ooxml:CT_ShapeDefaults_colormenu" },
    { NS_ooxml::LN_CT_ShapeDefaults_spidmax, "ooxml:CT_ShapeDefaults_spidmax" },
    { NS_ooxml::LN_CT_ShapeDefaults_style, "ooxml:CT_ShapeDefaults_style" },
    { NS_ooxml::LN_CT_ShapeDefaults_fill, "ooxml:CT_ShapeDefaults_fill" },
    { NS_ooxml::LN_CT_ShapeDefaults_fillcolor, "ooxml:CT_ShapeDefaults_fillcolor" },
    { NS_ooxml::LN_CT_ShapeDefaults_stroke, "ooxml:CT_ShapeDefaults_stroke" },
    { NS_ooxml::LN_CT_ShapeDefaults_strokecolor, "ooxml:CT_ShapeDefaults_strokecolor" },
    { NS_ooxml::LN_CT_ShapeDefaults_allowincell, "ooxml:CT_ShapeDefaults_allowincell" },
    { NS_ooxml::LN_CT_SmartTagType_namespaceuri, "ooxml:CT_SmartTagType_namespaceuri" },
    { NS_ooxml::LN_CT_SmartTagType_name, "ooxml:CT_SmartTagType_name" },
    { NS_ooxml::LN_CT_SmartTagType_url, "ooxml:CT_SmartTagType_url" },
    { NS_ooxml::LN_Value_St_ThemeColor_dark1, "ooxml:Value_St_ThemeColor_dark1" },
    { NS_ooxml::LN_Value_St_ThemeColor_light1, "ooxml:Value_St_ThemeColor_light1" },
    { NS_ooxml::LN_Value_St_ThemeColor_dark2, "ooxml:Value_St_ThemeColor_dark2" },
    { NS_ooxml::LN_Value_St_ThemeColor_light2, "ooxml:Value_St_ThemeColor_light2" },
    { NS_ooxml::LN_Value_St_ThemeColor_accent1, "ooxml:Value_St_ThemeColor_accent1" },
    { NS_ooxml::LN_Value_St_ThemeColor_accent2, "ooxml:Value_St_ThemeColor_accent2" },
    { NS_ooxml::LN_Value_St_ThemeColor_accent3, "ooxml:Value_St_ThemeColor_accent3" },
    { NS_ooxml::LN_Value_St_ThemeColor_accent4, "ooxml:Value_St_ThemeColor_accent4" },
    { NS_ooxml::LN_Value_St_ThemeColor_accent5, "ooxml:Value_St_ThemeColor_accent5" },
    { NS_ooxml::LN_Value_St_ThemeColor_accent6, "ooxml:Value_St_ThemeColor_accent6" },
    { NS_ooxml::LN_Value_St_ThemeColor_hyperlink, "ooxml:Value_St_ThemeColor_hyperlink" },
    { NS_ooxml::LN_Value_St_ThemeColor_followedHyperlink, "ooxml:Value_St_ThemeColor_followedHyperlink" },
    { NS_ooxml::LN_Value_St_ThemeColor_none, "ooxml:Value_St_ThemeColor_none" },
    { NS_ooxml::LN_Value_St_ThemeColor_background1, "ooxml:Value_St_ThemeColor_background1" },
    { NS_ooxml::LN_Value_St_ThemeColor_text1, "ooxml:Value_St_ThemeColor_text1" },
    { NS_ooxml::LN_Value_St_ThemeColor_background2, "ooxml:Value_St_ThemeColor_background2" },
    { NS_ooxml::LN_Value_St_ThemeColor_text2, "ooxml:Value_St_ThemeColor_text2" },
    { NS_ooxml::LN_CT_DocPartBehavior_val, "ooxml:CT_DocPartBehavior_val" },
    { NS_ooxml::LN_CT_DocPartType_val, "ooxml:CT_DocPartType_val" },
    { NS_ooxml::LN_CT_DocPartGallery_val, "ooxml:CT_DocPartGallery_val" },
    { NS_ooxml::LN_CT_DocPartName_val, "ooxml:CT_DocPartName_val" },
    { NS_ooxml::LN_CT_DocPartName_decorated, "ooxml:CT_DocPartName_decorated" },
    { NS_ooxml::LN_settings_settings, "ooxml:settings_settings" },
    { NS_ooxml::LN_Value_doc_ST_CaptionPos_above, "ooxml:Value_doc_ST_CaptionPos_above" },
    { NS_ooxml::LN_Value_doc_ST_CaptionPos_below, "ooxml:Value_doc_ST_CaptionPos_below" },
    { NS_ooxml::LN_Value_doc_ST_CaptionPos_left, "ooxml:Value_doc_ST_CaptionPos_left" },
    { NS_ooxml::LN_Value_doc_ST_CaptionPos_right, "ooxml:Value_doc_ST_CaptionPos_right" },
    { NS_ooxml::LN_CT_Caption_name, "ooxml:CT_Caption_name" },
    { NS_ooxml::LN_CT_Caption_pos, "ooxml:CT_Caption_pos" },
    { NS_ooxml::LN_CT_Caption_chapNum, "ooxml:CT_Caption_chapNum" },
    { NS_ooxml::LN_CT_Caption_heading, "ooxml:CT_Caption_heading" },
    { NS_ooxml::LN_CT_Caption_noLabel, "ooxml:CT_Caption_noLabel" },
    { NS_ooxml::LN_CT_Caption_numFmt, "ooxml:CT_Caption_numFmt" },
    { NS_ooxml::LN_CT_Caption_sep, "ooxml:CT_Caption_sep" },
    { NS_ooxml::LN_CT_AutoCaption_name, "ooxml:CT_AutoCaption_name" },
    { NS_ooxml::LN_CT_AutoCaption_caption, "ooxml:CT_AutoCaption_caption" },
    { NS_ooxml::LN_CT_AutoCaptions_autoCaption, "ooxml:CT_AutoCaptions_autoCaption" },
    { NS_ooxml::LN_CT_Captions_caption, "ooxml:CT_Captions_caption" },
    { NS_ooxml::LN_CT_Captions_autoCaptions, "ooxml:CT_Captions_autoCaptions" },
    { NS_ooxml::LN_CT_DocumentBase_background, "ooxml:CT_DocumentBase_background" },
    { NS_ooxml::LN_CT_DocPartPr_name, "ooxml:CT_DocPartPr_name" },
    { NS_ooxml::LN_CT_DocPartPr_category, "ooxml:CT_DocPartPr_category" },
    { NS_ooxml::LN_CT_DocPartCategory_gallery, "ooxml:CT_DocPartCategory_gallery" },

   };

    std::string QNameToString(Id qName)
    {
        auto it = g_QNameToStringMap.find(qName);
        if (it == g_QNameToStringMap.end())
            return std::string();

        return it->second;
    }

#endif
}

