#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x006e\x006e";
static constexpr OUStringLiteral langDefaultName = u"\x004e\x006f\x0072\x0077\x0065\x0067\x0069\x0061\x006e\x0020\x004e\x0079\x006e\x006f\x0072\x0073\x006b";
static constexpr OUStringLiteral countryID = u"\x004e\x004f";
static constexpr OUStringLiteral countryDefaultName = u"\x004e\x006f\x0072\x0077\x0061\x0079";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_nn_NO(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_nn_NO(sal_Int16& count)
{
	return getLocaleItem_no_NO(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x6b, 0x72, 0x2d, 0x38, 0x31, 0x34, 0x5d, 0x0};
extern OUString const * getAllFormats0_no_NO(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_nn_NO(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_no_NO(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_nn_NO(sal_Int16& count)
{
	return getDateAcceptancePatterns_no_NO(count);
}
extern const OUString *  getCollatorImplementation_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_nn_NO(sal_Int16& count)
{
	return getCollatorImplementation_no_NO(count);
}
extern const OUString *  getCollationOptions_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_nn_NO(sal_Int16& count)
{
	return getCollationOptions_no_NO(count);
}
extern const OUString *  getSearchOptions_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_nn_NO(sal_Int16& count)
{
	return getSearchOptions_no_NO(count);
}
extern const OUString *  getIndexAlgorithm_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_nn_NO(sal_Int16& count)
{
	return getIndexAlgorithm_no_NO(count);
}
extern const OUString *  getUnicodeScripts_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_nn_NO(sal_Int16& count)
{
	return getUnicodeScripts_no_NO(count);
}
extern const OUString *  getFollowPageWords_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_nn_NO(sal_Int16& count)
{
	return getFollowPageWords_no_NO(count);
}
static constexpr OUStringLiteral calendarID0 = u"\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral defaultCalendar0 = u"\x1";
static constexpr OUStringLiteral dayID00 = u"\x0073\x0075\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName00 = u"\x0073\x0075\x002e";
static constexpr OUStringLiteral dayDefaultFullName00 = u"\x0073\x0075\x006e\x0064\x0061\x0067";
static constexpr OUStringLiteral dayDefaultNarrowName00 = u"\x0073";
static constexpr OUStringLiteral dayID01 = u"\x006d\x006f\x006e";
static constexpr OUStringLiteral dayDefaultAbbrvName01 = u"\x006d\x00e5\x002e";
static constexpr OUStringLiteral dayDefaultFullName01 = u"\x006d\x00e5\x006e\x0064\x0061\x0067";
static constexpr OUStringLiteral dayDefaultNarrowName01 = u"\x006d";
static constexpr OUStringLiteral dayID02 = u"\x0074\x0075\x0065";
static constexpr OUStringLiteral dayDefaultAbbrvName02 = u"\x0074\x0079\x002e";
static constexpr OUStringLiteral dayDefaultFullName02 = u"\x0074\x0079\x0073\x0064\x0061\x0067";
static constexpr OUStringLiteral dayDefaultNarrowName02 = u"\x0074";
static constexpr OUStringLiteral dayID03 = u"\x0077\x0065\x0064";
static constexpr OUStringLiteral dayDefaultAbbrvName03 = u"\x006f\x006e\x002e";
static constexpr OUStringLiteral dayDefaultFullName03 = u"\x006f\x006e\x0073\x0064\x0061\x0067";
static constexpr OUStringLiteral dayDefaultNarrowName03 = u"\x006f";
static constexpr OUStringLiteral dayID04 = u"\x0074\x0068\x0075";
static constexpr OUStringLiteral dayDefaultAbbrvName04 = u"\x0074\x006f\x002e";
static constexpr OUStringLiteral dayDefaultFullName04 = u"\x0074\x006f\x0072\x0073\x0064\x0061\x0067";
static constexpr OUStringLiteral dayDefaultNarrowName04 = u"\x0074";
static constexpr OUStringLiteral dayID05 = u"\x0066\x0072\x0069";
static constexpr OUStringLiteral dayDefaultAbbrvName05 = u"\x0066\x0072\x002e";
static constexpr OUStringLiteral dayDefaultFullName05 = u"\x0066\x0072\x0065\x0064\x0061\x0067";
static constexpr OUStringLiteral dayDefaultNarrowName05 = u"\x0066";
static constexpr OUStringLiteral dayID06 = u"\x0073\x0061\x0074";
static constexpr OUStringLiteral dayDefaultAbbrvName06 = u"\x006c\x0061\x002e";
static constexpr OUStringLiteral dayDefaultFullName06 = u"\x006c\x0061\x0075\x0072\x0064\x0061\x0067";
static constexpr OUStringLiteral dayDefaultNarrowName06 = u"\x006c";
static constexpr OUStringLiteral monthRef0 = u"\x0072\x0065\x0066";
static constexpr OUStringLiteral monthRefName0 = u"\x006e\x006f\x005f\x004e\x004f\x005f\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral genitiveMonthRef0 = u"\x0072\x0065\x0066";
static constexpr OUStringLiteral genitiveMonthRefName0 = u"\x006e\x006f\x005f\x004e\x004f\x005f\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral partitiveMonthRef0 = u"\x0072\x0065\x0066";
static constexpr OUStringLiteral partitiveMonthRefName0 = u"\x006e\x006f\x005f\x004e\x004f\x005f\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral eraRef0 = u"\x0072\x0065\x0066";
static constexpr OUStringLiteral eraRefName0 = u"\x006e\x006f\x005f\x004e\x004f\x005f\x0067\x0072\x0065\x0067\x006f\x0072\x0069\x0061\x006e";
static constexpr OUStringLiteral startDayOfWeek0 = u"\x006d\x006f\x006e";
static constexpr OUStringLiteral minimalDaysInFirstWeek0 = u"\x4";
static const sal_Int16 calendarsCount = 1;

static constexpr OUStringLiteral nbOfDays = u"\x7";
static constexpr OUStringLiteral nbOfMonths = u"\x0";
static constexpr OUStringLiteral nbOfGenitiveMonths = u"\x0";
static constexpr OUStringLiteral nbOfPartitiveMonths = u"\x0";
static constexpr OUStringLiteral nbOfEras = u"\x0";
static constexpr OUString calendars[] = {
	nbOfDays,
	nbOfMonths,
	nbOfGenitiveMonths,
	nbOfPartitiveMonths,
	nbOfEras,
	calendarID0,
	defaultCalendar0,
	dayID00,
	dayDefaultAbbrvName00,
	dayDefaultFullName00,
	dayDefaultNarrowName00,
	dayID01,
	dayDefaultAbbrvName01,
	dayDefaultFullName01,
	dayDefaultNarrowName01,
	dayID02,
	dayDefaultAbbrvName02,
	dayDefaultFullName02,
	dayDefaultNarrowName02,
	dayID03,
	dayDefaultAbbrvName03,
	dayDefaultFullName03,
	dayDefaultNarrowName03,
	dayID04,
	dayDefaultAbbrvName04,
	dayDefaultFullName04,
	dayDefaultNarrowName04,
	dayID05,
	dayDefaultAbbrvName05,
	dayDefaultFullName05,
	dayDefaultNarrowName05,
	dayID06,
	dayDefaultAbbrvName06,
	dayDefaultFullName06,
	dayDefaultNarrowName06,
	monthRef0,
	monthRefName0,
	genitiveMonthRef0,
	genitiveMonthRefName0,
	partitiveMonthRef0,
	partitiveMonthRefName0,
	eraRef0,
	eraRefName0,
	startDayOfWeek0,
	minimalDaysInFirstWeek0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCalendars_nn_NO(sal_Int16& count)
{
	count = calendarsCount;
	return (OUString const *)calendars;
}
extern const OUString *  getAllCurrencies_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCurrencies_nn_NO(sal_Int16& count)
{
	return getAllCurrencies_no_NO(count);
}
extern const OUString *  getTransliterations_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_nn_NO(sal_Int16& count)
{
	return getTransliterations_no_NO(count);
}
extern const OUString *  getForbiddenCharacters_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_nn_NO(sal_Int16& count)
{
	return getForbiddenCharacters_no_NO(count);
}
extern const OUString *  getBreakIteratorRules_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_nn_NO(sal_Int16& count)
{
	return getBreakIteratorRules_no_NO(count);
}
extern const OUString *  getReservedWords_no_NO(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_nn_NO(sal_Int16& count)
{
	return getReservedWords_no_NO(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_no_NO(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_nn_NO(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_no_NO(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_no_NO(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_nn_NO(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_no_NO(nStyles, nLevels, nAttributes);
}
} // extern "C"

