#ifndef SBK_KXMLGUIWINDOWWRAPPER_H
#define SBK_KXMLGUIWINDOWWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kxmlguiwindow.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KXmlGuiWindowWrapper : public KXmlGuiWindow
{
public:
    KXmlGuiWindowWrapper(::QWidget * parent = nullptr, ::QFlags<Qt::WindowType> flags = Qt::WindowFlags());
    KXmlGuiWindowWrapper(const KXmlGuiWindowWrapper &) = delete;
    KXmlGuiWindowWrapper& operator=(const KXmlGuiWindowWrapper &) = delete;
    KXmlGuiWindowWrapper(KXmlGuiWindowWrapper &&) = delete;
    KXmlGuiWindowWrapper& operator=(KXmlGuiWindowWrapper &&) = delete;
    ~KXmlGuiWindowWrapper() override;

    ::KActionCollection * actionCollection() const override;
    void actionEvent(::QActionEvent * event) override;
    void changeEvent(::QEvent * event) override;
    void childEvent(::QChildEvent * event) override;
    void closeEvent(::QCloseEvent * arg__1) override;
    ::QString componentName() const override;
    void configureToolbars() override;
    void connectNotify(const ::QMetaMethod & signal) override;
    ::QStringList containerTags() const override;
    void contextMenuEvent(::QContextMenuEvent * event) override;
    ::QMenu * createPopupMenu() override;
    void customEvent(::QEvent * event) override;
    ::QStringList customTags() const override;
    int devType() const override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent(::QDragEnterEvent * event) override;
    void dragLeaveEvent(::QDragLeaveEvent * event) override;
    void dragMoveEvent(::QDragMoveEvent * event) override;
    void dropEvent(::QDropEvent * event) override;
    void enterEvent(::QEnterEvent * event) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void focusInEvent(::QFocusEvent * event) override;
    bool focusNextPrevChild(bool next) override;
    void focusOutEvent(::QFocusEvent * event) override;
    ::KXMLGUIFactory * guiFactory() override;
    static ::KXMLGUIFactory * sbk_o_guiFactory(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void hideEvent(::QHideEvent * event) override;
    void initPainter(::QPainter * painter) const override;
    void inputMethodEvent(::QInputMethodEvent * event) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery arg__1) const override;
    void keyPressEvent(::QKeyEvent * keyEvent) override;
    void keyReleaseEvent(::QKeyEvent * event) override;
    void leaveEvent(::QEvent * event) override;
    ::QString localXMLFile() const override;
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    ::QSize minimumSizeHint() const override;
    void mouseDoubleClickEvent(::QMouseEvent * event) override;
    void mouseMoveEvent(::QMouseEvent * event) override;
    void mousePressEvent(::QMouseEvent * event) override;
    void mouseReleaseEvent(::QMouseEvent * event) override;
    void moveEvent(::QMoveEvent * event) override;
    bool nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result) override;
    ::QPaintEngine * paintEngine() const override;
    void paintEvent(::QPaintEvent * event) override;
    bool queryClose() override;
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    void resizeEvent(::QResizeEvent * event) override;
    void saveNewToolbarConfig() override;
    void setCaption(const ::QString & caption) override;
    void setCaption(const ::QString & caption, bool modified) override;
    void setComponentName(const ::QString & componentName, const ::QString & componentDisplayName) override;
    void setLocalXMLFile(const ::QString & file) override;
    void setPlainCaption(const ::QString & caption) override;
    void setVisible(bool visible) override;
    void setXML(const ::QString & document, bool merge = false) override;
    void setXMLFile(const ::QString & file, bool merge = false, bool setXMLDoc = true) override;
    ::QPainter * sharedPainter() const override;
    void showEvent(::QShowEvent * event) override;
    ::QSize sizeHint() const override;
    void slotStateChanged(const ::QString & newstate) override;
    // Inherited overloads, because the using keyword sux
    void slotStateChanged(const ::QString & newstate, bool reverse) { KXmlGuiWindow::slotStateChanged(newstate, reverse); }

    void stateChanged(const ::QString & newstate, ::KXMLGUIClient::ReverseStateChange reverse = KXMLGUIClient::ReverseStateChange::StateNoReverse) override;
    void tabletEvent(::QTabletEvent * event) override;
    void timerEvent(::QTimerEvent * event) override;
    void wheelEvent(::QWheelEvent * event) override;
    ::QString xmlFile() const override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 67> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KXMLGUIWINDOWWRAPPER_H
