#ifndef itkImageToVideoFilterSwigInterface_h
#define itkImageToVideoFilterSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkVideoStream.h"
#include "itkImageToVideoFilter.h"

using itkImageToVideoFilterISC3 = itk::ImageToVideoFilter< itk::Image< signed char,3 > >;
using itkImageToVideoFilterISC3_Pointer = itk::ImageToVideoFilter< itk::Image< signed char,3 > >::Pointer;
using itkImageToVideoFilterVISC3VISC2 = itk::ImageToVideoFilter< itk::VectorImage< signed char,3 >, itk::VideoStream<itk::VectorImage< signed char,2 >> >;
using itkImageToVideoFilterVISC3VISC2_Pointer = itk::ImageToVideoFilter< itk::VectorImage< signed char,3 >, itk::VideoStream<itk::VectorImage< signed char,2 >> >::Pointer;
using itkImageToVideoFilterISS3 = itk::ImageToVideoFilter< itk::Image< signed short,3 > >;
using itkImageToVideoFilterISS3_Pointer = itk::ImageToVideoFilter< itk::Image< signed short,3 > >::Pointer;
using itkImageToVideoFilterVISS3VISS2 = itk::ImageToVideoFilter< itk::VectorImage< signed short,3 >, itk::VideoStream<itk::VectorImage< signed short,2 >> >;
using itkImageToVideoFilterVISS3VISS2_Pointer = itk::ImageToVideoFilter< itk::VectorImage< signed short,3 >, itk::VideoStream<itk::VectorImage< signed short,2 >> >::Pointer;
using itkImageToVideoFilterIUC3 = itk::ImageToVideoFilter< itk::Image< unsigned char,3 > >;
using itkImageToVideoFilterIUC3_Pointer = itk::ImageToVideoFilter< itk::Image< unsigned char,3 > >::Pointer;
using itkImageToVideoFilterVIUC3VIUC2 = itk::ImageToVideoFilter< itk::VectorImage< unsigned char,3 >, itk::VideoStream<itk::VectorImage< unsigned char,2 >> >;
using itkImageToVideoFilterVIUC3VIUC2_Pointer = itk::ImageToVideoFilter< itk::VectorImage< unsigned char,3 >, itk::VideoStream<itk::VectorImage< unsigned char,2 >> >::Pointer;
using itkImageToVideoFilterIULL3 = itk::ImageToVideoFilter< itk::Image< unsigned long long,3 > >;
using itkImageToVideoFilterIULL3_Pointer = itk::ImageToVideoFilter< itk::Image< unsigned long long,3 > >::Pointer;
using itkImageToVideoFilterVIULL3VIULL2 = itk::ImageToVideoFilter< itk::VectorImage< unsigned long long,3 >, itk::VideoStream<itk::VectorImage< unsigned long long,2 >> >;
using itkImageToVideoFilterVIULL3VIULL2_Pointer = itk::ImageToVideoFilter< itk::VectorImage< unsigned long long,3 >, itk::VideoStream<itk::VectorImage< unsigned long long,2 >> >::Pointer;
using itkImageToVideoFilterIUS3 = itk::ImageToVideoFilter< itk::Image< unsigned short,3 > >;
using itkImageToVideoFilterIUS3_Pointer = itk::ImageToVideoFilter< itk::Image< unsigned short,3 > >::Pointer;
using itkImageToVideoFilterVIUS3VIUS2 = itk::ImageToVideoFilter< itk::VectorImage< unsigned short,3 >, itk::VideoStream<itk::VectorImage< unsigned short,2 >> >;
using itkImageToVideoFilterVIUS3VIUS2_Pointer = itk::ImageToVideoFilter< itk::VectorImage< unsigned short,3 >, itk::VideoStream<itk::VectorImage< unsigned short,2 >> >::Pointer;
using itkImageToVideoFilterIF3 = itk::ImageToVideoFilter< itk::Image< float,3 > >;
using itkImageToVideoFilterIF3_Pointer = itk::ImageToVideoFilter< itk::Image< float,3 > >::Pointer;
using itkImageToVideoFilterVIF3VIF2 = itk::ImageToVideoFilter< itk::VectorImage< float,3 >, itk::VideoStream<itk::VectorImage< float,2 >> >;
using itkImageToVideoFilterVIF3VIF2_Pointer = itk::ImageToVideoFilter< itk::VectorImage< float,3 >, itk::VideoStream<itk::VectorImage< float,2 >> >::Pointer;
using itkImageToVideoFilterID3 = itk::ImageToVideoFilter< itk::Image< double,3 > >;
using itkImageToVideoFilterID3_Pointer = itk::ImageToVideoFilter< itk::Image< double,3 > >::Pointer;
using itkImageToVideoFilterVID3VID2 = itk::ImageToVideoFilter< itk::VectorImage< double,3 >, itk::VideoStream<itk::VectorImage< double,2 >> >;
using itkImageToVideoFilterVID3VID2_Pointer = itk::ImageToVideoFilter< itk::VectorImage< double,3 >, itk::VideoStream<itk::VectorImage< double,2 >> >::Pointer;
using itkImageToVideoFilterISC4 = itk::ImageToVideoFilter< itk::Image< signed char,4 > >;
using itkImageToVideoFilterISC4_Pointer = itk::ImageToVideoFilter< itk::Image< signed char,4 > >::Pointer;
using itkImageToVideoFilterVISC4VISC3 = itk::ImageToVideoFilter< itk::VectorImage< signed char,4 >, itk::VideoStream<itk::VectorImage< signed char,3 >> >;
using itkImageToVideoFilterVISC4VISC3_Pointer = itk::ImageToVideoFilter< itk::VectorImage< signed char,4 >, itk::VideoStream<itk::VectorImage< signed char,3 >> >::Pointer;
using itkImageToVideoFilterISS4 = itk::ImageToVideoFilter< itk::Image< signed short,4 > >;
using itkImageToVideoFilterISS4_Pointer = itk::ImageToVideoFilter< itk::Image< signed short,4 > >::Pointer;
using itkImageToVideoFilterVISS4VISS3 = itk::ImageToVideoFilter< itk::VectorImage< signed short,4 >, itk::VideoStream<itk::VectorImage< signed short,3 >> >;
using itkImageToVideoFilterVISS4VISS3_Pointer = itk::ImageToVideoFilter< itk::VectorImage< signed short,4 >, itk::VideoStream<itk::VectorImage< signed short,3 >> >::Pointer;
using itkImageToVideoFilterIUC4 = itk::ImageToVideoFilter< itk::Image< unsigned char,4 > >;
using itkImageToVideoFilterIUC4_Pointer = itk::ImageToVideoFilter< itk::Image< unsigned char,4 > >::Pointer;
using itkImageToVideoFilterVIUC4VIUC3 = itk::ImageToVideoFilter< itk::VectorImage< unsigned char,4 >, itk::VideoStream<itk::VectorImage< unsigned char,3 >> >;
using itkImageToVideoFilterVIUC4VIUC3_Pointer = itk::ImageToVideoFilter< itk::VectorImage< unsigned char,4 >, itk::VideoStream<itk::VectorImage< unsigned char,3 >> >::Pointer;
using itkImageToVideoFilterIULL4 = itk::ImageToVideoFilter< itk::Image< unsigned long long,4 > >;
using itkImageToVideoFilterIULL4_Pointer = itk::ImageToVideoFilter< itk::Image< unsigned long long,4 > >::Pointer;
using itkImageToVideoFilterVIULL4VIULL3 = itk::ImageToVideoFilter< itk::VectorImage< unsigned long long,4 >, itk::VideoStream<itk::VectorImage< unsigned long long,3 >> >;
using itkImageToVideoFilterVIULL4VIULL3_Pointer = itk::ImageToVideoFilter< itk::VectorImage< unsigned long long,4 >, itk::VideoStream<itk::VectorImage< unsigned long long,3 >> >::Pointer;
using itkImageToVideoFilterIUS4 = itk::ImageToVideoFilter< itk::Image< unsigned short,4 > >;
using itkImageToVideoFilterIUS4_Pointer = itk::ImageToVideoFilter< itk::Image< unsigned short,4 > >::Pointer;
using itkImageToVideoFilterVIUS4VIUS3 = itk::ImageToVideoFilter< itk::VectorImage< unsigned short,4 >, itk::VideoStream<itk::VectorImage< unsigned short,3 >> >;
using itkImageToVideoFilterVIUS4VIUS3_Pointer = itk::ImageToVideoFilter< itk::VectorImage< unsigned short,4 >, itk::VideoStream<itk::VectorImage< unsigned short,3 >> >::Pointer;
using itkImageToVideoFilterIF4 = itk::ImageToVideoFilter< itk::Image< float,4 > >;
using itkImageToVideoFilterIF4_Pointer = itk::ImageToVideoFilter< itk::Image< float,4 > >::Pointer;
using itkImageToVideoFilterVIF4VIF3 = itk::ImageToVideoFilter< itk::VectorImage< float,4 >, itk::VideoStream<itk::VectorImage< float,3 >> >;
using itkImageToVideoFilterVIF4VIF3_Pointer = itk::ImageToVideoFilter< itk::VectorImage< float,4 >, itk::VideoStream<itk::VectorImage< float,3 >> >::Pointer;
using itkImageToVideoFilterID4 = itk::ImageToVideoFilter< itk::Image< double,4 > >;
using itkImageToVideoFilterID4_Pointer = itk::ImageToVideoFilter< itk::Image< double,4 > >::Pointer;
using itkImageToVideoFilterVID4VID3 = itk::ImageToVideoFilter< itk::VectorImage< double,4 >, itk::VideoStream<itk::VectorImage< double,3 >> >;
using itkImageToVideoFilterVID4VID3_Pointer = itk::ImageToVideoFilter< itk::VectorImage< double,4 >, itk::VideoStream<itk::VectorImage< double,3 >> >::Pointer;


#include "itkVideoSourceSwigInterface.h"
#include "ITKCommonBaseSwigInterface.h"
#include "itkImageSwigInterface.h"
#include "itkVectorImageSwigInterface.h"
#include "itkImageToVideoFilterSwigInterface.h"
#endif
