// Copyright 2017 Istio Authors
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: mesh/v1alpha1/config.proto

// $title: Global Mesh Options
// $description: Configuration affecting the service mesh as a whole.
// $location: https://istio.io/docs/reference/config/istio.mesh.v1alpha1.html
// $weight: 20
// $mode: package

// Configuration affecting the service mesh as a whole.

package v1alpha1

import (
	duration "github.com/golang/protobuf/ptypes/duration"
	_struct "github.com/golang/protobuf/ptypes/struct"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	v1alpha3 "istio.io/api/networking/v1alpha3"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Resource describes the source of configuration
type Resource int32

const (
	// Set to only receive service entries that are generated by the platform.
	// These auto generated service entries are combination of services and endpoints
	// that are generated by a specific platform e.g. k8
	Resource_SERVICE_REGISTRY Resource = 0
)

// Enum value maps for Resource.
var (
	Resource_name = map[int32]string{
		0: "SERVICE_REGISTRY",
	}
	Resource_value = map[string]int32{
		"SERVICE_REGISTRY": 0,
	}
)

func (x Resource) Enum() *Resource {
	p := new(Resource)
	*p = x
	return p
}

func (x Resource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Resource) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_config_proto_enumTypes[0].Descriptor()
}

func (Resource) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_config_proto_enumTypes[0]
}

func (x Resource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Resource.Descriptor instead.
func (Resource) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0}
}

type MeshConfig_IngressControllerMode int32

const (
	// Unspecified Istio ingress controller.
	MeshConfig_UNSPECIFIED MeshConfig_IngressControllerMode = 0
	// Disables Istio ingress controller.
	MeshConfig_OFF MeshConfig_IngressControllerMode = 1
	// Istio ingress controller will act on ingress resources that do not
	// contain any annotation or whose annotations match the value
	// specified in the ingressClass parameter described earlier. Use this
	// mode if Istio ingress controller will be the default ingress
	// controller for the entire Kubernetes cluster.
	MeshConfig_DEFAULT MeshConfig_IngressControllerMode = 2
	// Istio ingress controller will only act on ingress resources whose
	// annotations match the value specified in the ingressClass parameter
	// described earlier. Use this mode if Istio ingress controller will be
	// a secondary ingress controller (e.g., in addition to a
	// cloud-provided ingress controller).
	MeshConfig_STRICT MeshConfig_IngressControllerMode = 3
)

// Enum value maps for MeshConfig_IngressControllerMode.
var (
	MeshConfig_IngressControllerMode_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "OFF",
		2: "DEFAULT",
		3: "STRICT",
	}
	MeshConfig_IngressControllerMode_value = map[string]int32{
		"UNSPECIFIED": 0,
		"OFF":         1,
		"DEFAULT":     2,
		"STRICT":      3,
	}
)

func (x MeshConfig_IngressControllerMode) Enum() *MeshConfig_IngressControllerMode {
	p := new(MeshConfig_IngressControllerMode)
	*p = x
	return p
}

func (x MeshConfig_IngressControllerMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MeshConfig_IngressControllerMode) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_config_proto_enumTypes[1].Descriptor()
}

func (MeshConfig_IngressControllerMode) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_config_proto_enumTypes[1]
}

func (x MeshConfig_IngressControllerMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MeshConfig_IngressControllerMode.Descriptor instead.
func (MeshConfig_IngressControllerMode) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 0}
}

// $hide_from_docs
type MeshConfig_AuthPolicy int32

const (
	MeshConfig_NONE       MeshConfig_AuthPolicy = 0
	MeshConfig_MUTUAL_TLS MeshConfig_AuthPolicy = 1
)

// Enum value maps for MeshConfig_AuthPolicy.
var (
	MeshConfig_AuthPolicy_name = map[int32]string{
		0: "NONE",
		1: "MUTUAL_TLS",
	}
	MeshConfig_AuthPolicy_value = map[string]int32{
		"NONE":       0,
		"MUTUAL_TLS": 1,
	}
)

func (x MeshConfig_AuthPolicy) Enum() *MeshConfig_AuthPolicy {
	p := new(MeshConfig_AuthPolicy)
	*p = x
	return p
}

func (x MeshConfig_AuthPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MeshConfig_AuthPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_config_proto_enumTypes[2].Descriptor()
}

func (MeshConfig_AuthPolicy) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_config_proto_enumTypes[2]
}

func (x MeshConfig_AuthPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MeshConfig_AuthPolicy.Descriptor instead.
func (MeshConfig_AuthPolicy) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 1}
}

type MeshConfig_AccessLogEncoding int32

const (
	// text encoding for the proxy access log
	MeshConfig_TEXT MeshConfig_AccessLogEncoding = 0
	// json encoding for the proxy access log
	MeshConfig_JSON MeshConfig_AccessLogEncoding = 1
)

// Enum value maps for MeshConfig_AccessLogEncoding.
var (
	MeshConfig_AccessLogEncoding_name = map[int32]string{
		0: "TEXT",
		1: "JSON",
	}
	MeshConfig_AccessLogEncoding_value = map[string]int32{
		"TEXT": 0,
		"JSON": 1,
	}
)

func (x MeshConfig_AccessLogEncoding) Enum() *MeshConfig_AccessLogEncoding {
	p := new(MeshConfig_AccessLogEncoding)
	*p = x
	return p
}

func (x MeshConfig_AccessLogEncoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MeshConfig_AccessLogEncoding) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_config_proto_enumTypes[3].Descriptor()
}

func (MeshConfig_AccessLogEncoding) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_config_proto_enumTypes[3]
}

func (x MeshConfig_AccessLogEncoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MeshConfig_AccessLogEncoding.Descriptor instead.
func (MeshConfig_AccessLogEncoding) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 2}
}

// Default Policy for upgrading http1.1 connections to http2.
type MeshConfig_H2UpgradePolicy int32

const (
	// Do not upgrade connections to http2.
	MeshConfig_DO_NOT_UPGRADE MeshConfig_H2UpgradePolicy = 0
	// Upgrade the connections to http2.
	MeshConfig_UPGRADE MeshConfig_H2UpgradePolicy = 1
)

// Enum value maps for MeshConfig_H2UpgradePolicy.
var (
	MeshConfig_H2UpgradePolicy_name = map[int32]string{
		0: "DO_NOT_UPGRADE",
		1: "UPGRADE",
	}
	MeshConfig_H2UpgradePolicy_value = map[string]int32{
		"DO_NOT_UPGRADE": 0,
		"UPGRADE":        1,
	}
)

func (x MeshConfig_H2UpgradePolicy) Enum() *MeshConfig_H2UpgradePolicy {
	p := new(MeshConfig_H2UpgradePolicy)
	*p = x
	return p
}

func (x MeshConfig_H2UpgradePolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MeshConfig_H2UpgradePolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_config_proto_enumTypes[4].Descriptor()
}

func (MeshConfig_H2UpgradePolicy) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_config_proto_enumTypes[4]
}

func (x MeshConfig_H2UpgradePolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MeshConfig_H2UpgradePolicy.Descriptor instead.
func (MeshConfig_H2UpgradePolicy) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 3}
}

type MeshConfig_OutboundTrafficPolicy_Mode int32

const (
	// In `REGISTRY_ONLY` mode, unknown outbound traffic will be dropped.
	// Traffic destinations must be explicitly declared into the service registry through `ServiceEntry` configurations.
	//
	// Note: Istio [does not offer an outbound traffic security policy](https://istio.io/latest/docs/ops/best-practices/security/#understand-traffic-capture-limitations).
	// This option does not act as one, or as any form of an outbound firewall.
	// Instead, this option exists primarily to offer users a way to detect missing `ServiceEntry` configurations by explicitly failing.
	MeshConfig_OutboundTrafficPolicy_REGISTRY_ONLY MeshConfig_OutboundTrafficPolicy_Mode = 0
	// In `ALLOW_ANY` mode, any traffic to unknown destinations will be allowed.
	// Unknown destination traffic will have limited functionality, however, such as reduced observability.
	// This mode allows users that do not have all possible egress destinations registered through `ServiceEntry` configurations to still connect
	// to arbitrary destinations.
	MeshConfig_OutboundTrafficPolicy_ALLOW_ANY MeshConfig_OutboundTrafficPolicy_Mode = 1
)

// Enum value maps for MeshConfig_OutboundTrafficPolicy_Mode.
var (
	MeshConfig_OutboundTrafficPolicy_Mode_name = map[int32]string{
		0: "REGISTRY_ONLY",
		1: "ALLOW_ANY",
	}
	MeshConfig_OutboundTrafficPolicy_Mode_value = map[string]int32{
		"REGISTRY_ONLY": 0,
		"ALLOW_ANY":     1,
	}
)

func (x MeshConfig_OutboundTrafficPolicy_Mode) Enum() *MeshConfig_OutboundTrafficPolicy_Mode {
	p := new(MeshConfig_OutboundTrafficPolicy_Mode)
	*p = x
	return p
}

func (x MeshConfig_OutboundTrafficPolicy_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MeshConfig_OutboundTrafficPolicy_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_config_proto_enumTypes[5].Descriptor()
}

func (MeshConfig_OutboundTrafficPolicy_Mode) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_config_proto_enumTypes[5]
}

func (x MeshConfig_OutboundTrafficPolicy_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MeshConfig_OutboundTrafficPolicy_Mode.Descriptor instead.
func (MeshConfig_OutboundTrafficPolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 0, 0}
}

type MeshConfig_InboundTrafficPolicy_Mode int32

const (
	// inbound traffic will be passed through to the destination listening
	// on Pod IP. This matches the behavior without Istio enabled at all
	// allowing proxy to be transparent.
	MeshConfig_InboundTrafficPolicy_PASSTHROUGH MeshConfig_InboundTrafficPolicy_Mode = 0
	// inbound traffic will be sent to the destinations listening on localhost.
	MeshConfig_InboundTrafficPolicy_LOCALHOST MeshConfig_InboundTrafficPolicy_Mode = 1
)

// Enum value maps for MeshConfig_InboundTrafficPolicy_Mode.
var (
	MeshConfig_InboundTrafficPolicy_Mode_name = map[int32]string{
		0: "PASSTHROUGH",
		1: "LOCALHOST",
	}
	MeshConfig_InboundTrafficPolicy_Mode_value = map[string]int32{
		"PASSTHROUGH": 0,
		"LOCALHOST":   1,
	}
)

func (x MeshConfig_InboundTrafficPolicy_Mode) Enum() *MeshConfig_InboundTrafficPolicy_Mode {
	p := new(MeshConfig_InboundTrafficPolicy_Mode)
	*p = x
	return p
}

func (x MeshConfig_InboundTrafficPolicy_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MeshConfig_InboundTrafficPolicy_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_config_proto_enumTypes[6].Descriptor()
}

func (MeshConfig_InboundTrafficPolicy_Mode) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_config_proto_enumTypes[6]
}

func (x MeshConfig_InboundTrafficPolicy_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MeshConfig_InboundTrafficPolicy_Mode.Descriptor instead.
func (MeshConfig_InboundTrafficPolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 1, 0}
}

// The scope of the matching service. Used to determine if the service is available locally
// (cluster local) or globally (mesh-wide).
type MeshConfig_ServiceScopeConfigs_Scope int32

const (
	MeshConfig_ServiceScopeConfigs_LOCAL  MeshConfig_ServiceScopeConfigs_Scope = 0
	MeshConfig_ServiceScopeConfigs_GLOBAL MeshConfig_ServiceScopeConfigs_Scope = 1
)

// Enum value maps for MeshConfig_ServiceScopeConfigs_Scope.
var (
	MeshConfig_ServiceScopeConfigs_Scope_name = map[int32]string{
		0: "LOCAL",
		1: "GLOBAL",
	}
	MeshConfig_ServiceScopeConfigs_Scope_value = map[string]int32{
		"LOCAL":  0,
		"GLOBAL": 1,
	}
)

func (x MeshConfig_ServiceScopeConfigs_Scope) Enum() *MeshConfig_ServiceScopeConfigs_Scope {
	p := new(MeshConfig_ServiceScopeConfigs_Scope)
	*p = x
	return p
}

func (x MeshConfig_ServiceScopeConfigs_Scope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MeshConfig_ServiceScopeConfigs_Scope) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_config_proto_enumTypes[7].Descriptor()
}

func (MeshConfig_ServiceScopeConfigs_Scope) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_config_proto_enumTypes[7]
}

func (x MeshConfig_ServiceScopeConfigs_Scope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MeshConfig_ServiceScopeConfigs_Scope.Descriptor instead.
func (MeshConfig_ServiceScopeConfigs_Scope) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 4, 0}
}

// TraceContext selects the context propagation headers used for
// distributed tracing.
type MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext int32

const (
	// $hide_from_docs
	// Unspecified context. Should not be used for now, but added to reserve
	// the 0 enum value if TraceContext is used outside of a repeated field.
	MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_UNSPECIFIED MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext = 0
	// Use W3C Trace Context propagation using the `traceparent` HTTP header.
	// See the
	// [Trace Context documentation](https://www.w3.org/TR/trace-context/) for details.
	MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_W3C_TRACE_CONTEXT MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext = 1
	// Use gRPC binary context propagation using the `grpc-trace-bin` http header.
	MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_GRPC_BIN MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext = 2
	// Use Cloud Trace context propagation using the
	// `X-Cloud-Trace-Context` http header.
	MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_CLOUD_TRACE_CONTEXT MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext = 3
	// Use multi-header B3 context propagation using the `X-B3-TraceId`,
	// `X-B3-SpanId`, and `X-B3-Sampled` HTTP headers. See
	// [B3 header propagation README](https://github.com/openzipkin/b3-propagation)
	// for details.
	MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_B3 MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext = 4
)

// Enum value maps for MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext.
var (
	MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "W3C_TRACE_CONTEXT",
		2: "GRPC_BIN",
		3: "CLOUD_TRACE_CONTEXT",
		4: "B3",
	}
	MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext_value = map[string]int32{
		"UNSPECIFIED":         0,
		"W3C_TRACE_CONTEXT":   1,
		"GRPC_BIN":            2,
		"CLOUD_TRACE_CONTEXT": 3,
		"B3":                  4,
	}
)

func (x MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext) Enum() *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext {
	p := new(MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext)
	*p = x
	return p
}

func (x MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_config_proto_enumTypes[8].Descriptor()
}

func (MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_config_proto_enumTypes[8]
}

func (x MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext.Descriptor instead.
func (MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 8, 0}
}

type MeshConfig_ProxyPathNormalization_NormalizationType int32

const (
	// Apply default normalizations. Currently, this is BASE.
	MeshConfig_ProxyPathNormalization_DEFAULT MeshConfig_ProxyPathNormalization_NormalizationType = 0
	// No normalization, paths are used as is.
	MeshConfig_ProxyPathNormalization_NONE MeshConfig_ProxyPathNormalization_NormalizationType = 1
	// Normalize according to [RFC 3986](https://tools.ietf.org/html/rfc3986).
	// For Envoy proxies, this is the [`normalize_path`](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/filters/network/http_connection_manager/v3/http_connection_manager.proto.html) option.
	// For example, `/a/../b` normalizes to `/b`.
	MeshConfig_ProxyPathNormalization_BASE MeshConfig_ProxyPathNormalization_NormalizationType = 2
	// In addition to the `BASE` normalization, consecutive slashes are also merged.
	// For example, `/a//b` normalizes to `a/b`.
	MeshConfig_ProxyPathNormalization_MERGE_SLASHES MeshConfig_ProxyPathNormalization_NormalizationType = 3
	// In addition to normalization in `MERGE_SLASHES`, slash characters are UTF-8 decoded (case insensitive) prior to merging.
	// This means `%2F`, `%2f`, `%5C`, and `%5c` sequences in the request path will be rewritten to `/` or `\`.
	// For example, `/a%2f/b` normalizes to `a/b`.
	MeshConfig_ProxyPathNormalization_DECODE_AND_MERGE_SLASHES MeshConfig_ProxyPathNormalization_NormalizationType = 4
)

// Enum value maps for MeshConfig_ProxyPathNormalization_NormalizationType.
var (
	MeshConfig_ProxyPathNormalization_NormalizationType_name = map[int32]string{
		0: "DEFAULT",
		1: "NONE",
		2: "BASE",
		3: "MERGE_SLASHES",
		4: "DECODE_AND_MERGE_SLASHES",
	}
	MeshConfig_ProxyPathNormalization_NormalizationType_value = map[string]int32{
		"DEFAULT":                  0,
		"NONE":                     1,
		"BASE":                     2,
		"MERGE_SLASHES":            3,
		"DECODE_AND_MERGE_SLASHES": 4,
	}
)

func (x MeshConfig_ProxyPathNormalization_NormalizationType) Enum() *MeshConfig_ProxyPathNormalization_NormalizationType {
	p := new(MeshConfig_ProxyPathNormalization_NormalizationType)
	*p = x
	return p
}

func (x MeshConfig_ProxyPathNormalization_NormalizationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MeshConfig_ProxyPathNormalization_NormalizationType) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_config_proto_enumTypes[9].Descriptor()
}

func (MeshConfig_ProxyPathNormalization_NormalizationType) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_config_proto_enumTypes[9]
}

func (x MeshConfig_ProxyPathNormalization_NormalizationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MeshConfig_ProxyPathNormalization_NormalizationType.Descriptor instead.
func (MeshConfig_ProxyPathNormalization_NormalizationType) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 8, 0}
}

// TLS protocol versions.
type MeshConfig_TLSConfig_TLSProtocol int32

const (
	// Automatically choose the optimal TLS version.
	MeshConfig_TLSConfig_TLS_AUTO MeshConfig_TLSConfig_TLSProtocol = 0
	// TLS version 1.2
	MeshConfig_TLSConfig_TLSV1_2 MeshConfig_TLSConfig_TLSProtocol = 1
	// TLS version 1.3
	MeshConfig_TLSConfig_TLSV1_3 MeshConfig_TLSConfig_TLSProtocol = 2
)

// Enum value maps for MeshConfig_TLSConfig_TLSProtocol.
var (
	MeshConfig_TLSConfig_TLSProtocol_name = map[int32]string{
		0: "TLS_AUTO",
		1: "TLSV1_2",
		2: "TLSV1_3",
	}
	MeshConfig_TLSConfig_TLSProtocol_value = map[string]int32{
		"TLS_AUTO": 0,
		"TLSV1_2":  1,
		"TLSV1_3":  2,
	}
)

func (x MeshConfig_TLSConfig_TLSProtocol) Enum() *MeshConfig_TLSConfig_TLSProtocol {
	p := new(MeshConfig_TLSConfig_TLSProtocol)
	*p = x
	return p
}

func (x MeshConfig_TLSConfig_TLSProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MeshConfig_TLSConfig_TLSProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_config_proto_enumTypes[10].Descriptor()
}

func (MeshConfig_TLSConfig_TLSProtocol) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_config_proto_enumTypes[10]
}

func (x MeshConfig_TLSConfig_TLSProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MeshConfig_TLSConfig_TLSProtocol.Descriptor instead.
func (MeshConfig_TLSConfig_TLSProtocol) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 9, 0}
}

// MeshConfig defines mesh-wide settings for the Istio service mesh.
type MeshConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Port on which Envoy should listen for all outbound traffic to other services.
	// Default port is 15001.
	ProxyListenPort int32 `protobuf:"varint,4,opt,name=proxy_listen_port,json=proxyListenPort,proto3" json:"proxy_listen_port,omitempty"`
	// Port on which Envoy should listen for all inbound traffic to the pod/vm will be captured to.
	// Default port is 15006.
	ProxyInboundListenPort int32 `protobuf:"varint,65,opt,name=proxy_inbound_listen_port,json=proxyInboundListenPort,proto3" json:"proxy_inbound_listen_port,omitempty"`
	// Port on which Envoy should listen for HTTP PROXY requests if set.
	ProxyHttpPort int32 `protobuf:"varint,5,opt,name=proxy_http_port,json=proxyHttpPort,proto3" json:"proxy_http_port,omitempty"`
	// Connection timeout used by Envoy. (MUST be >=1ms)
	// Default timeout is 10s.
	ConnectTimeout *duration.Duration `protobuf:"bytes,6,opt,name=connect_timeout,json=connectTimeout,proto3" json:"connect_timeout,omitempty"`
	// $hide_from_docs
	// Automatic protocol detection uses a set of heuristics to
	// determine whether the connection is using TLS or not (on the
	// server side), as well as the application protocol being used
	// (e.g., http vs tcp). These heuristics rely on the client sending
	// the first bits of data. For server first protocols like MySQL,
	// MongoDB, etc. Envoy will timeout on the protocol detection after
	// the specified period, defaulting to non mTLS plain TCP
	// traffic. Set this field to tweak the period that Envoy will wait
	// for the client to send the first bits of data. (MUST be >=1ms or
	// 0s to disable). Default detection timeout is 0s (no timeout).
	//
	// Setting a timeout is not recommended nor safe. Even high timeouts (>5s) will be hit
	// occasionally, and when they occur the result is typically broken traffic that may not
	// recover on its own. Exceptionally high values might solve this, but injecting 60s delays
	// onto new connections is generally not tenable anyways.
	ProtocolDetectionTimeout *duration.Duration `protobuf:"bytes,42,opt,name=protocol_detection_timeout,json=protocolDetectionTimeout,proto3" json:"protocol_detection_timeout,omitempty"`
	// If set then set `SO_KEEPALIVE` on the socket to enable TCP Keepalives.
	TcpKeepalive *v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive `protobuf:"bytes,28,opt,name=tcp_keepalive,json=tcpKeepalive,proto3" json:"tcp_keepalive,omitempty"`
	// Class of ingress resources to be processed by Istio ingress
	// controller. This corresponds to the value of
	// `kubernetes.io/ingress.class` annotation.
	IngressClass string `protobuf:"bytes,7,opt,name=ingress_class,json=ingressClass,proto3" json:"ingress_class,omitempty"`
	// Name of the Kubernetes service used for the istio ingress controller.
	// If no ingress controller is specified, the default value `istio-ingressgateway` is used.
	IngressService string `protobuf:"bytes,8,opt,name=ingress_service,json=ingressService,proto3" json:"ingress_service,omitempty"`
	// Defines whether to use Istio ingress controller for annotated or all ingress resources.
	// Default mode is `STRICT`.
	IngressControllerMode MeshConfig_IngressControllerMode `protobuf:"varint,9,opt,name=ingress_controller_mode,json=ingressControllerMode,proto3,enum=istio.mesh.v1alpha1.MeshConfig_IngressControllerMode" json:"ingress_controller_mode,omitempty"`
	// Defines which gateway deployment to use as the Ingress controller. This field corresponds to
	// the Gateway.selector field, and will be set as `istio: INGRESS_SELECTOR`.
	// By default, `ingressgateway` is used, which will select the default IngressGateway as it has the
	// `istio: ingressgateway` labels.
	// It is recommended that this is the same value as ingressService.
	IngressSelector string `protobuf:"bytes,52,opt,name=ingress_selector,json=ingressSelector,proto3" json:"ingress_selector,omitempty"`
	// Flag to control generation of trace spans and request IDs.
	// Requires a trace span collector defined in the proxy configuration.
	EnableTracing bool `protobuf:"varint,12,opt,name=enable_tracing,json=enableTracing,proto3" json:"enable_tracing,omitempty"`
	// File address for the proxy access log (e.g. /dev/stdout).
	// Empty value disables access logging.
	AccessLogFile string `protobuf:"bytes,13,opt,name=access_log_file,json=accessLogFile,proto3" json:"access_log_file,omitempty"`
	// Format for the proxy access log
	// Empty value results in proxy's default access log format
	AccessLogFormat string `protobuf:"bytes,24,opt,name=access_log_format,json=accessLogFormat,proto3" json:"access_log_format,omitempty"`
	// Encoding for the proxy access log (`TEXT` or `JSON`).
	// Default value is `TEXT`.
	AccessLogEncoding MeshConfig_AccessLogEncoding `protobuf:"varint,27,opt,name=access_log_encoding,json=accessLogEncoding,proto3,enum=istio.mesh.v1alpha1.MeshConfig_AccessLogEncoding" json:"access_log_encoding,omitempty"`
	// This flag enables Envoy's gRPC Access Log Service.
	// See [Access Log Service](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/access_loggers/grpc/v3/als.proto)
	// for details about Envoy's gRPC Access Log Service API.
	// Default value is `false`.
	EnableEnvoyAccessLogService bool `protobuf:"varint,40,opt,name=enable_envoy_access_log_service,json=enableEnvoyAccessLogService,proto3" json:"enable_envoy_access_log_service,omitempty"`
	// This flag disables Envoy Listener logs.
	// See [Listener Access Log](https://www.envoyproxy.io/docs/envoy/latest/api-v3/config/listener/v3/listener.proto#envoy-v3-api-field-config-listener-v3-listener-access-log)
	// Istio Enables Envoy's listener access logs on "NoRoute" response flag.
	// Default value is `false`.
	DisableEnvoyListenerLog bool `protobuf:"varint,56,opt,name=disable_envoy_listener_log,json=disableEnvoyListenerLog,proto3" json:"disable_envoy_listener_log,omitempty"`
	// Default proxy config used by gateway and sidecars.
	// In case of Kubernetes, the proxy config is applied once during the injection process,
	// and remain constant for the duration of the pod. The rest of the mesh config can be changed
	// at runtime and config gets distributed dynamically.
	// On Kubernetes, this can be overridden on individual pods with the `proxy.istio.io/config` annotation.
	DefaultConfig *ProxyConfig `protobuf:"bytes,14,opt,name=default_config,json=defaultConfig,proto3" json:"default_config,omitempty"`
	// Set the default behavior of the sidecar for handling outbound
	// traffic from the application.
	//
	// Can be overridden at a Sidecar level by setting the `OutboundTrafficPolicy` in the
	// [Sidecar API](https://istio.io/docs/reference/config/networking/sidecar/#OutboundTrafficPolicy).
	//
	// Default mode is `ALLOW_ANY`, which means outbound traffic to unknown destinations will be allowed.
	OutboundTrafficPolicy *MeshConfig_OutboundTrafficPolicy `protobuf:"bytes,17,opt,name=outbound_traffic_policy,json=outboundTrafficPolicy,proto3" json:"outbound_traffic_policy,omitempty"`
	// Set the default behavior of the sidecar for handling inbound
	// traffic to the application.  If your application listens on
	// localhost, you will need to set this to `LOCALHOST`.
	InboundTrafficPolicy *MeshConfig_InboundTrafficPolicy `protobuf:"bytes,66,opt,name=inbound_traffic_policy,json=inboundTrafficPolicy,proto3" json:"inbound_traffic_policy,omitempty"`
	// ConfigSource describes a source of configuration data for networking
	// rules, and other Istio configuration artifacts. Multiple data sources
	// can be configured for a single control plane.
	ConfigSources []*ConfigSource `protobuf:"bytes,22,rep,name=config_sources,json=configSources,proto3" json:"config_sources,omitempty"`
	// This flag is used to enable mutual `TLS` automatically for service to service communication
	// within the mesh, default true.
	// If set to true, and a given service does not have a corresponding `DestinationRule` configured,
	// or its `DestinationRule` does not have ClientTLSSettings specified, Istio configures client side
	// TLS configuration appropriately. More specifically,
	// If the upstream authentication policy is in `STRICT` mode, use Istio provisioned certificate
	// for mutual `TLS` to connect to upstream.
	// If upstream service is in plain text mode, use plain text.
	// If the upstream authentication policy is in PERMISSIVE mode, Istio configures clients to use
	// mutual `TLS` when server sides are capable of accepting mutual `TLS` traffic.
	// If service `DestinationRule` exists and has `ClientTLSSettings` specified, that is always used instead.
	EnableAutoMtls *wrappers.BoolValue `protobuf:"bytes,43,opt,name=enable_auto_mtls,json=enableAutoMtls,proto3" json:"enable_auto_mtls,omitempty"`
	// The trust domain corresponds to the trust root of a system.
	// Refer to [SPIFFE-ID](https://github.com/spiffe/spiffe/blob/master/standards/SPIFFE-ID.md#21-trust-domain)
	TrustDomain string `protobuf:"bytes,26,opt,name=trust_domain,json=trustDomain,proto3" json:"trust_domain,omitempty"`
	// The trust domain aliases represent the aliases of `trustDomain`.
	// For example, if we have
	// ```yaml
	// trustDomain: td1
	// trustDomainAliases: ["td2", "td3"]
	// ```
	// Any service with the identity `td1/ns/foo/sa/a-service-account`, `td2/ns/foo/sa/a-service-account`,
	// or `td3/ns/foo/sa/a-service-account` will be treated the same in the Istio mesh.
	TrustDomainAliases []string `protobuf:"bytes,46,rep,name=trust_domain_aliases,json=trustDomainAliases,proto3" json:"trust_domain_aliases,omitempty"`
	// The extra root certificates for workload-to-workload communication.
	// The plugin certificates (the 'cacerts' secret) or self-signed certificates (the 'istio-ca-secret' secret)
	// are automatically added by Istiod.
	// The CA certificate that signs the workload certificates is automatically added by Istio Agent.
	CaCertificates []*MeshConfig_CertificateData `protobuf:"bytes,58,rep,name=ca_certificates,json=caCertificates,proto3" json:"ca_certificates,omitempty"`
	// The default value for the ServiceEntry.exportTo field and services
	// imported through container registry integrations, e.g. this applies to
	// Kubernetes Service resources. The value is a list of namespace names and
	// reserved namespace aliases. The allowed namespace aliases are:
	// ```
	// * - All Namespaces
	// . - Current Namespace
	// ~ - No Namespace
	// ```
	// If not set the system will use "*" as the default value which implies that
	// services are exported to all namespaces.
	//
	// `All namespaces` is a reasonable default for implementations that don't
	// need to restrict access or visibility of services across namespace
	// boundaries. If that requirement is present it is generally good practice to
	// make the default `Current namespace` so that services are only visible
	// within their own namespaces by default. Operators can then expand the
	// visibility of services to other namespaces as needed. Use of `No Namespace`
	// is expected to be rare but can have utility for deployments where
	// dependency management needs to be precise even within the scope of a single
	// namespace.
	//
	// For further discussion see the reference documentation for `ServiceEntry`,
	// `Sidecar`, and `Gateway`.
	DefaultServiceExportTo []string `protobuf:"bytes,31,rep,name=default_service_export_to,json=defaultServiceExportTo,proto3" json:"default_service_export_to,omitempty"`
	// The default value for the VirtualService.exportTo field. Has the same
	// syntax as `defaultServiceExportTo`.
	//
	// If not set the system will use "*" as the default value which implies that
	// virtual services are exported to all namespaces
	DefaultVirtualServiceExportTo []string `protobuf:"bytes,32,rep,name=default_virtual_service_export_to,json=defaultVirtualServiceExportTo,proto3" json:"default_virtual_service_export_to,omitempty"`
	// The default value for the `DestinationRule.exportTo` field. Has the same
	// syntax as `defaultServiceExportTo`.
	//
	// If not set the system will use "*" as the default value which implies that
	// destination rules are exported to all namespaces
	DefaultDestinationRuleExportTo []string `protobuf:"bytes,33,rep,name=default_destination_rule_export_to,json=defaultDestinationRuleExportTo,proto3" json:"default_destination_rule_export_to,omitempty"`
	// The namespace to treat as the administrative root namespace for
	// Istio configuration. When processing a leaf namespace Istio will search for
	// declarations in that namespace first and if none are found it will
	// search in the root namespace. Any matching declaration found in the root
	// namespace is processed as if it were declared in the leaf namespace.
	//
	// The precise semantics of this processing are documented on each resource
	// type.
	RootNamespace string `protobuf:"bytes,34,opt,name=root_namespace,json=rootNamespace,proto3" json:"root_namespace,omitempty"`
	// Locality based load balancing distribution or failover settings.
	// If unspecified, locality based load balancing will be enabled by default.
	// However, this requires outlierDetection to actually take effect for a particular
	// service, see https://istio.io/latest/docs/tasks/traffic-management/locality-load-balancing/failover/
	LocalityLbSetting *v1alpha3.LocalityLoadBalancerSetting `protobuf:"bytes,35,opt,name=locality_lb_setting,json=localityLbSetting,proto3" json:"locality_lb_setting,omitempty"`
	// Configures DNS refresh rate for Envoy clusters of type `STRICT_DNS`
	// Default refresh rate is `60s`.
	DnsRefreshRate *duration.Duration `protobuf:"bytes,36,opt,name=dns_refresh_rate,json=dnsRefreshRate,proto3" json:"dns_refresh_rate,omitempty"`
	// Specify if http1.1 connections should be upgraded to http2 by default.
	// if sidecar is installed on all pods in the mesh, then this should be set to `UPGRADE`.
	// If one or more services or namespaces do not have sidecar(s), then this should be set to `DO_NOT_UPGRADE`.
	// It can be enabled by destination using the `destinationRule.trafficPolicy.connectionPool.http.h2UpgradePolicy` override.
	H2UpgradePolicy MeshConfig_H2UpgradePolicy `protobuf:"varint,41,opt,name=h2_upgrade_policy,json=h2UpgradePolicy,proto3,enum=istio.mesh.v1alpha1.MeshConfig_H2UpgradePolicy" json:"h2_upgrade_policy,omitempty"`
	// Name to be used while emitting statistics for inbound clusters. The same pattern is used while computing stat prefix for
	// network filters like TCP and Redis.
	// By default, Istio emits statistics with the pattern `inbound|<port>|<port-name>|<service-FQDN>`.
	// For example `inbound|7443|grpc-reviews|reviews.prod.svc.cluster.local`. This can be used to override that pattern.
	//
	// A Pattern can be composed of various pre-defined variables. The following variables are supported.
	//
	// - `%SERVICE%` - Will be substituted with short hostname of the service.
	// - `%SERVICE_NAME%` - Will be substituted with name of the service.
	// - `%SERVICE_FQDN%` - Will be substituted with FQDN of the service.
	// - `%SERVICE_PORT%` - Will be substituted with port of the service.
	// - `%TARGET_PORT%`  - Will be substituted with the target port of the service.
	// - `%SERVICE_PORT_NAME%` - Will be substituted with port name of the service.
	//
	// Following are some examples of supported patterns for reviews:
	//
	// - `%SERVICE_FQDN%_%SERVICE_PORT%` will use reviews.prod.svc.cluster.local_7443 as the stats name.
	// - `%SERVICE%` will use reviews.prod as the stats name.
	InboundClusterStatName string `protobuf:"bytes,44,opt,name=inbound_cluster_stat_name,json=inboundClusterStatName,proto3" json:"inbound_cluster_stat_name,omitempty"`
	// Name to be used while emitting statistics for outbound clusters. The same pattern is used while computing stat prefix for
	// network filters like TCP and Redis.
	// By default, Istio emits statistics with the pattern `outbound|<port>|<subsetname>|<service-FQDN>`.
	// For example `outbound|8080|v2|reviews.prod.svc.cluster.local`. This can be used to override that pattern.
	//
	// A Pattern can be composed of various pre-defined variables. The following variables are supported.
	//
	// - `%SERVICE%` - Will be substituted with short hostname of the service.
	// - `%SERVICE_NAME%` - Will be substituted with name of the service.
	// - `%SERVICE_FQDN%` - Will be substituted with FQDN of the service.
	// - `%SERVICE_PORT%` - Will be substituted with port of the service.
	// - `%SERVICE_PORT_NAME%` - Will be substituted with port name of the service.
	// - `%SUBSET_NAME%` - Will be substituted with subset.
	//
	// Following are some examples of supported patterns for reviews:
	//
	// - `%SERVICE_FQDN%_%SERVICE_PORT%` will use `reviews.prod.svc.cluster.local_7443` as the stats name.
	// - `%SERVICE%` will use reviews.prod as the stats name.
	OutboundClusterStatName string `protobuf:"bytes,45,opt,name=outbound_cluster_stat_name,json=outboundClusterStatName,proto3" json:"outbound_cluster_stat_name,omitempty"`
	// $hide_from_docs
	// Configure the provision of certificates.
	//
	// Note: Deprecated, please refer to Cert-Manager or other cert provisioning solutions to sign DNS certificates.
	//
	// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
	Certificates []*Certificate `protobuf:"bytes,47,rep,name=certificates,proto3" json:"certificates,omitempty"`
	// $hide_from_docs
	// Settings to be applied to select services.
	ServiceSettings []*MeshConfig_ServiceSettings `protobuf:"bytes,50,rep,name=service_settings,json=serviceSettings,proto3" json:"service_settings,omitempty"`
	// Scope to be applied to select services.
	ServiceScopeConfigs []*MeshConfig_ServiceScopeConfigs `protobuf:"bytes,67,rep,name=service_scope_configs,json=serviceScopeConfigs,proto3" json:"service_scope_configs,omitempty"`
	// If enabled, Istio agent will merge metrics exposed by the application with metrics from Envoy
	// and Istio agent. The sidecar injection will replace `prometheus.io` annotations present on the pod
	// and redirect them towards Istio agent, which will then merge metrics of from the application with Istio metrics.
	// This relies on the annotations `prometheus.io/scrape`, `prometheus.io/port`, and
	// `prometheus.io/path` annotations.
	// If you are running a separately managed Envoy with an Istio sidecar, this may cause issues, as the metrics will collide.
	// In this case, it is recommended to disable aggregation on that deployment with the
	// `prometheus.istio.io/merge-metrics: "false"` annotation.
	// If not specified, this will be enabled by default.
	EnablePrometheusMerge *wrappers.BoolValue `protobuf:"bytes,51,opt,name=enable_prometheus_merge,json=enablePrometheusMerge,proto3" json:"enable_prometheus_merge,omitempty"`
	// $hide_from_docs
	// `VerifyCertificateAtClient` sets the mesh global default for peer certificate validation
	// at the client-side proxy when `SIMPLE` TLS or `MUTUAL` TLS (non `ISTIO_MUTUAL`) origination
	// modes are used. This setting can be overridden at the host level via DestinationRule API.
	// By default, `VerifyCertificateAtClient` is `true`.
	//
	// `CaCertificates`: If set, proxy verifies CA signature based on given CaCertificates. If unset,
	// and VerifyCertificateAtClient is true, proxy uses default System CA bundle. If unset and
	// `VerifyCertificateAtClient` is false, proxy will not verify the CA.
	//
	// `SubjectAltNames`: If set, proxy verifies subject alt names are present in the SAN. If unset,
	// and `VerifyCertificateAtClient` is true, proxy uses host in destination rule to verify the SANs.
	// If unset, and `VerifyCertificateAtClient` is false, proxy does not verify SANs.
	//
	// For SAN, client-side proxy will exact match host in `DestinationRule` as well as one level
	// wildcard if the specified host in DestinationRule doesn't contain a wildcard.
	// For example, if the host in `DestinationRule` is `x.y.com`, client-side proxy will
	// match either `x.y.com` or `*.y.com` for the SAN in the presented server certificate.
	// For wildcard host name in DestinationRule, client-side proxy will do a suffix match. For example,
	// if host is `*.x.y.com`, client-side proxy will verify the presented server certificate SAN matches
	// `.x.y.com` suffix.
	//
	// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
	VerifyCertificateAtClient *wrappers.BoolValue `protobuf:"bytes,54,opt,name=verify_certificate_at_client,json=verifyCertificateAtClient,proto3" json:"verify_certificate_at_client,omitempty"`
	// $hide_from_docs
	// If specified, Istiod will authorize and forward the CSRs from the workloads to the specified external CA
	// using the Istio CA gRPC API.
	Ca *MeshConfig_CA `protobuf:"bytes,55,opt,name=ca,proto3" json:"ca,omitempty"`
	// Defines a list of extension providers that extend Istio's functionality. For example, the AuthorizationPolicy
	// can be used with an extension provider to delegate the authorization decision to a custom authorization system.
	ExtensionProviders []*MeshConfig_ExtensionProvider `protobuf:"bytes,57,rep,name=extension_providers,json=extensionProviders,proto3" json:"extension_providers,omitempty"`
	// Specifies extension providers to use by default in Istio configuration resources.
	DefaultProviders *MeshConfig_DefaultProviders `protobuf:"bytes,60,opt,name=default_providers,json=defaultProviders,proto3" json:"default_providers,omitempty"`
	// A list of Kubernetes selectors that specify the set of namespaces that Istio considers when
	// computing configuration updates for sidecars. This can be used to reduce Istio's computational load
	// by limiting the number of entities (including services, pods, and endpoints) that are watched and processed.
	// If omitted, Istio will use the default behavior of processing all namespaces in the cluster.
	// Elements in the list are disjunctive (OR semantics), i.e. a namespace will be included if it matches any selector.
	// The following example selects any namespace that matches either below:
	// 1. The namespace has both of these labels: `env: prod` and `region: us-east1`
	// 2. The namespace has label `app` equal to `cassandra` or `spark`.
	// ```yaml
	// discoverySelectors:
	//   - matchLabels:
	//     env: prod
	//     region: us-east1
	//   - matchExpressions:
	//   - key: app
	//     operator: In
	//     values:
	//   - cassandra
	//   - spark
	//
	// ```
	// Refer to the [Kubernetes selector docs](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors)
	// for additional detail on selector semantics.
	DiscoverySelectors []*LabelSelector `protobuf:"bytes,59,rep,name=discovery_selectors,json=discoverySelectors,proto3" json:"discovery_selectors,omitempty"`
	// ProxyPathNormalization configures how URL paths in incoming and outgoing HTTP requests are
	// normalized by the sidecars and gateways.
	// The normalized paths will be used in all aspects through the requests' lifetime on the
	// sidecars and gateways, which includes routing decisions in outbound direction (client proxy),
	// authorization policy match and enforcement in inbound direction (server proxy), and the URL
	// path proxied to the upstream service.
	// If not set, the NormalizationType.DEFAULT configuration will be used.
	PathNormalization *MeshConfig_ProxyPathNormalization `protobuf:"bytes,61,opt,name=path_normalization,json=pathNormalization,proto3" json:"path_normalization,omitempty"`
	// Configure the default HTTP retry policy.
	// The default number of retry attempts is set at 2 for these errors:
	//
	//	"connect-failure,refused-stream,unavailable,cancelled,retriable-status-codes".
	//
	// Setting the number of attempts to 0 disables retry policy globally.
	// This setting can be overridden on a per-host basis using the Virtual Service
	// API.
	// All settings in the retry policy except `perTryTimeout` can currently be
	// configured globally via this field.
	DefaultHttpRetryPolicy *v1alpha3.HTTPRetry `protobuf:"bytes,62,opt,name=default_http_retry_policy,json=defaultHttpRetryPolicy,proto3" json:"default_http_retry_policy,omitempty"`
	// The below configuration parameters can be used to specify TLSConfig for mesh traffic.
	// For example, a user could enable min TLS version for ISTIO_MUTUAL traffic and specify a curve for non ISTIO_MUTUAL traffic like below:
	// ```yaml
	// meshConfig:
	//
	//	meshMTLS:
	//	  minProtocolVersion: TLSV1_3
	//	tlsDefaults:
	//	  Note: applicable only for non ISTIO_MUTUAL scenarios
	//	  ecdhCurves:
	//	    - P-256
	//	    - P-512
	//
	// ```
	// Configuration of mTLS for traffic between workloads with ISTIO_MUTUAL TLS traffic.
	//
	// Note: Mesh mTLS does not respect ECDH curves.
	MeshMTLS *MeshConfig_TLSConfig `protobuf:"bytes,63,opt,name=mesh_mTLS,json=meshMTLS,proto3" json:"mesh_mTLS,omitempty"`
	// Configuration of TLS for all traffic except for ISTIO_MUTUAL mode.
	// Currently, this supports configuration of ecdhCurves and cipherSuites only.
	// For ISTIO_MUTUAL TLS settings, use meshMTLS configuration.
	TlsDefaults   *MeshConfig_TLSConfig `protobuf:"bytes,64,opt,name=tls_defaults,json=tlsDefaults,proto3" json:"tls_defaults,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig) Reset() {
	*x = MeshConfig{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig) ProtoMessage() {}

func (x *MeshConfig) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig.ProtoReflect.Descriptor instead.
func (*MeshConfig) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0}
}

func (x *MeshConfig) GetProxyListenPort() int32 {
	if x != nil {
		return x.ProxyListenPort
	}
	return 0
}

func (x *MeshConfig) GetProxyInboundListenPort() int32 {
	if x != nil {
		return x.ProxyInboundListenPort
	}
	return 0
}

func (x *MeshConfig) GetProxyHttpPort() int32 {
	if x != nil {
		return x.ProxyHttpPort
	}
	return 0
}

func (x *MeshConfig) GetConnectTimeout() *duration.Duration {
	if x != nil {
		return x.ConnectTimeout
	}
	return nil
}

func (x *MeshConfig) GetProtocolDetectionTimeout() *duration.Duration {
	if x != nil {
		return x.ProtocolDetectionTimeout
	}
	return nil
}

func (x *MeshConfig) GetTcpKeepalive() *v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive {
	if x != nil {
		return x.TcpKeepalive
	}
	return nil
}

func (x *MeshConfig) GetIngressClass() string {
	if x != nil {
		return x.IngressClass
	}
	return ""
}

func (x *MeshConfig) GetIngressService() string {
	if x != nil {
		return x.IngressService
	}
	return ""
}

func (x *MeshConfig) GetIngressControllerMode() MeshConfig_IngressControllerMode {
	if x != nil {
		return x.IngressControllerMode
	}
	return MeshConfig_UNSPECIFIED
}

func (x *MeshConfig) GetIngressSelector() string {
	if x != nil {
		return x.IngressSelector
	}
	return ""
}

func (x *MeshConfig) GetEnableTracing() bool {
	if x != nil {
		return x.EnableTracing
	}
	return false
}

func (x *MeshConfig) GetAccessLogFile() string {
	if x != nil {
		return x.AccessLogFile
	}
	return ""
}

func (x *MeshConfig) GetAccessLogFormat() string {
	if x != nil {
		return x.AccessLogFormat
	}
	return ""
}

func (x *MeshConfig) GetAccessLogEncoding() MeshConfig_AccessLogEncoding {
	if x != nil {
		return x.AccessLogEncoding
	}
	return MeshConfig_TEXT
}

func (x *MeshConfig) GetEnableEnvoyAccessLogService() bool {
	if x != nil {
		return x.EnableEnvoyAccessLogService
	}
	return false
}

func (x *MeshConfig) GetDisableEnvoyListenerLog() bool {
	if x != nil {
		return x.DisableEnvoyListenerLog
	}
	return false
}

func (x *MeshConfig) GetDefaultConfig() *ProxyConfig {
	if x != nil {
		return x.DefaultConfig
	}
	return nil
}

func (x *MeshConfig) GetOutboundTrafficPolicy() *MeshConfig_OutboundTrafficPolicy {
	if x != nil {
		return x.OutboundTrafficPolicy
	}
	return nil
}

func (x *MeshConfig) GetInboundTrafficPolicy() *MeshConfig_InboundTrafficPolicy {
	if x != nil {
		return x.InboundTrafficPolicy
	}
	return nil
}

func (x *MeshConfig) GetConfigSources() []*ConfigSource {
	if x != nil {
		return x.ConfigSources
	}
	return nil
}

func (x *MeshConfig) GetEnableAutoMtls() *wrappers.BoolValue {
	if x != nil {
		return x.EnableAutoMtls
	}
	return nil
}

func (x *MeshConfig) GetTrustDomain() string {
	if x != nil {
		return x.TrustDomain
	}
	return ""
}

func (x *MeshConfig) GetTrustDomainAliases() []string {
	if x != nil {
		return x.TrustDomainAliases
	}
	return nil
}

func (x *MeshConfig) GetCaCertificates() []*MeshConfig_CertificateData {
	if x != nil {
		return x.CaCertificates
	}
	return nil
}

func (x *MeshConfig) GetDefaultServiceExportTo() []string {
	if x != nil {
		return x.DefaultServiceExportTo
	}
	return nil
}

func (x *MeshConfig) GetDefaultVirtualServiceExportTo() []string {
	if x != nil {
		return x.DefaultVirtualServiceExportTo
	}
	return nil
}

func (x *MeshConfig) GetDefaultDestinationRuleExportTo() []string {
	if x != nil {
		return x.DefaultDestinationRuleExportTo
	}
	return nil
}

func (x *MeshConfig) GetRootNamespace() string {
	if x != nil {
		return x.RootNamespace
	}
	return ""
}

func (x *MeshConfig) GetLocalityLbSetting() *v1alpha3.LocalityLoadBalancerSetting {
	if x != nil {
		return x.LocalityLbSetting
	}
	return nil
}

func (x *MeshConfig) GetDnsRefreshRate() *duration.Duration {
	if x != nil {
		return x.DnsRefreshRate
	}
	return nil
}

func (x *MeshConfig) GetH2UpgradePolicy() MeshConfig_H2UpgradePolicy {
	if x != nil {
		return x.H2UpgradePolicy
	}
	return MeshConfig_DO_NOT_UPGRADE
}

func (x *MeshConfig) GetInboundClusterStatName() string {
	if x != nil {
		return x.InboundClusterStatName
	}
	return ""
}

func (x *MeshConfig) GetOutboundClusterStatName() string {
	if x != nil {
		return x.OutboundClusterStatName
	}
	return ""
}

// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
func (x *MeshConfig) GetCertificates() []*Certificate {
	if x != nil {
		return x.Certificates
	}
	return nil
}

func (x *MeshConfig) GetServiceSettings() []*MeshConfig_ServiceSettings {
	if x != nil {
		return x.ServiceSettings
	}
	return nil
}

func (x *MeshConfig) GetServiceScopeConfigs() []*MeshConfig_ServiceScopeConfigs {
	if x != nil {
		return x.ServiceScopeConfigs
	}
	return nil
}

func (x *MeshConfig) GetEnablePrometheusMerge() *wrappers.BoolValue {
	if x != nil {
		return x.EnablePrometheusMerge
	}
	return nil
}

// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
func (x *MeshConfig) GetVerifyCertificateAtClient() *wrappers.BoolValue {
	if x != nil {
		return x.VerifyCertificateAtClient
	}
	return nil
}

func (x *MeshConfig) GetCa() *MeshConfig_CA {
	if x != nil {
		return x.Ca
	}
	return nil
}

func (x *MeshConfig) GetExtensionProviders() []*MeshConfig_ExtensionProvider {
	if x != nil {
		return x.ExtensionProviders
	}
	return nil
}

func (x *MeshConfig) GetDefaultProviders() *MeshConfig_DefaultProviders {
	if x != nil {
		return x.DefaultProviders
	}
	return nil
}

func (x *MeshConfig) GetDiscoverySelectors() []*LabelSelector {
	if x != nil {
		return x.DiscoverySelectors
	}
	return nil
}

func (x *MeshConfig) GetPathNormalization() *MeshConfig_ProxyPathNormalization {
	if x != nil {
		return x.PathNormalization
	}
	return nil
}

func (x *MeshConfig) GetDefaultHttpRetryPolicy() *v1alpha3.HTTPRetry {
	if x != nil {
		return x.DefaultHttpRetryPolicy
	}
	return nil
}

func (x *MeshConfig) GetMeshMTLS() *MeshConfig_TLSConfig {
	if x != nil {
		return x.MeshMTLS
	}
	return nil
}

func (x *MeshConfig) GetTlsDefaults() *MeshConfig_TLSConfig {
	if x != nil {
		return x.TlsDefaults
	}
	return nil
}

// A label selector requirement is a selector that contains values, a key, and an operator that
// relates the key and values.
// Copied from Kubernetes to avoid expensive dependency on Kubernetes libraries.
type LabelSelector struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
	// map is equivalent to an element of matchExpressions, whose key field is "key", the
	// operator is "In", and the values array contains only "value". The requirements are ANDed.
	// +optional
	MatchLabels map[string]string `protobuf:"bytes,1,rep,name=matchLabels,proto3" json:"matchLabels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// matchExpressions is a list of label selector requirements. The requirements are ANDed.
	// +optional
	MatchExpressions []*LabelSelectorRequirement `protobuf:"bytes,2,rep,name=matchExpressions,proto3" json:"matchExpressions,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *LabelSelector) Reset() {
	*x = LabelSelector{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelSelector) ProtoMessage() {}

func (x *LabelSelector) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelSelector.ProtoReflect.Descriptor instead.
func (*LabelSelector) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{1}
}

func (x *LabelSelector) GetMatchLabels() map[string]string {
	if x != nil {
		return x.MatchLabels
	}
	return nil
}

func (x *LabelSelector) GetMatchExpressions() []*LabelSelectorRequirement {
	if x != nil {
		return x.MatchExpressions
	}
	return nil
}

// A label selector requirement is a selector that contains values, a key, and an operator that
// relates the key and values.
// Copied from Kubernetes to avoid expensive dependency on Kubernetes libraries.
type LabelSelectorRequirement struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// key is the label key that the selector applies to.
	// +patchMergeKey=key
	// +patchStrategy=merge
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// operator represents a key's relationship to a set of values.
	// Valid operators are In, NotIn, Exists and DoesNotExist.
	Operator string `protobuf:"bytes,2,opt,name=operator,proto3" json:"operator,omitempty"`
	// values is an array of string values. If the operator is In or NotIn,
	// the values array must be non-empty. If the operator is Exists or DoesNotExist,
	// the values array must be empty. This array is replaced during a strategic
	// merge patch.
	// +optional
	Values        []string `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LabelSelectorRequirement) Reset() {
	*x = LabelSelectorRequirement{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelSelectorRequirement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelSelectorRequirement) ProtoMessage() {}

func (x *LabelSelectorRequirement) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelSelectorRequirement.ProtoReflect.Descriptor instead.
func (*LabelSelectorRequirement) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{2}
}

func (x *LabelSelectorRequirement) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *LabelSelectorRequirement) GetOperator() string {
	if x != nil {
		return x.Operator
	}
	return ""
}

func (x *LabelSelectorRequirement) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// ConfigSource describes information about a configuration store inside a
// mesh. A single control plane instance can interact with one or more data
// sources.
type ConfigSource struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Address of the server implementing the Istio Mesh Configuration
	// protocol (MCP). Can be IP address or a fully qualified DNS name.
	// Use xds:// to specify a grpc-based xds backend, k8s:// to specify a k8s controller or
	// fs:/// to specify a file-based backend with absolute path to the directory.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Use the tlsSettings to specify the tls mode to use. If the MCP server
	// uses Istio mutual TLS and shares the root CA with istiod, specify the TLS
	// mode as `ISTIO_MUTUAL`.
	TlsSettings *v1alpha3.ClientTLSSettings `protobuf:"bytes,2,opt,name=tls_settings,json=tlsSettings,proto3" json:"tls_settings,omitempty"`
	// Describes the source of configuration, if nothing is specified default is MCP
	SubscribedResources []Resource `protobuf:"varint,3,rep,packed,name=subscribed_resources,json=subscribedResources,proto3,enum=istio.mesh.v1alpha1.Resource" json:"subscribed_resources,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *ConfigSource) Reset() {
	*x = ConfigSource{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSource) ProtoMessage() {}

func (x *ConfigSource) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSource.ProtoReflect.Descriptor instead.
func (*ConfigSource) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{3}
}

func (x *ConfigSource) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *ConfigSource) GetTlsSettings() *v1alpha3.ClientTLSSettings {
	if x != nil {
		return x.TlsSettings
	}
	return nil
}

func (x *ConfigSource) GetSubscribedResources() []Resource {
	if x != nil {
		return x.SubscribedResources
	}
	return nil
}

// $hide_from_docs
// Certificate configures the provision of a certificate and its key.
// Example 1: key and cert stored in a secret
// ```
// { secretName: galley-cert
//
//	  secretNamespace: istio-system
//	  dnsNames:
//	    - galley.istio-system.svc
//	    - galley.mydomain.com
//	}
//
// ```
// Example 2: key and cert stored in a directory
// ```
// { dnsNames:
//   - pilot.istio-system
//   - pilot.istio-system.svc
//   - pilot.mydomain.com
//     }
//
// ```
type Certificate struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the secret the certificate and its key will be stored into.
	// If it is empty, it will not be stored into a secret.
	// Instead, the certificate and its key will be stored into a hard-coded directory.
	SecretName string `protobuf:"bytes,1,opt,name=secret_name,json=secretName,proto3" json:"secret_name,omitempty"`
	// The DNS names for the certificate. A certificate may contain
	// multiple DNS names.
	DnsNames      []string `protobuf:"bytes,2,rep,name=dns_names,json=dnsNames,proto3" json:"dns_names,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Certificate) Reset() {
	*x = Certificate{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Certificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate) ProtoMessage() {}

func (x *Certificate) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate.ProtoReflect.Descriptor instead.
func (*Certificate) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{4}
}

func (x *Certificate) GetSecretName() string {
	if x != nil {
		return x.SecretName
	}
	return ""
}

func (x *Certificate) GetDnsNames() []string {
	if x != nil {
		return x.DnsNames
	}
	return nil
}

// `OutboundTrafficPolicy` sets the default behavior of the sidecar for
// handling unknown outbound traffic from the application.
type MeshConfig_OutboundTrafficPolicy struct {
	state         protoimpl.MessageState                `protogen:"open.v1"`
	Mode          MeshConfig_OutboundTrafficPolicy_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=istio.mesh.v1alpha1.MeshConfig_OutboundTrafficPolicy_Mode" json:"mode,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_OutboundTrafficPolicy) Reset() {
	*x = MeshConfig_OutboundTrafficPolicy{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_OutboundTrafficPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_OutboundTrafficPolicy) ProtoMessage() {}

func (x *MeshConfig_OutboundTrafficPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_OutboundTrafficPolicy.ProtoReflect.Descriptor instead.
func (*MeshConfig_OutboundTrafficPolicy) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 0}
}

func (x *MeshConfig_OutboundTrafficPolicy) GetMode() MeshConfig_OutboundTrafficPolicy_Mode {
	if x != nil {
		return x.Mode
	}
	return MeshConfig_OutboundTrafficPolicy_REGISTRY_ONLY
}

type MeshConfig_InboundTrafficPolicy struct {
	state         protoimpl.MessageState               `protogen:"open.v1"`
	Mode          MeshConfig_InboundTrafficPolicy_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=istio.mesh.v1alpha1.MeshConfig_InboundTrafficPolicy_Mode" json:"mode,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_InboundTrafficPolicy) Reset() {
	*x = MeshConfig_InboundTrafficPolicy{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_InboundTrafficPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_InboundTrafficPolicy) ProtoMessage() {}

func (x *MeshConfig_InboundTrafficPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_InboundTrafficPolicy.ProtoReflect.Descriptor instead.
func (*MeshConfig_InboundTrafficPolicy) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 1}
}

func (x *MeshConfig_InboundTrafficPolicy) GetMode() MeshConfig_InboundTrafficPolicy_Mode {
	if x != nil {
		return x.Mode
	}
	return MeshConfig_InboundTrafficPolicy_PASSTHROUGH
}

type MeshConfig_CertificateData struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to CertificateData:
	//
	//	*MeshConfig_CertificateData_Pem
	//	*MeshConfig_CertificateData_SpiffeBundleUrl
	CertificateData isMeshConfig_CertificateData_CertificateData `protobuf_oneof:"certificate_data"`
	// Optional. Specify the kubernetes signers (External CA) that use this trustAnchor
	// when Istiod is acting as RA(registration authority)
	// If set, they are used for these signers. Otherwise, this trustAnchor is used for all signers.
	CertSigners []string `protobuf:"bytes,3,rep,name=cert_signers,json=certSigners,proto3" json:"cert_signers,omitempty"`
	// Optional. Specify the list of trust domains to which this trustAnchor data belongs.
	// If set, they are used for these trust domains. Otherwise, this trustAnchor is used for default trust domain
	// and its aliases.
	// Note that we can have multiple trustAnchor data for a same trustDomain.
	// In that case, trustAnchors with a same trust domain will be merged and used together to verify peer certificates.
	// If neither certSigners nor trustDomains is set, this trustAnchor is used for all trust domains and all signers.
	// If only trustDomains is set, this trustAnchor is used for these trustDomains and all signers.
	// If only certSigners is set, this trustAnchor is used for these certSigners and all trust domains.
	// If both certSigners and trustDomains is set, this trustAnchor is only used for these signers and trust domains.
	TrustDomains  []string `protobuf:"bytes,4,rep,name=trust_domains,json=trustDomains,proto3" json:"trust_domains,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_CertificateData) Reset() {
	*x = MeshConfig_CertificateData{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_CertificateData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_CertificateData) ProtoMessage() {}

func (x *MeshConfig_CertificateData) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_CertificateData.ProtoReflect.Descriptor instead.
func (*MeshConfig_CertificateData) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 2}
}

func (x *MeshConfig_CertificateData) GetCertificateData() isMeshConfig_CertificateData_CertificateData {
	if x != nil {
		return x.CertificateData
	}
	return nil
}

func (x *MeshConfig_CertificateData) GetPem() string {
	if x != nil {
		if x, ok := x.CertificateData.(*MeshConfig_CertificateData_Pem); ok {
			return x.Pem
		}
	}
	return ""
}

func (x *MeshConfig_CertificateData) GetSpiffeBundleUrl() string {
	if x != nil {
		if x, ok := x.CertificateData.(*MeshConfig_CertificateData_SpiffeBundleUrl); ok {
			return x.SpiffeBundleUrl
		}
	}
	return ""
}

func (x *MeshConfig_CertificateData) GetCertSigners() []string {
	if x != nil {
		return x.CertSigners
	}
	return nil
}

func (x *MeshConfig_CertificateData) GetTrustDomains() []string {
	if x != nil {
		return x.TrustDomains
	}
	return nil
}

type isMeshConfig_CertificateData_CertificateData interface {
	isMeshConfig_CertificateData_CertificateData()
}

type MeshConfig_CertificateData_Pem struct {
	// The PEM data of the certificate.
	Pem string `protobuf:"bytes,1,opt,name=pem,proto3,oneof"`
}

type MeshConfig_CertificateData_SpiffeBundleUrl struct {
	// The SPIFFE bundle endpoint URL that complies to:
	// https://github.com/spiffe/spiffe/blob/master/standards/SPIFFE_Trust_Domain_and_Bundle.md#the-spiffe-trust-domain-and-bundle
	// The endpoint should support authentication based on Web PKI:
	// https://github.com/spiffe/spiffe/blob/master/standards/SPIFFE_Trust_Domain_and_Bundle.md#521-web-pki
	// The certificate is retrieved from the endpoint.
	SpiffeBundleUrl string `protobuf:"bytes,2,opt,name=spiffe_bundle_url,json=spiffeBundleUrl,proto3,oneof"`
}

func (*MeshConfig_CertificateData_Pem) isMeshConfig_CertificateData_CertificateData() {}

func (*MeshConfig_CertificateData_SpiffeBundleUrl) isMeshConfig_CertificateData_CertificateData() {}

// $hide_from_docs
// Settings to be applied to select services.
//
// For example, the following configures all services in namespace "foo" as well as the
// "bar" service in namespace "baz" to be considered cluster-local:
//
// ```yaml
// serviceSettings:
//   - settings:
//     clusterLocal: true
//     hosts:
//   - "*.foo.svc.cluster.local"
//   - "bar.baz.svc.cluster.local"
//
// ```
//
// When in ambient mode, if ServiceSettings are defined they will be considered in addition to the
// ServiceScopeConfigs. If a service is defined by ServiceSetting to be cluster local and matches a
// global service scope selector, the service will be considered cluster local. If a service is
// considered global by ServiceSettings and does not match a global service scope selector
// the serive will be considered local. Local scope takes precedence over global scope. Since
// ServiceScopeConfigs is local by default, all services are considered local unless it is considered
// global by ServiceSettings AND ServiceScopeConfigs.
type MeshConfig_ServiceSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The settings to apply to the selected services.
	Settings *MeshConfig_ServiceSettings_Settings `protobuf:"bytes,1,opt,name=settings,proto3" json:"settings,omitempty"`
	// The services to which the Settings should be applied. Services are selected using the hostname
	// matching rules used by DestinationRule.
	//
	// For example: foo.bar.svc.cluster.local, *.baz.svc.cluster.local
	Hosts         []string `protobuf:"bytes,2,rep,name=hosts,proto3" json:"hosts,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ServiceSettings) Reset() {
	*x = MeshConfig_ServiceSettings{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ServiceSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ServiceSettings) ProtoMessage() {}

func (x *MeshConfig_ServiceSettings) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ServiceSettings.ProtoReflect.Descriptor instead.
func (*MeshConfig_ServiceSettings) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 3}
}

func (x *MeshConfig_ServiceSettings) GetSettings() *MeshConfig_ServiceSettings_Settings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *MeshConfig_ServiceSettings) GetHosts() []string {
	if x != nil {
		return x.Hosts
	}
	return nil
}

// Configuration for ambient mode multicluster service scope. This setting allows mesh administrators
// to define the criteria by which the cluster's control plane determines which services in other
// clusters in the mesh are treated as global (accessible across multiple clusters) versus local
// (restricted to a single cluster). The configuration can be applied to services based on namespace
// and/or other matching criteria. This is particularly  useful in multicluster service mesh deployments
// to control service visibility and access across clusters. This API is not intended to enforce
// security policies. Resources like DestinationRules should be used to enforce authorization policies.
// If a service matches a global service scope selector, the service's endpoints will be globally
// exposed. If a service is locally scoped, its endpoints will only be exposed to local cluster
// services.
//
// For example, the following configures the scope of all services with the "istio.io/global" label
// in matching namespaces to be available globally:
//
// ```yaml
// serviceScopeConfigs:
//   - namespacesSelector:
//     matchExpressions:
//   - key: istio.io/global
//     operator: In
//     values: [true]
//     servicesSelector:
//     matchExpressions:
//   - key: istio.io/global
//     operator: Exists
//     scope: GLOBAL
//
// ```
type MeshConfig_ServiceScopeConfigs struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Match expression for namespaces.
	NamespaceSelector *LabelSelector `protobuf:"bytes,1,opt,name=namespace_selector,json=namespaceSelector,proto3" json:"namespace_selector,omitempty"`
	// Match expression for serivces.
	ServicesSelector *LabelSelector `protobuf:"bytes,2,opt,name=services_selector,json=servicesSelector,proto3" json:"services_selector,omitempty"`
	// Specifics the available scope for matching services.
	Scope         MeshConfig_ServiceScopeConfigs_Scope `protobuf:"varint,3,opt,name=scope,proto3,enum=istio.mesh.v1alpha1.MeshConfig_ServiceScopeConfigs_Scope" json:"scope,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ServiceScopeConfigs) Reset() {
	*x = MeshConfig_ServiceScopeConfigs{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ServiceScopeConfigs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ServiceScopeConfigs) ProtoMessage() {}

func (x *MeshConfig_ServiceScopeConfigs) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ServiceScopeConfigs.ProtoReflect.Descriptor instead.
func (*MeshConfig_ServiceScopeConfigs) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 4}
}

func (x *MeshConfig_ServiceScopeConfigs) GetNamespaceSelector() *LabelSelector {
	if x != nil {
		return x.NamespaceSelector
	}
	return nil
}

func (x *MeshConfig_ServiceScopeConfigs) GetServicesSelector() *LabelSelector {
	if x != nil {
		return x.ServicesSelector
	}
	return nil
}

func (x *MeshConfig_ServiceScopeConfigs) GetScope() MeshConfig_ServiceScopeConfigs_Scope {
	if x != nil {
		return x.Scope
	}
	return MeshConfig_ServiceScopeConfigs_LOCAL
}

type MeshConfig_CA struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Address of the CA server implementing the Istio CA gRPC API.
	// Can be IP address or a fully qualified DNS name with port
	// Eg: custom-ca.default.svc.cluster.local:8932, 192.168.23.2:9000
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Use the tlsSettings to specify the tls mode to use.
	// Regarding tlsSettings:
	// - DISABLE MODE is legitimate for the case Istiod is making the request via an Envoy sidecar.
	// DISABLE MODE can also be used for testing
	// - TLS MUTUAL MODE be on by default. If the CA certificates
	// (cert bundle to verify the CA server's certificate) is omitted, Istiod will
	// use the system root certs to verify the CA server's certificate.
	TlsSettings *v1alpha3.ClientTLSSettings `protobuf:"bytes,2,opt,name=tls_settings,json=tlsSettings,proto3" json:"tls_settings,omitempty"`
	// timeout for forward CSR requests from Istiod to External CA
	// Default: 10s
	RequestTimeout *duration.Duration `protobuf:"bytes,3,opt,name=request_timeout,json=requestTimeout,proto3" json:"request_timeout,omitempty"`
	// Use istiodSide to specify CA Server integrate to Istiod side or Agent side
	// Default: true
	IstiodSide    bool `protobuf:"varint,4,opt,name=istiod_side,json=istiodSide,proto3" json:"istiod_side,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_CA) Reset() {
	*x = MeshConfig_CA{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_CA) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_CA) ProtoMessage() {}

func (x *MeshConfig_CA) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_CA.ProtoReflect.Descriptor instead.
func (*MeshConfig_CA) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 5}
}

func (x *MeshConfig_CA) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *MeshConfig_CA) GetTlsSettings() *v1alpha3.ClientTLSSettings {
	if x != nil {
		return x.TlsSettings
	}
	return nil
}

func (x *MeshConfig_CA) GetRequestTimeout() *duration.Duration {
	if x != nil {
		return x.RequestTimeout
	}
	return nil
}

func (x *MeshConfig_CA) GetIstiodSide() bool {
	if x != nil {
		return x.IstiodSide
	}
	return false
}

type MeshConfig_ExtensionProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. A unique name identifying the extension provider.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// REQUIRED. Specifies detailed configuration for the extension provider.
	//
	// Types that are valid to be assigned to Provider:
	//
	//	*MeshConfig_ExtensionProvider_EnvoyExtAuthzHttp
	//	*MeshConfig_ExtensionProvider_EnvoyExtAuthzGrpc
	//	*MeshConfig_ExtensionProvider_Zipkin
	//	*MeshConfig_ExtensionProvider_Lightstep
	//	*MeshConfig_ExtensionProvider_Datadog
	//	*MeshConfig_ExtensionProvider_Stackdriver
	//	*MeshConfig_ExtensionProvider_Opencensus
	//	*MeshConfig_ExtensionProvider_Skywalking
	//	*MeshConfig_ExtensionProvider_Opentelemetry
	//	*MeshConfig_ExtensionProvider_Prometheus
	//	*MeshConfig_ExtensionProvider_EnvoyFileAccessLog
	//	*MeshConfig_ExtensionProvider_EnvoyHttpAls
	//	*MeshConfig_ExtensionProvider_EnvoyTcpAls
	//	*MeshConfig_ExtensionProvider_EnvoyOtelAls
	//	*MeshConfig_ExtensionProvider_Sds
	Provider      isMeshConfig_ExtensionProvider_Provider `protobuf_oneof:"provider"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider) Reset() {
	*x = MeshConfig_ExtensionProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6}
}

func (x *MeshConfig_ExtensionProvider) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider) GetProvider() isMeshConfig_ExtensionProvider_Provider {
	if x != nil {
		return x.Provider
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider) GetEnvoyExtAuthzHttp() *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider {
	if x != nil {
		if x, ok := x.Provider.(*MeshConfig_ExtensionProvider_EnvoyExtAuthzHttp); ok {
			return x.EnvoyExtAuthzHttp
		}
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider) GetEnvoyExtAuthzGrpc() *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider {
	if x != nil {
		if x, ok := x.Provider.(*MeshConfig_ExtensionProvider_EnvoyExtAuthzGrpc); ok {
			return x.EnvoyExtAuthzGrpc
		}
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider) GetZipkin() *MeshConfig_ExtensionProvider_ZipkinTracingProvider {
	if x != nil {
		if x, ok := x.Provider.(*MeshConfig_ExtensionProvider_Zipkin); ok {
			return x.Zipkin
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
func (x *MeshConfig_ExtensionProvider) GetLightstep() *MeshConfig_ExtensionProvider_LightstepTracingProvider {
	if x != nil {
		if x, ok := x.Provider.(*MeshConfig_ExtensionProvider_Lightstep); ok {
			return x.Lightstep
		}
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider) GetDatadog() *MeshConfig_ExtensionProvider_DatadogTracingProvider {
	if x != nil {
		if x, ok := x.Provider.(*MeshConfig_ExtensionProvider_Datadog); ok {
			return x.Datadog
		}
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider) GetStackdriver() *MeshConfig_ExtensionProvider_StackdriverProvider {
	if x != nil {
		if x, ok := x.Provider.(*MeshConfig_ExtensionProvider_Stackdriver); ok {
			return x.Stackdriver
		}
	}
	return nil
}

// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
func (x *MeshConfig_ExtensionProvider) GetOpencensus() *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider {
	if x != nil {
		if x, ok := x.Provider.(*MeshConfig_ExtensionProvider_Opencensus); ok {
			return x.Opencensus
		}
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider) GetSkywalking() *MeshConfig_ExtensionProvider_SkyWalkingTracingProvider {
	if x != nil {
		if x, ok := x.Provider.(*MeshConfig_ExtensionProvider_Skywalking); ok {
			return x.Skywalking
		}
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider) GetOpentelemetry() *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider {
	if x != nil {
		if x, ok := x.Provider.(*MeshConfig_ExtensionProvider_Opentelemetry); ok {
			return x.Opentelemetry
		}
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider) GetPrometheus() *MeshConfig_ExtensionProvider_PrometheusMetricsProvider {
	if x != nil {
		if x, ok := x.Provider.(*MeshConfig_ExtensionProvider_Prometheus); ok {
			return x.Prometheus
		}
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider) GetEnvoyFileAccessLog() *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider {
	if x != nil {
		if x, ok := x.Provider.(*MeshConfig_ExtensionProvider_EnvoyFileAccessLog); ok {
			return x.EnvoyFileAccessLog
		}
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider) GetEnvoyHttpAls() *MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider {
	if x != nil {
		if x, ok := x.Provider.(*MeshConfig_ExtensionProvider_EnvoyHttpAls); ok {
			return x.EnvoyHttpAls
		}
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider) GetEnvoyTcpAls() *MeshConfig_ExtensionProvider_EnvoyTcpGrpcV3LogProvider {
	if x != nil {
		if x, ok := x.Provider.(*MeshConfig_ExtensionProvider_EnvoyTcpAls); ok {
			return x.EnvoyTcpAls
		}
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider) GetEnvoyOtelAls() *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider {
	if x != nil {
		if x, ok := x.Provider.(*MeshConfig_ExtensionProvider_EnvoyOtelAls); ok {
			return x.EnvoyOtelAls
		}
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider) GetSds() *MeshConfig_ExtensionProvider_SDSProvider {
	if x != nil {
		if x, ok := x.Provider.(*MeshConfig_ExtensionProvider_Sds); ok {
			return x.Sds
		}
	}
	return nil
}

type isMeshConfig_ExtensionProvider_Provider interface {
	isMeshConfig_ExtensionProvider_Provider()
}

type MeshConfig_ExtensionProvider_EnvoyExtAuthzHttp struct {
	// Configures an external authorizer that implements the Envoy ext_authz filter authorization check service using the HTTP API.
	EnvoyExtAuthzHttp *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider `protobuf:"bytes,2,opt,name=envoy_ext_authz_http,json=envoyExtAuthzHttp,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_EnvoyExtAuthzGrpc struct {
	// Configures an external authorizer that implements the Envoy ext_authz filter authorization check service using the gRPC API.
	EnvoyExtAuthzGrpc *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider `protobuf:"bytes,3,opt,name=envoy_ext_authz_grpc,json=envoyExtAuthzGrpc,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_Zipkin struct {
	// Configures a tracing provider that uses the Zipkin API.
	Zipkin *MeshConfig_ExtensionProvider_ZipkinTracingProvider `protobuf:"bytes,4,opt,name=zipkin,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_Lightstep struct {
	// $hide_from_docs
	// Configures a Lightstep tracing provider.
	// Deprecated: For Istio 1.15+, please use an OpenTelemetryTracingProvider instead, more details can be found at https://github.com/istio/istio/issues/40027
	//
	// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
	Lightstep *MeshConfig_ExtensionProvider_LightstepTracingProvider `protobuf:"bytes,5,opt,name=lightstep,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_Datadog struct {
	// Configures a Datadog tracing provider.
	Datadog *MeshConfig_ExtensionProvider_DatadogTracingProvider `protobuf:"bytes,6,opt,name=datadog,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_Stackdriver struct {
	// $hide_from_docs
	// Configures a Stackdriver provider.
	Stackdriver *MeshConfig_ExtensionProvider_StackdriverProvider `protobuf:"bytes,7,opt,name=stackdriver,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_Opencensus struct {
	// $hide_from_docs
	// Configures an OpenCensusAgent tracing provider.
	// Deprecated: OpenCensus is deprecated, more details can be found at https://opentelemetry.io/blog/2023/sunsetting-opencensus/
	//
	// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
	Opencensus *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider `protobuf:"bytes,8,opt,name=opencensus,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_Skywalking struct {
	// Configures a Apache SkyWalking provider.
	Skywalking *MeshConfig_ExtensionProvider_SkyWalkingTracingProvider `protobuf:"bytes,9,opt,name=skywalking,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_Opentelemetry struct {
	// Configures an OpenTelemetry tracing provider.
	Opentelemetry *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider `protobuf:"bytes,15,opt,name=opentelemetry,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_Prometheus struct {
	// Configures a Prometheus metrics provider.
	Prometheus *MeshConfig_ExtensionProvider_PrometheusMetricsProvider `protobuf:"bytes,10,opt,name=prometheus,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_EnvoyFileAccessLog struct {
	// Configures an Envoy File Access Log provider.
	EnvoyFileAccessLog *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider `protobuf:"bytes,11,opt,name=envoy_file_access_log,json=envoyFileAccessLog,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_EnvoyHttpAls struct {
	// Configures an Envoy Access Logging Service provider for HTTP traffic.
	EnvoyHttpAls *MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider `protobuf:"bytes,12,opt,name=envoy_http_als,json=envoyHttpAls,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_EnvoyTcpAls struct {
	// Configures an Envoy Access Logging Service provider for TCP traffic.
	EnvoyTcpAls *MeshConfig_ExtensionProvider_EnvoyTcpGrpcV3LogProvider `protobuf:"bytes,13,opt,name=envoy_tcp_als,json=envoyTcpAls,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_EnvoyOtelAls struct {
	// Configures an Envoy Open Telemetry Access Logging Service provider.
	EnvoyOtelAls *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider `protobuf:"bytes,14,opt,name=envoy_otel_als,json=envoyOtelAls,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_Sds struct {
	// Configures an Extension Provider for SDS. This can be used to
	// configure an external SDS service to supply secrets for certain Gateways for example.
	// This is useful for scenarios where the secrets are stored in an external secret store like Vault.
	// The secret should be configured with sds://provider-name format.
	Sds *MeshConfig_ExtensionProvider_SDSProvider `protobuf:"bytes,16,opt,name=sds,proto3,oneof"`
}

func (*MeshConfig_ExtensionProvider_EnvoyExtAuthzHttp) isMeshConfig_ExtensionProvider_Provider() {}

func (*MeshConfig_ExtensionProvider_EnvoyExtAuthzGrpc) isMeshConfig_ExtensionProvider_Provider() {}

func (*MeshConfig_ExtensionProvider_Zipkin) isMeshConfig_ExtensionProvider_Provider() {}

func (*MeshConfig_ExtensionProvider_Lightstep) isMeshConfig_ExtensionProvider_Provider() {}

func (*MeshConfig_ExtensionProvider_Datadog) isMeshConfig_ExtensionProvider_Provider() {}

func (*MeshConfig_ExtensionProvider_Stackdriver) isMeshConfig_ExtensionProvider_Provider() {}

func (*MeshConfig_ExtensionProvider_Opencensus) isMeshConfig_ExtensionProvider_Provider() {}

func (*MeshConfig_ExtensionProvider_Skywalking) isMeshConfig_ExtensionProvider_Provider() {}

func (*MeshConfig_ExtensionProvider_Opentelemetry) isMeshConfig_ExtensionProvider_Provider() {}

func (*MeshConfig_ExtensionProvider_Prometheus) isMeshConfig_ExtensionProvider_Provider() {}

func (*MeshConfig_ExtensionProvider_EnvoyFileAccessLog) isMeshConfig_ExtensionProvider_Provider() {}

func (*MeshConfig_ExtensionProvider_EnvoyHttpAls) isMeshConfig_ExtensionProvider_Provider() {}

func (*MeshConfig_ExtensionProvider_EnvoyTcpAls) isMeshConfig_ExtensionProvider_Provider() {}

func (*MeshConfig_ExtensionProvider_EnvoyOtelAls) isMeshConfig_ExtensionProvider_Provider() {}

func (*MeshConfig_ExtensionProvider_Sds) isMeshConfig_ExtensionProvider_Provider() {}

// Holds the name references to the providers that will be used by default
// in other Istio configuration resources if the provider is not specified.
//
// These names must match a provider defined in `extensionProviders` that is
// one of the supported tracing providers.
type MeshConfig_DefaultProviders struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the default provider(s) for tracing.
	Tracing []string `protobuf:"bytes,1,rep,name=tracing,proto3" json:"tracing,omitempty"`
	// Name of the default provider(s) for metrics.
	Metrics []string `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// Name of the default provider(s) for access logging.
	AccessLogging []string `protobuf:"bytes,3,rep,name=access_logging,json=accessLogging,proto3" json:"access_logging,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_DefaultProviders) Reset() {
	*x = MeshConfig_DefaultProviders{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_DefaultProviders) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_DefaultProviders) ProtoMessage() {}

func (x *MeshConfig_DefaultProviders) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_DefaultProviders.ProtoReflect.Descriptor instead.
func (*MeshConfig_DefaultProviders) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 7}
}

func (x *MeshConfig_DefaultProviders) GetTracing() []string {
	if x != nil {
		return x.Tracing
	}
	return nil
}

func (x *MeshConfig_DefaultProviders) GetMetrics() []string {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *MeshConfig_DefaultProviders) GetAccessLogging() []string {
	if x != nil {
		return x.AccessLogging
	}
	return nil
}

type MeshConfig_ProxyPathNormalization struct {
	state         protoimpl.MessageState                              `protogen:"open.v1"`
	Normalization MeshConfig_ProxyPathNormalization_NormalizationType `protobuf:"varint,1,opt,name=normalization,proto3,enum=istio.mesh.v1alpha1.MeshConfig_ProxyPathNormalization_NormalizationType" json:"normalization,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ProxyPathNormalization) Reset() {
	*x = MeshConfig_ProxyPathNormalization{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ProxyPathNormalization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ProxyPathNormalization) ProtoMessage() {}

func (x *MeshConfig_ProxyPathNormalization) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ProxyPathNormalization.ProtoReflect.Descriptor instead.
func (*MeshConfig_ProxyPathNormalization) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 8}
}

func (x *MeshConfig_ProxyPathNormalization) GetNormalization() MeshConfig_ProxyPathNormalization_NormalizationType {
	if x != nil {
		return x.Normalization
	}
	return MeshConfig_ProxyPathNormalization_DEFAULT
}

type MeshConfig_TLSConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Optional: the minimum TLS protocol version. The default minimum
	// TLS version will be TLS 1.2. As servers may not be Envoy and be
	// set to TLS 1.2 (e.g., workloads using mTLS without sidecars), the
	// minimum TLS version for clients may also be TLS 1.2.
	// In the current Istio implementation, the maximum TLS protocol version
	// is TLS 1.3.
	MinProtocolVersion MeshConfig_TLSConfig_TLSProtocol `protobuf:"varint,1,opt,name=min_protocol_version,json=minProtocolVersion,proto3,enum=istio.mesh.v1alpha1.MeshConfig_TLSConfig_TLSProtocol" json:"min_protocol_version,omitempty"`
	// Optional: If specified, the TLS connection will only support the specified ECDH curves for the DH key exchange.
	// If not specified, the default curves enforced by Envoy will be used. For details about the default curves, refer to
	// [Ecdh Curves](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/transport_sockets/tls/v3/common.proto).
	EcdhCurves []string `protobuf:"bytes,2,rep,name=ecdh_curves,json=ecdhCurves,proto3" json:"ecdh_curves,omitempty"`
	// Optional: If specified, the TLS connection will only support the specified cipher list when negotiating TLS 1.0-1.2.
	// If not specified, the following cipher suites will be used:
	// ```
	// ECDHE-ECDSA-AES256-GCM-SHA384
	// ECDHE-RSA-AES256-GCM-SHA384
	// ECDHE-ECDSA-AES128-GCM-SHA256
	// ECDHE-RSA-AES128-GCM-SHA256
	// AES256-GCM-SHA384
	// AES128-GCM-SHA256
	// ```
	CipherSuites  []string `protobuf:"bytes,3,rep,name=cipher_suites,json=cipherSuites,proto3" json:"cipher_suites,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_TLSConfig) Reset() {
	*x = MeshConfig_TLSConfig{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_TLSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_TLSConfig) ProtoMessage() {}

func (x *MeshConfig_TLSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_TLSConfig.ProtoReflect.Descriptor instead.
func (*MeshConfig_TLSConfig) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 9}
}

func (x *MeshConfig_TLSConfig) GetMinProtocolVersion() MeshConfig_TLSConfig_TLSProtocol {
	if x != nil {
		return x.MinProtocolVersion
	}
	return MeshConfig_TLSConfig_TLS_AUTO
}

func (x *MeshConfig_TLSConfig) GetEcdhCurves() []string {
	if x != nil {
		return x.EcdhCurves
	}
	return nil
}

func (x *MeshConfig_TLSConfig) GetCipherSuites() []string {
	if x != nil {
		return x.CipherSuites
	}
	return nil
}

// Settings for the selected services.
type MeshConfig_ServiceSettings_Settings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// If true, specifies that the client and service endpoints must reside in the same cluster.
	// By default, in multi-cluster deployments, the Istio control plane assumes all service
	// endpoints to be reachable from any client in any of the clusters which are part of the
	// mesh. This configuration option limits the set of service endpoints visible to a client
	// to be cluster scoped.
	//
	// There are some common scenarios when this can be useful:
	//
	//   - A service (or group of services) is inherently local to the cluster and has local storage
	//     for that cluster. For example, the kube-system namespace (e.g. the Kube API Server).
	//   - A mesh administrator wants to slowly migrate services to Istio. They might start by first
	//     having services cluster-local and then slowly transition them to mesh-wide. They could do
	//     this service-by-service (e.g. mysvc.myns.svc.cluster.local) or as a group
	//     (e.g. *.myns.svc.cluster.local).
	//
	// By default Istio will consider kubernetes.default.svc (i.e. the API Server) as well as all
	// services in the kube-system namespace to be cluster-local, unless explicitly overridden here.
	ClusterLocal  bool `protobuf:"varint,1,opt,name=cluster_local,json=clusterLocal,proto3" json:"cluster_local,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ServiceSettings_Settings) Reset() {
	*x = MeshConfig_ServiceSettings_Settings{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ServiceSettings_Settings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ServiceSettings_Settings) ProtoMessage() {}

func (x *MeshConfig_ServiceSettings_Settings) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ServiceSettings_Settings.ProtoReflect.Descriptor instead.
func (*MeshConfig_ServiceSettings_Settings) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 3, 0}
}

func (x *MeshConfig_ServiceSettings_Settings) GetClusterLocal() bool {
	if x != nil {
		return x.ClusterLocal
	}
	return false
}

type MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Sets the maximum size of a message body that the ext-authz filter will hold in memory.
	// If maxRequestBytes is reached, and allowPartialMessage is false, Envoy will return a 413 (Payload Too Large).
	// Otherwise the request will be sent to the provider with a partial message.
	// Note that this setting will have precedence over the failOpen field, the 413 will be returned even when the
	// failOpen is set to true.
	MaxRequestBytes uint32 `protobuf:"varint,1,opt,name=max_request_bytes,json=maxRequestBytes,proto3" json:"max_request_bytes,omitempty"`
	// When this field is true, ext-authz filter will buffer the message until maxRequestBytes is reached.
	// The authorization request will be dispatched and no 413 HTTP error will be returned by the filter.
	// A "x-envoy-auth-partial-body: false|true" metadata header will be added to the authorization request message
	// indicating if the body data is partial.
	AllowPartialMessage bool `protobuf:"varint,2,opt,name=allow_partial_message,json=allowPartialMessage,proto3" json:"allow_partial_message,omitempty"`
	// If true, the body sent to the external authorization service in the gRPC authorization request is set with raw bytes
	// in the [raw_body field](https://github.com/envoyproxy/envoy/blame/cffb095d59d7935abda12b9509bcd136808367bb/api/envoy/service/auth/v3/attribute_context.proto#L153).
	// Otherwise, it will be filled with UTF-8 string in the [body field](https://github.com/envoyproxy/envoy/blame/cffb095d59d7935abda12b9509bcd136808367bb/api/envoy/service/auth/v3/attribute_context.proto#L147).
	// This field only works with the envoyExtAuthzGrpc provider and has no effect for the envoyExtAuthzHttp provider.
	PackAsBytes   bool `protobuf:"varint,3,opt,name=pack_as_bytes,json=packAsBytes,proto3" json:"pack_as_bytes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) Reset() {
	*x = MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 0}
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) GetMaxRequestBytes() uint32 {
	if x != nil {
		return x.MaxRequestBytes
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) GetAllowPartialMessage() bool {
	if x != nil {
		return x.AllowPartialMessage
	}
	return false
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody) GetPackAsBytes() bool {
	if x != nil {
		return x.PackAsBytes
	}
	return false
}

type MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Specifies the service that implements the Envoy ext_authz HTTP authorization service.
	// The format is `[<Namespace>/]<Hostname>`. The specification of `<Namespace>` is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The `<Hostname>` is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "my-ext-authz.foo.svc.cluster.local" or "bar/my-ext-authz.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// The maximum duration that the proxy will wait for a response from the provider (default timeout: 600s).
	// When this timeout condition is met, the proxy marks the communication to the authorization service as failure.
	// In this situation, the response sent back to the client will depend on the configured `failOpen` field.
	Timeout *duration.Duration `protobuf:"bytes,9,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Sets a prefix to the value of authorization request header *Path*.
	// For example, setting this to "/check" for an original user request at path "/admin" will cause the
	// authorization check request to be sent to the authorization service at the path "/check/admin" instead of "/admin".
	PathPrefix string `protobuf:"bytes,3,opt,name=path_prefix,json=pathPrefix,proto3" json:"path_prefix,omitempty"`
	// If true, the user request will be allowed even if the communication with the authorization service has failed,
	// or if the authorization service has returned a HTTP 5xx error.
	// Default is false and the request will be rejected with "Forbidden" response.
	FailOpen bool `protobuf:"varint,4,opt,name=fail_open,json=failOpen,proto3" json:"fail_open,omitempty"`
	// If true, clears route cache in order to allow the external authorization service to correctly affect routing decisions.
	// If true, recalculate routes with the new ExtAuthZ added/removed headers.
	// Default is false
	ClearRouteCache bool `protobuf:"varint,14,opt,name=clear_route_cache,json=clearRouteCache,proto3" json:"clear_route_cache,omitempty"`
	// Sets the HTTP status that is returned to the client when there is a network error to the authorization service.
	// The default status is "403" (HTTP Forbidden).
	StatusOnError string `protobuf:"bytes,5,opt,name=status_on_error,json=statusOnError,proto3" json:"status_on_error,omitempty"`
	// DEPRECATED. Use includeRequestHeadersInCheck instead.
	//
	// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
	IncludeHeadersInCheck []string `protobuf:"bytes,6,rep,name=include_headers_in_check,json=includeHeadersInCheck,proto3" json:"include_headers_in_check,omitempty"`
	// List of client request headers that should be included in the authorization request sent to the authorization service.
	// Note that in addition to the headers specified here following headers are included by default:
	// 1. *Host*, *Method*, *Path* and *Content-Length* are automatically sent.
	// 2. *Content-Length* will be set to 0 and the request will not have a message body. However, the authorization
	// request can include the buffered client request body (controlled by includeRequestBodyInCheck setting),
	// consequently the value of Content-Length of the authorization request reflects the size of its payload size.
	//
	// Exact, prefix and suffix matches are supported (similar to the
	// [authorization policy rule syntax](https://istio.io/latest/docs/reference/config/security/authorization-policy/#Rule)
	// except the presence match):
	// - Exact match: "abc" will match on value "abc".
	// - Prefix match: "abc*" will match on value "abc" and "abcd".
	// - Suffix match: "*abc" will match on value "abc" and "xabc".
	IncludeRequestHeadersInCheck []string `protobuf:"bytes,10,rep,name=include_request_headers_in_check,json=includeRequestHeadersInCheck,proto3" json:"include_request_headers_in_check,omitempty"`
	// Set of additional fixed headers that should be included in the authorization request sent to the authorization service.
	// Key is the header name and value is the header value.
	// Note that client request of the same key or headers specified in includeRequestHeadersInCheck will be overridden.
	IncludeAdditionalHeadersInCheck map[string]string `protobuf:"bytes,11,rep,name=include_additional_headers_in_check,json=includeAdditionalHeadersInCheck,proto3" json:"include_additional_headers_in_check,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// If set, the client request body will be included in the authorization request sent to the authorization service.
	IncludeRequestBodyInCheck *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody `protobuf:"bytes,12,opt,name=include_request_body_in_check,json=includeRequestBodyInCheck,proto3" json:"include_request_body_in_check,omitempty"`
	// List of headers from the authorization service that should be added or overridden in the original request and
	// forwarded to the upstream when the authorization check result is allowed (HTTP code 200).
	// If not specified, the original request will not be modified and forwarded to backend as-is.
	// Note, any existing headers will be overridden.
	//
	// Exact, prefix and suffix matches are supported (similar to the
	// [authorization policy rule syntax](https://istio.io/latest/docs/reference/config/security/authorization-policy/#Rule)
	// except the presence match):
	// - Exact match: "abc" will match on value "abc".
	// - Prefix match: "abc*" will match on value "abc" and "abcd".
	// - Suffix match: "*abc" will match on value "abc" and "xabc".
	HeadersToUpstreamOnAllow []string `protobuf:"bytes,7,rep,name=headers_to_upstream_on_allow,json=headersToUpstreamOnAllow,proto3" json:"headers_to_upstream_on_allow,omitempty"`
	// List of headers from the authorization service that should be forwarded to downstream when the authorization
	// check result is not allowed (HTTP code other than 200).
	// If not specified, all the authorization response headers, except *Authority (Host)* will be in the response to
	// the downstream.
	// When a header is included in this list, *Path*, *Status*, *Content-Length*, *WWWAuthenticate* and *Location* are
	// automatically added.
	// Note, the body from the authorization service is always included in the response to downstream.
	//
	// Exact, prefix and suffix matches are supported (similar to the
	// [authorization policy rule syntax](https://istio.io/latest/docs/reference/config/security/authorization-policy/#Rule)
	// except the presence match):
	// - Exact match: "abc" will match on value "abc".
	// - Prefix match: "abc*" will match on value "abc" and "abcd".
	// - Suffix match: "*abc" will match on value "abc" and "xabc".
	HeadersToDownstreamOnDeny []string `protobuf:"bytes,8,rep,name=headers_to_downstream_on_deny,json=headersToDownstreamOnDeny,proto3" json:"headers_to_downstream_on_deny,omitempty"`
	// List of headers from the authorization service that should be forwarded to downstream when the authorization
	// check result is allowed (HTTP code 200).
	// If not specified, the original response will not be modified and forwarded to downstream as-is.
	// Note, any existing headers will be overridden.
	//
	// Exact, prefix and suffix matches are supported (similar to the
	// [authorization policy rule syntax](https://istio.io/latest/docs/reference/config/security/authorization-policy/#Rule)
	// except the presence match):
	// - Exact match: "abc" will match on value "abc".
	// - Prefix match: "abc*" will match on value "abc" and "abcd".
	// - Suffix match: "*abc" will match on value "abc" and "xabc".
	HeadersToDownstreamOnAllow []string `protobuf:"bytes,13,rep,name=headers_to_downstream_on_allow,json=headersToDownstreamOnAllow,proto3" json:"headers_to_downstream_on_allow,omitempty"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) Reset() {
	*x = MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 1}
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetTimeout() *duration.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetPathPrefix() string {
	if x != nil {
		return x.PathPrefix
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetFailOpen() bool {
	if x != nil {
		return x.FailOpen
	}
	return false
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetClearRouteCache() bool {
	if x != nil {
		return x.ClearRouteCache
	}
	return false
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetStatusOnError() string {
	if x != nil {
		return x.StatusOnError
	}
	return ""
}

// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetIncludeHeadersInCheck() []string {
	if x != nil {
		return x.IncludeHeadersInCheck
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetIncludeRequestHeadersInCheck() []string {
	if x != nil {
		return x.IncludeRequestHeadersInCheck
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetIncludeAdditionalHeadersInCheck() map[string]string {
	if x != nil {
		return x.IncludeAdditionalHeadersInCheck
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetIncludeRequestBodyInCheck() *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody {
	if x != nil {
		return x.IncludeRequestBodyInCheck
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetHeadersToUpstreamOnAllow() []string {
	if x != nil {
		return x.HeadersToUpstreamOnAllow
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetHeadersToDownstreamOnDeny() []string {
	if x != nil {
		return x.HeadersToDownstreamOnDeny
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider) GetHeadersToDownstreamOnAllow() []string {
	if x != nil {
		return x.HeadersToDownstreamOnAllow
	}
	return nil
}

type MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Specifies the service that implements the Envoy ext_authz gRPC authorization service.
	// The format is `[<Namespace>/]<Hostname>`. The specification of `<Namespace>` is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The `<Hostname>` is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "my-ext-authz.foo.svc.cluster.local" or "bar/my-ext-authz.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// The maximum duration that the proxy will wait for a response from the provider, this is the timeout for a specific request (default timeout: 600s).
	// When this timeout condition is met, the proxy marks the communication to the authorization service as failure.
	// In this situation, the response sent back to the client will depend on the configured `failOpen` field.
	Timeout *duration.Duration `protobuf:"bytes,5,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// If true, the HTTP request or TCP connection will be allowed even if the communication with the authorization service has failed,
	// or if the authorization service has returned a HTTP 5xx error.
	// Default is false. For HTTP request, it will be rejected with 403 (HTTP Forbidden). For TCP connection, it will be closed immediately.
	FailOpen bool `protobuf:"varint,3,opt,name=fail_open,json=failOpen,proto3" json:"fail_open,omitempty"`
	// If true, clears route cache in order to allow the external authorization service to correctly affect routing decisions.
	// If true, recalculate routes with the new ExtAuthZ added/removed headers.
	// Default is false
	ClearRouteCache bool `protobuf:"varint,7,opt,name=clear_route_cache,json=clearRouteCache,proto3" json:"clear_route_cache,omitempty"`
	// Sets the HTTP status that is returned to the client when there is a network error to the authorization service.
	// The default status is "403" (HTTP Forbidden).
	StatusOnError string `protobuf:"bytes,4,opt,name=status_on_error,json=statusOnError,proto3" json:"status_on_error,omitempty"`
	// If set, the client request body will be included in the authorization request sent to the authorization service.
	IncludeRequestBodyInCheck *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody `protobuf:"bytes,6,opt,name=include_request_body_in_check,json=includeRequestBodyInCheck,proto3" json:"include_request_body_in_check,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) Reset() {
	*x = MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 2}
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) GetTimeout() *duration.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) GetFailOpen() bool {
	if x != nil {
		return x.FailOpen
	}
	return false
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) GetClearRouteCache() bool {
	if x != nil {
		return x.ClearRouteCache
	}
	return false
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) GetStatusOnError() string {
	if x != nil {
		return x.StatusOnError
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider) GetIncludeRequestBodyInCheck() *MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody {
	if x != nil {
		return x.IncludeRequestBodyInCheck
	}
	return nil
}

// Defines configuration for a Zipkin tracer.
type MeshConfig_ExtensionProvider_ZipkinTracingProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Specifies the service that the Zipkin API.
	// The format is `[<Namespace>/]<Hostname>`. The specification of `<Namespace>` is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The `<Hostname>` is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "zipkin.default.svc.cluster.local" or "bar/zipkin.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Optional. Controls the overall path length allowed in a reported span.
	// NOTE: currently only controls max length of the path tag.
	MaxTagLength uint32 `protobuf:"varint,3,opt,name=max_tag_length,json=maxTagLength,proto3" json:"max_tag_length,omitempty"`
	// Optional. A 128 bit trace id will be used in Istio.
	// If true, will result in a 64 bit trace id being used.
	Enable_64BitTraceId bool `protobuf:"varint,4,opt,name=enable_64bit_trace_id,json=enable64bitTraceId,proto3" json:"enable_64bit_trace_id,omitempty"`
	// Optional. Specifies the endpoint of Zipkin API.
	// The default value is "/api/v2/spans".
	Path          string `protobuf:"bytes,5,opt,name=path,proto3" json:"path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_ZipkinTracingProvider) Reset() {
	*x = MeshConfig_ExtensionProvider_ZipkinTracingProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_ZipkinTracingProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_ZipkinTracingProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_ZipkinTracingProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_ZipkinTracingProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_ZipkinTracingProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 3}
}

func (x *MeshConfig_ExtensionProvider_ZipkinTracingProvider) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_ZipkinTracingProvider) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_ZipkinTracingProvider) GetMaxTagLength() uint32 {
	if x != nil {
		return x.MaxTagLength
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_ZipkinTracingProvider) GetEnable_64BitTraceId() bool {
	if x != nil {
		return x.Enable_64BitTraceId
	}
	return false
}

func (x *MeshConfig_ExtensionProvider_ZipkinTracingProvider) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// Defines configuration for a Lightstep tracer.
// Note: Lightstep has moved to OpenTelemetry-based integrations. Istio 1.15+
// will generate OpenTelemetry-compatible configuration when using this option.
type MeshConfig_ExtensionProvider_LightstepTracingProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Specifies the service for the Lightstep collector.
	// The format is `[<Namespace>/]<Hostname>`. The specification of `<Namespace>` is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The `<Hostname>` is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "lightstep.default.svc.cluster.local" or "bar/lightstep.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// The Lightstep access token.
	AccessToken string `protobuf:"bytes,3,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	// Optional. Controls the overall path length allowed in a reported span.
	// NOTE: currently only controls max length of the path tag.
	MaxTagLength  uint32 `protobuf:"varint,4,opt,name=max_tag_length,json=maxTagLength,proto3" json:"max_tag_length,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_LightstepTracingProvider) Reset() {
	*x = MeshConfig_ExtensionProvider_LightstepTracingProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_LightstepTracingProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_LightstepTracingProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_LightstepTracingProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_LightstepTracingProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_LightstepTracingProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 4}
}

func (x *MeshConfig_ExtensionProvider_LightstepTracingProvider) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_LightstepTracingProvider) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_LightstepTracingProvider) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_LightstepTracingProvider) GetMaxTagLength() uint32 {
	if x != nil {
		return x.MaxTagLength
	}
	return 0
}

// Defines configuration for a Datadog tracer.
type MeshConfig_ExtensionProvider_DatadogTracingProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Specifies the service for the Datadog agent.
	// The format is `[<Namespace>/]<Hostname>`. The specification of `<Namespace>` is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The `<Hostname>` is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "datadog.default.svc.cluster.local" or "bar/datadog.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Optional. Controls the overall path length allowed in a reported span.
	// NOTE: currently only controls max length of the path tag.
	MaxTagLength  uint32 `protobuf:"varint,3,opt,name=max_tag_length,json=maxTagLength,proto3" json:"max_tag_length,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_DatadogTracingProvider) Reset() {
	*x = MeshConfig_ExtensionProvider_DatadogTracingProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_DatadogTracingProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_DatadogTracingProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_DatadogTracingProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_DatadogTracingProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_DatadogTracingProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 5}
}

func (x *MeshConfig_ExtensionProvider_DatadogTracingProvider) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_DatadogTracingProvider) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_DatadogTracingProvider) GetMaxTagLength() uint32 {
	if x != nil {
		return x.MaxTagLength
	}
	return 0
}

// Defines configuration for a SkyWalking tracer.
type MeshConfig_ExtensionProvider_SkyWalkingTracingProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Specifies the service for the SkyWalking receiver.
	// The format is `[<Namespace>/]<Hostname>`. The specification of `<Namespace>` is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The `<Hostname>` is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "skywalking.default.svc.cluster.local" or "bar/skywalking.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Optional. The SkyWalking OAP access token.
	AccessToken   string `protobuf:"bytes,3,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_SkyWalkingTracingProvider) Reset() {
	*x = MeshConfig_ExtensionProvider_SkyWalkingTracingProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_SkyWalkingTracingProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_SkyWalkingTracingProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_SkyWalkingTracingProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_SkyWalkingTracingProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_SkyWalkingTracingProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 6}
}

func (x *MeshConfig_ExtensionProvider_SkyWalkingTracingProvider) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_SkyWalkingTracingProvider) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_SkyWalkingTracingProvider) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

// Defines configuration for Stackdriver.
//
// WARNING: Stackdriver tracing uses OpenCensus configuration under the hood and, as a result, cannot be used
// alongside any OpenCensus provider configuration. This is due to a limitation in the implementation of OpenCensus
// driver in Envoy.
type MeshConfig_ExtensionProvider_StackdriverProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// debug enables trace output to stdout.
	// $hide_from_docs
	//
	// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
	Debug bool `protobuf:"varint,1,opt,name=debug,proto3" json:"debug,omitempty"`
	// The global default max number of attributes per span.
	// default is 200.
	// $hide_from_docs
	//
	// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
	MaxNumberOfAttributes *wrappers.Int64Value `protobuf:"bytes,2,opt,name=max_number_of_attributes,json=maxNumberOfAttributes,proto3" json:"max_number_of_attributes,omitempty"`
	// The global default max number of annotation events per span.
	// default is 200.
	// $hide_from_docs
	//
	// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
	MaxNumberOfAnnotations *wrappers.Int64Value `protobuf:"bytes,3,opt,name=max_number_of_annotations,json=maxNumberOfAnnotations,proto3" json:"max_number_of_annotations,omitempty"`
	// The global default max number of message events per span.
	// default is 200.
	// $hide_from_docs
	//
	// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
	MaxNumberOfMessageEvents *wrappers.Int64Value `protobuf:"bytes,4,opt,name=max_number_of_message_events,json=maxNumberOfMessageEvents,proto3" json:"max_number_of_message_events,omitempty"`
	// Optional. Controls the overall path length allowed in a reported span.
	// NOTE: currently only controls max length of the path tag.
	MaxTagLength uint32 `protobuf:"varint,5,opt,name=max_tag_length,json=maxTagLength,proto3" json:"max_tag_length,omitempty"`
	// Optional. Controls Stackdriver logging behavior.
	Logging       *MeshConfig_ExtensionProvider_StackdriverProvider_Logging `protobuf:"bytes,6,opt,name=logging,proto3" json:"logging,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_StackdriverProvider) Reset() {
	*x = MeshConfig_ExtensionProvider_StackdriverProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_StackdriverProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_StackdriverProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_StackdriverProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_StackdriverProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_StackdriverProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 7}
}

// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
func (x *MeshConfig_ExtensionProvider_StackdriverProvider) GetDebug() bool {
	if x != nil {
		return x.Debug
	}
	return false
}

// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
func (x *MeshConfig_ExtensionProvider_StackdriverProvider) GetMaxNumberOfAttributes() *wrappers.Int64Value {
	if x != nil {
		return x.MaxNumberOfAttributes
	}
	return nil
}

// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
func (x *MeshConfig_ExtensionProvider_StackdriverProvider) GetMaxNumberOfAnnotations() *wrappers.Int64Value {
	if x != nil {
		return x.MaxNumberOfAnnotations
	}
	return nil
}

// Deprecated: Marked as deprecated in mesh/v1alpha1/config.proto.
func (x *MeshConfig_ExtensionProvider_StackdriverProvider) GetMaxNumberOfMessageEvents() *wrappers.Int64Value {
	if x != nil {
		return x.MaxNumberOfMessageEvents
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_StackdriverProvider) GetMaxTagLength() uint32 {
	if x != nil {
		return x.MaxTagLength
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_StackdriverProvider) GetLogging() *MeshConfig_ExtensionProvider_StackdriverProvider_Logging {
	if x != nil {
		return x.Logging
	}
	return nil
}

// Defines configuration for an OpenCensus tracer writing to an OpenCensus backend.
//
// WARNING: OpenCensusAgentTracingProviders should be used with extreme care. Configuration of
// OpenCensus providers CANNOT be changed during the course of proxy's lifetime due to a limitation
// in the implementation of OpenCensus driver in Envoy. This means only a single provider configuration
// may be used for OpenCensus at any given time for a proxy or group of proxies AND that any change to the provider
// configuration MUST be accompanied by a restart of all proxies that will use that configuration.
//
// NOTE: Stackdriver tracing uses OpenCensus configuration under the hood and, as a result, cannot be used
// alongside OpenCensus provider configuration.
type MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Specifies the service for the OpenCensusAgent.
	// The format is `[<Namespace>/]<Hostname>`. The specification of `<Namespace>` is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The `<Hostname>` is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "ocagent.default.svc.cluster.local" or "bar/ocagent.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Specifies the set of context propagation headers used for distributed
	// tracing. Default is `["W3C_TRACE_CONTEXT"]`. If multiple values are specified,
	// the proxy will attempt to read each header for each request and will
	// write all headers.
	Context []MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext `protobuf:"varint,3,rep,packed,name=context,proto3,enum=istio.mesh.v1alpha1.MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext" json:"context,omitempty"`
	// Optional. Controls the overall path length allowed in a reported span.
	// NOTE: currently only controls max length of the path tag.
	MaxTagLength  uint32 `protobuf:"varint,4,opt,name=max_tag_length,json=maxTagLength,proto3" json:"max_tag_length,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) Reset() {
	*x = MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 8}
}

func (x *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) GetContext() []MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext {
	if x != nil {
		return x.Context
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider) GetMaxTagLength() uint32 {
	if x != nil {
		return x.MaxTagLength
	}
	return 0
}

type MeshConfig_ExtensionProvider_PrometheusMetricsProvider struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_PrometheusMetricsProvider) Reset() {
	*x = MeshConfig_ExtensionProvider_PrometheusMetricsProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_PrometheusMetricsProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_PrometheusMetricsProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_PrometheusMetricsProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_PrometheusMetricsProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_PrometheusMetricsProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 9}
}

// Defines configuration for Envoy-based access logging that writes to
// local files (and/or standard streams).
type MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Path to a local file to write the access log entries.
	// This may be used to write to streams, via `/dev/stderr` and `/dev/stdout`
	// If unspecified, defaults to `/dev/stdout`.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Optional. Allows overriding of the default access log format.
	LogFormat *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat `protobuf:"bytes,2,opt,name=log_format,json=logFormat,proto3" json:"log_format,omitempty"`
	// Optional. If set to true, when command operators are evaluated to null,
	// For text format, the output of the empty operator is changed from "-" to an empty string.
	// For json format, the keys with null values are omitted in the output structure.
	OmitEmptyValues bool `protobuf:"varint,3,opt,name=omit_empty_values,json=omitEmptyValues,proto3" json:"omit_empty_values,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider) Reset() {
	*x = MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 10}
}

func (x *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider) GetLogFormat() *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat {
	if x != nil {
		return x.LogFormat
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider) GetOmitEmptyValues() bool {
	if x != nil {
		return x.OmitEmptyValues
	}
	return false
}

// Defines configuration for an Envoy [Access Logging Service](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/access_loggers/grpc/v3/als.proto#grpc-access-log-service-als)
// integration for HTTP traffic.
type MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Specifies the service that implements the Envoy ALS gRPC authorization service.
	// The format is `[<Namespace>/]<Hostname>`. The specification of `<Namespace>` is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The `<Hostname>` is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "envoy-als.foo.svc.cluster.local" or "bar/envoy-als.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Optional. The friendly name of the access log.
	// Defaults:
	// -  "http_envoy_accesslog"
	// -  "listener_envoy_accesslog"
	LogName string `protobuf:"bytes,3,opt,name=log_name,json=logName,proto3" json:"log_name,omitempty"`
	// Optional. Additional filter state objects to log.
	FilterStateObjectsToLog []string `protobuf:"bytes,4,rep,name=filter_state_objects_to_log,json=filterStateObjectsToLog,proto3" json:"filter_state_objects_to_log,omitempty"`
	// Optional. Additional request headers to log.
	AdditionalRequestHeadersToLog []string `protobuf:"bytes,5,rep,name=additional_request_headers_to_log,json=additionalRequestHeadersToLog,proto3" json:"additional_request_headers_to_log,omitempty"`
	// Optional. Additional response headers to log.
	AdditionalResponseHeadersToLog []string `protobuf:"bytes,6,rep,name=additional_response_headers_to_log,json=additionalResponseHeadersToLog,proto3" json:"additional_response_headers_to_log,omitempty"`
	// Optional. Additional response trailers to log.
	AdditionalResponseTrailersToLog []string `protobuf:"bytes,7,rep,name=additional_response_trailers_to_log,json=additionalResponseTrailersToLog,proto3" json:"additional_response_trailers_to_log,omitempty"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider) Reset() {
	*x = MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 11}
}

func (x *MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider) GetLogName() string {
	if x != nil {
		return x.LogName
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider) GetFilterStateObjectsToLog() []string {
	if x != nil {
		return x.FilterStateObjectsToLog
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider) GetAdditionalRequestHeadersToLog() []string {
	if x != nil {
		return x.AdditionalRequestHeadersToLog
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider) GetAdditionalResponseHeadersToLog() []string {
	if x != nil {
		return x.AdditionalResponseHeadersToLog
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider) GetAdditionalResponseTrailersToLog() []string {
	if x != nil {
		return x.AdditionalResponseTrailersToLog
	}
	return nil
}

// Defines configuration for an Envoy [Access Logging Service](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/access_loggers/grpc/v3/als.proto#grpc-access-log-service-als)
// integration for TCP traffic.
type MeshConfig_ExtensionProvider_EnvoyTcpGrpcV3LogProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Specifies the service that implements the Envoy ALS gRPC authorization service.
	// The format is `[<Namespace>/]<Hostname>`. The specification of `<Namespace>` is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The `<Hostname>` is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "envoy-als.foo.svc.cluster.local" or "bar/envoy-als.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Optional. The friendly name of the access log.
	// Defaults:
	// - "tcp_envoy_accesslog"
	// - "listener_envoy_accesslog"
	LogName string `protobuf:"bytes,3,opt,name=log_name,json=logName,proto3" json:"log_name,omitempty"`
	// Optional. Additional filter state objects to log.
	FilterStateObjectsToLog []string `protobuf:"bytes,4,rep,name=filter_state_objects_to_log,json=filterStateObjectsToLog,proto3" json:"filter_state_objects_to_log,omitempty"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_EnvoyTcpGrpcV3LogProvider) Reset() {
	*x = MeshConfig_ExtensionProvider_EnvoyTcpGrpcV3LogProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_EnvoyTcpGrpcV3LogProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_EnvoyTcpGrpcV3LogProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_EnvoyTcpGrpcV3LogProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_EnvoyTcpGrpcV3LogProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_EnvoyTcpGrpcV3LogProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 12}
}

func (x *MeshConfig_ExtensionProvider_EnvoyTcpGrpcV3LogProvider) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_EnvoyTcpGrpcV3LogProvider) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_EnvoyTcpGrpcV3LogProvider) GetLogName() string {
	if x != nil {
		return x.LogName
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_EnvoyTcpGrpcV3LogProvider) GetFilterStateObjectsToLog() []string {
	if x != nil {
		return x.FilterStateObjectsToLog
	}
	return nil
}

// Defines configuration for an Envoy [OpenTelemetry (gRPC) Access Log](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/access_loggers/open_telemetry/v3/logs_service.proto)
type MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Specifies the service that implements the Envoy ALS gRPC authorization service.
	// The format is `[<Namespace>/]<Hostname>`. The specification of `<Namespace>` is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The `<Hostname>` is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "envoy-als.foo.svc.cluster.local" or "bar/envoy-als.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Optional. The friendly name of the access log.
	// Defaults:
	// - "otel_envoy_accesslog"
	LogName string `protobuf:"bytes,3,opt,name=log_name,json=logName,proto3" json:"log_name,omitempty"`
	// Optional. Format for the proxy access log
	// Empty value results in proxy's default access log format, following Envoy access logging formatting.
	LogFormat     *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider_LogFormat `protobuf:"bytes,4,opt,name=log_format,json=logFormat,proto3" json:"log_format,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider) Reset() {
	*x = MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 13}
}

func (x *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider) GetLogName() string {
	if x != nil {
		return x.LogName
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider) GetLogFormat() *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider_LogFormat {
	if x != nil {
		return x.LogFormat
	}
	return nil
}

// Defines configuration for an OpenTelemetry tracing backend. Istio 1.16.1 or higher is needed.
type MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Specifies the OpenTelemetry endpoint that will receive OTLP traces.
	// The format is `[<Namespace>/]<Hostname>`. The specification of `<Namespace>` is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The `<Hostname>` is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "otlp.default.svc.cluster.local" or "bar/otlp.example.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Optional. Controls the overall path length allowed in a reported span.
	// NOTE: currently only controls max length of the path tag.
	MaxTagLength uint32 `protobuf:"varint,3,opt,name=max_tag_length,json=maxTagLength,proto3" json:"max_tag_length,omitempty"`
	// Optional. Specifies the configuration for exporting OTLP traces via HTTP.
	// When empty, traces will be exported via gRPC.
	//
	// The following example shows how to configure the OpenTelemetry ExtensionProvider to export via HTTP:
	//
	// 1. Add/change the OpenTelemetry extension provider in `MeshConfig`
	// ```yaml
	//   - name: otel-tracing
	//     opentelemetry:
	//     port: 443
	//     service: my.olly-backend.com
	//     http:
	//     path: "/api/otlp/traces"
	//     timeout: 10s
	//     headers:
	//   - name: "my-custom-header"
	//     value: "some value"
	//
	// ```
	//
	// 2. Deploy a `ServiceEntry` for the observability back-end
	// ```yaml
	// apiVersion: networking.istio.io/v1alpha3
	// kind: ServiceEntry
	// metadata:
	//
	//	name: my-olly-backend
	//
	// spec:
	//
	//	hosts:
	//	- my.olly-backend.com
	//	ports:
	//	- number: 443
	//	  name: https-port
	//	  protocol: HTTPS
	//	resolution: DNS
	//	location: MESH_EXTERNAL
	//
	// ---
	// apiVersion: networking.istio.io/v1alpha3
	// kind: DestinationRule
	// metadata:
	//
	//	name: my-olly-backend
	//
	// spec:
	//
	//	host: my.olly-backend.com
	//	trafficPolicy:
	//	  portLevelSettings:
	//	  - port:
	//	      number: 443
	//	    tls:
	//	      mode: SIMPLE
	//
	// ```
	Http *MeshConfig_ExtensionProvider_HttpService `protobuf:"bytes,4,opt,name=http,proto3" json:"http,omitempty"`
	// Optional. Specifies the configuration for exporting OTLP traces via GRPC.
	// When empty, traces will check whether HTTP is set.
	// If not, traces will use default GRPC configurations.
	//
	// The following example shows how to configure the OpenTelemetry ExtensionProvider to export via GRPC:
	//
	// 1. Add/change the OpenTelemetry extension provider in `MeshConfig`
	// ```yaml
	//   - name: opentelemetry
	//     opentelemetry:
	//     port: 8090
	//     service: tracing.example.com
	//     grpc:
	//     timeout: 10s
	//     initialMetadata:
	//   - name: "Authentication"
	//     value: "token-xxxxx"
	//
	// ```
	//
	// 2. Deploy a `ServiceEntry` for the observability back-end
	// ```yaml
	// apiVersion: networking.istio.io/v1alpha3
	// kind: ServiceEntry
	// metadata:
	//
	//	name: tracing-grpc
	//
	// spec:
	//
	//	hosts:
	//	- tracing.example.com
	//	ports:
	//	- number: 8090
	//	  name: grpc-port
	//	  protocol: GRPC
	//	resolution: DNS
	//	location: MESH_EXTERNAL
	//
	// ```
	Grpc *MeshConfig_ExtensionProvider_GrpcService `protobuf:"bytes,7,opt,name=grpc,proto3" json:"grpc,omitempty"`
	// Optional. Specifies [Resource Detectors](https://opentelemetry.io/docs/specs/otel/resource/sdk/)
	// to be used by the OpenTelemetry Tracer. When multiple resources are provided, they are merged
	// according to the OpenTelemetry [Resource specification](https://opentelemetry.io/docs/specs/otel/resource/sdk/#merge).
	//
	// The following example shows how to configure the Environment Resource Detector, that will
	// read the attributes from the environment variable `OTEL_RESOURCE_ATTRIBUTES`:
	//
	// ```yaml
	//   - name: otel-tracing
	//     opentelemetry:
	//     port: 443
	//     service: my.olly-backend.com
	//     resourceDetectors:
	//     environment: {}
	//
	// ```
	ResourceDetectors *MeshConfig_ExtensionProvider_ResourceDetectors `protobuf:"bytes,5,opt,name=resource_detectors,json=resourceDetectors,proto3" json:"resource_detectors,omitempty"`
	// Optional. Configure a [Sampler](https://opentelemetry.io/docs/specs/otel/trace/sdk/#sampler)
	// to be used by the OpenTelemetry Tracer.
	//
	// Types that are valid to be assigned to Sampling:
	//
	//	*MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_
	Sampling      isMeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_Sampling `protobuf_oneof:"sampling"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider) Reset() {
	*x = MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 14}
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider) GetMaxTagLength() uint32 {
	if x != nil {
		return x.MaxTagLength
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider) GetHttp() *MeshConfig_ExtensionProvider_HttpService {
	if x != nil {
		return x.Http
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider) GetGrpc() *MeshConfig_ExtensionProvider_GrpcService {
	if x != nil {
		return x.Grpc
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider) GetResourceDetectors() *MeshConfig_ExtensionProvider_ResourceDetectors {
	if x != nil {
		return x.ResourceDetectors
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider) GetSampling() isMeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_Sampling {
	if x != nil {
		return x.Sampling
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider) GetDynatraceSampler() *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler {
	if x != nil {
		if x, ok := x.Sampling.(*MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_); ok {
			return x.DynatraceSampler
		}
	}
	return nil
}

type isMeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_Sampling interface {
	isMeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_Sampling()
}

type MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_ struct {
	// The Dynatrace adaptive traffic management (ATM) sampler.
	//
	// Example configuration:
	//
	// ```yaml
	//   - name: otel-tracing
	//     opentelemetry:
	//     port: 443
	//     service: "{your-environment-id}.live.dynatrace.com"
	//     http:
	//     path: "/api/v2/otlp/v1/traces"
	//     timeout: 10s
	//     headers:
	//   - name: "Authorization"
	//     value: "Api-Token dt0c01."
	//     resourceDetectors:
	//     dynatrace: {}
	//     dynatraceSampler:
	//     tenant: "{your-environment-id}"
	//     clusterId: 1234
	DynatraceSampler *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler `protobuf:"bytes,6,opt,name=dynatrace_sampler,json=dynatraceSampler,proto3,oneof"`
}

func (*MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_) isMeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_Sampling() {
}

// Defines configuration for an Gateway SDS provider.
type MeshConfig_ExtensionProvider_SDSProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Specifies the name of the provider. This should be used to configure the Gateway SDS.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// REQUIRED. Specifies the service that implements the  SDS service.
	// The format is `[<Namespace>/]<Hostname>`. The specification of `<Namespace>` is required only when it is insufficient
	// to unambiguously resolve a service in the service registry. The `<Hostname>` is a fully qualified host name of a
	// service defined by the Kubernetes service or ServiceEntry.
	//
	// Example: "gateway-sds.foo.svc.cluster.local" or "bar/gateway-sds.example.com".
	Service string `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port          uint32 `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_SDSProvider) Reset() {
	*x = MeshConfig_ExtensionProvider_SDSProvider{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_SDSProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_SDSProvider) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_SDSProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_SDSProvider.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_SDSProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 15}
}

func (x *MeshConfig_ExtensionProvider_SDSProvider) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_SDSProvider) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_SDSProvider) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

// Defines configuration for an HTTP service that can be used by an Extension Provider.
// that does communication via HTTP.
type MeshConfig_ExtensionProvider_HttpService struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Specifies the path on the service.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Optional. Specifies the timeout for the HTTP request.
	// If not specified, the default is 3s.
	Timeout *duration.Duration `protobuf:"bytes,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Optional. Allows specifying custom HTTP headers that will be added
	// to each HTTP request sent.
	Headers       []*MeshConfig_ExtensionProvider_HttpHeader `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_HttpService) Reset() {
	*x = MeshConfig_ExtensionProvider_HttpService{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_HttpService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_HttpService) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_HttpService) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_HttpService.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_HttpService) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 16}
}

func (x *MeshConfig_ExtensionProvider_HttpService) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_HttpService) GetTimeout() *duration.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_HttpService) GetHeaders() []*MeshConfig_ExtensionProvider_HttpHeader {
	if x != nil {
		return x.Headers
	}
	return nil
}

type MeshConfig_ExtensionProvider_HttpHeader struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. The HTTP header name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The HTTP header value.
	//
	// Types that are valid to be assigned to HeaderValue:
	//
	//	*MeshConfig_ExtensionProvider_HttpHeader_Value
	//	*MeshConfig_ExtensionProvider_HttpHeader_EnvName
	HeaderValue   isMeshConfig_ExtensionProvider_HttpHeader_HeaderValue `protobuf_oneof:"header_value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_HttpHeader) Reset() {
	*x = MeshConfig_ExtensionProvider_HttpHeader{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_HttpHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_HttpHeader) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_HttpHeader) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_HttpHeader.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_HttpHeader) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 17}
}

func (x *MeshConfig_ExtensionProvider_HttpHeader) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_HttpHeader) GetHeaderValue() isMeshConfig_ExtensionProvider_HttpHeader_HeaderValue {
	if x != nil {
		return x.HeaderValue
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_HttpHeader) GetValue() string {
	if x != nil {
		if x, ok := x.HeaderValue.(*MeshConfig_ExtensionProvider_HttpHeader_Value); ok {
			return x.Value
		}
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_HttpHeader) GetEnvName() string {
	if x != nil {
		if x, ok := x.HeaderValue.(*MeshConfig_ExtensionProvider_HttpHeader_EnvName); ok {
			return x.EnvName
		}
	}
	return ""
}

type isMeshConfig_ExtensionProvider_HttpHeader_HeaderValue interface {
	isMeshConfig_ExtensionProvider_HttpHeader_HeaderValue()
}

type MeshConfig_ExtensionProvider_HttpHeader_Value struct {
	// The HTTP header value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_HttpHeader_EnvName struct {
	// The HTTP header value from the environment variable.
	//
	// Warning:
	// - The environment variable must be set in the istiod pod spec.
	// - This is not a end-to-end secure.
	EnvName string `protobuf:"bytes,3,opt,name=env_name,json=envName,proto3,oneof"`
}

func (*MeshConfig_ExtensionProvider_HttpHeader_Value) isMeshConfig_ExtensionProvider_HttpHeader_HeaderValue() {
}

func (*MeshConfig_ExtensionProvider_HttpHeader_EnvName) isMeshConfig_ExtensionProvider_HttpHeader_HeaderValue() {
}

type MeshConfig_ExtensionProvider_ResourceDetectors struct {
	state         protoimpl.MessageState                                                      `protogen:"open.v1"`
	Environment   *MeshConfig_ExtensionProvider_ResourceDetectors_EnvironmentResourceDetector `protobuf:"bytes,1,opt,name=environment,proto3" json:"environment,omitempty"`
	Dynatrace     *MeshConfig_ExtensionProvider_ResourceDetectors_DynatraceResourceDetector   `protobuf:"bytes,2,opt,name=dynatrace,proto3" json:"dynatrace,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_ResourceDetectors) Reset() {
	*x = MeshConfig_ExtensionProvider_ResourceDetectors{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_ResourceDetectors) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_ResourceDetectors) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_ResourceDetectors) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_ResourceDetectors.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_ResourceDetectors) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 18}
}

func (x *MeshConfig_ExtensionProvider_ResourceDetectors) GetEnvironment() *MeshConfig_ExtensionProvider_ResourceDetectors_EnvironmentResourceDetector {
	if x != nil {
		return x.Environment
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_ResourceDetectors) GetDynatrace() *MeshConfig_ExtensionProvider_ResourceDetectors_DynatraceResourceDetector {
	if x != nil {
		return x.Dynatrace
	}
	return nil
}

// Defines configuration for an GRPC service that can be used by an Extension Provider.
// that does communication via GRPC.
type MeshConfig_ExtensionProvider_GrpcService struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Optional. Specifies the timeout for the GRPC request.
	Timeout *duration.Duration `protobuf:"bytes,1,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Optional. Additional metadata to include in streams initiated to the GrpcService. This can be used for
	// scenarios in which additional ad hoc authorization headers (e.g. "x-foo-bar: baz-key") are to
	// be injected.
	InitialMetadata []*MeshConfig_ExtensionProvider_HttpHeader `protobuf:"bytes,2,rep,name=initial_metadata,json=initialMetadata,proto3" json:"initial_metadata,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_GrpcService) Reset() {
	*x = MeshConfig_ExtensionProvider_GrpcService{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_GrpcService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_GrpcService) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_GrpcService) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_GrpcService.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_GrpcService) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 19}
}

func (x *MeshConfig_ExtensionProvider_GrpcService) GetTimeout() *duration.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_GrpcService) GetInitialMetadata() []*MeshConfig_ExtensionProvider_HttpHeader {
	if x != nil {
		return x.InitialMetadata
	}
	return nil
}

type MeshConfig_ExtensionProvider_StackdriverProvider_Logging struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Collection of tag names and tag expressions to include in the log
	// entry. Conflicts are resolved by the tag name by overriding previously
	// supplied values.
	//
	// Example:
	//
	//	labels:
	//	  path: request.url_path
	//	  foo: request.headers['x-foo']
	Labels        map[string]string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_StackdriverProvider_Logging) Reset() {
	*x = MeshConfig_ExtensionProvider_StackdriverProvider_Logging{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_StackdriverProvider_Logging) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_StackdriverProvider_Logging) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_StackdriverProvider_Logging) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_StackdriverProvider_Logging.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_StackdriverProvider_Logging) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 7, 0}
}

func (x *MeshConfig_ExtensionProvider_StackdriverProvider_Logging) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to LogFormat:
	//
	//	*MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_Text
	//	*MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_Labels
	LogFormat     isMeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_LogFormat `protobuf_oneof:"log_format"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat) Reset() {
	*x = MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 10, 0}
}

func (x *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat) GetLogFormat() isMeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_LogFormat {
	if x != nil {
		return x.LogFormat
	}
	return nil
}

func (x *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat) GetText() string {
	if x != nil {
		if x, ok := x.LogFormat.(*MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_Text); ok {
			return x.Text
		}
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat) GetLabels() *_struct.Struct {
	if x != nil {
		if x, ok := x.LogFormat.(*MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_Labels); ok {
			return x.Labels
		}
	}
	return nil
}

type isMeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_LogFormat interface {
	isMeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_LogFormat()
}

type MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_Text struct {
	// Textual format for the envoy access logs. Envoy [command operators](https://www.envoyproxy.io/docs/envoy/latest/configuration/observability/access_log/usage#command-operators) may be
	// used in the format. The [format string documentation](https://www.envoyproxy.io/docs/envoy/latest/configuration/observability/access_log/usage#config-access-log-format-strings)
	// provides more information.
	//
	// NOTE: Istio will insert a newline ('\n') on all formats (if missing).
	//
	// Example: `text: "%LOCAL_REPLY_BODY%:%RESPONSE_CODE%:path=%REQ(:path)%"`
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_Labels struct {
	// JSON structured format for the envoy access logs. Envoy [command operators](https://www.envoyproxy.io/docs/envoy/latest/configuration/observability/access_log/usage#command-operators)
	// can be used as values for fields within the Struct. Values are rendered
	// as strings, numbers, or boolean values, as appropriate
	// (see: [format dictionaries](https://www.envoyproxy.io/docs/envoy/latest/configuration/observability/access_log/usage#config-access-log-format-dictionaries)). Nested JSON is
	// supported for some command operators (e.g. `FILTER_STATE` or `DYNAMIC_METADATA`).
	// Use `labels: {}` for default envoy JSON log format.
	//
	// Example:
	// ```
	// labels:
	//
	//	status: "%RESPONSE_CODE%"
	//	message: "%LOCAL_REPLY_BODY%"
	//
	// ```
	Labels *_struct.Struct `protobuf:"bytes,2,opt,name=labels,proto3,oneof"`
}

func (*MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_Text) isMeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_LogFormat() {
}

func (*MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_Labels) isMeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_LogFormat() {
}

type MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider_LogFormat struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Textual format for the envoy access logs. Envoy [command operators](https://www.envoyproxy.io/docs/envoy/latest/configuration/observability/access_log/usage#command-operators) may be
	// used in the format. The [format string documentation](https://www.envoyproxy.io/docs/envoy/latest/configuration/observability/access_log/usage#config-access-log-format-strings)
	// provides more information.
	// Alias to `body` field in [Open Telemetry](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/access_loggers/open_telemetry/v3/logs_service.proto)
	// Example: `text: "%LOCAL_REPLY_BODY%:%RESPONSE_CODE%:path=%REQ(:path)%"`
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Optional. Additional attributes that describe the specific event occurrence.
	// Structured format for the envoy access logs. Envoy [command operators](https://www.envoyproxy.io/docs/envoy/latest/configuration/observability/access_log/usage#command-operators)
	// can be used as values for fields within the Struct. Values are rendered
	// as strings, numbers, or boolean values, as appropriate
	// (see: [format dictionaries](https://www.envoyproxy.io/docs/envoy/latest/configuration/observability/access_log/usage#config-access-log-format-dictionaries)). Nested JSON is
	// supported for some command operators (e.g. FILTER_STATE or DYNAMIC_METADATA).
	// Alias to `attributes` field in [Open Telemetry](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/access_loggers/open_telemetry/v3/logs_service.proto)
	//
	// Example:
	// ```
	// labels:
	//
	//	status: "%RESPONSE_CODE%"
	//	message: "%LOCAL_REPLY_BODY%"
	//
	// ```
	Labels        *_struct.Struct `protobuf:"bytes,2,opt,name=labels,proto3" json:"labels,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider_LogFormat) Reset() {
	*x = MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider_LogFormat{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider_LogFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider_LogFormat) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider_LogFormat) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider_LogFormat.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider_LogFormat) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 13, 0}
}

func (x *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider_LogFormat) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider_LogFormat) GetLabels() *_struct.Struct {
	if x != nil {
		return x.Labels
	}
	return nil
}

type MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. The Dynatrace customer's tenant identifier.
	//
	// The value can be obtained from the Istio deployment page in Dynatrace.
	Tenant string `protobuf:"bytes,1,opt,name=tenant,proto3" json:"tenant,omitempty"`
	// REQUIRED. The identifier of the cluster in the Dynatrace platform.
	// The cluster here is Dynatrace-specific concept and not related to the cluster concept in Istio/Envoy.
	//
	// The value can be obtained from the Istio deployment page in Dynatrace.
	ClusterId int32 `protobuf:"varint,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Optional. Number of sampled spans per minute to be used
	// when the adaptive value cannot be obtained from the Dynatrace API.
	//
	// A default value of `1000` is used when:
	//
	// - `rootSpansPerMinute` is unset
	// - `rootSpansPerMinute` is set to 0
	RootSpansPerMinute uint32 `protobuf:"varint,3,opt,name=root_spans_per_minute,json=rootSpansPerMinute,proto3" json:"root_spans_per_minute,omitempty"`
	// Optional. Dynatrace HTTP API to obtain sampling configuration.
	//
	// When not provided, the Dynatrace Sampler will re-use the configuration from the OpenTelemetryTracingProvider HTTP Exporter
	// (`service`, `port` and `http`), including the access token.
	HttpService   *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_DynatraceApi `protobuf:"bytes,4,opt,name=http_service,json=httpService,proto3" json:"http_service,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler) Reset() {
	*x = MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 14, 0}
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler) GetTenant() string {
	if x != nil {
		return x.Tenant
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler) GetClusterId() int32 {
	if x != nil {
		return x.ClusterId
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler) GetRootSpansPerMinute() uint32 {
	if x != nil {
		return x.RootSpansPerMinute
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler) GetHttpService() *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_DynatraceApi {
	if x != nil {
		return x.HttpService
	}
	return nil
}

type MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_DynatraceApi struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Specifies the Dynatrace environment to obtain the sampling configuration.
	// The format is `<Hostname>`, where `<Hostname>` is the fully qualified Dynatrace environment
	// host name defined in the ServiceEntry.
	//
	// Example: "{your-environment-id}.live.dynatrace.com".
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// REQUIRED. Specifies the port of the service.
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// REQUIRED. Specifies sampling configuration URI.
	Http          *MeshConfig_ExtensionProvider_HttpService `protobuf:"bytes,3,opt,name=http,proto3" json:"http,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_DynatraceApi) Reset() {
	*x = MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_DynatraceApi{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_DynatraceApi) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_DynatraceApi) ProtoMessage() {
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_DynatraceApi) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_DynatraceApi.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_DynatraceApi) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 14, 0, 0}
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_DynatraceApi) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_DynatraceApi) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_DynatraceApi) GetHttp() *MeshConfig_ExtensionProvider_HttpService {
	if x != nil {
		return x.Http
	}
	return nil
}

// OpenTelemetry Environment Resource Detector.
// The resource detector reads attributes from the environment variable `OTEL_RESOURCE_ATTRIBUTES`
// and adds them to the OpenTelemetry resource.
//
// See: [Resource specification](https://opentelemetry.io/docs/specs/otel/resource/sdk/#specifying-resource-information-via-an-environment-variable)
type MeshConfig_ExtensionProvider_ResourceDetectors_EnvironmentResourceDetector struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_ResourceDetectors_EnvironmentResourceDetector) Reset() {
	*x = MeshConfig_ExtensionProvider_ResourceDetectors_EnvironmentResourceDetector{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_ResourceDetectors_EnvironmentResourceDetector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_ResourceDetectors_EnvironmentResourceDetector) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_ResourceDetectors_EnvironmentResourceDetector) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_ResourceDetectors_EnvironmentResourceDetector.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_ResourceDetectors_EnvironmentResourceDetector) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 18, 0}
}

// Dynatrace Resource Detector.
// The resource detector reads from the Dynatrace enrichment files
// and adds host/process related attributes to the OpenTelemetry resource.
//
// See: [Enrich ingested data with Dynatrace-specific dimensions](https://docs.dynatrace.com/docs/shortlink/enrichment-files)
type MeshConfig_ExtensionProvider_ResourceDetectors_DynatraceResourceDetector struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MeshConfig_ExtensionProvider_ResourceDetectors_DynatraceResourceDetector) Reset() {
	*x = MeshConfig_ExtensionProvider_ResourceDetectors_DynatraceResourceDetector{}
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshConfig_ExtensionProvider_ResourceDetectors_DynatraceResourceDetector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig_ExtensionProvider_ResourceDetectors_DynatraceResourceDetector) ProtoMessage() {}

func (x *MeshConfig_ExtensionProvider_ResourceDetectors_DynatraceResourceDetector) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_config_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig_ExtensionProvider_ResourceDetectors_DynatraceResourceDetector.ProtoReflect.Descriptor instead.
func (*MeshConfig_ExtensionProvider_ResourceDetectors_DynatraceResourceDetector) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_config_proto_rawDescGZIP(), []int{0, 6, 18, 1}
}

var File_mesh_v1alpha1_config_proto protoreflect.FileDescriptor

const file_mesh_v1alpha1_config_proto_rawDesc = "" +
	"\n" +
	"\x1amesh/v1alpha1/config.proto\x12\x13istio.mesh.v1alpha1\x1a\x1egoogle/protobuf/duration.proto\x1a\x1cgoogle/protobuf/struct.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a\x19mesh/v1alpha1/proxy.proto\x1a*networking/v1alpha3/destination_rule.proto\x1a)networking/v1alpha3/virtual_service.proto\"\xa5m\n" +
	"\n" +
	"MeshConfig\x12*\n" +
	"\x11proxy_listen_port\x18\x04 \x01(\x05R\x0fproxyListenPort\x129\n" +
	"\x19proxy_inbound_listen_port\x18A \x01(\x05R\x16proxyInboundListenPort\x12&\n" +
	"\x0fproxy_http_port\x18\x05 \x01(\x05R\rproxyHttpPort\x12B\n" +
	"\x0fconnect_timeout\x18\x06 \x01(\v2\x19.google.protobuf.DurationR\x0econnectTimeout\x12W\n" +
	"\x1aprotocol_detection_timeout\x18* \x01(\v2\x19.google.protobuf.DurationR\x18protocolDetectionTimeout\x12o\n" +
	"\rtcp_keepalive\x18\x1c \x01(\v2J.istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings.TcpKeepaliveR\ftcpKeepalive\x12#\n" +
	"\ringress_class\x18\a \x01(\tR\fingressClass\x12'\n" +
	"\x0fingress_service\x18\b \x01(\tR\x0eingressService\x12m\n" +
	"\x17ingress_controller_mode\x18\t \x01(\x0e25.istio.mesh.v1alpha1.MeshConfig.IngressControllerModeR\x15ingressControllerMode\x12)\n" +
	"\x10ingress_selector\x184 \x01(\tR\x0fingressSelector\x12%\n" +
	"\x0eenable_tracing\x18\f \x01(\bR\renableTracing\x12&\n" +
	"\x0faccess_log_file\x18\r \x01(\tR\raccessLogFile\x12*\n" +
	"\x11access_log_format\x18\x18 \x01(\tR\x0faccessLogFormat\x12a\n" +
	"\x13access_log_encoding\x18\x1b \x01(\x0e21.istio.mesh.v1alpha1.MeshConfig.AccessLogEncodingR\x11accessLogEncoding\x12D\n" +
	"\x1fenable_envoy_access_log_service\x18( \x01(\bR\x1benableEnvoyAccessLogService\x12;\n" +
	"\x1adisable_envoy_listener_log\x188 \x01(\bR\x17disableEnvoyListenerLog\x12G\n" +
	"\x0edefault_config\x18\x0e \x01(\v2 .istio.mesh.v1alpha1.ProxyConfigR\rdefaultConfig\x12m\n" +
	"\x17outbound_traffic_policy\x18\x11 \x01(\v25.istio.mesh.v1alpha1.MeshConfig.OutboundTrafficPolicyR\x15outboundTrafficPolicy\x12j\n" +
	"\x16inbound_traffic_policy\x18B \x01(\v24.istio.mesh.v1alpha1.MeshConfig.InboundTrafficPolicyR\x14inboundTrafficPolicy\x12H\n" +
	"\x0econfig_sources\x18\x16 \x03(\v2!.istio.mesh.v1alpha1.ConfigSourceR\rconfigSources\x12D\n" +
	"\x10enable_auto_mtls\x18+ \x01(\v2\x1a.google.protobuf.BoolValueR\x0eenableAutoMtls\x12!\n" +
	"\ftrust_domain\x18\x1a \x01(\tR\vtrustDomain\x120\n" +
	"\x14trust_domain_aliases\x18. \x03(\tR\x12trustDomainAliases\x12X\n" +
	"\x0fca_certificates\x18: \x03(\v2/.istio.mesh.v1alpha1.MeshConfig.CertificateDataR\x0ecaCertificates\x129\n" +
	"\x19default_service_export_to\x18\x1f \x03(\tR\x16defaultServiceExportTo\x12H\n" +
	"!default_virtual_service_export_to\x18  \x03(\tR\x1ddefaultVirtualServiceExportTo\x12J\n" +
	"\"default_destination_rule_export_to\x18! \x03(\tR\x1edefaultDestinationRuleExportTo\x12%\n" +
	"\x0eroot_namespace\x18\" \x01(\tR\rrootNamespace\x12f\n" +
	"\x13locality_lb_setting\x18# \x01(\v26.istio.networking.v1alpha3.LocalityLoadBalancerSettingR\x11localityLbSetting\x12C\n" +
	"\x10dns_refresh_rate\x18$ \x01(\v2\x19.google.protobuf.DurationR\x0ednsRefreshRate\x12[\n" +
	"\x11h2_upgrade_policy\x18) \x01(\x0e2/.istio.mesh.v1alpha1.MeshConfig.H2UpgradePolicyR\x0fh2UpgradePolicy\x129\n" +
	"\x19inbound_cluster_stat_name\x18, \x01(\tR\x16inboundClusterStatName\x12;\n" +
	"\x1aoutbound_cluster_stat_name\x18- \x01(\tR\x17outboundClusterStatName\x12H\n" +
	"\fcertificates\x18/ \x03(\v2 .istio.mesh.v1alpha1.CertificateB\x02\x18\x01R\fcertificates\x12Z\n" +
	"\x10service_settings\x182 \x03(\v2/.istio.mesh.v1alpha1.MeshConfig.ServiceSettingsR\x0fserviceSettings\x12g\n" +
	"\x15service_scope_configs\x18C \x03(\v23.istio.mesh.v1alpha1.MeshConfig.ServiceScopeConfigsR\x13serviceScopeConfigs\x12R\n" +
	"\x17enable_prometheus_merge\x183 \x01(\v2\x1a.google.protobuf.BoolValueR\x15enablePrometheusMerge\x12_\n" +
	"\x1cverify_certificate_at_client\x186 \x01(\v2\x1a.google.protobuf.BoolValueB\x02\x18\x01R\x19verifyCertificateAtClient\x122\n" +
	"\x02ca\x187 \x01(\v2\".istio.mesh.v1alpha1.MeshConfig.CAR\x02ca\x12b\n" +
	"\x13extension_providers\x189 \x03(\v21.istio.mesh.v1alpha1.MeshConfig.ExtensionProviderR\x12extensionProviders\x12]\n" +
	"\x11default_providers\x18< \x01(\v20.istio.mesh.v1alpha1.MeshConfig.DefaultProvidersR\x10defaultProviders\x12S\n" +
	"\x13discovery_selectors\x18; \x03(\v2\".istio.mesh.v1alpha1.LabelSelectorR\x12discoverySelectors\x12e\n" +
	"\x12path_normalization\x18= \x01(\v26.istio.mesh.v1alpha1.MeshConfig.ProxyPathNormalizationR\x11pathNormalization\x12_\n" +
	"\x19default_http_retry_policy\x18> \x01(\v2$.istio.networking.v1alpha3.HTTPRetryR\x16defaultHttpRetryPolicy\x12F\n" +
	"\tmesh_mTLS\x18? \x01(\v2).istio.mesh.v1alpha1.MeshConfig.TLSConfigR\bmeshMTLS\x12L\n" +
	"\ftls_defaults\x18@ \x01(\v2).istio.mesh.v1alpha1.MeshConfig.TLSConfigR\vtlsDefaults\x1a\xad\x01\n" +
	"\x15OutboundTrafficPolicy\x12N\n" +
	"\x04mode\x18\x01 \x01(\x0e2:.istio.mesh.v1alpha1.MeshConfig.OutboundTrafficPolicy.ModeR\x04mode\"D\n" +
	"\x04Mode\x12\x11\n" +
	"\rREGISTRY_ONLY\x10\x00\x12\r\n" +
	"\tALLOW_ANY\x10\x01\"\x04\b\x02\x10\x02*\x14VIRTUAL_SERVICE_ONLY\x1a\x8d\x01\n" +
	"\x14InboundTrafficPolicy\x12M\n" +
	"\x04mode\x18\x01 \x01(\x0e29.istio.mesh.v1alpha1.MeshConfig.InboundTrafficPolicy.ModeR\x04mode\"&\n" +
	"\x04Mode\x12\x0f\n" +
	"\vPASSTHROUGH\x10\x00\x12\r\n" +
	"\tLOCALHOST\x10\x01\x1a\xaf\x01\n" +
	"\x0fCertificateData\x12\x12\n" +
	"\x03pem\x18\x01 \x01(\tH\x00R\x03pem\x12,\n" +
	"\x11spiffe_bundle_url\x18\x02 \x01(\tH\x00R\x0fspiffeBundleUrl\x12!\n" +
	"\fcert_signers\x18\x03 \x03(\tR\vcertSigners\x12#\n" +
	"\rtrust_domains\x18\x04 \x03(\tR\ftrustDomainsB\x12\n" +
	"\x10certificate_data\x1a\xae\x01\n" +
	"\x0fServiceSettings\x12T\n" +
	"\bsettings\x18\x01 \x01(\v28.istio.mesh.v1alpha1.MeshConfig.ServiceSettings.SettingsR\bsettings\x12\x14\n" +
	"\x05hosts\x18\x02 \x03(\tR\x05hosts\x1a/\n" +
	"\bSettings\x12#\n" +
	"\rcluster_local\x18\x01 \x01(\bR\fclusterLocal\x1a\xaa\x02\n" +
	"\x13ServiceScopeConfigs\x12Q\n" +
	"\x12namespace_selector\x18\x01 \x01(\v2\".istio.mesh.v1alpha1.LabelSelectorR\x11namespaceSelector\x12O\n" +
	"\x11services_selector\x18\x02 \x01(\v2\".istio.mesh.v1alpha1.LabelSelectorR\x10servicesSelector\x12O\n" +
	"\x05scope\x18\x03 \x01(\x0e29.istio.mesh.v1alpha1.MeshConfig.ServiceScopeConfigs.ScopeR\x05scope\"\x1e\n" +
	"\x05Scope\x12\t\n" +
	"\x05LOCAL\x10\x00\x12\n" +
	"\n" +
	"\x06GLOBAL\x10\x01\x1a\xd4\x01\n" +
	"\x02CA\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\x12O\n" +
	"\ftls_settings\x18\x02 \x01(\v2,.istio.networking.v1alpha3.ClientTLSSettingsR\vtlsSettings\x12B\n" +
	"\x0frequest_timeout\x18\x03 \x01(\v2\x19.google.protobuf.DurationR\x0erequestTimeout\x12\x1f\n" +
	"\vistiod_side\x18\x04 \x01(\bR\n" +
	"istiodSide\x1a\xf0>\n" +
	"\x11ExtensionProvider\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x8b\x01\n" +
	"\x14envoy_ext_authz_http\x18\x02 \x01(\v2X.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationHttpProviderH\x00R\x11envoyExtAuthzHttp\x12\x8b\x01\n" +
	"\x14envoy_ext_authz_grpc\x18\x03 \x01(\v2X.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationGrpcProviderH\x00R\x11envoyExtAuthzGrpc\x12a\n" +
	"\x06zipkin\x18\x04 \x01(\v2G.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.ZipkinTracingProviderH\x00R\x06zipkin\x12n\n" +
	"\tlightstep\x18\x05 \x01(\v2J.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.LightstepTracingProviderB\x02\x18\x01H\x00R\tlightstep\x12d\n" +
	"\adatadog\x18\x06 \x01(\v2H.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.DatadogTracingProviderH\x00R\adatadog\x12i\n" +
	"\vstackdriver\x18\a \x01(\v2E.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.StackdriverProviderH\x00R\vstackdriver\x12v\n" +
	"\n" +
	"opencensus\x18\b \x01(\v2P.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenCensusAgentTracingProviderB\x02\x18\x01H\x00R\n" +
	"opencensus\x12m\n" +
	"\n" +
	"skywalking\x18\t \x01(\v2K.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.SkyWalkingTracingProviderH\x00R\n" +
	"skywalking\x12v\n" +
	"\ropentelemetry\x18\x0f \x01(\v2N.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenTelemetryTracingProviderH\x00R\ropentelemetry\x12m\n" +
	"\n" +
	"prometheus\x18\n" +
	" \x01(\v2K.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.PrometheusMetricsProviderH\x00R\n" +
	"prometheus\x12\x81\x01\n" +
	"\x15envoy_file_access_log\x18\v \x01(\v2L.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyFileAccessLogProviderH\x00R\x12envoyFileAccessLog\x12t\n" +
	"\x0eenvoy_http_als\x18\f \x01(\v2L.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyHttpGrpcV3LogProviderH\x00R\fenvoyHttpAls\x12q\n" +
	"\renvoy_tcp_als\x18\r \x01(\v2K.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyTcpGrpcV3LogProviderH\x00R\venvoyTcpAls\x12w\n" +
	"\x0eenvoy_otel_als\x18\x0e \x01(\v2O.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyOpenTelemetryLogProviderH\x00R\fenvoyOtelAls\x12Q\n" +
	"\x03sds\x18\x10 \x01(\v2=.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.SDSProviderH\x00R\x03sds\x1a\xab\x01\n" +
	"%EnvoyExternalAuthorizationRequestBody\x12*\n" +
	"\x11max_request_bytes\x18\x01 \x01(\rR\x0fmaxRequestBytes\x122\n" +
	"\x15allow_partial_message\x18\x02 \x01(\bR\x13allowPartialMessage\x12\"\n" +
	"\rpack_as_bytes\x18\x03 \x01(\bR\vpackAsBytes\x1a\xa6\b\n" +
	"&EnvoyExternalAuthorizationHttpProvider\x12\x18\n" +
	"\aservice\x18\x01 \x01(\tR\aservice\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port\x123\n" +
	"\atimeout\x18\t \x01(\v2\x19.google.protobuf.DurationR\atimeout\x12\x1f\n" +
	"\vpath_prefix\x18\x03 \x01(\tR\n" +
	"pathPrefix\x12\x1b\n" +
	"\tfail_open\x18\x04 \x01(\bR\bfailOpen\x12*\n" +
	"\x11clear_route_cache\x18\x0e \x01(\bR\x0fclearRouteCache\x12&\n" +
	"\x0fstatus_on_error\x18\x05 \x01(\tR\rstatusOnError\x12;\n" +
	"\x18include_headers_in_check\x18\x06 \x03(\tB\x02\x18\x01R\x15includeHeadersInCheck\x12F\n" +
	" include_request_headers_in_check\x18\n" +
	" \x03(\tR\x1cincludeRequestHeadersInCheck\x12\xcb\x01\n" +
	"#include_additional_headers_in_check\x18\v \x03(\v2}.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationHttpProvider.IncludeAdditionalHeadersInCheckEntryR\x1fincludeAdditionalHeadersInCheck\x12\x99\x01\n" +
	"\x1dinclude_request_body_in_check\x18\f \x01(\v2W.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationRequestBodyR\x19includeRequestBodyInCheck\x12>\n" +
	"\x1cheaders_to_upstream_on_allow\x18\a \x03(\tR\x18headersToUpstreamOnAllow\x12@\n" +
	"\x1dheaders_to_downstream_on_deny\x18\b \x03(\tR\x19headersToDownstreamOnDeny\x12B\n" +
	"\x1eheaders_to_downstream_on_allow\x18\r \x03(\tR\x1aheadersToDownstreamOnAllow\x1aR\n" +
	"$IncludeAdditionalHeadersInCheckEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a\x98\x03\n" +
	"&EnvoyExternalAuthorizationGrpcProvider\x12\x18\n" +
	"\aservice\x18\x01 \x01(\tR\aservice\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port\x123\n" +
	"\atimeout\x18\x05 \x01(\v2\x19.google.protobuf.DurationR\atimeout\x12\x1b\n" +
	"\tfail_open\x18\x03 \x01(\bR\bfailOpen\x12*\n" +
	"\x11clear_route_cache\x18\a \x01(\bR\x0fclearRouteCache\x12&\n" +
	"\x0fstatus_on_error\x18\x04 \x01(\tR\rstatusOnError\x12\x99\x01\n" +
	"\x1dinclude_request_body_in_check\x18\x06 \x01(\v2W.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationRequestBodyR\x19includeRequestBodyInCheck\x1a\xb2\x01\n" +
	"\x15ZipkinTracingProvider\x12\x18\n" +
	"\aservice\x18\x01 \x01(\tR\aservice\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port\x12$\n" +
	"\x0emax_tag_length\x18\x03 \x01(\rR\fmaxTagLength\x121\n" +
	"\x15enable_64bit_trace_id\x18\x04 \x01(\bR\x12enable64bitTraceId\x12\x12\n" +
	"\x04path\x18\x05 \x01(\tR\x04path\x1a\x91\x01\n" +
	"\x18LightstepTracingProvider\x12\x18\n" +
	"\aservice\x18\x01 \x01(\tR\aservice\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port\x12!\n" +
	"\faccess_token\x18\x03 \x01(\tR\vaccessToken\x12$\n" +
	"\x0emax_tag_length\x18\x04 \x01(\rR\fmaxTagLength\x1al\n" +
	"\x16DatadogTracingProvider\x12\x18\n" +
	"\aservice\x18\x01 \x01(\tR\aservice\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port\x12$\n" +
	"\x0emax_tag_length\x18\x03 \x01(\rR\fmaxTagLength\x1al\n" +
	"\x19SkyWalkingTracingProvider\x12\x18\n" +
	"\aservice\x18\x01 \x01(\tR\aservice\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port\x12!\n" +
	"\faccess_token\x18\x03 \x01(\tR\vaccessToken\x1a\x8f\x05\n" +
	"\x13StackdriverProvider\x12\x18\n" +
	"\x05debug\x18\x01 \x01(\bB\x02\x18\x01R\x05debug\x12X\n" +
	"\x18max_number_of_attributes\x18\x02 \x01(\v2\x1b.google.protobuf.Int64ValueB\x02\x18\x01R\x15maxNumberOfAttributes\x12Z\n" +
	"\x19max_number_of_annotations\x18\x03 \x01(\v2\x1b.google.protobuf.Int64ValueB\x02\x18\x01R\x16maxNumberOfAnnotations\x12_\n" +
	"\x1cmax_number_of_message_events\x18\x04 \x01(\v2\x1b.google.protobuf.Int64ValueB\x02\x18\x01R\x18maxNumberOfMessageEvents\x12$\n" +
	"\x0emax_tag_length\x18\x05 \x01(\rR\fmaxTagLength\x12g\n" +
	"\alogging\x18\x06 \x01(\v2M.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.StackdriverProvider.LoggingR\alogging\x1a\xb7\x01\n" +
	"\aLogging\x12q\n" +
	"\x06labels\x18\x01 \x03(\v2Y.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.StackdriverProvider.Logging.LabelsEntryR\x06labels\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a\xd4\x02\n" +
	"\x1eOpenCensusAgentTracingProvider\x12\x18\n" +
	"\aservice\x18\x01 \x01(\tR\aservice\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port\x12w\n" +
	"\acontext\x18\x03 \x03(\x0e2].istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenCensusAgentTracingProvider.TraceContextR\acontext\x12$\n" +
	"\x0emax_tag_length\x18\x04 \x01(\rR\fmaxTagLength\"e\n" +
	"\fTraceContext\x12\x0f\n" +
	"\vUNSPECIFIED\x10\x00\x12\x15\n" +
	"\x11W3C_TRACE_CONTEXT\x10\x01\x12\f\n" +
	"\bGRPC_BIN\x10\x02\x12\x17\n" +
	"\x13CLOUD_TRACE_CONTEXT\x10\x03\x12\x06\n" +
	"\x02B3\x10\x04\x1a\x1b\n" +
	"\x19PrometheusMetricsProvider\x1a\xb7\x02\n" +
	"\x1aEnvoyFileAccessLogProvider\x12\x12\n" +
	"\x04path\x18\x01 \x01(\tR\x04path\x12u\n" +
	"\n" +
	"log_format\x18\x02 \x01(\v2V.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyFileAccessLogProvider.LogFormatR\tlogFormat\x12*\n" +
	"\x11omit_empty_values\x18\x03 \x01(\bR\x0fomitEmptyValues\x1ab\n" +
	"\tLogFormat\x12\x14\n" +
	"\x04text\x18\x01 \x01(\tH\x00R\x04text\x121\n" +
	"\x06labels\x18\x02 \x01(\v2\x17.google.protobuf.StructH\x00R\x06labelsB\f\n" +
	"\n" +
	"log_format\x1a\x87\x03\n" +
	"\x1aEnvoyHttpGrpcV3LogProvider\x12\x18\n" +
	"\aservice\x18\x01 \x01(\tR\aservice\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port\x12\x19\n" +
	"\blog_name\x18\x03 \x01(\tR\alogName\x12<\n" +
	"\x1bfilter_state_objects_to_log\x18\x04 \x03(\tR\x17filterStateObjectsToLog\x12H\n" +
	"!additional_request_headers_to_log\x18\x05 \x03(\tR\x1dadditionalRequestHeadersToLog\x12J\n" +
	"\"additional_response_headers_to_log\x18\x06 \x03(\tR\x1eadditionalResponseHeadersToLog\x12L\n" +
	"#additional_response_trailers_to_log\x18\a \x03(\tR\x1fadditionalResponseTrailersToLog\x1a\xa2\x01\n" +
	"\x19EnvoyTcpGrpcV3LogProvider\x12\x18\n" +
	"\aservice\x18\x01 \x01(\tR\aservice\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port\x12\x19\n" +
	"\blog_name\x18\x03 \x01(\tR\alogName\x12<\n" +
	"\x1bfilter_state_objects_to_log\x18\x04 \x03(\tR\x17filterStateObjectsToLog\x1a\xb4\x02\n" +
	"\x1dEnvoyOpenTelemetryLogProvider\x12\x18\n" +
	"\aservice\x18\x01 \x01(\tR\aservice\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port\x12\x19\n" +
	"\blog_name\x18\x03 \x01(\tR\alogName\x12x\n" +
	"\n" +
	"log_format\x18\x04 \x01(\v2Y.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyOpenTelemetryLogProvider.LogFormatR\tlogFormat\x1aP\n" +
	"\tLogFormat\x12\x12\n" +
	"\x04text\x18\x01 \x01(\tR\x04text\x12/\n" +
	"\x06labels\x18\x02 \x01(\v2\x17.google.protobuf.StructR\x06labels\x1a\xcc\a\n" +
	"\x1cOpenTelemetryTracingProvider\x12\x18\n" +
	"\aservice\x18\x01 \x01(\tR\aservice\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port\x12$\n" +
	"\x0emax_tag_length\x18\x03 \x01(\rR\fmaxTagLength\x12Q\n" +
	"\x04http\x18\x04 \x01(\v2=.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.HttpServiceR\x04http\x12Q\n" +
	"\x04grpc\x18\a \x01(\v2=.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.GrpcServiceR\x04grpc\x12r\n" +
	"\x12resource_detectors\x18\x05 \x01(\v2C.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.ResourceDetectorsR\x11resourceDetectors\x12\x8e\x01\n" +
	"\x11dynatrace_sampler\x18\x06 \x01(\v2_.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenTelemetryTracingProvider.DynatraceSamplerH\x00R\x10dynatraceSampler\x1a\xa0\x03\n" +
	"\x10DynatraceSampler\x12\x16\n" +
	"\x06tenant\x18\x01 \x01(\tR\x06tenant\x12\x1d\n" +
	"\n" +
	"cluster_id\x18\x02 \x01(\x05R\tclusterId\x121\n" +
	"\x15root_spans_per_minute\x18\x03 \x01(\rR\x12rootSpansPerMinute\x12\x8f\x01\n" +
	"\fhttp_service\x18\x04 \x01(\v2l.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenTelemetryTracingProvider.DynatraceSampler.DynatraceApiR\vhttpService\x1a\x8f\x01\n" +
	"\fDynatraceApi\x12\x18\n" +
	"\aservice\x18\x01 \x01(\tR\aservice\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port\x12Q\n" +
	"\x04http\x18\x03 \x01(\v2=.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.HttpServiceR\x04httpB\n" +
	"\n" +
	"\bsampling\x1aO\n" +
	"\vSDSProvider\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x18\n" +
	"\aservice\x18\x02 \x01(\tR\aservice\x12\x12\n" +
	"\x04port\x18\x03 \x01(\rR\x04port\x1a\xae\x01\n" +
	"\vHttpService\x12\x12\n" +
	"\x04path\x18\x01 \x01(\tR\x04path\x123\n" +
	"\atimeout\x18\x02 \x01(\v2\x19.google.protobuf.DurationR\atimeout\x12V\n" +
	"\aheaders\x18\x03 \x03(\v2<.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.HttpHeaderR\aheaders\x1ae\n" +
	"\n" +
	"HttpHeader\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x16\n" +
	"\x05value\x18\x02 \x01(\tH\x00R\x05value\x12\x1b\n" +
	"\benv_name\x18\x03 \x01(\tH\x00R\aenvNameB\x0e\n" +
	"\fheader_value\x1a\xd0\x02\n" +
	"\x11ResourceDetectors\x12\x81\x01\n" +
	"\venvironment\x18\x01 \x01(\v2_.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.ResourceDetectors.EnvironmentResourceDetectorR\venvironment\x12{\n" +
	"\tdynatrace\x18\x02 \x01(\v2].istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.ResourceDetectors.DynatraceResourceDetectorR\tdynatrace\x1a\x1d\n" +
	"\x1bEnvironmentResourceDetector\x1a\x1b\n" +
	"\x19DynatraceResourceDetector\x1a\xab\x01\n" +
	"\vGrpcService\x123\n" +
	"\atimeout\x18\x01 \x01(\v2\x19.google.protobuf.DurationR\atimeout\x12g\n" +
	"\x10initial_metadata\x18\x02 \x03(\v2<.istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.HttpHeaderR\x0finitialMetadataB\n" +
	"\n" +
	"\bprovider\x1am\n" +
	"\x10DefaultProviders\x12\x18\n" +
	"\atracing\x18\x01 \x03(\tR\atracing\x12\x18\n" +
	"\ametrics\x18\x02 \x03(\tR\ametrics\x12%\n" +
	"\x0eaccess_logging\x18\x03 \x03(\tR\raccessLogging\x1a\xef\x01\n" +
	"\x16ProxyPathNormalization\x12n\n" +
	"\rnormalization\x18\x01 \x01(\x0e2H.istio.mesh.v1alpha1.MeshConfig.ProxyPathNormalization.NormalizationTypeR\rnormalization\"e\n" +
	"\x11NormalizationType\x12\v\n" +
	"\aDEFAULT\x10\x00\x12\b\n" +
	"\x04NONE\x10\x01\x12\b\n" +
	"\x04BASE\x10\x02\x12\x11\n" +
	"\rMERGE_SLASHES\x10\x03\x12\x1c\n" +
	"\x18DECODE_AND_MERGE_SLASHES\x10\x04\x1a\xf1\x01\n" +
	"\tTLSConfig\x12g\n" +
	"\x14min_protocol_version\x18\x01 \x01(\x0e25.istio.mesh.v1alpha1.MeshConfig.TLSConfig.TLSProtocolR\x12minProtocolVersion\x12\x1f\n" +
	"\vecdh_curves\x18\x02 \x03(\tR\n" +
	"ecdhCurves\x12#\n" +
	"\rcipher_suites\x18\x03 \x03(\tR\fcipherSuites\"5\n" +
	"\vTLSProtocol\x12\f\n" +
	"\bTLS_AUTO\x10\x00\x12\v\n" +
	"\aTLSV1_2\x10\x01\x12\v\n" +
	"\aTLSV1_3\x10\x02\"J\n" +
	"\x15IngressControllerMode\x12\x0f\n" +
	"\vUNSPECIFIED\x10\x00\x12\a\n" +
	"\x03OFF\x10\x01\x12\v\n" +
	"\aDEFAULT\x10\x02\x12\n" +
	"\n" +
	"\x06STRICT\x10\x03\"&\n" +
	"\n" +
	"AuthPolicy\x12\b\n" +
	"\x04NONE\x10\x00\x12\x0e\n" +
	"\n" +
	"MUTUAL_TLS\x10\x01\"'\n" +
	"\x11AccessLogEncoding\x12\b\n" +
	"\x04TEXT\x10\x00\x12\b\n" +
	"\x04JSON\x10\x01\"2\n" +
	"\x0fH2UpgradePolicy\x12\x12\n" +
	"\x0eDO_NOT_UPGRADE\x10\x00\x12\v\n" +
	"\aUPGRADE\x10\x01J\x04\b1\x102J\x04\b\x01\x10\x02J\x04\b\x02\x10\x03J\x04\b\x03\x10\x04J\x04\b0\x101J\x04\b\x19\x10\x1aJ\x04\b\x1e\x10\x1fJ\x04\b\n" +
	"\x10\vJ\x04\b\v\x10\fJ\x04\b\x0f\x10\x10J\x04\b\x10\x10\x11J\x04\b\x12\x10\x13J\x04\b\x13\x10\x14J\x04\b\x14\x10\x15J\x04\b\x15\x10\x16J\x04\b\x17\x10\x18J\x04\b\x1d\x10\x1eJ\x04\b5\x106J\x04\b%\x10&J\x04\b&\x10'J\x04\b'\x10(R\rthrift_configR\x12mixer_check_serverR\x13mixer_report_serverR\x15disable_policy_checksR\x1adisable_mixer_http_reportsR\x16policy_check_fail_openR%sidecar_to_telemetry_session_affinityR\vauth_policyR\x11rds_refresh_delayR\rmixer_addressR\x1fenable_client_side_policy_checkR\fsds_uds_pathR\x11sds_refresh_delayR\x16enable_sds_token_mountR\x12sds_use_k8s_sa_jwtR\x1atermination_drain_durationR\x14disable_report_batchR\x18report_batch_max_entriesR\x15report_batch_max_time\"\x81\x02\n" +
	"\rLabelSelector\x12U\n" +
	"\vmatchLabels\x18\x01 \x03(\v23.istio.mesh.v1alpha1.LabelSelector.MatchLabelsEntryR\vmatchLabels\x12Y\n" +
	"\x10matchExpressions\x18\x02 \x03(\v2-.istio.mesh.v1alpha1.LabelSelectorRequirementR\x10matchExpressions\x1a>\n" +
	"\x10MatchLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"`\n" +
	"\x18LabelSelectorRequirement\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x1a\n" +
	"\boperator\x18\x02 \x01(\tR\boperator\x12\x16\n" +
	"\x06values\x18\x03 \x03(\tR\x06values\"\xcb\x01\n" +
	"\fConfigSource\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\x12O\n" +
	"\ftls_settings\x18\x02 \x01(\v2,.istio.networking.v1alpha3.ClientTLSSettingsR\vtlsSettings\x12P\n" +
	"\x14subscribed_resources\x18\x03 \x03(\x0e2\x1d.istio.mesh.v1alpha1.ResourceR\x13subscribedResources\"K\n" +
	"\vCertificate\x12\x1f\n" +
	"\vsecret_name\x18\x01 \x01(\tR\n" +
	"secretName\x12\x1b\n" +
	"\tdns_names\x18\x02 \x03(\tR\bdnsNames* \n" +
	"\bResource\x12\x14\n" +
	"\x10SERVICE_REGISTRY\x10\x00B\x1cZ\x1aistio.io/api/mesh/v1alpha1b\x06proto3"

var (
	file_mesh_v1alpha1_config_proto_rawDescOnce sync.Once
	file_mesh_v1alpha1_config_proto_rawDescData []byte
)

func file_mesh_v1alpha1_config_proto_rawDescGZIP() []byte {
	file_mesh_v1alpha1_config_proto_rawDescOnce.Do(func() {
		file_mesh_v1alpha1_config_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_mesh_v1alpha1_config_proto_rawDesc), len(file_mesh_v1alpha1_config_proto_rawDesc)))
	})
	return file_mesh_v1alpha1_config_proto_rawDescData
}

var file_mesh_v1alpha1_config_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_mesh_v1alpha1_config_proto_msgTypes = make([]protoimpl.MessageInfo, 46)
var file_mesh_v1alpha1_config_proto_goTypes = []any{
	(Resource)(0),                                                                 // 0: istio.mesh.v1alpha1.Resource
	(MeshConfig_IngressControllerMode)(0),                                         // 1: istio.mesh.v1alpha1.MeshConfig.IngressControllerMode
	(MeshConfig_AuthPolicy)(0),                                                    // 2: istio.mesh.v1alpha1.MeshConfig.AuthPolicy
	(MeshConfig_AccessLogEncoding)(0),                                             // 3: istio.mesh.v1alpha1.MeshConfig.AccessLogEncoding
	(MeshConfig_H2UpgradePolicy)(0),                                               // 4: istio.mesh.v1alpha1.MeshConfig.H2UpgradePolicy
	(MeshConfig_OutboundTrafficPolicy_Mode)(0),                                    // 5: istio.mesh.v1alpha1.MeshConfig.OutboundTrafficPolicy.Mode
	(MeshConfig_InboundTrafficPolicy_Mode)(0),                                     // 6: istio.mesh.v1alpha1.MeshConfig.InboundTrafficPolicy.Mode
	(MeshConfig_ServiceScopeConfigs_Scope)(0),                                     // 7: istio.mesh.v1alpha1.MeshConfig.ServiceScopeConfigs.Scope
	(MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider_TraceContext)(0), // 8: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenCensusAgentTracingProvider.TraceContext
	(MeshConfig_ProxyPathNormalization_NormalizationType)(0),                      // 9: istio.mesh.v1alpha1.MeshConfig.ProxyPathNormalization.NormalizationType
	(MeshConfig_TLSConfig_TLSProtocol)(0),                                         // 10: istio.mesh.v1alpha1.MeshConfig.TLSConfig.TLSProtocol
	(*MeshConfig)(nil),                                                            // 11: istio.mesh.v1alpha1.MeshConfig
	(*LabelSelector)(nil),                                                         // 12: istio.mesh.v1alpha1.LabelSelector
	(*LabelSelectorRequirement)(nil),                                              // 13: istio.mesh.v1alpha1.LabelSelectorRequirement
	(*ConfigSource)(nil),                                                          // 14: istio.mesh.v1alpha1.ConfigSource
	(*Certificate)(nil),                                                           // 15: istio.mesh.v1alpha1.Certificate
	(*MeshConfig_OutboundTrafficPolicy)(nil),                                      // 16: istio.mesh.v1alpha1.MeshConfig.OutboundTrafficPolicy
	(*MeshConfig_InboundTrafficPolicy)(nil),                                       // 17: istio.mesh.v1alpha1.MeshConfig.InboundTrafficPolicy
	(*MeshConfig_CertificateData)(nil),                                            // 18: istio.mesh.v1alpha1.MeshConfig.CertificateData
	(*MeshConfig_ServiceSettings)(nil),                                            // 19: istio.mesh.v1alpha1.MeshConfig.ServiceSettings
	(*MeshConfig_ServiceScopeConfigs)(nil),                                        // 20: istio.mesh.v1alpha1.MeshConfig.ServiceScopeConfigs
	(*MeshConfig_CA)(nil),                                                         // 21: istio.mesh.v1alpha1.MeshConfig.CA
	(*MeshConfig_ExtensionProvider)(nil),                                          // 22: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider
	(*MeshConfig_DefaultProviders)(nil),                                           // 23: istio.mesh.v1alpha1.MeshConfig.DefaultProviders
	(*MeshConfig_ProxyPathNormalization)(nil),                                     // 24: istio.mesh.v1alpha1.MeshConfig.ProxyPathNormalization
	(*MeshConfig_TLSConfig)(nil),                                                  // 25: istio.mesh.v1alpha1.MeshConfig.TLSConfig
	(*MeshConfig_ServiceSettings_Settings)(nil),                                   // 26: istio.mesh.v1alpha1.MeshConfig.ServiceSettings.Settings
	(*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationRequestBody)(nil),    // 27: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationRequestBody
	(*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationHttpProvider)(nil),   // 28: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationHttpProvider
	(*MeshConfig_ExtensionProvider_EnvoyExternalAuthorizationGrpcProvider)(nil),   // 29: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationGrpcProvider
	(*MeshConfig_ExtensionProvider_ZipkinTracingProvider)(nil),                    // 30: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.ZipkinTracingProvider
	(*MeshConfig_ExtensionProvider_LightstepTracingProvider)(nil),                 // 31: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.LightstepTracingProvider
	(*MeshConfig_ExtensionProvider_DatadogTracingProvider)(nil),                   // 32: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.DatadogTracingProvider
	(*MeshConfig_ExtensionProvider_SkyWalkingTracingProvider)(nil),                // 33: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.SkyWalkingTracingProvider
	(*MeshConfig_ExtensionProvider_StackdriverProvider)(nil),                      // 34: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.StackdriverProvider
	(*MeshConfig_ExtensionProvider_OpenCensusAgentTracingProvider)(nil),           // 35: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenCensusAgentTracingProvider
	(*MeshConfig_ExtensionProvider_PrometheusMetricsProvider)(nil),                // 36: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.PrometheusMetricsProvider
	(*MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider)(nil),               // 37: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyFileAccessLogProvider
	(*MeshConfig_ExtensionProvider_EnvoyHttpGrpcV3LogProvider)(nil),               // 38: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyHttpGrpcV3LogProvider
	(*MeshConfig_ExtensionProvider_EnvoyTcpGrpcV3LogProvider)(nil),                // 39: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyTcpGrpcV3LogProvider
	(*MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider)(nil),            // 40: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyOpenTelemetryLogProvider
	(*MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider)(nil),             // 41: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenTelemetryTracingProvider
	(*MeshConfig_ExtensionProvider_SDSProvider)(nil),                              // 42: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.SDSProvider
	(*MeshConfig_ExtensionProvider_HttpService)(nil),                              // 43: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.HttpService
	(*MeshConfig_ExtensionProvider_HttpHeader)(nil),                               // 44: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.HttpHeader
	(*MeshConfig_ExtensionProvider_ResourceDetectors)(nil),                        // 45: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.ResourceDetectors
	(*MeshConfig_ExtensionProvider_GrpcService)(nil),                              // 46: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.GrpcService
	nil, // 47: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationHttpProvider.IncludeAdditionalHeadersInCheckEntry
	(*MeshConfig_ExtensionProvider_StackdriverProvider_Logging)(nil), // 48: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.StackdriverProvider.Logging
	nil, // 49: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.StackdriverProvider.Logging.LabelsEntry
	(*MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat)(nil),                       // 50: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyFileAccessLogProvider.LogFormat
	(*MeshConfig_ExtensionProvider_EnvoyOpenTelemetryLogProvider_LogFormat)(nil),                    // 51: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyOpenTelemetryLogProvider.LogFormat
	(*MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler)(nil),              // 52: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenTelemetryTracingProvider.DynatraceSampler
	(*MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_DynatraceApi)(nil), // 53: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenTelemetryTracingProvider.DynatraceSampler.DynatraceApi
	(*MeshConfig_ExtensionProvider_ResourceDetectors_EnvironmentResourceDetector)(nil),              // 54: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.ResourceDetectors.EnvironmentResourceDetector
	(*MeshConfig_ExtensionProvider_ResourceDetectors_DynatraceResourceDetector)(nil),                // 55: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.ResourceDetectors.DynatraceResourceDetector
	nil,                       // 56: istio.mesh.v1alpha1.LabelSelector.MatchLabelsEntry
	(*duration.Duration)(nil), // 57: google.protobuf.Duration
	(*v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive)(nil), // 58: istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings.TcpKeepalive
	(*ProxyConfig)(nil),                          // 59: istio.mesh.v1alpha1.ProxyConfig
	(*wrappers.BoolValue)(nil),                   // 60: google.protobuf.BoolValue
	(*v1alpha3.LocalityLoadBalancerSetting)(nil), // 61: istio.networking.v1alpha3.LocalityLoadBalancerSetting
	(*v1alpha3.HTTPRetry)(nil),                   // 62: istio.networking.v1alpha3.HTTPRetry
	(*v1alpha3.ClientTLSSettings)(nil),           // 63: istio.networking.v1alpha3.ClientTLSSettings
	(*wrappers.Int64Value)(nil),                  // 64: google.protobuf.Int64Value
	(*_struct.Struct)(nil),                       // 65: google.protobuf.Struct
}
var file_mesh_v1alpha1_config_proto_depIdxs = []int32{
	57, // 0: istio.mesh.v1alpha1.MeshConfig.connect_timeout:type_name -> google.protobuf.Duration
	57, // 1: istio.mesh.v1alpha1.MeshConfig.protocol_detection_timeout:type_name -> google.protobuf.Duration
	58, // 2: istio.mesh.v1alpha1.MeshConfig.tcp_keepalive:type_name -> istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings.TcpKeepalive
	1,  // 3: istio.mesh.v1alpha1.MeshConfig.ingress_controller_mode:type_name -> istio.mesh.v1alpha1.MeshConfig.IngressControllerMode
	3,  // 4: istio.mesh.v1alpha1.MeshConfig.access_log_encoding:type_name -> istio.mesh.v1alpha1.MeshConfig.AccessLogEncoding
	59, // 5: istio.mesh.v1alpha1.MeshConfig.default_config:type_name -> istio.mesh.v1alpha1.ProxyConfig
	16, // 6: istio.mesh.v1alpha1.MeshConfig.outbound_traffic_policy:type_name -> istio.mesh.v1alpha1.MeshConfig.OutboundTrafficPolicy
	17, // 7: istio.mesh.v1alpha1.MeshConfig.inbound_traffic_policy:type_name -> istio.mesh.v1alpha1.MeshConfig.InboundTrafficPolicy
	14, // 8: istio.mesh.v1alpha1.MeshConfig.config_sources:type_name -> istio.mesh.v1alpha1.ConfigSource
	60, // 9: istio.mesh.v1alpha1.MeshConfig.enable_auto_mtls:type_name -> google.protobuf.BoolValue
	18, // 10: istio.mesh.v1alpha1.MeshConfig.ca_certificates:type_name -> istio.mesh.v1alpha1.MeshConfig.CertificateData
	61, // 11: istio.mesh.v1alpha1.MeshConfig.locality_lb_setting:type_name -> istio.networking.v1alpha3.LocalityLoadBalancerSetting
	57, // 12: istio.mesh.v1alpha1.MeshConfig.dns_refresh_rate:type_name -> google.protobuf.Duration
	4,  // 13: istio.mesh.v1alpha1.MeshConfig.h2_upgrade_policy:type_name -> istio.mesh.v1alpha1.MeshConfig.H2UpgradePolicy
	15, // 14: istio.mesh.v1alpha1.MeshConfig.certificates:type_name -> istio.mesh.v1alpha1.Certificate
	19, // 15: istio.mesh.v1alpha1.MeshConfig.service_settings:type_name -> istio.mesh.v1alpha1.MeshConfig.ServiceSettings
	20, // 16: istio.mesh.v1alpha1.MeshConfig.service_scope_configs:type_name -> istio.mesh.v1alpha1.MeshConfig.ServiceScopeConfigs
	60, // 17: istio.mesh.v1alpha1.MeshConfig.enable_prometheus_merge:type_name -> google.protobuf.BoolValue
	60, // 18: istio.mesh.v1alpha1.MeshConfig.verify_certificate_at_client:type_name -> google.protobuf.BoolValue
	21, // 19: istio.mesh.v1alpha1.MeshConfig.ca:type_name -> istio.mesh.v1alpha1.MeshConfig.CA
	22, // 20: istio.mesh.v1alpha1.MeshConfig.extension_providers:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider
	23, // 21: istio.mesh.v1alpha1.MeshConfig.default_providers:type_name -> istio.mesh.v1alpha1.MeshConfig.DefaultProviders
	12, // 22: istio.mesh.v1alpha1.MeshConfig.discovery_selectors:type_name -> istio.mesh.v1alpha1.LabelSelector
	24, // 23: istio.mesh.v1alpha1.MeshConfig.path_normalization:type_name -> istio.mesh.v1alpha1.MeshConfig.ProxyPathNormalization
	62, // 24: istio.mesh.v1alpha1.MeshConfig.default_http_retry_policy:type_name -> istio.networking.v1alpha3.HTTPRetry
	25, // 25: istio.mesh.v1alpha1.MeshConfig.mesh_mTLS:type_name -> istio.mesh.v1alpha1.MeshConfig.TLSConfig
	25, // 26: istio.mesh.v1alpha1.MeshConfig.tls_defaults:type_name -> istio.mesh.v1alpha1.MeshConfig.TLSConfig
	56, // 27: istio.mesh.v1alpha1.LabelSelector.matchLabels:type_name -> istio.mesh.v1alpha1.LabelSelector.MatchLabelsEntry
	13, // 28: istio.mesh.v1alpha1.LabelSelector.matchExpressions:type_name -> istio.mesh.v1alpha1.LabelSelectorRequirement
	63, // 29: istio.mesh.v1alpha1.ConfigSource.tls_settings:type_name -> istio.networking.v1alpha3.ClientTLSSettings
	0,  // 30: istio.mesh.v1alpha1.ConfigSource.subscribed_resources:type_name -> istio.mesh.v1alpha1.Resource
	5,  // 31: istio.mesh.v1alpha1.MeshConfig.OutboundTrafficPolicy.mode:type_name -> istio.mesh.v1alpha1.MeshConfig.OutboundTrafficPolicy.Mode
	6,  // 32: istio.mesh.v1alpha1.MeshConfig.InboundTrafficPolicy.mode:type_name -> istio.mesh.v1alpha1.MeshConfig.InboundTrafficPolicy.Mode
	26, // 33: istio.mesh.v1alpha1.MeshConfig.ServiceSettings.settings:type_name -> istio.mesh.v1alpha1.MeshConfig.ServiceSettings.Settings
	12, // 34: istio.mesh.v1alpha1.MeshConfig.ServiceScopeConfigs.namespace_selector:type_name -> istio.mesh.v1alpha1.LabelSelector
	12, // 35: istio.mesh.v1alpha1.MeshConfig.ServiceScopeConfigs.services_selector:type_name -> istio.mesh.v1alpha1.LabelSelector
	7,  // 36: istio.mesh.v1alpha1.MeshConfig.ServiceScopeConfigs.scope:type_name -> istio.mesh.v1alpha1.MeshConfig.ServiceScopeConfigs.Scope
	63, // 37: istio.mesh.v1alpha1.MeshConfig.CA.tls_settings:type_name -> istio.networking.v1alpha3.ClientTLSSettings
	57, // 38: istio.mesh.v1alpha1.MeshConfig.CA.request_timeout:type_name -> google.protobuf.Duration
	28, // 39: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.envoy_ext_authz_http:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationHttpProvider
	29, // 40: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.envoy_ext_authz_grpc:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationGrpcProvider
	30, // 41: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.zipkin:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.ZipkinTracingProvider
	31, // 42: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.lightstep:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.LightstepTracingProvider
	32, // 43: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.datadog:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.DatadogTracingProvider
	34, // 44: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.stackdriver:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.StackdriverProvider
	35, // 45: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.opencensus:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenCensusAgentTracingProvider
	33, // 46: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.skywalking:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.SkyWalkingTracingProvider
	41, // 47: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.opentelemetry:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenTelemetryTracingProvider
	36, // 48: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.prometheus:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.PrometheusMetricsProvider
	37, // 49: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.envoy_file_access_log:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyFileAccessLogProvider
	38, // 50: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.envoy_http_als:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyHttpGrpcV3LogProvider
	39, // 51: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.envoy_tcp_als:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyTcpGrpcV3LogProvider
	40, // 52: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.envoy_otel_als:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyOpenTelemetryLogProvider
	42, // 53: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.sds:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.SDSProvider
	9,  // 54: istio.mesh.v1alpha1.MeshConfig.ProxyPathNormalization.normalization:type_name -> istio.mesh.v1alpha1.MeshConfig.ProxyPathNormalization.NormalizationType
	10, // 55: istio.mesh.v1alpha1.MeshConfig.TLSConfig.min_protocol_version:type_name -> istio.mesh.v1alpha1.MeshConfig.TLSConfig.TLSProtocol
	57, // 56: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationHttpProvider.timeout:type_name -> google.protobuf.Duration
	47, // 57: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationHttpProvider.include_additional_headers_in_check:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationHttpProvider.IncludeAdditionalHeadersInCheckEntry
	27, // 58: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationHttpProvider.include_request_body_in_check:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationRequestBody
	57, // 59: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationGrpcProvider.timeout:type_name -> google.protobuf.Duration
	27, // 60: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationGrpcProvider.include_request_body_in_check:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyExternalAuthorizationRequestBody
	64, // 61: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.StackdriverProvider.max_number_of_attributes:type_name -> google.protobuf.Int64Value
	64, // 62: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.StackdriverProvider.max_number_of_annotations:type_name -> google.protobuf.Int64Value
	64, // 63: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.StackdriverProvider.max_number_of_message_events:type_name -> google.protobuf.Int64Value
	48, // 64: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.StackdriverProvider.logging:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.StackdriverProvider.Logging
	8,  // 65: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenCensusAgentTracingProvider.context:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenCensusAgentTracingProvider.TraceContext
	50, // 66: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyFileAccessLogProvider.log_format:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyFileAccessLogProvider.LogFormat
	51, // 67: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyOpenTelemetryLogProvider.log_format:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyOpenTelemetryLogProvider.LogFormat
	43, // 68: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenTelemetryTracingProvider.http:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.HttpService
	46, // 69: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenTelemetryTracingProvider.grpc:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.GrpcService
	45, // 70: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenTelemetryTracingProvider.resource_detectors:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.ResourceDetectors
	52, // 71: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenTelemetryTracingProvider.dynatrace_sampler:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenTelemetryTracingProvider.DynatraceSampler
	57, // 72: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.HttpService.timeout:type_name -> google.protobuf.Duration
	44, // 73: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.HttpService.headers:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.HttpHeader
	54, // 74: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.ResourceDetectors.environment:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.ResourceDetectors.EnvironmentResourceDetector
	55, // 75: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.ResourceDetectors.dynatrace:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.ResourceDetectors.DynatraceResourceDetector
	57, // 76: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.GrpcService.timeout:type_name -> google.protobuf.Duration
	44, // 77: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.GrpcService.initial_metadata:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.HttpHeader
	49, // 78: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.StackdriverProvider.Logging.labels:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.StackdriverProvider.Logging.LabelsEntry
	65, // 79: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyFileAccessLogProvider.LogFormat.labels:type_name -> google.protobuf.Struct
	65, // 80: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.EnvoyOpenTelemetryLogProvider.LogFormat.labels:type_name -> google.protobuf.Struct
	53, // 81: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenTelemetryTracingProvider.DynatraceSampler.http_service:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenTelemetryTracingProvider.DynatraceSampler.DynatraceApi
	43, // 82: istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.OpenTelemetryTracingProvider.DynatraceSampler.DynatraceApi.http:type_name -> istio.mesh.v1alpha1.MeshConfig.ExtensionProvider.HttpService
	83, // [83:83] is the sub-list for method output_type
	83, // [83:83] is the sub-list for method input_type
	83, // [83:83] is the sub-list for extension type_name
	83, // [83:83] is the sub-list for extension extendee
	0,  // [0:83] is the sub-list for field type_name
}

func init() { file_mesh_v1alpha1_config_proto_init() }
func file_mesh_v1alpha1_config_proto_init() {
	if File_mesh_v1alpha1_config_proto != nil {
		return
	}
	file_mesh_v1alpha1_proxy_proto_init()
	file_mesh_v1alpha1_config_proto_msgTypes[7].OneofWrappers = []any{
		(*MeshConfig_CertificateData_Pem)(nil),
		(*MeshConfig_CertificateData_SpiffeBundleUrl)(nil),
	}
	file_mesh_v1alpha1_config_proto_msgTypes[11].OneofWrappers = []any{
		(*MeshConfig_ExtensionProvider_EnvoyExtAuthzHttp)(nil),
		(*MeshConfig_ExtensionProvider_EnvoyExtAuthzGrpc)(nil),
		(*MeshConfig_ExtensionProvider_Zipkin)(nil),
		(*MeshConfig_ExtensionProvider_Lightstep)(nil),
		(*MeshConfig_ExtensionProvider_Datadog)(nil),
		(*MeshConfig_ExtensionProvider_Stackdriver)(nil),
		(*MeshConfig_ExtensionProvider_Opencensus)(nil),
		(*MeshConfig_ExtensionProvider_Skywalking)(nil),
		(*MeshConfig_ExtensionProvider_Opentelemetry)(nil),
		(*MeshConfig_ExtensionProvider_Prometheus)(nil),
		(*MeshConfig_ExtensionProvider_EnvoyFileAccessLog)(nil),
		(*MeshConfig_ExtensionProvider_EnvoyHttpAls)(nil),
		(*MeshConfig_ExtensionProvider_EnvoyTcpAls)(nil),
		(*MeshConfig_ExtensionProvider_EnvoyOtelAls)(nil),
		(*MeshConfig_ExtensionProvider_Sds)(nil),
	}
	file_mesh_v1alpha1_config_proto_msgTypes[30].OneofWrappers = []any{
		(*MeshConfig_ExtensionProvider_OpenTelemetryTracingProvider_DynatraceSampler_)(nil),
	}
	file_mesh_v1alpha1_config_proto_msgTypes[33].OneofWrappers = []any{
		(*MeshConfig_ExtensionProvider_HttpHeader_Value)(nil),
		(*MeshConfig_ExtensionProvider_HttpHeader_EnvName)(nil),
	}
	file_mesh_v1alpha1_config_proto_msgTypes[39].OneofWrappers = []any{
		(*MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_Text)(nil),
		(*MeshConfig_ExtensionProvider_EnvoyFileAccessLogProvider_LogFormat_Labels)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_mesh_v1alpha1_config_proto_rawDesc), len(file_mesh_v1alpha1_config_proto_rawDesc)),
			NumEnums:      11,
			NumMessages:   46,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_mesh_v1alpha1_config_proto_goTypes,
		DependencyIndexes: file_mesh_v1alpha1_config_proto_depIdxs,
		EnumInfos:         file_mesh_v1alpha1_config_proto_enumTypes,
		MessageInfos:      file_mesh_v1alpha1_config_proto_msgTypes,
	}.Build()
	File_mesh_v1alpha1_config_proto = out.File
	file_mesh_v1alpha1_config_proto_goTypes = nil
	file_mesh_v1alpha1_config_proto_depIdxs = nil
}
