/* Autogenerated file, DO NOT EDIT manually! generated by oa-equations-codegen.py */
// SPDX-License-Identifier: MIT
/*
 * Copyright © 2024 Intel Corporation
 */

#include <stdlib.h>
#include <string.h>

#include "xe/xe_oa.h"
#include "xe_oa_equations.h"

#define MIN(x, y) (((x) < (y)) ? (x) : (y))
#define MAX(a, b) (((a) > (b)) ? (a) : (b))

double
percentage_max_callback_float(const struct intel_xe_perf *perf,
                              const struct intel_xe_perf_metric_set *metric_set,
                              uint64_t *accumulator)
{
   return 100;
}

uint64_t
percentage_max_callback_uint64(const struct intel_xe_perf *perf,
                               const struct intel_xe_perf_metric_set *metric_set,
                               uint64_t *accumulator)
{
   return 100;
}


/* Render Metrics Basic set :: GPU Time Elapsed */
uint64_t
tglgt1__render_basic__gpu_time__read(const struct intel_xe_perf *perf,
                                     const struct intel_xe_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
    uint64_t tmp0 = accumulator[metric_set->gpu_time_offset + 0];
    uint64_t tmp1 = tmp0 * 1000000000;
    uint64_t tmp2 = tmp1;
    uint64_t tmp3 = perf->devinfo.timestamp_frequency;
    uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic set :: GPU Core Clocks */
uint64_t
tglgt1__render_basic__gpu_core_clocks__read(const struct intel_xe_perf *perf,
                                            const struct intel_xe_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: GPU_CLOCK 0 READ */
    uint64_t tmp0 = accumulator[metric_set->gpu_clock_offset + 0];

    return tmp0;
}

/* Render Metrics Basic set :: AVG GPU Core Frequency */
uint64_t
tglgt1__render_basic__avg_gpu_core_frequency__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
    uint64_t tmp0 = tglgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 1000000000;
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = tglgt1__render_basic__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Render Metrics Basic set :: AVG GPU Core Frequency */
uint64_t
tglgt1__render_basic__avg_gpu_core_frequency__max(const struct intel_xe_perf *perf,
                                                  const struct intel_xe_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: $GpuMaxFrequency */

    return perf->devinfo.gt_max_freq;
}

/* Render Metrics Basic set :: VS Threads Dispatched */
uint64_t
tglgt1__render_basic__vs_threads__read(const struct intel_xe_perf *perf,
                                       const struct intel_xe_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: A 1 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 1];

    return tmp0;
}

/* Render Metrics Basic set :: HS Threads Dispatched */
uint64_t
tglgt1__render_basic__hs_threads__read(const struct intel_xe_perf *perf,
                                       const struct intel_xe_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: A 2 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 2];

    return tmp0;
}

/* Render Metrics Basic set :: DS Threads Dispatched */
uint64_t
tglgt1__render_basic__ds_threads__read(const struct intel_xe_perf *perf,
                                       const struct intel_xe_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: A 3 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 3];

    return tmp0;
}

/* Render Metrics Basic set :: GS Threads Dispatched */
uint64_t
tglgt1__render_basic__gs_threads__read(const struct intel_xe_perf *perf,
                                       const struct intel_xe_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: A 5 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 5];

    return tmp0;
}

/* Render Metrics Basic set :: FS Threads Dispatched */
uint64_t
tglgt1__render_basic__ps_threads__read(const struct intel_xe_perf *perf,
                                       const struct intel_xe_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: A 6 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 6];

    return tmp0;
}

/* Render Metrics Basic set :: CS Threads Dispatched */
uint64_t
tglgt1__render_basic__cs_threads__read(const struct intel_xe_perf *perf,
                                       const struct intel_xe_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: A 4 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 4];

    return tmp0;
}

/* Render Metrics Basic set :: GPU Busy */
double
tglgt1__render_basic__gpu_busy__read(const struct intel_xe_perf *perf,
                                     const struct intel_xe_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = tglgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic set :: EU Active */
double
tglgt1__render_basic__eu_active__read(const struct intel_xe_perf *perf,
                                      const struct intel_xe_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 7 READ A 8 READ FADD A 9 READ FADD A 10 READ FADD $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 8];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 9];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->a_offset + 10];
    double tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = tmp6;
    uint64_t tmp8 = perf->devinfo.n_eus;
    uint64_t tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    uint64_t tmp10 = tmp9 * 100;
    double tmp11 = tmp10;
    double tmp12 = tglgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp13 = tmp12 ? tmp11 / tmp12 : 0;

    return tmp13;
}

/* Render Metrics Basic set :: EU Stall */
double
tglgt1__render_basic__eu_stall__read(const struct intel_xe_perf *perf,
                                     const struct intel_xe_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 11 READ A 12 READ FADD A 13 READ FADD A 14 READ FADD $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 11];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 12];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 13];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->a_offset + 14];
    double tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = tmp6;
    uint64_t tmp8 = perf->devinfo.n_eus;
    uint64_t tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    uint64_t tmp10 = tmp9 * 100;
    double tmp11 = tmp10;
    double tmp12 = tglgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp13 = tmp12 ? tmp11 / tmp12 : 0;

    return tmp13;
}

/* Render Metrics Basic set :: EU Thread Occupancy */
double
tglgt1__render_basic__eu_thread_occupancy__read(const struct intel_xe_perf *perf,
                                                const struct intel_xe_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: 8 A 15 READ A 16 READ FADD A 17 READ FADD A 18 READ FADD FMUL $EuThreadsCount FDIV $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 15];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 16];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 17];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->a_offset + 18];
    double tmp6 = tmp4 + tmp5;
    double tmp7 = 8 * tmp6;
    double tmp8 = tmp7;
    double tmp9 = perf->devinfo.eu_threads_count;
    double tmp10 = tmp9 ? tmp8 / tmp9 : 0;
    uint64_t tmp11 = tmp10;
    uint64_t tmp12 = perf->devinfo.n_eus;
    uint64_t tmp13 = tmp12 ? tmp11 / tmp12 : 0;
    uint64_t tmp14 = tmp13 * 100;
    double tmp15 = tmp14;
    double tmp16 = tglgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp17 = tmp16 ? tmp15 / tmp16 : 0;

    return tmp17;
}

/* Render Metrics Basic set :: Sampler00 Busy */
double
tglgt1__render_basic__sampler00_busy__read(const struct intel_xe_perf *perf,
                                           const struct intel_xe_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = tglgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic set :: Sampler Slice0 Dualsubslice0 is bottleneck */
double
tglgt1__render_basic__sampler00_bottleneck__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = tglgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic set :: Rasterized Pixels */
uint64_t
tglgt1__render_basic__rasterized_pixels__read(const struct intel_xe_perf *perf,
                                              const struct intel_xe_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: A 21 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 21];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Early Hi-Depth Test Fails */
uint64_t
tglgt1__render_basic__hi_depth_test_fails__read(const struct intel_xe_perf *perf,
                                                const struct intel_xe_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: A 22 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Early Depth Test Fails */
uint64_t
tglgt1__render_basic__early_depth_test_fails__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: A 23 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Samples Killed in FS */
uint64_t
tglgt1__render_basic__samples_killed_in_ps__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: A 24 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 24];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Pixels Failing Tests */
uint64_t
tglgt1__render_basic__pixels_failing_post_ps_tests__read(const struct intel_xe_perf *perf,
                                                         const struct intel_xe_perf_metric_set *metric_set,
                                                         uint64_t *accumulator)
{
    /* RPN equation: A 25 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 25];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Samples Written */
uint64_t
tglgt1__render_basic__samples_written__read(const struct intel_xe_perf *perf,
                                            const struct intel_xe_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: A 26 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 26];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Samples Blended */
uint64_t
tglgt1__render_basic__samples_blended__read(const struct intel_xe_perf *perf,
                                            const struct intel_xe_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: A 27 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Sampler Texels */
uint64_t
tglgt1__render_basic__sampler_texels__read(const struct intel_xe_perf *perf,
                                           const struct intel_xe_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: A 28 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Sampler Texels Misses */
uint64_t
tglgt1__render_basic__sampler_texel_misses__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: A 29 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 29];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: SLM Bytes Read */
uint64_t
tglgt1__render_basic__slm_bytes_read__read(const struct intel_xe_perf *perf,
                                           const struct intel_xe_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: A 30 READ 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 30];
    uint64_t tmp1 = tmp0 * 64;

    return tmp1;
}

/* Render Metrics Basic set :: SLM Bytes Read */
uint64_t
tglgt1__render_basic__slm_bytes_read__max(const struct intel_xe_perf *perf,
                                          const struct intel_xe_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 128 UMUL $EuSubslicesTotalCount UMUL */
    uint64_t tmp0 = tglgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 128;
    uint64_t tmp1 = tmp0 * perf->devinfo.n_eu_sub_slices;

    return tmp1;
}

/* Render Metrics Basic set :: SLM Bytes Written */
uint64_t
tglgt1__render_basic__slm_bytes_written__read(const struct intel_xe_perf *perf,
                                              const struct intel_xe_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: A 31 READ 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 31];
    uint64_t tmp1 = tmp0 * 64;

    return tmp1;
}

/* Render Metrics Basic set :: Shader Memory Accesses */
uint64_t
tglgt1__render_basic__shader_memory_accesses__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: A 32 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 32];

    return tmp0;
}

/* Render Metrics Basic set :: Shader Atomic Memory Accesses */
uint64_t
tglgt1__render_basic__shader_atomics__read(const struct intel_xe_perf *perf,
                                           const struct intel_xe_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: A 34 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 34];

    return tmp0;
}

/* Render Metrics Basic set :: L3 Shader Throughput */
uint64_t
tglgt1__render_basic__l3_shader_throughput__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: $ShaderMemoryAccesses 64 UMUL */
    uint64_t tmp0 = tglgt1__render_basic__shader_memory_accesses__read(perf, metric_set, accumulator) * 64;

    return tmp0;
}

/* Render Metrics Basic set :: L3 Shader Throughput */
uint64_t
tglgt1__render_basic__l3_shader_throughput__max(const struct intel_xe_perf *perf,
                                                const struct intel_xe_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 64 UMUL $EuSubslicesTotalCount UMUL */
    uint64_t tmp0 = tglgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 64;
    uint64_t tmp1 = tmp0 * perf->devinfo.n_eu_sub_slices;

    return tmp1;
}

/* Render Metrics Basic set :: Shader Barrier Messages */
uint64_t
tglgt1__render_basic__shader_barriers__read(const struct intel_xe_perf *perf,
                                            const struct intel_xe_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: A 35 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 35];

    return tmp0;
}

/* Render Metrics Basic set :: GTI Read Throughput */
uint64_t
tglgt1__render_basic__gti_read_throughput__read(const struct intel_xe_perf *perf,
                                                const struct intel_xe_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: 64  C 5 READ C 4 READ UADD C 3 READ UADD C 2 READ UADD UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = 64 * tmp6;

    return tmp7;
}

/* Render Metrics Basic set :: GTI Read Throughput */
uint64_t
tglgt1__render_basic__gti_read_throughput__max(const struct intel_xe_perf *perf,
                                               const struct intel_xe_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 64 UMUL */
    uint64_t tmp0 = tglgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 64;

    return tmp0;
}

/* Render Metrics Basic set :: GTI Write Throughput */
uint64_t
tglgt1__render_basic__gti_write_throughput__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 64  C 1 READ C 0 READ UADD UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = 64 * tmp2;

    return tmp3;
}

/* Metric set TestOa :: TestCounter0 */
uint64_t
tglgt1__test_oa__counter0__read(const struct intel_xe_perf *perf,
                                const struct intel_xe_perf_metric_set *metric_set,
                                uint64_t *accumulator)
{
    /* RPN equation: B 0 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];

    return tmp0;
}

/* Metric set TestOa :: TestCounter1 */
uint64_t
tglgt1__test_oa__counter1__read(const struct intel_xe_perf *perf,
                                const struct intel_xe_perf_metric_set *metric_set,
                                uint64_t *accumulator)
{
    /* RPN equation: B 1 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];

    return tmp0;
}

/* Metric set TestOa :: TestCounter2 */
uint64_t
tglgt1__test_oa__counter2__read(const struct intel_xe_perf *perf,
                                const struct intel_xe_perf_metric_set *metric_set,
                                uint64_t *accumulator)
{
    /* RPN equation: B 2 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];

    return tmp0;
}

/* Metric set TestOa :: TestCounter3 */
uint64_t
tglgt1__test_oa__counter3__read(const struct intel_xe_perf *perf,
                                const struct intel_xe_perf_metric_set *metric_set,
                                uint64_t *accumulator)
{
    /* RPN equation: B 3 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];

    return tmp0;
}

/* Metric set TestOa :: TestCounter4 */
uint64_t
tglgt1__test_oa__counter4__read(const struct intel_xe_perf *perf,
                                const struct intel_xe_perf_metric_set *metric_set,
                                uint64_t *accumulator)
{
    /* RPN equation: B 4 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];

    return tmp0;
}

/* Metric set TestOa :: TestCounter5 */
uint64_t
tglgt1__test_oa__counter5__read(const struct intel_xe_perf *perf,
                                const struct intel_xe_perf_metric_set *metric_set,
                                uint64_t *accumulator)
{
    /* RPN equation: B 5 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];

    return tmp0;
}

/* Metric set TestOa :: TestCounter6 */
uint64_t
tglgt1__test_oa__counter6__read(const struct intel_xe_perf *perf,
                                const struct intel_xe_perf_metric_set *metric_set,
                                uint64_t *accumulator)
{
    /* RPN equation: B 6 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];

    return tmp0;
}

/* Metric set TestOa :: TestCounter7 */
uint64_t
tglgt1__test_oa__counter7__read(const struct intel_xe_perf *perf,
                                const struct intel_xe_perf_metric_set *metric_set,
                                uint64_t *accumulator)
{
    /* RPN equation: B 7 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];

    return tmp0;
}

/* Metric set TestOa :: TestCounter8 */
uint64_t
tglgt1__test_oa__counter8__read(const struct intel_xe_perf *perf,
                                const struct intel_xe_perf_metric_set *metric_set,
                                uint64_t *accumulator)
{
    /* RPN equation: C 0 READ */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];

    return tmp0;
}

/* Metric set TestOa :: TestCounter9 - OAR enable */
uint64_t
tglgt1__test_oa__counter9__read(const struct intel_xe_perf *perf,
                                const struct intel_xe_perf_metric_set *metric_set,
                                uint64_t *accumulator)
{
    /* RPN equation: C 1 READ */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];

    return tmp0;
}

/* Render Metrics Basic set :: GTI Read Throughput */
uint64_t
dg1__render_basic__gti_read_throughput__max(const struct intel_xe_perf *perf,
                                            const struct intel_xe_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 128 UMUL */
    uint64_t tmp0 = dg1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 128;

    return tmp0;
}

/* Render Metrics Basic - aggregation approximation :: XVE Active */
double
acmgt1__render_basic__xve_active__read(const struct intel_xe_perf *perf,
                                       const struct intel_xe_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic - aggregation approximation :: XVE Stall */
double
acmgt1__render_basic__xve_stall__read(const struct intel_xe_perf *perf,
                                      const struct intel_xe_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic - aggregation approximation :: XVE Thread Occupancy */
double
acmgt1__render_basic__xve_thread_occupancy__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 8 A 9 READ FMUL $VectorEngineThreadsCount FDIV $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 9];
    double tmp1 = 8 * tmp0;
    double tmp2 = tmp1;
    double tmp3 = perf->devinfo.eu_threads_count;
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4;
    uint64_t tmp6 = perf->devinfo.n_eus;
    uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
    uint64_t tmp8 = tmp7 * 100;
    double tmp9 = tmp8;
    double tmp10 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

    return tmp11;
}

/* Render Metrics Basic - aggregation approximation :: EM And FPU Pipes Active */
double
acmgt1__render_basic__xve_fpu_em_active__read(const struct intel_xe_perf *perf,
                                              const struct intel_xe_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 10];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic - aggregation approximation :: VS FPU Pipe Active */
double
acmgt1__render_basic__vs_fpu_active__read(const struct intel_xe_perf *perf,
                                          const struct intel_xe_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 11];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic - aggregation approximation :: VS EM Pipe Active */
double
acmgt1__render_basic__vs_em_active__read(const struct intel_xe_perf *perf,
                                         const struct intel_xe_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic - aggregation approximation :: VS Send Pipe Active */
double
acmgt1__render_basic__vs_send_active__read(const struct intel_xe_perf *perf,
                                           const struct intel_xe_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: A 13 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic - aggregation approximation :: FS FPU Pipe Active */
double
acmgt1__render_basic__ps_fpu_active__read(const struct intel_xe_perf *perf,
                                          const struct intel_xe_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: A 14 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 14];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic - aggregation approximation :: FS EM Pipe Active */
double
acmgt1__render_basic__ps_em_active__read(const struct intel_xe_perf *perf,
                                         const struct intel_xe_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 15];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic - aggregation approximation :: FS Send Pipe Active */
double
acmgt1__render_basic__ps_send_active__read(const struct intel_xe_perf *perf,
                                           const struct intel_xe_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 16];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic - aggregation approximation :: SLM Bytes Read */
uint64_t
acmgt1__render_basic__slm_reads__read(const struct intel_xe_perf *perf,
                                      const struct intel_xe_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 30 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 30];

    return tmp0;
}

/* Render Metrics Basic - aggregation approximation :: SLM Bytes Read */
uint64_t
acmgt1__render_basic__slm_reads__max(const struct intel_xe_perf *perf,
                                     const struct intel_xe_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks $XeCoreTotalCount UMUL */
    uint64_t tmp0 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eu_sub_slices;

    return tmp0;
}

/* Render Metrics Basic - aggregation approximation :: SLM Writes */
uint64_t
acmgt1__render_basic__slm_writes__read(const struct intel_xe_perf *perf,
                                       const struct intel_xe_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: A 31 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 31];

    return tmp0;
}

/* Render Metrics Basic - aggregation approximation :: GTI Read Throughput */
uint64_t
acmgt1__render_basic__gti_read_throughput__read(const struct intel_xe_perf *perf,
                                                const struct intel_xe_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: 128  A 36 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 36];
    uint64_t tmp1 = 128 * tmp0;

    return tmp1;
}

/* Render Metrics Basic - aggregation approximation :: GTI Read Throughput */
uint64_t
acmgt1__render_basic__gti_read_throughput__max(const struct intel_xe_perf *perf,
                                               const struct intel_xe_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 512 UMUL */
    uint64_t tmp0 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 512;

    return tmp0;
}

/* Render Metrics Basic - aggregation approximation :: GTI Write Throughput */
uint64_t
acmgt1__render_basic__gti_write_throughput__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: C 6 READ C 7 READ UADD 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 128;

    return tmp3;
}

/* Render Metrics Basic - aggregation approximation :: Sampler Slice2 Xe Core0 is busy */
double
acmgt1__render_basic__sampler20_busy__read(const struct intel_xe_perf *perf,
                                           const struct intel_xe_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic - aggregation approximation :: Sampler20 Bottleneck */
double
acmgt1__render_basic__sampler20_bottleneck__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: C 4 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic - aggregation approximation :: GTI Write Throughput */
uint64_t
acmgt2__render_basic__gti_write_throughput__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 128  A 37 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 37];
    uint64_t tmp1 = 128 * tmp0;

    return tmp1;
}

/* Render Metrics Basic - aggregation approximation :: Sampler Slice2 Xe Core0 is busy */
double
acmgt2__render_basic__sampler20_busy__read(const struct intel_xe_perf *perf,
                                           const struct intel_xe_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = acmgt2__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic - aggregation approximation :: Sampler20 Bottleneck */
double
acmgt2__render_basic__sampler20_bottleneck__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = acmgt2__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic :: Sampler Slice0 Xe Core0 is busy */
double
acmgt3__render_basic__sampler00_busy__read(const struct intel_xe_perf *perf,
                                           const struct intel_xe_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: B 7 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = acmgt3__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic :: Sampler00 Bottleneck */
double
acmgt3__render_basic__sampler00_bottleneck__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: B 6 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = acmgt3__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Compute Metrics Basic :: SLM Reads */
uint64_t
pvc__compute_basic__slm_reads__max(const struct intel_xe_perf *perf,
                                   const struct intel_xe_perf_metric_set *metric_set,
                                   uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks $EuSubslicesTotalCount UMUL */
    uint64_t tmp0 = pvc__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eu_sub_slices;

    return tmp0;
}

/* Compute Metrics Basic :: EU FPU Pipe Active */
double
pvc__compute_basic__eu_inst_executed_alu0_all__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 9];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = pvc__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Compute Metrics Basic :: EU Thread Occupancy */
double
pvc__compute_basic__eu_threads_occupancy_all__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: 8 A 16 READ FMUL $EuThreadsCount FDIV $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 16];
    double tmp1 = 8 * tmp0;
    double tmp2 = tmp1;
    double tmp3 = perf->devinfo.eu_threads_count;
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4;
    uint64_t tmp6 = perf->devinfo.n_eus;
    uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
    uint64_t tmp8 = tmp7 * 100;
    double tmp9 = tmp8;
    double tmp10 = pvc__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

    return tmp11;
}

/* Compute Metrics Basic :: SYSMEM_TRANSACTION_READ */
uint64_t
pvc__compute_basic__sysmem_transaction_read__read(const struct intel_xe_perf *perf,
                                                  const struct intel_xe_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: C 7 READ */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];

    return tmp0;
}

/* Compute Metrics Basic :: SYSMEM_TRANSACTION_WRITE */
uint64_t
pvc__compute_basic__sysmem_transaction_write__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: C 6 READ */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];

    return tmp0;
}

/* Compute Metrics Basic :: HOST_TO_GPUMEM_TRANSACTION_READ */
uint64_t
pvc__compute_basic__host_to_gpumem_transaction_read__read(const struct intel_xe_perf *perf,
                                                          const struct intel_xe_perf_metric_set *metric_set,
                                                          uint64_t *accumulator)
{
    /* RPN equation: C 5 READ */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];

    return tmp0;
}

/* Compute Metrics Basic :: HOST_TO_GPUMEM_TRANSACTION_WRITE */
uint64_t
pvc__compute_basic__host_to_gpumem_transaction_write__read(const struct intel_xe_perf *perf,
                                                           const struct intel_xe_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: C 4 READ */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];

    return tmp0;
}

/* Compute Metrics Basic :: GPU_MEMORY_REQUEST_QUEUE_FULL _SQIDI0 */
double
pvc__compute_basic__gpu_memory_request_queue_full_sqidi0__read(const struct intel_xe_perf *perf,
                                                               const struct intel_xe_perf_metric_set *metric_set,
                                                               uint64_t *accumulator)
{
    /* RPN equation: C 3 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = pvc__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Compute Metrics Basic :: GPU_MEMORY_REQUEST_QUEUE_FULL _SQIDI1 */
double
pvc__compute_basic__gpu_memory_request_queue_full_sqidi1__read(const struct intel_xe_perf *perf,
                                                               const struct intel_xe_perf_metric_set *metric_set,
                                                               uint64_t *accumulator)
{
    /* RPN equation: C 2 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = pvc__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Compute Metrics Basic :: GPU_MEMORY_REQUEST_QUEUE_FULL _SQIDI2 */
double
pvc__compute_basic__gpu_memory_request_queue_full_sqidi2__read(const struct intel_xe_perf *perf,
                                                               const struct intel_xe_perf_metric_set *metric_set,
                                                               uint64_t *accumulator)
{
    /* RPN equation: C 1 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = pvc__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Compute Metrics Basic :: GPU_MEMORY_REQUEST_QUEUE_FULL _SQIDI3 */
double
pvc__compute_basic__gpu_memory_request_queue_full_sqidi3__read(const struct intel_xe_perf *perf,
                                                               const struct intel_xe_perf_metric_set *metric_set,
                                                               uint64_t *accumulator)
{
    /* RPN equation: C 0 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = pvc__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Compute Metrics Basic :: GPU_MEMORY_REQUEST_QUEUE_FULL _SQIDI12 */
double
pvc__compute_basic__gpu_memory_request_queue_full_sqidi12__read(const struct intel_xe_perf *perf,
                                                                const struct intel_xe_perf_metric_set *metric_set,
                                                                uint64_t *accumulator)
{
    /* RPN equation: B 5 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = pvc__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* TestOa :: EU Thread Occupancy */
double
pvc__test_oa__eu_thread_occupancy__read(const struct intel_xe_perf *perf,
                                        const struct intel_xe_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: 8 A 10 READ FMUL $EuThreadsCount FDIV $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 10];
    double tmp1 = 8 * tmp0;
    double tmp2 = tmp1;
    double tmp3 = perf->devinfo.eu_threads_count;
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4;
    uint64_t tmp6 = perf->devinfo.n_eus;
    uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
    uint64_t tmp8 = tmp7 * 100;
    double tmp9 = tmp8;
    double tmp10 = pvc__test_oa__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

    return tmp11;
}

/* TestOa :: Gti Read Transactions */
uint64_t
pvc__test_oa__gti_read_transactions__read(const struct intel_xe_perf *perf,
                                          const struct intel_xe_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: A 36 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 36];

    return tmp0;
}

/* TestOa :: Gti Read Transactions */
uint64_t
pvc__test_oa__gti_read_transactions__max(const struct intel_xe_perf *perf,
                                         const struct intel_xe_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks $EuSlicesTotalCount 4 UGT 8 UMUL $EuSlicesTotalCount 4 ULTE $EuSlicesTotalCount 1 UADD 0x6 AND UMUL UADD UMUL */
    uint64_t tmp0 = perf->devinfo.n_eu_slices > 4;
    uint64_t tmp1 = tmp0 * 8;
    uint64_t tmp2 = perf->devinfo.n_eu_slices <= 4;
    uint64_t tmp3 = perf->devinfo.n_eu_slices + 1;
    uint64_t tmp4 = tmp3 & 0x6;
    uint64_t tmp5 = tmp2 * tmp4;
    uint64_t tmp6 = tmp1 + tmp5;
    uint64_t tmp7 = pvc__test_oa__gpu_core_clocks__read(perf, metric_set, accumulator) * tmp6;

    return tmp7;
}

/* TestOa :: GTI Write Transactions */
uint64_t
pvc__test_oa__gti_write_transactions__read(const struct intel_xe_perf *perf,
                                           const struct intel_xe_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: A 37 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 37];

    return tmp0;
}

/* Render Metrics Basic :: GTI Read Throughput */
uint64_t
mtlgt2__render_basic__gti_read_throughput__read(const struct intel_xe_perf *perf,
                                                const struct intel_xe_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: 32  A 36 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 36];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Render Metrics Basic :: GTI Write Throughput */
uint64_t
mtlgt2__render_basic__gti_write_throughput__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 32  A 37 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 37];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* RenderBasic :: GPU Busy */
double
lnl__render_basic__gpu_busy__read(const struct intel_xe_perf *perf,
                                  const struct intel_xe_perf_metric_set *metric_set,
                                  uint64_t *accumulator)
{
    /* RPN equation: PEC 32 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 32];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = lnl__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* RenderBasic :: IA Vertex */
uint64_t
lnl__render_basic__ia_vertex__read(const struct intel_xe_perf *perf,
                                   const struct intel_xe_perf_metric_set *metric_set,
                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 33 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 33];

    return tmp0;
}

/* RenderBasic :: GpGpu Threadgroup Count */
uint64_t
lnl__render_basic__gpgpu_threadgroup_count__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: PEC 0 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 0];

    return tmp0;
}

/* RenderBasic :: Async GpGpu Threadgroup Count */
uint64_t
lnl__render_basic__async_gpgpu_threadgroup_count__read(const struct intel_xe_perf *perf,
                                                       const struct intel_xe_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: PEC 1 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 1];

    return tmp0;
}

/* RenderBasic :: Rasterizer Sample Output */
uint64_t
lnl__render_basic__rasterizer_sample_output__read(const struct intel_xe_perf *perf,
                                                  const struct intel_xe_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: PEC 34 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 34];

    return tmp0;
}

/* RenderBasic :: Pixel Blend */
uint64_t
lnl__render_basic__pixel_blend__read(const struct intel_xe_perf *perf,
                                     const struct intel_xe_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 35 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 35];

    return tmp0;
}

/* RenderBasic :: Pixel Write */
uint64_t
lnl__render_basic__pixel_write__read(const struct intel_xe_perf *perf,
                                     const struct intel_xe_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 36 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 36];

    return tmp0;
}

/* RenderBasic :: PostPS Alpha Test Fail */
uint64_t
lnl__render_basic__postps_alpha_test_fail__read(const struct intel_xe_perf *perf,
                                                const struct intel_xe_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: PEC 2 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 2];

    return tmp0;
}

/* RenderBasic :: Shader Pix Kill */
uint64_t
lnl__render_basic__shader_pix_kill__read(const struct intel_xe_perf *perf,
                                         const struct intel_xe_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: PEC 3 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 3];

    return tmp0;
}

/* RenderBasic :: L3 Read */
uint64_t
lnl__render_basic__l3_read__read(const struct intel_xe_perf *perf,
                                 const struct intel_xe_perf_metric_set *metric_set,
                                 uint64_t *accumulator)
{
    /* RPN equation: PEC 37 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 37];

    return tmp0;
}

/* RenderBasic :: L3 Write */
uint64_t
lnl__render_basic__l3_write__read(const struct intel_xe_perf *perf,
                                  const struct intel_xe_perf_metric_set *metric_set,
                                  uint64_t *accumulator)
{
    /* RPN equation: PEC 38 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 38];

    return tmp0;
}

/* RenderBasic :: Command Parser Compute Engine Busy */
double
lnl__render_basic__command_parser_compute_engine_busy__read(const struct intel_xe_perf *perf,
                                                            const struct intel_xe_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: PEC 39 READ $ComputeEngineTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 39];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderBasic :: Command Parser Render Engine Busy */
double
lnl__render_basic__command_parser_render_engine_busy__read(const struct intel_xe_perf *perf,
                                                           const struct intel_xe_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: PEC 40 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 40];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = lnl__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* RenderBasic :: Command Parser Copy Engine Busy */
double
lnl__render_basic__command_parser_copy_engine_busy__read(const struct intel_xe_perf *perf,
                                                         const struct intel_xe_perf_metric_set *metric_set,
                                                         uint64_t *accumulator)
{
    /* RPN equation: PEC 41 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 41];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = lnl__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* RenderBasic :: Clipper Input Vertex */
uint64_t
lnl__render_basic__clipper_input_vertex__read(const struct intel_xe_perf *perf,
                                              const struct intel_xe_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: PEC 42 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 42];

    return tmp0;
}

/* RenderBasic :: Clipper Primitive Cull */
uint64_t
lnl__render_basic__clipper_primitive_cull__read(const struct intel_xe_perf *perf,
                                                const struct intel_xe_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: PEC 43 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 43];

    return tmp0;
}

/* RenderBasic :: Clipper Primitive Far Near Clip */
uint64_t
lnl__render_basic__clipper_primitive_far_near_clip__read(const struct intel_xe_perf *perf,
                                                         const struct intel_xe_perf_metric_set *metric_set,
                                                         uint64_t *accumulator)
{
    /* RPN equation: PEC 44 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 44];

    return tmp0;
}

/* RenderBasic :: Clipper Primitive Output */
uint64_t
lnl__render_basic__clipper_primitive_output__read(const struct intel_xe_perf *perf,
                                                  const struct intel_xe_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: PEC 45 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 45];

    return tmp0;
}

/* RenderBasic :: IA Primitive */
uint64_t
lnl__render_basic__ia_primitive__read(const struct intel_xe_perf *perf,
                                      const struct intel_xe_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: PEC 46 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 46];

    return tmp0;
}

/* RenderBasic :: Streamout Output Vertex Count */
uint64_t
lnl__render_basic__streamout_output_vertex_count__read(const struct intel_xe_perf *perf,
                                                       const struct intel_xe_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: PEC 47 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 47];

    return tmp0;
}

/* RenderBasic :: Stripsfan Object Count */
uint64_t
lnl__render_basic__stripsfan_object_count__read(const struct intel_xe_perf *perf,
                                                const struct intel_xe_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: PEC 48 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 48];

    return tmp0;
}

/* RenderBasic :: Stripsfan Object Cull */
uint64_t
lnl__render_basic__stripsfan_object_cull__read(const struct intel_xe_perf *perf,
                                               const struct intel_xe_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: PEC 49 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 49];

    return tmp0;
}

/* RenderBasic :: Streamout Primitive Write Count */
uint64_t
lnl__render_basic__streamout_primitive_write_count__read(const struct intel_xe_perf *perf,
                                                         const struct intel_xe_perf_metric_set *metric_set,
                                                         uint64_t *accumulator)
{
    /* RPN equation: PEC 50 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 50];

    return tmp0;
}

/* RenderBasic :: SLM Bank Conflict Count */
uint64_t
lnl__render_basic__slm_bank_conflict_count__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: PEC 4 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 4];

    return tmp0;
}

/* RenderBasic :: Compressor Input */
uint64_t
lnl__render_basic__compressor_input__read(const struct intel_xe_perf *perf,
                                          const struct intel_xe_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: PEC 51 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 51];

    return tmp0;
}

/* RenderBasic :: Compressor Output */
uint64_t
lnl__render_basic__compressor_output__read(const struct intel_xe_perf *perf,
                                           const struct intel_xe_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: PEC 52 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 52];

    return tmp0;
}

/* RenderBasic :: TLB Miss */
uint64_t
lnl__render_basic__tlb_miss__read(const struct intel_xe_perf *perf,
                                  const struct intel_xe_perf_metric_set *metric_set,
                                  uint64_t *accumulator)
{
    /* RPN equation: PEC 53 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 53];

    return tmp0;
}

/* RenderBasic :: Sampler 2x2 Read */
uint64_t
lnl__render_basic__sampler_2_x2_read__read(const struct intel_xe_perf *perf,
                                           const struct intel_xe_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: PEC 5 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 5];

    return tmp0;
}

/* RenderBasic :: Sampler Texture Cache Access */
uint64_t
lnl__render_basic__sampler_texture_cache_access__read(const struct intel_xe_perf *perf,
                                                      const struct intel_xe_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: PEC 6 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 6];

    return tmp0;
}

/* RenderBasic :: Sampler Texture Cache Miss */
uint64_t
lnl__render_basic__sampler_texture_cache_miss__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 21 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 21];

    return tmp0;
}

/* RenderBasic :: URB Read */
uint64_t
lnl__render_basic__urb_read__read(const struct intel_xe_perf *perf,
                                  const struct intel_xe_perf_metric_set *metric_set,
                                  uint64_t *accumulator)
{
    /* RPN equation: PEC 55 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 55];

    return tmp0;
}

/* RenderBasic :: URB Write */
uint64_t
lnl__render_basic__urb_write__read(const struct intel_xe_perf *perf,
                                   const struct intel_xe_perf_metric_set *metric_set,
                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 56 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 56];

    return tmp0;
}

/* RenderBasic :: ICache Hit */
uint64_t
lnl__render_basic__icache_hit__read(const struct intel_xe_perf *perf,
                                    const struct intel_xe_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 22 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 22];

    return tmp0;
}

/* RenderBasic :: ICache Miss */
uint64_t
lnl__render_basic__icache_miss__read(const struct intel_xe_perf *perf,
                                     const struct intel_xe_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 23 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 23];

    return tmp0;
}

/* RenderBasic :: XVE Active */
double
lnl__render_basic__xve_active__read(const struct intel_xe_perf *perf,
                                    const struct intel_xe_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 24 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 24];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderBasic :: XVE Inst Executed ALU0 All */
uint64_t
lnl__render_basic__xve_inst_executed_alu0_all__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 25 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 25];

    return tmp0;
}

/* RenderBasic :: XVE Inst Executed ALU1 All */
uint64_t
lnl__render_basic__xve_inst_executed_alu1_all__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 26 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 26];

    return tmp0;
}

/* RenderBasic :: XVE Inst Executed Send All */
uint64_t
lnl__render_basic__xve_inst_executed_send_all__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 7 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 7];

    return tmp0;
}

/* RenderBasic :: XVE Inst Executed ALU0 CS */
uint64_t
lnl__render_basic__xve_inst_executed_alu0_cs__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 8 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 8];

    return tmp0;
}

/* RenderBasic :: XVE Inst Executed ALU0 PS */
uint64_t
lnl__render_basic__xve_inst_executed_alu0_ps__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 9 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 9];

    return tmp0;
}

/* RenderBasic :: XVE Inst Executed ALU0 VS */
uint64_t
lnl__render_basic__xve_inst_executed_alu0_vs__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 10 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 10];

    return tmp0;
}

/* RenderBasic :: XVE Inst Executed ALU1 CS */
uint64_t
lnl__render_basic__xve_inst_executed_alu1_cs__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 11 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 11];

    return tmp0;
}

/* RenderBasic :: XVE Inst Executed ALU1 PS */
uint64_t
lnl__render_basic__xve_inst_executed_alu1_ps__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 12 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 12];

    return tmp0;
}

/* RenderBasic :: XVE Inst Executed ALU1 VS */
uint64_t
lnl__render_basic__xve_inst_executed_alu1_vs__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 13 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 13];

    return tmp0;
}

/* RenderBasic :: XVE Shared Function Access Hold */
double
lnl__render_basic__xve_shared_function_access_hold__read(const struct intel_xe_perf *perf,
                                                         const struct intel_xe_perf_metric_set *metric_set,
                                                         uint64_t *accumulator)
{
    /* RPN equation: PEC 27 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 27];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderBasic :: RT BVH Cache Miss */
uint64_t
lnl__render_basic__rt_bvh_cache_miss__read(const struct intel_xe_perf *perf,
                                           const struct intel_xe_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: PEC 28 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 28];

    return tmp0;
}

/* RenderBasic :: RT Input Message Ray Count */
uint64_t
lnl__render_basic__rt_input_message_ray_count__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 29 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 29];

    return tmp0;
}

/* RenderBasic :: Load Store Cache Hit */
uint64_t
lnl__render_basic__load_store_cache_hit__read(const struct intel_xe_perf *perf,
                                              const struct intel_xe_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: PEC 30 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 30];

    return tmp0;
}

/* RenderBasic :: Load Store Cache Access */
uint64_t
lnl__render_basic__load_store_cache_access__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: PEC 31 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 31];

    return tmp0;
}

/* RenderBasic :: XVE Threads Occupancy All */
double
lnl__render_basic__xve_threads_occupancy_all__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 14 READ 8 UMUL $VectorEngineThreadsCount $VectorEngineTotalCount UMUL UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 14];
    uint64_t tmp1 = tmp0 * 8;
    uint64_t tmp2 = perf->devinfo.eu_threads_count * perf->devinfo.n_eus;
    uint64_t tmp3 = tmp1;
    uint64_t tmp4 = tmp2;
    uint64_t tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = lnl__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* RenderBasic :: XVE Inst Issued All */
uint64_t
lnl__render_basic__xve_inst_issued_all__read(const struct intel_xe_perf *perf,
                                             const struct intel_xe_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: PEC 15 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 15];

    return tmp0;
}

/* RenderBasic :: GPU Memory Byte Read */
uint64_t
lnl__render_basic__gpu_memory_byte_read__read(const struct intel_xe_perf *perf,
                                              const struct intel_xe_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: PEC 57 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 57];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* RenderBasic :: GPU Memory Byte Write */
uint64_t
lnl__render_basic__gpu_memory_byte_write__read(const struct intel_xe_perf *perf,
                                               const struct intel_xe_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: PEC 58 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 58];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* RenderBasic :: Load Store Cache Byte Read */
uint64_t
lnl__render_basic__load_store_cache_byte_read__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 16 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 16];

    return tmp0;
}

/* RenderBasic :: Load Store Cache Byte Write */
uint64_t
lnl__render_basic__load_store_cache_byte_write__read(const struct intel_xe_perf *perf,
                                                     const struct intel_xe_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 17 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 17];

    return tmp0;
}

/* RenderBasic :: SLM Byte Read */
uint64_t
lnl__render_basic__slm_byte_read__read(const struct intel_xe_perf *perf,
                                       const struct intel_xe_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: PEC 18 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 18];

    return tmp0;
}

/* RenderBasic :: SLM Byte Write */
uint64_t
lnl__render_basic__slm_byte_write__read(const struct intel_xe_perf *perf,
                                        const struct intel_xe_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: PEC 19 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 19];

    return tmp0;
}

/* RenderBasic :: GPU Memory Byte Read Rate */
double
lnl__render_basic__gpu_memory_byte_read_rate__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 57 READ 2 UMUL $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 57];
    uint64_t tmp1 = tmp0 * 2;
    double tmp2 = tmp1;
    double tmp3 = lnl__render_basic__gpu_time__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* RenderBasic :: GPU Memory Byte Write Rate */
double
lnl__render_basic__gpu_memory_byte_write_rate__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 58 READ 2 UMUL $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 58];
    uint64_t tmp1 = tmp0 * 2;
    double tmp2 = tmp1;
    double tmp3 = lnl__render_basic__gpu_time__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* RenderBasic :: XVE Stall */
double
lnl__render_basic__xve_stall__read(const struct intel_xe_perf *perf,
                                   const struct intel_xe_perf_metric_set *metric_set,
                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 20 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 20];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderBasic :: XVE Inst Executed ALU0 All Utilization */
double
lnl__render_basic__xve_inst_executed_alu0_all_utilization__read(const struct intel_xe_perf *perf,
                                                                const struct intel_xe_perf_metric_set *metric_set,
                                                                uint64_t *accumulator)
{
    /* RPN equation: PEC 25 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 25];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderBasic :: XVE Inst Executed ALU1 All Utilization */
double
lnl__render_basic__xve_inst_executed_alu1_all_utilization__read(const struct intel_xe_perf *perf,
                                                                const struct intel_xe_perf_metric_set *metric_set,
                                                                uint64_t *accumulator)
{
    /* RPN equation: PEC 26 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 26];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* ComputeBasic :: XVE Active */
double
lnl__compute_basic__xve_active__read(const struct intel_xe_perf *perf,
                                     const struct intel_xe_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 4 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 4];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* ComputeBasic :: XVE Shared Function Access Hold */
double
lnl__compute_basic__xve_shared_function_access_hold__read(const struct intel_xe_perf *perf,
                                                          const struct intel_xe_perf_metric_set *metric_set,
                                                          uint64_t *accumulator)
{
    /* RPN equation: PEC 22 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 22];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* ComputeBasic :: XVE Stall */
double
lnl__compute_basic__xve_stall__read(const struct intel_xe_perf *perf,
                                    const struct intel_xe_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 23 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 23];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* ComputeBasic :: XVE Threads Occupancy All */
double
lnl__compute_basic__xve_threads_occupancy_all__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 8 READ 8 UMUL $VectorEngineThreadsCount $VectorEngineTotalCount UMUL UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 8];
    uint64_t tmp1 = tmp0 * 8;
    uint64_t tmp2 = perf->devinfo.eu_threads_count * perf->devinfo.n_eus;
    uint64_t tmp3 = tmp1;
    uint64_t tmp4 = tmp2;
    uint64_t tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = lnl__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* ComputeBasic :: XVE Inst Executed ALU2 All */
uint64_t
lnl__compute_basic__xve_inst_executed_alu2_all__read(const struct intel_xe_perf *perf,
                                                     const struct intel_xe_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 24 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 24];

    return tmp0;
}

/* ComputeBasic :: SLM Bank Conflict Count */
uint64_t
lnl__compute_basic__slm_bank_conflict_count__read(const struct intel_xe_perf *perf,
                                                  const struct intel_xe_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: PEC 27 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 27];

    return tmp0;
}

/* ComputeBasic :: L3 Write */
uint64_t
lnl__compute_basic__l3_write__read(const struct intel_xe_perf *perf,
                                   const struct intel_xe_perf_metric_set *metric_set,
                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 39 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 39];

    return tmp0;
}

/* ComputeBasic :: Compressor Input */
uint64_t
lnl__compute_basic__compressor_input__read(const struct intel_xe_perf *perf,
                                           const struct intel_xe_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: PEC 41 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 41];

    return tmp0;
}

/* ComputeBasic :: GPU Memory Byte Read */
uint64_t
lnl__compute_basic__gpu_memory_byte_read__read(const struct intel_xe_perf *perf,
                                               const struct intel_xe_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: PEC 43 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 43];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* ComputeBasic :: GPU Memory Byte Write */
uint64_t
lnl__compute_basic__gpu_memory_byte_write__read(const struct intel_xe_perf *perf,
                                                const struct intel_xe_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: PEC 44 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 44];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* ComputeBasic :: GPU Memory Byte Read Rate */
double
lnl__compute_basic__gpu_memory_byte_read_rate__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 43 READ 2 UMUL $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 43];
    uint64_t tmp1 = tmp0 * 2;
    double tmp2 = tmp1;
    double tmp3 = lnl__compute_basic__gpu_time__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* ComputeBasic :: GPU Memory Byte Write Rate */
double
lnl__compute_basic__gpu_memory_byte_write_rate__read(const struct intel_xe_perf *perf,
                                                     const struct intel_xe_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 44 READ 2 UMUL $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 44];
    uint64_t tmp1 = tmp0 * 2;
    double tmp2 = tmp1;
    double tmp3 = lnl__compute_basic__gpu_time__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* ComputeBasic :: GpGpu Dispatch */
double
lnl__compute_basic__gpgpu_dispatch__read(const struct intel_xe_perf *perf,
                                         const struct intel_xe_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: PEC 12 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 12];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* ComputeBasic :: Command Parser Compute Engine Busy */
double
lnl__compute_basic__command_parser_compute_engine_busy__read(const struct intel_xe_perf *perf,
                                                             const struct intel_xe_perf_metric_set *metric_set,
                                                             uint64_t *accumulator)
{
    /* RPN equation: PEC 49 READ $ComputeEngineTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 49];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* ComputeBasic :: Command Parser Copy Engine Busy */
double
lnl__compute_basic__command_parser_copy_engine_busy__read(const struct intel_xe_perf *perf,
                                                          const struct intel_xe_perf_metric_set *metric_set,
                                                          uint64_t *accumulator)
{
    /* RPN equation: PEC 51 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 51];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = lnl__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* ComputeBasic :: Command Parser Render Engine Busy */
double
lnl__compute_basic__command_parser_render_engine_busy__read(const struct intel_xe_perf *perf,
                                                            const struct intel_xe_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: PEC 53 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 53];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = lnl__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* ComputeBasic :: Command Parser Render Engine Dispatch Kernel Count */
uint64_t
lnl__compute_basic__command_parser_render_engine_dispatch_kernel_count__read(const struct intel_xe_perf *perf,
                                                                             const struct intel_xe_perf_metric_set *metric_set,
                                                                             uint64_t *accumulator)
{
    /* RPN equation: PEC 54 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 54];

    return tmp0;
}

/* ComputeBasic :: XVE Pipe ALU0 And ALU1 Active */
double
lnl__compute_basic__xve_pipe_alu0_and_alu1_active__read(const struct intel_xe_perf *perf,
                                                        const struct intel_xe_perf_metric_set *metric_set,
                                                        uint64_t *accumulator)
{
    /* RPN equation: PEC 13 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 13];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* ComputeBasic :: XVE Pipe ALU0 And ALU2 Active */
double
lnl__compute_basic__xve_pipe_alu0_and_alu2_active__read(const struct intel_xe_perf *perf,
                                                        const struct intel_xe_perf_metric_set *metric_set,
                                                        uint64_t *accumulator)
{
    /* RPN equation: PEC 14 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 14];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* ComputeBasic :: XVE Inst Executed ALU0 All Utilization */
double
lnl__compute_basic__xve_inst_executed_alu0_all_utilization__read(const struct intel_xe_perf *perf,
                                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: PEC 5 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 5];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* ComputeBasic :: XVE Inst Executed ALU1 All Utilization */
double
lnl__compute_basic__xve_inst_executed_alu1_all_utilization__read(const struct intel_xe_perf *perf,
                                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: PEC 6 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 6];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* DepthProfile :: HiZ Depth Test Fail P */
uint64_t
lnl__depth_profile__hiz_depth_test_fail_p__read(const struct intel_xe_perf *perf,
                                                const struct intel_xe_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: PEC 40 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 40];

    return tmp0;
}

/* DepthProfile :: HiZ Subspan Latency Fifofull */
double
lnl__depth_profile__hiz_subspan_latency_fifofull__read(const struct intel_xe_perf *perf,
                                                       const struct intel_xe_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: PEC 42 READ $SliceTotalCount 2 UMUL UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 42];
    uint64_t tmp1 = perf->devinfo.n_eu_slices * 2;
    uint64_t tmp2 = tmp0;
    uint64_t tmp3 = tmp1;
    uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4 * 100;
    double tmp6 = tmp5;
    double tmp7 = lnl__depth_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}

/* DepthProfile :: IZ Output Ready */
double
lnl__depth_profile__iz_output_ready__read(const struct intel_xe_perf *perf,
                                          const struct intel_xe_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: PEC 43 READ $SliceTotalCount 2 UMUL UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 43];
    uint64_t tmp1 = perf->devinfo.n_eu_slices * 2;
    uint64_t tmp2 = tmp0;
    uint64_t tmp3 = tmp1;
    uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4 * 100;
    double tmp6 = tmp5;
    double tmp7 = lnl__depth_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}

/* DepthProfile :: IZ Subspan Latency Fifofull */
double
lnl__depth_profile__iz_subspan_latency_fifofull__read(const struct intel_xe_perf *perf,
                                                      const struct intel_xe_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: PEC 44 READ $SliceTotalCount 2 UMUL UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 44];
    uint64_t tmp1 = perf->devinfo.n_eu_slices * 2;
    uint64_t tmp2 = tmp0;
    uint64_t tmp3 = tmp1;
    uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4 * 100;
    double tmp6 = tmp5;
    double tmp7 = lnl__depth_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}

/* DeviceCacheProfile :: L3 Read */
uint64_t
lnl__device_cache_profile__l3_read__read(const struct intel_xe_perf *perf,
                                         const struct intel_xe_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: PEC 57 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 57];

    return tmp0;
}

/* DeviceCacheProfile :: L3 Write */
uint64_t
lnl__device_cache_profile__l3_write__read(const struct intel_xe_perf *perf,
                                          const struct intel_xe_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: PEC 59 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 59];

    return tmp0;
}

/* DeviceCacheProfile :: GPU Memory L3 Read */
uint64_t
lnl__device_cache_profile__gpu_memory_l3_read__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 60 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 60];

    return tmp0;
}

/* DeviceCacheProfile :: GPU Memory L3 Write */
uint64_t
lnl__device_cache_profile__gpu_memory_l3_write__read(const struct intel_xe_perf *perf,
                                                     const struct intel_xe_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 61 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 61];

    return tmp0;
}

/* DeviceCacheProfile :: GPU Memory Read */
uint64_t
lnl__device_cache_profile__gpu_memory_read__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: PEC 62 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 62];

    return tmp0;
}

/* DeviceCacheProfile :: GPU Memory Write */
uint64_t
lnl__device_cache_profile__gpu_memory_write__read(const struct intel_xe_perf *perf,
                                                  const struct intel_xe_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: PEC 63 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 63];

    return tmp0;
}

/* MemoryProfile :: GPU Memory Byte Read */
uint64_t
lnl__memory_profile__gpu_memory_byte_read__read(const struct intel_xe_perf *perf,
                                                const struct intel_xe_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: PEC 41 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 41];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* MemoryProfile :: GPU Memory Byte Write */
uint64_t
lnl__memory_profile__gpu_memory_byte_write__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: PEC 42 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 42];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* MemoryProfile :: GPU Memory Byte Read Rate */
double
lnl__memory_profile__gpu_memory_byte_read_rate__read(const struct intel_xe_perf *perf,
                                                     const struct intel_xe_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 41 READ 2 UMUL $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 41];
    uint64_t tmp1 = tmp0 * 2;
    double tmp2 = tmp1;
    double tmp3 = lnl__memory_profile__gpu_time__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* MemoryProfile :: GPU Memory Byte Write Rate */
double
lnl__memory_profile__gpu_memory_byte_write_rate__read(const struct intel_xe_perf *perf,
                                                      const struct intel_xe_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: PEC 42 READ 2 UMUL $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 42];
    uint64_t tmp1 = tmp0 * 2;
    double tmp2 = tmp1;
    double tmp3 = lnl__memory_profile__gpu_time__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* MemoryProfile :: Load Store Cache Input Available */
double
lnl__memory_profile__load_store_cache_input_available__read(const struct intel_xe_perf *perf,
                                                            const struct intel_xe_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: PEC 6 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 6];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__memory_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* MemoryProfile :: Load Store Cache Output Ready */
double
lnl__memory_profile__load_store_cache_output_ready__read(const struct intel_xe_perf *perf,
                                                         const struct intel_xe_perf_metric_set *metric_set,
                                                         uint64_t *accumulator)
{
    /* RPN equation: PEC 22 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 22];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__memory_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* MemoryProfile :: Copy Engine Request Stall */
double
lnl__memory_profile__copy_engine_request_stall__read(const struct intel_xe_perf *perf,
                                                     const struct intel_xe_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 58 READ $CopyEngineTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 58];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__memory_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Clipper Input Available */
double
lnl__render_pipe_profile__clipper_input_available__read(const struct intel_xe_perf *perf,
                                                        const struct intel_xe_perf_metric_set *metric_set,
                                                        uint64_t *accumulator)
{
    /* RPN equation: PEC 35 READ $SliceTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 35];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Clipper Output Ready */
double
lnl__render_pipe_profile__clipper_output_ready__read(const struct intel_xe_perf *perf,
                                                     const struct intel_xe_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 36 READ $SliceTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 36];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Stripsfan Output Ready */
double
lnl__render_pipe_profile__stripsfan_output_ready__read(const struct intel_xe_perf *perf,
                                                       const struct intel_xe_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: PEC 39 READ $SliceTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 39];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Vertex Fetch Input Available */
double
lnl__render_pipe_profile__vertex_fetch_input_available__read(const struct intel_xe_perf *perf,
                                                             const struct intel_xe_perf_metric_set *metric_set,
                                                             uint64_t *accumulator)
{
    /* RPN equation: PEC 40 READ $SliceTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 40];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Vertex Fetch Output Ready */
double
lnl__render_pipe_profile__vertex_fetch_output_ready__read(const struct intel_xe_perf *perf,
                                                          const struct intel_xe_perf_metric_set *metric_set,
                                                          uint64_t *accumulator)
{
    /* RPN equation: PEC 41 READ $SliceTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 41];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: VS Output Ready */
double
lnl__render_pipe_profile__vs_output_ready__read(const struct intel_xe_perf *perf,
                                                const struct intel_xe_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: PEC 42 READ $SliceTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 42];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Color Pipe Cache Latency2 Stall */
double
lnl__render_pipe_profile__color_pipe_cache_latency2_stall__read(const struct intel_xe_perf *perf,
                                                                const struct intel_xe_perf_metric_set *metric_set,
                                                                uint64_t *accumulator)
{
    /* RPN equation: PEC 44 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 44];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* RenderPipeProfile :: Pixel Post Process Input Available */
double
lnl__render_pipe_profile__pixel_post_process_input_available__read(const struct intel_xe_perf *perf,
                                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 45 READ $SliceTotalCount 2 UMUL UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 45];
    uint64_t tmp1 = perf->devinfo.n_eu_slices * 2;
    uint64_t tmp2 = tmp0;
    uint64_t tmp3 = tmp1;
    uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4 * 100;
    double tmp6 = tmp5;
    double tmp7 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}

/* RenderPipeProfile :: Pixel Post Process Output Ready */
double
lnl__render_pipe_profile__pixel_post_process_output_ready__read(const struct intel_xe_perf *perf,
                                                                const struct intel_xe_perf_metric_set *metric_set,
                                                                uint64_t *accumulator)
{
    /* RPN equation: PEC 46 READ $SliceTotalCount 2 UMUL UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 46];
    uint64_t tmp1 = perf->devinfo.n_eu_slices * 2;
    uint64_t tmp2 = tmp0;
    uint64_t tmp3 = tmp1;
    uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4 * 100;
    double tmp6 = tmp5;
    double tmp7 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}

/* RenderPipeProfile :: PS Output Available */
double
lnl__render_pipe_profile__ps_output_available__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 2 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 2];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: AMFS Stall All Input */
double
lnl__render_pipe_profile__amfs_stall_all_input__read(const struct intel_xe_perf *perf,
                                                     const struct intel_xe_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 49 READ $SliceTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 49];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: AMFS Stall Any Input */
double
lnl__render_pipe_profile__amfs_stall_any_input__read(const struct intel_xe_perf *perf,
                                                     const struct intel_xe_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 50 READ $SliceTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 50];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Sampler Active */
double
lnl__render_pipe_profile__sampler_active__read(const struct intel_xe_perf *perf,
                                               const struct intel_xe_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: PEC 3 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 3];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Sampler Input Available */
double
lnl__render_pipe_profile__sampler_input_available__read(const struct intel_xe_perf *perf,
                                                        const struct intel_xe_perf_metric_set *metric_set,
                                                        uint64_t *accumulator)
{
    /* RPN equation: PEC 4 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 4];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Sampler Memory Latency Stall */
double
lnl__render_pipe_profile__sampler_memory_latency_stall__read(const struct intel_xe_perf *perf,
                                                             const struct intel_xe_perf_metric_set *metric_set,
                                                             uint64_t *accumulator)
{
    /* RPN equation: PEC 5 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 5];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Rasterizer Input Available */
double
lnl__render_pipe_profile__rasterizer_input_available__read(const struct intel_xe_perf *perf,
                                                           const struct intel_xe_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: PEC 51 READ $SliceTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 51];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Rasterizer Output Ready */
double
lnl__render_pipe_profile__rasterizer_output_ready__read(const struct intel_xe_perf *perf,
                                                        const struct intel_xe_perf_metric_set *metric_set,
                                                        uint64_t *accumulator)
{
    /* RPN equation: PEC 52 READ $SliceTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 52];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Thread Dispatch Input Available */
double
lnl__render_pipe_profile__thread_dispatch_input_available__read(const struct intel_xe_perf *perf,
                                                                const struct intel_xe_perf_metric_set *metric_set,
                                                                uint64_t *accumulator)
{
    /* RPN equation: PEC 23 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 23];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Thread Dispatch PS Active */
double
lnl__render_pipe_profile__thread_dispatch_ps_active__read(const struct intel_xe_perf *perf,
                                                          const struct intel_xe_perf_metric_set *metric_set,
                                                          uint64_t *accumulator)
{
    /* RPN equation: PEC 24 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 24];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Thread Dispatch Queue0 Active */
double
lnl__render_pipe_profile__thread_dispatch_queue0_active__read(const struct intel_xe_perf *perf,
                                                              const struct intel_xe_perf_metric_set *metric_set,
                                                              uint64_t *accumulator)
{
    /* RPN equation: PEC 25 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 25];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Thread Dispatch Queue0 Stall */
double
lnl__render_pipe_profile__thread_dispatch_queue0_stall__read(const struct intel_xe_perf *perf,
                                                             const struct intel_xe_perf_metric_set *metric_set,
                                                             uint64_t *accumulator)
{
    /* RPN equation: PEC 26 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 26];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Thread Dispatch Queue1 Active */
double
lnl__render_pipe_profile__thread_dispatch_queue1_active__read(const struct intel_xe_perf *perf,
                                                              const struct intel_xe_perf_metric_set *metric_set,
                                                              uint64_t *accumulator)
{
    /* RPN equation: PEC 27 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 27];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Thread Dispatch Queue1 Stall */
double
lnl__render_pipe_profile__thread_dispatch_queue1_stall__read(const struct intel_xe_perf *perf,
                                                             const struct intel_xe_perf_metric_set *metric_set,
                                                             uint64_t *accumulator)
{
    /* RPN equation: PEC 28 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 28];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Threadgroup Dispatch Queue0 Resource Stall */
double
lnl__render_pipe_profile__threadgroup_dispatch_queue0_resource_stall__read(const struct intel_xe_perf *perf,
                                                                           const struct intel_xe_perf_metric_set *metric_set,
                                                                           uint64_t *accumulator)
{
    /* RPN equation: PEC 29 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 29];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RenderPipeProfile :: Threadgroup Dispatch Queue1 Resource Stall */
double
lnl__render_pipe_profile__threadgroup_dispatch_queue1_resource_stall__read(const struct intel_xe_perf *perf,
                                                                           const struct intel_xe_perf_metric_set *metric_set,
                                                                           uint64_t *accumulator)
{
    /* RPN equation: PEC 30 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 30];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RTProfile :: RT Traversal Stall */
double
lnl__rt_profile__rt_traversal_stall__read(const struct intel_xe_perf *perf,
                                          const struct intel_xe_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: PEC 7 READ $XeCoreTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 7];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__rt_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* RTProfile :: XVE Inst Executed ALU1 RT MS */
uint64_t
lnl__rt_profile__xve_inst_executed_alu1_rt_ms__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 14 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 14];

    return tmp0;
}

/* RTProfile :: XVE Threads Occupancy All */
double
lnl__rt_profile__xve_threads_occupancy_all__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: PEC 15 READ 8 UMUL $VectorEngineThreadsCount $VectorEngineTotalCount UMUL UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 15];
    uint64_t tmp1 = tmp0 * 8;
    uint64_t tmp2 = perf->devinfo.eu_threads_count * perf->devinfo.n_eus;
    uint64_t tmp3 = tmp1;
    uint64_t tmp4 = tmp2;
    uint64_t tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = lnl__rt_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* VectorEngineProfile :: XVE Multiple Pipe Active */
double
lnl__vector_engine_profile__xve_multiple_pipe_active__read(const struct intel_xe_perf *perf,
                                                           const struct intel_xe_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: PEC 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 17];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__vector_engine_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* VectorEngineProfile :: XVE Pipe ALU0 And ALU1 Active */
double
lnl__vector_engine_profile__xve_pipe_alu0_and_alu1_active__read(const struct intel_xe_perf *perf,
                                                                const struct intel_xe_perf_metric_set *metric_set,
                                                                uint64_t *accumulator)
{
    /* RPN equation: PEC 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 18];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__vector_engine_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* VectorEngineProfile :: XVE Pipe ALU0 And ALU2 Active */
double
lnl__vector_engine_profile__xve_pipe_alu0_and_alu2_active__read(const struct intel_xe_perf *perf,
                                                                const struct intel_xe_perf_metric_set *metric_set,
                                                                uint64_t *accumulator)
{
    /* RPN equation: PEC 19 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 19];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__vector_engine_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* VectorEngineProfile :: XVE Threads Occupancy All */
double
lnl__vector_engine_profile__xve_threads_occupancy_all__read(const struct intel_xe_perf *perf,
                                                            const struct intel_xe_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: PEC 20 READ 8 UMUL $VectorEngineThreadsCount $VectorEngineTotalCount UMUL UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 20];
    uint64_t tmp1 = tmp0 * 8;
    uint64_t tmp2 = perf->devinfo.eu_threads_count * perf->devinfo.n_eus;
    uint64_t tmp3 = tmp1;
    uint64_t tmp4 = tmp2;
    uint64_t tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = lnl__vector_engine_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* VectorEngineProfile :: Command Parser Compute Engine Busy */
double
lnl__vector_engine_profile__command_parser_compute_engine_busy__read(const struct intel_xe_perf *perf,
                                                                     const struct intel_xe_perf_metric_set *metric_set,
                                                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 45 READ $ComputeEngineTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 45];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__vector_engine_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* VectorEngineProfile :: Command Parser Render Engine Busy */
double
lnl__vector_engine_profile__command_parser_render_engine_busy__read(const struct intel_xe_perf *perf,
                                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 47 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 47];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = lnl__vector_engine_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* VectorEngineProfile :: GPU Memory Byte Read */
uint64_t
lnl__vector_engine_profile__gpu_memory_byte_read__read(const struct intel_xe_perf *perf,
                                                       const struct intel_xe_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: PEC 51 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 51];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* VectorEngineProfile :: GPU Memory Byte Write */
uint64_t
lnl__vector_engine_profile__gpu_memory_byte_write__read(const struct intel_xe_perf *perf,
                                                        const struct intel_xe_perf_metric_set *metric_set,
                                                        uint64_t *accumulator)
{
    /* RPN equation: PEC 52 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 52];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* VectorEngineProfile :: GPU Memory Byte Read Rate */
double
lnl__vector_engine_profile__gpu_memory_byte_read_rate__read(const struct intel_xe_perf *perf,
                                                            const struct intel_xe_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: PEC 51 READ 2 UMUL $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 51];
    uint64_t tmp1 = tmp0 * 2;
    double tmp2 = tmp1;
    double tmp3 = lnl__vector_engine_profile__gpu_time__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* VectorEngineProfile :: GPU Memory Byte Write Rate */
double
lnl__vector_engine_profile__gpu_memory_byte_write_rate__read(const struct intel_xe_perf *perf,
                                                             const struct intel_xe_perf_metric_set *metric_set,
                                                             uint64_t *accumulator)
{
    /* RPN equation: PEC 52 READ 2 UMUL $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 52];
    uint64_t tmp1 = tmp0 * 2;
    double tmp2 = tmp1;
    double tmp3 = lnl__vector_engine_profile__gpu_time__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* VectorEngineStalls :: XVE Stall Aluwr */
double
lnl__vector_engine_stalls__xve_stall_aluwr__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: PEC 2 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 2];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__vector_engine_stalls__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* VectorEngineStalls :: XVE Stall Barrier */
double
lnl__vector_engine_stalls__xve_stall_barrier__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 3 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 3];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__vector_engine_stalls__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* VectorEngineStalls :: XVE Stall Pipestall */
double
lnl__vector_engine_stalls__xve_stall_pipestall__read(const struct intel_xe_perf *perf,
                                                     const struct intel_xe_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 21 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 21];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__vector_engine_stalls__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* VectorEngineStalls :: XVE Active */
double
lnl__vector_engine_stalls__xve_active__read(const struct intel_xe_perf *perf,
                                            const struct intel_xe_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: PEC 31 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 31];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__vector_engine_stalls__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* VectorEngineStalls :: XVE Shared Function Access Hold */
double
lnl__vector_engine_stalls__xve_shared_function_access_hold__read(const struct intel_xe_perf *perf,
                                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: PEC 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 7];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__vector_engine_stalls__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* VectorEngineStalls :: XVE Stall */
double
lnl__vector_engine_stalls__xve_stall__read(const struct intel_xe_perf *perf,
                                           const struct intel_xe_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: PEC 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 8];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__vector_engine_stalls__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* VectorEngineStalls :: XVE Threads Occupancy All */
double
lnl__vector_engine_stalls__xve_threads_occupancy_all__read(const struct intel_xe_perf *perf,
                                                           const struct intel_xe_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: PEC 9 READ 8 UMUL $VectorEngineThreadsCount $VectorEngineTotalCount UMUL UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 9];
    uint64_t tmp1 = tmp0 * 8;
    uint64_t tmp2 = perf->devinfo.eu_threads_count * perf->devinfo.n_eus;
    uint64_t tmp3 = tmp1;
    uint64_t tmp4 = tmp2;
    uint64_t tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = lnl__vector_engine_stalls__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* VectorEngineStalls :: XVE Multiple Pipe Active */
double
lnl__vector_engine_stalls__xve_multiple_pipe_active__read(const struct intel_xe_perf *perf,
                                                          const struct intel_xe_perf_metric_set *metric_set,
                                                          uint64_t *accumulator)
{
    /* RPN equation: PEC 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 10];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__vector_engine_stalls__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* VectorEngineStalls :: XVE Pipe ALU0 And ALU1 Active */
double
lnl__vector_engine_stalls__xve_pipe_alu0_and_alu1_active__read(const struct intel_xe_perf *perf,
                                                               const struct intel_xe_perf_metric_set *metric_set,
                                                               uint64_t *accumulator)
{
    /* RPN equation: PEC 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 11];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__vector_engine_stalls__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* VectorEngineStalls :: XVE Pipe ALU0 And ALU2 Active */
double
lnl__vector_engine_stalls__xve_pipe_alu0_and_alu2_active__read(const struct intel_xe_perf *perf,
                                                               const struct intel_xe_perf_metric_set *metric_set,
                                                               uint64_t *accumulator)
{
    /* RPN equation: PEC 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 12];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = lnl__vector_engine_stalls__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* TestOa :: Test Event1 Cycles Average */
uint64_t
lnl__test_oa__test_event1_cycles_average__read(const struct intel_xe_perf *perf,
                                               const struct intel_xe_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: PEC 2 READ $XeCoreTotalCount UDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 2];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eu_sub_slices;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* ComputeBasic :: SysMem Transaction Write */
uint64_t
bmg__compute_basic__sysmem_transaction_write__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 58 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 58];

    return tmp0;
}

/* RenderBasic :: XVE Threads Occupancy All */
double
ptl__render_basic__xve_threads_occupancy_all__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 14 READ $VectorEngineThreadsCount $VectorEngineTotalCount UMUL UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 14];
    uint64_t tmp1 = perf->devinfo.eu_threads_count * perf->devinfo.n_eus;
    uint64_t tmp2 = tmp0;
    uint64_t tmp3 = tmp1;
    uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4 * 100;
    double tmp6 = tmp5;
    double tmp7 = ptl__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}

/* RenderBasic :: GPU Memory Byte Read Rate */
double
ptl__render_basic__gpu_memory_byte_read_rate__read(const struct intel_xe_perf *perf,
                                                   const struct intel_xe_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: PEC 57 READ $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 57];
    double tmp1 = tmp0;
    double tmp2 = ptl__render_basic__gpu_time__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* RenderBasic :: GPU Memory Byte Write Rate */
double
ptl__render_basic__gpu_memory_byte_write_rate__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 58 READ $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 58];
    double tmp1 = tmp0;
    double tmp2 = ptl__render_basic__gpu_time__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* ComputeBasic :: XVE Threads Occupancy All */
double
ptl__compute_basic__xve_threads_occupancy_all__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 24 READ $VectorEngineThreadsCount $VectorEngineTotalCount UMUL UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 24];
    uint64_t tmp1 = perf->devinfo.eu_threads_count * perf->devinfo.n_eus;
    uint64_t tmp2 = tmp0;
    uint64_t tmp3 = tmp1;
    uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4 * 100;
    double tmp6 = tmp5;
    double tmp7 = ptl__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}

/* ComputeBasic :: GPU Memory Byte Read Rate */
double
ptl__compute_basic__gpu_memory_byte_read_rate__read(const struct intel_xe_perf *perf,
                                                    const struct intel_xe_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: PEC 43 READ $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 43];
    double tmp1 = tmp0;
    double tmp2 = ptl__compute_basic__gpu_time__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* ComputeBasic :: GPU Memory Byte Write Rate */
double
ptl__compute_basic__gpu_memory_byte_write_rate__read(const struct intel_xe_perf *perf,
                                                     const struct intel_xe_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 44 READ $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 44];
    double tmp1 = tmp0;
    double tmp2 = ptl__compute_basic__gpu_time__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* MemoryProfile :: GPU Memory Byte Read Rate */
double
ptl__memory_profile__gpu_memory_byte_read_rate__read(const struct intel_xe_perf *perf,
                                                     const struct intel_xe_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: PEC 41 READ $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 41];
    double tmp1 = tmp0;
    double tmp2 = ptl__memory_profile__gpu_time__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* MemoryProfile :: GPU Memory Byte Write Rate */
double
ptl__memory_profile__gpu_memory_byte_write_rate__read(const struct intel_xe_perf *perf,
                                                      const struct intel_xe_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: PEC 42 READ $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 42];
    double tmp1 = tmp0;
    double tmp2 = ptl__memory_profile__gpu_time__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* RTProfile :: XVE Threads Occupancy All */
double
ptl__rt_profile__xve_threads_occupancy_all__read(const struct intel_xe_perf *perf,
                                                 const struct intel_xe_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: PEC 15 READ $VectorEngineThreadsCount $VectorEngineTotalCount UMUL UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 15];
    uint64_t tmp1 = perf->devinfo.eu_threads_count * perf->devinfo.n_eus;
    uint64_t tmp2 = tmp0;
    uint64_t tmp3 = tmp1;
    uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4 * 100;
    double tmp6 = tmp5;
    double tmp7 = ptl__rt_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}

/* RTProfile :: RT Stoc Hit Transparent */
uint64_t
ptl__rt_profile__rt_stoc_hit_transparent__read(const struct intel_xe_perf *perf,
                                               const struct intel_xe_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: PEC 20 READ */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 20];

    return tmp0;
}

/* VectorEngineProfile :: XVE Threads Occupancy All */
double
ptl__vector_engine_profile__xve_threads_occupancy_all__read(const struct intel_xe_perf *perf,
                                                            const struct intel_xe_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: PEC 20 READ $VectorEngineThreadsCount $VectorEngineTotalCount UMUL UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 20];
    uint64_t tmp1 = perf->devinfo.eu_threads_count * perf->devinfo.n_eus;
    uint64_t tmp2 = tmp0;
    uint64_t tmp3 = tmp1;
    uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4 * 100;
    double tmp6 = tmp5;
    double tmp7 = ptl__vector_engine_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}

/* VectorEngineProfile :: GPU Memory Byte Read Rate */
double
ptl__vector_engine_profile__gpu_memory_byte_read_rate__read(const struct intel_xe_perf *perf,
                                                            const struct intel_xe_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: PEC 51 READ $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 51];
    double tmp1 = tmp0;
    double tmp2 = ptl__vector_engine_profile__gpu_time__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* VectorEngineProfile :: GPU Memory Byte Write Rate */
double
ptl__vector_engine_profile__gpu_memory_byte_write_rate__read(const struct intel_xe_perf *perf,
                                                             const struct intel_xe_perf_metric_set *metric_set,
                                                             uint64_t *accumulator)
{
    /* RPN equation: PEC 52 READ $GpuTime FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 52];
    double tmp1 = tmp0;
    double tmp2 = ptl__vector_engine_profile__gpu_time__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* VectorEngineStalls :: XVE Threads Occupancy All */
double
ptl__vector_engine_stalls__xve_threads_occupancy_all__read(const struct intel_xe_perf *perf,
                                                           const struct intel_xe_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: PEC 9 READ $VectorEngineThreadsCount $VectorEngineTotalCount UMUL UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->pec_offset + 9];
    uint64_t tmp1 = perf->devinfo.eu_threads_count * perf->devinfo.n_eus;
    uint64_t tmp2 = tmp0;
    uint64_t tmp3 = tmp1;
    uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4 * 100;
    double tmp6 = tmp5;
    double tmp7 = ptl__vector_engine_stalls__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}
