/* Autogenerated file, DO NOT EDIT manually! generated by oa-metricset-codegen.py */
// SPDX-License-Identifier: MIT
/*
 * Copyright © 2024 Intel Corporation
 */

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>

#include "xe_oa_metrics_bmg.h"
#include "xe_oa_equations.h"
#include "xe_oa_registers_bmg.h"


static void
bmg_add_render_basic_metric_set(struct intel_xe_perf *perf)
{
    struct intel_xe_perf_metric_set *metric_set;
    struct intel_xe_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "RenderBasic";
    metric_set->symbol_name = "RenderBasic";
    metric_set->hw_config_guid = "f05e23fc-913d-4ab9-ba9a-43beb059a18c";
    metric_set->counters = calloc(69, sizeof(struct intel_xe_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = XE_OA_FORMAT_PEC64u64;

    metric_set->perf_raw_size = 576;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->pec_offset = 2;
    bmg_render_basic_add_registers(perf, metric_set);
    intel_xe_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_xe_perf_logical_counter _counters[] = {

            {
                .name = "Async GpGpu Threadgroup Count",
                .symbol_name = "ASYNC_GPGPU_THREADGROUP_COUNT",
                .desc = "Number of Async GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__async_gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bmg__render_basic__avg_gpu_core_frequency__read,
                .max_uint64 = bmg__render_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Clipper Input Vertex",
                .symbol_name = "CLIPPER_INPUT_VERTEX",
                .desc = "Number of Clipper input vertices",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__clipper_input_vertex__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Clipper Primitive Cull",
                .symbol_name = "CLIPPER_PRIMITIVE_CULL",
                .desc = "Number of Clipper early cull primitives",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__clipper_primitive_cull__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Clipper Primitive Far Near Clip",
                .symbol_name = "CLIPPER_PRIMITIVE_FAR_NEAR_CLIP",
                .desc = "Number of primitives clipped by Clipper due to near/far planes",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__clipper_primitive_far_near_clip__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Clipper Primitive Output",
                .symbol_name = "CLIPPER_PRIMITIVE_OUTPUT",
                .desc = "Number of primitives going out of Clipper, must clip plus the trivial accept. Must clip primitives are counted one time only.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__clipper_primitive_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Command Parser Compute Engine Busy",
                .symbol_name = "COMMAND_PARSER_COMPUTE_ENGINE_BUSY",
                .desc = "Percentage of time in which there is a context loaded and active on the compute queue",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_basic__command_parser_compute_engine_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "Command Parser Copy Engine Busy",
                .symbol_name = "COMMAND_PARSER_COPY_ENGINE_BUSY",
                .desc = "Percentage of time in which there is a context loaded and active on the copy queue.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_basic__command_parser_copy_engine_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "Command Parser Render Engine Busy",
                .symbol_name = "COMMAND_PARSER_RENDER_ENGINE_BUSY",
                .desc = "Percentage of time in which there is a context loaded and active on the 3D queue",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_basic__command_parser_render_engine_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "Compressor Input",
                .symbol_name = "COMPRESSOR_INPUT",
                .desc = "Number of 256B writes to compressible surfaces at the input of the compressor",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__compressor_input__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "Compressor Output",
                .symbol_name = "COMPRESSOR_OUTPUT",
                .desc = "Number of 256B writes to compressible surfaces at the output of the compressor",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__compressor_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GpGpu Threadgroup Count",
                .symbol_name = "GPGPU_THREADGROUP_COUNT",
                .desc = "Number of GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GPU_BUSY",
                .desc = "Percentage of time in which GPU is not idle including all GPU engines",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_basic__gpu_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "GPU Memory Byte Read",
                .symbol_name = "GPU_MEMORY_BYTE_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__render_basic__gpu_memory_byte_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory Byte Read Rate",
                .symbol_name = "GPU_MEMORY_BYTE_READ_RATE",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = bmg__render_basic__gpu_memory_byte_read_rate__read,
                .max_float = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory Byte Write",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__render_basic__gpu_memory_byte_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory Byte Write Rate",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE_RATE",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = bmg__render_basic__gpu_memory_byte_write_rate__read,
                .max_float = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__render_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bmg__render_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Host To GpuMem Transaction Read",
                .symbol_name = "HOST_TO_GPUMEM_TRANSACTION_READ",
                .desc = "Number of host 64B reads to GPU local (HBM) memory (downstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__host_to_gpumem_transaction_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "Host To GpuMem Transaction Write",
                .symbol_name = "HOST_TO_GPUMEM_TRANSACTION_WRITE",
                .desc = "Number of host 64B writes to GPU local (HBM) memory (downstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__host_to_gpumem_transaction_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "IA Primitive",
                .symbol_name = "IA_PRIMITIVE",
                .desc = "Number of primitives in a draw",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__ia_primitive__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "IA Vertex",
                .symbol_name = "IA_VERTEX",
                .desc = "Number of vertices in a draw",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__ia_vertex__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "ICache Hit",
                .symbol_name = "ICACHE_HIT",
                .desc = "Number of Instruction Cache hits",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__icache_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "ICache Miss",
                .symbol_name = "ICACHE_MISS",
                .desc = "Number of Instruction Cache misses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__icache_miss__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "L3 Read",
                .symbol_name = "L3_READ",
                .desc = "Number of Device Cache 64B read requests",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__l3_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Write",
                .symbol_name = "L3_WRITE",
                .desc = "Number of Device Cache 64B write requests",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__l3_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "Load Store Cache Access",
                .symbol_name = "LOAD_STORE_CACHE_ACCESS",
                .desc = "Number of Load Store Cache accesses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__load_store_cache_access__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Load Store Cache Byte Read",
                .symbol_name = "LOAD_STORE_CACHE_BYTE_READ",
                .desc = "Number of bytes read out of the Load Store Cache, excluding SLM accesses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__render_basic__load_store_cache_byte_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Load Store Cache Byte Write",
                .symbol_name = "LOAD_STORE_CACHE_BYTE_WRITE",
                .desc = "Number of bytes written to the Load Store Cache, excluding SLM accesses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__render_basic__load_store_cache_byte_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Load Store Cache Hit",
                .symbol_name = "LOAD_STORE_CACHE_HIT",
                .desc = "Number of Load Store Cache hits",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__load_store_cache_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Pixel Blend",
                .symbol_name = "PIXEL_BLEND",
                .desc = "Number of blended pixels written to all render targets",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__pixel_blend__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Color Pipe",
            },

            {
                .name = "Pixel Write",
                .symbol_name = "PIXEL_WRITE",
                .desc = "Number of pixels written to all render targets",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__pixel_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Color Pipe",
            },

            {
                .name = "PostPS Alpha Test Fail",
                .symbol_name = "POSTPS_ALPHA_TEST_FAIL",
                .desc = "Number of 2x2 that were lit from Rasterizer but failed the alpha test",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__postps_alpha_test_fail__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Color Pipe",
            },

            {
                .name = "Rasterizer Sample Output",
                .symbol_name = "RASTERIZER_SAMPLE_OUTPUT",
                .desc = "Number of lit samples emitted by Rasterizer",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__rasterizer_sample_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "RT BVH Cache Miss",
                .symbol_name = "RT_BVH_CACHE_MISS",
                .desc = "Number of BVH cache misses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__rt_bvh_cache_miss__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Input Message Ray Count",
                .symbol_name = "RT_INPUT_MESSAGE_RAY_COUNT",
                .desc = "Number of valid SIMD lanes in the TraceRay message",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__rt_input_message_ray_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "Sampler 2x2 Read",
                .symbol_name = "SAMPLER_2X2_READ",
                .desc = "Number of 2x2 texel block requested from Sampler",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__sampler_2_x2_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler",
            },

            {
                .name = "Sampler Texture Cache Access",
                .symbol_name = "SAMPLER_TEXTURE_CACHE_ACCESS",
                .desc = "Number of Sampler L1 requests",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__sampler_texture_cache_access__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler",
            },

            {
                .name = "Sampler Texture Cache Miss",
                .symbol_name = "SAMPLER_TEXTURE_CACHE_MISS",
                .desc = "Number of Sampler L1 misses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__sampler_texture_cache_miss__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler",
            },

            {
                .name = "Shader Pix Kill",
                .symbol_name = "SHADER_PIX_KILL",
                .desc = "Number of pixels that were lit from Rasterizer but killed by the Pixel Shader",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__shader_pix_kill__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Color Pipe",
            },

            {
                .name = "SLM Bank Conflict Count",
                .symbol_name = "SLM_BANK_CONFLICT_COUNT",
                .desc = "Number of SLM accesses resulting in a bank conflict",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__slm_bank_conflict_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "SLM Byte Read",
                .symbol_name = "SLM_BYTE_READ",
                .desc = "Number of bytes read from SLM",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__render_basic__slm_byte_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "SLM Byte Write",
                .symbol_name = "SLM_BYTE_WRITE",
                .desc = "Number of bytes written to SLM",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__render_basic__slm_byte_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Streamout Output Vertex Count",
                .symbol_name = "STREAMOUT_OUTPUT_VERTEX_COUNT",
                .desc = "Number of vertices written by SOL",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__streamout_output_vertex_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Streamout Primitive Write Count",
                .symbol_name = "STREAMOUT_PRIMITIVE_WRITE_COUNT",
                .desc = "Number of objects data written to memory, read from pipe 0 only",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__streamout_primitive_write_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Stripsfan Object Count",
                .symbol_name = "STRIPSFAN_OBJECT_COUNT",
                .desc = "Number of objects exiting Stripsfan stage",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__stripsfan_object_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Stripsfan Object Cull",
                .symbol_name = "STRIPSFAN_OBJECT_CULL",
                .desc = "Number of simple culled objects in Stripsfan stage",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__stripsfan_object_cull__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "SysMem Transaction Read",
                .symbol_name = "SYSMEM_TRANSACTION_READ",
                .desc = "Number of system memory 64B reads (upstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__sysmem_transaction_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "SysMem Transaction Write",
                .symbol_name = "SYSMEM_TRANSACTION_WRITE",
                .desc = "Number of system memory 64B writes (upstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__sysmem_transaction_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "TLB Miss",
                .symbol_name = "TLB_MISS",
                .desc = "Number of misses from all TLBs and all engines",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__tlb_miss__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "URB Read",
                .symbol_name = "URB_READ",
                .desc = "Number of URB reads",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__urb_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "URB",
            },

            {
                .name = "URB Write",
                .symbol_name = "URB_WRITE",
                .desc = "Number of URB writes",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__urb_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "URB",
            },

            {
                .name = "XVE Active",
                .symbol_name = "XVE_ACTIVE",
                .desc = "Percentage of time in which at least one pipe is active in XVE",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_basic__xve_active__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU0 All",
                .symbol_name = "XVE_INST_EXECUTED_ALU0_ALL",
                .desc = "Number of execution slots taken by instructions executed by ALL threads on ALU0 pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__xve_inst_executed_alu0_all__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU0 All Utilization",
                .symbol_name = "XVE_INST_EXECUTED_ALU0_ALL_UTILIZATION",
                .desc = "Percentage of time taken by instructions executed by ALL threads on ALU0 pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_basic__xve_inst_executed_alu0_all_utilization__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU0 CS",
                .symbol_name = "XVE_INST_EXECUTED_ALU0_CS",
                .desc = "Number of execution slots taken by instructions executed by CS threads on ALU0 pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__xve_inst_executed_alu0_cs__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU0 PS",
                .symbol_name = "XVE_INST_EXECUTED_ALU0_PS",
                .desc = "Number of execution slots taken by instructions executed by PS threads on ALU0 pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__xve_inst_executed_alu0_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU0 VS",
                .symbol_name = "XVE_INST_EXECUTED_ALU0_VS",
                .desc = "Number of execution slots taken by instructions executed by VS threads on ALU0 pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__xve_inst_executed_alu0_vs__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU1 All",
                .symbol_name = "XVE_INST_EXECUTED_ALU1_ALL",
                .desc = "Number of execution slots taken by instructions executed by ALL threads on ALU1 pipe. Does not include extended math instructions.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__xve_inst_executed_alu1_all__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU1 All Utilization",
                .symbol_name = "XVE_INST_EXECUTED_ALU1_ALL_UTILIZATION",
                .desc = "Percentage of time taken by instructions executed by ALL threads on ALU1 pipe. Does not include extended math instructions.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_basic__xve_inst_executed_alu1_all_utilization__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU1 CS",
                .symbol_name = "XVE_INST_EXECUTED_ALU1_CS",
                .desc = "Number of execution slots taken by instructions executed by CS threads on ALU1 pipe. Does not include extended math instructions.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__xve_inst_executed_alu1_cs__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU1 PS",
                .symbol_name = "XVE_INST_EXECUTED_ALU1_PS",
                .desc = "Number of execution slots taken by instructions executed by PS threads on ALU1 pipe. Does not include extended math instructions.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__xve_inst_executed_alu1_ps__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU1 VS",
                .symbol_name = "XVE_INST_EXECUTED_ALU1_VS",
                .desc = "Number of execution slots taken by instructions executed by VS threads on ALU1 pipe. Does not include extended math instructions.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__xve_inst_executed_alu1_vs__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Send All",
                .symbol_name = "XVE_INST_EXECUTED_SEND_ALL",
                .desc = "Number of instruction (GRF) dispatches executed by ALL threads on SEND Pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__xve_inst_executed_send_all__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Issued All",
                .symbol_name = "XVE_INST_ISSUED_ALL",
                .desc = "Number of instructions issued (decoded) to any pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_basic__xve_inst_issued_all__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Shared Function Access Hold",
                .symbol_name = "XVE_SHARED_FUNCTION_ACCESS_HOLD",
                .desc = "Percentage of time in which XVE requests stalled by Shared Function units",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_basic__xve_shared_function_access_hold__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Stall",
                .symbol_name = "XVE_STALL",
                .desc = "Percentage of time in which any thread loaded but not even a single pipe is active in XVE",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_basic__xve_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Threads Occupancy All",
                .symbol_name = "XVE_THREADS_OCCUPANCY_ALL",
                .desc = "Percentage of thread slots occupied by ALL threads",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_basic__xve_threads_occupancy_all__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_xe_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 69);
}


static void
bmg_add_compute_basic_metric_set(struct intel_xe_perf *perf)
{
    struct intel_xe_perf_metric_set *metric_set;
    struct intel_xe_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ComputeBasic";
    metric_set->symbol_name = "ComputeBasic";
    metric_set->hw_config_guid = "c7383a12-5c52-47a8-8e42-11b24d64d1f8";
    metric_set->counters = calloc(59, sizeof(struct intel_xe_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = XE_OA_FORMAT_PEC64u64;

    metric_set->perf_raw_size = 576;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->pec_offset = 2;
    bmg_compute_basic_add_registers(perf, metric_set);
    intel_xe_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_xe_perf_logical_counter _counters[] = {

            {
                .name = "Async GpGpu Threadgroup Count",
                .symbol_name = "ASYNC_GPGPU_THREADGROUP_COUNT",
                .desc = "Number of Async GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__async_gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Async GpGpu Thread Exit Count",
                .symbol_name = "ASYNC_GPGPU_THREAD_EXIT_COUNT",
                .desc = "Number of Async GPGPU EOT messages received",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bmg__compute_basic__async_gpgpu_thread_exit_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bmg__compute_basic__avg_gpu_core_frequency__read,
                .max_uint64 = bmg__compute_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Command Parser Compute Engine Busy",
                .symbol_name = "COMMAND_PARSER_COMPUTE_ENGINE_BUSY",
                .desc = "Percentage of time in which there is a context loaded and active on the compute queue",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__compute_basic__command_parser_compute_engine_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "Command Parser Compute Engine Dispatch Kernel Count",
                .symbol_name = "COMMAND_PARSER_COMPUTE_ENGINE_DISPATCH_KERNEL_COUNT",
                .desc = "Number of compute walker commands parsed on the compute engine",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__command_parser_compute_engine_dispatch_kernel_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "Command Parser Copy Engine Busy",
                .symbol_name = "COMMAND_PARSER_COPY_ENGINE_BUSY",
                .desc = "Percentage of time in which there is a context loaded and active on the copy queue.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__compute_basic__command_parser_copy_engine_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "Command Parser Flush Count",
                .symbol_name = "COMMAND_PARSER_FLUSH_COUNT",
                .desc = "Number of Stalling flushes at the top of the pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__command_parser_flush_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "Command Parser Render Engine Busy",
                .symbol_name = "COMMAND_PARSER_RENDER_ENGINE_BUSY",
                .desc = "Percentage of time in which there is a context loaded and active on the 3D queue",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__compute_basic__command_parser_render_engine_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "Command Parser Render Engine Dispatch Kernel Count",
                .symbol_name = "COMMAND_PARSER_RENDER_ENGINE_DISPATCH_KERNEL_COUNT",
                .desc = "Number of compute walker commands parsed on the 3D engine",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__command_parser_render_engine_dispatch_kernel_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "Compressor Input",
                .symbol_name = "COMPRESSOR_INPUT",
                .desc = "Number of 256B writes to compressible surfaces at the input of the compressor",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__compressor_input__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "Compressor Output",
                .symbol_name = "COMPRESSOR_OUTPUT",
                .desc = "Number of 256B writes to compressible surfaces at the output of the compressor",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__compressor_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GpGpu Dispatch",
                .symbol_name = "GPGPU_DISPATCH",
                .desc = "Percentage of time in which spent dispatching GPGPU threads to XVEs",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__compute_basic__gpgpu_dispatch__read,
                .max_float = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "GpGpu Threadgroup Count",
                .symbol_name = "GPGPU_THREADGROUP_COUNT",
                .desc = "Number of GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GPU_BUSY",
                .desc = "Percentage of time in which GPU is not idle including all GPU engines",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__compute_basic__gpu_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "GPU Memory Byte Read",
                .symbol_name = "GPU_MEMORY_BYTE_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__compute_basic__gpu_memory_byte_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory Byte Read Rate",
                .symbol_name = "GPU_MEMORY_BYTE_READ_RATE",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = bmg__compute_basic__gpu_memory_byte_read_rate__read,
                .max_float = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory Byte Write",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__compute_basic__gpu_memory_byte_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory Byte Write Rate",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE_RATE",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = bmg__compute_basic__gpu_memory_byte_write_rate__read,
                .max_float = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory L3 Read",
                .symbol_name = "GPU_MEMORY_L3_READ",
                .desc = "Number of GTI memory reads from Device Cache caused by Device Cache misses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__gpu_memory_l3_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory L3 Write",
                .symbol_name = "GPU_MEMORY_L3_WRITE",
                .desc = "Number of GTI memory writes from Device Cache caused by Device Cache invalidations",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__gpu_memory_l3_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__compute_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bmg__compute_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Host To GpuMem Transaction Read",
                .symbol_name = "HOST_TO_GPUMEM_TRANSACTION_READ",
                .desc = "Number of host 64B reads to GPU local (HBM) memory (downstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__host_to_gpumem_transaction_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "Host To GpuMem Transaction Write",
                .symbol_name = "HOST_TO_GPUMEM_TRANSACTION_WRITE",
                .desc = "Number of host 64B writes to GPU local (HBM) memory (downstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__host_to_gpumem_transaction_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "IA Vertex",
                .symbol_name = "IA_VERTEX",
                .desc = "Number of vertices in a draw",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__ia_vertex__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "ICache Hit",
                .symbol_name = "ICACHE_HIT",
                .desc = "Number of Instruction Cache hits",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__icache_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "ICache Miss",
                .symbol_name = "ICACHE_MISS",
                .desc = "Number of Instruction Cache misses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__icache_miss__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "L3 Atomic Access",
                .symbol_name = "L3_ATOMIC_ACCESS",
                .desc = "Number of atomic accesses to Device Cache bank",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__l3_atomic_access__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Hit",
                .symbol_name = "L3_HIT",
                .desc = "Number of Device Cache accesses which hits in the Device Cache cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__l3_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Miss",
                .symbol_name = "L3_MISS",
                .desc = "Number of Device Cache accesses which miss in the Device Cache cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__l3_miss__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Read",
                .symbol_name = "L3_READ",
                .desc = "Number of Device Cache 64B read requests",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__l3_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Write",
                .symbol_name = "L3_WRITE",
                .desc = "Number of Device Cache 64B write requests",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__l3_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "Load Store Cache Access",
                .symbol_name = "LOAD_STORE_CACHE_ACCESS",
                .desc = "Number of Load Store Cache accesses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__load_store_cache_access__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Load Store Cache Byte Read",
                .symbol_name = "LOAD_STORE_CACHE_BYTE_READ",
                .desc = "Number of bytes read out of the Load Store Cache, excluding SLM accesses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__compute_basic__load_store_cache_byte_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Load Store Cache Byte Write",
                .symbol_name = "LOAD_STORE_CACHE_BYTE_WRITE",
                .desc = "Number of bytes written to the Load Store Cache, excluding SLM accesses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__compute_basic__load_store_cache_byte_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Load Store Cache Hit",
                .symbol_name = "LOAD_STORE_CACHE_HIT",
                .desc = "Number of Load Store Cache hits",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__load_store_cache_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Load Store Cache Partial Write Count",
                .symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT",
                .desc = "Number of writes to the Load Store Cache that don't fill a subsector",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__load_store_cache_partial_write_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Rasterizer Sample Output",
                .symbol_name = "RASTERIZER_SAMPLE_OUTPUT",
                .desc = "Number of lit samples emitted by Rasterizer",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__rasterizer_sample_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "SLM Bank Conflict Count",
                .symbol_name = "SLM_BANK_CONFLICT_COUNT",
                .desc = "Number of SLM accesses resulting in a bank conflict",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__slm_bank_conflict_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "SLM Byte Read",
                .symbol_name = "SLM_BYTE_READ",
                .desc = "Number of bytes read from SLM",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__compute_basic__slm_byte_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "SLM Byte Write",
                .symbol_name = "SLM_BYTE_WRITE",
                .desc = "Number of bytes written to SLM",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__compute_basic__slm_byte_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "SysMem Transaction Read",
                .symbol_name = "SYSMEM_TRANSACTION_READ",
                .desc = "Number of system memory 64B reads (upstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__sysmem_transaction_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "SysMem Transaction Write",
                .symbol_name = "SYSMEM_TRANSACTION_WRITE",
                .desc = "Number of system memory 64B writes (upstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__sysmem_transaction_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "TLB Miss",
                .symbol_name = "TLB_MISS",
                .desc = "Number of misses from all TLBs and all engines",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__tlb_miss__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "XVE Active",
                .symbol_name = "XVE_ACTIVE",
                .desc = "Percentage of time in which at least one pipe is active in XVE",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__compute_basic__xve_active__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU0 All",
                .symbol_name = "XVE_INST_EXECUTED_ALU0_ALL",
                .desc = "Number of execution slots taken by instructions executed by ALL threads on ALU0 pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__xve_inst_executed_alu0_all__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU0 All Utilization",
                .symbol_name = "XVE_INST_EXECUTED_ALU0_ALL_UTILIZATION",
                .desc = "Percentage of time taken by instructions executed by ALL threads on ALU0 pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__compute_basic__xve_inst_executed_alu0_all_utilization__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU1 All",
                .symbol_name = "XVE_INST_EXECUTED_ALU1_ALL",
                .desc = "Number of execution slots taken by instructions executed by ALL threads on ALU1 pipe. Does not include extended math instructions.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__xve_inst_executed_alu1_all__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU1 All Utilization",
                .symbol_name = "XVE_INST_EXECUTED_ALU1_ALL_UTILIZATION",
                .desc = "Percentage of time taken by instructions executed by ALL threads on ALU1 pipe. Does not include extended math instructions.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__compute_basic__xve_inst_executed_alu1_all_utilization__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU2 All",
                .symbol_name = "XVE_INST_EXECUTED_ALU2_ALL",
                .desc = "Number of execution slots taken by instructions executed in ALU2 pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__xve_inst_executed_alu2_all__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU2 All Utilization",
                .symbol_name = "XVE_INST_EXECUTED_ALU2_ALL_UTILIZATION",
                .desc = "Percentage of time taken by instructions executed in ALU2 pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__compute_basic__xve_inst_executed_alu2_all_utilization__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Send All",
                .symbol_name = "XVE_INST_EXECUTED_SEND_ALL",
                .desc = "Number of instruction (GRF) dispatches executed by ALL threads on SEND Pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__xve_inst_executed_send_all__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Issued All",
                .symbol_name = "XVE_INST_ISSUED_ALL",
                .desc = "Number of instructions issued (decoded) to any pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__compute_basic__xve_inst_issued_all__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Multiple Pipe Active",
                .symbol_name = "XVE_MULTIPLE_PIPE_ACTIVE",
                .desc = "Percentage of time in which at least two pipes are actively executing a Gen ISA instruction among ALU0, ALU1 and ALU2 pipes",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__compute_basic__xve_multiple_pipe_active__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Pipe ALU0 And ALU1 Active",
                .symbol_name = "XVE_PIPE_ALU0_AND_ALU1_ACTIVE",
                .desc = "Percentage of time in which ALU0 and ALU1 pipes are both actively executing a Gen ISA instruction",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__compute_basic__xve_pipe_alu0_and_alu1_active__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Pipe ALU0 And ALU2 Active",
                .symbol_name = "XVE_PIPE_ALU0_AND_ALU2_ACTIVE",
                .desc = "Percentage of time in which ALU0 and ALU2 pipes are both actively executing a Gen ISA instruction",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__compute_basic__xve_pipe_alu0_and_alu2_active__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Shared Function Access Hold",
                .symbol_name = "XVE_SHARED_FUNCTION_ACCESS_HOLD",
                .desc = "Percentage of time in which XVE requests stalled by Shared Function units",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__compute_basic__xve_shared_function_access_hold__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Stall",
                .symbol_name = "XVE_STALL",
                .desc = "Percentage of time in which any thread loaded but not even a single pipe is active in XVE",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__compute_basic__xve_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Threads Occupancy All",
                .symbol_name = "XVE_THREADS_OCCUPANCY_ALL",
                .desc = "Percentage of thread slots occupied by ALL threads",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__compute_basic__xve_threads_occupancy_all__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_xe_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 59);
}


static void
bmg_add_depth_profile_metric_set(struct intel_xe_perf *perf)
{
    struct intel_xe_perf_metric_set *metric_set;
    struct intel_xe_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthProfile";
    metric_set->symbol_name = "DepthProfile";
    metric_set->hw_config_guid = "a80e9da5-d2c9-4c20-9f7c-c0adf74bbe89";
    metric_set->counters = calloc(26, sizeof(struct intel_xe_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = XE_OA_FORMAT_PEC64u64;

    metric_set->perf_raw_size = 576;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->pec_offset = 2;
    bmg_depth_profile_add_registers(perf, metric_set);
    intel_xe_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_xe_perf_logical_counter _counters[] = {

            {
                .name = "Async GpGpu Threadgroup Count",
                .symbol_name = "ASYNC_GPGPU_THREADGROUP_COUNT",
                .desc = "Number of Async GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__async_gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bmg__depth_profile__avg_gpu_core_frequency__read,
                .max_uint64 = bmg__depth_profile__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Early Depth Stencil Test Fail Np",
                .symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_NP",
                .desc = "Number of non-promoted 2x2 that failed Depth / Stencil before the Pixel Shader that were previously ambiguous at HiZ",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__early_depth_stencil_test_fail_np__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Depth Pipe",
            },

            {
                .name = "Early Depth Stencil Test Fail P",
                .symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_P",
                .desc = "Number of promoted 2x2 that failed Depth / Stencil that were previously ambiguous at HiZ",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__early_depth_stencil_test_fail_p__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Depth Pipe",
            },

            {
                .name = "GpGpu Threadgroup Count",
                .symbol_name = "GPGPU_THREADGROUP_COUNT",
                .desc = "Number of GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GPU_BUSY",
                .desc = "Percentage of time in which GPU is not idle including all GPU engines",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__depth_profile__gpu_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__depth_profile__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bmg__depth_profile__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HiZ Depth Test Ambig Np",
                .symbol_name = "HIZ_DEPTH_TEST_AMBIG_NP",
                .desc = "Number of non-promoted 2x2 that are ambiguous by hierarchical depth test",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__hiz_depth_test_ambig_np__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Depth Pipe",
            },

            {
                .name = "HiZ Depth Test Ambig P",
                .symbol_name = "HIZ_DEPTH_TEST_AMBIG_P",
                .desc = "Number of promoted 2x2 that are ambiguous by hierarchical depth test",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__hiz_depth_test_ambig_p__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Depth Pipe",
            },

            {
                .name = "HiZ Depth Test Fail Np",
                .symbol_name = "HIZ_DEPTH_TEST_FAIL_NP",
                .desc = "Number of non-promoted 2x2 that failed the hierarchical depth test",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__hiz_depth_test_fail_np__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Depth Pipe",
            },

            {
                .name = "HiZ Depth Test Fail P",
                .symbol_name = "HIZ_DEPTH_TEST_FAIL_P",
                .desc = "Number of promoted 2x2 that failed the hierarchical depth test",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__hiz_depth_test_fail_p__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Depth Pipe",
            },

            {
                .name = "HiZ Depth Test Pass P",
                .symbol_name = "HIZ_DEPTH_TEST_PASS_P",
                .desc = "Number of promoted 2x2 passed by hierarchical depth test",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__hiz_depth_test_pass_p__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Depth Pipe",
            },

            {
                .name = "HiZ Subspan Latency Fifofull",
                .symbol_name = "HIZ_SUBSPAN_LATENCY_FIFOFULL",
                .desc = "Percentage of time in which for which HiZ latency hiding structure full",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__depth_profile__hiz_subspan_latency_fifofull__read,
                .max_float = NULL /* undefined */,
                .group = "Depth Pipe",
            },

            {
                .name = "IA Vertex",
                .symbol_name = "IA_VERTEX",
                .desc = "Number of vertices in a draw",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__ia_vertex__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "IZ Output Ready",
                .symbol_name = "IZ_OUTPUT_READY",
                .desc = "Percentage of time in which IZ has requests to different clients",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__depth_profile__iz_output_ready__read,
                .max_float = NULL /* undefined */,
                .group = "Depth Pipe",
            },

            {
                .name = "IZ Subspan Latency Fifofull",
                .symbol_name = "IZ_SUBSPAN_LATENCY_FIFOFULL",
                .desc = "Percentage of time in which for which IZ latency hiding structure full",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__depth_profile__iz_subspan_latency_fifofull__read,
                .max_float = NULL /* undefined */,
                .group = "Depth Pipe",
            },

            {
                .name = "Pixel 2x2 Lit Post Rasterizer Early Depth",
                .symbol_name = "PIXEL_2X2_LIT_POST_RASTERIZER_EARLY_DEPTH",
                .desc = "Number of promoted 2x2 that are lit from Rasterizer",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__pixel_2_x2_lit_post_rasterizer_early_depth__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "Pixel 2x2 Lit Post Rasterizer Late Depth",
                .symbol_name = "PIXEL_2X2_LIT_POST_RASTERIZER_LATE_DEPTH",
                .desc = "Number of non-promoted 2x2 that are lit from Rasterizer",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__pixel_2_x2_lit_post_rasterizer_late_depth__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "PostPS Depth Stencil Test Fail",
                .symbol_name = "POSTPS_DEPTH_STENCIL_TEST_FAIL",
                .desc = "Number of 2x2 that were lit from Rasterizer but failed the depth or stencil test post shader",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__postps_depth_stencil_test_fail__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Depth Pipe",
            },

            {
                .name = "Rasterizer Sample Output",
                .symbol_name = "RASTERIZER_SAMPLE_OUTPUT",
                .desc = "Number of lit samples emitted by Rasterizer",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__rasterizer_sample_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "Render Cache Alloc",
                .symbol_name = "RENDER_CACHE_ALLOC",
                .desc = "Number of Render Cache allocations",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__render_cache_alloc__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Color Pipe",
            },

            {
                .name = "Render Cache Hit",
                .symbol_name = "RENDER_CACHE_HIT",
                .desc = "Number of Render Cache hits",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__render_cache_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Color Pipe",
            },

            {
                .name = "Render Cache Read",
                .symbol_name = "RENDER_CACHE_READ",
                .desc = "Number of Render Cache reads",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__render_cache_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Color Pipe",
            },

            {
                .name = "Render Cache Write",
                .symbol_name = "RENDER_CACHE_WRITE",
                .desc = "Number of Render Cache writes",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__render_cache_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Color Pipe",
            },

            {
                .name = "URB Cross Slice Read",
                .symbol_name = "URB_CROSS_SLICE_READ",
                .desc = "Number of URB reads occurred from cross slices",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__depth_profile__urb_cross_slice_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "URB",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_xe_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 26);
}


static void
bmg_add_device_cache_profile_metric_set(struct intel_xe_perf *perf)
{
    struct intel_xe_perf_metric_set *metric_set;
    struct intel_xe_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DeviceCacheProfile";
    metric_set->symbol_name = "DeviceCacheProfile";
    metric_set->hw_config_guid = "d8bb1c75-31d8-41a1-99db-99d98be17e78";
    metric_set->counters = calloc(32, sizeof(struct intel_xe_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = XE_OA_FORMAT_PEC64u64;

    metric_set->perf_raw_size = 576;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->pec_offset = 2;
    bmg_device_cache_profile_add_registers(perf, metric_set);
    intel_xe_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_xe_perf_logical_counter _counters[] = {

            {
                .name = "AMFS L3 Access",
                .symbol_name = "AMFS_L3_ACCESS",
                .desc = "Number of AMFS access to Device Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__amfs_l3_access__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "AMFS L3 Atomic",
                .symbol_name = "AMFS_L3_ATOMIC",
                .desc = "Number of AMFS atomics to Device Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__amfs_l3_atomic__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "AMFS L3 Hit",
                .symbol_name = "AMFS_L3_HIT",
                .desc = "Number of AMFS hits in Device Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__amfs_l3_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "AMFS L3 Write",
                .symbol_name = "AMFS_L3_WRITE",
                .desc = "Number of AMFS writes to Device Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__amfs_l3_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "Async GpGpu Threadgroup Count",
                .symbol_name = "ASYNC_GPGPU_THREADGROUP_COUNT",
                .desc = "Number of Async GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__async_gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bmg__device_cache_profile__avg_gpu_core_frequency__read,
                .max_uint64 = bmg__device_cache_profile__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Color L3 Access",
                .symbol_name = "COLOR_L3_ACCESS",
                .desc = "Number of Device Cache requests resulting from color local cache misses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__color_l3_access__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "Color L3 Hit",
                .symbol_name = "COLOR_L3_HIT",
                .desc = "Number of Device Cache requests resulting from color local cache miss which hits in Device Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__color_l3_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "GpGpu Threadgroup Count",
                .symbol_name = "GPGPU_THREADGROUP_COUNT",
                .desc = "Number of GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GPU_BUSY",
                .desc = "Percentage of time in which GPU is not idle including all GPU engines",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__device_cache_profile__gpu_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "GPU Memory L3 Read",
                .symbol_name = "GPU_MEMORY_L3_READ",
                .desc = "Number of GTI memory reads from Device Cache caused by Device Cache misses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__gpu_memory_l3_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory L3 Write",
                .symbol_name = "GPU_MEMORY_L3_WRITE",
                .desc = "Number of GTI memory writes from Device Cache caused by Device Cache invalidations",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__gpu_memory_l3_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory Read",
                .symbol_name = "GPU_MEMORY_READ",
                .desc = "Number of GTI memory reads",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__gpu_memory_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory Write",
                .symbol_name = "GPU_MEMORY_WRITE",
                .desc = "Number of GTI memory writes",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__gpu_memory_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__device_cache_profile__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bmg__device_cache_profile__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "IA Vertex",
                .symbol_name = "IA_VERTEX",
                .desc = "Number of vertices in a draw",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__ia_vertex__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "ICache L3 Hit",
                .symbol_name = "ICACHE_L3_HIT",
                .desc = "Number of XVE instruction cache requests that hit the Device Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__icache_l3_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "ICache L3 Read",
                .symbol_name = "ICACHE_L3_READ",
                .desc = "Number of Device Cache read requests coming from XVE Instruction Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__icache_l3_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Atomic Access",
                .symbol_name = "L3_ATOMIC_ACCESS",
                .desc = "Number of atomic accesses to Device Cache bank",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__l3_atomic_access__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Hit",
                .symbol_name = "L3_HIT",
                .desc = "Number of Device Cache accesses which hits in the Device Cache cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__l3_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Miss",
                .symbol_name = "L3_MISS",
                .desc = "Number of Device Cache accesses which miss in the Device Cache cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__l3_miss__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Read",
                .symbol_name = "L3_READ",
                .desc = "Number of Device Cache 64B read requests",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__l3_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Write",
                .symbol_name = "L3_WRITE",
                .desc = "Number of Device Cache 64B write requests",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__l3_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "Load Store Cache L3 Hit",
                .symbol_name = "LOAD_STORE_CACHE_L3_HIT",
                .desc = "Number of Load Store Cache requests to Device Cache that are hit",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__load_store_cache_l3_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "Load Store Cache L3 Read",
                .symbol_name = "LOAD_STORE_CACHE_L3_READ",
                .desc = "Number of cacheline read requests from the Load Store Cache to Device Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__load_store_cache_l3_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "Load Store Cache L3 Write",
                .symbol_name = "LOAD_STORE_CACHE_L3_WRITE",
                .desc = "Number of cacheline write requests from the Load Store Cache to Device Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__load_store_cache_l3_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "Rasterizer Sample Output",
                .symbol_name = "RASTERIZER_SAMPLE_OUTPUT",
                .desc = "Number of lit samples emitted by Rasterizer",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__rasterizer_sample_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "Sampler L3 Hit",
                .symbol_name = "SAMPLER_L3_HIT",
                .desc = "Number of Device Cache hit requests resulting from sampler local cache miss which hits in Device Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__sampler_l3_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "Sampler L3 Read",
                .symbol_name = "SAMPLER_L3_READ",
                .desc = "Number of Device Cache read requests resulting from sampler local cache miss",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__sampler_l3_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "Z L3 Access",
                .symbol_name = "Z_L3_ACCESS",
                .desc = "Number of Device Cache requests resulting from Z local cache misses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__z_l3_access__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "Z L3 Hit",
                .symbol_name = "Z_L3_HIT",
                .desc = "Number of Device Cache requests resulting from Z local cache miss which hits in Device Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__device_cache_profile__z_l3_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_xe_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 32);
}


static void
bmg_add_memory_profile_metric_set(struct intel_xe_perf *perf)
{
    struct intel_xe_perf_metric_set *metric_set;
    struct intel_xe_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "MemoryProfile";
    metric_set->symbol_name = "MemoryProfile";
    metric_set->hw_config_guid = "d2e403f3-4c94-4b1b-bc09-f472a43251a4";
    metric_set->counters = calloc(55, sizeof(struct intel_xe_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = XE_OA_FORMAT_PEC64u64;

    metric_set->perf_raw_size = 576;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->pec_offset = 2;
    bmg_memory_profile_add_registers(perf, metric_set);
    intel_xe_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_xe_perf_logical_counter _counters[] = {

            {
                .name = "Async GpGpu Threadgroup Count",
                .symbol_name = "ASYNC_GPGPU_THREADGROUP_COUNT",
                .desc = "Number of Async GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__async_gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bmg__memory_profile__avg_gpu_core_frequency__read,
                .max_uint64 = bmg__memory_profile__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Compressor Input",
                .symbol_name = "COMPRESSOR_INPUT",
                .desc = "Number of 256B writes to compressible surfaces at the input of the compressor",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__compressor_input__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "Compressor Output",
                .symbol_name = "COMPRESSOR_OUTPUT",
                .desc = "Number of 256B writes to compressible surfaces at the output of the compressor",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__compressor_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "Copy Engine Read Request",
                .symbol_name = "COPY_ENGINE_READ_REQUEST",
                .desc = "Number of read requests sent by the Copy Engine",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__copy_engine_read_request__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Copy Engine",
            },

            {
                .name = "Copy Engine Request Stall",
                .symbol_name = "COPY_ENGINE_REQUEST_STALL",
                .desc = "Percentage of time in which copy engine is stalled on the memory path due to stall on the read or write path when there are commands pending within copy engine",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__memory_profile__copy_engine_request_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Copy Engine",
            },

            {
                .name = "Copy Engine Write Request",
                .symbol_name = "COPY_ENGINE_WRITE_REQUEST",
                .desc = "Number of write requests sent by the Copy Engine",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__copy_engine_write_request__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Copy Engine",
            },

            {
                .name = "GpGpu Threadgroup Count",
                .symbol_name = "GPGPU_THREADGROUP_COUNT",
                .desc = "Number of GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GPU_BUSY",
                .desc = "Percentage of time in which GPU is not idle including all GPU engines",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__memory_profile__gpu_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "GPU Memory 32b Transaction Read",
                .symbol_name = "GPU_MEMORY_32B_TRANSACTION_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__gpu_memory_32_b_transaction_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory 32b Transaction Write",
                .symbol_name = "GPU_MEMORY_32B_TRANSACTION_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__gpu_memory_32_b_transaction_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory 64b Transaction Read",
                .symbol_name = "GPU_MEMORY_64B_TRANSACTION_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__gpu_memory_64_b_transaction_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory 64b Transaction Write",
                .symbol_name = "GPU_MEMORY_64B_TRANSACTION_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__gpu_memory_64_b_transaction_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory Byte Read",
                .symbol_name = "GPU_MEMORY_BYTE_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__memory_profile__gpu_memory_byte_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory Byte Read Rate",
                .symbol_name = "GPU_MEMORY_BYTE_READ_RATE",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = bmg__memory_profile__gpu_memory_byte_read_rate__read,
                .max_float = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory Byte Write",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__memory_profile__gpu_memory_byte_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory Byte Write Rate",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE_RATE",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = bmg__memory_profile__gpu_memory_byte_write_rate__read,
                .max_float = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory L3 Read",
                .symbol_name = "GPU_MEMORY_L3_READ",
                .desc = "Number of GTI memory reads from Device Cache caused by Device Cache misses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__gpu_memory_l3_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory L3 Write",
                .symbol_name = "GPU_MEMORY_L3_WRITE",
                .desc = "Number of GTI memory writes from Device Cache caused by Device Cache invalidations",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__gpu_memory_l3_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__memory_profile__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bmg__memory_profile__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Host To GpuMem Transaction Read",
                .symbol_name = "HOST_TO_GPUMEM_TRANSACTION_READ",
                .desc = "Number of host 64B reads to GPU local (HBM) memory (downstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__host_to_gpumem_transaction_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "Host To GpuMem Transaction Write",
                .symbol_name = "HOST_TO_GPUMEM_TRANSACTION_WRITE",
                .desc = "Number of host 64B writes to GPU local (HBM) memory (downstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__host_to_gpumem_transaction_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "IA Vertex",
                .symbol_name = "IA_VERTEX",
                .desc = "Number of vertices in a draw",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__ia_vertex__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "L3 Atomic Access",
                .symbol_name = "L3_ATOMIC_ACCESS",
                .desc = "Number of atomic accesses to Device Cache bank",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__l3_atomic_access__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Hit",
                .symbol_name = "L3_HIT",
                .desc = "Number of Device Cache accesses which hits in the Device Cache cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__l3_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Miss",
                .symbol_name = "L3_MISS",
                .desc = "Number of Device Cache accesses which miss in the Device Cache cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__l3_miss__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Read",
                .symbol_name = "L3_READ",
                .desc = "Number of Device Cache 64B read requests",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__l3_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Write",
                .symbol_name = "L3_WRITE",
                .desc = "Number of Device Cache 64B write requests",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__l3_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "Load Store Cache Access",
                .symbol_name = "LOAD_STORE_CACHE_ACCESS",
                .desc = "Number of Load Store Cache accesses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__load_store_cache_access__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Load Store Cache Byte Read",
                .symbol_name = "LOAD_STORE_CACHE_BYTE_READ",
                .desc = "Number of bytes read out of the Load Store Cache, excluding SLM accesses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__memory_profile__load_store_cache_byte_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Load Store Cache Byte Write",
                .symbol_name = "LOAD_STORE_CACHE_BYTE_WRITE",
                .desc = "Number of bytes written to the Load Store Cache, excluding SLM accesses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__memory_profile__load_store_cache_byte_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Load Store Cache Hit",
                .symbol_name = "LOAD_STORE_CACHE_HIT",
                .desc = "Number of Load Store Cache hits",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__load_store_cache_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Load Store Cache Input Available",
                .symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE",
                .desc = "Percentage of time in which the Load Store Cache has input available",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__memory_profile__load_store_cache_input_available__read,
                .max_float = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Load Store Cache Number Of Bank Access Count",
                .symbol_name = "LOAD_STORE_CACHE_NUMBER_OF_BANK_ACCESS_COUNT",
                .desc = "Number of Load Store Cache banks accessed in a clock",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__load_store_cache_number_of_bank_access_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Load Store Cache Output Ready",
                .symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY",
                .desc = "Percentage of time in which the Load Store Cache has output ready",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__memory_profile__load_store_cache_output_ready__read,
                .max_float = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Load Store Cache Partial Write Count",
                .symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT",
                .desc = "Number of writes to the Load Store Cache that don't fill a subsector",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__load_store_cache_partial_write_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "Rasterizer Sample Output",
                .symbol_name = "RASTERIZER_SAMPLE_OUTPUT",
                .desc = "Number of lit samples emitted by Rasterizer",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__rasterizer_sample_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "SLM Access Count",
                .symbol_name = "SLM_ACCESS_COUNT",
                .desc = "Number of SLM accesses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__slm_access_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "SLM Bank Conflict Count",
                .symbol_name = "SLM_BANK_CONFLICT_COUNT",
                .desc = "Number of SLM accesses resulting in a bank conflict",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__slm_bank_conflict_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "SLM Byte Read",
                .symbol_name = "SLM_BYTE_READ",
                .desc = "Number of bytes read from SLM",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__memory_profile__slm_byte_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "SLM Byte Write",
                .symbol_name = "SLM_BYTE_WRITE",
                .desc = "Number of bytes written to SLM",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__memory_profile__slm_byte_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "SysMem Transaction Read",
                .symbol_name = "SYSMEM_TRANSACTION_READ",
                .desc = "Number of system memory 64B reads (upstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__sysmem_transaction_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "SysMem Transaction Write",
                .symbol_name = "SYSMEM_TRANSACTION_WRITE",
                .desc = "Number of system memory 64B writes (upstream over an interface such as pcie, cxl or an integrated fabric as applicable to the respective product segment)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__sysmem_transaction_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "TLB Miss",
                .symbol_name = "TLB_MISS",
                .desc = "Number of misses from all TLBs and all engines",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__tlb_miss__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "XVE Load Store Cache Atomic Message Count",
                .symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT",
                .desc = "Number of atomic operations sent by XVEs to the Load Store Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__xve_load_store_cache_atomic_message_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "XVE Load Store Cache Fence Message Count",
                .symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT",
                .desc = "Number of fence messages sent by XVEs to the Load Store Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bmg__memory_profile__xve_load_store_cache_fence_message_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "XVE Load Store Cache Read Message Count",
                .symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT",
                .desc = "Number of read messages sent by XVEs to the Load Store Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bmg__memory_profile__xve_load_store_cache_read_message_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "XVE Load Store Cache Register Request Count",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT",
                .desc = "Number of message payload transactions sent by XVEs to the Load Store Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__xve_load_store_cache_register_request_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "XVE Load Store Cache Register Response Count",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT",
                .desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__xve_load_store_cache_register_response_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "XVE Load Store Cache Write Message Count",
                .symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT",
                .desc = "Number of write messages sent by XVEs to the Load Store Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bmg__memory_profile__xve_load_store_cache_write_message_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "XVE SLM Atomic Message Count",
                .symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT",
                .desc = "Number of SLM atomic operations sent by XVEs",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__xve_slm_atomic_message_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "XVE SLM Fence Message Count",
                .symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT",
                .desc = "Number of SLM fence operations sent by XVEs",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__memory_profile__xve_slm_fence_message_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "XVE SLM Read Message Count",
                .symbol_name = "XVE_SLM_READ_MESSAGE_COUNT",
                .desc = "Number of SLM read messages sent by XVEs",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bmg__memory_profile__xve_slm_read_message_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "XVE SLM Write Message Count",
                .symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT",
                .desc = "Number of SLM write messages sent by XVEs",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bmg__memory_profile__xve_slm_write_message_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_xe_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 55);
}


static void
bmg_add_render_pipe_profile_metric_set(struct intel_xe_perf *perf)
{
    struct intel_xe_perf_metric_set *metric_set;
    struct intel_xe_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "RenderPipeProfile";
    metric_set->symbol_name = "RenderPipeProfile";
    metric_set->hw_config_guid = "dad0d2c6-1290-4d50-a6aa-8b8104204232";
    metric_set->counters = calloc(44, sizeof(struct intel_xe_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = XE_OA_FORMAT_PEC64u64;

    metric_set->perf_raw_size = 576;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->pec_offset = 2;
    bmg_render_pipe_profile_add_registers(perf, metric_set);
    intel_xe_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_xe_perf_logical_counter _counters[] = {

            {
                .name = "AMFS 4x4 Shading Request",
                .symbol_name = "AMFS_4X4_SHADING_REQUEST",
                .desc = "Number of Shading Request (evaluate) messages processed by AMFS",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bmg__render_pipe_profile__amfs_4_x4_shading_request__read,
                .max_uint64 = NULL /* undefined */,
                .group = "AMFS",
            },

            {
                .name = "AMFS Cache Hit",
                .symbol_name = "AMFS_CACHE_HIT",
                .desc = "Number of hits in the AMFS cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_pipe_profile__amfs_cache_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "AMFS",
            },

            {
                .name = "AMFS Cache Miss",
                .symbol_name = "AMFS_CACHE_MISS",
                .desc = "Number of cache misses in AMFS",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_pipe_profile__amfs_cache_miss__read,
                .max_uint64 = NULL /* undefined */,
                .group = "AMFS",
            },

            {
                .name = "AMFS Stall All Input",
                .symbol_name = "AMFS_STALL_ALL_INPUT",
                .desc = "Percentage of time in which AMFS stalls at both of the color pipe inputs",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__amfs_stall_all_input__read,
                .max_float = NULL /* undefined */,
                .group = "AMFS",
            },

            {
                .name = "AMFS Stall Any Input",
                .symbol_name = "AMFS_STALL_ANY_INPUT",
                .desc = "Percentage of time in which AMFS stalls at any of the color pipe inputs",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__amfs_stall_any_input__read,
                .max_float = NULL /* undefined */,
                .group = "AMFS",
            },

            {
                .name = "Async GpGpu Threadgroup Count",
                .symbol_name = "ASYNC_GPGPU_THREADGROUP_COUNT",
                .desc = "Number of Async GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_pipe_profile__async_gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bmg__render_pipe_profile__avg_gpu_core_frequency__read,
                .max_uint64 = bmg__render_pipe_profile__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Clipper Input Available",
                .symbol_name = "CLIPPER_INPUT_AVAILABLE",
                .desc = "Percentage of time in which Clipper has input available (from Vertex Shader or SOL)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__clipper_input_available__read,
                .max_float = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Clipper Output Ready",
                .symbol_name = "CLIPPER_OUTPUT_READY",
                .desc = "Percentage of time in which Clipper output ready",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__clipper_output_ready__read,
                .max_float = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Clipper Transaction Output",
                .symbol_name = "CLIPPER_TRANSACTION_OUTPUT",
                .desc = "Number of elements pushed by Clipper into Stripsfan stage",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_pipe_profile__clipper_transaction_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Color Pipe Cache Latency1 Stall",
                .symbol_name = "COLOR_PIPE_CACHE_LATENCY1_STALL",
                .desc = "Percentage of time in which Color Pipeline stalled due to MultiSampling Cache latency hiding structure full",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__color_pipe_cache_latency1_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Color Pipe",
            },

            {
                .name = "Color Pipe Cache Latency2 Stall",
                .symbol_name = "COLOR_PIPE_CACHE_LATENCY2_STALL",
                .desc = "Percentage of time in which Color Pipeline stalled due to Render Cache latency hiding structure full",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__color_pipe_cache_latency2_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Color Pipe",
            },

            {
                .name = "Command Parser Render Engine Draw Count",
                .symbol_name = "COMMAND_PARSER_RENDER_ENGINE_DRAW_COUNT",
                .desc = "Number of DRAW and MESH commands parsed on the 3D engine",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_pipe_profile__command_parser_render_engine_draw_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "GpGpu Threadgroup Count",
                .symbol_name = "GPGPU_THREADGROUP_COUNT",
                .desc = "Number of GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_pipe_profile__gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GPU_BUSY",
                .desc = "Percentage of time in which GPU is not idle including all GPU engines",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__gpu_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__render_pipe_profile__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bmg__render_pipe_profile__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "IA Vertex",
                .symbol_name = "IA_VERTEX",
                .desc = "Number of vertices in a draw",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_pipe_profile__ia_vertex__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Pixel Post Process Input Available",
                .symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE",
                .desc = "Percentage of time in which Color Pipeline input ready",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__pixel_post_process_input_available__read,
                .max_float = NULL /* undefined */,
                .group = "Color Pipe",
            },

            {
                .name = "Pixel Post Process Output Ready",
                .symbol_name = "PIXEL_POST_PROCESS_OUTPUT_READY",
                .desc = "Percentage of time in which Color Pipeline pixel output ready",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__pixel_post_process_output_ready__read,
                .max_float = NULL /* undefined */,
                .group = "Color Pipe",
            },

            {
                .name = "PS Output Available",
                .symbol_name = "PS_OUTPUT_AVAILABLE",
                .desc = "Percentage of time in which Pixel Shader data is available",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__ps_output_available__read,
                .max_float = NULL /* undefined */,
                .group = "Color Pipe",
            },

            {
                .name = "Rasterizer Input Available",
                .symbol_name = "RASTERIZER_INPUT_AVAILABLE",
                .desc = "Percentage of time in which Rasterizer input is available",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__rasterizer_input_available__read,
                .max_float = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "Rasterizer Output Ready",
                .symbol_name = "RASTERIZER_OUTPUT_READY",
                .desc = "Percentage of time in which where rasterizer output is ready",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__rasterizer_output_ready__read,
                .max_float = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "Rasterizer Sample Output",
                .symbol_name = "RASTERIZER_SAMPLE_OUTPUT",
                .desc = "Number of lit samples emitted by Rasterizer",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_pipe_profile__rasterizer_sample_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "Rasterizer Transaction Output",
                .symbol_name = "RASTERIZER_TRANSACTION_OUTPUT",
                .desc = "Number of transactions pushed from Rasterizer to the Z pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_pipe_profile__rasterizer_transaction_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "Sampler Active",
                .symbol_name = "SAMPLER_ACTIVE",
                .desc = "Percentage of time in which Sampler pipeline active",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__sampler_active__read,
                .max_float = NULL /* undefined */,
                .group = "Sampler",
            },

            {
                .name = "Sampler Input Available",
                .symbol_name = "SAMPLER_INPUT_AVAILABLE",
                .desc = "Percentage of time in which Sampler input is available",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__sampler_input_available__read,
                .max_float = NULL /* undefined */,
                .group = "Sampler",
            },

            {
                .name = "Sampler Memory Latency Stall",
                .symbol_name = "SAMPLER_MEMORY_LATENCY_STALL",
                .desc = "Percentage of time in which Sampler stalled due to latency hiding structure full",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__sampler_memory_latency_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Sampler",
            },

            {
                .name = "Sampler Output Ready",
                .symbol_name = "SAMPLER_OUTPUT_READY",
                .desc = "Percentage of time in which Sampler output is ready",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__sampler_output_ready__read,
                .max_float = NULL /* undefined */,
                .group = "Sampler",
            },

            {
                .name = "Streamout Primitive Storage Need",
                .symbol_name = "STREAMOUT_PRIMITIVE_STORAGE_NEED",
                .desc = "Number of objects data that needed beyond the current allocated space, read from pipe 0 only",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_pipe_profile__streamout_primitive_storage_need__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Stripsfan Output Ready",
                .symbol_name = "STRIPSFAN_OUTPUT_READY",
                .desc = "Percentage of time in which in which geometry pipeline output is ready",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__stripsfan_output_ready__read,
                .max_float = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Task Threadgroup Count",
                .symbol_name = "TASK_THREADGROUP_COUNT",
                .desc = "Number of Task Shader threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__render_pipe_profile__task_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Task Thread Exit Count",
                .symbol_name = "TASK_THREAD_EXIT_COUNT",
                .desc = "Number of Task Shader EOT messages received",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bmg__render_pipe_profile__task_thread_exit_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Threadgroup Dispatch Queue0 Resource Stall",
                .symbol_name = "THREADGROUP_DISPATCH_QUEUE0_RESOURCE_STALL",
                .desc = "Percentage of time in which Thread Spawner queue 0 is stalled waiting for any resource to be available (for example, SLM, Barrier, BTD stack, etc.)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__threadgroup_dispatch_queue0_resource_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Threadgroup Dispatch Queue1 Resource Stall",
                .symbol_name = "THREADGROUP_DISPATCH_QUEUE1_RESOURCE_STALL",
                .desc = "Percentage of time in which Thread Spawner queue 1 is stalled waiting for any resource to be available (for example, SLM, Barrier, BTD stack, etc.)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__threadgroup_dispatch_queue1_resource_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Thread Dispatch Input Available",
                .symbol_name = "THREAD_DISPATCH_INPUT_AVAILABLE",
                .desc = "Percentage of time in which Thread Dispatch input is available",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__thread_dispatch_input_available__read,
                .max_float = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Thread Dispatch PS Active",
                .symbol_name = "THREAD_DISPATCH_PS_ACTIVE",
                .desc = "Percentage of time in which Pixel Shader threads are ready for dispatch",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__thread_dispatch_ps_active__read,
                .max_float = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Thread Dispatch Queue0 Active",
                .symbol_name = "THREAD_DISPATCH_QUEUE0_ACTIVE",
                .desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__thread_dispatch_queue0_active__read,
                .max_float = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Thread Dispatch Queue0 Stall",
                .symbol_name = "THREAD_DISPATCH_QUEUE0_STALL",
                .desc = "Percentage of time in which queue 0 is stalled waiting for threads to be available",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__thread_dispatch_queue0_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Thread Dispatch Queue1 Active",
                .symbol_name = "THREAD_DISPATCH_QUEUE1_ACTIVE",
                .desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__thread_dispatch_queue1_active__read,
                .max_float = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Thread Dispatch Queue1 Stall",
                .symbol_name = "THREAD_DISPATCH_QUEUE1_STALL",
                .desc = "Percentage of time in which queue 1 is stalled waiting for threads to be available",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__thread_dispatch_queue1_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Vertex Fetch Input Available",
                .symbol_name = "VERTEX_FETCH_INPUT_AVAILABLE",
                .desc = "Percentage of time in which Vertex Fetch input is available",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__vertex_fetch_input_available__read,
                .max_float = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Vertex Fetch Output Ready",
                .symbol_name = "VERTEX_FETCH_OUTPUT_READY",
                .desc = "Percentage of time in which Vertex Fetch output is ready",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__vertex_fetch_output_ready__read,
                .max_float = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "VS Output Ready",
                .symbol_name = "VS_OUTPUT_READY",
                .desc = "Percentage of time in which Vertex Shader output is ready",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__render_pipe_profile__vs_output_ready__read,
                .max_float = NULL /* undefined */,
                .group = "Geometry",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_xe_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 44);
}


static void
bmg_add_rt_profile_metric_set(struct intel_xe_perf *perf)
{
    struct intel_xe_perf_metric_set *metric_set;
    struct intel_xe_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "RTProfile";
    metric_set->symbol_name = "RTProfile";
    metric_set->hw_config_guid = "da09a8a6-802c-48bc-8f3a-35834c9b8ba2";
    metric_set->counters = calloc(37, sizeof(struct intel_xe_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = XE_OA_FORMAT_PEC64u64;

    metric_set->perf_raw_size = 576;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->pec_offset = 2;
    bmg_rt_profile_add_registers(perf, metric_set);
    intel_xe_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_xe_perf_logical_counter _counters[] = {

            {
                .name = "Async GpGpu Threadgroup Count",
                .symbol_name = "ASYNC_GPGPU_THREADGROUP_COUNT",
                .desc = "Number of Async GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__async_gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bmg__rt_profile__avg_gpu_core_frequency__read,
                .max_uint64 = bmg__rt_profile__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GpGpu Threadgroup Count",
                .symbol_name = "GPGPU_THREADGROUP_COUNT",
                .desc = "Number of GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GPU_BUSY",
                .desc = "Percentage of time in which GPU is not idle including all GPU engines",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__rt_profile__gpu_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__rt_profile__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bmg__rt_profile__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "IA Vertex",
                .symbol_name = "IA_VERTEX",
                .desc = "Number of vertices in a draw",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__ia_vertex__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Rasterizer Sample Output",
                .symbol_name = "RASTERIZER_SAMPLE_OUTPUT",
                .desc = "Number of lit samples emitted by Rasterizer",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rasterizer_sample_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "RT Any Hit Thread Ray Dispatch",
                .symbol_name = "RT_ANY_HIT_THREAD_RAY_DISPATCH",
                .desc = "Number of any hit threads dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_any_hit_thread_ray_dispatch__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT BVH Cache Miss",
                .symbol_name = "RT_BVH_CACHE_MISS",
                .desc = "Number of BVH cache misses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_bvh_cache_miss__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Callable Thread Ray Dispatch",
                .symbol_name = "RT_CALLABLE_THREAD_RAY_DISPATCH",
                .desc = "Number of BTD shader spawn requests dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_callable_thread_ray_dispatch__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Closest Hit Thread Ray Dispatch",
                .symbol_name = "RT_CLOSEST_HIT_THREAD_RAY_DISPATCH",
                .desc = "Number of closest hit threads dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_closest_hit_thread_ray_dispatch__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Input Message Ray Count",
                .symbol_name = "RT_INPUT_MESSAGE_RAY_COUNT",
                .desc = "Number of valid SIMD lanes in the TraceRay message",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_input_message_ray_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Input Message Spawn Count",
                .symbol_name = "RT_INPUT_MESSAGE_SPAWN_COUNT",
                .desc = "Number of valid SIMD lanes in the Spawn message",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_input_message_spawn_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Instance Node Ray Count",
                .symbol_name = "RT_INSTANCE_NODE_RAY_COUNT",
                .desc = "Number of instance BVH nodes processed by the traversal function",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_instance_node_ray_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Internal Node Ray Count",
                .symbol_name = "RT_INTERNAL_NODE_RAY_COUNT",
                .desc = "Number of internal BVH nodes processed by the traversal function",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_internal_node_ray_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Intersection Thread Ray Dispatch",
                .symbol_name = "RT_INTERSECTION_THREAD_RAY_DISPATCH",
                .desc = "Number of intersection threads dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_intersection_thread_ray_dispatch__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Load Store Cache Read Message Count",
                .symbol_name = "RT_LOAD_STORE_CACHE_READ_MESSAGE_COUNT",
                .desc = "Number of read messages sent from Ray Tracing unit to the Load Store Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bmg__rt_profile__rt_load_store_cache_read_message_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "RT Load Store Cache Write From Message Count",
                .symbol_name = "RT_LOAD_STORE_CACHE_WRITE_FROM_MESSAGE_COUNT",
                .desc = "Number of write messages sent from Ray Tracing unit to the Load Store Cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = bmg__rt_profile__rt_load_store_cache_write_from_message_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1 Cache",
            },

            {
                .name = "RT Message Stall",
                .symbol_name = "RT_MESSAGE_STALL",
                .desc = "Percentage of time in which Ray Tracing message input is stalled while accepting input",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__rt_profile__rt_message_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Miss Thread Ray Dispatch",
                .symbol_name = "RT_MISS_THREAD_RAY_DISPATCH",
                .desc = "Number of miss threads dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_miss_thread_ray_dispatch__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Procedural Node Ray Count",
                .symbol_name = "RT_PROCEDURAL_NODE_RAY_COUNT",
                .desc = "Number of procedural BVH nodes processed by the traversal function",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_procedural_node_ray_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Quad Leaf Ray Count",
                .symbol_name = "RT_QUAD_LEAF_RAY_COUNT",
                .desc = "Number of triangle BVH nodes processed by the traversal function",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_quad_leaf_ray_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Quad Test Ray Count",
                .symbol_name = "RT_QUAD_TEST_RAY_COUNT",
                .desc = "Number of nodes processed that use ray-quad intersection pipeline",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_quad_test_ray_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Request Collision",
                .symbol_name = "RT_REQUEST_COLLISION",
                .desc = "Percentage of time in which Ray Tracing Leaf has two Traversal inputs valid",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__rt_profile__rt_request_collision__read,
                .max_float = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Transform Ray Count",
                .symbol_name = "RT_TRANSFORM_RAY_COUNT",
                .desc = "Number of only HW transform accesses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_transform_ray_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Traversal Input Ray Count",
                .symbol_name = "RT_TRAVERSAL_INPUT_RAY_COUNT",
                .desc = "Number of Ray Tracing Traversal input rays",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_traversal_input_ray_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Traversal Output Ray Count",
                .symbol_name = "RT_TRAVERSAL_OUTPUT_RAY_COUNT",
                .desc = "Number of Ray Tracing Traversal output rays",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_traversal_output_ray_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Traversal Stall",
                .symbol_name = "RT_TRAVERSAL_STALL",
                .desc = "Percentage of time in which Ray Tracing Frontend is stalled by Traversal",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__rt_profile__rt_traversal_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "RT Traversal Step Ray Count",
                .symbol_name = "RT_TRAVERSAL_STEP_RAY_COUNT",
                .desc = "Number of BVH nodes processed",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__rt_traversal_step_ray_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Ray Tracing",
            },

            {
                .name = "XVE Inst Executed ALU0 RT AHS",
                .symbol_name = "XVE_INST_EXECUTED_ALU0_RT_AHS",
                .desc = "Number of execution slots taken by instructions executed by RT_AHS threads on ALU0 pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__xve_inst_executed_alu0_rt_ahs__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU0 RT CHS",
                .symbol_name = "XVE_INST_EXECUTED_ALU0_RT_CHS",
                .desc = "Number of execution slots taken by instructions executed by RT_CHS threads on ALU0 pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__xve_inst_executed_alu0_rt_chs__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU0 RT MS",
                .symbol_name = "XVE_INST_EXECUTED_ALU0_RT_MS",
                .desc = "Number of execution slots taken by instructions executed by RT_MS threads on ALU0 pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__xve_inst_executed_alu0_rt_ms__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU1 RT AHS",
                .symbol_name = "XVE_INST_EXECUTED_ALU1_RT_AHS",
                .desc = "Number of execution slots taken by instructions executed by RT_AHS threads on ALU1 pipe. Does not include extended math instructions.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__xve_inst_executed_alu1_rt_ahs__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU1 RT CHS",
                .symbol_name = "XVE_INST_EXECUTED_ALU1_RT_CHS",
                .desc = "Number of execution slots taken by instructions executed by RT_CHS threads on ALU1 pipe. Does not include extended math instructions.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__xve_inst_executed_alu1_rt_chs__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU1 RT MS",
                .symbol_name = "XVE_INST_EXECUTED_ALU1_RT_MS",
                .desc = "Number of execution slots taken by instructions executed by RT_MS threads on ALU1 pipe. Does not include extended math instructions.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__rt_profile__xve_inst_executed_alu1_rt_ms__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Threads Occupancy All",
                .symbol_name = "XVE_THREADS_OCCUPANCY_ALL",
                .desc = "Percentage of thread slots occupied by ALL threads",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__rt_profile__xve_threads_occupancy_all__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_xe_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 37);
}


static void
bmg_add_vector_engine_profile_metric_set(struct intel_xe_perf *perf)
{
    struct intel_xe_perf_metric_set *metric_set;
    struct intel_xe_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "VectorEngineProfile";
    metric_set->symbol_name = "VectorEngineProfile";
    metric_set->hw_config_guid = "dfe5251f-af3e-434c-b627-38490f2213da";
    metric_set->counters = calloc(54, sizeof(struct intel_xe_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = XE_OA_FORMAT_PEC64u64;

    metric_set->perf_raw_size = 576;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->pec_offset = 2;
    bmg_vector_engine_profile_add_registers(perf, metric_set);
    intel_xe_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_xe_perf_logical_counter _counters[] = {

            {
                .name = "Async GpGpu Threadgroup Count",
                .symbol_name = "ASYNC_GPGPU_THREADGROUP_COUNT",
                .desc = "Number of Async GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__async_gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bmg__vector_engine_profile__avg_gpu_core_frequency__read,
                .max_uint64 = bmg__vector_engine_profile__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Command Parser Compute Engine Busy",
                .symbol_name = "COMMAND_PARSER_COMPUTE_ENGINE_BUSY",
                .desc = "Percentage of time in which there is a context loaded and active on the compute queue",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_profile__command_parser_compute_engine_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "Command Parser Compute Engine Dispatch Kernel Count",
                .symbol_name = "COMMAND_PARSER_COMPUTE_ENGINE_DISPATCH_KERNEL_COUNT",
                .desc = "Number of compute walker commands parsed on the compute engine",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__command_parser_compute_engine_dispatch_kernel_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "Command Parser Render Engine Busy",
                .symbol_name = "COMMAND_PARSER_RENDER_ENGINE_BUSY",
                .desc = "Percentage of time in which there is a context loaded and active on the 3D queue",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_profile__command_parser_render_engine_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "Command Parser Render Engine Dispatch Kernel Count",
                .symbol_name = "COMMAND_PARSER_RENDER_ENGINE_DISPATCH_KERNEL_COUNT",
                .desc = "Number of compute walker commands parsed on the 3D engine",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__command_parser_render_engine_dispatch_kernel_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "Compressor Input",
                .symbol_name = "COMPRESSOR_INPUT",
                .desc = "Number of 256B writes to compressible surfaces at the input of the compressor",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__compressor_input__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "Compressor Output",
                .symbol_name = "COMPRESSOR_OUTPUT",
                .desc = "Number of 256B writes to compressible surfaces at the output of the compressor",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__compressor_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GpGpu Threadgroup Count",
                .symbol_name = "GPGPU_THREADGROUP_COUNT",
                .desc = "Number of GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GPU_BUSY",
                .desc = "Percentage of time in which GPU is not idle including all GPU engines",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_profile__gpu_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "GPU Memory Byte Read",
                .symbol_name = "GPU_MEMORY_BYTE_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__vector_engine_profile__gpu_memory_byte_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory Byte Read Rate",
                .symbol_name = "GPU_MEMORY_BYTE_READ_RATE",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = bmg__vector_engine_profile__gpu_memory_byte_read_rate__read,
                .max_float = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory Byte Write",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = bmg__vector_engine_profile__gpu_memory_byte_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Memory Byte Write Rate",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE_RATE",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = bmg__vector_engine_profile__gpu_memory_byte_write_rate__read,
                .max_float = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__vector_engine_profile__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bmg__vector_engine_profile__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "IA Vertex",
                .symbol_name = "IA_VERTEX",
                .desc = "Number of vertices in a draw",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__ia_vertex__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "ICache Hit",
                .symbol_name = "ICACHE_HIT",
                .desc = "Number of Instruction Cache hits",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__icache_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "ICache Miss",
                .symbol_name = "ICACHE_MISS",
                .desc = "Number of Instruction Cache misses",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__icache_miss__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "L3 Atomic Access",
                .symbol_name = "L3_ATOMIC_ACCESS",
                .desc = "Number of atomic accesses to Device Cache bank",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__l3_atomic_access__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Hit",
                .symbol_name = "L3_HIT",
                .desc = "Number of Device Cache accesses which hits in the Device Cache cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__l3_hit__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Miss",
                .symbol_name = "L3_MISS",
                .desc = "Number of Device Cache accesses which miss in the Device Cache cache",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__l3_miss__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Read",
                .symbol_name = "L3_READ",
                .desc = "Number of Device Cache 64B read requests",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__l3_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "L3 Write",
                .symbol_name = "L3_WRITE",
                .desc = "Number of Device Cache 64B write requests",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__l3_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Device Cache",
            },

            {
                .name = "Rasterizer Sample Output",
                .symbol_name = "RASTERIZER_SAMPLE_OUTPUT",
                .desc = "Number of lit samples emitted by Rasterizer",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__rasterizer_sample_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "TLB Miss",
                .symbol_name = "TLB_MISS",
                .desc = "Number of misses from all TLBs and all engines",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__tlb_miss__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "XVE Active",
                .symbol_name = "XVE_ACTIVE",
                .desc = "Percentage of time in which at least one pipe is active in XVE",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_profile__xve_active__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU0 All",
                .symbol_name = "XVE_INST_EXECUTED_ALU0_ALL",
                .desc = "Number of execution slots taken by instructions executed by ALL threads on ALU0 pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_alu0_all__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU1 All",
                .symbol_name = "XVE_INST_EXECUTED_ALU1_ALL",
                .desc = "Number of execution slots taken by instructions executed by ALL threads on ALU1 pipe. Does not include extended math instructions.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_alu1_all__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed ALU2 All",
                .symbol_name = "XVE_INST_EXECUTED_ALU2_ALL",
                .desc = "Number of execution slots taken by instructions executed in ALU2 pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_alu2_all__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Barrier",
                .symbol_name = "XVE_INST_EXECUTED_BARRIER",
                .desc = "Number of sync.bar and sync.host instructions executed",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_barrier__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Bitconv",
                .symbol_name = "XVE_INST_EXECUTED_BITCONV",
                .desc = "Number of execution slots taken by bit manipulation instructions",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_bitconv__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Control All",
                .symbol_name = "XVE_INST_EXECUTED_CONTROL_ALL",
                .desc = "Number of instructions executed on JEU Pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_control_all__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Fp16",
                .symbol_name = "XVE_INST_EXECUTED_FP16",
                .desc = "Number of execution slots taken by FP16 ALU instructions. Does not include extended math instructions.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_fp16__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Fp32",
                .symbol_name = "XVE_INST_EXECUTED_FP32",
                .desc = "Number of execution slots taken by FP32 ALU instructions. Does not include extended math instructions.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_fp32__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Fp64",
                .symbol_name = "XVE_INST_EXECUTED_FP64",
                .desc = "Number of execution slots taken by FP64 ALU instructions",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_fp64__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Fp64 2nd",
                .symbol_name = "XVE_INST_EXECUTED_FP64_2ND",
                .desc = "Number of execution slots taken by FP64 ALU instructions executed in the second pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_fp64_2_nd__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Int16",
                .symbol_name = "XVE_INST_EXECUTED_INT16",
                .desc = "Number of execution slots taken by INT16 ALU instructions",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_int16__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Int32",
                .symbol_name = "XVE_INST_EXECUTED_INT32",
                .desc = "Number of execution slots taken by INT32 ALU instructions",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_int32__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Int64",
                .symbol_name = "XVE_INST_EXECUTED_INT64",
                .desc = "Number of execution slots taken by INT64 instructions",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_int64__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Math",
                .symbol_name = "XVE_INST_EXECUTED_MATH",
                .desc = "Number of execution slots taken by extended math instructions",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_math__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Nondivergent",
                .symbol_name = "XVE_INST_EXECUTED_NONDIVERGENT",
                .desc = "Number of non-divergent instructions (not execution slots) executed",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_nondivergent__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Predication",
                .symbol_name = "XVE_INST_EXECUTED_PREDICATION",
                .desc = "Number of instructions (not execution slots) executed with predication mask enabled",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_predication__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed Send All",
                .symbol_name = "XVE_INST_EXECUTED_SEND_ALL",
                .desc = "Number of instruction (GRF) dispatches executed by ALL threads on SEND Pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_send_all__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed XMX Bf16",
                .symbol_name = "XVE_INST_EXECUTED_XMX_BF16",
                .desc = "Number of execution slots taken by BF16 XMX instructions",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_xmx_bf16__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed XMX Fp16",
                .symbol_name = "XVE_INST_EXECUTED_XMX_FP16",
                .desc = "Number of execution slots taken by FP16 XMX instructions",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_xmx_fp16__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed XMX Int2",
                .symbol_name = "XVE_INST_EXECUTED_XMX_INT2",
                .desc = "Number of execution slots taken by INT2 XMX instructions",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_xmx_int2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed XMX Int4",
                .symbol_name = "XVE_INST_EXECUTED_XMX_INT4",
                .desc = "Number of execution slots taken by INT4 XMX instructions",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_xmx_int4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Executed XMX Int8",
                .symbol_name = "XVE_INST_EXECUTED_XMX_INT8",
                .desc = "Number of execution slots taken by INT8 XMX instructions",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_executed_xmx_int8__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Inst Issued All",
                .symbol_name = "XVE_INST_ISSUED_ALL",
                .desc = "Number of instructions issued (decoded) to any pipe",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_profile__xve_inst_issued_all__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Multiple Pipe Active",
                .symbol_name = "XVE_MULTIPLE_PIPE_ACTIVE",
                .desc = "Percentage of time in which at least two pipes are actively executing a Gen ISA instruction among ALU0, ALU1 and ALU2 pipes",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_profile__xve_multiple_pipe_active__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Pipe ALU0 And ALU1 Active",
                .symbol_name = "XVE_PIPE_ALU0_AND_ALU1_ACTIVE",
                .desc = "Percentage of time in which ALU0 and ALU1 pipes are both actively executing a Gen ISA instruction",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_profile__xve_pipe_alu0_and_alu1_active__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Pipe ALU0 And ALU2 Active",
                .symbol_name = "XVE_PIPE_ALU0_AND_ALU2_ACTIVE",
                .desc = "Percentage of time in which ALU0 and ALU2 pipes are both actively executing a Gen ISA instruction",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_profile__xve_pipe_alu0_and_alu2_active__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Threads Occupancy All",
                .symbol_name = "XVE_THREADS_OCCUPANCY_ALL",
                .desc = "Percentage of thread slots occupied by ALL threads",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_profile__xve_threads_occupancy_all__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_xe_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 54);
}


static void
bmg_add_vector_engine_stalls_metric_set(struct intel_xe_perf *perf)
{
    struct intel_xe_perf_metric_set *metric_set;
    struct intel_xe_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "VectorEngineStalls";
    metric_set->symbol_name = "VectorEngineStalls";
    metric_set->hw_config_guid = "d008dcae-2a82-4929-a94d-2ba1e9c569d6";
    metric_set->counters = calloc(30, sizeof(struct intel_xe_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = XE_OA_FORMAT_PEC64u64;

    metric_set->perf_raw_size = 576;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->pec_offset = 2;
    bmg_vector_engine_stalls_add_registers(perf, metric_set);
    intel_xe_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_xe_perf_logical_counter _counters[] = {

            {
                .name = "Async GpGpu Threadgroup Count",
                .symbol_name = "ASYNC_GPGPU_THREADGROUP_COUNT",
                .desc = "Number of Async GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_stalls__async_gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bmg__vector_engine_stalls__avg_gpu_core_frequency__read,
                .max_uint64 = bmg__vector_engine_stalls__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GpGpu Threadgroup Count",
                .symbol_name = "GPGPU_THREADGROUP_COUNT",
                .desc = "Number of GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_stalls__gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GPU_BUSY",
                .desc = "Percentage of time in which GPU is not idle including all GPU engines",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__gpu_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__vector_engine_stalls__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bmg__vector_engine_stalls__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "IA Vertex",
                .symbol_name = "IA_VERTEX",
                .desc = "Number of vertices in a draw",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_stalls__ia_vertex__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Rasterizer Sample Output",
                .symbol_name = "RASTERIZER_SAMPLE_OUTPUT",
                .desc = "Number of lit samples emitted by Rasterizer",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__vector_engine_stalls__rasterizer_sample_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "Threadgroup Dispatch Queue0 Resource Stall",
                .symbol_name = "THREADGROUP_DISPATCH_QUEUE0_RESOURCE_STALL",
                .desc = "Percentage of time in which Thread Spawner queue 0 is stalled waiting for any resource to be available (for example, SLM, Barrier, BTD stack, etc.)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__threadgroup_dispatch_queue0_resource_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Threadgroup Dispatch Queue1 Resource Stall",
                .symbol_name = "THREADGROUP_DISPATCH_QUEUE1_RESOURCE_STALL",
                .desc = "Percentage of time in which Thread Spawner queue 1 is stalled waiting for any resource to be available (for example, SLM, Barrier, BTD stack, etc.)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__threadgroup_dispatch_queue1_resource_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Thread Dispatch Queue0 Active",
                .symbol_name = "THREAD_DISPATCH_QUEUE0_ACTIVE",
                .desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__thread_dispatch_queue0_active__read,
                .max_float = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Thread Dispatch Queue0 Stall",
                .symbol_name = "THREAD_DISPATCH_QUEUE0_STALL",
                .desc = "Percentage of time in which queue 0 is stalled waiting for threads to be available",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__thread_dispatch_queue0_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Thread Dispatch Queue1 Active",
                .symbol_name = "THREAD_DISPATCH_QUEUE1_ACTIVE",
                .desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__thread_dispatch_queue1_active__read,
                .max_float = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "Thread Dispatch Queue1 Stall",
                .symbol_name = "THREAD_DISPATCH_QUEUE1_STALL",
                .desc = "Percentage of time in which queue 1 is stalled waiting for threads to be available",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__thread_dispatch_queue1_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "XVE Active",
                .symbol_name = "XVE_ACTIVE",
                .desc = "Percentage of time in which at least one pipe is active in XVE",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_active__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Multiple Pipe Active",
                .symbol_name = "XVE_MULTIPLE_PIPE_ACTIVE",
                .desc = "Percentage of time in which at least two pipes are actively executing a Gen ISA instruction among ALU0, ALU1 and ALU2 pipes",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_multiple_pipe_active__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Pipe ALU0 And ALU1 Active",
                .symbol_name = "XVE_PIPE_ALU0_AND_ALU1_ACTIVE",
                .desc = "Percentage of time in which ALU0 and ALU1 pipes are both actively executing a Gen ISA instruction",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_pipe_alu0_and_alu1_active__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Pipe ALU0 And ALU2 Active",
                .symbol_name = "XVE_PIPE_ALU0_AND_ALU2_ACTIVE",
                .desc = "Percentage of time in which ALU0 and ALU2 pipes are both actively executing a Gen ISA instruction",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_pipe_alu0_and_alu2_active__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Shared Function Access Hold",
                .symbol_name = "XVE_SHARED_FUNCTION_ACCESS_HOLD",
                .desc = "Percentage of time in which XVE requests stalled by Shared Function units",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_shared_function_access_hold__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Stall",
                .symbol_name = "XVE_STALL",
                .desc = "Percentage of time in which any thread loaded but not even a single pipe is active in XVE",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_stall__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Stall Aluwr",
                .symbol_name = "XVE_STALL_ALUWR",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for ALU to write GRF/ACC register. Multiple stall reasons can qualify during the same cycle",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_stall_aluwr__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Stall Barrier",
                .symbol_name = "XVE_STALL_BARRIER",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for Gateway to write Notify register. Multiple stall reasons can qualify during the same cycle",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_stall_barrier__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Stall Control",
                .symbol_name = "XVE_STALL_CONTROL",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for JEU to complete branch instruction. Multiple stall reasons can qualify during the same cycle",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_stall_control__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Stall Instfetch",
                .symbol_name = "XVE_STALL_INSTFETCH",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for Instruction Fetch. Multiple stall reasons can qualify during the same cycle",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_stall_instfetch__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Stall Other",
                .symbol_name = "XVE_STALL_OTHER",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting on any other dependency (Flag/EoT etc). Multiple stall reasons can qualify during the same cycle",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_stall_other__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Stall Pipestall",
                .symbol_name = "XVE_STALL_PIPESTALL",
                .desc = "Percentage of time in which XVE stalled, with at least one thread ready to be scheduled (Grf conf/send holds etc). Multiple stall reasons can qualify during the same cycle",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_stall_pipestall__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Stall PS Dependency",
                .symbol_name = "XVE_STALL_PS_DEPENDENCY",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting on Pixel Shader dependency",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_stall_ps_dependency__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Stall Sbid",
                .symbol_name = "XVE_STALL_SBID",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for Scoreboard token to be available. Multiple stall reasons can qualify during the same cycle",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_stall_sbid__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Stall Sendwr",
                .symbol_name = "XVE_STALL_SENDWR",
                .desc = "Percentage of time in which XVE stalled, with at least one thread waiting for SEND message to be dispatched from XVE. Multiple stall reasons can qualify during the same cycle",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_stall_sendwr__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },

            {
                .name = "XVE Threads Occupancy All",
                .symbol_name = "XVE_THREADS_OCCUPANCY_ALL",
                .desc = "Percentage of thread slots occupied by ALL threads",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__vector_engine_stalls__xve_threads_occupancy_all__read,
                .max_float = NULL /* undefined */,
                .group = "Vector Engine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_xe_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 30);
}

static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE0_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE1_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE10_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 10, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE11_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 11, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE12_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 12, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE13_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 13, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE14_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 14, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE15_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 15, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE16_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 16, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE17_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 17, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE18_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 18, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE19_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 19, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE2_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE20_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 20, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE21_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 21, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE22_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 22, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE23_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 23, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE24_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 24, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE25_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 25, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE26_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 26, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE27_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 27, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE3_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE4_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE5_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE6_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 6, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE7_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 7, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE8_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 8, 0)) {
        return true;
    }
    return false;
}
static bool bmg_test_oa_TEST_EVENT1_CYCLES_XECORE9_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 9, 0)) {
        return true;
    }
    return false;
}

static void
bmg_add_test_oa_metric_set(struct intel_xe_perf *perf)
{
    struct intel_xe_perf_metric_set *metric_set;
    struct intel_xe_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TestOa";
    metric_set->symbol_name = "TestOa";
    metric_set->hw_config_guid = "9ec392a7-4c77-4253-a28a-85240821e82c";
    metric_set->counters = calloc(41, sizeof(struct intel_xe_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = XE_OA_FORMAT_PEC64u64;

    metric_set->perf_raw_size = 576;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->pec_offset = 2;
    bmg_test_oa_add_registers(perf, metric_set);
    intel_xe_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_xe_perf_logical_counter _counters[] = {

            {
                .name = "Async GpGpu Threadgroup Count",
                .symbol_name = "ASYNC_GPGPU_THREADGROUP_COUNT",
                .desc = "Number of Async GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__test_oa__async_gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = bmg__test_oa__avg_gpu_core_frequency__read,
                .max_uint64 = bmg__test_oa__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GpGpu Threadgroup Count",
                .symbol_name = "GPGPU_THREADGROUP_COUNT",
                .desc = "Number of GPGPU threadgroups dispatched",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__test_oa__gpgpu_threadgroup_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Thread Dispatcher",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GPU_BUSY",
                .desc = "Percentage of time in which GPU is not idle including all GPU engines",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__test_oa__gpu_busy__read,
                .max_float = NULL /* undefined */,
                .group = "Front End",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = bmg__test_oa__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "IA Vertex",
                .symbol_name = "IA_VERTEX",
                .desc = "Number of vertices in a draw",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__test_oa__ia_vertex__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Geometry",
            },

            {
                .name = "Rasterizer Sample Output",
                .symbol_name = "RASTERIZER_SAMPLE_OUTPUT",
                .desc = "Number of lit samples emitted by Rasterizer",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = bmg__test_oa__rasterizer_sample_output__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "Test Event1",
                .symbol_name = "TEST_EVENT1",
                .desc = "Number of GPU (gt) clock cycles at every clock period",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__test_oa__test_event1__read,
                .max_float = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "Test Event1 Cycles",
                .symbol_name = "TEST_EVENT1_CYCLES",
                .desc = "Number of GPU (gt) clock cycles at every clock period",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "Test Event1 Cycles Average",
                .symbol_name = "TEST_EVENT1_CYCLES_AVERAGE",
                .desc = "Average number of GPU (gt) clock cycles at every clock period",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_average__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "Test Event1 Cycles Xecore0",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE0",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE0)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE0_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore1",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE1",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE1)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE1_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore10",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE10",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE10)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore10__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE10_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore11",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE11",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE11)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore11__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE11_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore12",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE12",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE12)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore12__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE12_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore13",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE13",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE13)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore13__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE13_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore14",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE14",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE14)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore14__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE14_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore15",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE15",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE15)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore15__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE15_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore16",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE16",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE16)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore16__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE16_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore17",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE17",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE17)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore17__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE17_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore18",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE18",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE18)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore18__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE18_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore19",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE19",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE19)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore19__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE19_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore2",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE2",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE2)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE2_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore20",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE20",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE20)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore20__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE20_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore21",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE21",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE21)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore21__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE21_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore22",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE22",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE22)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore22__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE22_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore23",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE23",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE23)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore23__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE23_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore24",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE24",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE24)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore24__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE24_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore25",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE25",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE25)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore25__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE25_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore26",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE26",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE26)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore26__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE26_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore27",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE27",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE27)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore27__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE27_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore3",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE3",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE3)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE3_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore4",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE4",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE4)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE4_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore5",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE5",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE5)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE5_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore6",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE6",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE6)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE6_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore7",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE7",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE7)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE7_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore8",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE8",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE8)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore8__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE8_availability,
            },

            {
                .name = "Test Event1 Cycles Xecore9",
                .symbol_name = "TEST_EVENT1_CYCLES_XECORE9",
                .desc = "Number of GPU (gt) clock cycles at every clock period (XECORE9)",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event1_cycles_xecore9__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
                .availability = bmg_test_oa_TEST_EVENT1_CYCLES_XECORE9_availability,
            },

            {
                .name = "Test Event2",
                .symbol_name = "TEST_EVENT2",
                .desc = "Number of GPU (gt) clock cycles at every other clock period",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = bmg__test_oa__test_event2__read,
                .max_float = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "Test Event2 Cycles",
                .symbol_name = "TEST_EVENT2_CYCLES",
                .desc = "Number of GPU (gt) clock cycles at every other clock period",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = bmg__test_oa__test_event2_cycles__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_xe_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 41);
}

void
intel_xe_perf_load_metrics_bmg(struct intel_xe_perf *perf)
{
    bmg_add_render_basic_metric_set(perf);
    bmg_add_compute_basic_metric_set(perf);
    bmg_add_depth_profile_metric_set(perf);
    bmg_add_device_cache_profile_metric_set(perf);
    bmg_add_memory_profile_metric_set(perf);
    bmg_add_render_pipe_profile_metric_set(perf);
    bmg_add_rt_profile_metric_set(perf);
    bmg_add_vector_engine_profile_metric_set(perf);
    bmg_add_vector_engine_stalls_metric_set(perf);
    bmg_add_test_oa_metric_set(perf);
}
