#include "main.ih"

namespace
{
    Arg::LongOption longOpts[] =
    {
        Arg::LongOption{"colors",       'c'},
        Arg::LongOption{"dependencies", 'd'},
        Arg::LongOption{"help",         'h'},
        Arg::LongOption{"ignore",       'i'},
        Arg::LongOption{"module",       'm'},
        Arg::LongOption{"subdir",       's'},
        Arg::LongOption{"version",      'v'},
        Arg::LongOption{"verbose",      'V'},
    };
    auto longEnd = longOpts + size(longOpts);
}

int main(int argc, char **argv)
try
{
    Arg const &arg = Arg::initialize("cdhi:m:svV", longOpts, longEnd, 
                                                   argc, argv);
    arg.versionHelp(usage, VERSION, 1);

    Modules modules;            // CLASSES or --noclasses must be present

    modules.fill();             // determine the subdirs defining modules

    if (not modules.checkCircular())
        return 1;

    if (not modules.showDeps())
        modules.compile();
}
catch (...)
{
    return handleException();
}

