{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoAttrFontDesc@ structure is used to store an attribute that
-- sets all aspects of the font description at once.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.AttrFontDesc
    ( 

-- * Exported types
    AttrFontDesc(..)                        ,
    newZeroAttrFontDesc                     ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveAttrFontDescMethod               ,
#endif

-- ** new #method:new#

    attrFontDescNew                         ,




 -- * Properties


-- ** attr #attr:attr#
-- | the common portion of the attribute

#if defined(ENABLE_OVERLOADING)
    attrFontDesc_attr                       ,
#endif
    getAttrFontDescAttr                     ,


-- ** desc #attr:desc#
-- | the font description which is the value of this attribute

#if defined(ENABLE_OVERLOADING)
    attrFontDesc_desc                       ,
#endif
    clearAttrFontDescDesc                   ,
    getAttrFontDescDesc                     ,
    setAttrFontDescDesc                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription

#endif

-- | Memory-managed wrapper type.
newtype AttrFontDesc = AttrFontDesc (SP.ManagedPtr AttrFontDesc)
    deriving (Eq)

instance SP.ManagedPtrNewtype AttrFontDesc where
    toManagedPtr (AttrFontDesc p) = p

instance BoxedPtr AttrFontDesc where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr AttrFontDesc)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr AttrFontDesc where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'AttrFontDesc' struct initialized to zero.
newZeroAttrFontDesc :: MonadIO m => m AttrFontDesc
newZeroAttrFontDesc = liftIO $ boxedPtrCalloc >>= wrapPtr AttrFontDesc

instance tag ~ 'AttrSet => Constructible AttrFontDesc tag where
    new _ attrs = do
        o <- newZeroAttrFontDesc
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@attr@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrFontDesc #attr
-- @
getAttrFontDescAttr :: MonadIO m => AttrFontDesc -> m Pango.Attribute.Attribute
getAttrFontDescAttr s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Pango.Attribute.Attribute)
    val' <- (newBoxed Pango.Attribute.Attribute) val
    return val'

#if defined(ENABLE_OVERLOADING)
data AttrFontDescAttrFieldInfo
instance AttrInfo AttrFontDescAttrFieldInfo where
    type AttrBaseTypeConstraint AttrFontDescAttrFieldInfo = (~) AttrFontDesc
    type AttrAllowedOps AttrFontDescAttrFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint AttrFontDescAttrFieldInfo = (~) (Ptr Pango.Attribute.Attribute)
    type AttrTransferTypeConstraint AttrFontDescAttrFieldInfo = (~)(Ptr Pango.Attribute.Attribute)
    type AttrTransferType AttrFontDescAttrFieldInfo = (Ptr Pango.Attribute.Attribute)
    type AttrGetType AttrFontDescAttrFieldInfo = Pango.Attribute.Attribute
    type AttrLabel AttrFontDescAttrFieldInfo = "attr"
    type AttrOrigin AttrFontDescAttrFieldInfo = AttrFontDesc
    attrGet = getAttrFontDescAttr
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrFontDesc.attr"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrFontDesc.html#g:attr:attr"
        })

attrFontDesc_attr :: AttrLabelProxy "attr"
attrFontDesc_attr = AttrLabelProxy

#endif


-- | Get the value of the “@desc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrFontDesc #desc
-- @
getAttrFontDescDesc :: MonadIO m => AttrFontDesc -> m (Maybe Pango.FontDescription.FontDescription)
getAttrFontDescDesc s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (Ptr Pango.FontDescription.FontDescription)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newBoxed Pango.FontDescription.FontDescription) val'
        return val''
    return result

-- | Set the value of the “@desc@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attrFontDesc [ #desc 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttrFontDescDesc :: MonadIO m => AttrFontDesc -> Ptr Pango.FontDescription.FontDescription -> m ()
setAttrFontDescDesc s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Ptr Pango.FontDescription.FontDescription)

-- | Set the value of the “@desc@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #desc
-- @
clearAttrFontDescDesc :: MonadIO m => AttrFontDesc -> m ()
clearAttrFontDescDesc s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: Ptr Pango.FontDescription.FontDescription)

#if defined(ENABLE_OVERLOADING)
data AttrFontDescDescFieldInfo
instance AttrInfo AttrFontDescDescFieldInfo where
    type AttrBaseTypeConstraint AttrFontDescDescFieldInfo = (~) AttrFontDesc
    type AttrAllowedOps AttrFontDescDescFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AttrFontDescDescFieldInfo = (~) (Ptr Pango.FontDescription.FontDescription)
    type AttrTransferTypeConstraint AttrFontDescDescFieldInfo = (~)(Ptr Pango.FontDescription.FontDescription)
    type AttrTransferType AttrFontDescDescFieldInfo = (Ptr Pango.FontDescription.FontDescription)
    type AttrGetType AttrFontDescDescFieldInfo = Maybe Pango.FontDescription.FontDescription
    type AttrLabel AttrFontDescDescFieldInfo = "desc"
    type AttrOrigin AttrFontDescDescFieldInfo = AttrFontDesc
    attrGet = getAttrFontDescDesc
    attrSet = setAttrFontDescDesc
    attrConstruct = undefined
    attrClear = clearAttrFontDescDesc
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrFontDesc.desc"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrFontDesc.html#g:attr:desc"
        })

attrFontDesc_desc :: AttrLabelProxy "desc"
attrFontDesc_desc = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AttrFontDesc
type instance O.AttributeList AttrFontDesc = AttrFontDescAttributeList
type AttrFontDescAttributeList = ('[ '("attr", AttrFontDescAttrFieldInfo), '("desc", AttrFontDescDescFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method AttrFontDesc::new
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "desc"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "FontDescription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the font description"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Attribute" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attr_font_desc_new" pango_attr_font_desc_new :: 
    Ptr Pango.FontDescription.FontDescription -> -- desc : TInterface (Name {namespace = "Pango", name = "FontDescription"})
    IO (Ptr Pango.Attribute.Attribute)

-- | Create a new font description attribute.
-- 
-- This attribute allows setting family, style, weight, variant,
-- stretch, and size simultaneously.
attrFontDescNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Pango.FontDescription.FontDescription
    -- ^ /@desc@/: the font description
    -> m Pango.Attribute.Attribute
    -- ^ __Returns:__ the newly allocated
    --   @PangoAttribute@, which should be freed with
    --   'GI.Pango.Structs.Attribute.attributeDestroy'
attrFontDescNew desc = liftIO $ do
    desc' <- unsafeManagedPtrGetPtr desc
    result <- pango_attr_font_desc_new desc'
    checkUnexpectedReturnNULL "attrFontDescNew" result
    result' <- (wrapBoxed Pango.Attribute.Attribute) result
    touchManagedPtr desc
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAttrFontDescMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAttrFontDescMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAttrFontDescMethod t AttrFontDesc, O.OverloadedMethod info AttrFontDesc p) => OL.IsLabel t (AttrFontDesc -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAttrFontDescMethod t AttrFontDesc, O.OverloadedMethod info AttrFontDesc p, R.HasField t AttrFontDesc p) => R.HasField t AttrFontDesc p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAttrFontDescMethod t AttrFontDesc, O.OverloadedMethodInfo info AttrFontDesc) => OL.IsLabel t (O.MethodProxy info AttrFontDesc) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


