{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node for a repeating radial gradient.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.RepeatingRadialGradientNode
    ( 

-- * Exported types
    RepeatingRadialGradientNode(..)         ,
    IsRepeatingRadialGradientNode           ,
    toRepeatingRadialGradientNode           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveRepeatingRadialGradientNodeMethod,
#endif

-- ** new #method:new#

    repeatingRadialGradientNodeNew          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop

#else
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop

#endif

-- | Memory-managed wrapper type.
newtype RepeatingRadialGradientNode = RepeatingRadialGradientNode (SP.ManagedPtr RepeatingRadialGradientNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype RepeatingRadialGradientNode where
    toManagedPtr (RepeatingRadialGradientNode p) = p

foreign import ccall "gsk_repeating_radial_gradient_node_get_type"
    c_gsk_repeating_radial_gradient_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject RepeatingRadialGradientNode where
    glibType = c_gsk_repeating_radial_gradient_node_get_type

-- | Type class for types which can be safely cast to t'RepeatingRadialGradientNode', for instance with `toRepeatingRadialGradientNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf RepeatingRadialGradientNode o) => IsRepeatingRadialGradientNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf RepeatingRadialGradientNode o) => IsRepeatingRadialGradientNode o

instance O.HasParentTypes RepeatingRadialGradientNode
type instance O.ParentTypes RepeatingRadialGradientNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'RepeatingRadialGradientNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toRepeatingRadialGradientNode :: (MIO.MonadIO m, IsRepeatingRadialGradientNode o) => o -> m RepeatingRadialGradientNode
toRepeatingRadialGradientNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo RepeatingRadialGradientNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveRepeatingRadialGradientNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveRepeatingRadialGradientNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveRepeatingRadialGradientNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveRepeatingRadialGradientNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveRepeatingRadialGradientNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveRepeatingRadialGradientNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveRepeatingRadialGradientNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveRepeatingRadialGradientNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveRepeatingRadialGradientNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveRepeatingRadialGradientNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveRepeatingRadialGradientNodeMethod t RepeatingRadialGradientNode, O.OverloadedMethod info RepeatingRadialGradientNode p) => OL.IsLabel t (RepeatingRadialGradientNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveRepeatingRadialGradientNodeMethod t RepeatingRadialGradientNode, O.OverloadedMethod info RepeatingRadialGradientNode p, R.HasField t RepeatingRadialGradientNode p) => R.HasField t RepeatingRadialGradientNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveRepeatingRadialGradientNodeMethod t RepeatingRadialGradientNode, O.OverloadedMethodInfo info RepeatingRadialGradientNode) => OL.IsLabel t (O.MethodProxy info RepeatingRadialGradientNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr RepeatingRadialGradientNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method RepeatingRadialGradientNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "bounds"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the bounds of the node"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "center"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the center of the gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hradius"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the horizontal radius"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "vradius"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the vertical radius"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a percentage >= 0 that defines the start of the gradient around @center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a percentage >= 0 that defines the end of the gradient around @center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color_stops"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 7
--                 (TInterface Name { namespace = "Gsk" , name = "ColorStop" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pointer to an array of\n  `GskColorStop` defining the gradient. The offsets of all color stops\n  must be increasing. The first stop's offset must be >= 0 and the last\n  stop's offset must be <= 1."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_color_stops"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of elements in @color_stops"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_color_stops"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of elements in @color_stops"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gsk" , name = "RepeatingRadialGradientNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_repeating_radial_gradient_node_new" gsk_repeating_radial_gradient_node_new :: 
    Ptr Graphene.Rect.Rect ->               -- bounds : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Graphene.Point.Point ->             -- center : TInterface (Name {namespace = "Graphene", name = "Point"})
    CFloat ->                               -- hradius : TBasicType TFloat
    CFloat ->                               -- vradius : TBasicType TFloat
    CFloat ->                               -- start : TBasicType TFloat
    CFloat ->                               -- end : TBasicType TFloat
    Ptr Gsk.ColorStop.ColorStop ->          -- color_stops : TCArray False (-1) 7 (TInterface (Name {namespace = "Gsk", name = "ColorStop"}))
    FCT.CSize ->                            -- n_color_stops : TBasicType TSize
    IO (Ptr RepeatingRadialGradientNode)

-- | Creates a @GskRenderNode@ that draws a repeating radial gradient.
-- 
-- The radial gradient starts around /@center@/. The size of the gradient
-- is dictated by /@hradius@/ in horizontal orientation and by /@vradius@/
-- in vertical orientation.
repeatingRadialGradientNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Graphene.Rect.Rect
    -- ^ /@bounds@/: the bounds of the node
    -> Graphene.Point.Point
    -- ^ /@center@/: the center of the gradient
    -> Float
    -- ^ /@hradius@/: the horizontal radius
    -> Float
    -- ^ /@vradius@/: the vertical radius
    -> Float
    -- ^ /@start@/: a percentage >= 0 that defines the start of the gradient around /@center@/
    -> Float
    -- ^ /@end@/: a percentage >= 0 that defines the end of the gradient around /@center@/
    -> [Gsk.ColorStop.ColorStop]
    -- ^ /@colorStops@/: a pointer to an array of
    --   @GskColorStop@ defining the gradient. The offsets of all color stops
    --   must be increasing. The first stop\'s offset must be >= 0 and the last
    --   stop\'s offset must be \<= 1.
    -> m RepeatingRadialGradientNode
    -- ^ __Returns:__ A new @GskRenderNode@
repeatingRadialGradientNodeNew bounds center hradius vradius start end colorStops = liftIO $ do
    let nColorStops = fromIntegral $ P.length colorStops
    bounds' <- unsafeManagedPtrGetPtr bounds
    center' <- unsafeManagedPtrGetPtr center
    let hradius' = realToFrac hradius
    let vradius' = realToFrac vradius
    let start' = realToFrac start
    let end' = realToFrac end
    colorStops' <- mapM unsafeManagedPtrGetPtr colorStops
    colorStops'' <- packBlockArray 20 colorStops'
    result <- gsk_repeating_radial_gradient_node_new bounds' center' hradius' vradius' start' end' colorStops'' nColorStops
    checkUnexpectedReturnNULL "repeatingRadialGradientNodeNew" result
    result' <- (wrapPtr RepeatingRadialGradientNode) result
    touchManagedPtr bounds
    touchManagedPtr center
    mapM_ touchManagedPtr colorStops
    freeMem colorStops''
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


