{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The location and size of a rectangle region.
-- 
-- The width and height of a t'GI.Graphene.Structs.Rect.Rect' can be negative; for instance,
-- a t'GI.Graphene.Structs.Rect.Rect' with an origin of [ 0, 0 ] and a size of [ 10, 10 ] is
-- equivalent to a t'GI.Graphene.Structs.Rect.Rect' with an origin of [ 10, 10 ] and a size
-- of [ -10, -10 ].
-- 
-- Application code can normalize rectangles using 'GI.Graphene.Structs.Rect.rectNormalize';
-- this function will ensure that the width and height of a rectangle are
-- positive values. All functions taking a t'GI.Graphene.Structs.Rect.Rect' as an argument
-- will internally operate on a normalized copy; all functions returning a
-- t'GI.Graphene.Structs.Rect.Rect' will always return a normalized rectangle.
-- 
-- /Since: 1.0/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Graphene.Structs.Rect
    ( 

-- * Exported types
    Rect(..)                                ,
    newZeroRect                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [containsPoint]("GI.Graphene.Structs.Rect#g:method:containsPoint"), [containsRect]("GI.Graphene.Structs.Rect#g:method:containsRect"), [equal]("GI.Graphene.Structs.Rect#g:method:equal"), [expand]("GI.Graphene.Structs.Rect#g:method:expand"), [free]("GI.Graphene.Structs.Rect#g:method:free"), [init]("GI.Graphene.Structs.Rect#g:method:init"), [initFromRect]("GI.Graphene.Structs.Rect#g:method:initFromRect"), [inset]("GI.Graphene.Structs.Rect#g:method:inset"), [insetR]("GI.Graphene.Structs.Rect#g:method:insetR"), [interpolate]("GI.Graphene.Structs.Rect#g:method:interpolate"), [intersection]("GI.Graphene.Structs.Rect#g:method:intersection"), [normalize]("GI.Graphene.Structs.Rect#g:method:normalize"), [normalizeR]("GI.Graphene.Structs.Rect#g:method:normalizeR"), [offset]("GI.Graphene.Structs.Rect#g:method:offset"), [offsetR]("GI.Graphene.Structs.Rect#g:method:offsetR"), [round]("GI.Graphene.Structs.Rect#g:method:round"), [roundExtents]("GI.Graphene.Structs.Rect#g:method:roundExtents"), [roundToPixel]("GI.Graphene.Structs.Rect#g:method:roundToPixel"), [scale]("GI.Graphene.Structs.Rect#g:method:scale"), [union]("GI.Graphene.Structs.Rect#g:method:union").
-- 
-- ==== Getters
-- [getArea]("GI.Graphene.Structs.Rect#g:method:getArea"), [getBottomLeft]("GI.Graphene.Structs.Rect#g:method:getBottomLeft"), [getBottomRight]("GI.Graphene.Structs.Rect#g:method:getBottomRight"), [getCenter]("GI.Graphene.Structs.Rect#g:method:getCenter"), [getHeight]("GI.Graphene.Structs.Rect#g:method:getHeight"), [getTopLeft]("GI.Graphene.Structs.Rect#g:method:getTopLeft"), [getTopRight]("GI.Graphene.Structs.Rect#g:method:getTopRight"), [getWidth]("GI.Graphene.Structs.Rect#g:method:getWidth"), [getX]("GI.Graphene.Structs.Rect#g:method:getX"), [getY]("GI.Graphene.Structs.Rect#g:method:getY").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveRectMethod                       ,
#endif

-- ** alloc #method:alloc#

    rectAlloc                               ,


-- ** containsPoint #method:containsPoint#

#if defined(ENABLE_OVERLOADING)
    RectContainsPointMethodInfo             ,
#endif
    rectContainsPoint                       ,


-- ** containsRect #method:containsRect#

#if defined(ENABLE_OVERLOADING)
    RectContainsRectMethodInfo              ,
#endif
    rectContainsRect                        ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    RectEqualMethodInfo                     ,
#endif
    rectEqual                               ,


-- ** expand #method:expand#

#if defined(ENABLE_OVERLOADING)
    RectExpandMethodInfo                    ,
#endif
    rectExpand                              ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    RectFreeMethodInfo                      ,
#endif
    rectFree                                ,


-- ** getArea #method:getArea#

#if defined(ENABLE_OVERLOADING)
    RectGetAreaMethodInfo                   ,
#endif
    rectGetArea                             ,


-- ** getBottomLeft #method:getBottomLeft#

#if defined(ENABLE_OVERLOADING)
    RectGetBottomLeftMethodInfo             ,
#endif
    rectGetBottomLeft                       ,


-- ** getBottomRight #method:getBottomRight#

#if defined(ENABLE_OVERLOADING)
    RectGetBottomRightMethodInfo            ,
#endif
    rectGetBottomRight                      ,


-- ** getCenter #method:getCenter#

#if defined(ENABLE_OVERLOADING)
    RectGetCenterMethodInfo                 ,
#endif
    rectGetCenter                           ,


-- ** getHeight #method:getHeight#

#if defined(ENABLE_OVERLOADING)
    RectGetHeightMethodInfo                 ,
#endif
    rectGetHeight                           ,


-- ** getTopLeft #method:getTopLeft#

#if defined(ENABLE_OVERLOADING)
    RectGetTopLeftMethodInfo                ,
#endif
    rectGetTopLeft                          ,


-- ** getTopRight #method:getTopRight#

#if defined(ENABLE_OVERLOADING)
    RectGetTopRightMethodInfo               ,
#endif
    rectGetTopRight                         ,


-- ** getWidth #method:getWidth#

#if defined(ENABLE_OVERLOADING)
    RectGetWidthMethodInfo                  ,
#endif
    rectGetWidth                            ,


-- ** getX #method:getX#

#if defined(ENABLE_OVERLOADING)
    RectGetXMethodInfo                      ,
#endif
    rectGetX                                ,


-- ** getY #method:getY#

#if defined(ENABLE_OVERLOADING)
    RectGetYMethodInfo                      ,
#endif
    rectGetY                                ,


-- ** init #method:init#

#if defined(ENABLE_OVERLOADING)
    RectInitMethodInfo                      ,
#endif
    rectInit                                ,


-- ** initFromRect #method:initFromRect#

#if defined(ENABLE_OVERLOADING)
    RectInitFromRectMethodInfo              ,
#endif
    rectInitFromRect                        ,


-- ** inset #method:inset#

#if defined(ENABLE_OVERLOADING)
    RectInsetMethodInfo                     ,
#endif
    rectInset                               ,


-- ** insetR #method:insetR#

#if defined(ENABLE_OVERLOADING)
    RectInsetRMethodInfo                    ,
#endif
    rectInsetR                              ,


-- ** interpolate #method:interpolate#

#if defined(ENABLE_OVERLOADING)
    RectInterpolateMethodInfo               ,
#endif
    rectInterpolate                         ,


-- ** intersection #method:intersection#

#if defined(ENABLE_OVERLOADING)
    RectIntersectionMethodInfo              ,
#endif
    rectIntersection                        ,


-- ** normalize #method:normalize#

#if defined(ENABLE_OVERLOADING)
    RectNormalizeMethodInfo                 ,
#endif
    rectNormalize                           ,


-- ** normalizeR #method:normalizeR#

#if defined(ENABLE_OVERLOADING)
    RectNormalizeRMethodInfo                ,
#endif
    rectNormalizeR                          ,


-- ** offset #method:offset#

#if defined(ENABLE_OVERLOADING)
    RectOffsetMethodInfo                    ,
#endif
    rectOffset                              ,


-- ** offsetR #method:offsetR#

#if defined(ENABLE_OVERLOADING)
    RectOffsetRMethodInfo                   ,
#endif
    rectOffsetR                             ,


-- ** round #method:round#

#if defined(ENABLE_OVERLOADING)
    RectRoundMethodInfo                     ,
#endif
    rectRound                               ,


-- ** roundExtents #method:roundExtents#

#if defined(ENABLE_OVERLOADING)
    RectRoundExtentsMethodInfo              ,
#endif
    rectRoundExtents                        ,


-- ** roundToPixel #method:roundToPixel#

#if defined(ENABLE_OVERLOADING)
    RectRoundToPixelMethodInfo              ,
#endif
    rectRoundToPixel                        ,


-- ** scale #method:scale#

#if defined(ENABLE_OVERLOADING)
    RectScaleMethodInfo                     ,
#endif
    rectScale                               ,


-- ** union #method:union#

#if defined(ENABLE_OVERLOADING)
    RectUnionMethodInfo                     ,
#endif
    rectUnion                               ,


-- ** zero #method:zero#

    rectZero                                ,




 -- * Properties


-- ** origin #attr:origin#
-- | the coordinates of the origin of the rectangle

    getRectOrigin                           ,
#if defined(ENABLE_OVERLOADING)
    rect_origin                             ,
#endif


-- ** size #attr:size#
-- | the size of the rectangle

    getRectSize                             ,
#if defined(ENABLE_OVERLOADING)
    rect_size                               ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point as Graphene.Point
import {-# SOURCE #-} qualified GI.Graphene.Structs.Size as Graphene.Size
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2

#else
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point as Graphene.Point
import {-# SOURCE #-} qualified GI.Graphene.Structs.Size as Graphene.Size

#endif

-- | Memory-managed wrapper type.
newtype Rect = Rect (SP.ManagedPtr Rect)
    deriving (Eq)

instance SP.ManagedPtrNewtype Rect where
    toManagedPtr (Rect p) = p

foreign import ccall "graphene_rect_get_type" c_graphene_rect_get_type :: 
    IO GType

type instance O.ParentTypes Rect = '[]
instance O.HasParentTypes Rect

instance B.Types.TypedObject Rect where
    glibType = c_graphene_rect_get_type

instance B.Types.GBoxed Rect

-- | Convert t'Rect' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Rect) where
    gvalueGType_ = c_graphene_rect_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Rect)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Rect)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Rect ptr
        else return P.Nothing
        
    

-- | Construct a t'Rect' struct initialized to zero.
newZeroRect :: MonadIO m => m Rect
newZeroRect = liftIO $ callocBoxedBytes 16 >>= wrapBoxed Rect

instance tag ~ 'AttrSet => Constructible Rect tag where
    new _ attrs = do
        o <- newZeroRect
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@origin@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' rect #origin
-- @
getRectOrigin :: MonadIO m => Rect -> m Graphene.Point.Point
getRectOrigin s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Graphene.Point.Point)
    val' <- (newBoxed Graphene.Point.Point) val
    return val'

#if defined(ENABLE_OVERLOADING)
data RectOriginFieldInfo
instance AttrInfo RectOriginFieldInfo where
    type AttrBaseTypeConstraint RectOriginFieldInfo = (~) Rect
    type AttrAllowedOps RectOriginFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint RectOriginFieldInfo = (~) (Ptr Graphene.Point.Point)
    type AttrTransferTypeConstraint RectOriginFieldInfo = (~)(Ptr Graphene.Point.Point)
    type AttrTransferType RectOriginFieldInfo = (Ptr Graphene.Point.Point)
    type AttrGetType RectOriginFieldInfo = Graphene.Point.Point
    type AttrLabel RectOriginFieldInfo = "origin"
    type AttrOrigin RectOriginFieldInfo = Rect
    attrGet = getRectOrigin
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.origin"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#g:attr:origin"
        })

rect_origin :: AttrLabelProxy "origin"
rect_origin = AttrLabelProxy

#endif


-- | Get the value of the “@size@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' rect #size
-- @
getRectSize :: MonadIO m => Rect -> m Graphene.Size.Size
getRectSize s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 8 :: (Ptr Graphene.Size.Size)
    val' <- (newBoxed Graphene.Size.Size) val
    return val'

#if defined(ENABLE_OVERLOADING)
data RectSizeFieldInfo
instance AttrInfo RectSizeFieldInfo where
    type AttrBaseTypeConstraint RectSizeFieldInfo = (~) Rect
    type AttrAllowedOps RectSizeFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint RectSizeFieldInfo = (~) (Ptr Graphene.Size.Size)
    type AttrTransferTypeConstraint RectSizeFieldInfo = (~)(Ptr Graphene.Size.Size)
    type AttrTransferType RectSizeFieldInfo = (Ptr Graphene.Size.Size)
    type AttrGetType RectSizeFieldInfo = Graphene.Size.Size
    type AttrLabel RectSizeFieldInfo = "size"
    type AttrOrigin RectSizeFieldInfo = Rect
    attrGet = getRectSize
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.size"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#g:attr:size"
        })

rect_size :: AttrLabelProxy "size"
rect_size = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Rect
type instance O.AttributeList Rect = RectAttributeList
type RectAttributeList = ('[ '("origin", RectOriginFieldInfo), '("size", RectSizeFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method Rect::contains_point
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_contains_point" graphene_rect_contains_point :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Graphene.Point.Point ->             -- p : TInterface (Name {namespace = "Graphene", name = "Point"})
    IO CInt

-- | Checks whether a t'GI.Graphene.Structs.Rect.Rect' contains the given coordinates.
-- 
-- /Since: 1.0/
rectContainsPoint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> Graphene.Point.Point
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point.Point'
    -> m Bool
    -- ^ __Returns:__ @true@ if the rectangle contains the point
rectContainsPoint r p = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    p' <- unsafeManagedPtrGetPtr p
    result <- graphene_rect_contains_point r' p'
    let result' = (/= 0) result
    touchManagedPtr r
    touchManagedPtr p
    return result'

#if defined(ENABLE_OVERLOADING)
data RectContainsPointMethodInfo
instance (signature ~ (Graphene.Point.Point -> m Bool), MonadIO m) => O.OverloadedMethod RectContainsPointMethodInfo Rect signature where
    overloadedMethod = rectContainsPoint

instance O.OverloadedMethodInfo RectContainsPointMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectContainsPoint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectContainsPoint"
        })


#endif

-- method Rect::contains_rect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_contains_rect" graphene_rect_contains_rect :: 
    Ptr Rect ->                             -- a : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Rect ->                             -- b : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO CInt

-- | Checks whether a t'GI.Graphene.Structs.Rect.Rect' fully contains the given
-- rectangle.
-- 
-- /Since: 1.0/
rectContainsRect ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@a@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> Rect
    -- ^ /@b@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m Bool
    -- ^ __Returns:__ @true@ if the rectangle /@a@/ fully contains /@b@/
rectContainsRect a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- graphene_rect_contains_rect a' b'
    let result' = (/= 0) result
    touchManagedPtr a
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data RectContainsRectMethodInfo
instance (signature ~ (Rect -> m Bool), MonadIO m) => O.OverloadedMethod RectContainsRectMethodInfo Rect signature where
    overloadedMethod = rectContainsRect

instance O.OverloadedMethodInfo RectContainsRectMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectContainsRect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectContainsRect"
        })


#endif

-- method Rect::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_equal" graphene_rect_equal :: 
    Ptr Rect ->                             -- a : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Rect ->                             -- b : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO CInt

-- | Checks whether the two given rectangle are equal.
-- 
-- /Since: 1.0/
rectEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@a@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> Rect
    -- ^ /@b@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m Bool
    -- ^ __Returns:__ @true@ if the rectangles are equal
rectEqual a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- graphene_rect_equal a' b'
    let result' = (/= 0) result
    touchManagedPtr a
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data RectEqualMethodInfo
instance (signature ~ (Rect -> m Bool), MonadIO m) => O.OverloadedMethod RectEqualMethodInfo Rect signature where
    overloadedMethod = rectEqual

instance O.OverloadedMethodInfo RectEqualMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectEqual"
        })


#endif

-- method Rect::expand
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the expanded rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_expand" graphene_rect_expand :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Graphene.Point.Point ->             -- p : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr Rect ->                             -- res : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO ()

-- | Expands a t'GI.Graphene.Structs.Rect.Rect' to contain the given t'GI.Graphene.Structs.Point.Point'.
-- 
-- /Since: 1.4/
rectExpand ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> Graphene.Point.Point
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point.Point'
    -> m (Rect)
rectExpand r p = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    p' <- unsafeManagedPtrGetPtr p
    res <- SP.callocBoxedBytes 16 :: IO (Ptr Rect)
    graphene_rect_expand r' p' res
    res' <- (wrapBoxed Rect) res
    touchManagedPtr r
    touchManagedPtr p
    return res'

#if defined(ENABLE_OVERLOADING)
data RectExpandMethodInfo
instance (signature ~ (Graphene.Point.Point -> m (Rect)), MonadIO m) => O.OverloadedMethod RectExpandMethodInfo Rect signature where
    overloadedMethod = rectExpand

instance O.OverloadedMethodInfo RectExpandMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectExpand",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectExpand"
        })


#endif

-- method Rect::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_free" graphene_rect_free :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO ()

-- | Frees the resources allocated by 'GI.Graphene.Functions.rectAlloc'.
-- 
-- /Since: 1.0/
rectFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m ()
rectFree r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    graphene_rect_free r'
    touchManagedPtr r
    return ()

#if defined(ENABLE_OVERLOADING)
data RectFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod RectFreeMethodInfo Rect signature where
    overloadedMethod = rectFree

instance O.OverloadedMethodInfo RectFreeMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectFree"
        })


#endif

-- method Rect::get_area
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_get_area" graphene_rect_get_area :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO CFloat

-- | Compute the area of given normalized rectangle.
-- 
-- /Since: 1.10/
rectGetArea ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m Float
    -- ^ __Returns:__ the area of the normalized rectangle
rectGetArea r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    result <- graphene_rect_get_area r'
    let result' = realToFrac result
    touchManagedPtr r
    return result'

#if defined(ENABLE_OVERLOADING)
data RectGetAreaMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod RectGetAreaMethodInfo Rect signature where
    overloadedMethod = rectGetArea

instance O.OverloadedMethodInfo RectGetAreaMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectGetArea",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectGetArea"
        })


#endif

-- method Rect::get_bottom_left
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_get_bottom_left" graphene_rect_get_bottom_left :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Graphene.Point.Point ->             -- p : TInterface (Name {namespace = "Graphene", name = "Point"})
    IO ()

-- | Retrieves the coordinates of the bottom-left corner of the given rectangle.
-- 
-- /Since: 1.0/
rectGetBottomLeft ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m (Graphene.Point.Point)
rectGetBottomLeft r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    p <- SP.callocBoxedBytes 8 :: IO (Ptr Graphene.Point.Point)
    graphene_rect_get_bottom_left r' p
    p' <- (wrapBoxed Graphene.Point.Point) p
    touchManagedPtr r
    return p'

#if defined(ENABLE_OVERLOADING)
data RectGetBottomLeftMethodInfo
instance (signature ~ (m (Graphene.Point.Point)), MonadIO m) => O.OverloadedMethod RectGetBottomLeftMethodInfo Rect signature where
    overloadedMethod = rectGetBottomLeft

instance O.OverloadedMethodInfo RectGetBottomLeftMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectGetBottomLeft",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectGetBottomLeft"
        })


#endif

-- method Rect::get_bottom_right
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_get_bottom_right" graphene_rect_get_bottom_right :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Graphene.Point.Point ->             -- p : TInterface (Name {namespace = "Graphene", name = "Point"})
    IO ()

-- | Retrieves the coordinates of the bottom-right corner of the given rectangle.
-- 
-- /Since: 1.0/
rectGetBottomRight ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m (Graphene.Point.Point)
rectGetBottomRight r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    p <- SP.callocBoxedBytes 8 :: IO (Ptr Graphene.Point.Point)
    graphene_rect_get_bottom_right r' p
    p' <- (wrapBoxed Graphene.Point.Point) p
    touchManagedPtr r
    return p'

#if defined(ENABLE_OVERLOADING)
data RectGetBottomRightMethodInfo
instance (signature ~ (m (Graphene.Point.Point)), MonadIO m) => O.OverloadedMethod RectGetBottomRightMethodInfo Rect signature where
    overloadedMethod = rectGetBottomRight

instance O.OverloadedMethodInfo RectGetBottomRightMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectGetBottomRight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectGetBottomRight"
        })


#endif

-- method Rect::get_center
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_get_center" graphene_rect_get_center :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Graphene.Point.Point ->             -- p : TInterface (Name {namespace = "Graphene", name = "Point"})
    IO ()

-- | Retrieves the coordinates of the center of the given rectangle.
-- 
-- /Since: 1.0/
rectGetCenter ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m (Graphene.Point.Point)
rectGetCenter r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    p <- SP.callocBoxedBytes 8 :: IO (Ptr Graphene.Point.Point)
    graphene_rect_get_center r' p
    p' <- (wrapBoxed Graphene.Point.Point) p
    touchManagedPtr r
    return p'

#if defined(ENABLE_OVERLOADING)
data RectGetCenterMethodInfo
instance (signature ~ (m (Graphene.Point.Point)), MonadIO m) => O.OverloadedMethod RectGetCenterMethodInfo Rect signature where
    overloadedMethod = rectGetCenter

instance O.OverloadedMethodInfo RectGetCenterMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectGetCenter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectGetCenter"
        })


#endif

-- method Rect::get_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_get_height" graphene_rect_get_height :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO CFloat

-- | Retrieves the normalized height of the given rectangle.
-- 
-- /Since: 1.0/
rectGetHeight ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m Float
    -- ^ __Returns:__ the normalized height of the rectangle
rectGetHeight r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    result <- graphene_rect_get_height r'
    let result' = realToFrac result
    touchManagedPtr r
    return result'

#if defined(ENABLE_OVERLOADING)
data RectGetHeightMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod RectGetHeightMethodInfo Rect signature where
    overloadedMethod = rectGetHeight

instance O.OverloadedMethodInfo RectGetHeightMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectGetHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectGetHeight"
        })


#endif

-- method Rect::get_top_left
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_get_top_left" graphene_rect_get_top_left :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Graphene.Point.Point ->             -- p : TInterface (Name {namespace = "Graphene", name = "Point"})
    IO ()

-- | Retrieves the coordinates of the top-left corner of the given rectangle.
-- 
-- /Since: 1.0/
rectGetTopLeft ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m (Graphene.Point.Point)
rectGetTopLeft r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    p <- SP.callocBoxedBytes 8 :: IO (Ptr Graphene.Point.Point)
    graphene_rect_get_top_left r' p
    p' <- (wrapBoxed Graphene.Point.Point) p
    touchManagedPtr r
    return p'

#if defined(ENABLE_OVERLOADING)
data RectGetTopLeftMethodInfo
instance (signature ~ (m (Graphene.Point.Point)), MonadIO m) => O.OverloadedMethod RectGetTopLeftMethodInfo Rect signature where
    overloadedMethod = rectGetTopLeft

instance O.OverloadedMethodInfo RectGetTopLeftMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectGetTopLeft",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectGetTopLeft"
        })


#endif

-- method Rect::get_top_right
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_get_top_right" graphene_rect_get_top_right :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Graphene.Point.Point ->             -- p : TInterface (Name {namespace = "Graphene", name = "Point"})
    IO ()

-- | Retrieves the coordinates of the top-right corner of the given rectangle.
-- 
-- /Since: 1.0/
rectGetTopRight ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m (Graphene.Point.Point)
rectGetTopRight r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    p <- SP.callocBoxedBytes 8 :: IO (Ptr Graphene.Point.Point)
    graphene_rect_get_top_right r' p
    p' <- (wrapBoxed Graphene.Point.Point) p
    touchManagedPtr r
    return p'

#if defined(ENABLE_OVERLOADING)
data RectGetTopRightMethodInfo
instance (signature ~ (m (Graphene.Point.Point)), MonadIO m) => O.OverloadedMethod RectGetTopRightMethodInfo Rect signature where
    overloadedMethod = rectGetTopRight

instance O.OverloadedMethodInfo RectGetTopRightMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectGetTopRight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectGetTopRight"
        })


#endif

-- XXX Could not generate method Rect::get_vertices
-- Not implemented: Don't know how to allocate "vertices" of type TCArray False 4 (-1) (TInterface (Name {namespace = "Graphene", name = "Vec2"}))
-- method Rect::get_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_get_width" graphene_rect_get_width :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO CFloat

-- | Retrieves the normalized width of the given rectangle.
-- 
-- /Since: 1.0/
rectGetWidth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m Float
    -- ^ __Returns:__ the normalized width of the rectangle
rectGetWidth r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    result <- graphene_rect_get_width r'
    let result' = realToFrac result
    touchManagedPtr r
    return result'

#if defined(ENABLE_OVERLOADING)
data RectGetWidthMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod RectGetWidthMethodInfo Rect signature where
    overloadedMethod = rectGetWidth

instance O.OverloadedMethodInfo RectGetWidthMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectGetWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectGetWidth"
        })


#endif

-- method Rect::get_x
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_get_x" graphene_rect_get_x :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO CFloat

-- | Retrieves the normalized X coordinate of the origin of the given
-- rectangle.
-- 
-- /Since: 1.0/
rectGetX ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m Float
    -- ^ __Returns:__ the normalized X coordinate of the rectangle
rectGetX r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    result <- graphene_rect_get_x r'
    let result' = realToFrac result
    touchManagedPtr r
    return result'

#if defined(ENABLE_OVERLOADING)
data RectGetXMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod RectGetXMethodInfo Rect signature where
    overloadedMethod = rectGetX

instance O.OverloadedMethodInfo RectGetXMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectGetX",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectGetX"
        })


#endif

-- method Rect::get_y
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_get_y" graphene_rect_get_y :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO CFloat

-- | Retrieves the normalized Y coordinate of the origin of the given
-- rectangle.
-- 
-- /Since: 1.0/
rectGetY ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m Float
    -- ^ __Returns:__ the normalized Y coordinate of the rectangle
rectGetY r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    result <- graphene_rect_get_y r'
    let result' = realToFrac result
    touchManagedPtr r
    return result'

#if defined(ENABLE_OVERLOADING)
data RectGetYMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod RectGetYMethodInfo Rect signature where
    overloadedMethod = rectGetY

instance O.OverloadedMethodInfo RectGetYMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectGetY",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectGetY"
        })


#endif

-- method Rect::init
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the X coordinate of the @graphene_rect_t.origin"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the Y coordinate of the @graphene_rect_t.origin"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the width of the @graphene_rect_t.size"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the height of the @graphene_rect_t.size"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Rect" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_init" graphene_rect_init :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    CFloat ->                               -- x : TBasicType TFloat
    CFloat ->                               -- y : TBasicType TFloat
    CFloat ->                               -- width : TBasicType TFloat
    CFloat ->                               -- height : TBasicType TFloat
    IO (Ptr Rect)

-- | Initializes the given t'GI.Graphene.Structs.Rect.Rect' with the given values.
-- 
-- This function will implicitly normalize the t'GI.Graphene.Structs.Rect.Rect'
-- before returning.
-- 
-- /Since: 1.0/
rectInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> Float
    -- ^ /@x@/: the X coordinate of the /@grapheneRectT@/.origin
    -> Float
    -- ^ /@y@/: the Y coordinate of the /@grapheneRectT@/.origin
    -> Float
    -- ^ /@width@/: the width of the /@grapheneRectT@/.size
    -> Float
    -- ^ /@height@/: the height of the /@grapheneRectT@/.size
    -> m Rect
    -- ^ __Returns:__ the initialized rectangle
rectInit r x y width height = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    let x' = realToFrac x
    let y' = realToFrac y
    let width' = realToFrac width
    let height' = realToFrac height
    result <- graphene_rect_init r' x' y' width' height'
    checkUnexpectedReturnNULL "rectInit" result
    result' <- (newBoxed Rect) result
    touchManagedPtr r
    return result'

#if defined(ENABLE_OVERLOADING)
data RectInitMethodInfo
instance (signature ~ (Float -> Float -> Float -> Float -> m Rect), MonadIO m) => O.OverloadedMethod RectInitMethodInfo Rect signature where
    overloadedMethod = rectInit

instance O.OverloadedMethodInfo RectInitMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectInit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectInit"
        })


#endif

-- method Rect::init_from_rect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Rect" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_init_from_rect" graphene_rect_init_from_rect :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Rect ->                             -- src : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO (Ptr Rect)

-- | Initializes /@r@/ using the given /@src@/ rectangle.
-- 
-- This function will implicitly normalize the t'GI.Graphene.Structs.Rect.Rect'
-- before returning.
-- 
-- /Since: 1.0/
rectInitFromRect ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> Rect
    -- ^ /@src@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m Rect
    -- ^ __Returns:__ the initialized rectangle
rectInitFromRect r src = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    src' <- unsafeManagedPtrGetPtr src
    result <- graphene_rect_init_from_rect r' src'
    checkUnexpectedReturnNULL "rectInitFromRect" result
    result' <- (newBoxed Rect) result
    touchManagedPtr r
    touchManagedPtr src
    return result'

#if defined(ENABLE_OVERLOADING)
data RectInitFromRectMethodInfo
instance (signature ~ (Rect -> m Rect), MonadIO m) => O.OverloadedMethod RectInitFromRectMethodInfo Rect signature where
    overloadedMethod = rectInitFromRect

instance O.OverloadedMethodInfo RectInitFromRectMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectInitFromRect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectInitFromRect"
        })


#endif

-- method Rect::inset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "d_x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the horizontal inset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "d_y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the vertical inset" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Rect" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_inset" graphene_rect_inset :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    CFloat ->                               -- d_x : TBasicType TFloat
    CFloat ->                               -- d_y : TBasicType TFloat
    IO (Ptr Rect)

-- | Changes the given rectangle to be smaller, or larger depending on the
-- given inset parameters.
-- 
-- To create an inset rectangle, use positive /@dX@/ or /@dY@/ values; to
-- create a larger, encompassing rectangle, use negative /@dX@/ or /@dY@/
-- values.
-- 
-- The origin of the rectangle is offset by /@dX@/ and /@dY@/, while the size
-- is adjusted by @(2 * \@d_x, 2 * \@d_y)@. If /@dX@/ and /@dY@/ are positive
-- values, the size of the rectangle is decreased; if /@dX@/ and /@dY@/ are
-- negative values, the size of the rectangle is increased.
-- 
-- If the size of the resulting inset rectangle has a negative width or
-- height then the size will be set to zero.
-- 
-- /Since: 1.0/
rectInset ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> Float
    -- ^ /@dX@/: the horizontal inset
    -> Float
    -- ^ /@dY@/: the vertical inset
    -> m Rect
    -- ^ __Returns:__ the inset rectangle
rectInset r dX dY = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    let dX' = realToFrac dX
    let dY' = realToFrac dY
    result <- graphene_rect_inset r' dX' dY'
    checkUnexpectedReturnNULL "rectInset" result
    result' <- (newBoxed Rect) result
    touchManagedPtr r
    return result'

#if defined(ENABLE_OVERLOADING)
data RectInsetMethodInfo
instance (signature ~ (Float -> Float -> m Rect), MonadIO m) => O.OverloadedMethod RectInsetMethodInfo Rect signature where
    overloadedMethod = rectInset

instance O.OverloadedMethodInfo RectInsetMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectInset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectInset"
        })


#endif

-- method Rect::inset_r
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "d_x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the horizontal inset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "d_y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the vertical inset" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the inset rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_inset_r" graphene_rect_inset_r :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    CFloat ->                               -- d_x : TBasicType TFloat
    CFloat ->                               -- d_y : TBasicType TFloat
    Ptr Rect ->                             -- res : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO ()

-- | Changes the given rectangle to be smaller, or larger depending on the
-- given inset parameters.
-- 
-- To create an inset rectangle, use positive /@dX@/ or /@dY@/ values; to
-- create a larger, encompassing rectangle, use negative /@dX@/ or /@dY@/
-- values.
-- 
-- The origin of the rectangle is offset by /@dX@/ and /@dY@/, while the size
-- is adjusted by @(2 * \@d_x, 2 * \@d_y)@. If /@dX@/ and /@dY@/ are positive
-- values, the size of the rectangle is decreased; if /@dX@/ and /@dY@/ are
-- negative values, the size of the rectangle is increased.
-- 
-- If the size of the resulting inset rectangle has a negative width or
-- height then the size will be set to zero.
-- 
-- /Since: 1.4/
rectInsetR ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> Float
    -- ^ /@dX@/: the horizontal inset
    -> Float
    -- ^ /@dY@/: the vertical inset
    -> m (Rect)
rectInsetR r dX dY = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    let dX' = realToFrac dX
    let dY' = realToFrac dY
    res <- SP.callocBoxedBytes 16 :: IO (Ptr Rect)
    graphene_rect_inset_r r' dX' dY' res
    res' <- (wrapBoxed Rect) res
    touchManagedPtr r
    return res'

#if defined(ENABLE_OVERLOADING)
data RectInsetRMethodInfo
instance (signature ~ (Float -> Float -> m (Rect)), MonadIO m) => O.OverloadedMethod RectInsetRMethodInfo Rect signature where
    overloadedMethod = rectInsetR

instance O.OverloadedMethodInfo RectInsetRMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectInsetR",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectInsetR"
        })


#endif

-- method Rect::interpolate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factor"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the linear interpolation factor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the\n  interpolated rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_interpolate" graphene_rect_interpolate :: 
    Ptr Rect ->                             -- a : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Rect ->                             -- b : TInterface (Name {namespace = "Graphene", name = "Rect"})
    CDouble ->                              -- factor : TBasicType TDouble
    Ptr Rect ->                             -- res : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO ()

-- | Linearly interpolates the origin and size of the two given
-- rectangles.
-- 
-- /Since: 1.0/
rectInterpolate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@a@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> Rect
    -- ^ /@b@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> Double
    -- ^ /@factor@/: the linear interpolation factor
    -> m (Rect)
rectInterpolate a b factor = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    let factor' = realToFrac factor
    res <- SP.callocBoxedBytes 16 :: IO (Ptr Rect)
    graphene_rect_interpolate a' b' factor' res
    res' <- (wrapBoxed Rect) res
    touchManagedPtr a
    touchManagedPtr b
    return res'

#if defined(ENABLE_OVERLOADING)
data RectInterpolateMethodInfo
instance (signature ~ (Rect -> Double -> m (Rect)), MonadIO m) => O.OverloadedMethod RectInterpolateMethodInfo Rect signature where
    overloadedMethod = rectInterpolate

instance O.OverloadedMethodInfo RectInterpolateMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectInterpolate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectInterpolate"
        })


#endif

-- method Rect::intersection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for\n  a #graphene_rect_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_intersection" graphene_rect_intersection :: 
    Ptr Rect ->                             -- a : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Rect ->                             -- b : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Rect ->                             -- res : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO CInt

-- | Computes the intersection of the two given rectangles.
-- 
-- <<http://developer.gnome.org/graphene/stable/rectangle-intersection.png>>
-- 
-- The intersection in the image above is the blue outline.
-- 
-- If the two rectangles do not intersect, /@res@/ will contain
-- a degenerate rectangle with origin in (0, 0) and a size of 0.
-- 
-- /Since: 1.0/
rectIntersection ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@a@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> Rect
    -- ^ /@b@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m ((Bool, Rect))
    -- ^ __Returns:__ @true@ if the two rectangles intersect
rectIntersection a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    res <- SP.callocBoxedBytes 16 :: IO (Ptr Rect)
    result <- graphene_rect_intersection a' b' res
    let result' = (/= 0) result
    res' <- (wrapBoxed Rect) res
    touchManagedPtr a
    touchManagedPtr b
    return (result', res')

#if defined(ENABLE_OVERLOADING)
data RectIntersectionMethodInfo
instance (signature ~ (Rect -> m ((Bool, Rect))), MonadIO m) => O.OverloadedMethod RectIntersectionMethodInfo Rect signature where
    overloadedMethod = rectIntersection

instance O.OverloadedMethodInfo RectIntersectionMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectIntersection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectIntersection"
        })


#endif

-- method Rect::normalize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Rect" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_normalize" graphene_rect_normalize :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO (Ptr Rect)

-- | Normalizes the passed rectangle.
-- 
-- This function ensures that the size of the rectangle is made of
-- positive values, and that the origin is the top-left corner of
-- the rectangle.
-- 
-- /Since: 1.0/
rectNormalize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m Rect
    -- ^ __Returns:__ the normalized rectangle
rectNormalize r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    result <- graphene_rect_normalize r'
    checkUnexpectedReturnNULL "rectNormalize" result
    result' <- (newBoxed Rect) result
    touchManagedPtr r
    return result'

#if defined(ENABLE_OVERLOADING)
data RectNormalizeMethodInfo
instance (signature ~ (m Rect), MonadIO m) => O.OverloadedMethod RectNormalizeMethodInfo Rect signature where
    overloadedMethod = rectNormalize

instance O.OverloadedMethodInfo RectNormalizeMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectNormalize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectNormalize"
        })


#endif

-- method Rect::normalize_r
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the return location for the\n  normalized rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_normalize_r" graphene_rect_normalize_r :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Rect ->                             -- res : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO ()

-- | Normalizes the passed rectangle.
-- 
-- This function ensures that the size of the rectangle is made of
-- positive values, and that the origin is in the top-left corner
-- of the rectangle.
-- 
-- /Since: 1.4/
rectNormalizeR ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m (Rect)
rectNormalizeR r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    res <- SP.callocBoxedBytes 16 :: IO (Ptr Rect)
    graphene_rect_normalize_r r' res
    res' <- (wrapBoxed Rect) res
    touchManagedPtr r
    return res'

#if defined(ENABLE_OVERLOADING)
data RectNormalizeRMethodInfo
instance (signature ~ (m (Rect)), MonadIO m) => O.OverloadedMethod RectNormalizeRMethodInfo Rect signature where
    overloadedMethod = rectNormalizeR

instance O.OverloadedMethodInfo RectNormalizeRMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectNormalizeR",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectNormalizeR"
        })


#endif

-- method Rect::offset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "d_x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the horizontal offset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "d_y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the vertical offset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Rect" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_offset" graphene_rect_offset :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    CFloat ->                               -- d_x : TBasicType TFloat
    CFloat ->                               -- d_y : TBasicType TFloat
    IO (Ptr Rect)

-- | Offsets the origin by /@dX@/ and /@dY@/.
-- 
-- The size of the rectangle is unchanged.
-- 
-- /Since: 1.0/
rectOffset ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> Float
    -- ^ /@dX@/: the horizontal offset
    -> Float
    -- ^ /@dY@/: the vertical offset
    -> m Rect
    -- ^ __Returns:__ the offset rectangle
rectOffset r dX dY = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    let dX' = realToFrac dX
    let dY' = realToFrac dY
    result <- graphene_rect_offset r' dX' dY'
    checkUnexpectedReturnNULL "rectOffset" result
    result' <- (newBoxed Rect) result
    touchManagedPtr r
    return result'

#if defined(ENABLE_OVERLOADING)
data RectOffsetMethodInfo
instance (signature ~ (Float -> Float -> m Rect), MonadIO m) => O.OverloadedMethod RectOffsetMethodInfo Rect signature where
    overloadedMethod = rectOffset

instance O.OverloadedMethodInfo RectOffsetMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectOffset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectOffset"
        })


#endif

-- method Rect::offset_r
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "d_x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the horizontal offset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "d_y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the vertical offset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the offset\n  rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_offset_r" graphene_rect_offset_r :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    CFloat ->                               -- d_x : TBasicType TFloat
    CFloat ->                               -- d_y : TBasicType TFloat
    Ptr Rect ->                             -- res : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO ()

-- | Offsets the origin of the given rectangle by /@dX@/ and /@dY@/.
-- 
-- The size of the rectangle is left unchanged.
-- 
-- /Since: 1.4/
rectOffsetR ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> Float
    -- ^ /@dX@/: the horizontal offset
    -> Float
    -- ^ /@dY@/: the vertical offset
    -> m (Rect)
rectOffsetR r dX dY = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    let dX' = realToFrac dX
    let dY' = realToFrac dY
    res <- SP.callocBoxedBytes 16 :: IO (Ptr Rect)
    graphene_rect_offset_r r' dX' dY' res
    res' <- (wrapBoxed Rect) res
    touchManagedPtr r
    return res'

#if defined(ENABLE_OVERLOADING)
data RectOffsetRMethodInfo
instance (signature ~ (Float -> Float -> m (Rect)), MonadIO m) => O.OverloadedMethod RectOffsetRMethodInfo Rect signature where
    overloadedMethod = rectOffsetR

instance O.OverloadedMethodInfo RectOffsetRMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectOffsetR",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectOffsetR"
        })


#endif

-- method Rect::round
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the\n  rounded rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_round" graphene_rect_round :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Rect ->                             -- res : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO ()

{-# DEPRECATED rectRound ["(Since version 1.10)","Use 'GI.Graphene.Structs.Rect.rectRoundExtents' instead"] #-}
-- | Rounds the origin and size of the given rectangle to
-- their nearest integer values; the rounding is guaranteed
-- to be large enough to have an area bigger or equal to the
-- original rectangle, but might not fully contain its extents.
-- Use 'GI.Graphene.Structs.Rect.rectRoundExtents' in case you need to round
-- to a rectangle that covers fully the original one.
-- 
-- This function is the equivalent of calling @floor@ on
-- the coordinates of the origin, and @ceil@ on the size.
-- 
-- /Since: 1.4/
rectRound ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m (Rect)
rectRound r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    res <- SP.callocBoxedBytes 16 :: IO (Ptr Rect)
    graphene_rect_round r' res
    res' <- (wrapBoxed Rect) res
    touchManagedPtr r
    return res'

#if defined(ENABLE_OVERLOADING)
data RectRoundMethodInfo
instance (signature ~ (m (Rect)), MonadIO m) => O.OverloadedMethod RectRoundMethodInfo Rect signature where
    overloadedMethod = rectRound

instance O.OverloadedMethodInfo RectRoundMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectRound",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectRound"
        })


#endif

-- method Rect::round_extents
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the\n  rectangle with rounded extents"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_round_extents" graphene_rect_round_extents :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Rect ->                             -- res : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO ()

-- | Rounds the origin of the given rectangle to its nearest
-- integer value and and recompute the size so that the
-- rectangle is large enough to contain all the conrners
-- of the original rectangle.
-- 
-- This function is the equivalent of calling @floor@ on
-- the coordinates of the origin, and recomputing the size
-- calling @ceil@ on the bottom-right coordinates.
-- 
-- If you want to be sure that the rounded rectangle
-- completely covers the area that was covered by the
-- original rectangle — i.e. you want to cover the area
-- including all its corners — this function will make sure
-- that the size is recomputed taking into account the ceiling
-- of the coordinates of the bottom-right corner.
-- If the difference between the original coordinates and the
-- coordinates of the rounded rectangle is greater than the
-- difference between the original size and and the rounded
-- size, then the move of the origin would not be compensated
-- by a move in the anti-origin, leaving the corners of the
-- original rectangle outside the rounded one.
-- 
-- /Since: 1.10/
rectRoundExtents ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m (Rect)
rectRoundExtents r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    res <- SP.callocBoxedBytes 16 :: IO (Ptr Rect)
    graphene_rect_round_extents r' res
    res' <- (wrapBoxed Rect) res
    touchManagedPtr r
    return res'

#if defined(ENABLE_OVERLOADING)
data RectRoundExtentsMethodInfo
instance (signature ~ (m (Rect)), MonadIO m) => O.OverloadedMethod RectRoundExtentsMethodInfo Rect signature where
    overloadedMethod = rectRoundExtents

instance O.OverloadedMethodInfo RectRoundExtentsMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectRoundExtents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectRoundExtents"
        })


#endif

-- method Rect::round_to_pixel
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Rect" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_round_to_pixel" graphene_rect_round_to_pixel :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO (Ptr Rect)

{-# DEPRECATED rectRoundToPixel ["(Since version 1.4)","Use 'GI.Graphene.Structs.Rect.rectRound' instead"] #-}
-- | Rounds the origin and the size of the given rectangle to
-- their nearest integer values; the rounding is guaranteed
-- to be large enough to contain the original rectangle.
-- 
-- /Since: 1.0/
rectRoundToPixel ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m Rect
    -- ^ __Returns:__ the pixel-aligned rectangle.
rectRoundToPixel r = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    result <- graphene_rect_round_to_pixel r'
    checkUnexpectedReturnNULL "rectRoundToPixel" result
    result' <- (newBoxed Rect) result
    touchManagedPtr r
    return result'

#if defined(ENABLE_OVERLOADING)
data RectRoundToPixelMethodInfo
instance (signature ~ (m Rect), MonadIO m) => O.OverloadedMethod RectRoundToPixelMethodInfo Rect signature where
    overloadedMethod = rectRoundToPixel

instance O.OverloadedMethodInfo RectRoundToPixelMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectRoundToPixel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectRoundToPixel"
        })


#endif

-- method Rect::scale
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "s_h"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "horizontal scale factor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "s_v"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "vertical scale factor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the\n  scaled rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_scale" graphene_rect_scale :: 
    Ptr Rect ->                             -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    CFloat ->                               -- s_h : TBasicType TFloat
    CFloat ->                               -- s_v : TBasicType TFloat
    Ptr Rect ->                             -- res : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO ()

-- | Scales the size and origin of a rectangle horizontaly by /@sH@/,
-- and vertically by /@sV@/. The result /@res@/ is normalized.
-- 
-- /Since: 1.10/
rectScale ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> Float
    -- ^ /@sH@/: horizontal scale factor
    -> Float
    -- ^ /@sV@/: vertical scale factor
    -> m (Rect)
rectScale r sH sV = liftIO $ do
    r' <- unsafeManagedPtrGetPtr r
    let sH' = realToFrac sH
    let sV' = realToFrac sV
    res <- SP.callocBoxedBytes 16 :: IO (Ptr Rect)
    graphene_rect_scale r' sH' sV' res
    res' <- (wrapBoxed Rect) res
    touchManagedPtr r
    return res'

#if defined(ENABLE_OVERLOADING)
data RectScaleMethodInfo
instance (signature ~ (Float -> Float -> m (Rect)), MonadIO m) => O.OverloadedMethod RectScaleMethodInfo Rect signature where
    overloadedMethod = rectScale

instance O.OverloadedMethodInfo RectScaleMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectScale",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectScale"
        })


#endif

-- method Rect::union
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a #graphene_rect_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_union" graphene_rect_union :: 
    Ptr Rect ->                             -- a : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Rect ->                             -- b : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Rect ->                             -- res : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO ()

-- | Computes the union of the two given rectangles.
-- 
-- <<http://developer.gnome.org/graphene/stable/rectangle-union.png>>
-- 
-- The union in the image above is the blue outline.
-- 
-- /Since: 1.0/
rectUnion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Rect
    -- ^ /@a@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> Rect
    -- ^ /@b@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m (Rect)
rectUnion a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    res <- SP.callocBoxedBytes 16 :: IO (Ptr Rect)
    graphene_rect_union a' b' res
    res' <- (wrapBoxed Rect) res
    touchManagedPtr a
    touchManagedPtr b
    return res'

#if defined(ENABLE_OVERLOADING)
data RectUnionMethodInfo
instance (signature ~ (Rect -> m (Rect)), MonadIO m) => O.OverloadedMethod RectUnionMethodInfo Rect signature where
    overloadedMethod = rectUnion

instance O.OverloadedMethodInfo RectUnionMethodInfo Rect where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Rect.rectUnion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Rect.html#v:rectUnion"
        })


#endif

-- method Rect::alloc
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Rect" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_alloc" graphene_rect_alloc :: 
    IO (Ptr Rect)

-- | Allocates a new t'GI.Graphene.Structs.Rect.Rect'.
-- 
-- The contents of the returned rectangle are undefined.
-- 
-- /Since: 1.0/
rectAlloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Rect
    -- ^ __Returns:__ the newly allocated rectangle
rectAlloc  = liftIO $ do
    result <- graphene_rect_alloc
    checkUnexpectedReturnNULL "rectAlloc" result
    result' <- (wrapBoxed Rect) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Rect::zero
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Rect" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_rect_zero" graphene_rect_zero :: 
    IO (Ptr Rect)

-- | Returns a degenerate rectangle with origin fixed at (0, 0) and
-- a size of 0, 0.
-- 
-- /Since: 1.4/
rectZero ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Rect
    -- ^ __Returns:__ a fixed rectangle
rectZero  = liftIO $ do
    result <- graphene_rect_zero
    checkUnexpectedReturnNULL "rectZero" result
    result' <- (newBoxed Rect) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveRectMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveRectMethod "containsPoint" o = RectContainsPointMethodInfo
    ResolveRectMethod "containsRect" o = RectContainsRectMethodInfo
    ResolveRectMethod "equal" o = RectEqualMethodInfo
    ResolveRectMethod "expand" o = RectExpandMethodInfo
    ResolveRectMethod "free" o = RectFreeMethodInfo
    ResolveRectMethod "init" o = RectInitMethodInfo
    ResolveRectMethod "initFromRect" o = RectInitFromRectMethodInfo
    ResolveRectMethod "inset" o = RectInsetMethodInfo
    ResolveRectMethod "insetR" o = RectInsetRMethodInfo
    ResolveRectMethod "interpolate" o = RectInterpolateMethodInfo
    ResolveRectMethod "intersection" o = RectIntersectionMethodInfo
    ResolveRectMethod "normalize" o = RectNormalizeMethodInfo
    ResolveRectMethod "normalizeR" o = RectNormalizeRMethodInfo
    ResolveRectMethod "offset" o = RectOffsetMethodInfo
    ResolveRectMethod "offsetR" o = RectOffsetRMethodInfo
    ResolveRectMethod "round" o = RectRoundMethodInfo
    ResolveRectMethod "roundExtents" o = RectRoundExtentsMethodInfo
    ResolveRectMethod "roundToPixel" o = RectRoundToPixelMethodInfo
    ResolveRectMethod "scale" o = RectScaleMethodInfo
    ResolveRectMethod "union" o = RectUnionMethodInfo
    ResolveRectMethod "getArea" o = RectGetAreaMethodInfo
    ResolveRectMethod "getBottomLeft" o = RectGetBottomLeftMethodInfo
    ResolveRectMethod "getBottomRight" o = RectGetBottomRightMethodInfo
    ResolveRectMethod "getCenter" o = RectGetCenterMethodInfo
    ResolveRectMethod "getHeight" o = RectGetHeightMethodInfo
    ResolveRectMethod "getTopLeft" o = RectGetTopLeftMethodInfo
    ResolveRectMethod "getTopRight" o = RectGetTopRightMethodInfo
    ResolveRectMethod "getWidth" o = RectGetWidthMethodInfo
    ResolveRectMethod "getX" o = RectGetXMethodInfo
    ResolveRectMethod "getY" o = RectGetYMethodInfo
    ResolveRectMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveRectMethod t Rect, O.OverloadedMethod info Rect p) => OL.IsLabel t (Rect -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveRectMethod t Rect, O.OverloadedMethod info Rect p, R.HasField t Rect p) => R.HasField t Rect p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveRectMethod t Rect, O.OverloadedMethodInfo info Rect) => OL.IsLabel t (O.MethodProxy info Rect) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


