// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// TracesData represents the traces data that can be stored in a persistent storage,
// OR can be embedded by other protocols that transfer OTLP traces data but do not
// implement the OTLP protocol.
type TracesData struct {
	ResourceSpans []*ResourceSpans
}

var (
	protoPoolTracesData = sync.Pool{
		New: func() any {
			return &TracesData{}
		},
	}
)

func NewTracesData() *TracesData {
	if !UseProtoPooling.IsEnabled() {
		return &TracesData{}
	}
	return protoPoolTracesData.Get().(*TracesData)
}

func DeleteTracesData(orig *TracesData, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.ResourceSpans {
		DeleteResourceSpans(orig.ResourceSpans[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolTracesData.Put(orig)
	}
}

func CopyTracesData(dest, src *TracesData) *TracesData {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewTracesData()
	}
	dest.ResourceSpans = CopyResourceSpansPtrSlice(dest.ResourceSpans, src.ResourceSpans)

	return dest
}

func CopyTracesDataSlice(dest, src []TracesData) []TracesData {
	var newDest []TracesData
	if cap(dest) < len(src) {
		newDest = make([]TracesData, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteTracesData(&dest[i], false)
		}
	}
	for i := range src {
		CopyTracesData(&newDest[i], &src[i])
	}
	return newDest
}

func CopyTracesDataPtrSlice(dest, src []*TracesData) []*TracesData {
	var newDest []*TracesData
	if cap(dest) < len(src) {
		newDest = make([]*TracesData, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewTracesData()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteTracesData(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewTracesData()
		}
	}
	for i := range src {
		CopyTracesData(newDest[i], src[i])
	}
	return newDest
}

func (orig *TracesData) Reset() {
	*orig = TracesData{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *TracesData) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.ResourceSpans) > 0 {
		dest.WriteObjectField("resourceSpans")
		dest.WriteArrayStart()
		orig.ResourceSpans[0].MarshalJSON(dest)
		for i := 1; i < len(orig.ResourceSpans); i++ {
			dest.WriteMore()
			orig.ResourceSpans[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *TracesData) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "resourceSpans", "resource_spans":
			for iter.ReadArray() {
				orig.ResourceSpans = append(orig.ResourceSpans, NewResourceSpans())
				orig.ResourceSpans[len(orig.ResourceSpans)-1].UnmarshalJSON(iter)
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *TracesData) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.ResourceSpans {
		l = orig.ResourceSpans[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *TracesData) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.ResourceSpans) - 1; i >= 0; i-- {
		l = orig.ResourceSpans[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func (orig *TracesData) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceSpans", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ResourceSpans = append(orig.ResourceSpans, NewResourceSpans())
			err = orig.ResourceSpans[len(orig.ResourceSpans)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestTracesData() *TracesData {
	orig := NewTracesData()
	orig.ResourceSpans = []*ResourceSpans{{}, GenTestResourceSpans()}
	return orig
}

func GenTestTracesDataPtrSlice() []*TracesData {
	orig := make([]*TracesData, 5)
	orig[0] = NewTracesData()
	orig[1] = GenTestTracesData()
	orig[2] = NewTracesData()
	orig[3] = GenTestTracesData()
	orig[4] = NewTracesData()
	return orig
}

func GenTestTracesDataSlice() []TracesData {
	orig := make([]TracesData, 5)
	orig[1] = *GenTestTracesData()
	orig[3] = *GenTestTracesData()
	return orig
}
