/* gpx-viewer-path-layer.c generated by valac 0.56.18, the Vala compiler
 * generated from gpx-viewer-path-layer.vala, do not modify */

/*
 * Copyright (C) 2008-2009 Pierre-Luc Beaudoin <pierre-luc@pierlux.com>
 * Copyright (C) 2011 Jiri Techet <techet@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/**
 * TODO:
 * Accept GpxTrack, not points.
 * Then remove object type from point.
 */

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <clutter/clutter.h>
#include "gpx.h"
#include <champlain/champlain.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GPX_VIEWER_TYPE_COLOR (gpx_viewer_color_get_type ())
typedef struct _GpxViewerColor GpxViewerColor;
enum  {
	GPX_VIEWER_PATH_LAYER_0_PROPERTY,
	GPX_VIEWER_PATH_LAYER_STROKE_COLOR_PROPERTY,
	GPX_VIEWER_PATH_LAYER_STROKE_WIDTH_PROPERTY,
	GPX_VIEWER_PATH_LAYER_VISIBLE_PROPERTY,
	GPX_VIEWER_PATH_LAYER_TRACK_PROPERTY,
	GPX_VIEWER_PATH_LAYER_NUM_PROPERTIES
};
static GParamSpec* gpx_viewer_path_layer_properties[GPX_VIEWER_PATH_LAYER_NUM_PROPERTIES];
#define __vala_ClutterColor_free0(var) ((var == NULL) ? NULL : (var = (_vala_ClutterColor_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gpx_point_unref0(var) ((var == NULL) ? NULL : (var = (gpx_point_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _GpxViewerColor {
	gdouble r;
	gdouble g;
	gdouble b;
};

struct _GpxViewerPathLayerPrivate {
	ClutterColor* _stroke_color;
	gdouble _stroke_width;
	GpxTrack* _track;
	gboolean _visible;
	ChamplainView* view;
	ClutterGroup* content_group;
	ClutterCairoTexture* path_actor;
	gboolean redraw_scheduled;
	gulong view_relocate_handler_id;
	gulong view_latitude_handler_id;
};

static gint GpxViewerPathLayer_private_offset;
static gpointer gpx_viewer_path_layer_parent_class = NULL;

VALA_EXTERN GType gpx_viewer_color_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GpxViewerColor* gpx_viewer_color_dup (const GpxViewerColor* self);
VALA_EXTERN void gpx_viewer_color_free (GpxViewerColor* self);
static void _vala_ClutterColor_free (ClutterColor* self);
static void gpx_viewer_path_layer_real_paint (ClutterActor* base);
static void gpx_viewer_path_layer_real_pick (ClutterActor* base,
                                      ClutterColor* color);
static void gpx_viewer_path_layer_real_get_preferred_width (ClutterActor* base,
                                                     gfloat for_height,
                                                     gfloat* min_width_p,
                                                     gfloat* natural_width_p);
static void gpx_viewer_path_layer_real_get_preferred_height (ClutterActor* base,
                                                      gfloat for_width,
                                                      gfloat* min_height_p,
                                                      gfloat* natural_height_p);
static void gpx_viewer_path_layer_real_allocate (ClutterActor* base,
                                          ClutterActorBox* box,
                                          ClutterAllocationFlags flags);
static void gpx_viewer_path_layer_real_map (ClutterActor* base);
static void gpx_viewer_path_layer_real_unmap (ClutterActor* base);
static void gpx_viewer_path_layer_real_dispose (GObject* base);
static gboolean gpx_viewer_path_layer_redraw_path (GpxViewerPathLayer* self);
static void gpx_viewer_path_layer_schedule_redraw (GpxViewerPathLayer* self);
static gboolean _gpx_viewer_path_layer_redraw_path_gsource_func (gpointer self);
static void gpx_viewer_path_layer_real_set_view (ChamplainLayer* base,
                                          ChamplainView* view);
static void ___lambda7_ (GpxViewerPathLayer* self);
static void ____lambda7__champlain_view_layer_relocated (ChamplainView* _sender,
                                                  gpointer self);
static void ___lambda8_ (GpxViewerPathLayer* self);
static void ____lambda8__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static ChamplainBoundingBox* gpx_viewer_path_layer_real_get_bounding_box (ChamplainLayer* base);
static ClutterColor* _vala_ClutterColor_copy (ClutterColor* self);
static void _gpx_viewer_path_layer_track___lambda9_ (GpxViewerPathLayer* self);
static void __gpx_viewer_path_layer_track___lambda9__gpx_track_point_removed (GpxTrack* _sender,
                                                                       GpxPoint* point,
                                                                       gpointer self);
static GObject * gpx_viewer_path_layer_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void gpx_viewer_path_layer_finalize (GObject * obj);
static GType gpx_viewer_path_layer_get_type_once (void);
static void _vala_gpx_viewer_path_layer_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_gpx_viewer_path_layer_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const GpxViewerColor GPX_VIEWER_HEIGHT_COLORS[5] = {{0.0, 0.0, 1.0}, {0.0, 1.0, 1.0}, {0.0, 1.0, 0.0}, {1.0, 0.8, 0.0}, {1.0, 0.0, 0.0}};
const ClutterColor GPX_VIEWER_DEFAULT_STROKE_COLOR = {(guint8) 0xa4, (guint8) 0x00, (guint8) 0x00, (guint8) 0xff};

GpxViewerColor*
gpx_viewer_color_dup (const GpxViewerColor* self)
{
	GpxViewerColor* dup;
#line 38 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	dup = g_new0 (GpxViewerColor, 1);
#line 38 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	memcpy (dup, self, sizeof (GpxViewerColor));
#line 38 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	return dup;
#line 154 "gpx-viewer-path-layer.c"
}

void
gpx_viewer_color_free (GpxViewerColor* self)
{
#line 38 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	g_free (self);
#line 162 "gpx-viewer-path-layer.c"
}

static GType
gpx_viewer_color_get_type_once (void)
{
	GType gpx_viewer_color_type_id;
	gpx_viewer_color_type_id = g_boxed_type_register_static ("GpxViewerColor", (GBoxedCopyFunc) gpx_viewer_color_dup, (GBoxedFreeFunc) gpx_viewer_color_free);
	return gpx_viewer_color_type_id;
}

GType
gpx_viewer_color_get_type (void)
{
	static volatile gsize gpx_viewer_color_type_id__once = 0;
	if (g_once_init_enter (&gpx_viewer_color_type_id__once)) {
		GType gpx_viewer_color_type_id;
		gpx_viewer_color_type_id = gpx_viewer_color_get_type_once ();
		g_once_init_leave (&gpx_viewer_color_type_id__once, gpx_viewer_color_type_id);
	}
	return gpx_viewer_color_type_id__once;
}

static inline gpointer
gpx_viewer_path_layer_get_instance_private (GpxViewerPathLayer* self)
{
	return G_STRUCT_MEMBER_P (self, GpxViewerPathLayer_private_offset);
}

static void
_vala_ClutterColor_free (ClutterColor* self)
{
#line 104 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	g_boxed_free (CLUTTER_TYPE_COLOR, self);
#line 196 "gpx-viewer-path-layer.c"
}

static void
gpx_viewer_path_layer_real_paint (ClutterActor* base)
{
	GpxViewerPathLayer * self;
	ClutterGroup* _tmp0_;
#line 130 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self = (GpxViewerPathLayer*) base;
#line 132 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp0_ = self->priv->content_group;
#line 132 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	clutter_actor_paint ((ClutterActor*) _tmp0_);
#line 210 "gpx-viewer-path-layer.c"
}

static void
gpx_viewer_path_layer_real_pick (ClutterActor* base,
                                 ClutterColor* color)
{
	GpxViewerPathLayer * self;
	ClutterColor _tmp0_;
	ClutterGroup* _tmp1_;
#line 135 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self = (GpxViewerPathLayer*) base;
#line 137 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp0_ = *color;
#line 137 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	CLUTTER_ACTOR_CLASS (gpx_viewer_path_layer_parent_class)->pick ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, champlain_layer_get_type (), ChamplainLayer), &_tmp0_);
#line 138 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp1_ = self->priv->content_group;
#line 138 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	clutter_actor_paint ((ClutterActor*) _tmp1_);
#line 230 "gpx-viewer-path-layer.c"
}

static void
gpx_viewer_path_layer_real_get_preferred_width (ClutterActor* base,
                                                gfloat for_height,
                                                gfloat* min_width_p,
                                                gfloat* natural_width_p)
{
	GpxViewerPathLayer * self;
	gfloat _vala_min_width_p = 0.0F;
	gfloat _vala_natural_width_p = 0.0F;
	ClutterGroup* _tmp0_;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
#line 141 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self = (GpxViewerPathLayer*) base;
#line 143 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp0_ = self->priv->content_group;
#line 143 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	clutter_actor_get_preferred_width ((ClutterActor*) _tmp0_, for_height, &_tmp1_, &_tmp2_);
#line 143 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_vala_min_width_p = _tmp1_;
#line 143 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_vala_natural_width_p = _tmp2_;
#line 141 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (min_width_p) {
#line 141 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		*min_width_p = _vala_min_width_p;
#line 259 "gpx-viewer-path-layer.c"
	}
#line 141 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (natural_width_p) {
#line 141 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		*natural_width_p = _vala_natural_width_p;
#line 265 "gpx-viewer-path-layer.c"
	}
}

static void
gpx_viewer_path_layer_real_get_preferred_height (ClutterActor* base,
                                                 gfloat for_width,
                                                 gfloat* min_height_p,
                                                 gfloat* natural_height_p)
{
	GpxViewerPathLayer * self;
	gfloat _vala_min_height_p = 0.0F;
	gfloat _vala_natural_height_p = 0.0F;
	ClutterGroup* _tmp0_;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
#line 146 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self = (GpxViewerPathLayer*) base;
#line 148 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp0_ = self->priv->content_group;
#line 148 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	clutter_actor_get_preferred_height ((ClutterActor*) _tmp0_, for_width, &_tmp1_, &_tmp2_);
#line 148 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_vala_min_height_p = _tmp1_;
#line 148 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_vala_natural_height_p = _tmp2_;
#line 146 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (min_height_p) {
#line 146 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		*min_height_p = _vala_min_height_p;
#line 295 "gpx-viewer-path-layer.c"
	}
#line 146 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (natural_height_p) {
#line 146 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		*natural_height_p = _vala_natural_height_p;
#line 301 "gpx-viewer-path-layer.c"
	}
}

static void
gpx_viewer_path_layer_real_allocate (ClutterActor* base,
                                     ClutterActorBox* box,
                                     ClutterAllocationFlags flags)
{
	GpxViewerPathLayer * self;
	ClutterActorBox _tmp0_;
	ClutterActorBox child_box = {0};
	ClutterActorBox _tmp1_;
	ClutterActorBox _tmp2_;
	ClutterActorBox _tmp3_;
	ClutterActorBox _tmp4_;
	ClutterActorBox _tmp5_ = {0};
	ClutterGroup* _tmp6_;
	ClutterActorBox _tmp7_;
#line 151 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self = (GpxViewerPathLayer*) base;
#line 153 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp0_ = *box;
#line 153 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	CLUTTER_ACTOR_CLASS (gpx_viewer_path_layer_parent_class)->allocate ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, champlain_layer_get_type (), ChamplainLayer), &_tmp0_, flags);
#line 154 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp1_ = *box;
#line 154 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp2_ = *box;
#line 154 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp3_ = *box;
#line 154 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp4_ = *box;
#line 154 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp5_.x1 = 0.0f;
#line 154 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp5_.y1 = 0.0f;
#line 154 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp5_.x2 = _tmp1_.x2 - _tmp2_.x1;
#line 154 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp5_.y2 = _tmp3_.y2 - _tmp4_.y1;
#line 154 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	child_box = _tmp5_;
#line 155 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp6_ = self->priv->content_group;
#line 155 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp7_ = child_box;
#line 155 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	clutter_actor_allocate ((ClutterActor*) _tmp6_, &_tmp7_, flags);
#line 350 "gpx-viewer-path-layer.c"
}

static void
gpx_viewer_path_layer_real_map (ClutterActor* base)
{
	GpxViewerPathLayer * self;
	ClutterGroup* _tmp0_;
#line 158 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self = (GpxViewerPathLayer*) base;
#line 160 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	CLUTTER_ACTOR_CLASS (gpx_viewer_path_layer_parent_class)->map ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, champlain_layer_get_type (), ChamplainLayer));
#line 161 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp0_ = self->priv->content_group;
#line 161 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	clutter_actor_map ((ClutterActor*) _tmp0_);
#line 366 "gpx-viewer-path-layer.c"
}

static void
gpx_viewer_path_layer_real_unmap (ClutterActor* base)
{
	GpxViewerPathLayer * self;
	ClutterGroup* _tmp0_;
#line 164 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self = (GpxViewerPathLayer*) base;
#line 166 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	CLUTTER_ACTOR_CLASS (gpx_viewer_path_layer_parent_class)->unmap ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, champlain_layer_get_type (), ChamplainLayer));
#line 167 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp0_ = self->priv->content_group;
#line 167 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	clutter_actor_unmap ((ClutterActor*) _tmp0_);
#line 382 "gpx-viewer-path-layer.c"
}

static void
gpx_viewer_path_layer_real_dispose (GObject* base)
{
	GpxViewerPathLayer * self;
	ChamplainView* _tmp0_;
	ClutterGroup* _tmp1_;
#line 170 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self = (GpxViewerPathLayer*) base;
#line 172 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp0_ = self->priv->view;
#line 172 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (_tmp0_ != NULL) {
#line 173 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		champlain_layer_set_view ((ChamplainLayer*) self, NULL);
#line 399 "gpx-viewer-path-layer.c"
	}
#line 175 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp1_ = self->priv->content_group;
#line 175 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (_tmp1_ != NULL) {
#line 405 "gpx-viewer-path-layer.c"
		ClutterGroup* _tmp2_;
#line 176 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp2_ = self->priv->content_group;
#line 176 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		clutter_actor_unparent ((ClutterActor*) _tmp2_);
#line 177 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_g_object_unref0 (self->priv->content_group);
#line 177 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		self->priv->content_group = NULL;
#line 415 "gpx-viewer-path-layer.c"
	}
#line 180 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	G_OBJECT_CLASS (gpx_viewer_path_layer_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, champlain_layer_get_type (), ChamplainLayer));
#line 419 "gpx-viewer-path-layer.c"
}

static gpointer
_gpx_point_ref0 (gpointer self)
{
#line 226 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	return self ? gpx_point_ref (self) : NULL;
#line 427 "gpx-viewer-path-layer.c"
}

static gboolean
gpx_viewer_path_layer_redraw_path (GpxViewerPathLayer* self)
{
	gboolean _tmp0_ = FALSE;
	ChamplainView* _tmp1_;
	gfloat width = 0.0F;
	gfloat height = 0.0F;
	ChamplainView* _tmp3_;
	gfloat _tmp4_ = 0.0F;
	gfloat _tmp5_ = 0.0F;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	gboolean _tmp9_;
	guint last_width = 0U;
	guint last_height = 0U;
	ClutterCairoTexture* _tmp10_;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	gboolean _tmp13_ = FALSE;
	gint x = 0;
	gint y = 0;
	ChamplainView* _tmp15_;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	ClutterCairoTexture* _tmp18_;
	cairo_t* cr = NULL;
	ClutterCairoTexture* _tmp19_;
	cairo_t* _tmp20_;
	cairo_t* _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* _tmp23_;
	gdouble min_elv = 0.0;
	gdouble max_elv = 0.0;
	gdouble range = 0.0;
	GpxTrack* _tmp24_;
	GpxTrack* _tmp25_;
	cairo_t* _tmp26_;
	gdouble _tmp27_;
	gdouble _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	gint old_val = 0;
	GpxTrack* _tmp31_;
	GList* _tmp32_;
	cairo_t* _tmp47_;
	gboolean result;
#line 185 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self->priv->redraw_scheduled = FALSE;
#line 188 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp1_ = self->priv->view;
#line 188 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (_tmp1_ == NULL) {
#line 188 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp0_ = TRUE;
#line 485 "gpx-viewer-path-layer.c"
	} else {
		ClutterGroup* _tmp2_;
#line 188 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp2_ = self->priv->content_group;
#line 188 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 492 "gpx-viewer-path-layer.c"
	}
#line 188 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (_tmp0_) {
#line 189 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		result = FALSE;
#line 189 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		return result;
#line 500 "gpx-viewer-path-layer.c"
	}
#line 192 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp3_ = self->priv->view;
#line 192 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	clutter_actor_get_size ((ClutterActor*) _tmp3_, &_tmp4_, &_tmp5_);
#line 192 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	width = _tmp4_;
#line 192 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	height = _tmp5_;
#line 194 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp8_ = gpx_viewer_path_layer_get_visible (self);
#line 194 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp9_ = _tmp8_;
#line 194 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (!_tmp9_) {
#line 194 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp7_ = TRUE;
#line 518 "gpx-viewer-path-layer.c"
	} else {
#line 194 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp7_ = width == 0.0f;
#line 522 "gpx-viewer-path-layer.c"
	}
#line 194 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (_tmp7_) {
#line 194 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp6_ = TRUE;
#line 528 "gpx-viewer-path-layer.c"
	} else {
#line 194 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp6_ = height == 0.0f;
#line 532 "gpx-viewer-path-layer.c"
	}
#line 194 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (_tmp6_) {
#line 195 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		result = FALSE;
#line 195 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		return result;
#line 540 "gpx-viewer-path-layer.c"
	}
#line 198 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp10_ = self->priv->path_actor;
#line 198 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	clutter_cairo_texture_get_surface_size (_tmp10_, &_tmp11_, &_tmp12_);
#line 198 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	last_width = _tmp11_;
#line 198 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	last_height = _tmp12_;
#line 200 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (((guint) width) != last_width) {
#line 200 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp13_ = TRUE;
#line 554 "gpx-viewer-path-layer.c"
	} else {
#line 200 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp13_ = ((guint) height) != last_height;
#line 558 "gpx-viewer-path-layer.c"
	}
#line 200 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (_tmp13_) {
#line 562 "gpx-viewer-path-layer.c"
		ClutterCairoTexture* _tmp14_;
#line 201 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp14_ = self->priv->path_actor;
#line 201 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		clutter_cairo_texture_set_surface_size (_tmp14_, (guint) width, (guint) height);
#line 568 "gpx-viewer-path-layer.c"
	}
#line 205 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp15_ = self->priv->view;
#line 205 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	champlain_view_get_viewport_origin (_tmp15_, &_tmp16_, &_tmp17_);
#line 205 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	x = _tmp16_;
#line 205 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	y = _tmp17_;
#line 206 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp18_ = self->priv->path_actor;
#line 206 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	clutter_actor_set_position ((ClutterActor*) _tmp18_, (gfloat) x, (gfloat) y);
#line 208 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp19_ = self->priv->path_actor;
#line 208 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp20_ = clutter_cairo_texture_create (_tmp19_);
#line 208 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	cr = _tmp20_;
#line 211 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp21_ = cr;
#line 211 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	cairo_set_operator (_tmp21_, CAIRO_OPERATOR_CLEAR);
#line 212 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp22_ = cr;
#line 212 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	cairo_paint (_tmp22_);
#line 213 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp23_ = cr;
#line 213 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	cairo_set_operator (_tmp23_, CAIRO_OPERATOR_OVER);
#line 217 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp24_ = self->priv->_track;
#line 217 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	min_elv = _tmp24_->min_elevation;
#line 218 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp25_ = self->priv->_track;
#line 218 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	max_elv = _tmp25_->max_elevation;
#line 219 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	range = MAX (250.0, max_elv - min_elv);
#line 221 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp26_ = cr;
#line 221 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp27_ = gpx_viewer_path_layer_get_stroke_width (self);
#line 221 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp28_ = _tmp27_;
#line 221 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	cairo_set_line_width (_tmp26_, _tmp28_);
#line 222 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp29_ = cr;
#line 222 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	cairo_set_line_cap (_tmp29_, CAIRO_LINE_CAP_ROUND);
#line 223 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp30_ = cr;
#line 223 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	cairo_set_line_join (_tmp30_, CAIRO_LINE_JOIN_ROUND);
#line 225 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	old_val = -1;
#line 226 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp31_ = self->priv->_track;
#line 226 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp32_ = _tmp31_->points;
#line 632 "gpx-viewer-path-layer.c"
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
#line 226 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		location_collection = _tmp32_;
#line 226 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
#line 640 "gpx-viewer-path-layer.c"
			GpxPoint* _tmp33_;
			GpxPoint* location = NULL;
#line 226 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
			_tmp33_ = _gpx_point_ref0 ((GpxPoint*) location_it->data);
#line 226 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
			location = _tmp33_;
#line 647 "gpx-viewer-path-layer.c"
			{
				gint val = 0;
				GpxPoint* _tmp34_;
				gfloat c_x = 0.0F;
				gfloat c_y = 0.0F;
				ChamplainView* _tmp35_;
				GpxPoint* _tmp36_;
				ChamplainView* _tmp37_;
				GpxPoint* _tmp38_;
#line 228 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
				_tmp34_ = location;
#line 228 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
				val = (gint) round (((G_N_ELEMENTS (GPX_VIEWER_HEIGHT_COLORS) - 1) * (_tmp34_->elevation - min_elv)) / range);
#line 230 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
				_tmp35_ = self->priv->view;
#line 230 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
				_tmp36_ = location;
#line 230 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
				c_x = (gfloat) champlain_view_longitude_to_x (_tmp35_, _tmp36_->lon_dec);
#line 231 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
				_tmp37_ = self->priv->view;
#line 231 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
				_tmp38_ = location;
#line 231 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
				c_y = (gfloat) champlain_view_latitude_to_y (_tmp37_, _tmp38_->lat_dec);
#line 232 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
				if (val != old_val) {
#line 675 "gpx-viewer-path-layer.c"
					cairo_t* _tmp39_;
					cairo_t* _tmp40_;
					cairo_t* _tmp41_;
					GpxViewerColor _tmp42_;
					GpxViewerColor _tmp43_;
					GpxViewerColor _tmp44_;
					cairo_t* _tmp45_;
#line 233 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
					_tmp39_ = cr;
#line 233 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
					cairo_line_to (_tmp39_, (gdouble) c_x, (gdouble) c_y);
#line 234 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
					_tmp40_ = cr;
#line 234 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
					cairo_stroke (_tmp40_);
#line 235 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
					_tmp41_ = cr;
#line 235 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
					_tmp42_ = GPX_VIEWER_HEIGHT_COLORS[val];
#line 235 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
					_tmp43_ = GPX_VIEWER_HEIGHT_COLORS[val];
#line 235 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
					_tmp44_ = GPX_VIEWER_HEIGHT_COLORS[val];
#line 235 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
					cairo_set_source_rgb (_tmp41_, _tmp42_.r, _tmp43_.g, _tmp44_.b);
#line 236 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
					old_val = val;
#line 237 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
					_tmp45_ = cr;
#line 237 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
					cairo_move_to (_tmp45_, (gdouble) c_x, (gdouble) c_y);
#line 707 "gpx-viewer-path-layer.c"
				} else {
					cairo_t* _tmp46_;
#line 239 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
					_tmp46_ = cr;
#line 239 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
					cairo_line_to (_tmp46_, (gdouble) c_x, (gdouble) c_y);
#line 714 "gpx-viewer-path-layer.c"
				}
#line 226 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
				_gpx_point_unref0 (location);
#line 718 "gpx-viewer-path-layer.c"
			}
		}
	}
#line 243 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp47_ = cr;
#line 243 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	cairo_stroke (_tmp47_);
#line 245 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	result = FALSE;
#line 245 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_cairo_destroy0 (cr);
#line 245 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	return result;
#line 732 "gpx-viewer-path-layer.c"
}

static gboolean
_gpx_viewer_path_layer_redraw_path_gsource_func (gpointer self)
{
	gboolean result;
	result = gpx_viewer_path_layer_redraw_path ((GpxViewerPathLayer*) self);
#line 252 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	return result;
#line 742 "gpx-viewer-path-layer.c"
}

static void
gpx_viewer_path_layer_schedule_redraw (GpxViewerPathLayer* self)
{
#line 250 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (!self->priv->redraw_scheduled) {
#line 251 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		self->priv->redraw_scheduled = TRUE;
#line 252 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		g_idle_add_full (CLUTTER_PRIORITY_REDRAW, _gpx_viewer_path_layer_redraw_path_gsource_func, g_object_ref (self), g_object_unref);
#line 754 "gpx-viewer-path-layer.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 270 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	return self ? g_object_ref (self) : NULL;
#line 763 "gpx-viewer-path-layer.c"
}

static void
___lambda7_ (GpxViewerPathLayer* self)
{
#line 273 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	gpx_viewer_path_layer_schedule_redraw (self);
#line 771 "gpx-viewer-path-layer.c"
}

static void
____lambda7__champlain_view_layer_relocated (ChamplainView* _sender,
                                             gpointer self)
{
#line 273 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	___lambda7_ ((GpxViewerPathLayer*) self);
#line 780 "gpx-viewer-path-layer.c"
}

static void
___lambda8_ (GpxViewerPathLayer* self)
{
#line 274 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	gpx_viewer_path_layer_schedule_redraw (self);
#line 788 "gpx-viewer-path-layer.c"
}

static void
____lambda8__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 274 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	___lambda8_ ((GpxViewerPathLayer*) self);
#line 798 "gpx-viewer-path-layer.c"
}

static void
gpx_viewer_path_layer_real_set_view (ChamplainLayer* base,
                                     ChamplainView* view)
{
	GpxViewerPathLayer * self;
	ChamplainView* _tmp0_;
	ChamplainView* _tmp3_;
#line 260 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self = (GpxViewerPathLayer*) base;
#line 265 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp0_ = self->priv->view;
#line 265 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (_tmp0_ != NULL) {
#line 814 "gpx-viewer-path-layer.c"
		ChamplainView* _tmp1_;
		ChamplainView* _tmp2_;
#line 266 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp1_ = self->priv->view;
#line 266 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		g_signal_handler_disconnect ((GObject*) _tmp1_, self->priv->view_relocate_handler_id);
#line 267 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp2_ = self->priv->view;
#line 267 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		g_signal_handler_disconnect ((GObject*) _tmp2_, self->priv->view_latitude_handler_id);
#line 825 "gpx-viewer-path-layer.c"
	}
#line 270 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp3_ = _g_object_ref0 (view);
#line 270 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_g_object_unref0 (self->priv->view);
#line 270 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self->priv->view = _tmp3_;
#line 272 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (view != NULL) {
#line 835 "gpx-viewer-path-layer.c"
		gulong _tmp4_;
		gulong _tmp5_;
#line 273 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp4_ = g_signal_connect_object (view, "layer-relocated", (GCallback) ____lambda7__champlain_view_layer_relocated, self, 0);
#line 273 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		self->priv->view_relocate_handler_id = _tmp4_;
#line 274 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp5_ = g_signal_connect_object ((GObject*) view, "notify::latitude", (GCallback) ____lambda8__g_object_notify, self, 0);
#line 274 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		self->priv->view_latitude_handler_id = _tmp5_;
#line 275 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		gpx_viewer_path_layer_schedule_redraw (self);
#line 848 "gpx-viewer-path-layer.c"
	}
}

static ChamplainBoundingBox*
gpx_viewer_path_layer_real_get_bounding_box (ChamplainLayer* base)
{
	GpxViewerPathLayer * self;
	ChamplainBoundingBox* bbox = NULL;
	ChamplainBoundingBox* _tmp0_;
	GpxTrack* _tmp1_;
	GList* _tmp2_;
	ChamplainBoundingBox* _tmp7_;
	ChamplainBoundingBox* _tmp8_;
	ChamplainBoundingBox* _tmp13_;
	ChamplainBoundingBox* _tmp14_;
	ChamplainBoundingBox* result;
#line 279 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self = (GpxViewerPathLayer*) base;
#line 281 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp0_ = champlain_bounding_box_new ();
#line 281 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	bbox = _tmp0_;
#line 282 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp1_ = self->priv->_track;
#line 282 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp2_ = _tmp1_->points;
#line 875 "gpx-viewer-path-layer.c"
	{
		GList* point_collection = NULL;
		GList* point_it = NULL;
#line 282 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		point_collection = _tmp2_;
#line 282 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		for (point_it = point_collection; point_it != NULL; point_it = point_it->next) {
#line 883 "gpx-viewer-path-layer.c"
			GpxPoint* _tmp3_;
			GpxPoint* point = NULL;
#line 282 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
			_tmp3_ = _gpx_point_ref0 ((GpxPoint*) point_it->data);
#line 282 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
			point = _tmp3_;
#line 890 "gpx-viewer-path-layer.c"
			{
				ChamplainBoundingBox* _tmp4_;
				GpxPoint* _tmp5_;
				GpxPoint* _tmp6_;
#line 283 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
				_tmp4_ = bbox;
#line 283 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
				_tmp5_ = point;
#line 283 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
				_tmp6_ = point;
#line 283 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
				champlain_bounding_box_extend (_tmp4_, _tmp5_->lat_dec, _tmp6_->lon_dec);
#line 282 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
				_gpx_point_unref0 (point);
#line 905 "gpx-viewer-path-layer.c"
			}
		}
	}
#line 286 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp7_ = bbox;
#line 286 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp8_ = bbox;
#line 286 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (_tmp7_->left == _tmp8_->right) {
#line 915 "gpx-viewer-path-layer.c"
		ChamplainBoundingBox* _tmp9_;
		ChamplainBoundingBox* _tmp10_;
		ChamplainBoundingBox* _tmp11_;
		ChamplainBoundingBox* _tmp12_;
#line 287 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp9_ = bbox;
#line 287 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp10_ = bbox;
#line 287 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp10_->left = _tmp10_->left - 0.0001;
#line 288 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp11_ = bbox;
#line 288 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp12_ = bbox;
#line 288 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp12_->right = _tmp12_->right + 0.0001;
#line 932 "gpx-viewer-path-layer.c"
	}
#line 291 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp13_ = bbox;
#line 291 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp14_ = bbox;
#line 291 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (_tmp13_->bottom == _tmp14_->top) {
#line 940 "gpx-viewer-path-layer.c"
		ChamplainBoundingBox* _tmp15_;
		ChamplainBoundingBox* _tmp16_;
		ChamplainBoundingBox* _tmp17_;
		ChamplainBoundingBox* _tmp18_;
#line 292 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp15_ = bbox;
#line 292 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp16_ = bbox;
#line 292 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp16_->bottom = _tmp16_->bottom - 0.0001;
#line 293 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp17_ = bbox;
#line 293 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp18_ = bbox;
#line 293 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp18_->top = _tmp18_->top + 0.0001;
#line 957 "gpx-viewer-path-layer.c"
	}
#line 296 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	result = bbox;
#line 296 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	return result;
#line 963 "gpx-viewer-path-layer.c"
}

GpxViewerPathLayer*
gpx_viewer_path_layer_construct (GType object_type)
{
	GpxViewerPathLayer * self = NULL;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self = (GpxViewerPathLayer*) g_object_new (object_type, NULL);
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	return self;
#line 974 "gpx-viewer-path-layer.c"
}

GpxViewerPathLayer*
gpx_viewer_path_layer_new (void)
{
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	return gpx_viewer_path_layer_construct (GPX_VIEWER_TYPE_PATH_LAYER);
#line 982 "gpx-viewer-path-layer.c"
}

ClutterColor*
gpx_viewer_path_layer_get_stroke_color (GpxViewerPathLayer* self)
{
	ClutterColor* result;
	ClutterColor* _tmp0_;
#line 59 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp0_ = self->priv->_stroke_color;
#line 59 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	result = _tmp0_;
#line 59 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	return result;
#line 996 "gpx-viewer-path-layer.c"
}

static ClutterColor*
_vala_ClutterColor_copy (ClutterColor* self)
{
#line 62 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	return g_boxed_copy (CLUTTER_TYPE_COLOR, self);
#line 1004 "gpx-viewer-path-layer.c"
}

static gpointer
__vala_ClutterColor_copy0 (gpointer self)
{
#line 62 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	return self ? _vala_ClutterColor_copy (self) : NULL;
#line 1012 "gpx-viewer-path-layer.c"
}

void
gpx_viewer_path_layer_set_stroke_color (GpxViewerPathLayer* self,
                                        ClutterColor* value)
{
#line 61 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (value == NULL) {
#line 1021 "gpx-viewer-path-layer.c"
		ClutterColor* _tmp0_;
#line 62 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp0_ = __vala_ClutterColor_copy0 (&GPX_VIEWER_DEFAULT_STROKE_COLOR);
#line 62 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		__vala_ClutterColor_free0 (self->priv->_stroke_color);
#line 62 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		self->priv->_stroke_color = _tmp0_;
#line 1029 "gpx-viewer-path-layer.c"
	} else {
		ClutterColor* _tmp1_;
#line 64 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp1_ = __vala_ClutterColor_copy0 (value);
#line 64 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		__vala_ClutterColor_free0 (self->priv->_stroke_color);
#line 64 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		self->priv->_stroke_color = _tmp1_;
#line 1038 "gpx-viewer-path-layer.c"
	}
#line 66 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	gpx_viewer_path_layer_schedule_redraw (self);
#line 60 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	g_object_notify_by_pspec ((GObject *) self, gpx_viewer_path_layer_properties[GPX_VIEWER_PATH_LAYER_STROKE_COLOR_PROPERTY]);
#line 1044 "gpx-viewer-path-layer.c"
}

gdouble
gpx_viewer_path_layer_get_stroke_width (GpxViewerPathLayer* self)
{
	gdouble result;
#line 72 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	result = self->priv->_stroke_width;
#line 72 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	return result;
#line 1055 "gpx-viewer-path-layer.c"
}

void
gpx_viewer_path_layer_set_stroke_width (GpxViewerPathLayer* self,
                                        gdouble value)
{
#line 75 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self->priv->_stroke_width = value;
#line 76 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	gpx_viewer_path_layer_schedule_redraw (self);
#line 74 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	g_object_notify_by_pspec ((GObject *) self, gpx_viewer_path_layer_properties[GPX_VIEWER_PATH_LAYER_STROKE_WIDTH_PROPERTY]);
#line 1068 "gpx-viewer-path-layer.c"
}

gboolean
gpx_viewer_path_layer_get_visible (GpxViewerPathLayer* self)
{
	gboolean result;
#line 82 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	result = self->priv->_visible;
#line 82 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	return result;
#line 1079 "gpx-viewer-path-layer.c"
}

void
gpx_viewer_path_layer_set_visible (GpxViewerPathLayer* self,
                                   gboolean value)
{
#line 85 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self->priv->_visible = value;
#line 86 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	if (value) {
#line 1090 "gpx-viewer-path-layer.c"
		ClutterCairoTexture* _tmp0_;
#line 87 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp0_ = self->priv->path_actor;
#line 87 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		clutter_actor_show ((ClutterActor*) _tmp0_);
#line 1096 "gpx-viewer-path-layer.c"
	} else {
		ClutterCairoTexture* _tmp1_;
#line 89 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		_tmp1_ = self->priv->path_actor;
#line 89 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		clutter_actor_hide ((ClutterActor*) _tmp1_);
#line 1103 "gpx-viewer-path-layer.c"
	}
#line 84 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	g_object_notify_by_pspec ((GObject *) self, gpx_viewer_path_layer_properties[GPX_VIEWER_PATH_LAYER_VISIBLE_PROPERTY]);
#line 1107 "gpx-viewer-path-layer.c"
}

static void
_gpx_viewer_path_layer_track___lambda9_ (GpxViewerPathLayer* self)
{
#line 98 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	gpx_viewer_path_layer_schedule_redraw (self);
#line 1115 "gpx-viewer-path-layer.c"
}

static void
__gpx_viewer_path_layer_track___lambda9__gpx_track_point_removed (GpxTrack* _sender,
                                                                  GpxPoint* point,
                                                                  gpointer self)
{
#line 97 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_gpx_viewer_path_layer_track___lambda9_ ((GpxViewerPathLayer*) self);
#line 1125 "gpx-viewer-path-layer.c"
}

void
gpx_viewer_path_layer_set_track (GpxViewerPathLayer* self,
                                 GpxTrack* value)
{
	GpxTrack* _tmp0_;
	GpxTrack* _tmp1_;
#line 96 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp0_ = _g_object_ref0 (value);
#line 96 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_g_object_unref0 (self->priv->_track);
#line 96 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self->priv->_track = _tmp0_;
#line 97 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp1_ = self->priv->_track;
#line 97 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	g_signal_connect_object (_tmp1_, "point-removed", (GCallback) __gpx_viewer_path_layer_track___lambda9__gpx_track_point_removed, self, 0);
#line 100 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	gpx_viewer_path_layer_schedule_redraw (self);
#line 95 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	g_object_notify_by_pspec ((GObject *) self, gpx_viewer_path_layer_properties[GPX_VIEWER_PATH_LAYER_TRACK_PROPERTY]);
#line 1148 "gpx-viewer-path-layer.c"
}

static GObject *
gpx_viewer_path_layer_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GpxViewerPathLayer * self;
	ClutterColor* _tmp0_;
	ClutterGroup* _tmp1_;
	ClutterGroup* _tmp2_;
	ClutterCairoTexture* _tmp3_;
	ClutterGroup* _tmp4_;
	ClutterCairoTexture* _tmp5_;
#line 114 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	parent_class = G_OBJECT_CLASS (gpx_viewer_path_layer_parent_class);
#line 114 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 114 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_VIEWER_TYPE_PATH_LAYER, GpxViewerPathLayer);
#line 116 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp0_ = __vala_ClutterColor_copy0 (&GPX_VIEWER_DEFAULT_STROKE_COLOR);
#line 116 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	__vala_ClutterColor_free0 (self->priv->_stroke_color);
#line 116 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self->priv->_stroke_color = _tmp0_;
#line 117 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self->priv->_stroke_width = 2.0;
#line 118 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self->priv->_visible = TRUE;
#line 120 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self->priv->redraw_scheduled = FALSE;
#line 122 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp1_ = (ClutterGroup*) clutter_group_new ();
#line 122 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	g_object_ref_sink (_tmp1_);
#line 122 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_g_object_unref0 (self->priv->content_group);
#line 122 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self->priv->content_group = _tmp1_;
#line 123 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp2_ = self->priv->content_group;
#line 123 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	clutter_actor_set_parent ((ClutterActor*) _tmp2_, (ClutterActor*) self);
#line 124 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp3_ = (ClutterCairoTexture*) clutter_cairo_texture_new ((guint) 256, (guint) 256);
#line 124 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	g_object_ref_sink (_tmp3_);
#line 124 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_g_object_unref0 (self->priv->path_actor);
#line 124 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self->priv->path_actor = _tmp3_;
#line 125 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp4_ = self->priv->content_group;
#line 125 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_tmp5_ = self->priv->path_actor;
#line 125 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	clutter_container_add_actor ((ClutterContainer*) _tmp4_, (ClutterActor*) _tmp5_);
#line 127 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	clutter_actor_queue_relayout ((ClutterActor*) self);
#line 114 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	return obj;
#line 1213 "gpx-viewer-path-layer.c"
}

static void
gpx_viewer_path_layer_class_init (GpxViewerPathLayerClass * klass,
                                  gpointer klass_data)
{
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	gpx_viewer_path_layer_parent_class = g_type_class_peek_parent (klass);
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	g_type_class_adjust_private_offset (klass, &GpxViewerPathLayer_private_offset);
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	((ClutterActorClass *) klass)->paint = (void (*) (ClutterActor*)) gpx_viewer_path_layer_real_paint;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	((ClutterActorClass *) klass)->pick = (void (*) (ClutterActor*, ClutterColor*)) gpx_viewer_path_layer_real_pick;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	((ClutterActorClass *) klass)->get_preferred_width = (void (*) (ClutterActor*, gfloat, gfloat*, gfloat*)) gpx_viewer_path_layer_real_get_preferred_width;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	((ClutterActorClass *) klass)->get_preferred_height = (void (*) (ClutterActor*, gfloat, gfloat*, gfloat*)) gpx_viewer_path_layer_real_get_preferred_height;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	((ClutterActorClass *) klass)->allocate = (void (*) (ClutterActor*, ClutterActorBox*, ClutterAllocationFlags)) gpx_viewer_path_layer_real_allocate;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	((ClutterActorClass *) klass)->map = (void (*) (ClutterActor*)) gpx_viewer_path_layer_real_map;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	((ClutterActorClass *) klass)->unmap = (void (*) (ClutterActor*)) gpx_viewer_path_layer_real_unmap;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) gpx_viewer_path_layer_real_dispose;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	((ChamplainLayerClass *) klass)->set_view = (void (*) (ChamplainLayer*, ChamplainView*)) gpx_viewer_path_layer_real_set_view;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	((ChamplainLayerClass *) klass)->get_bounding_box = (ChamplainBoundingBox* (*) (ChamplainLayer*)) gpx_viewer_path_layer_real_get_bounding_box;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gpx_viewer_path_layer_get_property;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gpx_viewer_path_layer_set_property;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	G_OBJECT_CLASS (klass)->constructor = gpx_viewer_path_layer_constructor;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	G_OBJECT_CLASS (klass)->finalize = gpx_viewer_path_layer_finalize;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_VIEWER_PATH_LAYER_STROKE_COLOR_PROPERTY, gpx_viewer_path_layer_properties[GPX_VIEWER_PATH_LAYER_STROKE_COLOR_PROPERTY] = g_param_spec_boxed ("stroke-color", "stroke-color", "stroke-color", CLUTTER_TYPE_COLOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_VIEWER_PATH_LAYER_STROKE_WIDTH_PROPERTY, gpx_viewer_path_layer_properties[GPX_VIEWER_PATH_LAYER_STROKE_WIDTH_PROPERTY] = g_param_spec_double ("stroke-width", "stroke-width", "stroke-width", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_VIEWER_PATH_LAYER_VISIBLE_PROPERTY, gpx_viewer_path_layer_properties[GPX_VIEWER_PATH_LAYER_VISIBLE_PROPERTY] = g_param_spec_boolean ("visible", "visible", "visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GPX_VIEWER_PATH_LAYER_TRACK_PROPERTY, gpx_viewer_path_layer_properties[GPX_VIEWER_PATH_LAYER_TRACK_PROPERTY] = g_param_spec_object ("track", "track", "track", GPX_TYPE_TRACK, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
#line 1260 "gpx-viewer-path-layer.c"
}

static void
gpx_viewer_path_layer_instance_init (GpxViewerPathLayer * self,
                                     gpointer klass)
{
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self->priv = gpx_viewer_path_layer_get_instance_private (self);
#line 256 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self->priv->view_relocate_handler_id = (gulong) 0U;
#line 257 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self->priv->view_latitude_handler_id = (gulong) 0U;
#line 1273 "gpx-viewer-path-layer.c"
}

static void
gpx_viewer_path_layer_finalize (GObject * obj)
{
	GpxViewerPathLayer * self;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_VIEWER_TYPE_PATH_LAYER, GpxViewerPathLayer);
#line 104 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	__vala_ClutterColor_free0 (self->priv->_stroke_color);
#line 107 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_g_object_unref0 (self->priv->_track);
#line 109 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_g_object_unref0 (self->priv->view);
#line 110 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_g_object_unref0 (self->priv->content_group);
#line 111 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	_g_object_unref0 (self->priv->path_actor);
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	G_OBJECT_CLASS (gpx_viewer_path_layer_parent_class)->finalize (obj);
#line 1294 "gpx-viewer-path-layer.c"
}

static GType
gpx_viewer_path_layer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GpxViewerPathLayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_viewer_path_layer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxViewerPathLayer), 0, (GInstanceInitFunc) gpx_viewer_path_layer_instance_init, NULL };
	GType gpx_viewer_path_layer_type_id;
	gpx_viewer_path_layer_type_id = g_type_register_static (champlain_layer_get_type (), "GpxViewerPathLayer", &g_define_type_info, 0);
	GpxViewerPathLayer_private_offset = g_type_add_instance_private (gpx_viewer_path_layer_type_id, sizeof (GpxViewerPathLayerPrivate));
	return gpx_viewer_path_layer_type_id;
}

GType
gpx_viewer_path_layer_get_type (void)
{
	static volatile gsize gpx_viewer_path_layer_type_id__once = 0;
	if (g_once_init_enter (&gpx_viewer_path_layer_type_id__once)) {
		GType gpx_viewer_path_layer_type_id;
		gpx_viewer_path_layer_type_id = gpx_viewer_path_layer_get_type_once ();
		g_once_init_leave (&gpx_viewer_path_layer_type_id__once, gpx_viewer_path_layer_type_id);
	}
	return gpx_viewer_path_layer_type_id__once;
}

static void
_vala_gpx_viewer_path_layer_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GpxViewerPathLayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GPX_VIEWER_TYPE_PATH_LAYER, GpxViewerPathLayer);
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	switch (property_id) {
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		case GPX_VIEWER_PATH_LAYER_STROKE_COLOR_PROPERTY:
#line 1331 "gpx-viewer-path-layer.c"
		{
			ClutterColor* boxed;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
			boxed = gpx_viewer_path_layer_get_stroke_color (self);
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
			g_value_set_boxed (value, boxed);
#line 1338 "gpx-viewer-path-layer.c"
		}
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		break;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		case GPX_VIEWER_PATH_LAYER_STROKE_WIDTH_PROPERTY:
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		g_value_set_double (value, gpx_viewer_path_layer_get_stroke_width (self));
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		break;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		case GPX_VIEWER_PATH_LAYER_VISIBLE_PROPERTY:
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		g_value_set_boolean (value, gpx_viewer_path_layer_get_visible (self));
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		break;
#line 1354 "gpx-viewer-path-layer.c"
		default:
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		break;
#line 1360 "gpx-viewer-path-layer.c"
	}
}

static void
_vala_gpx_viewer_path_layer_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	GpxViewerPathLayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GPX_VIEWER_TYPE_PATH_LAYER, GpxViewerPathLayer);
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
	switch (property_id) {
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		case GPX_VIEWER_PATH_LAYER_STROKE_COLOR_PROPERTY:
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		gpx_viewer_path_layer_set_stroke_color (self, g_value_get_boxed (value));
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		break;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		case GPX_VIEWER_PATH_LAYER_STROKE_WIDTH_PROPERTY:
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		gpx_viewer_path_layer_set_stroke_width (self, g_value_get_double (value));
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		break;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		case GPX_VIEWER_PATH_LAYER_VISIBLE_PROPERTY:
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		gpx_viewer_path_layer_set_visible (self, g_value_get_boolean (value));
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		break;
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		case GPX_VIEWER_PATH_LAYER_TRACK_PROPERTY:
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		gpx_viewer_path_layer_set_track (self, g_value_get_object (value));
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		break;
#line 1398 "gpx-viewer-path-layer.c"
		default:
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 56 "../gpx-viewer/libgpx/gpx-viewer-path-layer.vala"
		break;
#line 1404 "gpx-viewer-path-layer.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

