/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_delay = R"doc(delay the input by a certain number of samples

Positive delays insert zero items at the beginning of the stream. Negative delays discard items from the stream.


You cannot initialize this block with a negative delay, however. That leads to a causality issue with the buffers when they are initialized. If you need to negetively delay one path, then put the positive delay on the other path instead.

Constructor Specific Documentation:

Make a delay block.

Args:
    itemsize : size of the data items.
    delay : number of samples to delay stream (>= 0).)doc";


static const char* __doc_gr_blocks_delay_delay_0 = R"doc()doc";


static const char* __doc_gr_blocks_delay_delay_1 = R"doc()doc";


static const char* __doc_gr_blocks_delay_make = R"doc(delay the input by a certain number of samples

Positive delays insert zero items at the beginning of the stream. Negative delays discard items from the stream.


You cannot initialize this block with a negative delay, however. That leads to a causality issue with the buffers when they are initialized. If you need to negetively delay one path, then put the positive delay on the other path instead.

Constructor Specific Documentation:

Make a delay block.

Args:
    itemsize : size of the data items.
    delay : number of samples to delay stream (>= 0).)doc";


static const char* __doc_gr_blocks_delay_dly = R"doc()doc";


static const char* __doc_gr_blocks_delay_set_dly = R"doc(Reset the delay.)doc";
