/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, iio, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */

static const char* __doc_gr_iio_device_source = R"doc(Generic source for IIO drivers with buffered output channels.

This block allows for streaming data from any IIO driver which has output scan elements or buffered channels.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of iio::device.

Args:
    uri : String of the context uri
    device : String of device name
    channels : Vector of strings of channels names
    device_phy : String of phy device name where attribute updates are applied
    params : Vector of strings of attributes to set in form: \"<attribute name>=<value to set>,<attribute name>=<value to set>\"
    buffer_size : Integer number of samples to be put into each IIO buffered passed to hardware.
    decimation : Integer number of sample to remove from received data buffers between successive samples)doc";

static const char* __doc_gr_iio_device_source_make = R"doc(Generic source for IIO drivers with buffered output channels.

This block allows for streaming data from any IIO driver which has output scan elements or buffered channels.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of iio::device.

Args:
    uri : String of the context uri
    device : String of device name
    channels : Vector of strings of channels names
    device_phy : String of phy device name where attribute updates are applied
    params : Vector of strings of attributes to set in form: \"<attribute name>=<value to set>,<attribute name>=<value to set>\"
    buffer_size : Integer number of samples to be put into each IIO buffered passed to hardware.
    decimation : Integer number of sample to remove from received data buffers between successive samples)doc";

static const char* __doc_gr_iio_device_source_set_buffer_size = R"doc(Number of samples to be put into each IIO buffered passed to hardware.)doc";

static const char* __doc_gr_iio_device_source_set_timeout_ms = R"doc()doc";

static const char* __doc_gr_iio_device_source_set_len_tag_key = R"doc(Key of the packet length tag. If empty no tag will be emitted.)doc";
