/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, channels, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_channels_channel_model2 = R"doc(Basic channel simulator allowing time-varying frequency and timing inputs.

This block implements a basic channel model simulator that can be used to help evaluate, design, and test various signals, waveforms, and algorithms.


This model allows the user to set the voltage of an AWGN noise source (), an initial timing offset (), and a seed () to randomize the AWGN noise source.


Multipath can be approximated in this model by using a FIR filter representation of a multipath delay profile with the parameter .


Unlike gr::channels::channel_model, this block is designed to enable time-varying frequency and timing offsets.



Since the models for frequency and timing offset may vary and what we are trying to model may be different for different simulations, we provide the time-varying nature as an input function that is user-defined. If only constant frequency and timing offsets are required, it is easier and less expensive to use gr::channels::channel_model.

Constructor Specific Documentation:

Build the channel simulator.

Args:
    noise_voltage : The AWGN noise level as a voltage (to be calculated externally to meet, say, a desired SNR).
    epsilon : The initial sample timing offset to emulate the different rates between the sample clocks of the transmitter and receiver. 1.0 is no difference.
    taps : Taps of a FIR filter to emulate a multipath delay profile.
    noise_seed : A random number generator seed for the noise source.
    block_tags : If true, tags will not be able to propagate through this block.)doc";


static const char* __doc_gr_channels_channel_model2_channel_model2_0 = R"doc()doc";


static const char* __doc_gr_channels_channel_model2_channel_model2_1 = R"doc()doc";


static const char* __doc_gr_channels_channel_model2_make = R"doc(Basic channel simulator allowing time-varying frequency and timing inputs.

This block implements a basic channel model simulator that can be used to help evaluate, design, and test various signals, waveforms, and algorithms.


This model allows the user to set the voltage of an AWGN noise source (), an initial timing offset (), and a seed () to randomize the AWGN noise source.


Multipath can be approximated in this model by using a FIR filter representation of a multipath delay profile with the parameter .


Unlike gr::channels::channel_model, this block is designed to enable time-varying frequency and timing offsets.



Since the models for frequency and timing offset may vary and what we are trying to model may be different for different simulations, we provide the time-varying nature as an input function that is user-defined. If only constant frequency and timing offsets are required, it is easier and less expensive to use gr::channels::channel_model.

Constructor Specific Documentation:

Build the channel simulator.

Args:
    noise_voltage : The AWGN noise level as a voltage (to be calculated externally to meet, say, a desired SNR).
    epsilon : The initial sample timing offset to emulate the different rates between the sample clocks of the transmitter and receiver. 1.0 is no difference.
    taps : Taps of a FIR filter to emulate a multipath delay profile.
    noise_seed : A random number generator seed for the noise source.
    block_tags : If true, tags will not be able to propagate through this block.)doc";


static const char* __doc_gr_channels_channel_model2_set_noise_voltage = R"doc()doc";


static const char* __doc_gr_channels_channel_model2_set_taps = R"doc()doc";


static const char* __doc_gr_channels_channel_model2_set_timing_offset = R"doc()doc";


static const char* __doc_gr_channels_channel_model2_noise_voltage = R"doc()doc";


static const char* __doc_gr_channels_channel_model2_taps = R"doc()doc";


static const char* __doc_gr_channels_channel_model2_timing_offset = R"doc()doc";
