/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, filter, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_filter_pfb_interpolator_ccf = R"doc(Polyphase filterbank interpolator with gr_complex input, gr_complex output and float taps.

This block takes in a signal stream and performs integer up- sampling (interpolation) with a polyphase filterbank. The first input is the integer specifying how much to interpolate by. The second input is a vector (Python list) of floating-point taps of the prototype filter.


The filter's taps should be based on the interpolation rate specified. That is, the bandwidth specified is relative to the bandwidth after interpolation.


For example, using the GNU Radio's firdes utility to building filters, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, ATT, and the filter window function (a Blackman-harris window in this case). The first input is the gain, which is also specified as the interpolation rate so that the output levels are the same as the input (this creates an overall increase in power).





The PFB interpolator code takes the taps generated above and builds a set of filters. The set contains  filters and each filter contains ceil(taps.size()/interp) taps. Each tap from the filter prototype is sequentially inserted into the next filter. When all of the input taps are used, the remaining filters in the filterbank are filled out with 0's to make sure each filter has the same number of taps.


The theory behind this block can be found in Chapter 7.1 of the following book:

Constructor Specific Documentation:

Build the polyphase filterbank interpolator.

Args:
    interp : (unsigned integer) Specifies the interpolation rate to use
    taps : (vector/list of floats) The prototype filter to populate the filterbank. The taps should be generated at the interpolated sampling rate.)doc";


static const char* __doc_gr_filter_pfb_interpolator_ccf_pfb_interpolator_ccf_0 =
    R"doc()doc";


static const char* __doc_gr_filter_pfb_interpolator_ccf_pfb_interpolator_ccf_1 =
    R"doc()doc";


static const char* __doc_gr_filter_pfb_interpolator_ccf_make = R"doc(Polyphase filterbank interpolator with gr_complex input, gr_complex output and float taps.

This block takes in a signal stream and performs integer up- sampling (interpolation) with a polyphase filterbank. The first input is the integer specifying how much to interpolate by. The second input is a vector (Python list) of floating-point taps of the prototype filter.


The filter's taps should be based on the interpolation rate specified. That is, the bandwidth specified is relative to the bandwidth after interpolation.


For example, using the GNU Radio's firdes utility to building filters, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, ATT, and the filter window function (a Blackman-harris window in this case). The first input is the gain, which is also specified as the interpolation rate so that the output levels are the same as the input (this creates an overall increase in power).





The PFB interpolator code takes the taps generated above and builds a set of filters. The set contains  filters and each filter contains ceil(taps.size()/interp) taps. Each tap from the filter prototype is sequentially inserted into the next filter. When all of the input taps are used, the remaining filters in the filterbank are filled out with 0's to make sure each filter has the same number of taps.


The theory behind this block can be found in Chapter 7.1 of the following book:

Constructor Specific Documentation:

Build the polyphase filterbank interpolator.

Args:
    interp : (unsigned integer) Specifies the interpolation rate to use
    taps : (vector/list of floats) The prototype filter to populate the filterbank. The taps should be generated at the interpolated sampling rate.)doc";


static const char* __doc_gr_filter_pfb_interpolator_ccf_set_taps = R"doc(Resets the filterbank's filter taps with the new prototype filter)doc";


static const char* __doc_gr_filter_pfb_interpolator_ccf_taps = R"doc(Return a vector<vector<>> of the filterbank taps)doc";


static const char* __doc_gr_filter_pfb_interpolator_ccf_print_taps = R"doc(Print all of the filterbank taps to screen.)doc";
