/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbt_convolutional_deinterleaver = R"doc(Convolutional deinterleaver.

ETSI EN 300 744 Clause 4.3.1 
Forney (Ramsey type III) convolutional deinterleaver. 
Data input: Stream of 1 byte elements. 
Data output: Blocks of I bytes size.

Constructor Specific Documentation:

Create a DVB-T convolutional deinterleaver.

Args:
    nsize : number of blocks to process.
    I : size of a block.
    M : depth length for each element in shift registers.)doc";


static const char*
    __doc_gr_dtv_dvbt_convolutional_deinterleaver_dvbt_convolutional_deinterleaver =
        R"doc()doc";


static const char* __doc_gr_dtv_dvbt_convolutional_deinterleaver_make = R"doc(Convolutional deinterleaver.

ETSI EN 300 744 Clause 4.3.1 
Forney (Ramsey type III) convolutional deinterleaver. 
Data input: Stream of 1 byte elements. 
Data output: Blocks of I bytes size.

Constructor Specific Documentation:

Create a DVB-T convolutional deinterleaver.

Args:
    nsize : number of blocks to process.
    I : size of a block.
    M : depth length for each element in shift registers.)doc";
