/*
 * Copyright 2023 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_burst_to_stream = R"doc(Burst to Stream.

Transforms a bursty tagged stream into a continuous stream by inserting zeros in the output between input packets whenever no packets are available at the input.

Constructor Specific Documentation:

Creates a Burst to Stream block.

Args:
    itemsize : Size of the items in bytes.
    len_tag_key : Packet length key of the tagged stream.
    propagate_tags : Controls propagation of tags from input to output.)doc";


static const char* __doc_gr_blocks_burst_to_stream_burst_to_stream = R"doc()doc";


static const char* __doc_gr_blocks_burst_to_stream_make = R"doc(Burst to Stream.

Transforms a bursty tagged stream into a continuous stream by inserting zeros in the output between input packets whenever no packets are available at the input.

Constructor Specific Documentation:

Creates a Burst to Stream block.

Args:
    itemsize : Size of the items in bytes.
    len_tag_key : Packet length key of the tagged stream.
    propagate_tags : Controls propagation of tags from input to output.)doc";
