/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, analog, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_analog_pwr_squelch_ff = R"doc(gate or zero output when input power below threshold

Constructor Specific Documentation:

Make power-based squelch block.

The block will emit a tag with the key pmt::intern(\"squelch_sob\") with the value of pmt::PMT_NIL on the first item it passes, and with the key pmt::intern(\"squelch_eob\") on the last item it passes.

Args:
    db : threshold (in dB) for power squelch
    alpha : Gain of averaging filter. Defaults to 0.0001.
    ramp : attack / release time in samples; a sinusodial ramp is used. set to 0 to disable.
    gate : if true, no output if no squelch tone. if false, output 0's if no squelch tone (default).)doc";


static const char* __doc_gr_analog_pwr_squelch_ff_pwr_squelch_ff_0 = R"doc()doc";


static const char* __doc_gr_analog_pwr_squelch_ff_pwr_squelch_ff_1 = R"doc()doc";


static const char* __doc_gr_analog_pwr_squelch_ff_make = R"doc(gate or zero output when input power below threshold

Constructor Specific Documentation:

Make power-based squelch block.

The block will emit a tag with the key pmt::intern(\"squelch_sob\") with the value of pmt::PMT_NIL on the first item it passes, and with the key pmt::intern(\"squelch_eob\") on the last item it passes.

Args:
    db : threshold (in dB) for power squelch
    alpha : Gain of averaging filter. Defaults to 0.0001.
    ramp : attack / release time in samples; a sinusodial ramp is used. set to 0 to disable.
    gate : if true, no output if no squelch tone. if false, output 0's if no squelch tone (default).)doc";


static const char* __doc_gr_analog_pwr_squelch_ff_squelch_range = R"doc()doc";


static const char* __doc_gr_analog_pwr_squelch_ff_threshold = R"doc()doc";


static const char* __doc_gr_analog_pwr_squelch_ff_set_threshold = R"doc()doc";


static const char* __doc_gr_analog_pwr_squelch_ff_set_alpha = R"doc()doc";


static const char* __doc_gr_analog_pwr_squelch_ff_ramp = R"doc()doc";


static const char* __doc_gr_analog_pwr_squelch_ff_set_ramp = R"doc()doc";


static const char* __doc_gr_analog_pwr_squelch_ff_gate = R"doc()doc";


static const char* __doc_gr_analog_pwr_squelch_ff_set_gate = R"doc()doc";


static const char* __doc_gr_analog_pwr_squelch_ff_unmuted = R"doc()doc";
