/* cpu-monitor.c generated by valac 0.56.18, the Vala compiler
 * generated from cpu-monitor.vala, do not modify */

/* cpu-monitor.vala
 *
 * Copyright (C) 2017 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Petr Štětka <pstetka@redhat.com>
 */

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glibtop/cpu.h>
#include <glibtop.h>
#include <glibtop/proctime.h>
#include <glibtop/procstate.h>
#include <gobject/gvaluecollector.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_MONITOR (usage_monitor_get_type ())
#define USAGE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_MONITOR, UsageMonitor))
#define USAGE_IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_MONITOR))
#define USAGE_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), USAGE_TYPE_MONITOR, UsageMonitorIface))

typedef struct _UsageMonitor UsageMonitor;
typedef struct _UsageMonitorIface UsageMonitorIface;

#define USAGE_TYPE_PROCESS (usage_process_get_type ())
#define USAGE_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_PROCESS, UsageProcess))
#define USAGE_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_PROCESS, UsageProcessClass))
#define USAGE_IS_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_PROCESS))
#define USAGE_IS_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_PROCESS))
#define USAGE_PROCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_PROCESS, UsageProcessClass))

typedef struct _UsageProcess UsageProcess;
typedef struct _UsageProcessClass UsageProcessClass;

#define USAGE_TYPE_CPU_MONITOR (usage_cpu_monitor_get_type ())
#define USAGE_CPU_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_CPU_MONITOR, UsageCpuMonitor))
#define USAGE_CPU_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_CPU_MONITOR, UsageCpuMonitorClass))
#define USAGE_IS_CPU_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_CPU_MONITOR))
#define USAGE_IS_CPU_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_CPU_MONITOR))
#define USAGE_CPU_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_CPU_MONITOR, UsageCpuMonitorClass))

typedef struct _UsageCpuMonitor UsageCpuMonitor;
typedef struct _UsageCpuMonitorClass UsageCpuMonitorClass;
typedef struct _UsageCpuMonitorPrivate UsageCpuMonitorPrivate;
typedef struct _UsageParamSpecCpuMonitor UsageParamSpecCpuMonitor;

struct _UsageMonitorIface {
	GTypeInterface parent_iface;
	void (*update) (UsageMonitor* self);
	void (*update_process) (UsageMonitor* self, UsageProcess** process);
};

struct _UsageCpuMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UsageCpuMonitorPrivate * priv;
};

struct _UsageCpuMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (UsageCpuMonitor *self);
};

struct _UsageCpuMonitorPrivate {
	gdouble cpu_load;
	gdouble* x_cpu_load;
	gint x_cpu_load_length1;
	gint _x_cpu_load_size_;
	guint64 cpu_last_used;
	guint64 cpu_last_total;
	guint64 cpu_last_total_step;
	guint64* x_cpu_last_used;
	gint x_cpu_last_used_length1;
	gint _x_cpu_last_used_size_;
	guint64* x_cpu_last_total;
	gint x_cpu_last_total_length1;
	gint _x_cpu_last_total_size_;
};

struct _UsageParamSpecCpuMonitor {
	GParamSpec parent_instance;
};

static gint UsageCpuMonitor_private_offset;
static gpointer usage_cpu_monitor_parent_class = NULL;
static UsageMonitorIface * usage_cpu_monitor_usage_monitor_parent_iface = NULL;

VALA_EXTERN GType usage_process_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageProcess, g_object_unref)
VALA_EXTERN GType usage_monitor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer usage_cpu_monitor_ref (gpointer instance);
VALA_EXTERN void usage_cpu_monitor_unref (gpointer instance);
VALA_EXTERN GParamSpec* usage_param_spec_cpu_monitor (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void usage_value_set_cpu_monitor (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void usage_value_take_cpu_monitor (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer usage_value_get_cpu_monitor (const GValue* value);
VALA_EXTERN GType usage_cpu_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageCpuMonitor, usage_cpu_monitor_unref)
VALA_EXTERN UsageCpuMonitor* usage_cpu_monitor_new (void);
VALA_EXTERN UsageCpuMonitor* usage_cpu_monitor_construct (GType object_type);
static void usage_cpu_monitor_real_update (UsageMonitor* base);
static guint64* _vala_array_dup3 (guint64* self,
                           gssize length);
static guint64* _vala_array_dup4 (guint64* self,
                           gssize length);
VALA_EXTERN gdouble usage_cpu_monitor_get_cpu_load (UsageCpuMonitor* self);
VALA_EXTERN gdouble* usage_cpu_monitor_get_x_cpu_load (UsageCpuMonitor* self,
                                           gint* result_length1);
static gdouble* _vala_array_dup5 (gdouble* self,
                           gssize length);
static void usage_cpu_monitor_real_update_process (UsageMonitor* base,
                                            UsageProcess** process);
VALA_EXTERN GPid usage_process_get_pid (UsageProcess* self);
VALA_EXTERN void usage_process_set_last_processor (UsageProcess* self,
                                       guint value);
VALA_EXTERN guint64 usage_process_get_cpu_last_used (UsageProcess* self);
VALA_EXTERN void usage_process_set_cpu_load (UsageProcess* self,
                                 gdouble value);
VALA_EXTERN void usage_process_set_cpu_last_used (UsageProcess* self,
                                      guint64 value);
VALA_EXTERN guint usage_process_get_last_processor (UsageProcess* self);
VALA_EXTERN void usage_process_set_x_cpu_last_used (UsageProcess* self,
                                        guint64 value);
VALA_EXTERN void usage_process_set_start_time (UsageProcess* self,
                                   guint64 value);
VALA_EXTERN void usage_monitor_update (UsageMonitor* self);
VALA_EXTERN void usage_monitor_update_process (UsageMonitor* self,
                                   UsageProcess** process);
static void usage_cpu_monitor_finalize (UsageCpuMonitor * obj);
static GType usage_cpu_monitor_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_cpu_monitor_get_instance_private (UsageCpuMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, UsageCpuMonitor_private_offset);
}

UsageCpuMonitor*
usage_cpu_monitor_construct (GType object_type)
{
	UsageCpuMonitor* self = NULL;
	gdouble* _tmp0_;
	guint64* _tmp1_;
	guint64* _tmp2_;
	self = (UsageCpuMonitor*) g_type_create_instance (object_type);
	_tmp0_ = g_new0 (gdouble, g_get_num_processors ());
	self->priv->x_cpu_load = (g_free (self->priv->x_cpu_load), NULL);
	self->priv->x_cpu_load = _tmp0_;
	self->priv->x_cpu_load_length1 = g_get_num_processors ();
	self->priv->_x_cpu_load_size_ = self->priv->x_cpu_load_length1;
	_tmp1_ = g_new0 (guint64, g_get_num_processors ());
	self->priv->x_cpu_last_used = (g_free (self->priv->x_cpu_last_used), NULL);
	self->priv->x_cpu_last_used = _tmp1_;
	self->priv->x_cpu_last_used_length1 = g_get_num_processors ();
	self->priv->_x_cpu_last_used_size_ = self->priv->x_cpu_last_used_length1;
	_tmp2_ = g_new0 (guint64, g_get_num_processors ());
	self->priv->x_cpu_last_total = (g_free (self->priv->x_cpu_last_total), NULL);
	self->priv->x_cpu_last_total = _tmp2_;
	self->priv->x_cpu_last_total_length1 = g_get_num_processors ();
	self->priv->_x_cpu_last_total_size_ = self->priv->x_cpu_last_total_length1;
	return self;
}

UsageCpuMonitor*
usage_cpu_monitor_new (void)
{
	return usage_cpu_monitor_construct (USAGE_TYPE_CPU_MONITOR);
}

static guint64*
_vala_array_dup3 (guint64* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint64));
	}
	return NULL;
}

static guint64*
_vala_array_dup4 (guint64* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint64));
	}
	return NULL;
}

static void
usage_cpu_monitor_real_update (UsageMonitor* base)
{
	UsageCpuMonitor * self;
	glibtop_cpu cpu_data = {0};
	glibtop_cpu _tmp0_ = {0};
	guint64 used = 0ULL;
	glibtop_cpu _tmp1_;
	glibtop_cpu _tmp2_;
	glibtop_cpu _tmp3_;
	glibtop_cpu _tmp4_;
	glibtop_cpu _tmp5_;
	guint64* x_cpu_used = NULL;
	guint64* _tmp6_;
	gint x_cpu_used_length1;
	gint _x_cpu_used_size_;
	glibtop_cpu _tmp26_;
	guint64* _tmp27_;
	gint _tmp27__length1;
	guint64* _tmp28_;
	gint _tmp28__length1;
	glibtop_cpu _tmp29_;
	guint64* _tmp30_;
	gint _tmp30__length1;
	self = (UsageCpuMonitor*) base;
	glibtop_get_cpu (&_tmp0_);
	cpu_data = _tmp0_;
	_tmp1_ = cpu_data;
	_tmp2_ = cpu_data;
	_tmp3_ = cpu_data;
	used = (_tmp1_.user + _tmp2_.nice) + _tmp3_.sys;
	_tmp4_ = cpu_data;
	self->priv->cpu_load = (((gdouble) (used - self->priv->cpu_last_used)) / (_tmp4_.total - self->priv->cpu_last_total)) * 100;
	_tmp5_ = cpu_data;
	self->priv->cpu_last_total_step = _tmp5_.total - self->priv->cpu_last_total;
	_tmp6_ = g_new0 (guint64, g_get_num_processors ());
	x_cpu_used = _tmp6_;
	x_cpu_used_length1 = g_get_num_processors ();
	_x_cpu_used_size_ = x_cpu_used_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gdouble* _tmp9_;
				gint _tmp9__length1;
				guint64* _tmp10_;
				gint _tmp10__length1;
				glibtop_cpu _tmp11_;
				guint64 _tmp12_;
				glibtop_cpu _tmp13_;
				guint64 _tmp14_;
				glibtop_cpu _tmp15_;
				guint64 _tmp16_;
				gdouble* _tmp17_;
				gint _tmp17__length1;
				guint64* _tmp18_;
				gint _tmp18__length1;
				guint64 _tmp19_;
				guint64* _tmp20_;
				gint _tmp20__length1;
				guint64 _tmp21_;
				glibtop_cpu _tmp22_;
				guint64 _tmp23_;
				guint64* _tmp24_;
				gint _tmp24__length1;
				guint64 _tmp25_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = self->priv->x_cpu_load;
				_tmp9__length1 = self->priv->x_cpu_load_length1;
				if (!(i < _tmp9__length1)) {
					break;
				}
				_tmp10_ = x_cpu_used;
				_tmp10__length1 = x_cpu_used_length1;
				_tmp11_ = cpu_data;
				_tmp12_ = _tmp11_.xcpu_user[i];
				_tmp13_ = cpu_data;
				_tmp14_ = _tmp13_.xcpu_nice[i];
				_tmp15_ = cpu_data;
				_tmp16_ = _tmp15_.xcpu_sys[i];
				_tmp10_[i] = (_tmp12_ + _tmp14_) + _tmp16_;
				_tmp17_ = self->priv->x_cpu_load;
				_tmp17__length1 = self->priv->x_cpu_load_length1;
				_tmp18_ = x_cpu_used;
				_tmp18__length1 = x_cpu_used_length1;
				_tmp19_ = _tmp18_[i];
				_tmp20_ = self->priv->x_cpu_last_used;
				_tmp20__length1 = self->priv->x_cpu_last_used_length1;
				_tmp21_ = _tmp20_[i];
				_tmp22_ = cpu_data;
				_tmp23_ = _tmp22_.xcpu_total[i];
				_tmp24_ = self->priv->x_cpu_last_total;
				_tmp24__length1 = self->priv->x_cpu_last_total_length1;
				_tmp25_ = _tmp24_[i];
				_tmp17_[i] = (((gdouble) (_tmp19_ - _tmp21_)) / (_tmp23_ - _tmp25_)) * 100;
			}
		}
	}
	self->priv->cpu_last_used = used;
	_tmp26_ = cpu_data;
	self->priv->cpu_last_total = _tmp26_.total;
	_tmp27_ = x_cpu_used;
	_tmp27__length1 = x_cpu_used_length1;
	_tmp28_ = (_tmp27_ != NULL) ? _vala_array_dup3 (_tmp27_, _tmp27__length1) : _tmp27_;
	_tmp28__length1 = _tmp27__length1;
	self->priv->x_cpu_last_used = (g_free (self->priv->x_cpu_last_used), NULL);
	self->priv->x_cpu_last_used = _tmp28_;
	self->priv->x_cpu_last_used_length1 = _tmp28__length1;
	self->priv->_x_cpu_last_used_size_ = self->priv->x_cpu_last_used_length1;
	_tmp29_ = cpu_data;
	_tmp30_ = _vala_array_dup4 (_tmp29_.xcpu_total, 1024);
	_tmp30__length1 = 1024;
	self->priv->x_cpu_last_total = (g_free (self->priv->x_cpu_last_total), NULL);
	self->priv->x_cpu_last_total = _tmp30_;
	self->priv->x_cpu_last_total_length1 = _tmp30__length1;
	self->priv->_x_cpu_last_total_size_ = self->priv->x_cpu_last_total_length1;
	x_cpu_used = (g_free (x_cpu_used), NULL);
}

gdouble
usage_cpu_monitor_get_cpu_load (UsageCpuMonitor* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->cpu_load;
	return result;
}

static gdouble*
_vala_array_dup5 (gdouble* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gdouble));
	}
	return NULL;
}

gdouble*
usage_cpu_monitor_get_x_cpu_load (UsageCpuMonitor* self,
                                  gint* result_length1)
{
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gdouble* _tmp1_;
	gint _tmp1__length1;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gdouble* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->x_cpu_load;
	_tmp0__length1 = self->priv->x_cpu_load_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
usage_cpu_monitor_real_update_process (UsageMonitor* base,
                                       UsageProcess** process)
{
	UsageCpuMonitor * self;
	glibtop_proc_time proc_time = {0};
	glibtop_proc_state proc_state = {0};
	GPid _tmp0_;
	GPid _tmp1_;
	glibtop_proc_time _tmp2_ = {0};
	GPid _tmp3_;
	GPid _tmp4_;
	glibtop_proc_state _tmp5_ = {0};
	glibtop_proc_state _tmp6_;
	gdouble cpu_load = 0.0;
	glibtop_proc_time _tmp7_;
	guint64 _tmp8_;
	guint64 _tmp9_;
	glibtop_proc_time _tmp10_;
	glibtop_proc_time _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	guint64 _tmp14_;
	glibtop_proc_time _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	guint64 _tmp18_;
	glibtop_proc_time _tmp19_;
	self = (UsageCpuMonitor*) base;
	g_return_if_fail (*process != NULL);
	_tmp0_ = usage_process_get_pid (*process);
	_tmp1_ = _tmp0_;
	glibtop_get_proc_time (&_tmp2_, _tmp1_);
	proc_time = _tmp2_;
	_tmp3_ = usage_process_get_pid (*process);
	_tmp4_ = _tmp3_;
	glibtop_get_proc_state (&_tmp5_, _tmp4_);
	proc_state = _tmp5_;
	_tmp6_ = proc_state;
	usage_process_set_last_processor (*process, (guint) _tmp6_.last_processor);
	_tmp7_ = proc_time;
	_tmp8_ = usage_process_get_cpu_last_used (*process);
	_tmp9_ = _tmp8_;
	cpu_load = ((((gdouble) (_tmp7_.rtime - _tmp9_)) / self->priv->cpu_last_total_step) * 100) * g_get_num_processors ();
	cpu_load = MIN ((gdouble) 100, cpu_load);
	usage_process_set_cpu_load (*process, cpu_load);
	_tmp10_ = proc_time;
	usage_process_set_cpu_last_used (*process, _tmp10_.rtime);
	_tmp11_ = proc_time;
	_tmp12_ = usage_process_get_last_processor (*process);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp11_.xcpu_utime[_tmp13_];
	_tmp15_ = proc_time;
	_tmp16_ = usage_process_get_last_processor (*process);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp15_.xcpu_stime[_tmp17_];
	usage_process_set_x_cpu_last_used (*process, _tmp14_ + _tmp18_);
	_tmp19_ = proc_time;
	usage_process_set_start_time (*process, _tmp19_.start_time);
}

static void
usage_value_cpu_monitor_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
usage_value_cpu_monitor_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		usage_cpu_monitor_unref (value->data[0].v_pointer);
	}
}

static void
usage_value_cpu_monitor_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = usage_cpu_monitor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
usage_value_cpu_monitor_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
usage_value_cpu_monitor_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UsageCpuMonitor * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = usage_cpu_monitor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
usage_value_cpu_monitor_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	UsageCpuMonitor ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = usage_cpu_monitor_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
usage_param_spec_cpu_monitor (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	UsageParamSpecCpuMonitor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, USAGE_TYPE_CPU_MONITOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
usage_value_get_cpu_monitor (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, USAGE_TYPE_CPU_MONITOR), NULL);
	return value->data[0].v_pointer;
}

void
usage_value_set_cpu_monitor (GValue* value,
                             gpointer v_object)
{
	UsageCpuMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, USAGE_TYPE_CPU_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, USAGE_TYPE_CPU_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		usage_cpu_monitor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		usage_cpu_monitor_unref (old);
	}
}

void
usage_value_take_cpu_monitor (GValue* value,
                              gpointer v_object)
{
	UsageCpuMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, USAGE_TYPE_CPU_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, USAGE_TYPE_CPU_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		usage_cpu_monitor_unref (old);
	}
}

static void
usage_cpu_monitor_class_init (UsageCpuMonitorClass * klass,
                              gpointer klass_data)
{
	usage_cpu_monitor_parent_class = g_type_class_peek_parent (klass);
	((UsageCpuMonitorClass *) klass)->finalize = usage_cpu_monitor_finalize;
	g_type_class_adjust_private_offset (klass, &UsageCpuMonitor_private_offset);
}

static void
usage_cpu_monitor_usage_monitor_interface_init (UsageMonitorIface * iface,
                                                gpointer iface_data)
{
	usage_cpu_monitor_usage_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->update = (void (*) (UsageMonitor*)) usage_cpu_monitor_real_update;
	iface->update_process = (void (*) (UsageMonitor*, UsageProcess**)) usage_cpu_monitor_real_update_process;
}

static void
usage_cpu_monitor_instance_init (UsageCpuMonitor * self,
                                 gpointer klass)
{
	self->priv = usage_cpu_monitor_get_instance_private (self);
	self->priv->cpu_last_used = (guint64) 0;
	self->priv->cpu_last_total = (guint64) 0;
	self->priv->cpu_last_total_step = (guint64) 0;
	self->ref_count = 1;
}

static void
usage_cpu_monitor_finalize (UsageCpuMonitor * obj)
{
	UsageCpuMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_CPU_MONITOR, UsageCpuMonitor);
	g_signal_handlers_destroy (self);
	self->priv->x_cpu_load = (g_free (self->priv->x_cpu_load), NULL);
	self->priv->x_cpu_last_used = (g_free (self->priv->x_cpu_last_used), NULL);
	self->priv->x_cpu_last_total = (g_free (self->priv->x_cpu_last_total), NULL);
}

static GType
usage_cpu_monitor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { usage_value_cpu_monitor_init, usage_value_cpu_monitor_free_value, usage_value_cpu_monitor_copy_value, usage_value_cpu_monitor_peek_pointer, "p", usage_value_cpu_monitor_collect_value, "p", usage_value_cpu_monitor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UsageCpuMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_cpu_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageCpuMonitor), 0, (GInstanceInitFunc) usage_cpu_monitor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	static const GInterfaceInfo usage_monitor_info = { (GInterfaceInitFunc) usage_cpu_monitor_usage_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType usage_cpu_monitor_type_id;
	usage_cpu_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UsageCpuMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	g_type_add_interface_static (usage_cpu_monitor_type_id, USAGE_TYPE_MONITOR, &usage_monitor_info);
	UsageCpuMonitor_private_offset = g_type_add_instance_private (usage_cpu_monitor_type_id, sizeof (UsageCpuMonitorPrivate));
	return usage_cpu_monitor_type_id;
}

GType
usage_cpu_monitor_get_type (void)
{
	static volatile gsize usage_cpu_monitor_type_id__once = 0;
	if (g_once_init_enter (&usage_cpu_monitor_type_id__once)) {
		GType usage_cpu_monitor_type_id;
		usage_cpu_monitor_type_id = usage_cpu_monitor_get_type_once ();
		g_once_init_leave (&usage_cpu_monitor_type_id__once, usage_cpu_monitor_type_id);
	}
	return usage_cpu_monitor_type_id__once;
}

gpointer
usage_cpu_monitor_ref (gpointer instance)
{
	UsageCpuMonitor * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
usage_cpu_monitor_unref (gpointer instance)
{
	UsageCpuMonitor * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		USAGE_CPU_MONITOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

