/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "terminal-gdbus-generated.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_options,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_VARIANT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectObjectVariantVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GUnixFDList *arg_fd_list,
        GVariant *arg_options,
        GVariant *arg_arguments,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectObjectVariantVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectObjectVariantVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_object (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              g_marshal_value_peek_variant (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Terminal.Factory0
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:TerminalFactory
 * @title: TerminalFactory
 * @short_description: Generated C code for the org.gnome.Terminal.Factory0 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Terminal-Factory0.top_of_page">org.gnome.Terminal.Factory0</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Terminal.Factory0 ---- */

static const _ExtendedGDBusArgInfo _terminal_factory_method_info_create_instance_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _terminal_factory_method_info_create_instance_IN_ARG_pointers[] =
{
  &_terminal_factory_method_info_create_instance_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _terminal_factory_method_info_create_instance_OUT_ARG_receiver =
{
  {
    -1,
    (gchar *) "receiver",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _terminal_factory_method_info_create_instance_OUT_ARG_pointers[] =
{
  &_terminal_factory_method_info_create_instance_OUT_ARG_receiver.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _terminal_factory_method_info_create_instance =
{
  {
    -1,
    (gchar *) "CreateInstance",
    (GDBusArgInfo **) &_terminal_factory_method_info_create_instance_IN_ARG_pointers,
    (GDBusArgInfo **) &_terminal_factory_method_info_create_instance_OUT_ARG_pointers,
    NULL
  },
  "handle-create-instance",
  FALSE
};

static const GDBusMethodInfo * const _terminal_factory_method_info_pointers[] =
{
  &_terminal_factory_method_info_create_instance.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _terminal_factory_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Terminal.Factory0",
    (GDBusMethodInfo **) &_terminal_factory_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "factory",
};


/**
 * terminal_factory_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Terminal-Factory0.top_of_page">org.gnome.Terminal.Factory0</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
terminal_factory_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_terminal_factory_interface_info.parent_struct;
}

/**
 * terminal_factory_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #TerminalFactory interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
terminal_factory_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
terminal_factory_method_marshal_create_instance (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * TerminalFactory:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Factory0.top_of_page">org.gnome.Terminal.Factory0</link>.
 */

/**
 * TerminalFactoryIface:
 * @parent_iface: The parent interface.
 * @handle_create_instance: Handler for the #TerminalFactory::handle-create-instance signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Factory0.top_of_page">org.gnome.Terminal.Factory0</link>.
 */

typedef TerminalFactoryIface TerminalFactoryInterface;
G_DEFINE_INTERFACE (TerminalFactory, terminal_factory, G_TYPE_OBJECT)

static void
terminal_factory_default_init (TerminalFactoryIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * TerminalFactory::handle-create-instance:
   * @object: A #TerminalFactory.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Terminal-Factory0.CreateInstance">CreateInstance()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call terminal_factory_complete_create_instance() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-instance",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (TerminalFactoryIface, handle_create_instance),
    g_signal_accumulator_true_handled,
    NULL,
      terminal_factory_method_marshal_create_instance,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

}

/**
 * terminal_factory_call_create_instance:
 * @proxy: A #TerminalFactoryProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Terminal-Factory0.CreateInstance">CreateInstance()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call terminal_factory_call_create_instance_finish() to get the result of the operation.
 *
 * See terminal_factory_call_create_instance_sync() for the synchronous, blocking version of this method.
 */
void
terminal_factory_call_create_instance (
    TerminalFactory *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateInstance",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * terminal_factory_call_create_instance_finish:
 * @proxy: A #TerminalFactoryProxy.
 * @out_receiver: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to terminal_factory_call_create_instance().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with terminal_factory_call_create_instance().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
terminal_factory_call_create_instance_finish (
    TerminalFactory *proxy,
    gchar **out_receiver,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_receiver);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * terminal_factory_call_create_instance_sync:
 * @proxy: A #TerminalFactoryProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @out_receiver: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Terminal-Factory0.CreateInstance">CreateInstance()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See terminal_factory_call_create_instance() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
terminal_factory_call_create_instance_sync (
    TerminalFactory *proxy,
    GVariant *arg_options,
    gchar **out_receiver,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateInstance",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_receiver);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * terminal_factory_complete_create_instance:
 * @object: A #TerminalFactory.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @receiver: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Terminal-Factory0.CreateInstance">CreateInstance()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
terminal_factory_complete_create_instance (
    TerminalFactory *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *receiver)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   receiver));
}

/* ------------------------------------------------------------------------ */

/**
 * TerminalFactoryProxy:
 *
 * The #TerminalFactoryProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * TerminalFactoryProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #TerminalFactoryProxy.
 */

struct _TerminalFactoryProxyPrivate
{
  GData *qdata;
};

static void terminal_factory_proxy_iface_init (TerminalFactoryIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (TerminalFactoryProxy, terminal_factory_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (TerminalFactoryProxy)
                         G_IMPLEMENT_INTERFACE (TERMINAL_TYPE_FACTORY, terminal_factory_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (TerminalFactoryProxy, terminal_factory_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TERMINAL_TYPE_FACTORY, terminal_factory_proxy_iface_init))

#endif
static void
terminal_factory_proxy_finalize (GObject *object)
{
  TerminalFactoryProxy *proxy = TERMINAL_FACTORY_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (terminal_factory_proxy_parent_class)->finalize (object);
}

static void
terminal_factory_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
terminal_factory_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
terminal_factory_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_terminal_factory_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TERMINAL_TYPE_FACTORY);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TERMINAL_TYPE_FACTORY);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
terminal_factory_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  TerminalFactoryProxy *proxy = TERMINAL_FACTORY_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_terminal_factory_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_terminal_factory_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
terminal_factory_proxy_init (TerminalFactoryProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = terminal_factory_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TERMINAL_TYPE_FACTORY_PROXY, TerminalFactoryProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), terminal_factory_interface_info ());
}

static void
terminal_factory_proxy_class_init (TerminalFactoryProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = terminal_factory_proxy_finalize;
  gobject_class->get_property = terminal_factory_proxy_get_property;
  gobject_class->set_property = terminal_factory_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = terminal_factory_proxy_g_signal;
  proxy_class->g_properties_changed = terminal_factory_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (TerminalFactoryProxyPrivate));
#endif
}

static void
terminal_factory_proxy_iface_init (TerminalFactoryIface *iface G_GNUC_UNUSED)
{
}

/**
 * terminal_factory_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Factory0.top_of_page">org.gnome.Terminal.Factory0</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call terminal_factory_proxy_new_finish() to get the result of the operation.
 *
 * See terminal_factory_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
terminal_factory_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TERMINAL_TYPE_FACTORY_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Terminal.Factory0", NULL);
}

/**
 * terminal_factory_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to terminal_factory_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with terminal_factory_proxy_new().
 *
 * Returns: (transfer full) (type TerminalFactoryProxy): The constructed proxy object or %NULL if @error is set.
 */
TerminalFactory *
terminal_factory_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return TERMINAL_FACTORY (ret);
  else
    return NULL;
}

/**
 * terminal_factory_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Factory0.top_of_page">org.gnome.Terminal.Factory0</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See terminal_factory_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type TerminalFactoryProxy): The constructed proxy object or %NULL if @error is set.
 */
TerminalFactory *
terminal_factory_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TERMINAL_TYPE_FACTORY_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Terminal.Factory0", NULL);
  if (ret != NULL)
    return TERMINAL_FACTORY (ret);
  else
    return NULL;
}


/**
 * terminal_factory_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like terminal_factory_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call terminal_factory_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See terminal_factory_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
terminal_factory_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TERMINAL_TYPE_FACTORY_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Terminal.Factory0", NULL);
}

/**
 * terminal_factory_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to terminal_factory_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with terminal_factory_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type TerminalFactoryProxy): The constructed proxy object or %NULL if @error is set.
 */
TerminalFactory *
terminal_factory_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return TERMINAL_FACTORY (ret);
  else
    return NULL;
}

/**
 * terminal_factory_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like terminal_factory_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See terminal_factory_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type TerminalFactoryProxy): The constructed proxy object or %NULL if @error is set.
 */
TerminalFactory *
terminal_factory_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TERMINAL_TYPE_FACTORY_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Terminal.Factory0", NULL);
  if (ret != NULL)
    return TERMINAL_FACTORY (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * TerminalFactorySkeleton:
 *
 * The #TerminalFactorySkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * TerminalFactorySkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #TerminalFactorySkeleton.
 */

struct _TerminalFactorySkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_terminal_factory_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  TerminalFactorySkeleton *skeleton = TERMINAL_FACTORY_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TERMINAL_TYPE_FACTORY);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TERMINAL_TYPE_FACTORY);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_terminal_factory_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  TerminalFactorySkeleton *skeleton = TERMINAL_FACTORY_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_terminal_factory_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_terminal_factory_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  TerminalFactorySkeleton *skeleton = TERMINAL_FACTORY_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_terminal_factory_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _terminal_factory_skeleton_vtable =
{
  _terminal_factory_skeleton_handle_method_call,
  _terminal_factory_skeleton_handle_get_property,
  _terminal_factory_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
terminal_factory_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return terminal_factory_interface_info ();
}

static GDBusInterfaceVTable *
terminal_factory_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_terminal_factory_skeleton_vtable;
}

static GVariant *
terminal_factory_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  TerminalFactorySkeleton *skeleton = TERMINAL_FACTORY_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_terminal_factory_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _terminal_factory_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _terminal_factory_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _terminal_factory_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Terminal.Factory0", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
terminal_factory_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void terminal_factory_skeleton_iface_init (TerminalFactoryIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (TerminalFactorySkeleton, terminal_factory_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (TerminalFactorySkeleton)
                         G_IMPLEMENT_INTERFACE (TERMINAL_TYPE_FACTORY, terminal_factory_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (TerminalFactorySkeleton, terminal_factory_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TERMINAL_TYPE_FACTORY, terminal_factory_skeleton_iface_init))

#endif
static void
terminal_factory_skeleton_finalize (GObject *object)
{
  TerminalFactorySkeleton *skeleton = TERMINAL_FACTORY_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (terminal_factory_skeleton_parent_class)->finalize (object);
}

static void
terminal_factory_skeleton_init (TerminalFactorySkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = terminal_factory_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TERMINAL_TYPE_FACTORY_SKELETON, TerminalFactorySkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
terminal_factory_skeleton_class_init (TerminalFactorySkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = terminal_factory_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = terminal_factory_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = terminal_factory_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = terminal_factory_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = terminal_factory_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (TerminalFactorySkeletonPrivate));
#endif
}

static void
terminal_factory_skeleton_iface_init (TerminalFactoryIface *iface G_GNUC_UNUSED)
{
}

/**
 * terminal_factory_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Factory0.top_of_page">org.gnome.Terminal.Factory0</link>.
 *
 * Returns: (transfer full) (type TerminalFactorySkeleton): The skeleton object.
 */
TerminalFactory *
terminal_factory_skeleton_new (void)
{
  return TERMINAL_FACTORY (g_object_new (TERMINAL_TYPE_FACTORY_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Terminal.Terminal0
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:TerminalReceiver
 * @title: TerminalReceiver
 * @short_description: Generated C code for the org.gnome.Terminal.Terminal0 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Terminal-Terminal0.top_of_page">org.gnome.Terminal.Terminal0</link> D-Bus interface in C.
 */

enum
{
  TERMINAL__RECEIVER_CHILD_EXITED,
};

static unsigned TERMINAL__RECEIVER_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.gnome.Terminal.Terminal0 ---- */

static const _ExtendedGDBusArgInfo _terminal_receiver_method_info_exec_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _terminal_receiver_method_info_exec_IN_ARG_arguments =
{
  {
    -1,
    (gchar *) "arguments",
    (gchar *) "aay",
    NULL
  },
  TRUE
};

static const GDBusArgInfo * const _terminal_receiver_method_info_exec_IN_ARG_pointers[] =
{
  &_terminal_receiver_method_info_exec_IN_ARG_options.parent_struct,
  &_terminal_receiver_method_info_exec_IN_ARG_arguments.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _terminal_receiver_method_info_exec =
{
  {
    -1,
    (gchar *) "Exec",
    (GDBusArgInfo **) &_terminal_receiver_method_info_exec_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-exec",
  TRUE
};

static const GDBusMethodInfo * const _terminal_receiver_method_info_pointers[] =
{
  &_terminal_receiver_method_info_exec.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _terminal_receiver_signal_info_child_exited_ARG_exit_code =
{
  {
    -1,
    (gchar *) "exit_code",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _terminal_receiver_signal_info_child_exited_ARG_pointers[] =
{
  &_terminal_receiver_signal_info_child_exited_ARG_exit_code.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _terminal_receiver_signal_info_child_exited =
{
  {
    -1,
    (gchar *) "ChildExited",
    (GDBusArgInfo **) &_terminal_receiver_signal_info_child_exited_ARG_pointers,
    NULL
  },
  "child-exited"
};

static const GDBusSignalInfo * const _terminal_receiver_signal_info_pointers[] =
{
  &_terminal_receiver_signal_info_child_exited.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _terminal_receiver_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Terminal.Terminal0",
    (GDBusMethodInfo **) &_terminal_receiver_method_info_pointers,
    (GDBusSignalInfo **) &_terminal_receiver_signal_info_pointers,
    NULL,
    NULL
  },
  "receiver",
};


/**
 * terminal_receiver_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Terminal-Terminal0.top_of_page">org.gnome.Terminal.Terminal0</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
terminal_receiver_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_terminal_receiver_interface_info.parent_struct;
}

/**
 * terminal_receiver_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #TerminalReceiver interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
terminal_receiver_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
terminal_receiver_signal_marshal_child_exited (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
terminal_receiver_method_marshal_exec (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_VARIANT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * TerminalReceiver:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Terminal0.top_of_page">org.gnome.Terminal.Terminal0</link>.
 */

/**
 * TerminalReceiverIface:
 * @parent_iface: The parent interface.
 * @handle_exec: Handler for the #TerminalReceiver::handle-exec signal.
 * @child_exited: Handler for the #TerminalReceiver::child-exited signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Terminal0.top_of_page">org.gnome.Terminal.Terminal0</link>.
 */

typedef TerminalReceiverIface TerminalReceiverInterface;
G_DEFINE_INTERFACE (TerminalReceiver, terminal_receiver, G_TYPE_OBJECT)

static void
terminal_receiver_default_init (TerminalReceiverIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * TerminalReceiver::handle-exec:
   * @object: A #TerminalReceiver.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_options: Argument passed by remote caller.
   * @arg_arguments: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Terminal-Terminal0.Exec">Exec()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call terminal_receiver_complete_exec() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-exec",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (TerminalReceiverIface, handle_exec),
    g_signal_accumulator_true_handled,
    NULL,
      terminal_receiver_method_marshal_exec,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * TerminalReceiver::child-exited:
   * @object: A #TerminalReceiver.
   * @arg_exit_code: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Terminal-Terminal0.ChildExited">"ChildExited"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  TERMINAL__RECEIVER_SIGNALS[TERMINAL__RECEIVER_CHILD_EXITED] =
    g_signal_new ("child-exited",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (TerminalReceiverIface, child_exited),
      NULL,
      NULL,
      terminal_receiver_signal_marshal_child_exited,
      G_TYPE_NONE,
      1, G_TYPE_INT);

}

/**
 * terminal_receiver_emit_child_exited:
 * @object: A #TerminalReceiver.
 * @arg_exit_code: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Terminal-Terminal0.ChildExited">"ChildExited"</link> D-Bus signal.
 */
void
terminal_receiver_emit_child_exited (
    TerminalReceiver *object,
    gint arg_exit_code)
{
  g_signal_emit (object, TERMINAL__RECEIVER_SIGNALS[TERMINAL__RECEIVER_CHILD_EXITED], 0, arg_exit_code);
}

/**
 * terminal_receiver_call_exec:
 * @proxy: A #TerminalReceiverProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_arguments: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Terminal-Terminal0.Exec">Exec()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call terminal_receiver_call_exec_finish() to get the result of the operation.
 *
 * See terminal_receiver_call_exec_sync() for the synchronous, blocking version of this method.
 */
void
terminal_receiver_call_exec (
    TerminalReceiver *proxy,
    GVariant *arg_options,
    GVariant *arg_arguments,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "Exec",
    g_variant_new ("(@a{sv}@aay)",
                   arg_options,
                   arg_arguments),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * terminal_receiver_call_exec_finish:
 * @proxy: A #TerminalReceiverProxy.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to terminal_receiver_call_exec().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with terminal_receiver_call_exec().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
terminal_receiver_call_exec_finish (
    TerminalReceiver *proxy,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * terminal_receiver_call_exec_sync:
 * @proxy: A #TerminalReceiverProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_arguments: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd_list: (out) (optional) (nullable): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Terminal-Terminal0.Exec">Exec()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See terminal_receiver_call_exec() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
terminal_receiver_call_exec_sync (
    TerminalReceiver *proxy,
    GVariant *arg_options,
    GVariant *arg_arguments,
    GUnixFDList  *fd_list,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "Exec",
    g_variant_new ("(@a{sv}@aay)",
                   arg_options,
                   arg_arguments),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * terminal_receiver_complete_exec:
 * @object: A #TerminalReceiver.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Terminal-Terminal0.Exec">Exec()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
terminal_receiver_complete_exec (
    TerminalReceiver *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("()"),
    fd_list);
}

/* ------------------------------------------------------------------------ */

/**
 * TerminalReceiverProxy:
 *
 * The #TerminalReceiverProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * TerminalReceiverProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #TerminalReceiverProxy.
 */

struct _TerminalReceiverProxyPrivate
{
  GData *qdata;
};

static void terminal_receiver_proxy_iface_init (TerminalReceiverIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (TerminalReceiverProxy, terminal_receiver_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (TerminalReceiverProxy)
                         G_IMPLEMENT_INTERFACE (TERMINAL_TYPE_RECEIVER, terminal_receiver_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (TerminalReceiverProxy, terminal_receiver_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TERMINAL_TYPE_RECEIVER, terminal_receiver_proxy_iface_init))

#endif
static void
terminal_receiver_proxy_finalize (GObject *object)
{
  TerminalReceiverProxy *proxy = TERMINAL_RECEIVER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (terminal_receiver_proxy_parent_class)->finalize (object);
}

static void
terminal_receiver_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
terminal_receiver_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
terminal_receiver_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_terminal_receiver_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TERMINAL_TYPE_RECEIVER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TERMINAL_TYPE_RECEIVER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
terminal_receiver_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  TerminalReceiverProxy *proxy = TERMINAL_RECEIVER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_terminal_receiver_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_terminal_receiver_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
terminal_receiver_proxy_init (TerminalReceiverProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = terminal_receiver_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TERMINAL_TYPE_RECEIVER_PROXY, TerminalReceiverProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), terminal_receiver_interface_info ());
}

static void
terminal_receiver_proxy_class_init (TerminalReceiverProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = terminal_receiver_proxy_finalize;
  gobject_class->get_property = terminal_receiver_proxy_get_property;
  gobject_class->set_property = terminal_receiver_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = terminal_receiver_proxy_g_signal;
  proxy_class->g_properties_changed = terminal_receiver_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (TerminalReceiverProxyPrivate));
#endif
}

static void
terminal_receiver_proxy_iface_init (TerminalReceiverIface *iface G_GNUC_UNUSED)
{
}

/**
 * terminal_receiver_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Terminal0.top_of_page">org.gnome.Terminal.Terminal0</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call terminal_receiver_proxy_new_finish() to get the result of the operation.
 *
 * See terminal_receiver_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
terminal_receiver_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TERMINAL_TYPE_RECEIVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Terminal.Terminal0", NULL);
}

/**
 * terminal_receiver_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to terminal_receiver_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with terminal_receiver_proxy_new().
 *
 * Returns: (transfer full) (type TerminalReceiverProxy): The constructed proxy object or %NULL if @error is set.
 */
TerminalReceiver *
terminal_receiver_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return TERMINAL_RECEIVER (ret);
  else
    return NULL;
}

/**
 * terminal_receiver_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Terminal0.top_of_page">org.gnome.Terminal.Terminal0</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See terminal_receiver_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type TerminalReceiverProxy): The constructed proxy object or %NULL if @error is set.
 */
TerminalReceiver *
terminal_receiver_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TERMINAL_TYPE_RECEIVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Terminal.Terminal0", NULL);
  if (ret != NULL)
    return TERMINAL_RECEIVER (ret);
  else
    return NULL;
}


/**
 * terminal_receiver_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like terminal_receiver_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call terminal_receiver_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See terminal_receiver_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
terminal_receiver_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TERMINAL_TYPE_RECEIVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Terminal.Terminal0", NULL);
}

/**
 * terminal_receiver_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to terminal_receiver_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with terminal_receiver_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type TerminalReceiverProxy): The constructed proxy object or %NULL if @error is set.
 */
TerminalReceiver *
terminal_receiver_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return TERMINAL_RECEIVER (ret);
  else
    return NULL;
}

/**
 * terminal_receiver_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like terminal_receiver_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See terminal_receiver_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type TerminalReceiverProxy): The constructed proxy object or %NULL if @error is set.
 */
TerminalReceiver *
terminal_receiver_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TERMINAL_TYPE_RECEIVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Terminal.Terminal0", NULL);
  if (ret != NULL)
    return TERMINAL_RECEIVER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * TerminalReceiverSkeleton:
 *
 * The #TerminalReceiverSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * TerminalReceiverSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #TerminalReceiverSkeleton.
 */

struct _TerminalReceiverSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_terminal_receiver_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  TerminalReceiverSkeleton *skeleton = TERMINAL_RECEIVER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TERMINAL_TYPE_RECEIVER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TERMINAL_TYPE_RECEIVER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_terminal_receiver_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  TerminalReceiverSkeleton *skeleton = TERMINAL_RECEIVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_terminal_receiver_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_terminal_receiver_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  TerminalReceiverSkeleton *skeleton = TERMINAL_RECEIVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_terminal_receiver_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _terminal_receiver_skeleton_vtable =
{
  _terminal_receiver_skeleton_handle_method_call,
  _terminal_receiver_skeleton_handle_get_property,
  _terminal_receiver_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
terminal_receiver_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return terminal_receiver_interface_info ();
}

static GDBusInterfaceVTable *
terminal_receiver_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_terminal_receiver_skeleton_vtable;
}

static GVariant *
terminal_receiver_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  TerminalReceiverSkeleton *skeleton = TERMINAL_RECEIVER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_terminal_receiver_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _terminal_receiver_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _terminal_receiver_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _terminal_receiver_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Terminal.Terminal0", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
terminal_receiver_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_terminal_receiver_on_signal_child_exited (
    TerminalReceiver *object,
    gint arg_exit_code)
{
  TerminalReceiverSkeleton *skeleton = TERMINAL_RECEIVER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(i)",
                   arg_exit_code));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Terminal.Terminal0", "ChildExited",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void terminal_receiver_skeleton_iface_init (TerminalReceiverIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (TerminalReceiverSkeleton, terminal_receiver_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (TerminalReceiverSkeleton)
                         G_IMPLEMENT_INTERFACE (TERMINAL_TYPE_RECEIVER, terminal_receiver_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (TerminalReceiverSkeleton, terminal_receiver_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TERMINAL_TYPE_RECEIVER, terminal_receiver_skeleton_iface_init))

#endif
static void
terminal_receiver_skeleton_finalize (GObject *object)
{
  TerminalReceiverSkeleton *skeleton = TERMINAL_RECEIVER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (terminal_receiver_skeleton_parent_class)->finalize (object);
}

static void
terminal_receiver_skeleton_init (TerminalReceiverSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = terminal_receiver_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TERMINAL_TYPE_RECEIVER_SKELETON, TerminalReceiverSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
terminal_receiver_skeleton_class_init (TerminalReceiverSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = terminal_receiver_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = terminal_receiver_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = terminal_receiver_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = terminal_receiver_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = terminal_receiver_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (TerminalReceiverSkeletonPrivate));
#endif
}

static void
terminal_receiver_skeleton_iface_init (TerminalReceiverIface *iface)
{
  iface->child_exited = _terminal_receiver_on_signal_child_exited;
}

/**
 * terminal_receiver_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Terminal0.top_of_page">org.gnome.Terminal.Terminal0</link>.
 *
 * Returns: (transfer full) (type TerminalReceiverSkeleton): The skeleton object.
 */
TerminalReceiver *
terminal_receiver_skeleton_new (void)
{
  return TERMINAL_RECEIVER (g_object_new (TERMINAL_TYPE_RECEIVER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for Object, ObjectProxy and ObjectSkeleton
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:TerminalObject
 * @title: TerminalObject
 * @short_description: Specialized GDBusObject types
 *
 * This section contains the #TerminalObject, #TerminalObjectProxy, and #TerminalObjectSkeleton types which make it easier to work with objects implementing generated types for D-Bus interfaces.
 */

/**
 * TerminalObject:
 *
 * The #TerminalObject type is a specialized container of interfaces.
 */

/**
 * TerminalObjectIface:
 * @parent_iface: The parent interface.
 *
 * Virtual table for the #TerminalObject interface.
 */

typedef TerminalObjectIface TerminalObjectInterface;
G_DEFINE_INTERFACE_WITH_CODE (TerminalObject, terminal_object, G_TYPE_OBJECT, g_type_interface_add_prerequisite (g_define_type_id, G_TYPE_DBUS_OBJECT);)

static void
terminal_object_default_init (TerminalObjectIface *iface)
{
  /**
   * TerminalObject:factory:
   *
   * The #TerminalFactory instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Factory0.top_of_page">org.gnome.Terminal.Factory0</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("factory", "factory", "factory", TERMINAL_TYPE_FACTORY, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * TerminalObject:receiver:
   *
   * The #TerminalReceiver instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Terminal0.top_of_page">org.gnome.Terminal.Terminal0</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("receiver", "receiver", "receiver", TERMINAL_TYPE_RECEIVER, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

}

/**
 * terminal_object_get_factory:
 * @object: A #TerminalObject.
 *
 * Gets the #TerminalFactory instance for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Factory0.top_of_page">org.gnome.Terminal.Factory0</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #TerminalFactory that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
TerminalFactory *terminal_object_get_factory (TerminalObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Terminal.Factory0");
  if (ret == NULL)
    return NULL;
  return TERMINAL_FACTORY (ret);
}

/**
 * terminal_object_get_receiver:
 * @object: A #TerminalObject.
 *
 * Gets the #TerminalReceiver instance for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Terminal0.top_of_page">org.gnome.Terminal.Terminal0</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #TerminalReceiver that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
TerminalReceiver *terminal_object_get_receiver (TerminalObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Terminal.Terminal0");
  if (ret == NULL)
    return NULL;
  return TERMINAL_RECEIVER (ret);
}


/**
 * terminal_object_peek_factory: (skip)
 * @object: A #TerminalObject.
 *
 * Like terminal_object_get_factory() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #TerminalFactory or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
TerminalFactory *terminal_object_peek_factory (TerminalObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Terminal.Factory0");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return TERMINAL_FACTORY (ret);
}

/**
 * terminal_object_peek_receiver: (skip)
 * @object: A #TerminalObject.
 *
 * Like terminal_object_get_receiver() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #TerminalReceiver or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
TerminalReceiver *terminal_object_peek_receiver (TerminalObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Terminal.Terminal0");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return TERMINAL_RECEIVER (ret);
}


static void
terminal_object_notify (GDBusObject *object, GDBusInterface *interface)
{
  _ExtendedGDBusInterfaceInfo *info = (_ExtendedGDBusInterfaceInfo *) g_dbus_interface_get_info (interface);
  /* info can be NULL if the other end is using a D-Bus interface we don't know
   * anything about, for example old generated code in this process talking to
   * newer generated code in the other process. */
  if (info != NULL)
    g_object_notify (G_OBJECT (object), info->hyphen_name);
}

/**
 * TerminalObjectProxy:
 *
 * The #TerminalObjectProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * TerminalObjectProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #TerminalObjectProxy.
 */

static void
terminal_object_proxy__terminal_object_iface_init (TerminalObjectIface *iface G_GNUC_UNUSED)
{
}

static void
terminal_object_proxy__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = terminal_object_notify;
  iface->interface_removed = terminal_object_notify;
}


G_DEFINE_TYPE_WITH_CODE (TerminalObjectProxy, terminal_object_proxy, G_TYPE_DBUS_OBJECT_PROXY,
                         G_IMPLEMENT_INTERFACE (TERMINAL_TYPE_OBJECT, terminal_object_proxy__terminal_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, terminal_object_proxy__g_dbus_object_iface_init))

static void
terminal_object_proxy_init (TerminalObjectProxy *object G_GNUC_UNUSED)
{
}

static void
terminal_object_proxy_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec)
{
  G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
}

static void
terminal_object_proxy_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  TerminalObjectProxy *object = TERMINAL_OBJECT_PROXY (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Terminal.Factory0");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Terminal.Terminal0");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
terminal_object_proxy_class_init (TerminalObjectProxyClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = terminal_object_proxy_set_property;
  gobject_class->get_property = terminal_object_proxy_get_property;

  g_object_class_override_property (gobject_class, 1, "factory");
  g_object_class_override_property (gobject_class, 2, "receiver");
}

/**
 * terminal_object_proxy_new:
 * @connection: A #GDBusConnection.
 * @object_path: An object path.
 *
 * Creates a new proxy object.
 *
 * Returns: (transfer full): The proxy object.
 */
TerminalObjectProxy *
terminal_object_proxy_new (GDBusConnection *connection,
  const gchar *object_path)
{
  g_return_val_if_fail (G_IS_DBUS_CONNECTION (connection), NULL);
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return TERMINAL_OBJECT_PROXY (g_object_new (TERMINAL_TYPE_OBJECT_PROXY, "g-connection", connection, "g-object-path", object_path, NULL));
}

/**
 * TerminalObjectSkeleton:
 *
 * The #TerminalObjectSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * TerminalObjectSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #TerminalObjectSkeleton.
 */

static void
terminal_object_skeleton__terminal_object_iface_init (TerminalObjectIface *iface G_GNUC_UNUSED)
{
}


static void
terminal_object_skeleton__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = terminal_object_notify;
  iface->interface_removed = terminal_object_notify;
}

G_DEFINE_TYPE_WITH_CODE (TerminalObjectSkeleton, terminal_object_skeleton, G_TYPE_DBUS_OBJECT_SKELETON,
                         G_IMPLEMENT_INTERFACE (TERMINAL_TYPE_OBJECT, terminal_object_skeleton__terminal_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, terminal_object_skeleton__g_dbus_object_iface_init))

static void
terminal_object_skeleton_init (TerminalObjectSkeleton *object G_GNUC_UNUSED)
{
}

static void
terminal_object_skeleton_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  TerminalObjectSkeleton *object = TERMINAL_OBJECT_SKELETON (gobject);
  GDBusInterfaceSkeleton *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (TERMINAL_IS_FACTORY (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.gnome.Terminal.Factory0");
        }
      break;

    case 2:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (TERMINAL_IS_RECEIVER (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.gnome.Terminal.Terminal0");
        }
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
terminal_object_skeleton_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  TerminalObjectSkeleton *object = TERMINAL_OBJECT_SKELETON (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Terminal.Factory0");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Terminal.Terminal0");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
terminal_object_skeleton_class_init (TerminalObjectSkeletonClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = terminal_object_skeleton_set_property;
  gobject_class->get_property = terminal_object_skeleton_get_property;

  g_object_class_override_property (gobject_class, 1, "factory");
  g_object_class_override_property (gobject_class, 2, "receiver");
}

/**
 * terminal_object_skeleton_new:
 * @object_path: An object path.
 *
 * Creates a new skeleton object.
 *
 * Returns: (transfer full): The skeleton object.
 */
TerminalObjectSkeleton *
terminal_object_skeleton_new (const gchar *object_path)
{
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return TERMINAL_OBJECT_SKELETON (g_object_new (TERMINAL_TYPE_OBJECT_SKELETON, "g-object-path", object_path, NULL));
}

/**
 * terminal_object_skeleton_set_factory:
 * @object: A #TerminalObjectSkeleton.
 * @interface_: (nullable): A #TerminalFactory or %NULL to clear the interface.
 *
 * Sets the #TerminalFactory instance for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Factory0.top_of_page">org.gnome.Terminal.Factory0</link> on @object.
 */
void terminal_object_skeleton_set_factory (TerminalObjectSkeleton *object, TerminalFactory *interface_)
{
  g_object_set (G_OBJECT (object), "factory", interface_, NULL);
}

/**
 * terminal_object_skeleton_set_receiver:
 * @object: A #TerminalObjectSkeleton.
 * @interface_: (nullable): A #TerminalReceiver or %NULL to clear the interface.
 *
 * Sets the #TerminalReceiver instance for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Terminal-Terminal0.top_of_page">org.gnome.Terminal.Terminal0</link> on @object.
 */
void terminal_object_skeleton_set_receiver (TerminalObjectSkeleton *object, TerminalReceiver *interface_)
{
  g_object_set (G_OBJECT (object), "receiver", interface_, NULL);
}


/* ------------------------------------------------------------------------
 * Code for ObjectManager client
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:TerminalObjectManagerClient
 * @title: TerminalObjectManagerClient
 * @short_description: Generated GDBusObjectManagerClient type
 *
 * This section contains a #GDBusObjectManagerClient that uses terminal_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc.
 */

/**
 * TerminalObjectManagerClient:
 *
 * The #TerminalObjectManagerClient structure contains only private data and should only be accessed using the provided API.
 */

/**
 * TerminalObjectManagerClientClass:
 * @parent_class: The parent class.
 *
 * Class structure for #TerminalObjectManagerClient.
 */

G_DEFINE_TYPE (TerminalObjectManagerClient, terminal_object_manager_client, G_TYPE_DBUS_OBJECT_MANAGER_CLIENT)

static void
terminal_object_manager_client_init (TerminalObjectManagerClient *manager G_GNUC_UNUSED)
{
}

static void
terminal_object_manager_client_class_init (TerminalObjectManagerClientClass *klass G_GNUC_UNUSED)
{
}

/**
 * terminal_object_manager_client_get_proxy_type:
 * @manager: A #GDBusObjectManagerClient.
 * @object_path: The object path of the remote object (unused).
 * @interface_name: (nullable): Interface name of the remote object or %NULL to get the object proxy #GType.
 * @user_data: User data (unused).
 *
 * A #GDBusProxyTypeFunc that maps @interface_name to the generated #GDBusObjectProxy derived and #GDBusProxy derived types.
 *
 * Returns: A #GDBusProxy derived #GType if @interface_name is not %NULL, otherwise the #GType for #TerminalObjectProxy.
 */
GType
terminal_object_manager_client_get_proxy_type (GDBusObjectManagerClient *manager G_GNUC_UNUSED, const gchar *object_path G_GNUC_UNUSED, const gchar *interface_name, gpointer user_data G_GNUC_UNUSED)
{
  static gsize once_init_value = 0;
  static GHashTable *lookup_hash;
  GType ret;

  if (interface_name == NULL)
    return TERMINAL_TYPE_OBJECT_PROXY;
  if (g_once_init_enter (&once_init_value))
    {
      lookup_hash = g_hash_table_new (g_str_hash, g_str_equal);
      g_hash_table_insert (lookup_hash, (gpointer) "org.gnome.Terminal.Factory0", (gpointer) (guintptr) (TERMINAL_TYPE_FACTORY_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "org.gnome.Terminal.Terminal0", (gpointer) (guintptr) (TERMINAL_TYPE_RECEIVER_PROXY));
      g_once_init_leave (&once_init_value, 1);
    }
  ret = (GType) (guintptr) (g_hash_table_lookup (lookup_hash, interface_name));
  if (ret == (GType) 0)
    ret = G_TYPE_DBUS_PROXY;
  return ret;
}

/**
 * terminal_object_manager_client_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates #GDBusObjectManagerClient using terminal_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call terminal_object_manager_client_new_finish() to get the result of the operation.
 *
 * See terminal_object_manager_client_new_sync() for the synchronous, blocking version of this constructor.
 */
void
terminal_object_manager_client_new (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (TERMINAL_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", terminal_object_manager_client_get_proxy_type, NULL);
}

/**
 * terminal_object_manager_client_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to terminal_object_manager_client_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with terminal_object_manager_client_new().
 *
 * Returns: (transfer full) (type TerminalObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
terminal_object_manager_client_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * terminal_object_manager_client_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates #GDBusObjectManagerClient using terminal_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See terminal_object_manager_client_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type TerminalObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
terminal_object_manager_client_new_sync (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (TERMINAL_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", terminal_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


/**
 * terminal_object_manager_client_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like terminal_object_manager_client_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call terminal_object_manager_client_new_for_bus_finish() to get the result of the operation.
 *
 * See terminal_object_manager_client_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
terminal_object_manager_client_new_for_bus (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (TERMINAL_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", terminal_object_manager_client_get_proxy_type, NULL);
}

/**
 * terminal_object_manager_client_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to terminal_object_manager_client_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with terminal_object_manager_client_new_for_bus().
 *
 * Returns: (transfer full) (type TerminalObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
terminal_object_manager_client_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * terminal_object_manager_client_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like terminal_object_manager_client_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See terminal_object_manager_client_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type TerminalObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
terminal_object_manager_client_new_for_bus_sync (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (TERMINAL_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", terminal_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


