/* libretro-plugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from libretro-plugin.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "games-libretro-plugin.h"
#include <retro-gtk.h>
#include <gio/gio.h>

#define GAMES_LIBRETRO_PLUGIN_LIBRETRO_FILE_SCHEME "libretro+file"
#define GAMES_LIBRETRO_PLUGIN_PLATFORM_ID "Libretro"
#define GAMES_LIBRETRO_PLUGIN_PLATFORM_NAME _ ("Libretro")
#define GAMES_LIBRETRO_PLUGIN_PLATFORM_UID_PREFIX "libretro"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_LIBRETRO_PLUGIN (games_libretro_plugin_get_type ())
#define GAMES_LIBRETRO_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_LIBRETRO_PLUGIN, GamesLibretroPlugin))
#define GAMES_LIBRETRO_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_LIBRETRO_PLUGIN, GamesLibretroPluginClass))
#define GAMES_IS_LIBRETRO_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_LIBRETRO_PLUGIN))
#define GAMES_IS_LIBRETRO_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_LIBRETRO_PLUGIN))
#define GAMES_LIBRETRO_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_LIBRETRO_PLUGIN, GamesLibretroPluginClass))

typedef struct _GamesLibretroPlugin GamesLibretroPlugin;
typedef struct _GamesLibretroPluginClass GamesLibretroPluginClass;
typedef struct _GamesLibretroPluginPrivate GamesLibretroPluginPrivate;
enum  {
	GAMES_LIBRETRO_PLUGIN_0_PROPERTY,
	GAMES_LIBRETRO_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* games_libretro_plugin_properties[GAMES_LIBRETRO_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_LIBRETRO_ERROR (games_libretro_error_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _games_uri_unref0(var) ((var == NULL) ? NULL : (var = (games_uri_unref (var), NULL)))

struct _GamesLibretroPlugin {
	GObject parent_instance;
	GamesLibretroPluginPrivate * priv;
};

struct _GamesLibretroPluginClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAMES_LIBRETRO_ERROR_NOT_A_LIBRETRO_DESCRIPTOR,
	GAMES_LIBRETRO_ERROR_NOT_A_GAME
} GamesLibretroError;
#define GAMES_LIBRETRO_ERROR games_libretro_error_quark ()

static gpointer games_libretro_plugin_parent_class = NULL;
static GamesPlatform* games_libretro_plugin_platform;
static GamesPlatform* games_libretro_plugin_platform = NULL;
static GamesPluginIface * games_libretro_plugin_games_plugin_parent_iface = NULL;
static GType games_libretro_plugin_type_id = 0;

GType games_libretro_plugin_register_type (GTypeModule * module);
VALA_EXTERN GType games_libretro_plugin_get_type (void) G_GNUC_CONST ;
static GamesPlatform** games_libretro_plugin_real_get_platforms (GamesPlugin* base,
                                                          gint* result_length1);
static GamesUriSource** games_libretro_plugin_real_get_uri_sources (GamesPlugin* base,
                                                             gint* result_length1);
static GamesUriGameFactory** games_libretro_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                                         gint* result_length1);
static GamesGame* games_libretro_plugin_game_for_uri (GamesUri* uri,
                                               GError** error);
static GamesGame* _games_libretro_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                            gpointer self,
                                                                                            GError** error);
static GamesRunnerFactory** games_libretro_plugin_real_get_runner_factories (GamesPlugin* base,
                                                                      gint* result_length1);
static GamesRunner* games_libretro_plugin_create_runner (GamesGame* game,
                                                  GError** error);
static GamesRunner* _games_libretro_plugin_create_runner_games_generic_runner_factory_create_runner (GamesGame* game,
                                                                                              gpointer self,
                                                                                              GError** error);
static RetroCoreDescriptor* games_libretro_plugin_get_core_descriptor (GamesUri* uri,
                                                                GError** error);
VALA_EXTERN GQuark games_libretro_error_quark (void);
VALA_EXTERN GType games_libretro_error_get_type (void) G_GNUC_CONST ;
static gchar* games_libretro_plugin_get_uid (RetroCoreDescriptor* core_descriptor);
VALA_EXTERN GamesLibretroPlugin* games_libretro_plugin_new (void);
VALA_EXTERN GamesLibretroPlugin* games_libretro_plugin_construct (GType object_type);
static void games_libretro_plugin_finalize (GObject * obj);
GType games_libretro_icon_register_type (GTypeModule * module);
GType games_libretro_title_register_type (GTypeModule * module);
GType games_libretro_uri_iterator_register_type (GTypeModule * module);
GType games_libretro_uri_source_register_type (GTypeModule * module);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GamesPlatform**
games_libretro_plugin_real_get_platforms (GamesPlugin* base,
                                          gint* result_length1)
{
	GamesLibretroPlugin * self;
	GamesPlatform* _tmp0_;
	GamesPlatform* _tmp1_;
	GamesPlatform** _tmp2_;
	GamesPlatform** _tmp3_;
	gint _tmp3__length1;
	GamesPlatform** result;
	self = (GamesLibretroPlugin*) base;
	_tmp0_ = games_libretro_plugin_platform;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_tmp2_ = g_new0 (GamesPlatform*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static GamesUriSource**
games_libretro_plugin_real_get_uri_sources (GamesPlugin* base,
                                            gint* result_length1)
{
	GamesLibretroPlugin * self;
	GamesLibretroUriSource* source = NULL;
	GamesLibretroUriSource* _tmp0_;
	GamesUriSource* _tmp1_;
	GamesUriSource** _tmp2_;
	GamesUriSource** _tmp3_;
	gint _tmp3__length1;
	GamesUriSource** result;
	self = (GamesLibretroPlugin*) base;
	_tmp0_ = games_libretro_uri_source_new ();
	source = _tmp0_;
	_tmp1_ = _g_object_ref0 ((GamesUriSource*) source);
	_tmp2_ = g_new0 (GamesUriSource*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	_g_object_unref0 (source);
	return result;
}

static GamesGame*
_games_libretro_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                 gpointer self,
                                                                                 GError** error)
{
	GamesGame* result;
	result = games_libretro_plugin_game_for_uri (uri, error);
	return result;
}

static GamesUriGameFactory**
games_libretro_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                   gint* result_length1)
{
	GamesLibretroPlugin * self;
	GamesGenericGameUriAdapter* game_uri_adapter = NULL;
	GamesGenericGameUriAdapter* _tmp0_;
	GamesGenericUriGameFactory* factory = NULL;
	GamesGenericUriGameFactory* _tmp1_;
	GamesUriGameFactory* _tmp2_;
	GamesUriGameFactory** _tmp3_;
	GamesUriGameFactory** _tmp4_;
	gint _tmp4__length1;
	GamesUriGameFactory** result;
	self = (GamesLibretroPlugin*) base;
	_tmp0_ = games_generic_game_uri_adapter_new (_games_libretro_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri, NULL, NULL);
	game_uri_adapter = _tmp0_;
	_tmp1_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) game_uri_adapter);
	factory = _tmp1_;
	games_generic_uri_game_factory_add_scheme (factory, GAMES_LIBRETRO_PLUGIN_LIBRETRO_FILE_SCHEME);
	_tmp2_ = _g_object_ref0 ((GamesUriGameFactory*) factory);
	_tmp3_ = g_new0 (GamesUriGameFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	_g_object_unref0 (game_uri_adapter);
	return result;
}

static GamesRunner*
_games_libretro_plugin_create_runner_games_generic_runner_factory_create_runner (GamesGame* game,
                                                                                 gpointer self,
                                                                                 GError** error)
{
	GamesRunner* result;
	result = games_libretro_plugin_create_runner (game, error);
	return result;
}

static GamesRunnerFactory**
games_libretro_plugin_real_get_runner_factories (GamesPlugin* base,
                                                 gint* result_length1)
{
	GamesLibretroPlugin * self;
	GamesGenericRunnerFactory* factory = NULL;
	GamesGenericRunnerFactory* _tmp0_;
	GamesPlatform* _tmp1_;
	GamesRunnerFactory* _tmp2_;
	GamesRunnerFactory** _tmp3_;
	GamesRunnerFactory** _tmp4_;
	gint _tmp4__length1;
	GamesRunnerFactory** result;
	self = (GamesLibretroPlugin*) base;
	_tmp0_ = games_generic_runner_factory_new (_games_libretro_plugin_create_runner_games_generic_runner_factory_create_runner, NULL, NULL);
	factory = _tmp0_;
	_tmp1_ = games_libretro_plugin_platform;
	games_generic_runner_factory_add_platform (factory, _tmp1_);
	_tmp2_ = _g_object_ref0 ((GamesRunnerFactory*) factory);
	_tmp3_ = g_new0 (GamesRunnerFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	return result;
}

static RetroCoreDescriptor*
games_libretro_plugin_get_core_descriptor (GamesUri* uri,
                                           GError** error)
{
	GamesUri* file_uri = NULL;
	GamesUri* _tmp0_;
	GFile* file = NULL;
	GamesUri* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* path = NULL;
	GFile* _tmp8_;
	gchar* _tmp9_;
	RetroCoreDescriptor* core_descriptor = NULL;
	const gchar* _tmp10_;
	RetroCoreDescriptor* _tmp11_;
	gboolean _tmp12_ = FALSE;
	RetroCoreDescriptor* _tmp13_;
	GError* _inner_error0_ = NULL;
	RetroCoreDescriptor* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = games_uri_new_from_uri_and_scheme (uri, "file", &_inner_error0_);
	file_uri = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = file_uri;
	_tmp2_ = games_uri_to_file (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	if (!g_file_query_exists (_tmp3_, NULL)) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp4_ = games_uri_to_string (uri);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new (GAMES_LIBRETRO_ERROR, GAMES_LIBRETRO_ERROR_NOT_A_LIBRETRO_DESCRIPTOR, "This isn’t a Libretro core descriptor: %s", _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error0_ = _tmp7_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		_games_uri_unref0 (file_uri);
		return NULL;
	}
	_tmp8_ = file;
	_tmp9_ = g_file_get_path (_tmp8_);
	path = _tmp9_;
	_tmp10_ = path;
	_tmp11_ = retro_core_descriptor_new (_tmp10_, &_inner_error0_);
	core_descriptor = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (path);
		_g_object_unref0 (file);
		_games_uri_unref0 (file_uri);
		return NULL;
	}
	_tmp13_ = core_descriptor;
	_tmp12_ = retro_core_descriptor_get_is_game (_tmp13_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (core_descriptor);
		_g_free0 (path);
		_g_object_unref0 (file);
		_games_uri_unref0 (file_uri);
		return NULL;
	}
	if (!_tmp12_) {
		gchar* _tmp14_;
		gchar* _tmp15_;
		GError* _tmp16_;
		GError* _tmp17_;
		_tmp14_ = games_uri_to_string (uri);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_error_new (GAMES_LIBRETRO_ERROR, GAMES_LIBRETRO_ERROR_NOT_A_GAME, "This Libretro core descriptor isn’t a game: %s", _tmp15_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		_inner_error0_ = _tmp17_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (core_descriptor);
		_g_free0 (path);
		_g_object_unref0 (file);
		_games_uri_unref0 (file_uri);
		return NULL;
	}
	result = core_descriptor;
	_g_free0 (path);
	_g_object_unref0 (file);
	_games_uri_unref0 (file_uri);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
games_libretro_plugin_get_uid (RetroCoreDescriptor* core_descriptor)
{
	gchar* id = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (core_descriptor != NULL, NULL);
	_tmp0_ = retro_core_descriptor_get_id (core_descriptor);
	id = _tmp0_;
	_tmp1_ = string_to_string (GAMES_LIBRETRO_PLUGIN_PLATFORM_UID_PREFIX);
	_tmp2_ = string_to_string (id);
	_tmp3_ = g_strconcat (_tmp1_, "-", _tmp2_, NULL);
	result = _tmp3_;
	_g_free0 (id);
	return result;
}

static GamesGame*
games_libretro_plugin_game_for_uri (GamesUri* uri,
                                    GError** error)
{
	RetroCoreDescriptor* core_descriptor = NULL;
	RetroCoreDescriptor* _tmp0_;
	GamesUid* uid = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GamesUid* _tmp3_;
	GamesUid* _tmp4_;
	GamesLibretroTitle* title = NULL;
	GamesLibretroTitle* _tmp5_;
	GamesLibretroIcon* icon = NULL;
	GamesLibretroIcon* _tmp6_;
	GamesGame* game = NULL;
	GamesUid* _tmp7_;
	GamesLibretroTitle* _tmp8_;
	GamesPlatform* _tmp9_;
	GamesGame* _tmp10_;
	GamesGame* _tmp11_;
	GamesLibretroIcon* _tmp12_;
	GError* _inner_error0_ = NULL;
	GamesGame* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = games_libretro_plugin_get_core_descriptor (uri, &_inner_error0_);
	core_descriptor = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = games_libretro_plugin_get_uid (core_descriptor);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_uid_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	uid = _tmp4_;
	_tmp5_ = games_libretro_title_new (core_descriptor);
	title = _tmp5_;
	_tmp6_ = games_libretro_icon_new (core_descriptor);
	icon = _tmp6_;
	_tmp7_ = uid;
	_tmp8_ = title;
	_tmp9_ = games_libretro_plugin_platform;
	_tmp10_ = games_game_new (_tmp7_, uri, (GamesTitle*) _tmp8_, _tmp9_);
	game = _tmp10_;
	_tmp11_ = game;
	_tmp12_ = icon;
	games_game_set_icon (_tmp11_, (GamesIcon*) _tmp12_);
	result = game;
	_g_object_unref0 (icon);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	_g_object_unref0 (core_descriptor);
	return result;
}

static GamesRunner*
games_libretro_plugin_create_runner (GamesGame* game,
                                     GError** error)
{
	RetroCoreDescriptor* core_descriptor = NULL;
	GamesUri* _tmp0_;
	GamesUri* _tmp1_;
	RetroCoreDescriptor* _tmp2_;
	GamesRetroRunner* runner = NULL;
	GamesRetroRunner* _tmp3_;
	GamesRetroRunner* _tmp4_;
	GamesGenericInputCapabilities* _tmp5_;
	GamesGenericInputCapabilities* _tmp6_;
	GError* _inner_error0_ = NULL;
	GamesRunner* result;
	g_return_val_if_fail (game != NULL, NULL);
	_tmp0_ = games_game_get_uri (game);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_libretro_plugin_get_core_descriptor (_tmp1_, &_inner_error0_);
	core_descriptor = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = games_retro_runner_new_from_descriptor (game, core_descriptor);
	runner = _tmp3_;
	_tmp4_ = runner;
	_tmp5_ = games_generic_input_capabilities_new (TRUE, TRUE);
	_tmp6_ = _tmp5_;
	games_retro_runner_set_input_capabilities (_tmp4_, (GamesInputCapabilities*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	result = (GamesRunner*) runner;
	_g_object_unref0 (core_descriptor);
	return result;
}

GamesLibretroPlugin*
games_libretro_plugin_construct (GType object_type)
{
	GamesLibretroPlugin * self = NULL;
	self = (GamesLibretroPlugin*) g_object_new (object_type, NULL);
	return self;
}

GamesLibretroPlugin*
games_libretro_plugin_new (void)
{
	return games_libretro_plugin_construct (GAMES_TYPE_LIBRETRO_PLUGIN);
}

static void
games_libretro_plugin_class_init (GamesLibretroPluginClass * klass,
                                  gpointer klass_data)
{
	GamesGenericPlatform* _tmp0_;
	games_libretro_plugin_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = games_libretro_plugin_finalize;
	_tmp0_ = games_generic_platform_new (GAMES_LIBRETRO_PLUGIN_PLATFORM_ID, GAMES_LIBRETRO_PLUGIN_PLATFORM_NAME, GAMES_LIBRETRO_PLUGIN_PLATFORM_UID_PREFIX);
	_g_object_unref0 (games_libretro_plugin_platform);
	games_libretro_plugin_platform = (GamesPlatform*) _tmp0_;
}

static void
games_libretro_plugin_games_plugin_interface_init (GamesPluginIface * iface,
                                                   gpointer iface_data)
{
	games_libretro_plugin_games_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_platforms = (GamesPlatform** (*) (GamesPlugin*, gint*)) games_libretro_plugin_real_get_platforms;
	iface->get_uri_sources = (GamesUriSource** (*) (GamesPlugin*, gint*)) games_libretro_plugin_real_get_uri_sources;
	iface->get_uri_game_factories = (GamesUriGameFactory** (*) (GamesPlugin*, gint*)) games_libretro_plugin_real_get_uri_game_factories;
	iface->get_runner_factories = (GamesRunnerFactory** (*) (GamesPlugin*, gint*)) games_libretro_plugin_real_get_runner_factories;
}

static void
games_libretro_plugin_instance_init (GamesLibretroPlugin * self,
                                     gpointer klass)
{
}

static void
games_libretro_plugin_finalize (GObject * obj)
{
	GamesLibretroPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_LIBRETRO_PLUGIN, GamesLibretroPlugin);
	G_OBJECT_CLASS (games_libretro_plugin_parent_class)->finalize (obj);
}

GType
games_libretro_plugin_get_type (void)
{
	return games_libretro_plugin_type_id;
}

GType
games_libretro_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesLibretroPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_libretro_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesLibretroPlugin), 0, (GInstanceInitFunc) games_libretro_plugin_instance_init, NULL };
	static const GInterfaceInfo games_plugin_info = { (GInterfaceInitFunc) games_libretro_plugin_games_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_libretro_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesLibretroPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_libretro_plugin_type_id, GAMES_TYPE_PLUGIN, &games_plugin_info);
	return games_libretro_plugin_type_id;
}

GType
register_games_plugin (GTypeModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	games_libretro_icon_register_type (module);
	games_libretro_plugin_register_type (module);
	games_libretro_title_register_type (module);
	games_libretro_uri_iterator_register_type (module);
	games_libretro_uri_source_register_type (module);
	result = GAMES_TYPE_LIBRETRO_PLUGIN;
	return result;
}

